def 获取邮件内容(服务器对象, 邮件索引):
    """
    获取指定索引的邮件内容。

    参数：
        - 服务器对象 (poplib.POP3)：已经连接的 POP3 服务器对象。
        - 邮件索引 (int)：要获取的邮件的索引，索引从 1 开始。

    返回值：
        - bytes：邮件内容的字节串。如果出现异常或指定索引的邮件不存在，返回 False。

    使用示例：
        邮件服务器 = zfx_pop3.登录('pop.服务器.com', '用户名', '密码')
        邮件内容 = zfx_pop3.获取邮件内容(邮件服务器, 2)
        if 邮件内容:
            print(f"邮件内容: {邮件内容}")
        else:
            print("邮件获取失败或邮件不存在")

    注意：
        - 邮件索引从 1 开始，确保提供的索引值在合法范围内（不能小于 1，且不能大于邮箱中的邮件总数）。
        - 返回的是原始邮件内容的字节串，可以使用 email 模块进行解析和处理。
    """
    try:
        # 获取邮箱中的邮件列表
        _, 邮件列表, _ = 服务器对象.list()

        # 检查邮件索引是否合法
        if 邮件索引 > len(邮件列表) or 邮件索引 <= 0:
            return False  # 如果索引无效，返回 False

        # 获取指定索引的邮件内容
        _, 邮件内容, _ = 服务器对象.retr(邮件索引)

        # 将邮件内容组合为字节串
        邮件内容字节串 = b'\n'.join(邮件内容)
        return 邮件内容字节串
    except Exception:
        return False  # 如果发生异常，返回 False
