# mypy-boto3-swf

[![PyPI - mypy-boto3-swf](https://img.shields.io/pypi/v/mypy-boto3-swf.svg?color=blue)](https://pypi.org/project/mypy-boto3-swf)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-swf.svg?color=blue)](https://pypi.org/project/mypy-boto3-swf)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.SWF 1.13.9](https://boto3.amazonaws.com/v1/documentation/api/1.13.9/reference/services/swf.html#SWF) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-swf](#mypy-boto3-swf)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `SWF` service.

```bash
python -m pip install boto3-stubs[swf]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import swf
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_swf as swf

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("swf")
client: swf.SWFClient = boto3.client("swf")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: swf.SWFClient = session.client("swf")


# Paginators need type annotation on creation
get_workflow_execution_history_paginator: swf.GetWorkflowExecutionHistoryPaginator = client.get_paginator("get_workflow_execution_history")
list_activity_types_paginator: swf.ListActivityTypesPaginator = client.get_paginator("list_activity_types")
list_closed_workflow_executions_paginator: swf.ListClosedWorkflowExecutionsPaginator = client.get_paginator("list_closed_workflow_executions")
list_domains_paginator: swf.ListDomainsPaginator = client.get_paginator("list_domains")
list_open_workflow_executions_paginator: swf.ListOpenWorkflowExecutionsPaginator = client.get_paginator("list_open_workflow_executions")
list_workflow_types_paginator: swf.ListWorkflowTypesPaginator = client.get_paginator("list_workflow_types")
poll_for_decision_task_paginator: swf.PollForDecisionTaskPaginator = client.get_paginator("poll_for_decision_task")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.