import re
from typing import Dict, List, Tuple

# This file is auto-generated from Gitleaks rules. Do not edit manually.
# Source: https://github.com/gitleaks/gitleaks/blob/master/config/gitleaks.toml
# Generation script: targets/vsc-extension/scripts/update-gitleaks-rules.mjs

COMPILED_RULES: List[Tuple[str, re.Pattern, int, List[str]]] = [
    (
        "1password-secret-key",
        re.compile(r'\bA3-[A-Z0-9]{6}-(?:(?:[A-Z0-9]{11})|(?:[A-Z0-9]{6}-[A-Z0-9]{5}))-[A-Z0-9]{5}-[A-Z0-9]{5}-[A-Z0-9]{5}\b', 0),
        1,
        ["a3-"],
    ),
    (
        "1password-service-account-token",
        re.compile(r'ops_eyJ[a-zA-Z0-9+/]{250,}={0,3}', 0),
        1,
        ["ops_"],
    ),
    (
        "adafruit-api-key",
        re.compile(r'[\w.-]{0,50}?(?:adafruit)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9_-]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["adafruit"],
    ),
    (
        "adobe-client-id",
        re.compile(r'[\w.-]{0,50}?(?:adobe)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["adobe"],
    ),
    (
        "adobe-client-secret",
        re.compile(r'\b(p8e-[a-z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["p8e-"],
    ),
    (
        "age-secret-key",
        re.compile(r'AGE-SECRET-KEY-1[QPZRY9X8GF2TVDW0S3JN54KHCE6MUA7L]{58}', 0),
        1,
        ["age-secret-key-1"],
    ),
    (
        "airtable-api-key",
        re.compile(r'[\w.-]{0,50}?(?:airtable)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{17})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["airtable"],
    ),
    (
        "algolia-api-key",
        re.compile(r'[\w.-]{0,50}?(?:algolia)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["algolia"],
    ),
    (
        "alibaba-access-key-id",
        re.compile(r'\b(LTAI[a-z0-9]{20})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["ltai"],
    ),
    (
        "alibaba-secret-key",
        re.compile(r'[\w.-]{0,50}?(?:alibaba)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{30})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["alibaba"],
    ),
    (
        "anthropic-admin-api-key",
        re.compile(r'\b(sk-ant-admin01-[a-zA-Z0-9_\-]{93}AA)(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["sk-ant-admin01"],
    ),
    (
        "anthropic-api-key",
        re.compile(r'\b(sk-ant-api03-[a-zA-Z0-9_\-]{93}AA)(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["sk-ant-api03"],
    ),
    (
        "artifactory-api-key",
        re.compile(r'\bAKCp[A-Za-z0-9]{69}\b', 0),
        1,
        ["akcp"],
    ),
    (
        "artifactory-reference-token",
        re.compile(r'\bcmVmd[A-Za-z0-9]{59}\b', 0),
        1,
        ["cmvmd"],
    ),
    (
        "asana-client-id",
        re.compile(r'[\w.-]{0,50}?(?:asana)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9]{16})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["asana"],
    ),
    (
        "asana-client-secret",
        re.compile(r'[\w.-]{0,50}?(?:asana)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["asana"],
    ),
    (
        "aws-access-token",
        re.compile(r'\b((?:A3T[A-Z0-9]|AKIA|ASIA|ABIA|ACCA)[A-Z2-7]{16})\b', 0),
        1,
        ["a3t", "akia", "asia", "abia", "acca"],
    ),
    (
        "aws-amazon-bedrock-api-key-long-lived",
        re.compile(r'\b(ABSK[A-Za-z0-9+/]{109,269}={0,2})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["absk"],
    ),
    (
        "aws-amazon-bedrock-api-key-short-lived",
        re.compile(r'bedrock-api-key-YmVkcm9jay5hbWF6b25hd3MuY29t', 0),
        1,
        ["bedrock-api-key-"],
    ),
    (
        "azure-ad-client-secret",
        re.compile(r'(?:^|[\\\'"\x60\s>=:(,)])([a-zA-Z0-9_~.]{3}\dQ~[a-zA-Z0-9_~.-]{31,34})(?:$|[\\\'"\x60\s<),])', 0),
        1,
        ["q~"],
    ),
    (
        "beamer-api-token",
        re.compile(r'[\w.-]{0,50}?(?:beamer)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(b_[az09=_\-]{44})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["beamer"],
    ),
    (
        "bitbucket-client-id",
        re.compile(r'[\w.-]{0,50}?(?:bitbucket)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["bitbucket"],
    ),
    (
        "bitbucket-client-secret",
        re.compile(r'[\w.-]{0,50}?(?:bitbucket)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([az09=_\-]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["bitbucket"],
    ),
    (
        "bittrex-access-key",
        re.compile(r'[\w.-]{0,50}?(?:bittrex)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["bittrex"],
    ),
    (
        "bittrex-secret-key",
        re.compile(r'[\w.-]{0,50}?(?:bittrex)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["bittrex"],
    ),
    (
        "clickhouse-cloud-api-secret-key",
        re.compile(r'\b(4b1d[A-Za-z0-9]{38})\b', 0),
        1,
        ["4b1d"],
    ),
    (
        "clojars-api-token",
        re.compile(r'CLOJARS_[a-z0-9]{60}', re.IGNORECASE),
        1,
        ["clojars_"],
    ),
    (
        "cloudflare-api-key",
        re.compile(r'[\w.-]{0,50}?(?:cloudflare)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9_-]{40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["cloudflare"],
    ),
    (
        "cloudflare-global-api-key",
        re.compile(r'[\w.-]{0,50}?(?:cloudflare)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{37})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["cloudflare"],
    ),
    (
        "cloudflare-origin-ca-key",
        re.compile(r'\b(v1\.0-[a-f0-9]{24}-[a-f0-9]{146})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["cloudflare", "v1.0-"],
    ),
    (
        "codecov-access-token",
        re.compile(r'[\w.-]{0,50}?(?:codecov)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["codecov"],
    ),
    (
        "coinbase-access-token",
        re.compile(r'[\w.-]{0,50}?(?:coinbase)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9_-]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["coinbase"],
    ),
    (
        "confluent-access-token",
        re.compile(r'[\w.-]{0,50}?(?:confluent)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{16})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["confluent"],
    ),
    (
        "confluent-secret-key",
        re.compile(r'[\w.-]{0,50}?(?:confluent)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["confluent"],
    ),
    (
        "contentful-delivery-api-token",
        re.compile(r'[\w.-]{0,50}?(?:contentful)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([az09=_\-]{43})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["contentful"],
    ),
    (
        "curl-auth-header",
        re.compile(r'\bcurl\b(?:.*?|.*?(?:[\r\n]{1,2}.*?){1,5})[ \t\n\r](?:-H|--header)(?:=|[ \t]{0,5})(?:"(?:Authorization:[ \t]{0,5}(?:Basic[ \t]([a-z0-9+/]{8,}={0,3})|(?:Bearer|(?:Api-)?Token)[ \t]([\w=~@.+/-]{8,})|([\w=~@.+/-]{8,}))|(?:(?:X-(?:[a-z]+-)?)?(?:Api-?)?(?:Key|Token)):[ \t]{0,5}([\w=~@.+/-]{8,}))"|\'(?:Authorization:[ \t]{0,5}(?:Basic[ \t]([a-z0-9+/]{8,}={0,3})|(?:Bearer|(?:Api-)?Token)[ \t]([\w=~@.+/-]{8,})|([\w=~@.+/-]{8,}))|(?:(?:X-(?:[a-z]+-)?)?(?:Api-?)?(?:Key|Token)):[ \t]{0,5}([\w=~@.+/-]{8,}))\')(?:|\s|$)', re.IGNORECASE),
        1,
        ["curl"],
    ),
    (
        "curl-auth-user",
        re.compile(r'\bcurl\b(?:.*|.*(?:[\r\n]{1,2}.*){1,5})[ \t\n\r](?:-u|--user)(?:=|[ \t]{0,5})("(:[^"]{3,}|[^:"]{3,}:|[^:"]{3,}:[^"]{3,})"|\'([^:\']{3,}:[^\']{3,})\'|((?:"[^"]{3,}"|\'[^\']{3,}\'|[\w$@.-]+):(?:"[^"]{3,}"|\'[^\']{3,}\'|[\w${}@.-]+)))(?:\s|$)', 0),
        1,
        ["curl", "[^:]+:(?:change(?:it|me)|pass(?:word)?|pwd|test|token|\\*+|x+)", "[", "[^:]+:\\[[^]]+]", "[", "\\$\\([^)]+\\):\\$\\([^)]+\\)", "["],
    ),
    (
        "databricks-api-token",
        re.compile(r'\b(dapi[a-f0-9]{32}(?:-\d)?)(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["dapi"],
    ),
    (
        "datadog-access-token",
        re.compile(r'[\w.-]{0,50}?(?:datadog)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["datadog"],
    ),
    (
        "defined-networking-api-token",
        re.compile(r'[\w.-]{0,50}?(?:dnkey)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(dnkey-[az09=_\-]{26}-[az09=_\-]{52})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["dnkey"],
    ),
    (
        "digitalocean-access-token",
        re.compile(r'\b(doo_v1_[a-f0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["doo_v1_"],
    ),
    (
        "digitalocean-pat",
        re.compile(r'\b(dop_v1_[a-f0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["dop_v1_"],
    ),
    (
        "digitalocean-refresh-token",
        re.compile(r'\b(dor_v1_[a-f0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["dor_v1_"],
    ),
    (
        "discord-api-token",
        re.compile(r'[\w.-]{0,50}?(?:discord)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["discord"],
    ),
    (
        "discord-client-id",
        re.compile(r'[\w.-]{0,50}?(?:discord)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9]{18})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["discord"],
    ),
    (
        "discord-client-secret",
        re.compile(r'[\w.-]{0,50}?(?:discord)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([az09=_\-]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["discord"],
    ),
    (
        "doppler-api-token",
        re.compile(r'dp\.pt\.[a-z0-9]{43}', re.IGNORECASE),
        1,
        ["dp.pt."],
    ),
    (
        "droneci-access-token",
        re.compile(r'[\w.-]{0,50}?(?:droneci)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["droneci"],
    ),
    (
        "dropbox-api-token",
        re.compile(r'[\w.-]{0,50}?(?:dropbox)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{15})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["dropbox"],
    ),
    (
        "dropbox-long-lived-api-token",
        re.compile(r'[\w.-]{0,50}?(?:dropbox)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{11}(AAAAAAAAAA)[az09\_=-]{43})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["dropbox"],
    ),
    (
        "dropbox-short-lived-api-token",
        re.compile(r'[\w.-]{0,50}?(?:dropbox)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(sl\.[az09\=_-]{135})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["dropbox"],
    ),
    (
        "duffel-api-token",
        re.compile(r'duffel_(?:test|live)_[az09_\=-]{43}', re.IGNORECASE),
        1,
        ["duffel_"],
    ),
    (
        "dynatrace-api-token",
        re.compile(r'dt0c01\.[a-z0-9]{24}\.[a-z0-9]{64}', re.IGNORECASE),
        1,
        ["dt0c01."],
    ),
    (
        "easypost-api-token",
        re.compile(r'\bEZAK[a-z0-9]{54}\b', re.IGNORECASE),
        1,
        ["ezak"],
    ),
    (
        "easypost-test-api-token",
        re.compile(r'\bEZTK[a-z0-9]{54}\b', re.IGNORECASE),
        1,
        ["eztk"],
    ),
    (
        "facebook-access-token",
        re.compile(r'\b(\d{15,16}(\||%)[0-9a-z\-_]{27,40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["facebook"],
    ),
    (
        "facebook-page-access-token",
        re.compile(r'\b(EAA[MC][a-z0-9]{100,})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["eaam", "eaac"],
    ),
    (
        "facebook-secret",
        re.compile(r'[\w.-]{0,50}?(?:facebook)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["facebook"],
    ),
    (
        "fastly-api-token",
        re.compile(r'[\w.-]{0,50}?(?:fastly)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([az09=_\-]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["fastly"],
    ),
    (
        "finicity-api-token",
        re.compile(r'[\w.-]{0,50}?(?:finicity)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["finicity"],
    ),
    (
        "finicity-client-secret",
        re.compile(r'[\w.-]{0,50}?(?:finicity)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{20})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["finicity"],
    ),
    (
        "finnhub-access-token",
        re.compile(r'[\w.-]{0,50}?(?:finnhub)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{20})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["finnhub"],
    ),
    (
        "flickr-access-token",
        re.compile(r'[\w.-]{0,50}?(?:flickr)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["flickr"],
    ),
    (
        "flutterwave-encryption-key",
        re.compile(r'FLWSECK_TEST-[a-h0-9]{12}', re.IGNORECASE),
        1,
        ["flwseck_test"],
    ),
    (
        "flutterwave-public-key",
        re.compile(r'FLWPUBK_TEST-[a-h0-9]{32}-X', re.IGNORECASE),
        1,
        ["flwpubk_test"],
    ),
    (
        "flutterwave-secret-key",
        re.compile(r'FLWSECK_TEST-[a-h0-9]{32}-X', re.IGNORECASE),
        1,
        ["flwseck_test"],
    ),
    (
        "flyio-access-token",
        re.compile(r'\b((?:fo1_[\w-]{43}|fm1[ar]_[a-zA-Z0-9+\/]{100,}={0,3}|fm2_[a-zA-Z0-9+\/]{100,}={0,3}))(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["fo1_", "fm1", "fm2_"],
    ),
    (
        "frameio-api-token",
        re.compile(r'fio-u-[az09\_=-]{64}', re.IGNORECASE),
        1,
        ["fio-u-"],
    ),
    (
        "freemius-secret-key",
        re.compile(r'["\']secret_key["\']\s*=>\s*["\'](sk_[\S]{29})["\']', re.IGNORECASE),
        1,
        ["secret_key"],
    ),
    (
        "freshbooks-access-token",
        re.compile(r'[\w.-]{0,50}?(?:freshbooks)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["freshbooks"],
    ),
    (
        "gcp-api-key",
        re.compile(r'\b(AIza[\w-]{35})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["aiza", "aizasyabcdefghijklmnopqrstuvwxyz1234567", "aizasyanla7nfelquw1tjfpx_eqcxox-oo6yyis", "aizasyckehvjf3pdurdt6d1ykomitrueke8agem", "aizasydmascliylx7f0npdeji1qmycghiaodrlu", "aizasyd3asb-2pezvqmkml6m9n6nhzrr_znhrh0", "aizaydnsxibfmlxbie6mczdlqaqityefhixbx4a", "aizasyados2zb6ncsk1pcdz4-p6gbdi_uupwx7c", "aizasyaswm6hmtmdywpgmnjrbjxcq9ckctwmld4", "aizasyanuvh9h9bsuccjsu2pcmekopjjaxedqgy", "aizasya5_ivawfq8abutznudcwerljv_a_p4wtm", "aizasya4urcgxgwqftfai3no3t7lt1sjmdnp5sq", "aizasydsb51jiicb6ojpwwmicsekrhhroq1cs7g", "aizasybf2rraim4a0mo64eshqfqfd2afnzavvuu", "aizasybce-ooibhjyr83gm4r2mfcu4mjmprnxsw", "aizasyb8qgxt4ec15vitgn44duc5ucxaoi4fmqe", "aizasya8vmapnrhnfe0bapf4hoz11srvl_n0nvy"],
    ),
    (
        "github-app-token",
        re.compile(r'(?:ghu|ghs)_[0-9a-zA-Z]{36}', 0),
        1,
        ["ghu_", "ghs_"],
    ),
    (
        "github-fine-grained-pat",
        re.compile(r'github_pat_\w{82}', 0),
        1,
        ["github_pat_"],
    ),
    (
        "github-oauth",
        re.compile(r'gho_[0-9a-zA-Z]{36}', 0),
        1,
        ["gho_"],
    ),
    (
        "github-pat",
        re.compile(r'ghp_[0-9a-zA-Z]{36}', 0),
        1,
        ["ghp_", "(?:^|/)@octokit/auth-token/readme\\.md$"],
    ),
    (
        "github-refresh-token",
        re.compile(r'ghr_[0-9a-zA-Z]{36}', 0),
        1,
        ["ghr_"],
    ),
    (
        "gitlab-cicd-job-token",
        re.compile(r'glcbt-[0-9a-zA-Z]{1,5}_[0-9a-zA-Z_-]{20}', 0),
        1,
        ["glcbt-"],
    ),
    (
        "gitlab-deploy-token",
        re.compile(r'gldt-[0-9a-zA-Z_\-]{20}', 0),
        1,
        ["gldt-"],
    ),
    (
        "gitlab-feature-flag-client-token",
        re.compile(r'glffct-[0-9a-zA-Z_\-]{20}', 0),
        1,
        ["glffct-"],
    ),
    (
        "gitlab-feed-token",
        re.compile(r'glft-[0-9a-zA-Z_\-]{20}', 0),
        1,
        ["glft-"],
    ),
    (
        "gitlab-incoming-mail-token",
        re.compile(r'glimt-[0-9a-zA-Z_\-]{25}', 0),
        1,
        ["glimt-"],
    ),
    (
        "gitlab-kubernetes-agent-token",
        re.compile(r'glagent-[0-9a-zA-Z_\-]{50}', 0),
        1,
        ["glagent-"],
    ),
    (
        "gitlab-oauth-app-secret",
        re.compile(r'gloas-[0-9a-zA-Z_\-]{64}', 0),
        1,
        ["gloas-"],
    ),
    (
        "gitlab-pat",
        re.compile(r'glpat-[\w-]{20}', 0),
        1,
        ["glpat-"],
    ),
    (
        "gitlab-pat-routable",
        re.compile(r'\bglpat-[0-9a-zA-Z_-]{27,300}\.[0-9a-z]{2}[0-9a-z]{7}\b', 0),
        1,
        ["glpat-"],
    ),
    (
        "gitlab-ptt",
        re.compile(r'glptt-[0-9a-f]{40}', 0),
        1,
        ["glptt-"],
    ),
    (
        "gitlab-rrt",
        re.compile(r'GR1348941[\w-]{20}', 0),
        1,
        ["gr1348941"],
    ),
    (
        "gitlab-runner-authentication-token",
        re.compile(r'glrt-[0-9a-zA-Z_\-]{20}', 0),
        1,
        ["glrt-"],
    ),
    (
        "gitlab-runner-authentication-token-routable",
        re.compile(r'\bglrt-t\d_[0-9a-zA-Z_\-]{27,300}\.[0-9a-z]{2}[0-9a-z]{7}\b', 0),
        1,
        ["glrt-"],
    ),
    (
        "gitlab-scim-token",
        re.compile(r'glsoat-[0-9a-zA-Z_\-]{20}', 0),
        1,
        ["glsoat-"],
    ),
    (
        "gitlab-session-cookie",
        re.compile(r'_gitlab_session=[0-9a-z]{32}', 0),
        1,
        ["_gitlab_session="],
    ),
    (
        "gitter-access-token",
        re.compile(r'[\w.-]{0,50}?(?:gitter)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9_-]{40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["gitter"],
    ),
    (
        "gocardless-api-token",
        re.compile(r'[\w.-]{0,50}?(?:gocardless)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(live_[az09\_=-]{40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["live_", "gocardless"],
    ),
    (
        "grafana-api-key",
        re.compile(r'\b(eyJrIjoi[A-Za-z0-9]{70,400}={0,3})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["eyjrijoi"],
    ),
    (
        "grafana-cloud-api-token",
        re.compile(r'\b(glc_[A-Za-z0-9+/]{32,400}={0,3})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["glc_"],
    ),
    (
        "grafana-service-account-token",
        re.compile(r'\b(glsa_[A-Za-z0-9]{32}_[A-Fa-f0-9]{8})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["glsa_"],
    ),
    (
        "harness-api-key",
        re.compile(r'(?:pat|sat)\.[a-zA-Z0-9_-]{22}\.[a-zA-Z0-9]{24}\.[a-zA-Z0-9]{20}', 0),
        1,
        ["pat.", "sat."],
    ),
    (
        "hashicorp-tf-password",
        re.compile(r'[\w.-]{0,50}?(?:administrator_login_password|password)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}("[az09=_\-]{8,20}")(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["administrator_login_password", "password"],
    ),
    (
        "heroku-api-key",
        re.compile(r'[\w.-]{0,50}?(?:heroku)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["heroku"],
    ),
    (
        "heroku-api-key-v2",
        re.compile(r'\b((HRKU-AA[0-9a-zA-Z_-]{58}))(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["hrku-aa"],
    ),
    (
        "hubspot-api-key",
        re.compile(r'[\w.-]{0,50}?(?:hubspot)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["hubspot"],
    ),
    (
        "infracost-api-token",
        re.compile(r'\b(ico-[a-zA-Z0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["ico-"],
    ),
    (
        "intercom-api-key",
        re.compile(r'[\w.-]{0,50}?(?:intercom)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([az09=_\-]{60})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["intercom"],
    ),
    (
        "intra42-client-secret",
        re.compile(r'\b(s-s4t2(?:ud|af)-[abcdef0123456789]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["intra", "s-s4t2ud-", "s-s4t2af-"],
    ),
    (
        "jfrog-api-key",
        re.compile(r'[\w.-]{0,50}?(?:jfrog|artifactory|bintray|xray)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{73})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["jfrog", "artifactory", "bintray", "xray"],
    ),
    (
        "jfrog-identity-token",
        re.compile(r'[\w.-]{0,50}?(?:jfrog|artifactory|bintray|xray)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["jfrog", "artifactory", "bintray", "xray"],
    ),
    (
        "jwt",
        re.compile(r'\b(ey[a-zA-Z0-9]{17,}\.ey[a-zA-Z0-9\/\\_-]{17,}\.(?:[a-zA-Z0-9\/\\_-]{10,}={0,2})?)(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["ey"],
    ),
    (
        "jwt-base64",
        re.compile(r'\bZXlK(?:(aGJHY2lPaU)|(aGNIVWlPaU)|(aGNIWWlPaU)|(aGRXUWlPaU)|(aU5qUWlP)|(amNtbDBJanBi)|(amRIa2lPaU)|(bGNHc2lPbn)|(bGJtTWlPaU)|(cWEzVWlPaU)|(cWQyc2lPb)|(cGMzTWlPaU)|(cGRpSTZJ)|(cmFXUWlP)|(clpYbGZiM0J6SWpwY)|(cmRIa2lPaUp)|(dWIyNWpaU0k2)|(d01tTWlP)|(d01uTWlPaU)|(d2NIUWlPaU)|(emRXSWlPaU)|(emRuUWlP)|(MFlXY2lPaU)|(MGVYQWlPaUp)|(MWNtd2l)|(MWMyVWlPaUp)|(MlpYSWlPaU)|(MlpYSnphVzl1SWpv)|(NElqb2)|(NE5XTWlP)|(NE5YUWlPaU)|(NE5YUWpVekkxTmlJNkl)|(NE5YVWlPaU)|(NmFYQWlPaU))[a-zA-Z0-9\/\\_+\-\r\n]{40,}={0,2}', 0),
        1,
        ["zxlk"],
    ),
    (
        "kraken-access-token",
        re.compile(r'[\w.-]{0,50}?(?:kraken)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([az09\/=_\+\-]{80,90})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["kraken"],
    ),
    (
        "kucoin-access-token",
        re.compile(r'[\w.-]{0,50}?(?:kucoin)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{24})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["kucoin"],
    ),
    (
        "kucoin-secret-key",
        re.compile(r'[\w.-]{0,50}?(?:kucoin)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["kucoin"],
    ),
    (
        "launchdarkly-access-token",
        re.compile(r'[\w.-]{0,50}?(?:launchdarkly)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([az09=_\-]{40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["launchdarkly"],
    ),
    (
        "linear-api-key",
        re.compile(r'lin_api_[a-z0-9]{40}', re.IGNORECASE),
        1,
        ["lin_api_"],
    ),
    (
        "linear-client-secret",
        re.compile(r'[\w.-]{0,50}?(?:linear)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["linear"],
    ),
    (
        "linkedin-client-id",
        re.compile(r'[\w.-]{0,50}?(?:linked[_-]?in)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{14})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["linkedin", "linked_in", "linked-in"],
    ),
    (
        "linkedin-client-secret",
        re.compile(r'[\w.-]{0,50}?(?:linked[_-]?in)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{16})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["linkedin", "linked_in", "linked-in"],
    ),
    (
        "lob-api-key",
        re.compile(r'[\w.-]{0,50}?(?:lob)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}((live|test)_[a-f0-9]{35})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["test_", "live_"],
    ),
    (
        "lob-pub-api-key",
        re.compile(r'[\w.-]{0,50}?(?:lob)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}((test|live)_pub_[a-f0-9]{31})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["test_pub", "live_pub", "_pub"],
    ),
    (
        "mailchimp-api-key",
        re.compile(r'[\w.-]{0,50}?(?:MailchimpSDK.initialize|mailchimp)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{32}-us\d\d)(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["mailchimp"],
    ),
    (
        "mailgun-private-api-token",
        re.compile(r'[\w.-]{0,50}?(?:mailgun)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(key-[a-f0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["mailgun"],
    ),
    (
        "mailgun-pub-key",
        re.compile(r'[\w.-]{0,50}?(?:mailgun)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(pubkey-[a-f0-9]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["mailgun"],
    ),
    (
        "mailgun-signing-key",
        re.compile(r'[\w.-]{0,50}?(?:mailgun)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-h0-9]{32}-[a-h0-9]{8}-[a-h0-9]{8})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["mailgun"],
    ),
    (
        "mapbox-api-token",
        re.compile(r'[\w.-]{0,50}?(?:mapbox)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(pk\.[a-z0-9]{60}\.[a-z0-9]{22})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["mapbox"],
    ),
    (
        "mattermost-access-token",
        re.compile(r'[\w.-]{0,50}?(?:mattermost)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{26})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["mattermost"],
    ),
    (
        "maxmind-license-key",
        re.compile(r'\b([A-Za-z0-9]{6}_[A-Za-z0-9]{29}_mmk)(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["_mmk"],
    ),
    (
        "messagebird-api-token",
        re.compile(r'[\w.-]{0,50}?(?:message[_-]?bird)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{25})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["messagebird", "message-bird", "message_bird"],
    ),
    (
        "messagebird-client-id",
        re.compile(r'[\w.-]{0,50}?(?:message[_-]?bird)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["messagebird", "message-bird", "message_bird"],
    ),
    (
        "microsoft-teams-webhook",
        re.compile(r'https://[a-z0-9]+\.webhook\.office\.com/webhookb2/[a-z0-9]{8}-([a-z0-9]{4}-){3}[a-z0-9]{12}@[a-z0-9]{8}-([a-z0-9]{4}-){3}[a-z0-9]{12}/IncomingWebhook/[a-z0-9]{32}/[a-z0-9]{8}-([a-z0-9]{4}-){3}[a-z0-9]{12}', 0),
        1,
        ["webhook.office.com", "webhookb2", "incomingwebhook"],
    ),
    (
        "netlify-access-token",
        re.compile(r'[\w.-]{0,50}?(?:netlify)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([az09=_\-]{40,46})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["netlify"],
    ),
    (
        "new-relic-browser-api-token",
        re.compile(r'[\w.-]{0,50}?(?:new-relic|newrelic|new_relic)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(NRJS-[a-f0-9]{19})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["nrjs-"],
    ),
    (
        "new-relic-insert-key",
        re.compile(r'[\w.-]{0,50}?(?:new-relic|newrelic|new_relic)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(NRII-[a-z0-9-]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["nrii-"],
    ),
    (
        "new-relic-user-api-id",
        re.compile(r'[\w.-]{0,50}?(?:new-relic|newrelic|new_relic)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["new-relic", "newrelic", "new_relic"],
    ),
    (
        "new-relic-user-api-key",
        re.compile(r'[\w.-]{0,50}?(?:new-relic|newrelic|new_relic)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(NRAK-[a-z0-9]{27})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["nrak"],
    ),
    (
        "notion-api-token",
        re.compile(r'\b(ntn_[0-9]{11}[A-Za-z0-9]{32}[A-Za-z0-9]{3})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["ntn_"],
    ),
    (
        "npm-access-token",
        re.compile(r'\b(npm_[a-z0-9]{36})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["npm_"],
    ),
    (
        "nuget-config-password",
        re.compile(r'<add key=\"(?:(?:ClearText)?Password)\"\s*value=\"(.{8,})\"\s*/>', re.IGNORECASE),
        1,
        ["<add key=", "33f!!lloppa", "hal\\+9ooo_da!sy", "^\\%\\s.*\\%$"],
    ),
    (
        "nytimes-access-token",
        re.compile(r'[\w.-]{0,50}?(?:nytimes|new-york-times,|newyorktimes)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([az09=_\-]{32})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["nytimes", "new-york-times", "newyorktimes"],
    ),
    (
        "octopus-deploy-api-key",
        re.compile(r'\b(API-[A-Z0-9]{26})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["api-"],
    ),
    (
        "openai-api-key",
        re.compile(r'\b(sk-(?:proj|svcacct|admin)-(?:[A-Za-z0-9_-]{74}|[A-Za-z0-9_-]{58})T3BlbkFJ(?:[A-Za-z0-9_-]{74}|[A-Za-z0-9_-]{58})\b|sk-[a-zA-Z0-9]{20}T3BlbkFJ[a-zA-Z0-9]{20})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["t3blbkfj"],
    ),
    (
        "openshift-user-token",
        re.compile(r'\b(sha256~[\w-]{43})(?:[^\w-]|$)', 0),
        1,
        ["sha256~"],
    ),
    (
        "perplexity-api-key",
        re.compile(r'\b(pplx-[a-zA-Z0-9]{48})(?:[\x60\'"\s;]|\\[nr]|$|\b)', 0),
        1,
        ["pplx-"],
    ),
    (
        "plaid-api-token",
        re.compile(r'[\w.-]{0,50}?(?:plaid)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(access-(?:sandbox|development|production)-[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["plaid"],
    ),
    (
        "plaid-client-id",
        re.compile(r'[\w.-]{0,50}?(?:plaid)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{24})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["plaid"],
    ),
    (
        "plaid-secret-key",
        re.compile(r'[\w.-]{0,50}?(?:plaid)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{30})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["plaid"],
    ),
    (
        "planetscale-api-token",
        re.compile(r'\b(pscale_tkn_[\w=\.-]{32,64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["pscale_tkn_"],
    ),
    (
        "planetscale-oauth-token",
        re.compile(r'\b(pscale_oauth_[\w=\.-]{32,64})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["pscale_oauth_"],
    ),
    (
        "planetscale-password",
        re.compile(r'\b(pscale_pw_[\w=\.-]{32,64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["pscale_pw_"],
    ),
    (
        "postman-api-token",
        re.compile(r'\b(PMAK-[a-f0-9]{24}\-[a-f0-9]{34})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["pmak-"],
    ),
    (
        "prefect-api-token",
        re.compile(r'\b(pnu_[a-zA-Z0-9]{36})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["pnu_"],
    ),
    (
        "private-key",
        re.compile(r'-----BEGIN[ A-Z0-9_-]{0,100}PRIVATE KEY(?: BLOCK)?-----[\s\S-]{64,}?KEY(?: BLOCK)?-----', re.IGNORECASE),
        1,
        ["-----begin"],
    ),
    (
        "pulumi-api-token",
        re.compile(r'\b(pul-[a-f0-9]{40})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["pul-"],
    ),
    (
        "pypi-upload-token",
        re.compile(r'pypi-AgEIcHlwaS5vcmc[\w-]{50,1000}', 0),
        1,
        ["pypi-ageichlwas5vcmc"],
    ),
    (
        "rapidapi-access-token",
        re.compile(r'[\w.-]{0,50}?(?:rapidapi)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9_-]{50})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["rapidapi"],
    ),
    (
        "readme-api-token",
        re.compile(r'\b(rdme_[a-z0-9]{70})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["rdme_"],
    ),
    (
        "rubygems-api-token",
        re.compile(r'\b(rubygems_[a-f0-9]{48})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["rubygems_"],
    ),
    (
        "scalingo-api-token",
        re.compile(r'\b(tk-us-[\w-]{48})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["tk-us-"],
    ),
    (
        "sendbird-access-id",
        re.compile(r'[\w.-]{0,50}?(?:sendbird)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["sendbird"],
    ),
    (
        "sendbird-access-token",
        re.compile(r'[\w.-]{0,50}?(?:sendbird)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["sendbird"],
    ),
    (
        "sendgrid-api-token",
        re.compile(r'\b(SG\.[az09=_\\.-]{66})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["sg."],
    ),
    (
        "sendinblue-api-token",
        re.compile(r'\b(xkeysib-[a-f0-9]{64}\-[a-z0-9]{16})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["xkeysib-"],
    ),
    (
        "sentry-access-token",
        re.compile(r'[\w.-]{0,50}?(?:sentry)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["sentry"],
    ),
    (
        "sentry-org-token",
        re.compile(r'\bsntrys_eyJpYXQiO[a-zA-Z0-9+/]{10,200}(?:LCJyZWdpb25fdXJs|InJlZ2lvbl91cmwi|cmVnaW9uX3VybCI6)[a-zA-Z0-9+/]{10,200}={0,2}_[a-zA-Z0-9+/]{43}(?:[^a-zA-Z0-9+/]|$)', 0),
        1,
        ["sntrys_eyjpyxqio"],
    ),
    (
        "sentry-user-token",
        re.compile(r'\b(sntryu_[a-f0-9]{64})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["sntryu_"],
    ),
    (
        "settlemint-application-access-token",
        re.compile(r'\b(sm_aat_[a-zA-Z0-9]{16})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["sm_aat"],
    ),
    (
        "settlemint-personal-access-token",
        re.compile(r'\b(sm_pat_[a-zA-Z0-9]{16})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["sm_pat"],
    ),
    (
        "settlemint-service-access-token",
        re.compile(r'\b(sm_sat_[a-zA-Z0-9]{16})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["sm_sat"],
    ),
    (
        "shippo-api-token",
        re.compile(r'\b(shippo_(?:live|test)_[a-fA-F0-9]{40})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["shippo_"],
    ),
    (
        "shopify-access-token",
        re.compile(r'shpat_[a-fA-F0-9]{32}', 0),
        1,
        ["shpat_"],
    ),
    (
        "shopify-custom-access-token",
        re.compile(r'shpca_[a-fA-F0-9]{32}', 0),
        1,
        ["shpca_"],
    ),
    (
        "shopify-private-app-access-token",
        re.compile(r'shppa_[a-fA-F0-9]{32}', 0),
        1,
        ["shppa_"],
    ),
    (
        "shopify-shared-secret",
        re.compile(r'shpss_[a-fA-F0-9]{32}', 0),
        1,
        ["shpss_"],
    ),
    (
        "sidekiq-secret",
        re.compile(r'[\w.-]{0,50}?(?:BUNDLE_ENTERPRISE__CONTRIBSYS__COM|BUNDLE_GEMS__CONTRIBSYS__COM)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-f0-9]{8}:[a-f0-9]{8})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["bundle_enterprise__contribsys__com", "bundle_gems__contribsys__com"],
    ),
    (
        "sidekiq-sensitive-url",
        re.compile(r'\bhttps?://([a-f0-9]{8}:[a-f0-9]{8})@(?:gems.contribsys.com|enterprise.contribsys.com)(?:[\/|\#|\?|:]|$)', re.IGNORECASE),
        1,
        ["gems.contribsys.com", "enterprise.contribsys.com"],
    ),
    (
        "slack-app-token",
        re.compile(r'xapp-\d-[A-Z0-9]+-\d+-[a-z0-9]+', re.IGNORECASE),
        1,
        ["xapp"],
    ),
    (
        "slack-bot-token",
        re.compile(r'xoxb-[0-9]{10,13}-[0-9]{10,13}[a-zA-Z0-9-]*', 0),
        1,
        ["xoxb"],
    ),
    (
        "slack-config-access-token",
        re.compile(r'xoxe.xox[bp]-\d-[A-Z0-9]{163,166}', re.IGNORECASE),
        1,
        ["xoxe.xoxb-", "xoxe.xoxp-"],
    ),
    (
        "slack-config-refresh-token",
        re.compile(r'xoxe-\d-[A-Z0-9]{146}', re.IGNORECASE),
        1,
        ["xoxe-"],
    ),
    (
        "slack-legacy-bot-token",
        re.compile(r'xoxb-[0-9]{8,14}-[a-zA-Z0-9]{18,26}', 0),
        1,
        ["xoxb"],
    ),
    (
        "slack-legacy-token",
        re.compile(r'xox[os]-\d+-\d+-\d+-[a-fA-F\d]+', 0),
        1,
        ["xoxo", "xoxs"],
    ),
    (
        "slack-legacy-workspace-token",
        re.compile(r'xox[ar]-(?:\d-)?[0-9a-zA-Z]{8,48}', 0),
        1,
        ["xoxa", "xoxr"],
    ),
    (
        "slack-user-token",
        re.compile(r'xox[pe](?:-[0-9]{10,13}){3}-[a-zA-Z0-9-]{28,34}', 0),
        1,
        ["xoxp-", "xoxe-"],
    ),
    (
        "slack-webhook-url",
        re.compile(r'(?:https?://)?hooks.slack.com/(?:services|workflows|triggers)/[A-Za-z0-9+/]{43,56}', 0),
        1,
        ["hooks.slack.com"],
    ),
    (
        "snyk-api-token",
        re.compile(r'[\w.-]{0,50}?(?:snyk[_.-]?(?:(?:api|oauth)[_.-]?)?(?:key|token))(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["snyk"],
    ),
    (
        "sonar-api-token",
        re.compile(r'[\w.-]{0,50}?(?:sonar[_.-]?(login|token))(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}((?:squ_|sqp_|sqa_)?[az09=_\-]{40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        2,
        ["sonar"],
    ),
    (
        "sourcegraph-access-token",
        re.compile(r'\b(\b(sgp_(?:[a-fA-F0-9]{16}|local)_[a-fA-F0-9]{40}|sgp_[a-fA-F0-9]{40}|[a-fA-F0-9]{40})\b)(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["sgp_", "sourcegraph"],
    ),
    (
        "square-access-token",
        re.compile(r'\b((?:EAAA|sq0atp-)[\w-]{22,60})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["sq0atp-", "eaaa"],
    ),
    (
        "squarespace-access-token",
        re.compile(r'[\w.-]{0,50}?(?:squarespace)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["squarespace"],
    ),
    (
        "stripe-access-token",
        re.compile(r'\b((?:sk|rk)_(?:test|live|prod)_[a-zA-Z0-9]{10,99})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["sk_test", "sk_live", "sk_prod", "rk_test", "rk_live", "rk_prod"],
    ),
    (
        "travisci-access-token",
        re.compile(r'[\w.-]{0,50}?(?:travis)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{22})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["travis"],
    ),
    (
        "twilio-api-key",
        re.compile(r'SK[0-9a-fA-F]{32}', 0),
        1,
        ["sk"],
    ),
    (
        "twitch-api-token",
        re.compile(r'[\w.-]{0,50}?(?:twitch)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{30})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["twitch"],
    ),
    (
        "twitter-access-secret",
        re.compile(r'[\w.-]{0,50}?(?:twitter)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{45})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["twitter"],
    ),
    (
        "twitter-access-token",
        re.compile(r'[\w.-]{0,50}?(?:twitter)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([0-9]{15,25}-[a-zA-Z0-9]{20,40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["twitter"],
    ),
    (
        "twitter-api-key",
        re.compile(r'[\w.-]{0,50}?(?:twitter)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{25})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["twitter"],
    ),
    (
        "twitter-api-secret",
        re.compile(r'[\w.-]{0,50}?(?:twitter)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{50})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["twitter"],
    ),
    (
        "twitter-bearer-token",
        re.compile(r'[\w.-]{0,50}?(?:twitter)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(A{22}[a-zA-Z0-9%]{80,100})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["twitter"],
    ),
    (
        "typeform-api-token",
        re.compile(r'[\w.-]{0,50}?(?:typeform)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(tfp_[az09\_\.=-]{59})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["tfp_"],
    ),
    (
        "vault-batch-token",
        re.compile(r'\b(hvb\.[\w-]{138,300})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["hvb."],
    ),
    (
        "yandex-access-token",
        re.compile(r'[\w.-]{0,50}?(?:yandex)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(t1\.[A-Z0-9a-z_-]+[=]{0,2}\.[A-Z0-9a-z_-]{86}[=]{0,2})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["yandex"],
    ),
    (
        "yandex-api-key",
        re.compile(r'[\w.-]{0,50}?(?:yandex)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(AQVN[A-Za-z0-9_\-]{35,38})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["yandex"],
    ),
    (
        "yandex-aws-access-token",
        re.compile(r'[\w.-]{0,50}?(?:yandex)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}(YC[a-zA-Z0-9_\-]{38})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["yandex"],
    ),
    (
        "zendesk-secret-key",
        re.compile(r'[\w.-]{0,50}?(?:zendesk)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5}([a-z0-9]{40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["zendesk"],
    ),
    (
        "aws-secret-access-key",
        re.compile(r'(?:[\w.-]{0,50}?(?:aws|secret)(?:[ \t\w.-]{0,20})[\s\'"]{0,3}(?:=|>|:{1,3}=|\|\||:|=>|\?=|,)[\x60\'"\s=]{0,5})?([A-Za-z0-9+/]{40})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["aws", "secret"],
    ),
    (
        "database-password",
        re.compile(r'://[^:/@]+:([^:/@]{6,})@', 0),
        1,
        ["://"],
    ),
    (
        "gcp-api-key-ii",
        re.compile(r'\b(AIza[\w-]{33,35})(?:[\x60\'"\s;]|\\[nr]|$)', 0),
        1,
        ["aiza"],
    ),
    (
        "sendgrid-api-token-ii",
        re.compile(r'\b(SG\.[a-z0-9=_.\-]{66})(?:[\x60\'"\s;]|\\[nr]|$)', re.IGNORECASE),
        1,
        ["sg."],
    ),
]

KEYWORD_INDEX: Dict[str, List[int]] = {}
for idx, (_, _, _, keywords) in enumerate(COMPILED_RULES):
    for kw in keywords:
        KEYWORD_INDEX.setdefault(kw, []).append(idx)

ALWAYS_RUN_IDS = {"jwt", "generic-api-key", "aws-access-token", "aws-secret-access-key", "simple-secret"}

def candidate_rule_indices(text_lower: str) -> List[int]:
    hits: List[int] = []
    seen = set()
    for kw, indices in KEYWORD_INDEX.items():
        if kw and kw in text_lower:
            for i in indices:
                if i not in seen:
                    hits.append(i)
                    seen.add(i)
    for i, (rid, _, _, _) in enumerate(COMPILED_RULES):
        if rid in ALWAYS_RUN_IDS and i not in seen:
            hits.append(i)
            seen.add(i)
    return hits

