from typing import Literal


type TipoAtendimentoAvulsoSistemasType = Literal[
    "Suporte Sistema",
    "Manutenção de Banco",
    "Atividade Interna",
]

type TipoAtendimentoAvulsoInfraestruturaType = Literal[
    "Atividade Interna",
    "Implementação",
    "Incidente",
    "Manutenção Corretiva",
    "Manutenção de Banco",
    "Manutenção Preventiva",
    "Monitoramento",
    "Requisição",
    "Suporte",
    "Treinamento",
]

type TipoOsSistemasType = Literal[
    "Implementação",
    "Manutenção Corretiva",
    "Monitoramento",
    "Mudança de Escopo",
    "Suporte Infraestrutura",
    "Suporte Sistema",
    "Treinamento",
]


type OrigemAtendimentoAvulsoSistemasType = Literal[
    "E-mail",
    "Pessoalmente",
    "Teams",
    "Telefone",
    "WhatsApp",
    "Plantão",
    "SAE",
]


type OrigemOsSistemasType = Literal[
    "E-mail",
    "Pessoalmente",
    "Teams",
    "Telefone",
    "WhatsApp",
    "Plantão",
    "SAE",
    "SATIC",
    "Siga",
]

type SistemasType = Literal[
    "Abaris",
    "Administrar Permissões e Acesso - Segurança",
    "Analytics / BI",
    "Analytics / BI (Administrativos/Hospitalares)",
    "APP Pega Plantão",
    "Assinatura Digital / Bird ID",
    "Controle de Contratos",
    "Custo/Orçamento Institucional",
    "GEM - Aplicativo de Apoio",
    "Intranet",
    "MV - Almoxarifado",
    "MV - Ambulatório",
    "MV - Apoio à TI",
    "MV - Auditoria e Glosa",
    "MV - Caixa",
    "MV - CCIH",
    "MV - Central de Marcação",
    "MV - Centro Cirúrgico e Obstétrico",
    "MV - CME",
    "MV - Conciliação de Convênios",
    "MV - Contabilidade",
    "MV - Contas a Pagar",
    "MV - Contas a Receber",
    "MV - Controle Bancário",
    "MV - Custos",
    "MV - Diagnóstico por Imagem",
    "MV - Diretoria Clínica",
    "MV - Faturamento de Convênios e Particulares",
    "MV - Faturamento SUS",
    "MV - Gerenciamento de Projetos",
    "MV - Gestão de Documentos",
    "MV - Gestão de Ocorrências",
    "MV - Gestão de Riscos",
    "MV - Higienização",
    "MV - HMed",
    "MV - Internação",
    "MV - Laboratório de Análises Clínicas",
    "MV - Lavanderia e Rouparia",
    "MV - Manutenção",
    "MV - MovDoc",
    "MV - Nutrição",
    "MV - Patrimônio",
    "MV - PEP",
    "MV - Repasse Médico",
    "MV - SAC",
    "MV - SAME",
    "MV - Sistema de Apoio",
    "MV - Tesouraria",
    "MV - Urgência",
    "Prefeitura Universitária",
    "PROT - Protocolo",
    "RCI - Avaliador (Cópias e Impressões)",
    "RH - Controle de Convênios",
    "RH - Plano de Cargos e Salários",
    "RH - Sistema de Apoio ao Recursos Humanos",
    "RMS - Almoxarifado",
    "RMS - Aprovador",
    "RMS - Avaliador",
    "RMS - Compras",
    "RMS - Gestão de Logística",
    "RMS - Gestão de Serviços",
    "RMS - Gestão de Transporte",
    "RMS - Marketing & Comunicacao",
    "RMS - Patrimônio",
    "RMS - Requisitante",
    "RPA - Recibo de Pagamento Autônomo (Pessoa Física)",
    "Sapiens - Contabilidade",
    "Sapiens - Contas a Pagar",
    "Sapiens - Contas a Receber",
    "Sapiens - Fluxo de Caixa",
    "Sapiens - Recebimento",
    "Sapiens - Sistema de Apoio",
    "Sapiens - Tesouraria",
    "Sapiens - Tributos",
    "Senior - Administração de Pessoal",
    "Senior - Controle de Acesso",
    "Senior - Controle de Ponto",
    "Senior - Jurídico Trabalhista",
    "Senior - Medicina e Segurança do Trabalho",
    "SGA - Acadêmico",
    "SGA - Atividades Administrativas",
    "SGA - Carteirinhas",
    "SGA - Censo",
    "SGA - Contabilidade",
    "SGA - Controle de Ponto",
    "SGA - Controle de Reuniões do Conselho e Câmara",
    "SGA - CPA",
    "SGA - Estágio",
    "SGA - Estágio (Novo)",
    "SGA - Extrator de Dados",
    "SGA - Financeiro",
    "SGA - Formandos",
    "SGA - FORMANDOS (DIPLOMA DIGITAL) - ANTIGO",
    "SGA - FORMANDOS (DIPLOMA DIGITAL) - ATUAL",
    "SGA - Pesquisa",
    "SGA - PIME",
    "SGA - Planejamento EAD",
    "SGA - Pós-Graduação e Extensão",
    "SGA - Pós-Graduação .Net",
    "SGA - Processos Seletivos",
    "SGA - Produção de Materiais Didáticos",
    "SGA - Roteiros",
    "SGA - SISCAP",
    "SGA - Telemarketing",
    "SGA - WEB Administrativo",
    "SGB - Biblioteca",
    "SGS - Clínicas Integradas",
    "SGS - Laboratorio Protese",
    "SGV - Administrativo",
    "SGV - Ambulatório",
    "SGV - Cirúrgico",
    "SGV - Farmácia",
    "SGV - Financeiro",
    "SGV - Financeiro .Net",
    "SGV - Imagem",
    "SGV - Internação",
    "SGV - Laboratório",
    "SGV - LMVP",
    "SGV - Patologia",
    "SGV - Recepção",
    "SIGA - Gestão de Solicitações a DTD / Atividades",
    "Sistemas AVA",
    "Site Institucional",
    "Site UAGRO - Dottatec",
    "Site Universidade do Agro (Drupal)",
    "SITES SAUDE / HOSPITAIS",
    "Sophia",
    "Uniube Sistemas Integrados - USI",
    "Uniube.br - Acesso restrito",
    "Consist Gem - Contabilidade (INATIVO)",
    "Consist Gem - Contas a Pagar (INATIVO)",
    "ORSE - Aplicativo de Apoio (INATIVO)",
    "SGA - Digitalizações (INATIVO)",
    "SGA - Pesquisa MPHU (INATIVO)",
]

type teste = ...

type CategoriasInfraestruturaType = Literal[
    "AD - Alterar Configuração do Domínio",
    "AD - Criar usuário",
    "AD - Desbloquear usuário",
    "AD - Excluir/Bloquear usuário",
    "AD - Liberar permissões de acesso",
    "AD - Redefinir Senha",
    "AD - Suporte/Dúvidas/Outros",
    "BD - Alterar tabela",
    "BD - Atividade Interna",
    "BD - Atualizar esquema",
    "BD - Corrigir lentidão e bloqueios",
    "BD - Criar tabela/índice",
    "BD - Criar usuário",
    "BD - Liberar acessos/permissões",
    "BD - Monitorar rotina de backups e testes de restauração",
    "BD - Reiniciar tabela / Tablespace",
    "BD - Restauração de LOG",
    "BD - Tunning de instrução",
    "DB - Suporte/Dúvidas/Outros",
    "DPO - Analisar contratos",
    "DPO - Analisar/Autorizar autorização de dados e imagens",
    "DPO - Conscientizar sobre segurança digital",
    "DPO - Criar/Implementar política de segurança",
    "E-mail - Alterar Colaborador Responsável",
    "E-mail - Configurar Google Workspace",
    "E-mail - Configurar primeiro acesso",
    "E-mail - Criar e-mail",
    "E-mail - Desbloquear e-mail",
    "E-mail - Excluir/Bloquear e-mail",
    "E-mail - Redefinir senha",
    "E-mail - Suporte/Dúvidas/Outros",
    "Hardware - Atualizar driver(s)/Firmware(s)/Limpeza computador/notebook",
    "Hardware - Atualizar driver(s)/Firmware(s)/Limpeza impressora/scanner",
    "Hardware - Backup",
    "Hardware - Consertar computador/notebook",
    "Hardware - Consertar/Trocar impressora/scanner",
    "Hardware - Formatar",
    "Hardware - Instalar Antivírus",
    "Hardware - Instalar/Desinstalar/Atualizar Software",
    "Hardware - Suporte/Dúvidas/Outros",
    "Inclusão / Remoção de Colaboradores",
    "Liberar dispositivo de armazenamento",
    "Publicação - AVA",
    "Rede - Alterar perfil de acesso",
    "Rede - Ativar/Crimpar Ponto de Rede",
    "Rede - Configurar Firewall",
    "Rede - Criar/Alterar regra Firewall",
    "Rede - Instalar/Configurar/Atualizar AP/Câmera/Router/Voip",
    "Rede - Instalar/Configurar/Atualizar controle de acesso/catraca",
    "Rede - Instalar/Configurar/Atualizar REP",
    "Rede - Instalar/Configurar/Atualizar Switch/VLAN",
    "Rede - Liberar internet",
    "Rede - Suporte VPN",
    "Rede - Suporte/Dúvidas/Outros",
    "Segurança - Investigar ataques cibernéticos",
    "Segurança - Remover ameaças detectadas",
    "Serviços - Atividade interna",
    "Serviços - Empréstimo de Equipamento",
    "Serviços - Realizar auditoria/Criar relatório",
    "Serviços - Transferir/Recolher equipamento",
    "Serviços - Treinamento",
    "Servidores - Alterar configuração",
    "Servidores - Atualizar driver(s)/Firmware(s)/Limpeza",
    "Servidores - Atualizar/Reiniciar",
    "Servidores - Criar usuário",
    "Servidores - Disparar/Conferir/Restaurar backup",
    "Servidores - Excluir/Bloquear Usuário",
    "Servidores - Liberar/Bloquear permissões",
    "Servidores - Manutenção Corretiva",
    "Servidores - Manutenção Preventiva",
    "Sistemas - Desbloquear usuário",
    "Sistemas - Instalar sistema",
    "Sistemas - Liberar Permissões",
    "Sistemas - Redefinir senha",
    "Sistemas - Retirar Permissões",
    "Sistemas - Suporte/Dúvidas/Outros",
    "Telefonia - Atualizar aparelho",
    "Telefonia - Configurar aparelho",
    "Telefonia - Consertar/Trocar aparelho",
    "Telefonia - Suporte/Dúvidas/Outros",
    "Verificar log de eventos",
    "AD - Atribuir Direitos de Acesso em Pasta/Impressora (INATIVO)",
    "AD - Criar/Renomear/Bloquear/Desbloquear usuário (INATIVO)",
    "Alterar REP (INATIVO)",
    "Catracas - Manutenção Corretiva/Preventiva (INATIVO)",
    "Coletor Biométrico - Manutenção Corretiva/Preventiva (INATIVO)",
    "DPO (INATIVO)",
    "Equipamentos - Instalar/Desinstalar (INATIVO)",
    "Equipamentos - Manutenção Corretiva/Preventiva (INATIVO)",
    "Equipamentos - Suporte/Dúvida/Outros (INATIVO)",
    "Firewall - Suporte/Dúvida/Outros (INATIVO)",
    "Internet - Suporte/Dúvidas/Outros (INATIVO)",
    "Servidores - Criar/Configurar (INATIVO)",
    "Servidores - Criar/Deletar Usuários e/ou Diretórios (INATIVO)",
    "Servidores - Manutenção Preventiva/Corretiva (INATIVO)",
    "Sistemas - Liberar/Retirar Permissão (INATIVO)",
    "Suporte/Dúvidas/Outros",
]

type EquipeSistemasType = Literal[
    "SGA - Acadêmico",
    "RMS (Requisições, Materiais e Serviços)",
    "SGA - Financeiro",
    "Recursos Humanos",
    "Financeiro e Contábil",
    "Saúde",
    "SGA - Web",
    "Administador de Banco de Dados",
    "Escritório de Projetos",
    "Analytics",
    "Equipe AVA",
]

type EquipeInfraestruturaType = Literal[
    "Administador de Banco de Dados",
    "Gerenciamento de Redes",
    "Gerenciamento de Redes - Linux",
    "Gerenciamento de Redes - Windows",
    "Help-Desk - Aeroporto",
    "Help-Desk - Ambulatório",
    "Help-Desk - Araxá",
    "Help-Desk - Centro",
    "Help-Desk - HR",
    "Help-Desk - HVU",
    "Help-Desk - IMM",
    "Help-Desk - MPHU",
    "Help-Desk - NPG",
    "Help-Desk - UPA Mirante",
    "Help-Desk - UPA São Benedito",
    "Help-Desk - Via Centro",
    "Help-Desk - Vila Gávea",
    "LIAE - Aeroporto",
    "LIAE - Via Centro",
    "Ouvidoria / Telefonia",
    "Proteção de dados",
    "Publicação AVA",
]

type EquipeGeralType = Literal[
    "SGA - Acadêmico",
    "RMS (Requisições, Materiais e Serviços)",
    "SGA - Financeiro",
    "Recursos Humanos",
    "Financeiro e Contábil",
    "Saúde",
    "SGA - Web",
    "Administador de Banco de Dados",
    "Escritório de Projetos",
    "Analytics",
    "Equipe AVA",
    "Gerenciamento de Redes",
    "Gerenciamento de Redes - Linux",
    "Gerenciamento de Redes - Windows",
    "Help-Desk - Aeroporto",
    "Help-Desk - Ambulatório",
    "Help-Desk - Araxá",
    "Help-Desk - Centro",
    "Help-Desk - HR",
    "Help-Desk - HVU",
    "Help-Desk - IMM",
    "Help-Desk - MPHU",
    "Help-Desk - NPG",
    "Help-Desk - UPA Mirante",
    "Help-Desk - UPA São Benedito",
    "Help-Desk - Via Centro",
    "Help-Desk - Vila Gávea",
    "LIAE - Aeroporto",
    "LIAE - Via Centro",
    "Ouvidoria / Telefonia",
    "Proteção de dados",
    "Publicação AVA",
]

type ProjetoType = Literal[
    "Adequações para ONA 2022",
    "Adequações para ONA 2024",
    "Adequações para ONA 2025",
    "Aditivos ao contrato dos alunos",
    "Anonimização de prontuário do paciente",
    "Análise Inicial - Implantação do sistema de imagens na Policlínica",
    "APP do Paciente",
    "Autoria",
    "AVA - CORPORATIVO",
    "Campus Villa Gávea - Infraestrutura e Segurança",
    "Cartão Saúde Uniube",
    "Cartão Vital",
    "Consultoria externa Contábil/Financeiro",
    "Consultoria externa HCM",
    "Controle de limpeza de leitos hospitalares",
    "Controle de registros dos médicos",
    "Criar script de mapeamento das impressoras",
    "Desenvolvimento Componentes / Framework",
    "Desenvolvimento Web / Mobile",
    "Estudo de plataformas de CRM e Vendas",
    "Gestão de Sucesso dos Polos",
    "Graduação - ajustes na transferência, 2ª graduação - 2025",
    "Implantação do módulo jurídico",
    "Implantação do sistema No Harm - Farmácia",
    "Implantação Integração MVPEP e ATRIUM",
    "Implantação UPAs",
    "Integração da modalidade ECG com o PACs",
    "Integração entre Sistema Epimed Monitor UTI e o MVPEP",
    "Integração SAE e Protocolos",
    "ITVix - SIG Polos Integração",
    "Mapeamento AS IS Logística e Central de Malotes",
    "Melhorias e automação de atendimento - MPHU e TakeBlip",
    "Melhorias na Transferência externa e aproveitamento de estudos",
    "Melhorias no módulo de treinamento",
    "Melhorias no Sistema de Geração de Provas e Fechamento de Disciplinas do EAD",
    "Melhorias para SADT - MPHU",
    "Migração .Net (Entity + Crystal)",
    "Migração de sistemas Fox Pro",
    "Migração para o PHP 8",
    "Novo CNES das Clínicas Integradas",
    "Novo formato alfanumérico para o Cadastro Nacional da Pessoa Jurídica (CNPJ)",
    "Operacao Publicacao AVA",
    "Operaçao DPO",
    "Operação Acadêmico",
    "Operação Analytics",
    "Operação AVA",
    "Operação Banco de Dados",
    "Operação Biblioteca",
    "Operação Clínicas",
    "Operação Compras",
    "Operação Financeiro/Contabilidade",
    "Operação Gestão de Relacionamento",
    "Operação Help Desk",
    "Operação HMed",
    "Operação HVU",
    "Operação Infraestrutura",
    "Operação Jurídico Trabalhista",
    "Operação LIAE",
    "Operação Medicina do Trabalho",
    "Operação MV",
    "Operação RH",
    "Operação RMS",
    "Operação Saúde - Web",
    "Operação Segurança do Trabalho",
    "Operação SGA - Financeiro/Contabilidade",
    "Operação Site Institucional",
    "Operação TI",
    "Operação WEB Administrativo",
    "Overmind.ia - Automação entre MV e Convênios",
    "Painéis interativos de sistemas de saúde",
    "Projeto - Fluxo de locação de espaços físicos",
    "Projeto APP Marcação de Ponto para Professores",
    "Projeto App Pega Plantão",
    "Projeto AVA 3.0",
    "Projeto Banco de Questões",
    "Projeto BI",
    "Projeto Carrinhos Beira Leito",
    "Projeto Contratos Empresariais - PROED",
    "Projeto Controle de Acessos dos Hospitais",
    "Projeto Cópia de perfil",
    "Projeto de adequação Rede WIFI",
    "Projeto de Automatização de Convênios do MPHU",
    "Projeto de Controle de Vacinas no HVU",
    "Projeto de desenvolvimento IA para Plano Terapeutico",
    "Projeto de integração Comtele",
    "Projeto de integração Intersaberes",
    "Projeto de Melhoria de Agendamento de Serviços de Transportes",
    "Projeto de melhorias nas Clínicas Integradas",
    "Projeto de Melhorias no Controle de Contratos",
    "Projeto de melhorias no faturamento MPHU",
    "Projeto de melhorias no HVU",
    "Projeto de Melhorias nos Setores Jurídicos",
    "Projeto de melhorias SEU Financeiro",
    "Projeto de Solicitação de Contratação",
    "Projeto Digitalização Secretaria do Conselho Universitário",
    "Projeto Diploma Digital",
    "Projeto Documentação de Telas e Sistemas",
    "Projeto DRG Brasil - Hospitais",
    "Projeto Evolução do Sistema RMS-Almoxarifado",
    "Projeto Fluxo de Situação Acadêmica EAD",
    "Projeto Gestão da Permanência Qualificada",
    "Projeto GIT",
    "Projeto GPQ",
    "Projeto Ilhas de Impressão",
    "Projeto IMM - Implantação Multiempresa",
    "Projeto Implantação Clínicas MV",
    "Projeto Implantação Ábaris - secretaria digital e diplomas",
    "Projeto Implantação Ábaris - XML histórico parcial e oficial",
    "Projeto Inscrição e Matrícula dos Cursos de Graduação",
    "Projeto LGPD",
    "Projeto Limpeza dos Sistemas AVA",
    "Projeto MELHORIA SISTEMA de APOIO RH",
    "Projeto Melhorias no controle de acesso - Hospitais - Campus Centro - Estacionamentos",
    "Projeto Migração para .Net SGA - Financeiro",
    "Projeto Migração para o Sistemas Integrados WEB",
    "Projeto Número de Alunos - Graduação",
    "Projeto Número de Alunos - Pós-Graduação",
    "Projeto Operação Formandos",
    "Projeto Reestruturação do Repasse a Parceiros - PROED",
    "Projeto Revisão Orçamento Institucional",
    "Projeto RH - Análise de Danos Causados pelo Empregado",
    "Projeto RH - Avaliação de Desenvolvimento",
    "Projeto RH - Coleta de assinatura digital dos ASOs",
    "Projeto RH - Plano de Cargos e Salários",
    "Projeto SEAD CONSAE - Etapa 1",
    "Projeto SEAD CONSAE - Etapa 2",
    "Projeto Secretaria Digital",
    "Projeto Sistema de Avaliação da EAD",
    "Projeto Sistemas de Saúde - WEB",
    "Projeto SMS",
    "Projeto Unificação do PIAC",
    "Projeto Unificação do PROEST",
    "Projeto UniFlex",
    "Projeto Universidade do Agro",
    "Projeto Ábaris - Currículo dos cursos em XML",
    "Projeto: Migração do sistema de Compras/Bionexo",
    "Projetos ASSCOM",
    "Projetos de BIs do sistema RMS",
    "Projetos Estágio",
    "Projetos PMO",
    "Projetos PROPEPE",
    "Projetos Setor Financeiro",
    "Publicações AVA",
    "Pós EAD 2.0",
    "Reformulação do SITE MPHU",
    "RMGV",
    "Sistemas Parceiros",
    "Site Hospitalares",
    "Situações acadêmicas da Pós-Graduação",
    "Transformação Digital",
    "Transformação digital - Aproveitamento/transferencia/segunda graduação",
    "Transformação Digital - Reabertura de atividades do AVA",
    "Transformação Digital - Reemissão de boletos (Refit 2024)",
    "Universidade do Agro - Novo site",
    "Universidade MV",
    "Upgrade SO Windows Server 2012 - fim do suporte",
    "Vertifical da Saúde Uniube (projeto)",
]

type FiltrosOSType = Literal[
    "Pendente-Atendimento",
    "Em Teste",
    "Pendente-Teste",
    "Em Atendimento",
    "Em Implantação",
    "Pendente-Liberação",
    "Concluída por Encaminhamento",
    "Concluída",
    "Concluída por substituição",
    "Não Planejada",
    "Pendente-Sist. Administrativos",
    "Pendente-AVA",
    "Pendente-Consultoria",
    "Solicitação em Aprovação",
    "Pendente-Aprovação",
    "Pendente-Sist. Acadêmicos",
    "Pendente-Marketing",
    "Pendente-Equipe Manutenção",
    "Pendente-Equipe Infraestrutura",
    "Pendente-Atualização de Versão",
    "Pendente-Help-Desk",
    "Cancelamento DTI | Arquivado",
    "Cancelada-Usuário",
    "Pendente-Fornecedor",
    "Pendente-Usuário",
]

type TiposAtendimentosOSType = Literal[
    "Suporte Sistema",
    "Implementação",
    "Manutenção Corretiva",
    "Reunião",
    "Treinamento",
    "Mudança de Escopo",
    "Anexo",
    "Suporte Infraestrutura",
    "Monitoramento",
    "Incidente",
    "Requisição",
]

type TipoAtendimentosOSType = Literal[
    "Suporte Sistema",
    "Implementação",
    "Manutenção Corretiva",
    "Reunião",
    "Treinamento",
    "Mudança de Escopo",
    "Anexo",
    "Suporte Infraestrutura",
    "Monitoramento",
    "Incidente",
    "Requisição",
]

type LinguagemOsSistemasType = Literal[
    "C#",
    "Fox",
    "SQL",
    "ASP.Net",
    "Access",
    "PHP",
    "Extrator de Dados",
    "MV Painel de Indicadores",
    "MV Editor",
    "Gerador de Relatórios",
    "Gerador de Cubos",
    "Power BI",
    "Gerador de Tela",
    "Editor de Regra",
    "Delphi",
    "Script SO",
    "Node.js",
    "Senior - Gerador de visão dinâmica",
    "Analytics",
]


type OsInternaSistemasType = Literal[
    "Sim",
    "Não",
]

type StatusOsType = Literal[
    "Concluída",
    "Concluída por Encaminhamento",
    "Concluída por substituição",
    "Em Atendimento",
    "Em Implantação",
    "Em Teste",
    "Não Planejada",
    "Pendente-Aprovação",
    "Pendente-Atendimento",
    "Pendente-Atualização de Versão",
    "Pendente-AVA",
    "Pendente-Consultoria",
    "Pendente-Equipe Infraestrutura",
    "Pendente-Equipe Manutenção",
    "Pendente-Fornecedor",
    "Pendente-Help-Desk",
    "Pendente-Liberação",
    "Pendente-Marketing",
    "Pendente-Sist. Acadêmicos",
    "Pendente-Sist. Administrativos",
    "Pendente-Teste",
    "Pendente-Usuário",
    "Solicitação em Aprovação",
    "Cancelada-Usuário",
    "Cancelamento DTD | Arquivado",
]

type CriticidadeOsType = Literal[
    "Nenhuma",
    "Baixa",
    "Média",
    "Alta",
]

type PrioridadeUsuarioOsType = Literal[
    "Nenhuma",
    "Urgente",
    "Alta",
    "Média",
    "Baixa",
]

# Type para situação do usuário
type SituacaoUsuarioType = Literal[
    "Bloqueado",
    "Ativo",
    "Bloqueado (Afastamento)",
    "Bloqueado pelo RH (Individual)",
    "Bloqueado por Falta de Justificativa de Ponto (Individual)",
    "Bloqueado Licença sem Remuneração",
]


type TransportType = Literal["http", "stdio"]
