"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2021 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import dapr.proto.common.v1.common_pb2
import dapr.proto.runtime.v1.appcallback_pb2
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _PubsubSubscriptionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PubsubSubscriptionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PubsubSubscriptionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN: _PubsubSubscriptionType.ValueType  # 0
    """UNKNOWN is the default value for the subscription type."""
    DECLARATIVE: _PubsubSubscriptionType.ValueType  # 1
    """Declarative subscription (k8s CRD)"""
    PROGRAMMATIC: _PubsubSubscriptionType.ValueType  # 2
    """Programmatically created subscription"""
    STREAMING: _PubsubSubscriptionType.ValueType  # 3
    """Bidirectional Streaming subscription"""

class PubsubSubscriptionType(_PubsubSubscriptionType, metaclass=_PubsubSubscriptionTypeEnumTypeWrapper):
    """PubsubSubscriptionType indicates the type of subscription"""

UNKNOWN: PubsubSubscriptionType.ValueType  # 0
"""UNKNOWN is the default value for the subscription type."""
DECLARATIVE: PubsubSubscriptionType.ValueType  # 1
"""Declarative subscription (k8s CRD)"""
PROGRAMMATIC: PubsubSubscriptionType.ValueType  # 2
"""Programmatically created subscription"""
STREAMING: PubsubSubscriptionType.ValueType  # 3
"""Bidirectional Streaming subscription"""
global___PubsubSubscriptionType = PubsubSubscriptionType

@typing.final
class InvokeServiceRequest(google.protobuf.message.Message):
    """InvokeServiceRequest represents the request message for Service invocation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. Callee's app id."""
    @property
    def message(self) -> dapr.proto.common.v1.common_pb2.InvokeRequest:
        """Required. message which will be delivered to callee."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        message: dapr.proto.common.v1.common_pb2.InvokeRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "message", b"message"]) -> None: ...

global___InvokeServiceRequest = InvokeServiceRequest

@typing.final
class GetStateRequest(google.protobuf.message.Message):
    """GetStateRequest is the message to get key-value states from specific state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    CONSISTENCY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    key: builtins.str
    """The key of the desired state"""
    consistency: dapr.proto.common.v1.common_pb2.StateOptions.StateConsistency.ValueType
    """The read consistency of the state store."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to state store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        key: builtins.str = ...,
        consistency: dapr.proto.common.v1.common_pb2.StateOptions.StateConsistency.ValueType = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["consistency", b"consistency", "key", b"key", "metadata", b"metadata", "store_name", b"store_name"]) -> None: ...

global___GetStateRequest = GetStateRequest

@typing.final
class GetBulkStateRequest(google.protobuf.message.Message):
    """GetBulkStateRequest is the message to get a list of key-value states from specific state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    PARALLELISM_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    parallelism: builtins.int
    """The number of parallel operations executed on the state store for a get operation."""
    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The keys to get."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to state store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        keys: collections.abc.Iterable[builtins.str] | None = ...,
        parallelism: builtins.int = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["keys", b"keys", "metadata", b"metadata", "parallelism", b"parallelism", "store_name", b"store_name"]) -> None: ...

global___GetBulkStateRequest = GetBulkStateRequest

@typing.final
class GetBulkStateResponse(google.protobuf.message.Message):
    """GetBulkStateResponse is the response conveying the list of state values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BulkStateItem]:
        """The list of items containing the keys to get values for."""

    def __init__(
        self,
        *,
        items: collections.abc.Iterable[global___BulkStateItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["items", b"items"]) -> None: ...

global___GetBulkStateResponse = GetBulkStateResponse

@typing.final
class BulkStateItem(google.protobuf.message.Message):
    """BulkStateItem is the response item for a bulk get operation.
    Return values include the item key, data and etag.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    KEY_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    key: builtins.str
    """state item key"""
    data: builtins.bytes
    """The byte array data"""
    etag: builtins.str
    """The entity tag which represents the specific version of data.
    ETag format is defined by the corresponding data store.
    """
    error: builtins.str
    """The error that was returned from the state store in case of a failed get operation."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to app."""

    def __init__(
        self,
        *,
        key: builtins.str = ...,
        data: builtins.bytes = ...,
        etag: builtins.str = ...,
        error: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "error", b"error", "etag", b"etag", "key", b"key", "metadata", b"metadata"]) -> None: ...

global___BulkStateItem = BulkStateItem

@typing.final
class GetStateResponse(google.protobuf.message.Message):
    """GetStateResponse is the response conveying the state value and etag."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """The byte array data"""
    etag: builtins.str
    """The entity tag which represents the specific version of data.
    ETag format is defined by the corresponding data store.
    """
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to app."""

    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
        etag: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "etag", b"etag", "metadata", b"metadata"]) -> None: ...

global___GetStateResponse = GetStateResponse

@typing.final
class DeleteStateRequest(google.protobuf.message.Message):
    """DeleteStateRequest is the message to delete key-value states in the specific state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    key: builtins.str
    """The key of the desired state"""
    @property
    def etag(self) -> dapr.proto.common.v1.common_pb2.Etag:
        """The entity tag which represents the specific version of data.
        The exact ETag format is defined by the corresponding data store.
        """

    @property
    def options(self) -> dapr.proto.common.v1.common_pb2.StateOptions:
        """State operation options which includes concurrency/
        consistency/retry_policy.
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to state store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        key: builtins.str = ...,
        etag: dapr.proto.common.v1.common_pb2.Etag | None = ...,
        options: dapr.proto.common.v1.common_pb2.StateOptions | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["etag", b"etag", "options", b"options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["etag", b"etag", "key", b"key", "metadata", b"metadata", "options", b"options", "store_name", b"store_name"]) -> None: ...

global___DeleteStateRequest = DeleteStateRequest

@typing.final
class DeleteBulkStateRequest(google.protobuf.message.Message):
    """DeleteBulkStateRequest is the message to delete a list of key-value states from specific state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    STATES_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    @property
    def states(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[dapr.proto.common.v1.common_pb2.StateItem]:
        """The array of the state key values."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        states: collections.abc.Iterable[dapr.proto.common.v1.common_pb2.StateItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["states", b"states", "store_name", b"store_name"]) -> None: ...

global___DeleteBulkStateRequest = DeleteBulkStateRequest

@typing.final
class SaveStateRequest(google.protobuf.message.Message):
    """SaveStateRequest is the message to save multiple states into state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    STATES_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    @property
    def states(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[dapr.proto.common.v1.common_pb2.StateItem]:
        """The array of the state key values."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        states: collections.abc.Iterable[dapr.proto.common.v1.common_pb2.StateItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["states", b"states", "store_name", b"store_name"]) -> None: ...

global___SaveStateRequest = SaveStateRequest

@typing.final
class QueryStateRequest(google.protobuf.message.Message):
    """QueryStateRequest is the message to query state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    query: builtins.str
    """The query in JSON format."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to state store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        query: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["metadata", b"metadata", "query", b"query", "store_name", b"store_name"]) -> None: ...

global___QueryStateRequest = QueryStateRequest

@typing.final
class QueryStateItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    key: builtins.str
    """The object key."""
    data: builtins.bytes
    """The object value."""
    etag: builtins.str
    """The entity tag which represents the specific version of data.
    ETag format is defined by the corresponding data store.
    """
    error: builtins.str
    """The error message indicating an error in processing of the query result."""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        data: builtins.bytes = ...,
        etag: builtins.str = ...,
        error: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "error", b"error", "etag", b"etag", "key", b"key"]) -> None: ...

global___QueryStateItem = QueryStateItem

@typing.final
class QueryStateResponse(google.protobuf.message.Message):
    """QueryStateResponse is the response conveying the query results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    RESULTS_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    token: builtins.str
    """Pagination token."""
    @property
    def results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___QueryStateItem]:
        """An array of query results."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to app."""

    def __init__(
        self,
        *,
        results: collections.abc.Iterable[global___QueryStateItem] | None = ...,
        token: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["metadata", b"metadata", "results", b"results", "token", b"token"]) -> None: ...

global___QueryStateResponse = QueryStateResponse

@typing.final
class PublishEventRequest(google.protobuf.message.Message):
    """PublishEventRequest is the message to publish event data to pubsub topic"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PUBSUB_NAME_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    DATA_CONTENT_TYPE_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    pubsub_name: builtins.str
    """The name of the pubsub component"""
    topic: builtins.str
    """The pubsub topic"""
    data: builtins.bytes
    """The data which will be published to topic."""
    data_content_type: builtins.str
    """The content type for the data (optional)."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata passing to pub components

        metadata property:
        - key : the key of the message.
        """

    def __init__(
        self,
        *,
        pubsub_name: builtins.str = ...,
        topic: builtins.str = ...,
        data: builtins.bytes = ...,
        data_content_type: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "data_content_type", b"data_content_type", "metadata", b"metadata", "pubsub_name", b"pubsub_name", "topic", b"topic"]) -> None: ...

global___PublishEventRequest = PublishEventRequest

@typing.final
class BulkPublishRequest(google.protobuf.message.Message):
    """BulkPublishRequest is the message to bulk publish events to pubsub topic"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PUBSUB_NAME_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    ENTRIES_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    pubsub_name: builtins.str
    """The name of the pubsub component"""
    topic: builtins.str
    """The pubsub topic"""
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BulkPublishRequestEntry]:
        """The entries which contain the individual events and associated details to be published"""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The request level metadata passing to to the pubsub components"""

    def __init__(
        self,
        *,
        pubsub_name: builtins.str = ...,
        topic: builtins.str = ...,
        entries: collections.abc.Iterable[global___BulkPublishRequestEntry] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["entries", b"entries", "metadata", b"metadata", "pubsub_name", b"pubsub_name", "topic", b"topic"]) -> None: ...

global___BulkPublishRequest = BulkPublishRequest

@typing.final
class BulkPublishRequestEntry(google.protobuf.message.Message):
    """BulkPublishRequestEntry is the message containing the event to be bulk published"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENTRY_ID_FIELD_NUMBER: builtins.int
    EVENT_FIELD_NUMBER: builtins.int
    CONTENT_TYPE_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    entry_id: builtins.str
    """The request scoped unique ID referring to this message. Used to map status in response"""
    event: builtins.bytes
    """The event which will be pulished to the topic"""
    content_type: builtins.str
    """The content type for the event"""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The event level metadata passing to the pubsub component"""

    def __init__(
        self,
        *,
        entry_id: builtins.str = ...,
        event: builtins.bytes = ...,
        content_type: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content_type", b"content_type", "entry_id", b"entry_id", "event", b"event", "metadata", b"metadata"]) -> None: ...

global___BulkPublishRequestEntry = BulkPublishRequestEntry

@typing.final
class BulkPublishResponse(google.protobuf.message.Message):
    """BulkPublishResponse is the message returned from a BulkPublishEvent call"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAILEDENTRIES_FIELD_NUMBER: builtins.int
    @property
    def failedEntries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BulkPublishResponseFailedEntry]:
        """The entries for different events that failed publish in the BulkPublishEvent call"""

    def __init__(
        self,
        *,
        failedEntries: collections.abc.Iterable[global___BulkPublishResponseFailedEntry] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["failedEntries", b"failedEntries"]) -> None: ...

global___BulkPublishResponse = BulkPublishResponse

@typing.final
class BulkPublishResponseFailedEntry(google.protobuf.message.Message):
    """BulkPublishResponseFailedEntry is the message containing the entryID and error of a failed event in BulkPublishEvent call"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTRY_ID_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    entry_id: builtins.str
    """The response scoped unique ID referring to this message"""
    error: builtins.str
    """The error message if any on failure"""
    def __init__(
        self,
        *,
        entry_id: builtins.str = ...,
        error: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["entry_id", b"entry_id", "error", b"error"]) -> None: ...

global___BulkPublishResponseFailedEntry = BulkPublishResponseFailedEntry

@typing.final
class SubscribeTopicEventsRequestAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsRequestAlpha1 is a message containing the details for
    subscribing to a topic via streaming.
    The first message must always be the initial request. All subsequent
    messages must be event processed responses.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INITIAL_REQUEST_FIELD_NUMBER: builtins.int
    EVENT_PROCESSED_FIELD_NUMBER: builtins.int
    @property
    def initial_request(self) -> global___SubscribeTopicEventsRequestInitialAlpha1: ...
    @property
    def event_processed(self) -> global___SubscribeTopicEventsRequestProcessedAlpha1: ...
    def __init__(
        self,
        *,
        initial_request: global___SubscribeTopicEventsRequestInitialAlpha1 | None = ...,
        event_processed: global___SubscribeTopicEventsRequestProcessedAlpha1 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["event_processed", b"event_processed", "initial_request", b"initial_request", "subscribe_topic_events_request_type", b"subscribe_topic_events_request_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["event_processed", b"event_processed", "initial_request", b"initial_request", "subscribe_topic_events_request_type", b"subscribe_topic_events_request_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["subscribe_topic_events_request_type", b"subscribe_topic_events_request_type"]) -> typing.Literal["initial_request", "event_processed"] | None: ...

global___SubscribeTopicEventsRequestAlpha1 = SubscribeTopicEventsRequestAlpha1

@typing.final
class SubscribeTopicEventsRequestInitialAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsRequestInitialAlpha1 is the initial message containing
    the details for subscribing to a topic via streaming.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PUBSUB_NAME_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    DEAD_LETTER_TOPIC_FIELD_NUMBER: builtins.int
    pubsub_name: builtins.str
    """The name of the pubsub component"""
    topic: builtins.str
    """The pubsub topic"""
    dead_letter_topic: builtins.str
    """dead_letter_topic is the topic to which messages that fail to be processed
    are sent.
    """
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata passing to pub components

        metadata property:
        - key : the key of the message.
        """

    def __init__(
        self,
        *,
        pubsub_name: builtins.str = ...,
        topic: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        dead_letter_topic: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_dead_letter_topic", b"_dead_letter_topic", "dead_letter_topic", b"dead_letter_topic"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_dead_letter_topic", b"_dead_letter_topic", "dead_letter_topic", b"dead_letter_topic", "metadata", b"metadata", "pubsub_name", b"pubsub_name", "topic", b"topic"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_dead_letter_topic", b"_dead_letter_topic"]) -> typing.Literal["dead_letter_topic"] | None: ...

global___SubscribeTopicEventsRequestInitialAlpha1 = SubscribeTopicEventsRequestInitialAlpha1

@typing.final
class SubscribeTopicEventsRequestProcessedAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsRequestProcessedAlpha1 is the message containing the
    subscription to a topic.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id is the unique identifier for the subscription request."""
    @property
    def status(self) -> dapr.proto.runtime.v1.appcallback_pb2.TopicEventResponse:
        """status is the result of the subscription request."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        status: dapr.proto.runtime.v1.appcallback_pb2.TopicEventResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "status", b"status"]) -> None: ...

global___SubscribeTopicEventsRequestProcessedAlpha1 = SubscribeTopicEventsRequestProcessedAlpha1

@typing.final
class SubscribeTopicEventsResponseAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsResponseAlpha1 is a message returned from daprd
    when subscribing to a topic via streaming.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INITIAL_RESPONSE_FIELD_NUMBER: builtins.int
    EVENT_MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def initial_response(self) -> global___SubscribeTopicEventsResponseInitialAlpha1: ...
    @property
    def event_message(self) -> dapr.proto.runtime.v1.appcallback_pb2.TopicEventRequest: ...
    def __init__(
        self,
        *,
        initial_response: global___SubscribeTopicEventsResponseInitialAlpha1 | None = ...,
        event_message: dapr.proto.runtime.v1.appcallback_pb2.TopicEventRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["event_message", b"event_message", "initial_response", b"initial_response", "subscribe_topic_events_response_type", b"subscribe_topic_events_response_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["event_message", b"event_message", "initial_response", b"initial_response", "subscribe_topic_events_response_type", b"subscribe_topic_events_response_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["subscribe_topic_events_response_type", b"subscribe_topic_events_response_type"]) -> typing.Literal["initial_response", "event_message"] | None: ...

global___SubscribeTopicEventsResponseAlpha1 = SubscribeTopicEventsResponseAlpha1

@typing.final
class SubscribeTopicEventsResponseInitialAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsResponseInitialAlpha1 is the initial response from daprd
    when subscribing to a topic.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SubscribeTopicEventsResponseInitialAlpha1 = SubscribeTopicEventsResponseInitialAlpha1

@typing.final
class InvokeBindingRequest(google.protobuf.message.Message):
    """InvokeBindingRequest is the message to send data to output bindings"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    OPERATION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the output binding to invoke."""
    data: builtins.bytes
    """The data which will be sent to output binding."""
    operation: builtins.str
    """The name of the operation type for the binding to invoke"""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata passing to output binding components

        Common metadata property:
        - ttlInSeconds : the time to live in seconds for the message.

        If set in the binding definition will cause all messages to
        have a default time to live. The message ttl overrides any value
        in the binding definition.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        data: builtins.bytes = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        operation: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "metadata", b"metadata", "name", b"name", "operation", b"operation"]) -> None: ...

global___InvokeBindingRequest = InvokeBindingRequest

@typing.final
class InvokeBindingResponse(google.protobuf.message.Message):
    """InvokeBindingResponse is the message returned from an output binding invocation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """The data which will be sent to output binding."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata returned from an external system"""

    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "metadata", b"metadata"]) -> None: ...

global___InvokeBindingResponse = InvokeBindingResponse

@typing.final
class GetSecretRequest(google.protobuf.message.Message):
    """GetSecretRequest is the message to get secret from secret store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of secret store."""
    key: builtins.str
    """The name of secret key."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to secret store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        key: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "metadata", b"metadata", "store_name", b"store_name"]) -> None: ...

global___GetSecretRequest = GetSecretRequest

@typing.final
class GetSecretResponse(google.protobuf.message.Message):
    """GetSecretResponse is the response message to convey the requested secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """data is the secret value. Some secret store, such as kubernetes secret
        store, can save multiple secrets for single secret key.
        """

    def __init__(
        self,
        *,
        data: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data"]) -> None: ...

global___GetSecretResponse = GetSecretResponse

@typing.final
class GetBulkSecretRequest(google.protobuf.message.Message):
    """GetBulkSecretRequest is the message to get the secrets from secret store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of secret store."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to secret store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["metadata", b"metadata", "store_name", b"store_name"]) -> None: ...

global___GetBulkSecretRequest = GetBulkSecretRequest

@typing.final
class SecretResponse(google.protobuf.message.Message):
    """SecretResponse is a map of decrypted string/string values"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    SECRETS_FIELD_NUMBER: builtins.int
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["secrets", b"secrets"]) -> None: ...

global___SecretResponse = SecretResponse

@typing.final
class GetBulkSecretResponse(google.protobuf.message.Message):
    """GetBulkSecretResponse is the response message to convey the requested secrets."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___SecretResponse: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___SecretResponse | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___SecretResponse]:
        """data hold the secret values. Some secret store, such as kubernetes secret
        store, can save multiple secrets for single secret key.
        """

    def __init__(
        self,
        *,
        data: collections.abc.Mapping[builtins.str, global___SecretResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data"]) -> None: ...

global___GetBulkSecretResponse = GetBulkSecretResponse

@typing.final
class TransactionalStateOperation(google.protobuf.message.Message):
    """TransactionalStateOperation is the message to execute a specified operation with a key-value pair."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONTYPE_FIELD_NUMBER: builtins.int
    REQUEST_FIELD_NUMBER: builtins.int
    operationType: builtins.str
    """The type of operation to be executed"""
    @property
    def request(self) -> dapr.proto.common.v1.common_pb2.StateItem:
        """State values to be operated on"""

    def __init__(
        self,
        *,
        operationType: builtins.str = ...,
        request: dapr.proto.common.v1.common_pb2.StateItem | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["request", b"request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["operationType", b"operationType", "request", b"request"]) -> None: ...

global___TransactionalStateOperation = TransactionalStateOperation

@typing.final
class ExecuteStateTransactionRequest(google.protobuf.message.Message):
    """ExecuteStateTransactionRequest is the message to execute multiple operations on a specified store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STORENAME_FIELD_NUMBER: builtins.int
    OPERATIONS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    storeName: builtins.str
    """Required. name of state store."""
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TransactionalStateOperation]:
        """Required. transactional operation list."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata used for transactional operations."""

    def __init__(
        self,
        *,
        storeName: builtins.str = ...,
        operations: collections.abc.Iterable[global___TransactionalStateOperation] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["metadata", b"metadata", "operations", b"operations", "storeName", b"storeName"]) -> None: ...

global___ExecuteStateTransactionRequest = ExecuteStateTransactionRequest

@typing.final
class RegisterActorTimerRequest(google.protobuf.message.Message):
    """RegisterActorTimerRequest is the message to register a timer for an actor of a given type and id."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DUE_TIME_FIELD_NUMBER: builtins.int
    PERIOD_FIELD_NUMBER: builtins.int
    CALLBACK_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    name: builtins.str
    due_time: builtins.str
    period: builtins.str
    callback: builtins.str
    data: builtins.bytes
    ttl: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        name: builtins.str = ...,
        due_time: builtins.str = ...,
        period: builtins.str = ...,
        callback: builtins.str = ...,
        data: builtins.bytes = ...,
        ttl: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "callback", b"callback", "data", b"data", "due_time", b"due_time", "name", b"name", "period", b"period", "ttl", b"ttl"]) -> None: ...

global___RegisterActorTimerRequest = RegisterActorTimerRequest

@typing.final
class UnregisterActorTimerRequest(google.protobuf.message.Message):
    """UnregisterActorTimerRequest is the message to unregister an actor timer"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    name: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "name", b"name"]) -> None: ...

global___UnregisterActorTimerRequest = UnregisterActorTimerRequest

@typing.final
class RegisterActorReminderRequest(google.protobuf.message.Message):
    """RegisterActorReminderRequest is the message to register a reminder for an actor of a given type and id."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DUE_TIME_FIELD_NUMBER: builtins.int
    PERIOD_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    name: builtins.str
    due_time: builtins.str
    period: builtins.str
    data: builtins.bytes
    ttl: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        name: builtins.str = ...,
        due_time: builtins.str = ...,
        period: builtins.str = ...,
        data: builtins.bytes = ...,
        ttl: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "data", b"data", "due_time", b"due_time", "name", b"name", "period", b"period", "ttl", b"ttl"]) -> None: ...

global___RegisterActorReminderRequest = RegisterActorReminderRequest

@typing.final
class UnregisterActorReminderRequest(google.protobuf.message.Message):
    """UnregisterActorReminderRequest is the message to unregister an actor reminder."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    name: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "name", b"name"]) -> None: ...

global___UnregisterActorReminderRequest = UnregisterActorReminderRequest

@typing.final
class GetActorStateRequest(google.protobuf.message.Message):
    """GetActorStateRequest is the message to get key-value states from specific actor."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    key: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "key", b"key"]) -> None: ...

global___GetActorStateRequest = GetActorStateRequest

@typing.final
class GetActorStateResponse(google.protobuf.message.Message):
    """GetActorStateResponse is the response conveying the actor's state value."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to app."""

    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "metadata", b"metadata"]) -> None: ...

global___GetActorStateResponse = GetActorStateResponse

@typing.final
class ExecuteActorStateTransactionRequest(google.protobuf.message.Message):
    """ExecuteActorStateTransactionRequest is the message to execute multiple operations on a specified actor."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    OPERATIONS_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TransactionalActorStateOperation]: ...
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        operations: collections.abc.Iterable[global___TransactionalActorStateOperation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "operations", b"operations"]) -> None: ...

global___ExecuteActorStateTransactionRequest = ExecuteActorStateTransactionRequest

@typing.final
class TransactionalActorStateOperation(google.protobuf.message.Message):
    """TransactionalActorStateOperation is the message to execute a specified operation with a key-value pair."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    OPERATIONTYPE_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    operationType: builtins.str
    key: builtins.str
    @property
    def value(self) -> google.protobuf.any_pb2.Any: ...
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata used for transactional operations.

        Common metadata property:
        - ttlInSeconds : the time to live in seconds for the stored value.
        """

    def __init__(
        self,
        *,
        operationType: builtins.str = ...,
        key: builtins.str = ...,
        value: google.protobuf.any_pb2.Any | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "metadata", b"metadata", "operationType", b"operationType", "value", b"value"]) -> None: ...

global___TransactionalActorStateOperation = TransactionalActorStateOperation

@typing.final
class InvokeActorRequest(google.protobuf.message.Message):
    """InvokeActorRequest is the message to call an actor."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    method: builtins.str
    data: builtins.bytes
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        method: builtins.str = ...,
        data: builtins.bytes = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "data", b"data", "metadata", b"metadata", "method", b"method"]) -> None: ...

global___InvokeActorRequest = InvokeActorRequest

@typing.final
class InvokeActorResponse(google.protobuf.message.Message):
    """InvokeActorResponse is the method that returns an actor invocation response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data"]) -> None: ...

global___InvokeActorResponse = InvokeActorResponse

@typing.final
class GetMetadataRequest(google.protobuf.message.Message):
    """GetMetadataRequest is the message for the GetMetadata request.
    Empty
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetMetadataRequest = GetMetadataRequest

@typing.final
class GetMetadataResponse(google.protobuf.message.Message):
    """GetMetadataResponse is a message that is returned on GetMetadata rpc call."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ExtendedMetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    ACTIVE_ACTORS_COUNT_FIELD_NUMBER: builtins.int
    REGISTERED_COMPONENTS_FIELD_NUMBER: builtins.int
    EXTENDED_METADATA_FIELD_NUMBER: builtins.int
    SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    HTTP_ENDPOINTS_FIELD_NUMBER: builtins.int
    APP_CONNECTION_PROPERTIES_FIELD_NUMBER: builtins.int
    RUNTIME_VERSION_FIELD_NUMBER: builtins.int
    ENABLED_FEATURES_FIELD_NUMBER: builtins.int
    ACTOR_RUNTIME_FIELD_NUMBER: builtins.int
    SCHEDULER_FIELD_NUMBER: builtins.int
    id: builtins.str
    runtime_version: builtins.str
    @property
    def active_actors_count(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ActiveActorsCount]:
        """Deprecated alias for actor_runtime.active_actors."""

    @property
    def registered_components(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RegisteredComponents]: ...
    @property
    def extended_metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def subscriptions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PubsubSubscription]: ...
    @property
    def http_endpoints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MetadataHTTPEndpoint]: ...
    @property
    def app_connection_properties(self) -> global___AppConnectionProperties: ...
    @property
    def enabled_features(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def actor_runtime(self) -> global___ActorRuntime: ...
    @property
    def scheduler(self) -> global___MetadataScheduler: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        active_actors_count: collections.abc.Iterable[global___ActiveActorsCount] | None = ...,
        registered_components: collections.abc.Iterable[global___RegisteredComponents] | None = ...,
        extended_metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        subscriptions: collections.abc.Iterable[global___PubsubSubscription] | None = ...,
        http_endpoints: collections.abc.Iterable[global___MetadataHTTPEndpoint] | None = ...,
        app_connection_properties: global___AppConnectionProperties | None = ...,
        runtime_version: builtins.str = ...,
        enabled_features: collections.abc.Iterable[builtins.str] | None = ...,
        actor_runtime: global___ActorRuntime | None = ...,
        scheduler: global___MetadataScheduler | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_scheduler", b"_scheduler", "actor_runtime", b"actor_runtime", "app_connection_properties", b"app_connection_properties", "scheduler", b"scheduler"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_scheduler", b"_scheduler", "active_actors_count", b"active_actors_count", "actor_runtime", b"actor_runtime", "app_connection_properties", b"app_connection_properties", "enabled_features", b"enabled_features", "extended_metadata", b"extended_metadata", "http_endpoints", b"http_endpoints", "id", b"id", "registered_components", b"registered_components", "runtime_version", b"runtime_version", "scheduler", b"scheduler", "subscriptions", b"subscriptions"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_scheduler", b"_scheduler"]) -> typing.Literal["scheduler"] | None: ...

global___GetMetadataResponse = GetMetadataResponse

@typing.final
class MetadataScheduler(google.protobuf.message.Message):
    """MetadataScheduler is a message that contains the list of addresses of the
    scheduler connections.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTED_ADDRESSES_FIELD_NUMBER: builtins.int
    @property
    def connected_addresses(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """connected_addresses the list of addresses of the scheduler connections."""

    def __init__(
        self,
        *,
        connected_addresses: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["connected_addresses", b"connected_addresses"]) -> None: ...

global___MetadataScheduler = MetadataScheduler

@typing.final
class ActorRuntime(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ActorRuntimeStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ActorRuntimeStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ActorRuntime._ActorRuntimeStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INITIALIZING: ActorRuntime._ActorRuntimeStatus.ValueType  # 0
        """Indicates that the actor runtime is still being initialized."""
        DISABLED: ActorRuntime._ActorRuntimeStatus.ValueType  # 1
        """Indicates that the actor runtime is disabled.
        This normally happens when Dapr is started without "placement-host-address"
        """
        RUNNING: ActorRuntime._ActorRuntimeStatus.ValueType  # 2
        """Indicates the actor runtime is running, either as an actor host or client."""

    class ActorRuntimeStatus(_ActorRuntimeStatus, metaclass=_ActorRuntimeStatusEnumTypeWrapper): ...
    INITIALIZING: ActorRuntime.ActorRuntimeStatus.ValueType  # 0
    """Indicates that the actor runtime is still being initialized."""
    DISABLED: ActorRuntime.ActorRuntimeStatus.ValueType  # 1
    """Indicates that the actor runtime is disabled.
    This normally happens when Dapr is started without "placement-host-address"
    """
    RUNNING: ActorRuntime.ActorRuntimeStatus.ValueType  # 2
    """Indicates the actor runtime is running, either as an actor host or client."""

    RUNTIME_STATUS_FIELD_NUMBER: builtins.int
    ACTIVE_ACTORS_FIELD_NUMBER: builtins.int
    HOST_READY_FIELD_NUMBER: builtins.int
    PLACEMENT_FIELD_NUMBER: builtins.int
    runtime_status: global___ActorRuntime.ActorRuntimeStatus.ValueType
    """Contains an enum indicating whether the actor runtime has been initialized."""
    host_ready: builtins.bool
    """Indicates whether the actor runtime is ready to host actors."""
    placement: builtins.str
    """Custom message from the placement provider."""
    @property
    def active_actors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ActiveActorsCount]:
        """Count of active actors per type."""

    def __init__(
        self,
        *,
        runtime_status: global___ActorRuntime.ActorRuntimeStatus.ValueType = ...,
        active_actors: collections.abc.Iterable[global___ActiveActorsCount] | None = ...,
        host_ready: builtins.bool = ...,
        placement: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active_actors", b"active_actors", "host_ready", b"host_ready", "placement", b"placement", "runtime_status", b"runtime_status"]) -> None: ...

global___ActorRuntime = ActorRuntime

@typing.final
class ActiveActorsCount(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    type: builtins.str
    count: builtins.int
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count", b"count", "type", b"type"]) -> None: ...

global___ActiveActorsCount = ActiveActorsCount

@typing.final
class RegisteredComponents(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    CAPABILITIES_FIELD_NUMBER: builtins.int
    name: builtins.str
    type: builtins.str
    version: builtins.str
    @property
    def capabilities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: builtins.str = ...,
        version: builtins.str = ...,
        capabilities: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["capabilities", b"capabilities", "name", b"name", "type", b"type", "version", b"version"]) -> None: ...

global___RegisteredComponents = RegisteredComponents

@typing.final
class MetadataHTTPEndpoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name"]) -> None: ...

global___MetadataHTTPEndpoint = MetadataHTTPEndpoint

@typing.final
class AppConnectionProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PORT_FIELD_NUMBER: builtins.int
    PROTOCOL_FIELD_NUMBER: builtins.int
    CHANNEL_ADDRESS_FIELD_NUMBER: builtins.int
    MAX_CONCURRENCY_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    port: builtins.int
    protocol: builtins.str
    channel_address: builtins.str
    max_concurrency: builtins.int
    @property
    def health(self) -> global___AppConnectionHealthProperties: ...
    def __init__(
        self,
        *,
        port: builtins.int = ...,
        protocol: builtins.str = ...,
        channel_address: builtins.str = ...,
        max_concurrency: builtins.int = ...,
        health: global___AppConnectionHealthProperties | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["health", b"health"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_address", b"channel_address", "health", b"health", "max_concurrency", b"max_concurrency", "port", b"port", "protocol", b"protocol"]) -> None: ...

global___AppConnectionProperties = AppConnectionProperties

@typing.final
class AppConnectionHealthProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_PATH_FIELD_NUMBER: builtins.int
    HEALTH_PROBE_INTERVAL_FIELD_NUMBER: builtins.int
    HEALTH_PROBE_TIMEOUT_FIELD_NUMBER: builtins.int
    HEALTH_THRESHOLD_FIELD_NUMBER: builtins.int
    health_check_path: builtins.str
    health_probe_interval: builtins.str
    health_probe_timeout: builtins.str
    health_threshold: builtins.int
    def __init__(
        self,
        *,
        health_check_path: builtins.str = ...,
        health_probe_interval: builtins.str = ...,
        health_probe_timeout: builtins.str = ...,
        health_threshold: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["health_check_path", b"health_check_path", "health_probe_interval", b"health_probe_interval", "health_probe_timeout", b"health_probe_timeout", "health_threshold", b"health_threshold"]) -> None: ...

global___AppConnectionHealthProperties = AppConnectionHealthProperties

@typing.final
class PubsubSubscription(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PUBSUB_NAME_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    DEAD_LETTER_TOPIC_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    pubsub_name: builtins.str
    topic: builtins.str
    dead_letter_topic: builtins.str
    type: global___PubsubSubscriptionType.ValueType
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def rules(self) -> global___PubsubSubscriptionRules: ...
    def __init__(
        self,
        *,
        pubsub_name: builtins.str = ...,
        topic: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        rules: global___PubsubSubscriptionRules | None = ...,
        dead_letter_topic: builtins.str = ...,
        type: global___PubsubSubscriptionType.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["rules", b"rules"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["dead_letter_topic", b"dead_letter_topic", "metadata", b"metadata", "pubsub_name", b"pubsub_name", "rules", b"rules", "topic", b"topic", "type", b"type"]) -> None: ...

global___PubsubSubscription = PubsubSubscription

@typing.final
class PubsubSubscriptionRules(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PubsubSubscriptionRule]: ...
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___PubsubSubscriptionRule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rules", b"rules"]) -> None: ...

global___PubsubSubscriptionRules = PubsubSubscriptionRules

@typing.final
class PubsubSubscriptionRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MATCH_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    match: builtins.str
    path: builtins.str
    def __init__(
        self,
        *,
        match: builtins.str = ...,
        path: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["match", b"match", "path", b"path"]) -> None: ...

global___PubsubSubscriptionRule = PubsubSubscriptionRule

@typing.final
class SetMetadataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    value: builtins.str
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

global___SetMetadataRequest = SetMetadataRequest

@typing.final
class GetConfigurationRequest(google.protobuf.message.Message):
    """GetConfigurationRequest is the message to get a list of key-value configuration from specified configuration store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """Required. The name of configuration store."""
    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. The key of the configuration item to fetch.
        If set, only query for the specified configuration items.
        Empty list means fetch all.
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Optional. The metadata which will be sent to configuration store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        keys: collections.abc.Iterable[builtins.str] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["keys", b"keys", "metadata", b"metadata", "store_name", b"store_name"]) -> None: ...

global___GetConfigurationRequest = GetConfigurationRequest

@typing.final
class GetConfigurationResponse(google.protobuf.message.Message):
    """GetConfigurationResponse is the response conveying the list of configuration values.
    It should be the FULL configuration of specified application which contains all of its configuration items.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ItemsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> dapr.proto.common.v1.common_pb2.ConfigurationItem: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: dapr.proto.common.v1.common_pb2.ConfigurationItem | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, dapr.proto.common.v1.common_pb2.ConfigurationItem]: ...
    def __init__(
        self,
        *,
        items: collections.abc.Mapping[builtins.str, dapr.proto.common.v1.common_pb2.ConfigurationItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["items", b"items"]) -> None: ...

global___GetConfigurationResponse = GetConfigurationResponse

@typing.final
class SubscribeConfigurationRequest(google.protobuf.message.Message):
    """SubscribeConfigurationRequest is the message to get a list of key-value configuration from specified configuration store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of configuration store."""
    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. The key of the configuration item to fetch.
        If set, only query for the specified configuration items.
        Empty list means fetch all.
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to configuration store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        keys: collections.abc.Iterable[builtins.str] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["keys", b"keys", "metadata", b"metadata", "store_name", b"store_name"]) -> None: ...

global___SubscribeConfigurationRequest = SubscribeConfigurationRequest

@typing.final
class UnsubscribeConfigurationRequest(google.protobuf.message.Message):
    """UnSubscribeConfigurationRequest is the message to stop watching the key-value configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of configuration store."""
    id: builtins.str
    """The id to unsubscribe."""
    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "store_name", b"store_name"]) -> None: ...

global___UnsubscribeConfigurationRequest = UnsubscribeConfigurationRequest

@typing.final
class SubscribeConfigurationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ItemsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> dapr.proto.common.v1.common_pb2.ConfigurationItem: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: dapr.proto.common.v1.common_pb2.ConfigurationItem | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Subscribe id, used to stop subscription."""
    @property
    def items(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, dapr.proto.common.v1.common_pb2.ConfigurationItem]:
        """The list of items containing configuration values"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        items: collections.abc.Mapping[builtins.str, dapr.proto.common.v1.common_pb2.ConfigurationItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "items", b"items"]) -> None: ...

global___SubscribeConfigurationResponse = SubscribeConfigurationResponse

@typing.final
class UnsubscribeConfigurationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OK_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    ok: builtins.bool
    message: builtins.str
    def __init__(
        self,
        *,
        ok: builtins.bool = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["message", b"message", "ok", b"ok"]) -> None: ...

global___UnsubscribeConfigurationResponse = UnsubscribeConfigurationResponse

@typing.final
class TryLockRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    LOCK_OWNER_FIELD_NUMBER: builtins.int
    EXPIRY_IN_SECONDS_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """Required. The lock store name,e.g. `redis`."""
    resource_id: builtins.str
    """Required. resource_id is the lock key. e.g. `order_id_111`
    It stands for "which resource I want to protect"
    """
    lock_owner: builtins.str
    """Required. lock_owner indicate the identifier of lock owner.
    You can generate a uuid as lock_owner.For example,in golang:

    req.LockOwner = uuid.New().String()

    This field is per request,not per process,so it is different for each request,
    which aims to prevent multi-thread in the same process trying the same lock concurrently.

    The reason why we don't make it automatically generated is:
    1. If it is automatically generated,there must be a 'my_lock_owner_id' field in the response.
      This name is so weird that we think it is inappropriate to put it into the api spec
    2. If we change the field 'my_lock_owner_id' in the response to 'lock_owner',which means the current lock owner of this lock,
      we find that in some lock services users can't get the current lock owner.Actually users don't need it at all.
    3. When reentrant lock is needed,the existing lock_owner is required to identify client and check "whether this client can reenter this lock".
      So this field in the request shouldn't be removed.
    """
    expiry_in_seconds: builtins.int
    """Required. The time before expiry.The time unit is second."""
    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        resource_id: builtins.str = ...,
        lock_owner: builtins.str = ...,
        expiry_in_seconds: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["expiry_in_seconds", b"expiry_in_seconds", "lock_owner", b"lock_owner", "resource_id", b"resource_id", "store_name", b"store_name"]) -> None: ...

global___TryLockRequest = TryLockRequest

@typing.final
class TryLockResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    success: builtins.bool
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["success", b"success"]) -> None: ...

global___TryLockResponse = TryLockResponse

@typing.final
class UnlockRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    LOCK_OWNER_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    resource_id: builtins.str
    """resource_id is the lock key."""
    lock_owner: builtins.str
    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        resource_id: builtins.str = ...,
        lock_owner: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["lock_owner", b"lock_owner", "resource_id", b"resource_id", "store_name", b"store_name"]) -> None: ...

global___UnlockRequest = UnlockRequest

@typing.final
class UnlockResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UnlockResponse._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SUCCESS: UnlockResponse._Status.ValueType  # 0
        LOCK_DOES_NOT_EXIST: UnlockResponse._Status.ValueType  # 1
        LOCK_BELONGS_TO_OTHERS: UnlockResponse._Status.ValueType  # 2
        INTERNAL_ERROR: UnlockResponse._Status.ValueType  # 3

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    SUCCESS: UnlockResponse.Status.ValueType  # 0
    LOCK_DOES_NOT_EXIST: UnlockResponse.Status.ValueType  # 1
    LOCK_BELONGS_TO_OTHERS: UnlockResponse.Status.ValueType  # 2
    INTERNAL_ERROR: UnlockResponse.Status.ValueType  # 3

    STATUS_FIELD_NUMBER: builtins.int
    status: global___UnlockResponse.Status.ValueType
    def __init__(
        self,
        *,
        status: global___UnlockResponse.Status.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["status", b"status"]) -> None: ...

global___UnlockResponse = UnlockResponse

@typing.final
class SubtleGetKeyRequest(google.protobuf.message.Message):
    """SubtleGetKeyRequest is the request object for SubtleGetKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _KeyFormat:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _KeyFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SubtleGetKeyRequest._KeyFormat.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PEM: SubtleGetKeyRequest._KeyFormat.ValueType  # 0
        """PEM (PKIX) (default)"""
        JSON: SubtleGetKeyRequest._KeyFormat.ValueType  # 1
        """JSON (JSON Web Key) as string"""

    class KeyFormat(_KeyFormat, metaclass=_KeyFormatEnumTypeWrapper): ...
    PEM: SubtleGetKeyRequest.KeyFormat.ValueType  # 0
    """PEM (PKIX) (default)"""
    JSON: SubtleGetKeyRequest.KeyFormat.ValueType  # 1
    """JSON (JSON Web Key) as string"""

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    name: builtins.str
    """Name (or name/version) of the key to use in the key vault"""
    format: global___SubtleGetKeyRequest.KeyFormat.ValueType
    """Response format"""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        name: builtins.str = ...,
        format: global___SubtleGetKeyRequest.KeyFormat.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["component_name", b"component_name", "format", b"format", "name", b"name"]) -> None: ...

global___SubtleGetKeyRequest = SubtleGetKeyRequest

@typing.final
class SubtleGetKeyResponse(google.protobuf.message.Message):
    """SubtleGetKeyResponse is the response for SubtleGetKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    PUBLIC_KEY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name (or name/version) of the key.
    This is returned as response too in case there is a version.
    """
    public_key: builtins.str
    """Public key, encoded in the requested format"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        public_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "public_key", b"public_key"]) -> None: ...

global___SubtleGetKeyResponse = SubtleGetKeyResponse

@typing.final
class SubtleEncryptRequest(google.protobuf.message.Message):
    """SubtleEncryptRequest is the request for SubtleEncryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    PLAINTEXT_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    ASSOCIATED_DATA_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    plaintext: builtins.bytes
    """Message to encrypt."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    nonce: builtins.bytes
    """Nonce / initialization vector.
    Ignored with asymmetric ciphers.
    """
    associated_data: builtins.bytes
    """Associated Data when using AEAD ciphers (optional)."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        plaintext: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        nonce: builtins.bytes = ...,
        associated_data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["algorithm", b"algorithm", "associated_data", b"associated_data", "component_name", b"component_name", "key_name", b"key_name", "nonce", b"nonce", "plaintext", b"plaintext"]) -> None: ...

global___SubtleEncryptRequest = SubtleEncryptRequest

@typing.final
class SubtleEncryptResponse(google.protobuf.message.Message):
    """SubtleEncryptResponse is the response for SubtleEncryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CIPHERTEXT_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    ciphertext: builtins.bytes
    """Encrypted ciphertext."""
    tag: builtins.bytes
    """Authentication tag.
    This is nil when not using an authenticated cipher.
    """
    def __init__(
        self,
        *,
        ciphertext: builtins.bytes = ...,
        tag: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["ciphertext", b"ciphertext", "tag", b"tag"]) -> None: ...

global___SubtleEncryptResponse = SubtleEncryptResponse

@typing.final
class SubtleDecryptRequest(google.protobuf.message.Message):
    """SubtleDecryptRequest is the request for SubtleDecryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    CIPHERTEXT_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    ASSOCIATED_DATA_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    ciphertext: builtins.bytes
    """Message to decrypt."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    nonce: builtins.bytes
    """Nonce / initialization vector.
    Ignored with asymmetric ciphers.
    """
    tag: builtins.bytes
    """Authentication tag.
    This is nil when not using an authenticated cipher.
    """
    associated_data: builtins.bytes
    """Associated Data when using AEAD ciphers (optional)."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        ciphertext: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        nonce: builtins.bytes = ...,
        tag: builtins.bytes = ...,
        associated_data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["algorithm", b"algorithm", "associated_data", b"associated_data", "ciphertext", b"ciphertext", "component_name", b"component_name", "key_name", b"key_name", "nonce", b"nonce", "tag", b"tag"]) -> None: ...

global___SubtleDecryptRequest = SubtleDecryptRequest

@typing.final
class SubtleDecryptResponse(google.protobuf.message.Message):
    """SubtleDecryptResponse is the response for SubtleDecryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAINTEXT_FIELD_NUMBER: builtins.int
    plaintext: builtins.bytes
    """Decrypted plaintext."""
    def __init__(
        self,
        *,
        plaintext: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["plaintext", b"plaintext"]) -> None: ...

global___SubtleDecryptResponse = SubtleDecryptResponse

@typing.final
class SubtleWrapKeyRequest(google.protobuf.message.Message):
    """SubtleWrapKeyRequest is the request for SubtleWrapKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    PLAINTEXT_KEY_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    ASSOCIATED_DATA_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    plaintext_key: builtins.bytes
    """Key to wrap"""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    nonce: builtins.bytes
    """Nonce / initialization vector.
    Ignored with asymmetric ciphers.
    """
    associated_data: builtins.bytes
    """Associated Data when using AEAD ciphers (optional)."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        plaintext_key: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        nonce: builtins.bytes = ...,
        associated_data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["algorithm", b"algorithm", "associated_data", b"associated_data", "component_name", b"component_name", "key_name", b"key_name", "nonce", b"nonce", "plaintext_key", b"plaintext_key"]) -> None: ...

global___SubtleWrapKeyRequest = SubtleWrapKeyRequest

@typing.final
class SubtleWrapKeyResponse(google.protobuf.message.Message):
    """SubtleWrapKeyResponse is the response for SubtleWrapKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WRAPPED_KEY_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    wrapped_key: builtins.bytes
    """Wrapped key."""
    tag: builtins.bytes
    """Authentication tag.
    This is nil when not using an authenticated cipher.
    """
    def __init__(
        self,
        *,
        wrapped_key: builtins.bytes = ...,
        tag: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tag", b"tag", "wrapped_key", b"wrapped_key"]) -> None: ...

global___SubtleWrapKeyResponse = SubtleWrapKeyResponse

@typing.final
class SubtleUnwrapKeyRequest(google.protobuf.message.Message):
    """SubtleUnwrapKeyRequest is the request for SubtleUnwrapKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    WRAPPED_KEY_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    ASSOCIATED_DATA_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    wrapped_key: builtins.bytes
    """Wrapped key."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    nonce: builtins.bytes
    """Nonce / initialization vector.
    Ignored with asymmetric ciphers.
    """
    tag: builtins.bytes
    """Authentication tag.
    This is nil when not using an authenticated cipher.
    """
    associated_data: builtins.bytes
    """Associated Data when using AEAD ciphers (optional)."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        wrapped_key: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        nonce: builtins.bytes = ...,
        tag: builtins.bytes = ...,
        associated_data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["algorithm", b"algorithm", "associated_data", b"associated_data", "component_name", b"component_name", "key_name", b"key_name", "nonce", b"nonce", "tag", b"tag", "wrapped_key", b"wrapped_key"]) -> None: ...

global___SubtleUnwrapKeyRequest = SubtleUnwrapKeyRequest

@typing.final
class SubtleUnwrapKeyResponse(google.protobuf.message.Message):
    """SubtleUnwrapKeyResponse is the response for SubtleUnwrapKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAINTEXT_KEY_FIELD_NUMBER: builtins.int
    plaintext_key: builtins.bytes
    """Key in plaintext"""
    def __init__(
        self,
        *,
        plaintext_key: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["plaintext_key", b"plaintext_key"]) -> None: ...

global___SubtleUnwrapKeyResponse = SubtleUnwrapKeyResponse

@typing.final
class SubtleSignRequest(google.protobuf.message.Message):
    """SubtleSignRequest is the request for SubtleSignAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    digest: builtins.bytes
    """Digest to sign."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        digest: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["algorithm", b"algorithm", "component_name", b"component_name", "digest", b"digest", "key_name", b"key_name"]) -> None: ...

global___SubtleSignRequest = SubtleSignRequest

@typing.final
class SubtleSignResponse(google.protobuf.message.Message):
    """SubtleSignResponse is the response for SubtleSignAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_FIELD_NUMBER: builtins.int
    signature: builtins.bytes
    """The signature that was computed"""
    def __init__(
        self,
        *,
        signature: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signature", b"signature"]) -> None: ...

global___SubtleSignResponse = SubtleSignResponse

@typing.final
class SubtleVerifyRequest(google.protobuf.message.Message):
    """SubtleVerifyRequest is the request for SubtleVerifyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    SIGNATURE_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    digest: builtins.bytes
    """Digest of the message."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    signature: builtins.bytes
    """Signature to verify."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        digest: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        signature: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["algorithm", b"algorithm", "component_name", b"component_name", "digest", b"digest", "key_name", b"key_name", "signature", b"signature"]) -> None: ...

global___SubtleVerifyRequest = SubtleVerifyRequest

@typing.final
class SubtleVerifyResponse(google.protobuf.message.Message):
    """SubtleVerifyResponse is the response for SubtleVerifyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALID_FIELD_NUMBER: builtins.int
    valid: builtins.bool
    """True if the signature is valid."""
    def __init__(
        self,
        *,
        valid: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["valid", b"valid"]) -> None: ...

global___SubtleVerifyResponse = SubtleVerifyResponse

@typing.final
class EncryptRequest(google.protobuf.message.Message):
    """EncryptRequest is the request for EncryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> global___EncryptRequestOptions:
        """Request details. Must be present in the first message only."""

    @property
    def payload(self) -> dapr.proto.common.v1.common_pb2.StreamPayload:
        """Chunk of data of arbitrary size."""

    def __init__(
        self,
        *,
        options: global___EncryptRequestOptions | None = ...,
        payload: dapr.proto.common.v1.common_pb2.StreamPayload | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["options", b"options", "payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["options", b"options", "payload", b"payload"]) -> None: ...

global___EncryptRequest = EncryptRequest

@typing.final
class EncryptRequestOptions(google.protobuf.message.Message):
    """EncryptRequestOptions contains options for the first message in the EncryptAlpha1 request."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    KEY_WRAP_ALGORITHM_FIELD_NUMBER: builtins.int
    DATA_ENCRYPTION_CIPHER_FIELD_NUMBER: builtins.int
    OMIT_DECRYPTION_KEY_NAME_FIELD_NUMBER: builtins.int
    DECRYPTION_KEY_NAME_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component. Required."""
    key_name: builtins.str
    """Name (or name/version) of the key. Required."""
    key_wrap_algorithm: builtins.str
    """Key wrapping algorithm to use. Required.
    Supported options include: A256KW (alias: AES), A128CBC, A192CBC, A256CBC, RSA-OAEP-256 (alias: RSA).
    """
    data_encryption_cipher: builtins.str
    """Cipher used to encrypt data (optional): "aes-gcm" (default) or "chacha20-poly1305" """
    omit_decryption_key_name: builtins.bool
    """If true, the encrypted document does not contain a key reference.
    In that case, calls to the Decrypt method must provide a key reference (name or name/version).
    Defaults to false.
    """
    decryption_key_name: builtins.str
    """Key reference to embed in the encrypted document (name or name/version).
    This is helpful if the reference of the key used to decrypt the document is different from the one used to encrypt it.
    If unset, uses the reference of the key used to encrypt the document (this is the default behavior).
    This option is ignored if omit_decryption_key_name is true.
    """
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        key_name: builtins.str = ...,
        key_wrap_algorithm: builtins.str = ...,
        data_encryption_cipher: builtins.str = ...,
        omit_decryption_key_name: builtins.bool = ...,
        decryption_key_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["component_name", b"component_name", "data_encryption_cipher", b"data_encryption_cipher", "decryption_key_name", b"decryption_key_name", "key_name", b"key_name", "key_wrap_algorithm", b"key_wrap_algorithm", "omit_decryption_key_name", b"omit_decryption_key_name"]) -> None: ...

global___EncryptRequestOptions = EncryptRequestOptions

@typing.final
class EncryptResponse(google.protobuf.message.Message):
    """EncryptResponse is the response for EncryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def payload(self) -> dapr.proto.common.v1.common_pb2.StreamPayload:
        """Chunk of data."""

    def __init__(
        self,
        *,
        payload: dapr.proto.common.v1.common_pb2.StreamPayload | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["payload", b"payload"]) -> None: ...

global___EncryptResponse = EncryptResponse

@typing.final
class DecryptRequest(google.protobuf.message.Message):
    """DecryptRequest is the request for DecryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> global___DecryptRequestOptions:
        """Request details. Must be present in the first message only."""

    @property
    def payload(self) -> dapr.proto.common.v1.common_pb2.StreamPayload:
        """Chunk of data of arbitrary size."""

    def __init__(
        self,
        *,
        options: global___DecryptRequestOptions | None = ...,
        payload: dapr.proto.common.v1.common_pb2.StreamPayload | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["options", b"options", "payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["options", b"options", "payload", b"payload"]) -> None: ...

global___DecryptRequest = DecryptRequest

@typing.final
class DecryptRequestOptions(google.protobuf.message.Message):
    """DecryptRequestOptions contains options for the first message in the DecryptAlpha1 request."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    key_name: builtins.str
    """Name (or name/version) of the key to decrypt the message.
    Overrides any key reference included in the message if present.
    This is required if the message doesn't include a key reference (i.e. was created with omit_decryption_key_name set to true).
    """
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        key_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["component_name", b"component_name", "key_name", b"key_name"]) -> None: ...

global___DecryptRequestOptions = DecryptRequestOptions

@typing.final
class DecryptResponse(google.protobuf.message.Message):
    """DecryptResponse is the response for DecryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def payload(self) -> dapr.proto.common.v1.common_pb2.StreamPayload:
        """Chunk of data."""

    def __init__(
        self,
        *,
        payload: dapr.proto.common.v1.common_pb2.StreamPayload | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["payload", b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["payload", b"payload"]) -> None: ...

global___DecryptResponse = DecryptResponse

@typing.final
class GetWorkflowRequest(google.protobuf.message.Message):
    """GetWorkflowRequest is the request for GetWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to query."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]) -> None: ...

global___GetWorkflowRequest = GetWorkflowRequest

@typing.final
class GetWorkflowResponse(google.protobuf.message.Message):
    """GetWorkflowResponse is the response for GetWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LAST_UPDATED_AT_FIELD_NUMBER: builtins.int
    RUNTIME_STATUS_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance."""
    workflow_name: builtins.str
    """Name of the workflow."""
    runtime_status: builtins.str
    """The current status of the workflow instance, for example, "PENDING", "RUNNING", "SUSPENDED", "COMPLETED", "FAILED", and "TERMINATED"."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which the workflow instance was created."""

    @property
    def last_updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last time at which the workflow instance had its state changed."""

    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional component-specific properties of the workflow instance."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_name: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        runtime_status: builtins.str = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "last_updated_at", b"last_updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "instance_id", b"instance_id", "last_updated_at", b"last_updated_at", "properties", b"properties", "runtime_status", b"runtime_status", "workflow_name", b"workflow_name"]) -> None: ...

global___GetWorkflowResponse = GetWorkflowResponse

@typing.final
class StartWorkflowRequest(google.protobuf.message.Message):
    """StartWorkflowRequest is the request for StartWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class OptionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    WORKFLOW_NAME_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """The ID to assign to the started workflow instance. If empty, a random ID is generated."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    workflow_name: builtins.str
    """Name of the workflow."""
    input: builtins.bytes
    """Input data for the workflow instance."""
    @property
    def options(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional component-specific options for starting the workflow instance."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
        workflow_name: builtins.str = ...,
        options: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        input: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["input", b"input", "instance_id", b"instance_id", "options", b"options", "workflow_component", b"workflow_component", "workflow_name", b"workflow_name"]) -> None: ...

global___StartWorkflowRequest = StartWorkflowRequest

@typing.final
class StartWorkflowResponse(google.protobuf.message.Message):
    """StartWorkflowResponse is the response for StartWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the started workflow instance."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id"]) -> None: ...

global___StartWorkflowResponse = StartWorkflowResponse

@typing.final
class TerminateWorkflowRequest(google.protobuf.message.Message):
    """TerminateWorkflowRequest is the request for TerminateWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to terminate."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]) -> None: ...

global___TerminateWorkflowRequest = TerminateWorkflowRequest

@typing.final
class PauseWorkflowRequest(google.protobuf.message.Message):
    """PauseWorkflowRequest is the request for PauseWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to pause."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]) -> None: ...

global___PauseWorkflowRequest = PauseWorkflowRequest

@typing.final
class ResumeWorkflowRequest(google.protobuf.message.Message):
    """ResumeWorkflowRequest is the request for ResumeWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to resume."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]) -> None: ...

global___ResumeWorkflowRequest = ResumeWorkflowRequest

@typing.final
class RaiseEventWorkflowRequest(google.protobuf.message.Message):
    """RaiseEventWorkflowRequest is the request for RaiseEventWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    EVENT_NAME_FIELD_NUMBER: builtins.int
    EVENT_DATA_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to raise an event for."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    event_name: builtins.str
    """Name of the event."""
    event_data: builtins.bytes
    """Data associated with the event."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
        event_name: builtins.str = ...,
        event_data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["event_data", b"event_data", "event_name", b"event_name", "instance_id", b"instance_id", "workflow_component", b"workflow_component"]) -> None: ...

global___RaiseEventWorkflowRequest = RaiseEventWorkflowRequest

@typing.final
class PurgeWorkflowRequest(google.protobuf.message.Message):
    """PurgeWorkflowRequest is the request for PurgeWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to purge."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]) -> None: ...

global___PurgeWorkflowRequest = PurgeWorkflowRequest

@typing.final
class ShutdownRequest(google.protobuf.message.Message):
    """ShutdownRequest is the request for Shutdown.
    Empty
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ShutdownRequest = ShutdownRequest

@typing.final
class Job(google.protobuf.message.Message):
    """Job is the definition of a job. At least one of schedule or due_time must be
    provided but can also be provided together.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    SCHEDULE_FIELD_NUMBER: builtins.int
    REPEATS_FIELD_NUMBER: builtins.int
    DUE_TIME_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    FAILURE_POLICY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The unique name for the job."""
    schedule: builtins.str
    """schedule is an optional schedule at which the job is to be run.
    Accepts both systemd timer style cron expressions, as well as human
    readable '@' prefixed period strings as defined below.

    Systemd timer style cron accepts 6 fields:
    seconds | minutes | hours | day of month | month        | day of week
    0-59    | 0-59    | 0-23  | 1-31         | 1-12/jan-dec | 0-6/sun-sat

    "0 30 * * * *" - every hour on the half hour
    "0 15 3 * * *" - every day at 03:15

    Period string expressions:
    Entry                  | Description                                  | Equivalent To
    -----                  | -----------                                  | -------------
    @every `<duration>`    | Run every `<duration>` (e.g. '@every 1h30m') | N/A
    @yearly (or @annually) | Run once a year, midnight, Jan. 1st          | 0 0 0 1 1 *
    @monthly               | Run once a month, midnight, first of month   | 0 0 0 1 * *
    @weekly                | Run once a week, midnight on Sunday          | 0 0 0 * * 0
    @daily (or @midnight)  | Run once a day, midnight                     | 0 0 0 * * *
    @hourly                | Run once an hour, beginning of hour          | 0 0 * * * *
    """
    repeats: builtins.int
    """repeats is the optional number of times in which the job should be
    triggered. If not set, the job will run indefinitely or until expiration.
    """
    due_time: builtins.str
    """due_time is the optional time at which the job should be active, or the
    "one shot" time if other scheduling type fields are not provided. Accepts
    a "point in time" string in the format of RFC3339, Go duration string
    (calculated from job creation time), or non-repeating ISO8601.
    """
    ttl: builtins.str
    """ttl is the optional time to live or expiration of the job. Accepts a
    "point in time" string in the format of RFC3339, Go duration string
    (calculated from job creation time), or non-repeating ISO8601.
    """
    @property
    def data(self) -> google.protobuf.any_pb2.Any:
        """payload is the serialized job payload that will be sent to the recipient
        when the job is triggered.
        """

    @property
    def failure_policy(self) -> dapr.proto.common.v1.common_pb2.JobFailurePolicy:
        """failure_policy is the optional policy for handling job failures."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        schedule: builtins.str | None = ...,
        repeats: builtins.int | None = ...,
        due_time: builtins.str | None = ...,
        ttl: builtins.str | None = ...,
        data: google.protobuf.any_pb2.Any | None = ...,
        failure_policy: dapr.proto.common.v1.common_pb2.JobFailurePolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_due_time", b"_due_time", "_failure_policy", b"_failure_policy", "_repeats", b"_repeats", "_schedule", b"_schedule", "_ttl", b"_ttl", "data", b"data", "due_time", b"due_time", "failure_policy", b"failure_policy", "repeats", b"repeats", "schedule", b"schedule", "ttl", b"ttl"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_due_time", b"_due_time", "_failure_policy", b"_failure_policy", "_repeats", b"_repeats", "_schedule", b"_schedule", "_ttl", b"_ttl", "data", b"data", "due_time", b"due_time", "failure_policy", b"failure_policy", "name", b"name", "repeats", b"repeats", "schedule", b"schedule", "ttl", b"ttl"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_due_time", b"_due_time"]) -> typing.Literal["due_time"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_failure_policy", b"_failure_policy"]) -> typing.Literal["failure_policy"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_repeats", b"_repeats"]) -> typing.Literal["repeats"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_schedule", b"_schedule"]) -> typing.Literal["schedule"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ttl", b"_ttl"]) -> typing.Literal["ttl"] | None: ...

global___Job = Job

@typing.final
class ScheduleJobRequest(google.protobuf.message.Message):
    """ScheduleJobRequest is the message to create/schedule the job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_FIELD_NUMBER: builtins.int
    OVERWRITE_FIELD_NUMBER: builtins.int
    overwrite: builtins.bool
    """If true, allows this job to overwrite an existing job with the same name."""
    @property
    def job(self) -> global___Job:
        """The job details."""

    def __init__(
        self,
        *,
        job: global___Job | None = ...,
        overwrite: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["job", b"job"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["job", b"job", "overwrite", b"overwrite"]) -> None: ...

global___ScheduleJobRequest = ScheduleJobRequest

@typing.final
class ScheduleJobResponse(google.protobuf.message.Message):
    """ScheduleJobResponse is the message response to create/schedule the job.
    Empty
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ScheduleJobResponse = ScheduleJobResponse

@typing.final
class GetJobRequest(google.protobuf.message.Message):
    """GetJobRequest is the message to retrieve a job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the job."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name"]) -> None: ...

global___GetJobRequest = GetJobRequest

@typing.final
class GetJobResponse(google.protobuf.message.Message):
    """GetJobResponse is the message's response for a job retrieved."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_FIELD_NUMBER: builtins.int
    @property
    def job(self) -> global___Job:
        """The job details."""

    def __init__(
        self,
        *,
        job: global___Job | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["job", b"job"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["job", b"job"]) -> None: ...

global___GetJobResponse = GetJobResponse

@typing.final
class DeleteJobRequest(google.protobuf.message.Message):
    """DeleteJobRequest is the message to delete the job by name."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the job."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name"]) -> None: ...

global___DeleteJobRequest = DeleteJobRequest

@typing.final
class DeleteJobResponse(google.protobuf.message.Message):
    """DeleteJobResponse is the message response to delete the job by name.
    Empty
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteJobResponse = DeleteJobResponse

@typing.final
class ConversationRequest(google.protobuf.message.Message):
    """ConversationRequest is the request object for Conversation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.any_pb2.Any: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.any_pb2.Any | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CONTEXTID_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    SCRUBPII_FIELD_NUMBER: builtins.int
    TEMPERATURE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of Conversation component"""
    contextID: builtins.str
    """The ID of an existing chat (like in ChatGPT)"""
    scrubPII: builtins.bool
    """Scrub PII data that comes back from the LLM"""
    temperature: builtins.float
    """Temperature for the LLM to optimize for creativity or predictability"""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationInput]:
        """Inputs for the conversation, support multiple input in one time."""

    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.any_pb2.Any]:
        """Parameters for all custom fields."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata passing to conversation components."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        contextID: builtins.str | None = ...,
        inputs: collections.abc.Iterable[global___ConversationInput] | None = ...,
        parameters: collections.abc.Mapping[builtins.str, google.protobuf.any_pb2.Any] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        scrubPII: builtins.bool | None = ...,
        temperature: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_contextID", b"_contextID", "_scrubPII", b"_scrubPII", "_temperature", b"_temperature", "contextID", b"contextID", "scrubPII", b"scrubPII", "temperature", b"temperature"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_contextID", b"_contextID", "_scrubPII", b"_scrubPII", "_temperature", b"_temperature", "contextID", b"contextID", "inputs", b"inputs", "metadata", b"metadata", "name", b"name", "parameters", b"parameters", "scrubPII", b"scrubPII", "temperature", b"temperature"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_contextID", b"_contextID"]) -> typing.Literal["contextID"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_scrubPII", b"_scrubPII"]) -> typing.Literal["scrubPII"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_temperature", b"_temperature"]) -> typing.Literal["temperature"] | None: ...

global___ConversationRequest = ConversationRequest

@typing.final
class ConversationRequestAlpha2(google.protobuf.message.Message):
    """ConversationRequestAlpha2 is the new request object for Conversation.
    Many of these fields are inspired by openai.ChatCompletionNewParams
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2106
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.any_pb2.Any: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.any_pb2.Any | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CONTEXT_ID_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    SCRUB_PII_FIELD_NUMBER: builtins.int
    TEMPERATURE_FIELD_NUMBER: builtins.int
    TOOLS_FIELD_NUMBER: builtins.int
    TOOL_CHOICE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of Conversation component"""
    context_id: builtins.str
    """The ID of an existing chat (like in ChatGPT)"""
    scrub_pii: builtins.bool
    """Scrub PII data that comes back from the LLM"""
    temperature: builtins.float
    """Temperature for the LLM to optimize for creativity or predictability"""
    tool_choice: builtins.str
    """Controls which (if any) tool is called by the model. 
    `none` means the model will not call any tool and instead generates a message. 
    `auto` means the model can pick between generating a message or calling one or more tools.
    Alternatively, a specific tool name may be used here, and casing/syntax must match on tool name.
    `none` is the default when no tools are present.
    `auto` is the default if tools are present.
    `required` requires one or more functions to be called.
    ref: https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1976
    ref: https://python.langchain.com/docs/how_to/tool_choice/
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationInputAlpha2]:
        """Inputs for the conversation, support multiple input in one time.
        This is the revamped conversation inputs better matching openai.
        """

    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.any_pb2.Any]:
        """Parameters for all custom fields."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata passing to conversation components."""

    @property
    def tools(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationTools]:
        """Tools register the tools available to be used by the LLM during the conversation.
        These are sent on a per request basis.
        The tools available during the first round of the conversation
        may be different than tools specified later on.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        context_id: builtins.str | None = ...,
        inputs: collections.abc.Iterable[global___ConversationInputAlpha2] | None = ...,
        parameters: collections.abc.Mapping[builtins.str, google.protobuf.any_pb2.Any] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        scrub_pii: builtins.bool | None = ...,
        temperature: builtins.float | None = ...,
        tools: collections.abc.Iterable[global___ConversationTools] | None = ...,
        tool_choice: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_context_id", b"_context_id", "_scrub_pii", b"_scrub_pii", "_temperature", b"_temperature", "_tool_choice", b"_tool_choice", "context_id", b"context_id", "scrub_pii", b"scrub_pii", "temperature", b"temperature", "tool_choice", b"tool_choice"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_context_id", b"_context_id", "_scrub_pii", b"_scrub_pii", "_temperature", b"_temperature", "_tool_choice", b"_tool_choice", "context_id", b"context_id", "inputs", b"inputs", "metadata", b"metadata", "name", b"name", "parameters", b"parameters", "scrub_pii", b"scrub_pii", "temperature", b"temperature", "tool_choice", b"tool_choice", "tools", b"tools"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_context_id", b"_context_id"]) -> typing.Literal["context_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_scrub_pii", b"_scrub_pii"]) -> typing.Literal["scrub_pii"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_temperature", b"_temperature"]) -> typing.Literal["temperature"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_tool_choice", b"_tool_choice"]) -> typing.Literal["tool_choice"] | None: ...

global___ConversationRequestAlpha2 = ConversationRequestAlpha2

@typing.final
class ConversationInput(google.protobuf.message.Message):
    """maintained for backwards compatibility"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    SCRUBPII_FIELD_NUMBER: builtins.int
    content: builtins.str
    """The content to send to the llm"""
    role: builtins.str
    """The role to set for the message"""
    scrubPII: builtins.bool
    """Scrub PII data that goes into the LLM"""
    def __init__(
        self,
        *,
        content: builtins.str = ...,
        role: builtins.str | None = ...,
        scrubPII: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_role", b"_role", "_scrubPII", b"_scrubPII", "role", b"role", "scrubPII", b"scrubPII"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_role", b"_role", "_scrubPII", b"_scrubPII", "content", b"content", "role", b"role", "scrubPII", b"scrubPII"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_role", b"_role"]) -> typing.Literal["role"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_scrubPII", b"_scrubPII"]) -> typing.Literal["scrubPII"] | None: ...

global___ConversationInput = ConversationInput

@typing.final
class ConversationInputAlpha2(google.protobuf.message.Message):
    """directly inspired by openai.ChatCompletionNewParams
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2106
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGES_FIELD_NUMBER: builtins.int
    SCRUB_PII_FIELD_NUMBER: builtins.int
    scrub_pii: builtins.bool
    """Scrub PII data that goes into the LLM"""
    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationMessage]:
        """The content to send to the llm"""

    def __init__(
        self,
        *,
        messages: collections.abc.Iterable[global___ConversationMessage] | None = ...,
        scrub_pii: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_scrub_pii", b"_scrub_pii", "scrub_pii", b"scrub_pii"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_scrub_pii", b"_scrub_pii", "messages", b"messages", "scrub_pii", b"scrub_pii"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_scrub_pii", b"_scrub_pii"]) -> typing.Literal["scrub_pii"] | None: ...

global___ConversationInputAlpha2 = ConversationInputAlpha2

@typing.final
class ConversationMessage(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionMessageParamUnion
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1449
    The role field is inherent to the type of ConversationMessage,
    and is propagated in the backend according to the underlying LLM provider type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OF_DEVELOPER_FIELD_NUMBER: builtins.int
    OF_SYSTEM_FIELD_NUMBER: builtins.int
    OF_USER_FIELD_NUMBER: builtins.int
    OF_ASSISTANT_FIELD_NUMBER: builtins.int
    OF_TOOL_FIELD_NUMBER: builtins.int
    @property
    def of_developer(self) -> global___ConversationMessageOfDeveloper: ...
    @property
    def of_system(self) -> global___ConversationMessageOfSystem: ...
    @property
    def of_user(self) -> global___ConversationMessageOfUser: ...
    @property
    def of_assistant(self) -> global___ConversationMessageOfAssistant: ...
    @property
    def of_tool(self) -> global___ConversationMessageOfTool:
        """Note: there could be a ConversationMessageOfFunction type here too, 
        but that is deprecated in openai, so we will not support this.
        """

    def __init__(
        self,
        *,
        of_developer: global___ConversationMessageOfDeveloper | None = ...,
        of_system: global___ConversationMessageOfSystem | None = ...,
        of_user: global___ConversationMessageOfUser | None = ...,
        of_assistant: global___ConversationMessageOfAssistant | None = ...,
        of_tool: global___ConversationMessageOfTool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["message_types", b"message_types", "of_assistant", b"of_assistant", "of_developer", b"of_developer", "of_system", b"of_system", "of_tool", b"of_tool", "of_user", b"of_user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["message_types", b"message_types", "of_assistant", b"of_assistant", "of_developer", b"of_developer", "of_system", b"of_system", "of_tool", b"of_tool", "of_user", b"of_user"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["message_types", b"message_types"]) -> typing.Literal["of_developer", "of_system", "of_user", "of_assistant", "of_tool"] | None: ...

global___ConversationMessage = ConversationMessage

@typing.final
class ConversationMessageOfDeveloper(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionDeveloperMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1130
    ConversationMessageOfDeveloper is intended to be the contents of a conversation message,
    as the role of a developer.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the participant in the message."""
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationMessageContent]: ...
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        content: collections.abc.Iterable[global___ConversationMessageContent] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_name", b"_name", "name", b"name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_name", b"_name", "content", b"content", "name", b"name"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_name", b"_name"]) -> typing.Literal["name"] | None: ...

global___ConversationMessageOfDeveloper = ConversationMessageOfDeveloper

@typing.final
class ConversationMessageOfSystem(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionSystemMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1842
    ConversationMessageOfSystem is intended to be the contents of a conversation message,
    as the role of a system.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationMessageContent]: ...
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        content: collections.abc.Iterable[global___ConversationMessageContent] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_name", b"_name", "name", b"name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_name", b"_name", "content", b"content", "name", b"name"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_name", b"_name"]) -> typing.Literal["name"] | None: ...

global___ConversationMessageOfSystem = ConversationMessageOfSystem

@typing.final
class ConversationMessageOfUser(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionUserMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2060C6-L2060C36
    ConversationMessageOfUser is intended to be the contents of a conversation message,
    as the role of an end user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationMessageContent]: ...
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        content: collections.abc.Iterable[global___ConversationMessageContent] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_name", b"_name", "name", b"name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_name", b"_name", "content", b"content", "name", b"name"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_name", b"_name"]) -> typing.Literal["name"] | None: ...

global___ConversationMessageOfUser = ConversationMessageOfUser

@typing.final
class ConversationMessageOfAssistant(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionAssistantMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L310
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2060C6-L2060C36
    ConversationMessageOfAssistant is intended to be the contents of a conversation message,
    as the role of an assistant.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    TOOL_CALLS_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationMessageContent]:
        """TODO: there is an audio field here to bring in when the time comes 1.17 or later."""

    @property
    def tool_calls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationToolCalls]:
        """Tool calls generated by the model, such as function calls for the client to then make."""

    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        content: collections.abc.Iterable[global___ConversationMessageContent] | None = ...,
        tool_calls: collections.abc.Iterable[global___ConversationToolCalls] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_name", b"_name", "name", b"name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_name", b"_name", "content", b"content", "name", b"name", "tool_calls", b"tool_calls"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_name", b"_name"]) -> typing.Literal["name"] | None: ...

global___ConversationMessageOfAssistant = ConversationMessageOfAssistant

@typing.final
class ConversationMessageOfTool(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionToolMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2011
    ConversationMessageOfTool is intended to be the contents of a conversation message,
    as the role of a tool.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOOL_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    tool_id: builtins.str
    """Tool ID is helpful for tracking tool history"""
    name: builtins.str
    """Name of tool associated with the message"""
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationMessageContent]: ...
    def __init__(
        self,
        *,
        tool_id: builtins.str | None = ...,
        name: builtins.str = ...,
        content: collections.abc.Iterable[global___ConversationMessageContent] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_tool_id", b"_tool_id", "tool_id", b"tool_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_tool_id", b"_tool_id", "content", b"content", "name", b"name", "tool_id", b"tool_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_tool_id", b"_tool_id"]) -> typing.Literal["tool_id"] | None: ...

global___ConversationMessageOfTool = ConversationMessageOfTool

@typing.final
class ConversationToolCalls(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionMessageToolCallParam and openai.ChatCompletionMessageToolCall
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1669
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1611
    ConversationToolCalls is the tool call request sent from the llm to the client to then call to execute.
    This assumes that in our api if a client makes a request that would get a tool call response from the llm,
    that this client can also have the tool handy itself to execute it.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    FUNCTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def function(self) -> global___ConversationToolCallsOfFunction: ...
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        function: global___ConversationToolCallsOfFunction | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_id", b"_id", "function", b"function", "id", b"id", "tool_types", b"tool_types"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_id", b"_id", "function", b"function", "id", b"id", "tool_types", b"tool_types"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_id", b"_id"]) -> typing.Literal["id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["tool_types", b"tool_types"]) -> typing.Literal["function"] | None: ...

global___ConversationToolCalls = ConversationToolCalls

@typing.final
class ConversationToolCallsOfFunction(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionMessageToolCallFunctionParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1692
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    arguments: builtins.str
    """The arguments to call the function with, as generated by the model in JSON
    format. Note that the model does not always generate valid JSON, and may
    hallucinate parameters not defined by your function schema. Validate the
    arguments in your code before calling your function.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        arguments: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["arguments", b"arguments", "name", b"name"]) -> None: ...

global___ConversationToolCallsOfFunction = ConversationToolCallsOfFunction

@typing.final
class ConversationMessageContent(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionContentPartTextParam & openai.ChatCompletionDeveloperMessageParamContentUnion
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1084
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1154C6-L1154C53
    Note: openai has this message be either a message of string or message of array type,
    so instead of this, we support that in one message type instead.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    text: builtins.str
    def __init__(
        self,
        *,
        text: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["text", b"text"]) -> None: ...

global___ConversationMessageContent = ConversationMessageContent

@typing.final
class ConversationResult(google.protobuf.message.Message):
    """ConversationResult is the result for one input."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.any_pb2.Any: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.any_pb2.Any | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    RESULT_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    result: builtins.str
    """Result for the one conversation input."""
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.any_pb2.Any]:
        """Parameters for all custom fields."""

    def __init__(
        self,
        *,
        result: builtins.str = ...,
        parameters: collections.abc.Mapping[builtins.str, google.protobuf.any_pb2.Any] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["parameters", b"parameters", "result", b"result"]) -> None: ...

global___ConversationResult = ConversationResult

@typing.final
class ConversationResultAlpha2(google.protobuf.message.Message):
    """inspired by openai.ChatCompletion
    ConversationResultAlpha2 is the result for one input.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHOICES_FIELD_NUMBER: builtins.int
    @property
    def choices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationResultChoices]:
        """Result for the conversation input."""

    def __init__(
        self,
        *,
        choices: collections.abc.Iterable[global___ConversationResultChoices] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["choices", b"choices"]) -> None: ...

global___ConversationResultAlpha2 = ConversationResultAlpha2

@typing.final
class ConversationResultChoices(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionChoice
    based on https://github.com/openai/openai-go/blob/main/chatcompletion.go#L226
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FINISH_REASON_FIELD_NUMBER: builtins.int
    INDEX_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    finish_reason: builtins.str
    """The reason the model stopped generating tokens. This will be `stop` if the model
    hit a natural stop point or a provided stop sequence, `length` if the maximum
    number of tokens specified in the request was reached, `content_filter` if
    content was omitted due to a flag from our content filters, `tool_calls` if the
    model called a tool.
    Any of "stop", "length", "tool_calls", "content_filter".
    """
    index: builtins.int
    """The index of the choice in the list of choices."""
    @property
    def message(self) -> global___ConversationResultMessage: ...
    def __init__(
        self,
        *,
        finish_reason: builtins.str = ...,
        index: builtins.int = ...,
        message: global___ConversationResultMessage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["finish_reason", b"finish_reason", "index", b"index", "message", b"message"]) -> None: ...

global___ConversationResultChoices = ConversationResultChoices

@typing.final
class ConversationResultMessage(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionMessage
    based on https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1218C6-L1218C27
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    TOOL_CALLS_FIELD_NUMBER: builtins.int
    content: builtins.str
    """The contents of the message."""
    @property
    def tool_calls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationToolCalls]:
        """The tool calls generated by the model."""

    def __init__(
        self,
        *,
        content: builtins.str = ...,
        tool_calls: collections.abc.Iterable[global___ConversationToolCalls] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "tool_calls", b"tool_calls"]) -> None: ...

global___ConversationResultMessage = ConversationResultMessage

@typing.final
class ConversationResponse(google.protobuf.message.Message):
    """ConversationResponse is the response for Conversation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTEXTID_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    contextID: builtins.str
    """The ID of an existing chat (like in ChatGPT)"""
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationResult]:
        """An array of results."""

    def __init__(
        self,
        *,
        contextID: builtins.str | None = ...,
        outputs: collections.abc.Iterable[global___ConversationResult] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_contextID", b"_contextID", "contextID", b"contextID"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_contextID", b"_contextID", "contextID", b"contextID", "outputs", b"outputs"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_contextID", b"_contextID"]) -> typing.Literal["contextID"] | None: ...

global___ConversationResponse = ConversationResponse

@typing.final
class ConversationResponseAlpha2(google.protobuf.message.Message):
    """ConversationResponseAlpha2 is the Alpha2 response for Conversation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTEXT_ID_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    context_id: builtins.str
    """The ID of an existing chat (like in ChatGPT)"""
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConversationResultAlpha2]:
        """An array of results."""

    def __init__(
        self,
        *,
        context_id: builtins.str | None = ...,
        outputs: collections.abc.Iterable[global___ConversationResultAlpha2] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_context_id", b"_context_id", "context_id", b"context_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_context_id", b"_context_id", "context_id", b"context_id", "outputs", b"outputs"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_context_id", b"_context_id"]) -> typing.Literal["context_id"] | None: ...

global___ConversationResponseAlpha2 = ConversationResponseAlpha2

@typing.final
class ConversationTools(google.protobuf.message.Message):
    """ConversationTools are the typed tools available to be called.
    inspired by openai.ChatCompletionToolParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1950
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_FIELD_NUMBER: builtins.int
    @property
    def function(self) -> global___ConversationToolsFunction: ...
    def __init__(
        self,
        *,
        function: global___ConversationToolsFunction | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["function", b"function", "tool_types", b"tool_types"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["function", b"function", "tool_types", b"tool_types"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["tool_types", b"tool_types"]) -> typing.Literal["function"] | None: ...

global___ConversationTools = ConversationTools

@typing.final
class ConversationToolsFunction(google.protobuf.message.Message):
    """ConversationToolsFunction is the main tool type to be used in a conversation.
    inspired by openai.FunctionDefinitionParam
    https://pkg.go.dev/github.com/openai/openai-go/shared#FunctionDefinitionParam
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the function to be called."""
    description: builtins.str
    """A description of what the function does, 
    used by the model to choose when and how to call the function.
    """
    @property
    def parameters(self) -> google.protobuf.struct_pb2.Struct:
        """The parameters the functions accepts, described as a JSON Schema object. 
        See the [guide](https://platform.openai.com/docs/guides/function-calling) for examples,
        and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format.	
        Omitting `parameters` defines a function with an empty parameter list.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str | None = ...,
        parameters: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_description", b"_description", "description", b"description", "parameters", b"parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_description", b"_description", "description", b"description", "name", b"name", "parameters", b"parameters"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_description", b"_description"]) -> typing.Literal["description"] | None: ...

global___ConversationToolsFunction = ConversationToolsFunction
