# Changelog (Auto Generated by Claude Code)


<details>
<summary>Click to expand v1.10.2 details</summary>

## [1.10.2] - 2025-10-17

### Added
- **AgentRunner Evaluation Method**: Complete evaluation workflow implementation in AgentRunner class
  - New `evaluate()` method for seamless ScoreModel integration with automatic task execution and scoring
  - Type conversion handling for processer data (List[Dict] to String format) for ScoreModel compatibility
  - Optional result display with `is_display` parameter for immediate feedback and debugging
  - Automatic conversation history extraction and formatting for evaluation purposes
  - Direct parameter passing and type-safe integration between AgentRunner and ScoreModel

- **Enhanced Evaluation Integration**: Streamlined ScoreModel connection with agent execution
  - Automatic task execution and result processing in a single method call
  - Built-in error handling and validation throughout the evaluation pipeline
  - Comprehensive fallback mechanisms for robust evaluation operations
  - Simplified evaluation workflow with reduced boilerplate code

### Changed
- **Developer Experience**: Improved evaluation workflow simplicity and usability
  - Single `evaluate()` call replaces multi-step evaluation process
  - Automatic handling of type conversions between AgentRunner and ScoreModel components
  - Optional display functionality for real-time monitoring and debugging
  - Enhanced error reporting and validation for evaluation scenarios

- **Type Compatibility**: Enhanced data flow between evaluation components
  - Robust integration between different data structures (List[Dict] to String conversion)
  - Preserved conversation structure and context during type conversion
  - Maintained data integrity throughout the evaluation pipeline
  - Type-safe parameter handling for reliable evaluation workflows

### Technical
- **Code Architecture**: Enhanced AgentRunner with complete evaluation capabilities
  - Clean separation between task execution and evaluation logic
  - Modular design allowing for easy customization and extension
  - Comprehensive type annotations and documentation for evaluation methods
  - Improved error handling and validation throughout the evaluation framework

- **Backward Compatibility**: Maintained full compatibility with existing evaluation workflows
  - All existing AgentRunner functionality remains unchanged
  - New evaluate() method is additive without disrupting existing code
  - Seamless integration with existing ScoreModel evaluation framework
  - Zero impact on current evaluation processes and tools

</details>

<details>
<summary>Click to expand v1.10.1 details</summary>

## [1.10.1] - 2025-10-16

### Added
- **AgentRunner Class**: New comprehensive agent management system for simplified LLM evaluation workflows
  - OpenAI-compatible API integration with support for multiple providers (OpenAI, DeepSeek, etc.)
  - `get_processer()` static method for automatic conversation history extraction from agent results
  - `get_final_result()` static method for extracting final answers from agent outputs
  - Built-in error handling and graceful fallback mechanisms for robust operation
  - Full type annotations and comprehensive documentation with practical examples

- **Comprehensive Testing Framework**: Complete test suite for AgentRunner functionality validation
  - Mock-based testing system for reliable validation without API dependencies
  - Real API testing with automatic fallback to mock tests when credentials unavailable
  - Comprehensive error handling validation and conversation structure verification
  - Integrity checks for method outputs and data format validation
  - Complete test coverage in `tar.py` with both mock and real API scenarios

- **Enhanced Documentation**: Updated evaluation guide with AgentRunner integration examples
  - Step-by-step AgentRunner usage instructions with practical Stata analysis examples
  - Complete code examples for real-world evaluation scenarios including auto dataset analysis
  - Batch evaluation workflows for processing multiple tasks efficiently
  - Custom evaluation criteria and metrics implementation examples
  - Environment setup guides for different API providers (OpenAI, DeepSeek)

### Changed
- **Module Organization**: Enhanced evaluate module structure with better component integration
  - AgentRunner now properly exported in `evaluate.__init__.py` for direct imports
  - Cleaner module structure with improved separation of concerns
  - Better discoverability of evaluation components and enhanced import experience
  - Updated `Evaluation.md` documentation with comprehensive AgentRunner usage examples

- **Developer Experience**: Streamlined evaluation workflow with simplified task execution
  - One-click conversation extraction and result processing through AgentRunner methods
  - Reduced boilerplate code for common evaluation scenarios and use cases
  - Better error messages and debugging information for improved development experience
  - Enhanced integration between agents and evaluation tools

- **Evaluation Framework**: Improved evaluation workflow with better tool integration
  - Seamless integration between AgentRunner and existing ScoreModel functionality
  - Enhanced support for OpenAI Agents result processing and extraction
  - Better handling of complex conversation structures with multi-turn interactions
  - Improved role detection and content extraction for diverse agent response formats

### Fixed
- **Conversation Processing**: Enhanced handling of complex conversation structures in agent outputs
  - Better support for multi-turn conversations with tool interactions and role switching
  - Enhanced role detection and content extraction from various agent response formats
  - More robust parsing of agent response data with improved error resilience
  - Better handling of edge cases in conversation structure processing

- **Testing Reliability**: Enhanced test stability and comprehensive error handling
  - Improved mock data structure for more realistic testing scenarios
  - Better exception handling in test environments with detailed error reporting
  - More comprehensive validation of method outputs and data integrity
  - Enhanced test reliability through better error recovery mechanisms

### Technical
- **Dependencies**: No new dependencies added for AgentRunner functionality
  - AgentRunner uses existing project dependencies (openai-agents, openai, langchain)
  - Lightweight implementation with minimal performance impact
  - Backward compatibility maintained for all existing features and workflows

- **Code Architecture**: Enhanced evaluation module with improved component integration
  - Clean separation between agent execution and result processing logic
  - Modular design allows for easy extension and customization
  - Standardized evaluation criteria based on professional statistical standards
  - Improved error handling and fallback mechanisms throughout the framework

</details>

<details>
<summary>Click to expand v1.10.0 details</summary>

## [1.10.0] - 2025-10-14

### Added
- **LLM Evaluation Module Framework**: Comprehensive evaluation system for Large Language Model performance assessment
  - New `evaluate` package with complete module structure (`src/stata_mcp/evaluate/`)
  - `_model.py` providing structured assessment framework and evaluation criteria
  - `advice.py` for evaluation advice generation and result analysis
  - `score_it.py` for automated LLM performance scoring and assessment
  - Full type annotations and comprehensive documentation for evaluation use

- **ScoreModel Evaluation System**: Automated LLM performance assessment framework
  - Task completion accuracy evaluation based on reference answers
  - Response quality assessment against expected outcomes
  - Process analysis for LLM reasoning quality evaluation
  - Historical message processing for context assessment
  - Quantitative metrics for model comparison and benchmarking

- **Structured Evaluation Framework**: Systematic approach to LLM performance evaluation
  - Task definition and reference answer management system
  - Process evaluation for analyzing LLM reasoning chains
  - Final answer scoring and validation mechanisms
  - Configurable evaluation parameters for different use cases
  - Extensible framework for custom evaluation criteria

- **Research Assessment Tools**: Built-in evaluation capabilities for AI research workflows
  - Standardized evaluation methodology for reproducible research
  - Benchmarking framework for model performance comparison
  - Reference answer management for accuracy assessment
  - Process analysis capabilities for reasoning evaluation

### Changed
- **Enhanced Research Capabilities**: Integrated LLM evaluation into existing Stata-MCP functionality
  - Evaluation framework works seamlessly with current research workflows
  - Optional enhancement for AI performance assessment without disrupting existing functionality
  - Flexible configuration for different evaluation scenarios and research requirements
  - Multi-language support for evaluation feedback and assessment results

- **Documentation Updates**: Enhanced user documentation with LLM evaluation features
  - Updated main README with LLM evaluation module announcement
  - Synchronized Chinese README with new evaluation capabilities
  - Added Evaluation.md documentation for LLM assessment workflows
  - Enhanced quick start guides with evaluation setup examples

### Technical
- **Code Architecture**: New evaluation module with clean separation of concerns
  - Modular design allows for easy extension and customization
  - Standardized evaluation criteria based on professional statistical standards
  - Configurable scoring parameters for different assessment requirements
  - Professional statistical standards integration for academic use

- **Dependencies**: No new dependencies added for evaluation functionality
  - Evaluation module uses existing project dependencies
  - Lightweight implementation with minimal performance impact
  - Backward compatibility maintained for all existing features

</details>

<details>
<summary>Click to expand v1.9.1 details</summary>

## [1.9.1] - 2025-10-12

### Removed
- **WebUI Module**: Completely removed Flask-based web interface and all related functionality
  - Removed Flask dependency and all web-related dependencies from `pyproject.toml`
  - Deleted webui module (`src/stata_mcp/webui/`) including templates, static assets, and utilities
  - Removed `--webui` CLI argument and related webui startup functionality
  - Deleted `WEBUI.md` documentation file

- **Config Module**: Discontinued TOML-based configuration system
  - Removed config module (`src/stata_mcp/config/`) and all configuration management logic
  - Deleted `Configuration.md` documentation file
  - Removed `example.toml` configuration template
  - Simplified project to use environment variable-based configuration only

### Changed
- **Project Structure**: Major simplification to focus on core MCP functionality
  - Streamlined project structure by removing 17 files and 2299 lines of code
  - Reduced dependency footprint for faster installation and smaller package size
  - Improved startup performance by eliminating complex configuration loading
  - Enhanced code maintainability through reduced complexity

- **Dependency Management**: Optimized dependency list for lightweight installation
  - Removed Flask and web-related dependencies
  - Commented out optional jupyter-related dependencies not currently used
  - Maintained all core dependencies for Stata-MCP functionality
  - Updated `uv.lock` to reflect new dependency structure

- **Configuration Simplification**: Streamlined configuration approach
  - Now relies solely on environment variables for configuration
  - Maintained dotenv loading for essential settings
  - Removed complex TOML parsing and validation logic
  - Better defaults for improved out-of-the-box experience

### Technical
- **Code Quality**: Improved maintainability and focus
  - Reduced attack surface by removing web interface components
  - Fewer potential points of failure in initialization
  - Cleaner separation of concerns between CLI and core functionality
  - Better alignment with MCP protocol's primary use case

- **Performance**: Enhanced startup and runtime performance
  - Faster initialization due to reduced module loading
  - Lower memory footprint from fewer loaded dependencies
  - Simplified error handling paths
  - Improved reliability through reduced complexity

### Migration Notes
- **WebUI Users**: Web interface no longer available - use CLI interface instead
- **Config File Users**: TOML configuration no longer supported - migrate to environment variables
- **Minimal Impact**: Most users unaffected as they were already using CLI-based workflow
- **Simple Migration**: Straightforward migration path for affected users

</details>

<details>
<summary>Click to expand v1.9.0 details</summary>

## [1.9.0] - 2025-10-11

### Added
- **Agent as Tool Framework**: Revolutionary multi-agent workflow support for Stata analysis
  - New `StataAgent` class with comprehensive ReAct (Reasoning-Action-Observation) framework
  - Professional Stata Data Analysis Expert role with economic research assistant capabilities
  - Seamless integration as a tool within other AI agents for complex workflows
  - Default comprehensive instructions covering data understanding, code generation, execution, and results interpretation
  - Configurable tool descriptions with clear capabilities and input/output specifications

- **Multi-Model Provider Support**: Enhanced compatibility with various LLM providers
  - Extended type hints to support `OpenAIChatCompletionsModel | Model` union types
  - `set_model()` utility function for easy configuration of alternative providers (DeepSeek, etc.)
  - Native support for OpenAI ChatCompletionsModel with fallback to generic Model interface
  - Improved IDE support and code completion through enhanced type annotations

- **Comprehensive Documentation Suite**: Complete bilingual documentation for Agent as Tool functionality
  - Detailed `agent_as_tool.md` guide with practical examples and use cases
  - Quick start guide for basic usage and advanced configuration examples
  - Integration patterns with existing agent frameworks (OpenAI Agents, LangChain)
  - Multi-provider setup examples with DeepSeek and other OpenAI-compatible models

- **Enhanced README Integration**: Improved user onboarding with Agent as Tool examples
  - New "Agent as Tool" section in main README with working code examples
  - Synchronized Chinese README with all new features and examples
  - Updated news sections highlighting new multi-agent capabilities
  - Clear navigation to detailed documentation and quick start guides

### Changed
- **Agent Architecture Enhancements**: Modular and flexible agent design
  - Clean separation between agent logic and tool integration through `as_tool` property
  - Flexible MCP server configuration with environment variable support
  - Enhanced tracing control for performance optimization and debugging
  - Configurable agent behavior through custom instructions, models, and tools

- **Developer Experience Improvements**: Enhanced usability and flexibility
  - Support for custom agent names, instructions, and tool descriptions
  - Adjustable `max_turns` parameter for complex analysis tasks
  - Configurable `DISABLE_TRACING` for performance optimization
  - Better error handling and connection management for MCP servers

- **Type Safety and IDE Support**: Improved development experience
  - Enhanced type annotations throughout the agent framework
  - Support for union types (`OpenAIChatCompletionsModel | Model`)
  - Better IDE support with improved code completion and error detection
  - Reduced runtime errors through comprehensive type checking

### Technical
- **New Dependencies**: Added `agents` library for Agent as Tool functionality
  - Support for OpenAI Agents framework with seamless integration
  - Enhanced MCP server configuration and management
  - Improved error handling and connection stability

- **Code Organization**: Enhanced module structure for agent functionality
  - New `agent_as_tool` module with `StataAgent` and `set_model` utilities
  - Clean separation of concerns between agent logic and tool integration
  - Improved maintainability and extensibility for future agent features

- **Configuration Flexibility**: Enhanced customization options
  - Environment variable support for Stata CLI configuration
  - Customizable agent instructions and tool descriptions
  - Flexible model provider configuration with easy switching between providers

</details>

<details>
<summary>Click to expand v1.8.2 details</summary>

## [1.8.2] - 2025-10-10

### Added
- **URL-based DTA File Reading**: Implemented support for reading Stata DTA files directly from HTTP/HTTPS URLs
  - Added URL detection and validation in DtaDataInfo class
  - Implemented memory-efficient reading using BytesIO for optimal performance
  - Support for both `http://` and `https://` protocols with comprehensive error handling
  - Seamless integration with existing local file functionality
  - Automatic URL format validation and file extension verification

### Changed
- **Enhanced DtaDataInfo Architecture**: Extended DtaDataInfo class to support both local and remote files
  - Unified `_read_data()` method handles both file sources without code duplication
  - Intelligent file path detection (URL vs local path) for appropriate processing
  - Streamlined DataInfoBase class by removing unnecessary abstract method `_read_data_from_url()`
  - Cleaner separation of concerns between local and remote operations

- **Documentation Updates**: Enhanced API documentation and examples
  - Updated docstring examples in `__init__.py` with comprehensive output format examples
  - Added clear demonstration of remote data analysis capabilities
  - Improved error handling documentation for network operations

### Fixed
- **URL Handling Conflicts**: Resolved Path object conflicts when processing URLs as file paths
  - Fixed URL validation to properly parse and validate HTTP/HTTPS URLs
  - Corrected file extension checking for remote files using URL path parsing
  - Improved error messages to provide clearer feedback for URL-related issues

- **Network Error Handling**: Enhanced error handling for network operations
  - Added comprehensive timeout configurations and status code validation
  - Improved error reporting for network failures, invalid URLs, and file format issues
  - Better exception handling with informative error messages for troubleshooting

### Technical
- **New Dependencies**: Added `requests` library for HTTP operations
  - Robust HTTP client with built-in error handling and retry mechanisms
  - Efficient content handling for binary DTA files with proper encoding
  - Support for HTTP/HTTPS protocols with TLS security

- **Memory Optimization**: Implemented memory-efficient data processing
  - Direct loading into BytesIO eliminates temporary file overhead
  - Streaming content handling for large files with optimal memory usage
  - Zero intermediate file operations for URL-based data access

</details>

<details>
<summary>Click to expand v1.8.1 details</summary>

## [1.8.1] - 2025-10-09

### Fixed
- **MCP Version Compatibility**: Enhanced MCP initialization logic for better version compatibility
  - Improved error handling for different MCP implementations (v1.16.0+)
  - Enhanced FastMCP initialization with fallback mechanisms
  - Better robustness when encountering validation errors
  - Streamlined version-specific initialization logic

### Changed
- **Initialization Process**: Reorganized FastMCP initialization sequence
  - Prioritized MCP v1.16.0+ configuration with proper icon array format
  - Improved fallback error handling with non-config initialization
  - Enhanced user guidance for MCP version upgrades

### Technical
- **Code Robustness**: Improved error handling and initialization reliability
- **Version Support**: Better compatibility with MCP v1.16.0 and newer versions

</details>

<details>
<summary>Click to expand v1.8.0 details</summary>

## [1.8.0] - 2025-10-09

### Added
- **Enhanced Data Info Support**: Added comprehensive multi-format data information functionality
  - New `CsvDataInfo` class for handling CSV file metadata and statistics
  - Enhanced `DtaDataInfo` class for Stata .dta file data information extraction
  - Improved `DataInfoBase` base class with kwargs support for extensibility
  - Enhanced `get_data_info` function with CSV and enhanced DTA file format support
  - Added save functionality with configurable output options
  - Implemented temporary directory management for data processing
  - Full type annotations and comprehensive documentation

- **Enabled Data Info Tool**: Reactivated `get_data_info` functionality
  - Tool decorator re-enabled for production use
  - Support for multiple file formats: .dta, .csv, and Excel files
  - Improved error handling and user feedback
  - Enhanced data summary statistics and metadata extraction

### Changed
- **MCP Version Upgrade**: Updated MCP dependency from v1.15.0 to v1.16.0
  - Enhanced FastMCP initialization logic for better version compatibility
  - Improved error handling for different MCP implementations
  - Better robustness in initialization process
  - Streamlined dependency management

### Technical
- **Code Architecture**: Improved data info module structure with base classes
- **Type Safety**: Enhanced type annotations across data info functionality
- **Module Organization**: Better separation of concerns in data processing modules

</details>

<details>
<summary>Click to expand v1.7.4 details</summary>

## [1.7.4] - 2025-10-09

### Fixed
- **MCP Dependency Conflicts**: Resolved version conflicts in MCP dependency chain
  - Fixed compatibility issues with different MCP implementations
  - Enhanced system stability through streamlined dependency management
  - Improved error handling for dependency-related edge cases

### Technical
- **Dependency Optimization**: Streamlined MCP dependencies for better stability
- **Version Update**: Updated version from 1.7.3 to 1.7.4

</details>

<details>
<summary>Click to expand v1.7.3 details</summary>

## [1.7.3] - 2025-10-06

### Added
- **Enhanced Encoding Support**: Added configurable encoding parameters to dofile functions
  - `write_dofile` now supports optional `encoding` parameter (default: utf-8)
  - `append_dofile` enhanced with configurable encoding for read/write operations
  - Better support for international character sets including Chinese, Japanese, Korean
  - Maintains full backward compatibility with existing code

### Fixed
- **Issue #18**: Resolved potential Chinese character encoding problems in dofile operations
  - Proactive fix for international character set support
  - Enables flexible encoding handling for various environments

### Technical
- **Encoding Flexibility**: Improved dofile encoding handling without breaking changes
- **Version Update**: Updated version from 1.7.2 to 1.7.3

</details>

<details>
<summary>Click to expand v1.7.2 details</summary>

## [1.7.2] - 2025-10-06

### Added
- **Agent Mode Support**: Added comprehensive agent mode functionality
  - New `stata-mcp --agent` command line option for interactive AI-driven analysis
  - `StataAgent` class with LangChain integration for AI-powered Stata operations
  - Support for GPT-5, DeepSeek, and other OpenAI-compatible models
  - ReAct (Reasoning + Acting) prompt template for enhanced AI reasoning
  - MultiServerMCPClient integration for seamless Stata command execution
  - Interactive workflow with data source and task input prompts
- **Agent Examples**: Added complete agent implementation examples
  - LangChain and LangGraph integration examples
  - OpenAI-based agent implementation
  - Advanced prompt generation system for agent tasks
  - Comprehensive documentation and README files
- **Agent Startup Script**: Added `agent.sh` automated startup script
  - Auto-detection of uv package manager with fallback to pip
  - Python 3.11+ version validation and environment checking
  - Interactive installation prompts for uv package manager
  - Automatic package installation and version validation
  - Seamless agent mode launch with proper error handling
  - Cross-platform compatibility with colored output for better UX

### Changed
- **Jupyter Dependencies**: Removed unused Jupyter-related dependencies from `pyproject.toml`
  - Commented out `jupyter-client>=8.6.3` and `stata-kernel>=1.12.2`
  - Commented out `notebook>=7.4.5` and `jupyter>=1.1.1`
  - Streamlined installation process and reduced package size
  - No impact on core Stata-MCP functionality

### Technical
- **Dependency Optimization**: Cleaned up unused dependencies for faster installation
- **Agent Mode Integration**: Enhanced CLI with agent mode support via `-a/--agent` flag
- **Version Update**: Updated version from 1.7.1 to 1.7.2

</details>

<details>
<summary>Click to expand v1.7.1 details</summary>

## [1.7.1] - 2025-10-05

### Changed
- **mk_dir Security**: Re-enabled `mk_dir` tool with enhanced security using pathvalidate library
  - Added comprehensive path validation and sanitization
  - Implemented secure directory creation with proper permissions (0o755)
  - Added detailed error handling for invalid paths and permission issues
  - Improved function documentation with comprehensive parameter descriptions

### Technical
- **Dependencies**: Added `pathvalidate>=3.3.1` for secure path validation
- **Version Update**: Updated version from 1.7.0 to 1.7.1

</details>

<details>
<summary>Click to expand v1.7.0 details</summary>

## [1.7.0] - 2025-10-4

### Added
- **AI-Assisted Research**: Added comprehensive AI-assisted empirical research report with latest findings
- **Prompt Engineering**: Introduced comprehensive task prompt guide and examples for better AI interaction
- **Template System**: Added prompt-generator template for standardized AI request formatting
- **Research Documentation**: Added detailed research report on StataMCP usage for social science research
- **Prompt Examples**: Added two practical examples for PromptGenerator usage
- **Load Figure**: Added `load_figure` functionality for image handling
- **Sandbox Infrastructure**: Added sandbox infrastructure for testing
- **Main Entry Point**: Added `main.py` entry point for local development
- **Multilingual Documentation**: Updated Chinese, French, and Spanish README files
- **Agent Mode Support**: Added agent mode support documentation
- **China Users Guide**: Added specialized documentation for China users
- **LLM Integration Guide**: Added comprehensive LLM documentation for AI integration

### Changed
- **MCP Protocol**: Upgraded MCP from version 1.14 to 1.15 for latest features
- **Module Naming**: Renamed `StataFinder` to `stata_finder` for snake_case consistency
- **Directory Structure**: Improved code organization with better directory structure
- **Contributing Guide**: Updated CONTRIBUTING.md documentation
- **Security Policy**: Enhanced security policy with comprehensive privacy disclaimer
- **Git Standards**: Updated CLAUDE.md with git push restrictions and standards
- **App Icon**: Updated app icon to higher resolution image
- **Project Dependencies**: Updated project dependencies and lock files

### Disabled (Commented Out)
- **Directory Creation**: `mk_dir` tool implemented but decorator commented out for safety considerations
- **Data Info Function**: `get_data_info` tool implemented but decorator commented out

### Fixed
- **ValueError Prevention**: Fixed default instructions setting to avoid ValueError
- **macOS Compatibility**: Fixed errors in StataFinder.macos
- **Citation Corrections**: Fixed citation mistakes in research documentation
- **Environment Configuration**: Fixed environment name errors in configuration
- **Debug Cleanup**: Removed leftover debug print statements

### Technical
- **Code Architecture**: Improved code organization and maintainability
- **Function Safety**: Temporarily disabled certain functions via decorator commenting for security
- **Development Environment**: Enhanced development environment setup
- **Data Info Stability**: Temporarily disabled `get_data_info` for stability considerations

</details>

<details>
<summary>Click to expand v1.6.3 details</summary>

## [1.6.3] - 2025-09-12

### Added
- **MCP Resource Support**: Added `@mcp.resource` decorator for `help` function with URI `help://stata/{cmd}`
- **AI Coding Ability Report**: Added comprehensive comparison chart of different AI models' Stata code generation capabilities in source documentation

### Changed
- **Dependency Upgrade**: Upgraded `mcp[cli]` from `>=1.9.0` to `>=1.13.0` for latest MCP protocol features
- **Version Updates**: Updated version numbers across all documentation files and CITATION.cff

### Technical
- **Enhanced MCP Support**: Improved MCP protocol compatibility with resource URI support

</details>

<details>
<summary>Click to expand v1.6.2 details</summary>

## [1.6.2] - 2025-08-15

### Changed
- **CLI Architecture**: Refactored CLI entry point from `__init__.py` to dedicated CLI module
  - Moved CLI functionality to `stata_mcp/cli/_cli.py`
  - Improved code modularity and separation of concerns
  - Updated entry point configuration in `pyproject.toml`
  - Enhanced maintainability following Python packaging best practices

### Technical
- **Code Organization**: Clean separation between package initialization and CLI execution
- **Entry Point**: Updated to use dedicated CLI module instead of `__init__.py`
- **Module Structure**: Reduced complexity in main module initialization

</details>

<details>
<summary>Click to expand v1.6.1 details</summary>

## [1.6.1] - 2025-08-09

### Fixed
- Fixed Excel file reading issue in `get_data_info` function by adding missing `openpyxl` dependency
- Resolved compatibility issues with Excel (.xlsx) file formats

### Added
- Added `openpyxl>=3.1.5` to project dependencies for Excel file support

### Security
- Updated license from MIT to Apache License 2.0 for better legal protection and compatibility

### Changed
- **License**: Migrated from MIT License to Apache License 2.0
  - Updated LICENSE file to Apache 2.0 full text
  - Updated all documentation files (README, README-cn, README-fr, README-sp)
  - Updated CITATION.cff license field
  - Updated pyproject.toml license field
  - Updated Statement.md in all languages (中文, English, Français)
  - Updated all license badges from MIT to Apache 2.0
  - Ensured consistent Apache 2.0 licensing across entire project

</details>

<details>
<summary>Click to expand v1.6.0 details</summary>

## [1.6.0] - 2025-06-28

### Added
- Initial release with core Stata-MCP functionality
- Support for regression analysis via LLM integration
- Multi-language documentation (English, Chinese, French, Spanish)
- PyPI package distribution
- Jupyter integration support
- Web UI interface
- Cross-platform support (macOS, Windows, Linux)

### Features
- Stata command execution via MCP protocol
- Data analysis automation
- Regression model building assistance
- Statistical output interpretation
- Code generation and debugging support

</details>
