"""
Emoji transformation data.

This module contains the dictionary used for emoji transformations.
You can modify this dictionary to customize the emoji transformation behavior.
"""

from typing import Dict

# Emoji mappings - regex patterns mapped to emoji equivalents
EMOJI_MAP: Dict[str, str] = {
    # Emotions
    r"\blove\b": "❤️",
    r"\bheart\b": "❤️",
    r"\bhappy\b": "😊",
    r"\bsad\b": "😢",
    r"\bangry\b": "😠",
    r"\bsmile\b": "😊",
    r"\bcry\b": "😢",
    r"\blaugh\b": "😂",
    # Food
    r"\bpizza\b": "🍕",
    r"\bburger\b": "🍔",
    r"\bcoffee\b": "☕",
    r"\bbeer\b": "🍺",
    r"\bwine\b": "🍷",
    r"\bcake\b": "🎂",
    r"\bapple\b": "🍎",
    r"\bbanana\b": "🍌",
    r"\btaco\b": "🌮",
    r"\bsushi\b": "🍣",
    r"\bbread\b": "🍞",
    r"\bchocolate\b": "🍫",
    # Animals
    r"\bdog\b": "🐶",
    r"\bcat\b": "🐱",
    r"\bbird\b": "🐦",
    r"\bfish\b": "🐟",
    r"\bcow\b": "🐄",
    r"\bpig\b": "🐷",
    r"\bmonkey\b": "🐵",
    r"\bhorse\b": "🐴",
    # Nature
    r"\bsun\b": "☀️",
    r"\bmoon\b": "🌙",
    r"\bstar\b": "⭐",
    r"\btree\b": "🌳",
    r"\bflower\b": "🌸",
    r"\bfire\b": "🔥",
    r"\bwater\b": "💧",
    r"\bsnow\b": "❄️",
    # Objects
    r"\bcar\b": "🚗",
    r"\bhouse\b": "🏠",
    r"\bphone\b": "📱",
    r"\bcomputer\b": "💻",
    r"\bbook\b": "📚",
    r"\bmusic\b": "🎵",
    r"\bgame\b": "🎮",
    r"\bball\b": "⚽",
    # Actions
    r"\brun\b": "🏃",
    r"\bwalk\b": "🚶",
    r"\bdance\b": "💃",
    r"\bsleep\b": "😴",
    r"\bwork\b": "💼",
    r"\btravel\b": "✈️",
    r"\bshopping\b": "🛒",
    r"\bcooking\b": "👨‍🍳",
    # ❤️ Emotions
    r"\blove\b": "❤️",
    r"\bheart\b": "❤️",
    r"\bcrush\b": "❤️",
    r"\bvalentine\b": "❤️",
    r"\bkiss\b": "😘",
    r"\bhug\b": "🤗",
    r"\bsmile\b": "😊",
    r"\bhappy\b": "😊",
    r"\bjoy\b": "😊",
    r"\bglad\b": "😊",
    r"\blaugh\b": "😂",
    r"\blol\b": "😂",
    r"\brofl\b": "🤣",
    r"\bexcited\b": "🤩",
    r"\bstarstruck\b": "🤩",
    r"\bsad\b": "😢",
    r"\bcry\b": "😢",
    r"\btears\b": "😭",
    r"\bgrief\b": "😢",
    r"\bangry\b": "😠",
    r"\bmad\b": "😠",
    r"\brage\b": "😡",
    r"\bshock\b": "😲",
    r"\bwow\b": "😲",
    r"\bamazed\b": "😲",
    r"\bfear\b": "😱",
    r"\bscared\b": "😱",
    r"\bhorror\b": "😱",
    r"\bthinking\b": "🤔",
    r"\bconfused\b": "😕",
    r"\bworried\b": "😟",
    r"\bsick\b": "🤒",
    r"\bparty\b": "🥳",
    r"\bcelebrate\b": "🎉",
    r"\bbirthday\b": "🎂",
    # 🍔 Food & Drinks
    r"\bpizza\b": "🍕",
    r"\bslice\b": "🍕",
    r"\bburger\b": "🍔",
    r"\bfries\b": "🍟",
    r"\bchips\b": "🍟",
    r"\bhotdog\b": "🌭",
    r"\btaco\b": "🌮",
    r"\bburrito\b": "🌯",
    r"\bsandwich\b": "🥪",
    r"\bsalad\b": "🥗",
    r"\bsoup\b": "🥣",
    r"\brice\b": "🍚",
    r"\bsushi\b": "🍣",
    r"\bnoddles\b": "🍜",
    r"\bpasta\b": "🍝",
    r"\bbread\b": "🍞",
    r"\bcroissant\b": "🥐",
    r"\bpretzel\b": "🥨",
    r"\bchocolate\b": "🍫",
    r"\bcandy\b": "🍬",
    r"\bdonut\b": "🍩",
    r"\bice cream\b": "🍦",
    r"\bcake\b": "🎂",
    r"\bmuffin\b": "🧁",
    r"\bapple\b": "🍎",
    r"\bbanana\b": "🍌",
    r"\borange\b": "🍊",
    r"\bpear\b": "🍐",
    r"\bgrapes\b": "🍇",
    r"\bwatermelon\b": "🍉",
    r"\bstrawberry\b": "🍓",
    r"\bcherry\b": "🍒",
    r"\bpineapple\b": "🍍",
    r"\blemon\b": "🍋",
    r"\bcoconut\b": "🥥",
    r"\bcoffee\b": "☕",
    r"\btea\b": "🍵",
    r"\bbeer\b": "🍺",
    r"\bwine\b": "🍷",
    r"\bchampagne\b": "🍾",
    r"\bcocktail\b": "🍹",
    r"\bdrink\b": "🥤",
    r"\bmilk\b": "🥛",
    r"\bwater\b": "💧",
    # 🐶 Animals
    r"\bdog\b": "🐶",
    r"\bpuppy\b": "🐶",
    r"\bpup\b": "🐶",
    r"\bhound\b": "🐶",
    r"\bcat\b": "🐱",
    r"\bkitten\b": "🐱",
    r"\bkitty\b": "🐱",
    r"\bbird\b": "🐦",
    r"\bparrot\b": "🦜",
    r"\bchicken\b": "🐔",
    r"\brooster\b": "🐓",
    r"\bduck\b": "🦆",
    r"\bpig\b": "🐷",
    r"\bpiggy\b": "🐷",
    r"\bcow\b": "🐄",
    r"\bbull\b": "🐂",
    r"\bhorse\b": "🐴",
    r"\bpony\b": "🐴",
    r"\blion\b": "🦁",
    r"\btiger\b": "🐯",
    r"\belephant\b": "🐘",
    r"\brabbit\b": "🐇",
    r"\bbunny\b": "🐇",
    r"\bbear\b": "🐻",
    r"\bpanda\b": "🐼",
    r"\bfrog\b": "🐸",
    r"\bmonkey\b": "🐵",
    r"\bape\b": "🦍",
    r"\bwhale\b": "🐋",
    r"\bdolphin\b": "🐬",
    r"\bshark\b": "🦈",
    r"\bfish\b": "🐟",
    r"\boctopus\b": "🐙",
    r"\bcrab\b": "🦀",
    r"\bsnake\b": "🐍",
    r"\blizard\b": "🦎",
    r"\bturtle\b": "🐢",
    r"\bdragon\b": "🐉",
    # 🌳 Nature & Weather
    r"\bsun\b": "☀️",
    r"\bsunshine\b": "☀️",
    r"\bsunny\b": "☀️",
    r"\bmoon\b": "🌙",
    r"\bnew moon\b": "🌑",
    r"\bfull moon\b": "🌕",
    r"\bstar\b": "⭐",
    r"\bstars\b": "🌌",
    r"\bshooting star\b": "🌠",
    r"\brain\b": "🌧️",
    r"\bstorm\b": "⛈️",
    r"\bthunder\b": "⚡",
    r"\blightning\b": "⚡",
    r"\bcloud\b": "☁️",
    r"\bsnow\b": "❄️",
    r"\bsnowflake\b": "❄️",
    r"\bwinter\b": "☃️",
    r"\brainbow\b": "🌈",
    r"\btree\b": "🌳",
    r"\bforest\b": "🌲",
    r"\bleaf\b": "🍃",
    r"\bflower\b": "🌸",
    r"\brose\b": "🌹",
    r"\bsunflower\b": "🌻",
    r"\btulip\b": "🌷",
    r"\bgrass\b": "🌱",
    r"\bocean\b": "🌊",
    r"\bsea\b": "🌊",
    r"\bmountain\b": "⛰️",
    r"\bvolcano\b": "🌋",
    r"\bdesert\b": "🏜️",
    r"\bisland\b": "🏝️",
    # 📱 Objects & Things
    r"\bphone\b": "📱",
    r"\bcell\b": "📱",
    r"\bmobile\b": "📱",
    r"\bcomputer\b": "💻",
    r"\blaptop\b": "💻",
    r"\bkeyboard\b": "⌨️",
    r"\bmouse\b": "🖱️",
    r"\bbook\b": "📚",
    r"\bbooks\b": "📚",
    r"\bnotebook\b": "📓",
    r"\bpen\b": "🖊️",
    r"\bpencil\b": "✏️",
    r"\bpaper\b": "📄",
    r"\bdocument\b": "📄",
    r"\benvelope\b": "✉️",
    r"\bletter\b": "✉️",
    r"\bpackage\b": "📦",
    r"\bgift\b": "🎁",
    r"\bwatch\b": "⌚",
    r"\bclock\b": "⏰",
    r"\bkey\b": "🔑",
    r"\bdoor\b": "🚪",
    r"\bwindow\b": "🪟",
    r"\blamp\b": "💡",
    r"\btelevision\b": "📺",
    r"\bradio\b": "📻",
    r"\bheadphones\b": "🎧",
    r"\bgame\b": "🎮",
    r"\bcontroller\b": "🎮",
    r"\bmusic\b": "🎵",
    r"\bsong\b": "🎶",
    r"\bdrum\b": "🥁",
    r"\bguitar\b": "🎸",
    r"\bpiano\b": "🎹",
    r"\bviolin\b": "🎻",
    r"\btrumpet\b": "🎺",
    r"\bcamera\b": "📷",
    r"\bphoto\b": "📸",
    r"\bvideo\b": "📹",
    r"\bfilm\b": "🎬",
    r"\bmap\b": "🗺️",
    r"\bflag\b": "🚩",
    # 🏃 Activities / Sports
    r"\brun\b": "🏃",
    r"\brunning\b": "🏃",
    r"\bjog\b": "🏃",
    r"\bwalk\b": "🚶",
    r"\bhike\b": "🥾",
    r"\bdance\b": "💃",
    r"\bparty\b": "🥳",
    r"\bcelebrate\b": "🎉",
    r"\bsing\b": "🎤",
    r"\bswim\b": "🏊",
    r"\bbike\b": "🚲",
    r"\bcycling\b": "🚴",
    r"\bski\b": "🎿",
    r"\bsnowboard\b": "🏂",
    r"\bclimb\b": "🧗",
    r"\byoga\b": "🧘",
    r"\bgym\b": "🏋️",
    r"\bexercise\b": "🏋️",
    r"\bsoccer\b": "⚽",
    r"\bfootball\b": "🏈",
    r"\bbasketball\b": "🏀",
    r"\bbaseball\b": "⚾",
    r"\btennis\b": "🎾",
    r"\bgolf\b": "⛳",
    r"\bbowling\b": "🎳",
    r"\bvolleyball\b": "🏐",
    r"\bboxing\b": "🥊",
    r"\bfight\b": "🥋",
    r"\bracing\b": "🏎️",
    r"\btravel\b": "✈️",
    r"\btrip\b": "🧳",
    r"\bcamping\b": "🏕️",
    r"\bshopping\b": "🛒",
    r"\bcooking\b": "👨‍🍳",
    r"\bread\b": "📖",
    r"\bwriting\b": "✍️",
    r"\bstudy\b": "📖",
    r"\bwork\b": "💼",
    r"\bjob\b": "💼",
    r"\bmeeting\b": "📅",
    # 🎄 Holidays & Celebrations
    r"\bchristmas\b": "🎄",
    r"\bxmas\b": "🎄",
    r"\bsanta\b": "🎅",
    r"\bgift\b": "🎁",
    r"\bpresent\b": "🎁",
    r"\bholiday\b": "🏖️",
    r"\bbirthday\b": "🎂",
    r"\bcake\b": "🎂",
    r"\bparty\b": "🥳",
    r"\bnew year\b": "🎆",
    r"\bfireworks\b": "🎇",
    r"\beaster\b": "🐇",
    r"\bvalentine\b": "❤️",
    r"\bhalloween\b": "🎃",
    r"\bpumpkin\b": "🎃",
    # 🔥 Symbols & Misc
    r"\bok\b": "👌",
    r"\byes\b": "✅",
    r"\bno\b": "❌",
    r"\bcheck\b": "✔️",
    r"\bcross\b": "❌",
    r"\bquestion\b": "❓",
    r"\bidea\b": "💡",
    r"\blight\b": "💡",
    r"\bmoney\b": "💰",
    r"\bcash\b": "💵",
    r"\bdollar\b": "💵",
    r"\bgold\b": "🥇",
    r"\bsilver\b": "🥈",
    r"\bbronze\b": "🥉",
    r"\btrophy\b": "🏆",
    r"\bmedal\b": "🏅",
    r"\bfire\b": "🔥",
    r"\bexplosion\b": "💥",
    r"\bboom\b": "💥",
    r"\bstar\b": "⭐",
    r"\bmagic\b": "✨",
    r"\bsparkle\b": "✨",
    r"\bpoop\b": "💩",
    r"\brobot\b": "🤖",
    r"\balien\b": "👽",
    r"\bghost\b": "👻",
    r"\bskull\b": "💀",
    r"\bbomb\b": "💣",
    r"\bweapon\b": "🔫",
    r"\bsword\b": "⚔️",
    r"\bcrown\b": "👑",
    r"\bking\b": "🤴",
    r"\bqueen\b": "👸",
    r"\bprince\b": "🤴",
    r"\bprincess\b": "👸",
    # 🚗 Vehicles & Transport
    r"\bcar\b": "🚗",
    r"\bcars\b": "🚗",
    r"\bjeep\b": "🚙",
    r"\btaxi\b": "🚕",
    r"\bbus\b": "🚌",
    r"\btruck\b": "🚚",
    r"\bvan\b": "🚐",
    r"\btrain\b": "🚆",
    r"\blocomotive\b": "🚂",
    r"\bsubway\b": "🚇",
    r"\btram\b": "🚊",
    r"\bship\b": "🚢",
    r"\bboat\b": "⛵",
    r"\bsailboat\b": "⛵",
    r"\byacht\b": "🛥️",
    r"\bplane\b": "✈️",
    r"\bairplane\b": "✈️",
    r"\bjet\b": "✈️",
    r"\bhelicopter\b": "🚁",
    r"\brocket\b": "🚀",
    r"\bspaceship\b": "🚀",
    r"\bbicycle\b": "🚲",
    r"\bbike\b": "🚲",
    r"\bmotorcycle\b": "🏍️",
    r"\bscooter\b": "🛵",
    r"\bskateboard\b": "🛹",
    # 👩‍🔧 Professions
    r"\bdoctor\b": "👨‍⚕️",
    r"\bnurse\b": "👩‍⚕️",
    r"\bteacher\b": "👩‍🏫",
    r"\bstudent\b": "👨‍🎓",
    r"\bgraduate\b": "🎓",
    r"\bscientist\b": "👩‍🔬",
    r"\bengineer\b": "👷",
    r"\bworker\b": "👷",
    r"\bchef\b": "👨‍🍳",
    r"\bcook\b": "👨‍🍳",
    r"\bartist\b": "👨‍🎨",
    r"\bpainter\b": "👩‍🎨",
    r"\bpolice\b": "👮",
    r"\bofficer\b": "👮",
    r"\bdetective\b": "🕵️",
    r"\bsoldier\b": "🪖",
    r"\bguard\b": "💂",
    r"\bfarmer\b": "👨‍🌾",
    r"\bfisherman\b": "🧑‍🌾",
    r"\bpilot\b": "👨‍✈️",
    r"\bsailor\b": "👩‍✈️",
    r"\bfireman\b": "👨‍🚒",
    r"\bfirefighter\b": "👨‍🚒",
    r"\bclown\b": "🤡",
    r"\bjester\b": "🤡",
    r"\bking\b": "🤴",
    r"\bqueen\b": "👸",
    r"\bprince\b": "🤴",
    r"\bprincess\b": "👸",
    # 🧙 Fantasy / Myth
    r"\bwizard\b": "🧙",
    r"\bwitch\b": "🧙‍♀️",
    r"\bmagician\b": "🧙",
    r"\belf\b": "🧝",
    r"\bdwarf\b": "🧝",
    r"\borc\b": "👹",
    r"\btroll\b": "👹",
    r"\bgiant\b": "🦣",
    r"\bghost\b": "👻",
    r"\bzombie\b": "🧟",
    r"\bvampire\b": "🧛",
    r"\bmermaid\b": "🧜‍♀️",
    r"\bmerman\b": "🧜‍♂️",
    r"\bfairy\b": "🧚",
    r"\bangel\b": "😇",
    r"\bdemon\b": "😈",
    r"\bdevil\b": "😈",
    r"\bskeleton\b": "💀",
    r"\bskull\b": "💀",
    r"\bdragon\b": "🐉",
    r"\bgriffin\b": "🦅",
    r"\bunicorn\b": "🦄",
    r"\bpegasus\b": "🐎",
    r"\bphoenix\b": "🔥",
    r"\bgoblin\b": "👺",
    # 🤟 Gestures & Body
    r"\bhand\b": "✋",
    r"\bwave\b": "👋",
    r"\bhello\b": "👋",
    r"\bhi\b": "👋",
    r"\bbye\b": "👋",
    r"\bfist\b": "✊",
    r"\bstrong\b": "💪",
    r"\bflex\b": "💪",
    r"\bpeace\b": "✌️",
    r"\bthumbs up\b": "👍",
    r"\bthumbs down\b": "👎",
    r"\bpoint\b": "👉",
    r"\bclap\b": "👏",
    r"\bpray\b": "🙏",
    r"\bfingers crossed\b": "🤞",
    r"\beyes\b": "👀",
    r"\beye\b": "👁️",
    r"\bear\b": "👂",
    r"\bnose\b": "👃",
    r"\bmouth\b": "👄",
    r"\btongue\b": "👅",
    r"\bfoot\b": "🦶",
    r"\bfeet\b": "🦶",
    r"\bleg\b": "🦵",
    r"\barm\b": "💪",
    r"\bbrain\b": "🧠",
    r"\bheart\b": "❤️",
    r"\blungs\b": "🫁",
    r"\bbone\b": "🦴",
    r"\btooth\b": "🦷",
    # 🛠️ More Objects
    r"\bhammer\b": "🔨",
    r"\baxe\b": "🪓",
    r"\bknife\b": "🔪",
    r"\bsword\b": "⚔️",
    r"\bshield\b": "🛡️",
    r"\bbow\b": "🏹",
    r"\bgun\b": "🔫",
    r"\bcannon\b": "💣",
    r"\barrow\b": "🏹",
    r"\bbomb\b": "💣",
    r"\banchor\b": "⚓",
    r"\bcompass\b": "🧭",
    r"\btelescope\b": "🔭",
    r"\bmicroscope\b": "🔬",
    r"\bflask\b": "⚗️",
    r"\btelescope\b": "🔭",
    r"\btest tube\b": "🧪",
    r"\bsyringe\b": "💉",
    r"\bpill\b": "💊",
    r"\bbed\b": "🛏️",
    r"\bchair\b": "🪑",
    r"\btable\b": "🪑",
    r"\bsofa\b": "🛋️",
    r"\btoilet\b": "🚽",
    r"\bshower\b": "🚿",
    r"\bbath\b": "🛁",
    r"\bsoap\b": "🧼",
    r"\btowel\b": "🧻",
    r"\bbucket\b": "🪣",
    r"\btrash\b": "🗑️",
    r"\brecycle\b": "♻️",
    r"\block\b": "🔒",
    r"\bunlock\b": "🔓",
    r"\bchain\b": "⛓️",
    r"\bmagnet\b": "🧲",
    # 🏳️ Flags (just a few popular)
    r"\busa\b": "🇺🇸",
    r"\bamerica\b": "🇺🇸",
    r"\buk\b": "🇬🇧",
    r"\bengland\b": "🏴",
    r"\bindia\b": "🇮🇳",
    r"\bjapan\b": "🇯🇵",
    r"\bchina\b": "🇨🇳",
    r"\bgermany\b": "🇩🇪",
    r"\bfrance\b": "🇫🇷",
    r"\bitaly\b": "🇮🇹",
    r"\bcanada\b": "🇨🇦",
    r"\baustralia\b": "🇦🇺",
    r"\bbrazil\b": "🇧🇷",
    r"\bmexico\b": "🇲🇽",
    # 🎽 Sports & Games
    r"\bfootball\b": "🏈",
    r"\brugby\b": "🏉",
    r"\bbasketball\b": "🏀",
    r"\btennis\b": "🎾",
    r"\bgolf\b": "⛳",
    r"\bbaseball\b": "⚾",
    r"\bcricket\b": "🏏",
    r"\bvolleyball\b": "🏐",
    r"\bping pong\b": "🏓",
    r"\btable tennis\b": "🏓",
    r"\bbadminton\b": "🏸",
    r"\bboxing\b": "🥊",
    r"\bwrestling\b": "🤼",
    r"\bski\b": "🎿",
    r"\bsnowboard\b": "🏂",
    r"\bchess\b": "♟️",
    r"\bmedal\b": "🥇",
    r"\btrophy\b": "🏆",
    # 👕 Clothes
    r"\bshirt\b": "👕",
    r"\btshirt\b": "👕",
    r"\bjeans\b": "👖",
    r"\bpants\b": "👖",
    r"\bdress\b": "👗",
    r"\bskirt\b": "👗",
    r"\bshoes\b": "👟",
    r"\bsneakers\b": "👟",
    r"\bboot\b": "👢",
    r"\bhat\b": "🎩",
    r"\bcap\b": "🧢",
    r"\bscarf\b": "🧣",
    r"\bgloves\b": "🧤",
    r"\bsocks\b": "🧦",
    r"\bcoat\b": "🧥",
    r"\bkimono\b": "👘",
    r"\bswimsuit\b": "🩱",
    r"\bbikini\b": "👙",
    r"\bpurse\b": "👛",
    r"\bbag\b": "👜",
    r"\bbackpack\b": "🎒",
    r"\bwallet\b": "👝",
    r"\bwatch\b": "⌚",
    r"\bglasses\b": "👓",
    r"\bsunglasses\b": "🕶️",
    # ☁️ Weather
    r"\brain\b": "🌧️",
    r"\bstorm\b": "⛈️",
    r"\bthunder\b": "⚡",
    r"\blightning\b": "⚡",
    r"\bcloud\b": "☁️",
    r"\brainbow\b": "🌈",
    r"\bfog\b": "🌫️",
    r"\btornado\b": "🌪️",
    r"\bhurricane\b": "🌀",
    r"\bvolcano\b": "🌋",
    # 🎉 Holidays & Celebrations
    r"\bbirthday\b": "🎂",
    r"\bparty\b": "🥳",
    r"\bcelebration\b": "🎉",
    r"\bchristmas\b": "🎄",
    r"\bxmas\b": "🎄",
    r"\bsanta\b": "🎅",
    r"\bholiday\b": "🏖️",
    r"\bnew year\b": "🎆",
    r"\bfestival\b": "🎊",
    r"\beaster\b": "🐣",
    r"\bdiwali\b": "🪔",
    r"\bramadan\b": "🕌",
    r"\bhalloween\b": "🎃",
    r"\bthanksgiving\b": "🦃",
    # 🚸 Signs & Transport
    r"\bstop\b": "🛑",
    r"\btraffic\b": "🚦",
    r"\bconstruction\b": "🚧",
    r"\bwarning\b": "⚠️",
    r"\bdanger\b": "☢️",
    r"\bradioactive\b": "☢️",
    r"\bbiohazard\b": "☣️",
    r"\bhospital\b": "🏥",
    r"\bschool\b": "🏫",
    r"\blibrary\b": "📖",
    r"\bpost\b": "📮",
    r"\bmailbox\b": "📬",
    r"\bpackage\b": "📦",
    # 🔣 Symbols
    r"\bcheck\b": "✔️",
    r"\bok\b": "🆗",
    r"\bcross\b": "❌",
    r"\bplus\b": "➕",
    r"\bminus\b": "➖",
    r"\bmultiply\b": "✖️",
    r"\bdivide\b": "➗",
    r"\binfinity\b": "♾️",
    r"\byes\b": "✅",
    r"\bno\b": "🚫",
    r"\bquestion\b": "❓",
    r"\bexclamation\b": "❗",
    r"\barrow\b": "➡️",
    r"\bup\b": "⬆️",
    r"\bdown\b": "⬇️",
    r"\bleft\b": "⬅️",
    r"\bright\b": "➡️",
    r"\bstar\b": "⭐",
    r"\bmoon\b": "🌙",
    # 🎲 Fun & Misc
    r"\bdice\b": "🎲",
    r"\bcards\b": "🃏",
    r"\bjoker\b": "🃏",
    r"\bslot\b": "🎰",
    r"\bcasino\b": "🎰",
    r"\bclown\b": "🤡",
    r"\brobot\b": "🤖",
    r"\balien\b": "👽",
    r"\bufo\b": "🛸",
    r"\bcrown\b": "👑",
    r"\bdiamond\b": "💎",
    r"\bgem\b": "💎",
    r"\bkey\b": "🔑",
    r"\btreasure\b": "🏴‍☠️",
    r"\bmap\b": "🗺️",
}
