"""
Shakespeare transformation data.

This module contains the dictionary used for Shakespearean English transformations.
You can modify this dictionary to customize the Shakespeare transformation behavior.
"""

from typing import Dict

# Shakespeare word replacements - regex patterns mapped to Shakespearean equivalents
SHAKESPEARE_REPLACEMENTS: Dict[str, str] = {
    # Pronouns
    r"\byou\b": "thou",
    r"\byour\b": "thy",
    r"\byou\'re\b": "thou art",
    r"\byours\b": "thine",
    r"\bI\b": "I",
    r"\bme\b": "me",
    r"\bmy\b": "mine",
    r"\bhe\b": "he",
    r"\bshe\b": "she",
    r"\bit\b": "it",
    # Verbs (present / past / modal)
    r"\bare\b": "art",
    r"\bis\b": "is",
    r"\bdo\b": "dost",
    r"\bdoes\b": "doth",
    r"\bhave\b": "hast",
    r"\bhas\b": "hath",
    r"\bwill\b": "shall",
    r"\bshall\b": "shalt",
    r"\bcan\b": "canst",
    r"\bmay\b": "mayst",
    r"\bmight\b": "mightst",
    r"\bshould\b": "shouldst",
    r"\bwould\b": "wouldst",
    r"\bcould\b": "couldst",
    r"\bgo\b": "goest",
    r"\bcome\b": "comest",
    r"\bsee\b": "seest",
    r"\bknow\b": "knowest",
    r"\bthink\b": "thinkest",
    r"\bspeak\b": "speakest",
    r"\btell\b": "tellest",
    r"\blook\b": "lookest",
    r"\bmake\b": "makest",
    r"\bfind\b": "findest",
    r"\bcall\b": "callest",
    r"\bleave\b": "leavest",
    r"\bbring\b": "bringest",
    r"\btake\b": "takest",
    r"\bcome\b": "comest",
    r"\brun\b": "runnest",
    r"\bfight\b": "fightest",
    r"\bhelp\b": "helpest",
    # Nouns
    r"\bfriend\b": "companion",
    r"\bfriends\b": "companions",
    r"\bman\b": "sir",
    r"\bwoman\b": "lady",
    r"\bking\b": "sovereign",
    r"\bqueen\b": "regent",
    r"\bchild\b": "child",
    r"\bchildren\b": "children",
    r"\blord\b": "lord",
    r"\blady\b": "lady",
    r"\bcourt\b": "hall",
    r"\bcastle\b": "fortress",
    r"\bhome\b": "dwelling",
    r"\bhouse\b": "abode",
    r"\broom\b": "chamber",
    # Adjectives
    r"\bgreat\b": "mighty",
    r"\bgood\b": "fair",
    r"\bbad\b": "ill",
    r"\bbeautiful\b": "beauteous",
    r"\bstrange\b": "passing strange",
    r"\bwise\b": "sage",
    r"\bquick\b": "swift",
    r"\bslow\b": "languid",
    r"\bhappy\b": "glad",
    r"\bsad\b": "sorrowful",
    r"\blovely\b": "winsome",
    r"\bstrong\b": "stout",
    r"\bweak\b": "feeble",
    r"\brich\b": "opulent",
    r"\bpoor\b": "destitute",
    r"\bbrave\b": "valiant",
    r"\bcowardly\b": "craven",
    r"\bfearful\b": "timorous",
    r"\bdead\b": "departed",
    # Adverbs
    r"\bquickly\b": "anon",
    r"\bsuddenly\b": "forthwith",
    r"\btruly\b": "verily",
    r"\bperhaps\b": "perchance",
    r"\bsometimes\b": "ofttimes",
    r"\balways\b": "evermore",
    r"\bnever\b": "ne’er",
    r"\bsoon\b": "presently",
    r"\bhere\b": "hither",
    r"\bthere\b": "thither",
    r"\bwhere\b": "whither",
    # Expressions / Interjections
    r"\byes\b": "aye",
    r"\bno\b": "nay",
    r"\bokay\b": "forsooth",
    r"\bhello\b": "hail",
    r"\bgoodbye\b": "farewell",
    r"\bmaybe\b": "mayhap",
    r"\bwait\b": "soft",
    r"\blisten\b": "hark",
    r"\blook\b": "lo",
    r"\bbe careful\b": "take heed",
    r"\bindeed\b": "forsooth",
    r"\btruly\b": "verily",
    r"\balas\b": "alack",
    r"\boh\b": "marry",
    r"\bwow\b": "zounds",
    r"\bgood grief\b": "gramercy",
    r"\bhelp\b": "aid",
    r"\bstop\b": "cease",
    r"\bwait\b": "bide",
}
