# Copyright (C) 2022 CVAT.ai Corporation
#
# SPDX-License-Identifier: MIT

# CVAT REST API
#
# REST API for Computer Vision Annotation Tool (CVAT)  # noqa: E501
#
# The version of the OpenAPI document: 2.43.0
# Contact: support@cvat.ai
# Generated by: https://openapi-generator.tech


from __future__ import annotations

import typing

import re  # noqa: F401
import sys  # noqa: F401

from cvat_sdk.api_client.model_utils import (  # noqa: F401
    ApiTypeError,
    IModelData,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from cvat_sdk.api_client.exceptions import ApiAttributeError

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    # Enable introspection. Can't work normally due to cyclic imports
    from cvat_sdk.api_client.apis import *
    from cvat_sdk.api_client.models import *


def lazy_import():
    from cvat_sdk.api_client.model.data_request_validation_params import DataRequestValidationParams
    from cvat_sdk.api_client.model.sorting_method import SortingMethod
    from cvat_sdk.api_client.model.storage_method import StorageMethod
    from cvat_sdk.api_client.model.storage_type import StorageType
    globals()['DataRequestValidationParams'] = DataRequestValidationParams
    globals()['SortingMethod'] = SortingMethod
    globals()['StorageMethod'] = StorageMethod
    globals()['StorageType'] = StorageType



class IDataRequest(IModelData):
    """
    NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    # member type declarations
    chunk_size: typing.Union[int, none_type] # noqa: E501
    """
    [optional]
    Maximum number of frames per chunk.
    """

    image_quality: int # noqa: E501
    """
    Image quality to use during annotation.
    """

    start_frame: int # noqa: E501
    """
    [optional]
    First frame index.
    """

    stop_frame: int # noqa: E501
    """
    [optional]
    Last frame index.
    """

    frame_filter: str # noqa: E501
    """
    [optional]
    Frame filter. The only supported syntax is: 'step=N'.
    """

    client_files: list[file_type] # noqa: E501
    """
    [optional, default: []]
    [file_type]
     Uploaded files. Must contain all files from job_file_mapping if job_file_mapping is not empty. .
    """

    server_files: list[str] # noqa: E501
    """
    [optional, default: []]
    [str]
     Paths to files from a file share mounted on the server, or from a cloud storage. Must contain all files from job_file_mapping if job_file_mapping is not empty. .
    """

    remote_files: list[str] # noqa: E501
    """
    [optional, default: []]
    [str]
     Direct download URLs for files. Must contain all files from job_file_mapping if job_file_mapping is not empty. .
    """

    use_zip_chunks: bool # noqa: E501
    """
    [optional, default: False]
    When true, video chunks will be represented as zip archives with decoded video frames. When false, video chunks are represented as video segments .
    """

    server_files_exclude: list[str] # noqa: E501
    """
    [optional, default: []]
    [str]
    Paths to files and directories from a file share mounted on the server, or from a cloud storage that should be excluded from the directories specified in server_files. This option cannot be used together with filename_pattern. The server_files_exclude parameter cannot be used to exclude a part of dataset from an archive.  Examples:  Exclude all files from subfolder 'sub/sub_1/sub_2'and single file 'sub/image.jpg' from specified folder: server_files = ['sub/'], server_files_exclude = ['sub/sub_1/sub_2/', 'sub/image.jpg']  Exclude all cloud storage files with prefix 'sub' from the content of manifest file: server_files = ['manifest.jsonl'], server_files_exclude = ['sub/'] .
    """

    cloud_storage_id: typing.Union[int, none_type] # noqa: E501
    """
    [optional]
    If not null, the files referenced by server_files will be retrieved from the cloud storage with the specified ID. The cloud storages applicable depend on the context. In the user sandbox, only the user sandbox cloud storages can be used. In an organization, only the organization cloud storages can be used. .
    """

    use_cache: bool # noqa: E501
    """
    [optional, default: False]
    Enable or disable task data chunk caching for the task. Read more: https://docs.cvat.ai/docs/manual/advanced/data_on_fly/ .
    """

    copy_data: bool # noqa: E501
    """
    [optional, default: False]
    Copy data from the server file share to CVAT during the task creation. This will create a copy of the data, making the server independent from the file share availability .
    """

    storage_method: StorageMethod # noqa: E501
    """
    [optional]
    """

    storage: StorageType # noqa: E501
    """
    [optional]
    """

    sorting_method: SortingMethod # noqa: E501
    """
    [optional]
    """

    filename_pattern: typing.Union[str, none_type] # noqa: E501
    """
    [optional]
    A filename filter for cloud storage files listed in the manifest. Supports fnmatch wildcards. Read more: https://docs.python.org/3/library/fnmatch.html .
    """

    job_file_mapping: list[list[str]] # noqa: E501
    """
    [optional]
    [[str]]
     Represents a file-to-job mapping. Useful to specify a custom job configuration during task creation. This option is not compatible with most other job split-related options. Files in the jobs must not overlap or repeat. Job file mapping files must be a subset of the input files. If directories are specified in server_files, all files obtained by recursive search in the specified directories will be used as input files. In case of missing items in the input files, an error will be raised.  Example: [      [\"file1.jpg\", \"file2.jpg\"], # job #1 files     [\"file3.png\"], # job #2 files     [\"file4.jpg\", \"file5.png\", \"file6.bmp\"], # job #3 files ] .
    """

    upload_file_order: list[str] # noqa: E501
    """
    [optional]
    [str]
    Allows to specify file order for client_file uploads. Only valid with the \"predefined\" sorting method selected.  To state that the input files are sent in the correct order, pass an empty list.  If you want to send files in an arbitrary order and reorder them afterwards on the server, pass the list of file names in the required order. .
    """

    validation_params: DataRequestValidationParams # noqa: E501
    """
    [optional]
    """


class DataRequest(ModelNormal, IDataRequest):
    """
    NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      image_quality (int): Image quality to use during annotation

      chunk_size (int, none_type): Maximum number of frames per chunk. [optional]  # noqa: E501

      start_frame (int): First frame index. [optional]  # noqa: E501

      stop_frame (int): Last frame index. [optional]  # noqa: E501

      frame_filter (str): Frame filter. The only supported syntax is: 'step=N'. [optional]  # noqa: E501

      client_files ([file_type]):  Uploaded files. Must contain all files from job_file_mapping if job_file_mapping is not empty. . [optional] if omitted the server will use the default value of []  # noqa: E501

      server_files ([str]):  Paths to files from a file share mounted on the server, or from a cloud storage. Must contain all files from job_file_mapping if job_file_mapping is not empty. . [optional] if omitted the server will use the default value of []  # noqa: E501

      remote_files ([str]):  Direct download URLs for files. Must contain all files from job_file_mapping if job_file_mapping is not empty. . [optional] if omitted the server will use the default value of []  # noqa: E501

      use_zip_chunks (bool): When true, video chunks will be represented as zip archives with decoded video frames. When false, video chunks are represented as video segments . [optional] if omitted the server will use the default value of False  # noqa: E501

      server_files_exclude ([str]): Paths to files and directories from a file share mounted on the server, or from a cloud storage that should be excluded from the directories specified in server_files. This option cannot be used together with filename_pattern. The server_files_exclude parameter cannot be used to exclude a part of dataset from an archive.  Examples:  Exclude all files from subfolder 'sub/sub_1/sub_2'and single file 'sub/image.jpg' from specified folder: server_files = ['sub/'], server_files_exclude = ['sub/sub_1/sub_2/', 'sub/image.jpg']  Exclude all cloud storage files with prefix 'sub' from the content of manifest file: server_files = ['manifest.jsonl'], server_files_exclude = ['sub/'] . [optional] if omitted the server will use the default value of []  # noqa: E501

      cloud_storage_id (int, none_type): If not null, the files referenced by server_files will be retrieved from the cloud storage with the specified ID. The cloud storages applicable depend on the context. In the user sandbox, only the user sandbox cloud storages can be used. In an organization, only the organization cloud storages can be used. . [optional]  # noqa: E501

      use_cache (bool): Enable or disable task data chunk caching for the task. Read more: https://docs.cvat.ai/docs/manual/advanced/data_on_fly/ . [optional] if omitted the server will use the default value of False  # noqa: E501

      copy_data (bool): Copy data from the server file share to CVAT during the task creation. This will create a copy of the data, making the server independent from the file share availability . [optional] if omitted the server will use the default value of False  # noqa: E501

      storage_method (StorageMethod): [optional]  # noqa: E501

      storage (StorageType): [optional]  # noqa: E501

      sorting_method (SortingMethod): [optional]  # noqa: E501

      filename_pattern (str, none_type): A filename filter for cloud storage files listed in the manifest. Supports fnmatch wildcards. Read more: https://docs.python.org/3/library/fnmatch.html . [optional]  # noqa: E501

      job_file_mapping ([[str]]):  Represents a file-to-job mapping. Useful to specify a custom job configuration during task creation. This option is not compatible with most other job split-related options. Files in the jobs must not overlap or repeat. Job file mapping files must be a subset of the input files. If directories are specified in server_files, all files obtained by recursive search in the specified directories will be used as input files. In case of missing items in the input files, an error will be raised.  Example: [      [\"file1.jpg\", \"file2.jpg\"], # job #1 files     [\"file3.png\"], # job #2 files     [\"file4.jpg\", \"file5.png\", \"file6.bmp\"], # job #3 files ] . [optional]  # noqa: E501

      upload_file_order ([str]): Allows to specify file order for client_file uploads. Only valid with the \"predefined\" sorting method selected.  To state that the input files are sent in the correct order, pass an empty list.  If you want to send files in an arbitrary order and reorder them afterwards on the server, pass the list of file names in the required order. . [optional]  # noqa: E501

      validation_params (DataRequestValidationParams): [optional]  # noqa: E501


      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
    }

    validations = {
        ('image_quality',): {
            'inclusive_maximum': 100,
            'inclusive_minimum': 0,
        },
        ('chunk_size',): {
            'inclusive_maximum': 2147483647,
            'inclusive_minimum': 0,
        },
        ('start_frame',): {
            'inclusive_maximum': 2147483647,
            'inclusive_minimum': 0,
        },
        ('stop_frame',): {
            'inclusive_maximum': 2147483647,
            'inclusive_minimum': 0,
        },
        ('frame_filter',): {
            'max_length': 256,
        },
        ('filename_pattern',): {
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'image_quality': (int,),  # noqa: E501
            'chunk_size': (int, none_type,),  # noqa: E501
            'start_frame': (int,),  # noqa: E501
            'stop_frame': (int,),  # noqa: E501
            'frame_filter': (str,),  # noqa: E501
            'client_files': ([file_type],),  # noqa: E501
            'server_files': ([str],),  # noqa: E501
            'remote_files': ([str],),  # noqa: E501
            'use_zip_chunks': (bool,),  # noqa: E501
            'server_files_exclude': ([str],),  # noqa: E501
            'cloud_storage_id': (int, none_type,),  # noqa: E501
            'use_cache': (bool,),  # noqa: E501
            'copy_data': (bool,),  # noqa: E501
            'storage_method': (StorageMethod,),  # noqa: E501
            'storage': (StorageType,),  # noqa: E501
            'sorting_method': (SortingMethod,),  # noqa: E501
            'filename_pattern': (str, none_type,),  # noqa: E501
            'job_file_mapping': ([[str]],),  # noqa: E501
            'upload_file_order': ([str],),  # noqa: E501
            'validation_params': (DataRequestValidationParams,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'image_quality': 'image_quality',  # noqa: E501
        'chunk_size': 'chunk_size',  # noqa: E501
        'start_frame': 'start_frame',  # noqa: E501
        'stop_frame': 'stop_frame',  # noqa: E501
        'frame_filter': 'frame_filter',  # noqa: E501
        'client_files': 'client_files',  # noqa: E501
        'server_files': 'server_files',  # noqa: E501
        'remote_files': 'remote_files',  # noqa: E501
        'use_zip_chunks': 'use_zip_chunks',  # noqa: E501
        'server_files_exclude': 'server_files_exclude',  # noqa: E501
        'cloud_storage_id': 'cloud_storage_id',  # noqa: E501
        'use_cache': 'use_cache',  # noqa: E501
        'copy_data': 'copy_data',  # noqa: E501
        'storage_method': 'storage_method',  # noqa: E501
        'storage': 'storage',  # noqa: E501
        'sorting_method': 'sorting_method',  # noqa: E501
        'filename_pattern': 'filename_pattern',  # noqa: E501
        'job_file_mapping': 'job_file_mapping',  # noqa: E501
        'upload_file_order': 'upload_file_order',  # noqa: E501
        'validation_params': 'validation_params',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, image_quality, *args, **kwargs):  # noqa: E501
        """DataRequest - a model defined in OpenAPI

        Args:
            image_quality (int): Image quality to use during annotation

        Keyword Args:
            chunk_size (int, none_type): Maximum number of frames per chunk. [optional]  # noqa: E501

            start_frame (int): First frame index. [optional]  # noqa: E501

            stop_frame (int): Last frame index. [optional]  # noqa: E501

            frame_filter (str): Frame filter. The only supported syntax is: 'step=N'. [optional]  # noqa: E501

            client_files ([file_type]):  Uploaded files. Must contain all files from job_file_mapping if job_file_mapping is not empty. . [optional] if omitted the server will use the default value of []  # noqa: E501

            server_files ([str]):  Paths to files from a file share mounted on the server, or from a cloud storage. Must contain all files from job_file_mapping if job_file_mapping is not empty. . [optional] if omitted the server will use the default value of []  # noqa: E501

            remote_files ([str]):  Direct download URLs for files. Must contain all files from job_file_mapping if job_file_mapping is not empty. . [optional] if omitted the server will use the default value of []  # noqa: E501

            use_zip_chunks (bool): When true, video chunks will be represented as zip archives with decoded video frames. When false, video chunks are represented as video segments . [optional] if omitted the server will use the default value of False  # noqa: E501

            server_files_exclude ([str]): Paths to files and directories from a file share mounted on the server, or from a cloud storage that should be excluded from the directories specified in server_files. This option cannot be used together with filename_pattern. The server_files_exclude parameter cannot be used to exclude a part of dataset from an archive.  Examples:  Exclude all files from subfolder 'sub/sub_1/sub_2'and single file 'sub/image.jpg' from specified folder: server_files = ['sub/'], server_files_exclude = ['sub/sub_1/sub_2/', 'sub/image.jpg']  Exclude all cloud storage files with prefix 'sub' from the content of manifest file: server_files = ['manifest.jsonl'], server_files_exclude = ['sub/'] . [optional] if omitted the server will use the default value of []  # noqa: E501

            cloud_storage_id (int, none_type): If not null, the files referenced by server_files will be retrieved from the cloud storage with the specified ID. The cloud storages applicable depend on the context. In the user sandbox, only the user sandbox cloud storages can be used. In an organization, only the organization cloud storages can be used. . [optional]  # noqa: E501

            use_cache (bool): Enable or disable task data chunk caching for the task. Read more: https://docs.cvat.ai/docs/manual/advanced/data_on_fly/ . [optional] if omitted the server will use the default value of False  # noqa: E501

            copy_data (bool): Copy data from the server file share to CVAT during the task creation. This will create a copy of the data, making the server independent from the file share availability . [optional] if omitted the server will use the default value of False  # noqa: E501

            storage_method (StorageMethod): [optional]  # noqa: E501

            storage (StorageType): [optional]  # noqa: E501

            sorting_method (SortingMethod): [optional]  # noqa: E501

            filename_pattern (str, none_type): A filename filter for cloud storage files listed in the manifest. Supports fnmatch wildcards. Read more: https://docs.python.org/3/library/fnmatch.html . [optional]  # noqa: E501

            job_file_mapping ([[str]]):  Represents a file-to-job mapping. Useful to specify a custom job configuration during task creation. This option is not compatible with most other job split-related options. Files in the jobs must not overlap or repeat. Job file mapping files must be a subset of the input files. If directories are specified in server_files, all files obtained by recursive search in the specified directories will be used as input files. In case of missing items in the input files, an error will be raised.  Example: [      [\"file1.jpg\", \"file2.jpg\"], # job #1 files     [\"file3.png\"], # job #2 files     [\"file4.jpg\", \"file5.png\", \"file6.bmp\"], # job #3 files ] . [optional]  # noqa: E501

            upload_file_order ([str]): Allows to specify file order for client_file uploads. Only valid with the \"predefined\" sorting method selected.  To state that the input files are sent in the correct order, pass an empty list.  If you want to send files in an arbitrary order and reorder them afterwards on the server, pass the list of file names in the required order. . [optional]  # noqa: E501

            validation_params (DataRequestValidationParams): [optional]  # noqa: E501

            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
"""

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.image_quality = image_quality
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, image_quality, *args, **kwargs):  # noqa: E501
        """DataRequest - a model defined in OpenAPI

        Args:
            image_quality (int): Image quality to use during annotation

        Keyword Args:
            chunk_size (int, none_type): Maximum number of frames per chunk. [optional]  # noqa: E501

            start_frame (int): First frame index. [optional]  # noqa: E501

            stop_frame (int): Last frame index. [optional]  # noqa: E501

            frame_filter (str): Frame filter. The only supported syntax is: 'step=N'. [optional]  # noqa: E501

            client_files ([file_type]):  Uploaded files. Must contain all files from job_file_mapping if job_file_mapping is not empty. . [optional] if omitted the server will use the default value of []  # noqa: E501

            server_files ([str]):  Paths to files from a file share mounted on the server, or from a cloud storage. Must contain all files from job_file_mapping if job_file_mapping is not empty. . [optional] if omitted the server will use the default value of []  # noqa: E501

            remote_files ([str]):  Direct download URLs for files. Must contain all files from job_file_mapping if job_file_mapping is not empty. . [optional] if omitted the server will use the default value of []  # noqa: E501

            use_zip_chunks (bool): When true, video chunks will be represented as zip archives with decoded video frames. When false, video chunks are represented as video segments . [optional] if omitted the server will use the default value of False  # noqa: E501

            server_files_exclude ([str]): Paths to files and directories from a file share mounted on the server, or from a cloud storage that should be excluded from the directories specified in server_files. This option cannot be used together with filename_pattern. The server_files_exclude parameter cannot be used to exclude a part of dataset from an archive.  Examples:  Exclude all files from subfolder 'sub/sub_1/sub_2'and single file 'sub/image.jpg' from specified folder: server_files = ['sub/'], server_files_exclude = ['sub/sub_1/sub_2/', 'sub/image.jpg']  Exclude all cloud storage files with prefix 'sub' from the content of manifest file: server_files = ['manifest.jsonl'], server_files_exclude = ['sub/'] . [optional] if omitted the server will use the default value of []  # noqa: E501

            cloud_storage_id (int, none_type): If not null, the files referenced by server_files will be retrieved from the cloud storage with the specified ID. The cloud storages applicable depend on the context. In the user sandbox, only the user sandbox cloud storages can be used. In an organization, only the organization cloud storages can be used. . [optional]  # noqa: E501

            use_cache (bool): Enable or disable task data chunk caching for the task. Read more: https://docs.cvat.ai/docs/manual/advanced/data_on_fly/ . [optional] if omitted the server will use the default value of False  # noqa: E501

            copy_data (bool): Copy data from the server file share to CVAT during the task creation. This will create a copy of the data, making the server independent from the file share availability . [optional] if omitted the server will use the default value of False  # noqa: E501

            storage_method (StorageMethod): [optional]  # noqa: E501

            storage (StorageType): [optional]  # noqa: E501

            sorting_method (SortingMethod): [optional]  # noqa: E501

            filename_pattern (str, none_type): A filename filter for cloud storage files listed in the manifest. Supports fnmatch wildcards. Read more: https://docs.python.org/3/library/fnmatch.html . [optional]  # noqa: E501

            job_file_mapping ([[str]]):  Represents a file-to-job mapping. Useful to specify a custom job configuration during task creation. This option is not compatible with most other job split-related options. Files in the jobs must not overlap or repeat. Job file mapping files must be a subset of the input files. If directories are specified in server_files, all files obtained by recursive search in the specified directories will be used as input files. In case of missing items in the input files, an error will be raised.  Example: [      [\"file1.jpg\", \"file2.jpg\"], # job #1 files     [\"file3.png\"], # job #2 files     [\"file4.jpg\", \"file5.png\", \"file6.bmp\"], # job #3 files ] . [optional]  # noqa: E501

            upload_file_order ([str]): Allows to specify file order for client_file uploads. Only valid with the \"predefined\" sorting method selected.  To state that the input files are sent in the correct order, pass an empty list.  If you want to send files in an arbitrary order and reorder them afterwards on the server, pass the list of file names in the required order. . [optional]  # noqa: E501

            validation_params (DataRequestValidationParams): [optional]  # noqa: E501

            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
"""

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.image_quality = image_quality
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

