/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.security.auth.login.FailedLoginException;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.AppConfig;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.ConnectionManager;
import org.datadog.jmxfetch.JMXAttribute;
import org.datadog.jmxfetch.JMXComplexAttribute;
import org.datadog.jmxfetch.JMXSimpleAttribute;
import org.datadog.jmxfetch.Reporter;
import org.datadog.jmxfetch.YamlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instance {
    private static final Logger LOGGER = Logger.getLogger(Instance.class.getName());
    private static final List<String> SIMPLE_TYPES = Arrays.asList("long", "java.lang.String", "int", "double", "java.lang.Double", "java.lang.Integer", "java.lang.Long", "java.util.concurrent.atomic.AtomicInteger", "java.util.concurrent.atomic.AtomicLong", "java.lang.Object", "java.lang.Boolean", "boolean", "java.lang.Number");
    private static final List<String> COMPOSED_TYPES = Arrays.asList("javax.management.openmbean.CompositeData", "java.util.HashMap");
    private static final int MAX_RETURNED_METRICS = 350;
    private Set<ObjectInstance> _beans;
    private LinkedList<Configuration> _configurationList = new LinkedList();
    private LinkedList<JMXAttribute> _matchingAttributes;
    private LinkedList<JMXAttribute> _failingAttributes;
    private Integer _refreshBeansPeriod;
    private long _lastRefreshTime;
    private LinkedHashMap<String, Object> _yaml;
    private LinkedHashMap<String, Object> _initConfig;
    private String _instanceName;
    private LinkedHashMap<String, String> _tags;
    private String _checkName;
    private int _maxReturnedMetrics;
    private boolean _limitReached;
    private Connection _connection;
    private AppConfig config;

    public Instance(LinkedHashMap<String, Object> yamlInstance, LinkedHashMap<String, Object> init_config, String checkName, AppConfig config) {
        Object yaml_conf;
        this.config = config;
        this._yaml = yamlInstance;
        this._initConfig = init_config;
        this._instanceName = (String)this._yaml.get("name");
        this._tags = (LinkedHashMap)this._yaml.get("tags");
        this._checkName = checkName;
        this._failingAttributes = new LinkedList();
        this._refreshBeansPeriod = (Integer)this._yaml.get("refresh_beans");
        if (this._refreshBeansPeriod == null) {
            this._refreshBeansPeriod = 600;
        }
        this._lastRefreshTime = 0L;
        this._limitReached = false;
        Object maxReturnedMetrics = this._yaml.get("max_returned_metrics");
        this._maxReturnedMetrics = maxReturnedMetrics == null ? 350 : (Integer)maxReturnedMetrics;
        if (this._instanceName == null) {
            this._instanceName = this._checkName + "-" + this._yaml.get("host") + "-" + this._yaml.get("port");
        }
        if ((yaml_conf = this._yaml.get("conf")) == null && this._initConfig != null) {
            yaml_conf = this._initConfig.get("conf");
        }
        if (yaml_conf == null) {
            LOGGER.warn("Cannot find a \"conf\" section in " + this._instanceName);
        } else {
            for (LinkedHashMap conf : (ArrayList)yaml_conf) {
                this._configurationList.add(new Configuration(conf));
            }
        }
        this._configurationList.add(new Configuration((LinkedHashMap)new YamlParser(this.getClass().getResourceAsStream("/jmx-1.yaml")).getParsedYaml()));
        this._configurationList.add(new Configuration((LinkedHashMap)new YamlParser(this.getClass().getResourceAsStream("/jmx-2.yaml")).getParsedYaml()));
    }

    public void init(boolean forceNewConnection) throws IOException, FailedLoginException, SecurityException {
        LOGGER.info("Trying to connect to JMX Server at " + this.toString());
        this._connection = ConnectionManager.getInstance().getConnection(this._yaml, forceNewConnection);
        LOGGER.info("Connected to JMX Server at " + this.toString());
        this._refreshBeansList();
        this._getMatchingAttributes();
    }

    public void init() throws IOException, FailedLoginException, SecurityException {
        this.init(false);
    }

    public String toString() {
        return this._yaml.get("host") + ":" + this._yaml.get("port");
    }

    public LinkedList<HashMap<String, Object>> getMetrics() throws IOException {
        if (this._refreshBeansPeriod != null && (System.currentTimeMillis() - this._lastRefreshTime) / 1000L > (long)this._refreshBeansPeriod.intValue()) {
            LOGGER.info("Refreshing bean list");
            this._refreshBeansList();
            this._getMatchingAttributes();
        }
        LinkedList<HashMap<String, Object>> metrics = new LinkedList<HashMap<String, Object>>();
        Iterator it = this._matchingAttributes.iterator();
        while (it.hasNext()) {
            JMXAttribute jmxAttr = (JMXAttribute)it.next();
            try {
                LinkedList<HashMap<String, Object>> attribute_metrics = jmxAttr.getMetrics();
                for (HashMap hashMap : attribute_metrics) {
                    hashMap.put("check_name", this._checkName);
                    metrics.add(hashMap);
                }
                if (!this._failingAttributes.contains(jmxAttr)) continue;
                this._failingAttributes.remove(jmxAttr);
            }
            catch (Exception e) {
                LOGGER.debug("Cannot get metrics for attribute: " + jmxAttr, e);
                if (this._failingAttributes.contains(jmxAttr)) {
                    LOGGER.debug("Cannot generate metrics for attribute: " + jmxAttr + " twice in a row. Removing it from the attribute list");
                    it.remove();
                    continue;
                }
                this._failingAttributes.add(jmxAttr);
            }
        }
        return metrics;
    }

    private void _getMatchingAttributes() {
        Reporter reporter = this.config.reporter;
        String action = this.config.getAction();
        boolean metricReachedDisplayed = false;
        this._matchingAttributes = new LinkedList();
        int metricsCount = 0;
        if (!action.equals("collect")) {
            reporter.displayInstanceName(this);
        }
        block4: for (ObjectInstance bean : this._beans) {
            MBeanAttributeInfo[] atr;
            if (this._limitReached) {
                LOGGER.debug("Limit reached");
                if (action.equals("collect")) break;
            }
            ObjectName beanName = bean.getObjectName();
            try {
                LOGGER.debug("Getting attributes for bean: " + beanName);
                atr = this._connection.getAttributesForBean(beanName);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot get bean attributes " + e.getMessage());
                continue;
            }
            for (MBeanAttributeInfo a : atr) {
                JMXAttribute jmxAttribute;
                String attributeType;
                if (metricsCount >= this._maxReturnedMetrics) {
                    this._limitReached = true;
                    if (action.equals("collect")) {
                        LOGGER.warn("Maximum number of metrics reached.");
                        continue block4;
                    }
                    if (!(metricReachedDisplayed || action.equals("list_collected_attributes") || action.equals("list_not_matching_attributes"))) {
                        reporter.displayMetricReached();
                        metricReachedDisplayed = true;
                    }
                }
                if (SIMPLE_TYPES.contains(attributeType = a.getType())) {
                    LOGGER.debug("Attribute: " + beanName + " : " + a + " has a simple type");
                    jmxAttribute = new JMXSimpleAttribute(a, bean, this._instanceName, this._connection, this._tags);
                } else if (COMPOSED_TYPES.contains(attributeType)) {
                    LOGGER.debug("Attribute: " + beanName + " : " + a + " has a complex type");
                    jmxAttribute = new JMXComplexAttribute(a, bean, this._instanceName, this._connection, this._tags);
                } else {
                    LOGGER.debug("Attribute: " + beanName + " : " + a + " has an unsupported type: " + attributeType);
                    continue;
                }
                for (Configuration conf : this._configurationList) {
                    try {
                        if (!jmxAttribute.match(conf)) continue;
                        jmxAttribute.matching_conf = conf;
                        metricsCount += jmxAttribute.getMetricsCount();
                        this._matchingAttributes.add(jmxAttribute);
                        if (!action.equals("list_everything") && !action.equals("list_matching_attributes") && (!action.equals("list_collected_attributes") || this._limitReached) && (!action.equals("list_limited_attributes") || !this._limitReached)) break;
                        reporter.displayMatchingAttributeName(jmxAttribute, metricsCount, this._maxReturnedMetrics);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while trying to match a configuration with the Attribute: " + beanName + " : " + a, e);
                    }
                }
                if (jmxAttribute.matching_conf != null || !action.equals("list_everything") && !action.equals("list_not_matching_attributes")) continue;
                reporter.displayNonMatchingAttributeName(jmxAttribute);
            }
        }
        LOGGER.info("Found " + this._matchingAttributes.size() + " matching attributes");
    }

    private void _refreshBeansList() throws IOException {
        this._beans = this._connection.queryMBeans();
        this._lastRefreshTime = System.currentTimeMillis();
    }

    public String getName() {
        return this._instanceName;
    }

    public LinkedHashMap<String, String> getTags() {
        return this._tags;
    }

    public LinkedHashMap<String, Object> getYaml() {
        return this._yaml;
    }

    public LinkedHashMap<String, Object> getInitConfig() {
        return this._initConfig;
    }

    public String getCheckName() {
        return this._checkName;
    }

    public int getMaxNumberOfMetrics() {
        return this._maxReturnedMetrics;
    }

    public boolean isLimitReached() {
        return this._limitReached;
    }
}

