/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectInstance;
import javax.management.ReflectionException;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.JMXAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXSimpleAttribute
extends JMXAttribute {
    private String _alias = null;
    private String _metricType;

    public JMXSimpleAttribute(MBeanAttributeInfo a, ObjectInstance instance, String instance_name, Connection connection, HashMap<String, String> instanceTags) {
        super(a, instance, instance_name, connection, instanceTags);
    }

    @Override
    public LinkedList<HashMap<String, Object>> getMetrics() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        HashMap<String, Object> metric = new HashMap<String, Object>();
        metric.put("alias", this._getAlias());
        metric.put("value", this._getValue());
        metric.put("tags", this.tags);
        metric.put("metric_type", this._getMetricType());
        LinkedList<HashMap<String, Object>> metrics = new LinkedList<HashMap<String, Object>>();
        metrics.add(metric);
        return metrics;
    }

    @Override
    public boolean match(Configuration configuration) {
        return this.matchDomain(configuration) && this.matchBean(configuration) && this.matchAttribute(configuration) && !this.excludeMatchDomain(configuration) && !this.excludeMatchBean(configuration) && !this._excludeMatchAttribute(configuration);
    }

    private boolean _excludeMatchAttribute(Configuration configuration) {
        if (configuration.exclude.get("attribute") == null) {
            return false;
        }
        if (configuration.exclude.get("attribute") instanceof LinkedHashMap && ((LinkedHashMap)configuration.exclude.get("attribute")).containsKey(this.attributeName)) {
            return true;
        }
        return configuration.exclude.get("attribute") instanceof ArrayList && ((ArrayList)configuration.exclude.get("attribute")).contains(this.attributeName);
    }

    private boolean matchAttribute(Configuration configuration) {
        if (configuration.include.get("attribute") == null) {
            return true;
        }
        if (configuration.include.get("attribute") instanceof LinkedHashMap && ((LinkedHashMap)configuration.include.get("attribute")).containsKey(this.attributeName)) {
            return true;
        }
        return configuration.include.get("attribute") instanceof ArrayList && ((ArrayList)configuration.include.get("attribute")).contains(this.attributeName);
    }

    private String _getAlias() {
        if (this._alias != null) {
            return this._alias;
        }
        this._alias = this.matching_conf.include.get("attribute") instanceof LinkedHashMap ? (String)((LinkedHashMap)((LinkedHashMap)this.matching_conf.include.get("attribute")).get(this.attribute.getName())).get("alias") : (this.matching_conf.conf.get("metric_prefix") != null ? this.matching_conf.conf.get("metric_prefix") + "." + this.beanName.split(":")[0] + "." + this.attributeName : "jmx." + this.beanName.split(":")[0] + "." + this.attributeName);
        this._alias = JMXSimpleAttribute.convertMetricName(this._alias);
        return this._alias;
    }

    private String _getMetricType() {
        if (this._metricType != null) {
            return this._metricType;
        }
        if (this.matching_conf.include.get("attribute") instanceof LinkedHashMap) {
            this._metricType = (String)((LinkedHashMap)((LinkedHashMap)this.matching_conf.include.get("attribute")).get(this.attributeName)).get("metric_type");
            if (this._metricType == null) {
                this._metricType = (String)((LinkedHashMap)((LinkedHashMap)this.matching_conf.include.get("attribute")).get(this.attributeName)).get("type");
            }
        }
        if (this._metricType == null) {
            this._metricType = "gauge";
        }
        return this._metricType;
    }

    private double _getValue() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, NumberFormatException {
        Object value = this.getJmxValue();
        return this._getValueAsDouble(value);
    }
}

