from typing import overload
import datetime
import typing

import QuantConnect.Algorithm.Framework.Alphas
import QuantConnect.Algorithm.Framework.Alphas.Analysis


class InsightManager(QuantConnect.Algorithm.Framework.Alphas.InsightCollection):
    """Encapsulates the storage of insights."""

    @overload
    def SetInsightScoreFunction(self, insightScoreFunction: QuantConnect.Algorithm.Framework.Alphas.IInsightScoreFunction) -> None:
        """
        Sets the insight score function to use
        
        :param insightScoreFunction: Model that scores insights
        """
        ...

    @overload
    def SetInsightScoreFunction(self, insightScoreFunction: typing.Any) -> None:
        """
        Sets the insight score function to use
        
        :param insightScoreFunction: Model that scores insights
        """
        ...

    def Step(self, utcNow: typing.Union[datetime.datetime, datetime.date]) -> None:
        """
        Process a new time step handling insights scoring
        
        :param utcNow: The current utc time
        """
        ...


