from typing import overload
import abc
import typing

import System
import System.Runtime.Intrinsics
import System.Runtime.Intrinsics.X86


class X86Base(System.Object, metaclass=abc.ABCMeta):
    """This class provides access to the x86 base hardware instructions via intrinsics"""

    class X64(System.Object, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """
            unsigned __int64 _udiv128(unsigned __int64 highdividend, unsigned __int64 lowdividend, unsigned __int64 divisor, unsigned __int64* remainder)
              DIV reg/m64
            """
            ...

        @staticmethod
        @overload
        def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """
            __int64 _div128(__int64 highdividend, __int64 lowdividend, __int64 divisor, __int64* remainder)
              DIV reg/m64
            """
            ...

        @staticmethod
        @overload
        def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """
            unsigned __int64 _udiv128(unsigned __int64 highdividend, unsigned __int64 lowdividend, unsigned __int64 divisor, unsigned __int64* remainder)
              DIV reg/m64
            """
            ...

        @staticmethod
        @overload
        def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """
            __int64 _div128(__int64 highdividend, __int64 lowdividend, __int64 divisor, __int64* remainder)
              DIV reg/m64
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def CpuId(functionId: int, subFunctionId: int) -> System.ValueTuple[int, int, int, int]:
        """
        void __cpuidex (int cpuInfo[4], int function_id, int subfunction_id);
          CPUID
        """
        ...

    @staticmethod
    @overload
    def CpuId(functionId: int, subFunctionId: int) -> System.ValueTuple[int, int, int, int]:
        """
        void __cpuidex (int cpuInfo[4], int function_id, int subfunction_id);
          CPUID
        """
        ...

    @staticmethod
    @overload
    def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """DIV reg/m32"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """IDIV reg/m32"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: System.UIntPtr, upper: System.UIntPtr, divisor: System.UIntPtr) -> System.ValueTuple[System.UIntPtr, System.UIntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: System.UIntPtr, upper: System.IntPtr, divisor: System.IntPtr) -> System.ValueTuple[System.IntPtr, System.IntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """
        unsigned _udiv64(unsigned __int64 dividend, unsigned divisor, unsigned* remainder)
          DIV reg/m32
        """
        ...

    @staticmethod
    @overload
    def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """
        int _div64(__int64 dividend, int divisor, int* remainder)
          IDIV reg/m32
        """
        ...

    @staticmethod
    @overload
    def DivRem(lower: System.UIntPtr, upper: System.UIntPtr, divisor: System.UIntPtr) -> System.ValueTuple[System.UIntPtr, System.UIntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: System.UIntPtr, upper: System.IntPtr, divisor: System.IntPtr) -> System.ValueTuple[System.IntPtr, System.IntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def Pause() -> None:
        """
        void _mm_pause (void);
          PAUSE
        """
        ...

    @staticmethod
    @overload
    def Pause() -> None:
        """
        void _mm_pause (void);
          PAUSE
        """
        ...


class Sse(System.Runtime.Intrinsics.X86.X86Base, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.X86Base.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """
            __m128 _mm_cvtsi64_ss (__m128 a, __int64 b)
              CVTSI2SS xmm, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """
            __m128 _mm_cvtsi64_ss (__m128 a, __int64 b)
              CVTSI2SS xmm, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvtss_si64 (__m128 a)
              CVTSS2SI r64, xmm/m32
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvtss_si64 (__m128 a)
              CVTSS2SI r64, xmm/m32
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvttss_si64 (__m128 a)
              CVTTSS2SI r64, xmm/m32
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvttss_si64 (__m128 a)
              CVTTSS2SI r64, xmm/m32
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_add_ps (__m128 a,  __m128 b)
          ADDPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_add_ps (__m128 a,  __m128 b)
          ADDPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_add_ss (__m128 a,  __m128 b)
          ADDSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def AddScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_add_ss (__m128 a,  __m128 b)
          ADDSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_and_ps (__m128 a, __m128 b)
          ANDPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_and_ps (__m128 a, __m128 b)
          ANDPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_andnot_ps (__m128 a, __m128 b)
          ANDNPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_andnot_ps (__m128 a, __m128 b)
          ANDNPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpeq_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpeq_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpgt_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(1) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpgt_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(1) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpge_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(2) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpge_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(2) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmplt_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmplt_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmple_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmple_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpneq_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpneq_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpngt_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(5) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpngt_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(5) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnge_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(6) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnge_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(6) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnlt_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnlt_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnle_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnle_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpord_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpord_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpeq_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpeq_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpgt_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(1) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpgt_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(1) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpge_ss (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m32, imm8(2) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpge_ss (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m32, imm8(2) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmplt_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmplt_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmple_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmple_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpneq_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpneq_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpngt_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(5) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpngt_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(5) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnge_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(6) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnge_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(6) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnlt_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnlt_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnle_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnle_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpord_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpord_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comieq_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comieq_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comigt_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comigt_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comige_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comige_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comilt_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comilt_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comile_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comile_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comineq_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comineq_ss (__m128 a, __m128 b)
          COMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpunord_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpunord_ss (__m128 a,  __m128 b)
          CMPSS xmm, xmm/m32, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomieq_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomieq_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomigt_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomigt_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomige_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomige_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomilt_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomilt_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomile_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomile_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomineq_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomineq_ss (__m128 a, __m128 b)
          UCOMISS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpunord_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpunord_ps (__m128 a,  __m128 b)
          CMPPS xmm, xmm/m128, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtsi32_ss (__m128 a, int b)
          CVTSI2SS xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtsi32_ss (__m128 a, int b)
          CVTSI2SS xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvtss_si32 (__m128 a)
          CVTSS2SI r32, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvtss_si32 (__m128 a)
          CVTSS2SI r32, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvttss_si32 (__m128 a)
          CVTTSS2SI r32, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvttss_si32 (__m128 a)
          CVTTSS2SI r32, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_div_ps (__m128 a,  __m128 b)
          DIVPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_div_ps (__m128 a,  __m128 b)
          DIVPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def DivideScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_div_ss (__m128 a,  __m128 b)
          DIVSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def DivideScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_div_ss (__m128 a,  __m128 b)
          DIVSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_load_ps (float const* mem_address)
          MOVAPS xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_load_ps (float const* mem_address)
          MOVAPS xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadHigh(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadh_pi (__m128 a, __m64 const* mem_addr)
          MOVHPS xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadHigh(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadh_pi (__m128 a, __m64 const* mem_addr)
          MOVHPS xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadLow(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadl_pi (__m128 a, __m64 const* mem_addr)
          MOVLPS xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadLow(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadl_pi (__m128 a, __m64 const* mem_addr)
          MOVLPS xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_load_ss (float const* mem_address)
          MOVSS xmm, m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_load_ss (float const* mem_address)
          MOVSS xmm, m32
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadu_ps (float const* mem_address)
          MOVUPS xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadu_ps (float const* mem_address)
          MOVUPS xmm, m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_max_ps (__m128 a,  __m128 b)
          MAXPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_max_ps (__m128 a,  __m128 b)
          MAXPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MaxScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_max_ss (__m128 a,  __m128 b)
          MAXSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MaxScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_max_ss (__m128 a,  __m128 b)
          MAXSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_min_ps (__m128 a,  __m128 b)
          MINPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_min_ps (__m128 a,  __m128 b)
          MINPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MinScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_min_ss (__m128 a,  __m128 b)
          MINSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MinScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_min_ss (__m128 a,  __m128 b)
          MINSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MoveHighToLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movehl_ps (__m128 a,  __m128 b)
          MOVHLPS xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveHighToLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movehl_ps (__m128 a,  __m128 b)
          MOVHLPS xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveLowToHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movelh_ps (__m128 a,  __m128 b)
          MOVLHPS xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveLowToHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movelh_ps (__m128 a,  __m128 b)
          MOVLHPS xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_movemask_ps (__m128 a)
          MOVMSKPS reg, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_movemask_ps (__m128 a)
          MOVMSKPS reg, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_move_ss (__m128 a, __m128 b)
          MOVSS xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_move_ss (__m128 a, __m128 b)
          MOVSS xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mul_ps (__m128 a, __m128 b)
          MULPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mul_ps (__m128 a, __m128 b)
          MULPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mul_ss (__m128 a, __m128 b)
          MULPS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplyScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mul_ss (__m128 a, __m128 b)
          MULPS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_or_ps (__m128 a,  __m128 b)
          ORPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_or_ps (__m128 a,  __m128 b)
          ORPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Prefetch0(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT0 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch0(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT0 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch1(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT1 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch1(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT1 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch2(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT2 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch2(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT2 m8
        """
        ...

    @staticmethod
    @overload
    def PrefetchNonTemporal(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHNTA m8
        """
        ...

    @staticmethod
    @overload
    def PrefetchNonTemporal(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHNTA m8
        """
        ...

    @staticmethod
    @overload
    def Reciprocal(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ps (__m128 a)
          RCPPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Reciprocal(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ps (__m128 a)
          RCPPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ReciprocalScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ss (__m128 a)
          RCPSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def ReciprocalScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ss (__m128 a, __m128 b)
          RCPSS xmm, xmm/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def ReciprocalScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ss (__m128 a)
          RCPSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def ReciprocalScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ss (__m128 a, __m128 b)
          RCPSS xmm, xmm/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ps (__m128 a)
          RSQRTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ps (__m128 a)
          RSQRTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ss (__m128 a)
          RSQRTSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ss (__m128 a, __m128 b)
          RSQRTSS xmm, xmm/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ss (__m128 a)
          RSQRTSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ss (__m128 a, __m128 b)
          RSQRTSS xmm, xmm/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def Shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_shuffle_ps (__m128 a,  __m128 b, unsigned int control)
          SHUFPS xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_shuffle_ps (__m128 a,  __m128 b, unsigned int control)
          SHUFPS xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ps (__m128 a)
          SQRTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ps (__m128 a)
          SQRTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ss (__m128 a)
          SQRTSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ss (__m128 a, __m128 b)
          SQRTSS xmm, xmm/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ss (__m128 a)
          SQRTSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ss (__m128 a, __m128 b)
          SQRTSS xmm, xmm/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeu_ps (float* mem_addr, __m128 a)
          MOVUPS m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeu_ps (float* mem_addr, __m128 a)
          MOVUPS m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_ps (float* mem_addr, __m128 a)
          MOVAPS m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_ps (float* mem_addr, __m128 a)
          MOVAPS m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_stream_ps (float* mem_addr, __m128 a)
          MOVNTPS m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_stream_ps (float* mem_addr, __m128 a)
          MOVNTPS m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreFence() -> None:
        """
        void _mm_sfence(void)
          SFENCE
        """
        ...

    @staticmethod
    @overload
    def StoreFence() -> None:
        """
        void _mm_sfence(void)
          SFENCE
        """
        ...

    @staticmethod
    @overload
    def StoreHigh(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeh_pi (__m64* mem_addr, __m128 a)
          MOVHPS m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreHigh(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeh_pi (__m64* mem_addr, __m128 a)
          MOVHPS m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreLow(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storel_pi (__m64* mem_addr, __m128 a)
          MOVLPS m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreLow(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storel_pi (__m64* mem_addr, __m128 a)
          MOVLPS m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_ss (float* mem_addr, __m128 a)
          MOVSS m32, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_ss (float* mem_addr, __m128 a)
          MOVSS m32, xmm
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_ps (__m128d a, __m128d b)
          SUBPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_ps (__m128d a, __m128d b)
          SUBPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sub_ss (__m128 a, __m128 b)
          SUBSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def SubtractScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sub_ss (__m128 a, __m128 b)
          SUBSS xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_unpackhi_ps (__m128 a,  __m128 b)
          UNPCKHPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_unpackhi_ps (__m128 a,  __m128 b)
          UNPCKHPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_unpacklo_ps (__m128 a,  __m128 b)
          UNPCKLPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_unpacklo_ps (__m128 a,  __m128 b)
          UNPCKLPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_xor_ps (__m128 a,  __m128 b)
          XORPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_xor_ps (__m128 a,  __m128 b)
          XORPS xmm, xmm/m128
        """
        ...


class Sse2(System.Runtime.Intrinsics.X86.Sse, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE2 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """
            __m128d _mm_cvtsi64_sd (__m128d a, __int64 b)
              CVTSI2SD xmm, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """
            __m128d _mm_cvtsi64_sd (__m128d a, __int64 b)
              CVTSI2SD xmm, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128Int64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_cvtsi64_si128 (__int64 a)
              MOVQ xmm, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128Int64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_cvtsi64_si128 (__int64 a)
              MOVQ xmm, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128UInt64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_cvtsi64_si128 (__int64 a)
              MOVQ xmm, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128UInt64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_cvtsi64_si128 (__int64 a)
              MOVQ xmm, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvtsd_si64 (__m128d a)
              CVTSD2SI r64, xmm/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """
            __int64 _mm_cvtsi128_si64 (__m128i a)
              MOVQ reg/m64, xmm
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvtsd_si64 (__m128d a)
              CVTSD2SI r64, xmm/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """
            __int64 _mm_cvtsi128_si64 (__m128i a)
              MOVQ reg/m64, xmm
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvttsd_si64 (__m128d a)
              CVTTSD2SI reg, xmm/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvttsd_si64 (__m128d a)
              CVTTSD2SI reg, xmm/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToUInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """
            __int64 _mm_cvtsi128_si64 (__m128i a)
              MOVQ reg/m64, xmm
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToUInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """
            __int64 _mm_cvtsi128_si64 (__m128i a)
              MOVQ reg/m64, xmm
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def StoreNonTemporal(address: typing.Any, value: int) -> None:
            """
            void _mm_stream_si64(__int64 *p, __int64 a)
              MOVNTI m64, r64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def StoreNonTemporal(address: typing.Any, value: int) -> None:
            """
            void _mm_stream_si64(__int64 *p, __int64 a)
              MOVNTI m64, r64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def StoreNonTemporal(address: typing.Any, value: int) -> None:
            """
            void _mm_stream_si64(__int64 *p, __int64 a)
              MOVNTI m64, r64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def StoreNonTemporal(address: typing.Any, value: int) -> None:
            """
            void _mm_stream_si64(__int64 *p, __int64 a)
              MOVNTI m64, r64
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi8 (__m128i a,  __m128i b)
          PADDB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi8 (__m128i a,  __m128i b)
          PADDB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi16 (__m128i a,  __m128i b)
          PADDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi16 (__m128i a,  __m128i b)
          PADDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi32 (__m128i a,  __m128i b)
          PADDD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi32 (__m128i a,  __m128i b)
          PADDD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi64 (__m128i a,  __m128i b)
          PADDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi64 (__m128i a,  __m128i b)
          PADDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_add_pd (__m128d a,  __m128d b)
          ADDPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi8 (__m128i a,  __m128i b)
          PADDB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi8 (__m128i a,  __m128i b)
          PADDB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi16 (__m128i a,  __m128i b)
          PADDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi16 (__m128i a,  __m128i b)
          PADDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi32 (__m128i a,  __m128i b)
          PADDD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi32 (__m128i a,  __m128i b)
          PADDD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi64 (__m128i a,  __m128i b)
          PADDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi64 (__m128i a,  __m128i b)
          PADDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_add_pd (__m128d a,  __m128d b)
          ADDPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epi8 (__m128i a,  __m128i b)
          PADDSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epu8 (__m128i a,  __m128i b)
          PADDUSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epi16 (__m128i a,  __m128i b)
          PADDSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epu16 (__m128i a,  __m128i b)
          PADDUSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epi8 (__m128i a,  __m128i b)
          PADDSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epu8 (__m128i a,  __m128i b)
          PADDUSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epi16 (__m128i a,  __m128i b)
          PADDSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epu16 (__m128i a,  __m128i b)
          PADDUSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_add_sd (__m128d a,  __m128d b)
          ADDSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def AddScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_add_sd (__m128d a,  __m128d b)
          ADDSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_and_pd (__m128d a, __m128d b)
          ANDPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
          PAND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_and_pd (__m128d a, __m128d b)
          ANDPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_andnot_pd (__m128d a, __m128d b)
          ADDNPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
          PANDN xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_andnot_pd (__m128d a, __m128d b)
          ADDNPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_avg_epu8 (__m128i a,  __m128i b)
          PAVGB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_avg_epu16 (__m128i a,  __m128i b)
          PAVGW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_avg_epu8 (__m128i a,  __m128i b)
          PAVGB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_avg_epu16 (__m128i a,  __m128i b)
          PAVGW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)
          PCMPEQB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)
          PCMPEQB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)
          PCMPEQW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)
          PCMPEQW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)
          PCMPEQD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)
          PCMPEQD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpeq_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)
          PCMPEQB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)
          PCMPEQB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)
          PCMPEQW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)
          PCMPEQW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)
          PCMPEQD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)
          PCMPEQD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpeq_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi8 (__m128i a,  __m128i b)
          PCMPGTB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi16 (__m128i a,  __m128i b)
          PCMPGTW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi32 (__m128i a,  __m128i b)
          PCMPGTD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpgt_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(1) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi8 (__m128i a,  __m128i b)
          PCMPGTB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi16 (__m128i a,  __m128i b)
          PCMPGTW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi32 (__m128i a,  __m128i b)
          PCMPGTD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpgt_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(1) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpge_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(2) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpge_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(2) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi8 (__m128i a,  __m128i b)
          PCMPGTB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi16 (__m128i a,  __m128i b)
          PCMPGTW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi32 (__m128i a,  __m128i b)
          PCMPGTD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmplt_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi8 (__m128i a,  __m128i b)
          PCMPGTB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi16 (__m128i a,  __m128i b)
          PCMPGTW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi32 (__m128i a,  __m128i b)
          PCMPGTD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmplt_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmple_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmple_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpneq_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpneq_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpngt_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(5) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpngt_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(5) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnge_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(6) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnge_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(6) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnlt_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnlt_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnle_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnle_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpord_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpord_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpeq_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpeq_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpgt_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(1) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpgt_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(1) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpge_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(2) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpge_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(2) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmplt_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmplt_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmple_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmple_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpneq_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpneq_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpngt_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(5) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpngt_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(5) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnge_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(6) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnge_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(6) with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnlt_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnlt_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnle_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnle_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpord_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpord_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comieq_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comieq_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comigt_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comigt_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comige_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comige_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comilt_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comilt_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comile_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comile_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comineq_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comineq_sd (__m128d a, __m128d b)
          COMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpunord_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpunord_sd (__m128d a,  __m128d b)
          CMPSD xmm, xmm/m64, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomieq_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomieq_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomigt_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomigt_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomige_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomige_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomilt_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomilt_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomile_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomile_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomineq_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomineq_sd (__m128d a, __m128d b)
          UCOMISD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpunord_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpunord_pd (__m128d a,  __m128d b)
          CMPPD xmm, xmm/m128, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtsi32_sd (__m128d a, int b)
          CVTSI2SD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtss_sd (__m128d a, __m128 b)
          CVTSS2SD xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtsi32_sd (__m128d a, int b)
          CVTSI2SD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtss_sd (__m128d a, __m128 b)
          CVTSS2SD xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Int32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtsi32_si128 (int a)
          MOVD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Int32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtsi32_si128 (int a)
          MOVD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtsd_ss (__m128 a, __m128d b)
          CVTSD2SS xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtsd_ss (__m128 a, __m128d b)
          CVTSD2SS xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128UInt32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtsi32_si128 (int a)
          MOVD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128UInt32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtsi32_si128 (int a)
          MOVD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvtsd_si32 (__m128d a)
          CVTSD2SI r32, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_cvtsi128_si32 (__m128i a)
          MOVD reg/m32, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvtsd_si32 (__m128d a)
          CVTSD2SI r32, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_cvtsi128_si32 (__m128i a)
          MOVD reg/m32, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvttsd_si32 (__m128d a)
          CVTTSD2SI reg, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvttsd_si32 (__m128d a)
          CVTTSD2SI reg, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToUInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_cvtsi128_si32 (__m128i a)
          MOVD reg/m32, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToUInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_cvtsi128_si32 (__m128i a)
          MOVD reg/m32, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtepi32_pd (__m128i a)
          CVTDQ2PD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtps_pd (__m128 a)
          CVTPS2PD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtepi32_pd (__m128i a)
          CVTDQ2PD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtps_pd (__m128 a)
          CVTPS2PD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtps_epi32 (__m128 a)
          CVTPS2DQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtpd_epi32 (__m128d a)
          CVTPD2DQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtps_epi32 (__m128 a)
          CVTPS2DQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtpd_epi32 (__m128d a)
          CVTPD2DQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvttps_epi32 (__m128 a)
          CVTTPS2DQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvttpd_epi32 (__m128d a)
          CVTTPD2DQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvttps_epi32 (__m128 a)
          CVTTPS2DQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvttpd_epi32 (__m128d a)
          CVTTPD2DQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtepi32_ps (__m128i a)
          CVTDQ2PS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtpd_ps (__m128d a)
          CVTPD2PS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtepi32_ps (__m128i a)
          CVTDQ2PS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtpd_ps (__m128d a)
          CVTPD2PS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_div_pd (__m128d a,  __m128d b)
          DIVPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_div_pd (__m128d a,  __m128d b)
          DIVPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def DivideScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_div_sd (__m128d a,  __m128d b)
          DIVSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def DivideScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_div_sd (__m128d a,  __m128d b)
          DIVSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi16 (__m128i a,  int immediate)
          PEXTRW reg, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi16 (__m128i a,  int immediate)
          PEXTRW reg, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)
          PINSRW xmm, reg/m16, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)
          PINSRW xmm, reg/m16, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)
          PINSRW xmm, reg/m16, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)
          PINSRW xmm, reg/m16, imm8
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_load_pd (double const* mem_address)
          MOVAPD xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_load_pd (double const* mem_address)
          MOVAPD xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadFence() -> None:
        """
        void _mm_lfence(void)
          LFENCE
        """
        ...

    @staticmethod
    @overload
    def LoadFence() -> None:
        """
        void _mm_lfence(void)
          LFENCE
        """
        ...

    @staticmethod
    @overload
    def LoadHigh(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadh_pd (__m128d a, double const* mem_addr)
          MOVHPD xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadHigh(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadh_pd (__m128d a, double const* mem_addr)
          MOVHPD xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadLow(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadl_pd (__m128d a, double const* mem_addr)
          MOVLPD xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadLow(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadl_pd (__m128d a, double const* mem_addr)
          MOVLPD xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_load_sd (double const* mem_address)
          MOVSD xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si32 (void const* mem_addr)
          MOVD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si32 (void const* mem_addr)
          MOVD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadl_epi64 (__m128i const* mem_addr)
          MOVQ xmm, reg/m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadl_epi64 (__m128i const* mem_addr)
          MOVQ xmm, reg/m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_load_sd (double const* mem_address)
          MOVSD xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si32 (void const* mem_addr)
          MOVD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si32 (void const* mem_addr)
          MOVD xmm, reg/m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadl_epi64 (__m128i const* mem_addr)
          MOVQ xmm, reg/m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadl_epi64 (__m128i const* mem_addr)
          MOVQ xmm, reg/m64
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadu_pd (double const* mem_address)
          MOVUPD xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
          MOVDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadu_pd (double const* mem_address)
          MOVUPD xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskMove(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """
        void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)
          MASKMOVDQU xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskMove(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """
        void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)
          MASKMOVDQU xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskMove(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """
        void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)
          MASKMOVDQU xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskMove(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """
        void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)
          MASKMOVDQU xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu8 (__m128i a,  __m128i b)
          PMAXUB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi16 (__m128i a,  __m128i b)
          PMAXSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_max_pd (__m128d a,  __m128d b)
          MAXPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu8 (__m128i a,  __m128i b)
          PMAXUB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi16 (__m128i a,  __m128i b)
          PMAXSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_max_pd (__m128d a,  __m128d b)
          MAXPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MaxScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_max_sd (__m128d a,  __m128d b)
          MAXSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MaxScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_max_sd (__m128d a,  __m128d b)
          MAXSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MemoryFence() -> None:
        """
        void _mm_mfence(void)
          MFENCE
        """
        ...

    @staticmethod
    @overload
    def MemoryFence() -> None:
        """
        void _mm_mfence(void)
          MFENCE
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu8 (__m128i a,  __m128i b)
          PMINUB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi16 (__m128i a,  __m128i b)
          PMINSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_min_pd (__m128d a,  __m128d b)
          MINPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu8 (__m128i a,  __m128i b)
          PMINUB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi16 (__m128i a,  __m128i b)
          PMINSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_min_pd (__m128d a,  __m128d b)
          MINPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MinScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_min_sd (__m128d a,  __m128d b)
          MINSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MinScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_min_sd (__m128d a,  __m128d b)
          MINSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_movemask_epi8 (__m128i a)
          PMOVMSKB reg, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_movemask_epi8 (__m128i a)
          PMOVMSKB reg, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_movemask_pd (__m128d a)
          MOVMSKPD reg, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_movemask_epi8 (__m128i a)
          PMOVMSKB reg, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_movemask_epi8 (__m128i a)
          PMOVMSKB reg, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_movemask_pd (__m128d a)
          MOVMSKPD reg, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_move_sd (__m128d a, __m128d b)
          MOVSD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_move_epi64 (__m128i a)
          MOVQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_move_epi64 (__m128i a)
          MOVQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_move_sd (__m128d a, __m128d b)
          MOVSD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_move_epi64 (__m128i a)
          MOVQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_move_epi64 (__m128i a)
          MOVQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mul_epu32 (__m128i a,  __m128i b)
          PMULUDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mul_pd (__m128d a,  __m128d b)
          MULPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mul_epu32 (__m128i a,  __m128i b)
          PMULUDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mul_pd (__m128d a,  __m128d b)
          MULPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_madd_epi16 (__m128i a,  __m128i b)
          PMADDWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_madd_epi16 (__m128i a,  __m128i b)
          PMADDWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhi_epi16 (__m128i a,  __m128i b)
          PMULHW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhi_epu16 (__m128i a,  __m128i b)
          PMULHUW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhi_epi16 (__m128i a,  __m128i b)
          PMULHW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhi_epu16 (__m128i a,  __m128i b)
          PMULHUW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi16 (__m128i a,  __m128i b)
          PMULLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi16 (__m128i a,  __m128i b)
          PMULLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi16 (__m128i a,  __m128i b)
          PMULLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi16 (__m128i a,  __m128i b)
          PMULLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mul_sd (__m128d a,  __m128d b)
          MULSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MultiplyScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mul_sd (__m128d a,  __m128d b)
          MULSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_or_pd (__m128d a,  __m128d b)
          ORPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
          POR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_or_pd (__m128d a,  __m128d b)
          ORPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packs_epi16 (__m128i a,  __m128i b)
          PACKSSWB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packs_epi32 (__m128i a,  __m128i b)
          PACKSSDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packs_epi16 (__m128i a,  __m128i b)
          PACKSSWB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packs_epi32 (__m128i a,  __m128i b)
          PACKSSDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packus_epi16 (__m128i a,  __m128i b)
          PACKUSWB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packus_epi16 (__m128i a,  __m128i b)
          PACKUSWB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi16 (__m128i a, __m128i count)
          PSLLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi16 (__m128i a,  __m128i count)
          PSLLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi32 (__m128i a, __m128i count)
          PSLLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi32 (__m128i a, __m128i count)
          PSLLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi64 (__m128i a, __m128i count)
          PSLLQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi64 (__m128i a, __m128i count)
          PSLLQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi16 (__m128i a,  int immediate)
          PSLLW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi16 (__m128i a,  int immediate)
          PSLLW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi32 (__m128i a,  int immediate)
          PSLLD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi32 (__m128i a,  int immediate)
          PSLLD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi64 (__m128i a,  int immediate)
          PSLLQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi64 (__m128i a,  int immediate)
          PSLLQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi16 (__m128i a, __m128i count)
          PSLLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi16 (__m128i a,  __m128i count)
          PSLLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi32 (__m128i a, __m128i count)
          PSLLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi32 (__m128i a, __m128i count)
          PSLLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi64 (__m128i a, __m128i count)
          PSLLQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi64 (__m128i a, __m128i count)
          PSLLQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi16 (__m128i a,  int immediate)
          PSLLW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi16 (__m128i a,  int immediate)
          PSLLW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi32 (__m128i a,  int immediate)
          PSLLD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi32 (__m128i a,  int immediate)
          PSLLD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi64 (__m128i a,  int immediate)
          PSLLQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi64 (__m128i a,  int immediate)
          PSLLQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
          PSLLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sra_epi16 (__m128i a, __m128i count)
          PSRAW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sra_epi32 (__m128i a, __m128i count)
          PSRAD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srai_epi16 (__m128i a,  int immediate)
          PSRAW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srai_epi32 (__m128i a,  int immediate)
          PSRAD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sra_epi16 (__m128i a, __m128i count)
          PSRAW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sra_epi32 (__m128i a, __m128i count)
          PSRAD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srai_epi16 (__m128i a,  int immediate)
          PSRAW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srai_epi32 (__m128i a,  int immediate)
          PSRAD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi16 (__m128i a, __m128i count)
          PSRLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi16 (__m128i a, __m128i count)
          PSRLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi32 (__m128i a, __m128i count)
          PSRLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi32 (__m128i a, __m128i count)
          PSRLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi64 (__m128i a, __m128i count)
          PSRLQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi64 (__m128i a, __m128i count)
          PSRLQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi16 (__m128i a,  int immediate)
          PSRLW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi16 (__m128i a,  int immediate)
          PSRLW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi32 (__m128i a,  int immediate)
          PSRLD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi32 (__m128i a,  int immediate)
          PSRLD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi64 (__m128i a,  int immediate)
          PSRLQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi64 (__m128i a,  int immediate)
          PSRLQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi16 (__m128i a, __m128i count)
          PSRLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi16 (__m128i a, __m128i count)
          PSRLW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi32 (__m128i a, __m128i count)
          PSRLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi32 (__m128i a, __m128i count)
          PSRLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi64 (__m128i a, __m128i count)
          PSRLQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi64 (__m128i a, __m128i count)
          PSRLQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi16 (__m128i a,  int immediate)
          PSRLW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi16 (__m128i a,  int immediate)
          PSRLW xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi32 (__m128i a,  int immediate)
          PSRLD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi32 (__m128i a,  int immediate)
          PSRLD xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi64 (__m128i a,  int immediate)
          PSRLQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi64 (__m128i a,  int immediate)
          PSRLQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
          PSRLDQ xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi32 (__m128i a,  int immediate)
          PSHUFD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi32 (__m128i a,  int immediate)
          PSHUFD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_shuffle_pd (__m128d a,  __m128d b, int immediate)
          SHUFPD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi32 (__m128i a,  int immediate)
          PSHUFD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi32 (__m128i a,  int immediate)
          PSHUFD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_shuffle_pd (__m128d a,  __m128d b, int immediate)
          SHUFPD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflehi_epi16 (__m128i a,  int immediate)
          PSHUFHW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflehi_epi16 (__m128i a,  int control)
          PSHUFHW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflehi_epi16 (__m128i a,  int immediate)
          PSHUFHW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflehi_epi16 (__m128i a,  int control)
          PSHUFHW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflelo_epi16 (__m128i a,  int control)
          PSHUFLW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflelo_epi16 (__m128i a,  int control)
          PSHUFLW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflelo_epi16 (__m128i a,  int control)
          PSHUFLW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflelo_epi16 (__m128i a,  int control)
          PSHUFLW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_pd (__m128d a)
          SQRTPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_pd (__m128d a)
          SQRTPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_sd (__m128d a)
          SQRTSD xmm, xmm/64
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_sd (__m128d a, __m128d b)
          SQRTSD xmm, xmm/64
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_sd (__m128d a)
          SQRTSD xmm, xmm/64
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_sd (__m128d a, __m128d b)
          SQRTSD xmm, xmm/64
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeu_pd (double* mem_addr, __m128d a)
          MOVUPD m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
          MOVDQU m128, xmm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeu_pd (double* mem_addr, __m128d a)
          MOVUPD m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_pd (double* mem_addr, __m128d a)
          MOVAPD m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
          MOVDQA m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_pd (double* mem_addr, __m128d a)
          MOVAPD m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_stream_pd (double* mem_addr, __m128d a)
          MOVNTPD m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
          MOVNTDQ m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_stream_pd (double* mem_addr, __m128d a)
          MOVNTPD m128, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreHigh(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeh_pd (double* mem_addr, __m128d a)
          MOVHPD m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreHigh(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeh_pd (double* mem_addr, __m128d a)
          MOVHPD m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreLow(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storel_pd (double* mem_addr, __m128d a)
          MOVLPD m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreLow(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storel_pd (double* mem_addr, __m128d a)
          MOVLPD m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreNonTemporal(address: typing.Any, value: int) -> None:
        """
        void _mm_stream_si32(int *p, int a)
          MOVNTI m32, r32
        """
        ...

    @staticmethod
    @overload
    def StoreNonTemporal(address: typing.Any, value: int) -> None:
        """
        void _mm_stream_si32(int *p, int a)
          MOVNTI m32, r32
        """
        ...

    @staticmethod
    @overload
    def StoreNonTemporal(address: typing.Any, value: int) -> None:
        """
        void _mm_stream_si32(int *p, int a)
          MOVNTI m32, r32
        """
        ...

    @staticmethod
    @overload
    def StoreNonTemporal(address: typing.Any, value: int) -> None:
        """
        void _mm_stream_si32(int *p, int a)
          MOVNTI m32, r32
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_sd (double* mem_addr, __m128d a)
          MOVSD m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si32 (void* mem_addr, __m128i a)
          MOVD m32, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)
          MOVQ m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si32 (void* mem_addr, __m128i a)
          MOVD m32, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)
          MOVQ m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_sd (double* mem_addr, __m128d a)
          MOVSD m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si32 (void* mem_addr, __m128i a)
          MOVD m32, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)
          MOVQ m64, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si32 (void* mem_addr, __m128i a)
          MOVD m32, xmm
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)
          MOVQ m64, xmm
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi8 (__m128i a,  __m128i b)
          PSUBB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi8 (__m128i a,  __m128i b)
          PSUBB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi16 (__m128i a,  __m128i b)
          PSUBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi16 (__m128i a,  __m128i b)
          PSUBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi32 (__m128i a,  __m128i b)
          PSUBD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi32 (__m128i a,  __m128i b)
          PSUBD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi64 (__m128i a,  __m128i b)
          PSUBQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi64 (__m128i a,  __m128i b)
          PSUBQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_pd (__m128d a, __m128d b)
          SUBPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi8 (__m128i a,  __m128i b)
          PSUBB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi8 (__m128i a,  __m128i b)
          PSUBB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi16 (__m128i a,  __m128i b)
          PSUBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi16 (__m128i a,  __m128i b)
          PSUBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi32 (__m128i a,  __m128i b)
          PSUBD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi32 (__m128i a,  __m128i b)
          PSUBD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi64 (__m128i a,  __m128i b)
          PSUBQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi64 (__m128i a,  __m128i b)
          PSUBQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_pd (__m128d a, __m128d b)
          SUBPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epi8 (__m128i a,  __m128i b)
          PSUBSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epi16 (__m128i a,  __m128i b)
          PSUBSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epu8 (__m128i a,  __m128i b)
          PSUBUSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epu16 (__m128i a,  __m128i b)
          PSUBUSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epi8 (__m128i a,  __m128i b)
          PSUBSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epi16 (__m128i a,  __m128i b)
          PSUBSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epu8 (__m128i a,  __m128i b)
          PSUBUSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epu16 (__m128i a,  __m128i b)
          PSUBUSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_sd (__m128d a, __m128d b)
          SUBSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def SubtractScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_sd (__m128d a, __m128d b)
          SUBSD xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def SumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sad_epu8 (__m128i a,  __m128i b)
          PSADBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def SumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sad_epu8 (__m128i a,  __m128i b)
          PSADBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)
          PUNPCKHBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)
          PUNPCKHBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)
          PUNPCKHWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)
          PUNPCKHWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)
          PUNPCKHDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)
          PUNPCKHDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)
          PUNPCKHQDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)
          PUNPCKHQDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_unpackhi_pd (__m128d a,  __m128d b)
          UNPCKHPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)
          PUNPCKHBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)
          PUNPCKHBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)
          PUNPCKHWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)
          PUNPCKHWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)
          PUNPCKHDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)
          PUNPCKHDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)
          PUNPCKHQDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)
          PUNPCKHQDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_unpackhi_pd (__m128d a,  __m128d b)
          UNPCKHPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)
          PUNPCKLBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)
          PUNPCKLBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)
          PUNPCKLWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)
          PUNPCKLWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)
          PUNPCKLDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)
          PUNPCKLDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)
          PUNPCKLQDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)
          PUNPCKLQDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_unpacklo_pd (__m128d a,  __m128d b)
          UNPCKLPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)
          PUNPCKLBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)
          PUNPCKLBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)
          PUNPCKLWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)
          PUNPCKLWD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)
          PUNPCKLDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)
          PUNPCKLDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)
          PUNPCKLQDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)
          PUNPCKLQDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_unpacklo_pd (__m128d a,  __m128d b)
          UNPCKLPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_xor_pd (__m128d a,  __m128d b)
          XORPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
          PXOR xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_xor_pd (__m128d a,  __m128d b)
          XORPD xmm, xmm/m128
        """
        ...


class Sse3(System.Runtime.Intrinsics.X86.Sse2, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE3 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse2.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_addsub_ps (__m128 a, __m128 b)
          ADDSUBPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_addsub_pd (__m128d a, __m128d b)
          ADDSUBPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_addsub_ps (__m128 a, __m128 b)
          ADDSUBPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_addsub_pd (__m128d a, __m128d b)
          ADDSUBPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_hadd_ps (__m128 a, __m128 b)
          HADDPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_hadd_pd (__m128d a, __m128d b)
          HADDPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_hadd_ps (__m128 a, __m128 b)
          HADDPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_hadd_pd (__m128d a, __m128d b)
          HADDPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_hsub_ps (__m128 a, __m128 b)
          HSUBPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_hsub_pd (__m128d a, __m128d b)
          HSUBPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_hsub_ps (__m128 a, __m128 b)
          HSUBPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_hsub_pd (__m128d a, __m128d b)
          HSUBPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def LoadAndDuplicateToVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loaddup_pd (double const* mem_addr)
        MOVDDUP xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadAndDuplicateToVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loaddup_pd (double const* mem_addr)
        MOVDDUP xmm, m64
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
          LDDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
          LDDQU xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        ...

    @staticmethod
    @overload
    def MoveAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_movedup_pd (__m128d a)
          MOVDDUP xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MoveAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_movedup_pd (__m128d a)
          MOVDDUP xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MoveHighAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movehdup_ps (__m128 a)
          MOVSHDUP xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MoveHighAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movehdup_ps (__m128 a)
          MOVSHDUP xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MoveLowAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_moveldup_ps (__m128 a)
          MOVSLDUP xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MoveLowAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_moveldup_ps (__m128 a)
          MOVSLDUP xmm, xmm/m128
        """
        ...


class Ssse3(System.Runtime.Intrinsics.X86.Sse3, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSSE3 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse3.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi8 (__m128i a)
          PABSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi16 (__m128i a)
          PABSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi32 (__m128i a)
          PABSD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi8 (__m128i a)
          PABSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi16 (__m128i a)
          PABSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi32 (__m128i a)
          PABSD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
          PALIGNR xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadd_epi16 (__m128i a, __m128i b)
          PHADDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadd_epi32 (__m128i a, __m128i b)
          PHADDD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadd_epi16 (__m128i a, __m128i b)
          PHADDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadd_epi32 (__m128i a, __m128i b)
          PHADDD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadds_epi16 (__m128i a, __m128i b)
          PHADDSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadds_epi16 (__m128i a, __m128i b)
          PHADDSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsub_epi16 (__m128i a, __m128i b)
          PHSUBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsub_epi32 (__m128i a, __m128i b)
          PHSUBD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsub_epi16 (__m128i a, __m128i b)
          PHSUBW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsub_epi32 (__m128i a, __m128i b)
          PHSUBD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsubs_epi16 (__m128i a, __m128i b)
          PHSUBSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsubs_epi16 (__m128i a, __m128i b)
          PHSUBSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maddubs_epi16 (__m128i a, __m128i b)
          PMADDUBSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maddubs_epi16 (__m128i a, __m128i b)
          PMADDUBSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHighRoundScale(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhrs_epi16 (__m128i a, __m128i b)
          PMULHRSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHighRoundScale(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhrs_epi16 (__m128i a, __m128i b)
          PMULHRSW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi8 (__m128i a, __m128i b)
          PSHUFB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi8 (__m128i a, __m128i b)
          PSHUFB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi8 (__m128i a, __m128i b)
          PSHUFB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi8 (__m128i a, __m128i b)
          PSHUFB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi8 (__m128i a, __m128i b)
          PSIGNB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi16 (__m128i a, __m128i b)
          PSIGNW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi32 (__m128i a, __m128i b)
          PSIGND xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi8 (__m128i a, __m128i b)
          PSIGNB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi16 (__m128i a, __m128i b)
          PSIGNW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi32 (__m128i a, __m128i b)
          PSIGND xmm, xmm/m128
        """
        ...


class Sse41(System.Runtime.Intrinsics.X86.Ssse3, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE4.1 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Ssse3.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """
            __int64 _mm_extract_epi64 (__m128i a, const int imm8)
              PEXTRQ reg/m64, xmm, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """
            __int64 _mm_extract_epi64 (__m128i a, const int imm8)
              PEXTRQ reg/m64, xmm, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """
            __int64 _mm_extract_epi64 (__m128i a, const int imm8)
              PEXTRQ reg/m64, xmm, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """
            __int64 _mm_extract_epi64 (__m128i a, const int imm8)
              PEXTRQ reg/m64, xmm, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)
              PINSRQ xmm, reg/m64, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)
              PINSRQ xmm, reg/m64, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)
              PINSRQ xmm, reg/m64, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)
              PINSRQ xmm, reg/m64, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)
          PBLENDW xmm, xmm/m128 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)
          PBLENDW xmm, xmm/m128 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_blend_ps (__m128 a, __m128 b, const int imm8)
          BLENDPS xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_blend_pd (__m128d a, __m128d b, const int imm8)
          BLENDPD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)
          PBLENDW xmm, xmm/m128 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)
          PBLENDW xmm, xmm/m128 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_blend_ps (__m128 a, __m128 b, const int imm8)
          BLENDPS xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_blend_pd (__m128d a, __m128d b, const int imm8)
          BLENDPD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_blendv_ps (__m128 a, __m128 b, __m128 mask)
          BLENDVPS xmm, xmm/m128, xmm0
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_blendv_pd (__m128d a, __m128d b, __m128d mask)
          BLENDVPD xmm, xmm/m128, xmm0
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
          PBLENDVB xmm, xmm/m128, xmm
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_blendv_ps (__m128 a, __m128 b, __m128 mask)
          BLENDVPS xmm, xmm/m128, xmm0
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_blendv_pd (__m128d a, __m128d b, __m128d mask)
          BLENDVPD xmm, xmm/m128, xmm0
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ps (__m128 a)
          ROUNDPS xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_pd (__m128d a)
          ROUNDPD xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ps (__m128 a)
          ROUNDPS xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_pd (__m128d a)
          ROUNDPD xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_sd (__m128d a)
          ROUNDSD xmm, xmm/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ss (__m128 a)
          ROUNDSD xmm, xmm/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_sd (__m128d a, __m128d b)
          ROUNDSD xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ss (__m128 a, __m128 b)
          ROUNDSS xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_sd (__m128d a)
          ROUNDSD xmm, xmm/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ss (__m128 a)
          ROUNDSD xmm, xmm/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_sd (__m128d a, __m128d b)
          ROUNDSD xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ss (__m128 a, __m128 b)
          ROUNDSS xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)
          PCMPEQQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)
          PCMPEQQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)
          PCMPEQQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)
          PCMPEQQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi16 (__m128i a)
          PMOVSXBW xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi16 (__m128i a)
          PMOVZXBW xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBW xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBW xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi16 (__m128i a)
          PMOVSXBW xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi16 (__m128i a)
          PMOVZXBW xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBW xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBW xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi32 (__m128i a)
          PMOVSXBD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi32 (__m128i a)
          PMOVZXBD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi16_epi32 (__m128i a)
          PMOVSXWD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu16_epi32 (__m128i a)
          PMOVZXWD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBD xmm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBD xmm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXWD xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXWD xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi32 (__m128i a)
          PMOVSXBD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi32 (__m128i a)
          PMOVZXBD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi16_epi32 (__m128i a)
          PMOVSXWD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu16_epi32 (__m128i a)
          PMOVZXWD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBD xmm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBD xmm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXWD xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXWD xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi64 (__m128i a)
          PMOVSXBQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi64 (__m128i a)
          PMOVZXBQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi16_epi64 (__m128i a)
          PMOVSXWQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu16_epi64 (__m128i a)
          PMOVZXWQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi32_epi64 (__m128i a)
          PMOVSXDQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu32_epi64 (__m128i a)
          PMOVZXDQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBQ xmm, m16
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBQ xmm, m16
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXWQ xmm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXWQ xmm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXDQ xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXDQ xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi64 (__m128i a)
          PMOVSXBQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi64 (__m128i a)
          PMOVZXBQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi16_epi64 (__m128i a)
          PMOVSXWQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu16_epi64 (__m128i a)
          PMOVZXWQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi32_epi64 (__m128i a)
          PMOVSXDQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu32_epi64 (__m128i a)
          PMOVZXDQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBQ xmm, m16
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBQ xmm, m16
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXWQ xmm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXWQ xmm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXDQ xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXDQ xmm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_dp_ps (__m128 a, __m128 b, const int imm8)
          DPPS xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_dp_pd (__m128d a, __m128d b, const int imm8)
          DPPD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_dp_ps (__m128 a, __m128 b, const int imm8)
          DPPS xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_dp_pd (__m128d a, __m128d b, const int imm8)
          DPPD xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi8 (__m128i a, const int imm8)
          PEXTRB reg/m8, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi32 (__m128i a, const int imm8)
          PEXTRD reg/m32, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi32 (__m128i a, const int imm8)
          PEXTRD reg/m32, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[float], index: int) -> float:
        """
        int _mm_extract_ps (__m128 a, const int imm8)
          EXTRACTPS xmm, xmm/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi8 (__m128i a, const int imm8)
          PEXTRB reg/m8, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi32 (__m128i a, const int imm8)
          PEXTRD reg/m32, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi32 (__m128i a, const int imm8)
          PEXTRD reg/m32, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[float], index: int) -> float:
        """
        int _mm_extract_ps (__m128 a, const int imm8)
          EXTRACTPS xmm, xmm/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ps (__m128 a)
          ROUNDPS xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_pd (__m128d a)
          ROUNDPD xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ps (__m128 a)
          ROUNDPS xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_pd (__m128d a)
          ROUNDPD xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_sd (__m128d a)
          ROUNDSD xmm, xmm/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ss (__m128 a)
          ROUNDSS xmm, xmm/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_sd (__m128d a, __m128d b)
          ROUNDSD xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ss (__m128 a, __m128 b)
          ROUNDSS xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_sd (__m128d a)
          ROUNDSD xmm, xmm/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ss (__m128 a)
          ROUNDSS xmm, xmm/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_sd (__m128d a, __m128d b)
          ROUNDSD xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ss (__m128 a, __m128 b)
          ROUNDSS xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)
          PINSRB xmm, reg/m8, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)
          PINSRB xmm, reg/m8, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)
          PINSRD xmm, reg/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)
          PINSRD xmm, reg/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_insert_ps (__m128 a, __m128 b, const int imm8)
          INSERTPS xmm, xmm/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)
          PINSRB xmm, reg/m8, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)
          PINSRB xmm, reg/m8, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)
          PINSRD xmm, reg/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)
          PINSRD xmm, reg/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_insert_ps (__m128 a, __m128 b, const int imm8)
          INSERTPS xmm, xmm/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
          MOVNTDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi8 (__m128i a, __m128i b)
          PMAXSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu16 (__m128i a, __m128i b)
          PMAXUW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi32 (__m128i a, __m128i b)
          PMAXSD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu32 (__m128i a, __m128i b)
          PMAXUD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi8 (__m128i a, __m128i b)
          PMAXSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu16 (__m128i a, __m128i b)
          PMAXUW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi32 (__m128i a, __m128i b)
          PMAXSD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu32 (__m128i a, __m128i b)
          PMAXUD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi8 (__m128i a, __m128i b)
          PMINSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu16 (__m128i a, __m128i b)
          PMINUW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi32 (__m128i a, __m128i b)
          PMINSD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu32 (__m128i a, __m128i b)
          PMINUD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi8 (__m128i a, __m128i b)
          PMINSB xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu16 (__m128i a, __m128i b)
          PMINUW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi32 (__m128i a, __m128i b)
          PMINSD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu32 (__m128i a, __m128i b)
          PMINUD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MinHorizontal(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_minpos_epu16 (__m128i a)
          PHMINPOSUW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MinHorizontal(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_minpos_epu16 (__m128i a)
          PHMINPOSUW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultipleSumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mpsadbw_epu8 (__m128i a, __m128i b, const int imm8)
          MPSADBW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def MultipleSumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mpsadbw_epu8 (__m128i a, __m128i b, const int imm8)
          MPSADBW xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mul_epi32 (__m128i a, __m128i b)
          PMULDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mul_epi32 (__m128i a, __m128i b)
          PMULDQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi32 (__m128i a, __m128i b)
          PMULLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi32 (__m128i a, __m128i b)
          PMULLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi32 (__m128i a, __m128i b)
          PMULLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi32 (__m128i a, __m128i b)
          PMULLD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packus_epi32 (__m128i a, __m128i b)
          PACKUSDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packus_epi32 (__m128i a, __m128i b)
          PACKUSDW xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_CUR_DIRECTION; ROUNDPS xmm, xmm/m128, imm8(4)"""
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_CUR_DIRECTION; ROUNDPD xmm, xmm/m128, imm8(4)"""
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_CUR_DIRECTION; ROUNDPS xmm, xmm/m128, imm8(4)"""
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_CUR_DIRECTION; ROUNDPD xmm, xmm/m128, imm8(4)"""
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_CUR_DIRECTION)
          ROUNDSD xmm, xmm/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_CUR_DIRECTION)
          ROUNDSD xmm, xmm/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_CUR_DIRECTION)
          ROUNDSS xmm, xmm/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_CUR_DIRECTION)
          ROUNDSS xmm, xmm/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_CUR_DIRECTION)
          ROUNDSD xmm, xmm/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_CUR_DIRECTION)
          ROUNDSD xmm, xmm/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_CUR_DIRECTION)
          ROUNDSS xmm, xmm/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_CUR_DIRECTION)
          ROUNDSS xmm, xmm/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, int rounding)
          ROUNDPS xmm, xmm/m128, imm8(8)
        _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_pd (__m128d a, int rounding)
          ROUNDPD xmm, xmm/m128, imm8(8)
        _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, int rounding)
          ROUNDPS xmm, xmm/m128, imm8(8)
        _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_pd (__m128d a, int rounding)
          ROUNDPD xmm, xmm/m128, imm8(8)
        _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(8)
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(8)
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(8)
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(8)
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC; ROUNDPS xmm, xmm/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC; ROUNDPD xmm, xmm/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC; ROUNDPS xmm, xmm/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC; ROUNDPD xmm, xmm/m128, imm8(9)"""
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC; ROUNDPS xmm, xmm/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC; ROUNDPD xmm, xmm/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC; ROUNDPS xmm, xmm/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC; ROUNDPD xmm, xmm/m128, imm8(10)"""
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC; ROUNDPS xmm, xmm/m128, imm8(11)"""
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC; ROUNDPD xmm, xmm/m128, imm8(11)"""
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC; ROUNDPS xmm, xmm/m128, imm8(11)"""
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """_MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC; ROUNDPD xmm, xmm/m128, imm8(11)"""
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(11)
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(11)
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)
          ROUNDSD xmm, xmm/m128, imm8(11)
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          ROUNDSS xmm, xmm/m128, imm8(11)
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
          PTEST xmm, xmm/m128
        """
        ...


class Sse42(System.Runtime.Intrinsics.X86.Sse41, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE4.2 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse41.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def Crc32(crc: int, data: int) -> int:
            """
            unsigned __int64 _mm_crc32_u64 (unsigned __int64 crc, unsigned __int64 v)
              CRC32 reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Crc32(crc: int, data: int) -> int:
            """
            unsigned __int64 _mm_crc32_u64 (unsigned __int64 crc, unsigned __int64 v)
              CRC32 reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi64 (__m128i a, __m128i b)
          PCMPGTQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi64 (__m128i a, __m128i b)
          PCMPGTQ xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u8 (unsigned int crc, unsigned char v)
          CRC32 reg, reg/m8
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u16 (unsigned int crc, unsigned short v)
          CRC32 reg, reg/m16
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u32 (unsigned int crc, unsigned int v)
          CRC32 reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u8 (unsigned int crc, unsigned char v)
          CRC32 reg, reg/m8
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u16 (unsigned int crc, unsigned short v)
          CRC32 reg, reg/m16
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u32 (unsigned int crc, unsigned int v)
          CRC32 reg, reg/m32
        """
        ...


class Popcnt(System.Runtime.Intrinsics.X86.Sse42, metaclass=abc.ABCMeta):
    """This class provides access to Intel POPCNT hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse42.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def PopCount(value: int) -> int:
            """
            __int64 _mm_popcnt_u64 (unsigned __int64 a)
              POPCNT reg64, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def PopCount(value: int) -> int:
            """
            __int64 _mm_popcnt_u64 (unsigned __int64 a)
              POPCNT reg64, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def PopCount(value: int) -> int:
        """
        int _mm_popcnt_u32 (unsigned int a)
          POPCNT reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def PopCount(value: int) -> int:
        """
        int _mm_popcnt_u32 (unsigned int a)
          POPCNT reg, reg/m32
        """
        ...


class FloatComparisonMode(System.Enum):
    """This class has no documentation."""

    OrderedEqualNonSignaling = 0
    """_CMP_EQ_OQ"""

    OrderedLessThanSignaling = 1
    """_CMP_LT_OS"""

    OrderedLessThanOrEqualSignaling = 2
    """_CMP_LE_OS"""

    UnorderedNonSignaling = 3
    """_CMP_UNORD_Q"""

    UnorderedNotEqualNonSignaling = 4
    """_CMP_NEQ_UQ"""

    UnorderedNotLessThanSignaling = 5
    """_CMP_NLT_US"""

    UnorderedNotLessThanOrEqualSignaling = 6
    """_CMP_NLE_US"""

    OrderedNonSignaling = 7
    """_CMP_ORD_Q"""

    UnorderedEqualNonSignaling = 8
    """_CMP_EQ_UQ"""

    UnorderedNotGreaterThanOrEqualSignaling = 9
    """_CMP_NGE_US"""

    UnorderedNotGreaterThanSignaling = 10
    """_CMP_NGT_US"""

    OrderedFalseNonSignaling = 11
    """_CMP_FALSE_OQ"""

    OrderedNotEqualNonSignaling = 12
    """_CMP_NEQ_OQ"""

    OrderedGreaterThanOrEqualSignaling = 13
    """_CMP_GE_OS"""

    OrderedGreaterThanSignaling = 14
    """_CMP_GT_OS"""

    UnorderedTrueNonSignaling = 15
    """_CMP_TRUE_UQ"""

    OrderedEqualSignaling = 16
    """_CMP_EQ_OS"""

    OrderedLessThanNonSignaling = 17
    """_CMP_LT_OQ"""

    OrderedLessThanOrEqualNonSignaling = 18
    """_CMP_LE_OQ"""

    UnorderedSignaling = 19
    """_CMP_UNORD_S"""

    UnorderedNotEqualSignaling = 20
    """_CMP_NEQ_US"""

    UnorderedNotLessThanNonSignaling = 21
    """_CMP_NLT_UQ"""

    UnorderedNotLessThanOrEqualNonSignaling = 22
    """_CMP_NLE_UQ"""

    OrderedSignaling = 23
    """_CMP_ORD_S"""

    UnorderedEqualSignaling = 24
    """_CMP_EQ_US"""

    UnorderedNotGreaterThanOrEqualNonSignaling = 25
    """_CMP_NGE_UQ"""

    UnorderedNotGreaterThanNonSignaling = 26
    """_CMP_NGT_UQ"""

    OrderedFalseSignaling = 27
    """_CMP_FALSE_OS"""

    OrderedNotEqualSignaling = 28
    """_CMP_NEQ_OS"""

    OrderedGreaterThanOrEqualNonSignaling = 29
    """_CMP_GE_OQ"""

    OrderedGreaterThanNonSignaling = 30
    """_CMP_GT_OQ"""

    UnorderedTrueSignaling = 31
    """_CMP_TRUE_US"""


class Avx(System.Runtime.Intrinsics.X86.Sse42, metaclass=abc.ABCMeta):
    """This class provides access to Intel AVX hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse42.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_add_ps (__m256 a, __m256 b)
          VADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_add_pd (__m256d a, __m256d b)
          VADDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_add_ps (__m256 a, __m256 b)
          VADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_add_pd (__m256d a, __m256d b)
          VADDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_addsub_ps (__m256 a, __m256 b)
          VADDSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_addsub_pd (__m256d a, __m256d b)
          VADDSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_addsub_ps (__m256 a, __m256 b)
          VADDSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_addsub_pd (__m256d a, __m256d b)
          VADDSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_and_ps (__m256 a, __m256 b)
          VANDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_and_pd (__m256d a, __m256d b)
          VANDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_and_ps (__m256 a, __m256 b)
          VANDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_and_pd (__m256d a, __m256d b)
          VANDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_andnot_ps (__m256 a, __m256 b)
          VANDNPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_andnot_pd (__m256d a, __m256d b)
          VANDNPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_andnot_ps (__m256 a, __m256 b)
          VANDNPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_andnot_pd (__m256d a, __m256d b)
          VANDNPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_blend_ps (__m256 a, __m256 b, const int imm8)
          VBLENDPS ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_blend_pd (__m256d a, __m256d b, const int imm8)
          VBLENDPD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_blend_ps (__m256 a, __m256 b, const int imm8)
          VBLENDPS ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_blend_pd (__m256d a, __m256d b, const int imm8)
          VBLENDPD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_blendv_ps (__m256 a, __m256 b, __m256 mask)
          VBLENDVPS ymm, ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_blendv_pd (__m256d a, __m256d b, __m256d mask)
          VBLENDVPD ymm, ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_blendv_ps (__m256 a, __m256 b, __m256 mask)
          VBLENDVPS ymm, ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_blendv_pd (__m256d a, __m256d b, __m256d mask)
          VBLENDVPD ymm, ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_broadcast_ss (float const * mem_addr)
          VBROADCASTSS xmm, m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_broadcast_ss (float const * mem_addr)
          VBROADCASTSS xmm, m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcast_ss (float const * mem_addr)
          VBROADCASTSS ymm, m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcast_sd (double const * mem_addr)
          VBROADCASTSD ymm, m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcast_ss (float const * mem_addr)
          VBROADCASTSS ymm, m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcast_sd (double const * mem_addr)
          VBROADCASTSD ymm, m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcast_ps (__m128 const * mem_addr)
          VBROADCASTF128, ymm, m128
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcast_pd (__m128d const * mem_addr)
          VBROADCASTF128, ymm, m128
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcast_ps (__m128 const * mem_addr)
          VBROADCASTF128, ymm, m128
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcast_pd (__m128d const * mem_addr)
          VBROADCASTF128, ymm, m128
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_ceil_ps (__m256 a)
          VROUNDPS ymm, ymm/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_ceil_pd (__m256d a)
          VROUNDPD ymm, ymm/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_ceil_ps (__m256 a)
          VROUNDPS ymm, ymm/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_ceil_pd (__m256d a)
          VROUNDPD ymm, ymm/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmp_ps (__m128 a, __m128 b, const int imm8)
          VCMPPS xmm, xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmp_pd (__m128d a, __m128d b, const int imm8)
          VCMPPD xmm, xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmp_ps (__m256 a, __m256 b, const int imm8)
          VCMPPS ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmp_pd (__m256d a, __m256d b, const int imm8)
          VCMPPD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmp_ps (__m128 a, __m128 b, const int imm8)
          VCMPPS xmm, xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmp_pd (__m128d a, __m128d b, const int imm8)
          VCMPPD xmm, xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmp_ps (__m256 a, __m256 b, const int imm8)
          VCMPPS ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmp_pd (__m256d a, __m256d b, const int imm8)
          VCMPPD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpeq_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(0)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpeq_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(0)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpeq_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(0)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpeq_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(0)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpgt_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(14)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpgt_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(14)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpgt_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(14)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpgt_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(14)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpge_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(13)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpge_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(13)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpge_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(13)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpge_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(13)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmplt_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(1)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmplt_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(1)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmplt_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(1)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmplt_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(1)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmple_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(2)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmple_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(2)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmple_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(2)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmple_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(2)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpneq_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpneq_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpneq_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpneq_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpngt_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpngt_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpngt_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpngt_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnge_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnge_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnge_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnge_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnlt_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(5)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnlt_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(5)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnlt_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(5)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnlt_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(5)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnle_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(6)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnle_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(6)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnle_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(6)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnle_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(6)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpord_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(7)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpord_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(7)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpord_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(7)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpord_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(7)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmp_sd (__m128d a, __m128d b, const int imm8)
          VCMPSS xmm, xmm, xmm/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmp_ss (__m128 a, __m128 b, const int imm8)
          VCMPSD xmm, xmm, xmm/m64, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmp_sd (__m128d a, __m128d b, const int imm8)
          VCMPSS xmm, xmm, xmm/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmp_ss (__m128 a, __m128 b, const int imm8)
          VCMPSD xmm, xmm, xmm/m64, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpunord_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(3)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpunord_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(3)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpunord_ps (__m256 a,  __m256 b)
          CMPPS ymm, ymm/m256, imm8(3)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpunord_pd (__m256d a,  __m256d b)
          CMPPD ymm, ymm/m256, imm8(3)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_cvtpd_epi32 (__m256d a)
          VCVTPD2DQ xmm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_cvtpd_epi32 (__m256d a)
          VCVTPD2DQ xmm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_cvttpd_epi32 (__m256d a)
          VCVTTPD2DQ xmm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_cvttpd_epi32 (__m256d a)
          VCVTTPD2DQ xmm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_cvtpd_ps (__m256d a)
          VCVTPD2PS xmm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_cvtpd_ps (__m256d a)
          VCVTPD2PS xmm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cvtps_pd (__m128 a)
          VCVTPS2PD ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cvtepi32_pd (__m128i a)
          VCVTDQ2PD ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cvtps_pd (__m128 a)
          VCVTPS2PD ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cvtepi32_pd (__m128i a)
          VCVTDQ2PD ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtps_epi32 (__m256 a)
          VCVTPS2DQ ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtps_epi32 (__m256 a)
          VCVTPS2DQ ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32WithTruncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvttps_epi32 (__m256 a)
          VCVTTPS2DQ ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32WithTruncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvttps_epi32 (__m256 a)
          VCVTTPS2DQ ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Single(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cvtepi32_ps (__m256i a)
          VCVTDQ2PS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Single(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cvtepi32_ps (__m256i a)
          VCVTDQ2PS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_div_ps (__m256 a, __m256 b)
          VDIVPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_div_pd (__m256d a, __m256d b)
          VDIVPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_div_ps (__m256 a, __m256 b)
          VDIVPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_div_pd (__m256d a, __m256d b)
          VDIVPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_dp_ps (__m256 a, __m256 b, const int imm8)
          VDPPS ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_dp_ps (__m256 a, __m256 b, const int imm8)
          VDPPS ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_moveldup_ps (__m256 a)
          VMOVSLDUP ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_movedup_pd (__m256d a)
          VMOVDDUP ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_moveldup_ps (__m256 a)
          VMOVSLDUP ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_movedup_pd (__m256d a)
          VMOVDDUP ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateOddIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_movehdup_ps (__m256 a)
          VMOVSHDUP ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateOddIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_movehdup_ps (__m256 a)
          VMOVSHDUP ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_extractf128_ps (__m256 a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm256_extractf128_pd (__m256d a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_extractf128_ps (__m256 a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm256_extractf128_pd (__m256d a, const int imm8)
          VEXTRACTF128 xmm/m128, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_floor_ps (__m256 a)
          VROUNDPS ymm, ymm/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_floor_pd (__m256d a)
          VROUNDPS ymm, ymm/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_floor_ps (__m256 a)
          VROUNDPS ymm, ymm/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_floor_pd (__m256d a)
          VROUNDPS ymm, ymm/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_hadd_ps (__m256 a, __m256 b)
          VHADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_hadd_pd (__m256d a, __m256d b)
          VHADDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_hadd_ps (__m256 a, __m256 b)
          VHADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_hadd_pd (__m256d a, __m256d b)
          VHADDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_hsub_ps (__m256 a, __m256 b)
          VHSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_hsub_pd (__m256d a, __m256d b)
          VHSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_hsub_ps (__m256 a, __m256 b)
          VHSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_hsub_pd (__m256d a, __m256d b)
          VHSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_insertf128_ps (__m256 a, __m128 b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_insertf128_pd (__m256d a, __m128d b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_insertf128_ps (__m256 a, __m128 b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_insertf128_pd (__m256d a, __m128d b, int imm8)
          VINSERTF128 ymm, ymm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_load_ps (float const * mem_addr)
          VMOVAPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_load_pd (double const * mem_addr)
          VMOVAPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_load_ps (float const * mem_addr)
          VMOVAPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_load_pd (double const * mem_addr)
          VMOVAPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_loadu_ps (float const * mem_addr)
          VMOVUPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_loadu_pd (double const * mem_addr)
          VMOVUPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_loadu_ps (float const * mem_addr)
          VMOVUPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_loadu_pd (double const * mem_addr)
          VMOVUPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_maskload_ps (float const * mem_addr, __m128i mask)
          VMASKMOVPS xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_maskload_pd (double const * mem_addr, __m128i mask)
          VMASKMOVPD xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_maskload_ps (float const * mem_addr, __m256i mask)
          VMASKMOVPS ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_maskload_pd (double const * mem_addr, __m256i mask)
          VMASKMOVPD ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_maskload_ps (float const * mem_addr, __m128i mask)
          VMASKMOVPS xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_maskload_pd (double const * mem_addr, __m128i mask)
          VMASKMOVPD xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_maskload_ps (float const * mem_addr, __m256i mask)
          VMASKMOVPS ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_maskload_pd (double const * mem_addr, __m256i mask)
          VMASKMOVPD ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_maskstore_ps (float * mem_addr, __m128i mask, __m128 a)
          VMASKMOVPS m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_maskstore_pd (double * mem_addr, __m128i mask, __m128d a)
          VMASKMOVPD m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_maskstore_ps (float * mem_addr, __m256i mask, __m256 a)
          VMASKMOVPS m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_maskstore_pd (double * mem_addr, __m256i mask, __m256d a)
          VMASKMOVPD m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_maskstore_ps (float * mem_addr, __m128i mask, __m128 a)
          VMASKMOVPS m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_maskstore_pd (double * mem_addr, __m128i mask, __m128d a)
          VMASKMOVPD m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_maskstore_ps (float * mem_addr, __m256i mask, __m256 a)
          VMASKMOVPS m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_maskstore_pd (double * mem_addr, __m256i mask, __m256d a)
          VMASKMOVPD m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_max_ps (__m256 a, __m256 b)
          VMAXPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_max_pd (__m256d a, __m256d b)
          VMAXPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_max_ps (__m256 a, __m256 b)
          VMAXPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_max_pd (__m256d a, __m256d b)
          VMAXPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_min_ps (__m256 a, __m256 b)
          VMINPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_min_pd (__m256d a, __m256d b)
          VMINPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_min_ps (__m256 a, __m256 b)
          VMINPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_min_pd (__m256d a, __m256d b)
          VMINPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """
        int _mm256_movemask_ps (__m256 a)
          VMOVMSKPS reg, ymm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """
        int _mm256_movemask_pd (__m256d a)
          VMOVMSKPD reg, ymm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """
        int _mm256_movemask_ps (__m256 a)
          VMOVMSKPS reg, ymm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """
        int _mm256_movemask_pd (__m256d a)
          VMOVMSKPD reg, ymm
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_mul_ps (__m256 a, __m256 b)
          VMULPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mul_pd (__m256d a, __m256d b)
          VMULPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_mul_ps (__m256 a, __m256 b)
          VMULPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mul_pd (__m256d a, __m256d b)
          VMULPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_or_ps (__m256 a, __m256 b)
          VORPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_or_pd (__m256d a, __m256d b)
          VORPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_or_ps (__m256 a, __m256 b)
          VORPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_or_pd (__m256d a, __m256d b)
          VORPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_permute_ps (__m128 a, int imm8)
          VPERMILPS xmm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_permute_pd (__m128d a, int imm8)
          VPERMILPD xmm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permute_ps (__m256 a, int imm8)
          VPERMILPS ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute_pd (__m256d a, int imm8)
          VPERMILPD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_permute_ps (__m128 a, int imm8)
          VPERMILPS xmm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_permute_pd (__m128d a, int imm8)
          VPERMILPD xmm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permute_ps (__m256 a, int imm8)
          VPERMILPS ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute_pd (__m256d a, int imm8)
          VPERMILPD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permute2f128_ps (__m256 a, __m256 b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute2f128_pd (__m256d a, __m256d b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permute2f128_ps (__m256 a, __m256 b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute2f128_pd (__m256d a, __m256d b, int imm8)
          VPERM2F128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_permutevar_ps (__m128 a, __m128i b)
          VPERMILPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_permutevar_pd (__m128d a, __m128i b)
          VPERMILPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permutevar_ps (__m256 a, __m256i b)
          VPERMILPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permutevar_pd (__m256d a, __m256i b)
          VPERMILPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_permutevar_ps (__m128 a, __m128i b)
          VPERMILPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_permutevar_pd (__m128d a, __m128i b)
          VPERMILPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permutevar_ps (__m256 a, __m256i b)
          VPERMILPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permutevar_pd (__m256d a, __m256i b)
          VPERMILPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Reciprocal(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_rcp_ps (__m256 a)
          VRCPPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Reciprocal(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_rcp_ps (__m256 a)
          VRCPPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_rsqrt_ps (__m256 a)
          VRSQRTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_rsqrt_ps (__m256 a)
          VRSQRTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_CUR_DIRECTION)
          VROUNDPS ymm, ymm/m256, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_CUR_DIRECTION)
          VROUNDPD ymm, ymm/m256, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_CUR_DIRECTION)
          VROUNDPS ymm, ymm/m256, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_CUR_DIRECTION)
          VROUNDPD ymm, ymm/m256, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
          VROUNDPS ymm, ymm/m256, imm8(8)
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
          VROUNDPD ymm, ymm/m256, imm8(8)
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
          VROUNDPS ymm, ymm/m256, imm8(8)
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
          VROUNDPD ymm, ymm/m256, imm8(8)
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          VROUNDPS ymm, ymm/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          VROUNDPD ymm, ymm/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          VROUNDPS ymm, ymm/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          VROUNDPD ymm, ymm/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          VROUNDPS ymm, ymm/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          VROUNDPD ymm, ymm/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          VROUNDPS ymm, ymm/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          VROUNDPD ymm, ymm/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          VROUNDPS ymm, ymm/m256, imm8(11)
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          VROUNDPD ymm, ymm/m256, imm8(11)
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          VROUNDPS ymm, ymm/m256, imm8(11)
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          VROUNDPD ymm, ymm/m256, imm8(11)
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_shuffle_ps (__m256 a, __m256 b, const int imm8)
          VSHUFPS ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_shuffle_pd (__m256d a, __m256d b, const int imm8)
          VSHUFPD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_shuffle_ps (__m256 a, __m256 b, const int imm8)
          VSHUFPS ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_shuffle_pd (__m256d a, __m256d b, const int imm8)
          VSHUFPD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_sqrt_ps (__m256 a)
          VSQRTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_sqrt_pd (__m256d a)
          VSQRTPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_sqrt_ps (__m256 a)
          VSQRTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_sqrt_pd (__m256d a)
          VSQRTPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_storeu_ps (float * mem_addr, __m256 a)
          MOVUPS m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_storeu_pd (double * mem_addr, __m256d a)
          MOVUPD m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          MOVDQU m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_storeu_ps (float * mem_addr, __m256 a)
          MOVUPS m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_storeu_pd (double * mem_addr, __m256d a)
          MOVUPD m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_store_ps (float * mem_addr, __m256 a)
          VMOVAPS m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_store_pd (double * mem_addr, __m256d a)
          VMOVAPD m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          MOVDQA m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_store_ps (float * mem_addr, __m256 a)
          VMOVAPS m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_store_pd (double * mem_addr, __m256d a)
          VMOVAPD m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_stream_ps (float * mem_addr, __m256 a)
          MOVNTPS m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_stream_pd (double * mem_addr, __m256d a)
          MOVNTPD m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_stream_ps (float * mem_addr, __m256 a)
          MOVNTPS m256, ymm
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_stream_pd (double * mem_addr, __m256d a)
          MOVNTPD m256, ymm
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_sub_ps (__m256 a, __m256 b)
          VSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_sub_pd (__m256d a, __m256d b)
          VSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_sub_ps (__m256 a, __m256 b)
          VSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_sub_pd (__m256d a, __m256d b)
          VSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testc_ps (__m128 a, __m128 b)
          VTESTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testc_pd (__m128d a, __m128d b)
          VTESTPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testc_ps (__m256 a, __m256 b)
          VTESTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testc_pd (__m256d a, __m256d b)
          VTESTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testc_ps (__m128 a, __m128 b)
          VTESTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testc_pd (__m128d a, __m128d b)
          VTESTPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testc_ps (__m256 a, __m256 b)
          VTESTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testc_pd (__m256d a, __m256d b)
          VTESTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testnzc_ps (__m128 a, __m128 b)
          VTESTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testnzc_pd (__m128d a, __m128d b)
          VTESTPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testnzc_ps (__m256 a, __m256 b)
          VTESTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testnzc_pd (__m256d a, __m256d b)
          VTESTPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testnzc_ps (__m128 a, __m128 b)
          VTESTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testnzc_pd (__m128d a, __m128d b)
          VTESTPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testnzc_ps (__m256 a, __m256 b)
          VTESTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testnzc_pd (__m256d a, __m256d b)
          VTESTPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testz_ps (__m128 a, __m128 b)
          VTESTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testz_pd (__m128d a, __m128d b)
          VTESTPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testz_ps (__m256 a, __m256 b)
          VTESTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testz_pd (__m256d a, __m256d b)
          VTESTPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testz_ps (__m128 a, __m128 b)
          VTESTPS xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testz_pd (__m128d a, __m128d b)
          VTESTPD xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testz_ps (__m256 a, __m256 b)
          VTESTPS ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testz_pd (__m256d a, __m256d b)
          VTESTPD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_unpackhi_ps (__m256 a, __m256 b)
          VUNPCKHPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_unpackhi_pd (__m256d a, __m256d b)
          VUNPCKHPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_unpackhi_ps (__m256 a, __m256 b)
          VUNPCKHPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_unpackhi_pd (__m256d a, __m256d b)
          VUNPCKHPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_unpacklo_ps (__m256 a, __m256 b)
          VUNPCKLPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_unpacklo_pd (__m256d a, __m256d b)
          VUNPCKLPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_unpacklo_ps (__m256 a, __m256 b)
          VUNPCKLPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_unpacklo_pd (__m256d a, __m256d b)
          VUNPCKLPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_xor_ps (__m256 a, __m256 b)
          VXORPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_xor_pd (__m256d a, __m256d b)
          VXORPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_xor_ps (__m256 a, __m256 b)
          VXORPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_xor_pd (__m256d a, __m256d b)
          VXORPS ymm, ymm, ymm/m256
        """
        ...


class Avx2(System.Runtime.Intrinsics.X86.Avx, metaclass=abc.ABCMeta):
    """This class provides access to Intel AVX2 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Avx.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi8 (__m256i a)
          VPABSB ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi16 (__m256i a)
          VPABSW ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi32 (__m256i a)
          VPABSD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi8 (__m256i a)
          VPABSB ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi16 (__m256i a)
          VPABSW ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi32 (__m256i a)
          VPABSD ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi8 (__m256i a, __m256i b)
          VPADDB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi8 (__m256i a, __m256i b)
          VPADDB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi16 (__m256i a, __m256i b)
          VPADDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi16 (__m256i a, __m256i b)
          VPADDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi32 (__m256i a, __m256i b)
          VPADDD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi32 (__m256i a, __m256i b)
          VPADDD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi64 (__m256i a, __m256i b)
          VPADDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi64 (__m256i a, __m256i b)
          VPADDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi8 (__m256i a, __m256i b)
          VPADDB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi8 (__m256i a, __m256i b)
          VPADDB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi16 (__m256i a, __m256i b)
          VPADDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi16 (__m256i a, __m256i b)
          VPADDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi32 (__m256i a, __m256i b)
          VPADDD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi32 (__m256i a, __m256i b)
          VPADDD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi64 (__m256i a, __m256i b)
          VPADDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi64 (__m256i a, __m256i b)
          VPADDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epi8 (__m256i a, __m256i b)
          VPADDSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epu8 (__m256i a, __m256i b)
          VPADDUSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epi16 (__m256i a, __m256i b)
          VPADDSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epu16 (__m256i a, __m256i b)
          VPADDUSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epi8 (__m256i a, __m256i b)
          VPADDSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epu8 (__m256i a, __m256i b)
          VPADDUSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epi16 (__m256i a, __m256i b)
          VPADDSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epu16 (__m256i a, __m256i b)
          VPADDUSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm, ymm, ymm/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_avg_epu8 (__m256i a, __m256i b)
          VPAVGB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_avg_epu16 (__m256i a, __m256i b)
          VPAVGW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_avg_epu8 (__m256i a, __m256i b)
          VPAVGB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_avg_epu16 (__m256i a, __m256i b)
          VPAVGW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)
          VPBLENDD xmm, xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)
          VPBLENDD xmm, xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)
          VPBLENDW ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)
          VPBLENDW ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)
          VPBLENDD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)
          VPBLENDD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)
          VPBLENDD xmm, xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)
          VPBLENDD xmm, xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)
          VPBLENDW ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)
          VPBLENDW ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)
          VPBLENDD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)
          VPBLENDD ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm, ymm, ymm/m256, ymm
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_broadcastss_ps (__m128 a)
          VBROADCASTSS xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_broadcastsd_pd (__m128d a)
          VMOVDDUP xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_broadcastss_ps (__m128 a)
          VBROADCASTSS xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_broadcastsd_pd (__m128d a)
          VMOVDDUP xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm, m8
        The above native signature does not directly correspond to the managed signature.
        We provide this additional overload for the lack of pointers to managed.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcastss_ps (__m128 a)
          VBROADCASTSS ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcastsd_pd (__m128d a)
          VBROADCASTSD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcastss_ps (__m128 a)
          VBROADCASTSS ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcastsd_pd (__m128d a)
          VBROADCASTSD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128 ymm, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)
          VPCMPEQB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)
          VPCMPEQB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)
          VPCMPEQW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)
          VPCMPEQW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)
          VPCMPEQD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)
          VPCMPEQD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)
          VPCMPEQQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)
          VPCMPEQQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)
          VPCMPEQB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)
          VPCMPEQB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)
          VPCMPEQW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)
          VPCMPEQW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)
          VPCMPEQD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)
          VPCMPEQD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)
          VPCMPEQQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)
          VPCMPEQQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi8 (__m256i a, __m256i b)
          VPCMPGTB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi16 (__m256i a, __m256i b)
          VPCMPGTW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi32 (__m256i a, __m256i b)
          VPCMPGTD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi64 (__m256i a, __m256i b)
          VPCMPGTQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi8 (__m256i a, __m256i b)
          VPCMPGTB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi16 (__m256i a, __m256i b)
          VPCMPGTW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi32 (__m256i a, __m256i b)
          VPCMPGTD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi64 (__m256i a, __m256i b)
          VPCMPGTQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_cvtsi256_si32 (__m256i a)
          MOVD reg/m32, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_cvtsi256_si32 (__m256i a)
          MOVD reg/m32, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToUInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_cvtsi256_si32 (__m256i a)
          MOVD reg/m32, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToUInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_cvtsi256_si32 (__m256i a)
          MOVD reg/m32, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi16 (__m128i a)
          VPMOVSXBW ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi16 (__m128i a)
          VPMOVZXBW ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBW ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBW ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi16 (__m128i a)
          VPMOVSXBW ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi16 (__m128i a)
          VPMOVZXBW ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBW ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBW ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi32 (__m128i a)
          VPMOVSXBD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi32 (__m128i a)
          VPMOVZXBD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi16_epi32 (__m128i a)
          VPMOVSXWD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu16_epi32 (__m128i a)
          VPMOVZXWD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBD ymm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBD ymm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXWD ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXWD ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi32 (__m128i a)
          VPMOVSXBD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi32 (__m128i a)
          VPMOVZXBD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi16_epi32 (__m128i a)
          VPMOVSXWD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu16_epi32 (__m128i a)
          VPMOVZXWD ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBD ymm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBD ymm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXWD ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXWD ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi64 (__m128i a)
          VPMOVSXBQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi64 (__m128i a)
          VPMOVZXBQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi16_epi64 (__m128i a)
          VPMOVSXWQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu16_epi64 (__m128i a)
          VPMOVZXWQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi32_epi64 (__m128i a)
          VPMOVSXDQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu32_epi64 (__m128i a)
          VPMOVZXDQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBQ ymm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBQ ymm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXWQ ymm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXWQ ymm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXDQ ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXDQ ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi64 (__m128i a)
          VPMOVSXBQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi64 (__m128i a)
          VPMOVZXBQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi16_epi64 (__m128i a)
          VPMOVSXWQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu16_epi64 (__m128i a)
          VPMOVZXWQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi32_epi64 (__m128i a)
          VPMOVSXDQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu32_epi64 (__m128i a)
          VPMOVZXDQ ymm, xmm
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBQ ymm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBQ ymm, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXWQ ymm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXWQ ymm, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXDQ ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXDQ ymm, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128 xmm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDQ xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDQ xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mask_i32gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)
          VGATHERDPS xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mask_i32gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)
          VGATHERDPD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQQ xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQQ xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mask_i64gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)
          VGATHERQPS xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mask_i64gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)
          VGATHERQPD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm, vm32y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm, vm32y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_mask_i64gather_ps (__m128 src, float const* base_addr, __m256i vindex, __m128 mask, const int scale)
          VGATHERQPS xmm, vm32y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDQ xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDQ xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mask_i32gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)
          VGATHERDPS xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mask_i32gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)
          VGATHERDPD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQQ xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQQ xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mask_i64gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)
          VGATHERQPS xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mask_i64gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)
          VGATHERQPD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm, vm32y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm, vm32y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_mask_i64gather_ps (__m128 src, float const* base_addr, __m256i vindex, __m128 mask, const int scale)
          VGATHERQPS xmm, vm32y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERDD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERDD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)
          VPGATHERDQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)
          VPGATHERDQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_mask_i32gather_ps (__m256 src, float const* base_addr, __m256i vindex, __m256 mask, const int scale)
          VPGATHERDPS ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mask_i32gather_pd (__m256d src, double const* base_addr, __m128i vindex, __m256d mask, const int scale)
          VPGATHERDPD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERQQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERQQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mask_i64gather_pd (__m256d src, double const* base_addr, __m256i vindex, __m256d mask, const int scale)
          VGATHERQPD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERDD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERDD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)
          VPGATHERDQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)
          VPGATHERDQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_mask_i32gather_ps (__m256 src, float const* base_addr, __m256i vindex, __m256 mask, const int scale)
          VPGATHERDPS ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mask_i32gather_pd (__m256d src, double const* base_addr, __m128i vindex, __m256d mask, const int scale)
          VPGATHERDPD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERQQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERQQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mask_i64gather_pd (__m256d src, double const* base_addr, __m256i vindex, __m256d mask, const int scale)
          VGATHERQPD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERDD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERDD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_i32gather_ps (float const* base_addr, __m128i vindex, const int scale)
          VGATHERDPS xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERDPD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERQD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERQD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERQQ xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERQQ xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_i64gather_ps (float const* base_addr, __m128i vindex, const int scale)
          VGATHERQPS xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_i64gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERQPD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERQD xmm, vm64y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERQD xmm, vm64y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_i64gather_ps (float const* base_addr, __m256i vindex, const int scale)
          VGATHERQPS xmm, vm64y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERDD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERDD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_i32gather_ps (float const* base_addr, __m128i vindex, const int scale)
          VGATHERDPS xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERDPD xmm, vm32x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERQD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERQD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERQQ xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERQQ xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_i64gather_ps (float const* base_addr, __m128i vindex, const int scale)
          VGATHERQPS xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_i64gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERQPD xmm, vm64x, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERQD xmm, vm64y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERQD xmm, vm64y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_i64gather_ps (float const* base_addr, __m256i vindex, const int scale)
          VGATHERQPS xmm, vm64y, xmm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERDD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERDD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_i32gather_ps (float const* base_addr, __m256i vindex, const int scale)
          VGATHERDPS ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERDPD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)
          VPGATHERQQ ymm, vm64y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)
          VPGATHERQQ ymm, vm64y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_i64gather_pd (double const* base_addr, __m256i vindex, const int scale)
          VGATHERQPD ymm, vm64y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERDD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERDD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_i32gather_ps (float const* base_addr, __m256i vindex, const int scale)
          VGATHERDPS ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERDPD ymm, vm32y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)
          VPGATHERQQ ymm, vm64y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)
          VPGATHERQQ ymm, vm64y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_i64gather_pd (double const* base_addr, __m256i vindex, const int scale)
          VGATHERQPD ymm, vm64y, ymm
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadd_epi16 (__m256i a, __m256i b)
          VPHADDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadd_epi32 (__m256i a, __m256i b)
          VPHADDD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadd_epi16 (__m256i a, __m256i b)
          VPHADDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadd_epi32 (__m256i a, __m256i b)
          VPHADDD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadds_epi16 (__m256i a, __m256i b)
          VPHADDSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadds_epi16 (__m256i a, __m256i b)
          VPHADDSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsub_epi16 (__m256i a, __m256i b)
          VPHSUBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsub_epi32 (__m256i a, __m256i b)
          VPHSUBD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsub_epi16 (__m256i a, __m256i b)
          VPHSUBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsub_epi32 (__m256i a, __m256i b)
          VPHSUBD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsubs_epi16 (__m256i a, __m256i b)
          VPHSUBSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsubs_epi16 (__m256i a, __m256i b)
          VPHSUBSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128 ymm, ymm, xmm, imm8
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)
          VPMASKMOVD xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)
          VPMASKMOVD xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)
          VPMASKMOVQ xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)
          VPMASKMOVQ xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)
          VPMASKMOVD ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)
          VPMASKMOVD ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)
          VPMASKMOVQ ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)
          VPMASKMOVQ ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)
          VPMASKMOVD xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)
          VPMASKMOVD xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)
          VPMASKMOVQ xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)
          VPMASKMOVQ xmm, xmm, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)
          VPMASKMOVD ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)
          VPMASKMOVD ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)
          VPMASKMOVQ ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)
          VPMASKMOVQ ymm, ymm, m256
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVD m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVD m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVQ m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVQ m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVD m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVD m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVQ m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVQ m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVD m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVD m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVQ m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVQ m128, xmm, xmm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVD m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVD m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVQ m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVQ m256, ymm, ymm
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi8 (__m256i a, __m256i b)
          VPMAXSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu8 (__m256i a, __m256i b)
          VPMAXUB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi16 (__m256i a, __m256i b)
          VPMAXSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu16 (__m256i a, __m256i b)
          VPMAXUW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi32 (__m256i a, __m256i b)
          VPMAXSD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu32 (__m256i a, __m256i b)
          VPMAXUD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi8 (__m256i a, __m256i b)
          VPMAXSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu8 (__m256i a, __m256i b)
          VPMAXUB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi16 (__m256i a, __m256i b)
          VPMAXSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu16 (__m256i a, __m256i b)
          VPMAXUW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi32 (__m256i a, __m256i b)
          VPMAXSD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu32 (__m256i a, __m256i b)
          VPMAXUD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi8 (__m256i a, __m256i b)
          VPMINSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu8 (__m256i a, __m256i b)
          VPMINUB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi16 (__m256i a, __m256i b)
          VPMINSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu16 (__m256i a, __m256i b)
          VPMINUW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi32 (__m256i a, __m256i b)
          VPMINSD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu32 (__m256i a, __m256i b)
          VPMINUD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi8 (__m256i a, __m256i b)
          VPMINSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu8 (__m256i a, __m256i b)
          VPMINUB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi16 (__m256i a, __m256i b)
          VPMINSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu16 (__m256i a, __m256i b)
          VPMINUW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi32 (__m256i a, __m256i b)
          VPMINSD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu32 (__m256i a, __m256i b)
          VPMINUD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_movemask_epi8 (__m256i a)
          VPMOVMSKB reg, ymm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_movemask_epi8 (__m256i a)
          VPMOVMSKB reg, ymm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_movemask_epi8 (__m256i a)
          VPMOVMSKB reg, ymm
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_movemask_epi8 (__m256i a)
          VPMOVMSKB reg, ymm
        """
        ...

    @staticmethod
    @overload
    def MultipleSumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mpsadbw_epu8 (__m256i a, __m256i b, const int imm8)
          VMPSADBW ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def MultipleSumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mpsadbw_epu8 (__m256i a, __m256i b, const int imm8)
          VMPSADBW ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mul_epi32 (__m256i a, __m256i b)
          VPMULDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mul_epu32 (__m256i a, __m256i b)
          VPMULUDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mul_epi32 (__m256i a, __m256i b)
          VPMULDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mul_epu32 (__m256i a, __m256i b)
          VPMULUDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_madd_epi16 (__m256i a, __m256i b)
          VPMADDWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maddubs_epi16 (__m256i a, __m256i b)
          VPMADDUBSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_madd_epi16 (__m256i a, __m256i b)
          VPMADDWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maddubs_epi16 (__m256i a, __m256i b)
          VPMADDUBSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhi_epi16 (__m256i a, __m256i b)
          VPMULHW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhi_epu16 (__m256i a, __m256i b)
          VPMULHUW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhi_epi16 (__m256i a, __m256i b)
          VPMULHW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhi_epu16 (__m256i a, __m256i b)
          VPMULHUW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHighRoundScale(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhrs_epi16 (__m256i a, __m256i b)
          VPMULHRSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHighRoundScale(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhrs_epi16 (__m256i a, __m256i b)
          VPMULHRSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi16 (__m256i a, __m256i b)
          VPMULLW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi16 (__m256i a, __m256i b)
          VPMULLW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi32 (__m256i a, __m256i b)
          VPMULLD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi32 (__m256i a, __m256i b)
          VPMULLD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi16 (__m256i a, __m256i b)
          VPMULLW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi16 (__m256i a, __m256i b)
          VPMULLW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi32 (__m256i a, __m256i b)
          VPMULLD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi32 (__m256i a, __m256i b)
          VPMULLD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packs_epi16 (__m256i a, __m256i b)
          VPACKSSWB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packs_epi32 (__m256i a, __m256i b)
          VPACKSSDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packs_epi16 (__m256i a, __m256i b)
          VPACKSSWB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packs_epi32 (__m256i a, __m256i b)
          VPACKSSDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packus_epi16 (__m256i a, __m256i b)
          VPACKUSWB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packus_epi32 (__m256i a, __m256i b)
          VPACKUSDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packus_epi16 (__m256i a, __m256i b)
          VPACKUSWB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packus_epi32 (__m256i a, __m256i b)
          VPACKUSDW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)
          VPERMQ ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)
          VPERMQ ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute4x64_pd (__m256d a, const int imm8)
          VPERMPD ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)
          VPERMQ ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)
          VPERMQ ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute4x64_pd (__m256d a, const int imm8)
          VPERMPD ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)
          VPERMD ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)
          VPERMD ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permutevar8x32_ps (__m256 a, __m256i idx)
          VPERMPS ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)
          VPERMD ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)
          VPERMD ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permutevar8x32_ps (__m256 a, __m256i idx)
          VPERMPS ymm, ymm/m256, ymm
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi16 (__m256i a, __m128i count)
          VPSLLW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi16 (__m256i a, __m128i count)
          VPSLLW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi32 (__m256i a, __m128i count)
          VPSLLD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi32 (__m256i a, __m128i count)
          VPSLLD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi64 (__m256i a, __m128i count)
          VPSLLQ ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi64 (__m256i a, __m128i count)
          VPSLLQ ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi16 (__m256i a, int imm8)
          VPSLLW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi16 (__m256i a, int imm8)
          VPSLLW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi32 (__m256i a, int imm8)
          VPSLLD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi32 (__m256i a, int imm8)
          VPSLLD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi64 (__m256i a, int imm8)
          VPSLLQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi64 (__m256i a, int imm8)
          VPSLLQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi16 (__m256i a, __m128i count)
          VPSLLW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi16 (__m256i a, __m128i count)
          VPSLLW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi32 (__m256i a, __m128i count)
          VPSLLD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi32 (__m256i a, __m128i count)
          VPSLLD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi64 (__m256i a, __m128i count)
          VPSLLQ ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi64 (__m256i a, __m128i count)
          VPSLLQ ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi16 (__m256i a, int imm8)
          VPSLLW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi16 (__m256i a, int imm8)
          VPSLLW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi32 (__m256i a, int imm8)
          VPSLLD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi32 (__m256i a, int imm8)
          VPSLLD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi64 (__m256i a, int imm8)
          VPSLLQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi64 (__m256i a, int imm8)
          VPSLLQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi32 (__m256i a, __m256i count)
          VPSLLVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi32 (__m256i a, __m256i count)
          VPSLLVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi64 (__m256i a, __m256i count)
          VPSLLVQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi64 (__m256i a, __m256i count)
          VPSLLVQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi32 (__m128i a, __m128i count)
          VPSLLVD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi32 (__m128i a, __m128i count)
          VPSLLVD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi64 (__m128i a, __m128i count)
          VPSLLVQ xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi64 (__m128i a, __m128i count)
          VPSLLVQ xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi32 (__m256i a, __m256i count)
          VPSLLVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi32 (__m256i a, __m256i count)
          VPSLLVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi64 (__m256i a, __m256i count)
          VPSLLVQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi64 (__m256i a, __m256i count)
          VPSLLVQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi32 (__m128i a, __m128i count)
          VPSLLVD xmm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi32 (__m128i a, __m128i count)
          VPSLLVD xmm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi64 (__m128i a, __m128i count)
          VPSLLVQ xmm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi64 (__m128i a, __m128i count)
          VPSLLVQ xmm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        _mm256_sra_epi16 (__m256i a, __m128i count)
          VPSRAW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        _mm256_sra_epi32 (__m256i a, __m128i count)
          VPSRAD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srai_epi16 (__m256i a, int imm8)
          VPSRAW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srai_epi32 (__m256i a, int imm8)
          VPSRAD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        _mm256_sra_epi16 (__m256i a, __m128i count)
          VPSRAW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        _mm256_sra_epi32 (__m256i a, __m128i count)
          VPSRAD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srai_epi16 (__m256i a, int imm8)
          VPSRAW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srai_epi32 (__m256i a, int imm8)
          VPSRAD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmeticVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srav_epi32 (__m256i a, __m256i count)
          VPSRAVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmeticVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srav_epi32 (__m128i a, __m128i count)
          VPSRAVD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmeticVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srav_epi32 (__m256i a, __m256i count)
          VPSRAVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmeticVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srav_epi32 (__m128i a, __m128i count)
          VPSRAVD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi16 (__m256i a, __m128i count)
          VPSRLW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi16 (__m256i a, __m128i count)
          VPSRLW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi32 (__m256i a, __m128i count)
          VPSRLD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi32 (__m256i a, __m128i count)
          VPSRLD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi64 (__m256i a, __m128i count)
          VPSRLQ ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi64 (__m256i a, __m128i count)
          VPSRLQ ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi16 (__m256i a, int imm8)
          VPSRLW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi16 (__m256i a, int imm8)
          VPSRLW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi32 (__m256i a, int imm8)
          VPSRLD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi32 (__m256i a, int imm8)
          VPSRLD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi64 (__m256i a, int imm8)
          VPSRLQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi64 (__m256i a, int imm8)
          VPSRLQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi16 (__m256i a, __m128i count)
          VPSRLW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi16 (__m256i a, __m128i count)
          VPSRLW ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi32 (__m256i a, __m128i count)
          VPSRLD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi32 (__m256i a, __m128i count)
          VPSRLD ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi64 (__m256i a, __m128i count)
          VPSRLQ ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi64 (__m256i a, __m128i count)
          VPSRLQ ymm, ymm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi16 (__m256i a, int imm8)
          VPSRLW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi16 (__m256i a, int imm8)
          VPSRLW ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi32 (__m256i a, int imm8)
          VPSRLD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi32 (__m256i a, int imm8)
          VPSRLD ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi64 (__m256i a, int imm8)
          VPSRLQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi64 (__m256i a, int imm8)
          VPSRLQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm, ymm, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi32 (__m256i a, __m256i count)
          VPSRLVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi32 (__m256i a, __m256i count)
          VPSRLVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi64 (__m256i a, __m256i count)
          VPSRLVQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi64 (__m256i a, __m256i count)
          VPSRLVQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi32 (__m128i a, __m128i count)
          VPSRLVD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi32 (__m128i a, __m128i count)
          VPSRLVD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi64 (__m128i a, __m128i count)
          VPSRLVQ xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi64 (__m128i a, __m128i count)
          VPSRLVQ xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi32 (__m256i a, __m256i count)
          VPSRLVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi32 (__m256i a, __m256i count)
          VPSRLVD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi64 (__m256i a, __m256i count)
          VPSRLVQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi64 (__m256i a, __m256i count)
          VPSRLVQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi32 (__m128i a, __m128i count)
          VPSRLVD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi32 (__m128i a, __m128i count)
          VPSRLVD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi64 (__m128i a, __m128i count)
          VPSRLVQ xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi64 (__m128i a, __m128i count)
          VPSRLVQ xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)
          VPSHUFB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)
          VPSHUFB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)
          VPSHUFD ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)
          VPSHUFD ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)
          VPSHUFB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)
          VPSHUFB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)
          VPSHUFD ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)
          VPSHUFD ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)
          VPSHUFHW ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)
          VPSHUFHW ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)
          VPSHUFHW ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)
          VPSHUFHW ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)
          VPSHUFLW ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)
          VPSHUFLW ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)
          VPSHUFLW ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)
          VPSHUFLW ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi8 (__m256i a, __m256i b)
          VPSIGNB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi16 (__m256i a, __m256i b)
          VPSIGNW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi32 (__m256i a, __m256i b)
          VPSIGND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi8 (__m256i a, __m256i b)
          VPSIGNB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi16 (__m256i a, __m256i b)
          VPSIGNW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi32 (__m256i a, __m256i b)
          VPSIGND ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi8 (__m256i a, __m256i b)
          VPSUBB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi8 (__m256i a, __m256i b)
          VPSUBB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi16 (__m256i a, __m256i b)
          VPSUBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi16 (__m256i a, __m256i b)
          VPSUBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi32 (__m256i a, __m256i b)
          VPSUBD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi32 (__m256i a, __m256i b)
          VPSUBD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi64 (__m256i a, __m256i b)
          VPSUBQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi64 (__m256i a, __m256i b)
          VPSUBQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi8 (__m256i a, __m256i b)
          VPSUBB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi8 (__m256i a, __m256i b)
          VPSUBB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi16 (__m256i a, __m256i b)
          VPSUBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi16 (__m256i a, __m256i b)
          VPSUBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi32 (__m256i a, __m256i b)
          VPSUBD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi32 (__m256i a, __m256i b)
          VPSUBD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi64 (__m256i a, __m256i b)
          VPSUBQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi64 (__m256i a, __m256i b)
          VPSUBQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epi8 (__m256i a, __m256i b)
          VPSUBSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epi16 (__m256i a, __m256i b)
          VPSUBSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epu8 (__m256i a, __m256i b)
          VPSUBUSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epu16 (__m256i a, __m256i b)
          VPSUBUSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epi8 (__m256i a, __m256i b)
          VPSUBSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epi16 (__m256i a, __m256i b)
          VPSUBSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epu8 (__m256i a, __m256i b)
          VPSUBUSB ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epu16 (__m256i a, __m256i b)
          VPSUBUSW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sad_epu8 (__m256i a, __m256i b)
          VPSADBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def SumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sad_epu8 (__m256i a, __m256i b)
          VPSADBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)
          VPUNPCKHBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)
          VPUNPCKHBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)
          VPUNPCKHWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)
          VPUNPCKHWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)
          VPUNPCKHDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)
          VPUNPCKHDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)
          VPUNPCKHQDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)
          VPUNPCKHQDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)
          VPUNPCKHBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)
          VPUNPCKHBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)
          VPUNPCKHWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)
          VPUNPCKHWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)
          VPUNPCKHDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)
          VPUNPCKHDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)
          VPUNPCKHQDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)
          VPUNPCKHQDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)
          VPUNPCKLBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)
          VPUNPCKLBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)
          VPUNPCKLWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)
          VPUNPCKLWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)
          VPUNPCKLDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)
          VPUNPCKLDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)
          VPUNPCKLQDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)
          VPUNPCKLQDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)
          VPUNPCKLBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)
          VPUNPCKLBW ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)
          VPUNPCKLWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)
          VPUNPCKLWD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)
          VPUNPCKLDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)
          VPUNPCKLDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)
          VPUNPCKLQDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)
          VPUNPCKLQDQ ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm, ymm, ymm/m256
        """
        ...


class X86Serialize(System.Runtime.Intrinsics.X86.X86Base, metaclass=abc.ABCMeta):
    """This class provides access to Intel SERIALIZE hardware instruction via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.X86Base.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def Serialize() -> None:
        """void _serialize (void);"""
        ...

    @staticmethod
    @overload
    def Serialize() -> None:
        """void _serialize (void);"""
        ...


class Avx512F(System.Runtime.Intrinsics.X86.Avx2, metaclass=abc.ABCMeta):
    """This class provides access to X86 AVX512F hardware instructions via intrinsics"""

    class VL(System.Object, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    class X64(System.Runtime.Intrinsics.X86.Avx2.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool


class Lzcnt(System.Runtime.Intrinsics.X86.X86Base, metaclass=abc.ABCMeta):
    """This class provides access to Intel LZCNT hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.X86Base.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def LeadingZeroCount(value: int) -> int:
            """
            unsigned __int64 _lzcnt_u64 (unsigned __int64 a)
              LZCNT reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def LeadingZeroCount(value: int) -> int:
            """
            unsigned __int64 _lzcnt_u64 (unsigned __int64 a)
              LZCNT reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def LeadingZeroCount(value: int) -> int:
        """
        unsigned int _lzcnt_u32 (unsigned int a)
          LZCNT reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def LeadingZeroCount(value: int) -> int:
        """
        unsigned int _lzcnt_u32 (unsigned int a)
          LZCNT reg, reg/m32
        """
        ...


class Avx512DQ(System.Runtime.Intrinsics.X86.Avx512F, metaclass=abc.ABCMeta):
    """This class provides access to X86 AVX512DQ hardware instructions via intrinsics"""

    class VL(System.Runtime.Intrinsics.X86.Avx512F.VL, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    class X64(System.Runtime.Intrinsics.X86.Avx512F.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool


class AvxVnni(System.Runtime.Intrinsics.X86.Avx2, metaclass=abc.ABCMeta):
    """This class has no documentation."""

    class X64(System.Runtime.Intrinsics.X86.Avx2.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def MultiplyWideningAndAdd(addend: System.Runtime.Intrinsics.Vector128[int], left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_dpbusd_epi32 (__m128i src, __m128i a, __m128i b)
        VPDPBUSD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAdd(addend: System.Runtime.Intrinsics.Vector128[int], left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_dpwssd_epi32 (__m128i src, __m128i a, __m128i b)
        VPDPWSSD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAdd(addend: System.Runtime.Intrinsics.Vector256[int], left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_dpbusd_epi32 (__m256i src, __m256i a, __m256i b)
        VPDPBUSD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAdd(addend: System.Runtime.Intrinsics.Vector256[int], left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_dpwssd_epi32 (__m256i src, __m256i a, __m256i b)
        VPDPWSSD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAdd(addend: System.Runtime.Intrinsics.Vector128[int], left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_dpbusd_epi32 (__m128i src, __m128i a, __m128i b)
        VPDPBUSD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAdd(addend: System.Runtime.Intrinsics.Vector128[int], left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_dpwssd_epi32 (__m128i src, __m128i a, __m128i b)
        VPDPWSSD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAdd(addend: System.Runtime.Intrinsics.Vector256[int], left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_dpbusd_epi32 (__m256i src, __m256i a, __m256i b)
        VPDPBUSD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAdd(addend: System.Runtime.Intrinsics.Vector256[int], left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_dpwssd_epi32 (__m256i src, __m256i a, __m256i b)
        VPDPWSSD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAddSaturate(addend: System.Runtime.Intrinsics.Vector128[int], left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_dpbusds_epi32 (__m128i src, __m128i a, __m128i b)
        VPDPBUSDS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAddSaturate(addend: System.Runtime.Intrinsics.Vector128[int], left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_dpwssds_epi32 (__m128i src, __m128i a, __m128i b)
        VPDPWSSDS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAddSaturate(addend: System.Runtime.Intrinsics.Vector256[int], left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_dpbusds_epi32 (__m256i src, __m256i a, __m256i b)
        VPDPBUSDS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAddSaturate(addend: System.Runtime.Intrinsics.Vector256[int], left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_dpwssds_epi32 (__m256i src, __m256i a, __m256i b)
        VPDPWSSDS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAddSaturate(addend: System.Runtime.Intrinsics.Vector128[int], left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_dpbusds_epi32 (__m128i src, __m128i a, __m128i b)
        VPDPBUSDS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAddSaturate(addend: System.Runtime.Intrinsics.Vector128[int], left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_dpwssds_epi32 (__m128i src, __m128i a, __m128i b)
        VPDPWSSDS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAddSaturate(addend: System.Runtime.Intrinsics.Vector256[int], left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_dpbusds_epi32 (__m256i src, __m256i a, __m256i b)
        VPDPBUSDS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyWideningAndAddSaturate(addend: System.Runtime.Intrinsics.Vector256[int], left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_dpwssds_epi32 (__m256i src, __m256i a, __m256i b)
        VPDPWSSDS ymm, ymm, ymm/m256
        """
        ...


class Avx512CD(System.Runtime.Intrinsics.X86.Avx512F, metaclass=abc.ABCMeta):
    """This class provides access to X86 AVX512CD hardware instructions via intrinsics"""

    class VL(System.Runtime.Intrinsics.X86.Avx512F.VL, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    class X64(System.Runtime.Intrinsics.X86.Avx512F.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool


class Pclmulqdq(System.Runtime.Intrinsics.X86.Sse2, metaclass=abc.ABCMeta):
    """This class provides access to Intel PCLMULQDQ hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse2.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def CarrylessMultiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_clmulepi64_si128 (__m128i a, __m128i b, const int imm8)
          PCLMULQDQ xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def CarrylessMultiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_clmulepi64_si128 (__m128i a, __m128i b, const int imm8)
          PCLMULQDQ xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def CarrylessMultiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_clmulepi64_si128 (__m128i a, __m128i b, const int imm8)
          PCLMULQDQ xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def CarrylessMultiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_clmulepi64_si128 (__m128i a, __m128i b, const int imm8)
          PCLMULQDQ xmm, xmm/m128, imm8
        """
        ...


class Bmi1(System.Runtime.Intrinsics.X86.X86Base, metaclass=abc.ABCMeta):
    """This class provides access to Intel BMI1 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.X86Base.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def AndNot(left: int, right: int) -> int:
            """
            unsigned __int64 _andn_u64 (unsigned __int64 a, unsigned __int64 b)
              ANDN r64a, r64b, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def AndNot(left: int, right: int) -> int:
            """
            unsigned __int64 _andn_u64 (unsigned __int64 a, unsigned __int64 b)
              ANDN r64a, r64b, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def BitFieldExtract(value: int, start: int, length: int) -> int:
            """
            unsigned __int64 _bextr_u64 (unsigned __int64 a, unsigned int start, unsigned int len)
              BEXTR r64a, reg/m64, r64b
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def BitFieldExtract(value: int, control: int) -> int:
            """
            unsigned __int64 _bextr2_u64 (unsigned __int64 a, unsigned __int64 control)
              BEXTR r64a, reg/m64, r64b
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def BitFieldExtract(value: int, start: int, length: int) -> int:
            """
            unsigned __int64 _bextr_u64 (unsigned __int64 a, unsigned int start, unsigned int len)
              BEXTR r64a, reg/m64, r64b
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def BitFieldExtract(value: int, control: int) -> int:
            """
            unsigned __int64 _bextr2_u64 (unsigned __int64 a, unsigned __int64 control)
              BEXTR r64a, reg/m64, r64b
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ExtractLowestSetBit(value: int) -> int:
            """
            unsigned __int64 _blsi_u64 (unsigned __int64 a)
              BLSI reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ExtractLowestSetBit(value: int) -> int:
            """
            unsigned __int64 _blsi_u64 (unsigned __int64 a)
              BLSI reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def GetMaskUpToLowestSetBit(value: int) -> int:
            """
            unsigned __int64 _blsmsk_u64 (unsigned __int64 a)
              BLSMSK reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def GetMaskUpToLowestSetBit(value: int) -> int:
            """
            unsigned __int64 _blsmsk_u64 (unsigned __int64 a)
              BLSMSK reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ResetLowestSetBit(value: int) -> int:
            """
            unsigned __int64 _blsr_u64 (unsigned __int64 a)
              BLSR reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ResetLowestSetBit(value: int) -> int:
            """
            unsigned __int64 _blsr_u64 (unsigned __int64 a)
              BLSR reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def TrailingZeroCount(value: int) -> int:
            """
            __int64 _mm_tzcnt_64 (unsigned __int64 a)
              TZCNT reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def TrailingZeroCount(value: int) -> int:
            """
            __int64 _mm_tzcnt_64 (unsigned __int64 a)
              TZCNT reg, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def AndNot(left: int, right: int) -> int:
        """
        unsigned int _andn_u32 (unsigned int a, unsigned int b)
          ANDN r32a, r32b, reg/m32
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: int, right: int) -> int:
        """
        unsigned int _andn_u32 (unsigned int a, unsigned int b)
          ANDN r32a, r32b, reg/m32
        """
        ...

    @staticmethod
    @overload
    def BitFieldExtract(value: int, start: int, length: int) -> int:
        """
        unsigned int _bextr_u32 (unsigned int a, unsigned int start, unsigned int len)
          BEXTR r32a, reg/m32, r32b
        """
        ...

    @staticmethod
    @overload
    def BitFieldExtract(value: int, control: int) -> int:
        """
        unsigned int _bextr2_u32 (unsigned int a, unsigned int control)
          BEXTR r32a, reg/m32, r32b
        """
        ...

    @staticmethod
    @overload
    def BitFieldExtract(value: int, start: int, length: int) -> int:
        """
        unsigned int _bextr_u32 (unsigned int a, unsigned int start, unsigned int len)
          BEXTR r32a, reg/m32, r32b
        """
        ...

    @staticmethod
    @overload
    def BitFieldExtract(value: int, control: int) -> int:
        """
        unsigned int _bextr2_u32 (unsigned int a, unsigned int control)
          BEXTR r32a, reg/m32, r32b
        """
        ...

    @staticmethod
    @overload
    def ExtractLowestSetBit(value: int) -> int:
        """
        unsigned int _blsi_u32 (unsigned int a)
          BLSI reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ExtractLowestSetBit(value: int) -> int:
        """
        unsigned int _blsi_u32 (unsigned int a)
          BLSI reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def GetMaskUpToLowestSetBit(value: int) -> int:
        """
        unsigned int _blsmsk_u32 (unsigned int a)
          BLSMSK reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def GetMaskUpToLowestSetBit(value: int) -> int:
        """
        unsigned int _blsmsk_u32 (unsigned int a)
          BLSMSK reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ResetLowestSetBit(value: int) -> int:
        """
        unsigned int _blsr_u32 (unsigned int a)
          BLSR reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ResetLowestSetBit(value: int) -> int:
        """
        unsigned int _blsr_u32 (unsigned int a)
          BLSR reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def TrailingZeroCount(value: int) -> int:
        """
        int _mm_tzcnt_32 (unsigned int a)
          TZCNT reg, reg/m32
        """
        ...

    @staticmethod
    @overload
    def TrailingZeroCount(value: int) -> int:
        """
        int _mm_tzcnt_32 (unsigned int a)
          TZCNT reg, reg/m32
        """
        ...


class Bmi2(System.Runtime.Intrinsics.X86.X86Base, metaclass=abc.ABCMeta):
    """This class provides access to Intel BMI2 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.X86Base.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def MultiplyNoFlags(left: int, right: int) -> int:
            """
            unsigned __int64 _mulx_u64 (unsigned __int64 a, unsigned __int64 b, unsigned __int64* hi)
              MULX r64a, r64b, reg/m64
            The above native signature does not directly correspond to the managed signature.
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def MultiplyNoFlags(left: int, right: int, low: typing.Any) -> int:
            """
            unsigned __int64 _mulx_u64 (unsigned __int64 a, unsigned __int64 b, unsigned __int64* hi)
              MULX r64a, r64b, reg/m64
            The above native signature does not directly correspond to the managed signature.
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def MultiplyNoFlags(left: int, right: int) -> int:
            """
            unsigned __int64 _mulx_u64 (unsigned __int64 a, unsigned __int64 b, unsigned __int64* hi)
              MULX r64a, r64b, reg/m64
            The above native signature does not directly correspond to the managed signature.
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def MultiplyNoFlags(left: int, right: int, low: typing.Any) -> int:
            """
            unsigned __int64 _mulx_u64 (unsigned __int64 a, unsigned __int64 b, unsigned __int64* hi)
              MULX r64a, r64b, reg/m64
            The above native signature does not directly correspond to the managed signature.
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ParallelBitDeposit(value: int, mask: int) -> int:
            """
            unsigned __int64 _pdep_u64 (unsigned __int64 a, unsigned __int64 mask)
              PDEP r64a, r64b, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ParallelBitDeposit(value: int, mask: int) -> int:
            """
            unsigned __int64 _pdep_u64 (unsigned __int64 a, unsigned __int64 mask)
              PDEP r64a, r64b, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ParallelBitExtract(value: int, mask: int) -> int:
            """
            unsigned __int64 _pext_u64 (unsigned __int64 a, unsigned __int64 mask)
              PEXT r64a, r64b, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ParallelBitExtract(value: int, mask: int) -> int:
            """
            unsigned __int64 _pext_u64 (unsigned __int64 a, unsigned __int64 mask)
              PEXT r64a, r64b, reg/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ZeroHighBits(value: int, index: int) -> int:
            """
            unsigned __int64 _bzhi_u64 (unsigned __int64 a, unsigned int index)
              BZHI r64a, reg/m32, r64b
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ZeroHighBits(value: int, index: int) -> int:
            """
            unsigned __int64 _bzhi_u64 (unsigned __int64 a, unsigned int index)
              BZHI r64a, reg/m32, r64b
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def MultiplyNoFlags(left: int, right: int) -> int:
        """
        unsigned int _mulx_u32 (unsigned int a, unsigned int b, unsigned int* hi)
          MULX r32a, r32b, reg/m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def MultiplyNoFlags(left: int, right: int, low: typing.Any) -> int:
        """
        unsigned int _mulx_u32 (unsigned int a, unsigned int b, unsigned int* hi)
          MULX r32a, r32b, reg/m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def MultiplyNoFlags(left: int, right: int) -> int:
        """
        unsigned int _mulx_u32 (unsigned int a, unsigned int b, unsigned int* hi)
          MULX r32a, r32b, reg/m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def MultiplyNoFlags(left: int, right: int, low: typing.Any) -> int:
        """
        unsigned int _mulx_u32 (unsigned int a, unsigned int b, unsigned int* hi)
          MULX r32a, r32b, reg/m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def ParallelBitDeposit(value: int, mask: int) -> int:
        """
        unsigned int _pdep_u32 (unsigned int a, unsigned int mask)
          PDEP r32a, r32b, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ParallelBitDeposit(value: int, mask: int) -> int:
        """
        unsigned int _pdep_u32 (unsigned int a, unsigned int mask)
          PDEP r32a, r32b, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ParallelBitExtract(value: int, mask: int) -> int:
        """
        unsigned int _pext_u32 (unsigned int a, unsigned int mask)
          PEXT r32a, r32b, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ParallelBitExtract(value: int, mask: int) -> int:
        """
        unsigned int _pext_u32 (unsigned int a, unsigned int mask)
          PEXT r32a, r32b, reg/m32
        """
        ...

    @staticmethod
    @overload
    def ZeroHighBits(value: int, index: int) -> int:
        """
        unsigned int _bzhi_u32 (unsigned int a, unsigned int index)
          BZHI r32a, reg/m32, r32b
        """
        ...

    @staticmethod
    @overload
    def ZeroHighBits(value: int, index: int) -> int:
        """
        unsigned int _bzhi_u32 (unsigned int a, unsigned int index)
          BZHI r32a, reg/m32, r32b
        """
        ...


class Fma(System.Runtime.Intrinsics.X86.Avx, metaclass=abc.ABCMeta):
    """This class provides access to Intel FMA hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Avx.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def MultiplyAdd(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmadd_ps (__m128 a, __m128 b, __m128 c)
          VFMADDPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAdd(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmadd_pd (__m128d a, __m128d b, __m128d c)
          VFMADDPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAdd(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fmadd_ps (__m256 a, __m256 b, __m256 c)
          VFMADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAdd(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fmadd_pd (__m256d a, __m256d b, __m256d c)
          VFMADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAdd(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmadd_ps (__m128 a, __m128 b, __m128 c)
          VFMADDPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAdd(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmadd_pd (__m128d a, __m128d b, __m128d c)
          VFMADDPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAdd(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fmadd_ps (__m256 a, __m256 b, __m256 c)
          VFMADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAdd(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fmadd_pd (__m256d a, __m256d b, __m256d c)
          VFMADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegated(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fnmadd_ps (__m128 a, __m128 b, __m128 c)
          VFNMADDPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegated(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fnmadd_pd (__m128d a, __m128d b, __m128d c)
          VFNMADDPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegated(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fnmadd_ps (__m256 a, __m256 b, __m256 c)
          VFNMADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegated(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fnmadd_pd (__m256d a, __m256d b, __m256d c)
          VFNMADDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegated(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fnmadd_ps (__m128 a, __m128 b, __m128 c)
          VFNMADDPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegated(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fnmadd_pd (__m128d a, __m128d b, __m128d c)
          VFNMADDPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegated(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fnmadd_ps (__m256 a, __m256 b, __m256 c)
          VFNMADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegated(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fnmadd_pd (__m256d a, __m256d b, __m256d c)
          VFNMADDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegatedScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fnmadd_ss (__m128 a, __m128 b, __m128 c)
          VFNMADDSS xmm, xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegatedScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fnmadd_sd (__m128d a, __m128d b, __m128d c)
          VFNMADDSD xmm, xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegatedScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fnmadd_ss (__m128 a, __m128 b, __m128 c)
          VFNMADDSS xmm, xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddNegatedScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fnmadd_sd (__m128d a, __m128d b, __m128d c)
          VFNMADDSD xmm, xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmadd_ss (__m128 a, __m128 b, __m128 c)
          VFMADDSS xmm, xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmadd_sd (__m128d a, __m128d b, __m128d c)
          VFMADDSS xmm, xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmadd_ss (__m128 a, __m128 b, __m128 c)
          VFMADDSS xmm, xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmadd_sd (__m128d a, __m128d b, __m128d c)
          VFMADDSS xmm, xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddSubtract(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmaddsub_ps (__m128 a, __m128 b, __m128 c)
          VFMADDSUBPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddSubtract(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmaddsub_pd (__m128d a, __m128d b, __m128d c)
          VFMADDSUBPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddSubtract(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fmaddsub_ps (__m256 a, __m256 b, __m256 c)
          VFMADDSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddSubtract(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fmaddsub_pd (__m256d a, __m256d b, __m256d c)
          VFMADDSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddSubtract(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmaddsub_ps (__m128 a, __m128 b, __m128 c)
          VFMADDSUBPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddSubtract(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmaddsub_pd (__m128d a, __m128d b, __m128d c)
          VFMADDSUBPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddSubtract(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fmaddsub_ps (__m256 a, __m256 b, __m256 c)
          VFMADDSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddSubtract(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fmaddsub_pd (__m256d a, __m256d b, __m256d c)
          VFMADDSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtract(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmsub_ps (__m128 a, __m128 b, __m128 c)
          VFMSUBPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtract(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmsub_pd (__m128d a, __m128d b, __m128d c)
          VFMSUBPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtract(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fmsub_ps (__m256 a, __m256 b, __m256 c)
          VFMSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtract(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fmsub_pd (__m256d a, __m256d b, __m256d c)
          VFMSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtract(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmsub_ps (__m128 a, __m128 b, __m128 c)
          VFMSUBPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtract(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmsub_pd (__m128d a, __m128d b, __m128d c)
          VFMSUBPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtract(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fmsub_ps (__m256 a, __m256 b, __m256 c)
          VFMSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtract(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fmsub_pd (__m256d a, __m256d b, __m256d c)
          VFMSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractAdd(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmsubadd_ps (__m128 a, __m128 b, __m128 c)
          VFMSUBADDPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractAdd(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmsubadd_pd (__m128d a, __m128d b, __m128d c)
          VFMSUBADDPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractAdd(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fmsubadd_ps (__m256 a, __m256 b, __m256 c)
          VFMSUBADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractAdd(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fmsubadd_pd (__m256d a, __m256d b, __m256d c)
          VFMSUBADDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractAdd(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmsubadd_ps (__m128 a, __m128 b, __m128 c)
          VFMSUBADDPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractAdd(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmsubadd_pd (__m128d a, __m128d b, __m128d c)
          VFMSUBADDPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractAdd(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fmsubadd_ps (__m256 a, __m256 b, __m256 c)
          VFMSUBADDPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractAdd(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fmsubadd_pd (__m256d a, __m256d b, __m256d c)
          VFMSUBADDPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegated(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fnmsub_ps (__m128 a, __m128 b, __m128 c)
          VFNMSUBPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegated(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fnmsub_pd (__m128d a, __m128d b, __m128d c)
          VFNMSUBPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegated(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fnmsub_ps (__m256 a, __m256 b, __m256 c)
          VFNMSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegated(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fnmsub_pd (__m256d a, __m256d b, __m256d c)
          VFNMSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegated(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fnmsub_ps (__m128 a, __m128 b, __m128 c)
          VFNMSUBPS xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegated(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fnmsub_pd (__m128d a, __m128d b, __m128d c)
          VFNMSUBPD xmm, xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegated(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_fnmsub_ps (__m256 a, __m256 b, __m256 c)
          VFNMSUBPS ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegated(a: System.Runtime.Intrinsics.Vector256[float], b: System.Runtime.Intrinsics.Vector256[float], c: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_fnmsub_pd (__m256d a, __m256d b, __m256d c)
          VFNMSUBPD ymm, ymm, ymm/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegatedScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fnmsub_ss (__m128 a, __m128 b, __m128 c)
          VFNMSUBSS xmm, xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegatedScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fnmsub_sd (__m128d a, __m128d b, __m128d c)
          VFNMSUBSD xmm, xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegatedScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fnmsub_ss (__m128 a, __m128 b, __m128 c)
          VFNMSUBSS xmm, xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractNegatedScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fnmsub_sd (__m128d a, __m128d b, __m128d c)
          VFNMSUBSD xmm, xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmsub_ss (__m128 a, __m128 b, __m128 c)
          VFMSUBSS xmm, xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmsub_sd (__m128d a, __m128d b, __m128d c)
          VFMSUBSD xmm, xmm, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_fmsub_ss (__m128 a, __m128 b, __m128 c)
          VFMSUBSS xmm, xmm, xmm/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplySubtractScalar(a: System.Runtime.Intrinsics.Vector128[float], b: System.Runtime.Intrinsics.Vector128[float], c: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_fmsub_sd (__m128d a, __m128d b, __m128d c)
          VFMSUBSD xmm, xmm, xmm/m64
        """
        ...


class Avx512BW(System.Runtime.Intrinsics.X86.Avx512F, metaclass=abc.ABCMeta):
    """This class provides access to X86 AVX512BW hardware instructions via intrinsics"""

    class VL(System.Runtime.Intrinsics.X86.Avx512F.VL, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    class X64(System.Runtime.Intrinsics.X86.Avx512F.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool


class Aes(System.Runtime.Intrinsics.X86.Sse2, metaclass=abc.ABCMeta):
    """This class provides access to Intel AES hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse2.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def Decrypt(value: System.Runtime.Intrinsics.Vector128[int], roundKey: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesdec_si128 (__m128i a, __m128i RoundKey)
          AESDEC xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Decrypt(value: System.Runtime.Intrinsics.Vector128[int], roundKey: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesdec_si128 (__m128i a, __m128i RoundKey)
          AESDEC xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def DecryptLast(value: System.Runtime.Intrinsics.Vector128[int], roundKey: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesdeclast_si128 (__m128i a, __m128i RoundKey)
          AESDECLAST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def DecryptLast(value: System.Runtime.Intrinsics.Vector128[int], roundKey: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesdeclast_si128 (__m128i a, __m128i RoundKey)
          AESDECLAST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Encrypt(value: System.Runtime.Intrinsics.Vector128[int], roundKey: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesenc_si128 (__m128i a, __m128i RoundKey)
          AESENC xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def Encrypt(value: System.Runtime.Intrinsics.Vector128[int], roundKey: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesenc_si128 (__m128i a, __m128i RoundKey)
          AESENC xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def EncryptLast(value: System.Runtime.Intrinsics.Vector128[int], roundKey: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesenclast_si128 (__m128i a, __m128i RoundKey)
          AESENCLAST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def EncryptLast(value: System.Runtime.Intrinsics.Vector128[int], roundKey: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesenclast_si128 (__m128i a, __m128i RoundKey)
          AESENCLAST xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def InverseMixColumns(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesimc_si128 (__m128i a)
          AESIMC xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def InverseMixColumns(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aesimc_si128 (__m128i a)
          AESIMC xmm, xmm/m128
        """
        ...

    @staticmethod
    @overload
    def KeygenAssist(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aeskeygenassist_si128 (__m128i a, const int imm8)
          AESKEYGENASSIST xmm, xmm/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def KeygenAssist(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_aeskeygenassist_si128 (__m128i a, const int imm8)
          AESKEYGENASSIST xmm, xmm/m128, imm8
        """
        ...


