from typing import overload
import typing

import System
import System.Numerics
import System.Runtime.Intrinsics

System_Runtime_Intrinsics_Vector64 = typing.Any
System_Runtime_Intrinsics_Vector128 = typing.Any
System_Runtime_Intrinsics_Vector256 = typing.Any
System_Runtime_Intrinsics_Vector512 = typing.Any

System_Runtime_Intrinsics_Vector64_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_T")
System_Runtime_Intrinsics_Vector64_Create_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Create_T")
System_Runtime_Intrinsics_Vector64_CreateScalar_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_CreateScalar_T")
System_Runtime_Intrinsics_Vector64_CreateScalarUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_CreateScalarUnsafe_T")
System_Runtime_Intrinsics_Vector64_Divide_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Divide_T")
System_Runtime_Intrinsics_Vector64_Dot_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Dot_T")
System_Runtime_Intrinsics_Vector64_GetElement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_GetElement_T")
System_Runtime_Intrinsics_Vector64_LoadUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_LoadUnsafe_T")
System_Runtime_Intrinsics_Vector64_Multiply_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Multiply_T")
System_Runtime_Intrinsics_Vector64_StoreUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_StoreUnsafe_T")
System_Runtime_Intrinsics_Vector64_Sum_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Sum_T")
System_Runtime_Intrinsics_Vector64_ToScalar_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_ToScalar_T")
System_Runtime_Intrinsics_Vector64_WithElement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_WithElement_T")
System_Runtime_Intrinsics_Vector64_Abs_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Abs_T")
System_Runtime_Intrinsics_Vector64_Add_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Add_T")
System_Runtime_Intrinsics_Vector64_AndNot_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AndNot_T")
System_Runtime_Intrinsics_Vector64_As_TTo = typing.TypeVar("System_Runtime_Intrinsics_Vector64_As_TTo")
System_Runtime_Intrinsics_Vector64_As_TFrom = typing.TypeVar("System_Runtime_Intrinsics_Vector64_As_TFrom")
System_Runtime_Intrinsics_Vector64_AsByte_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsByte_T")
System_Runtime_Intrinsics_Vector64_AsDouble_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsDouble_T")
System_Runtime_Intrinsics_Vector64_AsInt16_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsInt16_T")
System_Runtime_Intrinsics_Vector64_AsInt32_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsInt32_T")
System_Runtime_Intrinsics_Vector64_AsInt64_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsInt64_T")
System_Runtime_Intrinsics_Vector64_AsNInt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsNInt_T")
System_Runtime_Intrinsics_Vector64_AsNUInt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsNUInt_T")
System_Runtime_Intrinsics_Vector64_AsSByte_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsSByte_T")
System_Runtime_Intrinsics_Vector64_AsSingle_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsSingle_T")
System_Runtime_Intrinsics_Vector64_AsUInt16_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsUInt16_T")
System_Runtime_Intrinsics_Vector64_AsUInt32_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsUInt32_T")
System_Runtime_Intrinsics_Vector64_AsUInt64_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_AsUInt64_T")
System_Runtime_Intrinsics_Vector64_BitwiseAnd_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_BitwiseAnd_T")
System_Runtime_Intrinsics_Vector64_BitwiseOr_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_BitwiseOr_T")
System_Runtime_Intrinsics_Vector64_ConditionalSelect_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_ConditionalSelect_T")
System_Runtime_Intrinsics_Vector64_CopyTo_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_CopyTo_T")
System_Runtime_Intrinsics_Vector64_Equals_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Equals_T")
System_Runtime_Intrinsics_Vector64_EqualsAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_EqualsAll_T")
System_Runtime_Intrinsics_Vector64_EqualsAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_EqualsAny_T")
System_Runtime_Intrinsics_Vector64_ExtractMostSignificantBits_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_ExtractMostSignificantBits_T")
System_Runtime_Intrinsics_Vector64_GreaterThan_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_GreaterThan_T")
System_Runtime_Intrinsics_Vector64_GreaterThanAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_GreaterThanAll_T")
System_Runtime_Intrinsics_Vector64_GreaterThanAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_GreaterThanAny_T")
System_Runtime_Intrinsics_Vector64_GreaterThanOrEqual_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_GreaterThanOrEqual_T")
System_Runtime_Intrinsics_Vector64_GreaterThanOrEqualAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_GreaterThanOrEqualAll_T")
System_Runtime_Intrinsics_Vector64_GreaterThanOrEqualAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_GreaterThanOrEqualAny_T")
System_Runtime_Intrinsics_Vector64_LessThan_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_LessThan_T")
System_Runtime_Intrinsics_Vector64_LessThanAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_LessThanAll_T")
System_Runtime_Intrinsics_Vector64_LessThanAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_LessThanAny_T")
System_Runtime_Intrinsics_Vector64_LessThanOrEqual_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_LessThanOrEqual_T")
System_Runtime_Intrinsics_Vector64_LessThanOrEqualAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_LessThanOrEqualAll_T")
System_Runtime_Intrinsics_Vector64_LessThanOrEqualAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_LessThanOrEqualAny_T")
System_Runtime_Intrinsics_Vector64_Load_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Load_T")
System_Runtime_Intrinsics_Vector64_LoadAligned_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_LoadAligned_T")
System_Runtime_Intrinsics_Vector64_LoadAlignedNonTemporal_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_LoadAlignedNonTemporal_T")
System_Runtime_Intrinsics_Vector64_Max_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Max_T")
System_Runtime_Intrinsics_Vector64_Min_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Min_T")
System_Runtime_Intrinsics_Vector64_Negate_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Negate_T")
System_Runtime_Intrinsics_Vector64_OnesComplement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_OnesComplement_T")
System_Runtime_Intrinsics_Vector64_Sqrt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Sqrt_T")
System_Runtime_Intrinsics_Vector64_Store_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Store_T")
System_Runtime_Intrinsics_Vector64_StoreAligned_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_StoreAligned_T")
System_Runtime_Intrinsics_Vector64_StoreAlignedNonTemporal_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_StoreAlignedNonTemporal_T")
System_Runtime_Intrinsics_Vector64_Subtract_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Subtract_T")
System_Runtime_Intrinsics_Vector64_ToVector128_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_ToVector128_T")
System_Runtime_Intrinsics_Vector64_ToVector128Unsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_ToVector128Unsafe_T")
System_Runtime_Intrinsics_Vector64_TryCopyTo_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_TryCopyTo_T")
System_Runtime_Intrinsics_Vector64_Xor_T = typing.TypeVar("System_Runtime_Intrinsics_Vector64_Xor_T")
System_Runtime_Intrinsics_Vector128_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_T")
System_Runtime_Intrinsics_Vector128_Create_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Create_T")
System_Runtime_Intrinsics_Vector128_CreateScalar_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_CreateScalar_T")
System_Runtime_Intrinsics_Vector128_CreateScalarUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_CreateScalarUnsafe_T")
System_Runtime_Intrinsics_Vector128_Divide_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Divide_T")
System_Runtime_Intrinsics_Vector128_Dot_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Dot_T")
System_Runtime_Intrinsics_Vector128_GetElement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_GetElement_T")
System_Runtime_Intrinsics_Vector128_LoadUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_LoadUnsafe_T")
System_Runtime_Intrinsics_Vector128_Multiply_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Multiply_T")
System_Runtime_Intrinsics_Vector128_StoreUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_StoreUnsafe_T")
System_Runtime_Intrinsics_Vector128_Sum_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Sum_T")
System_Runtime_Intrinsics_Vector128_ToScalar_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_ToScalar_T")
System_Runtime_Intrinsics_Vector128_WithElement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_WithElement_T")
System_Runtime_Intrinsics_Vector128_Abs_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Abs_T")
System_Runtime_Intrinsics_Vector128_Add_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Add_T")
System_Runtime_Intrinsics_Vector128_AndNot_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AndNot_T")
System_Runtime_Intrinsics_Vector128_As_TTo = typing.TypeVar("System_Runtime_Intrinsics_Vector128_As_TTo")
System_Runtime_Intrinsics_Vector128_As_TFrom = typing.TypeVar("System_Runtime_Intrinsics_Vector128_As_TFrom")
System_Runtime_Intrinsics_Vector128_AsByte_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsByte_T")
System_Runtime_Intrinsics_Vector128_AsDouble_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsDouble_T")
System_Runtime_Intrinsics_Vector128_AsInt16_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsInt16_T")
System_Runtime_Intrinsics_Vector128_AsInt32_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsInt32_T")
System_Runtime_Intrinsics_Vector128_AsInt64_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsInt64_T")
System_Runtime_Intrinsics_Vector128_AsNInt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsNInt_T")
System_Runtime_Intrinsics_Vector128_AsNUInt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsNUInt_T")
System_Runtime_Intrinsics_Vector128_AsSByte_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsSByte_T")
System_Runtime_Intrinsics_Vector128_AsSingle_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsSingle_T")
System_Runtime_Intrinsics_Vector128_AsUInt16_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsUInt16_T")
System_Runtime_Intrinsics_Vector128_AsUInt32_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsUInt32_T")
System_Runtime_Intrinsics_Vector128_AsUInt64_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsUInt64_T")
System_Runtime_Intrinsics_Vector128_AsVector128_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsVector128_T")
System_Runtime_Intrinsics_Vector128_AsVector_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_AsVector_T")
System_Runtime_Intrinsics_Vector128_BitwiseAnd_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_BitwiseAnd_T")
System_Runtime_Intrinsics_Vector128_BitwiseOr_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_BitwiseOr_T")
System_Runtime_Intrinsics_Vector128_ConditionalSelect_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_ConditionalSelect_T")
System_Runtime_Intrinsics_Vector128_CopyTo_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_CopyTo_T")
System_Runtime_Intrinsics_Vector128_Equals_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Equals_T")
System_Runtime_Intrinsics_Vector128_EqualsAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_EqualsAll_T")
System_Runtime_Intrinsics_Vector128_EqualsAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_EqualsAny_T")
System_Runtime_Intrinsics_Vector128_ExtractMostSignificantBits_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_ExtractMostSignificantBits_T")
System_Runtime_Intrinsics_Vector128_GetLower_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_GetLower_T")
System_Runtime_Intrinsics_Vector128_GetUpper_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_GetUpper_T")
System_Runtime_Intrinsics_Vector128_GreaterThan_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_GreaterThan_T")
System_Runtime_Intrinsics_Vector128_GreaterThanAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_GreaterThanAll_T")
System_Runtime_Intrinsics_Vector128_GreaterThanAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_GreaterThanAny_T")
System_Runtime_Intrinsics_Vector128_GreaterThanOrEqual_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_GreaterThanOrEqual_T")
System_Runtime_Intrinsics_Vector128_GreaterThanOrEqualAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_GreaterThanOrEqualAll_T")
System_Runtime_Intrinsics_Vector128_GreaterThanOrEqualAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_GreaterThanOrEqualAny_T")
System_Runtime_Intrinsics_Vector128_LessThan_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_LessThan_T")
System_Runtime_Intrinsics_Vector128_LessThanAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_LessThanAll_T")
System_Runtime_Intrinsics_Vector128_LessThanAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_LessThanAny_T")
System_Runtime_Intrinsics_Vector128_LessThanOrEqual_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_LessThanOrEqual_T")
System_Runtime_Intrinsics_Vector128_LessThanOrEqualAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_LessThanOrEqualAll_T")
System_Runtime_Intrinsics_Vector128_LessThanOrEqualAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_LessThanOrEqualAny_T")
System_Runtime_Intrinsics_Vector128_Load_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Load_T")
System_Runtime_Intrinsics_Vector128_LoadAligned_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_LoadAligned_T")
System_Runtime_Intrinsics_Vector128_LoadAlignedNonTemporal_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_LoadAlignedNonTemporal_T")
System_Runtime_Intrinsics_Vector128_Max_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Max_T")
System_Runtime_Intrinsics_Vector128_Min_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Min_T")
System_Runtime_Intrinsics_Vector128_Negate_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Negate_T")
System_Runtime_Intrinsics_Vector128_OnesComplement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_OnesComplement_T")
System_Runtime_Intrinsics_Vector128_Sqrt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Sqrt_T")
System_Runtime_Intrinsics_Vector128_Store_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Store_T")
System_Runtime_Intrinsics_Vector128_StoreAligned_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_StoreAligned_T")
System_Runtime_Intrinsics_Vector128_StoreAlignedNonTemporal_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_StoreAlignedNonTemporal_T")
System_Runtime_Intrinsics_Vector128_Subtract_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Subtract_T")
System_Runtime_Intrinsics_Vector128_ToVector256_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_ToVector256_T")
System_Runtime_Intrinsics_Vector128_ToVector256Unsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_ToVector256Unsafe_T")
System_Runtime_Intrinsics_Vector128_TryCopyTo_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_TryCopyTo_T")
System_Runtime_Intrinsics_Vector128_WithLower_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_WithLower_T")
System_Runtime_Intrinsics_Vector128_WithUpper_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_WithUpper_T")
System_Runtime_Intrinsics_Vector128_Xor_T = typing.TypeVar("System_Runtime_Intrinsics_Vector128_Xor_T")
System_Runtime_Intrinsics_Vector256_Create_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Create_T")
System_Runtime_Intrinsics_Vector256_CreateScalar_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_CreateScalar_T")
System_Runtime_Intrinsics_Vector256_CreateScalarUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_CreateScalarUnsafe_T")
System_Runtime_Intrinsics_Vector256_Divide_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Divide_T")
System_Runtime_Intrinsics_Vector256_Dot_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Dot_T")
System_Runtime_Intrinsics_Vector256_GetElement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_GetElement_T")
System_Runtime_Intrinsics_Vector256_LoadUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_LoadUnsafe_T")
System_Runtime_Intrinsics_Vector256_Multiply_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Multiply_T")
System_Runtime_Intrinsics_Vector256_StoreUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_StoreUnsafe_T")
System_Runtime_Intrinsics_Vector256_Sum_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Sum_T")
System_Runtime_Intrinsics_Vector256_ToScalar_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_ToScalar_T")
System_Runtime_Intrinsics_Vector256_WithElement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_WithElement_T")
System_Runtime_Intrinsics_Vector256_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_T")
System_Runtime_Intrinsics_Vector256_Abs_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Abs_T")
System_Runtime_Intrinsics_Vector256_Add_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Add_T")
System_Runtime_Intrinsics_Vector256_AndNot_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AndNot_T")
System_Runtime_Intrinsics_Vector256_As_TTo = typing.TypeVar("System_Runtime_Intrinsics_Vector256_As_TTo")
System_Runtime_Intrinsics_Vector256_As_TFrom = typing.TypeVar("System_Runtime_Intrinsics_Vector256_As_TFrom")
System_Runtime_Intrinsics_Vector256_AsByte_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsByte_T")
System_Runtime_Intrinsics_Vector256_AsDouble_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsDouble_T")
System_Runtime_Intrinsics_Vector256_AsInt16_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsInt16_T")
System_Runtime_Intrinsics_Vector256_AsInt32_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsInt32_T")
System_Runtime_Intrinsics_Vector256_AsInt64_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsInt64_T")
System_Runtime_Intrinsics_Vector256_AsNInt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsNInt_T")
System_Runtime_Intrinsics_Vector256_AsNUInt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsNUInt_T")
System_Runtime_Intrinsics_Vector256_AsSByte_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsSByte_T")
System_Runtime_Intrinsics_Vector256_AsSingle_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsSingle_T")
System_Runtime_Intrinsics_Vector256_AsUInt16_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsUInt16_T")
System_Runtime_Intrinsics_Vector256_AsUInt32_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsUInt32_T")
System_Runtime_Intrinsics_Vector256_AsUInt64_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsUInt64_T")
System_Runtime_Intrinsics_Vector256_AsVector256_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsVector256_T")
System_Runtime_Intrinsics_Vector256_AsVector_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_AsVector_T")
System_Runtime_Intrinsics_Vector256_BitwiseAnd_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_BitwiseAnd_T")
System_Runtime_Intrinsics_Vector256_BitwiseOr_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_BitwiseOr_T")
System_Runtime_Intrinsics_Vector256_ConditionalSelect_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_ConditionalSelect_T")
System_Runtime_Intrinsics_Vector256_CopyTo_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_CopyTo_T")
System_Runtime_Intrinsics_Vector256_Equals_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Equals_T")
System_Runtime_Intrinsics_Vector256_EqualsAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_EqualsAll_T")
System_Runtime_Intrinsics_Vector256_EqualsAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_EqualsAny_T")
System_Runtime_Intrinsics_Vector256_ExtractMostSignificantBits_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_ExtractMostSignificantBits_T")
System_Runtime_Intrinsics_Vector256_GetLower_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_GetLower_T")
System_Runtime_Intrinsics_Vector256_GetUpper_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_GetUpper_T")
System_Runtime_Intrinsics_Vector256_GreaterThan_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_GreaterThan_T")
System_Runtime_Intrinsics_Vector256_GreaterThanAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_GreaterThanAll_T")
System_Runtime_Intrinsics_Vector256_GreaterThanAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_GreaterThanAny_T")
System_Runtime_Intrinsics_Vector256_GreaterThanOrEqual_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_GreaterThanOrEqual_T")
System_Runtime_Intrinsics_Vector256_GreaterThanOrEqualAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_GreaterThanOrEqualAll_T")
System_Runtime_Intrinsics_Vector256_GreaterThanOrEqualAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_GreaterThanOrEqualAny_T")
System_Runtime_Intrinsics_Vector256_LessThan_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_LessThan_T")
System_Runtime_Intrinsics_Vector256_LessThanAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_LessThanAll_T")
System_Runtime_Intrinsics_Vector256_LessThanAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_LessThanAny_T")
System_Runtime_Intrinsics_Vector256_LessThanOrEqual_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_LessThanOrEqual_T")
System_Runtime_Intrinsics_Vector256_LessThanOrEqualAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_LessThanOrEqualAll_T")
System_Runtime_Intrinsics_Vector256_LessThanOrEqualAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_LessThanOrEqualAny_T")
System_Runtime_Intrinsics_Vector256_Load_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Load_T")
System_Runtime_Intrinsics_Vector256_LoadAligned_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_LoadAligned_T")
System_Runtime_Intrinsics_Vector256_LoadAlignedNonTemporal_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_LoadAlignedNonTemporal_T")
System_Runtime_Intrinsics_Vector256_Max_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Max_T")
System_Runtime_Intrinsics_Vector256_Min_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Min_T")
System_Runtime_Intrinsics_Vector256_Negate_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Negate_T")
System_Runtime_Intrinsics_Vector256_OnesComplement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_OnesComplement_T")
System_Runtime_Intrinsics_Vector256_Sqrt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Sqrt_T")
System_Runtime_Intrinsics_Vector256_Store_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Store_T")
System_Runtime_Intrinsics_Vector256_StoreAligned_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_StoreAligned_T")
System_Runtime_Intrinsics_Vector256_StoreAlignedNonTemporal_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_StoreAlignedNonTemporal_T")
System_Runtime_Intrinsics_Vector256_Subtract_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Subtract_T")
System_Runtime_Intrinsics_Vector256_ToVector512_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_ToVector512_T")
System_Runtime_Intrinsics_Vector256_ToVector512Unsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_ToVector512Unsafe_T")
System_Runtime_Intrinsics_Vector256_TryCopyTo_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_TryCopyTo_T")
System_Runtime_Intrinsics_Vector256_WithLower_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_WithLower_T")
System_Runtime_Intrinsics_Vector256_WithUpper_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_WithUpper_T")
System_Runtime_Intrinsics_Vector256_Xor_T = typing.TypeVar("System_Runtime_Intrinsics_Vector256_Xor_T")
System_Runtime_Intrinsics_Vector512_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_T")
System_Runtime_Intrinsics_Vector512_Create_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Create_T")
System_Runtime_Intrinsics_Vector512_CreateScalar_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_CreateScalar_T")
System_Runtime_Intrinsics_Vector512_CreateScalarUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_CreateScalarUnsafe_T")
System_Runtime_Intrinsics_Vector512_Divide_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Divide_T")
System_Runtime_Intrinsics_Vector512_Dot_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Dot_T")
System_Runtime_Intrinsics_Vector512_GetElement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_GetElement_T")
System_Runtime_Intrinsics_Vector512_LoadUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_LoadUnsafe_T")
System_Runtime_Intrinsics_Vector512_Multiply_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Multiply_T")
System_Runtime_Intrinsics_Vector512_StoreUnsafe_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_StoreUnsafe_T")
System_Runtime_Intrinsics_Vector512_Sum_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Sum_T")
System_Runtime_Intrinsics_Vector512_ToScalar_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_ToScalar_T")
System_Runtime_Intrinsics_Vector512_WithElement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_WithElement_T")
System_Runtime_Intrinsics_Vector512_Abs_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Abs_T")
System_Runtime_Intrinsics_Vector512_Add_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Add_T")
System_Runtime_Intrinsics_Vector512_AndNot_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AndNot_T")
System_Runtime_Intrinsics_Vector512_As_TTo = typing.TypeVar("System_Runtime_Intrinsics_Vector512_As_TTo")
System_Runtime_Intrinsics_Vector512_As_TFrom = typing.TypeVar("System_Runtime_Intrinsics_Vector512_As_TFrom")
System_Runtime_Intrinsics_Vector512_AsByte_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsByte_T")
System_Runtime_Intrinsics_Vector512_AsDouble_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsDouble_T")
System_Runtime_Intrinsics_Vector512_AsInt16_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsInt16_T")
System_Runtime_Intrinsics_Vector512_AsInt32_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsInt32_T")
System_Runtime_Intrinsics_Vector512_AsInt64_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsInt64_T")
System_Runtime_Intrinsics_Vector512_AsNInt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsNInt_T")
System_Runtime_Intrinsics_Vector512_AsNUInt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsNUInt_T")
System_Runtime_Intrinsics_Vector512_AsSByte_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsSByte_T")
System_Runtime_Intrinsics_Vector512_AsSingle_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsSingle_T")
System_Runtime_Intrinsics_Vector512_AsUInt16_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsUInt16_T")
System_Runtime_Intrinsics_Vector512_AsUInt32_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsUInt32_T")
System_Runtime_Intrinsics_Vector512_AsUInt64_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsUInt64_T")
System_Runtime_Intrinsics_Vector512_AsVector512_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsVector512_T")
System_Runtime_Intrinsics_Vector512_AsVector_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_AsVector_T")
System_Runtime_Intrinsics_Vector512_BitwiseAnd_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_BitwiseAnd_T")
System_Runtime_Intrinsics_Vector512_BitwiseOr_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_BitwiseOr_T")
System_Runtime_Intrinsics_Vector512_ConditionalSelect_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_ConditionalSelect_T")
System_Runtime_Intrinsics_Vector512_CopyTo_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_CopyTo_T")
System_Runtime_Intrinsics_Vector512_Equals_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Equals_T")
System_Runtime_Intrinsics_Vector512_EqualsAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_EqualsAll_T")
System_Runtime_Intrinsics_Vector512_EqualsAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_EqualsAny_T")
System_Runtime_Intrinsics_Vector512_ExtractMostSignificantBits_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_ExtractMostSignificantBits_T")
System_Runtime_Intrinsics_Vector512_GetLower_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_GetLower_T")
System_Runtime_Intrinsics_Vector512_GetUpper_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_GetUpper_T")
System_Runtime_Intrinsics_Vector512_GreaterThan_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_GreaterThan_T")
System_Runtime_Intrinsics_Vector512_GreaterThanAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_GreaterThanAll_T")
System_Runtime_Intrinsics_Vector512_GreaterThanAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_GreaterThanAny_T")
System_Runtime_Intrinsics_Vector512_GreaterThanOrEqual_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_GreaterThanOrEqual_T")
System_Runtime_Intrinsics_Vector512_GreaterThanOrEqualAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_GreaterThanOrEqualAll_T")
System_Runtime_Intrinsics_Vector512_GreaterThanOrEqualAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_GreaterThanOrEqualAny_T")
System_Runtime_Intrinsics_Vector512_LessThan_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_LessThan_T")
System_Runtime_Intrinsics_Vector512_LessThanAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_LessThanAll_T")
System_Runtime_Intrinsics_Vector512_LessThanAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_LessThanAny_T")
System_Runtime_Intrinsics_Vector512_LessThanOrEqual_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_LessThanOrEqual_T")
System_Runtime_Intrinsics_Vector512_LessThanOrEqualAll_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_LessThanOrEqualAll_T")
System_Runtime_Intrinsics_Vector512_LessThanOrEqualAny_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_LessThanOrEqualAny_T")
System_Runtime_Intrinsics_Vector512_Load_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Load_T")
System_Runtime_Intrinsics_Vector512_LoadAligned_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_LoadAligned_T")
System_Runtime_Intrinsics_Vector512_LoadAlignedNonTemporal_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_LoadAlignedNonTemporal_T")
System_Runtime_Intrinsics_Vector512_Max_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Max_T")
System_Runtime_Intrinsics_Vector512_Min_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Min_T")
System_Runtime_Intrinsics_Vector512_Negate_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Negate_T")
System_Runtime_Intrinsics_Vector512_OnesComplement_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_OnesComplement_T")
System_Runtime_Intrinsics_Vector512_Sqrt_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Sqrt_T")
System_Runtime_Intrinsics_Vector512_Store_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Store_T")
System_Runtime_Intrinsics_Vector512_StoreAligned_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_StoreAligned_T")
System_Runtime_Intrinsics_Vector512_StoreAlignedNonTemporal_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_StoreAlignedNonTemporal_T")
System_Runtime_Intrinsics_Vector512_Subtract_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Subtract_T")
System_Runtime_Intrinsics_Vector512_TryCopyTo_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_TryCopyTo_T")
System_Runtime_Intrinsics_Vector512_WithLower_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_WithLower_T")
System_Runtime_Intrinsics_Vector512_WithUpper_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_WithUpper_T")
System_Runtime_Intrinsics_Vector512_Xor_T = typing.TypeVar("System_Runtime_Intrinsics_Vector512_Xor_T")


class Vector512(typing.Generic[System_Runtime_Intrinsics_Vector512_T], System.IEquatable[System_Runtime_Intrinsics_Vector512]):
    """This class has no documentation."""

    @property
    def _lower(self) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector512_T]:
        ...

    @property
    def _upper(self) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector512_T]:
        ...

    AllBitsSet: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_T]
    """Gets a new Vector512{T} with all bits set to 1."""

    Count: int
    """Gets the number of T that are in a Vector512{T}."""

    IsSupported: bool
    """Gets true if T is supported; otherwise, false."""

    One: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_T]
    """Gets a new Vector512{T} with all elements initialized to one."""

    Zero: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_T]
    """Gets a new Vector512{T} with all elements initialized to zero."""

    @property
    def DisplayString(self) -> str:
        ...

    Size: int = 64

    Alignment: int = 64

    IsHardwareAccelerated: bool

    def __getitem__(self, index: int) -> System_Runtime_Intrinsics_Vector512_T:
        """
        Gets the element at the specified index.
        
        :param index: The index of the element to get.
        :returns: The value of the element at .
        """
        ...

    @staticmethod
    def Abs(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Abs_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Abs_T]:
        """
        Computes the absolute value of each element in a vector.
        
        :param vector: The vector that will have its absolute value computed.
        :returns: A vector whose elements are the absolute value of the elements in .
        """
        ...

    @staticmethod
    def Add(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Add_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Add_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Add_T]:
        """
        Adds two vectors to compute their sum.
        
        :param left: The vector to add with .
        :param right: The vector to add with .
        :returns: The sum of  and .
        """
        ...

    @staticmethod
    def AndNot(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AndNot_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AndNot_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AndNot_T]:
        """
        Computes the bitwise-and of a given vector and the ones complement of another vector.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to that is ones-complemented before being bitwise-and with .
        :returns: The bitwise-and of  and the ones-complement of .
        """
        ...

    @staticmethod
    def As(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_As_TFrom]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_As_TTo]:
        """
        Reinterprets a Vector512{TFrom} as a new Vector512{TTo}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{TTo}.
        """
        ...

    @staticmethod
    def AsByte(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsByte_T]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Reinterprets a Vector512{T} as a new Vector512{Byte}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{Byte}.
        """
        ...

    @staticmethod
    def AsDouble(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsDouble_T]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Reinterprets a Vector512{T} as a new Vector512{Double}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{Double}.
        """
        ...

    @staticmethod
    def AsInt16(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsInt16_T]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Reinterprets a Vector512{T} as a new Vector512{Int16}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{Int16}.
        """
        ...

    @staticmethod
    def AsInt32(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsInt32_T]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Reinterprets a Vector512{T} as a new Vector512{Int32}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{Int32}.
        """
        ...

    @staticmethod
    def AsInt64(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsInt64_T]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Reinterprets a Vector512{T} as a new Vector512{Int64}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{Int64}.
        """
        ...

    @staticmethod
    def AsNInt(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsNInt_T]) -> System.Runtime.Intrinsics.Vector512[System.IntPtr]:
        """
        Reinterprets a Vector512{T} as a new Vector512{IntPtr}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{IntPtr}.
        """
        ...

    @staticmethod
    def AsNUInt(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsNUInt_T]) -> System.Runtime.Intrinsics.Vector512[System.UIntPtr]:
        """
        Reinterprets a Vector512{T} as a new Vector512{UIntPtr}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{UIntPtr}.
        """
        ...

    @staticmethod
    def AsSByte(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsSByte_T]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Reinterprets a Vector512{T} as a new Vector512{SByte}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{SByte}.
        """
        ...

    @staticmethod
    def AsSingle(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsSingle_T]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Reinterprets a Vector512{T} as a new Vector512{Single}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{Single}.
        """
        ...

    @staticmethod
    def AsUInt16(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsUInt16_T]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Reinterprets a Vector512{T} as a new Vector512{UInt16}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{UInt16}.
        """
        ...

    @staticmethod
    def AsUInt32(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsUInt32_T]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Reinterprets a Vector512{T} as a new Vector512{UInt32}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{UInt32}.
        """
        ...

    @staticmethod
    def AsUInt64(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsUInt64_T]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Reinterprets a Vector512{T} as a new Vector512{UInt64}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{UInt64}.
        """
        ...

    @staticmethod
    def AsVector(value: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsVector_T]) -> System.Numerics.Vector[System_Runtime_Intrinsics_Vector512_AsVector_T]:
        """
        Reinterprets a Vector512{T} as a new Vector{T}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{T}.
        """
        ...

    @staticmethod
    def AsVector512(value: System.Numerics.Vector[System_Runtime_Intrinsics_Vector512_AsVector512_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_AsVector512_T]:
        """
        Reinterprets a Vector{T} as a new Vector512{T}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector512{T}.
        """
        ...

    @staticmethod
    def BitwiseAnd(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_BitwiseAnd_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_BitwiseAnd_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_BitwiseAnd_T]:
        """
        Computes the bitwise-and of two vectors.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to bitwise-and with .
        :returns: The bitwise-and of  and .
        """
        ...

    @staticmethod
    def BitwiseOr(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_BitwiseOr_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_BitwiseOr_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_BitwiseOr_T]:
        """
        Computes the bitwise-or of two vectors.
        
        :param left: The vector to bitwise-or with .
        :param right: The vector to bitwise-or with .
        :returns: The bitwise-or of  and .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(vector: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param vector: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(vector: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param vector: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    def ConditionalSelect(condition: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_ConditionalSelect_T], left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_ConditionalSelect_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_ConditionalSelect_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_ConditionalSelect_T]:
        """
        Conditionally selects a value from two vectors on a bitwise basis.
        
        :param condition: The mask that is used to select a value from  or .
        :param left: The vector that is selected when the corresponding bit in  is one.
        :param right: The vector that is selected when the corresponding bit in  is zero.
        :returns: A vector whose bits come from  or  based on the value of .
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(vector: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Converts a Vector512{Int64} to a Vector512{Double}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(vector: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Converts a Vector512{UInt64} to a Vector512{Double}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt32(vector: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Converts a Vector512{Single} to a Vector512{Int32}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt64(vector: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Converts a Vector512{Double} to a Vector512{Int64}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(vector: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Converts a Vector512{Int32} to a Vector512{Single}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(vector: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Converts a Vector512{UInt32} to a Vector512{Single}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt32(vector: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Converts a Vector512{Single} to a Vector512{UInt32}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt64(vector: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Converts a Vector512{Double} to a Vector512{UInt64}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_CopyTo_T], destination: typing.List[System_Runtime_Intrinsics_Vector512_CopyTo_T]) -> None:
        """
        Copies a Vector512{T} to a given array.
        
        :param vector: The vector to be copied.
        :param destination: The array to which  is copied.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_CopyTo_T], destination: typing.List[System_Runtime_Intrinsics_Vector512_CopyTo_T], startIndex: int) -> None:
        """
        Copies a Vector512{T} to a given array starting at the specified index.
        
        :param vector: The vector to be copied.
        :param destination: The array to which  is copied.
        :param startIndex: The starting index of  which  will be copied to.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_CopyTo_T], destination: System.Span[System_Runtime_Intrinsics_Vector512_CopyTo_T]) -> None:
        """
        Copies a Vector512{T} to a given span.
        
        :param vector: The vector to be copied.
        :param destination: The span to which the  is copied.
        """
        ...

    @staticmethod
    @overload
    def Create(value: System_Runtime_Intrinsics_Vector512_Create_T) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Create_T]:
        """
        Creates a new Vector512{T} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{T} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Byte} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{Byte} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: float) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Double} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{Double} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int16} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{Int16} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int32} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{Int32} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int64} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{Int64} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector512[System.IntPtr]:
        """
        Creates a new Vector512{IntPtr} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{IntPtr} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector512[System.UIntPtr]:
        """
        Creates a new Vector512{UIntPtr} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{UIntPtr} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{SByte} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{SByte} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: float) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Single} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{Single} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt16} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{UInt16} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt32} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{UInt32} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt64} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector512{UInt64} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(values: typing.List[System_Runtime_Intrinsics_Vector512_Create_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Create_T]:
        """
        Creates a new Vector512{T} from a given array.
        
        :param values: The array from which the vector is created.
        :returns: A new Vector512{T} with its elements set to the first Vector512{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(values: typing.List[System_Runtime_Intrinsics_Vector512_Create_T], index: int) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Create_T]:
        """
        Creates a new Vector512{T} from a given array.
        
        :param values: The array from which the vector is created.
        :param index: The index in  at which to being reading elements.
        :returns: A new Vector512{T} with its elements set to the first Vector256{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(values: System.ReadOnlySpan[System_Runtime_Intrinsics_Vector512_Create_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Create_T]:
        """
        Creates a new Vector512{T} from a given readonly span.
        
        :param values: The readonly span from which the vector is created.
        :returns: A new Vector512{T} with its elements set to the first Vector512{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int, e16: int, e17: int, e18: int, e19: int, e20: int, e21: int, e22: int, e23: int, e24: int, e25: int, e26: int, e27: int, e28: int, e29: int, e30: int, e31: int, e32: int, e33: int, e34: int, e35: int, e36: int, e37: int, e38: int, e39: int, e40: int, e41: int, e42: int, e43: int, e44: int, e45: int, e46: int, e47: int, e48: int, e49: int, e50: int, e51: int, e52: int, e53: int, e54: int, e55: int, e56: int, e57: int, e58: int, e59: int, e60: int, e61: int, e62: int, e63: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Byte} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :param e16: The value that element 16 will be initialized to.
        :param e17: The value that element 17 will be initialized to.
        :param e18: The value that element 18 will be initialized to.
        :param e19: The value that element 19 will be initialized to.
        :param e20: The value that element 20 will be initialized to.
        :param e21: The value that element 21 will be initialized to.
        :param e22: The value that element 22 will be initialized to.
        :param e23: The value that element 23 will be initialized to.
        :param e24: The value that element 24 will be initialized to.
        :param e25: The value that element 25 will be initialized to.
        :param e26: The value that element 26 will be initialized to.
        :param e27: The value that element 27 will be initialized to.
        :param e28: The value that element 28 will be initialized to.
        :param e29: The value that element 29 will be initialized to.
        :param e30: The value that element 30 will be initialized to.
        :param e31: The value that element 31 will be initialized to.
        :param e32: The value that element 32 will be initialized to.
        :param e33: The value that element 33 will be initialized to.
        :param e34: The value that element 34 will be initialized to.
        :param e35: The value that element 35 will be initialized to.
        :param e36: The value that element 36 will be initialized to.
        :param e37: The value that element 37 will be initialized to.
        :param e38: The value that element 38 will be initialized to.
        :param e39: The value that element 39 will be initialized to.
        :param e40: The value that element 40 will be initialized to.
        :param e41: The value that element 41 will be initialized to.
        :param e42: The value that element 42 will be initialized to.
        :param e43: The value that element 43 will be initialized to.
        :param e44: The value that element 44 will be initialized to.
        :param e45: The value that element 45 will be initialized to.
        :param e46: The value that element 46 will be initialized to.
        :param e47: The value that element 47 will be initialized to.
        :param e48: The value that element 48 will be initialized to.
        :param e49: The value that element 49 will be initialized to.
        :param e50: The value that element 50 will be initialized to.
        :param e51: The value that element 51 will be initialized to.
        :param e52: The value that element 52 will be initialized to.
        :param e53: The value that element 53 will be initialized to.
        :param e54: The value that element 54 will be initialized to.
        :param e55: The value that element 55 will be initialized to.
        :param e56: The value that element 56 will be initialized to.
        :param e57: The value that element 57 will be initialized to.
        :param e58: The value that element 58 will be initialized to.
        :param e59: The value that element 59 will be initialized to.
        :param e60: The value that element 60 will be initialized to.
        :param e61: The value that element 61 will be initialized to.
        :param e62: The value that element 62 will be initialized to.
        :param e63: The value that element 63 will be initialized to.
        :returns: A new Vector512{Byte} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: float, e1: float, e2: float, e3: float, e4: float, e5: float, e6: float, e7: float) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Double} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector512{Double} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int, e16: int, e17: int, e18: int, e19: int, e20: int, e21: int, e22: int, e23: int, e24: int, e25: int, e26: int, e27: int, e28: int, e29: int, e30: int, e31: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int16} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :param e16: The value that element 16 will be initialized to.
        :param e17: The value that element 17 will be initialized to.
        :param e18: The value that element 18 will be initialized to.
        :param e19: The value that element 19 will be initialized to.
        :param e20: The value that element 20 will be initialized to.
        :param e21: The value that element 21 will be initialized to.
        :param e22: The value that element 22 will be initialized to.
        :param e23: The value that element 23 will be initialized to.
        :param e24: The value that element 24 will be initialized to.
        :param e25: The value that element 25 will be initialized to.
        :param e26: The value that element 26 will be initialized to.
        :param e27: The value that element 27 will be initialized to.
        :param e28: The value that element 28 will be initialized to.
        :param e29: The value that element 29 will be initialized to.
        :param e30: The value that element 30 will be initialized to.
        :param e31: The value that element 31 will be initialized to.
        :returns: A new Vector512{Int16} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int32} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :returns: A new Vector512{Int32} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int64} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector512{Int64} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int, e16: int, e17: int, e18: int, e19: int, e20: int, e21: int, e22: int, e23: int, e24: int, e25: int, e26: int, e27: int, e28: int, e29: int, e30: int, e31: int, e32: int, e33: int, e34: int, e35: int, e36: int, e37: int, e38: int, e39: int, e40: int, e41: int, e42: int, e43: int, e44: int, e45: int, e46: int, e47: int, e48: int, e49: int, e50: int, e51: int, e52: int, e53: int, e54: int, e55: int, e56: int, e57: int, e58: int, e59: int, e60: int, e61: int, e62: int, e63: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{SByte} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :param e16: The value that element 16 will be initialized to.
        :param e17: The value that element 17 will be initialized to.
        :param e18: The value that element 18 will be initialized to.
        :param e19: The value that element 19 will be initialized to.
        :param e20: The value that element 20 will be initialized to.
        :param e21: The value that element 21 will be initialized to.
        :param e22: The value that element 22 will be initialized to.
        :param e23: The value that element 23 will be initialized to.
        :param e24: The value that element 24 will be initialized to.
        :param e25: The value that element 25 will be initialized to.
        :param e26: The value that element 26 will be initialized to.
        :param e27: The value that element 27 will be initialized to.
        :param e28: The value that element 28 will be initialized to.
        :param e29: The value that element 29 will be initialized to.
        :param e30: The value that element 30 will be initialized to.
        :param e31: The value that element 31 will be initialized to.
        :param e32: The value that element 32 will be initialized to.
        :param e33: The value that element 33 will be initialized to.
        :param e34: The value that element 34 will be initialized to.
        :param e35: The value that element 35 will be initialized to.
        :param e36: The value that element 36 will be initialized to.
        :param e37: The value that element 37 will be initialized to.
        :param e38: The value that element 38 will be initialized to.
        :param e39: The value that element 39 will be initialized to.
        :param e40: The value that element 40 will be initialized to.
        :param e41: The value that element 41 will be initialized to.
        :param e42: The value that element 42 will be initialized to.
        :param e43: The value that element 43 will be initialized to.
        :param e44: The value that element 44 will be initialized to.
        :param e45: The value that element 45 will be initialized to.
        :param e46: The value that element 46 will be initialized to.
        :param e47: The value that element 47 will be initialized to.
        :param e48: The value that element 48 will be initialized to.
        :param e49: The value that element 49 will be initialized to.
        :param e50: The value that element 50 will be initialized to.
        :param e51: The value that element 51 will be initialized to.
        :param e52: The value that element 52 will be initialized to.
        :param e53: The value that element 53 will be initialized to.
        :param e54: The value that element 54 will be initialized to.
        :param e55: The value that element 55 will be initialized to.
        :param e56: The value that element 56 will be initialized to.
        :param e57: The value that element 57 will be initialized to.
        :param e58: The value that element 58 will be initialized to.
        :param e59: The value that element 59 will be initialized to.
        :param e60: The value that element 60 will be initialized to.
        :param e61: The value that element 61 will be initialized to.
        :param e62: The value that element 62 will be initialized to.
        :param e63: The value that element 63 will be initialized to.
        :returns: A new Vector512{SByte} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: float, e1: float, e2: float, e3: float, e4: float, e5: float, e6: float, e7: float, e8: float, e9: float, e10: float, e11: float, e12: float, e13: float, e14: float, e15: float) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Single} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :returns: A new Vector512{Single} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int, e16: int, e17: int, e18: int, e19: int, e20: int, e21: int, e22: int, e23: int, e24: int, e25: int, e26: int, e27: int, e28: int, e29: int, e30: int, e31: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt16} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :param e16: The value that element 16 will be initialized to.
        :param e17: The value that element 17 will be initialized to.
        :param e18: The value that element 18 will be initialized to.
        :param e19: The value that element 19 will be initialized to.
        :param e20: The value that element 20 will be initialized to.
        :param e21: The value that element 21 will be initialized to.
        :param e22: The value that element 22 will be initialized to.
        :param e23: The value that element 23 will be initialized to.
        :param e24: The value that element 24 will be initialized to.
        :param e25: The value that element 25 will be initialized to.
        :param e26: The value that element 26 will be initialized to.
        :param e27: The value that element 27 will be initialized to.
        :param e28: The value that element 28 will be initialized to.
        :param e29: The value that element 29 will be initialized to.
        :param e30: The value that element 30 will be initialized to.
        :param e31: The value that element 31 will be initialized to.
        :returns: A new Vector512{UInt16} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt32} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :returns: A new Vector512{UInt32} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt64} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector512{UInt64} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector512_Create_T], upper: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector512_Create_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Create_T]:
        """
        Creates a new Vector512{T} instance from two Vector256{T} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{T} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Byte} instance from two Vector256{Byte} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{Byte} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[float], upper: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Double} instance from two Vector256{Double} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{Double} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int16} instance from two Vector256{Int16} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{Int16} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int32} instance from two Vector256{Int32} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{Int32} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int64} instance from two Vector256{Int64} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{Int64} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[System.IntPtr], upper: System.Runtime.Intrinsics.Vector256[System.IntPtr]) -> System.Runtime.Intrinsics.Vector512[System.IntPtr]:
        """
        Creates a new Vector512{IntPtr} instance from two Vector256{IntPtr} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{IntPtr} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[System.UIntPtr], upper: System.Runtime.Intrinsics.Vector256[System.UIntPtr]) -> System.Runtime.Intrinsics.Vector512[System.UIntPtr]:
        """
        Creates a new Vector512{UIntPtr} instance from two Vector256{UIntPtr} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{UIntPtr} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{SByte} instance from two Vector256{SByte} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{SByte} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[float], upper: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Single} instance from two Vector256{Single} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{Single} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt16} instance from two Vector256{UInt16} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{UInt16} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt32} instance from two Vector256{UInt32} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{UInt32} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt64} instance from two Vector256{UInt64} instances.
        
        :param lower: The value that the lower 256-bits will be initialized to.
        :param upper: The value that the upper 256-bits will be initialized to.
        :returns: A new Vector512{UInt64} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System_Runtime_Intrinsics_Vector512_CreateScalar_T) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_CreateScalar_T]:
        """
        Creates a new Vector512{T} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{T} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Byte} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Byte} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: float) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Double} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Double} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int16} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Int16} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int32} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Int32} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int64} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Int64} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector512[System.IntPtr]:
        """
        Creates a new Vector512{IntPtr} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{IntPtr} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector512[System.UIntPtr]:
        """
        Creates a new Vector512{UIntPtr} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{UIntPtr} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{SByte} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{SByte} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: float) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Single} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Single} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt16} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{UInt16} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt32} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{UInt32} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt64} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{UInt64} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System_Runtime_Intrinsics_Vector512_CreateScalarUnsafe_T) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_CreateScalarUnsafe_T]:
        """
        Creates a new Vector512{T} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{T} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Byte} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Byte} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: float) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Double} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Double} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int16} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Int16} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int32} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Int32} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{Int64} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Int64} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector512[System.IntPtr]:
        """
        Creates a new Vector512{IntPtr} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{IntPtr} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector512[System.UIntPtr]:
        """
        Creates a new Vector512{UIntPtr} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{UIntPtr} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{SByte} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{SByte} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: float) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new Vector512{Single} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{Single} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt16} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{UInt16} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt32} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{UInt32} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new Vector512{UInt64} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector512{UInt64} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Divide_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Divide_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Divide_T]:
        """
        Divides two vectors to compute their quotient.
        
        :param left: The vector that will be divided by .
        :param right: The vector that will divide .
        :returns: The quotient of  divided by .
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Divide_T], right: System_Runtime_Intrinsics_Vector512_Divide_T) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Divide_T]:
        """
        Divides a vector by a scalar to compute the per-element quotient.
        
        :param left: The vector that will be divided by .
        :param right: The scalar that will divide .
        :returns: The quotient of  divided by .
        """
        ...

    @staticmethod
    def Dot(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Dot_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Dot_T]) -> System_Runtime_Intrinsics_Vector512_Dot_T:
        """
        Computes the dot product of two vectors.
        
        :param left: The vector that will be dotted with .
        :param right: The vector that will be dotted with .
        :returns: The dot product of  and .
        """
        ...

    @staticmethod
    def Equals(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Equals_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Equals_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Equals_T]:
        """
        Compares two vectors to determine if they are equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if the corresponding elements in  and  were equal.
        """
        ...

    @staticmethod
    def EqualsAll(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_EqualsAll_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_EqualsAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were equal to the corresponding element in .
        """
        ...

    @staticmethod
    def EqualsAny(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_EqualsAny_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_EqualsAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was equal to the corresponding element in .
        """
        ...

    @staticmethod
    def ExtractMostSignificantBits(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_ExtractMostSignificantBits_T]) -> int:
        """
        Extracts the most significant bit from each element in a vector.
        
        :param vector: The vector whose elements should have their most significant bit extracted.
        :returns: The packed most significant bits extracted from the elements in .
        """
        ...

    @staticmethod
    @overload
    def Floor(vector: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Computes the floor of each element in a vector.
        
        :param vector: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Floor(vector: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Computes the floor of each element in a vector.
        
        :param vector: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    @staticmethod
    def GetElement(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GetElement_T], index: int) -> System_Runtime_Intrinsics_Vector512_GetElement_T:
        """
        Gets the element at the specified index.
        
        :param vector: The vector to get the element from.
        :param index: The index of the element to get.
        :returns: The value of the element at .
        """
        ...

    @staticmethod
    def GetLower(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GetLower_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector512_GetLower_T]:
        """
        Gets the value of the lower 256-bits as a new Vector256{T}.
        
        :param vector: The vector to get the lower 256-bits from.
        :returns: The value of the lower 256-bits as a new Vector256{T}.
        """
        ...

    @staticmethod
    def GetUpper(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GetUpper_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector512_GetUpper_T]:
        """
        Gets the value of the upper 256-bits as a new Vector256{T}.
        
        :param vector: The vector to get the upper 256-bits from.
        :returns: The value of the upper 256-bits as a new Vector256{T}.
        """
        ...

    @staticmethod
    def GreaterThan(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThan_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThan_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThan_T]:
        """
        Compares two vectors to determine which is greater on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater.
        """
        ...

    @staticmethod
    def GreaterThanAll(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanAll_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanAny(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanAny_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanOrEqual_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanOrEqual_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanOrEqual_T]:
        """
        Compares two vectors to determine which is greater or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater or equal.
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAll(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanOrEqualAll_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAny(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanOrEqualAny_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_GreaterThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def LessThan(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThan_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThan_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThan_T]:
        """
        Compares two vectors to determine which is less on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less.
        """
        ...

    @staticmethod
    def LessThanAll(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanAll_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanAny(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanAny_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanOrEqual(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanOrEqual_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanOrEqual_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanOrEqual_T]:
        """
        Compares two vectors to determine which is less or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less or equal.
        """
        ...

    @staticmethod
    def LessThanOrEqualAll(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanOrEqualAll_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanOrEqualAny(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanOrEqualAny_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LessThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def Load(source: typing.Any) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Load_T]:
        """
        Loads a vector from the given source.
        
        :param source: The source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    def LoadAligned(source: typing.Any) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LoadAligned_T]:
        """
        Loads a vector from the given aligned source.
        
        :param source: The aligned source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    def LoadAlignedNonTemporal(source: typing.Any) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LoadAlignedNonTemporal_T]:
        """
        Loads a vector from the given aligned source.
        
        :param source: The aligned source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    @overload
    def LoadUnsafe(source: System_Runtime_Intrinsics_Vector512_LoadUnsafe_T) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LoadUnsafe_T]:
        """
        Loads a vector from the given source.
        
        :param source: The source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    @overload
    def LoadUnsafe(source: System_Runtime_Intrinsics_Vector512_LoadUnsafe_T, elementOffset: System.UIntPtr) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_LoadUnsafe_T]:
        """
        Loads a vector from the given source and element offset.
        
        :param source: The source to which  will be added before loading the vector.
        :param elementOffset: The element offset from  from which the vector will be loaded.
        :returns: The vector loaded from  plus .
        """
        ...

    @staticmethod
    def Max(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Max_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Max_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Max_T]:
        """
        Computes the maximum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the maximum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    def Min(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Min_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Min_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Min_T]:
        """
        Computes the minimum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the minimum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Multiply_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Multiply_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Multiply_T]:
        """
        Multiplies two vectors to compute their element-wise product.
        
        :param left: The vector to multiply with .
        :param right: The vector to multiply with .
        :returns: The element-wise product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Multiply_T], right: System_Runtime_Intrinsics_Vector512_Multiply_T) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The vector to multiply with .
        :param right: The scalar to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System_Runtime_Intrinsics_Vector512_Multiply_T, right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Multiply_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The scalar to multiply with .
        :param right: The vector to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector512[float], upper: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Narrows two Vector512{Double} instances into one Vector512{Single}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector512{Single} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector512[int], upper: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Narrows two Vector512{Int16} instances into one Vector512{SByte}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector512{SByte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector512[int], upper: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Narrows two Vector512{Int32} instances into one Vector512{Int16}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector512{Int16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector512[int], upper: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Narrows two Vector512{Int64} instances into one Vector512{Int32}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector512{Int32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector512[int], upper: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Narrows two Vector512{UInt16} instances into one Vector512{Byte}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector512{Byte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector512[int], upper: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Narrows two Vector512{UInt32} instances into one Vector512{UInt16}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector512{UInt16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector512[int], upper: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Narrows two Vector512{UInt64} instances into one Vector512{UInt32}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector512{UInt32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    def Negate(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Negate_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Negate_T]:
        """
        Negates a vector.
        
        :param vector: The vector to negate.
        :returns: A vector whose elements are the negation of the corresponding elements in .
        """
        ...

    @staticmethod
    def OnesComplement(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_OnesComplement_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_OnesComplement_T]:
        """
        Computes the ones-complement of a vector.
        
        :param vector: The vector whose ones-complement is to be computed.
        :returns: A vector whose elements are the ones-complement of the corresponding elements in .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[System.IntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[System.UIntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[System.UIntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector512[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[System.IntPtr]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[System.IntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[System.UIntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[System.UIntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector512[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[int], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[int], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[int], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[int], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[int], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[int], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[float], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[int], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[int], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector512[float], indices: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    def Sqrt(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Sqrt_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Sqrt_T]:
        """
        Computes the square root of a vector on a per-element basis.
        
        :param vector: The vector whose square root is to be computed.
        :returns: A vector whose elements are the square root of the corresponding elements in .
        """
        ...

    @staticmethod
    def Store(source: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Store_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination at which  will be stored.
        """
        ...

    @staticmethod
    def StoreAligned(source: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_StoreAligned_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given aligned destination.
        
        :param source: The vector that will be stored.
        :param destination: The aligned destination at which  will be stored.
        """
        ...

    @staticmethod
    def StoreAlignedNonTemporal(source: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_StoreAlignedNonTemporal_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given aligned destination.
        
        :param source: The vector that will be stored.
        :param destination: The aligned destination at which  will be stored.
        """
        ...

    @staticmethod
    @overload
    def StoreUnsafe(source: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_StoreUnsafe_T], destination: System_Runtime_Intrinsics_Vector512_StoreUnsafe_T) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination at which  will be stored.
        """
        ...

    @staticmethod
    @overload
    def StoreUnsafe(source: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_StoreUnsafe_T], destination: System_Runtime_Intrinsics_Vector512_StoreUnsafe_T, elementOffset: System.UIntPtr) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination to which  will be added before the vector will be stored.
        :param elementOffset: The element offset from  from which the vector will be stored.
        """
        ...

    @staticmethod
    def Subtract(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Subtract_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Subtract_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Subtract_T]:
        """
        Subtracts two vectors to compute their difference.
        
        :param left: The vector from which  will be subtracted.
        :param right: The vector to subtract from .
        :returns: The difference of  and .
        """
        ...

    @staticmethod
    def Sum(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Sum_T]) -> System_Runtime_Intrinsics_Vector512_Sum_T:
        """
        Computes the sum of all elements in a vector.
        
        :param vector: The vector whose elements will be summed.
        :returns: The sum of all elements in .
        """
        ...

    @staticmethod
    def ToScalar(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_ToScalar_T]) -> System_Runtime_Intrinsics_Vector512_ToScalar_T:
        """
        Converts the given vector to a scalar containing the value of the first element.
        
        :param vector: The vector to get the first element from.
        :returns: A scalar T containing the value of the first element.
        """
        ...

    @staticmethod
    def TryCopyTo(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_TryCopyTo_T], destination: System.Span[System_Runtime_Intrinsics_Vector512_TryCopyTo_T]) -> bool:
        """
        Tries to copy a Vector{T} to a given span.
        
        :param vector: The vector to copy.
        :param destination: The span to which  is copied.
        :returns: true if  was successfully copied to ; otherwise, false if the length of  is less than Vector512{T}.Count.
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector512[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector512[int], System.Runtime.Intrinsics.Vector512[int]]:
        """
        Widens a Vector512{Byte} into two Vector512{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector512[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector512[int], System.Runtime.Intrinsics.Vector512[int]]:
        """
        Widens a Vector512{Int16} into two Vector512{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector512[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector512[int], System.Runtime.Intrinsics.Vector512[int]]:
        """
        Widens a Vector512{Int32} into two Vector512{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector512[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector512[int], System.Runtime.Intrinsics.Vector512[int]]:
        """
        Widens a Vector512{SByte} into two Vector512{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector512[float]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector512[float], System.Runtime.Intrinsics.Vector512[float]]:
        """
        Widens a Vector512{Single} into two Vector512{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector512[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector512[int], System.Runtime.Intrinsics.Vector512[int]]:
        """
        Widens a Vector512{UInt16} into two Vector512{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector512[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector512[int], System.Runtime.Intrinsics.Vector512[int]]:
        """
        Widens a Vector512{UInt32} into two Vector512{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the lower half of a Vector512{Byte} into a Vector512{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the lower half of a Vector512{Int16} into a Vector512{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the lower half of a Vector512{Int32} into a Vector512{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the lower half of a Vector512{SByte} into a Vector512{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Widens the lower half of a Vector512{Single} into a Vector512{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the lower half of a Vector512{UInt16} into a Vector512{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the lower half of a Vector512{UInt32} into a Vector512{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the upper half of a Vector512{Byte} into a Vector512{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the upper half of a Vector512{Int16} into a Vector512{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the upper half of a Vector512{Int32} into a Vector512{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the upper half of a Vector512{SByte} into a Vector512{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        Widens the upper half of a Vector512{Single} into a Vector512{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the upper half of a Vector512{UInt16} into a Vector512{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        Widens the upper half of a Vector512{UInt32} into a Vector512{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    def WithElement(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_WithElement_T], index: int, value: System_Runtime_Intrinsics_Vector512_WithElement_T) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_WithElement_T]:
        """
        Creates a new Vector512{T} with the element at the specified index set to the specified value and the remaining elements set to the same value as that in the given vector.
        
        :param vector: The vector to get the remaining elements from.
        :param index: The index of the element to set.
        :param value: The value to set the element to.
        :returns: A Vector512{T} with the value of the element at  set to  and the remaining elements set to the same value as that in .
        """
        ...

    @staticmethod
    def WithLower(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_WithLower_T], value: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector512_WithLower_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_WithLower_T]:
        """
        Creates a new Vector512{T} with the lower 256-bits set to the specified value and the upper 256-bits set to the same value as that in the given vector.
        
        :param vector: The vector to get the upper 256-bits from.
        :param value: The value of the lower 256-bits as a Vector256{T}.
        :returns: A new Vector512{T} with the lower 256-bits set to  and the upper 256-bits set to the same value as that in .
        """
        ...

    @staticmethod
    def WithUpper(vector: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_WithUpper_T], value: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector512_WithUpper_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_WithUpper_T]:
        """
        Creates a new Vector512{T} with the upper 256-bits set to the specified value and the upper 256-bits set to the same value as that in the given vector.
        
        :param vector: The vector to get the lower 256-bits from.
        :param value: The value of the upper 256-bits as a Vector256{T}.
        :returns: A new Vector512{T} with the upper 256-bits set to  and the lower 256-bits set to the same value as that in .
        """
        ...

    @staticmethod
    def Xor(left: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Xor_T], right: System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Xor_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector512_Xor_T]:
        """
        Computes the exclusive-or of two vectors.
        
        :param left: The vector to exclusive-or with .
        :param right: The vector to exclusive-or with .
        :returns: The exclusive-or of  and .
        """
        ...


class Vector256(typing.Generic[System_Runtime_Intrinsics_Vector256_T], System.IEquatable[System_Runtime_Intrinsics_Vector256]):
    """This class has no documentation."""

    Size: int = 32

    Alignment: int = 32

    IsHardwareAccelerated: bool

    @property
    def _lower(self) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector256_T]:
        ...

    @property
    def _upper(self) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector256_T]:
        ...

    AllBitsSet: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_T]
    """Gets a new Vector256{T} with all bits set to 1."""

    Count: int
    """Gets the number of T that are in a Vector256{T}."""

    IsSupported: bool
    """Gets true if T is supported; otherwise, false."""

    One: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_T]
    """Gets a new Vector256{T} with all elements initialized to one."""

    Zero: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_T]
    """Gets a new Vector256{T} with all elements initialized to zero."""

    @property
    def DisplayString(self) -> str:
        ...

    def __getitem__(self, index: int) -> System_Runtime_Intrinsics_Vector256_T:
        """
        Gets the element at the specified index.
        
        :param index: The index of the element to get.
        :returns: The value of the element at .
        """
        ...

    @staticmethod
    def Abs(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Abs_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Abs_T]:
        """
        Computes the absolute value of each element in a vector.
        
        :param vector: The vector that will have its absolute value computed.
        :returns: A vector whose elements are the absolute value of the elements in .
        """
        ...

    @staticmethod
    def Add(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Add_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Add_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Add_T]:
        """
        Adds two vectors to compute their sum.
        
        :param left: The vector to add with .
        :param right: The vector to add with .
        :returns: The sum of  and .
        """
        ...

    @staticmethod
    def AndNot(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AndNot_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AndNot_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AndNot_T]:
        """
        Computes the bitwise-and of a given vector and the ones complement of another vector.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to that is ones-complemented before being bitwise-and with .
        :returns: The bitwise-and of  and the ones-complement of .
        """
        ...

    @staticmethod
    def As(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_As_TFrom]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_As_TTo]:
        """
        Reinterprets a Vector256{TFrom} as a new Vector256{TTo}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{TTo}.
        """
        ...

    @staticmethod
    def AsByte(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsByte_T]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Reinterprets a Vector256{T} as a new Vector256{Byte}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{Byte}.
        """
        ...

    @staticmethod
    def AsDouble(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsDouble_T]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Reinterprets a Vector256{T} as a new Vector256{Double}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{Double}.
        """
        ...

    @staticmethod
    def AsInt16(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsInt16_T]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Reinterprets a Vector256{T} as a new Vector256{Int16}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{Int16}.
        """
        ...

    @staticmethod
    def AsInt32(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsInt32_T]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Reinterprets a Vector256{T} as a new Vector256{Int32}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{Int32}.
        """
        ...

    @staticmethod
    def AsInt64(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsInt64_T]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Reinterprets a Vector256{T} as a new Vector256{Int64}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{Int64}.
        """
        ...

    @staticmethod
    def AsNInt(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsNInt_T]) -> System.Runtime.Intrinsics.Vector256[System.IntPtr]:
        """
        Reinterprets a Vector256{T} as a new Vector256{IntPtr}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{IntPtr}.
        """
        ...

    @staticmethod
    def AsNUInt(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsNUInt_T]) -> System.Runtime.Intrinsics.Vector256[System.UIntPtr]:
        """
        Reinterprets a Vector256{T} as a new Vector256{UIntPtr}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{UIntPtr}.
        """
        ...

    @staticmethod
    def AsSByte(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsSByte_T]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Reinterprets a Vector256{T} as a new Vector256{SByte}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{SByte}.
        """
        ...

    @staticmethod
    def AsSingle(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsSingle_T]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Reinterprets a Vector256{T} as a new Vector256{Single}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{Single}.
        """
        ...

    @staticmethod
    def AsUInt16(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsUInt16_T]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Reinterprets a Vector256{T} as a new Vector256{UInt16}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{UInt16}.
        """
        ...

    @staticmethod
    def AsUInt32(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsUInt32_T]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Reinterprets a Vector256{T} as a new Vector256{UInt32}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{UInt32}.
        """
        ...

    @staticmethod
    def AsUInt64(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsUInt64_T]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Reinterprets a Vector256{T} as a new Vector256{UInt64}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{UInt64}.
        """
        ...

    @staticmethod
    def AsVector(value: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsVector_T]) -> System.Numerics.Vector[System_Runtime_Intrinsics_Vector256_AsVector_T]:
        """
        Reinterprets a Vector256{T} as a new Vector{T}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{T}.
        """
        ...

    @staticmethod
    def AsVector256(value: System.Numerics.Vector[System_Runtime_Intrinsics_Vector256_AsVector256_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_AsVector256_T]:
        """
        Reinterprets a Vector{T} as a new Vector256{T}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector256{T}.
        """
        ...

    @staticmethod
    def BitwiseAnd(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_BitwiseAnd_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_BitwiseAnd_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_BitwiseAnd_T]:
        """
        Computes the bitwise-and of two vectors.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to bitwise-and with .
        :returns: The bitwise-and of  and .
        """
        ...

    @staticmethod
    def BitwiseOr(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_BitwiseOr_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_BitwiseOr_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_BitwiseOr_T]:
        """
        Computes the bitwise-or of two vectors.
        
        :param left: The vector to bitwise-or with .
        :param right: The vector to bitwise-or with .
        :returns: The bitwise-or of  and .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(vector: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param vector: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(vector: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param vector: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    def ConditionalSelect(condition: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_ConditionalSelect_T], left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_ConditionalSelect_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_ConditionalSelect_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_ConditionalSelect_T]:
        """
        Conditionally selects a value from two vectors on a bitwise basis.
        
        :param condition: The mask that is used to select a value from  or .
        :param left: The vector that is selected when the corresponding bit in  is one.
        :param right: The vector that is selected when the corresponding bit in  is zero.
        :returns: A vector whose bits come from  or  based on the value of .
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(vector: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Converts a Vector256{Int64} to a Vector256{Double}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(vector: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Converts a Vector256{UInt64} to a Vector256{Double}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt32(vector: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Converts a Vector256{Single} to a Vector256{Int32}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt64(vector: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Converts a Vector256{Double} to a Vector256{Int64}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(vector: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Converts a Vector256{Int32} to a Vector256{Single}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(vector: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Converts a Vector256{UInt32} to a Vector256{Single}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt32(vector: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Converts a Vector256{Single} to a Vector256{UInt32}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt64(vector: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Converts a Vector256{Double} to a Vector256{UInt64}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_CopyTo_T], destination: typing.List[System_Runtime_Intrinsics_Vector256_CopyTo_T]) -> None:
        """
        Copies a Vector256{T} to a given array.
        
        :param vector: The vector to be copied.
        :param destination: The array to which  is copied.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_CopyTo_T], destination: typing.List[System_Runtime_Intrinsics_Vector256_CopyTo_T], startIndex: int) -> None:
        """
        Copies a Vector256{T} to a given array starting at the specified index.
        
        :param vector: The vector to be copied.
        :param destination: The array to which  is copied.
        :param startIndex: The starting index of  which  will be copied to.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_CopyTo_T], destination: System.Span[System_Runtime_Intrinsics_Vector256_CopyTo_T]) -> None:
        """
        Copies a Vector256{T} to a given span.
        
        :param vector: The vector to be copied.
        :param destination: The span to which the  is copied.
        """
        ...

    @staticmethod
    @overload
    def Create(value: System_Runtime_Intrinsics_Vector256_Create_T) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Create_T]:
        """
        Creates a new Vector256{T} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{T} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Byte} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{Byte} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: float) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Double} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{Double} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int16} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{Int16} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int32} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{Int32} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int64} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{Int64} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector256[System.IntPtr]:
        """
        Creates a new Vector256{IntPtr} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{IntPtr} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector256[System.UIntPtr]:
        """
        Creates a new Vector256{UIntPtr} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{UIntPtr} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{SByte} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{SByte} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: float) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Single} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{Single} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt16} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{UInt16} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt32} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{UInt32} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt64} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector256{UInt64} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(values: typing.List[System_Runtime_Intrinsics_Vector256_Create_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Create_T]:
        """
        Creates a new Vector256{T} from a given array.
        
        :param values: The array from which the vector is created.
        :returns: A new Vector256{T} with its elements set to the first Vector256{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(values: typing.List[System_Runtime_Intrinsics_Vector256_Create_T], index: int) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Create_T]:
        """
        Creates a new Vector256{T} from a given array.
        
        :param values: The array from which the vector is created.
        :param index: The index in  at which to being reading elements.
        :returns: A new Vector256{T} with its elements set to the first Vector128{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(values: System.ReadOnlySpan[System_Runtime_Intrinsics_Vector256_Create_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Create_T]:
        """
        Creates a new Vector256{T} from a given readonly span.
        
        :param values: The readonly span from which the vector is created.
        :returns: A new Vector256{T} with its elements set to the first Vector256{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int, e16: int, e17: int, e18: int, e19: int, e20: int, e21: int, e22: int, e23: int, e24: int, e25: int, e26: int, e27: int, e28: int, e29: int, e30: int, e31: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Byte} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :param e16: The value that element 16 will be initialized to.
        :param e17: The value that element 17 will be initialized to.
        :param e18: The value that element 18 will be initialized to.
        :param e19: The value that element 19 will be initialized to.
        :param e20: The value that element 20 will be initialized to.
        :param e21: The value that element 21 will be initialized to.
        :param e22: The value that element 22 will be initialized to.
        :param e23: The value that element 23 will be initialized to.
        :param e24: The value that element 24 will be initialized to.
        :param e25: The value that element 25 will be initialized to.
        :param e26: The value that element 26 will be initialized to.
        :param e27: The value that element 27 will be initialized to.
        :param e28: The value that element 28 will be initialized to.
        :param e29: The value that element 29 will be initialized to.
        :param e30: The value that element 30 will be initialized to.
        :param e31: The value that element 31 will be initialized to.
        :returns: A new Vector256{Byte} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: float, e1: float, e2: float, e3: float) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Double} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :returns: A new Vector256{Double} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int16} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :returns: A new Vector256{Int16} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int32} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector256{Int32} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int64} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :returns: A new Vector256{Int64} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int, e16: int, e17: int, e18: int, e19: int, e20: int, e21: int, e22: int, e23: int, e24: int, e25: int, e26: int, e27: int, e28: int, e29: int, e30: int, e31: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{SByte} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :param e16: The value that element 16 will be initialized to.
        :param e17: The value that element 17 will be initialized to.
        :param e18: The value that element 18 will be initialized to.
        :param e19: The value that element 19 will be initialized to.
        :param e20: The value that element 20 will be initialized to.
        :param e21: The value that element 21 will be initialized to.
        :param e22: The value that element 22 will be initialized to.
        :param e23: The value that element 23 will be initialized to.
        :param e24: The value that element 24 will be initialized to.
        :param e25: The value that element 25 will be initialized to.
        :param e26: The value that element 26 will be initialized to.
        :param e27: The value that element 27 will be initialized to.
        :param e28: The value that element 28 will be initialized to.
        :param e29: The value that element 29 will be initialized to.
        :param e30: The value that element 30 will be initialized to.
        :param e31: The value that element 31 will be initialized to.
        :returns: A new Vector256{SByte} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: float, e1: float, e2: float, e3: float, e4: float, e5: float, e6: float, e7: float) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Single} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector256{Single} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt16} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :returns: A new Vector256{UInt16} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt32} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector256{UInt32} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt64} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :returns: A new Vector256{UInt64} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector256_Create_T], upper: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector256_Create_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Create_T]:
        """
        Creates a new Vector256{T} instance from two Vector128{T} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{T} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Byte} instance from two Vector128{Byte} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{Byte} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[float], upper: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Double} instance from two Vector128{Double} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{Double} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int16} instance from two Vector128{Int16} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{Int16} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int32} instance from two Vector128{Int32} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{Int32} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int64} instance from two Vector128{Int64} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{Int64} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[System.IntPtr], upper: System.Runtime.Intrinsics.Vector128[System.IntPtr]) -> System.Runtime.Intrinsics.Vector256[System.IntPtr]:
        """
        Creates a new Vector256{IntPtr} instance from two Vector128{IntPtr} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{IntPtr} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[System.UIntPtr], upper: System.Runtime.Intrinsics.Vector128[System.UIntPtr]) -> System.Runtime.Intrinsics.Vector256[System.UIntPtr]:
        """
        Creates a new Vector256{UIntPtr} instance from two Vector128{UIntPtr} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{UIntPtr} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{SByte} instance from two Vector128{SByte} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{SByte} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[float], upper: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Single} instance from two Vector128{Single} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{Single} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt16} instance from two Vector128{UInt16} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{UInt16} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt32} instance from two Vector128{UInt32} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{UInt32} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt64} instance from two Vector128{UInt64} instances.
        
        :param lower: The value that the lower 128-bits will be initialized to.
        :param upper: The value that the upper 128-bits will be initialized to.
        :returns: A new Vector256{UInt64} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System_Runtime_Intrinsics_Vector256_CreateScalar_T) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_CreateScalar_T]:
        """
        Creates a new Vector256{T} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{T} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Byte} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Byte} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: float) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Double} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Double} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int16} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Int16} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int32} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Int32} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int64} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Int64} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector256[System.IntPtr]:
        """
        Creates a new Vector256{IntPtr} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{IntPtr} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector256[System.UIntPtr]:
        """
        Creates a new Vector256{UIntPtr} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{UIntPtr} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{SByte} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{SByte} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: float) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Single} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Single} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt16} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{UInt16} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt32} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{UInt32} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt64} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{UInt64} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System_Runtime_Intrinsics_Vector256_CreateScalarUnsafe_T) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_CreateScalarUnsafe_T]:
        """
        Creates a new Vector256{T} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{T} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Byte} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Byte} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: float) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Double} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Double} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int16} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Int16} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int32} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Int32} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{Int64} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Int64} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector256[System.IntPtr]:
        """
        Creates a new Vector256{IntPtr} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{IntPtr} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector256[System.UIntPtr]:
        """
        Creates a new Vector256{UIntPtr} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{UIntPtr} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{SByte} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{SByte} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: float) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new Vector256{Single} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{Single} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt16} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{UInt16} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt32} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{UInt32} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new Vector256{UInt64} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector256{UInt64} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Divide_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Divide_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Divide_T]:
        """
        Divides two vectors to compute their quotient.
        
        :param left: The vector that will be divided by .
        :param right: The vector that will divide .
        :returns: The quotient of  divided by .
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Divide_T], right: System_Runtime_Intrinsics_Vector256_Divide_T) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Divide_T]:
        """
        Divides a vector by a scalar to compute the per-element quotient.
        
        :param left: The vector that will be divided by .
        :param right: The scalar that will divide .
        :returns: The quotient of  divided by .
        """
        ...

    @staticmethod
    def Dot(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Dot_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Dot_T]) -> System_Runtime_Intrinsics_Vector256_Dot_T:
        """
        Computes the dot product of two vectors.
        
        :param left: The vector that will be dotted with .
        :param right: The vector that will be dotted with .
        :returns: The dot product of  and .
        """
        ...

    @staticmethod
    def Equals(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Equals_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Equals_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Equals_T]:
        """
        Compares two vectors to determine if they are equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if the corresponding elements in  and  were equal.
        """
        ...

    @staticmethod
    def EqualsAll(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_EqualsAll_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_EqualsAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were equal to the corresponding element in .
        """
        ...

    @staticmethod
    def EqualsAny(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_EqualsAny_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_EqualsAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was equal to the corresponding element in .
        """
        ...

    @staticmethod
    def ExtractMostSignificantBits(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_ExtractMostSignificantBits_T]) -> int:
        """
        Extracts the most significant bit from each element in a vector.
        
        :param vector: The vector whose elements should have their most significant bit extracted.
        :returns: The packed most significant bits extracted from the elements in .
        """
        ...

    @staticmethod
    @overload
    def Floor(vector: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Computes the floor of each element in a vector.
        
        :param vector: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Floor(vector: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Computes the floor of each element in a vector.
        
        :param vector: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    @staticmethod
    def GetElement(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GetElement_T], index: int) -> System_Runtime_Intrinsics_Vector256_GetElement_T:
        """
        Gets the element at the specified index.
        
        :param vector: The vector to get the element from.
        :param index: The index of the element to get.
        :returns: The value of the element at .
        """
        ...

    @staticmethod
    def GetLower(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GetLower_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector256_GetLower_T]:
        """
        Gets the value of the lower 128-bits as a new Vector128{T}.
        
        :param vector: The vector to get the lower 128-bits from.
        :returns: The value of the lower 128-bits as a new Vector128{T}.
        """
        ...

    @staticmethod
    def GetUpper(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GetUpper_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector256_GetUpper_T]:
        """
        Gets the value of the upper 128-bits as a new Vector128{T}.
        
        :param vector: The vector to get the upper 128-bits from.
        :returns: The value of the upper 128-bits as a new Vector128{T}.
        """
        ...

    @staticmethod
    def GreaterThan(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThan_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThan_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThan_T]:
        """
        Compares two vectors to determine which is greater on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater.
        """
        ...

    @staticmethod
    def GreaterThanAll(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanAll_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanAny(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanAny_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanOrEqual_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanOrEqual_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanOrEqual_T]:
        """
        Compares two vectors to determine which is greater or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater or equal.
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAll(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanOrEqualAll_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAny(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanOrEqualAny_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_GreaterThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def LessThan(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThan_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThan_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThan_T]:
        """
        Compares two vectors to determine which is less on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less.
        """
        ...

    @staticmethod
    def LessThanAll(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanAll_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanAny(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanAny_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanOrEqual_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanOrEqual_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanOrEqual_T]:
        """
        Compares two vectors to determine which is less or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less or equal.
        """
        ...

    @staticmethod
    def LessThanOrEqualAll(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanOrEqualAll_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanOrEqualAny(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanOrEqualAny_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LessThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def Load(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Load_T]:
        """
        Loads a vector from the given source.
        
        :param source: The source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    def LoadAligned(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LoadAligned_T]:
        """
        Loads a vector from the given aligned source.
        
        :param source: The aligned source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    def LoadAlignedNonTemporal(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LoadAlignedNonTemporal_T]:
        """
        Loads a vector from the given aligned source.
        
        :param source: The aligned source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    @overload
    def LoadUnsafe(source: System_Runtime_Intrinsics_Vector256_LoadUnsafe_T) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LoadUnsafe_T]:
        """
        Loads a vector from the given source.
        
        :param source: The source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    @overload
    def LoadUnsafe(source: System_Runtime_Intrinsics_Vector256_LoadUnsafe_T, elementOffset: System.UIntPtr) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_LoadUnsafe_T]:
        """
        Loads a vector from the given source and element offset.
        
        :param source: The source to which  will be added before loading the vector.
        :param elementOffset: The element offset from  from which the vector will be loaded.
        :returns: The vector loaded from  plus .
        """
        ...

    @staticmethod
    def Max(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Max_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Max_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Max_T]:
        """
        Computes the maximum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the maximum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    def Min(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Min_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Min_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Min_T]:
        """
        Computes the minimum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the minimum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Multiply_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Multiply_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Multiply_T]:
        """
        Multiplies two vectors to compute their element-wise product.
        
        :param left: The vector to multiply with .
        :param right: The vector to multiply with .
        :returns: The element-wise product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Multiply_T], right: System_Runtime_Intrinsics_Vector256_Multiply_T) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The vector to multiply with .
        :param right: The scalar to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System_Runtime_Intrinsics_Vector256_Multiply_T, right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Multiply_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The scalar to multiply with .
        :param right: The vector to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector256[float], upper: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Narrows two Vector256{Double} instances into one Vector256{Single}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector256{Single} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Narrows two Vector256{Int16} instances into one Vector256{SByte}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector256{SByte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Narrows two Vector256{Int32} instances into one Vector256{Int16}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector256{Int16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Narrows two Vector256{Int64} instances into one Vector256{Int32}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector256{Int32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Narrows two Vector256{UInt16} instances into one Vector256{Byte}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector256{Byte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Narrows two Vector256{UInt32} instances into one Vector256{UInt16}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector256{UInt16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector256[int], upper: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Narrows two Vector256{UInt64} instances into one Vector256{UInt32}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector256{UInt32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    def Negate(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Negate_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Negate_T]:
        """
        Negates a vector.
        
        :param vector: The vector to negate.
        :returns: A vector whose elements are the negation of the corresponding elements in .
        """
        ...

    @staticmethod
    def OnesComplement(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_OnesComplement_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_OnesComplement_T]:
        """
        Computes the ones-complement of a vector.
        
        :param vector: The vector whose ones-complement is to be computed.
        :returns: A vector whose elements are the ones-complement of the corresponding elements in .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[System.IntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[System.UIntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[System.UIntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector256[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[System.IntPtr]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[System.IntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[System.UIntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[System.UIntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector256[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[float], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[int], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector256[float], indices: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    def Sqrt(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Sqrt_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Sqrt_T]:
        """
        Computes the square root of a vector on a per-element basis.
        
        :param vector: The vector whose square root is to be computed.
        :returns: A vector whose elements are the square root of the corresponding elements in .
        """
        ...

    @staticmethod
    def Store(source: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Store_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination at which  will be stored.
        """
        ...

    @staticmethod
    def StoreAligned(source: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_StoreAligned_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given aligned destination.
        
        :param source: The vector that will be stored.
        :param destination: The aligned destination at which  will be stored.
        """
        ...

    @staticmethod
    def StoreAlignedNonTemporal(source: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_StoreAlignedNonTemporal_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given aligned destination.
        
        :param source: The vector that will be stored.
        :param destination: The aligned destination at which  will be stored.
        """
        ...

    @staticmethod
    @overload
    def StoreUnsafe(source: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_StoreUnsafe_T], destination: System_Runtime_Intrinsics_Vector256_StoreUnsafe_T) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination at which  will be stored.
        """
        ...

    @staticmethod
    @overload
    def StoreUnsafe(source: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_StoreUnsafe_T], destination: System_Runtime_Intrinsics_Vector256_StoreUnsafe_T, elementOffset: System.UIntPtr) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination to which  will be added before the vector will be stored.
        :param elementOffset: The element offset from  from which the vector will be stored.
        """
        ...

    @staticmethod
    def Subtract(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Subtract_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Subtract_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Subtract_T]:
        """
        Subtracts two vectors to compute their difference.
        
        :param left: The vector from which  will be subtracted.
        :param right: The vector to subtract from .
        :returns: The difference of  and .
        """
        ...

    @staticmethod
    def Sum(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Sum_T]) -> System_Runtime_Intrinsics_Vector256_Sum_T:
        """
        Computes the sum of all elements in a vector.
        
        :param vector: The vector whose elements will be summed.
        :returns: The sum of all elements in .
        """
        ...

    @staticmethod
    def ToScalar(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_ToScalar_T]) -> System_Runtime_Intrinsics_Vector256_ToScalar_T:
        """
        Converts the given vector to a scalar containing the value of the first element.
        
        :param vector: The vector to get the first element from.
        :returns: A scalar T containing the value of the first element.
        """
        ...

    @staticmethod
    def ToVector512(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_ToVector512_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector256_ToVector512_T]:
        """
        Converts the given vector to a new Vector512{T} with the lower 256-bits set to the value of the given vector and the upper 256-bits initialized to zero.
        
        :param vector: The vector to extend.
        :returns: A new Vector512{T} with the lower 256-bits set to the value of  and the upper 256-bits initialized to zero.
        """
        ...

    @staticmethod
    def ToVector512Unsafe(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_ToVector512Unsafe_T]) -> System.Runtime.Intrinsics.Vector512[System_Runtime_Intrinsics_Vector256_ToVector512Unsafe_T]:
        """
        Converts the given vector to a new Vector512{T} with the lower 256-bits set to the value of the given vector and the upper 256-bits left uninitialized.
        
        :param vector: The vector to extend.
        :returns: A new Vector512{T} with the lower 256-bits set to the value of  and the upper 256-bits left uninitialized.
        """
        ...

    @staticmethod
    def TryCopyTo(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_TryCopyTo_T], destination: System.Span[System_Runtime_Intrinsics_Vector256_TryCopyTo_T]) -> bool:
        """
        Tries to copy a Vector{T} to a given span.
        
        :param vector: The vector to copy.
        :param destination: The span to which  is copied.
        :returns: true if  was successfully copied to ; otherwise, false if the length of  is less than Vector256{T}.Count.
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector256[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector256[int], System.Runtime.Intrinsics.Vector256[int]]:
        """
        Widens a Vector256{Byte} into two Vector256{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector256[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector256[int], System.Runtime.Intrinsics.Vector256[int]]:
        """
        Widens a Vector256{Int16} into two Vector256{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector256[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector256[int], System.Runtime.Intrinsics.Vector256[int]]:
        """
        Widens a Vector256{Int32} into two Vector256{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector256[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector256[int], System.Runtime.Intrinsics.Vector256[int]]:
        """
        Widens a Vector256{SByte} into two Vector256{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector256[float]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector256[float], System.Runtime.Intrinsics.Vector256[float]]:
        """
        Widens a Vector256{Single} into two Vector256{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector256[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector256[int], System.Runtime.Intrinsics.Vector256[int]]:
        """
        Widens a Vector256{UInt16} into two Vector256{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector256[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector256[int], System.Runtime.Intrinsics.Vector256[int]]:
        """
        Widens a Vector256{UInt32} into two Vector256{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the lower half of a Vector256{Byte} into a Vector256{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the lower half of a Vector256{Int16} into a Vector256{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the lower half of a Vector256{Int32} into a Vector256{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the lower half of a Vector256{SByte} into a Vector256{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Widens the lower half of a Vector256{Single} into a Vector256{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the lower half of a Vector256{UInt16} into a Vector256{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the lower half of a Vector256{UInt32} into a Vector256{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the upper half of a Vector256{Byte} into a Vector256{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the upper half of a Vector256{Int16} into a Vector256{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the upper half of a Vector256{Int32} into a Vector256{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the upper half of a Vector256{SByte} into a Vector256{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        Widens the upper half of a Vector256{Single} into a Vector256{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the upper half of a Vector256{UInt16} into a Vector256{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        Widens the upper half of a Vector256{UInt32} into a Vector256{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    def WithElement(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_WithElement_T], index: int, value: System_Runtime_Intrinsics_Vector256_WithElement_T) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_WithElement_T]:
        """
        Creates a new Vector256{T} with the element at the specified index set to the specified value and the remaining elements set to the same value as that in the given vector.
        
        :param vector: The vector to get the remaining elements from.
        :param index: The index of the element to set.
        :param value: The value to set the element to.
        :returns: A Vector256{T} with the value of the element at  set to  and the remaining elements set to the same value as that in .
        """
        ...

    @staticmethod
    def WithLower(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_WithLower_T], value: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector256_WithLower_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_WithLower_T]:
        """
        Creates a new Vector256{T} with the lower 128-bits set to the specified value and the upper 128-bits set to the same value as that in the given vector.
        
        :param vector: The vector to get the upper 128-bits from.
        :param value: The value of the lower 128-bits as a Vector128{T}.
        :returns: A new Vector256{T} with the lower 128-bits set to  and the upper 128-bits set to the same value as that in .
        """
        ...

    @staticmethod
    def WithUpper(vector: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_WithUpper_T], value: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector256_WithUpper_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_WithUpper_T]:
        """
        Creates a new Vector256{T} with the upper 128-bits set to the specified value and the upper 128-bits set to the same value as that in the given vector.
        
        :param vector: The vector to get the lower 128-bits from.
        :param value: The value of the upper 128-bits as a Vector128{T}.
        :returns: A new Vector256{T} with the upper 128-bits set to  and the lower 128-bits set to the same value as that in .
        """
        ...

    @staticmethod
    def Xor(left: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Xor_T], right: System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Xor_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector256_Xor_T]:
        """
        Computes the exclusive-or of two vectors.
        
        :param left: The vector to exclusive-or with .
        :param right: The vector to exclusive-or with .
        :returns: The exclusive-or of  and .
        """
        ...


class Vector128(typing.Generic[System_Runtime_Intrinsics_Vector128_T], System.IEquatable[System_Runtime_Intrinsics_Vector128]):
    """This class has no documentation."""

    @property
    def _lower(self) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector128_T]:
        ...

    @property
    def _upper(self) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector128_T]:
        ...

    AllBitsSet: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_T]
    """Gets a new Vector128{T} with all bits set to 1."""

    Count: int
    """Gets the number of T that are in a Vector128{T}."""

    IsSupported: bool
    """Gets true if T is supported; otherwise, false."""

    One: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_T]
    """Gets a new Vector128{T} with all elements initialized to one."""

    Zero: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_T]
    """Gets a new Vector128{T} with all elements initialized to zero."""

    @property
    def DisplayString(self) -> str:
        ...

    Size: int = 16

    Alignment: int = 16

    IsHardwareAccelerated: bool

    def __getitem__(self, index: int) -> System_Runtime_Intrinsics_Vector128_T:
        """
        Gets the element at the specified index.
        
        :param index: The index of the element to get.
        :returns: The value of the element at .
        """
        ...

    @staticmethod
    def Abs(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Abs_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Abs_T]:
        """
        Computes the absolute value of each element in a vector.
        
        :param vector: The vector that will have its absolute value computed.
        :returns: A vector whose elements are the absolute value of the elements in .
        """
        ...

    @staticmethod
    def Add(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Add_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Add_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Add_T]:
        """
        Adds two vectors to compute their sum.
        
        :param left: The vector to add with .
        :param right: The vector to add with .
        :returns: The sum of  and .
        """
        ...

    @staticmethod
    def AndNot(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AndNot_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AndNot_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AndNot_T]:
        """
        Computes the bitwise-and of a given vector and the ones complement of another vector.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to that is ones-complemented before being bitwise-and with .
        :returns: The bitwise-and of  and the ones-complement of .
        """
        ...

    @staticmethod
    def As(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_As_TFrom]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_As_TTo]:
        """
        Reinterprets a Vector128{TFrom} as a new Vector128{TTo}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{TTo}.
        """
        ...

    @staticmethod
    def AsByte(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsByte_T]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Reinterprets a Vector128{T} as a new Vector128{Byte}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{Byte}.
        """
        ...

    @staticmethod
    def AsDouble(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsDouble_T]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Reinterprets a Vector128{T} as a new Vector128{Double}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{Double}.
        """
        ...

    @staticmethod
    def AsInt16(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsInt16_T]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Reinterprets a Vector128{T} as a new Vector128{Int16}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{Int16}.
        """
        ...

    @staticmethod
    def AsInt32(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsInt32_T]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Reinterprets a Vector128{T} as a new Vector128{Int32}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{Int32}.
        """
        ...

    @staticmethod
    def AsInt64(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsInt64_T]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Reinterprets a Vector128{T} as a new Vector128{Int64}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{Int64}.
        """
        ...

    @staticmethod
    def AsNInt(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsNInt_T]) -> System.Runtime.Intrinsics.Vector128[System.IntPtr]:
        """
        Reinterprets a Vector128{T} as a new Vector128{IntPtr}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{IntPtr}.
        """
        ...

    @staticmethod
    def AsNUInt(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsNUInt_T]) -> System.Runtime.Intrinsics.Vector128[System.UIntPtr]:
        """
        Reinterprets a Vector128{T} as a new Vector128{UIntPtr}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{UIntPtr}.
        """
        ...

    @staticmethod
    def AsSByte(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsSByte_T]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Reinterprets a Vector128{T} as a new Vector128{SByte}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{SByte}.
        """
        ...

    @staticmethod
    def AsSingle(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsSingle_T]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Reinterprets a Vector128{T} as a new Vector128{Single}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{Single}.
        """
        ...

    @staticmethod
    def AsUInt16(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsUInt16_T]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Reinterprets a Vector128{T} as a new Vector128{UInt16}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{UInt16}.
        """
        ...

    @staticmethod
    def AsUInt32(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsUInt32_T]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Reinterprets a Vector128{T} as a new Vector128{UInt32}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{UInt32}.
        """
        ...

    @staticmethod
    def AsUInt64(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsUInt64_T]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Reinterprets a Vector128{T} as a new Vector128{UInt64}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{UInt64}.
        """
        ...

    @staticmethod
    def AsVector(value: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsVector_T]) -> System.Numerics.Vector[System_Runtime_Intrinsics_Vector128_AsVector_T]:
        """
        Reinterprets a Vector128{T} as a new Vector{T}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{T}.
        """
        ...

    @staticmethod
    @overload
    def AsVector128(value: System.Numerics.Vector2) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Reinterprets a Vector2 as a new Vector128{Single}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{Single}.
        """
        ...

    @staticmethod
    @overload
    def AsVector128(value: System.Numerics.Vector3) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Reinterprets a Vector3 as a new Vector128{Single}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{Single}.
        """
        ...

    @staticmethod
    @overload
    def AsVector128(value: System.Numerics.Vector4) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Reinterprets a Vector4 as a new Vector128{Single}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{Single}.
        """
        ...

    @staticmethod
    @overload
    def AsVector128(value: System.Numerics.Vector[System_Runtime_Intrinsics_Vector128_AsVector128_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_AsVector128_T]:
        """
        Reinterprets a Vector{T} as a new Vector128{T}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector128{T}.
        """
        ...

    @staticmethod
    def AsVector2(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Numerics.Vector2:
        """
        Reinterprets a Vector128{Single} as a new Vector2.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector2.
        """
        ...

    @staticmethod
    def AsVector3(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Numerics.Vector3:
        """
        Reinterprets a Vector128{Single} as a new Vector3.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector3.
        """
        ...

    @staticmethod
    def AsVector4(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Numerics.Vector4:
        """
        Reinterprets a Vector128{Single} as a new Vector4.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector4.
        """
        ...

    @staticmethod
    def BitwiseAnd(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_BitwiseAnd_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_BitwiseAnd_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_BitwiseAnd_T]:
        """
        Computes the bitwise-and of two vectors.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to bitwise-and with .
        :returns: The bitwise-and of  and .
        """
        ...

    @staticmethod
    def BitwiseOr(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_BitwiseOr_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_BitwiseOr_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_BitwiseOr_T]:
        """
        Computes the bitwise-or of two vectors.
        
        :param left: The vector to bitwise-or with .
        :param right: The vector to bitwise-or with .
        :returns: The bitwise-or of  and .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(vector: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param vector: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(vector: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param vector: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    def ConditionalSelect(condition: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_ConditionalSelect_T], left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_ConditionalSelect_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_ConditionalSelect_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_ConditionalSelect_T]:
        """
        Conditionally selects a value from two vectors on a bitwise basis.
        
        :param condition: The mask that is used to select a value from  or .
        :param left: The vector that is selected when the corresponding bit in  is one.
        :param right: The vector that is selected when the corresponding bit in  is zero.
        :returns: A vector whose bits come from  or  based on the value of .
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(vector: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Converts a Vector128{Int64} to a Vector128{Double}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(vector: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Converts a Vector128{UInt64} to a Vector128{Double}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt32(vector: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Converts a Vector128{Single} to a Vector128{Int32}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt64(vector: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Converts a Vector128{Double} to a Vector128{Int64}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(vector: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Converts a Vector128{Int32} to a Vector128{Single}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(vector: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Converts a Vector128{UInt32} to a Vector128{Single}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt32(vector: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Converts a Vector128{Single} to a Vector128{UInt32}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt64(vector: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Converts a Vector128{Double} to a Vector128{UInt64}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_CopyTo_T], destination: typing.List[System_Runtime_Intrinsics_Vector128_CopyTo_T]) -> None:
        """
        Copies a Vector128{T} to a given array.
        
        :param vector: The vector to be copied.
        :param destination: The array to which  is copied.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_CopyTo_T], destination: typing.List[System_Runtime_Intrinsics_Vector128_CopyTo_T], startIndex: int) -> None:
        """
        Copies a Vector128{T} to a given array starting at the specified index.
        
        :param vector: The vector to be copied.
        :param destination: The array to which  is copied.
        :param startIndex: The starting index of  which  will be copied to.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_CopyTo_T], destination: System.Span[System_Runtime_Intrinsics_Vector128_CopyTo_T]) -> None:
        """
        Copies a Vector128{T} to a given span.
        
        :param vector: The vector to be copied.
        :param destination: The span to which the  is copied.
        """
        ...

    @staticmethod
    @overload
    def Create(value: System_Runtime_Intrinsics_Vector128_Create_T) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Create_T]:
        """
        Creates a new Vector128{T} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{T} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Byte} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{Byte} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: float) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Double} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{Double} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int16} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{Int16} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int32} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{Int32} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int64} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{Int64} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector128[System.IntPtr]:
        """
        Creates a new Vector128{IntPtr} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{IntPtr} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector128[System.UIntPtr]:
        """
        Creates a new Vector128{UIntPtr} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{UIntPtr} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{SByte} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{SByte} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: float) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Single} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{Single} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt16} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{UInt16} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt32} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{UInt32} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt64} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector128{UInt64} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(values: typing.List[System_Runtime_Intrinsics_Vector128_Create_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Create_T]:
        """
        Creates a new Vector128{T} from a given array.
        
        :param values: The array from which the vector is created.
        :returns: A new Vector128{T} with its elements set to the first Vector128{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(values: typing.List[System_Runtime_Intrinsics_Vector128_Create_T], index: int) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Create_T]:
        """
        Creates a new Vector128{T} from a given array.
        
        :param values: The array from which the vector is created.
        :param index: The index in  at which to being reading elements.
        :returns: A new Vector128{T} with its elements set to the first Vector128{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(values: System.ReadOnlySpan[System_Runtime_Intrinsics_Vector128_Create_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Create_T]:
        """
        Creates a new Vector128{T} from a given readonly span.
        
        :param values: The readonly span from which the vector is created.
        :returns: A new Vector128{T} with its elements set to the first Vector128{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Byte} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :returns: A new Vector128{Byte} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: float, e1: float) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Double} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :returns: A new Vector128{Double} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int16} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector128{Int16} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int32} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :returns: A new Vector128{Int32} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int64} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :returns: A new Vector128{Int64} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int, e8: int, e9: int, e10: int, e11: int, e12: int, e13: int, e14: int, e15: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{SByte} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :param e8: The value that element 8 will be initialized to.
        :param e9: The value that element 9 will be initialized to.
        :param e10: The value that element 10 will be initialized to.
        :param e11: The value that element 11 will be initialized to.
        :param e12: The value that element 12 will be initialized to.
        :param e13: The value that element 13 will be initialized to.
        :param e14: The value that element 14 will be initialized to.
        :param e15: The value that element 15 will be initialized to.
        :returns: A new Vector128{SByte} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: float, e1: float, e2: float, e3: float) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Single} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :returns: A new Vector128{Single} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt16} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector128{UInt16} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt32} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :returns: A new Vector128{UInt32} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt64} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :returns: A new Vector128{UInt64} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector128_Create_T], upper: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector128_Create_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Create_T]:
        """
        Creates a new Vector128{T} instance from two Vector64{T} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{T} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Byte} instance from two Vector64{Byte} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{Byte} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[float], upper: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Double} instance from two Vector64{Double} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{Double} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int16} instance from two Vector64{Int16} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{Int16} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int32} instance from two Vector64{Int32} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{Int32} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int64} instance from two Vector64{Int64} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{Int64} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[System.IntPtr], upper: System.Runtime.Intrinsics.Vector64[System.IntPtr]) -> System.Runtime.Intrinsics.Vector128[System.IntPtr]:
        """
        Creates a new Vector128{IntPtr} instance from two Vector64{IntPtr} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{IntPtr} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[System.UIntPtr], upper: System.Runtime.Intrinsics.Vector64[System.UIntPtr]) -> System.Runtime.Intrinsics.Vector128[System.UIntPtr]:
        """
        Creates a new Vector128{UIntPtr} instance from two Vector64{UIntPtr} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{UIntPtr} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{SByte} instance from two Vector64{SByte} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{SByte} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[float], upper: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Single} instance from two Vector64{Single} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{Single} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt16} instance from two Vector64{UInt16} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{UInt16} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt32} instance from two Vector64{UInt32} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{UInt32} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def Create(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt64} instance from two Vector64{UInt64} instances.
        
        :param lower: The value that the lower 64-bits will be initialized to.
        :param upper: The value that the upper 64-bits will be initialized to.
        :returns: A new Vector128{UInt64} initialized from  and .
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System_Runtime_Intrinsics_Vector128_CreateScalar_T) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_CreateScalar_T]:
        """
        Creates a new Vector128{T} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{T} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Byte} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Byte} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: float) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Double} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Double} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int16} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Int16} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int32} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Int32} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int64} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Int64} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector128[System.IntPtr]:
        """
        Creates a new Vector128{IntPtr} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{IntPtr} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector128[System.UIntPtr]:
        """
        Creates a new Vector128{UIntPtr} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{UIntPtr} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{SByte} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{SByte} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: float) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Single} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Single} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt16} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{UInt16} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt32} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{UInt32} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt64} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{UInt64} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System_Runtime_Intrinsics_Vector128_CreateScalarUnsafe_T) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_CreateScalarUnsafe_T]:
        """
        Creates a new Vector128{T} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{T} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Byte} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Byte} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: float) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Double} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Double} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int16} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Int16} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int32} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Int32} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{Int64} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Int64} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector128[System.IntPtr]:
        """
        Creates a new Vector128{IntPtr} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{IntPtr} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector128[System.UIntPtr]:
        """
        Creates a new Vector128{UIntPtr} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{UIntPtr} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{SByte} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{SByte} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: float) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new Vector128{Single} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{Single} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt16} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{UInt16} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt32} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{UInt32} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new Vector128{UInt64} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector128{UInt64} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Divide_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Divide_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Divide_T]:
        """
        Divides two vectors to compute their quotient.
        
        :param left: The vector that will be divided by .
        :param right: The vector that will divide .
        :returns: The quotient of  divided by .
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Divide_T], right: System_Runtime_Intrinsics_Vector128_Divide_T) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Divide_T]:
        """
        Divides a vector by a scalar to compute the per-element quotient.
        
        :param left: The vector that will be divided by .
        :param right: The scalar that will divide .
        :returns: The quotient of  divided by .
        """
        ...

    @staticmethod
    def Dot(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Dot_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Dot_T]) -> System_Runtime_Intrinsics_Vector128_Dot_T:
        """
        Computes the dot product of two vectors.
        
        :param left: The vector that will be dotted with .
        :param right: The vector that will be dotted with .
        :returns: The dot product of  and .
        """
        ...

    @staticmethod
    def Equals(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Equals_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Equals_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Equals_T]:
        """
        Compares two vectors to determine if they are equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if the corresponding elements in  and  were equal.
        """
        ...

    @staticmethod
    def EqualsAll(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_EqualsAll_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_EqualsAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were equal to the corresponding element in .
        """
        ...

    @staticmethod
    def EqualsAny(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_EqualsAny_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_EqualsAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was equal to the corresponding element in .
        """
        ...

    @staticmethod
    def ExtractMostSignificantBits(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_ExtractMostSignificantBits_T]) -> int:
        """
        Extracts the most significant bit from each element in a vector.
        
        :param vector: The vector whose elements should have their most significant bit extracted.
        :returns: The packed most significant bits extracted from the elements in .
        """
        ...

    @staticmethod
    @overload
    def Floor(vector: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Computes the floor of each element in a vector.
        
        :param vector: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Floor(vector: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Computes the floor of each element in a vector.
        
        :param vector: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    @staticmethod
    def GetElement(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GetElement_T], index: int) -> System_Runtime_Intrinsics_Vector128_GetElement_T:
        """
        Gets the element at the specified index.
        
        :param vector: The vector to get the element from.
        :param index: The index of the element to get.
        :returns: The value of the element at .
        """
        ...

    @staticmethod
    def GetLower(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GetLower_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector128_GetLower_T]:
        """
        Gets the value of the lower 64-bits as a new Vector64{T}.
        
        :param vector: The vector to get the lower 64-bits from.
        :returns: The value of the lower 64-bits as a new Vector64{T}.
        """
        ...

    @staticmethod
    def GetUpper(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GetUpper_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector128_GetUpper_T]:
        """
        Gets the value of the upper 64-bits as a new Vector64{T}.
        
        :param vector: The vector to get the upper 64-bits from.
        :returns: The value of the upper 64-bits as a new Vector64{T}.
        """
        ...

    @staticmethod
    def GreaterThan(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThan_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThan_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThan_T]:
        """
        Compares two vectors to determine which is greater on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater.
        """
        ...

    @staticmethod
    def GreaterThanAll(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanAll_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanAny(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanAny_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanOrEqual_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanOrEqual_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanOrEqual_T]:
        """
        Compares two vectors to determine which is greater or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater or equal.
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAll(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanOrEqualAll_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAny(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanOrEqualAny_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_GreaterThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def LessThan(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThan_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThan_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThan_T]:
        """
        Compares two vectors to determine which is less on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less.
        """
        ...

    @staticmethod
    def LessThanAll(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanAll_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanAny(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanAny_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanOrEqual_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanOrEqual_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanOrEqual_T]:
        """
        Compares two vectors to determine which is less or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less or equal.
        """
        ...

    @staticmethod
    def LessThanOrEqualAll(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanOrEqualAll_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanOrEqualAny(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanOrEqualAny_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LessThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def Load(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Load_T]:
        """
        Loads a vector from the given source.
        
        :param source: The source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    def LoadAligned(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LoadAligned_T]:
        """
        Loads a vector from the given aligned source.
        
        :param source: The aligned source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    def LoadAlignedNonTemporal(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LoadAlignedNonTemporal_T]:
        """
        Loads a vector from the given aligned source.
        
        :param source: The aligned source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    @overload
    def LoadUnsafe(source: System_Runtime_Intrinsics_Vector128_LoadUnsafe_T) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LoadUnsafe_T]:
        """
        Loads a vector from the given source.
        
        :param source: The source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    @overload
    def LoadUnsafe(source: System_Runtime_Intrinsics_Vector128_LoadUnsafe_T, elementOffset: System.UIntPtr) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_LoadUnsafe_T]:
        """
        Loads a vector from the given source and element offset.
        
        :param source: The source to which  will be added before loading the vector.
        :param elementOffset: The element offset from  from which the vector will be loaded.
        :returns: The vector loaded from  plus .
        """
        ...

    @staticmethod
    def Max(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Max_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Max_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Max_T]:
        """
        Computes the maximum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the maximum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    def Min(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Min_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Min_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Min_T]:
        """
        Computes the minimum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the minimum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Multiply_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Multiply_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Multiply_T]:
        """
        Multiplies two vectors to compute their element-wise product.
        
        :param left: The vector to multiply with .
        :param right: The vector to multiply with .
        :returns: The element-wise product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Multiply_T], right: System_Runtime_Intrinsics_Vector128_Multiply_T) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The vector to multiply with .
        :param right: The scalar to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System_Runtime_Intrinsics_Vector128_Multiply_T, right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Multiply_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The scalar to multiply with .
        :param right: The vector to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector128[float], upper: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Narrows two Vector128{Double} instances into one Vector128{Single}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector128{Single} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Narrows two Vector128{Int16} instances into one Vector128{SByte}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector128{SByte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Narrows two Vector128{Int32} instances into one Vector128{Int16}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector128{Int16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Narrows two Vector128{Int64} instances into one Vector128{Int32}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector128{Int32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Narrows two Vector128{UInt16} instances into one Vector128{Byte}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector128{Byte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Narrows two Vector128{UInt32} instances into one Vector128{UInt16}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector128{UInt16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector128[int], upper: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Narrows two Vector128{UInt64} instances into one Vector128{UInt32}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector128{UInt32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    def Negate(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Negate_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Negate_T]:
        """
        Negates a vector.
        
        :param vector: The vector to negate.
        :returns: A vector whose elements are the negation of the corresponding elements in .
        """
        ...

    @staticmethod
    def OnesComplement(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_OnesComplement_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_OnesComplement_T]:
        """
        Computes the ones-complement of a vector.
        
        :param vector: The vector whose ones-complement is to be computed.
        :returns: A vector whose elements are the ones-complement of the corresponding elements in .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[System.IntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[System.UIntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[System.UIntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector128[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[System.IntPtr]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[System.IntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[System.UIntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[System.UIntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector128[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[float], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[int], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector128[float], indices: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    def Sqrt(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Sqrt_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Sqrt_T]:
        """
        Computes the square root of a vector on a per-element basis.
        
        :param vector: The vector whose square root is to be computed.
        :returns: A vector whose elements are the square root of the corresponding elements in .
        """
        ...

    @staticmethod
    def Store(source: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Store_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination at which  will be stored.
        """
        ...

    @staticmethod
    def StoreAligned(source: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_StoreAligned_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given aligned destination.
        
        :param source: The vector that will be stored.
        :param destination: The aligned destination at which  will be stored.
        """
        ...

    @staticmethod
    def StoreAlignedNonTemporal(source: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_StoreAlignedNonTemporal_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given aligned destination.
        
        :param source: The vector that will be stored.
        :param destination: The aligned destination at which  will be stored.
        """
        ...

    @staticmethod
    @overload
    def StoreUnsafe(source: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_StoreUnsafe_T], destination: System_Runtime_Intrinsics_Vector128_StoreUnsafe_T) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination at which  will be stored.
        """
        ...

    @staticmethod
    @overload
    def StoreUnsafe(source: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_StoreUnsafe_T], destination: System_Runtime_Intrinsics_Vector128_StoreUnsafe_T, elementOffset: System.UIntPtr) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination to which  will be added before the vector will be stored.
        :param elementOffset: The element offset from  from which the vector will be stored.
        """
        ...

    @staticmethod
    def Subtract(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Subtract_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Subtract_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Subtract_T]:
        """
        Subtracts two vectors to compute their difference.
        
        :param left: The vector from which  will be subtracted.
        :param right: The vector to subtract from .
        :returns: The difference of  and .
        """
        ...

    @staticmethod
    def Sum(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Sum_T]) -> System_Runtime_Intrinsics_Vector128_Sum_T:
        """
        Computes the sum of all elements in a vector.
        
        :param vector: The vector whose elements will be summed.
        :returns: The sum of all elements in .
        """
        ...

    @staticmethod
    def ToScalar(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_ToScalar_T]) -> System_Runtime_Intrinsics_Vector128_ToScalar_T:
        """
        Converts the given vector to a scalar containing the value of the first element.
        
        :param vector: The vector to get the first element from.
        :returns: A scalar T containing the value of the first element.
        """
        ...

    @staticmethod
    def ToVector256(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_ToVector256_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector128_ToVector256_T]:
        """
        Converts the given vector to a new Vector256{T} with the lower 128-bits set to the value of the given vector and the upper 128-bits initialized to zero.
        
        :param vector: The vector to extend.
        :returns: A new Vector256{T} with the lower 128-bits set to the value of  and the upper 128-bits initialized to zero.
        """
        ...

    @staticmethod
    def ToVector256Unsafe(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_ToVector256Unsafe_T]) -> System.Runtime.Intrinsics.Vector256[System_Runtime_Intrinsics_Vector128_ToVector256Unsafe_T]:
        """
        Converts the given vector to a new Vector256{T} with the lower 128-bits set to the value of the given vector and the upper 128-bits left uninitialized.
        
        :param vector: The vector to extend.
        :returns: A new Vector256{T} with the lower 128-bits set to the value of  and the upper 128-bits left uninitialized.
        """
        ...

    @staticmethod
    def TryCopyTo(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_TryCopyTo_T], destination: System.Span[System_Runtime_Intrinsics_Vector128_TryCopyTo_T]) -> bool:
        """
        Tries to copy a Vector{T} to a given span.
        
        :param vector: The vector to copy.
        :param destination: The span to which  is copied.
        :returns: true if  was successfully copied to ; otherwise, false if the length of  is less than Vector128{T}.Count.
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector128[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector128[int], System.Runtime.Intrinsics.Vector128[int]]:
        """
        Widens a Vector128{Byte} into two Vector128{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector128[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector128[int], System.Runtime.Intrinsics.Vector128[int]]:
        """
        Widens a Vector128{Int16} into two Vector128{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector128[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector128[int], System.Runtime.Intrinsics.Vector128[int]]:
        """
        Widens a Vector128{Int32} into two Vector128{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector128[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector128[int], System.Runtime.Intrinsics.Vector128[int]]:
        """
        Widens a Vector128{SByte} into two Vector128{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector128[float]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector128[float], System.Runtime.Intrinsics.Vector128[float]]:
        """
        Widens a Vector128{Single} into two Vector128{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector128[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector128[int], System.Runtime.Intrinsics.Vector128[int]]:
        """
        Widens a Vector128{UInt16} into two Vector128{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector128[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector128[int], System.Runtime.Intrinsics.Vector128[int]]:
        """
        Widens a Vector128{UInt32} into two Vector128{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the lower half of a Vector128{Byte} into a Vector128{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the lower half of a Vector128{Int16} into a Vector128{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the lower half of a Vector128{Int32} into a Vector128{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the lower half of a Vector128{SByte} into a Vector128{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Widens the lower half of a Vector128{Single} into a Vector128{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the lower half of a Vector128{UInt16} into a Vector128{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the lower half of a Vector128{UInt32} into a Vector128{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the upper half of a Vector128{Byte} into a Vector128{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the upper half of a Vector128{Int16} into a Vector128{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the upper half of a Vector128{Int32} into a Vector128{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the upper half of a Vector128{SByte} into a Vector128{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        Widens the upper half of a Vector128{Single} into a Vector128{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the upper half of a Vector128{UInt16} into a Vector128{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        Widens the upper half of a Vector128{UInt32} into a Vector128{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    def WithElement(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_WithElement_T], index: int, value: System_Runtime_Intrinsics_Vector128_WithElement_T) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_WithElement_T]:
        """
        Creates a new Vector128{T} with the element at the specified index set to the specified value and the remaining elements set to the same value as that in the given vector.
        
        :param vector: The vector to get the remaining elements from.
        :param index: The index of the element to set.
        :param value: The value to set the element to.
        :returns: A Vector128{T} with the value of the element at  set to  and the remaining elements set to the same value as that in .
        """
        ...

    @staticmethod
    def WithLower(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_WithLower_T], value: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector128_WithLower_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_WithLower_T]:
        """
        Creates a new Vector128{T} with the lower 64-bits set to the specified value and the upper 64-bits set to the same value as that in the given vector.
        
        :param vector: The vector to get the upper 64-bits from.
        :param value: The value of the lower 64-bits as a Vector64{T}.
        :returns: A new Vector128{T} with the lower 64-bits set to  and the upper 64-bits set to the same value as that in .
        """
        ...

    @staticmethod
    def WithUpper(vector: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_WithUpper_T], value: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector128_WithUpper_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_WithUpper_T]:
        """
        Creates a new Vector128{T} with the upper 64-bits set to the specified value and the upper 64-bits set to the same value as that in the given vector.
        
        :param vector: The vector to get the lower 64-bits from.
        :param value: The value of the upper 64-bits as a Vector64{T}.
        :returns: A new Vector128{T} with the upper 64-bits set to  and the lower 64-bits set to the same value as that in .
        """
        ...

    @staticmethod
    def Xor(left: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Xor_T], right: System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Xor_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector128_Xor_T]:
        """
        Computes the exclusive-or of two vectors.
        
        :param left: The vector to exclusive-or with .
        :param right: The vector to exclusive-or with .
        :returns: The exclusive-or of  and .
        """
        ...


class Vector64(typing.Generic[System_Runtime_Intrinsics_Vector64_T], System.IEquatable[System_Runtime_Intrinsics_Vector64]):
    """Provides a collection of static methods for creating, manipulating, and otherwise operating on 64-bit vectors."""

    @property
    def _00(self) -> int:
        ...

    AllBitsSet: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_T]
    """Gets a new Vector64{T} with all bits set to 1."""

    Count: int
    """Gets the number of T that are in a Vector64{T}."""

    IsSupported: bool
    """Gets true if T is supported; otherwise, false."""

    One: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_T]
    """Gets a new Vector64{T} with all elements initialized to one."""

    Zero: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_T]
    """Gets a new Vector64{T} with all elements initialized to zero."""

    @property
    def DisplayString(self) -> str:
        ...

    @property
    def element(self) -> System_Runtime_Intrinsics_Vector64_T:
        ...

    @element.setter
    def element(self, value: System_Runtime_Intrinsics_Vector64_T):
        ...

    Size: int = 8

    Alignment: int = 8

    IsHardwareAccelerated: bool
    """Gets a value that indicates whether 64-bit vector operations are subject to hardware acceleration through JIT intrinsic support."""

    def __getitem__(self, index: int) -> System_Runtime_Intrinsics_Vector64_T:
        """
        Gets the element at the specified index.
        
        :param index: The index of the element to get.
        :returns: The value of the element at .
        """
        ...

    @staticmethod
    def Abs(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Abs_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Abs_T]:
        """
        Computes the absolute value of each element in a vector.
        
        :param vector: The vector that will have its absolute value computed.
        :returns: A vector whose elements are the absolute value of the elements in .
        """
        ...

    @staticmethod
    def Add(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Add_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Add_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Add_T]:
        """
        Adds two vectors to compute their sum.
        
        :param left: The vector to add with .
        :param right: The vector to add with .
        :returns: The sum of  and .
        """
        ...

    @staticmethod
    def AndNot(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AndNot_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AndNot_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AndNot_T]:
        """
        Computes the bitwise-and of a given vector and the ones complement of another vector.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to that is ones-complemented before being bitwise-and with .
        :returns: The bitwise-and of  and the ones-complement of .
        """
        ...

    @staticmethod
    def As(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_As_TFrom]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_As_TTo]:
        """
        Reinterprets a Vector64{TFrom} as a new Vector64{TTo}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{TTo}.
        """
        ...

    @staticmethod
    def AsByte(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsByte_T]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Reinterprets a Vector64{T} as a new Vector64{Byte}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{Byte}.
        """
        ...

    @staticmethod
    def AsDouble(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsDouble_T]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Reinterprets a Vector64{T} as a new Vector64{Double}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{Double}.
        """
        ...

    @staticmethod
    def AsInt16(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsInt16_T]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Reinterprets a Vector64{T} as a new Vector64{Int16}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{Int16}.
        """
        ...

    @staticmethod
    def AsInt32(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsInt32_T]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Reinterprets a Vector64{T} as a new Vector64{Int32}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{Int32}.
        """
        ...

    @staticmethod
    def AsInt64(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsInt64_T]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Reinterprets a Vector64{T} as a new Vector64{Int64}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{Int64}.
        """
        ...

    @staticmethod
    def AsNInt(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsNInt_T]) -> System.Runtime.Intrinsics.Vector64[System.IntPtr]:
        """
        Reinterprets a Vector64{T} as a new Vector64{IntPtr}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{IntPtr}.
        """
        ...

    @staticmethod
    def AsNUInt(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsNUInt_T]) -> System.Runtime.Intrinsics.Vector64[System.UIntPtr]:
        """
        Reinterprets a Vector64{T} as a new Vector64{UIntPtr}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{UIntPtr}.
        """
        ...

    @staticmethod
    def AsSByte(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsSByte_T]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Reinterprets a Vector64{T} as a new Vector64{SByte}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{SByte}.
        """
        ...

    @staticmethod
    def AsSingle(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsSingle_T]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Reinterprets a Vector64{T} as a new Vector64{Single}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{Single}.
        """
        ...

    @staticmethod
    def AsUInt16(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsUInt16_T]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Reinterprets a Vector64{T} as a new Vector64{UInt16}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{UInt16}.
        """
        ...

    @staticmethod
    def AsUInt32(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsUInt32_T]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Reinterprets a Vector64{T} as a new Vector64{UInt32}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{UInt32}.
        """
        ...

    @staticmethod
    def AsUInt64(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_AsUInt64_T]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Reinterprets a Vector64{T} as a new Vector64{UInt64}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{UInt64}.
        """
        ...

    @staticmethod
    def BitwiseAnd(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_BitwiseAnd_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_BitwiseAnd_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_BitwiseAnd_T]:
        """
        Computes the bitwise-and of two vectors.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to bitwise-and with .
        :returns: The bitwise-and of  and .
        """
        ...

    @staticmethod
    def BitwiseOr(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_BitwiseOr_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_BitwiseOr_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_BitwiseOr_T]:
        """
        Computes the bitwise-or of two vectors.
        
        :param left: The vector to bitwise-or with .
        :param right: The vector to bitwise-or with .
        :returns: The bitwise-or of  and .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(vector: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param vector: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(vector: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param vector: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    def ConditionalSelect(condition: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_ConditionalSelect_T], left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_ConditionalSelect_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_ConditionalSelect_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_ConditionalSelect_T]:
        """
        Conditionally selects a value from two vectors on a bitwise basis.
        
        :param condition: The mask that is used to select a value from  or .
        :param left: The vector that is selected when the corresponding bit in  is one.
        :param right: The vector that is selected when the corresponding bit in  is zero.
        :returns: A vector whose bits come from  or  based on the value of .
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(vector: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Converts a Vector64{Int64} to a Vector64{Double}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(vector: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Converts a Vector64{UInt64} to a Vector64{Double}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt32(vector: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Converts a Vector64{Single} to a Vector64{Int32}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt64(vector: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Converts a Vector64{Double} to a Vector64{Int64}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(vector: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Converts a Vector64{Int32} to a Vector64{Single}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(vector: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Converts a Vector64{UInt32} to a Vector64{Single}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt32(vector: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Converts a Vector64{Single} to a Vector64{UInt32}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt64(vector: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Converts a Vector64{Double} to a Vector64{UInt64}.
        
        :param vector: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_CopyTo_T], destination: typing.List[System_Runtime_Intrinsics_Vector64_CopyTo_T]) -> None:
        """
        Copies a Vector64{T} to a given array.
        
        :param vector: The vector to be copied.
        :param destination: The array to which  is copied.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_CopyTo_T], destination: typing.List[System_Runtime_Intrinsics_Vector64_CopyTo_T], startIndex: int) -> None:
        """
        Copies a Vector64{T} to a given array starting at the specified index.
        
        :param vector: The vector to be copied.
        :param destination: The array to which  is copied.
        :param startIndex: The starting index of  which  will be copied to.
        """
        ...

    @staticmethod
    @overload
    def CopyTo(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_CopyTo_T], destination: System.Span[System_Runtime_Intrinsics_Vector64_CopyTo_T]) -> None:
        """
        Copies a Vector64{T} to a given span.
        
        :param vector: The vector to be copied.
        :param destination: The span to which  is copied.
        """
        ...

    @staticmethod
    @overload
    def Create(value: System_Runtime_Intrinsics_Vector64_Create_T) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Create_T]:
        """
        Creates a new Vector64{T} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{T} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Byte} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{Byte} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: float) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Creates a new Vector64{Double} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{Double} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int16} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{Int16} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int32} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{Int32} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int64} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{Int64} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector64[System.IntPtr]:
        """
        Creates a new Vector64{IntPtr} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{IntPtr} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector64[System.UIntPtr]:
        """
        Creates a new Vector64{UIntPtr} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{UIntPtr} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{SByte} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{SByte} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: float) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Creates a new Vector64{Single} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{Single} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt16} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{UInt16} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt32} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{UInt32} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt64} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector64{UInt64} with all elements initialized to .
        """
        ...

    @staticmethod
    @overload
    def Create(values: typing.List[System_Runtime_Intrinsics_Vector64_Create_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Create_T]:
        """
        Creates a new Vector64{T} from a given array.
        
        :param values: The array from which the vector is created.
        :returns: A new Vector64{T} with its elements set to the first Vector64{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(values: typing.List[System_Runtime_Intrinsics_Vector64_Create_T], index: int) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Create_T]:
        """
        Creates a new Vector64{T} from a given array.
        
        :param values: The array from which the vector is created.
        :param index: The index in  at which to being reading elements.
        :returns: A new Vector64{T} with its elements set to the first Vector128{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(values: System.ReadOnlySpan[System_Runtime_Intrinsics_Vector64_Create_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Create_T]:
        """
        Creates a new Vector64{T} from a given readonly span.
        
        :param values: The readonly span from which the vector is created.
        :returns: A new Vector64{T} with its elements set to the first Vector64{T}.Count elements from .
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Byte} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector64{Byte} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int16} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :returns: A new Vector64{Int16} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int32} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :returns: A new Vector64{Int32} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int, e4: int, e5: int, e6: int, e7: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{SByte} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :param e4: The value that element 4 will be initialized to.
        :param e5: The value that element 5 will be initialized to.
        :param e6: The value that element 6 will be initialized to.
        :param e7: The value that element 7 will be initialized to.
        :returns: A new Vector64{SByte} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: float, e1: float) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Creates a new Vector64{Single} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :returns: A new Vector64{Single} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int, e2: int, e3: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt16} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :param e2: The value that element 2 will be initialized to.
        :param e3: The value that element 3 will be initialized to.
        :returns: A new Vector64{UInt16} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def Create(e0: int, e1: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt32} instance with each element initialized to the corresponding specified value.
        
        :param e0: The value that element 0 will be initialized to.
        :param e1: The value that element 1 will be initialized to.
        :returns: A new Vector64{UInt32} with each element initialized to corresponding specified value.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System_Runtime_Intrinsics_Vector64_CreateScalar_T) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_CreateScalar_T]:
        """
        Creates a new Vector64{T} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Byte} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Byte} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Byte} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: float) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Creates a new Vector64{Double} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Double} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int16} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Int16} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int32} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Int32} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int64} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Int64} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector64[System.IntPtr]:
        """
        Creates a new Vector64{IntPtr} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{IntPtr} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector64[System.UIntPtr]:
        """
        Creates a new Vector64{UIntPtr} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{UIntPtr} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{SByte} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{SByte} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: float) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Creates a new Vector64{Single} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Single} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt16} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{UInt16} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt32} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{UInt32} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalar(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt64} instance with the first element initialized to the specified value and the remaining elements initialized to zero.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{UInt64} instance with the first element initialized to  and the remaining elements initialized to zero.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System_Runtime_Intrinsics_Vector64_CreateScalarUnsafe_T) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_CreateScalarUnsafe_T]:
        """
        Creates a new Vector64{T} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{T} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Byte} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Byte} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: float) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Creates a new Vector64{Double} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Double} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int16} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Int16} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int32} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Int32} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{Int64} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Int64} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System.IntPtr) -> System.Runtime.Intrinsics.Vector64[System.IntPtr]:
        """
        Creates a new Vector64{IntPtr} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{IntPtr} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: System.UIntPtr) -> System.Runtime.Intrinsics.Vector64[System.UIntPtr]:
        """
        Creates a new Vector64{UIntPtr} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{UIntPtr} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{SByte} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{SByte} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: float) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Creates a new Vector64{Single} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{Single} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt16} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{UInt16} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt32} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{UInt32} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def CreateScalarUnsafe(value: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new Vector64{UInt64} instance with the first element initialized to the specified value and the remaining elements left uninitialized.
        
        :param value: The value that element 0 will be initialized to.
        :returns: A new Vector64{UInt64} instance with the first element initialized to  and the remaining elements left uninitialized.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Divide_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Divide_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Divide_T]:
        """
        Divides two vectors to compute their quotient.
        
        :param left: The vector that will be divided by .
        :param right: The vector that will divide .
        :returns: The quotient of  divided by .
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Divide_T], right: System_Runtime_Intrinsics_Vector64_Divide_T) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Divide_T]:
        """
        Divides a vector by a scalar to compute the per-element quotient.
        
        :param left: The vector that will be divided by .
        :param right: The scalar that will divide .
        :returns: The quotient of  divided by .
        """
        ...

    @staticmethod
    def Dot(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Dot_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Dot_T]) -> System_Runtime_Intrinsics_Vector64_Dot_T:
        """
        Computes the dot product of two vectors.
        
        :param left: The vector that will be dotted with .
        :param right: The vector that will be dotted with .
        :returns: The dot product of  and .
        """
        ...

    @staticmethod
    def Equals(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Equals_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Equals_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Equals_T]:
        """
        Compares two vectors to determine if they are equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if the corresponding elements in  and  were equal.
        """
        ...

    @staticmethod
    def EqualsAll(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_EqualsAll_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_EqualsAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were equal to the corresponding element in .
        """
        ...

    @staticmethod
    def EqualsAny(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_EqualsAny_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_EqualsAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was equal to the corresponding element in .
        """
        ...

    @staticmethod
    def ExtractMostSignificantBits(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_ExtractMostSignificantBits_T]) -> int:
        """
        Extracts the most significant bit from each element in a vector.
        
        :param vector: The vector whose elements should have their most significant bit extracted.
        :returns: The packed most significant bits extracted from the elements in .
        """
        ...

    @staticmethod
    @overload
    def Floor(vector: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Computes the floor of each element in a vector.
        
        :param vector: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Floor(vector: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Computes the floor of each element in a vector.
        
        :param vector: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    @staticmethod
    def GetElement(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GetElement_T], index: int) -> System_Runtime_Intrinsics_Vector64_GetElement_T:
        """
        Gets the element at the specified index.
        
        :param vector: The vector to get the element from.
        :param index: The index of the element to get.
        :returns: The value of the element at .
        """
        ...

    @staticmethod
    def GreaterThan(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThan_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThan_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThan_T]:
        """
        Compares two vectors to determine which is greater on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater.
        """
        ...

    @staticmethod
    def GreaterThanAll(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanAll_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanAny(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanAny_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanOrEqual_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanOrEqual_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanOrEqual_T]:
        """
        Compares two vectors to determine which is greater or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater or equal.
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAll(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanOrEqualAll_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAny(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanOrEqualAny_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_GreaterThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def LessThan(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThan_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThan_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThan_T]:
        """
        Compares two vectors to determine which is less on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less.
        """
        ...

    @staticmethod
    def LessThanAll(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanAll_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanAny(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanAny_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanOrEqual(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanOrEqual_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanOrEqual_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanOrEqual_T]:
        """
        Compares two vectors to determine which is less or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less or equal.
        """
        ...

    @staticmethod
    def LessThanOrEqualAll(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanOrEqualAll_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanOrEqualAny(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanOrEqualAny_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LessThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def Load(source: typing.Any) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Load_T]:
        """
        Loads a vector from the given source.
        
        :param source: The source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    def LoadAligned(source: typing.Any) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LoadAligned_T]:
        """
        Loads a vector from the given aligned source.
        
        :param source: The aligned source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    def LoadAlignedNonTemporal(source: typing.Any) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LoadAlignedNonTemporal_T]:
        """
        Loads a vector from the given aligned source.
        
        :param source: The aligned source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    @overload
    def LoadUnsafe(source: System_Runtime_Intrinsics_Vector64_LoadUnsafe_T) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LoadUnsafe_T]:
        """
        Loads a vector from the given source.
        
        :param source: The source from which the vector will be loaded.
        :returns: The vector loaded from .
        """
        ...

    @staticmethod
    @overload
    def LoadUnsafe(source: System_Runtime_Intrinsics_Vector64_LoadUnsafe_T, elementOffset: System.UIntPtr) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_LoadUnsafe_T]:
        """
        Loads a vector from the given source and element offset.
        
        :param source: The source to which  will be added before loading the vector.
        :param elementOffset: The element offset from  from which the vector will be loaded.
        :returns: The vector loaded from  plus .
        """
        ...

    @staticmethod
    def Max(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Max_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Max_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Max_T]:
        """
        Computes the maximum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the maximum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    def Min(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Min_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Min_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Min_T]:
        """
        Computes the minimum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the minimum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Multiply_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Multiply_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Multiply_T]:
        """
        Multiplies two vectors to compute their element-wise product.
        
        :param left: The vector to multiply with .
        :param right: The vector to multiply with .
        :returns: The element-wise product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Multiply_T], right: System_Runtime_Intrinsics_Vector64_Multiply_T) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The vector to multiply with .
        :param right: The scalar to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System_Runtime_Intrinsics_Vector64_Multiply_T, right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Multiply_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The scalar to multiply with .
        :param right: The vector to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector64[float], upper: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Narrows two Vector64{Double} instances into one Vector64{Single}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector64{Single} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Narrows two Vector64{Int16} instances into one Vector64{SByte}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector64{SByte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Narrows two Vector64{Int32} instances into one Vector64{Int16}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector64{Int16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Narrows two Vector64{Int64} instances into one Vector64{Int32}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector64{Int32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Narrows two Vector64{UInt16} instances into one Vector64{Byte}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector64{Byte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Narrows two Vector64{UInt32} instances into one Vector64{UInt16}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector64{UInt16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(lower: System.Runtime.Intrinsics.Vector64[int], upper: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Narrows two Vector64{UInt64} instances into one Vector64{UInt32}.
        
        :param lower: The vector that will be narrowed to the lower half of the result vector.
        :param upper: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector64{UInt32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    def Negate(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Negate_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Negate_T]:
        """
        Negates a vector.
        
        :param vector: The vector to negate.
        :returns: A vector whose elements are the negation of the corresponding elements in .
        """
        ...

    @staticmethod
    def OnesComplement(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_OnesComplement_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_OnesComplement_T]:
        """
        Computes the ones-complement of a vector.
        
        :param vector: The vector whose ones-complement is to be computed.
        :returns: A vector whose elements are the ones-complement of the corresponding elements in .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[System.IntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[System.UIntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[System.UIntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector64[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[System.IntPtr]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[System.IntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[System.IntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[System.UIntPtr], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[System.UIntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(vector: System.Runtime.Intrinsics.Vector64[int], shiftCount: int) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param vector: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector64[int], indices: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector64[int], indices: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector64[int], indices: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector64[int], indices: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector64[int], indices: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector64[int], indices: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    @overload
    def Shuffle(vector: System.Runtime.Intrinsics.Vector64[float], indices: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Creates a new vector by selecting values from an input vector using a set of indices.
        
        :param vector: The input vector from which values are selected.
        :param indices: The per-element indices used to select a value from .
        :returns: A new vector containing the values from  selected by the given .
        """
        ...

    @staticmethod
    def Sqrt(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Sqrt_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Sqrt_T]:
        """
        Computes the square root of a vector on a per-element basis.
        
        :param vector: The vector whose square root is to be computed.
        :returns: A vector whose elements are the square root of the corresponding elements in .
        """
        ...

    @staticmethod
    def Store(source: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Store_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination at which  will be stored.
        """
        ...

    @staticmethod
    def StoreAligned(source: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_StoreAligned_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given aligned destination.
        
        :param source: The vector that will be stored.
        :param destination: The aligned destination at which  will be stored.
        """
        ...

    @staticmethod
    def StoreAlignedNonTemporal(source: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_StoreAlignedNonTemporal_T], destination: typing.Any) -> None:
        """
        Stores a vector at the given aligned destination.
        
        :param source: The vector that will be stored.
        :param destination: The aligned destination at which  will be stored.
        """
        ...

    @staticmethod
    @overload
    def StoreUnsafe(source: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_StoreUnsafe_T], destination: System_Runtime_Intrinsics_Vector64_StoreUnsafe_T) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination at which  will be stored.
        """
        ...

    @staticmethod
    @overload
    def StoreUnsafe(source: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_StoreUnsafe_T], destination: System_Runtime_Intrinsics_Vector64_StoreUnsafe_T, elementOffset: System.UIntPtr) -> None:
        """
        Stores a vector at the given destination.
        
        :param source: The vector that will be stored.
        :param destination: The destination to which  will be added before the vector will be stored.
        :param elementOffset: The element offset from  from which the vector will be stored.
        """
        ...

    @staticmethod
    def Subtract(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Subtract_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Subtract_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Subtract_T]:
        """
        Subtracts two vectors to compute their difference.
        
        :param left: The vector from which  will be subtracted.
        :param right: The vector to subtract from .
        :returns: The difference of  and .
        """
        ...

    @staticmethod
    def Sum(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Sum_T]) -> System_Runtime_Intrinsics_Vector64_Sum_T:
        """
        Computes the sum of all elements in a vector.
        
        :param vector: The vector whose elements will be summed.
        :returns: The sum of all elements in .
        """
        ...

    @staticmethod
    def ToScalar(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_ToScalar_T]) -> System_Runtime_Intrinsics_Vector64_ToScalar_T:
        """
        Converts the given vector to a scalar containing the value of the first element.
        
        :param vector: The vector to get the first element from.
        :returns: A scalar T containing the value of the first element.
        """
        ...

    @staticmethod
    def ToVector128(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_ToVector128_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector64_ToVector128_T]:
        """
        Converts the given vector to a new Vector128{T} with the lower 64-bits set to the value of the given vector and the upper 64-bits initialized to zero.
        
        :param vector: The vector to extend.
        :returns: A new Vector128{T} with the lower 64-bits set to the value of  and the upper 64-bits initialized to zero.
        """
        ...

    @staticmethod
    def ToVector128Unsafe(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_ToVector128Unsafe_T]) -> System.Runtime.Intrinsics.Vector128[System_Runtime_Intrinsics_Vector64_ToVector128Unsafe_T]:
        """
        Converts the given vector to a new Vector128{T} with the lower 64-bits set to the value of the given vector and the upper 64-bits left uninitialized.
        
        :param vector: The vector to extend.
        :returns: A new Vector128{T} with the lower 64-bits set to the value of  and the upper 64-bits left uninitialized.
        """
        ...

    @staticmethod
    def TryCopyTo(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_TryCopyTo_T], destination: System.Span[System_Runtime_Intrinsics_Vector64_TryCopyTo_T]) -> bool:
        """
        Tries to copy a Vector{T} to a given span.
        
        :param vector: The vector to copy.
        :param destination: The span to which  is copied.
        :returns: true if  was successfully copied to ; otherwise, false if the length of  is less than Vector64{T}.Count.
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector64[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector64[int], System.Runtime.Intrinsics.Vector64[int]]:
        """
        Widens a Vector64{Byte} into two Vector64{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector64[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector64[int], System.Runtime.Intrinsics.Vector64[int]]:
        """
        Widens a Vector64{Int16} into two Vector64{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector64[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector64[int], System.Runtime.Intrinsics.Vector64[int]]:
        """
        Widens a Vector64{Int32} into two Vector64{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector64[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector64[int], System.Runtime.Intrinsics.Vector64[int]]:
        """
        Widens a Vector64{SByte} into two Vector64{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector64[float]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector64[float], System.Runtime.Intrinsics.Vector64[float]]:
        """
        Widens a Vector64{Single} into two Vector64{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector64[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector64[int], System.Runtime.Intrinsics.Vector64[int]]:
        """
        Widens a Vector64{UInt16} into two Vector64{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Runtime.Intrinsics.Vector64[int]) -> System.ValueTuple[System.Runtime.Intrinsics.Vector64[int], System.Runtime.Intrinsics.Vector64[int]]:
        """
        Widens a Vector64{UInt32} into two Vector64{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A pair of vectors that contain the widened lower and upper halves of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the lower half of a Vector64{Byte} into a Vector64{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the lower half of a Vector64{Int16} into a Vector64{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the lower half of a Vector64{Int32} into a Vector64{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the lower half of a Vector64{SByte} into a Vector64{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Widens the lower half of a Vector64{Single} into a Vector64{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the lower half of a Vector64{UInt16} into a Vector64{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenLower(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the lower half of a Vector64{UInt32} into a Vector64{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened lower half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the upper half of a Vector64{Byte} into a Vector64{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the upper half of a Vector64{Int16} into a Vector64{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the upper half of a Vector64{Int32} into a Vector64{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the upper half of a Vector64{SByte} into a Vector64{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector64[float]) -> System.Runtime.Intrinsics.Vector64[float]:
        """
        Widens the upper half of a Vector64{Single} into a Vector64{Double} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the upper half of a Vector64{UInt16} into a Vector64{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    @overload
    def WidenUpper(source: System.Runtime.Intrinsics.Vector64[int]) -> System.Runtime.Intrinsics.Vector64[int]:
        """
        Widens the upper half of a Vector64{UInt32} into a Vector64{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :returns: A vector that contain the widened upper half of .
        """
        ...

    @staticmethod
    def WithElement(vector: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_WithElement_T], index: int, value: System_Runtime_Intrinsics_Vector64_WithElement_T) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_WithElement_T]:
        """
        Creates a new Vector64{T} with the element at the specified index set to the specified value and the remaining elements set to the same value as that in the given vector.
        
        :param vector: The vector to get the remaining elements from.
        :param index: The index of the element to set.
        :param value: The value to set the element to.
        :returns: A Vector64{T} with the value of the element at  set to  and the remaining elements set to the same value as that in .
        """
        ...

    @staticmethod
    def Xor(left: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Xor_T], right: System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Xor_T]) -> System.Runtime.Intrinsics.Vector64[System_Runtime_Intrinsics_Vector64_Xor_T]:
        """
        Computes the exclusive-or of two vectors.
        
        :param left: The vector to exclusive-or with .
        :param right: The vector to exclusive-or with .
        :returns: The exclusive-or of  and .
        """
        ...


