from typing import overload
import abc
import datetime
import typing

import System
import System.Collections.Generic
import System.Runtime.CompilerServices
import System.Runtime.Serialization
import System.Threading
import System.Threading.Tasks
import System.Threading.Tasks.Sources

System_Threading_Tasks_Task = typing.Any
System_Threading_Tasks_ValueTask = typing.Any

System_Threading_Tasks_TaskAsyncEnumerableExtensions_ToBlockingEnumerable_T = typing.TypeVar("System_Threading_Tasks_TaskAsyncEnumerableExtensions_ToBlockingEnumerable_T")
System_Threading_Tasks_TaskAsyncEnumerableExtensions_ConfigureAwait_T = typing.TypeVar("System_Threading_Tasks_TaskAsyncEnumerableExtensions_ConfigureAwait_T")
System_Threading_Tasks_TaskAsyncEnumerableExtensions_WithCancellation_T = typing.TypeVar("System_Threading_Tasks_TaskAsyncEnumerableExtensions_WithCancellation_T")
System_Threading_Tasks_TaskExtensions_Unwrap_TResult = typing.TypeVar("System_Threading_Tasks_TaskExtensions_Unwrap_TResult")
System_Threading_Tasks_Task_TResult = typing.TypeVar("System_Threading_Tasks_Task_TResult")
System_Threading_Tasks_Task_FromResult_TResult = typing.TypeVar("System_Threading_Tasks_Task_FromResult_TResult")
System_Threading_Tasks_Task_ContinueWith_TResult = typing.TypeVar("System_Threading_Tasks_Task_ContinueWith_TResult")
System_Threading_Tasks_Task_FromException_TResult = typing.TypeVar("System_Threading_Tasks_Task_FromException_TResult")
System_Threading_Tasks_Task_FromCanceled_TResult = typing.TypeVar("System_Threading_Tasks_Task_FromCanceled_TResult")
System_Threading_Tasks_Task_Run_TResult = typing.TypeVar("System_Threading_Tasks_Task_Run_TResult")
System_Threading_Tasks_Task_WhenAll_TResult = typing.TypeVar("System_Threading_Tasks_Task_WhenAll_TResult")
System_Threading_Tasks_Task_WhenAny_TResult = typing.TypeVar("System_Threading_Tasks_Task_WhenAny_TResult")
System_Threading_Tasks_Task_ContinueWith_TNewResult = typing.TypeVar("System_Threading_Tasks_Task_ContinueWith_TNewResult")
System_Threading_Tasks_TaskFactory_FromAsync_TArg1 = typing.TypeVar("System_Threading_Tasks_TaskFactory_FromAsync_TArg1")
System_Threading_Tasks_TaskFactory_FromAsync_TArg2 = typing.TypeVar("System_Threading_Tasks_TaskFactory_FromAsync_TArg2")
System_Threading_Tasks_TaskFactory_FromAsync_TArg3 = typing.TypeVar("System_Threading_Tasks_TaskFactory_FromAsync_TArg3")
System_Threading_Tasks_TaskFactory_TResult = typing.TypeVar("System_Threading_Tasks_TaskFactory_TResult")
System_Threading_Tasks_TaskFactory_StartNew_TResult = typing.TypeVar("System_Threading_Tasks_TaskFactory_StartNew_TResult")
System_Threading_Tasks_TaskFactory_FromAsync_TResult = typing.TypeVar("System_Threading_Tasks_TaskFactory_FromAsync_TResult")
System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult = typing.TypeVar("System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult")
System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult = typing.TypeVar("System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult")
System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult = typing.TypeVar("System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult")
System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult = typing.TypeVar("System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult")
System_Threading_Tasks_ValueTask_TResult = typing.TypeVar("System_Threading_Tasks_ValueTask_TResult")
System_Threading_Tasks_ValueTask_FromResult_TResult = typing.TypeVar("System_Threading_Tasks_ValueTask_FromResult_TResult")
System_Threading_Tasks_ValueTask_FromCanceled_TResult = typing.TypeVar("System_Threading_Tasks_ValueTask_FromCanceled_TResult")
System_Threading_Tasks_ValueTask_FromException_TResult = typing.TypeVar("System_Threading_Tasks_ValueTask_FromException_TResult")
System_Threading_Tasks_TaskCompletionSource_TResult = typing.TypeVar("System_Threading_Tasks_TaskCompletionSource_TResult")
System_Threading_Tasks__EventContainer_Callable = typing.TypeVar("System_Threading_Tasks__EventContainer_Callable")
System_Threading_Tasks__EventContainer_ReturnType = typing.TypeVar("System_Threading_Tasks__EventContainer_ReturnType")


class TaskCreationOptions(System.Enum):
    """Specifies flags that control optional behavior for the creation and execution of tasks."""

    # Cannot convert to Python: None = ...
    """Specifies that the default behavior should be used."""

    PreferFairness = ...
    """
    A hint to a System.Threading.Tasks.TaskScheduler to schedule a
    task in as fair a manner as possible, meaning that tasks scheduled sooner will be more likely to
    be run sooner, and tasks scheduled later will be more likely to be run later.
    """

    LongRunning = ...
    """
    Specifies that a task will be a long-running, course-grained operation. It provides a hint to the
    System.Threading.Tasks.TaskScheduler that oversubscription may be
    warranted.
    """

    AttachedToParent = ...
    """Specifies that a task is attached to a parent in the task hierarchy."""

    DenyChildAttach = ...
    """Specifies that an InvalidOperationException will be thrown if an attempt is made to attach a child task to the created task."""

    HideScheduler = ...
    """
    Prevents the ambient scheduler from being seen as the current scheduler in the created task.  This means that operations
    like StartNew or ContinueWith that are performed in the created task will see TaskScheduler.Default as the current scheduler.
    """

    RunContinuationsAsynchronously = ...


class TaskContinuationOptions(System.Enum):
    """Specifies flags that control optional behavior for the creation and execution of continuation tasks."""

    # Cannot convert to Python: None = 0
    """
    Default = "Continue on any, no task options, run asynchronously"
    Specifies that the default behavior should be used.  Continuations, by default, will
    be scheduled when the antecedent task completes, regardless of the task's final System.Threading.Tasks.TaskStatus.
    """

    PreferFairness = ...

    LongRunning = ...
    """
    Specifies that a task will be a long-running, coarse-grained operation.  It provides
    a hint to the System.Threading.Tasks.TaskScheduler that
    oversubscription may be warranted.
    """

    AttachedToParent = ...
    """Specifies that a task is attached to a parent in the task hierarchy."""

    DenyChildAttach = ...
    """Specifies that an InvalidOperationException will be thrown if an attempt is made to attach a child task to the created task."""

    HideScheduler = ...
    """
    Prevents the ambient scheduler from being seen as the current scheduler in the created task.  This means that operations
    like StartNew or ContinueWith that are performed in the created task will see TaskScheduler.Default as the current scheduler.
    """

    LazyCancellation = ...
    """In the case of continuation cancellation, prevents completion of the continuation until the antecedent has completed."""

    RunContinuationsAsynchronously = ...

    NotOnRanToCompletion = ...

    NotOnFaulted = ...
    """
    Specifies that the continuation task should not be scheduled if its antecedent threw an unhandled
    exception. This option is not valid for multi-task continuations.
    """

    NotOnCanceled = ...
    """
    Specifies that the continuation task should not be scheduled if its antecedent was canceled. This
    option is not valid for multi-task continuations.
    """

    OnlyOnRanToCompletion = ...
    """
    Specifies that the continuation task should be scheduled only if its antecedent ran to
    completion. This option is not valid for multi-task continuations.
    """

    OnlyOnFaulted = ...
    """
    Specifies that the continuation task should be scheduled only if its antecedent threw an
    unhandled exception. This option is not valid for multi-task continuations.
    """

    OnlyOnCanceled = ...
    """
    Specifies that the continuation task should be scheduled only if its antecedent was canceled.
    This option is not valid for multi-task continuations.
    """

    ExecuteSynchronously = ...
    """
    Specifies that the continuation task should be executed synchronously. With this option
    specified, the continuation will be run on the same thread that causes the antecedent task to
    transition into its final state. If the antecedent is already complete when the continuation is
    created, the continuation will run on the thread creating the continuation.  Only very
    short-running continuations should be executed synchronously.
    """


class TaskFactory(typing.Generic[System_Threading_Tasks_TaskFactory_TResult], System.Object):
    """
    Provides support for creating and scheduling
    System.Threading.Tasks.Task{TResult} objects.
    """

    @property
    def CancellationToken(self) -> System.Threading.CancellationToken:
        ...

    @property
    def Scheduler(self) -> System.Threading.Tasks.TaskScheduler:
        """
        Gets the System.Threading.Tasks.TaskScheduler of this
        TaskFactory{TResult}.
        """
        ...

    @property
    def CreationOptions(self) -> int:
        """
        Gets the System.Threading.Tasks.TaskCreationOptions value of this TaskFactory{TResult}.
        
        This property contains the int value of a member of the System.Threading.Tasks.TaskCreationOptions enum.
        """
        ...

    @property
    def ContinuationOptions(self) -> int:
        """
        Gets the System.Threading.Tasks.TaskCreationOptions value of this TaskFactory{TResult}.
        
        This property contains the int value of a member of the System.Threading.Tasks.TaskContinuationOptions enum.
        """
        ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Initializes a TaskFactory{TResult} instance with the default configuration.
        
        :param cancellationToken: The default CancellationToken that will be assigned to tasks created by this TaskFactory unless another CancellationToken is explicitly specified while calling the factory methods.
        """
        ...

    @overload
    def __init__(self, scheduler: System.Threading.Tasks.TaskScheduler) -> None:
        """
        Initializes a TaskFactory{TResult} instance with the specified configuration.
        
        :param scheduler: The System.Threading.Tasks.TaskScheduler to use to schedule any tasks created with this TaskFactory{TResult}. A null value indicates that the current TaskScheduler should be used.
        """
        ...

    @overload
    def __init__(self, creationOptions: System.Threading.Tasks.TaskCreationOptions, continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> None:
        """
        Initializes a TaskFactory{TResult} instance with the specified configuration.
        
        :param creationOptions: The default System.Threading.Tasks.TaskCreationOptions to use when creating tasks with this TaskFactory{TResult}.
        :param continuationOptions: The default System.Threading.Tasks.TaskContinuationOptions to use when creating continuation tasks with this TaskFactory{TResult}.
        """
        ...

    @overload
    def __init__(self, cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> None:
        """
        Initializes a TaskFactory{TResult} instance with the specified configuration.
        
        :param cancellationToken: The default CancellationToken that will be assigned to tasks created by this TaskFactory unless another CancellationToken is explicitly specified while calling the factory methods.
        :param creationOptions: The default System.Threading.Tasks.TaskCreationOptions to use when creating tasks with this TaskFactory{TResult}.
        :param continuationOptions: The default System.Threading.Tasks.TaskContinuationOptions to use when creating continuation tasks with this TaskFactory{TResult}.
        :param scheduler: The default System.Threading.Tasks.TaskScheduler to use to schedule any Tasks created with this TaskFactory{TResult}. A null value indicates that TaskScheduler.Current should be used.
        """
        ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Initializes a TaskFactory instance with the specified configuration.
        
        :param cancellationToken: The default CancellationToken that will be assigned to tasks created by this TaskFactory unless another CancellationToken is explicitly specified while calling the factory methods.
        """
        ...

    @overload
    def __init__(self, scheduler: System.Threading.Tasks.TaskScheduler) -> None:
        """
        Initializes a TaskFactory instance with the specified configuration.
        
        :param scheduler: The System.Threading.Tasks.TaskScheduler to use to schedule any tasks created with this TaskFactory. A null value indicates that the current TaskScheduler should be used.
        """
        ...

    @overload
    def __init__(self, creationOptions: System.Threading.Tasks.TaskCreationOptions, continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> None:
        """
        Initializes a TaskFactory instance with the specified configuration.
        
        :param creationOptions: The default System.Threading.Tasks.TaskCreationOptions to use when creating tasks with this TaskFactory.
        :param continuationOptions: The default System.Threading.Tasks.TaskContinuationOptions to use when creating continuation tasks with this TaskFactory.
        """
        ...

    @overload
    def __init__(self, cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> None:
        """
        Initializes a TaskFactory instance with the specified configuration.
        
        :param cancellationToken: The default CancellationToken that will be assigned to tasks created by this TaskFactory unless another CancellationToken is explicitly specified while calling the factory methods.
        :param creationOptions: The default System.Threading.Tasks.TaskCreationOptions to use when creating tasks with this TaskFactory.
        :param continuationOptions: The default System.Threading.Tasks.TaskContinuationOptions to use when creating continuation tasks with this TaskFactory.
        :param scheduler: The default System.Threading.Tasks.TaskScheduler to use to schedule any Tasks created with this TaskFactory. A null value indicates that TaskScheduler.Current should be used.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], System_Threading_Tasks_TaskFactory_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], System_Threading_Tasks_TaskFactory_TResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], System_Threading_Tasks_TaskFactory_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], System_Threading_Tasks_TaskFactory_TResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationAction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], None]) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationAction: The action delegate to execute when all tasks in the  array have completed.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationAction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], None], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationAction: The action delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationAction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], None], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationAction: The action delegate to execute when all tasks in the  array have completed.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationAction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], None], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationAction: The action delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationAction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], None]) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationAction: The action delegate to execute when all tasks in the  array have completed.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationAction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], None], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationAction: The action delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationAction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], None], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationAction: The action delegate to execute when all tasks in the  array have completed.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationAction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], None], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationAction: The action delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task]], System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAll(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]], continuationFunction: typing.Callable[[typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TAntecedentResult]]], System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAll_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of a set of provided Tasks.
        
        :param tasks: The array of tasks from which to continue.
        :param continuationFunction: The function delegate to execute when all tasks in the  array have completed.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_TaskFactory_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_TaskFactory_TResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], System_Threading_Tasks_TaskFactory_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], System_Threading_Tasks_TaskFactory_TResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationAction: typing.Callable[[System.Threading.Tasks.Task], None]) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationAction: The action delegate to execute when one task in the  array completes.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationAction: typing.Callable[[System.Threading.Tasks.Task], None], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationAction: The action delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationAction: typing.Callable[[System.Threading.Tasks.Task], None], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationAction: The action delegate to execute when one task in the  array completes.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationAction: typing.Callable[[System.Threading.Tasks.Task], None], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationAction: The action delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task], continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TResult]:
        """
        Creates a continuation System.Threading.Tasks.Task{TResult}
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationFunction: The function delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], None]) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationAction: The action delegate to execute when one task in the  array completes.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], None], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationAction: The action delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], None], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationAction: The action delegate to execute when one task in the  array completes.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def ContinueWhenAny(self, tasks: typing.List[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_ContinueWhenAny_TAntecedentResult]], None], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation System.Threading.Tasks.Task
        that will be started upon the completion of any Task in the provided set.
        
        :param tasks: The array of tasks from which to continue when one task completes.
        :param continuationAction: The action delegate to execute when one task in the  array completes.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: The System.Threading.Tasks.TaskContinuationOptions value that controls the behavior of the created continuation System.Threading.Tasks.Task.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created continuation System.Threading.Tasks.Task{TResult}.
        :returns: The new continuation System.Threading.Tasks.Task.
        """
        ...

    @overload
    def FromAsync(self, asyncResult: System.IAsyncResult, endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that executes an end
        method function when a specified System.IAsyncResult completes.
        
        :param asyncResult: The IAsyncResult whose completion should trigger the processing of the .
        :param endMethod: The function delegate that processes the completed .
        :returns: A System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, asyncResult: System.IAsyncResult, endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that executes an end
        method function when a specified System.IAsyncResult completes.
        
        :param asyncResult: The IAsyncResult whose completion should trigger the processing of the .
        :param endMethod: The function delegate that processes the completed .
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: A System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, asyncResult: System.IAsyncResult, endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], creationOptions: System.Threading.Tasks.TaskCreationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that executes an end
        method function when a specified System.IAsyncResult completes.
        
        :param asyncResult: The IAsyncResult whose completion should trigger the processing of the .
        :param endMethod: The function delegate that processes the completed .
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the task that executes the end method.
        :returns: A System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, System_Threading_Tasks_TaskFactory_FromAsync_TArg3, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, arg3: System_Threading_Tasks_TaskFactory_FromAsync_TArg3, state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param arg3: The third argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, System_Threading_Tasks_TaskFactory_FromAsync_TArg3, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, arg3: System_Threading_Tasks_TaskFactory_FromAsync_TArg3, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param arg3: The third argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, asyncResult: System.IAsyncResult, endMethod: typing.Callable[[System.IAsyncResult], None]) -> System.Threading.Tasks.Task:
        ...

    @overload
    def FromAsync(self, asyncResult: System.IAsyncResult, endMethod: typing.Callable[[System.IAsyncResult], None], creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that executes an end method action
        when a specified System.IAsyncResult completes.
        
        :param asyncResult: The IAsyncResult whose completion should trigger the processing of the .
        :param endMethod: The action delegate that processes the completed .
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task.
        :returns: A System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, asyncResult: System.IAsyncResult, endMethod: typing.Callable[[System.IAsyncResult], None], creationOptions: System.Threading.Tasks.TaskCreationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that executes an end method action
        when a specified System.IAsyncResult completes.
        
        :param asyncResult: The IAsyncResult whose completion should trigger the processing of the .
        :param endMethod: The action delegate that processes the completed .
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the task that executes the end method.
        :returns: A System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], None], state: typing.Any) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that represents a pair of begin
        and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], None], state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that represents a pair of begin
        and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task.
        :returns: The created System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], None], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, state: typing.Any) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that represents a pair of begin
        and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], None], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that represents a pair of begin
        and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task.
        :returns: The created System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], None], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, state: typing.Any) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that represents a pair of begin
        and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], None], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that represents a pair of begin
        and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task.
        :returns: The created System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, System_Threading_Tasks_TaskFactory_FromAsync_TArg3, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], None], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, arg3: System_Threading_Tasks_TaskFactory_FromAsync_TArg3, state: typing.Any) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that represents a pair of begin
        and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param arg3: The third argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, System_Threading_Tasks_TaskFactory_FromAsync_TArg3, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], None], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, arg3: System_Threading_Tasks_TaskFactory_FromAsync_TArg3, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a System.Threading.Tasks.Task that represents a pair of begin
        and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param arg3: The third argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task.
        :returns: The created System.Threading.Tasks.Task that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, asyncResult: System.IAsyncResult, endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        ...

    @overload
    def FromAsync(self, asyncResult: System.IAsyncResult, endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that executes an end
        method function when a specified System.IAsyncResult completes.
        
        :param asyncResult: The IAsyncResult whose completion should trigger the processing of the .
        :param endMethod: The function delegate that processes the completed .
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: A System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, asyncResult: System.IAsyncResult, endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], creationOptions: System.Threading.Tasks.TaskCreationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that executes an end
        method function when a specified System.IAsyncResult completes.
        
        :param asyncResult: The IAsyncResult whose completion should trigger the processing of the .
        :param endMethod: The function delegate that processes the completed .
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the task that executes the end method.
        :returns: A System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, System_Threading_Tasks_TaskFactory_FromAsync_TArg3, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, arg3: System_Threading_Tasks_TaskFactory_FromAsync_TArg3, state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param arg3: The third argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def FromAsync(self, beginMethod: typing.Callable[[System_Threading_Tasks_TaskFactory_FromAsync_TArg1, System_Threading_Tasks_TaskFactory_FromAsync_TArg2, System_Threading_Tasks_TaskFactory_FromAsync_TArg3, typing.Callable[[System.IAsyncResult], None], System.Object], System.IAsyncResult], endMethod: typing.Callable[[System.IAsyncResult], System_Threading_Tasks_TaskFactory_FromAsync_TResult], arg1: System_Threading_Tasks_TaskFactory_FromAsync_TArg1, arg2: System_Threading_Tasks_TaskFactory_FromAsync_TArg2, arg3: System_Threading_Tasks_TaskFactory_FromAsync_TArg3, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_FromAsync_TResult]:
        """
        Creates a System.Threading.Tasks.Task{TResult} that represents a pair of
        begin and end methods that conform to the Asynchronous Programming Model pattern.
        
        :param beginMethod: The delegate that begins the asynchronous operation.
        :param endMethod: The delegate that ends the asynchronous operation.
        :param arg1: The first argument passed to the  delegate.
        :param arg2: The second argument passed to the  delegate.
        :param arg3: The third argument passed to the  delegate.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: The TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The created System.Threading.Tasks.Task{TResult} that represents the asynchronous operation.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[], System_Threading_Tasks_TaskFactory_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        ...

    @overload
    def StartNew(self, function: typing.Callable[[], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[], System_Threading_Tasks_TaskFactory_TResult], creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[], System_Threading_Tasks_TaskFactory_TResult], cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created System.Threading.Tasks.Task{TResult}.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[System.Object], System_Threading_Tasks_TaskFactory_TResult], state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param state: An object containing data to be used by the  delegate.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[System.Object], System_Threading_Tasks_TaskFactory_TResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param state: An object containing data to be used by the  delegate.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[System.Object], System_Threading_Tasks_TaskFactory_TResult], state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[System.Object], System_Threading_Tasks_TaskFactory_TResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param state: An object containing data to be used by the  delegate.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created System.Threading.Tasks.Task{TResult}.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, action: typing.Callable[[], None]) -> System.Threading.Tasks.Task:
        ...

    @overload
    def StartNew(self, action: typing.Callable[[], None], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates and starts a System.Threading.Tasks.Task.
        
        :param action: The action delegate to execute asynchronously.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :returns: The started System.Threading.Tasks.Task.
        """
        ...

    @overload
    def StartNew(self, action: typing.Callable[[], None], creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task:
        """
        Creates and starts a System.Threading.Tasks.Task.
        
        :param action: The action delegate to execute asynchronously.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task
        :returns: The started System.Threading.Tasks.Task.
        """
        ...

    @overload
    def StartNew(self, action: typing.Callable[[], None], cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates and starts a System.Threading.Tasks.Task.
        
        :param action: The action delegate to execute asynchronously.
        :param cancellationToken: The CancellationToken that will be assigned to the new Task
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created System.Threading.Tasks.Task.
        :returns: The started System.Threading.Tasks.Task.
        """
        ...

    @overload
    def StartNew(self, action: typing.Callable[[System.Object], None], state: typing.Any) -> System.Threading.Tasks.Task:
        """
        Creates and starts a System.Threading.Tasks.Task.
        
        :param action: The action delegate to execute asynchronously.
        :param state: An object containing data to be used by the  delegate.
        :returns: The started System.Threading.Tasks.Task.
        """
        ...

    @overload
    def StartNew(self, action: typing.Callable[[System.Object], None], state: typing.Any, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates and starts a System.Threading.Tasks.Task.
        
        :param action: The action delegate to execute asynchronously.
        :param state: An object containing data to be used by the  delegate.
        :param cancellationToken: The CancellationToken that will be assigned to the new Task
        :returns: The started System.Threading.Tasks.Task.
        """
        ...

    @overload
    def StartNew(self, action: typing.Callable[[System.Object], None], state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task:
        """
        Creates and starts a System.Threading.Tasks.Task.
        
        :param action: The action delegate to execute asynchronously.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task
        :returns: The started System.Threading.Tasks.Task.
        """
        ...

    @overload
    def StartNew(self, action: typing.Callable[[System.Object], None], state: typing.Any, cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates and starts a System.Threading.Tasks.Task.
        
        :param action: The action delegate to execute asynchronously.
        :param state: An object containing data to be used by the  delegate.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created System.Threading.Tasks.Task.
        :returns: The started System.Threading.Tasks.Task.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[], System_Threading_Tasks_TaskFactory_StartNew_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_StartNew_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[], System_Threading_Tasks_TaskFactory_StartNew_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_StartNew_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param cancellationToken: The CancellationToken that will be assigned to the new Task
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[], System_Threading_Tasks_TaskFactory_StartNew_TResult], creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_StartNew_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[], System_Threading_Tasks_TaskFactory_StartNew_TResult], cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_StartNew_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created System.Threading.Tasks.Task{TResult}.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[System.Object], System_Threading_Tasks_TaskFactory_StartNew_TResult], state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_StartNew_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param state: An object containing data to be used by the  delegate.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[System.Object], System_Threading_Tasks_TaskFactory_StartNew_TResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_StartNew_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param state: An object containing data to be used by the  delegate.
        :param cancellationToken: The CancellationToken that will be assigned to the new Task
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[System.Object], System_Threading_Tasks_TaskFactory_StartNew_TResult], state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_StartNew_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param state: An object containing data to be used by the  delegate.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...

    @overload
    def StartNew(self, function: typing.Callable[[System.Object], System_Threading_Tasks_TaskFactory_StartNew_TResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskFactory_StartNew_TResult]:
        """
        Creates and starts a System.Threading.Tasks.Task{TResult}.
        
        :param function: A function delegate that returns the future result to be available through the System.Threading.Tasks.Task{TResult}.
        :param state: An object containing data to be used by the  delegate.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param creationOptions: A TaskCreationOptions value that controls the behavior of the created System.Threading.Tasks.Task{TResult}.
        :param scheduler: The System.Threading.Tasks.TaskScheduler that is used to schedule the created System.Threading.Tasks.Task{TResult}.
        :returns: The started System.Threading.Tasks.Task{TResult}.
        """
        ...


class Task(typing.Generic[System_Threading_Tasks_Task_TResult], System_Threading_Tasks_Task):
    """Represents an asynchronous operation that produces a result at some time in the future."""

    t_currentTask: System.Threading.Tasks.Task

    s_taskIdCounter: int

    @property
    def m_action(self) -> System.Delegate:
        ...

    @m_action.setter
    def m_action(self, value: System.Delegate):
        ...

    @property
    def m_stateObject(self) -> System.Object:
        ...

    @m_stateObject.setter
    def m_stateObject(self, value: System.Object):
        ...

    @property
    def m_taskScheduler(self) -> System.Threading.Tasks.TaskScheduler:
        ...

    @m_taskScheduler.setter
    def m_taskScheduler(self, value: System.Threading.Tasks.TaskScheduler):
        ...

    @property
    def m_stateFlags(self) -> int:
        ...

    @m_stateFlags.setter
    def m_stateFlags(self, value: int):
        ...

    s_asyncDebuggingEnabled: bool

    @property
    def m_contingentProperties(self) -> System.Threading.Tasks.Task.ContingentProperties:
        ...

    @m_contingentProperties.setter
    def m_contingentProperties(self, value: System.Threading.Tasks.Task.ContingentProperties):
        ...

    @property
    def Options(self) -> int:
        """This property contains the int value of a member of the System.Threading.Tasks.TaskCreationOptions enum."""
        ...

    @property
    def IsWaitNotificationEnabledOrNotRanToCompletion(self) -> bool:
        """Gets whether either the end await bit is set or (not xor) the task has not completed successfully."""
        ...

    @property
    def IsWaitNotificationEnabled(self) -> bool:
        """Gets whether the task's debugger notification for wait completion bit is set."""
        ...

    @property
    def Id(self) -> int:
        ...

    CurrentId: typing.Optional[int]
    """Returns the unique ID of the currently executing Task."""

    InternalCurrent: System.Threading.Tasks.Task
    """
    Gets the Task instance currently executing, or
    null if none exists.
    """

    @property
    def Exception(self) -> System.AggregateException:
        """
        Gets the System.AggregateException that caused the Task to end prematurely. If the Task completed successfully or has not yet thrown any
        exceptions, this will return null.
        """
        ...

    @property
    def Status(self) -> int:
        """
        Gets the System.Threading.Tasks.TaskStatus of this Task.
        
        This property contains the int value of a member of the System.Threading.Tasks.TaskStatus enum.
        """
        ...

    @property
    def IsCanceled(self) -> bool:
        """
        Gets whether this Task instance has completed
        execution due to being canceled.
        """
        ...

    @property
    def IsCancellationRequested(self) -> bool:
        """
        Returns true if this task has a cancellation token and it was signaled.
        To be used internally in execute entry codepaths.
        """
        ...

    @property
    def CancellationToken(self) -> System.Threading.CancellationToken:
        """
        This internal property provides access to the CancellationToken that was set on the task
        when it was constructed.
        """
        ...

    @property
    def IsCancellationAcknowledged(self) -> bool:
        """Gets whether this Task threw an OperationCanceledException while its CancellationToken was signaled."""
        ...

    @property
    def IsCompleted(self) -> bool:
        """Gets whether this Task has completed."""
        ...

    @property
    def IsCompletedSuccessfully(self) -> bool:
        ...

    @property
    def CreationOptions(self) -> int:
        """
        Gets the System.Threading.Tasks.TaskCreationOptions used
        to create this task.
        
        This property contains the int value of a member of the System.Threading.Tasks.TaskCreationOptions enum.
        """
        ...

    @property
    def AsyncWaitHandle(self) -> System.Threading.WaitHandle:
        """
        Gets a System.Threading.WaitHandle that can be used to wait for the task to
        complete.
        """
        ...

    @property
    def AsyncState(self) -> System.Object:
        """
        Gets the state object supplied when the Task was created,
        or null if none was supplied.
        """
        ...

    @property
    def CompletedSynchronously(self) -> bool:
        """Gets an indication of whether the asynchronous operation completed synchronously."""
        ...

    @property
    def ExecutingTaskScheduler(self) -> System.Threading.Tasks.TaskScheduler:
        """Provides access to the TaskScheduler responsible for executing this Task."""
        ...

    Factory: System.Threading.Tasks.TaskFactory
    """Provides access to factory methods for creating Task and Task{TResult} instances."""

    s_cachedCompleted: System.Threading.Tasks.Task[System.Threading.Tasks.VoidTaskResult] = ...
    """Singleton cached task that's been completed successfully."""

    CompletedTask: System.Threading.Tasks.Task
    """Gets a task that's already been completed successfully."""

    @property
    def CompletedEvent(self) -> System.Threading.ManualResetEventSlim:
        """
        Provides an event that can be used to wait for completion.
        Only called by IAsyncResult.AsyncWaitHandle, which means that we really do need to instantiate a completion event.
        """
        ...

    @property
    def ExceptionRecorded(self) -> bool:
        """Whether an exception has been stored into the task."""
        ...

    @property
    def IsFaulted(self) -> bool:
        """Gets whether the Task completed due to an unhandled exception."""
        ...

    @property
    def CapturedContext(self) -> System.Threading.ExecutionContext:
        """
        The captured execution context for the current task to run inside
        If the TaskStateFlags.ExecutionContextIsNull flag is set, this means ExecutionContext.Capture returned null, otherwise
        If the captured context is the default, nothing is saved, otherwise the m_contingentProperties inflates to save the context
        """
        ...

    @CapturedContext.setter
    def CapturedContext(self, value: System.Threading.ExecutionContext):
        """
        The captured execution context for the current task to run inside
        If the TaskStateFlags.ExecutionContextIsNull flag is set, this means ExecutionContext.Capture returned null, otherwise
        If the captured context is the default, nothing is saved, otherwise the m_contingentProperties inflates to save the context
        """
        ...

    @property
    def IsExceptionObservedByParent(self) -> bool:
        """
        Checks whether the TaskStateFlags.ExceptionObservedByParent status flag is set,
        This will only be used by the implicit wait to prevent double throws
        """
        ...

    @property
    def IsDelegateInvoked(self) -> bool:
        """Checks whether the body was ever invoked. Used by task scheduler code to verify custom schedulers actually ran the task."""
        ...

    s_defaultResultTask: System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult] = ...
    """A cached task for default(TResult)."""

    @property
    def m_result(self) -> System_Threading_Tasks_Task_TResult:
        ...

    @m_result.setter
    def m_result(self, value: System_Threading_Tasks_Task_TResult):
        ...

    @property
    def Result(self) -> System_Threading_Tasks_Task_TResult:
        """Gets the result value of this Task{TResult}."""
        ...

    @property
    def ResultOnSuccess(self) -> System_Threading_Tasks_Task_TResult:
        """Gets the result value of this Task{TResult} once the task has completed successfully."""
        ...

    @overload
    def __init__(self, action: typing.Callable[[], None]) -> None:
        """
        Initializes a new Task with the specified action.
        
        :param action: The delegate that represents the code to execute in the Task.
        """
        ...

    @overload
    def __init__(self, action: typing.Callable[[], None], cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Initializes a new Task with the specified action and System.Threading.CancellationToken.
        
        :param action: The delegate that represents the code to execute in the Task.
        :param cancellationToken: The System.Threading.CancellationToken that will be assigned to the new Task.
        """
        ...

    @overload
    def __init__(self, action: typing.Callable[[], None], creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Initializes a new Task with the specified action and creation options.
        
        :param action: The delegate that represents the code to execute in the task.
        :param creationOptions: The System.Threading.Tasks.TaskCreationOptions used to customize the Task's behavior.
        """
        ...

    @overload
    def __init__(self, action: typing.Callable[[], None], cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Initializes a new Task with the specified action and creation options.
        
        :param action: The delegate that represents the code to execute in the task.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param creationOptions: The System.Threading.Tasks.TaskCreationOptions used to customize the Task's behavior.
        """
        ...

    @overload
    def __init__(self, action: typing.Callable[[System.Object], None], state: typing.Any) -> None:
        """
        Initializes a new Task with the specified action and state.
        
        :param action: The delegate that represents the code to execute in the task.
        :param state: An object representing data to be used by the action.
        """
        ...

    @overload
    def __init__(self, action: typing.Callable[[System.Object], None], state: typing.Any, cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Initializes a new Task with the specified action, state, and options.
        
        :param action: The delegate that represents the code to execute in the task.
        :param state: An object representing data to be used by the action.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        """
        ...

    @overload
    def __init__(self, action: typing.Callable[[System.Object], None], state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Initializes a new Task with the specified action, state, and options.
        
        :param action: The delegate that represents the code to execute in the task.
        :param state: An object representing data to be used by the action.
        :param creationOptions: The System.Threading.Tasks.TaskCreationOptions used to customize the Task's behavior.
        """
        ...

    @overload
    def __init__(self, action: typing.Callable[[System.Object], None], state: typing.Any, cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Initializes a new Task with the specified action, state, and options.
        
        :param action: The delegate that represents the code to execute in the task.
        :param state: An object representing data to be used by the action.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param creationOptions: The System.Threading.Tasks.TaskCreationOptions used to customize the Task's behavior.
        """
        ...

    @overload
    def __init__(self, function: typing.Callable[[], System_Threading_Tasks_Task_TResult]) -> None:
        """
        Initializes a new Task{TResult} with the specified function.
        
        :param function: The delegate that represents the code to execute in the task. When the function has completed, the task's Result property will be set to return the result value of the function.
        """
        ...

    @overload
    def __init__(self, function: typing.Callable[[], System_Threading_Tasks_Task_TResult], cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Initializes a new Task{TResult} with the specified function.
        
        :param function: The delegate that represents the code to execute in the task. When the function has completed, the task's Result property will be set to return the result value of the function.
        :param cancellationToken: The CancellationToken to be assigned to this task.
        """
        ...

    @overload
    def __init__(self, function: typing.Callable[[], System_Threading_Tasks_Task_TResult], creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Initializes a new Task{TResult} with the specified function and creation options.
        
        :param function: The delegate that represents the code to execute in the task. When the function has completed, the task's Result property will be set to return the result value of the function.
        :param creationOptions: The System.Threading.Tasks.TaskCreationOptions used to customize the task's behavior.
        """
        ...

    @overload
    def __init__(self, function: typing.Callable[[], System_Threading_Tasks_Task_TResult], cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Initializes a new Task{TResult} with the specified function and creation options.
        
        :param function: The delegate that represents the code to execute in the task. When the function has completed, the task's Result property will be set to return the result value of the function.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param creationOptions: The System.Threading.Tasks.TaskCreationOptions used to customize the task's behavior.
        """
        ...

    @overload
    def __init__(self, function: typing.Callable[[System.Object], System_Threading_Tasks_Task_TResult], state: typing.Any) -> None:
        """
        Initializes a new Task{TResult} with the specified function and state.
        
        :param function: The delegate that represents the code to execute in the task. When the function has completed, the task's Result property will be set to return the result value of the function.
        :param state: An object representing data to be used by the action.
        """
        ...

    @overload
    def __init__(self, function: typing.Callable[[System.Object], System_Threading_Tasks_Task_TResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Initializes a new Task{TResult} with the specified action, state, and options.
        
        :param function: The delegate that represents the code to execute in the task. When the function has completed, the task's Result property will be set to return the result value of the function.
        :param state: An object representing data to be used by the function.
        :param cancellationToken: The CancellationToken to be assigned to the new task.
        """
        ...

    @overload
    def __init__(self, function: typing.Callable[[System.Object], System_Threading_Tasks_Task_TResult], state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Initializes a new Task{TResult} with the specified action, state, and options.
        
        :param function: The delegate that represents the code to execute in the task. When the function has completed, the task's Result property will be set to return the result value of the function.
        :param state: An object representing data to be used by the function.
        :param creationOptions: The System.Threading.Tasks.TaskCreationOptions used to customize the task's behavior.
        """
        ...

    @overload
    def __init__(self, function: typing.Callable[[System.Object], System_Threading_Tasks_Task_TResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Initializes a new Task{TResult} with the specified action, state, and options.
        
        :param function: The delegate that represents the code to execute in the task. When the function has completed, the task's Result property will be set to return the result value of the function.
        :param state: An object representing data to be used by the function.
        :param cancellationToken: The CancellationToken to be assigned to the new task.
        :param creationOptions: The System.Threading.Tasks.TaskCreationOptions used to customize the task's behavior.
        """
        ...

    @overload
    def ConfigureAwait(self, continueOnCapturedContext: bool) -> System.Runtime.CompilerServices.ConfiguredTaskAwaitable:
        """
        Configures an awaiter used to await this System.Threading.Tasks.Task.
        
        :param continueOnCapturedContext: true to attempt to marshal the continuation back to the original context captured; otherwise, false.
        :returns: An object used to await this task.
        """
        ...

    @overload
    def ConfigureAwait(self, continueOnCapturedContext: bool) -> System.Runtime.CompilerServices.ConfiguredTaskAwaitable[System_Threading_Tasks_Task_TResult]:
        """
        Configures an awaiter used to await this System.Threading.Tasks.Task{TResult}.
        
        :param continueOnCapturedContext: true to attempt to marshal the continuation back to the original context captured; otherwise, false.
        :returns: An object used to await this task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task], None]) -> System.Threading.Tasks.Task:
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task], None], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationAction: An action to run when the Task completes. When run, the delegate will be passed the completed task as an argument.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task], None], scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationAction: An action to run when the Task completes.  When run, the delegate will be passed the completed task as an argument.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task], None], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationAction: An action to run when the Task completes. When run, the delegate will be passed the completed task as an argument.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task], None], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationAction: An action to run when the Task completes. When run, the delegate will be passed the completed task as an argument.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task, System.Object], None], state: typing.Any) -> System.Threading.Tasks.Task:
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task, System.Object], None], state: typing.Any, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationAction: An action to run when the Task completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation action.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task, System.Object], None], state: typing.Any, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationAction: An action to run when the Task completes.  When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation action.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task, System.Object], None], state: typing.Any, continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationAction: An action to run when the Task completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation action.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task, System.Object], None], state: typing.Any, cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationAction: An action to run when the Task completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation action.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_Task_ContinueWith_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_Task_ContinueWith_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationFunction: A function to run when the Task completes. When run, the delegate will be passed the completed task as an argument.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :returns: A new continuation Task{TResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_Task_ContinueWith_TResult], scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationFunction: A function to run when the Task completes.  When run, the delegate will be passed the completed task as an argument.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task{TResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_Task_ContinueWith_TResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationFunction: A function to run when the Task completes. When run, the delegate will be passed the completed task as an argument.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :returns: A new continuation Task{TResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task], System_Threading_Tasks_Task_ContinueWith_TResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationFunction: A function to run when the Task completes. When run, the delegate will be passed the completed task as an argument.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task{TResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task, System.Object], System_Threading_Tasks_Task_ContinueWith_TResult], state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task, System.Object], System_Threading_Tasks_Task_ContinueWith_TResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationFunction: A function to run when the Task completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation function.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :returns: A new continuation Task{TResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task, System.Object], System_Threading_Tasks_Task_ContinueWith_TResult], state: typing.Any, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationFunction: A function to run when the Task completes.  When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation function.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task{TResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task, System.Object], System_Threading_Tasks_Task_ContinueWith_TResult], state: typing.Any, continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationFunction: A function to run when the Task completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation function.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :returns: A new continuation Task{TResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task, System.Object], System_Threading_Tasks_Task_ContinueWith_TResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TResult]:
        """
        Creates a continuation that executes when the target Task completes.
        
        :param continuationFunction: A function to run when the Task completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation function.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task{TResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], None]) -> System.Threading.Tasks.Task:
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], None], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationAction: An action to run when the Task{TResult} completes. When run, the delegate will be passed the completed task as an argument.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], None], scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationAction: An action to run when the Task{TResult} completes. When run, the delegate will be passed the completed task as an argument.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], None], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationAction: An action to run when the Task{TResult} completes. When run, the delegate will be passed the completed task as an argument.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], None], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationAction: An action to run when the Task{TResult} completes. When run, the delegate will be passed the completed task as an argument.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], None], state: typing.Any) -> System.Threading.Tasks.Task:
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], None], state: typing.Any, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationAction: An action to run when the Task{TResult} completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation action.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], None], state: typing.Any, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationAction: An action to run when the Task{TResult} completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation action.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], None], state: typing.Any, continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationAction: An action to run when the Task{TResult} completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation action.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationAction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], None], state: typing.Any, cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationAction: An action to run when the Task{TResult} completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation action.
        :param cancellationToken: The CancellationToken that will be assigned to the new continuation task.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], System_Threading_Tasks_Task_ContinueWith_TNewResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], System_Threading_Tasks_Task_ContinueWith_TNewResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationFunction: A function to run when the Task{TResult} completes. When run, the delegate will be passed the completed task as an argument.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :returns: A new continuation Task{TNewResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], System_Threading_Tasks_Task_ContinueWith_TNewResult], scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationFunction: A function to run when the Task{TResult} completes.  When run, the delegate will be passed the completed task as an argument.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task{TNewResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], System_Threading_Tasks_Task_ContinueWith_TNewResult], continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationFunction: A function to run when the Task{TResult} completes. When run, the delegate will be passed the completed task as an argument.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :returns: A new continuation Task{TNewResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]], System_Threading_Tasks_Task_ContinueWith_TNewResult], cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationFunction: A function to run when the Task{TResult} completes. When run, the delegate will be passed as an argument this completed task.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task{TNewResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], System_Threading_Tasks_Task_ContinueWith_TNewResult], state: typing.Any) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], System_Threading_Tasks_Task_ContinueWith_TNewResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationFunction: A function to run when the Task{TResult} completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation function.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :returns: A new continuation Task{TNewResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], System_Threading_Tasks_Task_ContinueWith_TNewResult], state: typing.Any, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationFunction: A function to run when the Task{TResult} completes.  When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation function.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task{TNewResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], System_Threading_Tasks_Task_ContinueWith_TNewResult], state: typing.Any, continuationOptions: System.Threading.Tasks.TaskContinuationOptions) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationFunction: A function to run when the Task{TResult} completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation function.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :returns: A new continuation Task{TNewResult}.
        """
        ...

    @overload
    def ContinueWith(self, continuationFunction: typing.Callable[[System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult], System.Object], System_Threading_Tasks_Task_ContinueWith_TNewResult], state: typing.Any, cancellationToken: System.Threading.CancellationToken, continuationOptions: System.Threading.Tasks.TaskContinuationOptions, scheduler: System.Threading.Tasks.TaskScheduler) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_ContinueWith_TNewResult]:
        """
        Creates a continuation that executes when the target Task{TResult} completes.
        
        :param continuationFunction: A function to run when the Task{TResult} completes. When run, the delegate will be passed the completed task and the caller-supplied state object as arguments.
        :param state: An object representing data to be used by the continuation function.
        :param cancellationToken: The CancellationToken that will be assigned to the new task.
        :param continuationOptions: Options for when the continuation is scheduled and how it behaves. This includes criteria, such as System.Threading.Tasks.TaskContinuationOptions.OnlyOnCanceled, as well as execution options, such as System.Threading.Tasks.TaskContinuationOptions.ExecuteSynchronously.
        :param scheduler: The TaskScheduler to associate with the continuation task and to use for its execution.
        :returns: A new continuation Task{TNewResult}.
        """
        ...

    @staticmethod
    @overload
    def Delay(delay: datetime.timedelta) -> System.Threading.Tasks.Task:
        ...

    @staticmethod
    @overload
    def Delay(delay: datetime.timedelta, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a Task that will complete after a time delay.
        
        :param delay: The time span to wait before completing the returned Task
        :param cancellationToken: The cancellation token that will be checked prior to completing the returned Task
        :returns: A Task that represents the time delay.
        """
        ...

    @staticmethod
    @overload
    def Delay(millisecondsDelay: int) -> System.Threading.Tasks.Task:
        """
        Creates a Task that will complete after a time delay.
        
        :param millisecondsDelay: The number of milliseconds to wait before completing the returned Task
        :returns: A Task that represents the time delay.
        """
        ...

    @staticmethod
    @overload
    def Delay(millisecondsDelay: int, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a Task that will complete after a time delay.
        
        :param millisecondsDelay: The number of milliseconds to wait before completing the returned Task
        :param cancellationToken: The cancellation token that will be checked prior to completing the returned Task
        :returns: A Task that represents the time delay.
        """
        ...

    @overload
    def Dispose(self) -> None:
        ...

    @overload
    def Dispose(self, disposing: bool) -> None:
        """
        Disposes the Task, releasing all of its unmanaged resources.
        
        This method is protected.
        
        :param disposing: A Boolean value that indicates whether this method is being called due to a call to Dispose().
        """
        ...

    @staticmethod
    @overload
    def FromCanceled(cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Creates a Task that's completed due to cancellation with the specified token.
        
        :param cancellationToken: The token with which to complete the task.
        :returns: The canceled task.
        """
        ...

    @staticmethod
    @overload
    def FromCanceled(cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_FromCanceled_TResult]:
        """
        Creates a Task{TResult} that's completed due to cancellation with the specified token.
        
        :param cancellationToken: The token with which to complete the task.
        :returns: The canceled task.
        """
        ...

    @staticmethod
    @overload
    def FromException(exception: System.Exception) -> System.Threading.Tasks.Task:
        """
        Creates a Task{TResult} that's completed exceptionally with the specified exception.
        
        :param exception: The exception with which to complete the task.
        :returns: The faulted task.
        """
        ...

    @staticmethod
    @overload
    def FromException(exception: System.Exception) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_FromException_TResult]:
        """
        Creates a Task{TResult} that's completed exceptionally with the specified exception.
        
        :param exception: The exception with which to complete the task.
        :returns: The faulted task.
        """
        ...

    @staticmethod
    def FromResult(result: System_Threading_Tasks_Task_FromResult_TResult) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_FromResult_TResult]:
        ...

    @overload
    def GetAwaiter(self) -> System.Runtime.CompilerServices.TaskAwaiter:
        ...

    @overload
    def GetAwaiter(self) -> System.Runtime.CompilerServices.TaskAwaiter[System_Threading_Tasks_Task_TResult]:
        ...

    @staticmethod
    @overload
    def Run(action: typing.Callable[[], None]) -> System.Threading.Tasks.Task:
        ...

    @staticmethod
    @overload
    def Run(action: typing.Callable[[], None], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Queues the specified work to run on the ThreadPool and returns a Task handle for that work.
        
        :param action: The work to execute asynchronously
        :param cancellationToken: A cancellation token that should be used to cancel the work
        :returns: A Task that represents the work queued to execute in the ThreadPool.
        """
        ...

    @staticmethod
    @overload
    def Run(function: typing.Callable[[], System_Threading_Tasks_Task_Run_TResult]) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_Run_TResult]:
        """
        Queues the specified work to run on the ThreadPool and returns a Task(TResult) handle for that work.
        
        :param function: The work to execute asynchronously
        :returns: A Task(TResult) that represents the work queued to execute in the ThreadPool.
        """
        ...

    @staticmethod
    @overload
    def Run(function: typing.Callable[[], System_Threading_Tasks_Task_Run_TResult], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_Run_TResult]:
        """
        Queues the specified work to run on the ThreadPool and returns a Task(TResult) handle for that work.
        
        :param function: The work to execute asynchronously
        :param cancellationToken: A cancellation token that should be used to cancel the work
        :returns: A Task(TResult) that represents the work queued to execute in the ThreadPool.
        """
        ...

    @staticmethod
    @overload
    def Run(function: typing.Callable[[], System.Threading.Tasks.Task]) -> System.Threading.Tasks.Task:
        """
        Queues the specified work to run on the ThreadPool and returns a proxy for the
        Task returned by .
        
        :param function: The work to execute asynchronously
        :returns: A Task that represents a proxy for the Task returned by .
        """
        ...

    @staticmethod
    @overload
    def Run(function: typing.Callable[[], System.Threading.Tasks.Task], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Queues the specified work to run on the ThreadPool and returns a proxy for the
        Task returned by .
        
        :param function: The work to execute asynchronously
        :param cancellationToken: A cancellation token that should be used to cancel the work
        :returns: A Task that represents a proxy for the Task returned by .
        """
        ...

    @staticmethod
    @overload
    def Run(function: typing.Callable[[], System.Threading.Tasks.Task[System_Threading_Tasks_Task_Run_TResult]]) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_Run_TResult]:
        """
        Queues the specified work to run on the ThreadPool and returns a proxy for the
        Task(TResult) returned by .
        
        :param function: The work to execute asynchronously
        :returns: A Task(TResult) that represents a proxy for the Task(TResult) returned by .
        """
        ...

    @staticmethod
    @overload
    def Run(function: typing.Callable[[], System.Threading.Tasks.Task[System_Threading_Tasks_Task_Run_TResult]], cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_Run_TResult]:
        """
        Queues the specified work to run on the ThreadPool and returns a proxy for the
        Task(TResult) returned by .
        
        :param function: The work to execute asynchronously
        :param cancellationToken: A cancellation token that should be used to cancel the work
        :returns: A Task(TResult) that represents a proxy for the Task(TResult) returned by .
        """
        ...

    @overload
    def RunSynchronously(self) -> None:
        """Runs the Task synchronously on the current System.Threading.Tasks.TaskScheduler."""
        ...

    @overload
    def RunSynchronously(self, scheduler: System.Threading.Tasks.TaskScheduler) -> None:
        """
        Runs the Task synchronously on the System.Threading.Tasks.TaskScheduler provided.
        
        :param scheduler: The scheduler on which to attempt to run this task inline.
        """
        ...

    @overload
    def Start(self) -> None:
        """Starts the Task, scheduling it for execution to the current System.Threading.Tasks.TaskScheduler."""
        ...

    @overload
    def Start(self, scheduler: System.Threading.Tasks.TaskScheduler) -> None:
        """
        Starts the Task, scheduling it for execution to the specified System.Threading.Tasks.TaskScheduler.
        
        :param scheduler: The System.Threading.Tasks.TaskScheduler with which to associate and execute this task.
        """
        ...

    @overload
    def Wait(self) -> None:
        ...

    @overload
    def Wait(self, timeout: datetime.timedelta) -> bool:
        """
        Waits for the Task to complete execution.
        
        :param timeout: A System.TimeSpan that represents the number of milliseconds to wait, or a System.TimeSpan that represents -1 milliseconds to wait indefinitely.
        :returns: true if the Task completed execution within the allotted time; otherwise, false.
        """
        ...

    @overload
    def Wait(self, timeout: datetime.timedelta, cancellationToken: System.Threading.CancellationToken) -> bool:
        """
        Waits for the Task to complete execution.
        
        :param timeout: The time to wait, or Timeout.InfiniteTimeSpan to wait indefinitely
        :param cancellationToken: A CancellationToken to observe while waiting for the task to complete.
        :returns: true if the Task completed execution within the allotted time; otherwise, false.
        """
        ...

    @overload
    def Wait(self, cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Waits for the Task to complete execution.
        
        :param cancellationToken: A CancellationToken to observe while waiting for the task to complete.
        """
        ...

    @overload
    def Wait(self, millisecondsTimeout: int) -> bool:
        """
        Waits for the Task to complete execution.
        
        :param millisecondsTimeout: The number of milliseconds to wait, or System.Threading.Timeout.Infinite (-1) to wait indefinitely.
        :returns: true if the Task completed execution within the allotted time; otherwise, false.
        """
        ...

    @overload
    def Wait(self, millisecondsTimeout: int, cancellationToken: System.Threading.CancellationToken) -> bool:
        """
        Waits for the Task to complete execution.
        
        :param millisecondsTimeout: The number of milliseconds to wait, or System.Threading.Timeout.Infinite (-1) to wait indefinitely.
        :param cancellationToken: A CancellationToken to observe while waiting for the task to complete.
        :returns: true if the Task completed execution within the allotted time; otherwise, false.
        """
        ...

    @staticmethod
    @overload
    def WaitAll(*tasks: System.Threading.Tasks.Task) -> None:
        ...

    @staticmethod
    @overload
    def WaitAll(tasks: typing.List[System.Threading.Tasks.Task], timeout: datetime.timedelta) -> bool:
        """
        Waits for all of the provided Task objects to complete execution.
        
        :param tasks: An array of Task instances on which to wait.
        :param timeout: A System.TimeSpan that represents the number of milliseconds to wait, or a System.TimeSpan that represents -1 milliseconds to wait indefinitely.
        :returns: true if all of the Task instances completed execution within the allotted time; otherwise, false.
        """
        ...

    @staticmethod
    @overload
    def WaitAll(tasks: typing.List[System.Threading.Tasks.Task], millisecondsTimeout: int) -> bool:
        """
        Waits for all of the provided Task objects to complete execution.
        
        :param tasks: An array of Task instances on which to wait.
        :param millisecondsTimeout: The number of milliseconds to wait, or System.Threading.Timeout.Infinite (-1) to wait indefinitely.
        :returns: true if all of the Task instances completed execution within the allotted time; otherwise, false.
        """
        ...

    @staticmethod
    @overload
    def WaitAll(tasks: typing.List[System.Threading.Tasks.Task], cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Waits for all of the provided Task objects to complete execution.
        
        :param tasks: An array of Task instances on which to wait.
        :param cancellationToken: A CancellationToken to observe while waiting for the tasks to complete.
        """
        ...

    @staticmethod
    @overload
    def WaitAll(tasks: typing.List[System.Threading.Tasks.Task], millisecondsTimeout: int, cancellationToken: System.Threading.CancellationToken) -> bool:
        """
        Waits for all of the provided Task objects to complete execution.
        
        :param tasks: An array of Task instances on which to wait.
        :param millisecondsTimeout: The number of milliseconds to wait, or System.Threading.Timeout.Infinite (-1) to wait indefinitely.
        :param cancellationToken: A CancellationToken to observe while waiting for the tasks to complete.
        :returns: true if all of the Task instances completed execution within the allotted time; otherwise, false.
        """
        ...

    @staticmethod
    @overload
    def WaitAny(*tasks: System.Threading.Tasks.Task) -> int:
        """
        Waits for any of the provided Task objects to complete execution.
        
        :param tasks: An array of Task instances on which to wait.
        :returns: The index of the completed task in the  array argument.
        """
        ...

    @staticmethod
    @overload
    def WaitAny(tasks: typing.List[System.Threading.Tasks.Task], timeout: datetime.timedelta) -> int:
        """
        Waits for any of the provided Task objects to complete execution.
        
        :param tasks: An array of Task instances on which to wait.
        :param timeout: A System.TimeSpan that represents the number of milliseconds to wait, or a System.TimeSpan that represents -1 milliseconds to wait indefinitely.
        :returns: The index of the completed task in the  array argument, or -1 if the timeout occurred.
        """
        ...

    @staticmethod
    @overload
    def WaitAny(tasks: typing.List[System.Threading.Tasks.Task], cancellationToken: System.Threading.CancellationToken) -> int:
        """
        Waits for any of the provided Task objects to complete execution.
        
        :param tasks: An array of Task instances on which to wait.
        :param cancellationToken: A CancellationToken to observe while waiting for a task to complete.
        :returns: The index of the completed task in the  array argument.
        """
        ...

    @staticmethod
    @overload
    def WaitAny(tasks: typing.List[System.Threading.Tasks.Task], millisecondsTimeout: int) -> int:
        """
        Waits for any of the provided Task objects to complete execution.
        
        :param tasks: An array of Task instances on which to wait.
        :param millisecondsTimeout: The number of milliseconds to wait, or System.Threading.Timeout.Infinite (-1) to wait indefinitely.
        :returns: The index of the completed task in the  array argument, or -1 if the timeout occurred.
        """
        ...

    @staticmethod
    @overload
    def WaitAny(tasks: typing.List[System.Threading.Tasks.Task], millisecondsTimeout: int, cancellationToken: System.Threading.CancellationToken) -> int:
        """
        Waits for any of the provided Task objects to complete execution.
        
        :param tasks: An array of Task instances on which to wait.
        :param millisecondsTimeout: The number of milliseconds to wait, or System.Threading.Timeout.Infinite (-1) to wait indefinitely.
        :param cancellationToken: A CancellationToken to observe while waiting for a task to complete.
        :returns: The index of the completed task in the  array argument, or -1 if the timeout occurred.
        """
        ...

    @overload
    def WaitAsync(self, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Gets a Task that will complete when this Task completes or when the specified CancellationToken has cancellation requested.
        
        :param cancellationToken: The CancellationToken to monitor for a cancellation request.
        :returns: The Task representing the asynchronous wait.  It may or may not be the same instance as the current instance.
        """
        ...

    @overload
    def WaitAsync(self, timeout: datetime.timedelta) -> System.Threading.Tasks.Task:
        """
        Gets a Task that will complete when this Task completes or when the specified timeout expires.
        
        :param timeout: The timeout after which the Task should be faulted with a TimeoutException if it hasn't otherwise completed.
        :returns: The Task representing the asynchronous wait.  It may or may not be the same instance as the current instance.
        """
        ...

    @overload
    def WaitAsync(self, timeout: datetime.timedelta, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task:
        """
        Gets a Task that will complete when this Task completes, when the specified timeout expires, or when the specified CancellationToken has cancellation requested.
        
        :param timeout: The timeout after which the Task should be faulted with a TimeoutException if it hasn't otherwise completed.
        :param cancellationToken: The CancellationToken to monitor for a cancellation request.
        :returns: The Task representing the asynchronous wait.  It may or may not be the same instance as the current instance.
        """
        ...

    @overload
    def WaitAsync(self, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]:
        ...

    @overload
    def WaitAsync(self, timeout: datetime.timedelta) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]:
        """
        Gets a Task{TResult} that will complete when this Task{TResult} completes or when the specified timeout expires.
        
        :param timeout: The timeout after which the Task should be faulted with a TimeoutException if it hasn't otherwise completed.
        :returns: The Task{TResult} representing the asynchronous wait.  It may or may not be the same instance as the current instance.
        """
        ...

    @overload
    def WaitAsync(self, timeout: datetime.timedelta, cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.Task[System_Threading_Tasks_Task_TResult]:
        """
        Gets a Task{TResult} that will complete when this Task{TResult} completes, when the specified timeout expires, or when the specified CancellationToken has cancellation requested.
        
        :param timeout: The timeout after which the Task should be faulted with a TimeoutException if it hasn't otherwise completed.
        :param cancellationToken: The CancellationToken to monitor for a cancellation request.
        :returns: The Task{TResult} representing the asynchronous wait.  It may or may not be the same instance as the current instance.
        """
        ...

    @staticmethod
    @overload
    def WhenAll(tasks: System.Collections.Generic.IEnumerable[System.Threading.Tasks.Task]) -> System.Threading.Tasks.Task:
        ...

    @staticmethod
    @overload
    def WhenAll(*tasks: System.Threading.Tasks.Task) -> System.Threading.Tasks.Task:
        """
        Creates a task that will complete when all of the supplied tasks have completed.
        
        :param tasks: The tasks to wait on for completion.
        :returns: A task that represents the completion of all of the supplied tasks.
        """
        ...

    @staticmethod
    @overload
    def WhenAll(tasks: System.Collections.Generic.IEnumerable[System.Threading.Tasks.Task[System_Threading_Tasks_Task_WhenAll_TResult]]) -> System.Threading.Tasks.Task[typing.List[System_Threading_Tasks_Task_WhenAll_TResult]]:
        """
        Creates a task that will complete when all of the supplied tasks have completed.
        
        :param tasks: The tasks to wait on for completion.
        :returns: A task that represents the completion of all of the supplied tasks.
        """
        ...

    @staticmethod
    @overload
    def WhenAll(*tasks: System.Threading.Tasks.Task[System_Threading_Tasks_Task_WhenAll_TResult]) -> System.Threading.Tasks.Task[typing.List[System_Threading_Tasks_Task_WhenAll_TResult]]:
        """
        Creates a task that will complete when all of the supplied tasks have completed.
        
        :param tasks: The tasks to wait on for completion.
        :returns: A task that represents the completion of all of the supplied tasks.
        """
        ...

    @staticmethod
    @overload
    def WhenAny(*tasks: System.Threading.Tasks.Task) -> System.Threading.Tasks.Task[System.Threading.Tasks.Task]:
        ...

    @staticmethod
    @overload
    def WhenAny(task1: System.Threading.Tasks.Task, task2: System.Threading.Tasks.Task) -> System.Threading.Tasks.Task[System.Threading.Tasks.Task]:
        """
        Creates a task that will complete when either of the supplied tasks have completed.
        
        :param task1: The first task to wait on for completion.
        :param task2: The second task to wait on for completion.
        :returns: A task that represents the completion of one of the supplied tasks.  The return Task's Result is the task that completed.
        """
        ...

    @staticmethod
    @overload
    def WhenAny(tasks: System.Collections.Generic.IEnumerable[System.Threading.Tasks.Task]) -> System.Threading.Tasks.Task[System.Threading.Tasks.Task]:
        """
        Creates a task that will complete when any of the supplied tasks have completed.
        
        :param tasks: The tasks to wait on for completion.
        :returns: A task that represents the completion of one of the supplied tasks.  The return Task's Result is the task that completed.
        """
        ...

    @staticmethod
    @overload
    def WhenAny(*tasks: System.Threading.Tasks.Task[System_Threading_Tasks_Task_WhenAny_TResult]) -> System.Threading.Tasks.Task[System.Threading.Tasks.Task[System_Threading_Tasks_Task_WhenAny_TResult]]:
        """
        Creates a task that will complete when any of the supplied tasks have completed.
        
        :param tasks: The tasks to wait on for completion.
        :returns: A task that represents the completion of one of the supplied tasks.  The return Task's Result is the task that completed.
        """
        ...

    @staticmethod
    @overload
    def WhenAny(task1: System.Threading.Tasks.Task[System_Threading_Tasks_Task_WhenAny_TResult], task2: System.Threading.Tasks.Task[System_Threading_Tasks_Task_WhenAny_TResult]) -> System.Threading.Tasks.Task[System.Threading.Tasks.Task[System_Threading_Tasks_Task_WhenAny_TResult]]:
        """
        Creates a task that will complete when either of the supplied tasks have completed.
        
        :param task1: The first task to wait on for completion.
        :param task2: The second task to wait on for completion.
        :returns: A task that represents the completion of one of the supplied tasks.  The return Task's Result is the task that completed.
        """
        ...

    @staticmethod
    @overload
    def WhenAny(tasks: System.Collections.Generic.IEnumerable[System.Threading.Tasks.Task[System_Threading_Tasks_Task_WhenAny_TResult]]) -> System.Threading.Tasks.Task[System.Threading.Tasks.Task[System_Threading_Tasks_Task_WhenAny_TResult]]:
        """
        Creates a task that will complete when any of the supplied tasks have completed.
        
        :param tasks: The tasks to wait on for completion.
        :returns: A task that represents the completion of one of the supplied tasks.  The return Task's Result is the task that completed.
        """
        ...

    @staticmethod
    def Yield() -> System.Runtime.CompilerServices.YieldAwaitable:
        """
        Creates an awaitable that asynchronously yields back to the current context when awaited.
        
        :returns: A context that, when awaited, will asynchronously transition back into the current context at the time of the await. If the current SynchronizationContext is non-null, that is treated as the current context. Otherwise, TaskScheduler.Current is treated as the current context.
        """
        ...


class UnobservedTaskExceptionEventArgs(System.EventArgs):
    """
    Provides data for the event that is raised when a faulted System.Threading.Tasks.Task's
    exception goes unobserved.
    """

    @property
    def m_observed(self) -> bool:
        ...

    @m_observed.setter
    def m_observed(self, value: bool):
        ...

    @property
    def Observed(self) -> bool:
        """Gets whether this exception has been marked as "observed.\""""
        ...

    @property
    def Exception(self) -> System.AggregateException:
        """The Exception that went unobserved."""
        ...

    def __init__(self, exception: System.AggregateException) -> None:
        """
        Initializes a new instance of the UnobservedTaskExceptionEventArgs class
        with the unobserved exception.
        
        :param exception: The Exception that has gone unobserved.
        """
        ...

    def SetObserved(self) -> None:
        """
        Marks the Exception as "observed," thus preventing it
        from triggering exception escalation policy which, by default, terminates the process.
        """
        ...


class TaskScheduler(System.Object, metaclass=abc.ABCMeta):
    """Represents an abstract scheduler for tasks."""

    @property
    def MaximumConcurrencyLevel(self) -> int:
        """
        Indicates the maximum concurrency level this
        TaskScheduler  is able to support.
        """
        ...

    @property
    def RequiresAtomicStartTransition(self) -> bool:
        """
        Indicates whether this is a custom scheduler, in which case the safe code paths will be taken upon task entry
        using a CAS to transition from queued state to executing.
        """
        ...

    s_taskSchedulerIdCounter: int

    Default: System.Threading.Tasks.TaskScheduler
    """Gets the default System.Threading.Tasks.TaskScheduler instance."""

    Current: System.Threading.Tasks.TaskScheduler
    """
    Gets the System.Threading.Tasks.TaskScheduler
    associated with the currently executing task.
    """

    InternalCurrent: System.Threading.Tasks.TaskScheduler
    """
    Gets the System.Threading.Tasks.TaskScheduler
    associated with the currently executing task.
    """

    @property
    def Id(self) -> int:
        """Gets the unique ID for this TaskScheduler."""
        ...

    UnobservedTaskException: _EventContainer[typing.Callable[[System.Object, System.Threading.Tasks.UnobservedTaskExceptionEventArgs], None], None]

    def __init__(self) -> None:
        """This method is protected."""
        ...

    @staticmethod
    def FromCurrentSynchronizationContext() -> System.Threading.Tasks.TaskScheduler:
        """
        Creates a TaskScheduler
        associated with the current System.Threading.SynchronizationContext.
        
        :returns: A TaskScheduler associated with the current System.Threading.SynchronizationContext, as determined by System.Threading.SynchronizationContext.Current.
        """
        ...

    def GetScheduledTasks(self) -> System.Collections.Generic.IEnumerable[System.Threading.Tasks.Task]:
        """
        Generates an enumerable of System.Threading.Tasks.Task instances
        currently queued to the scheduler waiting to be executed.
        
        This method is protected.
        
        :returns: An enumerable that allows traversal of tasks currently queued to this scheduler.
        """
        ...

    def TryExecuteTask(self, task: System.Threading.Tasks.Task) -> bool:
        """
        Attempts to execute the provided System.Threading.Tasks.Task
        on this scheduler.
        
        This method is protected.
        
        :param task: A System.Threading.Tasks.Task object to be executed.
        :returns: A Boolean that is true if  was successfully executed, false if it was not. A common reason for execution failure is that the task had previously been executed or is in the process of being executed by another thread.
        """
        ...

    def TryExecuteTaskInline(self, task: System.Threading.Tasks.Task, taskWasPreviouslyQueued: bool) -> bool:
        """
        Determines whether the provided System.Threading.Tasks.Task
        can be executed synchronously in this call, and if it can, executes it.
        
        This method is protected.
        
        :param task: The System.Threading.Tasks.Task to be executed.
        :param taskWasPreviouslyQueued: A Boolean denoting whether or not task has previously been queued. If this parameter is True, then the task may have been previously queued (scheduled); if False, then the task is known not to have been queued, and this call is being made in order to execute the task inline without queueing it.
        :returns: A Boolean value indicating whether the task was executed inline.
        """
        ...


class TaskAsyncEnumerableExtensions(System.Object):
    """Provides a set of static methods for configuring Task-related behaviors on asynchronous enumerables and disposables."""

    @staticmethod
    @overload
    def ConfigureAwait(source: System.IAsyncDisposable, continueOnCapturedContext: bool) -> System.Runtime.CompilerServices.ConfiguredAsyncDisposable:
        """
        Configures how awaits on the tasks returned from an async disposable will be performed.
        
        :param source: The source async disposable.
        :param continueOnCapturedContext: Whether to capture and marshal back to the current context.
        :returns: The configured async disposable.
        """
        ...

    @staticmethod
    @overload
    def ConfigureAwait(source: System.Collections.Generic.IAsyncEnumerable[System_Threading_Tasks_TaskAsyncEnumerableExtensions_ConfigureAwait_T], continueOnCapturedContext: bool) -> System.Runtime.CompilerServices.ConfiguredCancelableAsyncEnumerable[System_Threading_Tasks_TaskAsyncEnumerableExtensions_ConfigureAwait_T]:
        """
        Configures how awaits on the tasks returned from an async iteration will be performed.
        
        :param source: The source enumerable being iterated.
        :param continueOnCapturedContext: Whether to capture and marshal back to the current context.
        :returns: The configured enumerable.
        """
        ...

    @staticmethod
    def ToBlockingEnumerable(source: System.Collections.Generic.IAsyncEnumerable[System_Threading_Tasks_TaskAsyncEnumerableExtensions_ToBlockingEnumerable_T], cancellationToken: System.Threading.CancellationToken = ...) -> System.Collections.Generic.IEnumerable[System_Threading_Tasks_TaskAsyncEnumerableExtensions_ToBlockingEnumerable_T]:
        """
        Converts an IAsyncEnumerable{T} instance into an IEnumerable{T} that enumerates elements in a blocking manner.
        
        :param source: The source enumerable being iterated.
        :param cancellationToken: The CancellationToken to use.
        :returns: An IEnumerable{T} instance that enumerates the source IAsyncEnumerable{T} in a blocking manner.
        """
        ...

    @staticmethod
    def WithCancellation(source: System.Collections.Generic.IAsyncEnumerable[System_Threading_Tasks_TaskAsyncEnumerableExtensions_WithCancellation_T], cancellationToken: System.Threading.CancellationToken) -> System.Runtime.CompilerServices.ConfiguredCancelableAsyncEnumerable[System_Threading_Tasks_TaskAsyncEnumerableExtensions_WithCancellation_T]:
        """
        Sets the CancellationToken to be passed to IAsyncEnumerable{T}.GetAsyncEnumerator(CancellationToken) when iterating.
        
        :param source: The source enumerable being iterated.
        :param cancellationToken: The CancellationToken to use.
        :returns: The configured enumerable.
        """
        ...


class TaskExtensions(System.Object):
    """Provides a set of static methods for working with specific kinds of Task instances."""

    @staticmethod
    @overload
    def Unwrap(task: System.Threading.Tasks.Task[System.Threading.Tasks.Task]) -> System.Threading.Tasks.Task:
        """
        Creates a proxy Task that represents the asynchronous operation of a Task{Task}.
        
        :param task: The Task{Task} to unwrap.
        :returns: A Task that represents the asynchronous operation of the provided Task{Task}.
        """
        ...

    @staticmethod
    @overload
    def Unwrap(task: System.Threading.Tasks.Task[System.Threading.Tasks.Task[System_Threading_Tasks_TaskExtensions_Unwrap_TResult]]) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskExtensions_Unwrap_TResult]:
        """
        Creates a proxy Task{TResult} that represents the asynchronous operation of a wrapped Task{TResult}.
        
        :param task: The wrapped Task{TResult} to unwrap.
        :returns: A Task{TResult} that represents the asynchronous operation of the provided wrapped Task{TResult}.
        """
        ...


class TaskStatus(System.Enum):
    """Represents the current stage in the lifecycle of a Task."""

    Created = 0
    """The task has been initialized but has not yet been scheduled."""

    WaitingForActivation = 1
    """The task is waiting to be activated and scheduled internally by the .NET Framework infrastructure."""

    WaitingToRun = 2
    """The task has been scheduled for execution but has not yet begun executing."""

    Running = 3
    """The task is running but has not yet completed."""

    WaitingForChildrenToComplete = 4

    RanToCompletion = 5
    """The task completed execution successfully."""

    Canceled = 6
    """
    The task acknowledged cancellation by throwing an OperationCanceledException with its own CancellationToken
    while the token was in signaled state, or the task's CancellationToken was already signaled before the
    task started executing.
    """

    Faulted = 7
    """The task completed due to an unhandled exception."""


class TaskSchedulerException(System.Exception):
    """
    Represents an exception used to communicate an invalid operation by a
    System.Threading.Tasks.TaskScheduler.
    """

    @overload
    def __init__(self) -> None:
        """Initializes a new instance of the System.Threading.Tasks.TaskSchedulerException class."""
        ...

    @overload
    def __init__(self, message: str) -> None:
        """
        Initializes a new instance of the System.Threading.Tasks.TaskSchedulerException
        class with a specified error message.
        
        :param message: The error message that explains the reason for the exception.
        """
        ...

    @overload
    def __init__(self, innerException: System.Exception) -> None:
        """
        Initializes a new instance of the System.Threading.Tasks.TaskSchedulerException
        class using the default error message and a reference to the inner exception that is the cause of
        this exception.
        
        :param innerException: The exception that is the cause of the current exception.
        """
        ...

    @overload
    def __init__(self, message: str, innerException: System.Exception) -> None:
        """
        Initializes a new instance of the System.Threading.Tasks.TaskSchedulerException
        class with a specified error message and a reference to the inner exception that is the cause of
        this exception.
        
        :param message: The error message that explains the reason for the exception.
        :param innerException: The exception that is the cause of the current exception.
        """
        ...

    @overload
    def __init__(self, info: System.Runtime.Serialization.SerializationInfo, context: System.Runtime.Serialization.StreamingContext) -> None:
        """
        Initializes a new instance of the System.Threading.Tasks.TaskSchedulerException
        class with serialized data.
        
        This method is protected.
        
        :param info: The System.Runtime.Serialization.SerializationInfo that holds the serialized object data about the exception being thrown.
        :param context: The System.Runtime.Serialization.StreamingContext that contains contextual information about the source or destination.
        """
        ...


class ValueTask(typing.Generic[System_Threading_Tasks_ValueTask_TResult], System.IEquatable[System_Threading_Tasks_ValueTask]):
    """Provides a value type that can represent a synchronously available value or a task object."""

    @property
    def _obj(self) -> System.Object:
        """null if representing a successful synchronous completion, otherwise a Task or a IValueTaskSource."""
        ...

    @property
    def _token(self) -> int:
        """Opaque value passed through to the IValueTaskSource."""
        ...

    @property
    def _continueOnCapturedContext(self) -> bool:
        """true to continue on the captured context; otherwise, false."""
        ...

    CompletedTask: System.Threading.Tasks.ValueTask
    """Gets a task that has already completed successfully."""

    @property
    def IsCompleted(self) -> bool:
        """Gets whether the ValueTask represents a completed operation."""
        ...

    @property
    def IsCompletedSuccessfully(self) -> bool:
        """Gets whether the ValueTask represents a successfully completed operation."""
        ...

    @property
    def IsFaulted(self) -> bool:
        """Gets whether the ValueTask represents a failed operation."""
        ...

    @property
    def IsCanceled(self) -> bool:
        """Gets whether the ValueTask represents a canceled operation."""
        ...

    @property
    def _obj(self) -> System.Object:
        """null if _result has the result, otherwise a Task{TResult} or a IValueTaskSource{TResult}."""
        ...

    @property
    def _result(self) -> System_Threading_Tasks_ValueTask_TResult:
        """The result to be used if the operation completed successfully synchronously."""
        ...

    @property
    def _token(self) -> int:
        """Opaque value passed through to the IValueTaskSource{TResult}."""
        ...

    @property
    def _continueOnCapturedContext(self) -> bool:
        """true to continue on the captured context; otherwise, false."""
        ...

    @property
    def Result(self) -> System_Threading_Tasks_ValueTask_TResult:
        """Gets the result."""
        ...

    @overload
    def __init__(self, task: System.Threading.Tasks.Task) -> None:
        ...

    @overload
    def __init__(self, source: System.Threading.Tasks.Sources.IValueTaskSource, token: int) -> None:
        """
        Initialize the ValueTask with a IValueTaskSource object that represents the operation.
        
        :param source: The source.
        :param token: Opaque value passed through to the IValueTaskSource.
        """
        ...

    @overload
    def __init__(self, result: System_Threading_Tasks_ValueTask_TResult) -> None:
        ...

    @overload
    def __init__(self, task: System.Threading.Tasks.Task[System_Threading_Tasks_ValueTask_TResult]) -> None:
        """
        Initialize the ValueTask{TResult} with a Task{TResult} that represents the operation.
        
        :param task: The task.
        """
        ...

    @overload
    def __init__(self, source: System.Threading.Tasks.Sources.IValueTaskSource[System_Threading_Tasks_ValueTask_TResult], token: int) -> None:
        """
        Initialize the ValueTask{TResult} with a IValueTaskSource{TResult} object that represents the operation.
        
        :param source: The source.
        :param token: Opaque value passed through to the IValueTaskSource.
        """
        ...

    @overload
    def AsTask(self) -> System.Threading.Tasks.Task:
        """Gets a Task object to represent this ValueTask."""
        ...

    @overload
    def AsTask(self) -> System.Threading.Tasks.Task[System_Threading_Tasks_ValueTask_TResult]:
        """Gets a Task{TResult} object to represent this ValueTask."""
        ...

    @overload
    def ConfigureAwait(self, continueOnCapturedContext: bool) -> System.Runtime.CompilerServices.ConfiguredValueTaskAwaitable:
        """
        Configures an awaiter for this ValueTask.
        
        :param continueOnCapturedContext: true to attempt to marshal the continuation back to the captured context; otherwise, false.
        """
        ...

    @overload
    def ConfigureAwait(self, continueOnCapturedContext: bool) -> System.Runtime.CompilerServices.ConfiguredValueTaskAwaitable[System_Threading_Tasks_ValueTask_TResult]:
        """
        Configures an awaiter for this ValueTask{TResult}.
        
        :param continueOnCapturedContext: true to attempt to marshal the continuation back to the captured context; otherwise, false.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """Returns a value indicating whether this value is equal to a specified object."""
        ...

    @overload
    def Equals(self, other: System.Threading.Tasks.ValueTask) -> bool:
        """Returns a value indicating whether this value is equal to a specified ValueTask value."""
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """Returns a value indicating whether this value is equal to a specified object."""
        ...

    @overload
    def Equals(self, other: System.Threading.Tasks.ValueTask[System_Threading_Tasks_ValueTask_TResult]) -> bool:
        """Returns a value indicating whether this value is equal to a specified ValueTask{TResult} value."""
        ...

    @staticmethod
    @overload
    def FromCanceled(cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.ValueTask:
        """
        Creates a ValueTask that has completed due to cancellation with the specified cancellation token.
        
        :param cancellationToken: The cancellation token with which to complete the task.
        :returns: The canceled task.
        """
        ...

    @staticmethod
    @overload
    def FromCanceled(cancellationToken: System.Threading.CancellationToken) -> System.Threading.Tasks.ValueTask[System_Threading_Tasks_ValueTask_FromCanceled_TResult]:
        """
        Creates a ValueTask{TResult} that has completed due to cancellation with the specified cancellation token.
        
        :param cancellationToken: The cancellation token with which to complete the task.
        :returns: The canceled task.
        """
        ...

    @staticmethod
    @overload
    def FromException(exception: System.Exception) -> System.Threading.Tasks.ValueTask:
        """
        Creates a ValueTask that has completed with the specified exception.
        
        :param exception: The exception with which to complete the task.
        :returns: The faulted task.
        """
        ...

    @staticmethod
    @overload
    def FromException(exception: System.Exception) -> System.Threading.Tasks.ValueTask[System_Threading_Tasks_ValueTask_FromException_TResult]:
        """
        Creates a ValueTask{TResult} that has completed with the specified exception.
        
        :param exception: The exception with which to complete the task.
        :returns: The faulted task.
        """
        ...

    @staticmethod
    def FromResult(result: System_Threading_Tasks_ValueTask_FromResult_TResult) -> System.Threading.Tasks.ValueTask[System_Threading_Tasks_ValueTask_FromResult_TResult]:
        """
        Creates a ValueTask{TResult} that's completed successfully with the specified result.
        
        :param result: The result to store into the completed task.
        :returns: The successfully completed task.
        """
        ...

    @overload
    def GetAwaiter(self) -> System.Runtime.CompilerServices.ValueTaskAwaiter:
        """Gets an awaiter for this ValueTask."""
        ...

    @overload
    def GetAwaiter(self) -> System.Runtime.CompilerServices.ValueTaskAwaiter[System_Threading_Tasks_ValueTask_TResult]:
        """Gets an awaiter for this ValueTask{TResult}."""
        ...

    @overload
    def GetHashCode(self) -> int:
        """Returns the hash code for this instance."""
        ...

    @overload
    def GetHashCode(self) -> int:
        """Returns the hash code for this instance."""
        ...

    @overload
    def Preserve(self) -> System.Threading.Tasks.ValueTask:
        """Gets a ValueTask that may be used at any point in the future."""
        ...

    @overload
    def Preserve(self) -> System.Threading.Tasks.ValueTask[System_Threading_Tasks_ValueTask_TResult]:
        """Gets a ValueTask{TResult} that may be used at any point in the future."""
        ...

    def ToString(self) -> str:
        """Gets a string-representation of this ValueTask{TResult}."""
        ...


class TaskCompletionSource(typing.Generic[System_Threading_Tasks_TaskCompletionSource_TResult], System.Object):
    """
    Represents the producer side of a Task{TResult} unbound to a
    delegate, providing access to the consumer side through the Task property.
    """

    @property
    def Task(self) -> System.Threading.Tasks.Task[System_Threading_Tasks_TaskCompletionSource_TResult]:
        """Gets the Task{TResult} created by this TaskCompletionSource{TResult}."""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a TaskCompletionSource{TResult}."""
        ...

    @overload
    def __init__(self, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Creates a TaskCompletionSource{TResult} with the specified options.
        
        :param creationOptions: The options to use when creating the underlying Task{TResult}.
        """
        ...

    @overload
    def __init__(self, state: typing.Any) -> None:
        """
        Creates a TaskCompletionSource{TResult} with the specified state.
        
        :param state: The state to use as the underlying Task{TResult}'s AsyncState.
        """
        ...

    @overload
    def __init__(self, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Creates a TaskCompletionSource{TResult} with the specified state and options.
        
        :param state: The state to use as the underlying Task{TResult}'s AsyncState.
        :param creationOptions: The options to use when creating the underlying Task{TResult}.
        """
        ...

    @overload
    def __init__(self) -> None:
        """Creates a TaskCompletionSource."""
        ...

    @overload
    def __init__(self, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Creates a TaskCompletionSource with the specified options.
        
        :param creationOptions: The options to use when creating the underlying Tasks.Task.
        """
        ...

    @overload
    def __init__(self, state: typing.Any) -> None:
        """
        Creates a TaskCompletionSource with the specified state.
        
        :param state: The state to use as the underlying Tasks.Task's AsyncState.
        """
        ...

    @overload
    def __init__(self, state: typing.Any, creationOptions: System.Threading.Tasks.TaskCreationOptions) -> None:
        """
        Creates a TaskCompletionSource with the specified state and options.
        
        :param state: The state to use as the underlying Tasks.Task's AsyncState.
        :param creationOptions: The options to use when creating the underlying Tasks.Task.
        """
        ...

    @overload
    def SetCanceled(self) -> None:
        """Transitions the underlying Task{TResult} into the TaskStatus.Canceled state."""
        ...

    @overload
    def SetCanceled(self, cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Transitions the underlying Task{TResult} into the TaskStatus.Canceled state
        using the specified token.
        
        :param cancellationToken: The cancellation token with which to cancel the Task{TResult}.
        """
        ...

    @overload
    def SetCanceled(self) -> None:
        """Transitions the underlying Tasks.Task into the TaskStatus.Canceled state."""
        ...

    @overload
    def SetCanceled(self, cancellationToken: System.Threading.CancellationToken) -> None:
        """
        Transitions the underlying Tasks.Task into the TaskStatus.Canceled state
        using the specified token.
        
        :param cancellationToken: The cancellation token with which to cancel the Tasks.Task.
        """
        ...

    @overload
    def SetException(self, exception: System.Exception) -> None:
        """
        Transitions the underlying Task{TResult} into the TaskStatus.Faulted state.
        
        :param exception: The exception to bind to this Task{TResult}.
        """
        ...

    @overload
    def SetException(self, exceptions: System.Collections.Generic.IEnumerable[System.Exception]) -> None:
        """
        Transitions the underlying Task{TResult} into the TaskStatus.Faulted state.
        
        :param exceptions: The collection of exceptions to bind to this Task{TResult}.
        """
        ...

    @overload
    def SetException(self, exception: System.Exception) -> None:
        """
        Transitions the underlying Tasks.Task into the TaskStatus.Faulted state.
        
        :param exception: The exception to bind to this Tasks.Task.
        """
        ...

    @overload
    def SetException(self, exceptions: System.Collections.Generic.IEnumerable[System.Exception]) -> None:
        """
        Transitions the underlying Tasks.Task into the TaskStatus.Faulted state.
        
        :param exceptions: The collection of exceptions to bind to this Tasks.Task.
        """
        ...

    @overload
    def SetResult(self, result: System_Threading_Tasks_TaskCompletionSource_TResult) -> None:
        """
        Transitions the underlying Task{TResult} into the TaskStatus.RanToCompletion state.
        
        :param result: The result value to bind to this Task{TResult}.
        """
        ...

    @overload
    def SetResult(self) -> None:
        """Transitions the underlying Tasks.Task into the TaskStatus.RanToCompletion state."""
        ...

    @overload
    def TrySetCanceled(self) -> bool:
        """
        Attempts to transition the underlying Task{TResult} into the TaskStatus.Canceled state.
        
        :returns: True if the operation was successful; otherwise, false.
        """
        ...

    @overload
    def TrySetCanceled(self, cancellationToken: System.Threading.CancellationToken) -> bool:
        """
        Attempts to transition the underlying Task{TResult} into the TaskStatus.Canceled state.
        
        :param cancellationToken: The cancellation token with which to cancel the Task{TResult}.
        :returns: True if the operation was successful; otherwise, false.
        """
        ...

    @overload
    def TrySetCanceled(self) -> bool:
        """
        Attempts to transition the underlying Tasks.Task into the TaskStatus.Canceled state.
        
        :returns: True if the operation was successful; otherwise, false.
        """
        ...

    @overload
    def TrySetCanceled(self, cancellationToken: System.Threading.CancellationToken) -> bool:
        """
        Attempts to transition the underlying Tasks.Task into the TaskStatus.Canceled state.
        
        :param cancellationToken: The cancellation token with which to cancel the Tasks.Task.
        :returns: True if the operation was successful; otherwise, false.
        """
        ...

    @overload
    def TrySetException(self, exception: System.Exception) -> bool:
        """
        Attempts to transition the underlying Task{TResult} into the TaskStatus.Faulted state.
        
        :param exception: The exception to bind to this Task{TResult}.
        :returns: True if the operation was successful; otherwise, false.
        """
        ...

    @overload
    def TrySetException(self, exceptions: System.Collections.Generic.IEnumerable[System.Exception]) -> bool:
        """
        Attempts to transition the underlying Task{TResult} into the TaskStatus.Faulted state.
        
        :param exceptions: The collection of exceptions to bind to this Task{TResult}.
        :returns: True if the operation was successful; otherwise, false.
        """
        ...

    @overload
    def TrySetException(self, exception: System.Exception) -> bool:
        """
        Attempts to transition the underlying Tasks.Task into the TaskStatus.Faulted state.
        
        :param exception: The exception to bind to this Tasks.Task.
        :returns: True if the operation was successful; otherwise, false.
        """
        ...

    @overload
    def TrySetException(self, exceptions: System.Collections.Generic.IEnumerable[System.Exception]) -> bool:
        """
        Attempts to transition the underlying Tasks.Task into the TaskStatus.Faulted state.
        
        :param exceptions: The collection of exceptions to bind to this Tasks.Task.
        :returns: True if the operation was successful; otherwise, false.
        """
        ...

    @overload
    def TrySetResult(self, result: System_Threading_Tasks_TaskCompletionSource_TResult) -> bool:
        """
        Attempts to transition the underlying Task{TResult} into the TaskStatus.RanToCompletion state.
        
        :param result: The result value to bind to this Task{TResult}.
        :returns: True if the operation was successful; otherwise, false.
        """
        ...

    @overload
    def TrySetResult(self) -> bool:
        """
        Attempts to transition the underlying Tasks.Task into the TaskStatus.RanToCompletion state.
        
        :returns: True if the operation was successful; otherwise, false.
        """
        ...


class TaskCanceledException(System.OperationCanceledException):
    """Represents an exception used to communicate task cancellation."""

    @property
    def Task(self) -> System.Threading.Tasks.Task:
        """Gets the task associated with this exception."""
        ...

    @overload
    def __init__(self) -> None:
        """Initializes a new instance of the System.Threading.Tasks.TaskCanceledException class."""
        ...

    @overload
    def __init__(self, message: str) -> None:
        """
        Initializes a new instance of the System.Threading.Tasks.TaskCanceledException
        class with a specified error message.
        
        :param message: The error message that explains the reason for the exception.
        """
        ...

    @overload
    def __init__(self, message: str, innerException: System.Exception) -> None:
        """
        Initializes a new instance of the System.Threading.Tasks.TaskCanceledException
        class with a specified error message and a reference to the inner exception that is the cause of
        this exception.
        
        :param message: The error message that explains the reason for the exception.
        :param innerException: The exception that is the cause of the current exception.
        """
        ...

    @overload
    def __init__(self, message: str, innerException: System.Exception, token: System.Threading.CancellationToken) -> None:
        """
        Initializes a new instance of the System.Threading.Tasks.TaskCanceledException
        class with a specified error message, a reference to the inner exception that is the cause of
        this exception, and the CancellationToken that triggered the cancellation.
        
        :param message: The error message that explains the reason for the exception.
        :param innerException: The exception that is the cause of the current exception.
        :param token: The CancellationToken that triggered the cancellation.
        """
        ...

    @overload
    def __init__(self, task: System.Threading.Tasks.Task) -> None:
        """
        Initializes a new instance of the System.Threading.Tasks.TaskCanceledException class
        with a reference to the System.Threading.Tasks.Task that has been canceled.
        
        :param task: A task that has been canceled.
        """
        ...

    @overload
    def __init__(self, info: System.Runtime.Serialization.SerializationInfo, context: System.Runtime.Serialization.StreamingContext) -> None:
        """
        Initializes a new instance of the System.Threading.Tasks.TaskCanceledException
        class with serialized data.
        
        This method is protected.
        
        :param info: The System.Runtime.Serialization.SerializationInfo that holds the serialized object data about the exception being thrown.
        :param context: The System.Runtime.Serialization.StreamingContext that contains contextual information about the source or destination.
        """
        ...


class ConcurrentExclusiveSchedulerPair(System.Object):
    """
    Provides concurrent and exclusive task schedulers that coordinate to execute
    tasks while ensuring that concurrent tasks may run concurrently and exclusive tasks never do.
    """

    @property
    def Completion(self) -> System.Threading.Tasks.Task:
        """Gets a System.Threading.Tasks.Task that will complete when the scheduler has completed processing."""
        ...

    @property
    def ConcurrentScheduler(self) -> System.Threading.Tasks.TaskScheduler:
        """
        Gets a TaskScheduler that can be used to schedule tasks to this pair
        that may run concurrently with other tasks on this pair.
        """
        ...

    @property
    def ExclusiveScheduler(self) -> System.Threading.Tasks.TaskScheduler:
        """
        Gets a TaskScheduler that can be used to schedule tasks to this pair
        that must run exclusively with regards to other tasks on this pair.
        """
        ...

    @overload
    def __init__(self) -> None:
        """Initializes the ConcurrentExclusiveSchedulerPair."""
        ...

    @overload
    def __init__(self, taskScheduler: System.Threading.Tasks.TaskScheduler) -> None:
        """
        Initializes the ConcurrentExclusiveSchedulerPair to target the specified scheduler.
        
        :param taskScheduler: The target scheduler on which this pair should execute.
        """
        ...

    @overload
    def __init__(self, taskScheduler: System.Threading.Tasks.TaskScheduler, maxConcurrencyLevel: int) -> None:
        """
        Initializes the ConcurrentExclusiveSchedulerPair to target the specified scheduler with a maximum concurrency level.
        
        :param taskScheduler: The target scheduler on which this pair should execute.
        :param maxConcurrencyLevel: The maximum number of tasks to run concurrently.
        """
        ...

    @overload
    def __init__(self, taskScheduler: System.Threading.Tasks.TaskScheduler, maxConcurrencyLevel: int, maxItemsPerTask: int) -> None:
        """
        Initializes the ConcurrentExclusiveSchedulerPair to target the specified scheduler with a maximum
        concurrency level and a maximum number of scheduled tasks that may be processed as a unit.
        
        :param taskScheduler: The target scheduler on which this pair should execute.
        :param maxConcurrencyLevel: The maximum number of tasks to run concurrently.
        :param maxItemsPerTask: The maximum number of tasks to process for each underlying scheduled task used by the pair.
        """
        ...

    def Complete(self) -> None:
        """Informs the scheduler pair that it should not accept any more tasks."""
        ...


class _EventContainer(typing.Generic[System_Threading_Tasks__EventContainer_Callable, System_Threading_Tasks__EventContainer_ReturnType]):
    """This class is used to provide accurate autocomplete on events and cannot be imported."""

    def __call__(self, *args: typing.Any, **kwargs: typing.Any) -> System_Threading_Tasks__EventContainer_ReturnType:
        """Fires the event."""
        ...

    def __iadd__(self, item: System_Threading_Tasks__EventContainer_Callable) -> None:
        """Registers an event handler."""
        ...

    def __isub__(self, item: System_Threading_Tasks__EventContainer_Callable) -> None:
        """Unregisters an event handler."""
        ...


