ChangeLog
=========

English version [by liar Google](https://libmdbx-dqdkfa-ru.translate.goog/md__change_log.html?_x_tr_sl=ru&_x_tr_tl=en)
and [by Yandex](https://translated.turbopages.org/proxy_u/ru-en.en/https/libmdbx.dqdkfa.ru/md__change_log.html).

The source code is availale on [Gitflic](https://gitflic.ru/project/erthink/libmdbx) and mirrors on [abf.io](https://abf.io/erthink/libmdbx), [hub.mos.ru](https://hub.mos.ru/leo/libmdbx) and [Github](https://github.com/erthink/libmdbx).
Please use the `stable` branch or the latest release for production environment through stagging, but the `master` branch for development a derivative projects.
Donations are welcome to ETH `0xD104d8f8B2dC312aaD74899F83EBf3EEBDC1EA3A`.
Всё будет хорошо!

## v0.13.8 "Всеобуч" (v`seabooch) от 2025-08-31

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов,
в день 100 летнего юбилея Постановления Всероссийского центрального исполнительного комитета о всеобщем бесплатном начальном образовании.

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.

Исправления:

 - Устранена возможность получения неожиданного `SIGBUS` из-за отложенного/ленивого выделение места в заполненной файловой системе после приращения файла БД.
   Более подробное пояснение в комментарии коммита [`2930b304dc674bbccd188b7ce7c3f83755ef706e`](https://gitflic.ru/project/erthink/libmdbx/commit/2930b304dc674bbccd188b7ce7c3f83755ef706e).

Изменение поведения:

 - Вновь включена/разрешена на старых ядрах Linux, начиная с версии 3.16, так как
   сейчас уже нет причин отказываться от работы на 3.16 поддерживая при этом ядра 4.x,
   и еще есть проекты (Isar, Isar-Community, Hive) которым требуется такая поддержка.

 - Ошибка `MDBX_WANNA_RECOVERY` при открытии БД в режиме только-чтение теперь возвращается если размер БД не кратен размеру системной страницы,
   но игнорируется не кратность размеру блока выделения виртуальной памяти.
   Этим устраняется регресс, проявившейся вследствие изменения поведения после задействования
   системного вызова `fallocate()` для предотвращения `SIGBUS` после приращения файла БД в заполненной файловой системе.

--------------------------------------------------------------------------------

## v0.13.7 "Дружба" (Friendship) от 2025-07-30.

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов,
в [международный день дружбы](https://www.un.org/ru/observances/friendship-day).

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.
 - [Артёму Воротникову](https://github.com/vorot93) за сообщение об ошибках и тестировании [призязок для Rust](https://github.com/vorot93/libmdbx-rs).

Исправления:

 - Устранена критическая ошибка в функционале `mdbx_env_resurrect_after_fork()` при использовании SysV-семафоров.

   Проявлялась ошибка только после порождения дочернего процесса посредством `fork()` на фоне выполняющейся пишущей транзакции, что
   приводило к неверной работе семафоров и далее к самым различным ошибкам, вплоть до повреждения БД. Проблема существовала начиная с появления
   `mdbx_env_resurrect_after_fork()` и затрагивала OSX, а также POSIX-платформы при сборке с опцией `MDBX_LOCKING=5`.

 - Устранена проблема в API копирования БД на отличных от Linux системах POSIX,
   а также в некоторых случаях при расположении целевого файла на не-локальной файловой системе.
   Проблема проявлялась в основном на OSX, возвратом ошибки `EWOULDBLOCK`/`EAGAIN` (35),
   что обусловлено недочетом/конфликтом блокировок `fcntl(F_SETLK)` и `flock()` в ядре ОС.
   Переработана обработка ошибок захвата файловых блокировок в API копирования на системах POSIX.

 - Устранена ошибка приводившая к неожиданному возврату `MDBX_BAD_DBI` при одновременном старте нескольких транзакций внутри одного процесса после открытия БД.

 - Устранена ошибка приводившая к неожиданному возврату `MDBX_DBS_FULL` при повторном открытии уже открытых таблиц и уже достигнутом лимите открытых DBI-дескрипторов.

 - Исправлена ошибка сборки для платформы Android при явном определении `_FILE_OFFSET_BITS`.

 - Исправлена ошибка использования `ENOMEM` вместо `MDBX_ENOMEM`.
   Что могло ломать сборку на не-POSIX/Windows платформах, в зависимости от конфигурации и/или версии SDK.

 - Поправлено либо удалено несколько неверных assert-проверок, из-за которых происходили падения отладочных сборок в специфических ситуациях.
   Главным образом, в коде функций `txn_end()`, `txn_lock()` и `txn_unlock()` как на Windows, так и на POSIX.

 - Устранены несущественные предупреждения MSVC. Отключены предупреждения `C5286` и `C5287`.

Прочие доработки:

 - Доработана логика отказа от использования OFD-блокировок на POSIX-платформах.
   Теперь кроме `EINVAL` учитываются дополнительные коды ошибок (`ENOSYS`, `ENOIMPL`, `ENOTSUP`, `ENOSUPP`, `EOPNOTSUPP`),
   что позволит работать собранной библиотеке в некоторых случаях,
   когда актуальное ядро/контейнер/эмулятор не поддерживает требуемых системных вызовов.

 - В тестовый фреймворк добавлена поддержка опции --numa # для привязки стохастического теста к NUMA-узлу,
   а в battery/tmux-скрипте добавлено явное распределение по NUMA-узлам, что существенно увеличило КПД
   при тестировании на NUMA-машинах.

 - В стохастическом скрипте реализован случайный порядок запуска отдельных тестов.

--------------------------------------------------------------------------------

## v0.13.6 "Бузина" от 2025-04-22.

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов,
в память о погибшем украинском историке и писателе [Алесе Бузине](https://ru.ruwiki.ru/wiki/Бузина,_Олесь_Алексеевич).

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.
 - [Илье Михееву](https://t.me/IlyaMkhv) и команде [Erigon](https://github.com/erigontech) за сообщения о проблеме и тестирование.
 - [Алексею Костюку (aka Keller)](https://t.me/keller18306) за сообщения о проблеме копирования на NFS.

Исправления:

 - Устранён регресс при использовании курсоров для DBI=0 (aka GC/FreeDB) в читающих транзакциях.

   После рефакторинга и ряда оптимизаций для завершения/гашения
   курсоров в читающих и пишущих транзакций, стал использоваться общий код.
   Причем за основу, был взят соответствующий фрагмент относящийся к
   пишущим транзакциям, в которых пользователю не позволяется
   использоваться курсоры для DBI=0 и поэтому эта итераций пропускалась.

   В результате, при завершении читающих транзакциях, курсоры связанные с
   DBI=0 не завершались должным образом, а при их повторном использовании
   или явном закрытии после завершения читающей транзакции происходило
   обращение к уже освобожденной памяти. Если же такие курсоры
   отсоединялись или закрывались до завершения читающей транзакции, то
   ошибка не имела шансов на проявление.

 - Устранён регресс в виде ошибки `EAGAIN` при копировании БД на NFS и CIFS/SMB.

   При доработках/развитии API в функции копирования был добавлен захват
   файловой блокировки посредством как `fcntl()`, так и `flock()`. Однако,
   в зависимости от версии локального ядра, версии удалённого сервера NFS и
   опций монтирования, это могло приводить к возврату POSIX-ошибки `EAGAIN`
   (`11` на большинстве платформ, включая Linux).

 - Устранена ошибка merge/rebase внутри `mdbx_txn_release_all_cursors_ex()`,
   что могло приводить к последующим неожиданным ошибкам `MDBX_EBADSIGN` и утечкам памяти.
   Для проверки сценария дополнен соответствующий тест.

 - Исправлена assert-проверка в пути завершения вложенных транзакций.
   Для проверки сценария дополнен соответствующий тест.

 - Устранена возможность возврата неожиданной ошибки `MDBX_BUSY` из `mdbx_txn_lock(dont_wait=false)`.

 - Для совместимости с GCC 15.x в режиме C23 изменен порядок указания атрибутов функций.

Изменение поведения:

 - При невозможности отвязки курсора от его текущей транзакции функция `mdbx_cursor_bind()`
   теперь возвращает `MDBX_EINVAL` вместо `MDBX_BAD_TXN`.

Прочие доработки:

 - Во избежание потенциальных проблем отключено использование `copy_file_range()` на ядрах Linux 5.3 - 5.18.

 - Вброс `std::invalid_argument` теперь производится явным сообщением `MDBX_EINVAL`.

 - Уточнен тип адреса для пожертвований.
   Ethereum/ERC-20 позволяет перечислять не только ETH, но и другие валюты/токены, в том числе USDC.

 - Дополнен тест курсоров extra/cursor-closing.

 - В `NOTICE` обновлена информация о Github.

--------------------------------------------------------------------------------

## v0.13.5 "Труба" от 2025-03-21

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов.

Благодарности:

 - [Erigon](https://erigon.tech/) за спонсорство.
 - [Илье Михееву](https://t.me/IlyaMkhv) за сообщения о недочетах и тестирование.
 - [Alex Sharov](https://github.com/AskAlexSharov) за сообщение об ошибках и тестирование.
 - [maxc0d3r](https://gitflic.ru/user/maxc0d3r) for bug reporting and testing.
 - [Alain Picard](https://github.com/castortech) for support [Java bindings](https://github.com/castortech/mdbxjni) and MacOS universal binaries patch for CMake build scenario,
   also for bug reporting (put-`MDBX_MULTIPLE` regression). Big thank for assistance with debugging and testing.

Новое:

 - Добавлена опция сборки `MDBX_ENABLE_NON_READONLY_EXPORT` позволяющая использовать в режиме чтения-записи БД расположенных в файловых системах экспортированных через NFS.
   По-умолчанию опция выключена и при открытии в неэксклюзивном режиме чтения-записи БД расположенных  файловых системах доступных извне по NFS будет возвращаться ошибка `MDBX_EREMOTE`.
   Включение опции позволяет открывать БД в описанных выше ситуациях, но риск чтения неверных данных на удалённой стороне ложится на пользователя.

 - Поддержка MacOS universal binaries при сборке посредством CMake.

 - Для закрытия или отсоединения всех курсоров с получением их количества в API добавлена функция `mdbx_txn_release_all_cursors_ex()`.

 - Добавлена операция `MDBX_SEEK_AND_GET_MULTIPLE` в API курсора, позволяющая за одну операцию выполнить позиционирование
   курсора на конкретное значение и начать чтение multi-значений в пакетном режиме.

 - Добавлены методы `mdbx::cursor::put_multiple_samelength()`, `mdbx::cursor::seek_multiple_samelength()`, `mdbx::cursor_managed::withdraw_handle()`.

 - В политику управления выделением для `mdbx::buffer<ALLOCATOR, CAPACITY_POLICY>` добавлен параметр `inplace_storage_size_rounding`.
   Одновременно с этим переработан внутренний union-тип `mdbx::buffer<ALLOCATOR, CAPACITY_POLICY>::silo::bin` для возможности увеличения без пенальти встроенного в экземпляр буфера места под данные.

 - В API добавлена функция `mdbx_cursor_close2()` возвращающая код ошибки.

Исправления:

 - Устранение лишнего/ненужного предупреждения в сценарии изменения размера БД посредством вызова `mdbx_env_set_geometry()` до её открытия.
   API предусматривает возможность запросить изменение геометрии/размера БД перед её открытием, чтобы избежать как лишних накладных расходов,
   так и потенциальных ошибок из-за нехватки адресного пространства. В этом сценарии ранее могло выдаваться лишнее/ненужное предупреждение
   о несоответствии файла БД новому размеру. Теперь этот недостаток исправлен.

 - Восстановлена доступность дескрипторов таблиц, открытых в дочерней транзакции, после её фиксации, в случае отсутствия изменений в данных.
   Проблема не была замечена ранее из-за специфического сценария проявления.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `e6af7d7c53428ca2892bcbf7eec1c2acee06fd44` от 2023-11-05.

 - Устранён сбой аудита таблиц при инвалидации дескрипторов таблиц вследствие отмены вложенной транзакции.
   Проблема не была замечена ранее из-за специфического сценария проявления.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `e6af7d7c53428ca2892bcbf7eec1c2acee06fd44` от 2023-11-05.

 - Устранена причина потенциальных сбоев и/и деградации производительности в сценарии закрытия курсора до завершения вложенной транзакции,
   с последующим изменением данных той-же таблицы в текущей вложенной транзакции, либо её дочерних транзакциях.
   Проблема обнаружена при ручном анализе кода, сценарии воспроизведения/проявления проблемы пока не известны.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `3de3d425a128a3c6f7866503f5f93b80c09dbe41` от 2024-05-19.

 - Устранена причина ложных ошибок при работе `mdbx_chk` с высоким уровнем логирования.
   Проблема возникала из-за неверной трактовки `MDBX_NOTFOUND` при штатном окончании итерируемых данных.

 - Устранена причина попыток рекурсивного захвата мьютекса при работе `mdbx_chk -w` в сборах с поддержкой Valring/ASAN и под управлением этих инструментов.

 - Устранены проверки потока владеющего транзакцией при сборке с опцией `MDBX_TXN_CHECKOWNER=OFF`.

 - Устранена вероятность ситуации гонки в `tbl_setup(MDBX_DUPFIXED | MDBX_INTEGERDUP)` при работе в разных потоках.
   В реальных сценариях вероятность проявления проблемы была близка к нулю.
   Для подробностей смотрите комментарий коммита `3e91500fac475947f5b58268d5edd3c9cc4f77f6`.

 - Устранён регресс затенения курсоров во вложенных транзакциях.
   При реализации отложенной/ленивой инициализации dbi-дескрипторов также было реализовано отложенное затенение курсоров (создание копии состояния для отката при прерывании транзакции),
   что существенно уменьшало накладные расходы при старте и завершении вложенных транзакций в сценариях с большим количеством курсоров.
   Однако, была допущена логическая ошибка, вследствие которой отложенная инициализация и затенение выполнялись при использовании dbi-дескрипторов, но не курсора открытого в родительской транзакции.
   В результате, родительские курсоры во вложенных транзакциях могли не затеняться, что приводило к неконсистентному состоянию в случае
   прерывания/откате вложенной транзакции и в соответствующей таблицы были изменения в рамках прерванной вложенной транзакции.
   Проблема не реализовывалась в тестовых сценариях и не была замечена при эксплуатации, но была обнаружена при расширении тестов.
   Ошибка присутствует в версиях 0.13.x и последующих, начиная с коммита `e6af7d7c53428ca2892bcbf7eec1c2acee06fd44` от 2023-11-05.

 - Устранён регресс в пути обработки операции `MDBX_MULTIPLE`.
   Пакетная вставка значений посредством `MDBX_MULTIPLE` могла приводить к падениям и повреждению структуры БД. Ошибка оставалось не
   замеченной из-за специфических условий проявления, которые не реализовались в тестах.
   Проблема присутствовала во всех выпусках начиная с v0.13.1, но соответствующая ошибка не связана с конкретным коммита в истории, а
   является следствием нескольких доработок (шагов рефакторинга), которые суммарно привели к регрессу.
   Технически ошибка обусловлена не-обнулением переменной, чего не происходило в некотором пути выполнения, так как исходно не требовалось.
   Однако, такое обнуление потребовалось после ряда этапов оптимизации и рефакторинга смежных участков кода.
   Для подробностей смотрите комментарий коммита `23a417fe19614481c6546845995d6dc845baf797`.

 - Скорректировано описание ошибки `MDBX_MVCC_RETARDED` и текста соответствующего сообщения.

 - В C++ API добавлена упущенная проверка `__cpp_concepts >= 202002` для использования концептов C++.

Изменение поведения:

 - Функция `mdbx_txn_release_all_cursors()` возвращает только код ошибки, не смешивая его с количеством обработанных/закрытых курсоров.
   Для аналогичных действий с получением количества закрытых курсоров в API добавлена функция `mdbx_txn_release_all_cursors_ex()`.

 - Использование системного кода ошибки `EREMOTEIO` ("Remote I/O error") вместо `ENOTBLK` ("Block device required") в качестве `MDBX_EREMOTE` для индикации ошибочной ситуации открытия БД расположенной на сетевом носителе.

 - Для основных вариантов использования шаблона `mdbx::buffer<>` теперь явно инстанцируются внутри библиотеки,
   одновременно соответствующие специализации шаблона помечены как `external` для предотвращения повторного инстанцирования в пользовательском коде.

 - Запрещена отвязка/открепление курсоров во вложенных транзакциях, т.е. вызовы `mdbx_cursor_unbind()` и
   `mdbx_txn_release_all_cursors(unbind=true)` для курсоров открытых в одной из родительских транзакций.
   Причина в том, что в случае отмены вложенной транзакции возникает неконструктивная неопределенность
   — следует ли восстанавливать состояние курсоров. Если не восстанавливать, то получается что вложенная транзакция может
   поломать родительскую, сделав её продолжение невозможным. Если восстанавливать, то также следует «воскрешать» закрытые
   курсоры, что неизбежно приведет к путанице, утечкам памяти и использованию после освобождения.

 - В C++ API отменён вброс исключения при запросе транзакции у отсоединённого курсора посредством вызова `mdbx::cursor::txn()`.

Прочие доработки:

 - Доработка использования LTO в CMake-сценариях: использование `-flto=auto` для GCC >= 11.4,
   расслабление условий для включения LTO для CLANG на Linux, расширение поиска `LLVMgold.so` в относительных lib-директориях.

 - Добавлены дополнительные проверки сигнатур курсоров при итерации связанных списков.

 - Кратное сокращение итераций тестов в зависимости от конфигурации Valgrind/Debug/CI.

 - Устранены предупреждения UBASN о невыравненном доступе в тесте extra/close-dbi.

 - Добавлен перехват и логирование исключений в extra-тестах на C++.

 - Расширены тесты extra/dupfix-multiple, extra/cursor-closing и extra/txn.

 - В утилиту тестирования добавлена поддержка режима/опции `MDBX_VALIDATION` и поддержка значений `on`/`off` для опций командной строки.

 - Добавлены doxygen-описания для doubtless-positioning констант.

 - Переработана проверка курсоров на входе в API-функций с добавлением `cursor_check()`, `cursor_reset()` и `cursor_drown()`.

 - Отключено использование C23 `[[атрибутов]]` для версий CLANG меньше 20.

--------------------------------------------------------------------------------

## v0.13.4 "Sigma Boy" от 2025-02-14

Поддерживающий выпуск стабильной ветки с исправлением обнаруженных ошибок и устранением недочётов.

Благодарности:

 - [Erigon](https://docs.erigon.tech/) за спонсорство.
 - [Алексею Костюку (aka Keller)](https://t.me/keller18306) за сообщения об ошибках и недочетах.
 - [Alain Picard](https://github.com/castortech) for support [Java bindings](https://github.com/castortech/mdbxjni) and MacOS universal binaries patch for CMake build scenario.
 - [Alex Sharov](https://github.com/AskAlexSharov) за сообщение об ошибках и тестирование.
 - [Виктору Логунову](https://t.me/vl_username) за сообщение об опечатки в имени переменной в Conan-рецепте.

Новое:

 - Поддержка MacOS universal binaries при сборке посредством CMake.

Исправления:

 - Устранён регресс допускающий SIGSEGV в операциях обновления после вытеснения/spilling страниц в больших транзакциях.
   Ошибка присутствует в выпусках v0.13.1, v0.13.2, v0.13.3 и оставалась незамеченной из-за специфических условий и низкой вероятности проявления.
   Более подробная информация в описании коммита `21630ea115690a5cb39cfa921f9d199271a08102`.

 - Исправлена опечатка в документации в упоминании `mdbx_env_resurrect_after_fork()`.

 - Исправлена опечатка в условном операторе внутри `cursor_touch()`.
   При переделке курсоров было пропущено отрицание в условии, при оценке количества страниц, которые могут потребоваться для выполнения операции.
   В текущем понимании ошибка не приводила к каким-либо проблемам, ибо оценка делает по верхней границе с существенным запасом, а в худшем
   случае это могло приводить к прерыванию транзакции из-за достижения ограничения на кол-во грязных страниц.

 - Корректировка излишне строгого условия в assert-проверке внутри `recalculate_subpage_thresholds()`.
   Ошибка могла проявляться только в отладочных сборках при выставлении определенной комбинации предельных значений опций `MDBX_opt_subpage_limit`,
   `MDBX_opt_subpage_room_threshold`, `MDBX_opt_subpage_reserve_prereq`, `MDBX_opt_subpage_reserve_limit`.

 - Исправление опечатки в Conan-рецепте в коде протокольно-отладочного вывода в имени переменной `version_json_pathname`.

--------------------------------------------------------------------------------

## v0.13.3 "Королёв" от 2025-01-12

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов
в день рождения и в память об [Серге́е Па́вловиче Королёве](https://ru.wikipedia.org/wiki/Королёв,_Сергей_Павлович),
советском учёном и Главном конструкторе ракетно-космических систем.

Благодарности:

 - [Алексею Костюку (aka Keller)](https://t.me/keller18306) за сообщения об ошибках и недочетах.
 - [Erigon](https://docs.erigon.tech/) за спонсорство.
 - [Lazymio](https://github.com/wtdcode) за новые [привязки к Python](https://pypi.org/project/libmdbx/).

Новое:

 - В C API добавлена функция `mdbx_cursor_count_ex()` позволяющая получить как количество мульти-значений
   соответствующих текущему ключу, так и информацию о вложенном дереве хранящем эти значения.

 - В C++ API добавлен метод `mdbx::txn::make_broken()` аналогичный `mdbx_txn_break()`.

 - В утилиты mdbx_copy, mdbx_drop, mdbx_dump, mdbx_load, mdbx_stat добавлено логирование ошибок,
   предупреждений и важных сообщений от libmdbx.

Исправления:

 - Устранён регресс неразблокировки мьютекса при попытки повторного закрытия dbi-дескриптора,
   в том числе при попытке явно закрыть дескриптор после удаления связанной с ним таблицы.

   Вместо возврата ошибки `MDBX_BAD_DBI` происходил выход из тела функции по успешному пути,
   но без освобождения захваченной блокировки.
   Ошибка была внесена 2024-10-23 коммитом `3049bb87b5b14d83b16d121c186ce8fb3f21383e`.

 - Устранён регресс состояния вложенного/dupsort курсора после вставки данных в `MDBX_APPEND`-режиме.

   При добавлении нового ключа в append-режиме, в случае когда в текущей
   (последней) позиции с ключом связаны несколько значений и
   (соответственно) вложенный dupsort-курсор инициализирован, вставка
   происходила без сброса вложенного курсора.

   В результате вложенный курсор логически оставался стоять на
   multivalue-данных связанных с предыдущей позицией основного курсора,
   т.е. переходил в неконсистентное состояние.

   Ошибка проявлялась возвратом неверных значений из `mdbx_cursor_count()`
   или срабатывание assert-проверки в отладочных сборках.

 - Поддержка получения boot_id при работе внутри LXC-контейнера.

   Из LXC-контейнера не доступен файл хостовой системы `/proc/sys/kernel/random/boot_id`.
   Вместо него, при каждом старте контейнера, создается и заполняется
   случайными данными собственный boot_id смонтированный через bind из `tmpfs`.
   https://github.com/lxc/lxc/issues/3027

   Ранее этот подставной/замещенный boot_id отбраковывался внутри libmdbx,
   так как файл располагается в `tmpfs`, а не в файловой системе `/proc`.
   В результате boot_id для проверки целостности БД не был доступен.
   Теперь при работе внутри LXC-контейнера такой bootid будет использоваться.

   Однако, полноценно работающий контроль по boot_id не возможен, так как при
   рестарте LXC-контейнера (но не хоста) boot_id будет меняться, хотя
   данные в unified page cache сохраняются.

   Таким образом, при рестарте LXC-контейнера без рестарта хоста, libmdbx придется
   откатить состояние БД до крайней точки устойчивой фиксации, что повлечет
   утрату данных пользователя в случаях когда они могли быть сохранены.
   Однако, улучшить ситуацию пока не представляется возможным, как минимум
   до доступности boot_id хостовой системы изнутри LXC-контейнера.

 - Устранёна ошибка неверной обработки попытки запуска вложенной читающей транзакции.
   Теперь в таких ситуациях возвращается ошибка `MDBX_EINVAL`, так как вложенность
   поддерживается только для транзакций чтения-записи.

   Ошибка была внесена при рефакторинге, коммитом `2f2df1ee76ab137ee66d00af69a82a30dc0d6deb`
   чуть более 5 лет назад и долго оставалось не замеченной.

 - Устранён SIGSEGV-регресс обращения к нулевому адресу при работе в режиме только-чтение без использования LCK-файла,
   например при размещении БД на носителе доступном только для чтения.

   Ошибка была внесена при реализации функционала парковки читающих транзакций.

Изменение поведения:

 - Теперь при включении профилирования GC (сборка с опцией `MDBX_ENABLE_PROFGC=ON`)
   подсчитываются затраты времени ЦПУ на слияние списков страниц, т.е. на работу функции `pnl_merge()`.

 - В утилите тестирования значение режима данных переименовано из `data.dups` в `data.multi`.

 - Доработан контроль длины ключа внутри `cursor_seek()`.

   Ранее проверка внутри `cursor_seek()` не позволяла искать ключи длиннее, чем можно поместить в таблицу.
   Однако, при поиске/позиционировании это не является ошибкой для таблиц с ключами переменного размера.

 - Если посредством `mdbx_env_set_option(MDBX_opt_txn_dp_limit)` пользователем не задано собственно значение,
   то выполняется подстройка dirty-pages-limit при старте каждой не-вложенной пишущей транзакций,
   исходя из объёма доступного ОЗУ и размера БД.

 - Теперь в режиме `MDBX_NOSTICKYTHREADS` допускается commit/abort вложенных транзакций из любого треда/потока.

 - Теперь при попытке запуска вложенных транзакций в режиме `MDBX_WRITEMAP` производится
   логирование и возврат ошибки `MDBX_INCOMPATIBLE`.

 - Теперь в C++ API в конструкторах/инициализаторах и методах связанных с формированием геометрии БД
   по-умолчанию используются только `default`-значений, в том числа для минимального и максимального
   размера. В результате, при создании БД с геометрией по-умолчанию не происходит выбор максимального
   размера страницы из-за очень большого максимального размера БД.

 - Внутри `mdbx_env_set_geometry()` доработаны эвристики для подбора параметров геометрии БД запрошенных пользователем "по-умолчанию".

--------------------------------------------------------------------------------

## v0.13.2 "Прошлогодний Снег" (Last Year's Snow) от 2024-12-11

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов
в день рождения и в память об [Алекса́ндре Миха́йловиче Тата́рском](https://ru.wikipedia.org/wiki/Татарский,_Александр_Михайлович),
российском режиссёре-мультипликаторе, создавшем такие знаменитые
мультфильмы как "Падал прошлогодний снег", "Пластилиновая ворона",
заставку "Спокойной ночи, малыши!" и многие другие шедевры нашего
детства.

Новое:

 - Ускорено обновление GC при возврате/помещении списков страниц в
   сложных сценариях. Был доработан и активирован ранее отключенный
   экспериментальный режим корректирующей обратной связи. Этим
   принципиально улучшилась сходимость (сократилось количество повторных
   попыток), а также устранен дефект приводящий к "зацикливанию" при
   фиксации транзакций (с возвратом ошибки `MDBX_PROBLEM`) в редких
   специфических условиях.
   Подробности см. в описании коммита [`6c56ed97bbd8ca46abac61886a113ba31e5f1291`](https://gitflic.ru/project/erthink/libmdbx/commit/6c56ed97bbd8ca46abac61886a113ba31e5f1291).
 - Включен стандарт `C23` в CMake-скриптах сборки.
 - Добавлены T-макросы для парных `char`/`wchar_t` функций.
 - Поддержка вложенных пишущих транзакций в C++ API.
 - Переход на "Semantic Versioning 2" и экспорт информации о версии в `VERSION.json`.
 - Добавлена поддержка переменной среды `SOURCE_DATE_EPOCH` для воспроизводимости сборок.
   Прежний способ посредством `MDBX_BUILD_TIMESTAMP` также работает и имеет приоритет.
 - Добавлена возможность указывать дополнительную информацию о сборке
   libmdbx через опцию `MDBX_BUILD_METADATA`. Сейчас задаваемая информация
   просто включается внутрь библиотеки в качестве значения
   `mdbx_build.metadata`, а в дальнейшем также будет использоваться при
   формировании пакетов и т.п.
 - Добавлено логирование ошибок возвращаемых из API. Теперь для этого
   достаточно задать уровень логирования `MDBX_LOG_DEBUG` (для логирования
   ошибок за вычетом `MDBX_NOTFOUND`) или `MDBX_LOG_TRACE` (для логирования
   всех ошибок, а также `MDBX_RESULT_TRUE`).
 - Поддержка сборки посредством Conan.

Изменение поведения:

 - Добавлен метод `mdbx::cursor::get_multiple_samelength()` и
   переименован `mdbx::txn::put_multiple_samelength()`.
 - Для единообразия C++ API при выполнении операции `MDBX_GET_MULTIPLE`
   теперь также возвращается значение самого ключа.
 - Для размерных констант `mdbx::env::geometry` базовый тип изменен с
   беззнакового `size_t` на знаковый `intptr_t`.
 - Теперь выбор в пользу использования ntdll вместо CRT делается только
   при явном отключении C++ API.
 - Теперь выполняется освобождение памяти сброшенных/прерванных читающих
   транзакций передаваемых в `mdbx_txn_commit()`. Соглашение по API требует
   чтобы такие транзакции освобождались посредством `mdbx_txn_abort()`,
   из-за чего функция `mdbx_txn_commit()` возвращала ошибку в таких
   случаях, не разрушая сами транзакции. Это приводило к утечкам памяти
   из-за ошибок в приложениях, что побудило изменить поведение.
 - Использование макроса `__deprecated_enum` если он определен.
 - При сборке посредством CMake выбор стандарта языка `C` теперь
   выполняется с учётом `CMAKE_C_STANDARD`.
 - Изменения в опциях сборки:
   * опция `MDBX_OSX_SPEED_INSTEADOF_DURABILITY` переименована в
     `MDBX_APPLE_SPEED_INSTEADOF_DURABILITY`, так как актуальна для всех
     "Яблочных" платформ;
   * опция `MDBX_MMAP_USE_MS_ASYNC` переименована в
     `MDBX_MMAP_NEEDS_JOLT`, для более точного соответствия своей семантики;
   * в CMake добавлена поддержка опции `MDBX_USE_MINCORE`;
   * использование `madvise()` и родственных системных вызовов теперь
     всегда включено, а опция `MDBX_ENABLE_MADVISE` удалена;
   * удалены неиспользуемая опция `MDBX_USE_SYNCFILERANGE` и
     неиспользуемый режим `MDBX_LOCKING_BENAPHORE`.

Исправления:

 - Устранен регресс возврата неверной информации из функций
   `mdbx_env_stat_ex()` и `mdbx_env_stat()`. При рефакторинге до выпуска
   v0.13.1 была допущена ошибка, из-за которой выполнялось суммирование
   значений без очистки переданного пользователем буфера для результата.
   Таким образом, возвращаемая информация была верной, только если память
   используемая для размещения результата содержала нули на момент вызова
   функции.
 - Функция `mdbx_close_dbi()` доработана для возврата ошибки `MDBX_DANGLING_DBI`
   при попытке закрыть dbi-дескриптор таблицы, созданной и/или измененной в
   ещё выполняющейся транзакции. Такое преждевременное закрытие дескриптора
   является неверным использованием API и нарушением контракта/предусловий
   сформулированных в описании `mdbx_close_dbi()`. Однако, вместо возврата
   ошибки выполнялось некорректное закрытие дескриптора, что могло
   приводить к созданию таблицы с пустым именем, утечки страниц БД и/или
   нарушению структуры b-tree (неверной ссылкой на корень таблицы).
 - Исправлено открытие таблицы с пустым/нулевым именем, в том числе устранена
   возможность `SIGSEGV` при закрытии её дескриптора.
 - Добавлены упущенные inline-реализации `mdbx::cursor::upper_bound()` и `mdbx::cursor::upper_bound_multivalue()`.
 - Продолжена корректировка описания С++ API для использования термина "таблица" вместо "sub-database".
 - Исправлено проверяемое условие внутри `assert()` в пути обработки `MDBX_GET/NEXT/PREV_MULTIPLE`.
 - На 32-битных платформах разрешено использовать 4-байтное выравнивание при получении 64-битных значений посредством `MDBX_MULTIPLE`.
 - Добавлен костыль для устранения проблем из-за некорректной обработки `[[gnu::pure]]` в Apple Clang и MSVC.
 - Поправлено определение `MDBX_DEPRECATED_ENUM` для старых компиляторов при включении С++11.
 - Доработано использование `std::experimental::filesystem` для решения проблем со сборкой в старых компиляторах.
 - Исправлена обработка `MDBX_GET_MULTIPLE` в специальных случаях и одного значения у ключа в позиции курсора.
 - Исправление сборки при включении профилирования GC и `MDBX_ENABLE_DBI_SPARSE=OFF`.

Мелочи:

 - Теперь `MDBX_ENABLE_BIGFOOT` включена по-умолчанию вне зависимости от разрядности платформы.
 - Дополнение README и исправление опечаток/орфографии.
 - Использование `WIN32` вместо `${CMAKE_SYSTEM_NAME}`.
 - Подавление параноидальных предупреждений MSVC в extra-тестах.
 - Дополнение отладочного логирования внутри `dxb_resize()`.
 - Добавление в сценарии CMake/CTest копирования dll под  Windows для работы исключений в тестах на C++.
 - Добавление С++ теста `extra/open`.
 - Доработка `osal_jitter()` для уменьшения задержек в тестах под Windows.
 - Исправление максимальной длины значений в тесте `extra/crunched-delete`.
 - Добавление логирования С++ исключений в `extra/dupfix_multiple`.
 - Корректировка API-макросов для Doxygen.
 - Уточнение описания `mdbx_dbi_close()` для случая хендлов измененных таблиц.
 - Добавление теста `extra/early_close_dbi`.
 - Доработка скрипта стохастического теста и его переименование в `stochastic.sh`.
 - Доработка тестов для совместимости с режимами сборки до С++17.
 - Добавление `.WAIT` для устранения коллизий при распараллеливании сборки посредстом GNU Make 4.4.

--------------------------------------------------------------------------------

## v0.13.1 "РДС-1" от 2024-08-29

Новая версия со сменой лицензии, существенным расширением API,
добавлением функционала и внутренними переработками. В том числе,
с незначительным нарушением обратной совместимости API библиотеки.

Новое:

 - Изменение лицензии на Apache 2.0, пояснения и подробности в файле `COPYRIGHT`.

 - Реструктуризация исходного кода с рефакторингом.

 - Переработка курсоров для унификации поведения, более регулярного
   кода, уменьшения количества ветвлений и машинных операций.

 - Перенос функционала утилиты `mdbx_chk` внутрь библиотеки в виде
   функции `mdbx_env_chk() `для проверка целостности структуры БД, в том
   числе с вовлечением логики приложения.

 - Опция `MDBX_opt_gc_time_limit` для более гибкого контроля времени
   расходуемого на поиск последовательностей соседствующих свободных
   страниц в GC.

 - Снижение накладных расходов на запуск транзакций в сценариях с
   большим количеством DBI-хендов, за счет отложенной/ленивой инициализации
   элементов служебных таблиц. В том числе, механизм поддержки разреженных
   наборов DBI-хендов, управляемый опцией сборки `MDBX_ENABLE_DBI_SPARSE`,
   которая включена по-умолчанию.

 - Снижение накладных расходов на открытие DBI-хендов. В том числе,
   механизм отложенного освобождения и поддержки быстрого пути открытия без
   использования блокировок, управляемый опцией сборки
   `MDBX_ENABLE_DBI_LOCKFREE`, которая включена по-умолчанию.

 - Поддержка "парковки" читающих транзакций с их вытеснением ради
   переработки старых MVCC-снимков и предотвращения проблем вызываемых
   приостановкой переработки мусора. Механизм парковки и вытеснения
   припаркованных транзакций является как дополнением, так и более простой
   в использовании альтернативой обратному вызову
   [Handle-Slow-Readers](https://libmdbx.dqdkfa.ru/group__c__err.html#ga2cb11b56414c282fe06dd942ae6cade6).
   Для удобства функции `mdbx_txn_park()` и `mdbx_txn_unpark()` имеют
   дополнительные аргументы, позволяющие запросить автоматическую
   "распарковку" припаркованных и перезапуск вытесненных транзакций.

 - Расширение API позиционирования курсоров более удобными и очевидными
   операциями по аналогии условиям `<`, `<=`, `==`, `>=`, `>` как для
   ключей, так и для пар ключ-значение.

 - Функции `mdbx_dbi_rename()` и `mdbx_dbi_rename2()` для переименования таблиц.

 - Функции `mdbx_cursor_unbind()` и `mdbx_txn_release_all_cursors()` для
   гибкого управления курсорами в сценариях повторного использования для
   уменьшения накладных расходов.

 - Функция `mdbx_env_resurrect_after_fork()` для восстановление открытой
   среды работы с БД в дочернем процессе после ветвления/расщепления
   процесса.

 - Функция `mdbx_cursor_compare()` для сравнения позиций курсоров
   аналогично оператору `<=>`.

 - Функции `mdbx_cursor_scan()` и `mdbx_cursor_scan_from()` для
   сканирования таблиц с использованием функционального предиката и
   уменьшением сопутствующих накладных расходов.

 - Функции `mdbx_cursor_on_first_dup()` и `mdbx_cursor_on_last_dup()`
   для оценки позиции курсора.

 - Функция `mdbx_preopen_snapinfo()` для получения информации о БД без
   её открытия.

 - Функция `mdbx_enumerate_tables()` для получение информации
   об именованных пользовательских таблицах.

 - Поддержка функций логирования обратного вызова без функционала
   `vprintf()`, что существенно облегчает использование логирования в
   привязках к другим языкам программирования.

 - Режим работы `MDBX_NOSTICKYTHREADS` вместо `MDBX_NOTLS` для упрощения
   интеграции с легковесными потоками/нитями их мультиплексирования вместе
   с транзакциями по потокам операционной системы.

 - Опция `MDBX_opt_prefer_waf_insteadof_balance`.

 - Опции `MDBX_opt_subpage_limit`, `MDBX_opt_subpage_room_threshold`,
   `MDBX_opt_subpage_reserve_prereq`, `MDBX_opt_subpage_reserve_limit`.

 - Управление основной блокировкой lock/unlock/upgrade/downgrade для координации пишущих транзакций.

 - Функции `mdbx_limits_keysize_min()` и `mdbx_limits_valsize_min()` для
   получения нижней границы длины ключей и значений.

 - Для идентификации БД добавлен UUID доступный в поле `mi_dxbid` структуры `MDBX_envinfo`,
   получаемой посредством `mdbx_env_info_ex()`.

 - Расширение API функциями lock/unlock/upgrade/downgrade основной блокировки.

 - Добавление в API функций `mdbx_cursor_unbind()` и `mdbx_txn_release_all_cursors()`.

 - Добавление в API функций `mdbx_txn_copy2pathname()` и `mdbx_txn_copy2fd()`.

 - Добавление в утилиту `mdbx_copy` опций `-d` и `-p`.

 - Расширение и доработка C++ API:

     - добавлен тип `mdbx::cursor::estimate_result`, а поведение методов
      `mdbx::cursor::estimate()` унифицировано с `mdbx::cursor::move()`;
     - для предотвращения незаметного неверного использования API, для инициализации
       возвращаемых по ссылке срезов, вместо пустых срезов задействован `mdbx::slice::invalid()`;
     - добавлены дополнительные C++ операторы преобразования к типам C API;
     - для совместимости со старыми стандартами C++ и старыми версиями STL перенесены
       в public классы `mdbx::buffer::move_assign_alloc` и `mdbx::buffer::copy_assign_alloc`;
     - добавлен тип `mdbx::default_buffer`;
     - для срезов и буферов добавлены методы `mdbx::buffer::hex_decode()`, `mdbx::buffer::base64_decode()`, `mdbx::buffer::base58_decode()`;
     - добавлен тип `mdbx::comparator` и функций `mdbx::default_comparator()`;
     - добавлены статические методы `mdbx::buffer::hex()`, `mdbx::buffer::base64()`, `mdbx::buffer::base58()`;
     - для транзакций и курсоров добавлены методы `get_/set_context`;
     - добавлен метод `mdbx::cursor::clone()`;
     - поддержка base58 переработана и приведена в соответствии с черновиком RFC,
       в текущем понимании теперь это одна из самых высокопроизводительных реализаций base58;
     - переработка `to_hex()` и `from_hex()`;
     - добавлены перегрузи со `std::string_view` для методов `open_map`/`create_map`/`drop_map`/`clear_map`/`rename_map()`;
     - добавлены перегрузки методов put/insert/upsert для `mdbx::pair`;
     - добавлены методы принимающие имена таблиц/subDb через `mdbx::slice`.

Нарушение совместимости:

 - Использование термина "таблица" вместо "subDb".
 - Опция `MDBX_COALESCE` объявлена устаревшей, так как соответствующий функционал всегда включен начиная с предыдущей версии 0.12.
 - Опция `MDBX_NOTLS` объявлена устаревшей и заменена на `MDBX_NOSTICKYTHREADS`.
 - Опция сборки `MDBX_USE_VALGRIND` заменена на общепринятую `ENABLE_MEMCHECK`.
 - В структуре `MDBX_envinfo` серии полей вида `meta1`, `meta2` и `meta3` заменены на массивы вида `meta[3]`.
 - В шаблонных классах и функциях С++ API по-умолчанию вместо `mdbx::legacy_buffer` использован тип `mdbx::default_buffer` использующий полиморфные аллокаторы С++ 17.
 - Удаление `DEFAULT_MAPSIZE` и изменение геометрии по-умолчанию при создании БД.
 - Возвращение `MDBX_TXN_INVALID` (`INT32_MIN`) вместо `-1`
   из `mdbx_txn_flags()` при передаче невалидной транзакции.

Исправления:

 - Исправление упущенного `TXN_END_EOTDONE` при сбое старта читающей транзакции.
   Упомянутый флажок отсутствовал в пути разрушения транзакции при ошибке
   её запуска. Из-за чего делалась попытка разрушить курсоры, что приводило
   к падению **отладочных сборок**, так как в них соответствующий массив
   намеренно заполнен некорректными указателями.

 - Устранение возможности `SIGSEGV` внутри `coherency_check()` после
   изменения геометрии другим процессом с увеличением верхнего размера БД
   и увеличением БД больше предыдущего лимита.

 - Исправление assert-проверки при попытке создания таблицы с другими флагами/опциями.

Мелочи:

 - Обновление конфигурации Doxygen до 1.9.6.
 - Добавление `--read-var-info=yes` для Valgrind.
 - Вывод из `mdbx_chk` информации об уровне детализации/verbosity.

## v0.13.0 от 2023-04-23

Технический тэг, отмечающий начало ветки `0.13`
с новым функционалом и изменением API.

********************************************************************************

## v0.12.12 "Доллежаль" от 2024-10-27

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов,
в память о советском ученом-энергетике Николае Антоновиче Доллежаль в день 125-летия со дня его рождения.

Это последний выпуск куста стабильных версий 0.12.x, спустя более двух
лет после выпуска 0.12.1. Последующие выпуски 0.12.x будут формироваться
только в случае существенных проблем/ошибок, вероятность чего близка к
нулю. Для всех проектов находящихся в стадии активной разраборки
рекомендуется использовать ветку `master`.

```
git diff' stat: x commits, y files changed, z insertions(+), zz deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Значимые исправления:

 - Исправление упущенного `TXN_END_EOTDONE` при сбое старта читающей транзакции.
   Упомянутый флажок отсутствовал в пути разрушения транзакции при ошибке
   её запуска. Из-за чего делалась попытка разрушить курсоры, что приводило
   к падению **отладочных сборок**, так как в них соответствующий массив
   намеренно заполнен некорректными указателями.

 - Устранение возможности `SIGSEGV` внутри `coherency_check()` после
   изменения геометрии другим процессом с увеличением верхнего размера БД
   и увеличением БД больше предыдущего лимита.

 - Доработка `mdbx_close_dbi()` для возврата ошибки при попытке закрыть
   dbi-дескриптор таблицы, созданной и/или измененной в ещё выполняющейся
   транзакции. Такое преждевременное закрытие дескриптора является неверным
   использованием API и нарушением контракта/предусловий сформулированных
   в описании `mdbx_close_dbi()`. Однако, вместо возврата ошибки
   выполнялось некорректное закрытие дескриптора, что могло приводить к
   созданию таблицы с пустым именем, утечки страниц БД и/или нарушению
   структуры b-tree (неверной ссылкой на корень таблицы).
   Добавлен соответствующий тест `extra/early_close_dbi`.

--------------------------------------------------------------------------------

## v0.12.11 "Лиза и Соня" от 2024-07-23

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов,
в память об убитых в Крыму девочках 2 и 9 лет.

Лиза и Соня погибли 23 Июня 2024 на глазах у родителей, в результате
удара по общественному городскому пляжу ракетами ATACMS с кассетными
боеприпасами. Всего пострадало более 150 граждан России, в том числе 27
детей. Ракеты были выпущенными украинскими бандеровцами/фашистами, но
полетные задания формировались и загружались военными США, а управление
и наведение ATACAMS невозможно без использования орбитальной группировки
военных спутников США.

```
git diff' stat: 29 commits, 14 files changed, 379 insertions(+), 151 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Значимые исправления:

 - Исправление для ОС Windows нарезки `FILE_SEGMENT_ELEMENT`.
   Похоже что был потерян коммит входе работы над оптимизацией пути записи
   на диск в ОС Windows. В текущем понимании, вероятность проявления ошибки
   достаточно низкая, так как выявлена она была синтетическими тестами в
   ходе других доработок, а соответствующих сообщений/жалоб не поступало. К
   повреждению БД ошибка не приводила, так как сбой происходил до записи
   данных с возвратом `ERROR_INVALID_PARAMETER` из системного вызова, т.е.
   либо ошибка не проявлялась, либо транзакция не фиксировалась.

 - Устранение вероятности `SIGSEGV` при включении логирования
   уровня `MDBX_LOG_TRACE` в отладочных сборках.

 - Исправление генерации исключения `key_exists` в C++ API.

 - Исправление опечаток в документации и README.

 - Исправление обработки курсоров, открытых в родительских транзакциях и
   закрытых до завершения вложенных транзакций. В описанной ситуации
   закрытые курсоры "воскрешались", что приводило к утечке памяти
   выделенной под такие курсоры.

 - Костыль для MSVC ARM/ARM64 для предотвращения ICE (Internal Compiler Error).

 - Устранение `MDBX_EINVAL` для случая вызова `mdbx_env_remove(".")`.

 - Исправление инверсии bool-результата `env::remove()` в C++ API.

 - Исправление опечатки `равно`/`неравно` в условии внутри
   `update_gc()`. Существенных последствий ошибки не было, но в
   определенных сценариях, сходимость требовала еще одного цикла повтора
   внутри update_gc().

Прочие доработки:

 - Проверка совместимости флагов GC/FreeDB на случай их изменения в будущих версиях.
 - Очистка сообщений `FormatMessageA()` от концевых переводов строк.
 - Уточнение макроса `__always_inline` для особо яблочных версий CLANG.
 - Использование `\n` вместо `std::endl` в C++ API при .
 - Проверка дополнительных и пока не используемых полей в meta-страницах.
 - Отключение ненужной отладки внутри `txn_merge()`.
 - Исправление условий и привязки к версиям компиляторов при формировании макроса `MDBX_DEPRECATED`.
 - Больше атрибутов `__cold` для редко-используемых функций (backport).
 - Добавление методов `buffer::append_bytes()` и `buffer::clear_and_reserve()`.
 - Отключение установки признака фатальной ошибки для не-активной среды при отличии идентификатора процесса.

--------------------------------------------------------------------------------

## v0.12.12 "Доллежаль" от 2024-10-27

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов,
в память о советском ученом-энергетике Николае Антоновиче Доллежаль в день 125-летия со дня его рождения.

Это последний выпуск куста стабильных версий 0.12.x, спустя более двух
лет после выпуска 0.12.1. Последующие выпуски 0.12.x будут формироваться
только в случае существенных проблем/ошибок, вероятность чего близка к
нулю. Для всех проектов находящихся в стадии активной разраборки
рекомендуется использовать ветку `master`.

```
git diff' stat: x commits, y files changed, z insertions(+), zz deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Значимые исправления:

 - Исправление упущенного `TXN_END_EOTDONE` при сбое старта читающей транзакции.
   Упомянутый флажок отсутствовал в пути разрушения транзакции при ошибке
   её запуска. Из-за чего делалась попытка разрушить курсоры, что приводило
   к падению **отладочных сборок**, так как в них соответствующий массив
   намеренно заполнен некорректными указателями.

 - Устранение возможности `SIGSEGV` внутри `coherency_check()` после
   изменения геометрии другим процессом с увеличением верхнего размера БД
   и увеличением БД больше предыдущего лимита.

 - Доработка `mdbx_close_dbi()` для возврата ошибки при попытке закрыть
   dbi-дескриптор таблицы, созданной и/или измененной в ещё выполняющейся
   транзакции. Такое преждевременное закрытие дескриптора является неверным
   использованием API и нарушением контракта/предусловий сформулированных
   в описании `mdbx_close_dbi()`. Однако, вместо возврата ошибки
   выполнялось некорректное закрытие дескриптора, что могло приводить к
   созданию таблицы с пустым именем, утечки страниц БД и/или нарушению
   структуры b-tree (неверной ссылкой на корень таблицы).
   Добавлен соответствующий тест `extra/early_close_dbi`.

--------------------------------------------------------------------------------

## v0.12.11 "Лиза и Соня" от 2024-07-23

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов,
в память об убитых в Крыму девочках 2 и 9 лет.

Лиза и Соня погибли 23 Июня 2024 на глазах у родителей, в результате
удара по общественному городскому пляжу ракетами ATACMS с кассетными
боеприпасами. Всего пострадало более 150 граждан России, в том числе 27
детей. Ракеты были выпущенными украинскими бандеровцами/фашистами, но
полетные задания формировались и загружались военными США, а управление
и наведение ATACAMS невозможно без использования орбитальной группировки
военных спутников США.

```
git diff' stat: 29 commits, 14 files changed, 379 insertions(+), 151 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Значимые исправления:

 - Исправление для ОС Windows нарезки `FILE_SEGMENT_ELEMENT`.
   Похоже что был потерян коммит входе работы над оптимизацией пути записи
   на диск в ОС Windows. В текущем понимании, вероятность проявления ошибки
   достаточно низкая, так как выявлена она была синтетическими тестами в
   ходе других доработок, а соответствующих сообщений/жалоб не поступало. К
   повреждению БД ошибка не приводила, так как сбой происходил до записи
   данных с возвратом `ERROR_INVALID_PARAMETER` из системного вызова, т.е.
   либо ошибка не проявлялась, либо транзакция не фиксировалась.

 - Устранение вероятности `SIGSEGV` при включении логирования
   уровня `MDBX_LOG_TRACE` в отладочных сборках.

 - Исправление генерации исключения `key_exists` в C++ API.

 - Исправление опечаток в документации и README.

 - Исправление обработки курсоров, открытых в родительских транзакциях и
   закрытых до завершения вложенных транзакций. В описанной ситуации
   закрытые курсоры "воскрешались", что приводило к утечке памяти
   выделенной под такие курсоры.

 - Костыль для MSVC ARM/ARM64 для предотвращения ICE (Internal Compiler Error).

 - Устранение `MDBX_EINVAL` для случая вызова `mdbx_env_remove(".")`.

 - Исправление инверсии bool-результата `env::remove()` в C++ API.

 - Исправление опечатки `равно`/`неравно` в условии внутри
   `update_gc()`. Существенных последствий ошибки не было, но в
   определенных сценариях, сходимость требовала еще одного цикла повтора
   внутри update_gc().

Прочие доработки:

 - Проверка совместимости флагов GC/FreeDB на случай их изменения в будущих версиях.
 - Очистка сообщений `FormatMessageA()` от концевых переводов строк.
 - Уточнение макроса `__always_inline` для особо яблочных версий CLANG.
 - Использование `\n` вместо `std::endl` в C++ API для разделения строк в кодировщиках данных.
 - Проверка дополнительных и пока не используемых полей в meta-страницах.
 - Отключение ненужной отладки внутри `txn_merge()`.
 - Исправление условий и привязки к версиям компиляторов при формировании макроса `MDBX_DEPRECATED`.
 - Больше атрибутов `__cold` для редко-используемых функций (backport).
 - Добавление методов `buffer::append_bytes()` и `buffer::clear_and_reserve()`.
 - Отключение установки признака фатальной ошибки для не-активной среды при отличии идентификатора процесса.

--------------------------------------------------------------------------------

## v0.12.10 "СЭМ" от 2024-03-12

Поддерживающий выпуск с исправлением обнаруженных ошибок и устранением недочетов
в память Героя России гвардии майора Дмитрия Семёнова с позывным "СЭМ".

```
git diff' stat: 19 commits, 57 files changed, 751 insertions(+), 331 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - [Dvir H](https://t.me/Dvirsw) за [сообщение](https://t.me/libmdbx/5368)
   об ошибке `MDBX_CORRUPTED` в сценарии работы в режиме `MDBX_DUPFIXED` и нечетной длиной
   мульти-значений, с предоставлением точного минимального сценария воспроизведения.

Значимые исправления и доработки:

 - Устранение унаследованной от LMDB ошибки приводящей к повреждению БД при использовании `MDBX_DUPFIXED`.
   Проблема была выявлена при расширении тестов сценариями с длинными мульти-значениями в режиме `MDBX_DUPFIXED`.
   Сообщений о проявлении этой ошибки в эксплуатационных/продуктовых средах не поступало.

   На LEAF2-страниц, используемых для компактного хранения мульти-значений фиксированной длины,
   выполнялось резервирование места без учета возможности превышения размера страниц,
   с последующим переполнением, повреждением структуры БД и/или повреждением содержимого ОЗУ.

   Вероятность проявления ошибки существенно увеличивалась с увеличением размера/длины
   мульти-значений/дубликатов и уменьшением размера страницы БД. Поэтому при использовании `MDBX_INTEGERDUP`
   вероятность проявления близка к нулю, а сценарий такого проявления найти не удалось.

   В MDBX ошибка присутствовала с момента отделения проекта от LMDB,
   где эта ошибка присутствует более 11 лет, по настоящее время.

 - Исправление ложной ошибки `MDBX_CORRUPTED (-30796)` в сценарии работы
   в режиме `MDBX_DUPFIXED` и нечетной длиной мульти-значений.

 - Исправление недочета корректировки сопутствующих курсоров при разделении страницы
   по сценарию добавления пустой страницы слева.

 - Доработка `rebalance()` ради уменьшения WAF. Новый функционал, включая
   контролируемую пользователем опцию `enum MDBX_option_t`, будет доступен
   в выпусках ветки `0.13.x`, а в этом выпуске доработка сводится к тактике
   не-вовлечения чистой страницы при нехватке запаса страниц в ходе обновления GC,
   за счет ухудшения баланса дерева страниц.

 - Устранение упущения приводящего к нелогичной ситуации
   `me_dxb_mmap.curren > me_dxb_mmap.limit` при "дребезге" размера БД.
   В текущем понимании, последствий кроме срабатывания assert-проверки нет, а
   вероятность проявления близка к нулю.

 - Исправление в функционале обхода дерева, используемого утилитой
   `mdbx_chk`, подсчета места затраченного на выравнивание на вложенной
   под-странице, в случае нечетного количества dupfixed-элементов нечетного
   размера.
   Сообщений о проявлении этой ошибки в эксплуатационных/продуктовых средах не поступало.

 - Исправление assert-проверки внутри `check_txn()` для случая завершенных транзакций в режиме `MDBX_NO_TLS`.
   Последствий ошибки, кроме срабатывания assert-проверки в отладочных сборках, нет.

 - Устранение ошибки при открытии БД на файловой системе только-для-чтения.

 - Удалены излишне строгие проверки в утилите `mdbx_chk`, которые
   приводили к ложно-позитивным ошибкам при проверке БД после серии
   последних доработок. Подробности см в комментариях к коммитам [781b3f64d52b73cbaeb00a55811d1247c25624a8](https://gitflic.ru/project/erthink/libmdbx/commit/781b3f64d52b73cbaeb00a55811d1247c25624a8)
   и [0741c81cfd8dc0864fcf55e04192b2207c8f68f7](https://gitflic.ru/project/erthink/libmdbx/commit/0741c81cfd8dc0864fcf55e04192b2207c8f68f7).

Прочее:

 - Расширение стохастического теста dupfixed-сценариями.
 - Корректировка условия в assert-проверке для `MDBX_TXN_DRAINED_GC`.
 - Добавление в jitter-сценарий простого теста сброса и перезапуска читающих транзакций.
 - Вынужденное продолжение очистки/рефакторинга унаследованных ребусов в `cursor_put_nochecklen()`.
 - Фиксация транзакции при ошибках теста для последующего анализа содержимого БД.
 - Сопутствующий рефакторинг `node_shrink()` для ясности исходного кода.
 - Приведение в соответствие протоколируемых имен тестов опциям командной строки.
 - Добавление cmoke-теста `extra/dupfixed_addodd`.

--------------------------------------------------------------------------------

## v0.12.9 "Ясень-4" от 2023-12-11

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением недочетов.

```
git diff' stat: 32 commits, 8 files changed, 667 insertions(+), 401 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Исправления и доработки:

 - Ликвидация зависимости от ранее удаленной опции `MDBX_ENABLE_PREFAULT`, из-за
   чего опция `MDBX_ENABLE_MINCORE` не включалась автоматически, что приводило
   к не-активации соответствующего улучшения и не-достижению  декларируемого уровня
   производительности в сценариях использования в режиме `MDBX_WRITEMAP`.

 - Исправление авто-установки `MDBX_ENV_CHECKPID` при отключении использования
   функционала `madvise()` посредством опции сборки `MDBX_ENABLE_MADVISE=0`.
   Из-за чего при поддержке системой `madvise(MADV_DONTFORK)` не включался контроль pid.

 - Добавлена проверка переданного ключа на `NULL` при обработке `MDBX_GET_MULTIPLE`.

 - Добавлена проверка номеров корневых страниц в `coherency_check()`.

 - Обеспечен `const` для начала и конца диапазона в аргументах `mdbx_estimate_range()`.

 - Из разрабатываемой версии перенесены не-нарушающие совместимости доработки C++ API:

     - добавлен тип `mdbx::cursor::estimate_result`, а поведение методов
      `cursor::estimate()` унифицировано с `cursor::move()`;
     - для предотвращения незаметного неверного использования API, для инициализации
       возвращаемых по ссылке срезов, вместо пустых срезов задействован `slice::invalid()`;
     - добавлены дополнительные C++ операторы преобразования к типам C API;
     - для совместимости со старыми стандартами C++ и старыми версиями STL перенесены
       в public классы `buffer::move_assign_alloc` и `buffer::copy_assign_alloc`;
     - добавлен тип `mdbx::default_buffer`;
     - для срезов и буферов добавлены методы `hex_decode()`, `base64_decode()`, `base58_decode()`;
     - добавлен тип `mdbx::comparator` и функций `mdbx::default_comparator()`;
     - добавлены статические методы `buffer::hex()`, `base64()`, `base58()`;
     - для транзакций и курсоров добавлены методы `get_/set_context`;
     - добавлен метод `cursor::clone()`;

 - Поддержка base58 приведена в соответствии с черновиком RFC.

 - Переработка/исправление `to_hex()` и `from_hex()`.

 - Уменьшение `MDBX_opt_rp_augment_limit` по умолчанию до 1/3 от текущего количества страниц в БД.

Мелочи:

 - Удаление устаревших `mdbx_set_compare()` и `mdbx_set_dupsort()`.
 - Корректировка определения `MDBX_LAST_ADDED_ERRCODE`.
 - Добавление в C++ API забытого исключения `mdbx::duplicated_lck_file`.
 - Обновление патча для старых версий buildroot.
 - Использование в API `const MDBX_txn` где это возможно.
 - Удаление устаревшего упоминания `MDBX_EAGAIN`.
 - Проверка pid процесса только в функциях API требующих активной среды/env.
 - Исправление опечаток в комментариях, в том числе  в doxygen-описании.
 - В тестах для совместимости с проблемными версиями glibc и glibc++
   устранено использование `std::stoull()`.

--------------------------------------------------------------------------------

## v0.12.8 "Владимир Уткин" от 2023-10-17

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением недочетов,
в день 100-летия со дня рождения выдающегося советского и российского ученого и конструктора [Влади́мира Фёдоровича У́ткина](https://ru.wikipedia.org/wiki/Уткин,_Владимир_Фёдорович).

```
git diff' stat: 24 commits, 18 files changed, 624 insertions(+), 94 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - [Alain Picard](https://github.com/castortech) за сообщение о проблеме
   с обработкой `MDBX_MULTIPLE` и помощь в тестировании.

Исправления и доработки:

 - Устранение регресса/ошибки в пути обработки `put(MDBX_MULTIPLE)` при пакетном/оптовом
   помещении в БД множественных значений одного ключа (aka multi-value или dupsort).
   Проявление проблемы зависит от компилятора и опций оптимизации/кодогенерации, но с большой вероятностью возвращается
   ошибка `MDBX_BAD_VALSIZE` (`-30781`), а в отладочных сборках срабатывает проверка `cASSERT(mc, !"Invalid key-size")`.
   Сценарии приводящие к другим проявлениям на данный момент не известны.

 - Реализована перезапись в `mdbx_put(MDBX_CURRENT)` всех текущих мульти-значений ключа
   при отсутствии флага `MDBX_NOOVERWRITE`. Ранее в такой ситуации возвращалась ошибка `MDBX_EMULTIVAL`.
   В текущем понимании новое поведение более удобно и не создаёт проблем совместимости с ранее написанным кодом.

 - Добавлена возможность использовать `mdbx_cursor_get(MDBX_GET_MULTIPLE)` без предварительной установки
   курсора, совмещая операцию пакетного получения данных с позиционированием курсора на передаваемый ключ.

 - Микрооптимизация и рефакторинг `cursor_put_nochecklen()` в продолжение исправления
   регресса/ошибки в пути обработки `put(MDBX_MULTIPLE)`.

 - Уточнение формулировок в описании API, в том числе пояснений о `SIGSEGV`
   и недопустимости прямого изменения данных.

Мелочи:

 - Исправление несущественных предупреждений при `MDBX_ENABLE_PROFGC=ON`.
 - Добавление `slice::as_pod<typename>()` в C++ API.
 - Добавление перегрузки `txn::put_multiple()` и контроля POD в C++ API.
 - Добавление smoke-теста для `put(MDBX_MULTIPLE)`.
 - Добавление дополнительных smoke-тестов в область видимости ctest.
 - Устранение жалоб Valgrind на инвариантное чтение неинициализированной памяти
   и утечки памяти в одном из тестов.
 - Костыль для глушения/игнорирования `EDEADLK` в ряде сценариев при
   использовании Valgrind или ASAN. В частности, это устраняет
   ложно-негативный результат проверки БД посредством `mdbx_chk -wc`,
   т.е. проверку БД в кооперативном (не эксклюзивном) режиме чтения-записи
   в сборках с поддержкой Valgrind или включеным ASAN. Для более подробной
   информации см. [соответствующий коммит](https://gitflic.ru/project/erthink/libmdbx/commit/1aead6869a7eff1a85e400ab3eeecb4c8b904fe6).
 - Доработка `mdbx_dump_val()` используемой для логирования и отладки.
 - Устранение предупреждений Valgrind при логировании в отладочных сборках.
 - Доработка использования `filesystem` для старых компиляторов.
 - Сокращение излишнего вызова `osal_thread_self()`.
 - Вывод информации о большинстве mdbx-опций при сборке посредством CMake.
 - Добавление определений макросов для Doxygen.

--------------------------------------------------------------------------------

## v0.12.7 "Артек" от 2023-06-16

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением
недочетов, в день основания международного детского центра [«Арте́к»](https://ru.wikipedia.org/wiki/Артек).

```
14 files changed, 222 insertions(+), 56 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Исправления и доработки:

  - Исправление опечатки в имени переменной внутри `mdbx_env_turn_for_recovery()`,
    что приводило к неверному поведению в некоторых ситуациях.

    С точки зрения пользователя, с учетом актуальных сценариев использования
    утилиты `mdbx_chk`, был только один специфический/редкий сценарий
    проявления ошибки/проблемы - когда выполнялась проверка и активация
    слабой/weak мета-страницы с НЕ-последней транзакцией после системной
    аварии машины, где БД использовалась в хрупком/небезопасном режиме.
    В сценарии, при успешной проверке целевой страницы и её последующей
    активации выводилось сообщение об ошибке, связанной со срабатыванием
    механизма контроля не-когерентности кэша файловой системы и отображенных
    в ОЗУ данных БД. При этом БД успешно восстанавливалось и не было
    каких-либо негативных последствия, кроме самого сообщения об ошибке.

    Технически же ошибка проявлялась при "переключении" на мета-страницу,
    когда у хотя-бы одной из двух других мета-страниц номер транзакции был
    больше:

      * Если содержимое других мета-страниц было корректным, а номера
        связанных транзакций были больше, то результирующий номер транзакции в
        целевой/активируемой мета-страницы устанавливается без учета этих
        мета-страниц и мог быть меньше-или-равным.

      * В результате, если такие мета-страницы были в статусе слабых/weak, то
        при закрытии БД после переключения могла срабатывать защита от
        не-когерентности unified buffer/page cache, а в отладочных сборках могла
        срабатывать assert-проверка.

      * Если же такие мета-страницы были в статусе сильных/steady, то
        переключение на новую мета-страницу могло не давать эффекта либо
        приводить к появлению двух мета-страниц с одинаковым номером транзакции,
        что является ошибочной ситуацией.

  - Обходное решение проблем сборки посредством GCC с использование опций `-m32 -arch=i686 -Ofast`.
    Проблема обусловлена ошибкой GCC, из-за которой конструкция `__attribute__((__target__("sse2")))`
    не включает полноценное использование инструкций SSE и SSE2, если это не было сделано посредством
    опций командной строки, но была использована опция `-Ofast`. В результате сборка заканчивалась
    сообщением об ошибке:
        `error: inlining failed in call to 'always_inline' '_mm_movemask_ps': target specific option mismatch`

  - Доработка режима "восстановления" БД и переключения на заданную мета-страницу:
      * Устранение обновления без необходимости мета-страницы с увеличением номера транзакции;
      * Устранение вывода (логирования) бессмысленного/лишнего предупреждения о пропуске обновления геометрии БД;
      * Более ожидаемое и безопасное поведение при проверке БД с указанием целевой мета-страницы в режиме чтения-записи.

    Теперь при открытии БД посредством `mdbx_env_open_for_recovery()` не
    выполняется неявное изменение/обновление БД, в том числе при закрытии
    БД. Это позволяет обезопасить БД (снизить шанс её разрушения) если
    пользователь при попытке восстановления, либо просто в качестве
    эксперимента, задал утилите `mdbx_chk` неверную или опасную комбинацию
    параметров. При этом обычная проверка, как и явное переключение
    мета-страниц, работают по-прежнему.

Мелочи:

 - Незначительное уточнение CMake-пробника для `std::filesystem`,
   проверяющего необходимость линковки с дополнительными библиотеками C++.
 - Устранение минорных предупреждений старых компиляторов в тестах.
 - Устранение причины ложно-позитивного предупреждения новых версий GCC в C++ API.
 - Исправление ссылки на репозиторий бенчмарка ioarena.
 - Добавление перекрестных ссылок в doxygen-документацию по C++ API.
 - Уточнение ограничений в разделе [Restrictions & Caveats](https://libmdbx.dqdkfa.ru/intro.html#restrictions).
 - Исправление ссылок на описание `mdbx_canary_put()`.

--------------------------------------------------------------------------------

## v0.12.6 "ЦСКА" от 2023-04-29

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением
недочетов, в день 100-летнего юбилея спортивного клуба [«ЦСКА»](https://ru.wikipedia.org/wiki/Центральный_спортивный_клуб_Армии).

```
14 files changed, 117 insertions(+), 83 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Мелочи:

 - Обновление патча для старых версий buildroot.
 - Использование clang-format-16.
 - Использование `enum`-типов вместо `int` для устранения предупреждений GCC 13,
   что могло ломать сборку в Fedora 38.

--------------------------------------------------------------------------------

## v0.12.5 "Динамо" от 2023-04-18

Стабилизирующий выпуск с исправлением обнаруженных ошибок и устранением
недочетов, в день 100-летнего юбилея спортивного общества [«Динамо»](https://ru.wikipedia.org/wiki/Динамо_(спортивное_общество)).

```
16 files changed, 686 insertions(+), 247 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - Max <maxc0d3r@protonmail.com> за сообщение о проблеме экспорта из DSO/DLL
   устаревших функций API.
 - [`@calvin3721`](https://t.me/calvin3721) за сообщение о проблеме работы
   `MainDB` с флагами не по-умолчанию.

Исправления:

 - Поправлен экспорт из DSO/DLL устаревших функций,
   которые заменены на inline в текущем API.
 - Устранено использование неверного компаратора при создании или пересоздании
   `MainDB` с флагами/опциями предполагающим использование специфического
   компаратора (не по-умолчанию).

Мелочи:

 - Удалена дублирующая диагностика внутри `node_read_bigdata()`.
 - Исправлены ссылки в описании `mdbx_env_set_geometry()`.
 - Добавлен отдельный тест `extra/upsert_alldups` для специфического
   сценария замены/перезаписи одним значением всех multi-значений
   соответствующих ключу, т.е. замена всех «дубликатов» одним значением.
 - В C++ API добавлены варианты `buffer::key_from()` с явным именованием по типу данных.
 - Добавлен отдельный тест `extra/maindb_ordinal` для специфического
   сценария создания `MainDB` с флагами требующими использования
   компаратора не по-умолчанию.
 - Рефакторинг проверки "когерентности" мета-страниц.
 - Корректировка `osal_vasprintf()` для устранения предупреждений статических анализаторов.

--------------------------------------------------------------------------------

## v0.12.4 "Арта-333" от 2023-03-03

Стабилизирующий выпуск с исправлением обнаруженных ошибок, устранением
недочетов и технических долгов. Ветка 0.12 считается готовой к
продуктовому использованию, получает статус стабильной и далее будет
получать только исправление ошибок. Разработка будет продолжена в ветке
0.13, а ветка 0.11 становится архивной.

```
63 files changed, 1161 insertions(+), 569 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - Max <maxc0d3r@protonmail.com> за сообщение о проблеме ERROR_SHARING_VIOLATION
   в режиме MDBX_EXCLUSIVE на Windows.
 - Alisher Ashyrov <https://t.me/a1is43ras4> за сообщение о проблеме
   с assert-проверкой и содействие в отладке.
 - Masatoshi Fukunaga <https://gitflic.ru/user/mah0x211> за сообщение о проблеме
   `put(MDBX_UPSERT+MDBX_ALLDUPS)` для случая замены всех значений в subDb.

Исправления:

 - Устранен регресс после коммита 474391c83c5f81def6fdf3b0b6f5716a87b78fbf,
   приводящий к возврату ERROR_SHARING_VIOLATION в Windows при открытии БД
   в режиме MDBX_EXCLUSIVE для чтения-записи.

 - Добавлено ограничение размера отображения при коротком read-only файле, для
   предотвращения ошибки ERROR_NOT_ENOUGH_MEMORY в Windows, которая возникает
   в этом случае и совсем не информативна для пользователя.

 - Произведен рефакторинг `dxb_resize()`, в том числе, для устранения срабатывания
   assert-проверки `size_bytes == env->me_dxb_mmap.current` в специфических
   многопоточных сценариях использования. Проверка срабатывала только в
   отладочных сборках, при специфическом наложении во времени читающей и
   пишущей транзакции в разных потоках, одновременно с изменением размера БД.
   Кроме срабатывание проверки, каких-либо других последствий не возникало.

 - Устранена проблема в `put(MDBX_UPSERT+MDBX_ALLDUPS)` для случая замены
   всех значений единственного ключа в subDb. В ходе этой операции subDb
   становится полностью пустой, без каких-либо страниц и именно эта
   ситуация не была учтена в коде, что приводило к повреждению БД
   при фиксации такой транзакции.

 - Устранена излишняя assert-проверка внутри `override_meta()`.
   Что в отладочных сборках могло приводить к ложным срабатываниям
   при восстановлении БД, в том числе при автоматическом откате слабых
   мета-страниц.

 - Скорректированы макросы `__cold`/`__hot`, в том числе для устранения проблемы
   `error: inlining failed in call to ‘always_inline FOO(...)’: target specific option mismatch`
   при сборке посредством GCC >10.x для SH4.

Ликвидация технических долгов и мелочи:

 - Исправлены многочисленные опечатки в документации.
 - Доработан тест для полной стохастической проверки `MDBX_EKEYMISMATCH` в режиме `MDBX_APPEND`.
 - Расширены сценарии запуска `mdbx_chk` из CMake-тестов для проверки как в обычном,
   так и эксклюзивном режимах чтения-записи.
 - Уточнены спецификаторы `const` и `noexcept` для нескольких методов в C++ API.
 - Устранено использование стека под буферы для `wchar`-преобразования путей.
 - Для Windows добавлена функция `mdbx_env_get_path()` для получения пути к БД
   в формате многобайтных символов.
 - Добавлены doxygen-описания для API с широкими символами.
 - Устранены предупреждения статического анализатора MSVC,
   все они были несущественные, либо ложные.
 - Устранено ложное предупреждение GCC при сборке для SH4.
 - Добавлена поддержка ASAN (Address Sanitizer) при сборке посредством MSVC.
 - Расширен набор перебираемых режимов в скрипте `test/stochastic.sh`,
   добавлена опция `--extra`.
 - В C++ API добавлена поддержка расширенных опций времени выполнения `mdbx::extra_runtime_option`,
   аналогично `enum MDBX_option_t` из C API.
 - Вывод всех счетчиков page-operations в `mdbx_stat`.

--------------------------------------------------------------------------------

## v0.12.3 "Акула" от 2023-01-07

Выпуск с существенными доработками и новой функциональностью в память о закрытом open-source
[проекте "Акула"](https://erigon.substack.com/p/winding-down-support-for-akula-project).

Добавлена prefault-запись, переделан контроль “некогерентности” unified page/buffer cache, изменена тактика слияния страниц и т.д.
Стало ещё быстрее, в некоторых сценариях вдвое.

```
20 files changed, 4508 insertions(+), 2928 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Благодарности:

 - [Alex Sharov](https://t.me/AskAlexSharov) и команде [Erigon](https://github.com/ledgerwatch/erigon) за тестирование.
 - [Simon Leier](https://t.me/leisim) за сообщение о сбоях и тестирование.

Новое:

 - Использование адреса [https://libmdbx.dqdkfa.ru/dead-github](https://libmdbx.dqdkfa.ru/dead-github)
   для отсылки к сохранённым в web.archive.org копиям ресурсов, уничтоженных администрацией Github.

 - Реализована prefault-запись при выделении страниц для read-write отображений.
   Это приводит к кратному снижению системных издержек и существенному увеличению
   производительности в соответствующих сценариях использования, когда:
    - размер БД и объём данных существенно больше ОЗУ;
    - используется режим `MDBX_WRITEMAP`;
    - не-мелкие транзакции (по ходу транзакции выделяется многие сотни или тысячи страниц).

   В режиме `MDBX_WRITEMAP` выделение/переиспользование страниц приводит
   к page-fault и чтению страницы с диска, даже если содержимое страницы
   не нужно (будет перезаписано). Это является следствием работы подсистемы
   виртуальной памяти, а штатный способ лечения через `MADV_REMOVE`
   работает не на всех ФС и обычно дороже получаемой экономии.

   Теперь в libmdbx используется "упреждающая запись" таких страниц,
   которая на системах с [unified page cache](https://www.opennet.ru/base/dev/ubc.txt.html)
   приводит к "вталкиванию" данных, устраняя необходимость чтения с диска при
   обращении к такой странице памяти.

   Новый функционал работает в согласованности с автоматическим управлением read-ahead
   и кэшем статуса присутствия страниц в ОЗУ, посредством [mincore()](https://man7.org/linux/man-pages/man2/mincore.2.html).

 - Добавлена опция `MDBX_opt_prefault_write_enable` для возможности принудительного
   включения/выключения prefault-записи.

 - Реализован динамический выбор между сквозной записью на диск и обычной записью
   с последующим [fdatasync()](https://man7.org/linux/man-pages/man3/fdatasync.3p.html)
   управляемый опцией `MDBX_opt_writethrough_threshold`.

   В долговечных (durable) режимах данные на диск могут быть сброшены двумя способами:
     - сквозной записью через файловый дескриптор открытый с `O_DSYNC`;
     - обычной записью с последующим вызовом `fdatasync()`.

   Первый способ выгоднее при записи малого количества страниц и/или если
   канал взаимодействия с диском/носителем имеет близкую к нулю задержку.
   Второй способ выгоднее если требуется записать много страниц и/или канал
   взаимодействия имеет весомую задержку (датацентры, облака). Добавленная
   опция `MDBX_opt_writethrough_threshold` позволяет во время выполнения
   задать порог для динамического выбора способа записи в зависимости от
   объема и конкретных условия использования.

 - Автоматическая установка `MDBX_opt_rp_augment_limit` в зависимости от размера БД.

 - Запрещение разного режима `MDBX_WRITEMAP` между процессами в режимах
   с отложенной/ленивой записью, так как в этом случае невозможно
   обеспечить сброс данных на диск во всех случаях на всех поддерживаемых платформах.

 - Добавлена опция сборки `MDBX_MMAP_USE_MS_ASYNC` позволяющая отключить
   использование системного вызова `msync(MS_ASYNC)`, в использовании
   которого нет необходимости на подавляющем большинстве актуальных ОС.
   По-умолчанию `MDBX_MMAP_USE_MS_ASYNC=0` (выключено) на Linux и других
   системах с unified page cache. Такое поведение (без использования
   `msync(MS_ASYNC)`) соответствует неизменяемой (hardcoded) логике LMDB. В
   результате, в простых/наивных бенчмарках, libmdbx опережает LMDB
   примерно также как при реальном применении.

   На всякий случай стоит еще раз отметить/напомнить, что на Windows
   предположительно libmdbx будет отставать от LMDB в сценариях с
   множеством мелких транзакций, так как libmdbx осознанно использует на
   Windows файловые блокировки, которые медленные (плохо реализованы в ядре
   ОС), но позволяют застраховать пользователей от массы неверных действий
   приводящих к повреждению БД.

 - Поддержка не-печатных имен для subDb.

 - Добавлен явный выбор `tls_model("local-dynamic")` для обхода проблемы
   `relocation R_X86_64_TPOFF32 against FOO cannot be used with -shared`
   из-за ошибки в CLANG приводящей к использованию неверного режима `tls_model`.

 - Изменение тактики слияния страниц при удалении.
   Теперь слияние выполняется преимущественно с уже измененной/грязной страницей.
   Если же справа и слева обе страницы с одинаковым статусом,
   то с наименее заполненной, как прежде. В сценариях с массивным удалением
   это позволяет увеличить производительность до 50%.

 - Добавлен контроль отсутствия LCK-файлов с альтернативным именованием.

Исправления (без корректировок новых функций):

 - Изменение размера отображения если это требуется для сброса данных на
   диск при вызове `mdbx_env_sync()` из параллельного потока выполнения вне
   работающей транзакции.

 - Исправление регресса после коммита db72763de049d6e4546f838277fe83b9081ad1de от 2022-10-08
   в логике возврата грязных страниц в режиме `MDBX_WRITEMAP`, из-за чего
   освободившиеся страницы использовались не немедленно, а попадали в
   retired-список совершаемой транзакции и происходил необоснованный рост
   размера транзакции.

 - Устранение SIGSEGV или ошибочного вызова `free()` в ситуациях
   повторного открытия среды посредством `mdbx_env_open()`.

 - Устранение ошибки совершенной в коммите fe20de136c22ed3bc4c6d3f673e79c106e824f60 от 2022-09-18,
   в результате чего на Linux в режиме `MDBX_WRITEMAP` никогда не вызывался `msync()`.
   Проблема существует только в релизе 0.12.2.

 - Добавление подсчета грязных страниц в `MDBX_WRITEMAP` для предоставления посредством `mdbx_txn_info()`
   актуальной информации об объеме изменений в процессе транзакций чтения-записи.

 - Исправление несущественной опечатки в условиях `#if` определения порядка байт.

 - Исправление сборки для случая `MDBX_PNL_ASCENDING=1`.

Ликвидация технических долгов и мелочи:

 - Доработка поддержки авто-слияния записей GC внутри `page_alloc_slowpath()`.
 - Устранение несущественных предупреждений Coverity.
 - Использование единого курсора для поиска в GC.
 - Переработка внутренних флагов связанных с выделением страниц из GC.
 - Доработка подготовки резерва перед обновлением GC при включенном BigFoot.
 - Оптимизация `pnl_merge()` для случаев неперекрывающихся объединяемых списков.
 - Оптимизация поддержки отсортированного списка страниц в `dpl_append()`.
 - Ускорение работы `mdbx_chk` при обработке пользовательских записей в `@MAIN`.
 - Переработка LRU-отметок для спиллинга.
 - Переработка контроля "некогерентности" Unified page cache для уменьшения накладных расходов.
 - Рефакторинг и микрооптимизация.

--------------------------------------------------------------------------------

## v0.12.2 "Иван Ярыгин" от 2022-11-11

Выпуск с существенными доработками и новой функциональностью
в память о российском борце [Иване Сергеевиче Ярыгине](https://ru.wikipedia.org/wiki/Ярыгин,_Иван_Сергеевич).

На Олимпийских играх в Мюнхене в 1972 году Иван Ярыгин уложил всех соперников на лопатки,
суммарно затратив менее 9 минут. Этот рекорд никем не побит до сих пор.

```
64 files changed, 5573 insertions(+), 2510 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Новое:

 - Поддержка всех основных опций при сборке посредством CMake.

 - Требования к CMake понижены до версии 3.0.2 для возможности сборки для устаревших платформ.

 - Добавлена возможность профилирования работы GC в сложных и/или нагруженных
   сценариях (например Ethereum/Erigon). По-умолчанию соответствующий код отключен,
   а для его активации необходимо указать опцию сборки `MDBX_ENABLE_PROFGC=1`.

 - Добавлена функция `mdbx_env_warmup()` для "прогрева" БД с возможностью
   закрепления страниц в памяти.
   В утилиты `mdbx_chk`, `mdbx_copy` и `mdbx_dump` добавлены опции `-u` и `-U`
   для активации соответствующего функционала.

 - Отключение учета «грязных» страниц в не требующих этого режимах
   (`MDBX_WRITEMAP` при `MDBX_AVOID_MSYNC=0`). Доработка позволяет снизить
   накладные расходы и была запланирована давно, но откладывалась так как
   требовала других изменений.

 - Вытеснение из памяти (спиллинг) «грязных» страниц с учетом размера
   large/overflow-страниц. Доработка позволяет корректно соблюдать политику
   задаваемую опциями `MDBX_opt_txn_dp_limit`,
   `MDBX_opt_spill_max_denominator`, `MDBX_opt_spill_min_denominator` и
   была запланирована давно, но откладывалась так как требовала других
   изменений.

 - Для Windows в API добавлены UNICODE-зависимые определения макросов
  `MDBX_DATANAME`, `MDBX_LOCKNAME` и `MDBX_LOCK_SUFFIX`.

 - Переход на преимущественное использование типа `size_t` для
   уменьшения накладных расходов на платформе Эльбрус.

 - В API добавлены функции `mdbx_limits_valsize4page_max()` и
   `mdbx_env_get_valsize4page_max()` возвращающие максимальный размер в
   байтах значения, которое может быть размещена в одной
   large/overflow-странице, а не последовательности из двух или более таких
   страниц. Для таблиц с поддержкой дубликатов вынос значений на
   large/overflow-страницы не поддерживается, поэтому результат совпадает с
   `mdbx_limits_valsize_max()`.

 - В API добавлены функции `mdbx_limits_pairsize4page_max()`и
   `mdbx_env_get_pairsize4page_max()` возвращающие в байтах максимальный
   суммарный размер пары ключ-значение для их размещения на одной листовой
   страницы, без выноса значения на отдельную large/overflow-страницу. Для
   таблиц с поддержкой дубликатов вынос значений на large/overflow-страницы
   не поддерживается, поэтому результат определяет максимальный/допустимый
   суммарный размер пары ключ-значение.

 - Реализовано использование асинхронной (overlapped) записи в Windows,
   включая использования небуферизированного ввода-вывода и `WriteGather()`.
   Это позволяет сократить накладные расходы и частично обойти проблемы
   Windows с низкой производительностью ввода-вывода, включая большие
   задержки `FlushFileBuffers()`. Новый код также обеспечивает консолидацию
   записываемых регионов на всех платформах, а на Windows использование
   событий (events) сведено к минимум, одновременно с автоматических
   использованием `WriteGather()`. Поэтому ожидается существенное снижение
   накладных расходов взаимодействия с ОС, а в Windows это ускорение, в
   некоторых сценариях, может быть кратным в сравнении с LMDB.

 - Добавлена опция сборки `MDBX_AVOID_MSYNC`, которая определяет
   поведение libmdbx в режиме `MDBX_WRITE_MAP` (когда данные изменяются
   непосредственно в отображенных в ОЗУ страницах БД):

    * Если `MDBX_AVOID_MSYNC=0` (по умолчанию на всех системах кроме Windows),
      то (как прежде) сохранение данных выполняется посредством `msync()`,
      либо `FlushViewOfFile()` на Windows. На платформах с полноценной
      подсистемой виртуальной памяти и адекватным файловым вводом-выводом
      это обеспечивает минимум накладных расходов (один системный вызов)
      и максимальную производительность. Однако, на Windows приводит
      к значительной деградации, в том числе из-за того что после
      `FlushViewOfFile()` требуется также вызов `FlushFileBuffers()`
      с массой проблем и суеты внутри ядра ОС.

    * Если `MDBX_AVOID_MSYNC=1` (по умолчанию только на Windows), то
      сохранение данных выполняется явной записью в файл каждой измененной
      страницы БД. Это требует дополнительных накладных расходов, как
      на отслеживание измененных страниц (ведение списков "грязных"
      страниц), так и на системные вызовы для их записи.
      Кроме этого, с точки зрения подсистемы виртуальной памяти ядра ОС,
      страницы БД измененные в ОЗУ и явно записанные в файл, могут либо
      оставаться "грязными" и быть повторно записаны ядром ОС позже,
      либо требовать дополнительных накладных расходов для отслеживания
      PTE (Page Table Entries), их модификации и дополнительного копирования
      данных. Тем не менее, по имеющейся информации, на Windows такой путь
      записи данных в целом обеспечивает более высокую производительность.

 - Улучшение эвристики включения авто-слияния записей GC.

 - Изменение формата LCK и семантики некоторых внутренних полей. Версии
   libmdbx использующие разный формат не смогут работать с одной БД
   одновременно, а только поочередно (LCK-файл переписывается при открытии
   первым открывающим БД процессом).

 - В `C++` API добавлены методы фиксации транзакции с получением информации
   о задержках.

 - Added `MDBX_HAVE_BUILT IN_CPU_SUPPORTS` build option to control use GCC's
   `__builtin_cpu_supports()` function, which could be unavailable on a fake
   OSes (macos, ios, android, etc).

Исправления (без корректировок вышеперечисленных новых функций):

 - Устранения ряда предупреждений при сборке посредством MinGW.
 - Устранение ложно-положительных сообщений от Valgrind об использовании
   не инициализированных данных из-за выравнивающих зазоров в `struct troika`.
 - Исправлен возврат неожиданной ошибки `MDBX_BUSY` из функций `mdbx_env_set_option()`,
   `mdbx_env_set_syncbytes()` и `mdbx_env_set_syncperiod()`.
 - Небольшие исправления для совместимости с CMake 3.8
 - Больше контроля и осторожности (паранойи) для страховки от дефектов `mremap()`.
 - Костыль для починки сборки со старыми версиями `stdatomic.h` из GNU Lib C,
   где макросы `ATOMIC_*_LOCK_FREE` ошибочно переопределяются через функции.
 - Использование `fcntl64(F_GETLK64/F_SETLK64/F_SETLKW64)` при наличии.
   Это решает проблему срабатывания проверочного утверждения при сборке для
   платформ где тип `off_t` шире соответствующих полей `структуры flock`,
   используемой для блокировки файлов.
 - Доработан сбор информации о задержках при фиксации транзакций:
    * Устранено искажение замеров длительности обновления GC
      при включении отладочного внутреннего аудита;
    * Защита от undeflow-нуля только общей задержки в метриках,
      чтобы исключить ситуации, когда сумма отдельных стадий
      больше общей длительности.
 - Ряд исправлений для устранения срабатываний проверочных утверждения в
   отладочных сборках.
 - Более осторожное преобразование к типу `mdbx_tid_t` для устранения
   предупреждений.
 - Исправление лишнего сброса данных на диск в режиме `MDBX_SAFE_NOSYNC`
   при обновлении GC.
 - Fixed an extra check for `MDBX_APPENDDUP` inside `mdbx_cursor_put()`
   which could result in returning `MDBX_EKEYMISMATCH` for valid cases.
 - Fixed nasty `clz()` bug (by using `_BitScanReverse()`, only MSVC builds affected).

Мелочи:

 - Исторические ссылки cвязанные с удалённым на ~~github~~ проектом  перенаправлены на [web.archive.org](https://web.archive.org/web/https://github.com/erthink/libmdbx).
 - Синхронизированы конструкции CMake между проектами.
 - Добавлено предупреждение о небезопасности RISC-V.
 - Добавлено описание параметров `MDBX_debug_func` и `MDBX_debug_func`.
 - Добавлено обходное решение для минимизации ложно-положительных
   конфликтов при использовании файловых блокировок в Windows.
 - Проверка атомарности C11-операций c 32/64-битными данными.
 - Уменьшение в 42 раза значения по-умолчанию для `me_options.dp_limit`
   в отладочных сборках.
 - Добавление платформы `gcc-riscv64-linux-gnu` в список для цели `cross-gcc`.
 - Небольшие правки скрипта `stochastic.sh` для работы в Windows.
 - Удаление ненужного вызова `LockFileEx()` внутри `mdbx_env_copy()`.
 - Добавлено описание использования файловых дескрипторов в различных режимах.
 - Добавлено использование `_CrtDbgReport()` в отладочных сборках.
 - Fixed an extra ensure/assertion check of `oldest_reader` inside `txn_end()`.
 - Removed description of deprecated usage of `MDBX_NODUPDATA`.
 - Fixed regression ASAN/Valgring-enabled builds.
 - Fixed minor MingGW warning.

--------------------------------------------------------------------------------

## v0.12.1 "Positive Proxima" at 2022-08-24

The planned frontward release with new superior features on the day of 20 anniversary of [Positive Technologies](https://ptsecurty.com).

```
37 files changed, 7604 insertions(+), 7417 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

New:

 - The `Big Foot` feature which significantly reduces GC overhead for processing large lists of retired pages from huge transactions.
   Now _libmdbx_ avoid creating large chunks of PNLs (page number lists) which required a long sequences of free pages, aka large/overflow pages.
   Thus avoiding searching, allocating and storing such sequences inside GC.
 - Improved hot/online validation and checking of database pages both for more robustness and performance.
 - New solid and fast method to latch meta-pages called `Troika`.
   The minimum of memory barriers, reads, comparisons and conditional transitions are used.
 - New `MDBX_VALIDATION` environment options to extra validation of DB structure and pages content for carefully/safe handling damaged or untrusted DB.
 - Accelerated ×16/×8/×4 by AVX512/AVX2/SSE2/Neon implementations of search page sequences.
 - Added the `gcrtime_seconds16dot16` counter to the "Page Operation Statistics" that accumulates time spent for GC searching and reclaiming.
 - Copy-with-compactification now clears/zeroes unused gaps inside database pages.
 - The `C` and `C++` APIs has been extended and/or refined to simplify using `wchar_t` pathnames.
   On Windows the `mdbx_env_openW()`, `mdbx_env_get_pathW()`, `mdbx_env_copyW()`, `mdbx_env_open_for_recoveryW()` are available for now,
   but the `mdbx_env_get_path()` has been replaced in favor of `mdbx_env_get_pathW()`.
 - Added explicit error message for Buildroot's Microblaze toolchain maintainers.
 - Added `MDBX_MANAGE_BUILD_FLAGS` build options for CMake.
 - Speed-up internal `bsearch`/`lower_bound` implementation using branchless tactic, including workaround for CLANG x86 optimiser bug.
 - A lot internal refinement and micro-optimisations.
 - Internally counted volume of dirty pages (unused for now but for coming features).

Fixes:

 - Never use modern `__cxa_thread_atexit()` on Apple's OSes.
 - Don't check owner for finished transactions.
 - Fixed typo in `MDBX_EINVAL` which breaks MingGW builds with CLANG.

## v0.12.0 at 2022-06-19

Not a release but preparation for changing feature set and API.

********************************************************************************

## v0.11.14 "Sergey Kapitsa" at 2023-02-14

The stable bugfix release in memory of [Sergey Kapitsa](https://en.wikipedia.org/wiki/Sergey_Kapitsa) on his 95th birthday.

```
22 files changed, 250 insertions(+), 174 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Fixes:
 - backport: Fixed insignificant typo of `||` inside `#if` byte-order condition.
 - backport: Fixed `SIGSEGV` or an erroneous call to `free()` in situations where
   errors occur when reopening by `mdbx_env_open()` of a previously used
   environment.
 - backport: Fixed `cursor_put_nochecklen()` internals for case when dupsort'ed named subDb
   contains a single key with multiple values (aka duplicates), which are replaced
   with a single value by put-operation with the `MDBX_UPSERT+MDBX_ALLDUPS` flags.
   In this case, the database becomes completely empty, without any pages.
   However exactly this condition was not considered and thus wasn't handled correctly.
   See [issue#8](https://gitflic.ru/project/erthink/libmdbx/issue/8) for more information.
 - backport: Fixed extra assertion inside `override_meta()`, which could
   lead to false-positive failing of the assertion in a debug builds during
   DB recovery and auto-rollback.
 - backport: Refined the `__cold`/`__hot` macros to avoid the
   `error: inlining failed in call to ‘always_inline FOO(...)’: target specific option mismatch`
   issue during build using GCC >10.x for SH4 arch.

Minors:

 - backport: Using the https://libmdbx.dqdkfa.ru/dead-github
   for resources deleted by the Github' administration.
 - backport: Fixed English typos.
 - backport: Fixed proto of `__asan_default_options()`.
 - backport: Fixed doxygen-description of C++ API, especially of C++20 concepts.
 - backport: Refined `const` and `noexcept` for few C++ API methods.
 - backport: Fixed copy&paste typo of "Getting started".
 - backport: Update MithrilDB status.
 - backport: Resolve false-posirive `used uninitialized` warning from GCC >10.x
   while build for SH4 arch.

--------------------------------------------------------------------------------

## v0.11.13 at "Swashplate" 2022-11-10

The stable bugfix release in memory of [Boris Yuryev](https://ru.wikipedia.org/wiki/Юрьев,_Борис_Николаевич) on his 133rd birthday.

```
30 files changed, 405 insertions(+), 136 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Fixes:

 - Fixed builds with older libc versions after using `fcntl64()` (backport).
 - Fixed builds with  older `stdatomic.h` versions,
   where the `ATOMIC_*_LOCK_FREE` macros mistakenly redefined using functions (backport).
 - Added workaround for `mremap()` defect to avoid assertion failure (backport).
 - Workaround for `encryptfs` bug(s) in the `copy_file_range` implementation  (backport).
 - Fixed unexpected `MDBX_BUSY` from `mdbx_env_set_option()`, `mdbx_env_set_syncbytes()`
   and `mdbx_env_set_syncperiod()` (backport).
 - CMake requirements lowered to version 3.0.2 (backport).

Minors:

 - Minor clarification output of `--help` for `mdbx_test` (backport).
 - Added admonition of insecure for RISC-V (backport).
 - Stochastic scripts and CMake files synchronized with the `devel` branch.
 - Use `--dont-check-ram-size` for small-tests make-targets (backport).

--------------------------------------------------------------------------------

## v0.11.12 "Эребуни" at 2022-10-12

The stable bugfix release.

```
11 files changed, 96 insertions(+), 49 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Fixes:

 - Fixed static assertion failure on platforms where the `off_t` type is wider
   than corresponding fields of `struct flock` used for file locking (backport).
   Now _libmdbx_ will use `fcntl64(F_GETLK64/F_SETLK64/F_SETLKW64)` if available.
 - Fixed assertion check inside `page_retire_ex()` (backport).

Minors:

 - Fixed `-Wint-to-pointer-cast` warnings while casting to `mdbx_tid_t` (backport).
 - Removed needless `LockFileEx()` inside `mdbx_env_copy()` (backport).

--------------------------------------------------------------------------------

## v0.11.11 "Тендра-1790" at 2022-09-11

The stable bugfix release.

```
10 files changed, 38 insertions(+), 21 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Fixes:

 - Fixed an extra check for `MDBX_APPENDDUP` inside `mdbx_cursor_put()` which could result in returning `MDBX_EKEYMISMATCH` for valid cases.
 - Fixed an extra ensure/assertion check of `oldest_reader` inside `mdbx_txn_end()`.
 - Fixed derived C++ builds by removing `MDBX_INTERNAL_FUNC` for `mdbx_w2mb()` and `mdbx_mb2w()`.

--------------------------------------------------------------------------------

## v0.11.10 "the TriColor" at 2022-08-22

The stable bugfix release.

```
14 files changed, 263 insertions(+), 252 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

New:

 - The C++ API has been refined to simplify support for `wchar_t` in path names.
 - Added explicit error message for Buildroot's Microblaze toolchain maintainers.

Fixes:

 - Never use modern `__cxa_thread_atexit()` on Apple's OSes.
 - Use `MultiByteToWideChar(CP_THREAD_ACP)` instead of `mbstowcs()`.
 - Don't check owner for finished transactions.
 - Fixed typo in `MDBX_EINVAL` which breaks MingGW builds with CLANG.

Minors:

 - Fixed variable name typo.
 - Using `ldd` to check used dso.
 - Added `MDBX_WEAK_IMPORT_ATTRIBUTE` macro.
 - Use current transaction geometry for untouched parameters when `env_set_geometry()` called within a write transaction.
 - Minor clarified `iov_page()` failure case.

--------------------------------------------------------------------------------

## v0.11.9 "Чирчик-1992" at 2022-08-02

The stable bugfix release.

```
18 files changed, 318 insertions(+), 178 deletions(-)
Signed-off-by: Леонид Юрьев (Leonid Yuriev) <leo@yuriev.ru>
```

Acknowledgments:

 - [Alex Sharov](https://github.com/AskAlexSharov) and Erigon team for reporting and testing.
 - [Andrew Ashikhmin](https://gitflic.ru/user/yperbasis) for contributing.

New:

 - Ability to customise `MDBX_LOCK_SUFFIX`, `MDBX_DATANAME`, `MDBX_LOCKNAME` just by predefine ones during build.
 - Added to [`mdbx::env_managed`](https://libmdbx.dqdkfa.ru/group__cxx__api.html#classmdbx_1_1env__managed)'s methods a few overloads with `const char* pathname` parameter (C++ API).

Fixes:

 - Fixed hang copy-with-compactification of a corrupted DB
   or in case the volume of output pages is a multiple of `MDBX_ENVCOPY_WRITEBUF`.
 - Fixed standalone non-CMake build on MacOS (`#include AvailabilityMacros.h>`).
 - Fixed unexpected `MDBX_PAGE_FULL` error in rare cases with large database page sizes.

Minors:

 - Minor fixes Doxygen references, comments, descriptions, etc.
 - Fixed copy&paste typo inside `meta_checktxnid()`.
 - Minor fix `meta_checktxnid()` to avoid assertion in debug mode.
 - Minor fix `mdbx_env_set_geometry()` to avoid returning `EINVAL` in particular rare cases.
 - Minor refine/fix batch-get testcase for large page size.
 - Added `--pagesize NN` option to long-stotastic test script.
 - Updated Valgrind-suppressions file for modern GCC.
 - Fixed `has no symbols` warning from Apple's ranlib.

--------------------------------------------------------------------------------

## v0.11.8 "Baked Apple" at 2022-06-12

The stable release with an important fixes and workaround for the critical macOS thread-local-storage issue.

Acknowledgments:

 - [Masatoshi Fukunaga](https://github.com/mah0x211) for [Lua bindings](https://github.com/mah0x211/lua-libmdbx).

New:

 - Added most of transactions flags to the public API.
 - Added `MDBX_NOSUCCESS_EMPTY_COMMIT` build option to return non-success result (`MDBX_RESULT_TRUE`) on empty commit.
 - Reworked validation and import of DBI-handles into a transaction.
   Assumes  these changes will be invisible to most users, but will cause fewer surprises in complex DBI cases.
 - Added ability to open DB in without-LCK (exclusive read-only) mode in case no permissions to create/write LCK-file.

Fixes:

 - A series of fixes and improvements for automatically generated documentation (Doxygen).
 - Fixed copy&paste bug with could lead to `SIGSEGV` (nullptr dereference) in the exclusive/no-lck mode.
 - Fixed minor warnings from modern Apple's CLANG 13.
 - Fixed minor warnings from CLANG 14 and in-development CLANG 15.
 - Fixed `SIGSEGV` regression in without-LCK (exclusive read-only) mode.
 - Fixed `mdbx_check_fs_local()` for CDROM case on Windows.
 - Fixed nasty typo of typename which caused false `MDBX_CORRUPTED` error in a rare execution path,
   when the size of the thread-ID type not equal to 8.
 - Fixed Elbrus/E2K LCC 1.26 compiler warnings (memory model for atomic operations, etc).
 - Fixed write-after-free memory corruption on latest `macOS` during finalization/cleanup of thread(s) that executed read transaction(s).
   > The issue was suddenly discovered by a [CI](https://en.wikipedia.org/wiki/Continuous_integration)
   > after adding an iteration with macOS 11 "Big Sur", and then reproduced on recent release of macOS 12 "Monterey".
   > The issue was never noticed nor reported on macOS 10 "Catalina" nor others.
   > Analysis shown that the problem caused by a change in the behavior of the system library (internals of dyld and pthread)
   > during thread finalization/cleanup: now a memory allocated for a `__thread` variable(s) is released
   > before execution of the registered Thread-Local-Storage destructor(s),
   > thus a TLS-destructor will write-after-free just by legitime dereference any `__thread` variable.
   > This is unexpected crazy-like behavior since the order of resources releasing/destroying
   > is not the reverse of ones acquiring/construction order. Nonetheless such surprise
   > is now workarounded by using atomic compare-and-swap operations on a 64-bit signatures/cookies.

Minors:

 - Refined `release-assets` GNU Make target.
 - Added logging to `mdbx_fetch_sdb()` to help debugging complex DBI-handels use cases.
 - Added explicit error message from probe of no-support for `std::filesystem`.
 - Added contributors "score" table by `git fame` to generated docs.
 - Added `mdbx_assert_fail()` to public API (mostly for backtracing).
 - Now C++20 concepts used/enabled only when `__cpp_lib_concepts >= 202002`.
 - Don't provide nor report package information if used as a CMake subproject.

--------------------------------------------------------------------------------

## v0.11.7 "Resurrected Sarmat" at 2022-04-22

The stable risen release after the Github's intentional malicious disaster.

#### We have migrated to a reliable trusted infrastructure
The origin for now is at [GitFlic](https://gitflic.ru/project/erthink/libmdbx)
since on 2022-04-15 the Github administration, without any warning nor
explanation, deleted _libmdbx_ along with a lot of other projects,
simultaneously blocking access for many developers.
For the same reason ~~Github~~ is blacklisted forever.

GitFlic already support Russian and English languages, plan to support more,
including 和 中文. You are welcome!

New:

 - Added the `tools-static` make target to build statically linked MDBX tools.
 - Support for Microsoft Visual Studio 2022.
 - Support build by MinGW' make from command line without CMake.
 - Added `mdbx::filesystem` C++ API namespace that corresponds to `std::filesystem` or `std::experimental::filesystem`.
 - Created [website](https://libmdbx.dqdkfa.ru/) for online auto-generated documentation.
 - Used `https://web.archive.org/web/https://github.com/erthink/libmdbx` for dead (or temporarily lost) resources deleted by ~~Github~~.
 - Added `--loglevel=` command-line option to the `mdbx_test` tool.
 - Added few fast smoke-like tests into CMake builds.

Fixes:

 - Fixed a race between starting a transaction and creating a DBI descriptor that could lead to `SIGSEGV` in the cursor tracking code.
 - Clarified description of `MDBX_EPERM` error returned from `mdbx_env_set_geometry()`.
 - Fixed non-promoting the parent transaction to be dirty in case the undo of the geometry update failed during abortion of a nested transaction.
 - Resolved linking issues with `libstdc++fs`/`libc++fs`/`libc++experimental` for C++ `std::filesystem` or `std::experimental::filesystem` for legacy compilers.
 - Added workaround for GNU Make 3.81 and earlier.
 - Added workaround for Elbrus/LCC 1.25 compiler bug of class inline `static constexpr` member field.
 - [Fixed](https://github.com/ledgerwatch/erigon/issues/3874) minor assertion regression (only debug builds were affected).
 - Fixed detection of `C++20` concepts accessibility.
 - Fixed detection of Clang's LTO availability for Android.
 - Fixed extra definition of `_FILE_OFFSET_BITS=64` for Android that is problematic for 32-bit Bionic.
 - Fixed build for ARM/ARM64 by MSVC.
 - Fixed non-x86 Windows builds with `MDBX_WITHOUT_MSVC_CRT=ON` and `MDBX_BUILD_SHARED_LIBRARY=ON`.

Minors:

 - Resolve minor MSVC warnings: avoid `/INCREMENTAL[:YES]` with `/LTCG`, `/W4` with `/W3`, the `C5105` warning.
 - Switched to using `MDBX_EPERM` instead of `MDBX_RESULT_TRUE` to indicate that the geometry cannot be updated.
 - Added `NULL` checking during memory allocation inside `mdbx_chk`.
 - Resolved all warnings from MinGW while used without CMake.
 - Added inheritable `target_include_directories()` to `CMakeLists.txt` for easy integration.
 - Added build-time checks and paranoid runtime assertions for the `off_t` arguments of `fcntl()` which are used for locking.
 - Added `-Wno-lto-type-mismatch` to avoid false-positive warnings from old GCC during LTO-enabled builds.
 - Added checking for TID (system thread id) to avoid hang on 32-bit Bionic/Android within `pthread_mutex_lock()`.
 - Reworked `MDBX_BUILD_TARGET` of CMake builds.
 - Added `CMAKE_HOST_ARCH` and `CMAKE_HOST_CAN_RUN_EXECUTABLES_BUILT_FOR_TARGET`.

--------------------------------------------------------------------------------

## v0.11.6 at 2022-03-24

The stable release with the complete workaround for an incoherence flaw of Linux unified page/buffer cache.
Nonetheless the cause for this trouble may be an issue of Intel CPU cache/MESI.
See [issue#269](https://libmdbx.dqdkfa.ru/dead-github/issues/269) for more information.

Acknowledgments:

 - [David Bouyssié](https://github.com/david-bouyssie) for [Scala bindings](https://github.com/david-bouyssie/mdbx4s).
 - [Michelangelo Riccobene](https://github.com/mriccobene) for reporting and testing.

Fixes:

 - [Added complete workaround](https://libmdbx.dqdkfa.ru/dead-github/issues/269) for an incoherence flaw of Linux unified page/buffer cache.
 - [Fixed](https://libmdbx.dqdkfa.ru/dead-github/issues/272) cursor reusing for read-only transactions.
 - Fixed copy&paste typo inside `mdbx::cursor::find_multivalue()`.

Minors:

 - Minor refine C++ API for convenience.
 - Minor internals refines.
 - Added `lib-static` and `lib-shared` targets for make.
 - Added minor workaround for AppleClang 13.3 bug.
 - Clarified error messages of a signature/version mismatch.

--------------------------------------------------------------------------------

## v0.11.5 at 2022-02-23

The release with the temporary hotfix for a flaw of Linux unified page/buffer cache.
See [issue#269](https://libmdbx.dqdkfa.ru/dead-github/issues/269) for more information.

Acknowledgments:

 - [Simon Leier](https://github.com/leisim) for reporting and testing.
 - [Kai Wetlesen](https://github.com/kaiwetlesen) for [RPMs](http://copr.fedorainfracloud.org/coprs/kwetlesen/libmdbx/).
 - [Tullio Canepa](https://github.com/canepat) for reporting C++ API issue and contributing.

Fixes:

 - [Added hotfix](https://libmdbx.dqdkfa.ru/dead-github/issues/269) for a flaw of Linux unified page/buffer cache.
 - [Fixed/Reworked](https://libmdbx.dqdkfa.ru/dead-github/pull/270) move-assignment operators for "managed" classes of C++ API.
 - Fixed potential `SIGSEGV` while open DB with overrided non-default page size.
 - [Made](https://libmdbx.dqdkfa.ru/dead-github/issues/267) `mdbx_env_open()` idempotence in failure cases.
 - Refined/Fixed pages reservation inside `mdbx_update_gc()` to avoid non-reclamation in a rare cases.
 - Fixed typo in a retained space calculation for the hsr-callback.

Minors:

 - Reworked functions for meta-pages, split-off non-volatile.
 - Disentangled C11-atomic fences/barriers and pure-functions (with `__attribute__((__pure__))`) to avoid compiler misoptimization.
 - Fixed hypotetic unaligned access to 64-bit dwords on ARM with `__ARM_FEATURE_UNALIGNED` defined.
 - Reasonable paranoia that makes clarity for code readers.
 - Minor fixes Doxygen references, comments, descriptions, etc.

--------------------------------------------------------------------------------

## v0.11.4 at 2022-02-02

The stable release with fixes for large and huge databases sized of 4..128 TiB.

Acknowledgments:

 - [Ledgerwatch](https://github.com/ledgerwatch), [Binance](https://github.com/binance-chain) and [Positive Technologies](https://www.ptsecurity.com/) teams for reporting, assistance in investigation and testing.
 - [Alex Sharov](https://github.com/AskAlexSharov) for reporting, testing and provide resources for remote debugging/investigation.
 - [Kris Zyp](https://github.com/kriszyp) for [Deno](https://deno.land/) support.

New features, extensions and improvements:

 - Added treating the `UINT64_MAX` value as maximum for given option inside `mdbx_env_set_option()`.
 - Added `to_hex/to_base58/to_base64::output(std::ostream&)` overloads without using temporary string objects as buffers.
 - Added `--geometry-jitter=YES|no` option to the test framework.
 - Added support for [Deno](https://deno.land/) support by [Kris Zyp](https://github.com/kriszyp).

Fixes:

 - Fixed handling `MDBX_opt_rp_augment_limit` for GC's records from huge transactions (Erigon/Akula/Ethereum).
 - [Fixed](https://libmdbx.dqdkfa.ru/dead-github/issues/258) build on Android (avoid including `sys/sem.h`).
 - [Fixed](https://libmdbx.dqdkfa.ru/dead-github/pull/261) missing copy assignment operator for `mdbx::move_result`.
 - Fixed missing `&` for `std::ostream &operator<<()` overloads.
 - Fixed unexpected `EXDEV` (Cross-device link) error from `mdbx_env_copy()`.
 - Fixed base64 encoding/decoding bugs in auxillary C++ API.
 - Fixed overflow of `pgno_t` during checking PNL on 64-bit platforms.
 - [Fixed](https://libmdbx.dqdkfa.ru/dead-github/issues/260) excessive PNL checking after sort for spilling.
 - Reworked checking `MAX_PAGENO` and DB upper-size geometry limit.
 - [Fixed](https://libmdbx.dqdkfa.ru/dead-github/issues/265) build for some combinations of versions of  MSVC and Windows SDK.

Minors:

 - Added workaround for CLANG bug [D79919/PR42445](https://reviews.llvm.org/D79919).
 - Fixed build test on Android (using `pthread_barrier_t` stub).
 - Disabled C++20 concepts for CLANG < 14 on Android.
 - Fixed minor `unused parameter` warning.
 - Added CI for Android.
 - Refine/cleanup internal logging.
 - Refined line splitting inside hex/base58/base64 encoding to avoid `\n` at the end.
 - Added workaround for modern libstdc++ with CLANG < 4.x
 - Relaxed txn-check rules for auxiliary functions.
 - Clarified a comments and descriptions, etc.
 - Using the `-fno-semantic interposition` option to reduce the overhead to calling self own public functions.

--------------------------------------------------------------------------------

## v0.11.3 at 2021-12-31

Acknowledgments:

 - [gcxfd <i@rmw.link>](https://github.com/gcxfd) for reporting, contributing and testing.
 - [장세연 (Чан Се Ен)](https://github.com/sasgas) for reporting and testing.
 - [Alex Sharov](https://github.com/AskAlexSharov) for reporting, testing and provide resources for remote debugging/investigation.

New features, extensions and improvements:

 - [Added](https://libmdbx.dqdkfa.ru/dead-github/issues/236) `mdbx_cursor_get_batch()`.
 - [Added](https://libmdbx.dqdkfa.ru/dead-github/issues/250) `MDBX_SET_UPPERBOUND`.
 - C++ API is finalized now.
 - The GC update stage has been [significantly speeded](https://libmdbx.dqdkfa.ru/dead-github/issues/254) when fixing huge Erigon's transactions (Ethereum ecosystem).

Fixes:

 - Disabled C++20 concepts for stupid AppleClang 13.x
 - Fixed internal collision of `MDBX_SHRINK_ALLOWED` with `MDBX_ACCEDE`.

Minors:

 - Fixed returning `MDBX_RESULT_TRUE` (unexpected -1) from `mdbx_env_set_option()`.
 - Added `mdbx_env_get_syncbytes()` and `mdbx_env_get_syncperiod()`.
 - [Clarified](https://libmdbx.dqdkfa.ru/dead-github/pull/249) description of `MDBX_INTEGERKEY`.
 - Reworked/simplified `mdbx_env_sync_internal()`.
 - [Fixed](https://libmdbx.dqdkfa.ru/dead-github/issues/248) extra assertion inside `mdbx_cursor_put()` for `MDBX_DUPFIXED` cases.
 - Avoiding extra looping inside `mdbx_env_info_ex()`.
 - Explicitly enabled core dumps from stochastic tests scripts on Linux.
 - [Fixed](https://libmdbx.dqdkfa.ru/dead-github/issues/253) `mdbx_override_meta()` to avoid false-positive assertions.
 - For compatibility reverted returning `MDBX_ENODATA`for some cases.

--------------------------------------------------------------------------------

## v0.11.2 at 2021-12-02

Acknowledgments:

 - [장세연 (Чан Се Ен)](https://github.com/sasgas) for contributing to C++ API.
 - [Alain Picard](https://github.com/castortech) for [Java bindings](https://github.com/castortech/mdbxjni).
 - [Alex Sharov](https://github.com/AskAlexSharov) for reporting and testing.
 - [Kris Zyp](https://github.com/kriszyp) for reporting and testing.
 - [Artem Vorotnikov](https://github.com/vorot93) for support [Rust wrapper](https://github.com/vorot93/libmdbx-rs).

Fixes:

 - [Fixed compilation](https://libmdbx.dqdkfa.ru/dead-github/pull/239) with `devtoolset-9` on CentOS/RHEL 7.
 - [Fixed unexpected `MDBX_PROBLEM` error](https://libmdbx.dqdkfa.ru/dead-github/issues/242) because of update an obsolete meta-page.
 - [Fixed returning `MDBX_NOTFOUND` error](https://libmdbx.dqdkfa.ru/dead-github/issues/243) in case an inexact value found for `MDBX_GET_BOTH` operation.
 - [Fixed compilation](https://libmdbx.dqdkfa.ru/dead-github/issues/245) without kernel/libc-devel headers.

Minors:

 - Fixed `constexpr`-related macros for legacy compilers.
 - Allowed to define 'CMAKE_CXX_STANDARD` using an environment variable.
 - Simplified collection statistics of page operation .
 - Added `MDBX_FORCE_BUILD_AS_MAIN_PROJECT` cmake option.
 - Remove unneeded `#undef P_DIRTY`.

--------------------------------------------------------------------------------

## v0.11.1 at 2021-10-23

### Backward compatibility break:

The database format signature has been changed to prevent
forward-interoperability with an previous releases, which may lead to a
[false positive diagnosis of database corruption](https://libmdbx.dqdkfa.ru/dead-github/issues/238)
due to flaws of an old library versions.

This change is mostly invisible:

 - previously versions are unable to read/write a new DBs;
 - but the new release is able to handle an old DBs and will silently upgrade ones.

Acknowledgments:

 - [Alex Sharov](https://github.com/AskAlexSharov) for reporting and testing.

********************************************************************************

## v0.10.5 at 2021-10-13 (obsolete, please use v0.11.1)

Unfortunately, the `v0.10.5` accidentally comes not full-compatible with previous releases:

 - `v0.10.5` can read/processing DBs created by previous releases, i.e. the backward-compatibility is provided;
 - however, previous releases may lead to false-corrupted state with DB that was touched by `v0.10.5`, i.e. the forward-compatibility is broken for `v0.10.4` and earlier.

This cannot be fixed, as it requires fixing past versions, which as a result we will just get a current version.
Therefore, it is recommended to use `v0.11.1` instead of `v0.10.5`.

Acknowledgments:

 - [Noel Kuntze](https://github.com/Thermi) for immediately bug reporting.

Fixes:

 - Fixed unaligned access regression after the `#pragma pack` fix for modern compilers.
 - Added UBSAN-test to CI to avoid a regression(s) similar to lately fixed.
 - Fixed possibility of meta-pages clashing after manually turn to a particular meta-page using `mdbx_chk` utility.

Minors:

 - Refined handling of weak or invalid meta-pages while a DB opening.
 - Refined providing information for the `@MAIN` and `@GC` sub-databases of a last committed modification transaction's ID.

--------------------------------------------------------------------------------

## v0.10.4 at 2021-10-10

Acknowledgments:

 - [Artem Vorotnikov](https://github.com/vorot93) for support [Rust wrapper](https://github.com/vorot93/libmdbx-rs).
 - [Andrew Ashikhmin](https://github.com/yperbasis) for contributing to C++ API.

Fixes:

 - Fixed possibility of looping update GC during transaction commit (no public issue since the problem was discovered inside [Positive Technologies](https://www.ptsecurity.ru)).
 - Fixed `#pragma pack` to avoid provoking some compilers to generate code with [unaligned access](https://libmdbx.dqdkfa.ru/dead-github/issues/235).
 - Fixed `noexcept` for potentially throwing `txn::put()` of C++ API.

Minors:

 - Added stochastic test script for checking small transactions cases.
 - Removed extra transaction commit/restart inside test framework.
 - In debugging builds fixed a too small (single page) by default DB shrink threshold.

--------------------------------------------------------------------------------

## v0.10.3 at 2021-08-27

Acknowledgments:

 - [Francisco Vallarino](https://github.com/fjvallarino) for [Haskell bindings for libmdbx](https://hackage.haskell.org/package/libmdbx).
 - [Alex Sharov](https://github.com/AskAlexSharov) for reporting and testing.
 - [Andrea Lanfranchi](https://github.com/AndreaLanfranchi) for contributing.

Extensions and improvements:

 - Added `cursor::erase()` overloads for `key` and for `key-value`.
 - Resolve minor Coverity Scan issues (no fixes but some hint/comment were added).
 - Resolve minor UndefinedBehaviorSanitizer issues (no fixes but some workaround were added).

Fixes:

 - Always setup `madvise` while opening DB (fixes https://libmdbx.dqdkfa.ru/dead-github/issues/231).
 - Fixed checking legacy `P_DIRTY` flag (`0x10`) for nested/sub-pages.

Minors:

 - Fixed getting revision number from middle of history during amalgamation (GNU Makefile).
 - Fixed search GCC tools for LTO (CMake scripts).
 - Fixed/reorder dirs list for search CLANG tools for LTO (CMake scripts).
 - Fixed/workarounds for CLANG < 9.x
 - Fixed CMake warning about compatibility with 3.8.2

--------------------------------------------------------------------------------

## v0.10.2 at 2021-07-26

Acknowledgments:

 - [Alex Sharov](https://github.com/AskAlexSharov) for reporting and testing.
 - [Andrea Lanfranchi](https://github.com/AndreaLanfranchi) for reporting bugs.
 - [Lionel Debroux](https://github.com/debrouxl) for fuzzing tests and reporting bugs.
 - [Sergey Fedotov](https://github.com/SergeyFromHell/) for [`node-mdbx` NodeJS bindings](https://www.npmjs.com/package/node-mdbx).
 - [Kris Zyp](https://github.com/kriszyp) for [`lmdbx-store` NodeJS bindings](https://github.com/kriszyp/lmdbx-store).
 - [Noel Kuntze](https://github.com/Thermi) for [draft Python bindings](https://libmdbx.dqdkfa.ru/dead-github/commits/python-bindings).

New features, extensions and improvements:

 - [Allow to predefine/override `MDBX_BUILD_TIMESTAMP` for builds reproducibility](https://libmdbx.dqdkfa.ru/dead-github/issues/201).
 - Added options support for `long-stochastic` script.
 - Avoided `MDBX_TXN_FULL` error for large transactions when possible.
 - The `MDBX_READERS_LIMIT` increased to `32767`.
 - Raise `MDBX_TOO_LARGE` under Valgrind/ASAN if being opened DB is 100 larger than RAM (to avoid hangs and OOM).
 - Minimized the size of poisoned/unpoisoned regions to avoid Valgrind/ASAN stuck.
 - Added more workarounds for QEMU for testing builds for 32-bit platforms, Alpha and Sparc architectures.
 - `mdbx_chk` now skips iteration & checking of DB' records if corresponding page-tree is corrupted (to avoid `SIGSEGV`, ASAN failures, etc).
 - Added more checks for [rare/fuzzing corruption cases](https://libmdbx.dqdkfa.ru/dead-github/issues/217).

Backward compatibility break:

 - Use file `VERSION.txt` for version information instead of `VERSION` to avoid collision with `#include <version>`.
 - Rename `slice::from/to_FOO_bytes()` to `slice::envisage_from/to_FOO_length()'.
 - Rename `MDBX_TEST_EXTRA` make's variable to `MDBX_SMOKE_EXTRA`.
 - Some details of the C++ API have been changed for subsequent freezing.

Fixes:

 - Fixed excess meta-pages checks in case `mdbx_chk` is called to check the DB for a specific meta page and thus could prevent switching to the selected meta page, even if the check passed without errors.
 - Fixed [recursive use of SRW-lock on Windows cause by `MDBX_NOTLS` option](https://libmdbx.dqdkfa.ru/dead-github/issues/203).
 - Fixed [log a warning during a new DB creation](https://libmdbx.dqdkfa.ru/dead-github/issues/205).
 - Fixed [false-negative `mdbx_cursor_eof()` result](https://libmdbx.dqdkfa.ru/dead-github/issues/207).
 - Fixed [`make install` with non-GNU `install` utility (OSX, BSD)](https://libmdbx.dqdkfa.ru/dead-github/issues/208).
 - Fixed [installation by `CMake` in special cases by complete use `GNUInstallDirs`'s variables](https://libmdbx.dqdkfa.ru/dead-github/issues/209).
 - Fixed [C++ Buffer issue with `std::string` and alignment](https://libmdbx.dqdkfa.ru/dead-github/issues/191).
 - Fixed `safe64_reset()` for platforms without atomic 64-bit compare-and-swap.
 - Fixed hang/shutdown on big-endian platforms without `__cxa_thread_atexit()`.
 - Fixed [using bad meta-pages if DB was partially/recoverable corrupted](https://libmdbx.dqdkfa.ru/dead-github/issues/217).
 - Fixed extra `noexcept` for `buffer::&assign_reference()`.
 - Fixed `bootid` generation on Windows for case of change system' time.
 - Fixed [test framework keygen-related issue](https://libmdbx.dqdkfa.ru/dead-github/issues/127).

--------------------------------------------------------------------------------

## v0.10.1 at 2021-06-01

Acknowledgments:

 - [Alexey Akhunov](https://github.com/AlexeyAkhunov) and [Alex Sharov](https://github.com/AskAlexSharov) for bug reporting and testing.
 - [Andrea Lanfranchi](https://github.com/AndreaLanfranchi) for bug reporting and testing related to WSL2.

New features:

 - Added `-p` option to `mdbx_stat` utility for printing page operations statistic.
 - Added explicit checking for and warning about using unfit github's archives.
 - Added fallback from [OFD locking](https://bit.ly/3yFRtYC) to legacy non-OFD POSIX file locks on an `EINVAL` error.
 - Added [Plan 9](https://en.wikipedia.org/wiki/9P_(protocol)) network file system to the whitelist for an ability to open a DB in exclusive mode.
 - Support for opening from WSL2 environment a DB hosted on Windows drive and mounted via [DrvFs](https://docs.microsoft.com/it-it/archive/blogs/wsl/wsl-file-system-support#drvfs) (i.e by Plan 9 noted above).

Fixes:

 - Fixed minor "foo not used" warnings from modern C++ compilers when building the C++ part of the library.
 - Fixed confusing/messy errors when build library from unfit github's archives (https://libmdbx.dqdkfa.ru/dead-github/issues/197).
 - Fixed `#​e​l​s​i​f` typo.
 - Fixed rare unexpected `MDBX_PROBLEM` error during altering data in huge transactions due to wrong spilling/oust of dirty pages (https://libmdbx.dqdkfa.ru/dead-github/issues/195).
 - Re-Fixed WSL1/WSL2 detection with distinguishing (https://libmdbx.dqdkfa.ru/dead-github/issues/97).

--------------------------------------------------------------------------------

## v0.10.0 at 2021-05-09

Acknowledgments:

 - [Mahlon E. Smith](https://github.com/mahlonsmith) for [Ruby bindings](https://rubygems.org/gems/mdbx/).
 - [Alex Sharov](https://github.com/AskAlexSharov) for [mdbx-go](https://github.com/torquem-ch/mdbx-go), bug reporting and testing.
 - [Artem Vorotnikov](https://github.com/vorot93) for bug reporting and PR.
 - [Paolo Rebuffo](https://www.linkedin.com/in/paolo-rebuffo-8255766/), [Alexey Akhunov](https://github.com/AlexeyAkhunov) and Mark Grosberg for donations.
 - [Noel Kuntze](https://github.com/Thermi) for preliminary [Python bindings](https://github.com/Thermi/libmdbx/tree/python-bindings)

New features:

 - Added `mdbx_env_set_option()` and `mdbx_env_get_option()` for controls
   various runtime options for an environment (announce of this feature  was missed in a previous news).
 - Added `MDBX_DISABLE_PAGECHECKS` build option to disable some checks to reduce an overhead
   and detection probability of database corruption to a values closer to the LMDB.
   The `MDBX_DISABLE_PAGECHECKS=1` provides a performance boost of about 10% in CRUD scenarios,
   and conjointly with the `MDBX_ENV_CHECKPID=0` and `MDBX_TXN_CHECKOWNER=0` options can yield
   up to 30% more performance compared to LMDB.
 - Using float point (exponential quantized) representation for internal 16-bit values
   of grow step and shrink threshold when huge ones (https://libmdbx.dqdkfa.ru/dead-github/issues/166).
   To minimize the impact on compatibility, only the odd values inside the upper half
   of the range (i.e. 32769..65533) are used for the new representation.
 - Added the `mdbx_drop` similar to LMDB command-line tool to purge or delete (sub)database(s).
 - [Ruby bindings](https://rubygems.org/gems/mdbx/) is available now by [Mahlon E. Smith](https://github.com/mahlonsmith).
 - Added `MDBX_ENABLE_MADVISE` build option which controls the use of POSIX `madvise()` hints and friends.
 - The internal node sizes were refined, resulting in a reduction in large/overflow pages in some use cases
   and a slight increase in limits for a keys size to ≈½ of page size.
 - Added to `mdbx_chk` output number of keys/items on pages.
 - Added explicit `install-strip` and `install-no-strip` targets to the `Makefile` (https://libmdbx.dqdkfa.ru/dead-github/pull/180).
 - Major rework page splitting (af9b7b560505684249b76730997f9e00614b8113) for
     - An "auto-appending" feature upon insertion for both ascending and
       descending key sequences. As a result, the optimality of page filling
       increases significantly (more densely, less slackness) while
       inserting ordered sequences of keys,
     - A "splitting at middle" to make page tree more balanced on average.
 - Added `mdbx_get_sysraminfo()` to the API.
 - Added guessing a reasonable maximum DB size for the default upper limit of geometry (https://libmdbx.dqdkfa.ru/dead-github/issues/183).
 - Major rework internal labeling of a dirty pages (958fd5b9479f52f2124ab7e83c6b18b04b0e7dda) for
   a "transparent spilling" feature with the gist to make a dirty pages
   be ready to spilling (writing to a disk) without further altering ones.
   Thus in the `MDBX_WRITEMAP` mode the OS kernel able to oust dirty pages
   to DB file without further penalty during transaction commit.
   As a result, page swapping and I/O could be significantly reduced during extra large transactions and/or lack of memory.
 - Minimized reading leaf-pages during dropping subDB(s) and nested trees.
 - Major rework a spilling of dirty pages to support [LRU](https://en.wikipedia.org/wiki/Cache_replacement_policies#Least_recently_used_(LRU))
   policy and prioritization for a large/overflow pages.
 - Statistics of page operations (split, merge, copy, spill, etc) now available through `mdbx_env_info_ex()`.
 - Auto-setup limit for length of dirty pages list (`MDBX_opt_txn_dp_limit` option).
 - Support `make options` to list available build options.
 - Support `make help` to list available make targets.
 - Silently `make`'s build by default.
 - Preliminary [Python bindings](https://github.com/Thermi/libmdbx/tree/python-bindings) is available now
   by [Noel Kuntze](https://github.com/Thermi) (https://libmdbx.dqdkfa.ru/dead-github/issues/147).

Backward compatibility break:

 - The `MDBX_AVOID_CRT` build option was renamed to `MDBX_WITHOUT_MSVC_CRT`.
   This option is only relevant when building for Windows.
 - The `mdbx_env_stat()` always, and `mdbx_env_stat_ex()` when called with the zeroed transaction parameter,
   now internally start temporary read transaction and thus may returns `MDBX_BAD_RSLOT` error.
   So, just never use deprecated `mdbx_env_stat()' and call `mdbx_env_stat_ex()` with transaction parameter.
 - The build option `MDBX_CONFIG_MANUAL_TLS_CALLBACK` was removed and now just a non-zero value of
   the `MDBX_MANUAL_MODULE_HANDLER` macro indicates the requirement to manually call `mdbx_module_handler()`
   when loading libraries and applications uses statically linked libmdbx on an obsolete Windows versions.

Fixes:

 - Fixed performance regression due non-optimal C11 atomics usage (https://libmdbx.dqdkfa.ru/dead-github/issues/160).
 - Fixed "reincarnation" of subDB after it deletion (https://libmdbx.dqdkfa.ru/dead-github/issues/168).
 - Fixed (disallowing) implicit subDB deletion via operations on `@MAIN`'s DBI-handle.
 - Fixed a crash of `mdbx_env_info_ex()` in case of a call for a non-open environment (https://libmdbx.dqdkfa.ru/dead-github/issues/171).
 - Fixed the selecting/adjustment values inside `mdbx_env_set_geometry()` for implicit out-of-range cases (https://libmdbx.dqdkfa.ru/dead-github/issues/170).
 - Fixed `mdbx_env_set_option()` for set initial and limit size of dirty page list ((https://libmdbx.dqdkfa.ru/dead-github/issues/179).
 - Fixed an unreasonably huge default upper limit for DB geometry (https://libmdbx.dqdkfa.ru/dead-github/issues/183).
 - Fixed `constexpr` specifier for the `slice::invalid()`.
 - Fixed (no)readahead auto-handling (https://libmdbx.dqdkfa.ru/dead-github/issues/164).
 - Fixed non-alloy build for Windows.
 - Switched to using Heap-functions instead of LocalAlloc/LocalFree on Windows.
 - Fixed `mdbx_env_stat_ex()` to returning statistics of the whole environment instead of MainDB only (https://libmdbx.dqdkfa.ru/dead-github/issues/190).
 - Fixed building by GCC 4.8.5 (added workaround for a preprocessor's bug).
 - Fixed building C++ part for iOS <= 13.0 (unavailability of  `std::filesystem::path`).
 - Fixed building for Windows target versions prior to Windows Vista (`WIN32_WINNT < 0x0600`).
 - Fixed building by MinGW for Windows (https://libmdbx.dqdkfa.ru/dead-github/issues/155).

********************************************************************************

## v0.9.3 at 2021-02-02

Acknowledgments:

 - [Mahlon E. Smith](http://www.martini.nu/) for [FreeBSD port of libmdbx](https://svnweb.freebsd.org/ports/head/databases/mdbx/).
 - [장세연](http://www.castis.com) for bug fixing and PR.
 - [Clément Renault](https://github.com/Kerollmops/heed) for [Heed](https://github.com/Kerollmops/heed) fully typed Rust wrapper.
 - [Alex Sharov](https://github.com/AskAlexSharov) for bug reporting.
 - [Noel Kuntze](https://github.com/Thermi) for bug reporting.

Removed options and features:

 - Drop `MDBX_HUGE_TRANSACTIONS` build-option (now no longer required).

New features:

 - Package for FreeBSD is available now by Mahlon E. Smith.
 - New API functions to get/set various options (https://libmdbx.dqdkfa.ru/dead-github/issues/128):
    - the maximum number of named databases for the environment;
    - the maximum number of threads/reader slots;
    - threshold (since the last unsteady commit) to force flush the data buffers to disk;
    - relative period (since the last unsteady commit) to force flush the data buffers to disk;
    - limit to grow a list of reclaimed/recycled page's numbers for finding a sequence of contiguous pages for large data items;
    - limit to grow a cache of dirty pages for reuse in the current transaction;
    - limit of a pre-allocated memory items for dirty pages;
    - limit of dirty pages for a write transaction;
    - initial allocation size for dirty pages list of a write transaction;
    - maximal part of the dirty pages may be spilled when necessary;
    - minimal part of the dirty pages should be spilled when necessary;
    - how much of the parent transaction dirty pages will be spilled while start each child transaction;
 - Unlimited/Dynamic size of retired and dirty page lists (https://libmdbx.dqdkfa.ru/dead-github/issues/123).
 - Added `-p` option (purge subDB before loading) to `mdbx_load` tool.
 - Reworked spilling of large transaction and committing of nested transactions:
    - page spilling code reworked to avoid the flaws and bugs inherited from LMDB;
    - limit for number of dirty pages now is controllable at runtime;
    - a spilled pages, including overflow/large pages, now can be reused and refunded/compactified in nested transactions;
    - more effective refunding/compactification especially for the loosed page cache.
 - Added `MDBX_ENABLE_REFUND` and `MDBX_PNL_ASCENDING` internal/advanced build options.
 - Added `mdbx_default_pagesize()` function.
 - Better support architectures with a weak/relaxed memory consistency model (ARM, AARCH64, PPC, MIPS, RISC-V, etc) by means [C11 atomics](https://en.cppreference.com/w/c/atomic).
 - Speed up page number lists and dirty page lists (https://libmdbx.dqdkfa.ru/dead-github/issues/132).
 - Added `LIBMDBX_NO_EXPORTS_LEGACY_API` build option.

Fixes:

 - Fixed missing cleanup (null assigned) in the C++ commit/abort (https://libmdbx.dqdkfa.ru/dead-github/pull/143).
 - Fixed `mdbx_realloc()` for case of nullptr and `MDBX_WITHOUT_MSVC_CRT=ON` for Windows.
 - Fixed the possibility to use invalid and renewed (closed & re-opened, dropped & re-created) DBI-handles (https://libmdbx.dqdkfa.ru/dead-github/issues/146).
 - Fixed 4-byte aligned access to 64-bit integers, including access to the `bootid` meta-page's field (https://libmdbx.dqdkfa.ru/dead-github/issues/153).
 - Fixed minor/potential memory leak during page flushing and unspilling.
 - Fixed handling states of cursors's and subDBs's for nested transactions.
 - Fixed page leak in extra rare case the list of retired pages changed during update GC on transaction commit.
 - Fixed assertions to avoid false-positive UB detection by CLANG/LLVM (https://libmdbx.dqdkfa.ru/dead-github/issues/153).
 - Fixed `MDBX_TXN_FULL` and regressive `MDBX_KEYEXIST` during large transaction commit with `MDBX_LIFORECLAIM` (https://libmdbx.dqdkfa.ru/dead-github/issues/123).
 - Fixed auto-recovery (`weak->steady` with the same boot-id) when Database size at last weak checkpoint is large than at last steady checkpoint.
 - Fixed operation on systems with unusual small/large page size, including PowerPC (https://libmdbx.dqdkfa.ru/dead-github/issues/157).

--------------------------------------------------------------------------------

## v0.9.2 at 2020-11-27

Acknowledgments:

 - Jens Alfke (Mobile Architect at [Couchbase](https://www.couchbase.com/)) for [NimDBX](https://github.com/snej/nimdbx).
 - Clément Renault (CTO at [MeiliSearch](https://www.meilisearch.com/)) for [mdbx-rs](https://github.com/Kerollmops/mdbx-rs).
 - Alex Sharov (Go-Lang Teach Lead at [TurboGeth/Ethereum](https://ethereum.org/)) for an extreme test cases and bug reporting.
 - George Hazan (CTO at [Miranda NG](https://www.miranda-ng.org/)) for bug reporting.
 - [Positive Technologies](https://www.ptsecurity.com/) for funding and [The Standoff](https://standoff365.com/).

Added features:

 - Provided package for [buildroot](https://buildroot.org/).
 - Binding for Nim is [available](https://github.com/snej/nimdbx) now by Jens Alfke.
 - Added `mdbx_env_delete()` for deletion an environment files in a proper and multiprocess-safe way.
 - Added `mdbx_txn_commit_ex()` with collecting latency information.
 - Fast completion pure nested transactions.
 - Added `LIBMDBX_INLINE_API` macro and inline versions of some API functions.
 - Added `mdbx_cursor_copy()` function.
 - Extended tests for checking cursor tracking.
 - Added `MDBX_SET_LOWERBOUND` operation for `mdbx_cursor_get()`.

Fixes:

 - Fixed missing installation of `mdbx.h++`.
 - Fixed use of obsolete `__noreturn`.
 - Fixed use of `yield` instruction on ARM if unsupported.
 - Added pthread workaround for buggy toolchain/cmake/buildroot.
 - Fixed use of `pthread_yield()` for non-GLIBC.
 - Fixed use of `RegGetValueA()` on Windows 2000/XP.
 - Fixed use of `GetTickCount64()` on Windows 2000/XP.
 - Fixed opening DB on a network shares (in the exclusive mode).
 - Fixed copy&paste typos.
 - Fixed minor false-positive GCC warning.
 - Added workaround for broken `DEFINE_ENUM_FLAG_OPERATORS` from Windows SDK.
 - Fixed cursor state after multimap/dupsort repeated deletes (https://libmdbx.dqdkfa.ru/dead-github/issues/121).
 - Added `SIGPIPE` suppression for internal thread during `mdbx_env_copy()`.
 - Fixed extra-rare `MDBX_KEY_EXIST` error during `mdbx_commit()` (https://libmdbx.dqdkfa.ru/dead-github/issues/131).
 - Fixed spilled pages checking (https://libmdbx.dqdkfa.ru/dead-github/issues/126).
 - Fixed `mdbx_load` for 'plain text' and without `-s name` cases (https://libmdbx.dqdkfa.ru/dead-github/issues/136).
 - Fixed save/restore/commit of cursors for nested transactions.
 - Fixed cursors state in rare/special cases (move next beyond end-of-data, after deletion and so on).
 - Added workaround for MSVC 19.28 (Visual Studio 16.8) (but may still hang during compilation).
 - Fixed paranoidal Clang C++ UB for bitwise operations with flags defined by enums.
 - Fixed large pages checking (for compatibility and to avoid false-positive errors from `mdbx_chk`).
 - Added workaround for Wine (https://github.com/miranda-ng/miranda-ng/issues/1209).
 - Fixed `ERROR_NOT_SUPPORTED` while opening DB by UNC pathnames (https://github.com/miranda-ng/miranda-ng/issues/2627).
 - Added handling `EXCEPTION_POSSIBLE_DEADLOCK` condition for Windows.

--------------------------------------------------------------------------------

## v0.9.1 2020-09-30

Added features:

 - Preliminary C++ API with support for C++17 polymorphic allocators.
 - [Online C++ API reference](https://libmdbx.dqdkfa.ru/) by Doxygen.
 - Quick reference for Insert/Update/Delete operations.
 - Explicit `MDBX_SYNC_DURABLE` to sync modes for API clarity.
 - Explicit `MDBX_ALLDUPS` and `MDBX_UPSERT` for API clarity.
 - Support for read transactions preparation (`MDBX_TXN_RDONLY_PREPARE` flag).
 - Support for cursor preparation/(pre)allocation and reusing (`mdbx_cursor_create()` and `mdbx_cursor_bind()` functions).
 - Support for checking database using specified meta-page (see `mdbx_chk -h`).
 - Support for turn to the specific meta-page after checking (see `mdbx_chk -h`).
 - Support for explicit reader threads (de)registration.
 - The `mdbx_txn_break()` function to explicitly mark a transaction as broken.
 - Improved handling of corrupted databases by `mdbx_chk` utility and `mdbx_walk_tree()` function.
 - Improved DB corruption detection by checking parent-page-txnid.
 - Improved opening large DB (> 4Gb) from 32-bit code.
 - Provided `pure-function` and `const-function` attributes to C API.
 - Support for user-settable context for transactions & cursors.
 - Revised API and documentation related to Handle-Slow-Readers callback feature.

Deprecated functions and flags:

 - For clarity and API simplification the `MDBX_MAPASYNC` flag is deprecated.
   Just use `MDBX_SAFE_NOSYNC` or `MDBX_UTTERLY_NOSYNC` instead of it.
 - `MDBX_oom_func`, `mdbx_env_set_oomfunc()` and `mdbx_env_get_oomfunc()`
   replaced with `MDBX_hsr_func`, `mdbx_env_get_hsr` and `mdbx_env_get_hsr()`.

Fixes:

 - Fix `mdbx_strerror()` for `MDBX_BUSY` error (no error description is returned).
 - Fix update internal meta-geo information in read-only mode (`EACCESS` or `EBADFD` error).
 - Fix `mdbx_page_get()` null-defer when DB corrupted (crash by `SIGSEGV`).
 - Fix `mdbx_env_open()` for re-opening after non-fatal errors (`mdbx_chk` unexpected failures).
 - Workaround for MSVC 19.27 `static_assert()` bug.
 - Doxygen descriptions and refinement.
 - Update Valgrind's suppressions.
 - Workaround to avoid infinite loop of 'nested' testcase on MIPS under QEMU.
 - Fix a lot of typos & spelling (Thanks to Josh Soref for PR).
 - Fix `getopt()` messages for Windows (Thanks to Andrey Sporaw for reporting).
 - Fix MSVC compiler version requirements (Thanks to Andrey Sporaw for reporting).
 - Workarounds for QEMU's bugs to run tests for cross-built[A library under QEMU.
 - Now C++ compiler optional for building by CMake.

--------------------------------------------------------------------------------

## v0.9.0 2020-07-31 (not a release, but API changes)

Added features:

 - [Online C API reference](https://libmdbx.dqdkfa.ru/) by Doxygen.
 - Separated enums for environment, sub-databases, transactions, copying and data-update flags.

Deprecated functions and flags:

 - Usage of custom comparators and the `mdbx_dbi_open_ex()` are deprecated, since such databases couldn't be checked by the `mdbx_chk` utility.
   Please use the value-to-key functions to provide keys that are compatible with the built-in libmdbx comparators.

********************************************************************************

## 2020-07-06

 - Added support multi-opening the same DB in a process with SysV locking (BSD).
 - Fixed warnings & minors for LCC compiler (E2K).
 - Enabled to simultaneously open the same database from processes with and without the `MDBX_WRITEMAP` option.
 - Added key-to-value, `mdbx_get_keycmp()` and `mdbx_get_datacmp()` functions (helpful to avoid using custom comparators).
 - Added `ENABLE_UBSAN` CMake option to enabling the UndefinedBehaviorSanitizer from GCC/CLANG.
 - Workaround for [CLANG bug](https://bugs.llvm.org/show_bug.cgi?id=43275).
 - Returning `MDBX_CORRUPTED` in case all meta-pages are weak and no other error.
 - Refined mode bits while auto-creating LCK-file.
 - Avoids unnecessary database file re-mapping in case geometry changed by another process(es).
   From the user's point of view, the `MDBX_UNABLE_EXTEND_MAPSIZE` error will now be returned less frequently and only when using the DB in the current process really requires it to be reopened.
 - Remapping on-the-fly and of the database file was implemented.
   Now remapping with a change of address is performed automatically if there are no dependent readers in the current process.

## 2020-06-12

 - Minor change versioning. The last number in the version now means the number of commits since last release/tag.
 - Provide ChangeLog file.
 - Fix for using libmdbx as a C-only sub-project with CMake.
 - Fix `mdbx_env_set_geometry()` for case it is called from an opened environment outside of a write transaction.
 - Add support for huge transactions and `MDBX_HUGE_TRANSACTIONS` build-option (default `OFF`).
 - Refine LTO (link time optimization) for clang.
 - Force enabling exceptions handling for MSVC (`/EHsc` option).

## 2020-06-05

 - Support for Android/Bionic.
 - Support for iOS.
 - Auto-handling `MDBX_NOSUBDIR` while opening for any existing database.
 - Engage github-actions to make release-assets.
 - Clarify API description.
 - Extended keygen-cases in stochastic test.
 - Fix fetching of first/lower key from LEAF2-page during page merge.
 - Fix missing comma in array of error messages.
 - Fix div-by-zero while copy-with-compaction for non-resizable environments.
 - Fixes & enhancements for custom-comparators.
 - Fix `MDBX_WITHOUT_MSVC_CRT` option and missing `ntdll.def`.
 - Fix `mdbx_env_close()` to work correctly called concurrently from several threads.
 - Fix null-deref in an ASAN-enabled builds while opening the environment with error and/or read-only.
 - Fix AddressSanitizer errors after closing the environment.
 - Fix/workaround to avoid GCC 10.x pedantic warnings.
 - Fix using `ENODATA` for FreeBSD.
 - Avoid invalidation of DBI-handle(s) when it just closes.
 - Avoid using `pwritev()` for single-writes (up to 10% speedup for some kernels & scenarios).
 - Avoiding `MDBX_UTTERLY_NOSYNC` as result of flags merge.
 - Add `mdbx_dbi_dupsort_depthmask()` function.
 - Add `MDBX_CP_FORCE_RESIZABLE` option.
 - Add deprecated `MDBX_MAP_RESIZED` for compatibility.
 - Add `MDBX_BUILD_TOOLS` option (default `ON`).
 - Refine `mdbx_dbi_open_ex()` to safe concurrently opening the same handle from different threads.
 - Truncate clk-file during environment closing. So a zero-length lck-file indicates that the environment was closed properly.
 - Refine `mdbx_update_gc()` for huge transactions with small sizes of database page.
 - Extends dump/load to support all MDBX attributes.
 - Avoid upsertion the same key-value data, fix related assertions.
 - Rework min/max length checking for keys & values.
 - Checking the order of keys on all pages during checking.
 - Support `CFLAGS_EXTRA` make-option for convenience.
 - Preserve the last txnid while copying with compactification.
 - Auto-reset running transaction in mdbx_txn_renew().
 - Automatically abort errored transaction in mdbx_txn_commit().
 - Auto-choose page size for large databases.
 - Rearrange source files, rework build, options-support by CMake.
 - Crutch for WSL1 (Windows subsystem for Linux).
 - Refine install/uninstall targets.
 - Support for Valgrind 3.14 and later.
 - Add check-analyzer check-ubsan check-asan check-leak targets to Makefile.
 - Minor fix/workaround to avoid UBSAN traps for `memcpy(ptr, NULL, 0)`.
 - Avoid some GCC-analyzer false-positive warnings.

## 2020-03-18

 - Workarounds for Wine (Windows compatibility layer for Linux).
 - `MDBX_MAP_RESIZED` renamed to `MDBX_UNABLE_EXTEND_MAPSIZE`.
 - Clarify API description, fix typos.
 - Speedup runtime checks in debug/checked builds.
 - Added checking for read/write transactions overlapping for the same thread, added `MDBX_TXN_OVERLAPPING` error and `MDBX_DBG_LEGACY_OVERLAP` option.
 - Added `mdbx_key_from_jsonInteger()`, `mdbx_key_from_double()`, `mdbx_key_from_float()`, `mdbx_key_from_int64()` and `mdbx_key_from_int32()` functions. See `mdbx.h` for description.
 - Fix compatibility (use zero for invalid DBI).
 - Refine/clarify error messages.
 - Avoids extra error messages "bad txn" from mdbx_chk when DB is corrupted.

## 2020-01-21

 - Fix `mdbx_load` utility for custom comparators.
 - Fix checks related to `MDBX_APPEND` flag inside `mdbx_cursor_put()`.
 - Refine/fix dbi_bind() internals.
 - Refine/fix handling `STATUS_CONFLICTING_ADDRESSES`.
 - Rework `MDBX_DBG_DUMP` option to avoid disk I/O performance degradation.
 - Add built-in help to test tool.
 - Fix `mdbx_env_set_geometry()` for large page size.
 - Fix env_set_geometry() for large pagesize.
 - Clarify API description & comments, fix typos.

## 2019-12-31

 - Fix returning MDBX_RESULT_TRUE from page_alloc().
 - Fix false-positive ASAN issue.
 - Fix assertion for `MDBX_NOTLS` option.
 - Rework `MADV_DONTNEED` threshold.
 - Fix `mdbx_chk` utility for don't checking some numbers if walking on the B-tree was disabled.
 - Use page's mp_txnid for basic integrity checking.
 - Add `MDBX_FORCE_ASSERTIONS` build-time option.
 - Rework `MDBX_DBG_DUMP` to avoid performance degradation.
 - Rename `MDBX_NOSYNC` to `MDBX_SAFE_NOSYNC` for clarity.
 - Interpret `ERROR_ACCESS_DENIED` from `OpenProcess()` as 'process exists'.
 - Avoid using `FILE_FLAG_NO_BUFFERING` for compatibility with small database pages.
 - Added install section for CMake.

## 2019-12-02

 - Support for Mac OSX, FreeBSD, NetBSD, OpenBSD, DragonFly BSD, OpenSolaris, OpenIndiana (AIX and HP-UX pending).
 - Use bootid for decisions of rollback.
 - Counting retired pages and extended transaction info.
 - Add `MDBX_ACCEDE` flag for database opening.
 - Using OFD-locks and tracking for in-process multi-opening.
 - Hot backup into pipe.
 - Support for cmake & amalgamated sources.
 - Fastest internal sort implementation.
 - New internal dirty-list implementation with lazy sorting.
 - Support for lazy-sync-to-disk with polling.
 - Extended key length.
 - Last update transaction number for each sub-database.
 - Automatic read ahead enabling/disabling.
 - More auto-compactification.
 - Using -fsanitize=undefined and -Wpedantic options.
 - Rework page merging.
 - Nested transactions.
 - API description.
 - Checking for non-local filesystems to avoid DB corruption.

********************************************************************************

For early changes see the git commit history.
