# Project Agents.md Guide for py-hamt

This AGENTS.md file provides comprehensive guidance for OpenAI Codex and other AI agents working with this codebase.

## Project Description

This library is a python implementation of a HAMT, inspired by [rvagg's IAMap project written in JavaScript](https://github.com/rvagg/iamap).

py-hamt provides efficient storage and retrieval of large sets of key-value mappings in a content-addressed storage system. The main target is IPFS, and the data model used is IPLD.

dClimate primarily created this for storing large [zarrs](https://zarr.dev/) on IPFS. To see this in action, see our [data ETLs](https://github.com/dClimate/etl-scripts).

## Project Architecture

A user instantiates a ContentAddressedStore such as KuboCAS which is then used to instantiate a HAMT. This HAMT can then be passed to a ZarrHAMTStore to read/write zarr files. An IPFS daemon running locally can be used or a remote one can be accessed via gateway(reads) & rpc endpoints(writes) on their IPFS defaults. For tests, a local docker container is spun up if docker is available.

## Project Structure for OpenAI Codex Navigation

- `/py_hamt`: Source code of the py-hamt library
    - `encryption_hamt_store.py` - Example using total encryption
    - `hamt.py`- where the HAMT data structure is constructed and accesed
    - `store.py`- Where various stores live that writes the data. Primarily used KuboCAS
    - `zarr_hamt_store.py` - ZarrHAMTStore class used to directly write or read zarrs leveraging the HAMT data structure onto a Store usually a Content Addressed store like KuboCAS located in store.py.
- `/tests`: Test files that should be maintained and extended where possible.

## Coding Conventions

### General Conventions for AGENTS.md Implementation

- Use the latest version of Python (3.12) for all new code generated by OpenAI Codex
- The AI Agent should follow the existing code style in each file
- Agents.md requires meaningful variable and function names
- The AI Agent should add comments for complex logic as guided by Agents.md

### Python Guidelines
- Use functional easy to understand functions wherever possible.
- All functions need to be fully typed with mypy.
- All functions require tests to be written and coverage must be full.
- Example usage can be found in the `/tests` folder

### Development Setup

`py-hamt` uses uv for package management. If uv is not already present which can be checked with `uv` then it can be installed via

`curl -LsSf https://astral.sh/uv/install.sh | sh`

otherwise if uv is already present you can run

`uv sync` to install all dependencies

and then

`source .venv/bin/activate` to activate the venv created by uv.

Lastly while still setting up you can run

```
pre-commit install
```

to ensure pre-commit installed.

Docker is also used for integration tests to test ipfs. Try to have docker installed to be able to run all tests with` pytest --ipfs`

## Testing Requirements for the Agent

All tests should be created within the `/tests` directory.

The agent should run tests with the following commands:

```bash
# Run all tests
pytest --ipfs

# Run specific test file
pytest test tests/<insert_file_here>

# Run tests with coverage
pytest --ipfs --cov

# If IPFS is not present use
pytest --cov
```

Tests should be kept as closed to 100% as possible.

## Pull Request Guidelines for the Agent

When the Agent helps create a PR, please ensure it:

1. Includes a clear description of the changes as guided by AGENTS.md
2. References any related issues that the Agent is addressing
3. Ensures all tests pass for code generated by the Agent
4. Keeps PRs focused on a single concern as specified in AGENTS.md

## Programmatic Checks for the Agent

Before submitting changes generated by the Agent, run:

```bash
bash run-checks.sh
```

**Note:** This assumes ipfs is running as `run-checks.sh` runs with the ``--ipfs` flag. If kubo ipfs is not running in a local daemon or docker was unable to instantiate simply run

```
pytest --cov
```

and

```
uv run pre-commit run --all-files --show-diff-on-failure
```

instead.


If there is an error with formatting for ruff and it can be autofixed you can normally run

```
uv run ruff check --fix
```

to fix it.

All checks must pass before the Agent generated code can be merged. AGENTS.md helps ensure the Agent follows these requirements.
