# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tikit.tencentcloud.common.abstract_model import AbstractModel


class AIMarketAlgo(AbstractModel):
    """以ai市场算法作为数据源

    """

    def __init__(self):
        r"""
        :param _Id: AI市场公共算法版本Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _Path: 数据路径
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        :param _MaterialName: 物料名称，可选值为 Model: 模型, Code: 代码, Data: 数据
注意：此字段可能返回 null，表示取不到有效值。
        :type MaterialName: str
        :param _Group: 算法系列
注意：此字段可能返回 null，表示取不到有效值。
        :type Group: str
        """
        self._Id = None
        self._Path = None
        self._MaterialName = None
        self._Group = None

    @property
    def Id(self):
        """AI市场公共算法版本Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Path(self):
        """数据路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MaterialName(self):
        """物料名称，可选值为 Model: 模型, Code: 代码, Data: 数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MaterialName

    @MaterialName.setter
    def MaterialName(self, MaterialName):
        self._MaterialName = MaterialName

    @property
    def Group(self):
        """算法系列
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Group

    @Group.setter
    def Group(self, Group):
        self._Group = Group


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Path = params.get("Path")
        self._MaterialName = params.get("MaterialName")
        self._Group = params.get("Group")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class APIConfigDetail(AbstractModel):
    """接口描述信息

    """

    def __init__(self):
        r"""
        :param _Id: 接口id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _ServiceGroupId: 接口所属服务组id
注意：此字段可能返回 null，表示取不到有效值。
        :type ServiceGroupId: str
        :param _Description: 接口描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _RelativeUrl: 相对路径
注意：此字段可能返回 null，表示取不到有效值。
        :type RelativeUrl: str
        :param _ServiceType: 服务类型 HTTP HTTPS
注意：此字段可能返回 null，表示取不到有效值。
        :type ServiceType: str
        :param _HttpMethod: GET POST
注意：此字段可能返回 null，表示取不到有效值。
        :type HttpMethod: str
        :param _HttpInputExample: 请求示例
注意：此字段可能返回 null，表示取不到有效值。
        :type HttpInputExample: str
        :param _HttpOutputExample: 回包示例
注意：此字段可能返回 null，表示取不到有效值。
        :type HttpOutputExample: str
        :param _UpdatedBy: 更新成员
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdatedBy: str
        :param _UpdatedAt: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdatedAt: str
        :param _Uin: 主账号uin
注意：此字段可能返回 null，表示取不到有效值。
        :type Uin: str
        :param _SubUin: 子账号subuin
注意：此字段可能返回 null，表示取不到有效值。
        :type SubUin: str
        """
        self._Id = None
        self._ServiceGroupId = None
        self._Description = None
        self._RelativeUrl = None
        self._ServiceType = None
        self._HttpMethod = None
        self._HttpInputExample = None
        self._HttpOutputExample = None
        self._UpdatedBy = None
        self._UpdatedAt = None
        self._Uin = None
        self._SubUin = None

    @property
    def Id(self):
        """接口id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ServiceGroupId(self):
        """接口所属服务组id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ServiceGroupId

    @ServiceGroupId.setter
    def ServiceGroupId(self, ServiceGroupId):
        self._ServiceGroupId = ServiceGroupId

    @property
    def Description(self):
        """接口描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RelativeUrl(self):
        """相对路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RelativeUrl

    @RelativeUrl.setter
    def RelativeUrl(self, RelativeUrl):
        self._RelativeUrl = RelativeUrl

    @property
    def ServiceType(self):
        """服务类型 HTTP HTTPS
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def HttpMethod(self):
        """GET POST
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._HttpMethod

    @HttpMethod.setter
    def HttpMethod(self, HttpMethod):
        self._HttpMethod = HttpMethod

    @property
    def HttpInputExample(self):
        """请求示例
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._HttpInputExample

    @HttpInputExample.setter
    def HttpInputExample(self, HttpInputExample):
        self._HttpInputExample = HttpInputExample

    @property
    def HttpOutputExample(self):
        """回包示例
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._HttpOutputExample

    @HttpOutputExample.setter
    def HttpOutputExample(self, HttpOutputExample):
        self._HttpOutputExample = HttpOutputExample

    @property
    def UpdatedBy(self):
        """更新成员
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdatedBy

    @UpdatedBy.setter
    def UpdatedBy(self, UpdatedBy):
        self._UpdatedBy = UpdatedBy

    @property
    def UpdatedAt(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def Uin(self):
        """主账号uin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubUin(self):
        """子账号subuin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubUin

    @SubUin.setter
    def SubUin(self, SubUin):
        self._SubUin = SubUin


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ServiceGroupId = params.get("ServiceGroupId")
        self._Description = params.get("Description")
        self._RelativeUrl = params.get("RelativeUrl")
        self._ServiceType = params.get("ServiceType")
        self._HttpMethod = params.get("HttpMethod")
        self._HttpInputExample = params.get("HttpInputExample")
        self._HttpOutputExample = params.get("HttpOutputExample")
        self._UpdatedBy = params.get("UpdatedBy")
        self._UpdatedAt = params.get("UpdatedAt")
        self._Uin = params.get("Uin")
        self._SubUin = params.get("SubUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ASRBadCase(AbstractModel):
    """ASR badcase

    """

    def __init__(self):
        r"""
        :param _AudioUrl: 音频连接
        :type AudioUrl: str
        :param _AnnotationResult: 标注结果
        :type AnnotationResult: str
        :param _CurrentResult: 当前模型结果
        :type CurrentResult: str
        :param _PreviousResult: 优化前模型结果
        :type PreviousResult: str
        :param _AudioName: 音频文件名
        :type AudioName: str
        """
        self._AudioUrl = None
        self._AnnotationResult = None
        self._CurrentResult = None
        self._PreviousResult = None
        self._AudioName = None

    @property
    def AudioUrl(self):
        """音频连接
        :rtype: str
        """
        return self._AudioUrl

    @AudioUrl.setter
    def AudioUrl(self, AudioUrl):
        self._AudioUrl = AudioUrl

    @property
    def AnnotationResult(self):
        """标注结果
        :rtype: str
        """
        return self._AnnotationResult

    @AnnotationResult.setter
    def AnnotationResult(self, AnnotationResult):
        self._AnnotationResult = AnnotationResult

    @property
    def CurrentResult(self):
        """当前模型结果
        :rtype: str
        """
        return self._CurrentResult

    @CurrentResult.setter
    def CurrentResult(self, CurrentResult):
        self._CurrentResult = CurrentResult

    @property
    def PreviousResult(self):
        """优化前模型结果
        :rtype: str
        """
        return self._PreviousResult

    @PreviousResult.setter
    def PreviousResult(self, PreviousResult):
        self._PreviousResult = PreviousResult

    @property
    def AudioName(self):
        """音频文件名
        :rtype: str
        """
        return self._AudioName

    @AudioName.setter
    def AudioName(self, AudioName):
        self._AudioName = AudioName


    def _deserialize(self, params):
        self._AudioUrl = params.get("AudioUrl")
        self._AnnotationResult = params.get("AnnotationResult")
        self._CurrentResult = params.get("CurrentResult")
        self._PreviousResult = params.get("PreviousResult")
        self._AudioName = params.get("AudioName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddDocumentToKnowledgeBaseRequest(AbstractModel):
    """AddDocumentToKnowledgeBase请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SessionId: 会话ID，用于区分不同的会话
        :type SessionId: str
        :param _ModelId: 模型ID，区分模型
        :type ModelId: str
        :param _Document: 文档
        :type Document: :class:`tencentcloud.tione.v20211111.models.KnowledgeDocument`
        """
        self._SessionId = None
        self._ModelId = None
        self._Document = None

    @property
    def SessionId(self):
        """会话ID，用于区分不同的会话
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def ModelId(self):
        """模型ID，区分模型
        :rtype: str
        """
        return self._ModelId

    @ModelId.setter
    def ModelId(self, ModelId):
        self._ModelId = ModelId

    @property
    def Document(self):
        """文档
        :rtype: :class:`tencentcloud.tione.v20211111.models.KnowledgeDocument`
        """
        return self._Document

    @Document.setter
    def Document(self, Document):
        self._Document = Document


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._ModelId = params.get("ModelId")
        if params.get("Document") is not None:
            self._Document = KnowledgeDocument()
            self._Document._deserialize(params.get("Document"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddDocumentToKnowledgeBaseResponse(AbstractModel):
    """AddDocumentToKnowledgeBase返回参数结构体

    """

    def __init__(self):
        r"""
        :param _KnowledgeBaseId: 知识库Id
        :type KnowledgeBaseId: str
        :param _DocumentId: 插入成功的标识Id
        :type DocumentId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._KnowledgeBaseId = None
        self._DocumentId = None
        self._RequestId = None

    @property
    def KnowledgeBaseId(self):
        """知识库Id
        :rtype: str
        """
        return self._KnowledgeBaseId

    @KnowledgeBaseId.setter
    def KnowledgeBaseId(self, KnowledgeBaseId):
        self._KnowledgeBaseId = KnowledgeBaseId

    @property
    def DocumentId(self):
        """插入成功的标识Id
        :rtype: str
        """
        return self._DocumentId

    @DocumentId.setter
    def DocumentId(self, DocumentId):
        self._DocumentId = DocumentId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._KnowledgeBaseId = params.get("KnowledgeBaseId")
        self._DocumentId = params.get("DocumentId")
        self._RequestId = params.get("RequestId")


class AddTaskTrainSampleRequest(AbstractModel):
    """AddTaskTrainSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SampleItems: 待加入训练集的文本样本
        :type SampleItems: list of SampleItem
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _AppKey: 应用key
        :type AppKey: str
        """
        self._SampleItems = None
        self._ProjectId = None
        self._AppKey = None

    @property
    def SampleItems(self):
        """待加入训练集的文本样本
        :rtype: list of SampleItem
        """
        return self._SampleItems

    @SampleItems.setter
    def SampleItems(self, SampleItems):
        self._SampleItems = SampleItems

    @property
    def ProjectId(self):
        """项目id
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AppKey(self):
        """应用key
        :rtype: str
        """
        return self._AppKey

    @AppKey.setter
    def AppKey(self, AppKey):
        self._AppKey = AppKey


    def _deserialize(self, params):
        if params.get("SampleItems") is not None:
            self._SampleItems = []
            for item in params.get("SampleItems"):
                obj = SampleItem()
                obj._deserialize(item)
                self._SampleItems.append(obj)
        self._ProjectId = params.get("ProjectId")
        self._AppKey = params.get("AppKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddTaskTrainSampleResponse(AbstractModel):
    """AddTaskTrainSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FileNames: 保存的文件名称
        :type FileNames: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FileNames = None
        self._RequestId = None

    @property
    def FileNames(self):
        """保存的文件名称
        :rtype: list of str
        """
        return self._FileNames

    @FileNames.setter
    def FileNames(self, FileNames):
        self._FileNames = FileNames

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FileNames = params.get("FileNames")
        self._RequestId = params.get("RequestId")


class AddTencentLabWhitelistRequest(AbstractModel):
    """AddTencentLabWhitelist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassUin: 需要增加白名单的主uin
        :type ClassUin: str
        :param _ClassSubUin: 需要增加白名单的subUin
        :type ClassSubUin: str
        :param _ResourceId: Tione 平台维护的资源 ID，对应腾学会的课程 ID
        :type ResourceId: str
        :param _ExpireDurationSecond: 过期时长，以请求收到的时间向后延后 ExpireDurationSecond 计算过期时刻
        :type ExpireDurationSecond: int
        :param _Description: 备注描述
        :type Description: str
        """
        self._ClassUin = None
        self._ClassSubUin = None
        self._ResourceId = None
        self._ExpireDurationSecond = None
        self._Description = None

    @property
    def ClassUin(self):
        """需要增加白名单的主uin
        :rtype: str
        """
        return self._ClassUin

    @ClassUin.setter
    def ClassUin(self, ClassUin):
        self._ClassUin = ClassUin

    @property
    def ClassSubUin(self):
        """需要增加白名单的subUin
        :rtype: str
        """
        return self._ClassSubUin

    @ClassSubUin.setter
    def ClassSubUin(self, ClassSubUin):
        self._ClassSubUin = ClassSubUin

    @property
    def ResourceId(self):
        """Tione 平台维护的资源 ID，对应腾学会的课程 ID
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def ExpireDurationSecond(self):
        """过期时长，以请求收到的时间向后延后 ExpireDurationSecond 计算过期时刻
        :rtype: int
        """
        return self._ExpireDurationSecond

    @ExpireDurationSecond.setter
    def ExpireDurationSecond(self, ExpireDurationSecond):
        self._ExpireDurationSecond = ExpireDurationSecond

    @property
    def Description(self):
        """备注描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClassUin = params.get("ClassUin")
        self._ClassSubUin = params.get("ClassSubUin")
        self._ResourceId = params.get("ResourceId")
        self._ExpireDurationSecond = params.get("ExpireDurationSecond")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddTencentLabWhitelistResponse(AbstractModel):
    """AddTencentLabWhitelist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ExtraCosSourcePathJson: json 格式。课程进行需要的额外 cos 信息。数据源路径信息。若为json 结构或空字符串则表示无额外信息。格式如下
  { 
   "bucket": string,
   "region": string,
   "paths": string array
   }
        :type ExtraCosSourcePathJson: str
        :param _ExtraCosTargetPathJson: json 格式。课程进行需要的额外 cos 信息。数据目标路径信息。若为json 结构或空字符串则表示无额外信息。格式如下
   {
   "path": string
   }
        :type ExtraCosTargetPathJson: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ExtraCosSourcePathJson = None
        self._ExtraCosTargetPathJson = None
        self._RequestId = None

    @property
    def ExtraCosSourcePathJson(self):
        """json 格式。课程进行需要的额外 cos 信息。数据源路径信息。若为json 结构或空字符串则表示无额外信息。格式如下
  { 
   "bucket": string,
   "region": string,
   "paths": string array
   }
        :rtype: str
        """
        return self._ExtraCosSourcePathJson

    @ExtraCosSourcePathJson.setter
    def ExtraCosSourcePathJson(self, ExtraCosSourcePathJson):
        self._ExtraCosSourcePathJson = ExtraCosSourcePathJson

    @property
    def ExtraCosTargetPathJson(self):
        """json 格式。课程进行需要的额外 cos 信息。数据目标路径信息。若为json 结构或空字符串则表示无额外信息。格式如下
   {
   "path": string
   }
        :rtype: str
        """
        return self._ExtraCosTargetPathJson

    @ExtraCosTargetPathJson.setter
    def ExtraCosTargetPathJson(self, ExtraCosTargetPathJson):
        self._ExtraCosTargetPathJson = ExtraCosTargetPathJson

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExtraCosSourcePathJson = params.get("ExtraCosSourcePathJson")
        self._ExtraCosTargetPathJson = params.get("ExtraCosTargetPathJson")
        self._RequestId = params.get("RequestId")


class AddTencentLabWhitelistTestRequest(AbstractModel):
    """AddTencentLabWhitelistTest请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassUin: 需要增加白名单的主uin
        :type ClassUin: str
        :param _ClassSubUin: 需要增加白名单的subUin
        :type ClassSubUin: str
        :param _ResourceId: Tione 平台维护的资源 ID，对应腾学会的课程 ID
        :type ResourceId: str
        :param _ExpireDurationSecond: 过期时长，以请求收到的时间向后延后 ExpireDurationSecond 计算过期时刻
        :type ExpireDurationSecond: int
        :param _Description: 备注描述
        :type Description: str
        """
        self._ClassUin = None
        self._ClassSubUin = None
        self._ResourceId = None
        self._ExpireDurationSecond = None
        self._Description = None

    @property
    def ClassUin(self):
        """需要增加白名单的主uin
        :rtype: str
        """
        return self._ClassUin

    @ClassUin.setter
    def ClassUin(self, ClassUin):
        self._ClassUin = ClassUin

    @property
    def ClassSubUin(self):
        """需要增加白名单的subUin
        :rtype: str
        """
        return self._ClassSubUin

    @ClassSubUin.setter
    def ClassSubUin(self, ClassSubUin):
        self._ClassSubUin = ClassSubUin

    @property
    def ResourceId(self):
        """Tione 平台维护的资源 ID，对应腾学会的课程 ID
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def ExpireDurationSecond(self):
        """过期时长，以请求收到的时间向后延后 ExpireDurationSecond 计算过期时刻
        :rtype: int
        """
        return self._ExpireDurationSecond

    @ExpireDurationSecond.setter
    def ExpireDurationSecond(self, ExpireDurationSecond):
        self._ExpireDurationSecond = ExpireDurationSecond

    @property
    def Description(self):
        """备注描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClassUin = params.get("ClassUin")
        self._ClassSubUin = params.get("ClassSubUin")
        self._ResourceId = params.get("ResourceId")
        self._ExpireDurationSecond = params.get("ExpireDurationSecond")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddTencentLabWhitelistTestResponse(AbstractModel):
    """AddTencentLabWhitelistTest返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ExtraCosSourcePathJson: json 格式。课程进行需要的额外 cos 信息。数据源路径信息。若为json 结构或空字符串则表示无额外信息。格式如下
  { 
   "bucket": string,
   "region": string,
   "paths": string array
   }
        :type ExtraCosSourcePathJson: str
        :param _ExtraCosTargetPathJson: json 格式。课程进行需要的额外 cos 信息。数据目标路径信息。若为json 结构或空字符串则表示无额外信息。格式如下
   {
   "path": string
   }
        :type ExtraCosTargetPathJson: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ExtraCosSourcePathJson = None
        self._ExtraCosTargetPathJson = None
        self._RequestId = None

    @property
    def ExtraCosSourcePathJson(self):
        """json 格式。课程进行需要的额外 cos 信息。数据源路径信息。若为json 结构或空字符串则表示无额外信息。格式如下
  { 
   "bucket": string,
   "region": string,
   "paths": string array
   }
        :rtype: str
        """
        return self._ExtraCosSourcePathJson

    @ExtraCosSourcePathJson.setter
    def ExtraCosSourcePathJson(self, ExtraCosSourcePathJson):
        self._ExtraCosSourcePathJson = ExtraCosSourcePathJson

    @property
    def ExtraCosTargetPathJson(self):
        """json 格式。课程进行需要的额外 cos 信息。数据目标路径信息。若为json 结构或空字符串则表示无额外信息。格式如下
   {
   "path": string
   }
        :rtype: str
        """
        return self._ExtraCosTargetPathJson

    @ExtraCosTargetPathJson.setter
    def ExtraCosTargetPathJson(self, ExtraCosTargetPathJson):
        self._ExtraCosTargetPathJson = ExtraCosTargetPathJson

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExtraCosSourcePathJson = params.get("ExtraCosSourcePathJson")
        self._ExtraCosTargetPathJson = params.get("ExtraCosTargetPathJson")
        self._RequestId = params.get("RequestId")


class AggregatePublicAlgoVersion(AbstractModel):
    """聚合后的公共算法版本

    """

    def __init__(self):
        r"""
        :param _GroupName: 用于聚合的系列名字
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupName: str
        :param _PublicAlgoVersions: 算法公共版本列表
注意：此字段可能返回 null，表示取不到有效值。
        :type PublicAlgoVersions: list of PublicAlgoVersion
        """
        self._GroupName = None
        self._PublicAlgoVersions = None

    @property
    def GroupName(self):
        """用于聚合的系列名字
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def PublicAlgoVersions(self):
        """算法公共版本列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of PublicAlgoVersion
        """
        return self._PublicAlgoVersions

    @PublicAlgoVersions.setter
    def PublicAlgoVersions(self, PublicAlgoVersions):
        self._PublicAlgoVersions = PublicAlgoVersions


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        if params.get("PublicAlgoVersions") is not None:
            self._PublicAlgoVersions = []
            for item in params.get("PublicAlgoVersions"):
                obj = PublicAlgoVersion()
                obj._deserialize(item)
                self._PublicAlgoVersions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiMarketInfo(AbstractModel):
    """ai市场cos信息

    """

    def __init__(self):
        r"""
        :param _AlgorithmCosConfig: 算法cos信息
        :type AlgorithmCosConfig: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        self._AlgorithmCosConfig = None

    @property
    def AlgorithmCosConfig(self):
        """算法cos信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._AlgorithmCosConfig

    @AlgorithmCosConfig.setter
    def AlgorithmCosConfig(self, AlgorithmCosConfig):
        self._AlgorithmCosConfig = AlgorithmCosConfig


    def _deserialize(self, params):
        if params.get("AlgorithmCosConfig") is not None:
            self._AlgorithmCosConfig = CosPathInfo()
            self._AlgorithmCosConfig._deserialize(params.get("AlgorithmCosConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlgoGroup(AbstractModel):
    """我的算法组信息

    """

    def __init__(self):
        r"""
        :param _AlgoGroupId: 算法组Id
注意：此字段可能返回 null，表示取不到有效值。
        :type AlgoGroupId: str
        :param _Name: 算法名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _RelationPublicAlgoVersionId: 关联的公共算法版本Id
注意：此字段可能返回 null，表示取不到有效值。
        :type RelationPublicAlgoVersionId: str
        :param _RelationPublicVersion: 关联的公共算法版本号
注意：此字段可能返回 null，表示取不到有效值。
        :type RelationPublicVersion: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _RelationPublicAlgoGroupId: 关联的公共算法组Id
注意：此字段可能返回 null，表示取不到有效值。
        :type RelationPublicAlgoGroupId: str
        :param _RelationPublicAlgoNameId: 关联的公共算法名称
注意：此字段可能返回 null，表示取不到有效值。
        :type RelationPublicAlgoNameId: str
        """
        self._AlgoGroupId = None
        self._Name = None
        self._RelationPublicAlgoVersionId = None
        self._RelationPublicVersion = None
        self._CreateTime = None
        self._UpdateTime = None
        self._RelationPublicAlgoGroupId = None
        self._RelationPublicAlgoNameId = None

    @property
    def AlgoGroupId(self):
        """算法组Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AlgoGroupId

    @AlgoGroupId.setter
    def AlgoGroupId(self, AlgoGroupId):
        self._AlgoGroupId = AlgoGroupId

    @property
    def Name(self):
        """算法名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def RelationPublicAlgoVersionId(self):
        """关联的公共算法版本Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RelationPublicAlgoVersionId

    @RelationPublicAlgoVersionId.setter
    def RelationPublicAlgoVersionId(self, RelationPublicAlgoVersionId):
        self._RelationPublicAlgoVersionId = RelationPublicAlgoVersionId

    @property
    def RelationPublicVersion(self):
        """关联的公共算法版本号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RelationPublicVersion

    @RelationPublicVersion.setter
    def RelationPublicVersion(self, RelationPublicVersion):
        self._RelationPublicVersion = RelationPublicVersion

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def RelationPublicAlgoGroupId(self):
        """关联的公共算法组Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RelationPublicAlgoGroupId

    @RelationPublicAlgoGroupId.setter
    def RelationPublicAlgoGroupId(self, RelationPublicAlgoGroupId):
        self._RelationPublicAlgoGroupId = RelationPublicAlgoGroupId

    @property
    def RelationPublicAlgoNameId(self):
        """关联的公共算法名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RelationPublicAlgoNameId

    @RelationPublicAlgoNameId.setter
    def RelationPublicAlgoNameId(self, RelationPublicAlgoNameId):
        self._RelationPublicAlgoNameId = RelationPublicAlgoNameId


    def _deserialize(self, params):
        self._AlgoGroupId = params.get("AlgoGroupId")
        self._Name = params.get("Name")
        self._RelationPublicAlgoVersionId = params.get("RelationPublicAlgoVersionId")
        self._RelationPublicVersion = params.get("RelationPublicVersion")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._RelationPublicAlgoGroupId = params.get("RelationPublicAlgoGroupId")
        self._RelationPublicAlgoNameId = params.get("RelationPublicAlgoNameId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlgoVersion(AbstractModel):
    """我的算法版本信息

    """

    def __init__(self):
        r"""
        :param _AlgoVersionId: 算法版本Id
注意：此字段可能返回 null，表示取不到有效值。
        :type AlgoVersionId: str
        :param _Version: 版本号
注意：此字段可能返回 null，表示取不到有效值。
        :type Version: int
        :param _TrainCodeInfo: 训练代码信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainCodeInfo: :class:`tencentcloud.tione.v20211111.models.MaterialInfo`
        :param _TrainImageInfo: 训练镜像信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainImageInfo: :class:`tencentcloud.tione.v20211111.models.MaterialInfo`
        :param _ModelInfo: 预置模型信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelInfo: :class:`tencentcloud.tione.v20211111.models.MaterialInfo`
        :param _Tags: tag数组
注意：此字段可能返回 null，表示取不到有效值。
        :type Tags: list of Tag
        :param _NoteBookInstanceId: 关联的notebook实例Id
注意：此字段可能返回 null，表示取不到有效值。
        :type NoteBookInstanceId: str
        :param _NotebookLifecycleScriptId: 关联的notebook生命周期脚本Id
注意：此字段可能返回 null，表示取不到有效值。
        :type NotebookLifecycleScriptId: str
        :param _NotebookLifecycleScriptName: 关联的notebook生命周期脚本名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NotebookLifecycleScriptName: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _DefaultResourceSpec: 默认资源规格
注意：此字段可能返回 null，表示取不到有效值。
        :type DefaultResourceSpec: :class:`tencentcloud.tione.v20211111.models.ResourceSpec`
        """
        self._AlgoVersionId = None
        self._Version = None
        self._TrainCodeInfo = None
        self._TrainImageInfo = None
        self._ModelInfo = None
        self._Tags = None
        self._NoteBookInstanceId = None
        self._NotebookLifecycleScriptId = None
        self._NotebookLifecycleScriptName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._DefaultResourceSpec = None

    @property
    def AlgoVersionId(self):
        """算法版本Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AlgoVersionId

    @AlgoVersionId.setter
    def AlgoVersionId(self, AlgoVersionId):
        self._AlgoVersionId = AlgoVersionId

    @property
    def Version(self):
        """版本号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def TrainCodeInfo(self):
        """训练代码信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.MaterialInfo`
        """
        return self._TrainCodeInfo

    @TrainCodeInfo.setter
    def TrainCodeInfo(self, TrainCodeInfo):
        self._TrainCodeInfo = TrainCodeInfo

    @property
    def TrainImageInfo(self):
        """训练镜像信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.MaterialInfo`
        """
        return self._TrainImageInfo

    @TrainImageInfo.setter
    def TrainImageInfo(self, TrainImageInfo):
        self._TrainImageInfo = TrainImageInfo

    @property
    def ModelInfo(self):
        """预置模型信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.MaterialInfo`
        """
        return self._ModelInfo

    @ModelInfo.setter
    def ModelInfo(self, ModelInfo):
        self._ModelInfo = ModelInfo

    @property
    def Tags(self):
        """tag数组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def NoteBookInstanceId(self):
        """关联的notebook实例Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NoteBookInstanceId

    @NoteBookInstanceId.setter
    def NoteBookInstanceId(self, NoteBookInstanceId):
        self._NoteBookInstanceId = NoteBookInstanceId

    @property
    def NotebookLifecycleScriptId(self):
        """关联的notebook生命周期脚本Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NotebookLifecycleScriptId

    @NotebookLifecycleScriptId.setter
    def NotebookLifecycleScriptId(self, NotebookLifecycleScriptId):
        self._NotebookLifecycleScriptId = NotebookLifecycleScriptId

    @property
    def NotebookLifecycleScriptName(self):
        """关联的notebook生命周期脚本名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NotebookLifecycleScriptName

    @NotebookLifecycleScriptName.setter
    def NotebookLifecycleScriptName(self, NotebookLifecycleScriptName):
        self._NotebookLifecycleScriptName = NotebookLifecycleScriptName

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def DefaultResourceSpec(self):
        """默认资源规格
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceSpec`
        """
        return self._DefaultResourceSpec

    @DefaultResourceSpec.setter
    def DefaultResourceSpec(self, DefaultResourceSpec):
        self._DefaultResourceSpec = DefaultResourceSpec


    def _deserialize(self, params):
        self._AlgoVersionId = params.get("AlgoVersionId")
        self._Version = params.get("Version")
        if params.get("TrainCodeInfo") is not None:
            self._TrainCodeInfo = MaterialInfo()
            self._TrainCodeInfo._deserialize(params.get("TrainCodeInfo"))
        if params.get("TrainImageInfo") is not None:
            self._TrainImageInfo = MaterialInfo()
            self._TrainImageInfo._deserialize(params.get("TrainImageInfo"))
        if params.get("ModelInfo") is not None:
            self._ModelInfo = MaterialInfo()
            self._ModelInfo._deserialize(params.get("ModelInfo"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._NoteBookInstanceId = params.get("NoteBookInstanceId")
        self._NotebookLifecycleScriptId = params.get("NotebookLifecycleScriptId")
        self._NotebookLifecycleScriptName = params.get("NotebookLifecycleScriptName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("DefaultResourceSpec") is not None:
            self._DefaultResourceSpec = ResourceSpec()
            self._DefaultResourceSpec._deserialize(params.get("DefaultResourceSpec"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnnotateRecord(AbstractModel):
    """表示一个标注样本

    """

    def __init__(self):
        r"""
        :param _RecordId: 样本id
        :type RecordId: str
        :param _Values: 样本内容
        :type Values: list of str
        :param _AnnotationStatus: 标注状态：1-已标注；0-未标注
        :type AnnotationStatus: int
        :param _SubmitStatus: 提交状态：1-已提交；0-未提交
        :type SubmitStatus: int
        :param _ImageList: 图片列表
        :type ImageList: list of ImageData
        :param _UploadImageList: 用户上传的图片列表
        :type UploadImageList: list of ImageData
        """
        self._RecordId = None
        self._Values = None
        self._AnnotationStatus = None
        self._SubmitStatus = None
        self._ImageList = None
        self._UploadImageList = None

    @property
    def RecordId(self):
        """样本id
        :rtype: str
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def Values(self):
        """样本内容
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def AnnotationStatus(self):
        """标注状态：1-已标注；0-未标注
        :rtype: int
        """
        return self._AnnotationStatus

    @AnnotationStatus.setter
    def AnnotationStatus(self, AnnotationStatus):
        self._AnnotationStatus = AnnotationStatus

    @property
    def SubmitStatus(self):
        """提交状态：1-已提交；0-未提交
        :rtype: int
        """
        return self._SubmitStatus

    @SubmitStatus.setter
    def SubmitStatus(self, SubmitStatus):
        self._SubmitStatus = SubmitStatus

    @property
    def ImageList(self):
        """图片列表
        :rtype: list of ImageData
        """
        return self._ImageList

    @ImageList.setter
    def ImageList(self, ImageList):
        self._ImageList = ImageList

    @property
    def UploadImageList(self):
        """用户上传的图片列表
        :rtype: list of ImageData
        """
        return self._UploadImageList

    @UploadImageList.setter
    def UploadImageList(self, UploadImageList):
        self._UploadImageList = UploadImageList


    def _deserialize(self, params):
        self._RecordId = params.get("RecordId")
        self._Values = params.get("Values")
        self._AnnotationStatus = params.get("AnnotationStatus")
        self._SubmitStatus = params.get("SubmitStatus")
        if params.get("ImageList") is not None:
            self._ImageList = []
            for item in params.get("ImageList"):
                obj = ImageData()
                obj._deserialize(item)
                self._ImageList.append(obj)
        if params.get("UploadImageList") is not None:
            self._UploadImageList = []
            for item in params.get("UploadImageList"):
                obj = ImageData()
                obj._deserialize(item)
                self._UploadImageList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnnotationTaskInfo(AbstractModel):
    """描述标注任务详细信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 标注任务id
        :type TaskId: str
        :param _TaskName: 标注任务名称
        :type TaskName: str
        :param _DatasetId: 数据集id
        :type DatasetId: str
        :param _DatasetName: 数据集名称
        :type DatasetName: str
        :param _SceneName: 标注场景名称
        :type SceneName: str
        :param _LabelValueList: 标注任务的label信息数组
        :type LabelValueList: list of LabelValue
        :param _CamTagList: tag详情数组
        :type CamTagList: list of CamTag
        :param _Status: 任务状态
        :type Status: int
        :param _AbnormalMsg: 创建任务失败原因说明
        :type AbnormalMsg: str
        :param _IsSubmitting: 标注任务是否正在提交
        :type IsSubmitting: bool
        :param _TaskNote: 任务详情描述
        :type TaskNote: str
        :param _DataSetVersion: 数据集版本
        :type DataSetVersion: str
        :param _NumAnnotated: 已经标注的图片数量
        :type NumAnnotated: int
        :param _NumTotal: 标注的总图片数量
        :type NumTotal: int
        :param _CreateTime: 创建任务的时间戳
        :type CreateTime: int
        :param _OcrToolType: Ocr Tool Type
        :type OcrToolType: int
        :param _OcrTextAttributeAnnotateEnable: Ocr Text Attribute Annotate Enable
        :type OcrTextAttributeAnnotateEnable: bool
        :param _ExportFormat: 导出格式
        :type ExportFormat: str
        :param _SubmittingErrorMsg: 提交错误说明
        :type SubmittingErrorMsg: str
        :param _OcrAnnotationContentType: ocr任务类型：1-识别。2-智能结构化
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrAnnotationContentType: int
        :param _EnableAuxiliaryAnnotation: OCR任务：是否启用辅助标注
注意：此字段可能返回 null，表示取不到有效值。
        :type EnableAuxiliaryAnnotation: bool
        :param _ProcessingStatus: 任务进度
注意：此字段可能返回 null，表示取不到有效值。
        :type ProcessingStatus: int
        :param _NeedReload: 是否需要重载
注意：此字段可能返回 null，表示取不到有效值。
        :type NeedReload: bool
        :param _KeyPairsInUpdating: 是否正在更新
注意：此字段可能返回 null，表示取不到有效值。
        :type KeyPairsInUpdating: bool
        :param _DatasetCreator: 数据集创建者UIN
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetCreator: str
        :param _Creator: 任务创建者UIN
注意：此字段可能返回 null，表示取不到有效值。
        :type Creator: str
        :param _DatasetCreatorName: 数据集创建者名称
        :type DatasetCreatorName: str
        :param _CreatorName: 任务创建者名称
        :type CreatorName: str
        """
        self._TaskId = None
        self._TaskName = None
        self._DatasetId = None
        self._DatasetName = None
        self._SceneName = None
        self._LabelValueList = None
        self._CamTagList = None
        self._Status = None
        self._AbnormalMsg = None
        self._IsSubmitting = None
        self._TaskNote = None
        self._DataSetVersion = None
        self._NumAnnotated = None
        self._NumTotal = None
        self._CreateTime = None
        self._OcrToolType = None
        self._OcrTextAttributeAnnotateEnable = None
        self._ExportFormat = None
        self._SubmittingErrorMsg = None
        self._OcrAnnotationContentType = None
        self._EnableAuxiliaryAnnotation = None
        self._ProcessingStatus = None
        self._NeedReload = None
        self._KeyPairsInUpdating = None
        self._DatasetCreator = None
        self._Creator = None
        self._DatasetCreatorName = None
        self._CreatorName = None

    @property
    def TaskId(self):
        """标注任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        """标注任务名称
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def DatasetId(self):
        """数据集id
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def DatasetName(self):
        """数据集名称
        :rtype: str
        """
        return self._DatasetName

    @DatasetName.setter
    def DatasetName(self, DatasetName):
        self._DatasetName = DatasetName

    @property
    def SceneName(self):
        """标注场景名称
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName

    @property
    def LabelValueList(self):
        """标注任务的label信息数组
        :rtype: list of LabelValue
        """
        return self._LabelValueList

    @LabelValueList.setter
    def LabelValueList(self, LabelValueList):
        self._LabelValueList = LabelValueList

    @property
    def CamTagList(self):
        """tag详情数组
        :rtype: list of CamTag
        """
        return self._CamTagList

    @CamTagList.setter
    def CamTagList(self, CamTagList):
        self._CamTagList = CamTagList

    @property
    def Status(self):
        """任务状态
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AbnormalMsg(self):
        """创建任务失败原因说明
        :rtype: str
        """
        return self._AbnormalMsg

    @AbnormalMsg.setter
    def AbnormalMsg(self, AbnormalMsg):
        self._AbnormalMsg = AbnormalMsg

    @property
    def IsSubmitting(self):
        """标注任务是否正在提交
        :rtype: bool
        """
        return self._IsSubmitting

    @IsSubmitting.setter
    def IsSubmitting(self, IsSubmitting):
        self._IsSubmitting = IsSubmitting

    @property
    def TaskNote(self):
        """任务详情描述
        :rtype: str
        """
        return self._TaskNote

    @TaskNote.setter
    def TaskNote(self, TaskNote):
        self._TaskNote = TaskNote

    @property
    def DataSetVersion(self):
        """数据集版本
        :rtype: str
        """
        return self._DataSetVersion

    @DataSetVersion.setter
    def DataSetVersion(self, DataSetVersion):
        self._DataSetVersion = DataSetVersion

    @property
    def NumAnnotated(self):
        """已经标注的图片数量
        :rtype: int
        """
        return self._NumAnnotated

    @NumAnnotated.setter
    def NumAnnotated(self, NumAnnotated):
        self._NumAnnotated = NumAnnotated

    @property
    def NumTotal(self):
        """标注的总图片数量
        :rtype: int
        """
        return self._NumTotal

    @NumTotal.setter
    def NumTotal(self, NumTotal):
        self._NumTotal = NumTotal

    @property
    def CreateTime(self):
        """创建任务的时间戳
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def OcrToolType(self):
        """Ocr Tool Type
        :rtype: int
        """
        return self._OcrToolType

    @OcrToolType.setter
    def OcrToolType(self, OcrToolType):
        self._OcrToolType = OcrToolType

    @property
    def OcrTextAttributeAnnotateEnable(self):
        """Ocr Text Attribute Annotate Enable
        :rtype: bool
        """
        return self._OcrTextAttributeAnnotateEnable

    @OcrTextAttributeAnnotateEnable.setter
    def OcrTextAttributeAnnotateEnable(self, OcrTextAttributeAnnotateEnable):
        self._OcrTextAttributeAnnotateEnable = OcrTextAttributeAnnotateEnable

    @property
    def ExportFormat(self):
        """导出格式
        :rtype: str
        """
        return self._ExportFormat

    @ExportFormat.setter
    def ExportFormat(self, ExportFormat):
        self._ExportFormat = ExportFormat

    @property
    def SubmittingErrorMsg(self):
        """提交错误说明
        :rtype: str
        """
        return self._SubmittingErrorMsg

    @SubmittingErrorMsg.setter
    def SubmittingErrorMsg(self, SubmittingErrorMsg):
        self._SubmittingErrorMsg = SubmittingErrorMsg

    @property
    def OcrAnnotationContentType(self):
        """ocr任务类型：1-识别。2-智能结构化
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._OcrAnnotationContentType

    @OcrAnnotationContentType.setter
    def OcrAnnotationContentType(self, OcrAnnotationContentType):
        self._OcrAnnotationContentType = OcrAnnotationContentType

    @property
    def EnableAuxiliaryAnnotation(self):
        """OCR任务：是否启用辅助标注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._EnableAuxiliaryAnnotation

    @EnableAuxiliaryAnnotation.setter
    def EnableAuxiliaryAnnotation(self, EnableAuxiliaryAnnotation):
        self._EnableAuxiliaryAnnotation = EnableAuxiliaryAnnotation

    @property
    def ProcessingStatus(self):
        """任务进度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ProcessingStatus

    @ProcessingStatus.setter
    def ProcessingStatus(self, ProcessingStatus):
        self._ProcessingStatus = ProcessingStatus

    @property
    def NeedReload(self):
        """是否需要重载
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._NeedReload

    @NeedReload.setter
    def NeedReload(self, NeedReload):
        self._NeedReload = NeedReload

    @property
    def KeyPairsInUpdating(self):
        """是否正在更新
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._KeyPairsInUpdating

    @KeyPairsInUpdating.setter
    def KeyPairsInUpdating(self, KeyPairsInUpdating):
        self._KeyPairsInUpdating = KeyPairsInUpdating

    @property
    def DatasetCreator(self):
        """数据集创建者UIN
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetCreator

    @DatasetCreator.setter
    def DatasetCreator(self, DatasetCreator):
        self._DatasetCreator = DatasetCreator

    @property
    def Creator(self):
        """任务创建者UIN
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def DatasetCreatorName(self):
        """数据集创建者名称
        :rtype: str
        """
        return self._DatasetCreatorName

    @DatasetCreatorName.setter
    def DatasetCreatorName(self, DatasetCreatorName):
        self._DatasetCreatorName = DatasetCreatorName

    @property
    def CreatorName(self):
        """任务创建者名称
        :rtype: str
        """
        return self._CreatorName

    @CreatorName.setter
    def CreatorName(self, CreatorName):
        self._CreatorName = CreatorName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._DatasetId = params.get("DatasetId")
        self._DatasetName = params.get("DatasetName")
        self._SceneName = params.get("SceneName")
        if params.get("LabelValueList") is not None:
            self._LabelValueList = []
            for item in params.get("LabelValueList"):
                obj = LabelValue()
                obj._deserialize(item)
                self._LabelValueList.append(obj)
        if params.get("CamTagList") is not None:
            self._CamTagList = []
            for item in params.get("CamTagList"):
                obj = CamTag()
                obj._deserialize(item)
                self._CamTagList.append(obj)
        self._Status = params.get("Status")
        self._AbnormalMsg = params.get("AbnormalMsg")
        self._IsSubmitting = params.get("IsSubmitting")
        self._TaskNote = params.get("TaskNote")
        self._DataSetVersion = params.get("DataSetVersion")
        self._NumAnnotated = params.get("NumAnnotated")
        self._NumTotal = params.get("NumTotal")
        self._CreateTime = params.get("CreateTime")
        self._OcrToolType = params.get("OcrToolType")
        self._OcrTextAttributeAnnotateEnable = params.get("OcrTextAttributeAnnotateEnable")
        self._ExportFormat = params.get("ExportFormat")
        self._SubmittingErrorMsg = params.get("SubmittingErrorMsg")
        self._OcrAnnotationContentType = params.get("OcrAnnotationContentType")
        self._EnableAuxiliaryAnnotation = params.get("EnableAuxiliaryAnnotation")
        self._ProcessingStatus = params.get("ProcessingStatus")
        self._NeedReload = params.get("NeedReload")
        self._KeyPairsInUpdating = params.get("KeyPairsInUpdating")
        self._DatasetCreator = params.get("DatasetCreator")
        self._Creator = params.get("Creator")
        self._DatasetCreatorName = params.get("DatasetCreatorName")
        self._CreatorName = params.get("CreatorName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnnotationTypeConfig(AbstractModel):
    """标注场景配置

    """

    def __init__(self):
        r"""
        :param _AnnotationType: 标注场景枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationType: str
        :param _AnnotationTypeName: 标注场景名称
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationTypeName: str
        """
        self._AnnotationType = None
        self._AnnotationTypeName = None

    @property
    def AnnotationType(self):
        """标注场景枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationType

    @AnnotationType.setter
    def AnnotationType(self, AnnotationType):
        self._AnnotationType = AnnotationType

    @property
    def AnnotationTypeName(self):
        """标注场景名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationTypeName

    @AnnotationTypeName.setter
    def AnnotationTypeName(self, AnnotationTypeName):
        self._AnnotationTypeName = AnnotationTypeName


    def _deserialize(self, params):
        self._AnnotationType = params.get("AnnotationType")
        self._AnnotationTypeName = params.get("AnnotationTypeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrPred(AbstractModel):
    """Asr预测结果

    """

    def __init__(self):
        r"""
        :param _AutoMLEvaluateTaskId: 自动学习评测id
        :type AutoMLEvaluateTaskId: str
        :param _Pred: 预测结果
        :type Pred: str
        """
        self._AutoMLEvaluateTaskId = None
        self._Pred = None

    @property
    def AutoMLEvaluateTaskId(self):
        """自动学习评测id
        :rtype: str
        """
        return self._AutoMLEvaluateTaskId

    @AutoMLEvaluateTaskId.setter
    def AutoMLEvaluateTaskId(self, AutoMLEvaluateTaskId):
        self._AutoMLEvaluateTaskId = AutoMLEvaluateTaskId

    @property
    def Pred(self):
        """预测结果
        :rtype: str
        """
        return self._Pred

    @Pred.setter
    def Pred(self, Pred):
        self._Pred = Pred


    def _deserialize(self, params):
        self._AutoMLEvaluateTaskId = params.get("AutoMLEvaluateTaskId")
        self._Pred = params.get("Pred")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsyncTask(AbstractModel):
    """包含异步任务的相关信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务的唯一标识符
        :type TaskId: str
        :param _TaskType: 异步任务类型
        :type TaskType: str
        :param _TaskStatus: 异步任务状态
        :type TaskStatus: str
        :param _TaskProgress: 任务进度（百分比）
        :type TaskProgress: int
        :param _FailureReason: 任务失败原因（如果有）
        :type FailureReason: str
        :param _TaskResult: 任务结果
        :type TaskResult: str
        :param _CreateTime: 任务创建时间（Unix时间戳）
        :type CreateTime: int
        :param _UpdateTime: 任务最后更新时间（Unix时间戳）
        :type UpdateTime: int
        """
        self._TaskId = None
        self._TaskType = None
        self._TaskStatus = None
        self._TaskProgress = None
        self._FailureReason = None
        self._TaskResult = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def TaskId(self):
        """异步任务的唯一标识符
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        """异步任务类型
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskStatus(self):
        """异步任务状态
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def TaskProgress(self):
        """任务进度（百分比）
        :rtype: int
        """
        return self._TaskProgress

    @TaskProgress.setter
    def TaskProgress(self, TaskProgress):
        self._TaskProgress = TaskProgress

    @property
    def FailureReason(self):
        """任务失败原因（如果有）
        :rtype: str
        """
        return self._FailureReason

    @FailureReason.setter
    def FailureReason(self, FailureReason):
        self._FailureReason = FailureReason

    @property
    def TaskResult(self):
        """任务结果
        :rtype: str
        """
        return self._TaskResult

    @TaskResult.setter
    def TaskResult(self, TaskResult):
        self._TaskResult = TaskResult

    @property
    def CreateTime(self):
        """任务创建时间（Unix时间戳）
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """任务最后更新时间（Unix时间戳）
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        self._TaskStatus = params.get("TaskStatus")
        self._TaskProgress = params.get("TaskProgress")
        self._FailureReason = params.get("FailureReason")
        self._TaskResult = params.get("TaskResult")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachClusterResourceInstanceDataDiskRequest(AbstractModel):
    """AttachClusterResourceInstanceDataDisk请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 节点的资源组id
        :type ResourceGroupId: str
        :param _ResourceInstanceId: 节点id
        :type ResourceInstanceId: str
        """
        self._ResourceGroupId = None
        self._ResourceInstanceId = None

    @property
    def ResourceGroupId(self):
        """节点的资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceInstanceId(self):
        """节点id
        :rtype: str
        """
        return self._ResourceInstanceId

    @ResourceInstanceId.setter
    def ResourceInstanceId(self, ResourceInstanceId):
        self._ResourceInstanceId = ResourceInstanceId


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ResourceInstanceId = params.get("ResourceInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachClusterResourceInstanceDataDiskResponse(AbstractModel):
    """AttachClusterResourceInstanceDataDisk返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Attribute(AbstractModel):
    """镜像属性

    """

    def __init__(self):
        r"""
        :param _Type: 为‘List’时属性值取Values 否则取Value
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Key: 属性key
注意：此字段可能返回 null，表示取不到有效值。
        :type Key: str
        :param _Value: 属性值
注意：此字段可能返回 null，表示取不到有效值。
        :type Value: str
        :param _Values: 属性值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Values: list of str
        """
        self._Type = None
        self._Key = None
        self._Value = None
        self._Values = None

    @property
    def Type(self):
        """为‘List’时属性值取Values 否则取Value
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Key(self):
        """属性key
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        """属性值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Values(self):
        """属性值列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoMLDataConfig(AbstractModel):
    """训练或测试数据配置信息

    """

    def __init__(self):
        r"""
        :param _DataSourceType: DATASET、COS、CFS、HDFS、WEDATA_HDFS
        :type DataSourceType: str
        :param _DataSetSource: 来自数据集的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSetSource: :class:`tencentcloud.tione.v20211111.models.DataSetConfig`
        :param _COSSource: 来自cos的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type COSSource: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        self._DataSourceType = None
        self._DataSetSource = None
        self._COSSource = None

    @property
    def DataSourceType(self):
        """DATASET、COS、CFS、HDFS、WEDATA_HDFS
        :rtype: str
        """
        return self._DataSourceType

    @DataSourceType.setter
    def DataSourceType(self, DataSourceType):
        self._DataSourceType = DataSourceType

    @property
    def DataSetSource(self):
        """来自数据集的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.DataSetConfig`
        """
        return self._DataSetSource

    @DataSetSource.setter
    def DataSetSource(self, DataSetSource):
        self._DataSetSource = DataSetSource

    @property
    def COSSource(self):
        """来自cos的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._COSSource

    @COSSource.setter
    def COSSource(self, COSSource):
        self._COSSource = COSSource


    def _deserialize(self, params):
        self._DataSourceType = params.get("DataSourceType")
        if params.get("DataSetSource") is not None:
            self._DataSetSource = DataSetConfig()
            self._DataSetSource._deserialize(params.get("DataSetSource"))
        if params.get("COSSource") is not None:
            self._COSSource = CosPathInfo()
            self._COSSource._deserialize(params.get("COSSource"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AvailableNodeStatistic(AbstractModel):
    """可用节点数统计信息

    """

    def __init__(self):
        r"""
        :param _AvailableNodeCount: 可用的节点个数
        :type AvailableNodeCount: int
        :param _ResourceGroupCount: 满足上述AvailableNodeCount条件的资源组个数
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupCount: int
        :param _ResourceGroupIds: 资源组ID列表
        :type ResourceGroupIds: list of str
        """
        self._AvailableNodeCount = None
        self._ResourceGroupCount = None
        self._ResourceGroupIds = None

    @property
    def AvailableNodeCount(self):
        """可用的节点个数
        :rtype: int
        """
        return self._AvailableNodeCount

    @AvailableNodeCount.setter
    def AvailableNodeCount(self, AvailableNodeCount):
        self._AvailableNodeCount = AvailableNodeCount

    @property
    def ResourceGroupCount(self):
        """满足上述AvailableNodeCount条件的资源组个数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ResourceGroupCount

    @ResourceGroupCount.setter
    def ResourceGroupCount(self, ResourceGroupCount):
        self._ResourceGroupCount = ResourceGroupCount

    @property
    def ResourceGroupIds(self):
        """资源组ID列表
        :rtype: list of str
        """
        return self._ResourceGroupIds

    @ResourceGroupIds.setter
    def ResourceGroupIds(self, ResourceGroupIds):
        self._ResourceGroupIds = ResourceGroupIds


    def _deserialize(self, params):
        self._AvailableNodeCount = params.get("AvailableNodeCount")
        self._ResourceGroupCount = params.get("ResourceGroupCount")
        self._ResourceGroupIds = params.get("ResourceGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BadcaseImageInfo(AbstractModel):
    """自动学习评测badcase图像信息

    """

    def __init__(self):
        r"""
        :param _ImgThumbnailUrl: badcase图像缩略图地址
        :type ImgThumbnailUrl: str
        :param _ImgOriginalUrl: badcase图像地址
        :type ImgOriginalUrl: str
        :param _GroundTruthLabels: groundTrue标签信息
        :type GroundTruthLabels: list of LabelConfig
        :param _PredictLabels: 推理结果标签信息
        :type PredictLabels: list of PredictConfig
        :param _OcrGroundTruth: OCR GT json 字符串
        :type OcrGroundTruth: str
        :param _OcrPrediction: OCR Pred json 字符串
        :type OcrPrediction: str
        """
        self._ImgThumbnailUrl = None
        self._ImgOriginalUrl = None
        self._GroundTruthLabels = None
        self._PredictLabels = None
        self._OcrGroundTruth = None
        self._OcrPrediction = None

    @property
    def ImgThumbnailUrl(self):
        """badcase图像缩略图地址
        :rtype: str
        """
        return self._ImgThumbnailUrl

    @ImgThumbnailUrl.setter
    def ImgThumbnailUrl(self, ImgThumbnailUrl):
        self._ImgThumbnailUrl = ImgThumbnailUrl

    @property
    def ImgOriginalUrl(self):
        """badcase图像地址
        :rtype: str
        """
        return self._ImgOriginalUrl

    @ImgOriginalUrl.setter
    def ImgOriginalUrl(self, ImgOriginalUrl):
        self._ImgOriginalUrl = ImgOriginalUrl

    @property
    def GroundTruthLabels(self):
        """groundTrue标签信息
        :rtype: list of LabelConfig
        """
        return self._GroundTruthLabels

    @GroundTruthLabels.setter
    def GroundTruthLabels(self, GroundTruthLabels):
        self._GroundTruthLabels = GroundTruthLabels

    @property
    def PredictLabels(self):
        """推理结果标签信息
        :rtype: list of PredictConfig
        """
        return self._PredictLabels

    @PredictLabels.setter
    def PredictLabels(self, PredictLabels):
        self._PredictLabels = PredictLabels

    @property
    def OcrGroundTruth(self):
        """OCR GT json 字符串
        :rtype: str
        """
        return self._OcrGroundTruth

    @OcrGroundTruth.setter
    def OcrGroundTruth(self, OcrGroundTruth):
        self._OcrGroundTruth = OcrGroundTruth

    @property
    def OcrPrediction(self):
        """OCR Pred json 字符串
        :rtype: str
        """
        return self._OcrPrediction

    @OcrPrediction.setter
    def OcrPrediction(self, OcrPrediction):
        self._OcrPrediction = OcrPrediction


    def _deserialize(self, params):
        self._ImgThumbnailUrl = params.get("ImgThumbnailUrl")
        self._ImgOriginalUrl = params.get("ImgOriginalUrl")
        if params.get("GroundTruthLabels") is not None:
            self._GroundTruthLabels = []
            for item in params.get("GroundTruthLabels"):
                obj = LabelConfig()
                obj._deserialize(item)
                self._GroundTruthLabels.append(obj)
        if params.get("PredictLabels") is not None:
            self._PredictLabels = []
            for item in params.get("PredictLabels"):
                obj = PredictConfig()
                obj._deserialize(item)
                self._PredictLabels.append(obj)
        self._OcrGroundTruth = params.get("OcrGroundTruth")
        self._OcrPrediction = params.get("OcrPrediction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModelAccTask(AbstractModel):
    """批量模型加速任务

    """

    def __init__(self):
        r"""
        :param _ModelId: 模型ID
        :type ModelId: str
        :param _ModelVersion: 模型版本
        :type ModelVersion: str
        :param _ModelSource: 模型来源(JOB/COS)
        :type ModelSource: str
        :param _ModelFormat: 模型格式(TORCH_SCRIPT/DETECTRON2/SAVED_MODEL/FROZEN_GRAPH/MMDETECTION/ONNX/HUGGING_FACE)
        :type ModelFormat: str
        :param _TensorInfos: 模型Tensor信息
        :type TensorInfos: list of str
        :param _AccEngineVersion: 加速引擎版本
        :type AccEngineVersion: str
        :param _ModelInputPath: 模型输入cos路径
        :type ModelInputPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _ModelName: 模型名称
        :type ModelName: str
        :param _ModelSignature: SavedModel保存时配置的签名
        :type ModelSignature: str
        :param _FrameworkVersion: 加速引擎对应的框架版本
        :type FrameworkVersion: str
        """
        self._ModelId = None
        self._ModelVersion = None
        self._ModelSource = None
        self._ModelFormat = None
        self._TensorInfos = None
        self._AccEngineVersion = None
        self._ModelInputPath = None
        self._ModelName = None
        self._ModelSignature = None
        self._FrameworkVersion = None

    @property
    def ModelId(self):
        """模型ID
        :rtype: str
        """
        return self._ModelId

    @ModelId.setter
    def ModelId(self, ModelId):
        self._ModelId = ModelId

    @property
    def ModelVersion(self):
        """模型版本
        :rtype: str
        """
        return self._ModelVersion

    @ModelVersion.setter
    def ModelVersion(self, ModelVersion):
        self._ModelVersion = ModelVersion

    @property
    def ModelSource(self):
        """模型来源(JOB/COS)
        :rtype: str
        """
        return self._ModelSource

    @ModelSource.setter
    def ModelSource(self, ModelSource):
        self._ModelSource = ModelSource

    @property
    def ModelFormat(self):
        """模型格式(TORCH_SCRIPT/DETECTRON2/SAVED_MODEL/FROZEN_GRAPH/MMDETECTION/ONNX/HUGGING_FACE)
        :rtype: str
        """
        return self._ModelFormat

    @ModelFormat.setter
    def ModelFormat(self, ModelFormat):
        self._ModelFormat = ModelFormat

    @property
    def TensorInfos(self):
        """模型Tensor信息
        :rtype: list of str
        """
        return self._TensorInfos

    @TensorInfos.setter
    def TensorInfos(self, TensorInfos):
        self._TensorInfos = TensorInfos

    @property
    def AccEngineVersion(self):
        """加速引擎版本
        :rtype: str
        """
        return self._AccEngineVersion

    @AccEngineVersion.setter
    def AccEngineVersion(self, AccEngineVersion):
        self._AccEngineVersion = AccEngineVersion

    @property
    def ModelInputPath(self):
        """模型输入cos路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._ModelInputPath

    @ModelInputPath.setter
    def ModelInputPath(self, ModelInputPath):
        self._ModelInputPath = ModelInputPath

    @property
    def ModelName(self):
        """模型名称
        :rtype: str
        """
        return self._ModelName

    @ModelName.setter
    def ModelName(self, ModelName):
        self._ModelName = ModelName

    @property
    def ModelSignature(self):
        """SavedModel保存时配置的签名
        :rtype: str
        """
        return self._ModelSignature

    @ModelSignature.setter
    def ModelSignature(self, ModelSignature):
        self._ModelSignature = ModelSignature

    @property
    def FrameworkVersion(self):
        """加速引擎对应的框架版本
        :rtype: str
        """
        return self._FrameworkVersion

    @FrameworkVersion.setter
    def FrameworkVersion(self, FrameworkVersion):
        self._FrameworkVersion = FrameworkVersion


    def _deserialize(self, params):
        self._ModelId = params.get("ModelId")
        self._ModelVersion = params.get("ModelVersion")
        self._ModelSource = params.get("ModelSource")
        self._ModelFormat = params.get("ModelFormat")
        self._TensorInfos = params.get("TensorInfos")
        self._AccEngineVersion = params.get("AccEngineVersion")
        if params.get("ModelInputPath") is not None:
            self._ModelInputPath = CosPathInfo()
            self._ModelInputPath._deserialize(params.get("ModelInputPath"))
        self._ModelName = params.get("ModelName")
        self._ModelSignature = params.get("ModelSignature")
        self._FrameworkVersion = params.get("FrameworkVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchTaskDetail(AbstractModel):
    """批量预测任务详情

    """

    def __init__(self):
        r"""
        :param _BatchTaskId: 批量预测任务ID
        :type BatchTaskId: str
        :param _BatchTaskName: 批量预测任务名称
        :type BatchTaskName: str
        :param _Uin: 主账号uin
        :type Uin: str
        :param _SubUin: 子账号uin
        :type SubUin: str
        :param _Region: 地域
        :type Region: str
        :param _ChargeType: 计费模式
        :type ChargeType: str
        :param _ResourceGroupId: 包年包月资源组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupId: str
        :param _ResourceGroupName: 包年包月资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupName: str
        :param _ResourceConfigInfo: 资源配置
        :type ResourceConfigInfo: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        :param _Tags: 标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tags: list of Tag
        :param _ModelInfo: 服务对应的模型信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelInfo: :class:`tencentcloud.tione.v20211111.models.ModelInfo`
        :param _ImageInfo: 自定义镜像信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageInfo: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        :param _CodePackagePath: 代码包
注意：此字段可能返回 null，表示取不到有效值。
        :type CodePackagePath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _StartCmd: 启动命令
注意：此字段可能返回 null，表示取不到有效值。
        :type StartCmd: str
        :param _DataConfigs: 输入数据配置
注意：此字段可能返回 null，表示取不到有效值。
        :type DataConfigs: list of DataConfig
        :param _Outputs: 输出数据配置
        :type Outputs: list of DataConfig
        :param _LogEnable: 是否上报日志
        :type LogEnable: bool
        :param _LogConfig: 日志配置
注意：此字段可能返回 null，表示取不到有效值。
        :type LogConfig: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        :param _VpcId: vpc id
注意：此字段可能返回 null，表示取不到有效值。
        :type VpcId: str
        :param _SubnetId: 子网id
注意：此字段可能返回 null，表示取不到有效值。
        :type SubnetId: str
        :param _Status: 任务状态
        :type Status: str
        :param _RuntimeInSeconds: 运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :type RuntimeInSeconds: int
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _StartTime: 任务开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 任务结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _ChargeStatus: 计费状态，取值范围:
BILLING: 计费中
NOT_BILLING: 未计费
WHITELIST_USING: 白名单使用中
WHITELIST_STOP: 白名单到期
ARREARS_STOP: 欠费停止
        :type ChargeStatus: str
        :param _LatestInstanceId: 最近一次实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type LatestInstanceId: str
        :param _Remark: 备注
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        :param _FailureReason: 失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type FailureReason: str
        :param _BillingInfo: 计费金额信息，eg：2.00元/小时 (for 按量计费)
注意：此字段可能返回 null，表示取不到有效值。
        :type BillingInfo: str
        :param _PodList: 运行中的Pod的名字
注意：此字段可能返回 null，表示取不到有效值。
        :type PodList: list of str
        :param _ModelInferenceCodeInfo: 模型推理代码信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelInferenceCodeInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _ResourceGroupSWType: 资源组类型
        :type ResourceGroupSWType: str
        """
        self._BatchTaskId = None
        self._BatchTaskName = None
        self._Uin = None
        self._SubUin = None
        self._Region = None
        self._ChargeType = None
        self._ResourceGroupId = None
        self._ResourceGroupName = None
        self._ResourceConfigInfo = None
        self._Tags = None
        self._ModelInfo = None
        self._ImageInfo = None
        self._CodePackagePath = None
        self._StartCmd = None
        self._DataConfigs = None
        self._Outputs = None
        self._LogEnable = None
        self._LogConfig = None
        self._VpcId = None
        self._SubnetId = None
        self._Status = None
        self._RuntimeInSeconds = None
        self._CreateTime = None
        self._UpdateTime = None
        self._StartTime = None
        self._EndTime = None
        self._ChargeStatus = None
        self._LatestInstanceId = None
        self._Remark = None
        self._FailureReason = None
        self._BillingInfo = None
        self._PodList = None
        self._ModelInferenceCodeInfo = None
        self._ResourceGroupSWType = None

    @property
    def BatchTaskId(self):
        """批量预测任务ID
        :rtype: str
        """
        return self._BatchTaskId

    @BatchTaskId.setter
    def BatchTaskId(self, BatchTaskId):
        self._BatchTaskId = BatchTaskId

    @property
    def BatchTaskName(self):
        """批量预测任务名称
        :rtype: str
        """
        return self._BatchTaskName

    @BatchTaskName.setter
    def BatchTaskName(self, BatchTaskName):
        self._BatchTaskName = BatchTaskName

    @property
    def Uin(self):
        """主账号uin
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubUin(self):
        """子账号uin
        :rtype: str
        """
        return self._SubUin

    @SubUin.setter
    def SubUin(self, SubUin):
        self._SubUin = SubUin

    @property
    def Region(self):
        """地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def ChargeType(self):
        """计费模式
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def ResourceGroupId(self):
        """包年包月资源组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceGroupName(self):
        """包年包月资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def ResourceConfigInfo(self):
        """资源配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        """
        return self._ResourceConfigInfo

    @ResourceConfigInfo.setter
    def ResourceConfigInfo(self, ResourceConfigInfo):
        self._ResourceConfigInfo = ResourceConfigInfo

    @property
    def Tags(self):
        """标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ModelInfo(self):
        """服务对应的模型信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ModelInfo`
        """
        return self._ModelInfo

    @ModelInfo.setter
    def ModelInfo(self, ModelInfo):
        self._ModelInfo = ModelInfo

    @property
    def ImageInfo(self):
        """自定义镜像信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        """
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def CodePackagePath(self):
        """代码包
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._CodePackagePath

    @CodePackagePath.setter
    def CodePackagePath(self, CodePackagePath):
        self._CodePackagePath = CodePackagePath

    @property
    def StartCmd(self):
        """启动命令
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StartCmd

    @StartCmd.setter
    def StartCmd(self, StartCmd):
        self._StartCmd = StartCmd

    @property
    def DataConfigs(self):
        """输入数据配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataConfig
        """
        return self._DataConfigs

    @DataConfigs.setter
    def DataConfigs(self, DataConfigs):
        self._DataConfigs = DataConfigs

    @property
    def Outputs(self):
        """输出数据配置
        :rtype: list of DataConfig
        """
        return self._Outputs

    @Outputs.setter
    def Outputs(self, Outputs):
        self._Outputs = Outputs

    @property
    def LogEnable(self):
        """是否上报日志
        :rtype: bool
        """
        return self._LogEnable

    @LogEnable.setter
    def LogEnable(self, LogEnable):
        self._LogEnable = LogEnable

    @property
    def LogConfig(self):
        """日志配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def VpcId(self):
        """vpc id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Status(self):
        """任务状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RuntimeInSeconds(self):
        """运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RuntimeInSeconds

    @RuntimeInSeconds.setter
    def RuntimeInSeconds(self, RuntimeInSeconds):
        self._RuntimeInSeconds = RuntimeInSeconds

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def StartTime(self):
        """任务开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """任务结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ChargeStatus(self):
        """计费状态，取值范围:
BILLING: 计费中
NOT_BILLING: 未计费
WHITELIST_USING: 白名单使用中
WHITELIST_STOP: 白名单到期
ARREARS_STOP: 欠费停止
        :rtype: str
        """
        return self._ChargeStatus

    @ChargeStatus.setter
    def ChargeStatus(self, ChargeStatus):
        self._ChargeStatus = ChargeStatus

    @property
    def LatestInstanceId(self):
        """最近一次实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LatestInstanceId

    @LatestInstanceId.setter
    def LatestInstanceId(self, LatestInstanceId):
        self._LatestInstanceId = LatestInstanceId

    @property
    def Remark(self):
        """备注
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def FailureReason(self):
        """失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FailureReason

    @FailureReason.setter
    def FailureReason(self, FailureReason):
        self._FailureReason = FailureReason

    @property
    def BillingInfo(self):
        """计费金额信息，eg：2.00元/小时 (for 按量计费)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BillingInfo

    @BillingInfo.setter
    def BillingInfo(self, BillingInfo):
        self._BillingInfo = BillingInfo

    @property
    def PodList(self):
        """运行中的Pod的名字
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._PodList

    @PodList.setter
    def PodList(self, PodList):
        self._PodList = PodList

    @property
    def ModelInferenceCodeInfo(self):
        """模型推理代码信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._ModelInferenceCodeInfo

    @ModelInferenceCodeInfo.setter
    def ModelInferenceCodeInfo(self, ModelInferenceCodeInfo):
        self._ModelInferenceCodeInfo = ModelInferenceCodeInfo

    @property
    def ResourceGroupSWType(self):
        """资源组类型
        :rtype: str
        """
        return self._ResourceGroupSWType

    @ResourceGroupSWType.setter
    def ResourceGroupSWType(self, ResourceGroupSWType):
        self._ResourceGroupSWType = ResourceGroupSWType


    def _deserialize(self, params):
        self._BatchTaskId = params.get("BatchTaskId")
        self._BatchTaskName = params.get("BatchTaskName")
        self._Uin = params.get("Uin")
        self._SubUin = params.get("SubUin")
        self._Region = params.get("Region")
        self._ChargeType = params.get("ChargeType")
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ResourceGroupName = params.get("ResourceGroupName")
        if params.get("ResourceConfigInfo") is not None:
            self._ResourceConfigInfo = ResourceConfigInfo()
            self._ResourceConfigInfo._deserialize(params.get("ResourceConfigInfo"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("ModelInfo") is not None:
            self._ModelInfo = ModelInfo()
            self._ModelInfo._deserialize(params.get("ModelInfo"))
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        if params.get("CodePackagePath") is not None:
            self._CodePackagePath = CosPathInfo()
            self._CodePackagePath._deserialize(params.get("CodePackagePath"))
        self._StartCmd = params.get("StartCmd")
        if params.get("DataConfigs") is not None:
            self._DataConfigs = []
            for item in params.get("DataConfigs"):
                obj = DataConfig()
                obj._deserialize(item)
                self._DataConfigs.append(obj)
        if params.get("Outputs") is not None:
            self._Outputs = []
            for item in params.get("Outputs"):
                obj = DataConfig()
                obj._deserialize(item)
                self._Outputs.append(obj)
        self._LogEnable = params.get("LogEnable")
        if params.get("LogConfig") is not None:
            self._LogConfig = LogConfig()
            self._LogConfig._deserialize(params.get("LogConfig"))
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Status = params.get("Status")
        self._RuntimeInSeconds = params.get("RuntimeInSeconds")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ChargeStatus = params.get("ChargeStatus")
        self._LatestInstanceId = params.get("LatestInstanceId")
        self._Remark = params.get("Remark")
        self._FailureReason = params.get("FailureReason")
        self._BillingInfo = params.get("BillingInfo")
        self._PodList = params.get("PodList")
        if params.get("ModelInferenceCodeInfo") is not None:
            self._ModelInferenceCodeInfo = CosPathInfo()
            self._ModelInferenceCodeInfo._deserialize(params.get("ModelInferenceCodeInfo"))
        self._ResourceGroupSWType = params.get("ResourceGroupSWType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchTaskInstance(AbstractModel):
    """批处理任务实例

    """

    def __init__(self):
        r"""
        :param _BatchTaskInstanceId: 任务实例id
        :type BatchTaskInstanceId: str
        :param _StartTime: 开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _Status: 任务状态
        :type Status: str
        :param _RuntimeInSeconds: 运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :type RuntimeInSeconds: int
        """
        self._BatchTaskInstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._Status = None
        self._RuntimeInSeconds = None

    @property
    def BatchTaskInstanceId(self):
        """任务实例id
        :rtype: str
        """
        return self._BatchTaskInstanceId

    @BatchTaskInstanceId.setter
    def BatchTaskInstanceId(self, BatchTaskInstanceId):
        self._BatchTaskInstanceId = BatchTaskInstanceId

    @property
    def StartTime(self):
        """开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Status(self):
        """任务状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RuntimeInSeconds(self):
        """运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RuntimeInSeconds

    @RuntimeInSeconds.setter
    def RuntimeInSeconds(self, RuntimeInSeconds):
        self._RuntimeInSeconds = RuntimeInSeconds


    def _deserialize(self, params):
        self._BatchTaskInstanceId = params.get("BatchTaskInstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Status = params.get("Status")
        self._RuntimeInSeconds = params.get("RuntimeInSeconds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchTaskSetItem(AbstractModel):
    """出参类型

    """

    def __init__(self):
        r"""
        :param _BatchTaskId: 批量预测任务ID
        :type BatchTaskId: str
        :param _BatchTaskName: 批量预测任务名称
        :type BatchTaskName: str
        :param _ModelInfo: 模型信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelInfo: :class:`tencentcloud.tione.v20211111.models.ModelInfo`
        :param _ImageInfo: 镜像信息
        :type ImageInfo: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        :param _ChargeType: 计费模式
        :type ChargeType: str
        :param _ChargeStatus: 计费状态，取值范围:
BILLING: 计费中
NOT_BILLING: 未计费
WHITELIST_USING: 白名单使用中
WHITELIST_STOP: 白名单到期
ARREARS_STOP: 欠费停止
        :type ChargeStatus: str
        :param _ResourceGroupId: 包年包月资源组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupId: str
        :param _ResourceConfigInfo: 资源配置
        :type ResourceConfigInfo: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        :param _Tags: 标签配置
注意：此字段可能返回 null，表示取不到有效值。
        :type Tags: list of Tag
        :param _Status: 任务状态, 取值范围:
INIT, STARTING, RUNNING, FAILED, STOPPING, STOPPED, SUCCEED
        :type Status: str
        :param _RuntimeInSeconds: 运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :type RuntimeInSeconds: int
        :param _CreateTime: 任务创建时间
        :type CreateTime: str
        :param _StartTime: 任务开始运行时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 任务结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _UpdateTime: 任务更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _Outputs: 输出
        :type Outputs: list of DataConfig
        :param _ResourceGroupName: 包年包月资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupName: str
        :param _FailureReason: 失败原因
        :type FailureReason: str
        :param _BillingInfo: 按量计费信息
        :type BillingInfo: str
        :param _ResourceGroupSWType: 资源组类型
        :type ResourceGroupSWType: str
        """
        self._BatchTaskId = None
        self._BatchTaskName = None
        self._ModelInfo = None
        self._ImageInfo = None
        self._ChargeType = None
        self._ChargeStatus = None
        self._ResourceGroupId = None
        self._ResourceConfigInfo = None
        self._Tags = None
        self._Status = None
        self._RuntimeInSeconds = None
        self._CreateTime = None
        self._StartTime = None
        self._EndTime = None
        self._UpdateTime = None
        self._Outputs = None
        self._ResourceGroupName = None
        self._FailureReason = None
        self._BillingInfo = None
        self._ResourceGroupSWType = None

    @property
    def BatchTaskId(self):
        """批量预测任务ID
        :rtype: str
        """
        return self._BatchTaskId

    @BatchTaskId.setter
    def BatchTaskId(self, BatchTaskId):
        self._BatchTaskId = BatchTaskId

    @property
    def BatchTaskName(self):
        """批量预测任务名称
        :rtype: str
        """
        return self._BatchTaskName

    @BatchTaskName.setter
    def BatchTaskName(self, BatchTaskName):
        self._BatchTaskName = BatchTaskName

    @property
    def ModelInfo(self):
        """模型信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ModelInfo`
        """
        return self._ModelInfo

    @ModelInfo.setter
    def ModelInfo(self, ModelInfo):
        self._ModelInfo = ModelInfo

    @property
    def ImageInfo(self):
        """镜像信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        """
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def ChargeType(self):
        """计费模式
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def ChargeStatus(self):
        """计费状态，取值范围:
BILLING: 计费中
NOT_BILLING: 未计费
WHITELIST_USING: 白名单使用中
WHITELIST_STOP: 白名单到期
ARREARS_STOP: 欠费停止
        :rtype: str
        """
        return self._ChargeStatus

    @ChargeStatus.setter
    def ChargeStatus(self, ChargeStatus):
        self._ChargeStatus = ChargeStatus

    @property
    def ResourceGroupId(self):
        """包年包月资源组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceConfigInfo(self):
        """资源配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        """
        return self._ResourceConfigInfo

    @ResourceConfigInfo.setter
    def ResourceConfigInfo(self, ResourceConfigInfo):
        self._ResourceConfigInfo = ResourceConfigInfo

    @property
    def Tags(self):
        """标签配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Status(self):
        """任务状态, 取值范围:
INIT, STARTING, RUNNING, FAILED, STOPPING, STOPPED, SUCCEED
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RuntimeInSeconds(self):
        """运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RuntimeInSeconds

    @RuntimeInSeconds.setter
    def RuntimeInSeconds(self, RuntimeInSeconds):
        self._RuntimeInSeconds = RuntimeInSeconds

    @property
    def CreateTime(self):
        """任务创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def StartTime(self):
        """任务开始运行时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """任务结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def UpdateTime(self):
        """任务更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Outputs(self):
        """输出
        :rtype: list of DataConfig
        """
        return self._Outputs

    @Outputs.setter
    def Outputs(self, Outputs):
        self._Outputs = Outputs

    @property
    def ResourceGroupName(self):
        """包年包月资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def FailureReason(self):
        """失败原因
        :rtype: str
        """
        return self._FailureReason

    @FailureReason.setter
    def FailureReason(self, FailureReason):
        self._FailureReason = FailureReason

    @property
    def BillingInfo(self):
        """按量计费信息
        :rtype: str
        """
        return self._BillingInfo

    @BillingInfo.setter
    def BillingInfo(self, BillingInfo):
        self._BillingInfo = BillingInfo

    @property
    def ResourceGroupSWType(self):
        """资源组类型
        :rtype: str
        """
        return self._ResourceGroupSWType

    @ResourceGroupSWType.setter
    def ResourceGroupSWType(self, ResourceGroupSWType):
        self._ResourceGroupSWType = ResourceGroupSWType


    def _deserialize(self, params):
        self._BatchTaskId = params.get("BatchTaskId")
        self._BatchTaskName = params.get("BatchTaskName")
        if params.get("ModelInfo") is not None:
            self._ModelInfo = ModelInfo()
            self._ModelInfo._deserialize(params.get("ModelInfo"))
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._ChargeType = params.get("ChargeType")
        self._ChargeStatus = params.get("ChargeStatus")
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("ResourceConfigInfo") is not None:
            self._ResourceConfigInfo = ResourceConfigInfo()
            self._ResourceConfigInfo._deserialize(params.get("ResourceConfigInfo"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Status = params.get("Status")
        self._RuntimeInSeconds = params.get("RuntimeInSeconds")
        self._CreateTime = params.get("CreateTime")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("Outputs") is not None:
            self._Outputs = []
            for item in params.get("Outputs"):
                obj = DataConfig()
                obj._deserialize(item)
                self._Outputs.append(obj)
        self._ResourceGroupName = params.get("ResourceGroupName")
        self._FailureReason = params.get("FailureReason")
        self._BillingInfo = params.get("BillingInfo")
        self._ResourceGroupSWType = params.get("ResourceGroupSWType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BillingUint(AbstractModel):
    """计费的单元

    """

    def __init__(self):
        r"""
        :param _Spec: 计费规格
注意：此字段可能返回 null，表示取不到有效值。
        :type Spec: str
        :param _Count: 该规格的数量
注意：此字段可能返回 null，表示取不到有效值。
        :type Count: int
        """
        self._Spec = None
        self._Count = None

    @property
    def Spec(self):
        """计费规格
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Spec

    @Spec.setter
    def Spec(self, Spec):
        self._Spec = Spec

    @property
    def Count(self):
        """该规格的数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._Spec = params.get("Spec")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BuiltInEvaluationDataset(AbstractModel):
    """内置的评测数据集

    """

    def __init__(self):
        r"""
        :param _Id: 内置评测集 ID
        :type Id: str
        :param _Name: 内置评测集名称
        :type Name: str
        :param _Description: 内置评测集简介
        :type Description: str
        """
        self._Id = None
        self._Name = None
        self._Description = None

    @property
    def Id(self):
        """内置评测集 ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        """内置评测集名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """内置评测集简介
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CBSConfig(AbstractModel):
    """CBS存储配置

    """

    def __init__(self):
        r"""
        :param _VolumeSizeInGB: 存储大小
注意：此字段可能返回 null，表示取不到有效值。
        :type VolumeSizeInGB: int
        """
        self._VolumeSizeInGB = None

    @property
    def VolumeSizeInGB(self):
        """存储大小
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._VolumeSizeInGB

    @VolumeSizeInGB.setter
    def VolumeSizeInGB(self, VolumeSizeInGB):
        self._VolumeSizeInGB = VolumeSizeInGB


    def _deserialize(self, params):
        self._VolumeSizeInGB = params.get("VolumeSizeInGB")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CFSConfig(AbstractModel):
    """CFS存储的配置

    """

    def __init__(self):
        r"""
        :param _Id: cfs的实例的ID
        :type Id: str
        :param _Path: 存储的路径
        :type Path: str
        :param _MountType: cfs的挂载类型，可选值为：STORAGE、SOURCE 分别表示存储拓展模式和数据源模式，默认为 STORAGE
注意：此字段可能返回 null，表示取不到有效值。
        :type MountType: str
        :param _Ip: cfs的ip
注意：此字段可能返回 null，表示取不到有效值。
        :type Ip: str
        :param _VpcId: cfs的vpcid
        :type VpcId: str
        :param _SubnetId: cfs的子网id
        :type SubnetId: str
        :param _Protocol: 协议 1: NFS, 2: TURBO
注意：此字段可能返回 null，表示取不到有效值。
        :type Protocol: str
        :param _MountTargetId: CFS的MountTargetId
注意：此字段可能返回 null，表示取不到有效值。
        :type MountTargetId: str
        :param _IsPlatform: 是否为平台cfs
注意：此字段可能返回 null，表示取不到有效值。
        :type IsPlatform: str
        :param _Status: 状态: MOUNTING 挂载中; MOUNTED 已挂载; UNMOUNTED 未挂载
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _VpcCidr: vpc所在的网段
        :type VpcCidr: str
        """
        self._Id = None
        self._Path = None
        self._MountType = None
        self._Ip = None
        self._VpcId = None
        self._SubnetId = None
        self._Protocol = None
        self._MountTargetId = None
        self._IsPlatform = None
        self._Status = None
        self._VpcCidr = None

    @property
    def Id(self):
        """cfs的实例的ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Path(self):
        """存储的路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MountType(self):
        """cfs的挂载类型，可选值为：STORAGE、SOURCE 分别表示存储拓展模式和数据源模式，默认为 STORAGE
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MountType

    @MountType.setter
    def MountType(self, MountType):
        self._MountType = MountType

    @property
    def Ip(self):
        """cfs的ip
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def VpcId(self):
        """cfs的vpcid
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """cfs的子网id
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Protocol(self):
        """协议 1: NFS, 2: TURBO
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def MountTargetId(self):
        """CFS的MountTargetId
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MountTargetId

    @MountTargetId.setter
    def MountTargetId(self, MountTargetId):
        self._MountTargetId = MountTargetId

    @property
    def IsPlatform(self):
        """是否为平台cfs
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._IsPlatform

    @IsPlatform.setter
    def IsPlatform(self, IsPlatform):
        self._IsPlatform = IsPlatform

    @property
    def Status(self):
        """状态: MOUNTING 挂载中; MOUNTED 已挂载; UNMOUNTED 未挂载
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def VpcCidr(self):
        """vpc所在的网段
        :rtype: str
        """
        return self._VpcCidr

    @VpcCidr.setter
    def VpcCidr(self, VpcCidr):
        self._VpcCidr = VpcCidr


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Path = params.get("Path")
        self._MountType = params.get("MountType")
        self._Ip = params.get("Ip")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Protocol = params.get("Protocol")
        self._MountTargetId = params.get("MountTargetId")
        self._IsPlatform = params.get("IsPlatform")
        self._Status = params.get("Status")
        self._VpcCidr = params.get("VpcCidr")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CFSStorageInfo(AbstractModel):
    """CFS 存储信息

    """

    def __init__(self):
        r"""
        :param _Id: 文件系统 ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _Path: 存储路径
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        """
        self._Id = None
        self._Path = None

    @property
    def Id(self):
        """文件系统 ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Path(self):
        """存储路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Path = params.get("Path")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CFSTurbo(AbstractModel):
    """配置CFSTurbo参数

    """

    def __init__(self):
        r"""
        :param _Id: CFSTurbo实例id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _Path: CFSTurbo路径
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        """
        self._Id = None
        self._Path = None

    @property
    def Id(self):
        """CFSTurbo实例id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Path(self):
        """CFSTurbo路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Path = params.get("Path")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CFSTurboStorageInfo(AbstractModel):
    """CFS 存储信息

    """

    def __init__(self):
        r"""
        :param _Id: 文件系统 ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _Path: 存储路径
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        """
        self._Id = None
        self._Path = None

    @property
    def Id(self):
        """文件系统 ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Path(self):
        """存储路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Path = params.get("Path")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CVMInstanceWithSpec(AbstractModel):
    """CVM实例信息与TI配置项信息

    """

    def __init__(self):
        r"""
        :param _Id: CVM实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _Name: CVM实例名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Spec: 配置项
注意：此字段可能返回 null，表示取不到有效值。
        :type Spec: :class:`tencentcloud.tione.v20211111.models.Spec`
        :param _Price: 刊例价
注意：此字段可能返回 null，表示取不到有效值。
        :type Price: float
        :param _RejectedReasons: 无法纳管原因
注意：此字段可能返回 null，表示取不到有效值。
        :type RejectedReasons: list of str
        :param _SecurityGroupIds: 相关安全组ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SecurityGroupIds: list of str
        :param _VirtualPrivateCloud: VPC相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :type VirtualPrivateCloud: :class:`tencentcloud.tione.v20211111.models.VPCInfo`
        :param _SystemDisk: 系统盘信息
注意：此字段可能返回 null，表示取不到有效值。
        :type SystemDisk: :class:`tencentcloud.tione.v20211111.models.SystemDisk`
        :param _DataDisks: 数据盘信息
注意：此字段可能返回 null，表示取不到有效值。
        :type DataDisks: list of DataDisk
        :param _TagSet: 节点的标签信息
        :type TagSet: list of Tag
        """
        self._Id = None
        self._Name = None
        self._Spec = None
        self._Price = None
        self._RejectedReasons = None
        self._SecurityGroupIds = None
        self._VirtualPrivateCloud = None
        self._SystemDisk = None
        self._DataDisks = None
        self._TagSet = None

    @property
    def Id(self):
        """CVM实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        """CVM实例名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Spec(self):
        """配置项
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.Spec`
        """
        return self._Spec

    @Spec.setter
    def Spec(self, Spec):
        self._Spec = Spec

    @property
    def Price(self):
        """刊例价
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def RejectedReasons(self):
        """无法纳管原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._RejectedReasons

    @RejectedReasons.setter
    def RejectedReasons(self, RejectedReasons):
        self._RejectedReasons = RejectedReasons

    @property
    def SecurityGroupIds(self):
        """相关安全组ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def VirtualPrivateCloud(self):
        """VPC相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.VPCInfo`
        """
        return self._VirtualPrivateCloud

    @VirtualPrivateCloud.setter
    def VirtualPrivateCloud(self, VirtualPrivateCloud):
        self._VirtualPrivateCloud = VirtualPrivateCloud

    @property
    def SystemDisk(self):
        """系统盘信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.SystemDisk`
        """
        return self._SystemDisk

    @SystemDisk.setter
    def SystemDisk(self, SystemDisk):
        self._SystemDisk = SystemDisk

    @property
    def DataDisks(self):
        """数据盘信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataDisk
        """
        return self._DataDisks

    @DataDisks.setter
    def DataDisks(self, DataDisks):
        self._DataDisks = DataDisks

    @property
    def TagSet(self):
        """节点的标签信息
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        if params.get("Spec") is not None:
            self._Spec = Spec()
            self._Spec._deserialize(params.get("Spec"))
        self._Price = params.get("Price")
        self._RejectedReasons = params.get("RejectedReasons")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("VirtualPrivateCloud") is not None:
            self._VirtualPrivateCloud = VPCInfo()
            self._VirtualPrivateCloud._deserialize(params.get("VirtualPrivateCloud"))
        if params.get("SystemDisk") is not None:
            self._SystemDisk = SystemDisk()
            self._SystemDisk._deserialize(params.get("SystemDisk"))
        if params.get("DataDisks") is not None:
            self._DataDisks = []
            for item in params.get("DataDisks"):
                obj = DataDisk()
                obj._deserialize(item)
                self._DataDisks.append(obj)
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CamTag(AbstractModel):
    """cam详细信息

    """

    def __init__(self):
        r"""
        :param _Key: tag键值
        :type Key: str
        :param _Value: tag值
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        """tag键值
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        """tag值
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChatCompletionRequest(AbstractModel):
    """ChatCompletion请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Model: 对话的目标模型ID。
自行部署的开源大模型聊天：部署的模型服务组ID，形如ms-q7pfr29p。
        :type Model: str
        :param _Messages: 输入对话历史。旧的对话在前，数组中最后一项应该为这次的问题。
        :type Messages: list of Message
        :param _Temperature: 仅当模型为自行部署的开源大模型时生效。采样随机值，默认值为0.7，取值范围[0,2]。较高的值(如0.8)将使输出更加随机，而较低的值(如0.2)将使输出更加确定。建议仅修改此参数或TopP，但不建议两者都修改。
        :type Temperature: float
        :param _TopP: 仅当模型为自行部署的开源大模型时生效。核采样，默认值为1，取值范围[0,1]。指的是预先设置一个概率界限 p，然后将所有可能生成的token，根据概率大小从高到低排列，依次选取。当这些选取的token的累积概率大于或等于 p 值时停止，然后从已经选取的token中进行采样，生成下一个token。例如top_p为0.1时意味着模型只考虑累积概率为10%的token。建议仅修改此参数或Temperature，不建议两者都修改。
        :type TopP: float
        :param _N: 仅当模型为自行部署的开源大模型时生效。生成答案数。默认为1
        :type N: float
        :param _MaxTokens: 仅当模型为自行部署的开源大模型时生效。默认 512，模型可生成内容的最长 token 数量，最大不能超过模型支持的上下文长度。
        :type MaxTokens: int
        :param _Stream: 否流式返回，默认值为 false。
        :type Stream: bool
        """
        self._Model = None
        self._Messages = None
        self._Temperature = None
        self._TopP = None
        self._N = None
        self._MaxTokens = None
        self._Stream = None

    @property
    def Model(self):
        """对话的目标模型ID。
自行部署的开源大模型聊天：部署的模型服务组ID，形如ms-q7pfr29p。
        :rtype: str
        """
        return self._Model

    @Model.setter
    def Model(self, Model):
        self._Model = Model

    @property
    def Messages(self):
        """输入对话历史。旧的对话在前，数组中最后一项应该为这次的问题。
        :rtype: list of Message
        """
        return self._Messages

    @Messages.setter
    def Messages(self, Messages):
        self._Messages = Messages

    @property
    def Temperature(self):
        """仅当模型为自行部署的开源大模型时生效。采样随机值，默认值为0.7，取值范围[0,2]。较高的值(如0.8)将使输出更加随机，而较低的值(如0.2)将使输出更加确定。建议仅修改此参数或TopP，但不建议两者都修改。
        :rtype: float
        """
        return self._Temperature

    @Temperature.setter
    def Temperature(self, Temperature):
        self._Temperature = Temperature

    @property
    def TopP(self):
        """仅当模型为自行部署的开源大模型时生效。核采样，默认值为1，取值范围[0,1]。指的是预先设置一个概率界限 p，然后将所有可能生成的token，根据概率大小从高到低排列，依次选取。当这些选取的token的累积概率大于或等于 p 值时停止，然后从已经选取的token中进行采样，生成下一个token。例如top_p为0.1时意味着模型只考虑累积概率为10%的token。建议仅修改此参数或Temperature，不建议两者都修改。
        :rtype: float
        """
        return self._TopP

    @TopP.setter
    def TopP(self, TopP):
        self._TopP = TopP

    @property
    def N(self):
        """仅当模型为自行部署的开源大模型时生效。生成答案数。默认为1
        :rtype: float
        """
        return self._N

    @N.setter
    def N(self, N):
        self._N = N

    @property
    def MaxTokens(self):
        """仅当模型为自行部署的开源大模型时生效。默认 512，模型可生成内容的最长 token 数量，最大不能超过模型支持的上下文长度。
        :rtype: int
        """
        return self._MaxTokens

    @MaxTokens.setter
    def MaxTokens(self, MaxTokens):
        self._MaxTokens = MaxTokens

    @property
    def Stream(self):
        """否流式返回，默认值为 false。
        :rtype: bool
        """
        return self._Stream

    @Stream.setter
    def Stream(self, Stream):
        self._Stream = Stream


    def _deserialize(self, params):
        self._Model = params.get("Model")
        if params.get("Messages") is not None:
            self._Messages = []
            for item in params.get("Messages"):
                obj = Message()
                obj._deserialize(item)
                self._Messages.append(obj)
        self._Temperature = params.get("Temperature")
        self._TopP = params.get("TopP")
        self._N = params.get("N")
        self._MaxTokens = params.get("MaxTokens")
        self._Stream = params.get("Stream")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChatCompletionResponse(AbstractModel):
    """ChatCompletion返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Model: 对话的模型服务组ID
        :type Model: str
        :param _Choices: 本次问答的答案。
        :type Choices: list of Choice
        :param _Id: 会话Id。
        :type Id: str
        :param _Usage: token统计
        :type Usage: :class:`tencentcloud.tione.v20211111.models.Usage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Model = None
        self._Choices = None
        self._Id = None
        self._Usage = None
        self._RequestId = None

    @property
    def Model(self):
        """对话的模型服务组ID
        :rtype: str
        """
        return self._Model

    @Model.setter
    def Model(self, Model):
        self._Model = Model

    @property
    def Choices(self):
        """本次问答的答案。
        :rtype: list of Choice
        """
        return self._Choices

    @Choices.setter
    def Choices(self, Choices):
        self._Choices = Choices

    @property
    def Id(self):
        """会话Id。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Usage(self):
        """token统计
        :rtype: :class:`tencentcloud.tione.v20211111.models.Usage`
        """
        return self._Usage

    @Usage.setter
    def Usage(self, Usage):
        self._Usage = Usage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Model = params.get("Model")
        if params.get("Choices") is not None:
            self._Choices = []
            for item in params.get("Choices"):
                obj = Choice()
                obj._deserialize(item)
                self._Choices.append(obj)
        self._Id = params.get("Id")
        if params.get("Usage") is not None:
            self._Usage = Usage()
            self._Usage._deserialize(params.get("Usage"))
        self._RequestId = params.get("RequestId")


class ChatTaskInfo(AbstractModel):
    """对话任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务Id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _SessionId: 会话ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SessionId: str
        :param _SequenceId: 会话序列号
注意：此字段可能返回 null，表示取不到有效值。
        :type SequenceId: int
        :param _State: 任务状态。RUNNING，运行中;FINISHED，已结束
注意：此字段可能返回 null，表示取不到有效值。
        :type State: str
        :param _Answer: 本次对话迄今为止的所有答案
注意：此字段可能返回 null，表示取不到有效值。
        :type Answer: str
        """
        self._TaskId = None
        self._SessionId = None
        self._SequenceId = None
        self._State = None
        self._Answer = None

    @property
    def TaskId(self):
        """异步任务Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SessionId(self):
        """会话ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SequenceId(self):
        """会话序列号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SequenceId

    @SequenceId.setter
    def SequenceId(self, SequenceId):
        self._SequenceId = SequenceId

    @property
    def State(self):
        """任务状态。RUNNING，运行中;FINISHED，已结束
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Answer(self):
        """本次对话迄今为止的所有答案
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Answer

    @Answer.setter
    def Answer(self, Answer):
        self._Answer = Answer


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SessionId = params.get("SessionId")
        self._SequenceId = params.get("SequenceId")
        self._State = params.get("State")
        self._Answer = params.get("Answer")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAutoMLTaskNameExistRequest(AbstractModel):
    """CheckAutoMLTaskNameExist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskName: 任务名称
        :type TaskName: str
        """
        self._TaskName = None

    @property
    def TaskName(self):
        """任务名称
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAutoMLTaskNameExistResponse(AbstractModel):
    """CheckAutoMLTaskNameExist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NameExist: 是否存在
        :type NameExist: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NameExist = None
        self._RequestId = None

    @property
    def NameExist(self):
        """是否存在
        :rtype: bool
        """
        return self._NameExist

    @NameExist.setter
    def NameExist(self, NameExist):
        self._NameExist = NameExist

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NameExist = params.get("NameExist")
        self._RequestId = params.get("RequestId")


class CheckBillingOwnUinRequest(AbstractModel):
    """CheckBillingOwnUin请求参数结构体

    """


class CheckBillingOwnUinResponse(AbstractModel):
    """CheckBillingOwnUin返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsInternal: 是否是内部客户
        :type IsInternal: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsInternal = None
        self._RequestId = None

    @property
    def IsInternal(self):
        """是否是内部客户
        :rtype: bool
        """
        return self._IsInternal

    @IsInternal.setter
    def IsInternal(self, IsInternal):
        self._IsInternal = IsInternal

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsInternal = params.get("IsInternal")
        self._RequestId = params.get("RequestId")


class CheckBillingWhitelistRequest(AbstractModel):
    """CheckBillingWhitelist请求参数结构体

    """


class CheckBillingWhitelistResponse(AbstractModel):
    """CheckBillingWhitelist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsWhitelist: 是否为白名单用户
        :type IsWhitelist: bool
        :param _WhitelistState: None/Effective/Frozen/Expired
        :type WhitelistState: str
        :param _IsMiyingUser: 是否为觅影用户
        :type IsMiyingUser: bool
        :param _BillingType: 计费类型，MiyingBilling：觅影计费，NonWhitelist：正常计费（非白名单），CommonWhitelist：普通白名单，TLearningWhitelist：腾学汇白名单
        :type BillingType: str
        :param _BillingFeatures: 特殊资源访问权限
        :type BillingFeatures: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsWhitelist = None
        self._WhitelistState = None
        self._IsMiyingUser = None
        self._BillingType = None
        self._BillingFeatures = None
        self._RequestId = None

    @property
    def IsWhitelist(self):
        """是否为白名单用户
        :rtype: bool
        """
        return self._IsWhitelist

    @IsWhitelist.setter
    def IsWhitelist(self, IsWhitelist):
        self._IsWhitelist = IsWhitelist

    @property
    def WhitelistState(self):
        """None/Effective/Frozen/Expired
        :rtype: str
        """
        return self._WhitelistState

    @WhitelistState.setter
    def WhitelistState(self, WhitelistState):
        self._WhitelistState = WhitelistState

    @property
    def IsMiyingUser(self):
        """是否为觅影用户
        :rtype: bool
        """
        return self._IsMiyingUser

    @IsMiyingUser.setter
    def IsMiyingUser(self, IsMiyingUser):
        self._IsMiyingUser = IsMiyingUser

    @property
    def BillingType(self):
        """计费类型，MiyingBilling：觅影计费，NonWhitelist：正常计费（非白名单），CommonWhitelist：普通白名单，TLearningWhitelist：腾学汇白名单
        :rtype: str
        """
        return self._BillingType

    @BillingType.setter
    def BillingType(self, BillingType):
        self._BillingType = BillingType

    @property
    def BillingFeatures(self):
        """特殊资源访问权限
        :rtype: list of str
        """
        return self._BillingFeatures

    @BillingFeatures.setter
    def BillingFeatures(self, BillingFeatures):
        self._BillingFeatures = BillingFeatures

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsWhitelist = params.get("IsWhitelist")
        self._WhitelistState = params.get("WhitelistState")
        self._IsMiyingUser = params.get("IsMiyingUser")
        self._BillingType = params.get("BillingType")
        self._BillingFeatures = params.get("BillingFeatures")
        self._RequestId = params.get("RequestId")


class CheckDatasetNameRequest(AbstractModel):
    """CheckDatasetName请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetName: 数据集名称
        :type DatasetName: str
        """
        self._DatasetName = None

    @property
    def DatasetName(self):
        """数据集名称
        :rtype: str
        """
        return self._DatasetName

    @DatasetName.setter
    def DatasetName(self, DatasetName):
        self._DatasetName = DatasetName


    def _deserialize(self, params):
        self._DatasetName = params.get("DatasetName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDatasetNameResponse(AbstractModel):
    """CheckDatasetName返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Exist: true or false
注意：此字段可能返回 null，表示取不到有效值。
        :type Exist: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Exist = None
        self._RequestId = None

    @property
    def Exist(self):
        """true or false
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Exist

    @Exist.setter
    def Exist(self, Exist):
        self._Exist = Exist

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Exist = params.get("Exist")
        self._RequestId = params.get("RequestId")


class CheckModelAccTaskNameExistRequest(AbstractModel):
    """CheckModelAccTaskNameExist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelAccTaskName: 模型加速任务名称
        :type ModelAccTaskName: str
        """
        self._ModelAccTaskName = None

    @property
    def ModelAccTaskName(self):
        """模型加速任务名称
        :rtype: str
        """
        return self._ModelAccTaskName

    @ModelAccTaskName.setter
    def ModelAccTaskName(self, ModelAccTaskName):
        self._ModelAccTaskName = ModelAccTaskName


    def _deserialize(self, params):
        self._ModelAccTaskName = params.get("ModelAccTaskName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckModelAccTaskNameExistResponse(AbstractModel):
    """CheckModelAccTaskNameExist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NameExist: 是否存在重名
注意：此字段可能返回 null，表示取不到有效值。
        :type NameExist: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NameExist = None
        self._RequestId = None

    @property
    def NameExist(self):
        """是否存在重名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._NameExist

    @NameExist.setter
    def NameExist(self, NameExist):
        self._NameExist = NameExist

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NameExist = params.get("NameExist")
        self._RequestId = params.get("RequestId")


class CheckpointInferMeta(AbstractModel):
    """Checkpoint 的推理配置，目前由训练脚本输出

    """

    def __init__(self):
        r"""
        :param _ConversationTemplateName: 对话模板名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ConversationTemplateName: str
        :param _ModelId: 模型ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelId: str
        """
        self._ConversationTemplateName = None
        self._ModelId = None

    @property
    def ConversationTemplateName(self):
        """对话模板名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConversationTemplateName

    @ConversationTemplateName.setter
    def ConversationTemplateName(self, ConversationTemplateName):
        self._ConversationTemplateName = ConversationTemplateName

    @property
    def ModelId(self):
        """模型ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModelId

    @ModelId.setter
    def ModelId(self, ModelId):
        self._ModelId = ModelId


    def _deserialize(self, params):
        self._ConversationTemplateName = params.get("ConversationTemplateName")
        self._ModelId = params.get("ModelId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckpointInfo(AbstractModel):
    """训练任务产生的 Checkpoint 的信息

    """

    def __init__(self):
        r"""
        :param _CheckpointId: Checkpoint 的唯一 ID
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckpointId: str
        :param _TrainTaskId: 训练任务 ID（重启任务后不变）
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTaskId: str
        :param _TrainJobId: 训练任务实例 ID（重启任务后重新生成）
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainJobId: str
        :param _Name: 名称，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Description: 描述，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Path: Checkpoint 在训练容器中的路径，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _StorageInfo: Checkpoint 实际的存储信息
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageInfo: :class:`tencentcloud.tione.v20211111.models.CheckpointStorageInfo`
        :param _TrainMeta: 训练相关元信息，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainMeta: :class:`tencentcloud.tione.v20211111.models.CheckpointTrainMeta`
        :param _InferMeta: 推理相关元信息，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :type InferMeta: :class:`tencentcloud.tione.v20211111.models.CheckpointInferMeta`
        """
        self._CheckpointId = None
        self._TrainTaskId = None
        self._TrainJobId = None
        self._Name = None
        self._Description = None
        self._Path = None
        self._CreateTime = None
        self._UpdateTime = None
        self._StorageInfo = None
        self._TrainMeta = None
        self._InferMeta = None

    @property
    def CheckpointId(self):
        """Checkpoint 的唯一 ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CheckpointId

    @CheckpointId.setter
    def CheckpointId(self, CheckpointId):
        self._CheckpointId = CheckpointId

    @property
    def TrainTaskId(self):
        """训练任务 ID（重启任务后不变）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainTaskId

    @TrainTaskId.setter
    def TrainTaskId(self, TrainTaskId):
        self._TrainTaskId = TrainTaskId

    @property
    def TrainJobId(self):
        """训练任务实例 ID（重启任务后重新生成）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainJobId

    @TrainJobId.setter
    def TrainJobId(self, TrainJobId):
        self._TrainJobId = TrainJobId

    @property
    def Name(self):
        """名称，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """描述，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Path(self):
        """Checkpoint 在训练容器中的路径，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def StorageInfo(self):
        """Checkpoint 实际的存储信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CheckpointStorageInfo`
        """
        return self._StorageInfo

    @StorageInfo.setter
    def StorageInfo(self, StorageInfo):
        self._StorageInfo = StorageInfo

    @property
    def TrainMeta(self):
        """训练相关元信息，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CheckpointTrainMeta`
        """
        return self._TrainMeta

    @TrainMeta.setter
    def TrainMeta(self, TrainMeta):
        self._TrainMeta = TrainMeta

    @property
    def InferMeta(self):
        """推理相关元信息，通过用户脚本获取
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CheckpointInferMeta`
        """
        return self._InferMeta

    @InferMeta.setter
    def InferMeta(self, InferMeta):
        self._InferMeta = InferMeta


    def _deserialize(self, params):
        self._CheckpointId = params.get("CheckpointId")
        self._TrainTaskId = params.get("TrainTaskId")
        self._TrainJobId = params.get("TrainJobId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Path = params.get("Path")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("StorageInfo") is not None:
            self._StorageInfo = CheckpointStorageInfo()
            self._StorageInfo._deserialize(params.get("StorageInfo"))
        if params.get("TrainMeta") is not None:
            self._TrainMeta = CheckpointTrainMeta()
            self._TrainMeta._deserialize(params.get("TrainMeta"))
        if params.get("InferMeta") is not None:
            self._InferMeta = CheckpointInferMeta()
            self._InferMeta._deserialize(params.get("InferMeta"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckpointStorageInfo(AbstractModel):
    """Checkpoint 的存储信息

    """

    def __init__(self):
        r"""
        :param _StorageType: 存储类型
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageType: str
        :param _CFSStorage: CFS 存储
注意：此字段可能返回 null，表示取不到有效值。
        :type CFSStorage: :class:`tencentcloud.tione.v20211111.models.CFSStorageInfo`
        :param _CFSTurboStorage: CFSTurbo 存储
注意：此字段可能返回 null，表示取不到有效值。
        :type CFSTurboStorage: :class:`tencentcloud.tione.v20211111.models.CFSTurboStorageInfo`
        :param _DataSourceFS: 私有化数据中心数据源存储
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSourceFS: :class:`tencentcloud.tione.v20211111.models.DataCenterDataSource`
        :param _PlatformFS: 私有化文件系统存储
注意：此字段可能返回 null，表示取不到有效值。
        :type PlatformFS: :class:`tencentcloud.tione.v20211111.models.PrivateFileSystemDataSource`
        """
        self._StorageType = None
        self._CFSStorage = None
        self._CFSTurboStorage = None
        self._DataSourceFS = None
        self._PlatformFS = None

    @property
    def StorageType(self):
        """存储类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def CFSStorage(self):
        """CFS 存储
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSStorageInfo`
        """
        return self._CFSStorage

    @CFSStorage.setter
    def CFSStorage(self, CFSStorage):
        self._CFSStorage = CFSStorage

    @property
    def CFSTurboStorage(self):
        """CFSTurbo 存储
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSTurboStorageInfo`
        """
        return self._CFSTurboStorage

    @CFSTurboStorage.setter
    def CFSTurboStorage(self, CFSTurboStorage):
        self._CFSTurboStorage = CFSTurboStorage

    @property
    def DataSourceFS(self):
        """私有化数据中心数据源存储
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.DataCenterDataSource`
        """
        return self._DataSourceFS

    @DataSourceFS.setter
    def DataSourceFS(self, DataSourceFS):
        self._DataSourceFS = DataSourceFS

    @property
    def PlatformFS(self):
        """私有化文件系统存储
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.PrivateFileSystemDataSource`
        """
        return self._PlatformFS

    @PlatformFS.setter
    def PlatformFS(self, PlatformFS):
        self._PlatformFS = PlatformFS


    def _deserialize(self, params):
        self._StorageType = params.get("StorageType")
        if params.get("CFSStorage") is not None:
            self._CFSStorage = CFSStorageInfo()
            self._CFSStorage._deserialize(params.get("CFSStorage"))
        if params.get("CFSTurboStorage") is not None:
            self._CFSTurboStorage = CFSTurboStorageInfo()
            self._CFSTurboStorage._deserialize(params.get("CFSTurboStorage"))
        if params.get("DataSourceFS") is not None:
            self._DataSourceFS = DataCenterDataSource()
            self._DataSourceFS._deserialize(params.get("DataSourceFS"))
        if params.get("PlatformFS") is not None:
            self._PlatformFS = PrivateFileSystemDataSource()
            self._PlatformFS._deserialize(params.get("PlatformFS"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckpointTrainMeta(AbstractModel):
    """产生 Checkpoint 时由训练脚本输出的训练相关元信息

    """

    def __init__(self):
        r"""
        :param _Step: 训练步数
注意：此字段可能返回 null，表示取不到有效值。
        :type Step: int
        :param _Epoch: 训练 Epoch 数
注意：此字段可能返回 null，表示取不到有效值。
        :type Epoch: float
        :param _Loss: 训练 Loss
注意：此字段可能返回 null，表示取不到有效值。
        :type Loss: float
        :param _LearningRate: 学习率
注意：此字段可能返回 null，表示取不到有效值。
        :type LearningRate: float
        """
        self._Step = None
        self._Epoch = None
        self._Loss = None
        self._LearningRate = None

    @property
    def Step(self):
        """训练步数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Step

    @Step.setter
    def Step(self, Step):
        self._Step = Step

    @property
    def Epoch(self):
        """训练 Epoch 数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Epoch

    @Epoch.setter
    def Epoch(self, Epoch):
        self._Epoch = Epoch

    @property
    def Loss(self):
        """训练 Loss
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Loss

    @Loss.setter
    def Loss(self, Loss):
        self._Loss = Loss

    @property
    def LearningRate(self):
        """学习率
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._LearningRate

    @LearningRate.setter
    def LearningRate(self, LearningRate):
        self._LearningRate = LearningRate


    def _deserialize(self, params):
        self._Step = params.get("Step")
        self._Epoch = params.get("Epoch")
        self._Loss = params.get("Loss")
        self._LearningRate = params.get("LearningRate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Choice(AbstractModel):
    """对话结果

    """

    def __init__(self):
        r"""
        :param _Message: 对话结果
        :type Message: :class:`tencentcloud.tione.v20211111.models.Message`
        :param _FinishReason: 结束理由: stop, length, content_filter, null
        :type FinishReason: str
        :param _Index: 序号
        :type Index: int
        """
        self._Message = None
        self._FinishReason = None
        self._Index = None

    @property
    def Message(self):
        """对话结果
        :rtype: :class:`tencentcloud.tione.v20211111.models.Message`
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FinishReason(self):
        """结束理由: stop, length, content_filter, null
        :rtype: str
        """
        return self._FinishReason

    @FinishReason.setter
    def FinishReason(self, FinishReason):
        self._FinishReason = FinishReason

    @property
    def Index(self):
        """序号
        :rtype: int
        """
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index


    def _deserialize(self, params):
        if params.get("Message") is not None:
            self._Message = Message()
            self._Message._deserialize(params.get("Message"))
        self._FinishReason = params.get("FinishReason")
        self._Index = params.get("Index")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CodeInfo(AbstractModel):
    """代码信息

    """

    def __init__(self):
        r"""
        :param _Content: 代码文本内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: str
        :param _Language: 代码语言
注意：此字段可能返回 null，表示取不到有效值。
        :type Language: str
        """
        self._Content = None
        self._Language = None

    @property
    def Content(self):
        """代码文本内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Language(self):
        """代码语言
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Language

    @Language.setter
    def Language(self, Language):
        self._Language = Language


    def _deserialize(self, params):
        self._Content = params.get("Content")
        self._Language = params.get("Language")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CodeRepoConfig(AbstractModel):
    """代码仓库配置

    """

    def __init__(self):
        r"""
        :param _Id: 代码仓库Id
        :type Id: str
        :param _TargetPath: 代码仓下载目标地址
        :type TargetPath: str
        """
        self._Id = None
        self._TargetPath = None

    @property
    def Id(self):
        """代码仓库Id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TargetPath(self):
        """代码仓下载目标地址
        :rtype: str
        """
        return self._TargetPath

    @TargetPath.setter
    def TargetPath(self, TargetPath):
        self._TargetPath = TargetPath


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TargetPath = params.get("TargetPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CodeRepoDetail(AbstractModel):
    """代码仓库详情

    """

    def __init__(self):
        r"""
        :param _Id: 代码仓库ID
        :type Id: str
        :param _Name: 代码仓库名称
        :type Name: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _NoSecret: 是否有密钥
        :type NoSecret: bool
        :param _GitConfig: 配置
        :type GitConfig: :class:`tencentcloud.tione.v20211111.models.GitConfig`
        :param _Tags: 标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tags: list of Tag
        """
        self._Id = None
        self._Name = None
        self._CreateTime = None
        self._UpdateTime = None
        self._NoSecret = None
        self._GitConfig = None
        self._Tags = None

    @property
    def Id(self):
        """代码仓库ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        """代码仓库名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def NoSecret(self):
        """是否有密钥
        :rtype: bool
        """
        return self._NoSecret

    @NoSecret.setter
    def NoSecret(self, NoSecret):
        self._NoSecret = NoSecret

    @property
    def GitConfig(self):
        """配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.GitConfig`
        """
        return self._GitConfig

    @GitConfig.setter
    def GitConfig(self, GitConfig):
        self._GitConfig = GitConfig

    @property
    def Tags(self):
        """标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._NoSecret = params.get("NoSecret")
        if params.get("GitConfig") is not None:
            self._GitConfig = GitConfig()
            self._GitConfig._deserialize(params.get("GitConfig"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonConfig(AbstractModel):
    """自动学习基础配置

    """

    def __init__(self):
        r"""
        :param _SceneId: 场景ID
        :type SceneId: str
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _TaskDescription: 任务描述
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskDescription: str
        :param _Version: 任务版本，出参使用
        :type Version: str
        """
        self._SceneId = None
        self._TaskName = None
        self._TaskDescription = None
        self._Version = None

    @property
    def SceneId(self):
        """场景ID
        :rtype: str
        """
        return self._SceneId

    @SceneId.setter
    def SceneId(self, SceneId):
        self._SceneId = SceneId

    @property
    def TaskName(self):
        """任务名称
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskDescription(self):
        """任务描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskDescription

    @TaskDescription.setter
    def TaskDescription(self, TaskDescription):
        self._TaskDescription = TaskDescription

    @property
    def Version(self):
        """任务版本，出参使用
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version


    def _deserialize(self, params):
        self._SceneId = params.get("SceneId")
        self._TaskName = params.get("TaskName")
        self._TaskDescription = params.get("TaskDescription")
        self._Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComparedPrediction(AbstractModel):
    """对比评测结果信息

    """

    def __init__(self):
        r"""
        :param _GT: 标注结果
        :type GT: str
        :param _Preds: asr预测结果列表
        :type Preds: list of AsrPred
        :param _PredID: 预测id
        :type PredID: int
        :param _DatasetID: 测试数据集名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetID: str
        :param _FileRelPath: FileRelPath 文件在数据集中的相对路径，例如"1.wav"
注意：此字段可能返回 null，表示取不到有效值。
        :type FileRelPath: str
        :param _GTFilePath: 在cos中的路径用于下载
注意：此字段可能返回 null，表示取不到有效值。
        :type GTFilePath: str
        :param _AddFlag: 样本是否已经添加
注意：此字段可能返回 null，表示取不到有效值。
        :type AddFlag: bool
        :param _NLPText: 语料
注意：此字段可能返回 null，表示取不到有效值。
        :type NLPText: str
        :param _NLPPreds: nlp推理结果
注意：此字段可能返回 null，表示取不到有效值。
        :type NLPPreds: list of SeniorNLPItem
        :param _NLPGTs: nlp标注结果
注意：此字段可能返回 null，表示取不到有效值。
        :type NLPGTs: list of SeniorNLPItem
        :param _Type: 推理的错误类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._GT = None
        self._Preds = None
        self._PredID = None
        self._DatasetID = None
        self._FileRelPath = None
        self._GTFilePath = None
        self._AddFlag = None
        self._NLPText = None
        self._NLPPreds = None
        self._NLPGTs = None
        self._Type = None

    @property
    def GT(self):
        """标注结果
        :rtype: str
        """
        return self._GT

    @GT.setter
    def GT(self, GT):
        self._GT = GT

    @property
    def Preds(self):
        """asr预测结果列表
        :rtype: list of AsrPred
        """
        return self._Preds

    @Preds.setter
    def Preds(self, Preds):
        self._Preds = Preds

    @property
    def PredID(self):
        """预测id
        :rtype: int
        """
        return self._PredID

    @PredID.setter
    def PredID(self, PredID):
        self._PredID = PredID

    @property
    def DatasetID(self):
        """测试数据集名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetID

    @DatasetID.setter
    def DatasetID(self, DatasetID):
        self._DatasetID = DatasetID

    @property
    def FileRelPath(self):
        """FileRelPath 文件在数据集中的相对路径，例如"1.wav"
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FileRelPath

    @FileRelPath.setter
    def FileRelPath(self, FileRelPath):
        self._FileRelPath = FileRelPath

    @property
    def GTFilePath(self):
        """在cos中的路径用于下载
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GTFilePath

    @GTFilePath.setter
    def GTFilePath(self, GTFilePath):
        self._GTFilePath = GTFilePath

    @property
    def AddFlag(self):
        """样本是否已经添加
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._AddFlag

    @AddFlag.setter
    def AddFlag(self, AddFlag):
        self._AddFlag = AddFlag

    @property
    def NLPText(self):
        """语料
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NLPText

    @NLPText.setter
    def NLPText(self, NLPText):
        self._NLPText = NLPText

    @property
    def NLPPreds(self):
        """nlp推理结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SeniorNLPItem
        """
        return self._NLPPreds

    @NLPPreds.setter
    def NLPPreds(self, NLPPreds):
        self._NLPPreds = NLPPreds

    @property
    def NLPGTs(self):
        """nlp标注结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SeniorNLPItem
        """
        return self._NLPGTs

    @NLPGTs.setter
    def NLPGTs(self, NLPGTs):
        self._NLPGTs = NLPGTs

    @property
    def Type(self):
        """推理的错误类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._GT = params.get("GT")
        if params.get("Preds") is not None:
            self._Preds = []
            for item in params.get("Preds"):
                obj = AsrPred()
                obj._deserialize(item)
                self._Preds.append(obj)
        self._PredID = params.get("PredID")
        self._DatasetID = params.get("DatasetID")
        self._FileRelPath = params.get("FileRelPath")
        self._GTFilePath = params.get("GTFilePath")
        self._AddFlag = params.get("AddFlag")
        self._NLPText = params.get("NLPText")
        if params.get("NLPPreds") is not None:
            self._NLPPreds = []
            for item in params.get("NLPPreds"):
                obj = SeniorNLPItem()
                obj._deserialize(item)
                self._NLPPreds.append(obj)
        if params.get("NLPGTs") is not None:
            self._NLPGTs = []
            for item in params.get("NLPGTs"):
                obj = SeniorNLPItem()
                obj._deserialize(item)
                self._NLPGTs.append(obj)
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComparisonTagFilter(AbstractModel):
    """ComparisonTagFilter过滤参数

    """

    def __init__(self):
        r"""
        :param _Name: 无
        :type Name: str
        :param _Predicate: 无
        :type Predicate: str
        :param _NumberValue: 无
        :type NumberValue: float
        :param _SearchTerm: 无
        :type SearchTerm: str
        :param _Checked: 无
        :type Checked: list of str
        """
        self._Name = None
        self._Predicate = None
        self._NumberValue = None
        self._SearchTerm = None
        self._Checked = None

    @property
    def Name(self):
        """无
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Predicate(self):
        """无
        :rtype: str
        """
        return self._Predicate

    @Predicate.setter
    def Predicate(self, Predicate):
        self._Predicate = Predicate

    @property
    def NumberValue(self):
        """无
        :rtype: float
        """
        return self._NumberValue

    @NumberValue.setter
    def NumberValue(self, NumberValue):
        self._NumberValue = NumberValue

    @property
    def SearchTerm(self):
        """无
        :rtype: str
        """
        return self._SearchTerm

    @SearchTerm.setter
    def SearchTerm(self, SearchTerm):
        self._SearchTerm = SearchTerm

    @property
    def Checked(self):
        """无
        :rtype: list of str
        """
        return self._Checked

    @Checked.setter
    def Checked(self, Checked):
        self._Checked = Checked


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Predicate = params.get("Predicate")
        self._NumberValue = params.get("NumberValue")
        self._SearchTerm = params.get("SearchTerm")
        self._Checked = params.get("Checked")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Container(AbstractModel):
    """容器信息

    """

    def __init__(self):
        r"""
        :param _Name: 名字
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _ContainerId: id
注意：此字段可能返回 null，表示取不到有效值。
        :type ContainerId: str
        :param _Image: 镜像地址
注意：此字段可能返回 null，表示取不到有效值。
        :type Image: str
        :param _Status: 容器状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: :class:`tencentcloud.tione.v20211111.models.ContainerStatus`
        """
        self._Name = None
        self._ContainerId = None
        self._Image = None
        self._Status = None

    @property
    def Name(self):
        """名字
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ContainerId(self):
        """id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId

    @property
    def Image(self):
        """镜像地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Image

    @Image.setter
    def Image(self, Image):
        self._Image = Image

    @property
    def Status(self):
        """容器状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ContainerStatus`
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._ContainerId = params.get("ContainerId")
        self._Image = params.get("Image")
        if params.get("Status") is not None:
            self._Status = ContainerStatus()
            self._Status._deserialize(params.get("Status"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerStatus(AbstractModel):
    """容器状态

    """

    def __init__(self):
        r"""
        :param _RestartCount: 重启次数
注意：此字段可能返回 null，表示取不到有效值。
        :type RestartCount: int
        :param _State: 状态
注意：此字段可能返回 null，表示取不到有效值。
        :type State: str
        :param _Ready: 是否就绪
注意：此字段可能返回 null，表示取不到有效值。
        :type Ready: bool
        :param _Reason: 状态原因
注意：此字段可能返回 null，表示取不到有效值。
        :type Reason: str
        :param _Message: 容器的错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Message: str
        """
        self._RestartCount = None
        self._State = None
        self._Ready = None
        self._Reason = None
        self._Message = None

    @property
    def RestartCount(self):
        """重启次数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RestartCount

    @RestartCount.setter
    def RestartCount(self, RestartCount):
        self._RestartCount = RestartCount

    @property
    def State(self):
        """状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Ready(self):
        """是否就绪
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Ready

    @Ready.setter
    def Ready(self, Ready):
        self._Ready = Ready

    @property
    def Reason(self):
        """状态原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def Message(self):
        """容器的错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._RestartCount = params.get("RestartCount")
        self._State = params.get("State")
        self._Ready = params.get("Ready")
        self._Reason = params.get("Reason")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentLengthCount(AbstractModel):
    """数据中心查询文本透视

    """

    def __init__(self):
        r"""
        :param _LengthMin: 长度区间起点，闭区间
注意：此字段可能返回 null，表示取不到有效值。
        :type LengthMin: int
        :param _LengthMax: 长度区间终点，开区间
注意：此字段可能返回 null，表示取不到有效值。
        :type LengthMax: int
        :param _Count: 长度区间内样本出现的次数
注意：此字段可能返回 null，表示取不到有效值。
        :type Count: int
        """
        self._LengthMin = None
        self._LengthMax = None
        self._Count = None

    @property
    def LengthMin(self):
        """长度区间起点，闭区间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._LengthMin

    @LengthMin.setter
    def LengthMin(self, LengthMin):
        self._LengthMin = LengthMin

    @property
    def LengthMax(self):
        """长度区间终点，开区间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._LengthMax

    @LengthMax.setter
    def LengthMax(self, LengthMax):
        self._LengthMax = LengthMax

    @property
    def Count(self):
        """长度区间内样本出现的次数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._LengthMin = params.get("LengthMin")
        self._LengthMax = params.get("LengthMax")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyFlowRequest(AbstractModel):
    """CopyFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 工程ID
        :type ProjectId: str
        :param _FlowName: 工作流名称
        :type FlowName: str
        :param _SourceFlowId: 源工作流Id
        :type SourceFlowId: str
        :param _Description: 工作流描述
        :type Description: str
        """
        self._ProjectId = None
        self._FlowName = None
        self._SourceFlowId = None
        self._Description = None

    @property
    def ProjectId(self):
        """工程ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FlowName(self):
        """工作流名称
        :rtype: str
        """
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName

    @property
    def SourceFlowId(self):
        """源工作流Id
        :rtype: str
        """
        return self._SourceFlowId

    @SourceFlowId.setter
    def SourceFlowId(self, SourceFlowId):
        self._SourceFlowId = SourceFlowId

    @property
    def Description(self):
        """工作流描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FlowName = params.get("FlowName")
        self._SourceFlowId = params.get("SourceFlowId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyFlowResponse(AbstractModel):
    """CopyFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 工作流的Id
        :type FlowId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        """工作流的Id
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class CopyFromDemoFlowRequest(AbstractModel):
    """CopyFromDemoFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DemoFlowId: 案例工作流ID
        :type DemoFlowId: str
        :param _ProjectId: 工程ID
        :type ProjectId: str
        :param _FlowName: 工作流名称
        :type FlowName: str
        :param _Description: 工作流描述
        :type Description: str
        """
        self._DemoFlowId = None
        self._ProjectId = None
        self._FlowName = None
        self._Description = None

    @property
    def DemoFlowId(self):
        """案例工作流ID
        :rtype: str
        """
        return self._DemoFlowId

    @DemoFlowId.setter
    def DemoFlowId(self, DemoFlowId):
        self._DemoFlowId = DemoFlowId

    @property
    def ProjectId(self):
        """工程ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FlowName(self):
        """工作流名称
        :rtype: str
        """
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName

    @property
    def Description(self):
        """工作流描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._DemoFlowId = params.get("DemoFlowId")
        self._ProjectId = params.get("ProjectId")
        self._FlowName = params.get("FlowName")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyFromDemoFlowResponse(AbstractModel):
    """CopyFromDemoFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 工作流ID
        :type FlowId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        """工作流ID
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class CosPathInfo(AbstractModel):
    """cos的路径信息

    """

    def __init__(self):
        r"""
        :param _Bucket: 存储桶
注意：此字段可能返回 null，表示取不到有效值。
        :type Bucket: str
        :param _Region: 所在地域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Paths: 路径列表，目前只支持单个
注意：此字段可能返回 null，表示取不到有效值。
        :type Paths: list of str
        :param _Uin: 主用户Uin
注意：此字段可能返回 null，表示取不到有效值。
        :type Uin: str
        :param _SubUin: 子用户UIN
注意：此字段可能返回 null，表示取不到有效值。
        :type SubUin: str
        """
        self._Bucket = None
        self._Region = None
        self._Paths = None
        self._Uin = None
        self._SubUin = None

    @property
    def Bucket(self):
        """存储桶
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        """所在地域
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Paths(self):
        """路径列表，目前只支持单个
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Paths

    @Paths.setter
    def Paths(self, Paths):
        self._Paths = Paths

    @property
    def Uin(self):
        """主用户Uin
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubUin(self):
        """子用户UIN
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubUin

    @SubUin.setter
    def SubUin(self, SubUin):
        self._SubUin = SubUin


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Paths = params.get("Paths")
        self._Uin = params.get("Uin")
        self._SubUin = params.get("SubUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAlgoNotebookRequest(AbstractModel):
    """CreateAlgoNotebook请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 名称。不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :type Name: str
        :param _ChargeType: 计算资源付费模式 ，可选值为：
PREPAID：预付费，即包年包月
POSTPAID_BY_HOUR：按小时后付费
        :type ChargeType: str
        :param _ResourceConf: 计算资源配置
        :type ResourceConf: :class:`tencentcloud.tione.v20211111.models.ResourceConf`
        :param _LogEnable: 是否上报日志
        :type LogEnable: bool
        :param _RootAccess: 是否ROOT权限
        :type RootAccess: bool
        :param _AutoStopping: 是否自动停止
        :type AutoStopping: bool
        :param _DirectInternetAccess: 是否访问公网
        :type DirectInternetAccess: bool
        :param _AlgoVersionId: 算法版本ID
        :type AlgoVersionId: str
        :param _ResourceGroupId: 资源组ID(for预付费)
        :type ResourceGroupId: str
        :param _VpcId: Vpc-Id
        :type VpcId: str
        :param _SubnetId: 子网Id
        :type SubnetId: str
        :param _VolumeSourceType: 存储的类型。取值包含： 
    FREE:    预付费的免费存储
    CLOUD_PREMIUM： 高性能云硬盘
    CLOUD_SSD： SSD云硬盘
    CFS:     CFS存储，包含NFS和turbo
        :type VolumeSourceType: str
        :param _VolumeSizeInGB: 存储卷大小，单位GB
        :type VolumeSizeInGB: int
        :param _VolumeSourceCFS: CFS存储的配置
        :type VolumeSourceCFS: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        :param _LogConfig: 日志配置
        :type LogConfig: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        :param _LifecycleScriptId: 生命周期脚本的ID
        :type LifecycleScriptId: str
        :param _DefaultCodeRepoId: 默认GIT存储库的ID
        :type DefaultCodeRepoId: str
        :param _AdditionalCodeRepoIds: 其他GIT存储库的ID，最多3个
        :type AdditionalCodeRepoIds: list of str
        :param _AutomaticStopTime: 自动停止时间，单位小时
        :type AutomaticStopTime: int
        :param _Tags: 标签配置
        :type Tags: list of Tag
        :param _DataConfigs: 数据配置
        :type DataConfigs: list of DataConfig
        :param _UserType: 用户类型
        :type UserType: str
        :param _UserDataInfo: 用户数据信息
        :type UserDataInfo: :class:`tencentcloud.tione.v20211111.models.UserDataInfo`
        """
        self._Name = None
        self._ChargeType = None
        self._ResourceConf = None
        self._LogEnable = None
        self._RootAccess = None
        self._AutoStopping = None
        self._DirectInternetAccess = None
        self._AlgoVersionId = None
        self._ResourceGroupId = None
        self._VpcId = None
        self._SubnetId = None
        self._VolumeSourceType = None
        self._VolumeSizeInGB = None
        self._VolumeSourceCFS = None
        self._LogConfig = None
        self._LifecycleScriptId = None
        self._DefaultCodeRepoId = None
        self._AdditionalCodeRepoIds = None
        self._AutomaticStopTime = None
        self._Tags = None
        self._DataConfigs = None
        self._UserType = None
        self._UserDataInfo = None

    @property
    def Name(self):
        """名称。不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ChargeType(self):
        """计算资源付费模式 ，可选值为：
PREPAID：预付费，即包年包月
POSTPAID_BY_HOUR：按小时后付费
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def ResourceConf(self):
        """计算资源配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceConf`
        """
        return self._ResourceConf

    @ResourceConf.setter
    def ResourceConf(self, ResourceConf):
        self._ResourceConf = ResourceConf

    @property
    def LogEnable(self):
        """是否上报日志
        :rtype: bool
        """
        return self._LogEnable

    @LogEnable.setter
    def LogEnable(self, LogEnable):
        self._LogEnable = LogEnable

    @property
    def RootAccess(self):
        """是否ROOT权限
        :rtype: bool
        """
        return self._RootAccess

    @RootAccess.setter
    def RootAccess(self, RootAccess):
        self._RootAccess = RootAccess

    @property
    def AutoStopping(self):
        """是否自动停止
        :rtype: bool
        """
        return self._AutoStopping

    @AutoStopping.setter
    def AutoStopping(self, AutoStopping):
        self._AutoStopping = AutoStopping

    @property
    def DirectInternetAccess(self):
        """是否访问公网
        :rtype: bool
        """
        return self._DirectInternetAccess

    @DirectInternetAccess.setter
    def DirectInternetAccess(self, DirectInternetAccess):
        self._DirectInternetAccess = DirectInternetAccess

    @property
    def AlgoVersionId(self):
        """算法版本ID
        :rtype: str
        """
        return self._AlgoVersionId

    @AlgoVersionId.setter
    def AlgoVersionId(self, AlgoVersionId):
        self._AlgoVersionId = AlgoVersionId

    @property
    def ResourceGroupId(self):
        """资源组ID(for预付费)
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def VpcId(self):
        """Vpc-Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网Id
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def VolumeSourceType(self):
        """存储的类型。取值包含： 
    FREE:    预付费的免费存储
    CLOUD_PREMIUM： 高性能云硬盘
    CLOUD_SSD： SSD云硬盘
    CFS:     CFS存储，包含NFS和turbo
        :rtype: str
        """
        return self._VolumeSourceType

    @VolumeSourceType.setter
    def VolumeSourceType(self, VolumeSourceType):
        self._VolumeSourceType = VolumeSourceType

    @property
    def VolumeSizeInGB(self):
        """存储卷大小，单位GB
        :rtype: int
        """
        return self._VolumeSizeInGB

    @VolumeSizeInGB.setter
    def VolumeSizeInGB(self, VolumeSizeInGB):
        self._VolumeSizeInGB = VolumeSizeInGB

    @property
    def VolumeSourceCFS(self):
        """CFS存储的配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        """
        return self._VolumeSourceCFS

    @VolumeSourceCFS.setter
    def VolumeSourceCFS(self, VolumeSourceCFS):
        self._VolumeSourceCFS = VolumeSourceCFS

    @property
    def LogConfig(self):
        """日志配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def LifecycleScriptId(self):
        """生命周期脚本的ID
        :rtype: str
        """
        return self._LifecycleScriptId

    @LifecycleScriptId.setter
    def LifecycleScriptId(self, LifecycleScriptId):
        self._LifecycleScriptId = LifecycleScriptId

    @property
    def DefaultCodeRepoId(self):
        """默认GIT存储库的ID
        :rtype: str
        """
        return self._DefaultCodeRepoId

    @DefaultCodeRepoId.setter
    def DefaultCodeRepoId(self, DefaultCodeRepoId):
        self._DefaultCodeRepoId = DefaultCodeRepoId

    @property
    def AdditionalCodeRepoIds(self):
        """其他GIT存储库的ID，最多3个
        :rtype: list of str
        """
        return self._AdditionalCodeRepoIds

    @AdditionalCodeRepoIds.setter
    def AdditionalCodeRepoIds(self, AdditionalCodeRepoIds):
        self._AdditionalCodeRepoIds = AdditionalCodeRepoIds

    @property
    def AutomaticStopTime(self):
        """自动停止时间，单位小时
        :rtype: int
        """
        return self._AutomaticStopTime

    @AutomaticStopTime.setter
    def AutomaticStopTime(self, AutomaticStopTime):
        self._AutomaticStopTime = AutomaticStopTime

    @property
    def Tags(self):
        """标签配置
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def DataConfigs(self):
        """数据配置
        :rtype: list of DataConfig
        """
        return self._DataConfigs

    @DataConfigs.setter
    def DataConfigs(self, DataConfigs):
        self._DataConfigs = DataConfigs

    @property
    def UserType(self):
        """用户类型
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserDataInfo(self):
        """用户数据信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.UserDataInfo`
        """
        return self._UserDataInfo

    @UserDataInfo.setter
    def UserDataInfo(self, UserDataInfo):
        self._UserDataInfo = UserDataInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._ChargeType = params.get("ChargeType")
        if params.get("ResourceConf") is not None:
            self._ResourceConf = ResourceConf()
            self._ResourceConf._deserialize(params.get("ResourceConf"))
        self._LogEnable = params.get("LogEnable")
        self._RootAccess = params.get("RootAccess")
        self._AutoStopping = params.get("AutoStopping")
        self._DirectInternetAccess = params.get("DirectInternetAccess")
        self._AlgoVersionId = params.get("AlgoVersionId")
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._VolumeSourceType = params.get("VolumeSourceType")
        self._VolumeSizeInGB = params.get("VolumeSizeInGB")
        if params.get("VolumeSourceCFS") is not None:
            self._VolumeSourceCFS = CFSConfig()
            self._VolumeSourceCFS._deserialize(params.get("VolumeSourceCFS"))
        if params.get("LogConfig") is not None:
            self._LogConfig = LogConfig()
            self._LogConfig._deserialize(params.get("LogConfig"))
        self._LifecycleScriptId = params.get("LifecycleScriptId")
        self._DefaultCodeRepoId = params.get("DefaultCodeRepoId")
        self._AdditionalCodeRepoIds = params.get("AdditionalCodeRepoIds")
        self._AutomaticStopTime = params.get("AutomaticStopTime")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("DataConfigs") is not None:
            self._DataConfigs = []
            for item in params.get("DataConfigs"):
                obj = DataConfig()
                obj._deserialize(item)
                self._DataConfigs.append(obj)
        self._UserType = params.get("UserType")
        if params.get("UserDataInfo") is not None:
            self._UserDataInfo = UserDataInfo()
            self._UserDataInfo._deserialize(params.get("UserDataInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAlgoNotebookResponse(AbstractModel):
    """CreateAlgoNotebook返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: notebook标志
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        """notebook标志
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CreateAnnotateTaskRequest(AbstractModel):
    """CreateAnnotateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataSetId: 数据集ID
        :type DataSetId: str
        :param _DataSetName: 数据集名称
        :type DataSetName: str
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _ExportFormat: 导出数据格式
        :type ExportFormat: str
        :param _SceneName: 场景名称
        :type SceneName: str
        :param _Labels: 标签配置
        :type Labels: list of PersonalLabel
        :param _TaskNote: 任务备注
        :type TaskNote: str
        :param _CamTags: camtag
        :type CamTags: list of CamTag
        :param _OcrToolType: ocr标注工具类型 1 矩形 2 四点多边形
        :type OcrToolType: int
        :param _OcrTextAttributeAnnotateEnable: ocr是否同时标注文本属性
        :type OcrTextAttributeAnnotateEnable: bool
        :param _OcrAnnotationContentType: ocr任务类型：1-识别，2-智能结构化
        :type OcrAnnotationContentType: int
        :param _EnableAuxiliaryAnnotation: OCR任务：是否启用辅助标注
        :type EnableAuxiliaryAnnotation: bool
        """
        self._DataSetId = None
        self._DataSetName = None
        self._TaskName = None
        self._ExportFormat = None
        self._SceneName = None
        self._Labels = None
        self._TaskNote = None
        self._CamTags = None
        self._OcrToolType = None
        self._OcrTextAttributeAnnotateEnable = None
        self._OcrAnnotationContentType = None
        self._EnableAuxiliaryAnnotation = None

    @property
    def DataSetId(self):
        """数据集ID
        :rtype: str
        """
        return self._DataSetId

    @DataSetId.setter
    def DataSetId(self, DataSetId):
        self._DataSetId = DataSetId

    @property
    def DataSetName(self):
        """数据集名称
        :rtype: str
        """
        return self._DataSetName

    @DataSetName.setter
    def DataSetName(self, DataSetName):
        self._DataSetName = DataSetName

    @property
    def TaskName(self):
        """任务名称
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def ExportFormat(self):
        """导出数据格式
        :rtype: str
        """
        return self._ExportFormat

    @ExportFormat.setter
    def ExportFormat(self, ExportFormat):
        self._ExportFormat = ExportFormat

    @property
    def SceneName(self):
        """场景名称
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName

    @property
    def Labels(self):
        """标签配置
        :rtype: list of PersonalLabel
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def TaskNote(self):
        """任务备注
        :rtype: str
        """
        return self._TaskNote

    @TaskNote.setter
    def TaskNote(self, TaskNote):
        self._TaskNote = TaskNote

    @property
    def CamTags(self):
        """camtag
        :rtype: list of CamTag
        """
        return self._CamTags

    @CamTags.setter
    def CamTags(self, CamTags):
        self._CamTags = CamTags

    @property
    def OcrToolType(self):
        """ocr标注工具类型 1 矩形 2 四点多边形
        :rtype: int
        """
        return self._OcrToolType

    @OcrToolType.setter
    def OcrToolType(self, OcrToolType):
        self._OcrToolType = OcrToolType

    @property
    def OcrTextAttributeAnnotateEnable(self):
        """ocr是否同时标注文本属性
        :rtype: bool
        """
        return self._OcrTextAttributeAnnotateEnable

    @OcrTextAttributeAnnotateEnable.setter
    def OcrTextAttributeAnnotateEnable(self, OcrTextAttributeAnnotateEnable):
        self._OcrTextAttributeAnnotateEnable = OcrTextAttributeAnnotateEnable

    @property
    def OcrAnnotationContentType(self):
        """ocr任务类型：1-识别，2-智能结构化
        :rtype: int
        """
        return self._OcrAnnotationContentType

    @OcrAnnotationContentType.setter
    def OcrAnnotationContentType(self, OcrAnnotationContentType):
        self._OcrAnnotationContentType = OcrAnnotationContentType

    @property
    def EnableAuxiliaryAnnotation(self):
        """OCR任务：是否启用辅助标注
        :rtype: bool
        """
        return self._EnableAuxiliaryAnnotation

    @EnableAuxiliaryAnnotation.setter
    def EnableAuxiliaryAnnotation(self, EnableAuxiliaryAnnotation):
        self._EnableAuxiliaryAnnotation = EnableAuxiliaryAnnotation


    def _deserialize(self, params):
        self._DataSetId = params.get("DataSetId")
        self._DataSetName = params.get("DataSetName")
        self._TaskName = params.get("TaskName")
        self._ExportFormat = params.get("ExportFormat")
        self._SceneName = params.get("SceneName")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = PersonalLabel()
                obj._deserialize(item)
                self._Labels.append(obj)
        self._TaskNote = params.get("TaskNote")
        if params.get("CamTags") is not None:
            self._CamTags = []
            for item in params.get("CamTags"):
                obj = CamTag()
                obj._deserialize(item)
                self._CamTags.append(obj)
        self._OcrToolType = params.get("OcrToolType")
        self._OcrTextAttributeAnnotateEnable = params.get("OcrTextAttributeAnnotateEnable")
        self._OcrAnnotationContentType = params.get("OcrAnnotationContentType")
        self._EnableAuxiliaryAnnotation = params.get("EnableAuxiliaryAnnotation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnnotateTaskResponse(AbstractModel):
    """CreateAnnotateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateAnnotationKeyRequest(AbstractModel):
    """CreateAnnotationKey请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集ID
        :type DatasetId: str
        :param _Key: keypair
        :type Key: :class:`tencentcloud.tione.v20211111.models.KeyPair`
        :param _KeyType: 1	标准 key
2	附加key
        :type KeyType: int
        """
        self._DatasetId = None
        self._Key = None
        self._KeyType = None

    @property
    def DatasetId(self):
        """数据集ID
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def Key(self):
        """keypair
        :rtype: :class:`tencentcloud.tione.v20211111.models.KeyPair`
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def KeyType(self):
        """1	标准 key
2	附加key
        :rtype: int
        """
        return self._KeyType

    @KeyType.setter
    def KeyType(self, KeyType):
        self._KeyType = KeyType


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        if params.get("Key") is not None:
            self._Key = KeyPair()
            self._Key._deserialize(params.get("Key"))
        self._KeyType = params.get("KeyType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnnotationKeyResponse(AbstractModel):
    """CreateAnnotationKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Key: keypari
        :type Key: :class:`tencentcloud.tione.v20211111.models.KeyPair`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Key = None
        self._RequestId = None

    @property
    def Key(self):
        """keypari
        :rtype: :class:`tencentcloud.tione.v20211111.models.KeyPair`
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Key") is not None:
            self._Key = KeyPair()
            self._Key._deserialize(params.get("Key"))
        self._RequestId = params.get("RequestId")


class CreateAutoMLEMSTaskRequest(AbstractModel):
    """CreateAutoMLEMSTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 发布模型服务创建任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _ChargeType: 付费模式，PREPAID(包年包月), POSTPAID_BY_HOUR(按量计费)
        :type ChargeType: str
        :param _PublishResourceInfo: 发布模型服务资源分配信息
        :type PublishResourceInfo: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        :param _ResourceGroupId: 包年包月资源组id
        :type ResourceGroupId: str
        :param _MaxServiceHours: 模型服务最大运行小时，不填默认1小时，-1表示永久
        :type MaxServiceHours: int
        :param _UserCosInfo: 用来保存用户测试时的图片
        :type UserCosInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        self._AutoMLTaskId = None
        self._ChargeType = None
        self._PublishResourceInfo = None
        self._ResourceGroupId = None
        self._MaxServiceHours = None
        self._UserCosInfo = None

    @property
    def AutoMLTaskId(self):
        """发布模型服务创建任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def ChargeType(self):
        """付费模式，PREPAID(包年包月), POSTPAID_BY_HOUR(按量计费)
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def PublishResourceInfo(self):
        """发布模型服务资源分配信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        """
        return self._PublishResourceInfo

    @PublishResourceInfo.setter
    def PublishResourceInfo(self, PublishResourceInfo):
        self._PublishResourceInfo = PublishResourceInfo

    @property
    def ResourceGroupId(self):
        """包年包月资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def MaxServiceHours(self):
        """模型服务最大运行小时，不填默认1小时，-1表示永久
        :rtype: int
        """
        return self._MaxServiceHours

    @MaxServiceHours.setter
    def MaxServiceHours(self, MaxServiceHours):
        self._MaxServiceHours = MaxServiceHours

    @property
    def UserCosInfo(self):
        """用来保存用户测试时的图片
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._UserCosInfo

    @UserCosInfo.setter
    def UserCosInfo(self, UserCosInfo):
        self._UserCosInfo = UserCosInfo


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._ChargeType = params.get("ChargeType")
        if params.get("PublishResourceInfo") is not None:
            self._PublishResourceInfo = ResourceConfigInfo()
            self._PublishResourceInfo._deserialize(params.get("PublishResourceInfo"))
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._MaxServiceHours = params.get("MaxServiceHours")
        if params.get("UserCosInfo") is not None:
            self._UserCosInfo = CosPathInfo()
            self._UserCosInfo._deserialize(params.get("UserCosInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAutoMLEMSTaskResponse(AbstractModel):
    """CreateAutoMLEMSTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 发布模型服务创建任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EMSTaskId: 发布模型服务任务id
        :type EMSTaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EMSTaskId = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """发布模型服务创建任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EMSTaskId(self):
        """发布模型服务任务id
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        self._RequestId = params.get("RequestId")


class CreateAutoMLTaskEvaluationConfusionMatrixUrlRequest(AbstractModel):
    """CreateAutoMLTaskEvaluationConfusionMatrixUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _Thresholds: 每个标签对应的阈值信息，不填默认所有标签用默认的0.5，填一个表示所有标签的阈值一样
        :type Thresholds: list of float
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._Thresholds = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def Thresholds(self):
        """每个标签对应的阈值信息，不填默认所有标签用默认的0.5，填一个表示所有标签的阈值一样
        :rtype: list of float
        """
        return self._Thresholds

    @Thresholds.setter
    def Thresholds(self, Thresholds):
        self._Thresholds = Thresholds


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._Thresholds = params.get("Thresholds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAutoMLTaskEvaluationConfusionMatrixUrlResponse(AbstractModel):
    """CreateAutoMLTaskEvaluationConfusionMatrixUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfusionUrl: 混淆矩阵下载链接，有效期1分钟
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfusionUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ConfusionUrl = None
        self._RequestId = None

    @property
    def ConfusionUrl(self):
        """混淆矩阵下载链接，有效期1分钟
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ConfusionUrl

    @ConfusionUrl.setter
    def ConfusionUrl(self, ConfusionUrl):
        self._ConfusionUrl = ConfusionUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ConfusionUrl = params.get("ConfusionUrl")
        self._RequestId = params.get("RequestId")


class CreateAutoMLTaskRequest(AbstractModel):
    """CreateAutoMLTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CommonConfig: 基础配置
        :type CommonConfig: :class:`tencentcloud.tione.v20211111.models.CommonConfig`
        :param _DataConfig: 数据配置
        :type DataConfig: :class:`tencentcloud.tione.v20211111.models.MLDataConfig`
        :param _ModelTrainConfig: 模型训练配置
        :type ModelTrainConfig: :class:`tencentcloud.tione.v20211111.models.ModelTrainConfig`
        :param _ModelParamConfig: 模型训练超参数
        :type ModelParamConfig: str
        :param _TrainResourceConfig: 训练资源配置
        :type TrainResourceConfig: :class:`tencentcloud.tione.v20211111.models.TrainResourceConfig`
        :param _TaskSource: 任务来源
        :type TaskSource: str
        :param _Tags: 标签
        :type Tags: list of Tag
        :param _TaskOutputCosInfo: 任务输出路径
        :type TaskOutputCosInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _PublishAutoMLTaskId: 发布新版本任务来源ID
        :type PublishAutoMLTaskId: str
        :param _ModelAccelerateConfig: 模型优化配置
        :type ModelAccelerateConfig: :class:`tencentcloud.tione.v20211111.models.ModelAccelerateConfig`
        :param _CTXCosInfo: 自动学习全流程中可以使用的配置信息，cos内的文件会只读挂载
        :type CTXCosInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _NotAutoEvaluate: 训练完成后是否启动评测任务
        :type NotAutoEvaluate: bool
        """
        self._CommonConfig = None
        self._DataConfig = None
        self._ModelTrainConfig = None
        self._ModelParamConfig = None
        self._TrainResourceConfig = None
        self._TaskSource = None
        self._Tags = None
        self._TaskOutputCosInfo = None
        self._PublishAutoMLTaskId = None
        self._ModelAccelerateConfig = None
        self._CTXCosInfo = None
        self._NotAutoEvaluate = None

    @property
    def CommonConfig(self):
        """基础配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.CommonConfig`
        """
        return self._CommonConfig

    @CommonConfig.setter
    def CommonConfig(self, CommonConfig):
        self._CommonConfig = CommonConfig

    @property
    def DataConfig(self):
        """数据配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.MLDataConfig`
        """
        return self._DataConfig

    @DataConfig.setter
    def DataConfig(self, DataConfig):
        self._DataConfig = DataConfig

    @property
    def ModelTrainConfig(self):
        """模型训练配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.ModelTrainConfig`
        """
        return self._ModelTrainConfig

    @ModelTrainConfig.setter
    def ModelTrainConfig(self, ModelTrainConfig):
        self._ModelTrainConfig = ModelTrainConfig

    @property
    def ModelParamConfig(self):
        """模型训练超参数
        :rtype: str
        """
        return self._ModelParamConfig

    @ModelParamConfig.setter
    def ModelParamConfig(self, ModelParamConfig):
        self._ModelParamConfig = ModelParamConfig

    @property
    def TrainResourceConfig(self):
        """训练资源配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.TrainResourceConfig`
        """
        return self._TrainResourceConfig

    @TrainResourceConfig.setter
    def TrainResourceConfig(self, TrainResourceConfig):
        self._TrainResourceConfig = TrainResourceConfig

    @property
    def TaskSource(self):
        """任务来源
        :rtype: str
        """
        return self._TaskSource

    @TaskSource.setter
    def TaskSource(self, TaskSource):
        self._TaskSource = TaskSource

    @property
    def Tags(self):
        """标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def TaskOutputCosInfo(self):
        """任务输出路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._TaskOutputCosInfo

    @TaskOutputCosInfo.setter
    def TaskOutputCosInfo(self, TaskOutputCosInfo):
        self._TaskOutputCosInfo = TaskOutputCosInfo

    @property
    def PublishAutoMLTaskId(self):
        """发布新版本任务来源ID
        :rtype: str
        """
        return self._PublishAutoMLTaskId

    @PublishAutoMLTaskId.setter
    def PublishAutoMLTaskId(self, PublishAutoMLTaskId):
        self._PublishAutoMLTaskId = PublishAutoMLTaskId

    @property
    def ModelAccelerateConfig(self):
        """模型优化配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.ModelAccelerateConfig`
        """
        return self._ModelAccelerateConfig

    @ModelAccelerateConfig.setter
    def ModelAccelerateConfig(self, ModelAccelerateConfig):
        self._ModelAccelerateConfig = ModelAccelerateConfig

    @property
    def CTXCosInfo(self):
        """自动学习全流程中可以使用的配置信息，cos内的文件会只读挂载
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._CTXCosInfo

    @CTXCosInfo.setter
    def CTXCosInfo(self, CTXCosInfo):
        self._CTXCosInfo = CTXCosInfo

    @property
    def NotAutoEvaluate(self):
        """训练完成后是否启动评测任务
        :rtype: bool
        """
        return self._NotAutoEvaluate

    @NotAutoEvaluate.setter
    def NotAutoEvaluate(self, NotAutoEvaluate):
        self._NotAutoEvaluate = NotAutoEvaluate


    def _deserialize(self, params):
        if params.get("CommonConfig") is not None:
            self._CommonConfig = CommonConfig()
            self._CommonConfig._deserialize(params.get("CommonConfig"))
        if params.get("DataConfig") is not None:
            self._DataConfig = MLDataConfig()
            self._DataConfig._deserialize(params.get("DataConfig"))
        if params.get("ModelTrainConfig") is not None:
            self._ModelTrainConfig = ModelTrainConfig()
            self._ModelTrainConfig._deserialize(params.get("ModelTrainConfig"))
        self._ModelParamConfig = params.get("ModelParamConfig")
        if params.get("TrainResourceConfig") is not None:
            self._TrainResourceConfig = TrainResourceConfig()
            self._TrainResourceConfig._deserialize(params.get("TrainResourceConfig"))
        self._TaskSource = params.get("TaskSource")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("TaskOutputCosInfo") is not None:
            self._TaskOutputCosInfo = CosPathInfo()
            self._TaskOutputCosInfo._deserialize(params.get("TaskOutputCosInfo"))
        self._PublishAutoMLTaskId = params.get("PublishAutoMLTaskId")
        if params.get("ModelAccelerateConfig") is not None:
            self._ModelAccelerateConfig = ModelAccelerateConfig()
            self._ModelAccelerateConfig._deserialize(params.get("ModelAccelerateConfig"))
        if params.get("CTXCosInfo") is not None:
            self._CTXCosInfo = CosPathInfo()
            self._CTXCosInfo._deserialize(params.get("CTXCosInfo"))
        self._NotAutoEvaluate = params.get("NotAutoEvaluate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAutoMLTaskResponse(AbstractModel):
    """CreateAutoMLTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        :param _TrainTaskId: 训练任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTaskId: str
        :param _Version: 任务版本
        :type Version: str
        :param _AsyncTaskId: 异步任务ID
        :type AsyncTaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._TrainTaskId = None
        self._Version = None
        self._AsyncTaskId = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def TrainTaskId(self):
        """训练任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainTaskId

    @TrainTaskId.setter
    def TrainTaskId(self, TrainTaskId):
        self._TrainTaskId = TrainTaskId

    @property
    def Version(self):
        """任务版本
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def AsyncTaskId(self):
        """异步任务ID
        :rtype: str
        """
        return self._AsyncTaskId

    @AsyncTaskId.setter
    def AsyncTaskId(self, AsyncTaskId):
        self._AsyncTaskId = AsyncTaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._TrainTaskId = params.get("TrainTaskId")
        self._Version = params.get("Version")
        self._AsyncTaskId = params.get("AsyncTaskId")
        self._RequestId = params.get("RequestId")


class CreateBatchModelAccTasksRequest(AbstractModel):
    """CreateBatchModelAccTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelAccTaskName: 模型加速任务名称
        :type ModelAccTaskName: str
        :param _BatchModelAccTasks: 批量模型加速任务
        :type BatchModelAccTasks: list of BatchModelAccTask
        :param _ModelOutputPath: 模型加速保存路径
        :type ModelOutputPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _Tags: 标签
        :type Tags: list of Tag
        :param _OptimizationLevel: 优化级别(NO_LOSS/FP16/INT8)，默认FP16
        :type OptimizationLevel: str
        :param _GPUType: GPU卡类型(T4/V100/A10)，默认T4
        :type GPUType: str
        :param _HyperParameter: 专业参数设置
        :type HyperParameter: :class:`tencentcloud.tione.v20211111.models.HyperParameter`
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        :param _ResourceGroupName: 资源组名称
        :type ResourceGroupName: str
        :param _ResourceGroupSWType: 资源组类型
        :type ResourceGroupSWType: str
        """
        self._ModelAccTaskName = None
        self._BatchModelAccTasks = None
        self._ModelOutputPath = None
        self._Tags = None
        self._OptimizationLevel = None
        self._GPUType = None
        self._HyperParameter = None
        self._ResourceGroupId = None
        self._ResourceGroupName = None
        self._ResourceGroupSWType = None

    @property
    def ModelAccTaskName(self):
        """模型加速任务名称
        :rtype: str
        """
        return self._ModelAccTaskName

    @ModelAccTaskName.setter
    def ModelAccTaskName(self, ModelAccTaskName):
        self._ModelAccTaskName = ModelAccTaskName

    @property
    def BatchModelAccTasks(self):
        """批量模型加速任务
        :rtype: list of BatchModelAccTask
        """
        return self._BatchModelAccTasks

    @BatchModelAccTasks.setter
    def BatchModelAccTasks(self, BatchModelAccTasks):
        self._BatchModelAccTasks = BatchModelAccTasks

    @property
    def ModelOutputPath(self):
        """模型加速保存路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._ModelOutputPath

    @ModelOutputPath.setter
    def ModelOutputPath(self, ModelOutputPath):
        self._ModelOutputPath = ModelOutputPath

    @property
    def Tags(self):
        """标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def OptimizationLevel(self):
        """优化级别(NO_LOSS/FP16/INT8)，默认FP16
        :rtype: str
        """
        return self._OptimizationLevel

    @OptimizationLevel.setter
    def OptimizationLevel(self, OptimizationLevel):
        self._OptimizationLevel = OptimizationLevel

    @property
    def GPUType(self):
        """GPU卡类型(T4/V100/A10)，默认T4
        :rtype: str
        """
        return self._GPUType

    @GPUType.setter
    def GPUType(self, GPUType):
        self._GPUType = GPUType

    @property
    def HyperParameter(self):
        """专业参数设置
        :rtype: :class:`tencentcloud.tione.v20211111.models.HyperParameter`
        """
        return self._HyperParameter

    @HyperParameter.setter
    def HyperParameter(self, HyperParameter):
        self._HyperParameter = HyperParameter

    @property
    def ResourceGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceGroupName(self):
        """资源组名称
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def ResourceGroupSWType(self):
        """资源组类型
        :rtype: str
        """
        return self._ResourceGroupSWType

    @ResourceGroupSWType.setter
    def ResourceGroupSWType(self, ResourceGroupSWType):
        self._ResourceGroupSWType = ResourceGroupSWType


    def _deserialize(self, params):
        self._ModelAccTaskName = params.get("ModelAccTaskName")
        if params.get("BatchModelAccTasks") is not None:
            self._BatchModelAccTasks = []
            for item in params.get("BatchModelAccTasks"):
                obj = BatchModelAccTask()
                obj._deserialize(item)
                self._BatchModelAccTasks.append(obj)
        if params.get("ModelOutputPath") is not None:
            self._ModelOutputPath = CosPathInfo()
            self._ModelOutputPath._deserialize(params.get("ModelOutputPath"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._OptimizationLevel = params.get("OptimizationLevel")
        self._GPUType = params.get("GPUType")
        if params.get("HyperParameter") is not None:
            self._HyperParameter = HyperParameter()
            self._HyperParameter._deserialize(params.get("HyperParameter"))
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ResourceGroupName = params.get("ResourceGroupName")
        self._ResourceGroupSWType = params.get("ResourceGroupSWType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBatchModelAccTasksResponse(AbstractModel):
    """CreateBatchModelAccTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelAccTaskIds: 模型优化任务ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelAccTaskIds: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ModelAccTaskIds = None
        self._RequestId = None

    @property
    def ModelAccTaskIds(self):
        """模型优化任务ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ModelAccTaskIds

    @ModelAccTaskIds.setter
    def ModelAccTaskIds(self, ModelAccTaskIds):
        self._ModelAccTaskIds = ModelAccTaskIds

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ModelAccTaskIds = params.get("ModelAccTaskIds")
        self._RequestId = params.get("RequestId")


class CreateBatchTaskRequest(AbstractModel):
    """CreateBatchTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchTaskName: 批量预测任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :type BatchTaskName: str
        :param _ChargeType: 计费模式，eg：PREPAID 包年包月；POSTPAID_BY_HOUR 按量计费
        :type ChargeType: str
        :param _ResourceConfigInfo: 资源配置
        :type ResourceConfigInfo: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        :param _Outputs: 结果输出存储信息
        :type Outputs: list of DataConfig
        :param _LogEnable: 是否上报日志
        :type LogEnable: bool
        :param _JobType: 工作类型 1:单次 2:周期
        :type JobType: int
        :param _CronInfo: 任务周期描述
        :type CronInfo: :class:`tencentcloud.tione.v20211111.models.CronInfo`
        :param _ResourceGroupId: 包年包月资源组ID
        :type ResourceGroupId: str
        :param _Tags: 标签配置
        :type Tags: list of Tag
        :param _ModelInfo: 服务对应的模型信息，有模型文件时需要填写
        :type ModelInfo: :class:`tencentcloud.tione.v20211111.models.ModelInfo`
        :param _ImageInfo: 自定义镜像信息
        :type ImageInfo: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        :param _CodePackage: 代码包
        :type CodePackage: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _StartCmd: 启动命令
        :type StartCmd: str
        :param _DataConfigs: 数据配置
        :type DataConfigs: list of DataConfig
        :param _LogConfig: 日志配置
        :type LogConfig: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        :param _VpcId: VPC Id
        :type VpcId: str
        :param _SubnetId: 子网Id
        :type SubnetId: str
        :param _Remark: 备注
        :type Remark: str
        :param _CallbackUrl: 任务执行结果回调URL，仅支持http和https。回调格式&内容详见: [TI-ONE 接口回调说明](https://cloud.tencent.com/document/product/851/84292)
        :type CallbackUrl: str
        :param _StartCmdBase64: 以Base64方式编码的启动命令。假设启动命令是/app/run.sh，则此处输入参数应该为L2FwcC9ydW4uc2g=。
        :type StartCmdBase64: str
        """
        self._BatchTaskName = None
        self._ChargeType = None
        self._ResourceConfigInfo = None
        self._Outputs = None
        self._LogEnable = None
        self._JobType = None
        self._CronInfo = None
        self._ResourceGroupId = None
        self._Tags = None
        self._ModelInfo = None
        self._ImageInfo = None
        self._CodePackage = None
        self._StartCmd = None
        self._DataConfigs = None
        self._LogConfig = None
        self._VpcId = None
        self._SubnetId = None
        self._Remark = None
        self._CallbackUrl = None
        self._StartCmdBase64 = None

    @property
    def BatchTaskName(self):
        """批量预测任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :rtype: str
        """
        return self._BatchTaskName

    @BatchTaskName.setter
    def BatchTaskName(self, BatchTaskName):
        self._BatchTaskName = BatchTaskName

    @property
    def ChargeType(self):
        """计费模式，eg：PREPAID 包年包月；POSTPAID_BY_HOUR 按量计费
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def ResourceConfigInfo(self):
        """资源配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        """
        return self._ResourceConfigInfo

    @ResourceConfigInfo.setter
    def ResourceConfigInfo(self, ResourceConfigInfo):
        self._ResourceConfigInfo = ResourceConfigInfo

    @property
    def Outputs(self):
        """结果输出存储信息
        :rtype: list of DataConfig
        """
        return self._Outputs

    @Outputs.setter
    def Outputs(self, Outputs):
        self._Outputs = Outputs

    @property
    def LogEnable(self):
        """是否上报日志
        :rtype: bool
        """
        return self._LogEnable

    @LogEnable.setter
    def LogEnable(self, LogEnable):
        self._LogEnable = LogEnable

    @property
    def JobType(self):
        warnings.warn("parameter `JobType` is deprecated", DeprecationWarning) 

        """工作类型 1:单次 2:周期
        :rtype: int
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        warnings.warn("parameter `JobType` is deprecated", DeprecationWarning) 

        self._JobType = JobType

    @property
    def CronInfo(self):
        warnings.warn("parameter `CronInfo` is deprecated", DeprecationWarning) 

        """任务周期描述
        :rtype: :class:`tencentcloud.tione.v20211111.models.CronInfo`
        """
        return self._CronInfo

    @CronInfo.setter
    def CronInfo(self, CronInfo):
        warnings.warn("parameter `CronInfo` is deprecated", DeprecationWarning) 

        self._CronInfo = CronInfo

    @property
    def ResourceGroupId(self):
        """包年包月资源组ID
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def Tags(self):
        """标签配置
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ModelInfo(self):
        """服务对应的模型信息，有模型文件时需要填写
        :rtype: :class:`tencentcloud.tione.v20211111.models.ModelInfo`
        """
        return self._ModelInfo

    @ModelInfo.setter
    def ModelInfo(self, ModelInfo):
        self._ModelInfo = ModelInfo

    @property
    def ImageInfo(self):
        """自定义镜像信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        """
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def CodePackage(self):
        """代码包
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._CodePackage

    @CodePackage.setter
    def CodePackage(self, CodePackage):
        self._CodePackage = CodePackage

    @property
    def StartCmd(self):
        warnings.warn("parameter `StartCmd` is deprecated", DeprecationWarning) 

        """启动命令
        :rtype: str
        """
        return self._StartCmd

    @StartCmd.setter
    def StartCmd(self, StartCmd):
        warnings.warn("parameter `StartCmd` is deprecated", DeprecationWarning) 

        self._StartCmd = StartCmd

    @property
    def DataConfigs(self):
        """数据配置
        :rtype: list of DataConfig
        """
        return self._DataConfigs

    @DataConfigs.setter
    def DataConfigs(self, DataConfigs):
        self._DataConfigs = DataConfigs

    @property
    def LogConfig(self):
        """日志配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def VpcId(self):
        """VPC Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网Id
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Remark(self):
        """备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def CallbackUrl(self):
        """任务执行结果回调URL，仅支持http和https。回调格式&内容详见: [TI-ONE 接口回调说明](https://cloud.tencent.com/document/product/851/84292)
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def StartCmdBase64(self):
        """以Base64方式编码的启动命令。假设启动命令是/app/run.sh，则此处输入参数应该为L2FwcC9ydW4uc2g=。
        :rtype: str
        """
        return self._StartCmdBase64

    @StartCmdBase64.setter
    def StartCmdBase64(self, StartCmdBase64):
        self._StartCmdBase64 = StartCmdBase64


    def _deserialize(self, params):
        self._BatchTaskName = params.get("BatchTaskName")
        self._ChargeType = params.get("ChargeType")
        if params.get("ResourceConfigInfo") is not None:
            self._ResourceConfigInfo = ResourceConfigInfo()
            self._ResourceConfigInfo._deserialize(params.get("ResourceConfigInfo"))
        if params.get("Outputs") is not None:
            self._Outputs = []
            for item in params.get("Outputs"):
                obj = DataConfig()
                obj._deserialize(item)
                self._Outputs.append(obj)
        self._LogEnable = params.get("LogEnable")
        self._JobType = params.get("JobType")
        if params.get("CronInfo") is not None:
            self._CronInfo = CronInfo()
            self._CronInfo._deserialize(params.get("CronInfo"))
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("ModelInfo") is not None:
            self._ModelInfo = ModelInfo()
            self._ModelInfo._deserialize(params.get("ModelInfo"))
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        if params.get("CodePackage") is not None:
            self._CodePackage = CosPathInfo()
            self._CodePackage._deserialize(params.get("CodePackage"))
        self._StartCmd = params.get("StartCmd")
        if params.get("DataConfigs") is not None:
            self._DataConfigs = []
            for item in params.get("DataConfigs"):
                obj = DataConfig()
                obj._deserialize(item)
                self._DataConfigs.append(obj)
        if params.get("LogConfig") is not None:
            self._LogConfig = LogConfig()
            self._LogConfig._deserialize(params.get("LogConfig"))
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Remark = params.get("Remark")
        self._CallbackUrl = params.get("CallbackUrl")
        self._StartCmdBase64 = params.get("StartCmdBase64")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBatchTaskResponse(AbstractModel):
    """CreateBatchTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchTaskId: 批量预测任务ID
        :type BatchTaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BatchTaskId = None
        self._RequestId = None

    @property
    def BatchTaskId(self):
        """批量预测任务ID
        :rtype: str
        """
        return self._BatchTaskId

    @BatchTaskId.setter
    def BatchTaskId(self, BatchTaskId):
        self._BatchTaskId = BatchTaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BatchTaskId = params.get("BatchTaskId")
        self._RequestId = params.get("RequestId")


class CreateBillingPostpaidSWInstancesRequest(AbstractModel):
    """CreateBillingPostpaidSWInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组ID
        :type ResourceGroupId: str
        :param _CVMInstanceIds: 纳管的CVM节点列表
        :type CVMInstanceIds: list of str
        """
        self._ResourceGroupId = None
        self._CVMInstanceIds = None

    @property
    def ResourceGroupId(self):
        """资源组ID
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def CVMInstanceIds(self):
        """纳管的CVM节点列表
        :rtype: list of str
        """
        return self._CVMInstanceIds

    @CVMInstanceIds.setter
    def CVMInstanceIds(self, CVMInstanceIds):
        self._CVMInstanceIds = CVMInstanceIds


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._CVMInstanceIds = params.get("CVMInstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBillingPostpaidSWInstancesResponse(AbstractModel):
    """CreateBillingPostpaidSWInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FailedCVMInstances: 纳管失败的节点列表
        :type FailedCVMInstances: list of FailedPostpaidSWInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FailedCVMInstances = None
        self._RequestId = None

    @property
    def FailedCVMInstances(self):
        """纳管失败的节点列表
        :rtype: list of FailedPostpaidSWInstance
        """
        return self._FailedCVMInstances

    @FailedCVMInstances.setter
    def FailedCVMInstances(self, FailedCVMInstances):
        self._FailedCVMInstances = FailedCVMInstances

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FailedCVMInstances") is not None:
            self._FailedCVMInstances = []
            for item in params.get("FailedCVMInstances"):
                obj = FailedPostpaidSWInstance()
                obj._deserialize(item)
                self._FailedCVMInstances.append(obj)
        self._RequestId = params.get("RequestId")


class CreateBillingResourceGroupRequest(AbstractModel):
    """CreateBillingResourceGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 资源组名称
注意：此字段仅支持英文、数字、下划线 _、短横 -，只能以英文、数字开头，长度为60个字
注意：此字段相同地域相同资源组类型下不可同名。
        :type Name: str
        :param _Type: 资源组类型;
枚举值:
空: 通用, TRAIN: 训练, INFERENCE: 推理
        :type Type: str
        :param _TagSet: 资源组标签列表
注意：此字段从腾讯云标签服务获取。
        :type TagSet: list of Tag
        :param _IsBareMetalResourceGroup: 是否为裸金属资源组
        :type IsBareMetalResourceGroup: bool
        :param _IsRdma: 是否为rdma资源组
        :type IsRdma: bool
        :param _SWType: 纳管资源组类型，可填空、NORMAL、SW
        :type SWType: str
        :param _ScheduleStrategy: 调度策略
        :type ScheduleStrategy: str
        :param _GpuPackageEnabled: 是否限制GPU按比例申请资源
        :type GpuPackageEnabled: bool
        """
        self._Name = None
        self._Type = None
        self._TagSet = None
        self._IsBareMetalResourceGroup = None
        self._IsRdma = None
        self._SWType = None
        self._ScheduleStrategy = None
        self._GpuPackageEnabled = None

    @property
    def Name(self):
        """资源组名称
注意：此字段仅支持英文、数字、下划线 _、短横 -，只能以英文、数字开头，长度为60个字
注意：此字段相同地域相同资源组类型下不可同名。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """资源组类型;
枚举值:
空: 通用, TRAIN: 训练, INFERENCE: 推理
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TagSet(self):
        """资源组标签列表
注意：此字段从腾讯云标签服务获取。
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def IsBareMetalResourceGroup(self):
        """是否为裸金属资源组
        :rtype: bool
        """
        return self._IsBareMetalResourceGroup

    @IsBareMetalResourceGroup.setter
    def IsBareMetalResourceGroup(self, IsBareMetalResourceGroup):
        self._IsBareMetalResourceGroup = IsBareMetalResourceGroup

    @property
    def IsRdma(self):
        """是否为rdma资源组
        :rtype: bool
        """
        return self._IsRdma

    @IsRdma.setter
    def IsRdma(self, IsRdma):
        self._IsRdma = IsRdma

    @property
    def SWType(self):
        """纳管资源组类型，可填空、NORMAL、SW
        :rtype: str
        """
        return self._SWType

    @SWType.setter
    def SWType(self, SWType):
        self._SWType = SWType

    @property
    def ScheduleStrategy(self):
        """调度策略
        :rtype: str
        """
        return self._ScheduleStrategy

    @ScheduleStrategy.setter
    def ScheduleStrategy(self, ScheduleStrategy):
        self._ScheduleStrategy = ScheduleStrategy

    @property
    def GpuPackageEnabled(self):
        """是否限制GPU按比例申请资源
        :rtype: bool
        """
        return self._GpuPackageEnabled

    @GpuPackageEnabled.setter
    def GpuPackageEnabled(self, GpuPackageEnabled):
        self._GpuPackageEnabled = GpuPackageEnabled


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._IsBareMetalResourceGroup = params.get("IsBareMetalResourceGroup")
        self._IsRdma = params.get("IsRdma")
        self._SWType = params.get("SWType")
        self._ScheduleStrategy = params.get("ScheduleStrategy")
        self._GpuPackageEnabled = params.get("GpuPackageEnabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBillingResourceGroupResponse(AbstractModel):
    """CreateBillingResourceGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组id;
        :type ResourceGroupId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResourceGroupId = None
        self._RequestId = None

    @property
    def ResourceGroupId(self):
        """资源组id;
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._RequestId = params.get("RequestId")


class CreateBillingResourceInstanceRequest(AbstractModel):
    """CreateBillingResourceInstance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组节点id
        :type ResourceGroupId: str
        """
        self._ResourceGroupId = None

    @property
    def ResourceGroupId(self):
        """资源组节点id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBillingResourceInstanceResponse(AbstractModel):
    """CreateBillingResourceInstance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CheckResult: 校验结果 true: 有权限 false 无权限
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckResult: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CheckResult = None
        self._RequestId = None

    @property
    def CheckResult(self):
        """校验结果 true: 有权限 false 无权限
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CheckResult = params.get("CheckResult")
        self._RequestId = params.get("RequestId")


class CreateChatWhiteListUserRequest(AbstractModel):
    """CreateChatWhiteListUser请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UinId: 用户Uin
        :type UinId: str
        :param _Level: 用户等级，填'high'或'low'
        :type Level: str
        :param _Remark: 用户备注
        :type Remark: str
        """
        self._UinId = None
        self._Level = None
        self._Remark = None

    @property
    def UinId(self):
        """用户Uin
        :rtype: str
        """
        return self._UinId

    @UinId.setter
    def UinId(self, UinId):
        self._UinId = UinId

    @property
    def Level(self):
        """用户等级，填'high'或'low'
        :rtype: str
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Remark(self):
        """用户备注
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._UinId = params.get("UinId")
        self._Level = params.get("Level")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateChatWhiteListUserResponse(AbstractModel):
    """CreateChatWhiteListUser返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateCodeRepoRequest(AbstractModel):
    """CreateCodeRepo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 名称。不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :type Name: str
        :param _GitSecret: git的认证信息
        :type GitSecret: :class:`tencentcloud.tione.v20211111.models.GitSecret`
        :param _GitConfig: git的配置信息
        :type GitConfig: :class:`tencentcloud.tione.v20211111.models.GitConfig`
        :param _Tags: 标签信息
        :type Tags: list of Tag
        """
        self._Name = None
        self._GitSecret = None
        self._GitConfig = None
        self._Tags = None

    @property
    def Name(self):
        """名称。不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def GitSecret(self):
        """git的认证信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.GitSecret`
        """
        return self._GitSecret

    @GitSecret.setter
    def GitSecret(self, GitSecret):
        self._GitSecret = GitSecret

    @property
    def GitConfig(self):
        """git的配置信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.GitConfig`
        """
        return self._GitConfig

    @GitConfig.setter
    def GitConfig(self, GitConfig):
        self._GitConfig = GitConfig

    @property
    def Tags(self):
        """标签信息
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("GitSecret") is not None:
            self._GitSecret = GitSecret()
            self._GitSecret._deserialize(params.get("GitSecret"))
        if params.get("GitConfig") is not None:
            self._GitConfig = GitConfig()
            self._GitConfig._deserialize(params.get("GitConfig"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCodeRepoResponse(AbstractModel):
    """CreateCodeRepo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: id值
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        """id值
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CreateDataPipelineTaskRequest(AbstractModel):
    """CreateDataPipelineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskName: 数据构建任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :type TaskName: str
        :param _DataPipelines: 数据构建任务pipeline。具体取值范围参考DescribeDataPipelineConfig接口的DataPipelineConfigs返回值
        :type DataPipelines: list of str
        :param _DataScenes: 通用算法任务。具体取值范围参考DescribeDataPipelineConfig接口的DataSceneNodes返回值
        :type DataScenes: list of str
        :param _Description: 当前数据构建任务备注
        :type Description: str
        :param _Tags: 数据构建任务标签
        :type Tags: list of Tag
        """
        self._TaskName = None
        self._DataPipelines = None
        self._DataScenes = None
        self._Description = None
        self._Tags = None

    @property
    def TaskName(self):
        """数据构建任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def DataPipelines(self):
        """数据构建任务pipeline。具体取值范围参考DescribeDataPipelineConfig接口的DataPipelineConfigs返回值
        :rtype: list of str
        """
        return self._DataPipelines

    @DataPipelines.setter
    def DataPipelines(self, DataPipelines):
        self._DataPipelines = DataPipelines

    @property
    def DataScenes(self):
        """通用算法任务。具体取值范围参考DescribeDataPipelineConfig接口的DataSceneNodes返回值
        :rtype: list of str
        """
        return self._DataScenes

    @DataScenes.setter
    def DataScenes(self, DataScenes):
        self._DataScenes = DataScenes

    @property
    def Description(self):
        """当前数据构建任务备注
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Tags(self):
        """数据构建任务标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._DataPipelines = params.get("DataPipelines")
        self._DataScenes = params.get("DataScenes")
        self._Description = params.get("Description")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataPipelineTaskResponse(AbstractModel):
    """CreateDataPipelineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 数据构建任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """数据构建任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateDatasetDetailTextRequest(AbstractModel):
    """CreateDatasetDetailText请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集ID
        :type DatasetId: str
        :param _FileId: 文件ID
        :type FileId: str
        """
        self._DatasetId = None
        self._FileId = None

    @property
    def DatasetId(self):
        """数据集ID
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def FileId(self):
        """文件ID
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        self._FileId = params.get("FileId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDatasetDetailTextResponse(AbstractModel):
    """CreateDatasetDetailText返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """异步任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateDatasetRequest(AbstractModel):
    """CreateDataset请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetName: 数据集名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :type DatasetName: str
        :param _DatasetType: 数据集类型:
TYPE_DATASET_TEXT，文本
TYPE_DATASET_IMAGE，图片
TYPE_DATASET_TABLE，表格
TYPE_DATASET_OTHER，其他
        :type DatasetType: str
        :param _StorageDataPath: 数据源cos路径
        :type StorageDataPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _StorageLabelPath: 数据集标签cos存储路径
        :type StorageLabelPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _DatasetTags: 数据集标签
        :type DatasetTags: list of Tag
        :param _AnnotationStatus: 数据集标注状态:
STATUS_NON_ANNOTATED，未标注
STATUS_ANNOTATED，已标注
        :type AnnotationStatus: str
        :param _AnnotationType: 标注类型:
ANNOTATION_TYPE_CLASSIFICATION，图片分类
ANNOTATION_TYPE_DETECTION，目标检测
ANNOTATION_TYPE_SEGMENTATION，图片分割
ANNOTATION_TYPE_TRACKING，目标跟踪
ANNOTATION_TYPE_OCR，OCR
ANNOTATION_TYPE_TEXT_CLASSIFICATION，文本分类
        :type AnnotationType: str
        :param _AnnotationFormat: 标注格式:
ANNOTATION_FORMAT_TI，TI平台格式
ANNOTATION_FORMAT_PASCAL，Pascal Voc
ANNOTATION_FORMAT_COCO，COCO
ANNOTATION_FORMAT_FILE，文件目录结构
ANNOTATION_FORMAT_TEXT_TI，文本类型TI平台格式
ANNOTATION_FORMAT_TXT，文本类型TXT格式
ANNOTATION_FORMAT_CSV，文本类型CSV格式
ANNOTATION_FORMAT_JSON，文本类型JSON格式
        :type AnnotationFormat: str
        :param _SchemaInfos: 表头信息
        :type SchemaInfos: list of SchemaInfo
        :param _IsSchemaExisted: 数据是否存在表头
        :type IsSchemaExisted: bool
        :param _ContentType: 导入文件粒度
TYPE_TEXT_LINE，按行
TYPE_TEXT_FILE，按文件
        :type ContentType: str
        :param _BusinessScene: 业务场景：
SCENE_TIONE，普通TIONE场景
SCENE_THELPER，云小微场景
默认为SCENE_TIONE
        :type BusinessScene: str
        :param _DatasetScene: 数据集建模一级类别。LLM,CV,STRUCTURE,OTHER
        :type DatasetScene: str
        :param _SceneTags: 数据集标签。
        :type SceneTags: list of str
        :param _CFSConfig: 数据集CFS配置。仅支持LLM场景
        :type CFSConfig: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        """
        self._DatasetName = None
        self._DatasetType = None
        self._StorageDataPath = None
        self._StorageLabelPath = None
        self._DatasetTags = None
        self._AnnotationStatus = None
        self._AnnotationType = None
        self._AnnotationFormat = None
        self._SchemaInfos = None
        self._IsSchemaExisted = None
        self._ContentType = None
        self._BusinessScene = None
        self._DatasetScene = None
        self._SceneTags = None
        self._CFSConfig = None

    @property
    def DatasetName(self):
        """数据集名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :rtype: str
        """
        return self._DatasetName

    @DatasetName.setter
    def DatasetName(self, DatasetName):
        self._DatasetName = DatasetName

    @property
    def DatasetType(self):
        """数据集类型:
TYPE_DATASET_TEXT，文本
TYPE_DATASET_IMAGE，图片
TYPE_DATASET_TABLE，表格
TYPE_DATASET_OTHER，其他
        :rtype: str
        """
        return self._DatasetType

    @DatasetType.setter
    def DatasetType(self, DatasetType):
        self._DatasetType = DatasetType

    @property
    def StorageDataPath(self):
        """数据源cos路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageDataPath

    @StorageDataPath.setter
    def StorageDataPath(self, StorageDataPath):
        self._StorageDataPath = StorageDataPath

    @property
    def StorageLabelPath(self):
        """数据集标签cos存储路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageLabelPath

    @StorageLabelPath.setter
    def StorageLabelPath(self, StorageLabelPath):
        self._StorageLabelPath = StorageLabelPath

    @property
    def DatasetTags(self):
        """数据集标签
        :rtype: list of Tag
        """
        return self._DatasetTags

    @DatasetTags.setter
    def DatasetTags(self, DatasetTags):
        self._DatasetTags = DatasetTags

    @property
    def AnnotationStatus(self):
        """数据集标注状态:
STATUS_NON_ANNOTATED，未标注
STATUS_ANNOTATED，已标注
        :rtype: str
        """
        return self._AnnotationStatus

    @AnnotationStatus.setter
    def AnnotationStatus(self, AnnotationStatus):
        self._AnnotationStatus = AnnotationStatus

    @property
    def AnnotationType(self):
        """标注类型:
ANNOTATION_TYPE_CLASSIFICATION，图片分类
ANNOTATION_TYPE_DETECTION，目标检测
ANNOTATION_TYPE_SEGMENTATION，图片分割
ANNOTATION_TYPE_TRACKING，目标跟踪
ANNOTATION_TYPE_OCR，OCR
ANNOTATION_TYPE_TEXT_CLASSIFICATION，文本分类
        :rtype: str
        """
        return self._AnnotationType

    @AnnotationType.setter
    def AnnotationType(self, AnnotationType):
        self._AnnotationType = AnnotationType

    @property
    def AnnotationFormat(self):
        """标注格式:
ANNOTATION_FORMAT_TI，TI平台格式
ANNOTATION_FORMAT_PASCAL，Pascal Voc
ANNOTATION_FORMAT_COCO，COCO
ANNOTATION_FORMAT_FILE，文件目录结构
ANNOTATION_FORMAT_TEXT_TI，文本类型TI平台格式
ANNOTATION_FORMAT_TXT，文本类型TXT格式
ANNOTATION_FORMAT_CSV，文本类型CSV格式
ANNOTATION_FORMAT_JSON，文本类型JSON格式
        :rtype: str
        """
        return self._AnnotationFormat

    @AnnotationFormat.setter
    def AnnotationFormat(self, AnnotationFormat):
        self._AnnotationFormat = AnnotationFormat

    @property
    def SchemaInfos(self):
        """表头信息
        :rtype: list of SchemaInfo
        """
        return self._SchemaInfos

    @SchemaInfos.setter
    def SchemaInfos(self, SchemaInfos):
        self._SchemaInfos = SchemaInfos

    @property
    def IsSchemaExisted(self):
        """数据是否存在表头
        :rtype: bool
        """
        return self._IsSchemaExisted

    @IsSchemaExisted.setter
    def IsSchemaExisted(self, IsSchemaExisted):
        self._IsSchemaExisted = IsSchemaExisted

    @property
    def ContentType(self):
        """导入文件粒度
TYPE_TEXT_LINE，按行
TYPE_TEXT_FILE，按文件
        :rtype: str
        """
        return self._ContentType

    @ContentType.setter
    def ContentType(self, ContentType):
        self._ContentType = ContentType

    @property
    def BusinessScene(self):
        """业务场景：
SCENE_TIONE，普通TIONE场景
SCENE_THELPER，云小微场景
默认为SCENE_TIONE
        :rtype: str
        """
        return self._BusinessScene

    @BusinessScene.setter
    def BusinessScene(self, BusinessScene):
        self._BusinessScene = BusinessScene

    @property
    def DatasetScene(self):
        """数据集建模一级类别。LLM,CV,STRUCTURE,OTHER
        :rtype: str
        """
        return self._DatasetScene

    @DatasetScene.setter
    def DatasetScene(self, DatasetScene):
        self._DatasetScene = DatasetScene

    @property
    def SceneTags(self):
        """数据集标签。
        :rtype: list of str
        """
        return self._SceneTags

    @SceneTags.setter
    def SceneTags(self, SceneTags):
        self._SceneTags = SceneTags

    @property
    def CFSConfig(self):
        """数据集CFS配置。仅支持LLM场景
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        """
        return self._CFSConfig

    @CFSConfig.setter
    def CFSConfig(self, CFSConfig):
        self._CFSConfig = CFSConfig


    def _deserialize(self, params):
        self._DatasetName = params.get("DatasetName")
        self._DatasetType = params.get("DatasetType")
        if params.get("StorageDataPath") is not None:
            self._StorageDataPath = CosPathInfo()
            self._StorageDataPath._deserialize(params.get("StorageDataPath"))
        if params.get("StorageLabelPath") is not None:
            self._StorageLabelPath = CosPathInfo()
            self._StorageLabelPath._deserialize(params.get("StorageLabelPath"))
        if params.get("DatasetTags") is not None:
            self._DatasetTags = []
            for item in params.get("DatasetTags"):
                obj = Tag()
                obj._deserialize(item)
                self._DatasetTags.append(obj)
        self._AnnotationStatus = params.get("AnnotationStatus")
        self._AnnotationType = params.get("AnnotationType")
        self._AnnotationFormat = params.get("AnnotationFormat")
        if params.get("SchemaInfos") is not None:
            self._SchemaInfos = []
            for item in params.get("SchemaInfos"):
                obj = SchemaInfo()
                obj._deserialize(item)
                self._SchemaInfos.append(obj)
        self._IsSchemaExisted = params.get("IsSchemaExisted")
        self._ContentType = params.get("ContentType")
        self._BusinessScene = params.get("BusinessScene")
        self._DatasetScene = params.get("DatasetScene")
        self._SceneTags = params.get("SceneTags")
        if params.get("CFSConfig") is not None:
            self._CFSConfig = CFSConfig()
            self._CFSConfig._deserialize(params.get("CFSConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDatasetResponse(AbstractModel):
    """CreateDataset返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatasetId = None
        self._RequestId = None

    @property
    def DatasetId(self):
        """数据集ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        self._RequestId = params.get("RequestId")


class CreateDatasetTextAnalyzeRequest(AbstractModel):
    """CreateDatasetTextAnalyze请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetIds: 数据集ID列表
        :type DatasetIds: list of str
        :param _TextLanguage: 样本语言:
TEXT_LANGUAGE_ENGLISH 英文
TEXT_LANGUAGE_CHINESE 中文
        :type TextLanguage: str
        """
        self._DatasetIds = None
        self._TextLanguage = None

    @property
    def DatasetIds(self):
        """数据集ID列表
        :rtype: list of str
        """
        return self._DatasetIds

    @DatasetIds.setter
    def DatasetIds(self, DatasetIds):
        self._DatasetIds = DatasetIds

    @property
    def TextLanguage(self):
        """样本语言:
TEXT_LANGUAGE_ENGLISH 英文
TEXT_LANGUAGE_CHINESE 中文
        :rtype: str
        """
        return self._TextLanguage

    @TextLanguage.setter
    def TextLanguage(self, TextLanguage):
        self._TextLanguage = TextLanguage


    def _deserialize(self, params):
        self._DatasetIds = params.get("DatasetIds")
        self._TextLanguage = params.get("TextLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDatasetTextAnalyzeResponse(AbstractModel):
    """CreateDatasetTextAnalyze返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """异步任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateDemoWhiteRequest(AbstractModel):
    """CreateDemoWhite请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DemoUin: 要添加白名单用户的主账号uin
        :type DemoUin: str
        :param _Type: 任务类型。1为Notebook+Tikit实验；2为自动学习实验
        :type Type: int
        """
        self._DemoUin = None
        self._Type = None

    @property
    def DemoUin(self):
        """要添加白名单用户的主账号uin
        :rtype: str
        """
        return self._DemoUin

    @DemoUin.setter
    def DemoUin(self, DemoUin):
        self._DemoUin = DemoUin

    @property
    def Type(self):
        """任务类型。1为Notebook+Tikit实验；2为自动学习实验
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._DemoUin = params.get("DemoUin")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDemoWhiteResponse(AbstractModel):
    """CreateDemoWhite返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateDirectoryRequest(AbstractModel):
    """CreateDirectory请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataSourceId: CFS ID
        :type DataSourceId: str
        :param _Directory: 文件夹路径
        :type Directory: str
        """
        self._DataSourceId = None
        self._Directory = None

    @property
    def DataSourceId(self):
        """CFS ID
        :rtype: str
        """
        return self._DataSourceId

    @DataSourceId.setter
    def DataSourceId(self, DataSourceId):
        self._DataSourceId = DataSourceId

    @property
    def Directory(self):
        """文件夹路径
        :rtype: str
        """
        return self._Directory

    @Directory.setter
    def Directory(self, Directory):
        self._Directory = Directory


    def _deserialize(self, params):
        self._DataSourceId = params.get("DataSourceId")
        self._Directory = params.get("Directory")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDirectoryResponse(AbstractModel):
    """CreateDirectory返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateExportAutoMLSDKTaskRequest(AbstractModel):
    """CreateExportAutoMLSDKTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        :param _TrainTaskId: 训练任务ID
        :type TrainTaskId: str
        :param _SDKLanguage: SDK语言
        :type SDKLanguage: str
        :param _StorageCosInfo: 存储COS路径
        :type StorageCosInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        self._AutoMLTaskId = None
        self._TrainTaskId = None
        self._SDKLanguage = None
        self._StorageCosInfo = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def TrainTaskId(self):
        """训练任务ID
        :rtype: str
        """
        return self._TrainTaskId

    @TrainTaskId.setter
    def TrainTaskId(self, TrainTaskId):
        self._TrainTaskId = TrainTaskId

    @property
    def SDKLanguage(self):
        """SDK语言
        :rtype: str
        """
        return self._SDKLanguage

    @SDKLanguage.setter
    def SDKLanguage(self, SDKLanguage):
        self._SDKLanguage = SDKLanguage

    @property
    def StorageCosInfo(self):
        """存储COS路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageCosInfo

    @StorageCosInfo.setter
    def StorageCosInfo(self, StorageCosInfo):
        self._StorageCosInfo = StorageCosInfo


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._TrainTaskId = params.get("TrainTaskId")
        self._SDKLanguage = params.get("SDKLanguage")
        if params.get("StorageCosInfo") is not None:
            self._StorageCosInfo = CosPathInfo()
            self._StorageCosInfo._deserialize(params.get("StorageCosInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExportAutoMLSDKTaskResponse(AbstractModel):
    """CreateExportAutoMLSDKTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        :param _TrainTaskId: 训练任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTaskId: str
        :param _TrainId: 任务式建模ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainId: str
        :param _StorageCosInfo: SDK输出COS路径
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageCosInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._TrainTaskId = None
        self._TrainId = None
        self._StorageCosInfo = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def TrainTaskId(self):
        """训练任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainTaskId

    @TrainTaskId.setter
    def TrainTaskId(self, TrainTaskId):
        self._TrainTaskId = TrainTaskId

    @property
    def TrainId(self):
        """任务式建模ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainId

    @TrainId.setter
    def TrainId(self, TrainId):
        self._TrainId = TrainId

    @property
    def StorageCosInfo(self):
        """SDK输出COS路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageCosInfo

    @StorageCosInfo.setter
    def StorageCosInfo(self, StorageCosInfo):
        self._StorageCosInfo = StorageCosInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._TrainTaskId = params.get("TrainTaskId")
        self._TrainId = params.get("TrainId")
        if params.get("StorageCosInfo") is not None:
            self._StorageCosInfo = CosPathInfo()
            self._StorageCosInfo._deserialize(params.get("StorageCosInfo"))
        self._RequestId = params.get("RequestId")


class CreateExportRequest(AbstractModel):
    """CreateExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Service: 服务类型，TRAIN为任务式建模, NOTEBOOK为Notebook, INFER为在线服务, BATCH为批量预测枚举值：- TRAIN- NOTEBOOK- INFER- BATCH
        :type Service: str
        :param _ServiceId: 服务ID，和Service参数对应，不同Service的服务ID获取方式不同，具体如下：- Service类型为TRAIN：  调用[DescribeTrainingTask接口](/document/product/851/75089)查询训练任务详情，ServiceId为接口返回值中Response.TrainingTaskDetail.LatestInstanceId- Service类型为NOTEBOOK：  调用[DescribeNotebook接口](/document/product/851/95662)查询Notebook详情，ServiceId为接口返回值中Response.NotebookDetail.PodName- Service类型为INFER：  调用[DescribeModelServiceGroup接口](/document/product/851/82285)查询服务组详情，ServiceId为接口返回值中Response.ServiceGroup.Services.ServiceId- Service类型为BATCH：  调用[DescribeBatchTask接口](/document/product/851/80180)查询跑批任务详情，ServiceId为接口返回值中Response.BatchTaskDetail.LatestInstanceId
        :type ServiceId: str
        :param _StartTime: 日志查询开始时间（RFC3339格式的时间字符串），默认值为当前时间的前一个小时
        :type StartTime: str
        :param _EndTime: 日志查询结束时间（RFC3339格式的时间字符串），开始时间和结束时间必须同时填或同时不填，默认值为当前时间
        :type EndTime: str
        :param _Format: 日志导出数据格式。json，csv，默认为csv
        :type Format: str
        :param _PodName: Pod的名称，即需要查询服务对应的Pod，和Service参数对应，不同Service的PodName获取方式不同，具体如下：- Service类型为TRAIN：  调用[DescribeTrainingTaskPods接口](/document/product/851/75088)查询训练任务pod列表，PodName为接口返回值中Response.PodNames- Service类型为NOTEBOOK：  调用[DescribeNotebook接口](/document/product/851/95662)查询Notebook详情，PodName为接口返回值中Response.NotebookDetail.PodName- Service类型为INFER：  调用[DescribeModelService接口](/document/product/851/82287)查询单个服务详情，PodName为接口返回值中Response.Service.ServiceInfo.PodInfos- Service类型为BATCH：  调用[DescribeBatchTask接口](/document/product/851/80180)查询跑批任务详情，PodName为接口返回值中Response.BatchTaskDetail. PodList注：支持结尾通配符*
        :type PodName: str
        :param _JobCategory: 描述任务的类型
        :type JobCategory: str
        :param _InstanceType: 实例的类型
        :type InstanceType: str
        :param _InstanceId: 查实例Id
        :type InstanceId: str
        """
        self._Service = None
        self._ServiceId = None
        self._StartTime = None
        self._EndTime = None
        self._Format = None
        self._PodName = None
        self._JobCategory = None
        self._InstanceType = None
        self._InstanceId = None

    @property
    def Service(self):
        """服务类型，TRAIN为任务式建模, NOTEBOOK为Notebook, INFER为在线服务, BATCH为批量预测枚举值：- TRAIN- NOTEBOOK- INFER- BATCH
        :rtype: str
        """
        return self._Service

    @Service.setter
    def Service(self, Service):
        self._Service = Service

    @property
    def ServiceId(self):
        """服务ID，和Service参数对应，不同Service的服务ID获取方式不同，具体如下：- Service类型为TRAIN：  调用[DescribeTrainingTask接口](/document/product/851/75089)查询训练任务详情，ServiceId为接口返回值中Response.TrainingTaskDetail.LatestInstanceId- Service类型为NOTEBOOK：  调用[DescribeNotebook接口](/document/product/851/95662)查询Notebook详情，ServiceId为接口返回值中Response.NotebookDetail.PodName- Service类型为INFER：  调用[DescribeModelServiceGroup接口](/document/product/851/82285)查询服务组详情，ServiceId为接口返回值中Response.ServiceGroup.Services.ServiceId- Service类型为BATCH：  调用[DescribeBatchTask接口](/document/product/851/80180)查询跑批任务详情，ServiceId为接口返回值中Response.BatchTaskDetail.LatestInstanceId
        :rtype: str
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def StartTime(self):
        """日志查询开始时间（RFC3339格式的时间字符串），默认值为当前时间的前一个小时
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """日志查询结束时间（RFC3339格式的时间字符串），开始时间和结束时间必须同时填或同时不填，默认值为当前时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Format(self):
        """日志导出数据格式。json，csv，默认为csv
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def PodName(self):
        """Pod的名称，即需要查询服务对应的Pod，和Service参数对应，不同Service的PodName获取方式不同，具体如下：- Service类型为TRAIN：  调用[DescribeTrainingTaskPods接口](/document/product/851/75088)查询训练任务pod列表，PodName为接口返回值中Response.PodNames- Service类型为NOTEBOOK：  调用[DescribeNotebook接口](/document/product/851/95662)查询Notebook详情，PodName为接口返回值中Response.NotebookDetail.PodName- Service类型为INFER：  调用[DescribeModelService接口](/document/product/851/82287)查询单个服务详情，PodName为接口返回值中Response.Service.ServiceInfo.PodInfos- Service类型为BATCH：  调用[DescribeBatchTask接口](/document/product/851/80180)查询跑批任务详情，PodName为接口返回值中Response.BatchTaskDetail. PodList注：支持结尾通配符*
        :rtype: str
        """
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def JobCategory(self):
        """描述任务的类型
        :rtype: str
        """
        return self._JobCategory

    @JobCategory.setter
    def JobCategory(self, JobCategory):
        self._JobCategory = JobCategory

    @property
    def InstanceType(self):
        """实例的类型
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        """查实例Id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Service = params.get("Service")
        self._ServiceId = params.get("ServiceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Format = params.get("Format")
        self._PodName = params.get("PodName")
        self._JobCategory = params.get("JobCategory")
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExportResponse(AbstractModel):
    """CreateExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportId: 日志下载任务的ID
        :type ExportId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ExportId = None
        self._RequestId = None

    @property
    def ExportId(self):
        """日志下载任务的ID
        :rtype: str
        """
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExportId = params.get("ExportId")
        self._RequestId = params.get("RequestId")


class CreateFilePreviewUrlRequest(AbstractModel):
    """CreateFilePreviewUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataSourceId: CFS ID
        :type DataSourceId: str
        :param _File: 文件在cfs上的绝对路径
        :type File: str
        """
        self._DataSourceId = None
        self._File = None

    @property
    def DataSourceId(self):
        """CFS ID
        :rtype: str
        """
        return self._DataSourceId

    @DataSourceId.setter
    def DataSourceId(self, DataSourceId):
        self._DataSourceId = DataSourceId

    @property
    def File(self):
        """文件在cfs上的绝对路径
        :rtype: str
        """
        return self._File

    @File.setter
    def File(self, File):
        self._File = File


    def _deserialize(self, params):
        self._DataSourceId = params.get("DataSourceId")
        self._File = params.get("File")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFilePreviewUrlResponse(AbstractModel):
    """CreateFilePreviewUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Url: 预览路径
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Url = None
        self._RequestId = None

    @property
    def Url(self):
        """预览路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._RequestId = params.get("RequestId")


class CreateFlowRequest(AbstractModel):
    """CreateFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 工程ID
        :type ProjectId: str
        :param _FlowName: 工作流名称
        :type FlowName: str
        :param _Description: 工作流描述
        :type Description: str
        """
        self._ProjectId = None
        self._FlowName = None
        self._Description = None

    @property
    def ProjectId(self):
        """工程ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FlowName(self):
        """工作流名称
        :rtype: str
        """
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName

    @property
    def Description(self):
        """工作流描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FlowName = params.get("FlowName")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFlowResponse(AbstractModel):
    """CreateFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 工作流的Id
        :type FlowId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        """工作流的Id
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class CreateFlowTensorBoardUrlRequest(AbstractModel):
    """CreateFlowTensorBoardUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowRunNodeId: 运行节点id
        :type FlowRunNodeId: str
        """
        self._FlowRunNodeId = None

    @property
    def FlowRunNodeId(self):
        """运行节点id
        :rtype: str
        """
        return self._FlowRunNodeId

    @FlowRunNodeId.setter
    def FlowRunNodeId(self, FlowRunNodeId):
        self._FlowRunNodeId = FlowRunNodeId


    def _deserialize(self, params):
        self._FlowRunNodeId = params.get("FlowRunNodeId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFlowTensorBoardUrlResponse(AbstractModel):
    """CreateFlowTensorBoardUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TensorBoardUrl: 可视化建模的tensorboard url
        :type TensorBoardUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TensorBoardUrl = None
        self._RequestId = None

    @property
    def TensorBoardUrl(self):
        """可视化建模的tensorboard url
        :rtype: str
        """
        return self._TensorBoardUrl

    @TensorBoardUrl.setter
    def TensorBoardUrl(self, TensorBoardUrl):
        self._TensorBoardUrl = TensorBoardUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TensorBoardUrl = params.get("TensorBoardUrl")
        self._RequestId = params.get("RequestId")


class CreateInferGatewayRequest(AbstractModel):
    """CreateInferGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 用户推理服务客户端服务所在的VpcId
        :type VpcId: str
        :param _SubnetId: 用户推理服务客户端服务所在的SubnetId
        :type SubnetId: str
        """
        self._VpcId = None
        self._SubnetId = None

    @property
    def VpcId(self):
        """用户推理服务客户端服务所在的VpcId
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """用户推理服务客户端服务所在的SubnetId
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInferGatewayResponse(AbstractModel):
    """CreateInferGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLifecycleScriptRequest(AbstractModel):
    """CreateLifecycleScript请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 生命周期脚本名称。由中英文、数字、下划线"_"、短横"-"组成
        :type Name: str
        :param _CreateScript: 创建脚本，需要base64编码，base64编码后的长度不能超过16384
        :type CreateScript: str
        :param _StartScript: 动脚本, 需要base64编码，base64编码后的长度不能超过16384
        :type StartScript: str
        :param _Tags: 标签信息
        :type Tags: list of Tag
        """
        self._Name = None
        self._CreateScript = None
        self._StartScript = None
        self._Tags = None

    @property
    def Name(self):
        """生命周期脚本名称。由中英文、数字、下划线"_"、短横"-"组成
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def CreateScript(self):
        """创建脚本，需要base64编码，base64编码后的长度不能超过16384
        :rtype: str
        """
        return self._CreateScript

    @CreateScript.setter
    def CreateScript(self, CreateScript):
        self._CreateScript = CreateScript

    @property
    def StartScript(self):
        """动脚本, 需要base64编码，base64编码后的长度不能超过16384
        :rtype: str
        """
        return self._StartScript

    @StartScript.setter
    def StartScript(self, StartScript):
        self._StartScript = StartScript

    @property
    def Tags(self):
        """标签信息
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._CreateScript = params.get("CreateScript")
        self._StartScript = params.get("StartScript")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLifecycleScriptResponse(AbstractModel):
    """CreateLifecycleScript返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: id值
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        """id值
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CreateModelAccelerateTaskRequest(AbstractModel):
    """CreateModelAccelerateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelAccTaskName: 模型加速任务名称
        :type ModelAccTaskName: str
        :param _ModelSource: 模型来源（JOB/COS）
        :type ModelSource: str
        :param _ModelInputPath: 模型输入cos路径
        :type ModelInputPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _ModelOutputPath: 模型输出cos路径
        :type ModelOutputPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _AlgorithmFramework: 算法框架（废弃）
        :type AlgorithmFramework: str
        :param _ModelId: 模型ID，模型名称为空时必传
        :type ModelId: str
        :param _ModelName: 模型名称，模型ID为空时必传
        :type ModelName: str
        :param _ModelVersion: 模型版本，必传
        :type ModelVersion: str
        :param _OptimizationLevel: 优化级别 （NO_LOSS/FP16/INT8），默认FP16
        :type OptimizationLevel: str
        :param _ModelInputNum: input节点个数（废弃）
        :type ModelInputNum: int
        :param _ModelInputInfos: input节点信息（废弃）
        :type ModelInputInfos: list of ModelInputInfo
        :param _ModelFormat: 模型格式，必传（TORCH_SCRIPT/DETECTRON2/SAVED_MODEL/FROZEN_GRAPH/MMDETECTION/ONNX/HUGGING_FACE）
        :type ModelFormat: str
        :param _TensorInfos: 模型Tensor信息，必传
        :type TensorInfos: list of str
        :param _HyperParameter: 模型专业参数
        :type HyperParameter: :class:`tencentcloud.tione.v20211111.models.HyperParameter`
        :param _GPUType: GPU类型（T4/V100/A10），默认T4
        :type GPUType: str
        :param _AccEngineVersion: 加速引擎版本
        :type AccEngineVersion: str
        :param _Tags: 标签
        :type Tags: list of Tag
        :param _ModelSignature: SavedModel保存时配置的签名
        :type ModelSignature: str
        :param _FrameworkVersion: 加速引擎对应的框架版本
        :type FrameworkVersion: str
        :param _ResourceGroupId: 资源组Id
        :type ResourceGroupId: str
        :param _ResourceGroupName: 资源组名称
        :type ResourceGroupName: str
        :param _ResourceGroupSWType: 资源组类型
        :type ResourceGroupSWType: str
        """
        self._ModelAccTaskName = None
        self._ModelSource = None
        self._ModelInputPath = None
        self._ModelOutputPath = None
        self._AlgorithmFramework = None
        self._ModelId = None
        self._ModelName = None
        self._ModelVersion = None
        self._OptimizationLevel = None
        self._ModelInputNum = None
        self._ModelInputInfos = None
        self._ModelFormat = None
        self._TensorInfos = None
        self._HyperParameter = None
        self._GPUType = None
        self._AccEngineVersion = None
        self._Tags = None
        self._ModelSignature = None
        self._FrameworkVersion = None
        self._ResourceGroupId = None
        self._ResourceGroupName = None
        self._ResourceGroupSWType = None

    @property
    def ModelAccTaskName(self):
        """模型加速任务名称
        :rtype: str
        """
        return self._ModelAccTaskName

    @ModelAccTaskName.setter
    def ModelAccTaskName(self, ModelAccTaskName):
        self._ModelAccTaskName = ModelAccTaskName

    @property
    def ModelSource(self):
        """模型来源（JOB/COS）
        :rtype: str
        """
        return self._ModelSource

    @ModelSource.setter
    def ModelSource(self, ModelSource):
        self._ModelSource = ModelSource

    @property
    def ModelInputPath(self):
        """模型输入cos路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._ModelInputPath

    @ModelInputPath.setter
    def ModelInputPath(self, ModelInputPath):
        self._ModelInputPath = ModelInputPath

    @property
    def ModelOutputPath(self):
        """模型输出cos路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._ModelOutputPath

    @ModelOutputPath.setter
    def ModelOutputPath(self, ModelOutputPath):
        self._ModelOutputPath = ModelOutputPath

    @property
    def AlgorithmFramework(self):
        """算法框架（废弃）
        :rtype: str
        """
        return self._AlgorithmFramework

    @AlgorithmFramework.setter
    def AlgorithmFramework(self, AlgorithmFramework):
        self._AlgorithmFramework = AlgorithmFramework

    @property
    def ModelId(self):
        """模型ID，模型名称为空时必传
        :rtype: str
        """
        return self._ModelId

    @ModelId.setter
    def ModelId(self, ModelId):
        self._ModelId = ModelId

    @property
    def ModelName(self):
        """模型名称，模型ID为空时必传
        :rtype: str
        """
        return self._ModelName

    @ModelName.setter
    def ModelName(self, ModelName):
        self._ModelName = ModelName

    @property
    def ModelVersion(self):
        """模型版本，必传
        :rtype: str
        """
        return self._ModelVersion

    @ModelVersion.setter
    def ModelVersion(self, ModelVersion):
        self._ModelVersion = ModelVersion

    @property
    def OptimizationLevel(self):
        """优化级别 （NO_LOSS/FP16/INT8），默认FP16
        :rtype: str
        """
        return self._OptimizationLevel

    @OptimizationLevel.setter
    def OptimizationLevel(self, OptimizationLevel):
        self._OptimizationLevel = OptimizationLevel

    @property
    def ModelInputNum(self):
        """input节点个数（废弃）
        :rtype: int
        """
        return self._ModelInputNum

    @ModelInputNum.setter
    def ModelInputNum(self, ModelInputNum):
        self._ModelInputNum = ModelInputNum

    @property
    def ModelInputInfos(self):
        """input节点信息（废弃）
        :rtype: list of ModelInputInfo
        """
        return self._ModelInputInfos

    @ModelInputInfos.setter
    def ModelInputInfos(self, ModelInputInfos):
        self._ModelInputInfos = ModelInputInfos

    @property
    def ModelFormat(self):
        """模型格式，必传（TORCH_SCRIPT/DETECTRON2/SAVED_MODEL/FROZEN_GRAPH/MMDETECTION/ONNX/HUGGING_FACE）
        :rtype: str
        """
        return self._ModelFormat

    @ModelFormat.setter
    def ModelFormat(self, ModelFormat):
        self._ModelFormat = ModelFormat

    @property
    def TensorInfos(self):
        """模型Tensor信息，必传
        :rtype: list of str
        """
        return self._TensorInfos

    @TensorInfos.setter
    def TensorInfos(self, TensorInfos):
        self._TensorInfos = TensorInfos

    @property
    def HyperParameter(self):
        """模型专业参数
        :rtype: :class:`tencentcloud.tione.v20211111.models.HyperParameter`
        """
        return self._HyperParameter

    @HyperParameter.setter
    def HyperParameter(self, HyperParameter):
        self._HyperParameter = HyperParameter

    @property
    def GPUType(self):
        """GPU类型（T4/V100/A10），默认T4
        :rtype: str
        """
        return self._GPUType

    @GPUType.setter
    def GPUType(self, GPUType):
        self._GPUType = GPUType

    @property
    def AccEngineVersion(self):
        """加速引擎版本
        :rtype: str
        """
        return self._AccEngineVersion

    @AccEngineVersion.setter
    def AccEngineVersion(self, AccEngineVersion):
        self._AccEngineVersion = AccEngineVersion

    @property
    def Tags(self):
        """标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ModelSignature(self):
        """SavedModel保存时配置的签名
        :rtype: str
        """
        return self._ModelSignature

    @ModelSignature.setter
    def ModelSignature(self, ModelSignature):
        self._ModelSignature = ModelSignature

    @property
    def FrameworkVersion(self):
        """加速引擎对应的框架版本
        :rtype: str
        """
        return self._FrameworkVersion

    @FrameworkVersion.setter
    def FrameworkVersion(self, FrameworkVersion):
        self._FrameworkVersion = FrameworkVersion

    @property
    def ResourceGroupId(self):
        """资源组Id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceGroupName(self):
        """资源组名称
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def ResourceGroupSWType(self):
        """资源组类型
        :rtype: str
        """
        return self._ResourceGroupSWType

    @ResourceGroupSWType.setter
    def ResourceGroupSWType(self, ResourceGroupSWType):
        self._ResourceGroupSWType = ResourceGroupSWType


    def _deserialize(self, params):
        self._ModelAccTaskName = params.get("ModelAccTaskName")
        self._ModelSource = params.get("ModelSource")
        if params.get("ModelInputPath") is not None:
            self._ModelInputPath = CosPathInfo()
            self._ModelInputPath._deserialize(params.get("ModelInputPath"))
        if params.get("ModelOutputPath") is not None:
            self._ModelOutputPath = CosPathInfo()
            self._ModelOutputPath._deserialize(params.get("ModelOutputPath"))
        self._AlgorithmFramework = params.get("AlgorithmFramework")
        self._ModelId = params.get("ModelId")
        self._ModelName = params.get("ModelName")
        self._ModelVersion = params.get("ModelVersion")
        self._OptimizationLevel = params.get("OptimizationLevel")
        self._ModelInputNum = params.get("ModelInputNum")
        if params.get("ModelInputInfos") is not None:
            self._ModelInputInfos = []
            for item in params.get("ModelInputInfos"):
                obj = ModelInputInfo()
                obj._deserialize(item)
                self._ModelInputInfos.append(obj)
        self._ModelFormat = params.get("ModelFormat")
        self._TensorInfos = params.get("TensorInfos")
        if params.get("HyperParameter") is not None:
            self._HyperParameter = HyperParameter()
            self._HyperParameter._deserialize(params.get("HyperParameter"))
        self._GPUType = params.get("GPUType")
        self._AccEngineVersion = params.get("AccEngineVersion")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._ModelSignature = params.get("ModelSignature")
        self._FrameworkVersion = params.get("FrameworkVersion")
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ResourceGroupName = params.get("ResourceGroupName")
        self._ResourceGroupSWType = params.get("ResourceGroupSWType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateModelAccelerateTaskResponse(AbstractModel):
    """CreateModelAccelerateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelAccTaskId: 模型加速任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelAccTaskId: str
        :param _AsyncTaskId: 异步任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AsyncTaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ModelAccTaskId = None
        self._AsyncTaskId = None
        self._RequestId = None

    @property
    def ModelAccTaskId(self):
        """模型加速任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModelAccTaskId

    @ModelAccTaskId.setter
    def ModelAccTaskId(self, ModelAccTaskId):
        self._ModelAccTaskId = ModelAccTaskId

    @property
    def AsyncTaskId(self):
        """异步任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AsyncTaskId

    @AsyncTaskId.setter
    def AsyncTaskId(self, AsyncTaskId):
        self._AsyncTaskId = AsyncTaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ModelAccTaskId = params.get("ModelAccTaskId")
        self._AsyncTaskId = params.get("AsyncTaskId")
        self._RequestId = params.get("RequestId")


class CreateModelRequest(AbstractModel):
    """CreateModel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 模型名称
        :type Name: str
        :param _ModelStorageInfo: 模型存储信息
        :type ModelStorageInfo: :class:`tencentcloud.tione.v20211111.models.ModelStorageInfo`
        :param _Tags: 模型资源标签
        :type Tags: list of Tag
        :param _ModelTags: 模型标签列表
        :type ModelTags: list of str
        """
        self._Name = None
        self._ModelStorageInfo = None
        self._Tags = None
        self._ModelTags = None

    @property
    def Name(self):
        """模型名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ModelStorageInfo(self):
        """模型存储信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.ModelStorageInfo`
        """
        return self._ModelStorageInfo

    @ModelStorageInfo.setter
    def ModelStorageInfo(self, ModelStorageInfo):
        self._ModelStorageInfo = ModelStorageInfo

    @property
    def Tags(self):
        """模型资源标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ModelTags(self):
        """模型标签列表
        :rtype: list of str
        """
        return self._ModelTags

    @ModelTags.setter
    def ModelTags(self, ModelTags):
        self._ModelTags = ModelTags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("ModelStorageInfo") is not None:
            self._ModelStorageInfo = ModelStorageInfo()
            self._ModelStorageInfo._deserialize(params.get("ModelStorageInfo"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._ModelTags = params.get("ModelTags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateModelResponse(AbstractModel):
    """CreateModel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelId: 模型Id
        :type ModelId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ModelId = None
        self._RequestId = None

    @property
    def ModelId(self):
        """模型Id
        :rtype: str
        """
        return self._ModelId

    @ModelId.setter
    def ModelId(self, ModelId):
        self._ModelId = ModelId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ModelId = params.get("ModelId")
        self._RequestId = params.get("RequestId")


class CreateModelServicePodUrlRequest(AbstractModel):
    """CreateModelServicePodUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceId: 服务id
        :type ServiceId: str
        :param _PodName: pod 名称
        :type PodName: str
        """
        self._ServiceId = None
        self._PodName = None

    @property
    def ServiceId(self):
        """服务id
        :rtype: str
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def PodName(self):
        """pod 名称
        :rtype: str
        """
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName


    def _deserialize(self, params):
        self._ServiceId = params.get("ServiceId")
        self._PodName = params.get("PodName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateModelServicePodUrlResponse(AbstractModel):
    """CreateModelServicePodUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Url: pod 登陆url
        :type Url: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Url = None
        self._RequestId = None

    @property
    def Url(self):
        """pod 登陆url
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._RequestId = params.get("RequestId")


class CreateModelServiceRequest(AbstractModel):
    """CreateModelService请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceGroupId: 新增版本时需要填写
        :type ServiceGroupId: str
        :param _ServiceGroupName: 不超过60个字，仅支持英文、数字、下划线"_"、短横"-"，只能以英文、数字开头
        :type ServiceGroupName: str
        :param _ServiceDescription: 模型服务的描述
        :type ServiceDescription: str
        :param _ChargeType: 付费模式,有 PREPAID （包年包月）和 POSTPAID_BY_HOUR（按量付费）
        :type ChargeType: str
        :param _ResourceGroupId: 预付费模式下所属的资源组id，同服务组下唯一
        :type ResourceGroupId: str
        :param _ModelInfo: 模型信息，需要挂载模型时填写
        :type ModelInfo: :class:`tencentcloud.tione.v20211111.models.ModelInfo`
        :param _ImageInfo: 镜像信息，配置服务运行所需的镜像地址等信息
        :type ImageInfo: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        :param _Env: 环境变量，可选参数，用于配置容器中的环境变量
        :type Env: list of EnvVar
        :param _Resources: 资源描述，指定包年包月模式下的cpu,mem,gpu等信息，后付费无需填写
        :type Resources: :class:`tencentcloud.tione.v20211111.models.ResourceInfo`
        :param _InstanceType: 使用DescribeBillingSpecs接口返回的规格列表中的值，或者参考实例列表:
TI.S.MEDIUM.POST	2C4G
TI.S.LARGE.POST	4C8G
TI.S.2XLARGE16.POST	8C16G
TI.S.2XLARGE32.POST	8C32G
TI.S.4XLARGE32.POST	16C32G
TI.S.4XLARGE64.POST	16C64G
TI.S.6XLARGE48.POST	24C48G
TI.S.6XLARGE96.POST	24C96G
TI.S.8XLARGE64.POST	32C64G
TI.S.8XLARGE128.POST 32C128G
TI.GN7.LARGE20.POST	4C20G T4*1/4
TI.GN7.2XLARGE40.POST	10C40G T4*1/2
TI.GN7.2XLARGE32.POST	8C32G T4*1
TI.GN7.5XLARGE80.POST	20C80G T4*1
TI.GN7.8XLARGE128.POST	32C128G T4*1
TI.GN7.10XLARGE160.POST	40C160G T4*2
TI.GN7.20XLARGE320.POST	80C320G T4*4
        :type InstanceType: str
        :param _ScaleMode: 扩缩容类型 支持：自动 - "AUTO", 手动 - "MANUAL",默认为MANUAL
        :type ScaleMode: str
        :param _Replicas: 实例数量, 不同计费模式和调节模式下对应关系如下
PREPAID 和 POSTPAID_BY_HOUR:
手动调节模式下对应 实例数量
自动调节模式下对应 基于时间的默认策略的实例数量
HYBRID_PAID:
后付费实例手动调节模式下对应 实例数量
后付费实例自动调节模式下对应 时间策略的默认策略的实例数量
        :type Replicas: int
        :param _HorizontalPodAutoscaler: 自动伸缩信息
        :type HorizontalPodAutoscaler: :class:`tencentcloud.tione.v20211111.models.HorizontalPodAutoscaler`
        :param _LogEnable: 是否开启日志投递，开启后需填写配置投递到指定cls
        :type LogEnable: bool
        :param _LogConfig: 日志配置，需要投递服务日志到指定cls时填写
        :type LogConfig: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        :param _AuthorizationEnable: 是否开启接口鉴权，开启后自动生成token信息，访问需要token鉴权
        :type AuthorizationEnable: bool
        :param _Tags: 腾讯云标签
        :type Tags: list of Tag
        :param _NewVersion: 是否新增版本
        :type NewVersion: bool
        :param _CronScaleJobs: 定时任务配置，使用定时策略时填写
        :type CronScaleJobs: list of CronScaleJob
        :param _ScaleStrategy: 自动伸缩策略配置 HPA : 通过HPA进行弹性伸缩 CRON 通过定时任务进行伸缩
        :type ScaleStrategy: str
        :param _HybridBillingPrepaidReplicas: 计费模式[HYBRID_PAID]时生效, 用于标识混合计费模式下的预付费实例数
        :type HybridBillingPrepaidReplicas: int
        :param _CreateSource: [AUTO_ML 自动学习，自动学习正式发布 AUTO_ML_FORMAL, DEFAULT 默认]
        :type CreateSource: str
        :param _ModelHotUpdateEnable: 是否开启模型的热更新。默认不开启
        :type ModelHotUpdateEnable: bool
        :param _ScheduledAction: 定时停止配置
        :type ScheduledAction: :class:`tencentcloud.tione.v20211111.models.ScheduledAction`
        :param _VolumeMount: 挂载配置，目前只支持CFS
        :type VolumeMount: :class:`tencentcloud.tione.v20211111.models.VolumeMount`
        :param _ServiceLimit: 服务限速限流相关配置
        :type ServiceLimit: :class:`tencentcloud.tione.v20211111.models.ServiceLimit`
        :param _CallbackUrl: 回调地址，用于回调创建服务状态信息，回调格式&内容详情见：[TI-ONE 接口回调说明](https://cloud.tencent.com/document/product/851/84292)
        :type CallbackUrl: str
        :param _ModelTurboEnable: 是否开启模型的加速, 仅对StableDiffusion(动态加速)格式的模型有效。
        :type ModelTurboEnable: bool
        :param _ServiceCategory: 服务分类
        :type ServiceCategory: str
        :param _Command: 服务的启动命令，如遇特殊字符导致配置失败，可使用CommandBase64参数
        :type Command: str
        :param _ServiceEIP: 是否开启TIONE内网访问外部，此功能仅支持后付费机型与从TIONE平台购买的预付费机型；使用从CVM选择资源组时此配置不生效。
        :type ServiceEIP: :class:`tencentcloud.tione.v20211111.models.ServiceEIP`
        :param _CommandBase64: 服务的启动命令，以base64格式进行输入，与Command同时配置时，仅当前参数生效
        :type CommandBase64: str
        :param _ServicePort: 服务端口，仅在非内置镜像时生效，默认8501。不支持输入8501-8510,6006,9092
        :type ServicePort: int
        :param _SourceTaskInfo: 源任务信息
        :type SourceTaskInfo: :class:`tencentcloud.tione.v20211111.models.SourceTaskInfo`
        :param _DeployType: 服务的部署类型 [STANDARD 标准部署，DIST 分布式多机部署] 默认STANDARD
        :type DeployType: str
        :param _InstancePerReplicas: 单副本下的实例数，仅在部署类型为DIST时生效，默认1
        :type InstancePerReplicas: int
        :param _MaxRetryTimes: 服务首次启动时的最大重试次数，1以下表示不限制
        :type MaxRetryTimes: int
        :param _TerminationGracePeriodSeconds: 30
        :type TerminationGracePeriodSeconds: int
        :param _PreStopCommand: ["sleep","60"]
        :type PreStopCommand: list of str
        :param _Roles: 多角色配置
        :type Roles: list of RoleSpec
        """
        self._ServiceGroupId = None
        self._ServiceGroupName = None
        self._ServiceDescription = None
        self._ChargeType = None
        self._ResourceGroupId = None
        self._ModelInfo = None
        self._ImageInfo = None
        self._Env = None
        self._Resources = None
        self._InstanceType = None
        self._ScaleMode = None
        self._Replicas = None
        self._HorizontalPodAutoscaler = None
        self._LogEnable = None
        self._LogConfig = None
        self._AuthorizationEnable = None
        self._Tags = None
        self._NewVersion = None
        self._CronScaleJobs = None
        self._ScaleStrategy = None
        self._HybridBillingPrepaidReplicas = None
        self._CreateSource = None
        self._ModelHotUpdateEnable = None
        self._ScheduledAction = None
        self._VolumeMount = None
        self._ServiceLimit = None
        self._CallbackUrl = None
        self._ModelTurboEnable = None
        self._ServiceCategory = None
        self._Command = None
        self._ServiceEIP = None
        self._CommandBase64 = None
        self._ServicePort = None
        self._SourceTaskInfo = None
        self._DeployType = None
        self._InstancePerReplicas = None
        self._MaxRetryTimes = None
        self._TerminationGracePeriodSeconds = None
        self._PreStopCommand = None
        self._Roles = None

    @property
    def ServiceGroupId(self):
        """新增版本时需要填写
        :rtype: str
        """
        return self._ServiceGroupId

    @ServiceGroupId.setter
    def ServiceGroupId(self, ServiceGroupId):
        self._ServiceGroupId = ServiceGroupId

    @property
    def ServiceGroupName(self):
        """不超过60个字，仅支持英文、数字、下划线"_"、短横"-"，只能以英文、数字开头
        :rtype: str
        """
        return self._ServiceGroupName

    @ServiceGroupName.setter
    def ServiceGroupName(self, ServiceGroupName):
        self._ServiceGroupName = ServiceGroupName

    @property
    def ServiceDescription(self):
        """模型服务的描述
        :rtype: str
        """
        return self._ServiceDescription

    @ServiceDescription.setter
    def ServiceDescription(self, ServiceDescription):
        self._ServiceDescription = ServiceDescription

    @property
    def ChargeType(self):
        """付费模式,有 PREPAID （包年包月）和 POSTPAID_BY_HOUR（按量付费）
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def ResourceGroupId(self):
        """预付费模式下所属的资源组id，同服务组下唯一
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ModelInfo(self):
        """模型信息，需要挂载模型时填写
        :rtype: :class:`tencentcloud.tione.v20211111.models.ModelInfo`
        """
        return self._ModelInfo

    @ModelInfo.setter
    def ModelInfo(self, ModelInfo):
        self._ModelInfo = ModelInfo

    @property
    def ImageInfo(self):
        """镜像信息，配置服务运行所需的镜像地址等信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        """
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Env(self):
        """环境变量，可选参数，用于配置容器中的环境变量
        :rtype: list of EnvVar
        """
        return self._Env

    @Env.setter
    def Env(self, Env):
        self._Env = Env

    @property
    def Resources(self):
        """资源描述，指定包年包月模式下的cpu,mem,gpu等信息，后付费无需填写
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceInfo`
        """
        return self._Resources

    @Resources.setter
    def Resources(self, Resources):
        self._Resources = Resources

    @property
    def InstanceType(self):
        """使用DescribeBillingSpecs接口返回的规格列表中的值，或者参考实例列表:
TI.S.MEDIUM.POST	2C4G
TI.S.LARGE.POST	4C8G
TI.S.2XLARGE16.POST	8C16G
TI.S.2XLARGE32.POST	8C32G
TI.S.4XLARGE32.POST	16C32G
TI.S.4XLARGE64.POST	16C64G
TI.S.6XLARGE48.POST	24C48G
TI.S.6XLARGE96.POST	24C96G
TI.S.8XLARGE64.POST	32C64G
TI.S.8XLARGE128.POST 32C128G
TI.GN7.LARGE20.POST	4C20G T4*1/4
TI.GN7.2XLARGE40.POST	10C40G T4*1/2
TI.GN7.2XLARGE32.POST	8C32G T4*1
TI.GN7.5XLARGE80.POST	20C80G T4*1
TI.GN7.8XLARGE128.POST	32C128G T4*1
TI.GN7.10XLARGE160.POST	40C160G T4*2
TI.GN7.20XLARGE320.POST	80C320G T4*4
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def ScaleMode(self):
        """扩缩容类型 支持：自动 - "AUTO", 手动 - "MANUAL",默认为MANUAL
        :rtype: str
        """
        return self._ScaleMode

    @ScaleMode.setter
    def ScaleMode(self, ScaleMode):
        self._ScaleMode = ScaleMode

    @property
    def Replicas(self):
        """实例数量, 不同计费模式和调节模式下对应关系如下
PREPAID 和 POSTPAID_BY_HOUR:
手动调节模式下对应 实例数量
自动调节模式下对应 基于时间的默认策略的实例数量
HYBRID_PAID:
后付费实例手动调节模式下对应 实例数量
后付费实例自动调节模式下对应 时间策略的默认策略的实例数量
        :rtype: int
        """
        return self._Replicas

    @Replicas.setter
    def Replicas(self, Replicas):
        self._Replicas = Replicas

    @property
    def HorizontalPodAutoscaler(self):
        """自动伸缩信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.HorizontalPodAutoscaler`
        """
        return self._HorizontalPodAutoscaler

    @HorizontalPodAutoscaler.setter
    def HorizontalPodAutoscaler(self, HorizontalPodAutoscaler):
        self._HorizontalPodAutoscaler = HorizontalPodAutoscaler

    @property
    def LogEnable(self):
        """是否开启日志投递，开启后需填写配置投递到指定cls
        :rtype: bool
        """
        return self._LogEnable

    @LogEnable.setter
    def LogEnable(self, LogEnable):
        self._LogEnable = LogEnable

    @property
    def LogConfig(self):
        """日志配置，需要投递服务日志到指定cls时填写
        :rtype: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def AuthorizationEnable(self):
        """是否开启接口鉴权，开启后自动生成token信息，访问需要token鉴权
        :rtype: bool
        """
        return self._AuthorizationEnable

    @AuthorizationEnable.setter
    def AuthorizationEnable(self, AuthorizationEnable):
        self._AuthorizationEnable = AuthorizationEnable

    @property
    def Tags(self):
        """腾讯云标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def NewVersion(self):
        """是否新增版本
        :rtype: bool
        """
        return self._NewVersion

    @NewVersion.setter
    def NewVersion(self, NewVersion):
        self._NewVersion = NewVersion

    @property
    def CronScaleJobs(self):
        """定时任务配置，使用定时策略时填写
        :rtype: list of CronScaleJob
        """
        return self._CronScaleJobs

    @CronScaleJobs.setter
    def CronScaleJobs(self, CronScaleJobs):
        self._CronScaleJobs = CronScaleJobs

    @property
    def ScaleStrategy(self):
        """自动伸缩策略配置 HPA : 通过HPA进行弹性伸缩 CRON 通过定时任务进行伸缩
        :rtype: str
        """
        return self._ScaleStrategy

    @ScaleStrategy.setter
    def ScaleStrategy(self, ScaleStrategy):
        self._ScaleStrategy = ScaleStrategy

    @property
    def HybridBillingPrepaidReplicas(self):
        """计费模式[HYBRID_PAID]时生效, 用于标识混合计费模式下的预付费实例数
        :rtype: int
        """
        return self._HybridBillingPrepaidReplicas

    @HybridBillingPrepaidReplicas.setter
    def HybridBillingPrepaidReplicas(self, HybridBillingPrepaidReplicas):
        self._HybridBillingPrepaidReplicas = HybridBillingPrepaidReplicas

    @property
    def CreateSource(self):
        """[AUTO_ML 自动学习，自动学习正式发布 AUTO_ML_FORMAL, DEFAULT 默认]
        :rtype: str
        """
        return self._CreateSource

    @CreateSource.setter
    def CreateSource(self, CreateSource):
        self._CreateSource = CreateSource

    @property
    def ModelHotUpdateEnable(self):
        """是否开启模型的热更新。默认不开启
        :rtype: bool
        """
        return self._ModelHotUpdateEnable

    @ModelHotUpdateEnable.setter
    def ModelHotUpdateEnable(self, ModelHotUpdateEnable):
        self._ModelHotUpdateEnable = ModelHotUpdateEnable

    @property
    def ScheduledAction(self):
        """定时停止配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.ScheduledAction`
        """
        return self._ScheduledAction

    @ScheduledAction.setter
    def ScheduledAction(self, ScheduledAction):
        self._ScheduledAction = ScheduledAction

    @property
    def VolumeMount(self):
        """挂载配置，目前只支持CFS
        :rtype: :class:`tencentcloud.tione.v20211111.models.VolumeMount`
        """
        return self._VolumeMount

    @VolumeMount.setter
    def VolumeMount(self, VolumeMount):
        self._VolumeMount = VolumeMount

    @property
    def ServiceLimit(self):
        """服务限速限流相关配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.ServiceLimit`
        """
        return self._ServiceLimit

    @ServiceLimit.setter
    def ServiceLimit(self, ServiceLimit):
        self._ServiceLimit = ServiceLimit

    @property
    def CallbackUrl(self):
        """回调地址，用于回调创建服务状态信息，回调格式&内容详情见：[TI-ONE 接口回调说明](https://cloud.tencent.com/document/product/851/84292)
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def ModelTurboEnable(self):
        """是否开启模型的加速, 仅对StableDiffusion(动态加速)格式的模型有效。
        :rtype: bool
        """
        return self._ModelTurboEnable

    @ModelTurboEnable.setter
    def ModelTurboEnable(self, ModelTurboEnable):
        self._ModelTurboEnable = ModelTurboEnable

    @property
    def ServiceCategory(self):
        """服务分类
        :rtype: str
        """
        return self._ServiceCategory

    @ServiceCategory.setter
    def ServiceCategory(self, ServiceCategory):
        self._ServiceCategory = ServiceCategory

    @property
    def Command(self):
        """服务的启动命令，如遇特殊字符导致配置失败，可使用CommandBase64参数
        :rtype: str
        """
        return self._Command

    @Command.setter
    def Command(self, Command):
        self._Command = Command

    @property
    def ServiceEIP(self):
        """是否开启TIONE内网访问外部，此功能仅支持后付费机型与从TIONE平台购买的预付费机型；使用从CVM选择资源组时此配置不生效。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ServiceEIP`
        """
        return self._ServiceEIP

    @ServiceEIP.setter
    def ServiceEIP(self, ServiceEIP):
        self._ServiceEIP = ServiceEIP

    @property
    def CommandBase64(self):
        """服务的启动命令，以base64格式进行输入，与Command同时配置时，仅当前参数生效
        :rtype: str
        """
        return self._CommandBase64

    @CommandBase64.setter
    def CommandBase64(self, CommandBase64):
        self._CommandBase64 = CommandBase64

    @property
    def ServicePort(self):
        """服务端口，仅在非内置镜像时生效，默认8501。不支持输入8501-8510,6006,9092
        :rtype: int
        """
        return self._ServicePort

    @ServicePort.setter
    def ServicePort(self, ServicePort):
        self._ServicePort = ServicePort

    @property
    def SourceTaskInfo(self):
        """源任务信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.SourceTaskInfo`
        """
        return self._SourceTaskInfo

    @SourceTaskInfo.setter
    def SourceTaskInfo(self, SourceTaskInfo):
        self._SourceTaskInfo = SourceTaskInfo

    @property
    def DeployType(self):
        """服务的部署类型 [STANDARD 标准部署，DIST 分布式多机部署] 默认STANDARD
        :rtype: str
        """
        return self._DeployType

    @DeployType.setter
    def DeployType(self, DeployType):
        self._DeployType = DeployType

    @property
    def InstancePerReplicas(self):
        """单副本下的实例数，仅在部署类型为DIST时生效，默认1
        :rtype: int
        """
        return self._InstancePerReplicas

    @InstancePerReplicas.setter
    def InstancePerReplicas(self, InstancePerReplicas):
        self._InstancePerReplicas = InstancePerReplicas

    @property
    def MaxRetryTimes(self):
        """服务首次启动时的最大重试次数，1以下表示不限制
        :rtype: int
        """
        return self._MaxRetryTimes

    @MaxRetryTimes.setter
    def MaxRetryTimes(self, MaxRetryTimes):
        self._MaxRetryTimes = MaxRetryTimes

    @property
    def TerminationGracePeriodSeconds(self):
        """30
        :rtype: int
        """
        return self._TerminationGracePeriodSeconds

    @TerminationGracePeriodSeconds.setter
    def TerminationGracePeriodSeconds(self, TerminationGracePeriodSeconds):
        self._TerminationGracePeriodSeconds = TerminationGracePeriodSeconds

    @property
    def PreStopCommand(self):
        """["sleep","60"]
        :rtype: list of str
        """
        return self._PreStopCommand

    @PreStopCommand.setter
    def PreStopCommand(self, PreStopCommand):
        self._PreStopCommand = PreStopCommand

    @property
    def Roles(self):
        """多角色配置
        :rtype: list of RoleSpec
        """
        return self._Roles

    @Roles.setter
    def Roles(self, Roles):
        self._Roles = Roles


    def _deserialize(self, params):
        self._ServiceGroupId = params.get("ServiceGroupId")
        self._ServiceGroupName = params.get("ServiceGroupName")
        self._ServiceDescription = params.get("ServiceDescription")
        self._ChargeType = params.get("ChargeType")
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("ModelInfo") is not None:
            self._ModelInfo = ModelInfo()
            self._ModelInfo._deserialize(params.get("ModelInfo"))
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        if params.get("Env") is not None:
            self._Env = []
            for item in params.get("Env"):
                obj = EnvVar()
                obj._deserialize(item)
                self._Env.append(obj)
        if params.get("Resources") is not None:
            self._Resources = ResourceInfo()
            self._Resources._deserialize(params.get("Resources"))
        self._InstanceType = params.get("InstanceType")
        self._ScaleMode = params.get("ScaleMode")
        self._Replicas = params.get("Replicas")
        if params.get("HorizontalPodAutoscaler") is not None:
            self._HorizontalPodAutoscaler = HorizontalPodAutoscaler()
            self._HorizontalPodAutoscaler._deserialize(params.get("HorizontalPodAutoscaler"))
        self._LogEnable = params.get("LogEnable")
        if params.get("LogConfig") is not None:
            self._LogConfig = LogConfig()
            self._LogConfig._deserialize(params.get("LogConfig"))
        self._AuthorizationEnable = params.get("AuthorizationEnable")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._NewVersion = params.get("NewVersion")
        if params.get("CronScaleJobs") is not None:
            self._CronScaleJobs = []
            for item in params.get("CronScaleJobs"):
                obj = CronScaleJob()
                obj._deserialize(item)
                self._CronScaleJobs.append(obj)
        self._ScaleStrategy = params.get("ScaleStrategy")
        self._HybridBillingPrepaidReplicas = params.get("HybridBillingPrepaidReplicas")
        self._CreateSource = params.get("CreateSource")
        self._ModelHotUpdateEnable = params.get("ModelHotUpdateEnable")
        if params.get("ScheduledAction") is not None:
            self._ScheduledAction = ScheduledAction()
            self._ScheduledAction._deserialize(params.get("ScheduledAction"))
        if params.get("VolumeMount") is not None:
            self._VolumeMount = VolumeMount()
            self._VolumeMount._deserialize(params.get("VolumeMount"))
        if params.get("ServiceLimit") is not None:
            self._ServiceLimit = ServiceLimit()
            self._ServiceLimit._deserialize(params.get("ServiceLimit"))
        self._CallbackUrl = params.get("CallbackUrl")
        self._ModelTurboEnable = params.get("ModelTurboEnable")
        self._ServiceCategory = params.get("ServiceCategory")
        self._Command = params.get("Command")
        if params.get("ServiceEIP") is not None:
            self._ServiceEIP = ServiceEIP()
            self._ServiceEIP._deserialize(params.get("ServiceEIP"))
        self._CommandBase64 = params.get("CommandBase64")
        self._ServicePort = params.get("ServicePort")
        if params.get("SourceTaskInfo") is not None:
            self._SourceTaskInfo = SourceTaskInfo()
            self._SourceTaskInfo._deserialize(params.get("SourceTaskInfo"))
        self._DeployType = params.get("DeployType")
        self._InstancePerReplicas = params.get("InstancePerReplicas")
        self._MaxRetryTimes = params.get("MaxRetryTimes")
        self._TerminationGracePeriodSeconds = params.get("TerminationGracePeriodSeconds")
        self._PreStopCommand = params.get("PreStopCommand")
        if params.get("Roles") is not None:
            self._Roles = []
            for item in params.get("Roles"):
                obj = RoleSpec()
                obj._deserialize(item)
                self._Roles.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateModelServiceResponse(AbstractModel):
    """CreateModelService返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Service: 生成的模型服务
        :type Service: :class:`tencentcloud.tione.v20211111.models.Service`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Service = None
        self._RequestId = None

    @property
    def Service(self):
        """生成的模型服务
        :rtype: :class:`tencentcloud.tione.v20211111.models.Service`
        """
        return self._Service

    @Service.setter
    def Service(self, Service):
        self._Service = Service

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Service") is not None:
            self._Service = Service()
            self._Service._deserialize(params.get("Service"))
        self._RequestId = params.get("RequestId")


class CreateNotebookImageRequest(AbstractModel):
    """CreateNotebookImage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageInfo: 镜像信息
        :type ImageInfo: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        :param _NotebookId: notebook id
        :type NotebookId: str
        :param _Kernels: 要保存的kernel数组
        :type Kernels: list of str
        """
        self._ImageInfo = None
        self._NotebookId = None
        self._Kernels = None

    @property
    def ImageInfo(self):
        """镜像信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        """
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def NotebookId(self):
        """notebook id
        :rtype: str
        """
        return self._NotebookId

    @NotebookId.setter
    def NotebookId(self, NotebookId):
        self._NotebookId = NotebookId

    @property
    def Kernels(self):
        """要保存的kernel数组
        :rtype: list of str
        """
        return self._Kernels

    @Kernels.setter
    def Kernels(self, Kernels):
        self._Kernels = Kernels


    def _deserialize(self, params):
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._NotebookId = params.get("NotebookId")
        self._Kernels = params.get("Kernels")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNotebookImageResponse(AbstractModel):
    """CreateNotebookImage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNotebookRequest(AbstractModel):
    """CreateNotebook请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 名称。不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :type Name: str
        :param _ChargeType: 计算资源付费模式 ，可选值为：
PREPAID：预付费，即包年包月
POSTPAID_BY_HOUR：按小时后付费
        :type ChargeType: str
        :param _ResourceConf: 计算资源配置
        :type ResourceConf: :class:`tencentcloud.tione.v20211111.models.ResourceConf`
        :param _LogEnable: 是否上报日志
        :type LogEnable: bool
        :param _RootAccess: 是否ROOT权限
        :type RootAccess: bool
        :param _AutoStopping: 是否自动停止
        :type AutoStopping: bool
        :param _DirectInternetAccess: 是否访问公网
        :type DirectInternetAccess: bool
        :param _ResourceGroupId: 资源组ID(for预付费)
        :type ResourceGroupId: str
        :param _VpcId: Vpc-Id
        :type VpcId: str
        :param _SubnetId: 子网Id
        :type SubnetId: str
        :param _VolumeSourceType: 存储的类型。取值包含： 
FREE：预付费的免费存储
CLOUD_PREMIUM：高性能云硬盘
CLOUD_SSD：SSD云硬盘
CFS：CFS存储
CFS_TURBO：CFS Turbo存储
GooseFSx：GooseFSx存储
        :type VolumeSourceType: str
        :param _VolumeSizeInGB: 云硬盘存储卷大小，单位GB
        :type VolumeSizeInGB: int
        :param _VolumeSourceCFS: CFS存储的配置
        :type VolumeSourceCFS: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        :param _LogConfig: 日志配置
        :type LogConfig: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        :param _LifecycleScriptId: 生命周期脚本的ID
        :type LifecycleScriptId: str
        :param _DefaultCodeRepoId: 默认GIT存储库的ID
        :type DefaultCodeRepoId: str
        :param _AdditionalCodeRepoIds: 其他GIT存储库的ID，最多3个
        :type AdditionalCodeRepoIds: list of str
        :param _AutomaticStopTime: 自动停止时间，单位小时
        :type AutomaticStopTime: int
        :param _Tags: 标签配置
        :type Tags: list of Tag
        :param _DataConfigs: 数据配置，只支持WEDATA_HDFS存储类型
        :type DataConfigs: list of DataConfig
        :param _UserType: 用户类型
        :type UserType: str
        :param _UserDataInfo: 用户数据信息
        :type UserDataInfo: :class:`tencentcloud.tione.v20211111.models.UserDataInfo`
        :param _ImageInfo: 镜像信息
        :type ImageInfo: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        :param _ImageType: 镜像类型，包括SYSTEM、TCR、CCR
        :type ImageType: str
        :param _SSHConfig: SSH配置信息
        :type SSHConfig: :class:`tencentcloud.tione.v20211111.models.SSHConfig`
        :param _VolumeSourceGooseFS: GooseFS存储配置
        :type VolumeSourceGooseFS: :class:`tencentcloud.tione.v20211111.models.GooseFS`
        :param _DataPipelineTaskId: 数据构建任务ID
        :type DataPipelineTaskId: str
        :param _Envs: 自定义环境变量
        :type Envs: list of EnvVar
        """
        self._Name = None
        self._ChargeType = None
        self._ResourceConf = None
        self._LogEnable = None
        self._RootAccess = None
        self._AutoStopping = None
        self._DirectInternetAccess = None
        self._ResourceGroupId = None
        self._VpcId = None
        self._SubnetId = None
        self._VolumeSourceType = None
        self._VolumeSizeInGB = None
        self._VolumeSourceCFS = None
        self._LogConfig = None
        self._LifecycleScriptId = None
        self._DefaultCodeRepoId = None
        self._AdditionalCodeRepoIds = None
        self._AutomaticStopTime = None
        self._Tags = None
        self._DataConfigs = None
        self._UserType = None
        self._UserDataInfo = None
        self._ImageInfo = None
        self._ImageType = None
        self._SSHConfig = None
        self._VolumeSourceGooseFS = None
        self._DataPipelineTaskId = None
        self._Envs = None

    @property
    def Name(self):
        """名称。不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ChargeType(self):
        """计算资源付费模式 ，可选值为：
PREPAID：预付费，即包年包月
POSTPAID_BY_HOUR：按小时后付费
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def ResourceConf(self):
        """计算资源配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceConf`
        """
        return self._ResourceConf

    @ResourceConf.setter
    def ResourceConf(self, ResourceConf):
        self._ResourceConf = ResourceConf

    @property
    def LogEnable(self):
        """是否上报日志
        :rtype: bool
        """
        return self._LogEnable

    @LogEnable.setter
    def LogEnable(self, LogEnable):
        self._LogEnable = LogEnable

    @property
    def RootAccess(self):
        """是否ROOT权限
        :rtype: bool
        """
        return self._RootAccess

    @RootAccess.setter
    def RootAccess(self, RootAccess):
        self._RootAccess = RootAccess

    @property
    def AutoStopping(self):
        """是否自动停止
        :rtype: bool
        """
        return self._AutoStopping

    @AutoStopping.setter
    def AutoStopping(self, AutoStopping):
        self._AutoStopping = AutoStopping

    @property
    def DirectInternetAccess(self):
        """是否访问公网
        :rtype: bool
        """
        return self._DirectInternetAccess

    @DirectInternetAccess.setter
    def DirectInternetAccess(self, DirectInternetAccess):
        self._DirectInternetAccess = DirectInternetAccess

    @property
    def ResourceGroupId(self):
        """资源组ID(for预付费)
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def VpcId(self):
        """Vpc-Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网Id
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def VolumeSourceType(self):
        """存储的类型。取值包含： 
FREE：预付费的免费存储
CLOUD_PREMIUM：高性能云硬盘
CLOUD_SSD：SSD云硬盘
CFS：CFS存储
CFS_TURBO：CFS Turbo存储
GooseFSx：GooseFSx存储
        :rtype: str
        """
        return self._VolumeSourceType

    @VolumeSourceType.setter
    def VolumeSourceType(self, VolumeSourceType):
        self._VolumeSourceType = VolumeSourceType

    @property
    def VolumeSizeInGB(self):
        """云硬盘存储卷大小，单位GB
        :rtype: int
        """
        return self._VolumeSizeInGB

    @VolumeSizeInGB.setter
    def VolumeSizeInGB(self, VolumeSizeInGB):
        self._VolumeSizeInGB = VolumeSizeInGB

    @property
    def VolumeSourceCFS(self):
        """CFS存储的配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        """
        return self._VolumeSourceCFS

    @VolumeSourceCFS.setter
    def VolumeSourceCFS(self, VolumeSourceCFS):
        self._VolumeSourceCFS = VolumeSourceCFS

    @property
    def LogConfig(self):
        """日志配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def LifecycleScriptId(self):
        """生命周期脚本的ID
        :rtype: str
        """
        return self._LifecycleScriptId

    @LifecycleScriptId.setter
    def LifecycleScriptId(self, LifecycleScriptId):
        self._LifecycleScriptId = LifecycleScriptId

    @property
    def DefaultCodeRepoId(self):
        """默认GIT存储库的ID
        :rtype: str
        """
        return self._DefaultCodeRepoId

    @DefaultCodeRepoId.setter
    def DefaultCodeRepoId(self, DefaultCodeRepoId):
        self._DefaultCodeRepoId = DefaultCodeRepoId

    @property
    def AdditionalCodeRepoIds(self):
        """其他GIT存储库的ID，最多3个
        :rtype: list of str
        """
        return self._AdditionalCodeRepoIds

    @AdditionalCodeRepoIds.setter
    def AdditionalCodeRepoIds(self, AdditionalCodeRepoIds):
        self._AdditionalCodeRepoIds = AdditionalCodeRepoIds

    @property
    def AutomaticStopTime(self):
        """自动停止时间，单位小时
        :rtype: int
        """
        return self._AutomaticStopTime

    @AutomaticStopTime.setter
    def AutomaticStopTime(self, AutomaticStopTime):
        self._AutomaticStopTime = AutomaticStopTime

    @property
    def Tags(self):
        """标签配置
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def DataConfigs(self):
        """数据配置，只支持WEDATA_HDFS存储类型
        :rtype: list of DataConfig
        """
        return self._DataConfigs

    @DataConfigs.setter
    def DataConfigs(self, DataConfigs):
        self._DataConfigs = DataConfigs

    @property
    def UserType(self):
        """用户类型
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserDataInfo(self):
        """用户数据信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.UserDataInfo`
        """
        return self._UserDataInfo

    @UserDataInfo.setter
    def UserDataInfo(self, UserDataInfo):
        self._UserDataInfo = UserDataInfo

    @property
    def ImageInfo(self):
        """镜像信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        """
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def ImageType(self):
        """镜像类型，包括SYSTEM、TCR、CCR
        :rtype: str
        """
        return self._ImageType

    @ImageType.setter
    def ImageType(self, ImageType):
        self._ImageType = ImageType

    @property
    def SSHConfig(self):
        """SSH配置信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.SSHConfig`
        """
        return self._SSHConfig

    @SSHConfig.setter
    def SSHConfig(self, SSHConfig):
        self._SSHConfig = SSHConfig

    @property
    def VolumeSourceGooseFS(self):
        """GooseFS存储配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.GooseFS`
        """
        return self._VolumeSourceGooseFS

    @VolumeSourceGooseFS.setter
    def VolumeSourceGooseFS(self, VolumeSourceGooseFS):
        self._VolumeSourceGooseFS = VolumeSourceGooseFS

    @property
    def DataPipelineTaskId(self):
        """数据构建任务ID
        :rtype: str
        """
        return self._DataPipelineTaskId

    @DataPipelineTaskId.setter
    def DataPipelineTaskId(self, DataPipelineTaskId):
        self._DataPipelineTaskId = DataPipelineTaskId

    @property
    def Envs(self):
        """自定义环境变量
        :rtype: list of EnvVar
        """
        return self._Envs

    @Envs.setter
    def Envs(self, Envs):
        self._Envs = Envs


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._ChargeType = params.get("ChargeType")
        if params.get("ResourceConf") is not None:
            self._ResourceConf = ResourceConf()
            self._ResourceConf._deserialize(params.get("ResourceConf"))
        self._LogEnable = params.get("LogEnable")
        self._RootAccess = params.get("RootAccess")
        self._AutoStopping = params.get("AutoStopping")
        self._DirectInternetAccess = params.get("DirectInternetAccess")
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._VolumeSourceType = params.get("VolumeSourceType")
        self._VolumeSizeInGB = params.get("VolumeSizeInGB")
        if params.get("VolumeSourceCFS") is not None:
            self._VolumeSourceCFS = CFSConfig()
            self._VolumeSourceCFS._deserialize(params.get("VolumeSourceCFS"))
        if params.get("LogConfig") is not None:
            self._LogConfig = LogConfig()
            self._LogConfig._deserialize(params.get("LogConfig"))
        self._LifecycleScriptId = params.get("LifecycleScriptId")
        self._DefaultCodeRepoId = params.get("DefaultCodeRepoId")
        self._AdditionalCodeRepoIds = params.get("AdditionalCodeRepoIds")
        self._AutomaticStopTime = params.get("AutomaticStopTime")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("DataConfigs") is not None:
            self._DataConfigs = []
            for item in params.get("DataConfigs"):
                obj = DataConfig()
                obj._deserialize(item)
                self._DataConfigs.append(obj)
        self._UserType = params.get("UserType")
        if params.get("UserDataInfo") is not None:
            self._UserDataInfo = UserDataInfo()
            self._UserDataInfo._deserialize(params.get("UserDataInfo"))
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._ImageType = params.get("ImageType")
        if params.get("SSHConfig") is not None:
            self._SSHConfig = SSHConfig()
            self._SSHConfig._deserialize(params.get("SSHConfig"))
        if params.get("VolumeSourceGooseFS") is not None:
            self._VolumeSourceGooseFS = GooseFS()
            self._VolumeSourceGooseFS._deserialize(params.get("VolumeSourceGooseFS"))
        self._DataPipelineTaskId = params.get("DataPipelineTaskId")
        if params.get("Envs") is not None:
            self._Envs = []
            for item in params.get("Envs"):
                obj = EnvVar()
                obj._deserialize(item)
                self._Envs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNotebookResponse(AbstractModel):
    """CreateNotebook返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: notebook标志
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        """notebook标志
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CreateObjectiveEvaluationRequest(AbstractModel):
    """CreateObjectiveEvaluation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Datasets: [已废弃]请使用InputDatasets
        :type Datasets: list of CFSConfig
        :param _Models: 模型配置
        :type Models: list of EvalModel
        :param _Description: 描述
        :type Description: str
        :param _CreateSource: 创建来源
        :type CreateSource: str
        :param _ChargeType: 计费
        :type ChargeType: str
        :param _ResourceGroupId: 资源
        :type ResourceGroupId: str
        :param _Resources: 预付费资源
        :type Resources: :class:`tencentcloud.tione.v20211111.models.ResourceInfo`
        :param _InstanceType: 资源类型
        :type InstanceType: str
        :param _ResourceGroupName: 资源组名称
        :type ResourceGroupName: str
        :param _DeployType: 部署类型
        :type DeployType: str
        :param _InstancePerReplicas: 单副本下的实例数，仅在部署类型为DIST时生效，默认1
        :type InstancePerReplicas: int
        :param _Tags: 标签
        :type Tags: list of Tag
        :param _InputDatasets: 评测集
        :type InputDatasets: list of SimpleCFSConfig
        :param _InstanceTypeAlias: 后付费资源信息
        :type InstanceTypeAlias: str
        """
        self._Name = None
        self._Datasets = None
        self._Models = None
        self._Description = None
        self._CreateSource = None
        self._ChargeType = None
        self._ResourceGroupId = None
        self._Resources = None
        self._InstanceType = None
        self._ResourceGroupName = None
        self._DeployType = None
        self._InstancePerReplicas = None
        self._Tags = None
        self._InputDatasets = None
        self._InstanceTypeAlias = None

    @property
    def Name(self):
        """名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Datasets(self):
        """[已废弃]请使用InputDatasets
        :rtype: list of CFSConfig
        """
        return self._Datasets

    @Datasets.setter
    def Datasets(self, Datasets):
        self._Datasets = Datasets

    @property
    def Models(self):
        """模型配置
        :rtype: list of EvalModel
        """
        return self._Models

    @Models.setter
    def Models(self, Models):
        self._Models = Models

    @property
    def Description(self):
        """描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateSource(self):
        """创建来源
        :rtype: str
        """
        return self._CreateSource

    @CreateSource.setter
    def CreateSource(self, CreateSource):
        self._CreateSource = CreateSource

    @property
    def ChargeType(self):
        """计费
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def ResourceGroupId(self):
        """资源
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def Resources(self):
        """预付费资源
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceInfo`
        """
        return self._Resources

    @Resources.setter
    def Resources(self, Resources):
        self._Resources = Resources

    @property
    def InstanceType(self):
        """资源类型
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def ResourceGroupName(self):
        """资源组名称
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def DeployType(self):
        """部署类型
        :rtype: str
        """
        return self._DeployType

    @DeployType.setter
    def DeployType(self, DeployType):
        self._DeployType = DeployType

    @property
    def InstancePerReplicas(self):
        """单副本下的实例数，仅在部署类型为DIST时生效，默认1
        :rtype: int
        """
        return self._InstancePerReplicas

    @InstancePerReplicas.setter
    def InstancePerReplicas(self, InstancePerReplicas):
        self._InstancePerReplicas = InstancePerReplicas

    @property
    def Tags(self):
        """标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def InputDatasets(self):
        """评测集
        :rtype: list of SimpleCFSConfig
        """
        return self._InputDatasets

    @InputDatasets.setter
    def InputDatasets(self, InputDatasets):
        self._InputDatasets = InputDatasets

    @property
    def InstanceTypeAlias(self):
        """后付费资源信息
        :rtype: str
        """
        return self._InstanceTypeAlias

    @InstanceTypeAlias.setter
    def InstanceTypeAlias(self, InstanceTypeAlias):
        self._InstanceTypeAlias = InstanceTypeAlias


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("Datasets") is not None:
            self._Datasets = []
            for item in params.get("Datasets"):
                obj = CFSConfig()
                obj._deserialize(item)
                self._Datasets.append(obj)
        if params.get("Models") is not None:
            self._Models = []
            for item in params.get("Models"):
                obj = EvalModel()
                obj._deserialize(item)
                self._Models.append(obj)
        self._Description = params.get("Description")
        self._CreateSource = params.get("CreateSource")
        self._ChargeType = params.get("ChargeType")
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("Resources") is not None:
            self._Resources = ResourceInfo()
            self._Resources._deserialize(params.get("Resources"))
        self._InstanceType = params.get("InstanceType")
        self._ResourceGroupName = params.get("ResourceGroupName")
        self._DeployType = params.get("DeployType")
        self._InstancePerReplicas = params.get("InstancePerReplicas")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("InputDatasets") is not None:
            self._InputDatasets = []
            for item in params.get("InputDatasets"):
                obj = SimpleCFSConfig()
                obj._deserialize(item)
                self._InputDatasets.append(obj)
        self._InstanceTypeAlias = params.get("InstanceTypeAlias")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateObjectiveEvaluationResponse(AbstractModel):
    """CreateObjectiveEvaluation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateOptimizedModelRequest(AbstractModel):
    """CreateOptimizedModel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelAccTaskId: 模型加速任务ID
        :type ModelAccTaskId: str
        :param _Tags: 标签
        :type Tags: list of Tag
        """
        self._ModelAccTaskId = None
        self._Tags = None

    @property
    def ModelAccTaskId(self):
        """模型加速任务ID
        :rtype: str
        """
        return self._ModelAccTaskId

    @ModelAccTaskId.setter
    def ModelAccTaskId(self, ModelAccTaskId):
        self._ModelAccTaskId = ModelAccTaskId

    @property
    def Tags(self):
        """标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ModelAccTaskId = params.get("ModelAccTaskId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOptimizedModelResponse(AbstractModel):
    """CreateOptimizedModel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelId: 模型ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelId: str
        :param _ModelVersionId: 模型版本ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelVersionId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ModelId = None
        self._ModelVersionId = None
        self._RequestId = None

    @property
    def ModelId(self):
        """模型ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModelId

    @ModelId.setter
    def ModelId(self, ModelId):
        self._ModelId = ModelId

    @property
    def ModelVersionId(self):
        """模型版本ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModelVersionId

    @ModelVersionId.setter
    def ModelVersionId(self, ModelVersionId):
        self._ModelVersionId = ModelVersionId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ModelId = params.get("ModelId")
        self._ModelVersionId = params.get("ModelVersionId")
        self._RequestId = params.get("RequestId")


class CreatePreSignedTensorBoardUrlRequest(AbstractModel):
    """CreatePreSignedTensorBoardUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: TensorBoard ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """TensorBoard ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePreSignedTensorBoardUrlResponse(AbstractModel):
    """CreatePreSignedTensorBoardUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Url: TensorBoard Url
        :type Url: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Url = None
        self._RequestId = None

    @property
    def Url(self):
        """TensorBoard Url
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._RequestId = params.get("RequestId")


class CreatePresignedNotebookUrlRequest(AbstractModel):
    """CreatePresignedNotebookUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: Notebook ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """Notebook ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePresignedNotebookUrlResponse(AbstractModel):
    """CreatePresignedNotebookUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AuthorizedUrl: 携带认证TOKEN的URL
        :type AuthorizedUrl: str
        :param _AuthorizedCodeServerUrl: 携带认证TOKEN的CodeServer URL
        :type AuthorizedCodeServerUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AuthorizedUrl = None
        self._AuthorizedCodeServerUrl = None
        self._RequestId = None

    @property
    def AuthorizedUrl(self):
        """携带认证TOKEN的URL
        :rtype: str
        """
        return self._AuthorizedUrl

    @AuthorizedUrl.setter
    def AuthorizedUrl(self, AuthorizedUrl):
        self._AuthorizedUrl = AuthorizedUrl

    @property
    def AuthorizedCodeServerUrl(self):
        """携带认证TOKEN的CodeServer URL
        :rtype: str
        """
        return self._AuthorizedCodeServerUrl

    @AuthorizedCodeServerUrl.setter
    def AuthorizedCodeServerUrl(self, AuthorizedCodeServerUrl):
        self._AuthorizedCodeServerUrl = AuthorizedCodeServerUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AuthorizedUrl = params.get("AuthorizedUrl")
        self._AuthorizedCodeServerUrl = params.get("AuthorizedCodeServerUrl")
        self._RequestId = params.get("RequestId")


class CreatePrivateLinkRequest(AbstractModel):
    """CreatePrivateLink请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceGroupId: 服务组ID
        :type ServiceGroupId: str
        :param _VpcId: 用户VpcId
        :type VpcId: str
        :param _SubnetId: 用户SubnetId
        :type SubnetId: str
        """
        self._ServiceGroupId = None
        self._VpcId = None
        self._SubnetId = None

    @property
    def ServiceGroupId(self):
        """服务组ID
        :rtype: str
        """
        return self._ServiceGroupId

    @ServiceGroupId.setter
    def ServiceGroupId(self, ServiceGroupId):
        self._ServiceGroupId = ServiceGroupId

    @property
    def VpcId(self):
        """用户VpcId
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """用户SubnetId
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._ServiceGroupId = params.get("ServiceGroupId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrivateLinkResponse(AbstractModel):
    """CreatePrivateLink返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateProjectRequest(AbstractModel):
    """CreateProject请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectName: 工程名称
        :type ProjectName: str
        :param _CosPathInfo: 工程COS桶
        :type CosPathInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _LogEnable: 是否上报日志
        :type LogEnable: bool
        :param _Description: 工程描述
        :type Description: str
        :param _LogConfig: CLS日志配置
        :type LogConfig: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        :param _Tags: 标签配置
        :type Tags: list of Tag
        """
        self._ProjectName = None
        self._CosPathInfo = None
        self._LogEnable = None
        self._Description = None
        self._LogConfig = None
        self._Tags = None

    @property
    def ProjectName(self):
        """工程名称
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def CosPathInfo(self):
        """工程COS桶
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._CosPathInfo

    @CosPathInfo.setter
    def CosPathInfo(self, CosPathInfo):
        self._CosPathInfo = CosPathInfo

    @property
    def LogEnable(self):
        """是否上报日志
        :rtype: bool
        """
        return self._LogEnable

    @LogEnable.setter
    def LogEnable(self, LogEnable):
        self._LogEnable = LogEnable

    @property
    def Description(self):
        """工程描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def LogConfig(self):
        """CLS日志配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def Tags(self):
        """标签配置
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ProjectName = params.get("ProjectName")
        if params.get("CosPathInfo") is not None:
            self._CosPathInfo = CosPathInfo()
            self._CosPathInfo._deserialize(params.get("CosPathInfo"))
        self._LogEnable = params.get("LogEnable")
        self._Description = params.get("Description")
        if params.get("LogConfig") is not None:
            self._LogConfig = LogConfig()
            self._LogConfig._deserialize(params.get("LogConfig"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProjectResponse(AbstractModel):
    """CreateProject返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 工程的ID
        :type ProjectId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ProjectId = None
        self._RequestId = None

    @property
    def ProjectId(self):
        """工程的ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RequestId = params.get("RequestId")


class CreateRecyclePolicyRequest(AbstractModel):
    """CreateRecyclePolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RecycleConfig: 回收策略
        :type RecycleConfig: :class:`tencentcloud.tione.v20211111.models.RecycleConfig`
        :param _ExcludeConfig: 排除策略
        :type ExcludeConfig: :class:`tencentcloud.tione.v20211111.models.ExcludeConfig`
        """
        self._RecycleConfig = None
        self._ExcludeConfig = None

    @property
    def RecycleConfig(self):
        """回收策略
        :rtype: :class:`tencentcloud.tione.v20211111.models.RecycleConfig`
        """
        return self._RecycleConfig

    @RecycleConfig.setter
    def RecycleConfig(self, RecycleConfig):
        self._RecycleConfig = RecycleConfig

    @property
    def ExcludeConfig(self):
        """排除策略
        :rtype: :class:`tencentcloud.tione.v20211111.models.ExcludeConfig`
        """
        return self._ExcludeConfig

    @ExcludeConfig.setter
    def ExcludeConfig(self, ExcludeConfig):
        self._ExcludeConfig = ExcludeConfig


    def _deserialize(self, params):
        if params.get("RecycleConfig") is not None:
            self._RecycleConfig = RecycleConfig()
            self._RecycleConfig._deserialize(params.get("RecycleConfig"))
        if params.get("ExcludeConfig") is not None:
            self._ExcludeConfig = ExcludeConfig()
            self._ExcludeConfig._deserialize(params.get("ExcludeConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRecyclePolicyResponse(AbstractModel):
    """CreateRecyclePolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RecyclePolicyId: id值
        :type RecyclePolicyId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RecyclePolicyId = None
        self._RequestId = None

    @property
    def RecyclePolicyId(self):
        """id值
        :rtype: str
        """
        return self._RecyclePolicyId

    @RecyclePolicyId.setter
    def RecyclePolicyId(self, RecyclePolicyId):
        self._RecyclePolicyId = RecyclePolicyId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RecyclePolicyId = params.get("RecyclePolicyId")
        self._RequestId = params.get("RequestId")


class CreateSDWebUIUrlRequest(AbstractModel):
    """CreateSDWebUIUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceId: 服务id
        :type ServiceId: str
        """
        self._ServiceId = None

    @property
    def ServiceId(self):
        """服务id
        :rtype: str
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId


    def _deserialize(self, params):
        self._ServiceId = params.get("ServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSDWebUIUrlResponse(AbstractModel):
    """CreateSDWebUIUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Url: webui url 地址
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Url = None
        self._RequestId = None

    @property
    def Url(self):
        """webui url 地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._RequestId = params.get("RequestId")


class CreateSubjectiveEvaluationRequest(AbstractModel):
    """CreateSubjectiveEvaluation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Datasets: [已废弃]请使用InputDatasets
        :type Datasets: list of CFSConfig
        :param _Models: 模型配置
        :type Models: list of EvalModel
        :param _Description: 描述
        :type Description: str
        :param _ChargeType: 计费
        :type ChargeType: str
        :param _ResourceGroupId: 资源
        :type ResourceGroupId: str
        :param _Resources: 预付费资源
        :type Resources: :class:`tencentcloud.tione.v20211111.models.ResourceInfo`
        :param _InstanceType: 资源类型
        :type InstanceType: str
        :param _ResourceGroupName: 资源组名称
        :type ResourceGroupName: str
        :param _DeployType: 部署类型
        :type DeployType: str
        :param _InstancePerReplicas: 单副本下的实例数，仅在部署类型为DIST时生效，默认1
        :type InstancePerReplicas: int
        :param _OutputCFSConfig: 输出CFS路径
        :type OutputCFSConfig: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        :param _Tags: 标签
        :type Tags: list of Tag
        :param _InputDatasets: 评测集
        :type InputDatasets: list of SimpleCFSConfig
        :param _InstanceTypeAlias: 后付费资源信息
        :type InstanceTypeAlias: str
        """
        self._Name = None
        self._Datasets = None
        self._Models = None
        self._Description = None
        self._ChargeType = None
        self._ResourceGroupId = None
        self._Resources = None
        self._InstanceType = None
        self._ResourceGroupName = None
        self._DeployType = None
        self._InstancePerReplicas = None
        self._OutputCFSConfig = None
        self._Tags = None
        self._InputDatasets = None
        self._InstanceTypeAlias = None

    @property
    def Name(self):
        """名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Datasets(self):
        """[已废弃]请使用InputDatasets
        :rtype: list of CFSConfig
        """
        return self._Datasets

    @Datasets.setter
    def Datasets(self, Datasets):
        self._Datasets = Datasets

    @property
    def Models(self):
        """模型配置
        :rtype: list of EvalModel
        """
        return self._Models

    @Models.setter
    def Models(self, Models):
        self._Models = Models

    @property
    def Description(self):
        """描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ChargeType(self):
        """计费
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def ResourceGroupId(self):
        """资源
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def Resources(self):
        """预付费资源
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceInfo`
        """
        return self._Resources

    @Resources.setter
    def Resources(self, Resources):
        self._Resources = Resources

    @property
    def InstanceType(self):
        """资源类型
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def ResourceGroupName(self):
        """资源组名称
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def DeployType(self):
        """部署类型
        :rtype: str
        """
        return self._DeployType

    @DeployType.setter
    def DeployType(self, DeployType):
        self._DeployType = DeployType

    @property
    def InstancePerReplicas(self):
        """单副本下的实例数，仅在部署类型为DIST时生效，默认1
        :rtype: int
        """
        return self._InstancePerReplicas

    @InstancePerReplicas.setter
    def InstancePerReplicas(self, InstancePerReplicas):
        self._InstancePerReplicas = InstancePerReplicas

    @property
    def OutputCFSConfig(self):
        """输出CFS路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        """
        return self._OutputCFSConfig

    @OutputCFSConfig.setter
    def OutputCFSConfig(self, OutputCFSConfig):
        self._OutputCFSConfig = OutputCFSConfig

    @property
    def Tags(self):
        """标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def InputDatasets(self):
        """评测集
        :rtype: list of SimpleCFSConfig
        """
        return self._InputDatasets

    @InputDatasets.setter
    def InputDatasets(self, InputDatasets):
        self._InputDatasets = InputDatasets

    @property
    def InstanceTypeAlias(self):
        """后付费资源信息
        :rtype: str
        """
        return self._InstanceTypeAlias

    @InstanceTypeAlias.setter
    def InstanceTypeAlias(self, InstanceTypeAlias):
        self._InstanceTypeAlias = InstanceTypeAlias


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("Datasets") is not None:
            self._Datasets = []
            for item in params.get("Datasets"):
                obj = CFSConfig()
                obj._deserialize(item)
                self._Datasets.append(obj)
        if params.get("Models") is not None:
            self._Models = []
            for item in params.get("Models"):
                obj = EvalModel()
                obj._deserialize(item)
                self._Models.append(obj)
        self._Description = params.get("Description")
        self._ChargeType = params.get("ChargeType")
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("Resources") is not None:
            self._Resources = ResourceInfo()
            self._Resources._deserialize(params.get("Resources"))
        self._InstanceType = params.get("InstanceType")
        self._ResourceGroupName = params.get("ResourceGroupName")
        self._DeployType = params.get("DeployType")
        self._InstancePerReplicas = params.get("InstancePerReplicas")
        if params.get("OutputCFSConfig") is not None:
            self._OutputCFSConfig = CFSConfig()
            self._OutputCFSConfig._deserialize(params.get("OutputCFSConfig"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("InputDatasets") is not None:
            self._InputDatasets = []
            for item in params.get("InputDatasets"):
                obj = SimpleCFSConfig()
                obj._deserialize(item)
                self._InputDatasets.append(obj)
        self._InstanceTypeAlias = params.get("InstanceTypeAlias")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubjectiveEvaluationResponse(AbstractModel):
    """CreateSubjectiveEvaluation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateSyncReviewImageTaskRequest(AbstractModel):
    """CreateSyncReviewImageTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageUrl: 待审核的图片链接
        :type ImageUrl: str
        """
        self._ImageUrl = None

    @property
    def ImageUrl(self):
        """待审核的图片链接
        :rtype: str
        """
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl


    def _deserialize(self, params):
        self._ImageUrl = params.get("ImageUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSyncReviewImageTaskResponse(AbstractModel):
    """CreateSyncReviewImageTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 表示本次判定的审核结果，1（审核正常），2（判定为违规敏感文件）
        :type Result: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """表示本次判定的审核结果，1（审核正常），2（判定为违规敏感文件）
        :rtype: int
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateTaskComparisonRequest(AbstractModel):
    """CreateTaskComparison请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 任务名称
        :type Name: str
        :param _AppKey: 云小微应用端信息
        :type AppKey: str
        :param _DataConfig: 评测数据集
        :type DataConfig: :class:`tencentcloud.tione.v20211111.models.AutoMLDataConfig`
        :param _TaskConfigs: 任务配置信息
        :type TaskConfigs: list of EvaluateTaskItem
        :param _TaskType: 评测类型single或者multi
        :type TaskType: str
        :param _CreateUserName: 创建人名称
        :type CreateUserName: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _CTXCosInfo: 云小微创建对比评测使用的配置信息
        :type CTXCosInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _TestDataMap: 测试数据路径映射
        :type TestDataMap: list of TestDataInfo
        :param _TaskComparisonId: 对比评测任务id，非空表示重启
        :type TaskComparisonId: str
        """
        self._Name = None
        self._AppKey = None
        self._DataConfig = None
        self._TaskConfigs = None
        self._TaskType = None
        self._CreateUserName = None
        self._ProjectId = None
        self._CTXCosInfo = None
        self._TestDataMap = None
        self._TaskComparisonId = None

    @property
    def Name(self):
        """任务名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def AppKey(self):
        """云小微应用端信息
        :rtype: str
        """
        return self._AppKey

    @AppKey.setter
    def AppKey(self, AppKey):
        self._AppKey = AppKey

    @property
    def DataConfig(self):
        """评测数据集
        :rtype: :class:`tencentcloud.tione.v20211111.models.AutoMLDataConfig`
        """
        return self._DataConfig

    @DataConfig.setter
    def DataConfig(self, DataConfig):
        self._DataConfig = DataConfig

    @property
    def TaskConfigs(self):
        """任务配置信息
        :rtype: list of EvaluateTaskItem
        """
        return self._TaskConfigs

    @TaskConfigs.setter
    def TaskConfigs(self, TaskConfigs):
        self._TaskConfigs = TaskConfigs

    @property
    def TaskType(self):
        """评测类型single或者multi
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def CreateUserName(self):
        """创建人名称
        :rtype: str
        """
        return self._CreateUserName

    @CreateUserName.setter
    def CreateUserName(self, CreateUserName):
        self._CreateUserName = CreateUserName

    @property
    def ProjectId(self):
        """项目ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CTXCosInfo(self):
        """云小微创建对比评测使用的配置信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._CTXCosInfo

    @CTXCosInfo.setter
    def CTXCosInfo(self, CTXCosInfo):
        self._CTXCosInfo = CTXCosInfo

    @property
    def TestDataMap(self):
        """测试数据路径映射
        :rtype: list of TestDataInfo
        """
        return self._TestDataMap

    @TestDataMap.setter
    def TestDataMap(self, TestDataMap):
        self._TestDataMap = TestDataMap

    @property
    def TaskComparisonId(self):
        """对比评测任务id，非空表示重启
        :rtype: str
        """
        return self._TaskComparisonId

    @TaskComparisonId.setter
    def TaskComparisonId(self, TaskComparisonId):
        self._TaskComparisonId = TaskComparisonId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._AppKey = params.get("AppKey")
        if params.get("DataConfig") is not None:
            self._DataConfig = AutoMLDataConfig()
            self._DataConfig._deserialize(params.get("DataConfig"))
        if params.get("TaskConfigs") is not None:
            self._TaskConfigs = []
            for item in params.get("TaskConfigs"):
                obj = EvaluateTaskItem()
                obj._deserialize(item)
                self._TaskConfigs.append(obj)
        self._TaskType = params.get("TaskType")
        self._CreateUserName = params.get("CreateUserName")
        self._ProjectId = params.get("ProjectId")
        if params.get("CTXCosInfo") is not None:
            self._CTXCosInfo = CosPathInfo()
            self._CTXCosInfo._deserialize(params.get("CTXCosInfo"))
        if params.get("TestDataMap") is not None:
            self._TestDataMap = []
            for item in params.get("TestDataMap"):
                obj = TestDataInfo()
                obj._deserialize(item)
                self._TestDataMap.append(obj)
        self._TaskComparisonId = params.get("TaskComparisonId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskComparisonResponse(AbstractModel):
    """CreateTaskComparison返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskComparisonId: 任务ID
        :type TaskComparisonId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskComparisonId = None
        self._RequestId = None

    @property
    def TaskComparisonId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskComparisonId

    @TaskComparisonId.setter
    def TaskComparisonId(self, TaskComparisonId):
        self._TaskComparisonId = TaskComparisonId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskComparisonId = params.get("TaskComparisonId")
        self._RequestId = params.get("RequestId")


class CreateTensorBoardTaskRequest(AbstractModel):
    """CreateTensorBoardTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 训练任务ID
        :type TaskId: str
        :param _SummaryDataConfig: summary存储配置
        :type SummaryDataConfig: :class:`tencentcloud.tione.v20211111.models.DataConfig`
        :param _NotToStartTensorBoard: 是否不启动Tensorboard，默认启动Tensorboard
        :type NotToStartTensorBoard: bool
        :param _SummaryAbsolutePath: summary相对路径
        :type SummaryAbsolutePath: str
        """
        self._TaskId = None
        self._SummaryDataConfig = None
        self._NotToStartTensorBoard = None
        self._SummaryAbsolutePath = None

    @property
    def TaskId(self):
        """训练任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SummaryDataConfig(self):
        """summary存储配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.DataConfig`
        """
        return self._SummaryDataConfig

    @SummaryDataConfig.setter
    def SummaryDataConfig(self, SummaryDataConfig):
        self._SummaryDataConfig = SummaryDataConfig

    @property
    def NotToStartTensorBoard(self):
        """是否不启动Tensorboard，默认启动Tensorboard
        :rtype: bool
        """
        return self._NotToStartTensorBoard

    @NotToStartTensorBoard.setter
    def NotToStartTensorBoard(self, NotToStartTensorBoard):
        self._NotToStartTensorBoard = NotToStartTensorBoard

    @property
    def SummaryAbsolutePath(self):
        """summary相对路径
        :rtype: str
        """
        return self._SummaryAbsolutePath

    @SummaryAbsolutePath.setter
    def SummaryAbsolutePath(self, SummaryAbsolutePath):
        self._SummaryAbsolutePath = SummaryAbsolutePath


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        if params.get("SummaryDataConfig") is not None:
            self._SummaryDataConfig = DataConfig()
            self._SummaryDataConfig._deserialize(params.get("SummaryDataConfig"))
        self._NotToStartTensorBoard = params.get("NotToStartTensorBoard")
        self._SummaryAbsolutePath = params.get("SummaryAbsolutePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTensorBoardTaskResponse(AbstractModel):
    """CreateTensorBoardTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TensorBoardId: TensorBoard ID
        :type TensorBoardId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TensorBoardId = None
        self._RequestId = None

    @property
    def TensorBoardId(self):
        """TensorBoard ID
        :rtype: str
        """
        return self._TensorBoardId

    @TensorBoardId.setter
    def TensorBoardId(self, TensorBoardId):
        self._TensorBoardId = TensorBoardId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TensorBoardId = params.get("TensorBoardId")
        self._RequestId = params.get("RequestId")


class CreateTrainingModelRequest(AbstractModel):
    """CreateTrainingModel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImportMethod: 导入方式
MODEL：导入新模型
VERSION：导入新版本
EXIST：导入现有版本
        :type ImportMethod: str
        :param _ReasoningEnvironmentSource: 推理环境来源（SYSTEM/CUSTOM）
        :type ReasoningEnvironmentSource: str
        :param _TrainingModelName: 模型名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :type TrainingModelName: str
        :param _Tags: 标签配置
        :type Tags: list of Tag
        :param _TrainingJobName: 训练任务名称
        :type TrainingJobName: str
        :param _TrainingModelCosPath: 模型来源cos目录，以/结尾
        :type TrainingModelCosPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _AlgorithmFramework: 算法框架 （PYTORCH/TENSORFLOW/DETECTRON2/PMML/MMDETECTION/ONNX)
        :type AlgorithmFramework: str
        :param _ReasoningEnvironment: 推理环境
        :type ReasoningEnvironment: str
        :param _TrainingModelIndex: 训练指标，最多支持1000字符
        :type TrainingModelIndex: str
        :param _TrainingModelVersion: 模型版本
        :type TrainingModelVersion: str
        :param _ReasoningImageInfo: 自定义推理环境
        :type ReasoningImageInfo: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        :param _ModelMoveMode: 模型移动方式（CUT/COPY）
        :type ModelMoveMode: str
        :param _TrainingJobId: 训练任务ID
        :type TrainingJobId: str
        :param _TrainingModelId: 模型ID（导入新模型不需要，导入新版本需要）
        :type TrainingModelId: str
        :param _ModelOutputPath: 模型存储cos目录
        :type ModelOutputPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _TrainingModelSource: 模型来源 （JOB/COS）
        :type TrainingModelSource: str
        :param _TrainingPreference: 模型偏好
        :type TrainingPreference: str
        :param _AutoMLTaskId: 自动学习任务ID（已废弃）
        :type AutoMLTaskId: str
        :param _TrainingJobVersion: 任务版本
        :type TrainingJobVersion: str
        :param _ModelVersionType: 模型版本类型；
枚举值：NORMAL(通用)  ACCELERATE(加速)
注意:  默认为NORMAL
        :type ModelVersionType: str
        :param _ModelFormat: 模型格式 （PYTORCH/TORCH_SCRIPT/DETECTRON2/SAVED_MODEL/FROZEN_GRAPH/PMML/MMDETECTION/ONNX/HUGGING_FACE_BERT/HUGGING_FACE_STABLE_DIFFUSION/HUGGING_FACE_STABLE_DIFFUSION_LORA/WEB_UI_STABLE_DIFFUSION）
        :type ModelFormat: str
        :param _ReasoningEnvironmentId: 推理镜像ID
        :type ReasoningEnvironmentId: str
        :param _AutoClean: 模型自动清理开关(true/false)，当前版本仅支持SAVED_MODEL格式模型
        :type AutoClean: str
        :param _MaxReservedModels: 模型数量保留上限(默认值为24个，上限为24，下限为1，步长为1)
        :type MaxReservedModels: int
        :param _ModelCleanPeriod: 模型清理周期(默认值为1分钟，上限为1440，下限为1分钟，步长为1)
        :type ModelCleanPeriod: int
        :param _IsQAT: 是否QAT模型
        :type IsQAT: bool
        :param _ModelAffiliation: 模型所属模块；
枚举值：MODEL_REPO(模型仓库)  AI_MARKET(AI市场)
注意:  默认为MODEL_REPO
        :type ModelAffiliation: str
        :param _TrainingJobBackendId: 太极HY训练任务id
        :type TrainingJobBackendId: str
        :param _TrainingJobBackendName: 太极HY训练任务名称
        :type TrainingJobBackendName: str
        """
        self._ImportMethod = None
        self._ReasoningEnvironmentSource = None
        self._TrainingModelName = None
        self._Tags = None
        self._TrainingJobName = None
        self._TrainingModelCosPath = None
        self._AlgorithmFramework = None
        self._ReasoningEnvironment = None
        self._TrainingModelIndex = None
        self._TrainingModelVersion = None
        self._ReasoningImageInfo = None
        self._ModelMoveMode = None
        self._TrainingJobId = None
        self._TrainingModelId = None
        self._ModelOutputPath = None
        self._TrainingModelSource = None
        self._TrainingPreference = None
        self._AutoMLTaskId = None
        self._TrainingJobVersion = None
        self._ModelVersionType = None
        self._ModelFormat = None
        self._ReasoningEnvironmentId = None
        self._AutoClean = None
        self._MaxReservedModels = None
        self._ModelCleanPeriod = None
        self._IsQAT = None
        self._ModelAffiliation = None
        self._TrainingJobBackendId = None
        self._TrainingJobBackendName = None

    @property
    def ImportMethod(self):
        """导入方式
MODEL：导入新模型
VERSION：导入新版本
EXIST：导入现有版本
        :rtype: str
        """
        return self._ImportMethod

    @ImportMethod.setter
    def ImportMethod(self, ImportMethod):
        self._ImportMethod = ImportMethod

    @property
    def ReasoningEnvironmentSource(self):
        """推理环境来源（SYSTEM/CUSTOM）
        :rtype: str
        """
        return self._ReasoningEnvironmentSource

    @ReasoningEnvironmentSource.setter
    def ReasoningEnvironmentSource(self, ReasoningEnvironmentSource):
        self._ReasoningEnvironmentSource = ReasoningEnvironmentSource

    @property
    def TrainingModelName(self):
        """模型名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :rtype: str
        """
        return self._TrainingModelName

    @TrainingModelName.setter
    def TrainingModelName(self, TrainingModelName):
        self._TrainingModelName = TrainingModelName

    @property
    def Tags(self):
        """标签配置
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def TrainingJobName(self):
        """训练任务名称
        :rtype: str
        """
        return self._TrainingJobName

    @TrainingJobName.setter
    def TrainingJobName(self, TrainingJobName):
        self._TrainingJobName = TrainingJobName

    @property
    def TrainingModelCosPath(self):
        """模型来源cos目录，以/结尾
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._TrainingModelCosPath

    @TrainingModelCosPath.setter
    def TrainingModelCosPath(self, TrainingModelCosPath):
        self._TrainingModelCosPath = TrainingModelCosPath

    @property
    def AlgorithmFramework(self):
        """算法框架 （PYTORCH/TENSORFLOW/DETECTRON2/PMML/MMDETECTION/ONNX)
        :rtype: str
        """
        return self._AlgorithmFramework

    @AlgorithmFramework.setter
    def AlgorithmFramework(self, AlgorithmFramework):
        self._AlgorithmFramework = AlgorithmFramework

    @property
    def ReasoningEnvironment(self):
        """推理环境
        :rtype: str
        """
        return self._ReasoningEnvironment

    @ReasoningEnvironment.setter
    def ReasoningEnvironment(self, ReasoningEnvironment):
        self._ReasoningEnvironment = ReasoningEnvironment

    @property
    def TrainingModelIndex(self):
        """训练指标，最多支持1000字符
        :rtype: str
        """
        return self._TrainingModelIndex

    @TrainingModelIndex.setter
    def TrainingModelIndex(self, TrainingModelIndex):
        self._TrainingModelIndex = TrainingModelIndex

    @property
    def TrainingModelVersion(self):
        """模型版本
        :rtype: str
        """
        return self._TrainingModelVersion

    @TrainingModelVersion.setter
    def TrainingModelVersion(self, TrainingModelVersion):
        self._TrainingModelVersion = TrainingModelVersion

    @property
    def ReasoningImageInfo(self):
        """自定义推理环境
        :rtype: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        """
        return self._ReasoningImageInfo

    @ReasoningImageInfo.setter
    def ReasoningImageInfo(self, ReasoningImageInfo):
        self._ReasoningImageInfo = ReasoningImageInfo

    @property
    def ModelMoveMode(self):
        """模型移动方式（CUT/COPY）
        :rtype: str
        """
        return self._ModelMoveMode

    @ModelMoveMode.setter
    def ModelMoveMode(self, ModelMoveMode):
        self._ModelMoveMode = ModelMoveMode

    @property
    def TrainingJobId(self):
        """训练任务ID
        :rtype: str
        """
        return self._TrainingJobId

    @TrainingJobId.setter
    def TrainingJobId(self, TrainingJobId):
        self._TrainingJobId = TrainingJobId

    @property
    def TrainingModelId(self):
        """模型ID（导入新模型不需要，导入新版本需要）
        :rtype: str
        """
        return self._TrainingModelId

    @TrainingModelId.setter
    def TrainingModelId(self, TrainingModelId):
        self._TrainingModelId = TrainingModelId

    @property
    def ModelOutputPath(self):
        """模型存储cos目录
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._ModelOutputPath

    @ModelOutputPath.setter
    def ModelOutputPath(self, ModelOutputPath):
        self._ModelOutputPath = ModelOutputPath

    @property
    def TrainingModelSource(self):
        """模型来源 （JOB/COS）
        :rtype: str
        """
        return self._TrainingModelSource

    @TrainingModelSource.setter
    def TrainingModelSource(self, TrainingModelSource):
        self._TrainingModelSource = TrainingModelSource

    @property
    def TrainingPreference(self):
        """模型偏好
        :rtype: str
        """
        return self._TrainingPreference

    @TrainingPreference.setter
    def TrainingPreference(self, TrainingPreference):
        self._TrainingPreference = TrainingPreference

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID（已废弃）
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def TrainingJobVersion(self):
        """任务版本
        :rtype: str
        """
        return self._TrainingJobVersion

    @TrainingJobVersion.setter
    def TrainingJobVersion(self, TrainingJobVersion):
        self._TrainingJobVersion = TrainingJobVersion

    @property
    def ModelVersionType(self):
        """模型版本类型；
枚举值：NORMAL(通用)  ACCELERATE(加速)
注意:  默认为NORMAL
        :rtype: str
        """
        return self._ModelVersionType

    @ModelVersionType.setter
    def ModelVersionType(self, ModelVersionType):
        self._ModelVersionType = ModelVersionType

    @property
    def ModelFormat(self):
        """模型格式 （PYTORCH/TORCH_SCRIPT/DETECTRON2/SAVED_MODEL/FROZEN_GRAPH/PMML/MMDETECTION/ONNX/HUGGING_FACE_BERT/HUGGING_FACE_STABLE_DIFFUSION/HUGGING_FACE_STABLE_DIFFUSION_LORA/WEB_UI_STABLE_DIFFUSION）
        :rtype: str
        """
        return self._ModelFormat

    @ModelFormat.setter
    def ModelFormat(self, ModelFormat):
        self._ModelFormat = ModelFormat

    @property
    def ReasoningEnvironmentId(self):
        """推理镜像ID
        :rtype: str
        """
        return self._ReasoningEnvironmentId

    @ReasoningEnvironmentId.setter
    def ReasoningEnvironmentId(self, ReasoningEnvironmentId):
        self._ReasoningEnvironmentId = ReasoningEnvironmentId

    @property
    def AutoClean(self):
        """模型自动清理开关(true/false)，当前版本仅支持SAVED_MODEL格式模型
        :rtype: str
        """
        return self._AutoClean

    @AutoClean.setter
    def AutoClean(self, AutoClean):
        self._AutoClean = AutoClean

    @property
    def MaxReservedModels(self):
        """模型数量保留上限(默认值为24个，上限为24，下限为1，步长为1)
        :rtype: int
        """
        return self._MaxReservedModels

    @MaxReservedModels.setter
    def MaxReservedModels(self, MaxReservedModels):
        self._MaxReservedModels = MaxReservedModels

    @property
    def ModelCleanPeriod(self):
        """模型清理周期(默认值为1分钟，上限为1440，下限为1分钟，步长为1)
        :rtype: int
        """
        return self._ModelCleanPeriod

    @ModelCleanPeriod.setter
    def ModelCleanPeriod(self, ModelCleanPeriod):
        self._ModelCleanPeriod = ModelCleanPeriod

    @property
    def IsQAT(self):
        """是否QAT模型
        :rtype: bool
        """
        return self._IsQAT

    @IsQAT.setter
    def IsQAT(self, IsQAT):
        self._IsQAT = IsQAT

    @property
    def ModelAffiliation(self):
        """模型所属模块；
枚举值：MODEL_REPO(模型仓库)  AI_MARKET(AI市场)
注意:  默认为MODEL_REPO
        :rtype: str
        """
        return self._ModelAffiliation

    @ModelAffiliation.setter
    def ModelAffiliation(self, ModelAffiliation):
        self._ModelAffiliation = ModelAffiliation

    @property
    def TrainingJobBackendId(self):
        """太极HY训练任务id
        :rtype: str
        """
        return self._TrainingJobBackendId

    @TrainingJobBackendId.setter
    def TrainingJobBackendId(self, TrainingJobBackendId):
        self._TrainingJobBackendId = TrainingJobBackendId

    @property
    def TrainingJobBackendName(self):
        """太极HY训练任务名称
        :rtype: str
        """
        return self._TrainingJobBackendName

    @TrainingJobBackendName.setter
    def TrainingJobBackendName(self, TrainingJobBackendName):
        self._TrainingJobBackendName = TrainingJobBackendName


    def _deserialize(self, params):
        self._ImportMethod = params.get("ImportMethod")
        self._ReasoningEnvironmentSource = params.get("ReasoningEnvironmentSource")
        self._TrainingModelName = params.get("TrainingModelName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._TrainingJobName = params.get("TrainingJobName")
        if params.get("TrainingModelCosPath") is not None:
            self._TrainingModelCosPath = CosPathInfo()
            self._TrainingModelCosPath._deserialize(params.get("TrainingModelCosPath"))
        self._AlgorithmFramework = params.get("AlgorithmFramework")
        self._ReasoningEnvironment = params.get("ReasoningEnvironment")
        self._TrainingModelIndex = params.get("TrainingModelIndex")
        self._TrainingModelVersion = params.get("TrainingModelVersion")
        if params.get("ReasoningImageInfo") is not None:
            self._ReasoningImageInfo = ImageInfo()
            self._ReasoningImageInfo._deserialize(params.get("ReasoningImageInfo"))
        self._ModelMoveMode = params.get("ModelMoveMode")
        self._TrainingJobId = params.get("TrainingJobId")
        self._TrainingModelId = params.get("TrainingModelId")
        if params.get("ModelOutputPath") is not None:
            self._ModelOutputPath = CosPathInfo()
            self._ModelOutputPath._deserialize(params.get("ModelOutputPath"))
        self._TrainingModelSource = params.get("TrainingModelSource")
        self._TrainingPreference = params.get("TrainingPreference")
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._TrainingJobVersion = params.get("TrainingJobVersion")
        self._ModelVersionType = params.get("ModelVersionType")
        self._ModelFormat = params.get("ModelFormat")
        self._ReasoningEnvironmentId = params.get("ReasoningEnvironmentId")
        self._AutoClean = params.get("AutoClean")
        self._MaxReservedModels = params.get("MaxReservedModels")
        self._ModelCleanPeriod = params.get("ModelCleanPeriod")
        self._IsQAT = params.get("IsQAT")
        self._ModelAffiliation = params.get("ModelAffiliation")
        self._TrainingJobBackendId = params.get("TrainingJobBackendId")
        self._TrainingJobBackendName = params.get("TrainingJobBackendName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTrainingModelResponse(AbstractModel):
    """CreateTrainingModel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 模型ID，TrainingModel ID
        :type Id: str
        :param _TrainingModelVersionId: 模型版本ID
        :type TrainingModelVersionId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._TrainingModelVersionId = None
        self._RequestId = None

    @property
    def Id(self):
        """模型ID，TrainingModel ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TrainingModelVersionId(self):
        """模型版本ID
        :rtype: str
        """
        return self._TrainingModelVersionId

    @TrainingModelVersionId.setter
    def TrainingModelVersionId(self, TrainingModelVersionId):
        self._TrainingModelVersionId = TrainingModelVersionId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TrainingModelVersionId = params.get("TrainingModelVersionId")
        self._RequestId = params.get("RequestId")


class CreateTrainingTaskRequest(AbstractModel):
    """CreateTrainingTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 训练任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :type Name: str
        :param _ChargeType: 计费模式，eg：PREPAID 包年包月（资源组）;
POSTPAID_BY_HOUR 按量计费
        :type ChargeType: str
        :param _ResourceConfigInfos: 资源配置，需填写对应算力规格ID和节点数量，算力规格ID查询接口为DescribeBillingSpecsPrice，eg：[{"Role":"WORKER", "InstanceType": "TI.S.MEDIUM.POST", "InstanceNum": 1}]
        :type ResourceConfigInfos: list of ResourceConfigInfo
        :param _FrameworkName: 训练框架名称，通过DescribeTrainingFrameworks接口查询，eg：SPARK、PYSPARK、TENSORFLOW、PYTORCH
        :type FrameworkName: str
        :param _FrameworkVersion: 训练框架版本，通过DescribeTrainingFrameworks接口查询，eg：1.15、1.9
        :type FrameworkVersion: str
        :param _FrameworkEnvironment: 训练框架环境，通过DescribeTrainingFrameworks接口查询，eg：tf1.15-py3.7-cpu、torch1.9-py3.8-cuda11.1-gpu
        :type FrameworkEnvironment: str
        :param _ResourceGroupId: 预付费专用资源组ID，通过DescribeBillingResourceGroups接口查询
        :type ResourceGroupId: str
        :param _Tags: 标签配置
        :type Tags: list of Tag
        :param _ImageInfo: 自定义镜像信息
        :type ImageInfo: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        :param _CodePackagePath: COS代码包路径
        :type CodePackagePath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _StartCmdInfo: 任务的启动命令，按任务训练模式输入，如遇特殊字符导致配置失败，可使用EncodedStartCmdInfo参数
        :type StartCmdInfo: :class:`tencentcloud.tione.v20211111.models.StartCmdInfo`
        :param _TrainingMode: 训练模式，通过DescribeTrainingFrameworks接口查询，eg：PS_WORKER、DDP、MPI、HOROVOD
        :type TrainingMode: str
        :param _DataConfigs: 数据配置，依赖DataSource字段，数量不超过10个
        :type DataConfigs: list of DataConfig
        :param _VpcId: VPC Id
        :type VpcId: str
        :param _SubnetId: 子网Id
        :type SubnetId: str
        :param _Output: COS训练输出路径
        :type Output: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _LogConfig: CLS日志配置
        :type LogConfig: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        :param _TuningParameters: 调优参数，不超过2048个字符
        :type TuningParameters: str
        :param _LogEnable: 是否上报日志
        :type LogEnable: bool
        :param _Remark: 备注，不超过1024个字符
        :type Remark: str
        :param _TaskType: 任务类型:请求方来自哪里,eg: AutoML-train、WeData
        :type TaskType: str
        :param _TaskId: 请求方携带的主键ID，eg：14141341
        :type TaskId: str
        :param _DataSource: 数据来源，eg：DATASET、COS、CFS、CFSTurbo、HDFS、GooseFSx
        :type DataSource: str
        :param _CallbackUrl: 回调地址，用于创建/启动/停止训练任务的异步回调。回调格式&内容详见：[[TI-ONE接口回调说明]](https://cloud.tencent.com/document/product/851/84292)
        :type CallbackUrl: str
        :param _PreTrainModel: 太极预训练模型ID
        :type PreTrainModel: :class:`tencentcloud.tione.v20211111.models.PreTrainModel`
        :param _TAIJITemplateId: 太极模版ID
        :type TAIJITemplateId: str
        :param _AIMarketTemplateId: AI市场模板ID
        :type AIMarketTemplateId: str
        :param _AIMarketTemplateGroup: AI市场模板类别
        :type AIMarketTemplateGroup: str
        :param _ResourceGroupAnnotationInfo: 资源组感知的任务信息
        :type ResourceGroupAnnotationInfo: :class:`tencentcloud.tione.v20211111.models.ResourceGroupAnnotationInfo`
        :param _SchedulePolicy: 配置调度策略
        :type SchedulePolicy: :class:`tencentcloud.tione.v20211111.models.SchedulePolicy`
        :param _EncodedStartCmdInfo: 编码后的任务启动命令，与StartCmdInfo同时配置时，仅当前参数生效
        :type EncodedStartCmdInfo: :class:`tencentcloud.tione.v20211111.models.EncodedStartCmdInfo`
        :param _SourceTaskId: 复制任务时的源任务ID
        :type SourceTaskId: str
        :param _CodeRepos: 代码仓库配置
        :type CodeRepos: list of CodeRepoConfig
        """
        self._Name = None
        self._ChargeType = None
        self._ResourceConfigInfos = None
        self._FrameworkName = None
        self._FrameworkVersion = None
        self._FrameworkEnvironment = None
        self._ResourceGroupId = None
        self._Tags = None
        self._ImageInfo = None
        self._CodePackagePath = None
        self._StartCmdInfo = None
        self._TrainingMode = None
        self._DataConfigs = None
        self._VpcId = None
        self._SubnetId = None
        self._Output = None
        self._LogConfig = None
        self._TuningParameters = None
        self._LogEnable = None
        self._Remark = None
        self._TaskType = None
        self._TaskId = None
        self._DataSource = None
        self._CallbackUrl = None
        self._PreTrainModel = None
        self._TAIJITemplateId = None
        self._AIMarketTemplateId = None
        self._AIMarketTemplateGroup = None
        self._ResourceGroupAnnotationInfo = None
        self._SchedulePolicy = None
        self._EncodedStartCmdInfo = None
        self._SourceTaskId = None
        self._CodeRepos = None

    @property
    def Name(self):
        """训练任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ChargeType(self):
        """计费模式，eg：PREPAID 包年包月（资源组）;
POSTPAID_BY_HOUR 按量计费
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def ResourceConfigInfos(self):
        """资源配置，需填写对应算力规格ID和节点数量，算力规格ID查询接口为DescribeBillingSpecsPrice，eg：[{"Role":"WORKER", "InstanceType": "TI.S.MEDIUM.POST", "InstanceNum": 1}]
        :rtype: list of ResourceConfigInfo
        """
        return self._ResourceConfigInfos

    @ResourceConfigInfos.setter
    def ResourceConfigInfos(self, ResourceConfigInfos):
        self._ResourceConfigInfos = ResourceConfigInfos

    @property
    def FrameworkName(self):
        """训练框架名称，通过DescribeTrainingFrameworks接口查询，eg：SPARK、PYSPARK、TENSORFLOW、PYTORCH
        :rtype: str
        """
        return self._FrameworkName

    @FrameworkName.setter
    def FrameworkName(self, FrameworkName):
        self._FrameworkName = FrameworkName

    @property
    def FrameworkVersion(self):
        """训练框架版本，通过DescribeTrainingFrameworks接口查询，eg：1.15、1.9
        :rtype: str
        """
        return self._FrameworkVersion

    @FrameworkVersion.setter
    def FrameworkVersion(self, FrameworkVersion):
        self._FrameworkVersion = FrameworkVersion

    @property
    def FrameworkEnvironment(self):
        """训练框架环境，通过DescribeTrainingFrameworks接口查询，eg：tf1.15-py3.7-cpu、torch1.9-py3.8-cuda11.1-gpu
        :rtype: str
        """
        return self._FrameworkEnvironment

    @FrameworkEnvironment.setter
    def FrameworkEnvironment(self, FrameworkEnvironment):
        self._FrameworkEnvironment = FrameworkEnvironment

    @property
    def ResourceGroupId(self):
        """预付费专用资源组ID，通过DescribeBillingResourceGroups接口查询
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def Tags(self):
        """标签配置
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ImageInfo(self):
        """自定义镜像信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        """
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def CodePackagePath(self):
        """COS代码包路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._CodePackagePath

    @CodePackagePath.setter
    def CodePackagePath(self, CodePackagePath):
        self._CodePackagePath = CodePackagePath

    @property
    def StartCmdInfo(self):
        """任务的启动命令，按任务训练模式输入，如遇特殊字符导致配置失败，可使用EncodedStartCmdInfo参数
        :rtype: :class:`tencentcloud.tione.v20211111.models.StartCmdInfo`
        """
        return self._StartCmdInfo

    @StartCmdInfo.setter
    def StartCmdInfo(self, StartCmdInfo):
        self._StartCmdInfo = StartCmdInfo

    @property
    def TrainingMode(self):
        """训练模式，通过DescribeTrainingFrameworks接口查询，eg：PS_WORKER、DDP、MPI、HOROVOD
        :rtype: str
        """
        return self._TrainingMode

    @TrainingMode.setter
    def TrainingMode(self, TrainingMode):
        self._TrainingMode = TrainingMode

    @property
    def DataConfigs(self):
        """数据配置，依赖DataSource字段，数量不超过10个
        :rtype: list of DataConfig
        """
        return self._DataConfigs

    @DataConfigs.setter
    def DataConfigs(self, DataConfigs):
        self._DataConfigs = DataConfigs

    @property
    def VpcId(self):
        """VPC Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网Id
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Output(self):
        """COS训练输出路径
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def LogConfig(self):
        """CLS日志配置
        :rtype: :class:`tencentcloud.tione.v20211111.models.LogConfig`
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def TuningParameters(self):
        """调优参数，不超过2048个字符
        :rtype: str
        """
        return self._TuningParameters

    @TuningParameters.setter
    def TuningParameters(self, TuningParameters):
        self._TuningParameters = TuningParameters

    @property
    def LogEnable(self):
        """是否上报日志
        :rtype: bool
        """
        return self._LogEnable

    @LogEnable.setter
    def LogEnable(self, LogEnable):
        self._LogEnable = LogEnable

    @property
    def Remark(self):
        """备注，不超过1024个字符
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def TaskType(self):
        """任务类型:请求方来自哪里,eg: AutoML-train、WeData
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskId(self):
        """请求方携带的主键ID，eg：14141341
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DataSource(self):
        """数据来源，eg：DATASET、COS、CFS、CFSTurbo、HDFS、GooseFSx
        :rtype: str
        """
        return self._DataSource

    @DataSource.setter
    def DataSource(self, DataSource):
        self._DataSource = DataSource

    @property
    def CallbackUrl(self):
        """回调地址，用于创建/启动/停止训练任务的异步回调。回调格式&内容详见：[[TI-ONE接口回调说明]](https://cloud.tencent.com/document/product/851/84292)
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def PreTrainModel(self):
        """太极预训练模型ID
        :rtype: :class:`tencentcloud.tione.v20211111.models.PreTrainModel`
        """
        return self._PreTrainModel

    @PreTrainModel.setter
    def PreTrainModel(self, PreTrainModel):
        self._PreTrainModel = PreTrainModel

    @property
    def TAIJITemplateId(self):
        """太极模版ID
        :rtype: str
        """
        return self._TAIJITemplateId

    @TAIJITemplateId.setter
    def TAIJITemplateId(self, TAIJITemplateId):
        self._TAIJITemplateId = TAIJITemplateId

    @property
    def AIMarketTemplateId(self):
        """AI市场模板ID
        :rtype: str
        """
        return self._AIMarketTemplateId

    @AIMarketTemplateId.setter
    def AIMarketTemplateId(self, AIMarketTemplateId):
        self._AIMarketTemplateId = AIMarketTemplateId

    @property
    def AIMarketTemplateGroup(self):
        """AI市场模板类别
        :rtype: str
        """
        return self._AIMarketTemplateGroup

    @AIMarketTemplateGroup.setter
    def AIMarketTemplateGroup(self, AIMarketTemplateGroup):
        self._AIMarketTemplateGroup = AIMarketTemplateGroup

    @property
    def ResourceGroupAnnotationInfo(self):
        """资源组感知的任务信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceGroupAnnotationInfo`
        """
        return self._ResourceGroupAnnotationInfo

    @ResourceGroupAnnotationInfo.setter
    def ResourceGroupAnnotationInfo(self, ResourceGroupAnnotationInfo):
        self._ResourceGroupAnnotationInfo = ResourceGroupAnnotationInfo

    @property
    def SchedulePolicy(self):
        """配置调度策略
        :rtype: :class:`tencentcloud.tione.v20211111.models.SchedulePolicy`
        """
        return self._SchedulePolicy

    @SchedulePolicy.setter
    def SchedulePolicy(self, SchedulePolicy):
        self._SchedulePolicy = SchedulePolicy

    @property
    def EncodedStartCmdInfo(self):
        """编码后的任务启动命令，与StartCmdInfo同时配置时，仅当前参数生效
        :rtype: :class:`tencentcloud.tione.v20211111.models.EncodedStartCmdInfo`
        """
        return self._EncodedStartCmdInfo

    @EncodedStartCmdInfo.setter
    def EncodedStartCmdInfo(self, EncodedStartCmdInfo):
        self._EncodedStartCmdInfo = EncodedStartCmdInfo

    @property
    def SourceTaskId(self):
        """复制任务时的源任务ID
        :rtype: str
        """
        return self._SourceTaskId

    @SourceTaskId.setter
    def SourceTaskId(self, SourceTaskId):
        self._SourceTaskId = SourceTaskId

    @property
    def CodeRepos(self):
        """代码仓库配置
        :rtype: list of CodeRepoConfig
        """
        return self._CodeRepos

    @CodeRepos.setter
    def CodeRepos(self, CodeRepos):
        self._CodeRepos = CodeRepos


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._ChargeType = params.get("ChargeType")
        if params.get("ResourceConfigInfos") is not None:
            self._ResourceConfigInfos = []
            for item in params.get("ResourceConfigInfos"):
                obj = ResourceConfigInfo()
                obj._deserialize(item)
                self._ResourceConfigInfos.append(obj)
        self._FrameworkName = params.get("FrameworkName")
        self._FrameworkVersion = params.get("FrameworkVersion")
        self._FrameworkEnvironment = params.get("FrameworkEnvironment")
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        if params.get("CodePackagePath") is not None:
            self._CodePackagePath = CosPathInfo()
            self._CodePackagePath._deserialize(params.get("CodePackagePath"))
        if params.get("StartCmdInfo") is not None:
            self._StartCmdInfo = StartCmdInfo()
            self._StartCmdInfo._deserialize(params.get("StartCmdInfo"))
        self._TrainingMode = params.get("TrainingMode")
        if params.get("DataConfigs") is not None:
            self._DataConfigs = []
            for item in params.get("DataConfigs"):
                obj = DataConfig()
                obj._deserialize(item)
                self._DataConfigs.append(obj)
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        if params.get("Output") is not None:
            self._Output = CosPathInfo()
            self._Output._deserialize(params.get("Output"))
        if params.get("LogConfig") is not None:
            self._LogConfig = LogConfig()
            self._LogConfig._deserialize(params.get("LogConfig"))
        self._TuningParameters = params.get("TuningParameters")
        self._LogEnable = params.get("LogEnable")
        self._Remark = params.get("Remark")
        self._TaskType = params.get("TaskType")
        self._TaskId = params.get("TaskId")
        self._DataSource = params.get("DataSource")
        self._CallbackUrl = params.get("CallbackUrl")
        if params.get("PreTrainModel") is not None:
            self._PreTrainModel = PreTrainModel()
            self._PreTrainModel._deserialize(params.get("PreTrainModel"))
        self._TAIJITemplateId = params.get("TAIJITemplateId")
        self._AIMarketTemplateId = params.get("AIMarketTemplateId")
        self._AIMarketTemplateGroup = params.get("AIMarketTemplateGroup")
        if params.get("ResourceGroupAnnotationInfo") is not None:
            self._ResourceGroupAnnotationInfo = ResourceGroupAnnotationInfo()
            self._ResourceGroupAnnotationInfo._deserialize(params.get("ResourceGroupAnnotationInfo"))
        if params.get("SchedulePolicy") is not None:
            self._SchedulePolicy = SchedulePolicy()
            self._SchedulePolicy._deserialize(params.get("SchedulePolicy"))
        if params.get("EncodedStartCmdInfo") is not None:
            self._EncodedStartCmdInfo = EncodedStartCmdInfo()
            self._EncodedStartCmdInfo._deserialize(params.get("EncodedStartCmdInfo"))
        self._SourceTaskId = params.get("SourceTaskId")
        if params.get("CodeRepos") is not None:
            self._CodeRepos = []
            for item in params.get("CodeRepos"):
                obj = CodeRepoConfig()
                obj._deserialize(item)
                self._CodeRepos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTrainingTaskResponse(AbstractModel):
    """CreateTrainingTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 训练任务ID
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        """训练任务ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CreateVpcPrivateLinkRequest(AbstractModel):
    """CreateVpcPrivateLink请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: vpc id
        :type VpcId: str
        :param _SubnetId: 子网Id	
        :type SubnetId: str
        :param _MappingDomain: 用户自定义映射域名
        :type MappingDomain: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._MappingDomain = None

    @property
    def VpcId(self):
        """vpc id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网Id	
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def MappingDomain(self):
        """用户自定义映射域名
        :rtype: str
        """
        return self._MappingDomain

    @MappingDomain.setter
    def MappingDomain(self, MappingDomain):
        self._MappingDomain = MappingDomain


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._MappingDomain = params.get("MappingDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcPrivateLinkResponse(AbstractModel):
    """CreateVpcPrivateLink返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: id值
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        """id值
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CronInfo(AbstractModel):
    """跑批任务周期描述

    """

    def __init__(self):
        r"""
        :param _CronConfig: cron配置
        :type CronConfig: str
        :param _StartTime: 周期开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 周期结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        """
        self._CronConfig = None
        self._StartTime = None
        self._EndTime = None

    @property
    def CronConfig(self):
        """cron配置
        :rtype: str
        """
        return self._CronConfig

    @CronConfig.setter
    def CronConfig(self, CronConfig):
        self._CronConfig = CronConfig

    @property
    def StartTime(self):
        """周期开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """周期结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._CronConfig = params.get("CronConfig")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CronScaleJob(AbstractModel):
    """定时扩缩任务

    """

    def __init__(self):
        r"""
        :param _Schedule: Cron表达式，标识任务的执行时间，精确到分钟级
        :type Schedule: str
        :param _Name: 定时任务名
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _TargetReplicas: 目标实例数
注意：此字段可能返回 null，表示取不到有效值。
        :type TargetReplicas: int
        :param _MinReplicas: 目标min
注意：此字段可能返回 null，表示取不到有效值。
        :type MinReplicas: int
        :param _MaxReplicas: 目标max
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxReplicas: int
        :param _ExcludeDates: 例外时间，Cron表达式，在对应时间内不执行任务。最多支持3条。
注意：此字段可能返回 null，表示取不到有效值。
        :type ExcludeDates: list of str
        """
        self._Schedule = None
        self._Name = None
        self._TargetReplicas = None
        self._MinReplicas = None
        self._MaxReplicas = None
        self._ExcludeDates = None

    @property
    def Schedule(self):
        """Cron表达式，标识任务的执行时间，精确到分钟级
        :rtype: str
        """
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def Name(self):
        """定时任务名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TargetReplicas(self):
        """目标实例数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TargetReplicas

    @TargetReplicas.setter
    def TargetReplicas(self, TargetReplicas):
        self._TargetReplicas = TargetReplicas

    @property
    def MinReplicas(self):
        """目标min
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MinReplicas

    @MinReplicas.setter
    def MinReplicas(self, MinReplicas):
        self._MinReplicas = MinReplicas

    @property
    def MaxReplicas(self):
        """目标max
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MaxReplicas

    @MaxReplicas.setter
    def MaxReplicas(self, MaxReplicas):
        self._MaxReplicas = MaxReplicas

    @property
    def ExcludeDates(self):
        """例外时间，Cron表达式，在对应时间内不执行任务。最多支持3条。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ExcludeDates

    @ExcludeDates.setter
    def ExcludeDates(self, ExcludeDates):
        self._ExcludeDates = ExcludeDates


    def _deserialize(self, params):
        self._Schedule = params.get("Schedule")
        self._Name = params.get("Name")
        self._TargetReplicas = params.get("TargetReplicas")
        self._MinReplicas = params.get("MinReplicas")
        self._MaxReplicas = params.get("MaxReplicas")
        self._ExcludeDates = params.get("ExcludeDates")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CrossTenantENIInfo(AbstractModel):
    """跨租户弹性网卡下Pod调用信息

    """

    def __init__(self):
        r"""
        :param _PrimaryIP: Pod IP
注意：此字段可能返回 null，表示取不到有效值。
        :type PrimaryIP: str
        :param _Port: Pod Port
注意：此字段可能返回 null，表示取不到有效值。
        :type Port: str
        """
        self._PrimaryIP = None
        self._Port = None

    @property
    def PrimaryIP(self):
        """Pod IP
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PrimaryIP

    @PrimaryIP.setter
    def PrimaryIP(self, PrimaryIP):
        self._PrimaryIP = PrimaryIP

    @property
    def Port(self):
        """Pod Port
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._PrimaryIP = params.get("PrimaryIP")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomTrainingData(AbstractModel):
    """自定义指标

    """

    def __init__(self):
        r"""
        :param _MetricName: 指标名
注意：此字段可能返回 null，表示取不到有效值。
        :type MetricName: str
        :param _Metrics: 指标
注意：此字段可能返回 null，表示取不到有效值。
        :type Metrics: list of CustomTrainingMetric
        """
        self._MetricName = None
        self._Metrics = None

    @property
    def MetricName(self):
        """指标名
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def Metrics(self):
        """指标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CustomTrainingMetric
        """
        return self._Metrics

    @Metrics.setter
    def Metrics(self, Metrics):
        self._Metrics = Metrics


    def _deserialize(self, params):
        self._MetricName = params.get("MetricName")
        if params.get("Metrics") is not None:
            self._Metrics = []
            for item in params.get("Metrics"):
                obj = CustomTrainingMetric()
                obj._deserialize(item)
                self._Metrics.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomTrainingMetric(AbstractModel):
    """自定义指标

    """

    def __init__(self):
        r"""
        :param _XType: X轴数据类型: TIMESTAMP; EPOCH; STEP
        :type XType: str
        :param _Points: 数据点
注意：此字段可能返回 null，表示取不到有效值。
        :type Points: list of CustomTrainingPoint
        """
        self._XType = None
        self._Points = None

    @property
    def XType(self):
        """X轴数据类型: TIMESTAMP; EPOCH; STEP
        :rtype: str
        """
        return self._XType

    @XType.setter
    def XType(self, XType):
        self._XType = XType

    @property
    def Points(self):
        """数据点
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CustomTrainingPoint
        """
        return self._Points

    @Points.setter
    def Points(self, Points):
        self._Points = Points


    def _deserialize(self, params):
        self._XType = params.get("XType")
        if params.get("Points") is not None:
            self._Points = []
            for item in params.get("Points"):
                obj = CustomTrainingPoint()
                obj._deserialize(item)
                self._Points.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomTrainingPoint(AbstractModel):
    """自定义训练指标数据点

    """

    def __init__(self):
        r"""
        :param _XValue: X值
        :type XValue: float
        :param _YValue: Y值
        :type YValue: float
        """
        self._XValue = None
        self._YValue = None

    @property
    def XValue(self):
        """X值
        :rtype: float
        """
        return self._XValue

    @XValue.setter
    def XValue(self, XValue):
        self._XValue = XValue

    @property
    def YValue(self):
        """Y值
        :rtype: float
        """
        return self._YValue

    @YValue.setter
    def YValue(self, YValue):
        self._YValue = YValue


    def _deserialize(self, params):
        self._XValue = params.get("XValue")
        self._YValue = params.get("YValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataArray(AbstractModel):
    """数组信息

    """

    def __init__(self):
        r"""
        :param _Values: 数组信息
        :type Values: list of float
        """
        self._Values = None

    @property
    def Values(self):
        """数组信息
        :rtype: list of float
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataCenterDataSource(AbstractModel):
    """数据中心数据源存储（私有化使用）

    """


class DataConfig(AbstractModel):
    """数据配置

    """

    def __init__(self):
        r"""
        :param _MappingPath: 映射路径
        :type MappingPath: str
        :param _DataSourceUsage: 存储用途
可选值为 BUILTIN_CODE, BUILTIN_DATA, BUILTIN_MODEL, USER_DATA, USER_CODE, USER_MODEL, OUTPUT, OTHER
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSourceUsage: str
        :param _DataSourceType: DATASET、COS、CFS、CFSTurbo、GooseFSx、HDFS、WEDATA_HDFS
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSourceType: str
        :param _DataSetSource: 来自数据集的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSetSource: :class:`tencentcloud.tione.v20211111.models.DataSetConfig`
        :param _COSSource: 来自cos的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type COSSource: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _CFSSource: 来自CFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type CFSSource: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        :param _HDFSSource: 来自HDFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type HDFSSource: :class:`tencentcloud.tione.v20211111.models.HDFSConfig`
        :param _WeDataHDFSSource: 来自WEDATA_HDFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type WeDataHDFSSource: :class:`tencentcloud.tione.v20211111.models.WeDataHDFSConfig`
        :param _AIMarketAlgoPreModelSource: 配置AI市场算法预训练模型作为数据
注意：此字段可能返回 null，表示取不到有效值。
        :type AIMarketAlgoPreModelSource: :class:`tencentcloud.tione.v20211111.models.AIMarketAlgo`
        :param _GooseFSSource: 配置GooseFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type GooseFSSource: :class:`tencentcloud.tione.v20211111.models.GooseFS`
        :param _CFSTurboSource: 配置TurboFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :type CFSTurboSource: :class:`tencentcloud.tione.v20211111.models.CFSTurbo`
        :param _AIMarketAlgoDataSource: 配置AI市场内置数据
注意：此字段可能返回 null，表示取不到有效值。
        :type AIMarketAlgoDataSource: :class:`tencentcloud.tione.v20211111.models.AIMarketAlgo`
        :param _LocalDiskSource: 来自本地磁盘的信息
注意：此字段可能返回 null，表示取不到有效值。
        :type LocalDiskSource: :class:`tencentcloud.tione.v20211111.models.LocalDisk`
        :param _CBSSource: CBS配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type CBSSource: :class:`tencentcloud.tione.v20211111.models.CBSConfig`
        :param _HostPathSource: 主机路径信息
        :type HostPathSource: :class:`tencentcloud.tione.v20211111.models.HostPathSource`
        """
        self._MappingPath = None
        self._DataSourceUsage = None
        self._DataSourceType = None
        self._DataSetSource = None
        self._COSSource = None
        self._CFSSource = None
        self._HDFSSource = None
        self._WeDataHDFSSource = None
        self._AIMarketAlgoPreModelSource = None
        self._GooseFSSource = None
        self._CFSTurboSource = None
        self._AIMarketAlgoDataSource = None
        self._LocalDiskSource = None
        self._CBSSource = None
        self._HostPathSource = None

    @property
    def MappingPath(self):
        """映射路径
        :rtype: str
        """
        return self._MappingPath

    @MappingPath.setter
    def MappingPath(self, MappingPath):
        self._MappingPath = MappingPath

    @property
    def DataSourceUsage(self):
        """存储用途
可选值为 BUILTIN_CODE, BUILTIN_DATA, BUILTIN_MODEL, USER_DATA, USER_CODE, USER_MODEL, OUTPUT, OTHER
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataSourceUsage

    @DataSourceUsage.setter
    def DataSourceUsage(self, DataSourceUsage):
        self._DataSourceUsage = DataSourceUsage

    @property
    def DataSourceType(self):
        """DATASET、COS、CFS、CFSTurbo、GooseFSx、HDFS、WEDATA_HDFS
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DataSourceType

    @DataSourceType.setter
    def DataSourceType(self, DataSourceType):
        self._DataSourceType = DataSourceType

    @property
    def DataSetSource(self):
        """来自数据集的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.DataSetConfig`
        """
        return self._DataSetSource

    @DataSetSource.setter
    def DataSetSource(self, DataSetSource):
        self._DataSetSource = DataSetSource

    @property
    def COSSource(self):
        """来自cos的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._COSSource

    @COSSource.setter
    def COSSource(self, COSSource):
        self._COSSource = COSSource

    @property
    def CFSSource(self):
        """来自CFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        """
        return self._CFSSource

    @CFSSource.setter
    def CFSSource(self, CFSSource):
        self._CFSSource = CFSSource

    @property
    def HDFSSource(self):
        """来自HDFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.HDFSConfig`
        """
        return self._HDFSSource

    @HDFSSource.setter
    def HDFSSource(self, HDFSSource):
        self._HDFSSource = HDFSSource

    @property
    def WeDataHDFSSource(self):
        """来自WEDATA_HDFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.WeDataHDFSConfig`
        """
        return self._WeDataHDFSSource

    @WeDataHDFSSource.setter
    def WeDataHDFSSource(self, WeDataHDFSSource):
        self._WeDataHDFSSource = WeDataHDFSSource

    @property
    def AIMarketAlgoPreModelSource(self):
        """配置AI市场算法预训练模型作为数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.AIMarketAlgo`
        """
        return self._AIMarketAlgoPreModelSource

    @AIMarketAlgoPreModelSource.setter
    def AIMarketAlgoPreModelSource(self, AIMarketAlgoPreModelSource):
        self._AIMarketAlgoPreModelSource = AIMarketAlgoPreModelSource

    @property
    def GooseFSSource(self):
        """配置GooseFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.GooseFS`
        """
        return self._GooseFSSource

    @GooseFSSource.setter
    def GooseFSSource(self, GooseFSSource):
        self._GooseFSSource = GooseFSSource

    @property
    def CFSTurboSource(self):
        """配置TurboFS的数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSTurbo`
        """
        return self._CFSTurboSource

    @CFSTurboSource.setter
    def CFSTurboSource(self, CFSTurboSource):
        self._CFSTurboSource = CFSTurboSource

    @property
    def AIMarketAlgoDataSource(self):
        """配置AI市场内置数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.AIMarketAlgo`
        """
        return self._AIMarketAlgoDataSource

    @AIMarketAlgoDataSource.setter
    def AIMarketAlgoDataSource(self, AIMarketAlgoDataSource):
        self._AIMarketAlgoDataSource = AIMarketAlgoDataSource

    @property
    def LocalDiskSource(self):
        """来自本地磁盘的信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.LocalDisk`
        """
        return self._LocalDiskSource

    @LocalDiskSource.setter
    def LocalDiskSource(self, LocalDiskSource):
        self._LocalDiskSource = LocalDiskSource

    @property
    def CBSSource(self):
        """CBS配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CBSConfig`
        """
        return self._CBSSource

    @CBSSource.setter
    def CBSSource(self, CBSSource):
        self._CBSSource = CBSSource

    @property
    def HostPathSource(self):
        """主机路径信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.HostPathSource`
        """
        return self._HostPathSource

    @HostPathSource.setter
    def HostPathSource(self, HostPathSource):
        self._HostPathSource = HostPathSource


    def _deserialize(self, params):
        self._MappingPath = params.get("MappingPath")
        self._DataSourceUsage = params.get("DataSourceUsage")
        self._DataSourceType = params.get("DataSourceType")
        if params.get("DataSetSource") is not None:
            self._DataSetSource = DataSetConfig()
            self._DataSetSource._deserialize(params.get("DataSetSource"))
        if params.get("COSSource") is not None:
            self._COSSource = CosPathInfo()
            self._COSSource._deserialize(params.get("COSSource"))
        if params.get("CFSSource") is not None:
            self._CFSSource = CFSConfig()
            self._CFSSource._deserialize(params.get("CFSSource"))
        if params.get("HDFSSource") is not None:
            self._HDFSSource = HDFSConfig()
            self._HDFSSource._deserialize(params.get("HDFSSource"))
        if params.get("WeDataHDFSSource") is not None:
            self._WeDataHDFSSource = WeDataHDFSConfig()
            self._WeDataHDFSSource._deserialize(params.get("WeDataHDFSSource"))
        if params.get("AIMarketAlgoPreModelSource") is not None:
            self._AIMarketAlgoPreModelSource = AIMarketAlgo()
            self._AIMarketAlgoPreModelSource._deserialize(params.get("AIMarketAlgoPreModelSource"))
        if params.get("GooseFSSource") is not None:
            self._GooseFSSource = GooseFS()
            self._GooseFSSource._deserialize(params.get("GooseFSSource"))
        if params.get("CFSTurboSource") is not None:
            self._CFSTurboSource = CFSTurbo()
            self._CFSTurboSource._deserialize(params.get("CFSTurboSource"))
        if params.get("AIMarketAlgoDataSource") is not None:
            self._AIMarketAlgoDataSource = AIMarketAlgo()
            self._AIMarketAlgoDataSource._deserialize(params.get("AIMarketAlgoDataSource"))
        if params.get("LocalDiskSource") is not None:
            self._LocalDiskSource = LocalDisk()
            self._LocalDiskSource._deserialize(params.get("LocalDiskSource"))
        if params.get("CBSSource") is not None:
            self._CBSSource = CBSConfig()
            self._CBSSource._deserialize(params.get("CBSSource"))
        if params.get("HostPathSource") is not None:
            self._HostPathSource = HostPathSource()
            self._HostPathSource._deserialize(params.get("HostPathSource"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataDisk(AbstractModel):
    """CVM节点数据盘

    """

    def __init__(self):
        r"""
        :param _DiskSize: 云硬盘容量
注意：此字段可能返回 null，表示取不到有效值。
        :type DiskSize: int
        :param _DiskType: 云硬盘类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DiskType: str
        :param _DiskId: 云硬盘ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DiskId: str
        :param _DeleteWithInstance: 是否在CVM实例删除时一并删掉
注意：此字段可能返回 null，表示取不到有效值。
        :type DeleteWithInstance: bool
        :param _SnapshotId: 磁盘快照ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SnapshotId: str
        :param _Encrypt: 是否加密
注意：此字段可能返回 null，表示取不到有效值。
        :type Encrypt: bool
        :param _KmsKeyId: 加密key的ID
注意：此字段可能返回 null，表示取不到有效值。
        :type KmsKeyId: str
        :param _ThroughputPerformance: 云硬盘性能，单位：MB/s
注意：此字段可能返回 null，表示取不到有效值。
        :type ThroughputPerformance: int
        :param _CdcId: 所属的独享集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :type CdcId: str
        :param _BurstPerformance: 突发性能
注意：此字段可能返回 null，表示取不到有效值。
        :type BurstPerformance: bool
        """
        self._DiskSize = None
        self._DiskType = None
        self._DiskId = None
        self._DeleteWithInstance = None
        self._SnapshotId = None
        self._Encrypt = None
        self._KmsKeyId = None
        self._ThroughputPerformance = None
        self._CdcId = None
        self._BurstPerformance = None

    @property
    def DiskSize(self):
        """云硬盘容量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def DiskType(self):
        """云硬盘类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def DiskId(self):
        """云硬盘ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DiskId

    @DiskId.setter
    def DiskId(self, DiskId):
        self._DiskId = DiskId

    @property
    def DeleteWithInstance(self):
        """是否在CVM实例删除时一并删掉
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._DeleteWithInstance

    @DeleteWithInstance.setter
    def DeleteWithInstance(self, DeleteWithInstance):
        self._DeleteWithInstance = DeleteWithInstance

    @property
    def SnapshotId(self):
        """磁盘快照ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SnapshotId

    @SnapshotId.setter
    def SnapshotId(self, SnapshotId):
        self._SnapshotId = SnapshotId

    @property
    def Encrypt(self):
        """是否加密
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Encrypt

    @Encrypt.setter
    def Encrypt(self, Encrypt):
        self._Encrypt = Encrypt

    @property
    def KmsKeyId(self):
        """加密key的ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._KmsKeyId

    @KmsKeyId.setter
    def KmsKeyId(self, KmsKeyId):
        self._KmsKeyId = KmsKeyId

    @property
    def ThroughputPerformance(self):
        """云硬盘性能，单位：MB/s
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ThroughputPerformance

    @ThroughputPerformance.setter
    def ThroughputPerformance(self, ThroughputPerformance):
        self._ThroughputPerformance = ThroughputPerformance

    @property
    def CdcId(self):
        """所属的独享集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def BurstPerformance(self):
        """突发性能
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._BurstPerformance

    @BurstPerformance.setter
    def BurstPerformance(self, BurstPerformance):
        self._BurstPerformance = BurstPerformance


    def _deserialize(self, params):
        self._DiskSize = params.get("DiskSize")
        self._DiskType = params.get("DiskType")
        self._DiskId = params.get("DiskId")
        self._DeleteWithInstance = params.get("DeleteWithInstance")
        self._SnapshotId = params.get("SnapshotId")
        self._Encrypt = params.get("Encrypt")
        self._KmsKeyId = params.get("KmsKeyId")
        self._ThroughputPerformance = params.get("ThroughputPerformance")
        self._CdcId = params.get("CdcId")
        self._BurstPerformance = params.get("BurstPerformance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataPipelineConfig(AbstractModel):
    """数据构建Pipeline配置

    """

    def __init__(self):
        r"""
        :param _Pipeline: pipeline枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :type Pipeline: str
        :param _Name: pipeline名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Description: pipeline使用说明
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        """
        self._Pipeline = None
        self._Name = None
        self._Description = None

    @property
    def Pipeline(self):
        """pipeline枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Pipeline

    @Pipeline.setter
    def Pipeline(self, Pipeline):
        self._Pipeline = Pipeline

    @property
    def Name(self):
        """pipeline名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """pipeline使用说明
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Pipeline = params.get("Pipeline")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataPipelineTask(AbstractModel):
    """数据构建任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 数据构建任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 数据构建任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _Creator: 数据构建任务的创建者ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Creator: str
        :param _CreateTime: 数据构建任务的创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 数据构建任务的更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _DataPipelines: 当前数据构建任务所选择的Pipeline
注意：此字段可能返回 null，表示取不到有效值。
        :type DataPipelines: list of DataPipelineConfig
        :param _DataScenes: 当前数据构建任务所选择的通用算法任务
注意：此字段可能返回 null，表示取不到有效值。
        :type DataScenes: list of DataSceneConfig
        :param _Description: 数据构建任务的描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _NotebookId: 数据构建任务绑定的Notebook的ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NotebookId: str
        :param _NotebookName: 数据构建任务绑定的Notebook的名字
注意：此字段可能返回 null，表示取不到有效值。
        :type NotebookName: str
        :param _Tags: 数据构建任务标签
        :type Tags: list of Tag
        :param _CreatorNickname: 数据构建任务的创建者名称
        :type CreatorNickname: str
        """
        self._TaskId = None
        self._TaskName = None
        self._Creator = None
        self._CreateTime = None
        self._UpdateTime = None
        self._DataPipelines = None
        self._DataScenes = None
        self._Description = None
        self._NotebookId = None
        self._NotebookName = None
        self._Tags = None
        self._CreatorNickname = None

    @property
    def TaskId(self):
        """数据构建任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        """数据构建任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def Creator(self):
        """数据构建任务的创建者ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def CreateTime(self):
        """数据构建任务的创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """数据构建任务的更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def DataPipelines(self):
        """当前数据构建任务所选择的Pipeline
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataPipelineConfig
        """
        return self._DataPipelines

    @DataPipelines.setter
    def DataPipelines(self, DataPipelines):
        self._DataPipelines = DataPipelines

    @property
    def DataScenes(self):
        """当前数据构建任务所选择的通用算法任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataSceneConfig
        """
        return self._DataScenes

    @DataScenes.setter
    def DataScenes(self, DataScenes):
        self._DataScenes = DataScenes

    @property
    def Description(self):
        """数据构建任务的描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def NotebookId(self):
        """数据构建任务绑定的Notebook的ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NotebookId

    @NotebookId.setter
    def NotebookId(self, NotebookId):
        self._NotebookId = NotebookId

    @property
    def NotebookName(self):
        """数据构建任务绑定的Notebook的名字
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NotebookName

    @NotebookName.setter
    def NotebookName(self, NotebookName):
        self._NotebookName = NotebookName

    @property
    def Tags(self):
        """数据构建任务标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CreatorNickname(self):
        """数据构建任务的创建者名称
        :rtype: str
        """
        return self._CreatorNickname

    @CreatorNickname.setter
    def CreatorNickname(self, CreatorNickname):
        self._CreatorNickname = CreatorNickname


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._Creator = params.get("Creator")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("DataPipelines") is not None:
            self._DataPipelines = []
            for item in params.get("DataPipelines"):
                obj = DataPipelineConfig()
                obj._deserialize(item)
                self._DataPipelines.append(obj)
        if params.get("DataScenes") is not None:
            self._DataScenes = []
            for item in params.get("DataScenes"):
                obj = DataSceneConfig()
                obj._deserialize(item)
                self._DataScenes.append(obj)
        self._Description = params.get("Description")
        self._NotebookId = params.get("NotebookId")
        self._NotebookName = params.get("NotebookName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CreatorNickname = params.get("CreatorNickname")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataPoint(AbstractModel):
    """数据点

    """

    def __init__(self):
        r"""
        :param _Name: 指标名字
        :type Name: str
        :param _Value: 值
        :type Value: float
        """
        self._Name = None
        self._Value = None

    @property
    def Name(self):
        """指标名字
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        """值
        :rtype: float
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataPointMonitor(AbstractModel):
    """监控数据点

    """

    def __init__(self):
        r"""
        :param _Dimensions: 实例对象维度组合
        :type Dimensions: list of DimensionMonitor
        :param _Timestamps: 时间戳数组，表示那些时间点有数据，缺失的时间戳，没有数据点，可以理解为掉点了
        :type Timestamps: list of float
        :param _Values: 监控值数组，该数组和Timestamps一一对应
        :type Values: list of float
        """
        self._Dimensions = None
        self._Timestamps = None
        self._Values = None

    @property
    def Dimensions(self):
        """实例对象维度组合
        :rtype: list of DimensionMonitor
        """
        return self._Dimensions

    @Dimensions.setter
    def Dimensions(self, Dimensions):
        self._Dimensions = Dimensions

    @property
    def Timestamps(self):
        """时间戳数组，表示那些时间点有数据，缺失的时间戳，没有数据点，可以理解为掉点了
        :rtype: list of float
        """
        return self._Timestamps

    @Timestamps.setter
    def Timestamps(self, Timestamps):
        self._Timestamps = Timestamps

    @property
    def Values(self):
        """监控值数组，该数组和Timestamps一一对应
        :rtype: list of float
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        if params.get("Dimensions") is not None:
            self._Dimensions = []
            for item in params.get("Dimensions"):
                obj = DimensionMonitor()
                obj._deserialize(item)
                self._Dimensions.append(obj)
        self._Timestamps = params.get("Timestamps")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataRecordLLM(AbstractModel):
    """大模型数据单行样本

    """

    def __init__(self):
        r"""
        :param _RecordId: 样本ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RecordId: str
        :param _DatasetId: 数据集ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetId: str
        :param _Values: 样本内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Values: list of str
        :param _ImageList: 图片列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageList: list of ImageData
        :param _RecordIndex: 样本索引id
注意：此字段可能返回 null，表示取不到有效值。
        :type RecordIndex: int
        :param _FilePath: 样本所在文件路径
        :type FilePath: str
        :param _AnnotationStatus: 是否已标
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationStatus: int
        """
        self._RecordId = None
        self._DatasetId = None
        self._Values = None
        self._ImageList = None
        self._RecordIndex = None
        self._FilePath = None
        self._AnnotationStatus = None

    @property
    def RecordId(self):
        """样本ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def DatasetId(self):
        """数据集ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def Values(self):
        """样本内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ImageList(self):
        """图片列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ImageData
        """
        return self._ImageList

    @ImageList.setter
    def ImageList(self, ImageList):
        self._ImageList = ImageList

    @property
    def RecordIndex(self):
        """样本索引id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RecordIndex

    @RecordIndex.setter
    def RecordIndex(self, RecordIndex):
        self._RecordIndex = RecordIndex

    @property
    def FilePath(self):
        """样本所在文件路径
        :rtype: str
        """
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def AnnotationStatus(self):
        """是否已标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AnnotationStatus

    @AnnotationStatus.setter
    def AnnotationStatus(self, AnnotationStatus):
        self._AnnotationStatus = AnnotationStatus


    def _deserialize(self, params):
        self._RecordId = params.get("RecordId")
        self._DatasetId = params.get("DatasetId")
        self._Values = params.get("Values")
        if params.get("ImageList") is not None:
            self._ImageList = []
            for item in params.get("ImageList"):
                obj = ImageData()
                obj._deserialize(item)
                self._ImageList.append(obj)
        self._RecordIndex = params.get("RecordIndex")
        self._FilePath = params.get("FilePath")
        self._AnnotationStatus = params.get("AnnotationStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSceneConfig(AbstractModel):
    """数据构建通用算法任务信息

    """

    def __init__(self):
        r"""
        :param _ClassNames: 通用算法任务所属类别名称列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassNames: list of str
        :param _Scene: 通用算法任务对应场景ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Scene: str
        """
        self._ClassNames = None
        self._Scene = None

    @property
    def ClassNames(self):
        """通用算法任务所属类别名称列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ClassNames

    @ClassNames.setter
    def ClassNames(self, ClassNames):
        self._ClassNames = ClassNames

    @property
    def Scene(self):
        """通用算法任务对应场景ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene


    def _deserialize(self, params):
        self._ClassNames = params.get("ClassNames")
        self._Scene = params.get("Scene")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSceneNode(AbstractModel):
    """数据构建通用算法任务类别树节点

    """

    def __init__(self):
        r"""
        :param _ClassName: 通用算法任务所属类别名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassName: str
        :param _Scene: 通用算法任务对应场景ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Scene: str
        :param _Children: 子类别节点列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Children: list of DataSceneNode
        """
        self._ClassName = None
        self._Scene = None
        self._Children = None

    @property
    def ClassName(self):
        """通用算法任务所属类别名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ClassName

    @ClassName.setter
    def ClassName(self, ClassName):
        self._ClassName = ClassName

    @property
    def Scene(self):
        """通用算法任务对应场景ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene

    @property
    def Children(self):
        """子类别节点列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataSceneNode
        """
        return self._Children

    @Children.setter
    def Children(self, Children):
        self._Children = Children


    def _deserialize(self, params):
        self._ClassName = params.get("ClassName")
        self._Scene = params.get("Scene")
        if params.get("Children") is not None:
            self._Children = []
            for item in params.get("Children"):
                obj = DataSceneNode()
                obj._deserialize(item)
                self._Children.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSetConfig(AbstractModel):
    """数据集结构体

    """

    def __init__(self):
        r"""
        :param _Id: 数据集ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """数据集ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasetConfigs(AbstractModel):
    """自动学习数据集配置信息

    """

    def __init__(self):
        r"""
        :param _TrainDatasetId: 自动学习训练数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainDatasetId: str
        :param _ValidationDatasetId: 自动学习验证数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :type ValidationDatasetId: str
        :param _TestDatasetId: 自动学习测试数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :type TestDatasetId: str
        """
        self._TrainDatasetId = None
        self._ValidationDatasetId = None
        self._TestDatasetId = None

    @property
    def TrainDatasetId(self):
        """自动学习训练数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainDatasetId

    @TrainDatasetId.setter
    def TrainDatasetId(self, TrainDatasetId):
        self._TrainDatasetId = TrainDatasetId

    @property
    def ValidationDatasetId(self):
        """自动学习验证数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ValidationDatasetId

    @ValidationDatasetId.setter
    def ValidationDatasetId(self, ValidationDatasetId):
        self._ValidationDatasetId = ValidationDatasetId

    @property
    def TestDatasetId(self):
        """自动学习测试数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TestDatasetId

    @TestDatasetId.setter
    def TestDatasetId(self, TestDatasetId):
        self._TestDatasetId = TestDatasetId


    def _deserialize(self, params):
        self._TrainDatasetId = params.get("TrainDatasetId")
        self._ValidationDatasetId = params.get("ValidationDatasetId")
        self._TestDatasetId = params.get("TestDatasetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasetFileInfo(AbstractModel):
    """数据集快照存储详情

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetId: str
        :param _StorageDataPath: 数据源cos 信息
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageDataPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _StorageLabelPath: 数据集存储cos信息
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageLabelPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _DatasetName: 数据集名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetName: str
        :param _DatasetVersion: 数据集版本
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetVersion: str
        """
        self._DatasetId = None
        self._StorageDataPath = None
        self._StorageLabelPath = None
        self._DatasetName = None
        self._DatasetVersion = None

    @property
    def DatasetId(self):
        """数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def StorageDataPath(self):
        """数据源cos 信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageDataPath

    @StorageDataPath.setter
    def StorageDataPath(self, StorageDataPath):
        self._StorageDataPath = StorageDataPath

    @property
    def StorageLabelPath(self):
        """数据集存储cos信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageLabelPath

    @StorageLabelPath.setter
    def StorageLabelPath(self, StorageLabelPath):
        self._StorageLabelPath = StorageLabelPath

    @property
    def DatasetName(self):
        """数据集名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetName

    @DatasetName.setter
    def DatasetName(self, DatasetName):
        self._DatasetName = DatasetName

    @property
    def DatasetVersion(self):
        """数据集版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetVersion

    @DatasetVersion.setter
    def DatasetVersion(self, DatasetVersion):
        self._DatasetVersion = DatasetVersion


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        if params.get("StorageDataPath") is not None:
            self._StorageDataPath = CosPathInfo()
            self._StorageDataPath._deserialize(params.get("StorageDataPath"))
        if params.get("StorageLabelPath") is not None:
            self._StorageLabelPath = CosPathInfo()
            self._StorageLabelPath._deserialize(params.get("StorageLabelPath"))
        self._DatasetName = params.get("DatasetName")
        self._DatasetVersion = params.get("DatasetVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasetFileProcessInfo(AbstractModel):
    """数据集文件处理信息

    """

    def __init__(self):
        r"""
        :param _FilePath: 文件路径
注意：此字段可能返回 null，表示取不到有效值。
        :type FilePath: str
        :param _FileStatus: 文件处理状态
注意：此字段可能返回 null，表示取不到有效值。
        :type FileStatus: str
        :param _SuccessCount: 解析成功的样本数量
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailedCount: 解析失败的样本数量
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedCount: int
        :param _FailedSampleCosPath: 失败的文件cos地址
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedSampleCosPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _FailedSampleFile: 失败的文件url
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedSampleFile: str
        """
        self._FilePath = None
        self._FileStatus = None
        self._SuccessCount = None
        self._FailedCount = None
        self._FailedSampleCosPath = None
        self._FailedSampleFile = None

    @property
    def FilePath(self):
        """文件路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def FileStatus(self):
        """文件处理状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FileStatus

    @FileStatus.setter
    def FileStatus(self, FileStatus):
        self._FileStatus = FileStatus

    @property
    def SuccessCount(self):
        """解析成功的样本数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """解析失败的样本数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def FailedSampleCosPath(self):
        """失败的文件cos地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._FailedSampleCosPath

    @FailedSampleCosPath.setter
    def FailedSampleCosPath(self, FailedSampleCosPath):
        self._FailedSampleCosPath = FailedSampleCosPath

    @property
    def FailedSampleFile(self):
        """失败的文件url
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FailedSampleFile

    @FailedSampleFile.setter
    def FailedSampleFile(self, FailedSampleFile):
        self._FailedSampleFile = FailedSampleFile


    def _deserialize(self, params):
        self._FilePath = params.get("FilePath")
        self._FileStatus = params.get("FileStatus")
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        if params.get("FailedSampleCosPath") is not None:
            self._FailedSampleCosPath = CosPathInfo()
            self._FailedSampleCosPath._deserialize(params.get("FailedSampleCosPath"))
        self._FailedSampleFile = params.get("FailedSampleFile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasetGroup(AbstractModel):
    """数据集组

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetId: str
        :param _DatasetName: 数据集名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetName: str
        :param _Creator: 创建者
注意：此字段可能返回 null，表示取不到有效值。
        :type Creator: str
        :param _DatasetVersion: 数据集版本
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetVersion: str
        :param _DatasetType: 数据集类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetType: str
        :param _DatasetTags: 数据集标签
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetTags: list of Tag
        :param _DatasetAnnotationTaskName: 数据集标注任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetAnnotationTaskName: str
        :param _DatasetAnnotationTaskId: 数据集标注任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetAnnotationTaskId: str
        :param _Process: 处理进度
注意：此字段可能返回 null，表示取不到有效值。
        :type Process: int
        :param _DatasetStatus: 数据集状态
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetStatus: str
        :param _ErrorMsg: 错误详情
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMsg: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _ExternalTaskType: 外部关联TASKType
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalTaskType: str
        :param _DatasetSize: 数据集大小
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetSize: str
        :param _FileNum: 数据集数据量
注意：此字段可能返回 null，表示取不到有效值。
        :type FileNum: int
        :param _StorageDataPath: 数据集源COS路径
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageDataPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _StorageLabelPath: 数据集标签存储路径
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageLabelPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _DatasetVersions: 数据集版本聚合详情
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetVersions: list of DatasetInfo
        :param _AnnotationStatus: 数据集标注状态
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationStatus: str
        :param _AnnotationType: 数据集类型
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationType: str
        :param _AnnotationFormat: 数据集标注格式
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationFormat: str
        :param _DatasetScope: 数据集范围
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetScope: str
        :param _OcrScene: 数据集OCR子场景
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrScene: str
        :param _AnnotationKeyStatus: 数据集字典修改状态
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationKeyStatus: str
        :param _ContentType: 文本数据集导入方式
注意：此字段可能返回 null，表示取不到有效值。
        :type ContentType: str
        :param _DatasetScene: 数据集建模类别。
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetScene: str
        :param _CFSConfig: CFS配置
注意：此字段可能返回 null，表示取不到有效值。
        :type CFSConfig: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        :param _SceneTags: 数据集标签
注意：此字段可能返回 null，表示取不到有效值。
        :type SceneTags: list of str
        :param _NumAnnotated: 已标注数量
注意：此字段可能返回 null，表示取不到有效值。
        :type NumAnnotated: int
        :param _AnnotationSpecification: 标注规范
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationSpecification: str
        :param _AnnotationSchemaConfigured: 标注Schema是否配置
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationSchemaConfigured: bool
        :param _CreatorNickname: 创建者名称
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatorNickname: str
        :param _IsCfsUpdated: cfs路径是否有修改
注意：此字段可能返回 null，表示取不到有效值。
        :type IsCfsUpdated: bool
        """
        self._DatasetId = None
        self._DatasetName = None
        self._Creator = None
        self._DatasetVersion = None
        self._DatasetType = None
        self._DatasetTags = None
        self._DatasetAnnotationTaskName = None
        self._DatasetAnnotationTaskId = None
        self._Process = None
        self._DatasetStatus = None
        self._ErrorMsg = None
        self._CreateTime = None
        self._UpdateTime = None
        self._ExternalTaskType = None
        self._DatasetSize = None
        self._FileNum = None
        self._StorageDataPath = None
        self._StorageLabelPath = None
        self._DatasetVersions = None
        self._AnnotationStatus = None
        self._AnnotationType = None
        self._AnnotationFormat = None
        self._DatasetScope = None
        self._OcrScene = None
        self._AnnotationKeyStatus = None
        self._ContentType = None
        self._DatasetScene = None
        self._CFSConfig = None
        self._SceneTags = None
        self._NumAnnotated = None
        self._AnnotationSpecification = None
        self._AnnotationSchemaConfigured = None
        self._CreatorNickname = None
        self._IsCfsUpdated = None

    @property
    def DatasetId(self):
        """数据集ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def DatasetName(self):
        """数据集名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetName

    @DatasetName.setter
    def DatasetName(self, DatasetName):
        self._DatasetName = DatasetName

    @property
    def Creator(self):
        """创建者
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def DatasetVersion(self):
        """数据集版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetVersion

    @DatasetVersion.setter
    def DatasetVersion(self, DatasetVersion):
        self._DatasetVersion = DatasetVersion

    @property
    def DatasetType(self):
        """数据集类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetType

    @DatasetType.setter
    def DatasetType(self, DatasetType):
        self._DatasetType = DatasetType

    @property
    def DatasetTags(self):
        """数据集标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._DatasetTags

    @DatasetTags.setter
    def DatasetTags(self, DatasetTags):
        self._DatasetTags = DatasetTags

    @property
    def DatasetAnnotationTaskName(self):
        """数据集标注任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetAnnotationTaskName

    @DatasetAnnotationTaskName.setter
    def DatasetAnnotationTaskName(self, DatasetAnnotationTaskName):
        self._DatasetAnnotationTaskName = DatasetAnnotationTaskName

    @property
    def DatasetAnnotationTaskId(self):
        """数据集标注任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetAnnotationTaskId

    @DatasetAnnotationTaskId.setter
    def DatasetAnnotationTaskId(self, DatasetAnnotationTaskId):
        self._DatasetAnnotationTaskId = DatasetAnnotationTaskId

    @property
    def Process(self):
        """处理进度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def DatasetStatus(self):
        """数据集状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetStatus

    @DatasetStatus.setter
    def DatasetStatus(self, DatasetStatus):
        self._DatasetStatus = DatasetStatus

    @property
    def ErrorMsg(self):
        """错误详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def CreateTime(self):
        """创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ExternalTaskType(self):
        """外部关联TASKType
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalTaskType

    @ExternalTaskType.setter
    def ExternalTaskType(self, ExternalTaskType):
        self._ExternalTaskType = ExternalTaskType

    @property
    def DatasetSize(self):
        """数据集大小
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetSize

    @DatasetSize.setter
    def DatasetSize(self, DatasetSize):
        self._DatasetSize = DatasetSize

    @property
    def FileNum(self):
        """数据集数据量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FileNum

    @FileNum.setter
    def FileNum(self, FileNum):
        self._FileNum = FileNum

    @property
    def StorageDataPath(self):
        """数据集源COS路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageDataPath

    @StorageDataPath.setter
    def StorageDataPath(self, StorageDataPath):
        self._StorageDataPath = StorageDataPath

    @property
    def StorageLabelPath(self):
        """数据集标签存储路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageLabelPath

    @StorageLabelPath.setter
    def StorageLabelPath(self, StorageLabelPath):
        self._StorageLabelPath = StorageLabelPath

    @property
    def DatasetVersions(self):
        """数据集版本聚合详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DatasetInfo
        """
        return self._DatasetVersions

    @DatasetVersions.setter
    def DatasetVersions(self, DatasetVersions):
        self._DatasetVersions = DatasetVersions

    @property
    def AnnotationStatus(self):
        """数据集标注状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationStatus

    @AnnotationStatus.setter
    def AnnotationStatus(self, AnnotationStatus):
        self._AnnotationStatus = AnnotationStatus

    @property
    def AnnotationType(self):
        """数据集类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationType

    @AnnotationType.setter
    def AnnotationType(self, AnnotationType):
        self._AnnotationType = AnnotationType

    @property
    def AnnotationFormat(self):
        """数据集标注格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationFormat

    @AnnotationFormat.setter
    def AnnotationFormat(self, AnnotationFormat):
        self._AnnotationFormat = AnnotationFormat

    @property
    def DatasetScope(self):
        """数据集范围
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetScope

    @DatasetScope.setter
    def DatasetScope(self, DatasetScope):
        self._DatasetScope = DatasetScope

    @property
    def OcrScene(self):
        """数据集OCR子场景
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OcrScene

    @OcrScene.setter
    def OcrScene(self, OcrScene):
        self._OcrScene = OcrScene

    @property
    def AnnotationKeyStatus(self):
        """数据集字典修改状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationKeyStatus

    @AnnotationKeyStatus.setter
    def AnnotationKeyStatus(self, AnnotationKeyStatus):
        self._AnnotationKeyStatus = AnnotationKeyStatus

    @property
    def ContentType(self):
        """文本数据集导入方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ContentType

    @ContentType.setter
    def ContentType(self, ContentType):
        self._ContentType = ContentType

    @property
    def DatasetScene(self):
        """数据集建模类别。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetScene

    @DatasetScene.setter
    def DatasetScene(self, DatasetScene):
        self._DatasetScene = DatasetScene

    @property
    def CFSConfig(self):
        """CFS配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        """
        return self._CFSConfig

    @CFSConfig.setter
    def CFSConfig(self, CFSConfig):
        self._CFSConfig = CFSConfig

    @property
    def SceneTags(self):
        """数据集标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._SceneTags

    @SceneTags.setter
    def SceneTags(self, SceneTags):
        self._SceneTags = SceneTags

    @property
    def NumAnnotated(self):
        """已标注数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._NumAnnotated

    @NumAnnotated.setter
    def NumAnnotated(self, NumAnnotated):
        self._NumAnnotated = NumAnnotated

    @property
    def AnnotationSpecification(self):
        """标注规范
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationSpecification

    @AnnotationSpecification.setter
    def AnnotationSpecification(self, AnnotationSpecification):
        self._AnnotationSpecification = AnnotationSpecification

    @property
    def AnnotationSchemaConfigured(self):
        """标注Schema是否配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._AnnotationSchemaConfigured

    @AnnotationSchemaConfigured.setter
    def AnnotationSchemaConfigured(self, AnnotationSchemaConfigured):
        self._AnnotationSchemaConfigured = AnnotationSchemaConfigured

    @property
    def CreatorNickname(self):
        """创建者名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreatorNickname

    @CreatorNickname.setter
    def CreatorNickname(self, CreatorNickname):
        self._CreatorNickname = CreatorNickname

    @property
    def IsCfsUpdated(self):
        """cfs路径是否有修改
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsCfsUpdated

    @IsCfsUpdated.setter
    def IsCfsUpdated(self, IsCfsUpdated):
        self._IsCfsUpdated = IsCfsUpdated


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        self._DatasetName = params.get("DatasetName")
        self._Creator = params.get("Creator")
        self._DatasetVersion = params.get("DatasetVersion")
        self._DatasetType = params.get("DatasetType")
        if params.get("DatasetTags") is not None:
            self._DatasetTags = []
            for item in params.get("DatasetTags"):
                obj = Tag()
                obj._deserialize(item)
                self._DatasetTags.append(obj)
        self._DatasetAnnotationTaskName = params.get("DatasetAnnotationTaskName")
        self._DatasetAnnotationTaskId = params.get("DatasetAnnotationTaskId")
        self._Process = params.get("Process")
        self._DatasetStatus = params.get("DatasetStatus")
        self._ErrorMsg = params.get("ErrorMsg")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._ExternalTaskType = params.get("ExternalTaskType")
        self._DatasetSize = params.get("DatasetSize")
        self._FileNum = params.get("FileNum")
        if params.get("StorageDataPath") is not None:
            self._StorageDataPath = CosPathInfo()
            self._StorageDataPath._deserialize(params.get("StorageDataPath"))
        if params.get("StorageLabelPath") is not None:
            self._StorageLabelPath = CosPathInfo()
            self._StorageLabelPath._deserialize(params.get("StorageLabelPath"))
        if params.get("DatasetVersions") is not None:
            self._DatasetVersions = []
            for item in params.get("DatasetVersions"):
                obj = DatasetInfo()
                obj._deserialize(item)
                self._DatasetVersions.append(obj)
        self._AnnotationStatus = params.get("AnnotationStatus")
        self._AnnotationType = params.get("AnnotationType")
        self._AnnotationFormat = params.get("AnnotationFormat")
        self._DatasetScope = params.get("DatasetScope")
        self._OcrScene = params.get("OcrScene")
        self._AnnotationKeyStatus = params.get("AnnotationKeyStatus")
        self._ContentType = params.get("ContentType")
        self._DatasetScene = params.get("DatasetScene")
        if params.get("CFSConfig") is not None:
            self._CFSConfig = CFSConfig()
            self._CFSConfig._deserialize(params.get("CFSConfig"))
        self._SceneTags = params.get("SceneTags")
        self._NumAnnotated = params.get("NumAnnotated")
        self._AnnotationSpecification = params.get("AnnotationSpecification")
        self._AnnotationSchemaConfigured = params.get("AnnotationSchemaConfigured")
        self._CreatorNickname = params.get("CreatorNickname")
        self._IsCfsUpdated = params.get("IsCfsUpdated")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasetInfo(AbstractModel):
    """数据集详情

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetId: str
        :param _DatasetName: 数据集名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetName: str
        :param _Creator: 数据集创建者
注意：此字段可能返回 null，表示取不到有效值。
        :type Creator: str
        :param _DatasetVersion: 数据集版本
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetVersion: str
        :param _DatasetType: 数据集类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetType: str
        :param _DatasetTags: 数据集标签
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetTags: list of Tag
        :param _DatasetAnnotationTaskName: 数据集对应标注任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetAnnotationTaskName: str
        :param _DatasetAnnotationTaskId: 数据集对应标注任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetAnnotationTaskId: str
        :param _Process: 处理进度
注意：此字段可能返回 null，表示取不到有效值。
        :type Process: int
        :param _DatasetStatus: 数据集状态
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetStatus: str
        :param _ErrorMsg: 错误详情
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMsg: str
        :param _CreateTime: 数据集创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 数据集更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _ExternalTaskType: 外部任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ExternalTaskType: str
        :param _DatasetSize: 数据集存储大小
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetSize: str
        :param _FileNum: 数据集数据数量
注意：此字段可能返回 null，表示取不到有效值。
        :type FileNum: int
        :param _StorageDataPath: 数据集源cos 路径
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageDataPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _StorageLabelPath: 数据集输出cos路径
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageLabelPath: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _AnnotationStatus: 数据集标注状态
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationStatus: str
        :param _AnnotationType: 数据集类型
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationType: str
        :param _AnnotationFormat: 数据集标注格式
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationFormat: str
        :param _DatasetScope: 数据集范围
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetScope: str
        :param _OcrScene: 数据集OCR子场景
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrScene: str
        :param _AnnotationKeyStatus: 数据集字典修改状态
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationKeyStatus: str
        :param _ContentType: 内容类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ContentType: str
        :param _DatasetScene: 数据集建模类别。
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetScene: str
        :param _CFSConfig: CFS配置
注意：此字段可能返回 null，表示取不到有效值。
        :type CFSConfig: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        :param _SceneTags: 数据集标签
注意：此字段可能返回 null，表示取不到有效值。
        :type SceneTags: list of str
        :param _NumAnnotated: 已标注数量
注意：此字段可能返回 null，表示取不到有效值。
        :type NumAnnotated: int
        :param _AnnotationSpecification: 标注规范
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationSpecification: str
        :param _AnnotationSchemaConfigured: 标注Schema是否配置
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationSchemaConfigured: bool
        :param _CreatorNickname: 创建者名称
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatorNickname: str
        :param _IsCfsUpdated: cfs路径是否有修改
注意：此字段可能返回 null，表示取不到有效值。
        :type IsCfsUpdated: bool
        """
        self._DatasetId = None
        self._DatasetName = None
        self._Creator = None
        self._DatasetVersion = None
        self._DatasetType = None
        self._DatasetTags = None
        self._DatasetAnnotationTaskName = None
        self._DatasetAnnotationTaskId = None
        self._Process = None
        self._DatasetStatus = None
        self._ErrorMsg = None
        self._CreateTime = None
        self._UpdateTime = None
        self._ExternalTaskType = None
        self._DatasetSize = None
        self._FileNum = None
        self._StorageDataPath = None
        self._StorageLabelPath = None
        self._AnnotationStatus = None
        self._AnnotationType = None
        self._AnnotationFormat = None
        self._DatasetScope = None
        self._OcrScene = None
        self._AnnotationKeyStatus = None
        self._ContentType = None
        self._DatasetScene = None
        self._CFSConfig = None
        self._SceneTags = None
        self._NumAnnotated = None
        self._AnnotationSpecification = None
        self._AnnotationSchemaConfigured = None
        self._CreatorNickname = None
        self._IsCfsUpdated = None

    @property
    def DatasetId(self):
        """数据集id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def DatasetName(self):
        """数据集名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetName

    @DatasetName.setter
    def DatasetName(self, DatasetName):
        self._DatasetName = DatasetName

    @property
    def Creator(self):
        """数据集创建者
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def DatasetVersion(self):
        """数据集版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetVersion

    @DatasetVersion.setter
    def DatasetVersion(self, DatasetVersion):
        self._DatasetVersion = DatasetVersion

    @property
    def DatasetType(self):
        """数据集类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetType

    @DatasetType.setter
    def DatasetType(self, DatasetType):
        self._DatasetType = DatasetType

    @property
    def DatasetTags(self):
        """数据集标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._DatasetTags

    @DatasetTags.setter
    def DatasetTags(self, DatasetTags):
        self._DatasetTags = DatasetTags

    @property
    def DatasetAnnotationTaskName(self):
        """数据集对应标注任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetAnnotationTaskName

    @DatasetAnnotationTaskName.setter
    def DatasetAnnotationTaskName(self, DatasetAnnotationTaskName):
        self._DatasetAnnotationTaskName = DatasetAnnotationTaskName

    @property
    def DatasetAnnotationTaskId(self):
        """数据集对应标注任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetAnnotationTaskId

    @DatasetAnnotationTaskId.setter
    def DatasetAnnotationTaskId(self, DatasetAnnotationTaskId):
        self._DatasetAnnotationTaskId = DatasetAnnotationTaskId

    @property
    def Process(self):
        """处理进度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def DatasetStatus(self):
        """数据集状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetStatus

    @DatasetStatus.setter
    def DatasetStatus(self, DatasetStatus):
        self._DatasetStatus = DatasetStatus

    @property
    def ErrorMsg(self):
        """错误详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def CreateTime(self):
        """数据集创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """数据集更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ExternalTaskType(self):
        """外部任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExternalTaskType

    @ExternalTaskType.setter
    def ExternalTaskType(self, ExternalTaskType):
        self._ExternalTaskType = ExternalTaskType

    @property
    def DatasetSize(self):
        """数据集存储大小
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetSize

    @DatasetSize.setter
    def DatasetSize(self, DatasetSize):
        self._DatasetSize = DatasetSize

    @property
    def FileNum(self):
        """数据集数据数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FileNum

    @FileNum.setter
    def FileNum(self, FileNum):
        self._FileNum = FileNum

    @property
    def StorageDataPath(self):
        """数据集源cos 路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageDataPath

    @StorageDataPath.setter
    def StorageDataPath(self, StorageDataPath):
        self._StorageDataPath = StorageDataPath

    @property
    def StorageLabelPath(self):
        """数据集输出cos路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._StorageLabelPath

    @StorageLabelPath.setter
    def StorageLabelPath(self, StorageLabelPath):
        self._StorageLabelPath = StorageLabelPath

    @property
    def AnnotationStatus(self):
        """数据集标注状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationStatus

    @AnnotationStatus.setter
    def AnnotationStatus(self, AnnotationStatus):
        self._AnnotationStatus = AnnotationStatus

    @property
    def AnnotationType(self):
        """数据集类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationType

    @AnnotationType.setter
    def AnnotationType(self, AnnotationType):
        self._AnnotationType = AnnotationType

    @property
    def AnnotationFormat(self):
        """数据集标注格式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationFormat

    @AnnotationFormat.setter
    def AnnotationFormat(self, AnnotationFormat):
        self._AnnotationFormat = AnnotationFormat

    @property
    def DatasetScope(self):
        """数据集范围
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetScope

    @DatasetScope.setter
    def DatasetScope(self, DatasetScope):
        self._DatasetScope = DatasetScope

    @property
    def OcrScene(self):
        """数据集OCR子场景
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OcrScene

    @OcrScene.setter
    def OcrScene(self, OcrScene):
        self._OcrScene = OcrScene

    @property
    def AnnotationKeyStatus(self):
        """数据集字典修改状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationKeyStatus

    @AnnotationKeyStatus.setter
    def AnnotationKeyStatus(self, AnnotationKeyStatus):
        self._AnnotationKeyStatus = AnnotationKeyStatus

    @property
    def ContentType(self):
        """内容类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ContentType

    @ContentType.setter
    def ContentType(self, ContentType):
        self._ContentType = ContentType

    @property
    def DatasetScene(self):
        """数据集建模类别。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetScene

    @DatasetScene.setter
    def DatasetScene(self, DatasetScene):
        self._DatasetScene = DatasetScene

    @property
    def CFSConfig(self):
        """CFS配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CFSConfig`
        """
        return self._CFSConfig

    @CFSConfig.setter
    def CFSConfig(self, CFSConfig):
        self._CFSConfig = CFSConfig

    @property
    def SceneTags(self):
        """数据集标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._SceneTags

    @SceneTags.setter
    def SceneTags(self, SceneTags):
        self._SceneTags = SceneTags

    @property
    def NumAnnotated(self):
        """已标注数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._NumAnnotated

    @NumAnnotated.setter
    def NumAnnotated(self, NumAnnotated):
        self._NumAnnotated = NumAnnotated

    @property
    def AnnotationSpecification(self):
        """标注规范
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AnnotationSpecification

    @AnnotationSpecification.setter
    def AnnotationSpecification(self, AnnotationSpecification):
        self._AnnotationSpecification = AnnotationSpecification

    @property
    def AnnotationSchemaConfigured(self):
        """标注Schema是否配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._AnnotationSchemaConfigured

    @AnnotationSchemaConfigured.setter
    def AnnotationSchemaConfigured(self, AnnotationSchemaConfigured):
        self._AnnotationSchemaConfigured = AnnotationSchemaConfigured

    @property
    def CreatorNickname(self):
        """创建者名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreatorNickname

    @CreatorNickname.setter
    def CreatorNickname(self, CreatorNickname):
        self._CreatorNickname = CreatorNickname

    @property
    def IsCfsUpdated(self):
        """cfs路径是否有修改
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsCfsUpdated

    @IsCfsUpdated.setter
    def IsCfsUpdated(self, IsCfsUpdated):
        self._IsCfsUpdated = IsCfsUpdated


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        self._DatasetName = params.get("DatasetName")
        self._Creator = params.get("Creator")
        self._DatasetVersion = params.get("DatasetVersion")
        self._DatasetType = params.get("DatasetType")
        if params.get("DatasetTags") is not None:
            self._DatasetTags = []
            for item in params.get("DatasetTags"):
                obj = Tag()
                obj._deserialize(item)
                self._DatasetTags.append(obj)
        self._DatasetAnnotationTaskName = params.get("DatasetAnnotationTaskName")
        self._DatasetAnnotationTaskId = params.get("DatasetAnnotationTaskId")
        self._Process = params.get("Process")
        self._DatasetStatus = params.get("DatasetStatus")
        self._ErrorMsg = params.get("ErrorMsg")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._ExternalTaskType = params.get("ExternalTaskType")
        self._DatasetSize = params.get("DatasetSize")
        self._FileNum = params.get("FileNum")
        if params.get("StorageDataPath") is not None:
            self._StorageDataPath = CosPathInfo()
            self._StorageDataPath._deserialize(params.get("StorageDataPath"))
        if params.get("StorageLabelPath") is not None:
            self._StorageLabelPath = CosPathInfo()
            self._StorageLabelPath._deserialize(params.get("StorageLabelPath"))
        self._AnnotationStatus = params.get("AnnotationStatus")
        self._AnnotationType = params.get("AnnotationType")
        self._AnnotationFormat = params.get("AnnotationFormat")
        self._DatasetScope = params.get("DatasetScope")
        self._OcrScene = params.get("OcrScene")
        self._AnnotationKeyStatus = params.get("AnnotationKeyStatus")
        self._ContentType = params.get("ContentType")
        self._DatasetScene = params.get("DatasetScene")
        if params.get("CFSConfig") is not None:
            self._CFSConfig = CFSConfig()
            self._CFSConfig._deserialize(params.get("CFSConfig"))
        self._SceneTags = params.get("SceneTags")
        self._NumAnnotated = params.get("NumAnnotated")
        self._AnnotationSpecification = params.get("AnnotationSpecification")
        self._AnnotationSchemaConfigured = params.get("AnnotationSchemaConfigured")
        self._CreatorNickname = params.get("CreatorNickname")
        self._IsCfsUpdated = params.get("IsCfsUpdated")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasetProgress(AbstractModel):
    """DatasetProgress

    """

    def __init__(self):
        r"""
        :param _DatasetCFSConfig: 数据集配置
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetCFSConfig: :class:`tencentcloud.tione.v20211111.models.SimpleCFSConfig`
        :param _ScoredCount: 已标注数量
注意：此字段可能返回 null，表示取不到有效值。
        :type ScoredCount: int
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        """
        self._DatasetCFSConfig = None
        self._ScoredCount = None
        self._TotalCount = None

    @property
    def DatasetCFSConfig(self):
        """数据集配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.SimpleCFSConfig`
        """
        return self._DatasetCFSConfig

    @DatasetCFSConfig.setter
    def DatasetCFSConfig(self, DatasetCFSConfig):
        self._DatasetCFSConfig = DatasetCFSConfig

    @property
    def ScoredCount(self):
        """已标注数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ScoredCount

    @ScoredCount.setter
    def ScoredCount(self, ScoredCount):
        self._ScoredCount = ScoredCount

    @property
    def TotalCount(self):
        """总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("DatasetCFSConfig") is not None:
            self._DatasetCFSConfig = SimpleCFSConfig()
            self._DatasetCFSConfig._deserialize(params.get("DatasetCFSConfig"))
        self._ScoredCount = params.get("ScoredCount")
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasetSceneConfig(AbstractModel):
    """数据集建模场景配置项

    """

    def __init__(self):
        r"""
        :param _DatasetScene: 数据集建模场景枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetScene: str
        :param _DatasetSceneName: 数据集建模场景名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetSceneName: str
        :param _AnnotationTypeConfigs: 标注场景配置项
注意：此字段可能返回 null，表示取不到有效值。
        :type AnnotationTypeConfigs: list of AnnotationTypeConfig
        """
        self._DatasetScene = None
        self._DatasetSceneName = None
        self._AnnotationTypeConfigs = None

    @property
    def DatasetScene(self):
        """数据集建模场景枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetScene

    @DatasetScene.setter
    def DatasetScene(self, DatasetScene):
        self._DatasetScene = DatasetScene

    @property
    def DatasetSceneName(self):
        """数据集建模场景名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DatasetSceneName

    @DatasetSceneName.setter
    def DatasetSceneName(self, DatasetSceneName):
        self._DatasetSceneName = DatasetSceneName

    @property
    def AnnotationTypeConfigs(self):
        """标注场景配置项
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AnnotationTypeConfig
        """
        return self._AnnotationTypeConfigs

    @AnnotationTypeConfigs.setter
    def AnnotationTypeConfigs(self, AnnotationTypeConfigs):
        self._AnnotationTypeConfigs = AnnotationTypeConfigs


    def _deserialize(self, params):
        self._DatasetScene = params.get("DatasetScene")
        self._DatasetSceneName = params.get("DatasetSceneName")
        if params.get("AnnotationTypeConfigs") is not None:
            self._AnnotationTypeConfigs = []
            for item in params.get("AnnotationTypeConfigs"):
                obj = AnnotationTypeConfig()
                obj._deserialize(item)
                self._AnnotationTypeConfigs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasetSchemaTask(AbstractModel):
    """数据集Schema任务

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskStatus: 任务状态
        :type TaskStatus: str
        :param _StartTime: 任务启动时间
        :type StartTime: int
        :param _Progress: 任务整体进度
        :type Progress: float
        :param _SuccessCount: 解析成功的样本数量
        :type SuccessCount: int
        :param _FailedCount: 解析失败的样本数量
        :type FailedCount: int
        :param _FailedSampleFile: 解析失败的样本文件URL
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedSampleFile: str
        :param _FileProcessInfo: 解析文件信息
注意：此字段可能返回 null，表示取不到有效值。
        :type FileProcessInfo: list of DatasetFileProcessInfo
        """
        self._TaskId = None
        self._TaskStatus = None
        self._StartTime = None
        self._Progress = None
        self._SuccessCount = None
        self._FailedCount = None
        self._FailedSampleFile = None
        self._FileProcessInfo = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskStatus(self):
        """任务状态
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def StartTime(self):
        """任务启动时间
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Progress(self):
        """任务整体进度
        :rtype: float
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def SuccessCount(self):
        """解析成功的样本数量
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        """解析失败的样本数量
        :rtype: int
        """
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def FailedSampleFile(self):
        """解析失败的样本文件URL
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FailedSampleFile

    @FailedSampleFile.setter
    def FailedSampleFile(self, FailedSampleFile):
        self._FailedSampleFile = FailedSampleFile

    @property
    def FileProcessInfo(self):
        """解析文件信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DatasetFileProcessInfo
        """
        return self._FileProcessInfo

    @FileProcessInfo.setter
    def FileProcessInfo(self, FileProcessInfo):
        self._FileProcessInfo = FileProcessInfo


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskStatus = params.get("TaskStatus")
        self._StartTime = params.get("StartTime")
        self._Progress = params.get("Progress")
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._FailedSampleFile = params.get("FailedSampleFile")
        if params.get("FileProcessInfo") is not None:
            self._FileProcessInfo = []
            for item in params.get("FileProcessInfo"):
                obj = DatasetFileProcessInfo()
                obj._deserialize(item)
                self._FileProcessInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasetWithResults(AbstractModel):
    """DatasetWithResults

    """

    def __init__(self):
        r"""
        :param _DatasetCFSConfig: 评测集路径信息
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasetCFSConfig: :class:`tencentcloud.tione.v20211111.models.SimpleCFSConfig`
        :param _OutputCFSConfigs: 输出路径信息
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputCFSConfigs: list of SimpleCFSConfig
        """
        self._DatasetCFSConfig = None
        self._OutputCFSConfigs = None

    @property
    def DatasetCFSConfig(self):
        """评测集路径信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.SimpleCFSConfig`
        """
        return self._DatasetCFSConfig

    @DatasetCFSConfig.setter
    def DatasetCFSConfig(self, DatasetCFSConfig):
        self._DatasetCFSConfig = DatasetCFSConfig

    @property
    def OutputCFSConfigs(self):
        """输出路径信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SimpleCFSConfig
        """
        return self._OutputCFSConfigs

    @OutputCFSConfigs.setter
    def OutputCFSConfigs(self, OutputCFSConfigs):
        self._OutputCFSConfigs = OutputCFSConfigs


    def _deserialize(self, params):
        if params.get("DatasetCFSConfig") is not None:
            self._DatasetCFSConfig = SimpleCFSConfig()
            self._DatasetCFSConfig._deserialize(params.get("DatasetCFSConfig"))
        if params.get("OutputCFSConfigs") is not None:
            self._OutputCFSConfigs = []
            for item in params.get("OutputCFSConfigs"):
                obj = SimpleCFSConfig()
                obj._deserialize(item)
                self._OutputCFSConfigs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DefaultInnerCallInfo(AbstractModel):
    """默认内网调用信息

    """

    def __init__(self):
        r"""
        :param _VpcIds: 可以进行调用的VPC-ID
注意：此字段可能返回 null，表示取不到有效值。
        :type VpcIds: list of str
        :param _InnerHttpAddr: 默认内网调用地址
注意：此字段可能返回 null，表示取不到有效值。
        :type InnerHttpAddr: str
        """
        self._VpcIds = None
        self._InnerHttpAddr = None

    @property
    def VpcIds(self):
        """可以进行调用的VPC-ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds

    @property
    def InnerHttpAddr(self):
        """默认内网调用地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InnerHttpAddr

    @InnerHttpAddr.setter
    def InnerHttpAddr(self, InnerHttpAddr):
        self._InnerHttpAddr = InnerHttpAddr


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        self._InnerHttpAddr = params.get("InnerHttpAddr")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DefaultNginxGatewayCallInfo(AbstractModel):
    """默认Nginx网关结构

    """

    def __init__(self):
        r"""
        :param _Host: host
注意：此字段可能返回 null，表示取不到有效值。
        :type Host: str
        """
        self._Host = None

    @property
    def Host(self):
        """host
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host


    def _deserialize(self, params):
        self._Host = params.get("Host")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAlgoGroupRequest(AbstractModel):
    """DeleteAlgoGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AlgoGroupId: 个人算法组Id
        :type AlgoGroupId: str
        """
        self._AlgoGroupId = None

    @property
    def AlgoGroupId(self):
        """个人算法组Id
        :rtype: str
        """
        return self._AlgoGroupId

    @AlgoGroupId.setter
    def AlgoGroupId(self, AlgoGroupId):
        self._AlgoGroupId = AlgoGroupId


    def _deserialize(self, params):
        self._AlgoGroupId = params.get("AlgoGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAlgoGroupResponse(AbstractModel):
    """DeleteAlgoGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAlgoVersionRequest(AbstractModel):
    """DeleteAlgoVersion请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AlgoVersionId: 个人算法版本Id
        :type AlgoVersionId: str
        """
        self._AlgoVersionId = None

    @property
    def AlgoVersionId(self):
        """个人算法版本Id
        :rtype: str
        """
        return self._AlgoVersionId

    @AlgoVersionId.setter
    def AlgoVersionId(self, AlgoVersionId):
        self._AlgoVersionId = AlgoVersionId


    def _deserialize(self, params):
        self._AlgoVersionId = params.get("AlgoVersionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAlgoVersionResponse(AbstractModel):
    """DeleteAlgoVersion返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAnnotateRecordsRequest(AbstractModel):
    """DeleteAnnotateRecords请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RecordIds: 要删除的样本id列表
        :type RecordIds: list of str
        """
        self._TaskId = None
        self._RecordIds = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RecordIds(self):
        """要删除的样本id列表
        :rtype: list of str
        """
        return self._RecordIds

    @RecordIds.setter
    def RecordIds(self, RecordIds):
        self._RecordIds = RecordIds


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RecordIds = params.get("RecordIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAnnotateRecordsResponse(AbstractModel):
    """DeleteAnnotateRecords返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RecordIds: 删除的样本id列表
        :type RecordIds: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RecordIds = None
        self._RequestId = None

    @property
    def RecordIds(self):
        """删除的样本id列表
        :rtype: list of str
        """
        return self._RecordIds

    @RecordIds.setter
    def RecordIds(self, RecordIds):
        self._RecordIds = RecordIds

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RecordIds = params.get("RecordIds")
        self._RequestId = params.get("RequestId")


class DeleteAnnotatedTaskRequest(AbstractModel):
    """DeleteAnnotatedTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 删除的任务id
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """删除的任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAnnotatedTaskResponse(AbstractModel):
    """DeleteAnnotatedTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 删除的任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """删除的任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DeleteAutoMLNLPPredictRecordRequest(AbstractModel):
    """DeleteAutoMLNLPPredictRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务Id
        :type AutoMLTaskId: str
        :param _RecordId: 预测记录Id
        :type RecordId: str
        :param _EMSTaskId: 推理服务任务Id
        :type EMSTaskId: str
        """
        self._AutoMLTaskId = None
        self._RecordId = None
        self._EMSTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务Id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def RecordId(self):
        """预测记录Id
        :rtype: str
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def EMSTaskId(self):
        """推理服务任务Id
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._RecordId = params.get("RecordId")
        self._EMSTaskId = params.get("EMSTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAutoMLNLPPredictRecordResponse(AbstractModel):
    """DeleteAutoMLNLPPredictRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAutoMLTaskRequest(AbstractModel):
    """DeleteAutoMLTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        """
        self._AutoMLTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAutoMLTaskResponse(AbstractModel):
    """DeleteAutoMLTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        :param _AsyncTaskId: 异步任务ID
        :type AsyncTaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._AsyncTaskId = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def AsyncTaskId(self):
        """异步任务ID
        :rtype: str
        """
        return self._AsyncTaskId

    @AsyncTaskId.setter
    def AsyncTaskId(self, AsyncTaskId):
        self._AsyncTaskId = AsyncTaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._AsyncTaskId = params.get("AsyncTaskId")
        self._RequestId = params.get("RequestId")


class DeleteBatchTaskRequest(AbstractModel):
    """DeleteBatchTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchTaskId: 批量预测任务ID
        :type BatchTaskId: str
        """
        self._BatchTaskId = None

    @property
    def BatchTaskId(self):
        """批量预测任务ID
        :rtype: str
        """
        return self._BatchTaskId

    @BatchTaskId.setter
    def BatchTaskId(self, BatchTaskId):
        self._BatchTaskId = BatchTaskId


    def _deserialize(self, params):
        self._BatchTaskId = params.get("BatchTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBatchTaskResponse(AbstractModel):
    """DeleteBatchTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBillingResourceGroupRequest(AbstractModel):
    """DeleteBillingResourceGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        """
        self._ResourceGroupId = None

    @property
    def ResourceGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBillingResourceGroupResponse(AbstractModel):
    """DeleteBillingResourceGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResourceGroupId = None
        self._RequestId = None

    @property
    def ResourceGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._RequestId = params.get("RequestId")


class DeleteBillingResourceInstanceRequest(AbstractModel):
    """DeleteBillingResourceInstance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceInstanceId: 资源组节点id
        :type ResourceInstanceId: str
        """
        self._ResourceInstanceId = None

    @property
    def ResourceInstanceId(self):
        """资源组节点id
        :rtype: str
        """
        return self._ResourceInstanceId

    @ResourceInstanceId.setter
    def ResourceInstanceId(self, ResourceInstanceId):
        self._ResourceInstanceId = ResourceInstanceId


    def _deserialize(self, params):
        self._ResourceInstanceId = params.get("ResourceInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBillingResourceInstanceResponse(AbstractModel):
    """DeleteBillingResourceInstance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceInstanceId: 资源组节点id
        :type ResourceInstanceId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResourceInstanceId = None
        self._RequestId = None

    @property
    def ResourceInstanceId(self):
        """资源组节点id
        :rtype: str
        """
        return self._ResourceInstanceId

    @ResourceInstanceId.setter
    def ResourceInstanceId(self, ResourceInstanceId):
        self._ResourceInstanceId = ResourceInstanceId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ResourceInstanceId = params.get("ResourceInstanceId")
        self._RequestId = params.get("RequestId")


class DeleteChatWhiteListUserRequest(AbstractModel):
    """DeleteChatWhiteListUser请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UinId: 用户uin
        :type UinId: str
        """
        self._UinId = None

    @property
    def UinId(self):
        """用户uin
        :rtype: str
        """
        return self._UinId

    @UinId.setter
    def UinId(self, UinId):
        self._UinId = UinId


    def _deserialize(self, params):
        self._UinId = params.get("UinId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteChatWhiteListUserResponse(AbstractModel):
    """DeleteChatWhiteListUser返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCodeRepoRequest(AbstractModel):
    """DeleteCodeRepo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: id值
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """id值
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCodeRepoResponse(AbstractModel):
    """DeleteCodeRepo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDataPipelineTaskRequest(AbstractModel):
    """DeleteDataPipelineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 数据构建任务id
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """数据构建任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataPipelineTaskResponse(AbstractModel):
    """DeleteDataPipelineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 删除的数据构建任务的ID
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """删除的数据构建任务的ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DeleteDataSourceRequest(AbstractModel):
    """DeleteDataSource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DataSourceId: 数据源ID
        :type DataSourceId: str
        """
        self._DataSourceId = None

    @property
    def DataSourceId(self):
        """数据源ID
        :rtype: str
        """
        return self._DataSourceId

    @DataSourceId.setter
    def DataSourceId(self, DataSourceId):
        self._DataSourceId = DataSourceId


    def _deserialize(self, params):
        self._DataSourceId = params.get("DataSourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataSourceResponse(AbstractModel):
    """DeleteDataSource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDatasetRequest(AbstractModel):
    """DeleteDataset请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集id
        :type DatasetId: str
        :param _DeleteLabelEnable: 是否删除cos标签文件
        :type DeleteLabelEnable: bool
        """
        self._DatasetId = None
        self._DeleteLabelEnable = None

    @property
    def DatasetId(self):
        """数据集id
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def DeleteLabelEnable(self):
        """是否删除cos标签文件
        :rtype: bool
        """
        return self._DeleteLabelEnable

    @DeleteLabelEnable.setter
    def DeleteLabelEnable(self, DeleteLabelEnable):
        self._DeleteLabelEnable = DeleteLabelEnable


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        self._DeleteLabelEnable = params.get("DeleteLabelEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDatasetResponse(AbstractModel):
    """DeleteDataset返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetId: 删除的datasetId
        :type DatasetId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatasetId = None
        self._RequestId = None

    @property
    def DatasetId(self):
        """删除的datasetId
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        self._RequestId = params.get("RequestId")


class DeleteExportRequest(AbstractModel):
    """DeleteExport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExportId: 日志下载任务的ID
        :type ExportId: str
        """
        self._ExportId = None

    @property
    def ExportId(self):
        """日志下载任务的ID
        :rtype: str
        """
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId


    def _deserialize(self, params):
        self._ExportId = params.get("ExportId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteExportResponse(AbstractModel):
    """DeleteExport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteFlowRequest(AbstractModel):
    """DeleteFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 工作流ID
        :type FlowId: str
        """
        self._FlowId = None

    @property
    def FlowId(self):
        """工作流ID
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFlowResponse(AbstractModel):
    """DeleteFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 工作流ID
        :type FlowId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        """工作流ID
        :rtype: str
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class DeleteFlowRunRequest(AbstractModel):
    """DeleteFlowRun请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowRunId: 工作流的执行ID
        :type FlowRunId: str
        """
        self._FlowRunId = None

    @property
    def FlowRunId(self):
        """工作流的执行ID
        :rtype: str
        """
        return self._FlowRunId

    @FlowRunId.setter
    def FlowRunId(self, FlowRunId):
        self._FlowRunId = FlowRunId


    def _deserialize(self, params):
        self._FlowRunId = params.get("FlowRunId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFlowRunResponse(AbstractModel):
    """DeleteFlowRun返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowRunId: 工作流的运行Id
        :type FlowRunId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FlowRunId = None
        self._RequestId = None

    @property
    def FlowRunId(self):
        """工作流的运行Id
        :rtype: str
        """
        return self._FlowRunId

    @FlowRunId.setter
    def FlowRunId(self, FlowRunId):
        self._FlowRunId = FlowRunId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowRunId = params.get("FlowRunId")
        self._RequestId = params.get("RequestId")


class DeleteInferGatewayRequest(AbstractModel):
    """DeleteInferGateway请求参数结构体

    """


class DeleteInferGatewayResponse(AbstractModel):
    """DeleteInferGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLifecycleScriptRequest(AbstractModel):
    """DeleteLifecycleScript请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 生命周期脚本ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """生命周期脚本ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLifecycleScriptResponse(AbstractModel):
    """DeleteLifecycleScript返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteModelAccelerateTaskRequest(AbstractModel):
    """DeleteModelAccelerateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelAccTaskId: 模型加速任务ID
        :type ModelAccTaskId: str
        """
        self._ModelAccTaskId = None

    @property
    def ModelAccTaskId(self):
        """模型加速任务ID
        :rtype: str
        """
        return self._ModelAccTaskId

    @ModelAccTaskId.setter
    def ModelAccTaskId(self, ModelAccTaskId):
        self._ModelAccTaskId = ModelAccTaskId


    def _deserialize(self, params):
        self._ModelAccTaskId = params.get("ModelAccTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteModelAccelerateTaskResponse(AbstractModel):
    """DeleteModelAccelerateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteModelAccelerateTasksRequest(AbstractModel):
    """DeleteModelAccelerateTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelAccTaskIds: 模型加速任务ID列表
        :type ModelAccTaskIds: list of str
        """
        self._ModelAccTaskIds = None

    @property
    def ModelAccTaskIds(self):
        """模型加速任务ID列表
        :rtype: list of str
        """
        return self._ModelAccTaskIds

    @ModelAccTaskIds.setter
    def ModelAccTaskIds(self, ModelAccTaskIds):
        self._ModelAccTaskIds = ModelAccTaskIds


    def _deserialize(self, params):
        self._ModelAccTaskIds = params.get("ModelAccTaskIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteModelAccelerateTasksResponse(AbstractModel):
    """DeleteModelAccelerateTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteModelRequest(AbstractModel):
    """DeleteModel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModelId: 模型Id
        :type ModelId: str
        """
        self._ModelId = None

    @property
    def ModelId(self):
        """模型Id
        :rtype: str
        """
        return self._ModelId

    @ModelId.setter
    def ModelId(self, ModelId):
        self._ModelId = ModelId


    def _deserialize(self, params):
        self._ModelId = params.get("ModelId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteModelResponse(AbstractModel):
    """DeleteModel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteModelServiceGroupRequest(AbstractModel):
    """DeleteModelServiceGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceGroupId: 服务id
        :type ServiceGroupId: str
        :param _ServiceCategory: 服务类型
        :type ServiceCategory: str
        """
        self._ServiceGroupId = None
        self._ServiceCategory = None

    @property
    def ServiceGroupId(self):
        """服务id
        :rtype: str
        """
        return self._ServiceGroupId

    @ServiceGroupId.setter
    def ServiceGroupId(self, ServiceGroupId):
        self._ServiceGroupId = ServiceGroupId

    @property
    def ServiceCategory(self):
        """服务类型
        :rtype: str
        """
        return self._ServiceCategory

    @ServiceCategory.setter
    def ServiceCategory(self, ServiceCategory):
        self._ServiceCategory = ServiceCategory


    def _deserialize(self, params):
        self._ServiceGroupId = params.get("ServiceGroupId")
        self._ServiceCategory = params.get("ServiceCategory")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteModelServiceGroupResponse(AbstractModel):
    """DeleteModelServiceGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteModelServiceRequest(AbstractModel):
    """DeleteModelService请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceId: 服务id
        :type ServiceId: str
        :param _ServiceCategory: 服务分类
        :type ServiceCategory: str
        """
        self._ServiceId = None
        self._ServiceCategory = None

    @property
    def ServiceId(self):
        """服务id
        :rtype: str
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def ServiceCategory(self):
        """服务分类
        :rtype: str
        """
        return self._ServiceCategory

    @ServiceCategory.setter
    def ServiceCategory(self, ServiceCategory):
        self._ServiceCategory = ServiceCategory


    def _deserialize(self, params):
        self._ServiceId = params.get("ServiceId")
        self._ServiceCategory = params.get("ServiceCategory")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteModelServiceResponse(AbstractModel):
    """DeleteModelService返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNotebookImageRecordRequest(AbstractModel):
    """DeleteNotebookImageRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RecordId: 记录id
        :type RecordId: str
        """
        self._RecordId = None

    @property
    def RecordId(self):
        """记录id
        :rtype: str
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId


    def _deserialize(self, params):
        self._RecordId = params.get("RecordId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNotebookImageRecordResponse(AbstractModel):
    """DeleteNotebookImageRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNotebookRequest(AbstractModel):
    """DeleteNotebook请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: notebook id
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """notebook id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNotebookResponse(AbstractModel):
    """DeleteNotebook返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteObjectiveEvaluationRequest(AbstractModel):
    """DeleteObjectiveEvaluation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteObjectiveEvaluationResponse(AbstractModel):
    """DeleteObjectiveEvaluation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrivateLinkRequest(AbstractModel):
    """DeletePrivateLink请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceGroupId: 服务组ID
        :type ServiceGroupId: str
        :param _VpcId: 用户VpcId
        :type VpcId: str
        :param _SubnetId: 用户SubnetId
        :type SubnetId: str
        """
        self._ServiceGroupId = None
        self._VpcId = None
        self._SubnetId = None

    @property
    def ServiceGroupId(self):
        """服务组ID
        :rtype: str
        """
        return self._ServiceGroupId

    @ServiceGroupId.setter
    def ServiceGroupId(self, ServiceGroupId):
        self._ServiceGroupId = ServiceGroupId

    @property
    def VpcId(self):
        """用户VpcId
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """用户SubnetId
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._ServiceGroupId = params.get("ServiceGroupId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrivateLinkResponse(AbstractModel):
    """DeletePrivateLink返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteProjectRequest(AbstractModel):
    """DeleteProject请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 工程ID
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        """工程ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProjectResponse(AbstractModel):
    """DeleteProject返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 工程ID
        :type ProjectId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ProjectId = None
        self._RequestId = None

    @property
    def ProjectId(self):
        """工程ID
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RequestId = params.get("RequestId")


class DeleteRecyclePolicyRequest(AbstractModel):
    """DeleteRecyclePolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RecyclePolicyId: id值
        :type RecyclePolicyId: str
        """
        self._RecyclePolicyId = None

    @property
    def RecyclePolicyId(self):
        """id值
        :rtype: str
        """
        return self._RecyclePolicyId

    @RecyclePolicyId.setter
    def RecyclePolicyId(self, RecyclePolicyId):
        self._RecyclePolicyId = RecyclePolicyId


    def _deserialize(self, params):
        self._RecyclePolicyId = params.get("RecyclePolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRecyclePolicyResponse(AbstractModel):
    """DeleteRecyclePolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSubjectiveEvaluationRequest(AbstractModel):
    """DeleteSubjectiveEvaluation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSubjectiveEvaluationResponse(AbstractModel):
    """DeleteSubjectiveEvaluation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTaskComparisonRequest(AbstractModel):
    """DeleteTaskComparison请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskComparisonId: 任务ID
        :type TaskComparisonId: str
        """
        self._TaskComparisonId = None

    @property
    def TaskComparisonId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskComparisonId

    @TaskComparisonId.setter
    def TaskComparisonId(self, TaskComparisonId):
        self._TaskComparisonId = TaskComparisonId


    def _deserialize(self, params):
        self._TaskComparisonId = params.get("TaskComparisonId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskComparisonResponse(AbstractModel):
    """DeleteTaskComparison返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTaskProcessRequest(AbstractModel):
    """DeleteTaskProcess请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务ID列表
        :type TaskIds: list of str
        """
        self._TaskIds = None

    @property
    def TaskIds(self):
        """任务ID列表
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskProcessResponse(AbstractModel):
    """DeleteTaskProcess返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTencentLabWhitelistRequest(AbstractModel):
    """DeleteTencentLabWhitelist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassUin: 需要增加白名单的主uin
        :type ClassUin: str
        :param _ClassSubUin: 需要增加白名单的subUin
        :type ClassSubUin: str
        :param _ResourceId: Tione 平台维护的资源 ID，对应腾学会的课程 ID
        :type ResourceId: str
        """
        self._ClassUin = None
        self._ClassSubUin = None
        self._ResourceId = None

    @property
    def ClassUin(self):
        """需要增加白名单的主uin
        :rtype: str
        """
        return self._ClassUin

    @ClassUin.setter
    def ClassUin(self, ClassUin):
        self._ClassUin = ClassUin

    @property
    def ClassSubUin(self):
        """需要增加白名单的subUin
        :rtype: str
        """
        return self._ClassSubUin

    @ClassSubUin.setter
    def ClassSubUin(self, ClassSubUin):
        self._ClassSubUin = ClassSubUin

    @property
    def ResourceId(self):
        """Tione 平台维护的资源 ID，对应腾学会的课程 ID
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ClassUin = params.get("ClassUin")
        self._ClassSubUin = params.get("ClassSubUin")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTencentLabWhitelistResponse(AbstractModel):
    """DeleteTencentLabWhitelist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTencentLabWhitelistTestRequest(AbstractModel):
    """DeleteTencentLabWhitelistTest请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClassUin: 需要增加白名单的主uin
        :type ClassUin: str
        :param _ClassSubUin: 需要增加白名单的subUin
        :type ClassSubUin: str
        :param _ResourceId: Tione 平台维护的资源 ID，对应腾学会的课程 ID
        :type ResourceId: str
        """
        self._ClassUin = None
        self._ClassSubUin = None
        self._ResourceId = None

    @property
    def ClassUin(self):
        """需要增加白名单的主uin
        :rtype: str
        """
        return self._ClassUin

    @ClassUin.setter
    def ClassUin(self, ClassUin):
        self._ClassUin = ClassUin

    @property
    def ClassSubUin(self):
        """需要增加白名单的subUin
        :rtype: str
        """
        return self._ClassSubUin

    @ClassSubUin.setter
    def ClassSubUin(self, ClassSubUin):
        self._ClassSubUin = ClassSubUin

    @property
    def ResourceId(self):
        """Tione 平台维护的资源 ID，对应腾学会的课程 ID
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ClassUin = params.get("ClassUin")
        self._ClassSubUin = params.get("ClassSubUin")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTencentLabWhitelistTestResponse(AbstractModel):
    """DeleteTencentLabWhitelistTest返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTrainingMetricsRequest(AbstractModel):
    """DeleteTrainingMetrics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 训练任务Id列表
        :type TaskIds: list of str
        """
        self._TaskIds = None

    @property
    def TaskIds(self):
        """训练任务Id列表
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTrainingMetricsResponse(AbstractModel):
    """DeleteTrainingMetrics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTrainingModelRequest(AbstractModel):
    """DeleteTrainingModel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TrainingModelId: 模型ID
        :type TrainingModelId: str
        :param _EnableDeleteCos: 是否同步清理cos
        :type EnableDeleteCos: bool
        :param _ModelVersionType: 删除模型类型，枚举值：NORMAL 普通，ACCELERATE 加速，不传则删除所有
        :type ModelVersionType: str
        :param _ModelAffiliation: 模型所属模块，枚举值：MODEL_REPO 模型仓库，
 AI_MARKET AI市场，不传则删除模型仓库模型
        :type ModelAffiliation: str
        """
        self._TrainingModelId = None
        self._EnableDeleteCos = None
        self._ModelVersionType = None
        self._ModelAffiliation = None

    @property
    def TrainingModelId(self):
        """模型ID
        :rtype: str
        """
        return self._TrainingModelId

    @TrainingModelId.setter
    def TrainingModelId(self, TrainingModelId):
        self._TrainingModelId = TrainingModelId

    @property
    def EnableDeleteCos(self):
        """是否同步清理cos
        :rtype: bool
        """
        return self._EnableDeleteCos

    @EnableDeleteCos.setter
    def EnableDeleteCos(self, EnableDeleteCos):
        self._EnableDeleteCos = EnableDeleteCos

    @property
    def ModelVersionType(self):
        """删除模型类型，枚举值：NORMAL 普通，ACCELERATE 加速，不传则删除所有
        :rtype: str
        """
        return self._ModelVersionType

    @ModelVersionType.setter
    def ModelVersionType(self, ModelVersionType):
        self._ModelVersionType = ModelVersionType

    @property
    def ModelAffiliation(self):
        """模型所属模块，枚举值：MODEL_REPO 模型仓库，
 AI_MARKET AI市场，不传则删除模型仓库模型
        :rtype: str
        """
        return self._ModelAffiliation

    @ModelAffiliation.setter
    def ModelAffiliation(self, ModelAffiliation):
        self._ModelAffiliation = ModelAffiliation


    def _deserialize(self, params):
        self._TrainingModelId = params.get("TrainingModelId")
        self._EnableDeleteCos = params.get("EnableDeleteCos")
        self._ModelVersionType = params.get("ModelVersionType")
        self._ModelAffiliation = params.get("ModelAffiliation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTrainingModelResponse(AbstractModel):
    """DeleteTrainingModel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTrainingModelVersionRequest(AbstractModel):
    """DeleteTrainingModelVersion请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TrainingModelVersionId: 模型版本ID
        :type TrainingModelVersionId: str
        :param _EnableDeleteCos: 是否同步清理cos
        :type EnableDeleteCos: bool
        """
        self._TrainingModelVersionId = None
        self._EnableDeleteCos = None

    @property
    def TrainingModelVersionId(self):
        """模型版本ID
        :rtype: str
        """
        return self._TrainingModelVersionId

    @TrainingModelVersionId.setter
    def TrainingModelVersionId(self, TrainingModelVersionId):
        self._TrainingModelVersionId = TrainingModelVersionId

    @property
    def EnableDeleteCos(self):
        """是否同步清理cos
        :rtype: bool
        """
        return self._EnableDeleteCos

    @EnableDeleteCos.setter
    def EnableDeleteCos(self, EnableDeleteCos):
        self._EnableDeleteCos = EnableDeleteCos


    def _deserialize(self, params):
        self._TrainingModelVersionId = params.get("TrainingModelVersionId")
        self._EnableDeleteCos = params.get("EnableDeleteCos")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTrainingModelVersionResponse(AbstractModel):
    """DeleteTrainingModelVersion返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTrainingTaskRequest(AbstractModel):
    """DeleteTrainingTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 训练任务ID
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """训练任务ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTrainingTaskResponse(AbstractModel):
    """DeleteTrainingTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcPrivateLinkRequest(AbstractModel):
    """DeleteVpcPrivateLink请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: id值
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """id值
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcPrivateLinkResponse(AbstractModel):
    """DeleteVpcPrivateLink返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeliverBillingResourceRequest(AbstractModel):
    """DeliverBillingResource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TimeUnit: 节点续费的时间单位(计费周期范围)
注意：此字段为枚举值
说明：m: 月  y: 年
        :type TimeUnit: str
        :param _TimeSpan: 节点续费的时间大小
注意：节点续费最大支持2年; 因此当TimeUnit为m时，此字段取值不可大于24，TimeUnit为y时，此字段取值不可大于2
        :type TimeSpan: int
        :param _ResourceIds: 资源组节点id列表
注意: 单次最多100个
        :type ResourceIds: list of str
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        """
        self._TimeUnit = None
        self._TimeSpan = None
        self._ResourceIds = None
        self._ResourceGroupId = None

    @property
    def TimeUnit(self):
        """节点续费的时间单位(计费周期范围)
注意：此字段为枚举值
说明：m: 月  y: 年
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def TimeSpan(self):
        """节点续费的时间大小
注意：节点续费最大支持2年; 因此当TimeUnit为m时，此字段取值不可大于24，TimeUnit为y时，此字段取值不可大于2
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def ResourceIds(self):
        """资源组节点id列表
注意: 单次最多100个
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def ResourceGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId


    def _deserialize(self, params):
        self._TimeUnit = params.get("TimeUnit")
        self._TimeSpan = params.get("TimeSpan")
        self._ResourceIds = params.get("ResourceIds")
        self._ResourceGroupId = params.get("ResourceGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeliverBillingResourceResponse(AbstractModel):
    """DeliverBillingResource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FailResources: 续费失败的节点及其失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type FailResources: list of FailResource
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FailResources = None
        self._RequestId = None

    @property
    def FailResources(self):
        """续费失败的节点及其失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of FailResource
        """
        return self._FailResources

    @FailResources.setter
    def FailResources(self, FailResources):
        self._FailResources = FailResources

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FailResources") is not None:
            self._FailResources = []
            for item in params.get("FailResources"):
                obj = FailResource()
                obj._deserialize(item)
                self._FailResources.append(obj)
        self._RequestId = params.get("RequestId")


class DemoFlowDetail(AbstractModel):
    """案例工作流详情

    """

    def __init__(self):
        r"""
        :param _DemoFlowId: 案例工作流ID
        :type DemoFlowId: str
        :param _DemoProjectId: 案例工程ID
        :type DemoProjectId: str
        :param _DemoFlowName: 案例工作流名称
        :type DemoFlowName: str
        :param _Description: 案例工作流描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _CanvasData: 案例工作流画布信息
        :type CanvasData: str
        :param _DocUrl: 案例工作流文档链接
        :type DocUrl: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        """
        self._DemoFlowId = None
        self._DemoProjectId = None
        self._DemoFlowName = None
        self._Description = None
        self._CanvasData = None
        self._DocUrl = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def DemoFlowId(self):
        """案例工作流ID
        :rtype: str
        """
        return self._DemoFlowId

    @DemoFlowId.setter
    def DemoFlowId(self, DemoFlowId):
        self._DemoFlowId = DemoFlowId

    @property
    def DemoProjectId(self):
        """案例工程ID
        :rtype: str
        """
        return self._DemoProjectId

    @DemoProjectId.setter
    def DemoProjectId(self, DemoProjectId):
        self._DemoProjectId = DemoProjectId

    @property
    def DemoFlowName(self):
        """案例工作流名称
        :rtype: str
        """
        return self._DemoFlowName

    @DemoFlowName.setter
    def DemoFlowName(self, DemoFlowName):
        self._DemoFlowName = DemoFlowName

    @property
    def Description(self):
        """案例工作流描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CanvasData(self):
        """案例工作流画布信息
        :rtype: str
        """
        return self._CanvasData

    @CanvasData.setter
    def CanvasData(self, CanvasData):
        self._CanvasData = CanvasData

    @property
    def DocUrl(self):
        """案例工作流文档链接
        :rtype: str
        """
        return self._DocUrl

    @DocUrl.setter
    def DocUrl(self, DocUrl):
        self._DocUrl = DocUrl

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._DemoFlowId = params.get("DemoFlowId")
        self._DemoProjectId = params.get("DemoProjectId")
        self._DemoFlowName = params.get("DemoFlowName")
        self._Description = params.get("Description")
        self._CanvasData = params.get("CanvasData")
        self._DocUrl = params.get("DocUrl")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DemoProjectDetail(AbstractModel):
    """案例工程详情

    """

    def __init__(self):
        r"""
        :param _DemoProjectId: 案例工程ID
        :type DemoProjectId: str
        :param _DemoProjectName: 案例工程名称
        :type DemoProjectName: str
        :param _Description: 案例工程描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        """
        self._DemoProjectId = None
        self._DemoProjectName = None
        self._Description = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def DemoProjectId(self):
        """案例工程ID
        :rtype: str
        """
        return self._DemoProjectId

    @DemoProjectId.setter
    def DemoProjectId(self, DemoProjectId):
        self._DemoProjectId = DemoProjectId

    @property
    def DemoProjectName(self):
        """案例工程名称
        :rtype: str
        """
        return self._DemoProjectName

    @DemoProjectName.setter
    def DemoProjectName(self, DemoProjectName):
        self._DemoProjectName = DemoProjectName

    @property
    def Description(self):
        """案例工程描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._DemoProjectId = params.get("DemoProjectId")
        self._DemoProjectName = params.get("DemoProjectName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Dependency(AbstractModel):
    """依赖性描述子

    """

    def __init__(self):
        r"""
        :param _Production: 产品名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Production: str
        :param _Action: 对产品进行的操作
注意：此字段可能返回 null，表示取不到有效值。
        :type Action: str
        :param _ResourceId: cls-123
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceId: list of str
        """
        self._Production = None
        self._Action = None
        self._ResourceId = None

    @property
    def Production(self):
        """产品名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Production

    @Production.setter
    def Production(self, Production):
        self._Production = Production

    @property
    def Action(self):
        """对产品进行的操作
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def ResourceId(self):
        """cls-123
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._Production = params.get("Production")
        self._Action = params.get("Action")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DependencyAccessibility(AbstractModel):
    """依赖可访问性描述子

    """

    def __init__(self):
        r"""
        :param _Production: 产品名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Production: str
        :param _Action: 操作接口
注意：此字段可能返回 null，表示取不到有效值。
        :type Action: str
        :param _ResourceId: 资源ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceId: list of str
        :param _Accessible: 可访问性标志
注意：此字段可能返回 null，表示取不到有效值。
        :type Accessible: bool
        :param _Policy: 资源六段式描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Policy: list of str
        """
        self._Production = None
        self._Action = None
        self._ResourceId = None
        self._Accessible = None
        self._Policy = None

    @property
    def Production(self):
        """产品名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Production

    @Production.setter
    def Production(self, Production):
        self._Production = Production

    @property
    def Action(self):
        """操作接口
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def ResourceId(self):
        """资源ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Accessible(self):
        """可访问性标志
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Accessible

    @Accessible.setter
    def Accessible(self, Accessible):
        self._Accessible = Accessible

    @property
    def Policy(self):
        """资源六段式描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy


    def _deserialize(self, params):
        self._Production = params.get("Production")
        self._Action = params.get("Action")
        self._ResourceId = params.get("ResourceId")
        self._Accessible = params.get("Accessible")
        self._Policy = params.get("Policy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAPIConfigsRequest(AbstractModel):
    """DescribeAPIConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100
        :type Limit: int
        :param _Order: 输出列表的排列顺序。取值范围：ASC：升序排列 DESC：降序排列
        :type Order: str
        :param _OrderField: 排序的依据字段， 取值范围 "CreateTime" "UpdateTime"
        :type OrderField: str
        :param _Filters: 分页参数，支持的分页过滤Name包括：
["ClusterId", "ServiceId", "ServiceGroupName", "ServiceGroupId"]
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._OrderField = None
        self._Filters = None

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        """输出列表的排列顺序。取值范围：ASC：升序排列 DESC：降序排列
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OrderField(self):
        """排序的依据字段， 取值范围 "CreateTime" "UpdateTime"
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Filters(self):
        """分页参数，支持的分页过滤Name包括：
["ClusterId", "ServiceId", "ServiceGroupName", "ServiceGroupId"]
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._OrderField = params.get("OrderField")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAPIConfigsResponse(AbstractModel):
    """DescribeAPIConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 接口数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _Details: 接口详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Details: list of APIConfigDetail
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Details = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """接口数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Details(self):
        """接口详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of APIConfigDetail
        """
        return self._Details

    @Details.setter
    def Details(self, Details):
        self._Details = Details

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Details") is not None:
            self._Details = []
            for item in params.get("Details"):
                obj = APIConfigDetail()
                obj._deserialize(item)
                self._Details.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAlgoGroupListRequest(AbstractModel):
    """DescribeAlgoGroupList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤器
        :type Filters: list of Filter
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 返回记录条数，默认10
        :type Limit: int
        :param _OrderField: 排序字段，默认CreateTime
        :type OrderField: str
        :param _Order: 排序方式：ASC/DESC，默认DESC
        :type Order: str
        :param _TagFilters: 标签过滤器
        :type TagFilters: list of TagFilter
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._Order = None
        self._TagFilters = None

    @property
    def Filters(self):
        """过滤器
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """排序字段，默认CreateTime
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Order(self):
        """排序方式：ASC/DESC，默认DESC
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def TagFilters(self):
        """标签过滤器
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._Order = params.get("Order")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlgoGroupListResponse(AbstractModel):
    """DescribeAlgoGroupList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 算法组数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _AlgoGroups: 个人算法组列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AlgoGroups: :class:`tencentcloud.tione.v20211111.models.AlgoGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AlgoGroups = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """算法组数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AlgoGroups(self):
        """个人算法组列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.AlgoGroup`
        """
        return self._AlgoGroups

    @AlgoGroups.setter
    def AlgoGroups(self, AlgoGroups):
        self._AlgoGroups = AlgoGroups

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AlgoGroups") is not None:
            self._AlgoGroups = AlgoGroup()
            self._AlgoGroups._deserialize(params.get("AlgoGroups"))
        self._RequestId = params.get("RequestId")


class DescribeAlgoVersionListRequest(AbstractModel):
    """DescribeAlgoVersionList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤器
        :type Filters: list of Filter
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 返回记录条数，默认10
        :type Limit: int
        :param _TagFilters: 标签过滤器
        :type TagFilters: list of TagFilter
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._TagFilters = None

    @property
    def Filters(self):
        """过滤器
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回记录条数，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TagFilters(self):
        """标签过滤器
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlgoVersionListResponse(AbstractModel):
    """DescribeAlgoVersionList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 算法版本数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _AlgoVersions: 个人算法版本列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AlgoVersions: list of AlgoVersion
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AlgoVersions = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """算法版本数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AlgoVersions(self):
        """个人算法版本列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AlgoVersion
        """
        return self._AlgoVersions

    @AlgoVersions.setter
    def AlgoVersions(self, AlgoVersions):
        self._AlgoVersions = AlgoVersions

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AlgoVersions") is not None:
            self._AlgoVersions = []
            for item in params.get("AlgoVersions"):
                obj = AlgoVersion()
                obj._deserialize(item)
                self._AlgoVersions.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAnnotateRecordListRequest(AbstractModel):
    """DescribeAnnotateRecordList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 限制数
        :type Limit: int
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        :param _OnlyResult: 只获取结果不获取图片
        :type OnlyResult: bool
        :param _WithSchema: 同时返回表头
        :type WithSchema: bool
        """
        self._TaskId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._OnlyResult = None
        self._WithSchema = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """限制数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """过滤参数
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OnlyResult(self):
        """只获取结果不获取图片
        :rtype: bool
        """
        return self._OnlyResult

    @OnlyResult.setter
    def OnlyResult(self, OnlyResult):
        self._OnlyResult = OnlyResult

    @property
    def WithSchema(self):
        """同时返回表头
        :rtype: bool
        """
        return self._WithSchema

    @WithSchema.setter
    def WithSchema(self, WithSchema):
        self._WithSchema = WithSchema


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._OnlyResult = params.get("OnlyResult")
        self._WithSchema = params.get("WithSchema")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnnotateRecordListResponse(AbstractModel):
    """DescribeAnnotateRecordList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总量
        :type TotalCount: int
        :param _RowItems: 样本列表
注意：此字段可能返回 null，表示取不到有效值。
        :type RowItems: list of AnnotateRecord
        :param _Schema: 表头
        :type Schema: list of str
        :param _AsyncTask: 异步任务状态。有可能仅返回异步任务状态，不返回样本列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AsyncTask: :class:`tencentcloud.tione.v20211111.models.AsyncTask`
        :param _AnnotatedCount: 已标注数量
        :type AnnotatedCount: int
        :param _Offset: 偏移量，当使用RecordId进行筛选时返回
注意：此字段可能返回 null，表示取不到有效值。
        :type Offset: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RowItems = None
        self._Schema = None
        self._AsyncTask = None
        self._AnnotatedCount = None
        self._Offset = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """总量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RowItems(self):
        """样本列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AnnotateRecord
        """
        return self._RowItems

    @RowItems.setter
    def RowItems(self, RowItems):
        self._RowItems = RowItems

    @property
    def Schema(self):
        """表头
        :rtype: list of str
        """
        return self._Schema

    @Schema.setter
    def Schema(self, Schema):
        self._Schema = Schema

    @property
    def AsyncTask(self):
        """异步任务状态。有可能仅返回异步任务状态，不返回样本列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.AsyncTask`
        """
        return self._AsyncTask

    @AsyncTask.setter
    def AsyncTask(self, AsyncTask):
        self._AsyncTask = AsyncTask

    @property
    def AnnotatedCount(self):
        """已标注数量
        :rtype: int
        """
        return self._AnnotatedCount

    @AnnotatedCount.setter
    def AnnotatedCount(self, AnnotatedCount):
        self._AnnotatedCount = AnnotatedCount

    @property
    def Offset(self):
        """偏移量，当使用RecordId进行筛选时返回
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RowItems") is not None:
            self._RowItems = []
            for item in params.get("RowItems"):
                obj = AnnotateRecord()
                obj._deserialize(item)
                self._RowItems.append(obj)
        self._Schema = params.get("Schema")
        if params.get("AsyncTask") is not None:
            self._AsyncTask = AsyncTask()
            self._AsyncTask._deserialize(params.get("AsyncTask"))
        self._AnnotatedCount = params.get("AnnotatedCount")
        self._Offset = params.get("Offset")
        self._RequestId = params.get("RequestId")


class DescribeAnnotateTaskStatusRequest(AbstractModel):
    """DescribeAnnotateTaskStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnnotateTaskStatusResponse(AbstractModel):
    """DescribeAnnotateTaskStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LastSubmitedTask: 最近成功提交的任务
注意：此字段可能返回 null，表示取不到有效值。
        :type LastSubmitedTask: :class:`tencentcloud.tione.v20211111.models.AsyncTask`
        :param _NumUnsubmitted: 待提交样本数
        :type NumUnsubmitted: int
        :param _LastSubmitNum: 上次提交样本数目
        :type LastSubmitNum: int
        :param _LastSubmitUin: 上次提交UIN
        :type LastSubmitUin: str
        :param _LastSubmitSubAccountUin: 上次提交SubUin
        :type LastSubmitSubAccountUin: str
        :param _LastSubmitTimeStamp: 上次提交时间戳
        :type LastSubmitTimeStamp: str
        :param _TaskInfo: 标注任务相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInfo: :class:`tencentcloud.tione.v20211111.models.AnnotationTaskInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LastSubmitedTask = None
        self._NumUnsubmitted = None
        self._LastSubmitNum = None
        self._LastSubmitUin = None
        self._LastSubmitSubAccountUin = None
        self._LastSubmitTimeStamp = None
        self._TaskInfo = None
        self._RequestId = None

    @property
    def LastSubmitedTask(self):
        """最近成功提交的任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.AsyncTask`
        """
        return self._LastSubmitedTask

    @LastSubmitedTask.setter
    def LastSubmitedTask(self, LastSubmitedTask):
        self._LastSubmitedTask = LastSubmitedTask

    @property
    def NumUnsubmitted(self):
        """待提交样本数
        :rtype: int
        """
        return self._NumUnsubmitted

    @NumUnsubmitted.setter
    def NumUnsubmitted(self, NumUnsubmitted):
        self._NumUnsubmitted = NumUnsubmitted

    @property
    def LastSubmitNum(self):
        """上次提交样本数目
        :rtype: int
        """
        return self._LastSubmitNum

    @LastSubmitNum.setter
    def LastSubmitNum(self, LastSubmitNum):
        self._LastSubmitNum = LastSubmitNum

    @property
    def LastSubmitUin(self):
        """上次提交UIN
        :rtype: str
        """
        return self._LastSubmitUin

    @LastSubmitUin.setter
    def LastSubmitUin(self, LastSubmitUin):
        self._LastSubmitUin = LastSubmitUin

    @property
    def LastSubmitSubAccountUin(self):
        """上次提交SubUin
        :rtype: str
        """
        return self._LastSubmitSubAccountUin

    @LastSubmitSubAccountUin.setter
    def LastSubmitSubAccountUin(self, LastSubmitSubAccountUin):
        self._LastSubmitSubAccountUin = LastSubmitSubAccountUin

    @property
    def LastSubmitTimeStamp(self):
        """上次提交时间戳
        :rtype: str
        """
        return self._LastSubmitTimeStamp

    @LastSubmitTimeStamp.setter
    def LastSubmitTimeStamp(self, LastSubmitTimeStamp):
        self._LastSubmitTimeStamp = LastSubmitTimeStamp

    @property
    def TaskInfo(self):
        """标注任务相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.AnnotationTaskInfo`
        """
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LastSubmitedTask") is not None:
            self._LastSubmitedTask = AsyncTask()
            self._LastSubmitedTask._deserialize(params.get("LastSubmitedTask"))
        self._NumUnsubmitted = params.get("NumUnsubmitted")
        self._LastSubmitNum = params.get("LastSubmitNum")
        self._LastSubmitUin = params.get("LastSubmitUin")
        self._LastSubmitSubAccountUin = params.get("LastSubmitSubAccountUin")
        self._LastSubmitTimeStamp = params.get("LastSubmitTimeStamp")
        if params.get("TaskInfo") is not None:
            self._TaskInfo = AnnotationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAnnotateTaskTempCosInfoRequest(AbstractModel):
    """DescribeAnnotateTaskTempCosInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RecordId: 样本id
        :type RecordId: str
        :param _FileName: 文件名称
        :type FileName: str
        """
        self._TaskId = None
        self._RecordId = None
        self._FileName = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RecordId(self):
        """样本id
        :rtype: str
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def FileName(self):
        """文件名称
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RecordId = params.get("RecordId")
        self._FileName = params.get("FileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnnotateTaskTempCosInfoResponse(AbstractModel):
    """DescribeAnnotateTaskTempCosInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TempCosCredential: 用于上传图片到运营账号COS的临时秘钥
        :type TempCosCredential: :class:`tencentcloud.tione.v20211111.models.TempCosCredential`
        :param _TempBucket: 用于上传图片到运营账号COS的桶
        :type TempBucket: str
        :param _TempPath: 用于上传图片到运营账号COS的路径
        :type TempPath: str
        :param _ExpiredTime: 临时访问凭证有效的时间，返回 Unix 时间戳
        :type ExpiredTime: str
        :param _Expiration: 临时访问凭证有效的时间，以 iso8601 格式的 UTC 时间表示
        :type Expiration: str
        :param _RelativePath: 在标注结果中记录的相对路径
        :type RelativePath: str
        :param _Region: 用于上传图片到运营账号COS的地域
        :type Region: str
        :param _StartTime: 临时访问凭证有效的开始时间，返回 Unix 时间戳
        :type StartTime: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TempCosCredential = None
        self._TempBucket = None
        self._TempPath = None
        self._ExpiredTime = None
        self._Expiration = None
        self._RelativePath = None
        self._Region = None
        self._StartTime = None
        self._RequestId = None

    @property
    def TempCosCredential(self):
        """用于上传图片到运营账号COS的临时秘钥
        :rtype: :class:`tencentcloud.tione.v20211111.models.TempCosCredential`
        """
        return self._TempCosCredential

    @TempCosCredential.setter
    def TempCosCredential(self, TempCosCredential):
        self._TempCosCredential = TempCosCredential

    @property
    def TempBucket(self):
        """用于上传图片到运营账号COS的桶
        :rtype: str
        """
        return self._TempBucket

    @TempBucket.setter
    def TempBucket(self, TempBucket):
        self._TempBucket = TempBucket

    @property
    def TempPath(self):
        """用于上传图片到运营账号COS的路径
        :rtype: str
        """
        return self._TempPath

    @TempPath.setter
    def TempPath(self, TempPath):
        self._TempPath = TempPath

    @property
    def ExpiredTime(self):
        """临时访问凭证有效的时间，返回 Unix 时间戳
        :rtype: str
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def Expiration(self):
        """临时访问凭证有效的时间，以 iso8601 格式的 UTC 时间表示
        :rtype: str
        """
        return self._Expiration

    @Expiration.setter
    def Expiration(self, Expiration):
        self._Expiration = Expiration

    @property
    def RelativePath(self):
        """在标注结果中记录的相对路径
        :rtype: str
        """
        return self._RelativePath

    @RelativePath.setter
    def RelativePath(self, RelativePath):
        self._RelativePath = RelativePath

    @property
    def Region(self):
        """用于上传图片到运营账号COS的地域
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def StartTime(self):
        """临时访问凭证有效的开始时间，返回 Unix 时间戳
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TempCosCredential") is not None:
            self._TempCosCredential = TempCosCredential()
            self._TempCosCredential._deserialize(params.get("TempCosCredential"))
        self._TempBucket = params.get("TempBucket")
        self._TempPath = params.get("TempPath")
        self._ExpiredTime = params.get("ExpiredTime")
        self._Expiration = params.get("Expiration")
        self._RelativePath = params.get("RelativePath")
        self._Region = params.get("Region")
        self._StartTime = params.get("StartTime")
        self._RequestId = params.get("RequestId")


class DescribeAnnotatedTaskListRequest(AbstractModel):
    """DescribeAnnotatedTaskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 页面大小，默认为10
        :type Limit: int
        :param _Filters: 过滤条件数组，支持数据集ID，标注场景、任务状态、数据集名称、人物名称的过滤，后面两个支持模糊查询
        :type Filters: list of Filter
        :param _TagFilters: 标签过滤条件
        :type TagFilters: list of TagFilter
        :param _Order: 排序方向：Asc Desc
        :type Order: str
        :param _OrderField: 排序字段
        :type OrderField: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._TagFilters = None
        self._Order = None
        self._OrderField = None

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """页面大小，默认为10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """过滤条件数组，支持数据集ID，标注场景、任务状态、数据集名称、人物名称的过滤，后面两个支持模糊查询
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        """标签过滤条件
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def Order(self):
        """排序方向：Asc Desc
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OrderField(self):
        """排序字段
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        self._Order = params.get("Order")
        self._OrderField = params.get("OrderField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnnotatedTaskListResponse(AbstractModel):
    """DescribeAnnotatedTaskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 任务列表总数量
        :type TotalCount: int
        :param _TaskList: 标注任务详情列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskList: list of AnnotationTaskInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._TaskList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """任务列表总数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskList(self):
        """标注任务详情列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of AnnotationTaskInfo
        """
        return self._TaskList

    @TaskList.setter
    def TaskList(self, TaskList):
        self._TaskList = TaskList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TaskList") is not None:
            self._TaskList = []
            for item in params.get("TaskList"):
                obj = AnnotationTaskInfo()
                obj._deserialize(item)
                self._TaskList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAnnotationKeysRequest(AbstractModel):
    """DescribeAnnotationKeys请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集ID
        :type DatasetId: str
        """
        self._DatasetId = None

    @property
    def DatasetId(self):
        """数据集ID
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnnotationKeysResponse(AbstractModel):
    """DescribeAnnotationKeys返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集ID
        :type DatasetId: str
        :param _InUpdating: 当前是否处于更新之中
注意：此字段可能返回 null，表示取不到有效值。
        :type InUpdating: bool
        :param _LastUpdateStatus: 上一次更新的结果是否成功
注意：此字段可能返回 null，表示取不到有效值。
        :type LastUpdateStatus: bool
        :param _LastUpdateMsg: 上一次更新的报错信息
注意：此字段可能返回 null，表示取不到有效值。
        :type LastUpdateMsg: str
        :param _LastUpdateKeyType: 上一次更新的KeyType
注意：此字段可能返回 null，表示取不到有效值。
        :type LastUpdateKeyType: int
        :param _Version: ver
注意：此字段可能返回 null，表示取不到有效值。
        :type Version: str
        :param _StandardKeySet: 标注key名字典
注意：此字段可能返回 null，表示取不到有效值。
        :type StandardKeySet: :class:`tencentcloud.tione.v20211111.models.KeySetType`
        :param _AdditionalKeySet: 标注key名字典
注意：此字段可能返回 null，表示取不到有效值。
        :type AdditionalKeySet: :class:`tencentcloud.tione.v20211111.models.KeySetType`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatasetId = None
        self._InUpdating = None
        self._LastUpdateStatus = None
        self._LastUpdateMsg = None
        self._LastUpdateKeyType = None
        self._Version = None
        self._StandardKeySet = None
        self._AdditionalKeySet = None
        self._RequestId = None

    @property
    def DatasetId(self):
        """数据集ID
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def InUpdating(self):
        """当前是否处于更新之中
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._InUpdating

    @InUpdating.setter
    def InUpdating(self, InUpdating):
        self._InUpdating = InUpdating

    @property
    def LastUpdateStatus(self):
        """上一次更新的结果是否成功
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._LastUpdateStatus

    @LastUpdateStatus.setter
    def LastUpdateStatus(self, LastUpdateStatus):
        self._LastUpdateStatus = LastUpdateStatus

    @property
    def LastUpdateMsg(self):
        """上一次更新的报错信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LastUpdateMsg

    @LastUpdateMsg.setter
    def LastUpdateMsg(self, LastUpdateMsg):
        self._LastUpdateMsg = LastUpdateMsg

    @property
    def LastUpdateKeyType(self):
        """上一次更新的KeyType
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._LastUpdateKeyType

    @LastUpdateKeyType.setter
    def LastUpdateKeyType(self, LastUpdateKeyType):
        self._LastUpdateKeyType = LastUpdateKeyType

    @property
    def Version(self):
        """ver
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def StandardKeySet(self):
        """标注key名字典
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.KeySetType`
        """
        return self._StandardKeySet

    @StandardKeySet.setter
    def StandardKeySet(self, StandardKeySet):
        self._StandardKeySet = StandardKeySet

    @property
    def AdditionalKeySet(self):
        """标注key名字典
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.KeySetType`
        """
        return self._AdditionalKeySet

    @AdditionalKeySet.setter
    def AdditionalKeySet(self, AdditionalKeySet):
        self._AdditionalKeySet = AdditionalKeySet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        self._InUpdating = params.get("InUpdating")
        self._LastUpdateStatus = params.get("LastUpdateStatus")
        self._LastUpdateMsg = params.get("LastUpdateMsg")
        self._LastUpdateKeyType = params.get("LastUpdateKeyType")
        self._Version = params.get("Version")
        if params.get("StandardKeySet") is not None:
            self._StandardKeySet = KeySetType()
            self._StandardKeySet._deserialize(params.get("StandardKeySet"))
        if params.get("AdditionalKeySet") is not None:
            self._AdditionalKeySet = KeySetType()
            self._AdditionalKeySet._deserialize(params.get("AdditionalKeySet"))
        self._RequestId = params.get("RequestId")


class DescribeAsyncChatMessageRequest(AbstractModel):
    """DescribeAsyncChatMessage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务Id
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """异步任务Id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAsyncChatMessageResponse(AbstractModel):
    """DescribeAsyncChatMessage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfo: 对话任务结果
        :type TaskInfo: :class:`tencentcloud.tione.v20211111.models.ChatTaskInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInfo = None
        self._RequestId = None

    @property
    def TaskInfo(self):
        """对话任务结果
        :rtype: :class:`tencentcloud.tione.v20211111.models.ChatTaskInfo`
        """
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = ChatTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAsyncTaskStatusRequest(AbstractModel):
    """DescribeAsyncTaskStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """异步任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAsyncTaskStatusResponse(AbstractModel):
    """DescribeAsyncTaskStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskStatus: 任务执行状态
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskStatus: str
        :param _ProgressRate: 数据集导入/导出进度
注意：此字段可能返回 null，表示取不到有效值。
        :type ProgressRate: int
        :param _Reason: 任务执行失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type Reason: :class:`tencentcloud.tione.v20211111.models.ReasonInfo`
        :param _Error: 错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Error: :class:`tencentcloud.tione.v20211111.models.ErrorInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskStatus = None
        self._ProgressRate = None
        self._Reason = None
        self._Error = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        """任务执行状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def ProgressRate(self):
        """数据集导入/导出进度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ProgressRate

    @ProgressRate.setter
    def ProgressRate(self, ProgressRate):
        self._ProgressRate = ProgressRate

    @property
    def Reason(self):
        """任务执行失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ReasonInfo`
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def Error(self):
        """错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ErrorInfo`
        """
        return self._Error

    @Error.setter
    def Error(self, Error):
        self._Error = Error

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskStatus = params.get("TaskStatus")
        self._ProgressRate = params.get("ProgressRate")
        if params.get("Reason") is not None:
            self._Reason = ReasonInfo()
            self._Reason._deserialize(params.get("Reason"))
        if params.get("Error") is not None:
            self._Error = ErrorInfo()
            self._Error._deserialize(params.get("Error"))
        self._RequestId = params.get("RequestId")


class DescribeAutoMLEMSAPIInfoRequest(AbstractModel):
    """DescribeAutoMLEMSAPIInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 发布模型服务创建任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EMSTaskId: 发布模型服务任务id
        :type EMSTaskId: str
        """
        self._AutoMLTaskId = None
        self._EMSTaskId = None

    @property
    def AutoMLTaskId(self):
        """发布模型服务创建任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EMSTaskId(self):
        """发布模型服务任务id
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLEMSAPIInfoResponse(AbstractModel):
    """DescribeAutoMLEMSAPIInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 发布模型服务创建任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EMSTaskId: 发布模型服务任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type EMSTaskId: str
        :param _InnerUrl: 发布模型服务接口内网调用地址
注意：此字段可能返回 null，表示取不到有效值。
        :type InnerUrl: str
        :param _OuterUrl: 发布模型服务接口外网调用地址
注意：此字段可能返回 null，表示取不到有效值。
        :type OuterUrl: str
        :param _UrlInfo: 发布模型服务前端展示地址链接
注意：此字段可能返回 null，表示取不到有效值。
        :type UrlInfo: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EMSTaskId = None
        self._InnerUrl = None
        self._OuterUrl = None
        self._UrlInfo = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """发布模型服务创建任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EMSTaskId(self):
        """发布模型服务任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId

    @property
    def InnerUrl(self):
        """发布模型服务接口内网调用地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InnerUrl

    @InnerUrl.setter
    def InnerUrl(self, InnerUrl):
        self._InnerUrl = InnerUrl

    @property
    def OuterUrl(self):
        """发布模型服务接口外网调用地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OuterUrl

    @OuterUrl.setter
    def OuterUrl(self, OuterUrl):
        self._OuterUrl = OuterUrl

    @property
    def UrlInfo(self):
        """发布模型服务前端展示地址链接
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UrlInfo

    @UrlInfo.setter
    def UrlInfo(self, UrlInfo):
        self._UrlInfo = UrlInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        self._InnerUrl = params.get("InnerUrl")
        self._OuterUrl = params.get("OuterUrl")
        self._UrlInfo = params.get("UrlInfo")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLEMSTaskRequest(AbstractModel):
    """DescribeAutoMLEMSTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 发布模型服务任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EMSTaskId: 发布模型服务任务id
        :type EMSTaskId: str
        """
        self._AutoMLTaskId = None
        self._EMSTaskId = None

    @property
    def AutoMLTaskId(self):
        """发布模型服务任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EMSTaskId(self):
        """发布模型服务任务id
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLEMSTaskResponse(AbstractModel):
    """DescribeAutoMLEMSTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 发布模型服务任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EMSTaskId: 发布模型服务任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type EMSTaskId: str
        :param _EMSTaskBusinessStatus: 发布模型服务business状态，包括CREATING(创建中), CREATE_FAILED(创建失败), ARREARS_STOP(因欠费被强制停止)
注意：此字段可能返回 null，表示取不到有效值。
        :type EMSTaskBusinessStatus: str
        :param _EMSTaskWorkloadStatus: 模型服务实例状态, Normal(运行中), Pending(启动中), Abnormal(服务异常), Stopping(服务停止中), Stopped(服务已停止)
注意：此字段可能返回 null，表示取不到有效值。
        :type EMSTaskWorkloadStatus: str
        :param _Scene: 自动学习场景
注意：此字段可能返回 null，表示取不到有效值。
        :type Scene: :class:`tencentcloud.tione.v20211111.models.Scene`
        :param _ChargeType: 付费模式，PREPAID(预付费), POSTPAID_BY_HOUR(后付费)
注意：此字段可能返回 null，表示取不到有效值。
        :type ChargeType: str
        :param _MaxServiceHours: 模型服务最大运行时间，没设置则返回-1
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxServiceHours: int
        :param _EMSServiceGroupId: 发布模型服务服务组id
注意：此字段可能返回 null，表示取不到有效值。
        :type EMSServiceGroupId: str
        :param _EMSServiceId: 发布模型服务服务id
注意：此字段可能返回 null，表示取不到有效值。
        :type EMSServiceId: str
        :param _ResourceGroupId: 预付费资源组id
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupId: str
        :param _PublishResourceInfo: 发布模型服务资源配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :type PublishResourceInfo: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        :param _TaskOutputCosInfo: 自动学习任务模型输出cos路径
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskOutputCosInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _ErrorMsg: 出现异常时错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMsg: str
        :param _UserCosInfo: 保存文件的Cos信息
注意：此字段可能返回 null，表示取不到有效值。
        :type UserCosInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EMSTaskId = None
        self._EMSTaskBusinessStatus = None
        self._EMSTaskWorkloadStatus = None
        self._Scene = None
        self._ChargeType = None
        self._MaxServiceHours = None
        self._EMSServiceGroupId = None
        self._EMSServiceId = None
        self._ResourceGroupId = None
        self._PublishResourceInfo = None
        self._TaskOutputCosInfo = None
        self._ErrorMsg = None
        self._UserCosInfo = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """发布模型服务任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EMSTaskId(self):
        """发布模型服务任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId

    @property
    def EMSTaskBusinessStatus(self):
        """发布模型服务business状态，包括CREATING(创建中), CREATE_FAILED(创建失败), ARREARS_STOP(因欠费被强制停止)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EMSTaskBusinessStatus

    @EMSTaskBusinessStatus.setter
    def EMSTaskBusinessStatus(self, EMSTaskBusinessStatus):
        self._EMSTaskBusinessStatus = EMSTaskBusinessStatus

    @property
    def EMSTaskWorkloadStatus(self):
        """模型服务实例状态, Normal(运行中), Pending(启动中), Abnormal(服务异常), Stopping(服务停止中), Stopped(服务已停止)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EMSTaskWorkloadStatus

    @EMSTaskWorkloadStatus.setter
    def EMSTaskWorkloadStatus(self, EMSTaskWorkloadStatus):
        self._EMSTaskWorkloadStatus = EMSTaskWorkloadStatus

    @property
    def Scene(self):
        """自动学习场景
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.Scene`
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene

    @property
    def ChargeType(self):
        """付费模式，PREPAID(预付费), POSTPAID_BY_HOUR(后付费)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def MaxServiceHours(self):
        """模型服务最大运行时间，没设置则返回-1
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MaxServiceHours

    @MaxServiceHours.setter
    def MaxServiceHours(self, MaxServiceHours):
        self._MaxServiceHours = MaxServiceHours

    @property
    def EMSServiceGroupId(self):
        """发布模型服务服务组id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EMSServiceGroupId

    @EMSServiceGroupId.setter
    def EMSServiceGroupId(self, EMSServiceGroupId):
        self._EMSServiceGroupId = EMSServiceGroupId

    @property
    def EMSServiceId(self):
        """发布模型服务服务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EMSServiceId

    @EMSServiceId.setter
    def EMSServiceId(self, EMSServiceId):
        self._EMSServiceId = EMSServiceId

    @property
    def ResourceGroupId(self):
        """预付费资源组id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def PublishResourceInfo(self):
        """发布模型服务资源配置信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        """
        return self._PublishResourceInfo

    @PublishResourceInfo.setter
    def PublishResourceInfo(self, PublishResourceInfo):
        self._PublishResourceInfo = PublishResourceInfo

    @property
    def TaskOutputCosInfo(self):
        """自动学习任务模型输出cos路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._TaskOutputCosInfo

    @TaskOutputCosInfo.setter
    def TaskOutputCosInfo(self, TaskOutputCosInfo):
        self._TaskOutputCosInfo = TaskOutputCosInfo

    @property
    def ErrorMsg(self):
        """出现异常时错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def UserCosInfo(self):
        """保存文件的Cos信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._UserCosInfo

    @UserCosInfo.setter
    def UserCosInfo(self, UserCosInfo):
        self._UserCosInfo = UserCosInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        self._EMSTaskBusinessStatus = params.get("EMSTaskBusinessStatus")
        self._EMSTaskWorkloadStatus = params.get("EMSTaskWorkloadStatus")
        if params.get("Scene") is not None:
            self._Scene = Scene()
            self._Scene._deserialize(params.get("Scene"))
        self._ChargeType = params.get("ChargeType")
        self._MaxServiceHours = params.get("MaxServiceHours")
        self._EMSServiceGroupId = params.get("EMSServiceGroupId")
        self._EMSServiceId = params.get("EMSServiceId")
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("PublishResourceInfo") is not None:
            self._PublishResourceInfo = ResourceConfigInfo()
            self._PublishResourceInfo._deserialize(params.get("PublishResourceInfo"))
        if params.get("TaskOutputCosInfo") is not None:
            self._TaskOutputCosInfo = CosPathInfo()
            self._TaskOutputCosInfo._deserialize(params.get("TaskOutputCosInfo"))
        self._ErrorMsg = params.get("ErrorMsg")
        if params.get("UserCosInfo") is not None:
            self._UserCosInfo = CosPathInfo()
            self._UserCosInfo._deserialize(params.get("UserCosInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAutoMLEMSTasksRequest(AbstractModel):
    """DescribeAutoMLEMSTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 业务关联过滤条件
        :type Filters: list of Filter
        :param _TagFilters: 标签关联过滤条件
        :type TagFilters: list of TagFilter
        :param _Offset: 偏移量，默认0
        :type Offset: int
        :param _Limit: 结果限制数量，默认10
        :type Limit: int
        :param _OrderField: 结果排序业务字段, 默认自动学习任务创建时间
        :type OrderField: str
        :param _Order: 结果排序规则，ASC(升序), DESC(降序)
        :type Order: str
        """
        self._Filters = None
        self._TagFilters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._Order = None

    @property
    def Filters(self):
        """业务关联过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        """标签关联过滤条件
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def Offset(self):
        """偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """结果限制数量，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """结果排序业务字段, 默认自动学习任务创建时间
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Order(self):
        """结果排序规则，ASC(升序), DESC(降序)
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLEMSTasksResponse(AbstractModel):
    """DescribeAutoMLEMSTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 满足条件的模型发布任务总数量
        :type TotalCount: int
        :param _EMSTaskGroups: 满足条件的模型服务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type EMSTaskGroups: list of EMSTaskGroup
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._EMSTaskGroups = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """满足条件的模型发布任务总数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EMSTaskGroups(self):
        """满足条件的模型服务列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of EMSTaskGroup
        """
        return self._EMSTaskGroups

    @EMSTaskGroups.setter
    def EMSTaskGroups(self, EMSTaskGroups):
        self._EMSTaskGroups = EMSTaskGroups

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EMSTaskGroups") is not None:
            self._EMSTaskGroups = []
            for item in params.get("EMSTaskGroups"):
                obj = EMSTaskGroup()
                obj._deserialize(item)
                self._EMSTaskGroups.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAutoMLEMSTasksTrainLabelsRequest(AbstractModel):
    """DescribeAutoMLEMSTasksTrainLabels请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EMSTaskId: 推理任务任务id
        :type EMSTaskId: str
        """
        self._AutoMLTaskId = None
        self._EMSTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EMSTaskId(self):
        """推理任务任务id
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLEMSTasksTrainLabelsResponse(AbstractModel):
    """DescribeAutoMLEMSTasksTrainLabels返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EMSTaskId: 推理任务任务id
        :type EMSTaskId: str
        :param _LabelResults: 标注的key数组
        :type LabelResults: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EMSTaskId = None
        self._LabelResults = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EMSTaskId(self):
        """推理任务任务id
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId

    @property
    def LabelResults(self):
        """标注的key数组
        :rtype: list of str
        """
        return self._LabelResults

    @LabelResults.setter
    def LabelResults(self, LabelResults):
        self._LabelResults = LabelResults

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        self._LabelResults = params.get("LabelResults")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLEMSTempCosInfoRequest(AbstractModel):
    """DescribeAutoMLEMSTempCosInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        """
        self._AutoMLTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLEMSTempCosInfoResponse(AbstractModel):
    """DescribeAutoMLEMSTempCosInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TempCosCredential: 临时鉴权信息
        :type TempCosCredential: :class:`tencentcloud.tione.v20211111.models.TempCosCredential`
        :param _TempFolder: 保存图片的临时目录
        :type TempFolder: str
        :param _TempBucket: 保存图片的存储桶名称
        :type TempBucket: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TempCosCredential = None
        self._TempFolder = None
        self._TempBucket = None
        self._RequestId = None

    @property
    def TempCosCredential(self):
        """临时鉴权信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.TempCosCredential`
        """
        return self._TempCosCredential

    @TempCosCredential.setter
    def TempCosCredential(self, TempCosCredential):
        self._TempCosCredential = TempCosCredential

    @property
    def TempFolder(self):
        """保存图片的临时目录
        :rtype: str
        """
        return self._TempFolder

    @TempFolder.setter
    def TempFolder(self, TempFolder):
        self._TempFolder = TempFolder

    @property
    def TempBucket(self):
        """保存图片的存储桶名称
        :rtype: str
        """
        return self._TempBucket

    @TempBucket.setter
    def TempBucket(self, TempBucket):
        self._TempBucket = TempBucket

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TempCosCredential") is not None:
            self._TempCosCredential = TempCosCredential()
            self._TempCosCredential._deserialize(params.get("TempCosCredential"))
        self._TempFolder = params.get("TempFolder")
        self._TempBucket = params.get("TempBucket")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLEvaluationIdByAutoMLTaskIdRequest(AbstractModel):
    """DescribeAutoMLEvaluationIdByAutoMLTaskId请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        """
        self._AutoMLTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLEvaluationIdByAutoMLTaskIdResponse(AbstractModel):
    """DescribeAutoMLEvaluationIdByAutoMLTaskId返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLEvaluationNLUTaskReportUrlRequest(AbstractModel):
    """DescribeAutoMLEvaluationNLUTaskReportUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLEvaluationNLUTaskReportUrlResponse(AbstractModel):
    """DescribeAutoMLEvaluationNLUTaskReportUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _ReportUrl: 报告下载链接
        :type ReportUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._ReportUrl = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def ReportUrl(self):
        """报告下载链接
        :rtype: str
        """
        return self._ReportUrl

    @ReportUrl.setter
    def ReportUrl(self, ReportUrl):
        self._ReportUrl = ReportUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._ReportUrl = params.get("ReportUrl")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLEvaluationTaskStatusRequest(AbstractModel):
    """DescribeAutoMLEvaluationTaskStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLEvaluationTaskStatusResponse(AbstractModel):
    """DescribeAutoMLEvaluationTaskStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 查询评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 查询评测任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type EvaluationTaskId: str
        :param _TaskStatus: 评测任务当前状态，状态类型NOTSTART(未创建评测任务), WAITING(排队中),INIT(初始化中), STARTING(启动中), RUNNING(运行中), FAILED(异常), STOPPING(停止中), STOPPED(已停止), SUCCEED(已完成)
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskStatus: str
        :param _TaskProgress: 评测任务进度百分比，范围为[0, 100]
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskProgress: int
        :param _ErrorMsg: 任务异常信息，当TaskStatus为FAILED时返回
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMsg: str
        :param _WaitNumber: 前面排队任务数量，当TaskStatus为WAITING时返回
注意：此字段可能返回 null，表示取不到有效值。
        :type WaitNumber: int
        :param _InputTestDatasetIds: 输入评测数据集
注意：此字段可能返回 null，表示取不到有效值。
        :type InputTestDatasetIds: list of str
        :param _InputTestDatasetLabels: 输入评测数据标签
注意：此字段可能返回 null，表示取不到有效值。
        :type InputTestDatasetLabels: str
        :param _InputTestDataSetConfig: 评测数据信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InputTestDataSetConfig: :class:`tencentcloud.tione.v20211111.models.TestDataSetConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._TaskStatus = None
        self._TaskProgress = None
        self._ErrorMsg = None
        self._WaitNumber = None
        self._InputTestDatasetIds = None
        self._InputTestDatasetLabels = None
        self._InputTestDataSetConfig = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """查询评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """查询评测任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def TaskStatus(self):
        """评测任务当前状态，状态类型NOTSTART(未创建评测任务), WAITING(排队中),INIT(初始化中), STARTING(启动中), RUNNING(运行中), FAILED(异常), STOPPING(停止中), STOPPED(已停止), SUCCEED(已完成)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def TaskProgress(self):
        """评测任务进度百分比，范围为[0, 100]
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TaskProgress

    @TaskProgress.setter
    def TaskProgress(self, TaskProgress):
        self._TaskProgress = TaskProgress

    @property
    def ErrorMsg(self):
        """任务异常信息，当TaskStatus为FAILED时返回
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def WaitNumber(self):
        """前面排队任务数量，当TaskStatus为WAITING时返回
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._WaitNumber

    @WaitNumber.setter
    def WaitNumber(self, WaitNumber):
        self._WaitNumber = WaitNumber

    @property
    def InputTestDatasetIds(self):
        """输入评测数据集
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._InputTestDatasetIds

    @InputTestDatasetIds.setter
    def InputTestDatasetIds(self, InputTestDatasetIds):
        self._InputTestDatasetIds = InputTestDatasetIds

    @property
    def InputTestDatasetLabels(self):
        """输入评测数据标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InputTestDatasetLabels

    @InputTestDatasetLabels.setter
    def InputTestDatasetLabels(self, InputTestDatasetLabels):
        self._InputTestDatasetLabels = InputTestDatasetLabels

    @property
    def InputTestDataSetConfig(self):
        """评测数据信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.TestDataSetConfig`
        """
        return self._InputTestDataSetConfig

    @InputTestDataSetConfig.setter
    def InputTestDataSetConfig(self, InputTestDataSetConfig):
        self._InputTestDataSetConfig = InputTestDataSetConfig

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._TaskStatus = params.get("TaskStatus")
        self._TaskProgress = params.get("TaskProgress")
        self._ErrorMsg = params.get("ErrorMsg")
        self._WaitNumber = params.get("WaitNumber")
        self._InputTestDatasetIds = params.get("InputTestDatasetIds")
        self._InputTestDatasetLabels = params.get("InputTestDatasetLabels")
        if params.get("InputTestDataSetConfig") is not None:
            self._InputTestDataSetConfig = TestDataSetConfig()
            self._InputTestDataSetConfig._deserialize(params.get("InputTestDataSetConfig"))
        self._RequestId = params.get("RequestId")


class DescribeAutoMLEvaluationTasksRequest(AbstractModel):
    """DescribeAutoMLEvaluationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 业务关联过滤条件
        :type Filters: list of Filter
        :param _TagFilters: 标签关联过滤条件
        :type TagFilters: list of TagFilter
        :param _Offset: 偏移量，默认0
        :type Offset: int
        :param _Limit: 结果限制数量，默认10
        :type Limit: int
        :param _OrderField: 结果排序业务字段, 默认自动学习任务创建时间
        :type OrderField: str
        :param _Order: 结果排序规则，ASC(升序), DESC(降序)
        :type Order: str
        """
        self._Filters = None
        self._TagFilters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._Order = None

    @property
    def Filters(self):
        """业务关联过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        """标签关联过滤条件
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def Offset(self):
        """偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """结果限制数量，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """结果排序业务字段, 默认自动学习任务创建时间
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Order(self):
        """结果排序规则，ASC(升序), DESC(降序)
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLEvaluationTasksResponse(AbstractModel):
    """DescribeAutoMLEvaluationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 满足条件的评测任务总数量
        :type TotalCount: int
        :param _EvaluationTaskGroups: 评测任务列表详情
注意：此字段可能返回 null，表示取不到有效值。
        :type EvaluationTaskGroups: list of EvaluationTaskGroup
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._EvaluationTaskGroups = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """满足条件的评测任务总数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EvaluationTaskGroups(self):
        """评测任务列表详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of EvaluationTaskGroup
        """
        return self._EvaluationTaskGroups

    @EvaluationTaskGroups.setter
    def EvaluationTaskGroups(self, EvaluationTaskGroups):
        self._EvaluationTaskGroups = EvaluationTaskGroups

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EvaluationTaskGroups") is not None:
            self._EvaluationTaskGroups = []
            for item in params.get("EvaluationTaskGroups"):
                obj = EvaluationTaskGroup()
                obj._deserialize(item)
                self._EvaluationTaskGroups.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAutoMLModelServiceInfoRequest(AbstractModel):
    """DescribeAutoMLModelServiceInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        """
        self._AutoMLTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLModelServiceInfoResponse(AbstractModel):
    """DescribeAutoMLModelServiceInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _ModelId: 模型ID
        :type ModelId: str
        :param _ModelVersionId: 模型版本ID
        :type ModelVersionId: str
        :param _ModelName: 模型名称
        :type ModelName: str
        :param _ModelVersion: 模型版本
        :type ModelVersion: str
        :param _ImageInfo: GPU环境镜像
        :type ImageInfo: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._ModelId = None
        self._ModelVersionId = None
        self._ModelName = None
        self._ModelVersion = None
        self._ImageInfo = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def ModelId(self):
        """模型ID
        :rtype: str
        """
        return self._ModelId

    @ModelId.setter
    def ModelId(self, ModelId):
        self._ModelId = ModelId

    @property
    def ModelVersionId(self):
        """模型版本ID
        :rtype: str
        """
        return self._ModelVersionId

    @ModelVersionId.setter
    def ModelVersionId(self, ModelVersionId):
        self._ModelVersionId = ModelVersionId

    @property
    def ModelName(self):
        """模型名称
        :rtype: str
        """
        return self._ModelName

    @ModelName.setter
    def ModelName(self, ModelName):
        self._ModelName = ModelName

    @property
    def ModelVersion(self):
        """模型版本
        :rtype: str
        """
        return self._ModelVersion

    @ModelVersion.setter
    def ModelVersion(self, ModelVersion):
        self._ModelVersion = ModelVersion

    @property
    def ImageInfo(self):
        """GPU环境镜像
        :rtype: :class:`tencentcloud.tione.v20211111.models.ImageInfo`
        """
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._ModelId = params.get("ModelId")
        self._ModelVersionId = params.get("ModelVersionId")
        self._ModelName = params.get("ModelName")
        self._ModelVersion = params.get("ModelVersion")
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAutoMLNLPPredictRecordsRequest(AbstractModel):
    """DescribeAutoMLNLPPredictRecords请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务Id
        :type AutoMLTaskId: str
        :param _EMSTaskId: 推理服务任务Id
        :type EMSTaskId: str
        """
        self._AutoMLTaskId = None
        self._EMSTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务Id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EMSTaskId(self):
        """推理服务任务Id
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLNLPPredictRecordsResponse(AbstractModel):
    """DescribeAutoMLNLPPredictRecords返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务Id
        :type AutoMLTaskId: str
        :param _EMSTaskId: 推理服务任务Id
        :type EMSTaskId: str
        :param _PredictResults: 预测结果
        :type PredictResults: list of NLPSamplePredictResult
        :param _InferUrl: 当前服务请求地址
        :type InferUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EMSTaskId = None
        self._PredictResults = None
        self._InferUrl = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务Id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EMSTaskId(self):
        """推理服务任务Id
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId

    @property
    def PredictResults(self):
        """预测结果
        :rtype: list of NLPSamplePredictResult
        """
        return self._PredictResults

    @PredictResults.setter
    def PredictResults(self, PredictResults):
        self._PredictResults = PredictResults

    @property
    def InferUrl(self):
        """当前服务请求地址
        :rtype: str
        """
        return self._InferUrl

    @InferUrl.setter
    def InferUrl(self, InferUrl):
        self._InferUrl = InferUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        if params.get("PredictResults") is not None:
            self._PredictResults = []
            for item in params.get("PredictResults"):
                obj = NLPSamplePredictResult()
                obj._deserialize(item)
                self._PredictResults.append(obj)
        self._InferUrl = params.get("InferUrl")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskCommonEvaluationBadCasesRequest(AbstractModel):
    """DescribeAutoMLTaskCommonEvaluationBadCases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _Offset: 偏移量，默认0
        :type Offset: int
        :param _Limit: 结果限制数量，默认10
        :type Limit: int
        :param _OrderField: 结果排序业务字段
        :type OrderField: str
        :param _Order: 结果排序规则
        :type Order: str
        :param _AutoMLEvaluateTaskId: 自动学习评测任务id
        :type AutoMLEvaluateTaskId: str
        :param _Type: single or multi
        :type Type: str
        :param _QueryType: ALL, BAD_CASE, GOOD_CASE
        :type QueryType: str
        :param _TagFilters: tag过滤
        :type TagFilters: list of ComparisonTagFilter
        :param _TagSorters: tag排序
        :type TagSorters: list of TagSorter
        :param _ResultFilters: 结果过滤
        :type ResultFilters: list of ResultFilter
        :param _SortOn: 排序、筛选所基于任务的SID
        :type SortOn: str
        """
        self._AutoMLTaskId = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._Order = None
        self._AutoMLEvaluateTaskId = None
        self._Type = None
        self._QueryType = None
        self._TagFilters = None
        self._TagSorters = None
        self._ResultFilters = None
        self._SortOn = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def Offset(self):
        """偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """结果限制数量，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """结果排序业务字段
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Order(self):
        """结果排序规则
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def AutoMLEvaluateTaskId(self):
        """自动学习评测任务id
        :rtype: str
        """
        return self._AutoMLEvaluateTaskId

    @AutoMLEvaluateTaskId.setter
    def AutoMLEvaluateTaskId(self, AutoMLEvaluateTaskId):
        self._AutoMLEvaluateTaskId = AutoMLEvaluateTaskId

    @property
    def Type(self):
        """single or multi
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def QueryType(self):
        """ALL, BAD_CASE, GOOD_CASE
        :rtype: str
        """
        return self._QueryType

    @QueryType.setter
    def QueryType(self, QueryType):
        self._QueryType = QueryType

    @property
    def TagFilters(self):
        """tag过滤
        :rtype: list of ComparisonTagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def TagSorters(self):
        """tag排序
        :rtype: list of TagSorter
        """
        return self._TagSorters

    @TagSorters.setter
    def TagSorters(self, TagSorters):
        self._TagSorters = TagSorters

    @property
    def ResultFilters(self):
        """结果过滤
        :rtype: list of ResultFilter
        """
        return self._ResultFilters

    @ResultFilters.setter
    def ResultFilters(self, ResultFilters):
        self._ResultFilters = ResultFilters

    @property
    def SortOn(self):
        """排序、筛选所基于任务的SID
        :rtype: str
        """
        return self._SortOn

    @SortOn.setter
    def SortOn(self, SortOn):
        self._SortOn = SortOn


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._Order = params.get("Order")
        self._AutoMLEvaluateTaskId = params.get("AutoMLEvaluateTaskId")
        self._Type = params.get("Type")
        self._QueryType = params.get("QueryType")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = ComparisonTagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        if params.get("TagSorters") is not None:
            self._TagSorters = []
            for item in params.get("TagSorters"):
                obj = TagSorter()
                obj._deserialize(item)
                self._TagSorters.append(obj)
        if params.get("ResultFilters") is not None:
            self._ResultFilters = []
            for item in params.get("ResultFilters"):
                obj = ResultFilter()
                obj._deserialize(item)
                self._ResultFilters.append(obj)
        self._SortOn = params.get("SortOn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskCommonEvaluationBadCasesResponse(AbstractModel):
    """DescribeAutoMLTaskCommonEvaluationBadCases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 本次请求的所有的自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 本次请求的所有的自动学习评测任务id
        :type EvaluationTaskId: str
        :param _Predictions: 预测结果
        :type Predictions: list of ComparedPrediction
        :param _TotalCount: 预测结果总量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._Predictions = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """本次请求的所有的自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """本次请求的所有的自动学习评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def Predictions(self):
        """预测结果
        :rtype: list of ComparedPrediction
        """
        return self._Predictions

    @Predictions.setter
    def Predictions(self, Predictions):
        self._Predictions = Predictions

    @property
    def TotalCount(self):
        """预测结果总量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        if params.get("Predictions") is not None:
            self._Predictions = []
            for item in params.get("Predictions"):
                obj = ComparedPrediction()
                obj._deserialize(item)
                self._Predictions.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskCommonEvaluationDetailRequest(AbstractModel):
    """DescribeAutoMLTaskCommonEvaluationDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskCommonEvaluationDetailResponse(AbstractModel):
    """DescribeAutoMLTaskCommonEvaluationDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _TestDataSetNames: 测试数据集名称
        :type TestDataSetNames: list of str
        :param _TotalSampleCount: 测试数据集样本数量
        :type TotalSampleCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._TestDataSetNames = None
        self._TotalSampleCount = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def TestDataSetNames(self):
        """测试数据集名称
        :rtype: list of str
        """
        return self._TestDataSetNames

    @TestDataSetNames.setter
    def TestDataSetNames(self, TestDataSetNames):
        self._TestDataSetNames = TestDataSetNames

    @property
    def TotalSampleCount(self):
        """测试数据集样本数量
        :rtype: int
        """
        return self._TotalSampleCount

    @TotalSampleCount.setter
    def TotalSampleCount(self, TotalSampleCount):
        self._TotalSampleCount = TotalSampleCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._TestDataSetNames = params.get("TestDataSetNames")
        self._TotalSampleCount = params.get("TotalSampleCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskCommonEvaluationIndicatorRequest(AbstractModel):
    """DescribeAutoMLTaskCommonEvaluationIndicator请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskCommonEvaluationIndicatorResponse(AbstractModel):
    """DescribeAutoMLTaskCommonEvaluationIndicator返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrentScalarMetrics: 当前模型基础指标
        :type CurrentScalarMetrics: list of ScalarItem
        :param _PreviousScalarMetrics: 优化前模型基础指标
        :type PreviousScalarMetrics: list of ScalarItem
        :param _CurrentMetrics: 当前模型详细指标
        :type CurrentMetrics: str
        :param _PreviousMetrics: 优化前模型详细指标
        :type PreviousMetrics: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CurrentScalarMetrics = None
        self._PreviousScalarMetrics = None
        self._CurrentMetrics = None
        self._PreviousMetrics = None
        self._RequestId = None

    @property
    def CurrentScalarMetrics(self):
        """当前模型基础指标
        :rtype: list of ScalarItem
        """
        return self._CurrentScalarMetrics

    @CurrentScalarMetrics.setter
    def CurrentScalarMetrics(self, CurrentScalarMetrics):
        self._CurrentScalarMetrics = CurrentScalarMetrics

    @property
    def PreviousScalarMetrics(self):
        """优化前模型基础指标
        :rtype: list of ScalarItem
        """
        return self._PreviousScalarMetrics

    @PreviousScalarMetrics.setter
    def PreviousScalarMetrics(self, PreviousScalarMetrics):
        self._PreviousScalarMetrics = PreviousScalarMetrics

    @property
    def CurrentMetrics(self):
        """当前模型详细指标
        :rtype: str
        """
        return self._CurrentMetrics

    @CurrentMetrics.setter
    def CurrentMetrics(self, CurrentMetrics):
        self._CurrentMetrics = CurrentMetrics

    @property
    def PreviousMetrics(self):
        """优化前模型详细指标
        :rtype: str
        """
        return self._PreviousMetrics

    @PreviousMetrics.setter
    def PreviousMetrics(self, PreviousMetrics):
        self._PreviousMetrics = PreviousMetrics

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CurrentScalarMetrics") is not None:
            self._CurrentScalarMetrics = []
            for item in params.get("CurrentScalarMetrics"):
                obj = ScalarItem()
                obj._deserialize(item)
                self._CurrentScalarMetrics.append(obj)
        if params.get("PreviousScalarMetrics") is not None:
            self._PreviousScalarMetrics = []
            for item in params.get("PreviousScalarMetrics"):
                obj = ScalarItem()
                obj._deserialize(item)
                self._PreviousScalarMetrics.append(obj)
        self._CurrentMetrics = params.get("CurrentMetrics")
        self._PreviousMetrics = params.get("PreviousMetrics")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskConfigRequest(AbstractModel):
    """DescribeAutoMLTaskConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        """
        self._AutoMLTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskConfigResponse(AbstractModel):
    """DescribeAutoMLTaskConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CommonConfig: 基础配置
注意：此字段可能返回 null，表示取不到有效值。
        :type CommonConfig: :class:`tencentcloud.tione.v20211111.models.CommonConfig`
        :param _DataConfig: 数据配置
注意：此字段可能返回 null，表示取不到有效值。
        :type DataConfig: :class:`tencentcloud.tione.v20211111.models.MLDataConfig`
        :param _TaskOutputCosInfo: 自动学习任务输出COS
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskOutputCosInfo: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        :param _ModelTrainConfig: 模型训练参数配置
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelTrainConfig: :class:`tencentcloud.tione.v20211111.models.ModelTrainConfig`
        :param _ModelParamConfig: 模型超参数
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelParamConfig: str
        :param _TrainResourceConfig: 训练资源配置
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainResourceConfig: :class:`tencentcloud.tione.v20211111.models.TrainResourceConfig`
        :param _Tags: 标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tags: list of Tag
        :param _TaskSource: 任务来源
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskSource: str
        :param _AutoMLTaskId: 自动学习任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AutoMLTaskId: str
        :param _AutoMLTaskGroupId: 任务组
注意：此字段可能返回 null，表示取不到有效值。
        :type AutoMLTaskGroupId: str
        :param _TrainTaskId: 训练任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTaskId: str
        :param _EvaluationTaskId: 评测任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type EvaluationTaskId: str
        :param _EMSTaskId: 在线服务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type EMSTaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CommonConfig = None
        self._DataConfig = None
        self._TaskOutputCosInfo = None
        self._ModelTrainConfig = None
        self._ModelParamConfig = None
        self._TrainResourceConfig = None
        self._Tags = None
        self._TaskSource = None
        self._AutoMLTaskId = None
        self._AutoMLTaskGroupId = None
        self._TrainTaskId = None
        self._EvaluationTaskId = None
        self._EMSTaskId = None
        self._RequestId = None

    @property
    def CommonConfig(self):
        """基础配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CommonConfig`
        """
        return self._CommonConfig

    @CommonConfig.setter
    def CommonConfig(self, CommonConfig):
        self._CommonConfig = CommonConfig

    @property
    def DataConfig(self):
        """数据配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.MLDataConfig`
        """
        return self._DataConfig

    @DataConfig.setter
    def DataConfig(self, DataConfig):
        self._DataConfig = DataConfig

    @property
    def TaskOutputCosInfo(self):
        """自动学习任务输出COS
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.CosPathInfo`
        """
        return self._TaskOutputCosInfo

    @TaskOutputCosInfo.setter
    def TaskOutputCosInfo(self, TaskOutputCosInfo):
        self._TaskOutputCosInfo = TaskOutputCosInfo

    @property
    def ModelTrainConfig(self):
        """模型训练参数配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ModelTrainConfig`
        """
        return self._ModelTrainConfig

    @ModelTrainConfig.setter
    def ModelTrainConfig(self, ModelTrainConfig):
        self._ModelTrainConfig = ModelTrainConfig

    @property
    def ModelParamConfig(self):
        """模型超参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModelParamConfig

    @ModelParamConfig.setter
    def ModelParamConfig(self, ModelParamConfig):
        self._ModelParamConfig = ModelParamConfig

    @property
    def TrainResourceConfig(self):
        """训练资源配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.TrainResourceConfig`
        """
        return self._TrainResourceConfig

    @TrainResourceConfig.setter
    def TrainResourceConfig(self, TrainResourceConfig):
        self._TrainResourceConfig = TrainResourceConfig

    @property
    def Tags(self):
        """标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def TaskSource(self):
        """任务来源
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskSource

    @TaskSource.setter
    def TaskSource(self, TaskSource):
        self._TaskSource = TaskSource

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def AutoMLTaskGroupId(self):
        """任务组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AutoMLTaskGroupId

    @AutoMLTaskGroupId.setter
    def AutoMLTaskGroupId(self, AutoMLTaskGroupId):
        self._AutoMLTaskGroupId = AutoMLTaskGroupId

    @property
    def TrainTaskId(self):
        """训练任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainTaskId

    @TrainTaskId.setter
    def TrainTaskId(self, TrainTaskId):
        self._TrainTaskId = TrainTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def EMSTaskId(self):
        """在线服务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EMSTaskId

    @EMSTaskId.setter
    def EMSTaskId(self, EMSTaskId):
        self._EMSTaskId = EMSTaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CommonConfig") is not None:
            self._CommonConfig = CommonConfig()
            self._CommonConfig._deserialize(params.get("CommonConfig"))
        if params.get("DataConfig") is not None:
            self._DataConfig = MLDataConfig()
            self._DataConfig._deserialize(params.get("DataConfig"))
        if params.get("TaskOutputCosInfo") is not None:
            self._TaskOutputCosInfo = CosPathInfo()
            self._TaskOutputCosInfo._deserialize(params.get("TaskOutputCosInfo"))
        if params.get("ModelTrainConfig") is not None:
            self._ModelTrainConfig = ModelTrainConfig()
            self._ModelTrainConfig._deserialize(params.get("ModelTrainConfig"))
        self._ModelParamConfig = params.get("ModelParamConfig")
        if params.get("TrainResourceConfig") is not None:
            self._TrainResourceConfig = TrainResourceConfig()
            self._TrainResourceConfig._deserialize(params.get("TrainResourceConfig"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._TaskSource = params.get("TaskSource")
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._AutoMLTaskGroupId = params.get("AutoMLTaskGroupId")
        self._TrainTaskId = params.get("TrainTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._EMSTaskId = params.get("EMSTaskId")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskEMSTempCosInfoRequest(AbstractModel):
    """DescribeAutoMLTaskEMSTempCosInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        """
        self._AutoMLTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskEMSTempCosInfoResponse(AbstractModel):
    """DescribeAutoMLTaskEMSTempCosInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TempCosCredential: 临时鉴权信息
        :type TempCosCredential: :class:`tencentcloud.tione.v20211111.models.TempCosCredential`
        :param _TempFolder: 保存图片的临时目录
        :type TempFolder: str
        :param _TempBucket: 保存图片的存储桶名称
        :type TempBucket: str
        :param _ExpiredTime: 有效期时长
        :type ExpiredTime: int
        :param _StartTime: 开始有效时间
        :type StartTime: int
        :param _Expiration: 过期时间
        :type Expiration: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TempCosCredential = None
        self._TempFolder = None
        self._TempBucket = None
        self._ExpiredTime = None
        self._StartTime = None
        self._Expiration = None
        self._RequestId = None

    @property
    def TempCosCredential(self):
        """临时鉴权信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.TempCosCredential`
        """
        return self._TempCosCredential

    @TempCosCredential.setter
    def TempCosCredential(self, TempCosCredential):
        self._TempCosCredential = TempCosCredential

    @property
    def TempFolder(self):
        """保存图片的临时目录
        :rtype: str
        """
        return self._TempFolder

    @TempFolder.setter
    def TempFolder(self, TempFolder):
        self._TempFolder = TempFolder

    @property
    def TempBucket(self):
        """保存图片的存储桶名称
        :rtype: str
        """
        return self._TempBucket

    @TempBucket.setter
    def TempBucket(self, TempBucket):
        self._TempBucket = TempBucket

    @property
    def ExpiredTime(self):
        """有效期时长
        :rtype: int
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def StartTime(self):
        """开始有效时间
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Expiration(self):
        """过期时间
        :rtype: str
        """
        return self._Expiration

    @Expiration.setter
    def Expiration(self, Expiration):
        self._Expiration = Expiration

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TempCosCredential") is not None:
            self._TempCosCredential = TempCosCredential()
            self._TempCosCredential._deserialize(params.get("TempCosCredential"))
        self._TempFolder = params.get("TempFolder")
        self._TempBucket = params.get("TempBucket")
        self._ExpiredTime = params.get("ExpiredTime")
        self._StartTime = params.get("StartTime")
        self._Expiration = params.get("Expiration")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskEvaluationASRBadcaseRequest(AbstractModel):
    """DescribeAutoMLTaskEvaluationASRBadcase请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _AutoMLEvaluateTaskId: 自动学习评测任务id
        :type AutoMLEvaluateTaskId: str
        :param _Offset: 偏移量，默认0
        :type Offset: int
        :param _Limit: 结果限制数量，默认10
        :type Limit: int
        :param _OrderField: 结果排序业务字段
        :type OrderField: str
        :param _Order: 结果排序规则
        :type Order: str
        :param _Type: single or multi
        :type Type: str
        :param _QueryType: ALL, BAD_CASE, GOOD_CASE
        :type QueryType: str
        :param _TagFilters: tag过滤
        :type TagFilters: list of ComparisonTagFilter
        :param _TagSorters: tag排序
        :type TagSorters: list of TagSorter
        :param _ResultFilters: 结果过滤
        :type ResultFilters: list of ResultFilter
        :param _SortOn: 排序、筛选所基于任务的SID
        :type SortOn: str
        """
        self._AutoMLTaskId = None
        self._AutoMLEvaluateTaskId = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._Order = None
        self._Type = None
        self._QueryType = None
        self._TagFilters = None
        self._TagSorters = None
        self._ResultFilters = None
        self._SortOn = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def AutoMLEvaluateTaskId(self):
        """自动学习评测任务id
        :rtype: str
        """
        return self._AutoMLEvaluateTaskId

    @AutoMLEvaluateTaskId.setter
    def AutoMLEvaluateTaskId(self, AutoMLEvaluateTaskId):
        self._AutoMLEvaluateTaskId = AutoMLEvaluateTaskId

    @property
    def Offset(self):
        """偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """结果限制数量，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """结果排序业务字段
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Order(self):
        """结果排序规则
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Type(self):
        """single or multi
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def QueryType(self):
        """ALL, BAD_CASE, GOOD_CASE
        :rtype: str
        """
        return self._QueryType

    @QueryType.setter
    def QueryType(self, QueryType):
        self._QueryType = QueryType

    @property
    def TagFilters(self):
        """tag过滤
        :rtype: list of ComparisonTagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def TagSorters(self):
        """tag排序
        :rtype: list of TagSorter
        """
        return self._TagSorters

    @TagSorters.setter
    def TagSorters(self, TagSorters):
        self._TagSorters = TagSorters

    @property
    def ResultFilters(self):
        """结果过滤
        :rtype: list of ResultFilter
        """
        return self._ResultFilters

    @ResultFilters.setter
    def ResultFilters(self, ResultFilters):
        self._ResultFilters = ResultFilters

    @property
    def SortOn(self):
        """排序、筛选所基于任务的SID
        :rtype: str
        """
        return self._SortOn

    @SortOn.setter
    def SortOn(self, SortOn):
        self._SortOn = SortOn


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._AutoMLEvaluateTaskId = params.get("AutoMLEvaluateTaskId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._Order = params.get("Order")
        self._Type = params.get("Type")
        self._QueryType = params.get("QueryType")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = ComparisonTagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        if params.get("TagSorters") is not None:
            self._TagSorters = []
            for item in params.get("TagSorters"):
                obj = TagSorter()
                obj._deserialize(item)
                self._TagSorters.append(obj)
        if params.get("ResultFilters") is not None:
            self._ResultFilters = []
            for item in params.get("ResultFilters"):
                obj = ResultFilter()
                obj._deserialize(item)
                self._ResultFilters.append(obj)
        self._SortOn = params.get("SortOn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskEvaluationASRBadcaseResponse(AbstractModel):
    """DescribeAutoMLTaskEvaluationASRBadcase返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _AutoMLEvaluateTaskId: 本次请求的所有的自动学习评测任务id
        :type AutoMLEvaluateTaskId: str
        :param _ComparedPredictions: 预测结果
        :type ComparedPredictions: list of ComparedPrediction
        :param _TotalCount: 预测结果总量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._AutoMLEvaluateTaskId = None
        self._ComparedPredictions = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def AutoMLEvaluateTaskId(self):
        """本次请求的所有的自动学习评测任务id
        :rtype: str
        """
        return self._AutoMLEvaluateTaskId

    @AutoMLEvaluateTaskId.setter
    def AutoMLEvaluateTaskId(self, AutoMLEvaluateTaskId):
        self._AutoMLEvaluateTaskId = AutoMLEvaluateTaskId

    @property
    def ComparedPredictions(self):
        """预测结果
        :rtype: list of ComparedPrediction
        """
        return self._ComparedPredictions

    @ComparedPredictions.setter
    def ComparedPredictions(self, ComparedPredictions):
        self._ComparedPredictions = ComparedPredictions

    @property
    def TotalCount(self):
        """预测结果总量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._AutoMLEvaluateTaskId = params.get("AutoMLEvaluateTaskId")
        if params.get("ComparedPredictions") is not None:
            self._ComparedPredictions = []
            for item in params.get("ComparedPredictions"):
                obj = ComparedPrediction()
                obj._deserialize(item)
                self._ComparedPredictions.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskEvaluationASRBaseIndicatorRequest(AbstractModel):
    """DescribeAutoMLTaskEvaluationASRBaseIndicator请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _XiaoWeiAppInfo: 云小微app info
        :type XiaoWeiAppInfo: :class:`tencentcloud.tione.v20211111.models.XiaoWeiAppInfo`
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        """
        self._AutoMLTaskId = None
        self._XiaoWeiAppInfo = None
        self._EvaluationTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def XiaoWeiAppInfo(self):
        """云小微app info
        :rtype: :class:`tencentcloud.tione.v20211111.models.XiaoWeiAppInfo`
        """
        return self._XiaoWeiAppInfo

    @XiaoWeiAppInfo.setter
    def XiaoWeiAppInfo(self, XiaoWeiAppInfo):
        self._XiaoWeiAppInfo = XiaoWeiAppInfo

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        if params.get("XiaoWeiAppInfo") is not None:
            self._XiaoWeiAppInfo = XiaoWeiAppInfo()
            self._XiaoWeiAppInfo._deserialize(params.get("XiaoWeiAppInfo"))
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskEvaluationASRBaseIndicatorResponse(AbstractModel):
    """DescribeAutoMLTaskEvaluationASRBaseIndicator返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrentAccuracy: 当前模型准确度
注意：此字段可能返回 null，表示取不到有效值。
        :type CurrentAccuracy: str
        :param _PreviousAccuracy: 优化前模型准确度
注意：此字段可能返回 null，表示取不到有效值。
        :type PreviousAccuracy: str
        :param _CurrentScalarMetrics: 当前模型的标量指标
注意：此字段可能返回 null，表示取不到有效值。
        :type CurrentScalarMetrics: list of ScalarItem
        :param _PreviousScalarMetrics: 优化前模型的标量指标
注意：此字段可能返回 null，表示取不到有效值。
        :type PreviousScalarMetrics: list of ScalarItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CurrentAccuracy = None
        self._PreviousAccuracy = None
        self._CurrentScalarMetrics = None
        self._PreviousScalarMetrics = None
        self._RequestId = None

    @property
    def CurrentAccuracy(self):
        """当前模型准确度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CurrentAccuracy

    @CurrentAccuracy.setter
    def CurrentAccuracy(self, CurrentAccuracy):
        self._CurrentAccuracy = CurrentAccuracy

    @property
    def PreviousAccuracy(self):
        """优化前模型准确度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PreviousAccuracy

    @PreviousAccuracy.setter
    def PreviousAccuracy(self, PreviousAccuracy):
        self._PreviousAccuracy = PreviousAccuracy

    @property
    def CurrentScalarMetrics(self):
        """当前模型的标量指标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ScalarItem
        """
        return self._CurrentScalarMetrics

    @CurrentScalarMetrics.setter
    def CurrentScalarMetrics(self, CurrentScalarMetrics):
        self._CurrentScalarMetrics = CurrentScalarMetrics

    @property
    def PreviousScalarMetrics(self):
        """优化前模型的标量指标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ScalarItem
        """
        return self._PreviousScalarMetrics

    @PreviousScalarMetrics.setter
    def PreviousScalarMetrics(self, PreviousScalarMetrics):
        self._PreviousScalarMetrics = PreviousScalarMetrics

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CurrentAccuracy = params.get("CurrentAccuracy")
        self._PreviousAccuracy = params.get("PreviousAccuracy")
        if params.get("CurrentScalarMetrics") is not None:
            self._CurrentScalarMetrics = []
            for item in params.get("CurrentScalarMetrics"):
                obj = ScalarItem()
                obj._deserialize(item)
                self._CurrentScalarMetrics.append(obj)
        if params.get("PreviousScalarMetrics") is not None:
            self._PreviousScalarMetrics = []
            for item in params.get("PreviousScalarMetrics"):
                obj = ScalarItem()
                obj._deserialize(item)
                self._PreviousScalarMetrics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskEvaluationASRDetailRequest(AbstractModel):
    """DescribeAutoMLTaskEvaluationASRDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskEvaluationASRDetailResponse(AbstractModel):
    """DescribeAutoMLTaskEvaluationASRDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _TestDataSetNames: 测试数据集名称
        :type TestDataSetNames: list of str
        :param _TotalSampleCount: 测试数据集样本数量
        :type TotalSampleCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._TestDataSetNames = None
        self._TotalSampleCount = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def TestDataSetNames(self):
        """测试数据集名称
        :rtype: list of str
        """
        return self._TestDataSetNames

    @TestDataSetNames.setter
    def TestDataSetNames(self, TestDataSetNames):
        self._TestDataSetNames = TestDataSetNames

    @property
    def TotalSampleCount(self):
        """测试数据集样本数量
        :rtype: int
        """
        return self._TotalSampleCount

    @TotalSampleCount.setter
    def TotalSampleCount(self, TotalSampleCount):
        self._TotalSampleCount = TotalSampleCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._TestDataSetNames = params.get("TestDataSetNames")
        self._TotalSampleCount = params.get("TotalSampleCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskEvaluationBadcasesRequest(AbstractModel):
    """DescribeAutoMLTaskEvaluationBadcases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _Threshold: 阈值
        :type Threshold: float
        :param _GroundTruthLabels: groundTruth标签过滤数组
        :type GroundTruthLabels: list of str
        :param _PredictLabels: 模型推理结果标签过滤数据
        :type PredictLabels: list of str
        :param _Offset: 偏移量，默认0
        :type Offset: int
        :param _Limit: 结果大小限制，默认10
        :type Limit: int
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._Threshold = None
        self._GroundTruthLabels = None
        self._PredictLabels = None
        self._Offset = None
        self._Limit = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def Threshold(self):
        """阈值
        :rtype: float
        """
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold

    @property
    def GroundTruthLabels(self):
        """groundTruth标签过滤数组
        :rtype: list of str
        """
        return self._GroundTruthLabels

    @GroundTruthLabels.setter
    def GroundTruthLabels(self, GroundTruthLabels):
        self._GroundTruthLabels = GroundTruthLabels

    @property
    def PredictLabels(self):
        """模型推理结果标签过滤数据
        :rtype: list of str
        """
        return self._PredictLabels

    @PredictLabels.setter
    def PredictLabels(self, PredictLabels):
        self._PredictLabels = PredictLabels

    @property
    def Offset(self):
        """偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """结果大小限制，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._Threshold = params.get("Threshold")
        self._GroundTruthLabels = params.get("GroundTruthLabels")
        self._PredictLabels = params.get("PredictLabels")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskEvaluationBadcasesResponse(AbstractModel):
    """DescribeAutoMLTaskEvaluationBadcases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type EvaluationTaskId: str
        :param _Threshold: 阈值
注意：此字段可能返回 null，表示取不到有效值。
        :type Threshold: float
        :param _TotalCount: 总的badcase数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _ImageInfos: badcase图像列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageInfos: list of BadcaseImageInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._Threshold = None
        self._TotalCount = None
        self._ImageInfos = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def Threshold(self):
        """阈值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold

    @property
    def TotalCount(self):
        """总的badcase数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageInfos(self):
        """badcase图像列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of BadcaseImageInfo
        """
        return self._ImageInfos

    @ImageInfos.setter
    def ImageInfos(self, ImageInfos):
        self._ImageInfos = ImageInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._Threshold = params.get("Threshold")
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageInfos") is not None:
            self._ImageInfos = []
            for item in params.get("ImageInfos"):
                obj = BadcaseImageInfo()
                obj._deserialize(item)
                self._ImageInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskEvaluationBaseIndicatorsRequest(AbstractModel):
    """DescribeAutoMLTaskEvaluationBaseIndicators请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _Threshold: 评测结果指标对应的阈值，不填默认0.5
        :type Threshold: float
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._Threshold = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def Threshold(self):
        """评测结果指标对应的阈值，不填默认0.5
        :rtype: float
        """
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._Threshold = params.get("Threshold")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskEvaluationBaseIndicatorsResponse(AbstractModel):
    """DescribeAutoMLTaskEvaluationBaseIndicators返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _EvaluationTaskStatus: 评测任务状态
        :type EvaluationTaskStatus: str
        :param _Accuracy: 请求阈值下的精度
注意：此字段可能返回 null，表示取不到有效值。
        :type Accuracy: float
        :param _Recall: 请求阈值下的召回率
注意：此字段可能返回 null，表示取不到有效值。
        :type Recall: float
        :param _FScore: 请求阈值下的f1-score
注意：此字段可能返回 null，表示取不到有效值。
        :type FScore: float
        :param _MAP: 请求阈值下的mAP
注意：此字段可能返回 null，表示取不到有效值。
        :type MAP: float
        :param _Threshold: 请求阈值
注意：此字段可能返回 null，表示取不到有效值。
        :type Threshold: float
        :param _NLPItems: NLP基础指标
注意：此字段可能返回 null，表示取不到有效值。
        :type NLPItems: list of NLPIndicatorItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._EvaluationTaskStatus = None
        self._Accuracy = None
        self._Recall = None
        self._FScore = None
        self._MAP = None
        self._Threshold = None
        self._NLPItems = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def EvaluationTaskStatus(self):
        """评测任务状态
        :rtype: str
        """
        return self._EvaluationTaskStatus

    @EvaluationTaskStatus.setter
    def EvaluationTaskStatus(self, EvaluationTaskStatus):
        self._EvaluationTaskStatus = EvaluationTaskStatus

    @property
    def Accuracy(self):
        """请求阈值下的精度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Accuracy

    @Accuracy.setter
    def Accuracy(self, Accuracy):
        self._Accuracy = Accuracy

    @property
    def Recall(self):
        """请求阈值下的召回率
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Recall

    @Recall.setter
    def Recall(self, Recall):
        self._Recall = Recall

    @property
    def FScore(self):
        """请求阈值下的f1-score
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._FScore

    @FScore.setter
    def FScore(self, FScore):
        self._FScore = FScore

    @property
    def MAP(self):
        """请求阈值下的mAP
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._MAP

    @MAP.setter
    def MAP(self, MAP):
        self._MAP = MAP

    @property
    def Threshold(self):
        """请求阈值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold

    @property
    def NLPItems(self):
        """NLP基础指标
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of NLPIndicatorItem
        """
        return self._NLPItems

    @NLPItems.setter
    def NLPItems(self, NLPItems):
        self._NLPItems = NLPItems

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._EvaluationTaskStatus = params.get("EvaluationTaskStatus")
        self._Accuracy = params.get("Accuracy")
        self._Recall = params.get("Recall")
        self._FScore = params.get("FScore")
        self._MAP = params.get("MAP")
        self._Threshold = params.get("Threshold")
        if params.get("NLPItems") is not None:
            self._NLPItems = []
            for item in params.get("NLPItems"):
                obj = NLPIndicatorItem()
                obj._deserialize(item)
                self._NLPItems.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskEvaluationDetailRequest(AbstractModel):
    """DescribeAutoMLTaskEvaluationDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _Threshold: 指定阈值，阈值范围为[0.05, 0.95]，步长为0.05
        :type Threshold: float
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._Threshold = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def Threshold(self):
        """指定阈值，阈值范围为[0.05, 0.95]，步长为0.05
        :rtype: float
        """
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._Threshold = params.get("Threshold")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskEvaluationDetailResponse(AbstractModel):
    """DescribeAutoMLTaskEvaluationDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type EvaluationTaskId: str
        :param _TestDatasetIds: 评测任务有效数据集列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TestDatasetIds: list of str
        :param _TestDatasetLabels: 参与评测有效标签列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TestDatasetLabels: list of str
        :param _ImgNums: 参与评测的有效图像数据量
注意：此字段可能返回 null，表示取不到有效值。
        :type ImgNums: int
        :param _BadCaseNums: 查询阈值下的badcase数量
注意：此字段可能返回 null，表示取不到有效值。
        :type BadCaseNums: int
        :param _Scene: 评测任务场景信息详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Scene: :class:`tencentcloud.tione.v20211111.models.Scene`
        :param _EvaluationCostSeconds: 评测任务运行时长，单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :type EvaluationCostSeconds: int
        :param _TxtNums: 文本数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TxtNums: int
        :param _NLPItems: “题目”查询参数扩展
注意：此字段可能返回 null，表示取不到有效值。
        :type NLPItems: list of NLPItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._TestDatasetIds = None
        self._TestDatasetLabels = None
        self._ImgNums = None
        self._BadCaseNums = None
        self._Scene = None
        self._EvaluationCostSeconds = None
        self._TxtNums = None
        self._NLPItems = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def TestDatasetIds(self):
        """评测任务有效数据集列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._TestDatasetIds

    @TestDatasetIds.setter
    def TestDatasetIds(self, TestDatasetIds):
        self._TestDatasetIds = TestDatasetIds

    @property
    def TestDatasetLabels(self):
        """参与评测有效标签列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._TestDatasetLabels

    @TestDatasetLabels.setter
    def TestDatasetLabels(self, TestDatasetLabels):
        self._TestDatasetLabels = TestDatasetLabels

    @property
    def ImgNums(self):
        """参与评测的有效图像数据量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ImgNums

    @ImgNums.setter
    def ImgNums(self, ImgNums):
        self._ImgNums = ImgNums

    @property
    def BadCaseNums(self):
        """查询阈值下的badcase数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._BadCaseNums

    @BadCaseNums.setter
    def BadCaseNums(self, BadCaseNums):
        self._BadCaseNums = BadCaseNums

    @property
    def Scene(self):
        """评测任务场景信息详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.Scene`
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene

    @property
    def EvaluationCostSeconds(self):
        """评测任务运行时长，单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._EvaluationCostSeconds

    @EvaluationCostSeconds.setter
    def EvaluationCostSeconds(self, EvaluationCostSeconds):
        self._EvaluationCostSeconds = EvaluationCostSeconds

    @property
    def TxtNums(self):
        """文本数量
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TxtNums

    @TxtNums.setter
    def TxtNums(self, TxtNums):
        self._TxtNums = TxtNums

    @property
    def NLPItems(self):
        """“题目”查询参数扩展
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of NLPItem
        """
        return self._NLPItems

    @NLPItems.setter
    def NLPItems(self, NLPItems):
        self._NLPItems = NLPItems

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._TestDatasetIds = params.get("TestDatasetIds")
        self._TestDatasetLabels = params.get("TestDatasetLabels")
        self._ImgNums = params.get("ImgNums")
        self._BadCaseNums = params.get("BadCaseNums")
        if params.get("Scene") is not None:
            self._Scene = Scene()
            self._Scene._deserialize(params.get("Scene"))
        self._EvaluationCostSeconds = params.get("EvaluationCostSeconds")
        self._TxtNums = params.get("TxtNums")
        if params.get("NLPItems") is not None:
            self._NLPItems = []
            for item in params.get("NLPItems"):
                obj = NLPItem()
                obj._deserialize(item)
                self._NLPItems.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskEvaluationNLUSeniorIndicatorRequest(AbstractModel):
    """DescribeAutoMLTaskEvaluationNLUSeniorIndicator请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskEvaluationNLUSeniorIndicatorResponse(AbstractModel):
    """DescribeAutoMLTaskEvaluationNLUSeniorIndicator返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CurrentMetrics: 当前模型详细指标
        :type CurrentMetrics: str
        :param _PreviousMetrics: 优化前模型详细指标
        :type PreviousMetrics: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CurrentMetrics = None
        self._PreviousMetrics = None
        self._RequestId = None

    @property
    def CurrentMetrics(self):
        """当前模型详细指标
        :rtype: str
        """
        return self._CurrentMetrics

    @CurrentMetrics.setter
    def CurrentMetrics(self, CurrentMetrics):
        self._CurrentMetrics = CurrentMetrics

    @property
    def PreviousMetrics(self):
        """优化前模型详细指标
        :rtype: str
        """
        return self._PreviousMetrics

    @PreviousMetrics.setter
    def PreviousMetrics(self, PreviousMetrics):
        self._PreviousMetrics = PreviousMetrics

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CurrentMetrics = params.get("CurrentMetrics")
        self._PreviousMetrics = params.get("PreviousMetrics")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskEvaluationSeniorIndicatorsRequest(AbstractModel):
    """DescribeAutoMLTaskEvaluationSeniorIndicators请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _Thresholds: 每个标签对应的阈值信息，不填默认所有标签用默认的0.5，填一个表示所有标签的阈值一样
        :type Thresholds: list of float
        :param _MaxConfusionMatrixSize: 返回的最大混淆矩阵大小，超过的则截断返回; 默认:0; 不截断，全部返回
        :type MaxConfusionMatrixSize: int
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._Thresholds = None
        self._MaxConfusionMatrixSize = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def Thresholds(self):
        """每个标签对应的阈值信息，不填默认所有标签用默认的0.5，填一个表示所有标签的阈值一样
        :rtype: list of float
        """
        return self._Thresholds

    @Thresholds.setter
    def Thresholds(self, Thresholds):
        self._Thresholds = Thresholds

    @property
    def MaxConfusionMatrixSize(self):
        """返回的最大混淆矩阵大小，超过的则截断返回; 默认:0; 不截断，全部返回
        :rtype: int
        """
        return self._MaxConfusionMatrixSize

    @MaxConfusionMatrixSize.setter
    def MaxConfusionMatrixSize(self, MaxConfusionMatrixSize):
        self._MaxConfusionMatrixSize = MaxConfusionMatrixSize


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._Thresholds = params.get("Thresholds")
        self._MaxConfusionMatrixSize = params.get("MaxConfusionMatrixSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskEvaluationSeniorIndicatorsResponse(AbstractModel):
    """DescribeAutoMLTaskEvaluationSeniorIndicators返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _TestLabels: 评测标签列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TestLabels: list of str
        :param _Thresholds: 评测结果每个标签对应的阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Thresholds: list of float
        :param _Precisions: 评测结果每个标签对应的精度信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Precisions: list of float
        :param _Recalls: 评测结果每个标签对应的召回率信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Recalls: list of float
        :param _FScores: 评测结果每个标签对应的f1-score信息
注意：此字段可能返回 null，表示取不到有效值。
        :type FScores: list of float
        :param _MAP: 评测结果每个标签对应的mAP信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MAP: list of float
        :param _PRValues: pr曲线详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :type PRValues: list of PRValue
        :param _ConfusionMatrix: 混淆矩阵
注意：此字段可能返回 null，表示取不到有效值。
        :type ConfusionMatrix: list of DataArray
        :param _MultiLabel: NLP是否为多标签
注意：此字段可能返回 null，表示取不到有效值。
        :type MultiLabel: bool
        :param _Accuracies: NLP的分类别准确率
注意：此字段可能返回 null，表示取不到有效值。
        :type Accuracies: list of float
        :param _MacroFScores: NLP的宏平均
注意：此字段可能返回 null，表示取不到有效值。
        :type MacroFScores: list of float
        :param _MicroFScores: NLP的微平均
注意：此字段可能返回 null，表示取不到有效值。
        :type MicroFScores: list of float
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._TestLabels = None
        self._Thresholds = None
        self._Precisions = None
        self._Recalls = None
        self._FScores = None
        self._MAP = None
        self._PRValues = None
        self._ConfusionMatrix = None
        self._MultiLabel = None
        self._Accuracies = None
        self._MacroFScores = None
        self._MicroFScores = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def TestLabels(self):
        """评测标签列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._TestLabels

    @TestLabels.setter
    def TestLabels(self, TestLabels):
        self._TestLabels = TestLabels

    @property
    def Thresholds(self):
        """评测结果每个标签对应的阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._Thresholds

    @Thresholds.setter
    def Thresholds(self, Thresholds):
        self._Thresholds = Thresholds

    @property
    def Precisions(self):
        """评测结果每个标签对应的精度信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._Precisions

    @Precisions.setter
    def Precisions(self, Precisions):
        self._Precisions = Precisions

    @property
    def Recalls(self):
        """评测结果每个标签对应的召回率信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._Recalls

    @Recalls.setter
    def Recalls(self, Recalls):
        self._Recalls = Recalls

    @property
    def FScores(self):
        """评测结果每个标签对应的f1-score信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._FScores

    @FScores.setter
    def FScores(self, FScores):
        self._FScores = FScores

    @property
    def MAP(self):
        """评测结果每个标签对应的mAP信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._MAP

    @MAP.setter
    def MAP(self, MAP):
        self._MAP = MAP

    @property
    def PRValues(self):
        """pr曲线详细信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of PRValue
        """
        return self._PRValues

    @PRValues.setter
    def PRValues(self, PRValues):
        self._PRValues = PRValues

    @property
    def ConfusionMatrix(self):
        """混淆矩阵
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataArray
        """
        return self._ConfusionMatrix

    @ConfusionMatrix.setter
    def ConfusionMatrix(self, ConfusionMatrix):
        self._ConfusionMatrix = ConfusionMatrix

    @property
    def MultiLabel(self):
        """NLP是否为多标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._MultiLabel

    @MultiLabel.setter
    def MultiLabel(self, MultiLabel):
        self._MultiLabel = MultiLabel

    @property
    def Accuracies(self):
        """NLP的分类别准确率
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._Accuracies

    @Accuracies.setter
    def Accuracies(self, Accuracies):
        self._Accuracies = Accuracies

    @property
    def MacroFScores(self):
        """NLP的宏平均
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._MacroFScores

    @MacroFScores.setter
    def MacroFScores(self, MacroFScores):
        self._MacroFScores = MacroFScores

    @property
    def MicroFScores(self):
        """NLP的微平均
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._MicroFScores

    @MicroFScores.setter
    def MicroFScores(self, MicroFScores):
        self._MicroFScores = MicroFScores

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._TestLabels = params.get("TestLabels")
        self._Thresholds = params.get("Thresholds")
        self._Precisions = params.get("Precisions")
        self._Recalls = params.get("Recalls")
        self._FScores = params.get("FScores")
        self._MAP = params.get("MAP")
        if params.get("PRValues") is not None:
            self._PRValues = []
            for item in params.get("PRValues"):
                obj = PRValue()
                obj._deserialize(item)
                self._PRValues.append(obj)
        if params.get("ConfusionMatrix") is not None:
            self._ConfusionMatrix = []
            for item in params.get("ConfusionMatrix"):
                obj = DataArray()
                obj._deserialize(item)
                self._ConfusionMatrix.append(obj)
        self._MultiLabel = params.get("MultiLabel")
        self._Accuracies = params.get("Accuracies")
        self._MacroFScores = params.get("MacroFScores")
        self._MicroFScores = params.get("MicroFScores")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskNLPEvaluationBadcasesRequest(AbstractModel):
    """DescribeAutoMLTaskNLPEvaluationBadcases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: NLP评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _Topic: 题目
        :type Topic: str
        :param _PreviewRange: 查询范围
        :type PreviewRange: str
        :param _Offset: 偏移量，默认0
        :type Offset: int
        :param _Limit: 结果大小限制，默认10
        :type Limit: int
        :param _NLPTagFilters: 过滤
        :type NLPTagFilters: list of NLPTagFilter
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._Topic = None
        self._PreviewRange = None
        self._Offset = None
        self._Limit = None
        self._NLPTagFilters = None

    @property
    def AutoMLTaskId(self):
        """NLP评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def Topic(self):
        """题目
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def PreviewRange(self):
        """查询范围
        :rtype: str
        """
        return self._PreviewRange

    @PreviewRange.setter
    def PreviewRange(self, PreviewRange):
        self._PreviewRange = PreviewRange

    @property
    def Offset(self):
        """偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """结果大小限制，默认10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NLPTagFilters(self):
        """过滤
        :rtype: list of NLPTagFilter
        """
        return self._NLPTagFilters

    @NLPTagFilters.setter
    def NLPTagFilters(self, NLPTagFilters):
        self._NLPTagFilters = NLPTagFilters


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._Topic = params.get("Topic")
        self._PreviewRange = params.get("PreviewRange")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("NLPTagFilters") is not None:
            self._NLPTagFilters = []
            for item in params.get("NLPTagFilters"):
                obj = NLPTagFilter()
                obj._deserialize(item)
                self._NLPTagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskNLPEvaluationBadcasesResponse(AbstractModel):
    """DescribeAutoMLTaskNLPEvaluationBadcases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: NLP评测任务所属自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type EvaluationTaskId: str
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _NLPBadcaseItems: NLP badcase数组
注意：此字段可能返回 null，表示取不到有效值。
        :type NLPBadcaseItems: list of NLPBadcaseItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._TotalCount = None
        self._NLPBadcaseItems = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """NLP评测任务所属自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def TotalCount(self):
        """总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def NLPBadcaseItems(self):
        """NLP badcase数组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of NLPBadcaseItem
        """
        return self._NLPBadcaseItems

    @NLPBadcaseItems.setter
    def NLPBadcaseItems(self, NLPBadcaseItems):
        self._NLPBadcaseItems = NLPBadcaseItems

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._TotalCount = params.get("TotalCount")
        if params.get("NLPBadcaseItems") is not None:
            self._NLPBadcaseItems = []
            for item in params.get("NLPBadcaseItems"):
                obj = NLPBadcaseItem()
                obj._deserialize(item)
                self._NLPBadcaseItems.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskNLUEvaluationBaseIndicatorRequest(AbstractModel):
    """DescribeAutoMLTaskNLUEvaluationBaseIndicator请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskNLUEvaluationBaseIndicatorResponse(AbstractModel):
    """DescribeAutoMLTaskNLUEvaluationBaseIndicator返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _BaseIndicator: 当前模型指标
        :type BaseIndicator: str
        :param _SeniorIndicator: 优化前模型指标
        :type SeniorIndicator: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None
        self._BaseIndicator = None
        self._SeniorIndicator = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def BaseIndicator(self):
        """当前模型指标
        :rtype: str
        """
        return self._BaseIndicator

    @BaseIndicator.setter
    def BaseIndicator(self, BaseIndicator):
        self._BaseIndicator = BaseIndicator

    @property
    def SeniorIndicator(self):
        """优化前模型指标
        :rtype: str
        """
        return self._SeniorIndicator

    @SeniorIndicator.setter
    def SeniorIndicator(self, SeniorIndicator):
        self._SeniorIndicator = SeniorIndicator

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._BaseIndicator = params.get("BaseIndicator")
        self._SeniorIndicator = params.get("SeniorIndicator")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskNLUEvaluationSeniorIndicatorRequest(AbstractModel):
    """DescribeAutoMLTaskNLUEvaluationSeniorIndicator请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        """
        self._AutoMLTaskId = None
        self._EvaluationTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskNLUEvaluationSeniorIndicatorResponse(AbstractModel):
    """DescribeAutoMLTaskNLUEvaluationSeniorIndicator返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EvaluationTaskId: 评测任务id
        :type EvaluationTaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EvaluationTaskId = None
        self._RequestId = None

    @property
    def EvaluationTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._EvaluationTaskId

    @EvaluationTaskId.setter
    def EvaluationTaskId(self, EvaluationTaskId):
        self._EvaluationTaskId = EvaluationTaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EvaluationTaskId = params.get("EvaluationTaskId")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskTrainDetailRequest(AbstractModel):
    """DescribeAutoMLTaskTrainDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        :param _TrainTaskId: 训练任务ID
        :type TrainTaskId: str
        """
        self._AutoMLTaskId = None
        self._TrainTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def TrainTaskId(self):
        """训练任务ID
        :rtype: str
        """
        return self._TrainTaskId

    @TrainTaskId.setter
    def TrainTaskId(self, TrainTaskId):
        self._TrainTaskId = TrainTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._TrainTaskId = params.get("TrainTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskTrainDetailResponse(AbstractModel):
    """DescribeAutoMLTaskTrainDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        :param _TrainTaskId: 训练任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTaskId: str
        :param _TrainTimeUsedSecond: 训练耗时
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTimeUsedSecond: int
        :param _TrainTimeExpectedSecond: 训练预估耗时
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTimeExpectedSecond: int
        :param _TrainTimeMaxSecond: 训练最大时长
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTimeMaxSecond: int
        :param _TrainProgress: 训练进度
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainProgress: int
        :param _TrainTaskStatus: 训练任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTaskStatus: str
        :param _TrainErrorMessage: 训练失败时错误详情
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainErrorMessage: str
        :param _TrainStartTime: 训练开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainStartTime: str
        :param _TrainEndTime: 训练结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainEndTime: float
        :param _TrainingTaskInfos: 任务式建模任务详情
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainingTaskInfos: list of TrainingTaskInfo
        :param _ModelAccTaskStatus: 模型优化任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelAccTaskStatus: str
        :param _OptimizationResult: 模型优化任务报告
注意：此字段可能返回 null，表示取不到有效值。
        :type OptimizationResult: :class:`tencentcloud.tione.v20211111.models.OptimizationResult`
        :param _ModelAccErrorMessage: 模型优化时错误详情
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelAccErrorMessage: str
        :param _ModelAccTaskProgress: 模型优化任务进度
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelAccTaskProgress: int
        :param _ModelAccRunningSeconds: 模型优化耗时
注意：此字段可能返回 null，表示取不到有效值。
        :type ModelAccRunningSeconds: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._TrainTaskId = None
        self._TrainTimeUsedSecond = None
        self._TrainTimeExpectedSecond = None
        self._TrainTimeMaxSecond = None
        self._TrainProgress = None
        self._TrainTaskStatus = None
        self._TrainErrorMessage = None
        self._TrainStartTime = None
        self._TrainEndTime = None
        self._TrainingTaskInfos = None
        self._ModelAccTaskStatus = None
        self._OptimizationResult = None
        self._ModelAccErrorMessage = None
        self._ModelAccTaskProgress = None
        self._ModelAccRunningSeconds = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def TrainTaskId(self):
        """训练任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainTaskId

    @TrainTaskId.setter
    def TrainTaskId(self, TrainTaskId):
        self._TrainTaskId = TrainTaskId

    @property
    def TrainTimeUsedSecond(self):
        """训练耗时
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TrainTimeUsedSecond

    @TrainTimeUsedSecond.setter
    def TrainTimeUsedSecond(self, TrainTimeUsedSecond):
        self._TrainTimeUsedSecond = TrainTimeUsedSecond

    @property
    def TrainTimeExpectedSecond(self):
        """训练预估耗时
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TrainTimeExpectedSecond

    @TrainTimeExpectedSecond.setter
    def TrainTimeExpectedSecond(self, TrainTimeExpectedSecond):
        self._TrainTimeExpectedSecond = TrainTimeExpectedSecond

    @property
    def TrainTimeMaxSecond(self):
        """训练最大时长
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TrainTimeMaxSecond

    @TrainTimeMaxSecond.setter
    def TrainTimeMaxSecond(self, TrainTimeMaxSecond):
        self._TrainTimeMaxSecond = TrainTimeMaxSecond

    @property
    def TrainProgress(self):
        """训练进度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TrainProgress

    @TrainProgress.setter
    def TrainProgress(self, TrainProgress):
        self._TrainProgress = TrainProgress

    @property
    def TrainTaskStatus(self):
        """训练任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainTaskStatus

    @TrainTaskStatus.setter
    def TrainTaskStatus(self, TrainTaskStatus):
        self._TrainTaskStatus = TrainTaskStatus

    @property
    def TrainErrorMessage(self):
        """训练失败时错误详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainErrorMessage

    @TrainErrorMessage.setter
    def TrainErrorMessage(self, TrainErrorMessage):
        self._TrainErrorMessage = TrainErrorMessage

    @property
    def TrainStartTime(self):
        """训练开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainStartTime

    @TrainStartTime.setter
    def TrainStartTime(self, TrainStartTime):
        self._TrainStartTime = TrainStartTime

    @property
    def TrainEndTime(self):
        """训练结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: float
        """
        return self._TrainEndTime

    @TrainEndTime.setter
    def TrainEndTime(self, TrainEndTime):
        self._TrainEndTime = TrainEndTime

    @property
    def TrainingTaskInfos(self):
        """任务式建模任务详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TrainingTaskInfo
        """
        return self._TrainingTaskInfos

    @TrainingTaskInfos.setter
    def TrainingTaskInfos(self, TrainingTaskInfos):
        self._TrainingTaskInfos = TrainingTaskInfos

    @property
    def ModelAccTaskStatus(self):
        """模型优化任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModelAccTaskStatus

    @ModelAccTaskStatus.setter
    def ModelAccTaskStatus(self, ModelAccTaskStatus):
        self._ModelAccTaskStatus = ModelAccTaskStatus

    @property
    def OptimizationResult(self):
        """模型优化任务报告
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.OptimizationResult`
        """
        return self._OptimizationResult

    @OptimizationResult.setter
    def OptimizationResult(self, OptimizationResult):
        self._OptimizationResult = OptimizationResult

    @property
    def ModelAccErrorMessage(self):
        """模型优化时错误详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ModelAccErrorMessage

    @ModelAccErrorMessage.setter
    def ModelAccErrorMessage(self, ModelAccErrorMessage):
        self._ModelAccErrorMessage = ModelAccErrorMessage

    @property
    def ModelAccTaskProgress(self):
        """模型优化任务进度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ModelAccTaskProgress

    @ModelAccTaskProgress.setter
    def ModelAccTaskProgress(self, ModelAccTaskProgress):
        self._ModelAccTaskProgress = ModelAccTaskProgress

    @property
    def ModelAccRunningSeconds(self):
        """模型优化耗时
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ModelAccRunningSeconds

    @ModelAccRunningSeconds.setter
    def ModelAccRunningSeconds(self, ModelAccRunningSeconds):
        self._ModelAccRunningSeconds = ModelAccRunningSeconds

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._TrainTaskId = params.get("TrainTaskId")
        self._TrainTimeUsedSecond = params.get("TrainTimeUsedSecond")
        self._TrainTimeExpectedSecond = params.get("TrainTimeExpectedSecond")
        self._TrainTimeMaxSecond = params.get("TrainTimeMaxSecond")
        self._TrainProgress = params.get("TrainProgress")
        self._TrainTaskStatus = params.get("TrainTaskStatus")
        self._TrainErrorMessage = params.get("TrainErrorMessage")
        self._TrainStartTime = params.get("TrainStartTime")
        self._TrainEndTime = params.get("TrainEndTime")
        if params.get("TrainingTaskInfos") is not None:
            self._TrainingTaskInfos = []
            for item in params.get("TrainingTaskInfos"):
                obj = TrainingTaskInfo()
                obj._deserialize(item)
                self._TrainingTaskInfos.append(obj)
        self._ModelAccTaskStatus = params.get("ModelAccTaskStatus")
        if params.get("OptimizationResult") is not None:
            self._OptimizationResult = OptimizationResult()
            self._OptimizationResult._deserialize(params.get("OptimizationResult"))
        self._ModelAccErrorMessage = params.get("ModelAccErrorMessage")
        self._ModelAccTaskProgress = params.get("ModelAccTaskProgress")
        self._ModelAccRunningSeconds = params.get("ModelAccRunningSeconds")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTaskTrainIndicatorsRequest(AbstractModel):
    """DescribeAutoMLTaskTrainIndicators请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        :param _TrainTaskId: 训练任务ID
        :type TrainTaskId: str
        """
        self._AutoMLTaskId = None
        self._TrainTaskId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def TrainTaskId(self):
        """训练任务ID
        :rtype: str
        """
        return self._TrainTaskId

    @TrainTaskId.setter
    def TrainTaskId(self, TrainTaskId):
        self._TrainTaskId = TrainTaskId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._TrainTaskId = params.get("TrainTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTaskTrainIndicatorsResponse(AbstractModel):
    """DescribeAutoMLTaskTrainIndicators返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务ID
        :type AutoMLTaskId: str
        :param _TrainTaskId: 训练任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTaskId: str
        :param _Scene: 场景
注意：此字段可能返回 null，表示取不到有效值。
        :type Scene: :class:`tencentcloud.tione.v20211111.models.Scene`
        :param _Epochs: 迭代id
注意：此字段可能返回 null，表示取不到有效值。
        :type Epochs: list of int non-negative
        :param _Accuracy: 准确率
注意：此字段可能返回 null，表示取不到有效值。
        :type Accuracy: list of float
        :param _AccTop1: top1准确率
注意：此字段可能返回 null，表示取不到有效值。
        :type AccTop1: list of float
        :param _AccTop5: top5准确率
注意：此字段可能返回 null，表示取不到有效值。
        :type AccTop5: list of float
        :param _Loss: 损失值
注意：此字段可能返回 null，表示取不到有效值。
        :type Loss: list of float
        :param _MAP: 检测mAP
注意：此字段可能返回 null，表示取不到有效值。
        :type MAP: list of float
        :param _TrainTimeUsedSecond: 已运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTimeUsedSecond: int
        :param _TrainTimeExpectedSecond: 预计运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTimeExpectedSecond: int
        :param _TrainTimeMaxSecond: 最长运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTimeMaxSecond: int
        :param _TrainProgress: 训练进度
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainProgress: int
        :param _TrainTaskStatus: 任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTaskStatus: str
        :param _TrainErrorMessage: 错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainErrorMessage: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AutoMLTaskId = None
        self._TrainTaskId = None
        self._Scene = None
        self._Epochs = None
        self._Accuracy = None
        self._AccTop1 = None
        self._AccTop5 = None
        self._Loss = None
        self._MAP = None
        self._TrainTimeUsedSecond = None
        self._TrainTimeExpectedSecond = None
        self._TrainTimeMaxSecond = None
        self._TrainProgress = None
        self._TrainTaskStatus = None
        self._TrainErrorMessage = None
        self._RequestId = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务ID
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def TrainTaskId(self):
        """训练任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainTaskId

    @TrainTaskId.setter
    def TrainTaskId(self, TrainTaskId):
        self._TrainTaskId = TrainTaskId

    @property
    def Scene(self):
        """场景
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.Scene`
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene

    @property
    def Epochs(self):
        """迭代id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of int non-negative
        """
        return self._Epochs

    @Epochs.setter
    def Epochs(self, Epochs):
        self._Epochs = Epochs

    @property
    def Accuracy(self):
        """准确率
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._Accuracy

    @Accuracy.setter
    def Accuracy(self, Accuracy):
        self._Accuracy = Accuracy

    @property
    def AccTop1(self):
        """top1准确率
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._AccTop1

    @AccTop1.setter
    def AccTop1(self, AccTop1):
        self._AccTop1 = AccTop1

    @property
    def AccTop5(self):
        """top5准确率
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._AccTop5

    @AccTop5.setter
    def AccTop5(self, AccTop5):
        self._AccTop5 = AccTop5

    @property
    def Loss(self):
        """损失值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._Loss

    @Loss.setter
    def Loss(self, Loss):
        self._Loss = Loss

    @property
    def MAP(self):
        """检测mAP
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of float
        """
        return self._MAP

    @MAP.setter
    def MAP(self, MAP):
        self._MAP = MAP

    @property
    def TrainTimeUsedSecond(self):
        """已运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TrainTimeUsedSecond

    @TrainTimeUsedSecond.setter
    def TrainTimeUsedSecond(self, TrainTimeUsedSecond):
        self._TrainTimeUsedSecond = TrainTimeUsedSecond

    @property
    def TrainTimeExpectedSecond(self):
        """预计运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TrainTimeExpectedSecond

    @TrainTimeExpectedSecond.setter
    def TrainTimeExpectedSecond(self, TrainTimeExpectedSecond):
        self._TrainTimeExpectedSecond = TrainTimeExpectedSecond

    @property
    def TrainTimeMaxSecond(self):
        """最长运行时长
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TrainTimeMaxSecond

    @TrainTimeMaxSecond.setter
    def TrainTimeMaxSecond(self, TrainTimeMaxSecond):
        self._TrainTimeMaxSecond = TrainTimeMaxSecond

    @property
    def TrainProgress(self):
        """训练进度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TrainProgress

    @TrainProgress.setter
    def TrainProgress(self, TrainProgress):
        self._TrainProgress = TrainProgress

    @property
    def TrainTaskStatus(self):
        """任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainTaskStatus

    @TrainTaskStatus.setter
    def TrainTaskStatus(self, TrainTaskStatus):
        self._TrainTaskStatus = TrainTaskStatus

    @property
    def TrainErrorMessage(self):
        """错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TrainErrorMessage

    @TrainErrorMessage.setter
    def TrainErrorMessage(self, TrainErrorMessage):
        self._TrainErrorMessage = TrainErrorMessage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._TrainTaskId = params.get("TrainTaskId")
        if params.get("Scene") is not None:
            self._Scene = Scene()
            self._Scene._deserialize(params.get("Scene"))
        self._Epochs = params.get("Epochs")
        self._Accuracy = params.get("Accuracy")
        self._AccTop1 = params.get("AccTop1")
        self._AccTop5 = params.get("AccTop5")
        self._Loss = params.get("Loss")
        self._MAP = params.get("MAP")
        self._TrainTimeUsedSecond = params.get("TrainTimeUsedSecond")
        self._TrainTimeExpectedSecond = params.get("TrainTimeExpectedSecond")
        self._TrainTimeMaxSecond = params.get("TrainTimeMaxSecond")
        self._TrainProgress = params.get("TrainProgress")
        self._TrainTaskStatus = params.get("TrainTaskStatus")
        self._TrainErrorMessage = params.get("TrainErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeAutoMLTrainTasksRequest(AbstractModel):
    """DescribeAutoMLTrainTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _TagFilters: 标签过滤条件
        :type TagFilters: list of TagFilter
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 返回个数
        :type Limit: int
        :param _OrderField: 排序字段
        :type OrderField: str
        :param _Order: 排序方式
        :type Order: str
        """
        self._Filters = None
        self._TagFilters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._Order = None

    @property
    def Filters(self):
        """过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        """标签过滤条件
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回个数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """排序字段
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Order(self):
        """排序方式
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMLTrainTasksResponse(AbstractModel):
    """DescribeAutoMLTrainTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrainTaskGroups: 训练任务组列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TrainTaskGroups: list of TrainTaskGroup
        :param _TotalCount: 总个数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrainTaskGroups = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TrainTaskGroups(self):
        """训练任务组列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TrainTaskGroup
        """
        return self._TrainTaskGroups

    @TrainTaskGroups.setter
    def TrainTaskGroups(self, TrainTaskGroups):
        self._TrainTaskGroups = TrainTaskGroups

    @property
    def TotalCount(self):
        """总个数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrainTaskGroups") is not None:
            self._TrainTaskGroups = []
            for item in params.get("TrainTaskGroups"):
                obj = TrainTaskGroup()
                obj._deserialize(item)
                self._TrainTaskGroups.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoMlTaskIntentSlotsRequest(AbstractModel):
    """DescribeAutoMlTaskIntentSlots请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AutoMLTaskId: 自动学习任务id
        :type AutoMLTaskId: str
        :param _AutoMLEvaluateTaskId: 评测任务id
        :type AutoMLEvaluateTaskId: str
        :param _TagFilters: tag过滤
        :type TagFilters: list of ComparisonTagFilter
        :param _TagSorters: 排序关系
        :type TagSorters: list of TagSorter
        :param _ResultFilters: 结果过滤
        :type ResultFilters: list of ResultFilter
        """
        self._AutoMLTaskId = None
        self._AutoMLEvaluateTaskId = None
        self._TagFilters = None
        self._TagSorters = None
        self._ResultFilters = None

    @property
    def AutoMLTaskId(self):
        """自动学习任务id
        :rtype: str
        """
        return self._AutoMLTaskId

    @AutoMLTaskId.setter
    def AutoMLTaskId(self, AutoMLTaskId):
        self._AutoMLTaskId = AutoMLTaskId

    @property
    def AutoMLEvaluateTaskId(self):
        """评测任务id
        :rtype: str
        """
        return self._AutoMLEvaluateTaskId

    @AutoMLEvaluateTaskId.setter
    def AutoMLEvaluateTaskId(self, AutoMLEvaluateTaskId):
        self._AutoMLEvaluateTaskId = AutoMLEvaluateTaskId

    @property
    def TagFilters(self):
        """tag过滤
        :rtype: list of ComparisonTagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def TagSorters(self):
        """排序关系
        :rtype: list of TagSorter
        """
        return self._TagSorters

    @TagSorters.setter
    def TagSorters(self, TagSorters):
        self._TagSorters = TagSorters

    @property
    def ResultFilters(self):
        """结果过滤
        :rtype: list of ResultFilter
        """
        return self._ResultFilters

    @ResultFilters.setter
    def ResultFilters(self, ResultFilters):
        self._ResultFilters = ResultFilters


    def _deserialize(self, params):
        self._AutoMLTaskId = params.get("AutoMLTaskId")
        self._AutoMLEvaluateTaskId = params.get("AutoMLEvaluateTaskId")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = ComparisonTagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        if params.get("TagSorters") is not None:
            self._TagSorters = []
            for item in params.get("TagSorters"):
                obj = TagSorter()
                obj._deserialize(item)
                self._TagSorters.append(obj)
        if params.get("ResultFilters") is not None:
            self._ResultFilters = []
            for item in params.get("ResultFilters"):
                obj = ResultFilter()
                obj._deserialize(item)
                self._ResultFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoMlTaskIntentSlotsResponse(AbstractModel):
    """DescribeAutoMlTaskIntentSlots返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IntentSlots: 意图槽位列表
        :type IntentSlots: list of IntentSlotsPair
        :param _TotalCount: 列表元素总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IntentSlots = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def IntentSlots(self):
        """意图槽位列表
        :rtype: list of IntentSlotsPair
        """
        return self._IntentSlots

    @IntentSlots.setter
    def IntentSlots(self, IntentSlots):
        self._IntentSlots = IntentSlots

    @property
    def TotalCount(self):
        """列表元素总数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IntentSlots") is not None:
            self._IntentSlots = []
            for item in params.get("IntentSlots"):
                obj = IntentSlotsPair()
                obj._deserialize(item)
                self._IntentSlots.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoOcrPredictionRequest(AbstractModel):
    """DescribeAutoOcrPrediction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _FileId: 文件id
        :type FileId: str
        :param _Pts: 坐标
        :type Pts: list of Point
        :param _RotateAngle: 旋转角度，支持0，90，180，270，360
        :type RotateAngle: int
        :param _AsyncTaskId: 异步任务ID
        :type AsyncTaskId: str
        """
        self._TaskId = None
        self._FileId = None
        self._Pts = None
        self._RotateAngle = None
        self._AsyncTaskId = None

    @property
    def TaskId(self):
        """任务id
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def FileId(self):
        """文件id
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Pts(self):
        """坐标
        :rtype: list of Point
        """
        return self._Pts

    @Pts.setter
    def Pts(self, Pts):
        self._Pts = Pts

    @property
    def RotateAngle(self):
        """旋转角度，支持0，90，180，270，360
        :rtype: int
        """
        return self._RotateAngle

    @RotateAngle.setter
    def RotateAngle(self, RotateAngle):
        self._RotateAngle = RotateAngle

    @property
    def AsyncTaskId(self):
        """异步任务ID
        :rtype: str
        """
        return self._AsyncTaskId

    @AsyncTaskId.setter
    def AsyncTaskId(self, AsyncTaskId):
        self._AsyncTaskId = AsyncTaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._FileId = params.get("FileId")
        if params.get("Pts") is not None:
            self._Pts = []
            for item in params.get("Pts"):
                obj = Point()
                obj._deserialize(item)
                self._Pts.append(obj)
        self._RotateAngle = params.get("RotateAngle")
        self._AsyncTaskId = params.get("AsyncTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoOcrPredictionResponse(AbstractModel):
    """DescribeAutoOcrPrediction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Value: 预测结果
        :type Value: str
        :param _AsyncTaskId: 异步任务ID，如果出现此值，需要携带此值轮询获取标注结果
注意：此字段可能返回 null，表示取不到有效值。
        :type AsyncTaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Value = None
        self._AsyncTaskId = None
        self._RequestId = None

    @property
    def Value(self):
        """预测结果
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def AsyncTaskId(self):
        """异步任务ID，如果出现此值，需要携带此值轮询获取标注结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AsyncTaskId

    @AsyncTaskId.setter
    def AsyncTaskId(self, AsyncTaskId):
        self._AsyncTaskId = AsyncTaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Value = params.get("Value")
        self._AsyncTaskId = params.get("AsyncTaskId")
        self._RequestId = params.get("RequestId")


class DescribeAvailableNodeStatisticRequest(AbstractModel):
    """DescribeAvailableNodeStatistic请求参数结构体

    """


class DescribeAvailableNodeStatisticResponse(AbstractModel):
    """DescribeAvailableNodeStatistic返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AvailableNodeStatisticList: 统计列表
        :type AvailableNodeStatisticList: list of AvailableNodeStatistic
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AvailableNodeStatisticList = None
        self._RequestId = None

    @property
    def AvailableNodeStatisticList(self):
        """统计列表
        :rtype: list of AvailableNodeStatistic
        """
        return self._AvailableNodeStatisticList

    @AvailableNodeStatisticList.setter
    def AvailableNodeStatisticList(self, AvailableNodeStatisticList):
        self._AvailableNodeStatisticList = AvailableNodeStatisticList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AvailableNodeStatisticList") is not None:
            self._AvailableNodeStatisticList = []
            for item in params.get("AvailableNodeStatisticList"):
                obj = AvailableNodeStatistic()
                obj._deserialize(item)
                self._AvailableNodeStatisticList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAvailableSWInstancesRequest(AbstractModel):
    """DescribeAvailableSWInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组ID
        :type ResourceGroupId: str
        :param _ChargeType: 节点计费类型，可选值为PREPAID和POSTPAID_BY_HOUR，默认值为PREPAID
        :type ChargeType: str
        :param _Marker: 分页的Marker
        :type Marker: str
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _TagFilters: 标签过滤条件
        :type TagFilters: list of TagFilter
        """
        self._ResourceGroupId = None
        self._ChargeType = None
        self._Marker = None
        self._Filters = None
        self._TagFilters = None

    @property
    def ResourceGroupId(self):
        """资源组ID
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ChargeType(self):
        """节点计费类型，可选值为PREPAID和POSTPAID_BY_HOUR，默认值为PREPAID
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def Marker(self):
        """分页的Marker
        :rtype: str
        """
        return self._Marker

    @Marker.setter
    def Marker(self, Marker):
        self._Marker = Marker

    @property
    def Filters(self):
        """过滤条件
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        """标签过滤条件
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ChargeType = params.get("ChargeType")
        self._Marker = params.get("Marker")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAvailableSWInstancesResponse(AbstractModel):
    """DescribeAvailableSWInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: CVM实例与TI配置项信息
        :type Instances: list of CVMInstanceWithSpec
        :param _Marker: 下一页分页的Marker
        :type Marker: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Instances = None
        self._Marker = None
        self._RequestId = None

    @property
    def Instances(self):
        """CVM实例与TI配置项信息
        :rtype: list of CVMInstanceWithSpec
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def Marker(self):
        """下一页分页的Marker
        :rtype: str
        """
        return self._Marker

    @Marker.setter
    def Marker(self, Marker):
        self._Marker = Marker

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CVMInstanceWithSpec()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._Marker = params.get("Marker")
        self._RequestId = params.get("RequestId")


class DescribeBadcasePreviewStatusRequest(AbstractModel):
    """DescribeBadcasePreviewStatus请求参数结构体

    """


class DescribeBadcasePreviewStatusResponse(AbstractModel):
    """DescribeBadcasePreviewStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PreviewStatus: 预览开关状态，有OFF(关闭), ON(开启)
注意：此字段可能返回 null，表示取不到有效值。
        :type PreviewStatus: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PreviewStatus = None
        self._RequestId = None

    @property
    def PreviewStatus(self):
        """预览开关状态，有OFF(关闭), ON(开启)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PreviewStatus

    @PreviewStatus.setter
    def PreviewStatus(self, PreviewStatus):
        self._PreviewStatus = PreviewStatus

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PreviewStatus = params.get("PreviewStatus")
        self._RequestId = params.get("RequestId")


class DescribeBatchTaskInstancesRequest(AbstractModel):
    """DescribeBatchTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchTaskId: 批量预测任务id
        :type BatchTaskId: str
        """
        self._BatchTaskId = None

    @property
    def BatchTaskId(self):
        """批量预测任务id
        :rtype: str
        """
        return self._BatchTaskId

    @BatchTaskId.setter
    def BatchTaskId(self, BatchTaskId):
        self._BatchTaskId = BatchTaskId


    def _deserialize(self, params):
        self._BatchTaskId = params.get("BatchTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchTaskInstancesResponse(AbstractModel):
    """DescribeBatchTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchInstances: 批量预测实例结果
注意：此字段可能返回 null，表示取不到有效值。
        :type BatchInstances: list of BatchTaskInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BatchInstances = None
        self._RequestId = None

    @property
    def BatchInstances(self):
        """批量预测实例结果
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of BatchTaskInstance
        """
        return self._BatchInstances

    @BatchInstances.setter
    def BatchInstances(self, BatchInstances):
        self._BatchInstances = BatchInstances

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BatchInstances") is not None:
            self._BatchInstances = []
            for item in params.get("BatchInstances"):
                obj = BatchTaskInstance()
                obj._deserialize(item)
                self._BatchInstances.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBatchTaskRequest(AbstractModel):
    """DescribeBatchTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchTaskId: 批量预测任务ID
        :type BatchTaskId: str
        """
        self._BatchTaskId = None

    @property
    def BatchTaskId(self):
        """批量预测任务ID
        :rtype: str
        """
        return self._BatchTaskId

    @BatchTaskId.setter
    def BatchTaskId(self, BatchTaskId):
        self._BatchTaskId = BatchTaskId


    def _deserialize(self, params):
        self._BatchTaskId = params.get("BatchTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchTaskResponse(AbstractModel):
    """DescribeBatchTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BatchTaskDetail: 批量预测任务详情
注意：此字段可能返回 null，表示取不到有效值。
        :type BatchTaskDetail: :class:`tencentcloud.tione.v20211111.models.BatchTaskDetail`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BatchTaskDetail = None
        self._RequestId = None

    @property
    def BatchTaskDetail(self):
        """批量预测任务详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.BatchTaskDetail`
        """
        return self._BatchTaskDetail

    @BatchTaskDetail.setter
    def BatchTaskDetail(self, BatchTaskDetail):
        self._BatchTaskDetail = BatchTaskDetail

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BatchTaskDetail") is not None:
            self._BatchTaskDetail = BatchTaskDetail()
            self._BatchTaskDetail._deserialize(params.get("BatchTaskDetail"))
        self._RequestId = params.get("RequestId")


class DescribeBatchTasksRequest(AbstractModel):
    """DescribeBatchTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤器

Name支持的取值范围：
BatchTaskId, BatchTaskName, Status, ModelVersionId

其中Status 的有效取值范围:
INIT, STARTING, RUNNING, FAILED, STOPPING, STOPPED, SUCCEED
        :type Filters: list of Filter
        :param _TagFilters: 标签过滤器
        :type TagFilters: list of TagFilter
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 限制数目，默认为20
        :type Limit: int
        :param _Order: 输出列表的排列顺序。取值范围：ASC（升序排列）/ DESC（降序排列），默认为DESC
        :type Order: str
        :param _OrderField: 排序字段。当前仅支持 "CreateTime"。
不传此字段则按照DB默认排序结果返回
        :type OrderField: str
        """
        self._Filters = None
        self._TagFilters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._OrderField = None

    @property
    def Filters(self):
        """过滤器

Name支持的取值范围：
BatchTaskId, BatchTaskName, Status, ModelVersionId

其中Status 的有效取值范围:
INIT, STARTING, RUNNING, FAILED, STOPPING, STOPPED, SUCCEED
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        """标签过滤器
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """限制数目，默认为20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        """输出列表的排列顺序。取值范围：ASC（升序排列）/ DESC（降序排列），默认为DESC
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OrderField(self):
        """排序字段。当前仅支持 "CreateTime"。
不传此字段则按照DB默认排序结果返回
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._OrderField = params.get("OrderField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchTasksResponse(AbstractModel):
    """DescribeBatchTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 批量预测任务总数
        :type TotalCount: int
        :param _BatchTaskSet: 批量预测任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type BatchTaskSet: list of BatchTaskSetItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._BatchTaskSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """批量预测任务总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BatchTaskSet(self):
        """批量预测任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of BatchTaskSetItem
        """
        return self._BatchTaskSet

    @BatchTaskSet.setter
    def BatchTaskSet(self, BatchTaskSet):
        self._BatchTaskSet = BatchTaskSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BatchTaskSet") is not None:
            self._BatchTaskSet = []
            for item in params.get("BatchTaskSet"):
                obj = BatchTaskSetItem()
                obj._deserialize(item)
                self._BatchTaskSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingResourceGroupRequest(AbstractModel):
    """DescribeBillingResourceGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组id, 取值为创建资源组接口(CreateBillingResourceGroup)响应中的ResourceGroupId
        :type ResourceGroupId: str
        :param _Filters: 过滤条件
注意: 
1. Filter.Name 只支持以下枚举值:
    InstanceId (资源组节点id)
    InstanceStatus (资源组节点状态)
2. Filter.Values: 长度为1且Filter.Fuzzy=true时，支持模糊查询; 不为1时，精确查询
3. 每次请求的Filters的上限为10，Filter.Values的上限为100
        :type Filters: list of Filter
        :param _Offset: 分页查询起始位置，如：Limit为10，第一页Offset为0，第二页Offset为10....即每页左边为闭区间; 默认0
        :type Offset: int
        :param _Limit: 分页查询每页大小，默认20
        :type Limit: int
        :param _Order: 排序方向; 枚举值: ASC | DESC；默认DESC
        :type Order: str
        :param _OrderField: 排序字段; 枚举值: CreateTime (创建时间) ｜ ExpireTime (到期时间)；默认CreateTime
        :type OrderField: str
        """
        self._ResourceGroupId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._OrderField = None

    @property
    def ResourceGroupId(self):
        """资源组id, 取值为创建资源组接口(CreateBillingResourceGroup)响应中的ResourceGroupId
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def Filters(self):
        """过滤条件
注意: 
1. Filter.Name 只支持以下枚举值:
    InstanceId (资源组节点id)
    InstanceStatus (资源组节点状态)
2. Filter.Values: 长度为1且Filter.Fuzzy=true时，支持模糊查询; 不为1时，精确查询
3. 每次请求的Filters的上限为10，Filter.Values的上限为100
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """分页查询起始位置，如：Limit为10，第一页Offset为0，第二页Offset为10....即每页左边为闭区间; 默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页查询每页大小，默认20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        """排序方向; 枚举值: ASC | DESC；默认DESC
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OrderField(self):
        """排序字段; 枚举值: CreateTime (创建时间) ｜ ExpireTime (到期时间)；默认CreateTime
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._OrderField = params.get("OrderField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingResourceGroupResponse(AbstractModel):
    """DescribeBillingResourceGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 资源组节点总数； 注意接口是分页拉取的，total是指资源组节点总数，不是本次返回中InstanceSet数组的大小
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _InstanceSet: 资源组节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceSet: list of Instance
        :param _ResourceGroupSWType: 资源组纳管类型
        :type ResourceGroupSWType: str
        :param _GpuPackageEnabled: 是否限制GPU按比例申请资源
        :type GpuPackageEnabled: bool
        :param _IsBareMetalResourceGroup: 是否为裸金属资源组
注意：此字段可能返回 null，表示取不到有效值。
        :type IsBareMetalResourceGroup: bool
        :param _VirtualGpuSet: GPU各卡型是否支持虚拟化
注意：此字段可能返回 null，表示取不到有效值。
        :type VirtualGpuSet: list of VirtualGpu
        :param _ResourceGroupId: 资源组id
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupId: str
        :param _ResourceGroupName: 资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupName: str
        :param _FreeInstance: 可用节点个数(运行中的节点）
注意：此字段可能返回 null，表示取不到有效值。
        :type FreeInstance: int
        :param _UsedResource: 资源组已用的资源
注意：此字段可能返回 null，表示取不到有效值。
        :type UsedResource: :class:`tencentcloud.tione.v20211111.models.GroupResource`
        :param _TotalResource: 资源组总资源
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalResource: :class:`tencentcloud.tione.v20211111.models.GroupResource`
        :param _TagSet: 标签列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TagSet: list of Tag
        :param _IsRdma: 是否为rdma资源组
注意：此字段可能返回 null，表示取不到有效值。
        :type IsRdma: bool
        :param _ScheduleStrategy: 资源组调度策略
注意：此字段可能返回 null，表示取不到有效值。
        :type ScheduleStrategy: str
        :param _GpuTypeResource: 按GPU卡型号聚合的GPU用量等信息
注意：此字段可能返回 null，表示取不到有效值。
        :type GpuTypeResource: list of GpuTypeResource
        :param _AvailableResource: 资源组可用资源
注意：此字段可能返回 null，表示取不到有效值。
        :type AvailableResource: :class:`tencentcloud.tione.v20211111.models.GroupResource`
        :param _AppId: AppId
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: int
        :param _EnableModels: 更多配置开启可用模块
注意：此字段可能返回 null，表示取不到有效值。
        :type EnableModels: list of str
        :param _SpecTemps: 规格模版
注意：此字段可能返回 null，表示取不到有效值。
        :type SpecTemps: list of SpecTemp
        :param _PresetResourceSwitch: 预设资源开关，枚举值：CLOSE,GPU,TEMPLATE
注意：此字段可能返回 null，表示取不到有效值。
        :type PresetResourceSwitch: str
        :param _IsCanModifyPreset: 是否可修改预设资源
注意：此字段可能返回 null，表示取不到有效值。
        :type IsCanModifyPreset: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceSet = None
        self._ResourceGroupSWType = None
        self._GpuPackageEnabled = None
        self._IsBareMetalResourceGroup = None
        self._VirtualGpuSet = None
        self._ResourceGroupId = None
        self._ResourceGroupName = None
        self._FreeInstance = None
        self._UsedResource = None
        self._TotalResource = None
        self._TagSet = None
        self._IsRdma = None
        self._ScheduleStrategy = None
        self._GpuTypeResource = None
        self._AvailableResource = None
        self._AppId = None
        self._EnableModels = None
        self._SpecTemps = None
        self._PresetResourceSwitch = None
        self._IsCanModifyPreset = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """资源组节点总数； 注意接口是分页拉取的，total是指资源组节点总数，不是本次返回中InstanceSet数组的大小
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceSet(self):
        """资源组节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Instance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def ResourceGroupSWType(self):
        """资源组纳管类型
        :rtype: str
        """
        return self._ResourceGroupSWType

    @ResourceGroupSWType.setter
    def ResourceGroupSWType(self, ResourceGroupSWType):
        self._ResourceGroupSWType = ResourceGroupSWType

    @property
    def GpuPackageEnabled(self):
        """是否限制GPU按比例申请资源
        :rtype: bool
        """
        return self._GpuPackageEnabled

    @GpuPackageEnabled.setter
    def GpuPackageEnabled(self, GpuPackageEnabled):
        self._GpuPackageEnabled = GpuPackageEnabled

    @property
    def IsBareMetalResourceGroup(self):
        """是否为裸金属资源组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsBareMetalResourceGroup

    @IsBareMetalResourceGroup.setter
    def IsBareMetalResourceGroup(self, IsBareMetalResourceGroup):
        self._IsBareMetalResourceGroup = IsBareMetalResourceGroup

    @property
    def VirtualGpuSet(self):
        """GPU各卡型是否支持虚拟化
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of VirtualGpu
        """
        return self._VirtualGpuSet

    @VirtualGpuSet.setter
    def VirtualGpuSet(self, VirtualGpuSet):
        self._VirtualGpuSet = VirtualGpuSet

    @property
    def ResourceGroupId(self):
        """资源组id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceGroupName(self):
        """资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def FreeInstance(self):
        """可用节点个数(运行中的节点）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FreeInstance

    @FreeInstance.setter
    def FreeInstance(self, FreeInstance):
        self._FreeInstance = FreeInstance

    @property
    def UsedResource(self):
        """资源组已用的资源
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.GroupResource`
        """
        return self._UsedResource

    @UsedResource.setter
    def UsedResource(self, UsedResource):
        self._UsedResource = UsedResource

    @property
    def TotalResource(self):
        """资源组总资源
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.GroupResource`
        """
        return self._TotalResource

    @TotalResource.setter
    def TotalResource(self, TotalResource):
        self._TotalResource = TotalResource

    @property
    def TagSet(self):
        """标签列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def IsRdma(self):
        """是否为rdma资源组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsRdma

    @IsRdma.setter
    def IsRdma(self, IsRdma):
        self._IsRdma = IsRdma

    @property
    def ScheduleStrategy(self):
        """资源组调度策略
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ScheduleStrategy

    @ScheduleStrategy.setter
    def ScheduleStrategy(self, ScheduleStrategy):
        self._ScheduleStrategy = ScheduleStrategy

    @property
    def GpuTypeResource(self):
        """按GPU卡型号聚合的GPU用量等信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of GpuTypeResource
        """
        return self._GpuTypeResource

    @GpuTypeResource.setter
    def GpuTypeResource(self, GpuTypeResource):
        self._GpuTypeResource = GpuTypeResource

    @property
    def AvailableResource(self):
        """资源组可用资源
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.GroupResource`
        """
        return self._AvailableResource

    @AvailableResource.setter
    def AvailableResource(self, AvailableResource):
        self._AvailableResource = AvailableResource

    @property
    def AppId(self):
        """AppId
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def EnableModels(self):
        """更多配置开启可用模块
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._EnableModels

    @EnableModels.setter
    def EnableModels(self, EnableModels):
        self._EnableModels = EnableModels

    @property
    def SpecTemps(self):
        """规格模版
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SpecTemp
        """
        return self._SpecTemps

    @SpecTemps.setter
    def SpecTemps(self, SpecTemps):
        self._SpecTemps = SpecTemps

    @property
    def PresetResourceSwitch(self):
        """预设资源开关，枚举值：CLOSE,GPU,TEMPLATE
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PresetResourceSwitch

    @PresetResourceSwitch.setter
    def PresetResourceSwitch(self, PresetResourceSwitch):
        self._PresetResourceSwitch = PresetResourceSwitch

    @property
    def IsCanModifyPreset(self):
        """是否可修改预设资源
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsCanModifyPreset

    @IsCanModifyPreset.setter
    def IsCanModifyPreset(self, IsCanModifyPreset):
        self._IsCanModifyPreset = IsCanModifyPreset

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = Instance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._ResourceGroupSWType = params.get("ResourceGroupSWType")
        self._GpuPackageEnabled = params.get("GpuPackageEnabled")
        self._IsBareMetalResourceGroup = params.get("IsBareMetalResourceGroup")
        if params.get("VirtualGpuSet") is not None:
            self._VirtualGpuSet = []
            for item in params.get("VirtualGpuSet"):
                obj = VirtualGpu()
                obj._deserialize(item)
                self._VirtualGpuSet.append(obj)
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ResourceGroupName = params.get("ResourceGroupName")
        self._FreeInstance = params.get("FreeInstance")
        if params.get("UsedResource") is not None:
            self._UsedResource = GroupResource()
            self._UsedResource._deserialize(params.get("UsedResource"))
        if params.get("TotalResource") is not None:
            self._TotalResource = GroupResource()
            self._TotalResource._deserialize(params.get("TotalResource"))
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._IsRdma = params.get("IsRdma")
        self._ScheduleStrategy = params.get("ScheduleStrategy")
        if params.get("GpuTypeResource") is not None:
            self._GpuTypeResource = []
            for item in params.get("GpuTypeResource"):
                obj = GpuTypeResource()
                obj._deserialize(item)
                self._GpuTypeResource.append(obj)
        if params.get("AvailableResource") is not None:
            self._AvailableResource = GroupResource()
            self._AvailableResource._deserialize(params.get("AvailableResource"))
        self._AppId = params.get("AppId")
        self._EnableModels = params.get("EnableModels")
        if params.get("SpecTemps") is not None:
            self._SpecTemps = []
            for item in params.get("SpecTemps"):
                obj = SpecTemp()
                obj._deserialize(item)
                self._SpecTemps.append(obj)
        self._PresetResourceSwitch = params.get("PresetResourceSwitch")
        self._IsCanModifyPreset = params.get("IsCanModifyPreset")
        self._RequestId = params.get("RequestId")


class DescribeBillingResourceGroupRunningJobsRequest(AbstractModel):
    """DescribeBillingResourceGroupRunningJobs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        :param _Filters: 过滤条件。ResourceInstanceId: 资源组节点ID，TaskType: 任务类型，TaskId: 任务 ID，TaskName: 任务名称，JobStatus: 任务状态
        :type Filters: list of Filter
        """
        self._ResourceGroupId = None
        self._Filters = None

    @property
    def ResourceGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def Filters(self):
        """过滤条件。ResourceInstanceId: 资源组节点ID，TaskType: 任务类型，TaskId: 任务 ID，TaskName: 任务名称，JobStatus: 任务状态
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingResourceGroupRunningJobsResponse(AbstractModel):
    """DescribeBillingResourceGroupRunningJobs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupRunningJobInfos: 资源组运行中的任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupRunningJobInfos: list of ResourceGroupRunningJobInfo
        :param _ResourceGroupJobInfos: 资源组中调度的任务信息
        :type ResourceGroupJobInfos: list of ResourceGroupJobInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResourceGroupRunningJobInfos = None
        self._ResourceGroupJobInfos = None
        self._RequestId = None

    @property
    def ResourceGroupRunningJobInfos(self):
        """资源组运行中的任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ResourceGroupRunningJobInfo
        """
        return self._ResourceGroupRunningJobInfos

    @ResourceGroupRunningJobInfos.setter
    def ResourceGroupRunningJobInfos(self, ResourceGroupRunningJobInfos):
        self._ResourceGroupRunningJobInfos = ResourceGroupRunningJobInfos

    @property
    def ResourceGroupJobInfos(self):
        """资源组中调度的任务信息
        :rtype: list of ResourceGroupJobInfo
        """
        return self._ResourceGroupJobInfos

    @ResourceGroupJobInfos.setter
    def ResourceGroupJobInfos(self, ResourceGroupJobInfos):
        self._ResourceGroupJobInfos = ResourceGroupJobInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ResourceGroupRunningJobInfos") is not None:
            self._ResourceGroupRunningJobInfos = []
            for item in params.get("ResourceGroupRunningJobInfos"):
                obj = ResourceGroupRunningJobInfo()
                obj._deserialize(item)
                self._ResourceGroupRunningJobInfos.append(obj)
        if params.get("ResourceGroupJobInfos") is not None:
            self._ResourceGroupJobInfos = []
            for item in params.get("ResourceGroupJobInfos"):
                obj = ResourceGroupJobInfo()
                obj._deserialize(item)
                self._ResourceGroupJobInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingResourceGroupsRequest(AbstractModel):
    """DescribeBillingResourceGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 资源组类型;
枚举值:
空: 通用, TRAIN: 训练, INFERENCE: 推理
        :type Type: str
        :param _Filters: Filter.Name: 枚举值: ResourceGroupId (资源组id列表)                    ResourceGroupName (资源组名称列表)                    AvailableNodeCount（资源组中可用节点数量）Filter.Values: 长度为1且Filter.Fuzzy=true时，支持模糊查询; 不为1时，精确查询每次请求的Filters的上限为5，Filter.Values的上限为100
        :type Filters: list of Filter
        :param _TagFilters: 标签过滤
        :type TagFilters: list of TagFilter
        :param _Offset: 偏移量，默认为0；分页查询起始位置，如：Limit为100，第一页Offset为0，第二页OffSet为100....即每页左边为闭区间
        :type Offset: int
        :param _Limit: 分页查询每页大小，默认20
        :type Limit: int
        :param _SearchWord: 支持模糊查找资源组id和资源组名
        :type SearchWord: str
        :param _DontShowInstanceSet: 是否不展示节点列表; 
true: 不展示，false 展示；
默认为false
        :type DontShowInstanceSet: bool
        :param _OrderField: 排序字段
        :type OrderField: str
        """
        self._Type = None
        self._Filters = None
        self._TagFilters = None
        self._Offset = None
        self._Limit = None
        self._SearchWord = None
        self._DontShowInstanceSet = None
        self._OrderField = None

    @property
    def Type(self):
        """资源组类型;
枚举值:
空: 通用, TRAIN: 训练, INFERENCE: 推理
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Filters(self):
        """Filter.Name: 枚举值: ResourceGroupId (资源组id列表)                    ResourceGroupName (资源组名称列表)                    AvailableNodeCount（资源组中可用节点数量）Filter.Values: 长度为1且Filter.Fuzzy=true时，支持模糊查询; 不为1时，精确查询每次请求的Filters的上限为5，Filter.Values的上限为100
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        """标签过滤
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def Offset(self):
        """偏移量，默认为0；分页查询起始位置，如：Limit为100，第一页Offset为0，第二页OffSet为100....即每页左边为闭区间
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页查询每页大小，默认20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        """支持模糊查找资源组id和资源组名
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def DontShowInstanceSet(self):
        """是否不展示节点列表; 
true: 不展示，false 展示；
默认为false
        :rtype: bool
        """
        return self._DontShowInstanceSet

    @DontShowInstanceSet.setter
    def DontShowInstanceSet(self, DontShowInstanceSet):
        self._DontShowInstanceSet = DontShowInstanceSet

    @property
    def OrderField(self):
        """排序字段
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        self._DontShowInstanceSet = params.get("DontShowInstanceSet")
        self._OrderField = params.get("OrderField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingResourceGroupsResponse(AbstractModel):
    """DescribeBillingResourceGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 资源组总数； 注意接口是分页拉取的，total是指资源组总数，不是本次返回中ResourceGroupSet数组的大小
        :type TotalCount: int
        :param _ResourceGroupSet: 资源组详情
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupSet: list of ResourceGroup
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ResourceGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """资源组总数； 注意接口是分页拉取的，total是指资源组总数，不是本次返回中ResourceGroupSet数组的大小
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ResourceGroupSet(self):
        """资源组详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ResourceGroup
        """
        return self._ResourceGroupSet

    @ResourceGroupSet.setter
    def ResourceGroupSet(self, ResourceGroupSet):
        self._ResourceGroupSet = ResourceGroupSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ResourceGroupSet") is not None:
            self._ResourceGroupSet = []
            for item in params.get("ResourceGroupSet"):
                obj = ResourceGroup()
                obj._deserialize(item)
                self._ResourceGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingResourceInstanceGroupByGpuTypeRequest(AbstractModel):
    """DescribeBillingResourceInstanceGroupByGpuType请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组ID
        :type ResourceGroupId: str
        """
        self._ResourceGroupId = None

    @property
    def ResourceGroupId(self):
        """资源组ID
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingResourceInstanceGroupByGpuTypeResponse(AbstractModel):
    """DescribeBillingResourceInstanceGroupByGpuType返回参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupedInstanceSet: 按GPU型号聚合的节点列表
注意：此字段可能返回 null，表示取不到有效值。
        :type GroupedInstanceSet: list of InstanceGroup
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._GroupedInstanceSet = None
        self._RequestId = None

    @property
    def GroupedInstanceSet(self):
        """按GPU型号聚合的节点列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of InstanceGroup
        """
        return self._GroupedInstanceSet

    @GroupedInstanceSet.setter
    def GroupedInstanceSet(self, GroupedInstanceSet):
        self._GroupedInstanceSet = GroupedInstanceSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GroupedInstanceSet") is not None:
            self._GroupedInstanceSet = []
            for item in params.get("GroupedInstanceSet"):
                obj = InstanceGroup()
                obj._deserialize(item)
                self._GroupedInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingResourceInstanceRunningJobsBatchRequest(AbstractModel):
    """DescribeBillingResourceInstanceRunningJobsBatch请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        :param _ResourceInstanceIds: 资源组节点id列表
        :type ResourceInstanceIds: list of str
        """
        self._ResourceGroupId = None
        self._ResourceInstanceIds = None

    @property
    def ResourceGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceInstanceIds(self):
        """资源组节点id列表
        :rtype: list of str
        """
        return self._ResourceInstanceIds

    @ResourceInstanceIds.setter
    def ResourceInstanceIds(self, ResourceInstanceIds):
        self._ResourceInstanceIds = ResourceInstanceIds


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ResourceInstanceIds = params.get("ResourceInstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingResourceInstanceRunningJobsBatchResponse(AbstractModel):
    """DescribeBillingResourceInstanceRunningJobsBatch返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceInstanceIdWithRunningJobInfos: 节点运行中的任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceInstanceIdWithRunningJobInfos: list of ResourceInstanceIdWithRunningJobInfos
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResourceInstanceIdWithRunningJobInfos = None
        self._RequestId = None

    @property
    def ResourceInstanceIdWithRunningJobInfos(self):
        """节点运行中的任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ResourceInstanceIdWithRunningJobInfos
        """
        return self._ResourceInstanceIdWithRunningJobInfos

    @ResourceInstanceIdWithRunningJobInfos.setter
    def ResourceInstanceIdWithRunningJobInfos(self, ResourceInstanceIdWithRunningJobInfos):
        self._ResourceInstanceIdWithRunningJobInfos = ResourceInstanceIdWithRunningJobInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ResourceInstanceIdWithRunningJobInfos") is not None:
            self._ResourceInstanceIdWithRunningJobInfos = []
            for item in params.get("ResourceInstanceIdWithRunningJobInfos"):
                obj = ResourceInstanceIdWithRunningJobInfos()
                obj._deserialize(item)
                self._ResourceInstanceIdWithRunningJobInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingResourceInstanceRunningJobsRequest(AbstractModel):
    """DescribeBillingResourceInstanceRunningJobs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        :param _ResourceInstanceId: 资源组节点id
        :type ResourceInstanceId: str
        """
        self._ResourceGroupId = None
        self._ResourceInstanceId = None

    @property
    def ResourceGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ResourceInstanceId(self):
        """资源组节点id
        :rtype: str
        """
        return self._ResourceInstanceId

    @ResourceInstanceId.setter
    def ResourceInstanceId(self, ResourceInstanceId):
        self._ResourceInstanceId = ResourceInstanceId


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ResourceInstanceId = params.get("ResourceInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingResourceInstanceRunningJobsResponse(AbstractModel):
    """DescribeBillingResourceInstanceRunningJobs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceInstanceRunningJobInfos: 资源组节点运行中的任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceInstanceRunningJobInfos: list of ResourceInstanceRunningJobInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResourceInstanceRunningJobInfos = None
        self._RequestId = None

    @property
    def ResourceInstanceRunningJobInfos(self):
        """资源组节点运行中的任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ResourceInstanceRunningJobInfo
        """
        return self._ResourceInstanceRunningJobInfos

    @ResourceInstanceRunningJobInfos.setter
    def ResourceInstanceRunningJobInfos(self, ResourceInstanceRunningJobInfos):
        self._ResourceInstanceRunningJobInfos = ResourceInstanceRunningJobInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ResourceInstanceRunningJobInfos") is not None:
            self._ResourceInstanceRunningJobInfos = []
            for item in params.get("ResourceInstanceRunningJobInfos"):
                obj = ResourceInstanceRunningJobInfo()
                obj._deserialize(item)
                self._ResourceInstanceRunningJobInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingResourceInstanceStatusStatisticRequest(AbstractModel):
    """DescribeBillingResourceInstanceStatusStatistic请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组id
        :type ResourceGroupId: str
        """
        self._ResourceGroupId = None

    @property
    def ResourceGroupId(self):
        """资源组id
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingResourceInstanceStatusStatisticResponse(AbstractModel):
    """DescribeBillingResourceInstanceStatusStatistic返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupName: 资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ResourceGroupName: str
        :param _InstanceStatusSet: 资源组节点状态信息统计
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceStatusSet: list of InstanceStatusStatistic
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResourceGroupName = None
        self._InstanceStatusSet = None
        self._RequestId = None

    @property
    def ResourceGroupName(self):
        """资源组名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName

    @property
    def InstanceStatusSet(self):
        """资源组节点状态信息统计
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of InstanceStatusStatistic
        """
        return self._InstanceStatusSet

    @InstanceStatusSet.setter
    def InstanceStatusSet(self, InstanceStatusSet):
        self._InstanceStatusSet = InstanceStatusSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ResourceGroupName = params.get("ResourceGroupName")
        if params.get("InstanceStatusSet") is not None:
            self._InstanceStatusSet = []
            for item in params.get("InstanceStatusSet"):
                obj = InstanceStatusStatistic()
                obj._deserialize(item)
                self._InstanceStatusSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingResourceInstancesRequest(AbstractModel):
    """DescribeBillingResourceInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceGroupId: 资源组id, 取值为创建资源组接口(CreateBillingResourceGroup)响应中的ResourceGroupId
        :type ResourceGroupId: str
        :param _Filters: 过滤条件
注意: 
1. Filter.Name 只支持以下枚举值:
    InstanceId (资源组节点id)
    InstanceStatus (资源组节点状态)
2. Filter.Values: 长度为1且Filter.Fuzzy=true时，支持模糊查询; 不为1时，精确查询
3. 每次请求的Filters的上限为10，Filter.Values的上限为100
        :type Filters: list of Filter
        :param _Offset: 分页查询起始位置，如：Limit为10，第一页Offset为0，第二页Offset为10....即每页左边为闭区间; 默认0
        :type Offset: int
        :param _Limit: 分页查询每页大小，默认20
        :type Limit: int
        :param _Order: 排序方向; 枚举值: ASC | DESC；默认DESC
        :type Order: str
        :param _OrderField: 排序字段; 枚举值: CreateTime (创建时间) ｜ ExpireTime (到期时间)；默认CreateTime
        :type OrderField: str
        """
        self._ResourceGroupId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._OrderField = None

    @property
    def ResourceGroupId(self):
        """资源组id, 取值为创建资源组接口(CreateBillingResourceGroup)响应中的ResourceGroupId
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def Filters(self):
        """过滤条件
注意: 
1. Filter.Name 只支持以下枚举值:
    InstanceId (资源组节点id)
    InstanceStatus (资源组节点状态)
2. Filter.Values: 长度为1且Filter.Fuzzy=true时，支持模糊查询; 不为1时，精确查询
3. 每次请求的Filters的上限为10，Filter.Values的上限为100
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """分页查询起始位置，如：Limit为10，第一页Offset为0，第二页Offset为10....即每页左边为闭区间; 默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页查询每页大小，默认20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        """排序方向; 枚举值: ASC | DESC；默认DESC
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OrderField(self):
        """排序字段; 枚举值: CreateTime (创建时间) ｜ ExpireTime (到期时间)；默认CreateTime
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField


    def _deserialize(self, params):
        self._ResourceGroupId = params.get("ResourceGroupId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._OrderField = params.get("OrderField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingResourceInstancesResponse(AbstractModel):
    """DescribeBillingResourceInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 资源组节点总数； 注意接口是分页拉取的，total是指资源组节点总数，不是本次返回中InstanceSet数组的大小
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _InstanceSet: 资源组节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceSet: list of Instance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """资源组节点总数； 注意接口是分页拉取的，total是指资源组节点总数，不是本次返回中InstanceSet数组的大小
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceSet(self):
        """资源组节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Instance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = Instance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingSpecsPriceRequest(AbstractModel):
    """DescribeBillingSpecsPrice请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SpecsParam: 询价参数，支持批量询价
        :type SpecsParam: list of SpecUnit
        """
        self._SpecsParam = None

    @property
    def SpecsParam(self):
        """询价参数，支持批量询价
        :rtype: list of SpecUnit
        """
        return self._SpecsParam

    @SpecsParam.setter
    def SpecsParam(self, SpecsParam):
        self._SpecsParam = SpecsParam


    def _deserialize(self, params):
        if params.get("SpecsParam") is not None:
            self._SpecsParam = []
            for item in params.get("SpecsParam"):
                obj = SpecUnit()
                obj._deserialize(item)
                self._SpecsParam.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingSpecsPriceResponse(AbstractModel):
    """DescribeBillingSpecsPrice返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SpecsPrice: 计费项价格，支持批量返回
        :type SpecsPrice: list of SpecPrice
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SpecsPrice = None
        self._RequestId = None

    @property
    def SpecsPrice(self):
        """计费项价格，支持批量返回
        :rtype: list of SpecPrice
        """
        return self._SpecsPrice

    @SpecsPrice.setter
    def SpecsPrice(self, SpecsPrice):
        self._SpecsPrice = SpecsPrice

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SpecsPrice") is not None:
            self._SpecsPrice = []
            for item in params.get("SpecsPrice"):
                obj = SpecPrice()
                obj._deserialize(item)
                self._SpecsPrice.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingSpecsRequest(AbstractModel):
    """DescribeBillingSpecs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ChargeType: 付费模式：POSTPAID_BY_HOUR按量计费、PREPAID包年包月
        :type ChargeType: str
        :param _TaskType: 枚举值：空、TRAIN、NOTEBOOK、INFERENCE或EMS
        :type TaskType: str
        :param _ResourceType: 资源类型：["", "CALC", "CPU", "GPU", "GPU-SW"]
        :type ResourceType: str
        :param _IsBareMetalResourceGroup: 是否为裸金属资源组
        :type IsBareMetalResourceGroup: bool
        :param _IsRdma: 是否为rdma资源组
        :type IsRdma: bool
        :param _IsSW: 是否为软件费计费项
        :type IsSW: bool
        :param _ResourceGroupId: 资源组ID
        :type ResourceGroupId: str
        """
        self._ChargeType = None
        self._TaskType = None
        self._ResourceType = None
        self._IsBareMetalResourceGroup = None
        self._IsRdma = None
        self._IsSW = None
        self._ResourceGroupId = None

    @property
    def ChargeType(self):
        """付费模式：POSTPAID_BY_HOUR按量计费、PREPAID包年包月
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def TaskType(self):
        """枚举值：空、TRAIN、NOTEBOOK、INFERENCE或EMS
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ResourceType(self):
        """资源类型：["", "CALC", "CPU", "GPU", "GPU-SW"]
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def IsBareMetalResourceGroup(self):
        """是否为裸金属资源组
        :rtype: bool
        """
        return self._IsBareMetalResourceGroup

    @IsBareMetalResourceGroup.setter
    def IsBareMetalResourceGroup(self, IsBareMetalResourceGroup):
        self._IsBareMetalResourceGroup = IsBareMetalResourceGroup

    @property
    def IsRdma(self):
        """是否为rdma资源组
        :rtype: bool
        """
        return self._IsRdma

    @IsRdma.setter
    def IsRdma(self, IsRdma):
        self._IsRdma = IsRdma

    @property
    def IsSW(self):
        """是否为软件费计费项
        :rtype: bool
        """
        return self._IsSW

    @IsSW.setter
    def IsSW(self, IsSW):
        self._IsSW = IsSW

    @property
    def ResourceGroupId(self):
        """资源组ID
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId


    def _deserialize(self, params):
        self._ChargeType = params.get("ChargeType")
        self._TaskType = params.get("TaskType")
        self._ResourceType = params.get("ResourceType")
        self._IsBareMetalResourceGroup = params.get("IsBareMetalResourceGroup")
        self._IsRdma = params.get("IsRdma")
        self._IsSW = params.get("IsSW")
        self._ResourceGroupId = params.get("ResourceGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingSpecsResponse(AbstractModel):
    """DescribeBillingSpecs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Specs: 计费项列表
        :type Specs: list of Spec
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Specs = None
        self._RequestId = None

    @property
    def Specs(self):
        """计费项列表
        :rtype: list of Spec
        """
        return self._Specs

    @Specs.setter
    def Specs(self, Specs):
        self._Specs = Specs

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Specs") is not None:
            self._Specs = []
            for item in params.get("Specs"):
                obj = Spec()
                obj._deserialize(item)
                self._Specs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillingUserListRequest(AbstractModel):
    """DescribeBillingUserList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserType: 用户属性，比如WHITELIST、MIYING等。如果传空则不返回
        :type UserType: str
        """
        self._UserType = None

    @property
    def UserType(self):
        """用户属性，比如WHITELIST、MIYING等。如果传空则不返回
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType


    def _deserialize(self, params):
        self._UserType = params.get("UserType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillingUserListResponse(AbstractModel):
    """DescribeBillingUserList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserType: 对应的用户属性
        :type UserType: str
        :param _UserList: 用户主uin数组
        :type UserList: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserType = None
        self._UserList = None
        self._RequestId = None

    @property
    def UserType(self):
        """对应的用户属性
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserList(self):
        """用户主uin数组
        :rtype: list of str
        """
        return self._UserList

    @UserList.setter
    def UserList(self, UserList):
        self._UserList = UserList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UserType = params.get("UserType")
        self._UserList = params.get("UserList")
        self._RequestId = params.get("RequestId")


class DescribeBuildInImagesRequest(AbstractModel):
    """DescribeBuildInImages请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageFilters: 镜像过滤器
        :type ImageFilters: list of ImageFIlter
        """
        self._ImageFilters = None

    @property
    def ImageFilters(self):
        """镜像过滤器
        :rtype: list of ImageFIlter
        """
        return self._ImageFilters

    @ImageFilters.setter
    def ImageFilters(self, ImageFilters):
        self._ImageFilters = ImageFilters


    def _deserialize(self, params):
        if params.get("ImageFilters") is not None:
            self._ImageFilters = []
            for item in params.get("ImageFilters"):
                obj = ImageFIlter()
                obj._deserialize(item)
                self._ImageFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBuildInImagesResponse(AbstractModel):
    """DescribeBuildInImages返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BuildInImageInfos: 内置镜像详情列表
        :type BuildInImageInfos: list of ImageInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BuildInImageInfos = None
        self._RequestId = None

    @property
    def BuildInImageInfos(self):
        """内置镜像详情列表
        :rtype: list of ImageInfo
        """
        return self._BuildInImageInfos

    @BuildInImageInfos.setter
    def BuildInImageInfos(self, BuildInImageInfos):
        self._BuildInImageInfos = BuildInImageInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BuildInImageInfos") is not None:
            self._BuildInImageInfos = []
            for item in params.get("BuildInImageInfos"):
                obj = ImageInfo()
                obj._deserialize(item)
                self._BuildInImageInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCVMSemiPrecheckRequest(AbstractModel):
    """DescribeCVMSemiPrecheck请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CVMInstanceIds: 需要检查的CVM节点ID
        :type CVMInstanceIds: list of str
        :param _ResourceGroupId: 资源组ID
        :type ResourceGroupId: str
        :param _ChargeType: 计费类型，当前无用
        :type ChargeType: str
        """
        self._CVMInstanceIds = None
        self._ResourceGroupId = None
        self._ChargeType = None

    @property
    def CVMInstanceIds(self):
        """需要检查的CVM节点ID
        :rtype: list of str
        """
        return self._CVMInstanceIds

    @CVMInstanceIds.setter
    def CVMInstanceIds(self, CVMInstanceIds):
        self._CVMInstanceIds = CVMInstanceIds

    @property
    def ResourceGroupId(self):
        """资源组ID
        :rtype: str
        """
        return self._ResourceGroupId

    @ResourceGroupId.setter
    def ResourceGroupId(self, ResourceGroupId):
        self._ResourceGroupId = ResourceGroupId

    @property
    def ChargeType(self):
        """计费类型，当前无用
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType


    def _deserialize(self, params):
        self._CVMInstanceIds = params.get("CVMInstanceIds")
        self._ResourceGroupId = params.get("ResourceGroupId")
        self._ChargeType = params.get("ChargeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCVMSemiPrecheckResponse(AbstractModel):
    """DescribeCVMSemiPrecheck返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 预检结果
        :type Result: list of PrecheckResult
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """预检结果
        :rtype: list of PrecheckResult
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = PrecheckResult()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeChatServiceStatusRequest(AbstractModel):
    """DescribeChatServiceStatus请求参数结构体

    """


class DescribeChatServiceStatusResponse(AbstractModel):
    """DescribeChatServiceStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 是否可用
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        """是否可用
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribeCheckpointListRequest(AbstractModel):
    """DescribeCheckpointList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 训练任务ID
        :type TaskId: str
        :param _RequireLightEvalServiceInfo: 是否需要查询轻量体验服务信息
        :type RequireLightEvalServiceInfo: bool
        :param _RequireObjectiveEvalTaskInfo: 是否需要查询客观评测任务信息
        :type RequireObjectiveEvalTaskInfo: bool
        """
        self._TaskId = None
        self._RequireLightEvalServiceInfo = None
        self._RequireObjectiveEvalTaskInfo = None

    @property
    def TaskId(self):
        """训练任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequireLightEvalServiceInfo(self):
        """是否需要查询轻量体验服务信息
        :rtype: bool
        """
        return self._RequireLightEvalServiceInfo

    @RequireLightEvalServiceInfo.setter
    def RequireLightEvalServiceInfo(self, RequireLightEvalServiceInfo):
        self._RequireLightEvalServiceInfo = RequireLightEvalServiceInfo

    @property
    def RequireObjectiveEvalTaskInfo(self):
        """是否需要查询客观评测任务信息
        :rtype: bool
        """
        return self._RequireObjectiveEvalTaskInfo

    @RequireObjectiveEvalTaskInfo.setter
    def RequireObjectiveEvalTaskInfo(self, RequireObjectiveEvalTaskInfo):
        self._RequireObjectiveEvalTaskInfo = RequireObjectiveEvalTaskInfo


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequireLightEvalServiceInfo = params.get("RequireLightEvalServiceInfo")
        self._RequireObjectiveEvalTaskInfo = params.get("RequireObjectiveEvalTaskInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCheckpointListResponse(AbstractModel):
    """DescribeCheckpointList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _GetCheckpointListPluginVersion: 获得该 Checkpoint 列表的插件版本
注意：此字段可能返回 null，表示取不到有效值。
        :type GetCheckpointListPluginVersion: str
        :param _CheckpointInfos: 任务对应的 Checkpoint 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type CheckpointInfos: list of CheckpointInfo
        :param _LightEvalServiceInfos: 任务对应的轻量体验服务列表，目前只会有一个
注意：此字段可能返回 null，表示取不到有效值。
        :type LightEvalServiceInfos: list of LightEvalServiceInfo
        :param _ObjectiveEvalTaskInfos: 任务对应的客观评测任务列表，目前只会有一个
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjectiveEvalTaskInfos: list of ObjectiveEvalTaskInfo
        :param _ExecuteError: 任务对应的Checkpoint代码的执行错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ExecuteError: :class:`tencentcloud.tione.v20211111.models.ExecuteError`
        :param _LastLightEvalServiceResourceInfo: 用于前端回填的资源信息
注意：此字段可能返回 null，表示取不到有效值。
        :type LastLightEvalServiceResourceInfo: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._GetCheckpointListPluginVersion = None
        self._CheckpointInfos = None
        self._LightEvalServiceInfos = None
        self._ObjectiveEvalTaskInfos = None
        self._ExecuteError = None
        self._LastLightEvalServiceResourceInfo = None
        self._RequestId = None

    @property
    def GetCheckpointListPluginVersion(self):
        """获得该 Checkpoint 列表的插件版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._GetCheckpointListPluginVersion

    @GetCheckpointListPluginVersion.setter
    def GetCheckpointListPluginVersion(self, GetCheckpointListPluginVersion):
        self._GetCheckpointListPluginVersion = GetCheckpointListPluginVersion

    @property
    def CheckpointInfos(self):
        """任务对应的 Checkpoint 列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CheckpointInfo
        """
        return self._CheckpointInfos

    @CheckpointInfos.setter
    def CheckpointInfos(self, CheckpointInfos):
        self._CheckpointInfos = CheckpointInfos

    @property
    def LightEvalServiceInfos(self):
        """任务对应的轻量体验服务列表，目前只会有一个
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of LightEvalServiceInfo
        """
        return self._LightEvalServiceInfos

    @LightEvalServiceInfos.setter
    def LightEvalServiceInfos(self, LightEvalServiceInfos):
        self._LightEvalServiceInfos = LightEvalServiceInfos

    @property
    def ObjectiveEvalTaskInfos(self):
        """任务对应的客观评测任务列表，目前只会有一个
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of ObjectiveEvalTaskInfo
        """
        return self._ObjectiveEvalTaskInfos

    @ObjectiveEvalTaskInfos.setter
    def ObjectiveEvalTaskInfos(self, ObjectiveEvalTaskInfos):
        self._ObjectiveEvalTaskInfos = ObjectiveEvalTaskInfos

    @property
    def ExecuteError(self):
        """任务对应的Checkpoint代码的执行错误信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ExecuteError`
        """
        return self._ExecuteError

    @ExecuteError.setter
    def ExecuteError(self, ExecuteError):
        self._ExecuteError = ExecuteError

    @property
    def LastLightEvalServiceResourceInfo(self):
        """用于前端回填的资源信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tione.v20211111.models.ResourceConfigInfo`
        """
        return self._LastLightEvalServiceResourceInfo

    @LastLightEvalServiceResourceInfo.setter
    def LastLightEvalServiceResourceInfo(self, LastLightEvalServiceResourceInfo):
        self._LastLightEvalServiceResourceInfo = LastLightEvalServiceResourceInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._GetCheckpointListPluginVersion = params.get("GetCheckpointListPluginVersion")
        if params.get("CheckpointInfos") is not None:
            self._CheckpointInfos = []
            for item in params.get("CheckpointInfos"):
                obj = CheckpointInfo()
                obj._deserialize(item)
                self._CheckpointInfos.append(obj)
        if params.get("LightEvalServiceInfos") is not None:
            self._LightEvalServiceInfos = []
            for item in params.get("LightEvalServiceInfos"):
                obj = LightEvalServiceInfo()
                obj._deserialize(item)
                self._LightEvalServiceInfos.append(obj)
        if params.get("ObjectiveEvalTaskInfos") is not None:
            self._ObjectiveEvalTaskInfos = []
            for item in params.get("ObjectiveEvalTaskInfos"):
                obj = ObjectiveEvalTaskInfo()
                obj._deserialize(item)
                self._ObjectiveEvalTaskInfos.append(obj)
        if params.get("ExecuteError") is not None:
            self._ExecuteError = ExecuteError()
            self._ExecuteError._deserialize(params.get("ExecuteError"))
        if params.get("LastLightEvalServiceResourceInfo") is not None:
            self._LastLightEvalServiceResourceInfo = ResourceConfigInfo()
            self._LastLightEvalServiceResourceInfo._deserialize(params.get("LastLightEvalServiceResourceInfo"))
        self._RequestId = params.get("RequestId")


class DescribeCodeRepoRequest(AbstractModel):
    """DescribeCodeRepo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: id值
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        """id值
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCodeRepoResponse(AbstractModel):
    """DescribeCodeRepo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CodeRepoDetail: 详情信息
        :type CodeRepoDetail: :class:`tencentcloud.tione.v20211111.models.CodeRepoDetail`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CodeRepoDetail = None
        self._RequestId = None

    @property
    def CodeRepoDetail(self):
        """详情信息
        :rtype: :class:`tencentcloud.tione.v20211111.models.CodeRepoDetail`
        """
        return self._CodeRepoDetail

    @CodeRepoDetail.setter
    def CodeRepoDetail(self, CodeRepoDetail):
        self._CodeRepoDetail = CodeRepoDetail

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CodeRepoDetail") is not None:
            self._CodeRepoDetail = CodeRepoDetail()
            self._CodeRepoDetail._deserialize(params.get("CodeRepoDetail"))
        self._RequestId = params.get("RequestId")


class DescribeCodeReposRequest(AbstractModel):
    """DescribeCodeRepos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 每页返回的实例数，默认为10
        :type Limit: int
        :param _Order: 输出列表的排列顺序。取值范围：ASC：升序排列 DESC：降序排列。默认为DESC
        :type Order: str
        :param _OrderField: 根据哪个字段排序，如：CreateTime、UpdateTime，默认为UpdateTime
        :type OrderField: str
        :param _Filters: 过滤器，eg：[{ "Name": "Name", "Values": ["myCodeRepoName"] }]
        :type Filters: list of Filter
        :param _TagFilters: 标签过滤器，eg：[{ "TagKey": "TagKeyA", "TagValue": ["TagValueA"] }]	
        :type TagFilters: list of TagFilter
        """
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._OrderField = None
        self._Filters = None
        self._TagFilters = None

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页返回的实例数，默认为10
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        """输出列表的排列顺序。取值范围：ASC：升序排列 DESC：降序排列。默认为DESC
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OrderField(self):
        """根据哪个字段排序，如：CreateTime、UpdateTime，默认为UpdateTime
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Filters(self):
        """过滤器，eg：[{ "Name": "Name", "Values": ["myCodeRepoName"] }]
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        """标签过滤器，eg：[{ "TagKey": "TagKeyA", "TagValue": ["TagValueA"] }]	
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._OrderField = params.get("OrderField")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCodeReposResponse(AbstractModel):
    """DescribeCodeRepos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CodeRepoSet: 详情信息
注意：此字段可能返回 null，表示取不到有效值。
        :type CodeRepoSet: list of CodeRepoDetail
        :param _TotalCount: total count
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CodeRepoSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CodeRepoSet(self):
        """详情信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CodeRepoDetail
        """
        return self._CodeRepoSet

    @CodeRepoSet.setter
    def CodeRepoSet(self, CodeRepoSet):
        self._CodeRepoSet = CodeRepoSet

    @property
    def TotalCount(self):
        """total count
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CodeRepoSet") is not None:
            self._CodeRepoSet = []
            for item in params.get("CodeRepoSet"):
                obj = CodeRepoDetail()
                obj._deserialize(item)
                self._CodeRepoSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeComparisonResultsRequest(AbstractModel):
    """DescribeComparisonResults请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ObjectiveEvaluationIds: 指定用户选了哪些客观评测任务
        :type ObjectiveEvaluationIds: list of str
        :param _SubjectiveEvaluationIds: 指定用户选了哪些主观评测任务
        :type SubjectiveEvaluationIds: list of str
        :param _EvaluationSuites: 指定客观评测选了哪些开源数据集
        :type EvaluationSuites: list of str
        :param _SubjectiveDatasets: 指定主观评测选了哪些评测集
        :type SubjectiveDatasets: list of SimpleCFSConfig
        :param _ModelsForObjevals: 指定客观评测选了哪些模型
        :type ModelsForObjevals: list of WhichModel
        :param _ModelsForSubevals: 指定主观评测选了哪些模型
        :type ModelsForSubevals: list of WhichModel
        :param _Reset: 是否重置
        :type Reset: bool
        """
        self._ObjectiveEvaluationIds = None
        self._SubjectiveEvaluationIds = None
        self._EvaluationSuites = None
        self._SubjectiveDatasets = None
        self._ModelsForObjevals = None
        self._ModelsForSubevals = None
        self._Reset = None

    @property
    def ObjectiveEvaluationIds(self):
        """指定用户选了哪些客观评测任务
        :rtype: list of str
        """
        return self._ObjectiveEvaluationIds

    @ObjectiveEvaluationIds.setter
    def ObjectiveEvaluationIds(self, ObjectiveEvaluationIds):
        self._ObjectiveEvaluationIds = ObjectiveEvaluationIds

    @property
    def SubjectiveEvaluationIds(self):
        """指定用户选了哪些主观评测任务
        :rtype: list of str
        """
        return self._SubjectiveEvaluationIds

    @SubjectiveEvaluationIds.setter
    def SubjectiveEvaluationIds(self, SubjectiveEvaluationIds):
        self._SubjectiveEvaluationIds = SubjectiveEvaluationIds

    @property
    def EvaluationSuites(self):
        """指定客观评测选了哪些开源数据集
        :rtype: list of str
        """
        return self._EvaluationSuites

    @EvaluationSuites.setter
    def EvaluationSuites(self, EvaluationSuites):
        self._EvaluationSuites = EvaluationSuites

    @property
    def SubjectiveDatasets(self):
        """指定主观评测选了哪些评测集
        :rtype: list of SimpleCFSConfig
        """
        return self._SubjectiveDatasets

    @SubjectiveDatasets.setter
    def SubjectiveDatasets(self, SubjectiveDatasets):
        self._SubjectiveDatasets = SubjectiveDatasets

    @property
    def ModelsForObjevals(self):
        """指定客观评测选了哪些模型
        :rtype: list of WhichModel
        """
        return self._ModelsForObjevals

    @ModelsForObjevals.setter
    def ModelsForObjevals(self, ModelsForObjevals):
        self._ModelsForObjevals = ModelsForObjevals

    @property
    def ModelsForSubevals(self):
        """指定主观评测选了哪些模型
        :rtype: list of WhichModel
        """
        return self._ModelsForSubevals

    @ModelsForSubevals.setter
    def ModelsForSubevals(self, ModelsForSubevals):
        self._ModelsForSubevals = ModelsForSubevals

    @property
    def Reset(self):
        """是否重置
        :rtype: bool
        """
        return self._Reset

    @Reset.setter
    def Reset(self, Reset):
        self._Reset = Reset


    def _deserialize(self, params):
        self._ObjectiveEvaluationIds = params.get("ObjectiveEvaluationIds")
        self._SubjectiveEvaluationIds = params.get("SubjectiveEvaluationIds")
        self._EvaluationSuites = params.get("EvaluationSuites")
        if params.get("SubjectiveDatasets") is not None:
            self._SubjectiveDatasets = []
            for item in params.get("SubjectiveDatasets"):
                obj = SimpleCFSConfig()
                obj._deserialize(item)
                self._SubjectiveDatasets.append(obj)
        if params.get("ModelsForObjevals") is not None:
            self._ModelsForObjevals = []
            for item in params.get("ModelsForObjevals"):
                obj = WhichModel()
                obj._deserialize(item)
                self._ModelsForObjevals.append(obj)
        if params.get("ModelsForSubevals") is not None:
            self._ModelsForSubevals = []
            for item in params.get("ModelsForSubevals"):
                obj = WhichModel()
                obj._deserialize(item)
                self._ModelsForSubevals.append(obj)
        self._Reset = params.get("Reset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComparisonResultsResponse(AbstractModel):
    """DescribeComparisonResults返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ObjevalCompResults: 客观评测对比结果
        :type ObjevalCompResults: list of ObjevalCompResult
        :param _SubevalCompResults: 主观评测对比结果
        :type SubevalCompResults: list of SubevalCompResult
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ObjevalCompResults = None
        self._SubevalCompResults = None
        self._RequestId = None

    @property
    def ObjevalCompResults(self):
        """客观评测对比结果
        :rtype: list of ObjevalCompResult
        """
        return self._ObjevalCompResults

    @ObjevalCompResults.setter
    def ObjevalCompResults(self, ObjevalCompResults):
        self._ObjevalCompResults = ObjevalCompResults

    @property
    def SubevalCompResults(self):
        """主观评测对比结果
        :rtype: list of SubevalCompResult
        """
        return self._SubevalCompResults

    @SubevalCompResults.setter
    def SubevalCompResults(self, SubevalCompResults):
        self._SubevalCompResults = SubevalCompResults

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ObjevalCompResults") is not None:
            self._ObjevalCompResults = []
            for item in params.get("ObjevalCompResults"):
                obj = ObjevalCompResult()
                obj._deserialize(item)
                self._ObjevalCompResults.append(obj)
        if params.get("SubevalCompResults") is not None:
            self._SubevalCompResults = []
            for item in params.get("SubevalCompResults"):
                obj = SubevalCompResult()
                obj._deserialize(item)
                self._SubevalCompResults.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComparisonsOutputsRequest(AbstractModel):
    """DescribeComparisonsOutputs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ObjectiveEvaluationIds: 指定用户选了哪些客观评测任务
        :type ObjectiveEvaluationIds: list of str
        :param _SubjectiveEvaluationIds: 指定用户选了哪些主观评测任务
        :type SubjectiveEvaluationIds: list of str
        :param _EvaluationSuites: 指定客观评测选了哪些开源数据集
        :type EvaluationSuites: list of str
        :param _SubjectiveDatasets: 指定主观评测选了哪些评测集
        :type SubjectiveDatasets: list of SimpleCFSConfig
        :param _ModelsForObjevals: 指定客观评测选了哪些模型
        :type ModelsForObjevals: list of WhichModel
        :param _ModelsForSubevals: 指定主观评测选了哪些模型
        :type ModelsForSubevals: list of WhichModel
        """
        self._ObjectiveEvaluationIds = None
        self._SubjectiveEvaluationIds = None
        self._EvaluationSuites = None
        self._SubjectiveDatasets = None
        self._ModelsForObjevals = None
        self._ModelsForSubevals = None

    @property
    def ObjectiveEvaluationIds(self):
        """指定用户选了哪些客观评测任务
        :rtype: list of str
        """
        return self._ObjectiveEvaluationIds

    @ObjectiveEvaluationIds.setter
    def ObjectiveEvaluationIds(self, ObjectiveEvaluationIds):
        self._ObjectiveEvaluationIds = ObjectiveEvaluationIds

    @property
    def SubjectiveEvaluationIds(self):
        """指定用户选了哪些主观评测任务
        :rtype: list of str
        """
        return self._SubjectiveEvaluationIds

    @SubjectiveEvaluationIds.setter
    def SubjectiveEvaluationIds(self, SubjectiveEvaluationIds):
        self._SubjectiveEvaluationIds = SubjectiveEvaluationIds

    @property
    def EvaluationSuites(self):
        """指定客观评测选了哪些开源数据集
        :rtype: list of str
        """
        return self._EvaluationSuites

    @EvaluationSuites.setter
    def EvaluationSuites(self, EvaluationSuites):
        self._EvaluationSuites = EvaluationSuites

    @property
    def SubjectiveDatasets(self):
        """指定主观评测选了哪些评测集
        :rtype: list of SimpleCFSConfig
        """
        return self._SubjectiveDatasets

    @SubjectiveDatasets.setter
    def SubjectiveDatasets(self, SubjectiveDatasets):
        self._SubjectiveDatasets = SubjectiveDatasets

    @property
    def ModelsForObjevals(self):
        """指定客观评测选了哪些模型
        :rtype: list of WhichModel
        """
        return self._ModelsForObjevals

    @ModelsForObjevals.setter
    def ModelsForObjevals(self, ModelsForObjevals):
        self._ModelsForObjevals = ModelsForObjevals

    @property
    def ModelsForSubevals(self):
        """指定主观评测选了哪些模型
        :rtype: list of WhichModel
        """
        return self._ModelsForSubevals

    @ModelsForSubevals.setter
    def ModelsForSubevals(self, ModelsForSubevals):
        self._ModelsForSubevals = ModelsForSubevals


    def _deserialize(self, params):
        self._ObjectiveEvaluationIds = params.get("ObjectiveEvaluationIds")
        self._SubjectiveEvaluationIds = params.get("SubjectiveEvaluationIds")
        self._EvaluationSuites = params.get("EvaluationSuites")
        if params.get("SubjectiveDatasets") is not None:
            self._SubjectiveDatasets = []
            for item in params.get("SubjectiveDatasets"):
                obj = SimpleCFSConfig()
                obj._deserialize(item)
                self._SubjectiveDatasets.append(obj)
        if params.get("ModelsForObjevals") is not None:
            self._ModelsForObjevals = []
            for item in params.get("ModelsForObjevals"):
                obj = WhichModel()
                obj._deserialize(item)
                self._ModelsForObjevals.append(obj)
        if params.get("ModelsForSubevals") is not None:
            self._ModelsForSubevals = []
            for item in params.get("ModelsForSubevals"):
                obj = WhichModel()
                obj._deserialize(item)
                self._ModelsForSubevals.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComparisonsOutputsResponse(AbstractModel):
    """DescribeComparisonsOutputs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadURL: 下载链接
        :type DownloadURL: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadURL = None
        self._RequestId = None

    @property
    def DownloadURL(self):
        """下载链接
        :rtype: str
        """
        return self._DownloadURL

    @DownloadURL.setter
    def DownloadURL(self, DownloadURL):
        self._DownloadURL = DownloadURL

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadURL = params.get("DownloadURL")
        self._RequestId = params.get("RequestId")


class DescribeContentByMD5Request(AbstractModel):
    """DescribeContentByMD5请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasetId: 数据集ID
        :type DatasetId: str
        :param _MD5: 文件对象md5
        :type MD5: str
        """
        self._DatasetId = None
        self._MD5 = None

    @property
    def DatasetId(self):
        """数据集ID
        :rtype: str
        """
        return self._DatasetId

    @DatasetId.setter
    def DatasetId(self, DatasetId):
        self._DatasetId = DatasetId

    @property
    def MD5(self):
        """文件对象md5
        :rtype: str
        """
        return self._MD5

    @MD5.setter
    def MD5(self, MD5):
        self._MD5 = MD5


    def _deserialize(self, params):
        self._DatasetId = params.get("DatasetId")
        self._MD5 = params.get("MD5")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentByMD5Response(AbstractModel):
    """DescribeContentByMD5返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Content: 文本内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: list of str
        :param _ContentSummary: 文本内容摘要（前50个字符）
注意：此字段可能返回 null，表示取不到有效值。
        :type ContentSummary: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Content = None
        self._ContentSummary = None
        self._RequestId = None

    @property
    def Content(self):
        """文本内容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def ContentSummary(self):
        """文本内容摘要（前50个字符）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ContentSummary

    @ContentSummary.setter
    def ContentSummary(self, ContentSummary):
        self._ContentSummary = ContentSummary

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Content = params.get("Content")
        self._ContentSummary = params.get("ContentSummary")
        self._RequestId = params.get("RequestId")


class DescribeDataPipelineConfigRequest(AbstractModel):
    """DescribeDataPipelineConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigType: 需要获取的配置类型。可选项：
CONFIG_DATA_PIPELINE，获取pipeline配置
CONFIG_DATA_SCENE，获取通用算法任务配置
CONFIG_ALL，获取所有配置
默认为CONFIG_ALL
        :type ConfigType: str
        """
        self._ConfigType = None

    @property
    def ConfigType(self):
        """需要获取的配置类型。可选项：
CONFIG_DATA_PIPELINE，获取pipeline配置
CONFIG_DATA_SCENE，获取通用算法任务配置
CONFIG_ALL，获取所有配置
默认为CONFIG_ALL
        :rtype: str
        """
        return self._ConfigType

    @ConfigType.setter
    def ConfigType(self, ConfigType):
        self._ConfigType = ConfigType


    def _deserialize(self, params):
        self._ConfigType = params.get("ConfigType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataPipelineConfigResponse(AbstractModel):
    """DescribeDataPipelineConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataPipelineConfigs: 数据构建pipeline配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :type DataPipelineConfigs: list of DataPipelineConfig
        :param _DataSceneNodes: 数据构建通用算法任务配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSceneNodes: list of DataSceneNode
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataPipelineConfigs = None
        self._DataSceneNodes = None
        self._RequestId = None

    @property
    def DataPipelineConfigs(self):
        """数据构建pipeline配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataPipelineConfig
        """
        return self._DataPipelineConfigs

    @DataPipelineConfigs.setter
    def DataPipelineConfigs(self, DataPipelineConfigs):
        self._DataPipelineConfigs = DataPipelineConfigs

    @property
    def DataSceneNodes(self):
        """数据构建通用算法任务配置列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataSceneNode
        """
        return self._DataSceneNodes

    @DataSceneNodes.setter
    def DataSceneNodes(self, DataSceneNodes):
        self._DataSceneNodes = DataSceneNodes

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataPipelineConfigs") is not None:
            self._DataPipelineConfigs = []
            for item in params.get("DataPipelineConfigs"):
                obj = DataPipelineConfig()
                obj._deserialize(item)
                self._DataPipelineConfigs.append(obj)
        if params.get("DataSceneNodes") is not None:
            self._DataSceneNodes = []
            for item in params.get("DataSceneNodes"):
                obj = DataSceneNode()
                obj._deserialize(item)
                self._DataSceneNodes.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataPipelineTaskRequest(AbstractModel):
    """DescribeDataPipelineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 数据构建任务ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """数据构建任务ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataPipelineTaskResponse(AbstractModel):
    """DescribeDataPipelineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 数据构建任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 数据构建任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _Creator: 数据构建任务创建者ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Creator: str
        :param _CreateTime: 数据构建任务创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 数据构建任务更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _DataPipelines: 数据构建任务所选择的Pipeline
注意：此字段可能返回 null，表示取不到有效值。
        :type DataPipelines: list of DataPipelineConfig
        :param _DataScenes: 数据构建任务所选择的通用算法任务
注意：此字段可能返回 null，表示取不到有效值。
        :type DataScenes: list of DataSceneConfig
        :param _Description: 数据构建任务的描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _NotebookId: 数据构建任务对应的Notebook ID
注意：此字段可能返回 null，表示取不到有效值。
        :type NotebookId: str
        :param _NotebookName: 数据构建任务对应的Notebook名字
注意：此字段可能返回 null，表示取不到有效值。
        :type NotebookName: str
        :param _Tags: 数据构建任务标签
        :type Tags: list of Tag
        :param _CreatorNickname: 数据构建任务创建者名称
        :type CreatorNickname: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._TaskName = None
        self._Creator = None
        self._CreateTime = None
        self._UpdateTime = None
        self._DataPipelines = None
        self._DataScenes = None
        self._Description = None
        self._NotebookId = None
        self._NotebookName = None
        self._Tags = None
        self._CreatorNickname = None
        self._RequestId = None

    @property
    def TaskId(self):
        """数据构建任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        """数据构建任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def Creator(self):
        """数据构建任务创建者ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def CreateTime(self):
        """数据构建任务创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """数据构建任务更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def DataPipelines(self):
        """数据构建任务所选择的Pipeline
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataPipelineConfig
        """
        return self._DataPipelines

    @DataPipelines.setter
    def DataPipelines(self, DataPipelines):
        self._DataPipelines = DataPipelines

    @property
    def DataScenes(self):
        """数据构建任务所选择的通用算法任务
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataSceneConfig
        """
        return self._DataScenes

    @DataScenes.setter
    def DataScenes(self, DataScenes):
        self._DataScenes = DataScenes

    @property
    def Description(self):
        """数据构建任务的描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def NotebookId(self):
        """数据构建任务对应的Notebook ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NotebookId

    @NotebookId.setter
    def NotebookId(self, NotebookId):
        self._NotebookId = NotebookId

    @property
    def NotebookName(self):
        """数据构建任务对应的Notebook名字
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._NotebookName

    @NotebookName.setter
    def NotebookName(self, NotebookName):
        self._NotebookName = NotebookName

    @property
    def Tags(self):
        """数据构建任务标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CreatorNickname(self):
        """数据构建任务创建者名称
        :rtype: str
        """
        return self._CreatorNickname

    @CreatorNickname.setter
    def CreatorNickname(self, CreatorNickname):
        self._CreatorNickname = CreatorNickname

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._Creator = params.get("Creator")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("DataPipelines") is not None:
            self._DataPipelines = []
            for item in params.get("DataPipelines"):
                obj = DataPipelineConfig()
                obj._deserialize(item)
                self._DataPipelines.append(obj)
        if params.get("DataScenes") is not None:
            self._DataScenes = []
            for item in params.get("DataScenes"):
                obj = DataSceneConfig()
                obj._deserialize(item)
                self._DataScenes.append(obj)
        self._Description = params.get("Description")
        self._NotebookId = params.get("NotebookId")
        self._NotebookName = params.get("NotebookName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CreatorNickname = params.get("CreatorNickname")
        self._RequestId = params.get("RequestId")


class DescribeDataPipelineTasksRequest(AbstractModel):
    """DescribeDataPipelineTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 数据构建任务ID列表
        :type TaskIds: list of str
        :param _Filters: 数据构建任务过滤条件，多个Filter之间的关系为逻辑与（AND）关系，过滤字段Filter.Name支持以下两种:
1. TaskName: 数据构建任务名称
2. DataPipelines: 数据构建Pipeline, 其中DataPipelines Filter取值范围参考DescribeDataPipelineConfig接口的DataPipelineConfigs返回值
        :type Filters: list of Filter
        :param _Order: 输出列表的排列顺序。取值范围：ASC（升序排列）/ DESC（降序排列），默认为DESC
        :type Order: str
        :param _OrderField: 排序字段，支持CreateTime或UpdateTime，默认CreateTime
        :type OrderField: str
        :param _Offset: 偏移量，默认为0
        :type Offset: int
        :param _Limit: 限制数目，最大值200，默认值20
        :type Limit: int
        :param _TagFilters: 标签过滤条件
        :type TagFilters: list of TagFilter
        """
        self._TaskIds = None
        self._Filters = None
        self._Order = None
        self._OrderField = None
        self._Offset = None
        self._Limit = None
        self._TagFilters = None

    @property
    def TaskIds(self):
        """数据构建任务ID列表
        :rtype: list of str
        """
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def Filters(self):
        """数据构建任务过滤条件，多个Filter之间的关系为逻辑与（AND）关系，过滤字段Filter.Name支持以下两种:
1. TaskName: 数据构建任务名称
2. DataPipelines: 数据构建Pipeline, 其中DataPipelines Filter取值范围参考DescribeDataPipelineConfig接口的DataPipelineConfigs返回值
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        """输出列表的排列顺序。取值范围：ASC（升序排列）/ DESC（降序排列），默认为DESC
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OrderField(self):
        """排序字段，支持CreateTime或UpdateTime，默认CreateTime
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Offset(self):
        """偏移量，默认为0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """限制数目，最大值200，默认值20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TagFilters(self):
        """标签过滤条件
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._OrderField = params.get("OrderField")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataPipelineTasksResponse(AbstractModel):
    """DescribeDataPipelineTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 数据构建任务总量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _DataPipelineTasks: 数据构建任务列表详情
注意：此字段可能返回 null，表示取不到有效值。
        :type DataPipelineTasks: list of DataPipelineTask
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = N