# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from increase import Increase, AsyncIncrease
from tests.utils import assert_matches_type
from increase.types import DigitalWalletToken
from increase._utils import parse_datetime
from increase.pagination import SyncPage, AsyncPage

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestDigitalWalletTokens:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    def test_method_retrieve(self, client: Increase) -> None:
        digital_wallet_token = client.digital_wallet_tokens.retrieve(
            "digital_wallet_token_izi62go3h51p369jrie0",
        )
        assert_matches_type(DigitalWalletToken, digital_wallet_token, path=["response"])

    @parametrize
    def test_raw_response_retrieve(self, client: Increase) -> None:
        response = client.digital_wallet_tokens.with_raw_response.retrieve(
            "digital_wallet_token_izi62go3h51p369jrie0",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        digital_wallet_token = response.parse()
        assert_matches_type(DigitalWalletToken, digital_wallet_token, path=["response"])

    @parametrize
    def test_streaming_response_retrieve(self, client: Increase) -> None:
        with client.digital_wallet_tokens.with_streaming_response.retrieve(
            "digital_wallet_token_izi62go3h51p369jrie0",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            digital_wallet_token = response.parse()
            assert_matches_type(DigitalWalletToken, digital_wallet_token, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_retrieve(self, client: Increase) -> None:
        with pytest.raises(
            ValueError, match=r"Expected a non-empty value for `digital_wallet_token_id` but received ''"
        ):
            client.digital_wallet_tokens.with_raw_response.retrieve(
                "",
            )

    @parametrize
    def test_method_list(self, client: Increase) -> None:
        digital_wallet_token = client.digital_wallet_tokens.list()
        assert_matches_type(SyncPage[DigitalWalletToken], digital_wallet_token, path=["response"])

    @parametrize
    def test_method_list_with_all_params(self, client: Increase) -> None:
        digital_wallet_token = client.digital_wallet_tokens.list(
            card_id="card_id",
            created_at={
                "after": parse_datetime("2019-12-27T18:11:19.117Z"),
                "before": parse_datetime("2019-12-27T18:11:19.117Z"),
                "on_or_after": parse_datetime("2019-12-27T18:11:19.117Z"),
                "on_or_before": parse_datetime("2019-12-27T18:11:19.117Z"),
            },
            cursor="cursor",
            limit=1,
        )
        assert_matches_type(SyncPage[DigitalWalletToken], digital_wallet_token, path=["response"])

    @parametrize
    def test_raw_response_list(self, client: Increase) -> None:
        response = client.digital_wallet_tokens.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        digital_wallet_token = response.parse()
        assert_matches_type(SyncPage[DigitalWalletToken], digital_wallet_token, path=["response"])

    @parametrize
    def test_streaming_response_list(self, client: Increase) -> None:
        with client.digital_wallet_tokens.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            digital_wallet_token = response.parse()
            assert_matches_type(SyncPage[DigitalWalletToken], digital_wallet_token, path=["response"])

        assert cast(Any, response.is_closed) is True


class TestAsyncDigitalWalletTokens:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @parametrize
    async def test_method_retrieve(self, async_client: AsyncIncrease) -> None:
        digital_wallet_token = await async_client.digital_wallet_tokens.retrieve(
            "digital_wallet_token_izi62go3h51p369jrie0",
        )
        assert_matches_type(DigitalWalletToken, digital_wallet_token, path=["response"])

    @parametrize
    async def test_raw_response_retrieve(self, async_client: AsyncIncrease) -> None:
        response = await async_client.digital_wallet_tokens.with_raw_response.retrieve(
            "digital_wallet_token_izi62go3h51p369jrie0",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        digital_wallet_token = await response.parse()
        assert_matches_type(DigitalWalletToken, digital_wallet_token, path=["response"])

    @parametrize
    async def test_streaming_response_retrieve(self, async_client: AsyncIncrease) -> None:
        async with async_client.digital_wallet_tokens.with_streaming_response.retrieve(
            "digital_wallet_token_izi62go3h51p369jrie0",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            digital_wallet_token = await response.parse()
            assert_matches_type(DigitalWalletToken, digital_wallet_token, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_retrieve(self, async_client: AsyncIncrease) -> None:
        with pytest.raises(
            ValueError, match=r"Expected a non-empty value for `digital_wallet_token_id` but received ''"
        ):
            await async_client.digital_wallet_tokens.with_raw_response.retrieve(
                "",
            )

    @parametrize
    async def test_method_list(self, async_client: AsyncIncrease) -> None:
        digital_wallet_token = await async_client.digital_wallet_tokens.list()
        assert_matches_type(AsyncPage[DigitalWalletToken], digital_wallet_token, path=["response"])

    @parametrize
    async def test_method_list_with_all_params(self, async_client: AsyncIncrease) -> None:
        digital_wallet_token = await async_client.digital_wallet_tokens.list(
            card_id="card_id",
            created_at={
                "after": parse_datetime("2019-12-27T18:11:19.117Z"),
                "before": parse_datetime("2019-12-27T18:11:19.117Z"),
                "on_or_after": parse_datetime("2019-12-27T18:11:19.117Z"),
                "on_or_before": parse_datetime("2019-12-27T18:11:19.117Z"),
            },
            cursor="cursor",
            limit=1,
        )
        assert_matches_type(AsyncPage[DigitalWalletToken], digital_wallet_token, path=["response"])

    @parametrize
    async def test_raw_response_list(self, async_client: AsyncIncrease) -> None:
        response = await async_client.digital_wallet_tokens.with_raw_response.list()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        digital_wallet_token = await response.parse()
        assert_matches_type(AsyncPage[DigitalWalletToken], digital_wallet_token, path=["response"])

    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncIncrease) -> None:
        async with async_client.digital_wallet_tokens.with_streaming_response.list() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            digital_wallet_token = await response.parse()
            assert_matches_type(AsyncPage[DigitalWalletToken], digital_wallet_token, path=["response"])

        assert cast(Any, response.is_closed) is True
