# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEncryptionAtRestPrivateEndpointsResult',
    'AwaitableGetEncryptionAtRestPrivateEndpointsResult',
    'get_encryption_at_rest_private_endpoints',
    'get_encryption_at_rest_private_endpoints_output',
]

@pulumi.output_type
class GetEncryptionAtRestPrivateEndpointsResult:
    """
    A collection of values returned by getEncryptionAtRestPrivateEndpoints.
    """
    def __init__(__self__, cloud_provider=None, id=None, project_id=None, results=None):
        if cloud_provider and not isinstance(cloud_provider, str):
            raise TypeError("Expected argument 'cloud_provider' to be a str")
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> _builtins.str:
        """
        Label that identifies the cloud provider for the Encryption At Rest private endpoint.
        """
        return pulumi.get(self, "cloud_provider")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetEncryptionAtRestPrivateEndpointsResultResult']:
        """
        List of documents that MongoDB Cloud returns for this request.
        """
        return pulumi.get(self, "results")


class AwaitableGetEncryptionAtRestPrivateEndpointsResult(GetEncryptionAtRestPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEncryptionAtRestPrivateEndpointsResult(
            cloud_provider=self.cloud_provider,
            id=self.id,
            project_id=self.project_id,
            results=self.results)


def get_encryption_at_rest_private_endpoints(cloud_provider: Optional[_builtins.str] = None,
                                             project_id: Optional[_builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEncryptionAtRestPrivateEndpointsResult:
    """
    ## # Data Source: get_encryption_at_rest_private_endpoints

    `get_encryption_at_rest_private_endpoints` describes private endpoints of a particular cloud provider used for encryption at rest using customer-managed keys.

    ## Example Usage

    ### S

    > **NOTE:** Only Azure Key Vault with Azure Private Link and AWS KMS over AWS PrivateLink is supported at this time.

    ### Encryption At Rest Azure Key Vault Private Endpoint
    To learn more about existing limitations, see [Manage Customer Keys with Azure Key Vault Over Private Endpoints](https://www.mongodb.com/docs/atlas/security/azure-kms-over-private-endpoint/#manage-customer-keys-with-azure-key-vault-over-private-endpoints).

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    plural = mongodbatlas.get_encryption_at_rest_private_endpoints(project_id=atlas_project_id,
        cloud_provider="AZURE")
    pulumi.export("numberOfEndpoints", len(plural.results))
    ```

    ### Encryption At Rest AWS KMS Private Endpoint
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    plural = mongodbatlas.get_encryption_at_rest_private_endpoints(project_id=atlas_project_id,
        cloud_provider="AWS")
    pulumi.export("numberOfEndpoints", len(plural.results))
    ```


    :param _builtins.str cloud_provider: Label that identifies the cloud provider for the Encryption At Rest private endpoint.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['cloudProvider'] = cloud_provider
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getEncryptionAtRestPrivateEndpoints:getEncryptionAtRestPrivateEndpoints', __args__, opts=opts, typ=GetEncryptionAtRestPrivateEndpointsResult).value

    return AwaitableGetEncryptionAtRestPrivateEndpointsResult(
        cloud_provider=pulumi.get(__ret__, 'cloud_provider'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        results=pulumi.get(__ret__, 'results'))
def get_encryption_at_rest_private_endpoints_output(cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                                                    project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEncryptionAtRestPrivateEndpointsResult]:
    """
    ## # Data Source: get_encryption_at_rest_private_endpoints

    `get_encryption_at_rest_private_endpoints` describes private endpoints of a particular cloud provider used for encryption at rest using customer-managed keys.

    ## Example Usage

    ### S

    > **NOTE:** Only Azure Key Vault with Azure Private Link and AWS KMS over AWS PrivateLink is supported at this time.

    ### Encryption At Rest Azure Key Vault Private Endpoint
    To learn more about existing limitations, see [Manage Customer Keys with Azure Key Vault Over Private Endpoints](https://www.mongodb.com/docs/atlas/security/azure-kms-over-private-endpoint/#manage-customer-keys-with-azure-key-vault-over-private-endpoints).

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    plural = mongodbatlas.get_encryption_at_rest_private_endpoints(project_id=atlas_project_id,
        cloud_provider="AZURE")
    pulumi.export("numberOfEndpoints", len(plural.results))
    ```

    ### Encryption At Rest AWS KMS Private Endpoint
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    plural = mongodbatlas.get_encryption_at_rest_private_endpoints(project_id=atlas_project_id,
        cloud_provider="AWS")
    pulumi.export("numberOfEndpoints", len(plural.results))
    ```


    :param _builtins.str cloud_provider: Label that identifies the cloud provider for the Encryption At Rest private endpoint.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['cloudProvider'] = cloud_provider
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getEncryptionAtRestPrivateEndpoints:getEncryptionAtRestPrivateEndpoints', __args__, opts=opts, typ=GetEncryptionAtRestPrivateEndpointsResult)
    return __ret__.apply(lambda __response__: GetEncryptionAtRestPrivateEndpointsResult(
        cloud_provider=pulumi.get(__response__, 'cloud_provider'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        results=pulumi.get(__response__, 'results')))
