# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEventTriggerResult',
    'AwaitableGetEventTriggerResult',
    'get_event_trigger',
    'get_event_trigger_output',
]

@pulumi.output_type
class GetEventTriggerResult:
    """
    A collection of values returned by getEventTrigger.
    """
    def __init__(__self__, app_id=None, config_collection=None, config_database=None, config_full_document=None, config_full_document_before=None, config_match=None, config_operation_type=None, config_operation_types=None, config_project=None, config_providers=None, config_schedule=None, config_schedule_type=None, config_service_id=None, disabled=None, event_processors=None, function_id=None, function_name=None, id=None, name=None, project_id=None, trigger_id=None, type=None, unordered=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if config_collection and not isinstance(config_collection, str):
            raise TypeError("Expected argument 'config_collection' to be a str")
        pulumi.set(__self__, "config_collection", config_collection)
        if config_database and not isinstance(config_database, str):
            raise TypeError("Expected argument 'config_database' to be a str")
        pulumi.set(__self__, "config_database", config_database)
        if config_full_document and not isinstance(config_full_document, bool):
            raise TypeError("Expected argument 'config_full_document' to be a bool")
        pulumi.set(__self__, "config_full_document", config_full_document)
        if config_full_document_before and not isinstance(config_full_document_before, bool):
            raise TypeError("Expected argument 'config_full_document_before' to be a bool")
        pulumi.set(__self__, "config_full_document_before", config_full_document_before)
        if config_match and not isinstance(config_match, str):
            raise TypeError("Expected argument 'config_match' to be a str")
        pulumi.set(__self__, "config_match", config_match)
        if config_operation_type and not isinstance(config_operation_type, str):
            raise TypeError("Expected argument 'config_operation_type' to be a str")
        pulumi.set(__self__, "config_operation_type", config_operation_type)
        if config_operation_types and not isinstance(config_operation_types, list):
            raise TypeError("Expected argument 'config_operation_types' to be a list")
        pulumi.set(__self__, "config_operation_types", config_operation_types)
        if config_project and not isinstance(config_project, str):
            raise TypeError("Expected argument 'config_project' to be a str")
        pulumi.set(__self__, "config_project", config_project)
        if config_providers and not isinstance(config_providers, list):
            raise TypeError("Expected argument 'config_providers' to be a list")
        pulumi.set(__self__, "config_providers", config_providers)
        if config_schedule and not isinstance(config_schedule, str):
            raise TypeError("Expected argument 'config_schedule' to be a str")
        pulumi.set(__self__, "config_schedule", config_schedule)
        if config_schedule_type and not isinstance(config_schedule_type, str):
            raise TypeError("Expected argument 'config_schedule_type' to be a str")
        pulumi.set(__self__, "config_schedule_type", config_schedule_type)
        if config_service_id and not isinstance(config_service_id, str):
            raise TypeError("Expected argument 'config_service_id' to be a str")
        pulumi.set(__self__, "config_service_id", config_service_id)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if event_processors and not isinstance(event_processors, list):
            raise TypeError("Expected argument 'event_processors' to be a list")
        pulumi.set(__self__, "event_processors", event_processors)
        if function_id and not isinstance(function_id, str):
            raise TypeError("Expected argument 'function_id' to be a str")
        pulumi.set(__self__, "function_id", function_id)
        if function_name and not isinstance(function_name, str):
            raise TypeError("Expected argument 'function_name' to be a str")
        pulumi.set(__self__, "function_name", function_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if trigger_id and not isinstance(trigger_id, str):
            raise TypeError("Expected argument 'trigger_id' to be a str")
        pulumi.set(__self__, "trigger_id", trigger_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if unordered and not isinstance(unordered, bool):
            raise TypeError("Expected argument 'unordered' to be a bool")
        pulumi.set(__self__, "unordered", unordered)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="configCollection")
    def config_collection(self) -> _builtins.str:
        """
        The name of the MongoDB collection that the trigger watches for change events.
        """
        return pulumi.get(self, "config_collection")

    @_builtins.property
    @pulumi.getter(name="configDatabase")
    def config_database(self) -> _builtins.str:
        """
        The name of the MongoDB database to watch.
        """
        return pulumi.get(self, "config_database")

    @_builtins.property
    @pulumi.getter(name="configFullDocument")
    def config_full_document(self) -> _builtins.bool:
        """
        If true, indicates that `UPDATE` change events should include the most current [majority-committed](https://docs.mongodb.com/manual/reference/read-concern-majority/) version of the modified document in the fullDocument field.
        """
        return pulumi.get(self, "config_full_document")

    @_builtins.property
    @pulumi.getter(name="configFullDocumentBefore")
    def config_full_document_before(self) -> _builtins.bool:
        return pulumi.get(self, "config_full_document_before")

    @_builtins.property
    @pulumi.getter(name="configMatch")
    def config_match(self) -> _builtins.str:
        """
        A [$match](https://docs.mongodb.com/manual/reference/operator/aggregation/match/) expression document that MongoDB Realm includes in the underlying change stream pipeline for the trigger.
        """
        return pulumi.get(self, "config_match")

    @_builtins.property
    @pulumi.getter(name="configOperationType")
    def config_operation_type(self) -> _builtins.str:
        """
        The [authentication operation type](https://docs.mongodb.com/realm/triggers/authentication-triggers/#std-label-authentication-event-operation-types) to listen for.
        """
        return pulumi.get(self, "config_operation_type")

    @_builtins.property
    @pulumi.getter(name="configOperationTypes")
    def config_operation_types(self) -> Sequence[_builtins.str]:
        """
        The [database event operation types](https://docs.mongodb.com/realm/triggers/database-triggers/#std-label-database-events) to listen for.
        """
        return pulumi.get(self, "config_operation_types")

    @_builtins.property
    @pulumi.getter(name="configProject")
    def config_project(self) -> _builtins.str:
        """
        A [$project](https://docs.mongodb.com/manual/reference/operator/aggregation/project/) expression document that Realm uses to filter the fields that appear in change event objects.
        """
        return pulumi.get(self, "config_project")

    @_builtins.property
    @pulumi.getter(name="configProviders")
    def config_providers(self) -> Sequence[_builtins.str]:
        """
        A list of one or more [authentication provider](https://docs.mongodb.com/realm/authentication/providers/) id values. The trigger will only listen for authentication events produced by these providers.
        """
        return pulumi.get(self, "config_providers")

    @_builtins.property
    @pulumi.getter(name="configSchedule")
    def config_schedule(self) -> _builtins.str:
        """
        A [cron expression](https://docs.mongodb.com/realm/triggers/cron-expressions/) that defines the trigger schedule.
        """
        return pulumi.get(self, "config_schedule")

    @_builtins.property
    @pulumi.getter(name="configScheduleType")
    def config_schedule_type(self) -> _builtins.str:
        return pulumi.get(self, "config_schedule_type")

    @_builtins.property
    @pulumi.getter(name="configServiceId")
    def config_service_id(self) -> _builtins.str:
        """
        The ID of the MongoDB Service associated with the trigger.
        """
        return pulumi.get(self, "config_service_id")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Status of a trigger.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="eventProcessors")
    def event_processors(self) -> Sequence['outputs.GetEventTriggerEventProcessorResult']:
        """
        An object where each field name is an event processor ID and each value is an object that configures its corresponding event processor.
        """
        return pulumi.get(self, "event_processors")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> _builtins.str:
        """
        The ID of the function associated with the trigger.
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> _builtins.str:
        """
        The name of the function associated with the trigger.
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> _builtins.str:
        return pulumi.get(self, "trigger_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the trigger.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def unordered(self) -> _builtins.bool:
        """
        Only Available for Database Triggers. If true, event ordering is disabled and this trigger can process events in parallel. If false, event ordering is enabled and the trigger executes serially.
        """
        return pulumi.get(self, "unordered")


class AwaitableGetEventTriggerResult(GetEventTriggerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventTriggerResult(
            app_id=self.app_id,
            config_collection=self.config_collection,
            config_database=self.config_database,
            config_full_document=self.config_full_document,
            config_full_document_before=self.config_full_document_before,
            config_match=self.config_match,
            config_operation_type=self.config_operation_type,
            config_operation_types=self.config_operation_types,
            config_project=self.config_project,
            config_providers=self.config_providers,
            config_schedule=self.config_schedule,
            config_schedule_type=self.config_schedule_type,
            config_service_id=self.config_service_id,
            disabled=self.disabled,
            event_processors=self.event_processors,
            function_id=self.function_id,
            function_name=self.function_name,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            trigger_id=self.trigger_id,
            type=self.type,
            unordered=self.unordered)


def get_event_trigger(app_id: Optional[_builtins.str] = None,
                      project_id: Optional[_builtins.str] = None,
                      trigger_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventTriggerResult:
    """
    ## # Data Source: EventTrigger

    `EventTrigger` describes an Event Trigger.


    :param _builtins.str app_id: The ObjectID of your application.
           * For more details on `project_id` and `app_id` see: https://www.mongodb.com/docs/api/doc/atlas-app-services-admin-api-v3/#topic-project-amp-application-ids
    :param _builtins.str project_id: The unique ID for the project to create the trigger.
    :param _builtins.str trigger_id: The unique ID of the trigger.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['projectId'] = project_id
    __args__['triggerId'] = trigger_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getEventTrigger:getEventTrigger', __args__, opts=opts, typ=GetEventTriggerResult).value

    return AwaitableGetEventTriggerResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        config_collection=pulumi.get(__ret__, 'config_collection'),
        config_database=pulumi.get(__ret__, 'config_database'),
        config_full_document=pulumi.get(__ret__, 'config_full_document'),
        config_full_document_before=pulumi.get(__ret__, 'config_full_document_before'),
        config_match=pulumi.get(__ret__, 'config_match'),
        config_operation_type=pulumi.get(__ret__, 'config_operation_type'),
        config_operation_types=pulumi.get(__ret__, 'config_operation_types'),
        config_project=pulumi.get(__ret__, 'config_project'),
        config_providers=pulumi.get(__ret__, 'config_providers'),
        config_schedule=pulumi.get(__ret__, 'config_schedule'),
        config_schedule_type=pulumi.get(__ret__, 'config_schedule_type'),
        config_service_id=pulumi.get(__ret__, 'config_service_id'),
        disabled=pulumi.get(__ret__, 'disabled'),
        event_processors=pulumi.get(__ret__, 'event_processors'),
        function_id=pulumi.get(__ret__, 'function_id'),
        function_name=pulumi.get(__ret__, 'function_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        trigger_id=pulumi.get(__ret__, 'trigger_id'),
        type=pulumi.get(__ret__, 'type'),
        unordered=pulumi.get(__ret__, 'unordered'))
def get_event_trigger_output(app_id: Optional[pulumi.Input[_builtins.str]] = None,
                             project_id: Optional[pulumi.Input[_builtins.str]] = None,
                             trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventTriggerResult]:
    """
    ## # Data Source: EventTrigger

    `EventTrigger` describes an Event Trigger.


    :param _builtins.str app_id: The ObjectID of your application.
           * For more details on `project_id` and `app_id` see: https://www.mongodb.com/docs/api/doc/atlas-app-services-admin-api-v3/#topic-project-amp-application-ids
    :param _builtins.str project_id: The unique ID for the project to create the trigger.
    :param _builtins.str trigger_id: The unique ID of the trigger.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['projectId'] = project_id
    __args__['triggerId'] = trigger_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getEventTrigger:getEventTrigger', __args__, opts=opts, typ=GetEventTriggerResult)
    return __ret__.apply(lambda __response__: GetEventTriggerResult(
        app_id=pulumi.get(__response__, 'app_id'),
        config_collection=pulumi.get(__response__, 'config_collection'),
        config_database=pulumi.get(__response__, 'config_database'),
        config_full_document=pulumi.get(__response__, 'config_full_document'),
        config_full_document_before=pulumi.get(__response__, 'config_full_document_before'),
        config_match=pulumi.get(__response__, 'config_match'),
        config_operation_type=pulumi.get(__response__, 'config_operation_type'),
        config_operation_types=pulumi.get(__response__, 'config_operation_types'),
        config_project=pulumi.get(__response__, 'config_project'),
        config_providers=pulumi.get(__response__, 'config_providers'),
        config_schedule=pulumi.get(__response__, 'config_schedule'),
        config_schedule_type=pulumi.get(__response__, 'config_schedule_type'),
        config_service_id=pulumi.get(__response__, 'config_service_id'),
        disabled=pulumi.get(__response__, 'disabled'),
        event_processors=pulumi.get(__response__, 'event_processors'),
        function_id=pulumi.get(__response__, 'function_id'),
        function_name=pulumi.get(__response__, 'function_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        trigger_id=pulumi.get(__response__, 'trigger_id'),
        type=pulumi.get(__response__, 'type'),
        unordered=pulumi.get(__response__, 'unordered')))
