# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFlexSnapshotResult',
    'AwaitableGetFlexSnapshotResult',
    'get_flex_snapshot',
    'get_flex_snapshot_output',
]

@pulumi.output_type
class GetFlexSnapshotResult:
    """
    A collection of values returned by getFlexSnapshot.
    """
    def __init__(__self__, expiration=None, finish_time=None, id=None, mongo_db_version=None, name=None, project_id=None, scheduled_time=None, snapshot_id=None, start_time=None, status=None):
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if finish_time and not isinstance(finish_time, str):
            raise TypeError("Expected argument 'finish_time' to be a str")
        pulumi.set(__self__, "finish_time", finish_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mongo_db_version and not isinstance(mongo_db_version, str):
            raise TypeError("Expected argument 'mongo_db_version' to be a str")
        pulumi.set(__self__, "mongo_db_version", mongo_db_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if scheduled_time and not isinstance(scheduled_time, str):
            raise TypeError("Expected argument 'scheduled_time' to be a str")
        pulumi.set(__self__, "scheduled_time", scheduled_time)
        if snapshot_id and not isinstance(snapshot_id, str):
            raise TypeError("Expected argument 'snapshot_id' to be a str")
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> _builtins.str:
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> _builtins.str:
        return pulumi.get(self, "finish_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mongoDbVersion")
    def mongo_db_version(self) -> _builtins.str:
        return pulumi.get(self, "mongo_db_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Human-readable label that identifies the flex cluster whose snapshot you want to restore.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="scheduledTime")
    def scheduled_time(self) -> _builtins.str:
        return pulumi.get(self, "scheduled_time")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> _builtins.str:
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")


class AwaitableGetFlexSnapshotResult(GetFlexSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlexSnapshotResult(
            expiration=self.expiration,
            finish_time=self.finish_time,
            id=self.id,
            mongo_db_version=self.mongo_db_version,
            name=self.name,
            project_id=self.project_id,
            scheduled_time=self.scheduled_time,
            snapshot_id=self.snapshot_id,
            start_time=self.start_time,
            status=self.status)


def get_flex_snapshot(name: Optional[_builtins.str] = None,
                      project_id: Optional[_builtins.str] = None,
                      snapshot_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlexSnapshotResult:
    """
    ## # Data Source: get_flex_snapshot

    `get_flex_snapshot` describes a flex snapshot.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    snapshot = mongodbatlas.get_flex_snapshot(project_id=project_id,
        name=example_cluster["name"],
        snapshot_id=snapshot_id)
    snapshots = mongodbatlas.get_flex_snapshots(project_id=project_id,
        name=example_cluster["name"])
    pulumi.export("mongodbatlasFlexSnapshot", snapshot.name)
    pulumi.export("mongodbatlasFlexSnapshots", [snapshot.snapshot_id for snapshot in snapshots.results])
    ```


    :param _builtins.str name: Human-readable label that identifies the flex cluster whose snapshot you want to restore.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['snapshotId'] = snapshot_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getFlexSnapshot:getFlexSnapshot', __args__, opts=opts, typ=GetFlexSnapshotResult).value

    return AwaitableGetFlexSnapshotResult(
        expiration=pulumi.get(__ret__, 'expiration'),
        finish_time=pulumi.get(__ret__, 'finish_time'),
        id=pulumi.get(__ret__, 'id'),
        mongo_db_version=pulumi.get(__ret__, 'mongo_db_version'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        scheduled_time=pulumi.get(__ret__, 'scheduled_time'),
        snapshot_id=pulumi.get(__ret__, 'snapshot_id'),
        start_time=pulumi.get(__ret__, 'start_time'),
        status=pulumi.get(__ret__, 'status'))
def get_flex_snapshot_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                             project_id: Optional[pulumi.Input[_builtins.str]] = None,
                             snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlexSnapshotResult]:
    """
    ## # Data Source: get_flex_snapshot

    `get_flex_snapshot` describes a flex snapshot.

    ## Example Usage

    ### S
    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    snapshot = mongodbatlas.get_flex_snapshot(project_id=project_id,
        name=example_cluster["name"],
        snapshot_id=snapshot_id)
    snapshots = mongodbatlas.get_flex_snapshots(project_id=project_id,
        name=example_cluster["name"])
    pulumi.export("mongodbatlasFlexSnapshot", snapshot.name)
    pulumi.export("mongodbatlasFlexSnapshots", [snapshot.snapshot_id for snapshot in snapshots.results])
    ```


    :param _builtins.str name: Human-readable label that identifies the flex cluster whose snapshot you want to restore.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['snapshotId'] = snapshot_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getFlexSnapshot:getFlexSnapshot', __args__, opts=opts, typ=GetFlexSnapshotResult)
    return __ret__.apply(lambda __response__: GetFlexSnapshotResult(
        expiration=pulumi.get(__response__, 'expiration'),
        finish_time=pulumi.get(__response__, 'finish_time'),
        id=pulumi.get(__response__, 'id'),
        mongo_db_version=pulumi.get(__response__, 'mongo_db_version'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        scheduled_time=pulumi.get(__response__, 'scheduled_time'),
        snapshot_id=pulumi.get(__response__, 'snapshot_id'),
        start_time=pulumi.get(__response__, 'start_time'),
        status=pulumi.get(__response__, 'status')))
