# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult',
    'AwaitableGetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult',
    'get_privatelink_endpoint_service_data_federation_online_archive',
    'get_privatelink_endpoint_service_data_federation_online_archive_output',
]

@pulumi.output_type
class GetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult:
    """
    A collection of values returned by getPrivatelinkEndpointServiceDataFederationOnlineArchive.
    """
    def __init__(__self__, comment=None, customer_endpoint_dns_name=None, endpoint_id=None, id=None, project_id=None, provider_name=None, region=None, type=None):
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if customer_endpoint_dns_name and not isinstance(customer_endpoint_dns_name, str):
            raise TypeError("Expected argument 'customer_endpoint_dns_name' to be a str")
        pulumi.set(__self__, "customer_endpoint_dns_name", customer_endpoint_dns_name)
        if endpoint_id and not isinstance(endpoint_id, str):
            raise TypeError("Expected argument 'endpoint_id' to be a str")
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if provider_name and not isinstance(provider_name, str):
            raise TypeError("Expected argument 'provider_name' to be a str")
        pulumi.set(__self__, "provider_name", provider_name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Human-readable string to associate with this private endpoint.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="customerEndpointDnsName")
    def customer_endpoint_dns_name(self) -> _builtins.str:
        """
        (Optional) Human-readable label to identify VPC endpoint DNS name.
        """
        return pulumi.get(self, "customer_endpoint_dns_name")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> _builtins.str:
        """
        Human-readable label that identifies the cloud service provider.
        """
        return pulumi.get(self, "provider_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Human-readable label to identify the region of VPC endpoint.  Requires the **Atlas region name**, see the reference list for [AWS](https://docs.atlas.mongodb.com/reference/amazon-aws/), [GCP](https://docs.atlas.mongodb.com/reference/google-gcp/), [Azure](https://docs.atlas.mongodb.com/reference/microsoft-azure/).
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Human-readable label that identifies the resource type associated with this private endpoint.
        """
        return pulumi.get(self, "type")


class AwaitableGetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult(GetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult(
            comment=self.comment,
            customer_endpoint_dns_name=self.customer_endpoint_dns_name,
            endpoint_id=self.endpoint_id,
            id=self.id,
            project_id=self.project_id,
            provider_name=self.provider_name,
            region=self.region,
            type=self.type)


def get_privatelink_endpoint_service_data_federation_online_archive(endpoint_id: Optional[_builtins.str] = None,
                                                                    project_id: Optional[_builtins.str] = None,
                                                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult:
    """
    ## # Data Source: PrivatelinkEndpointServiceDataFederationOnlineArchive

    `PrivatelinkEndpointServiceDataFederationOnlineArchive` describes a Private Endpoint Service resource for Data Federation and Online Archive.

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    atlas_project = mongodbatlas.Project("atlas-project",
        org_id=atlas_org_id,
        name=atlas_project_name)
    test = mongodbatlas.PrivatelinkEndpointServiceDataFederationOnlineArchive("test",
        project_id=atlas_project.id,
        endpoint_id="vpce-046cf43c79424d4c9",
        provider_name="AWS",
        comment="Test",
        region="US_EAST_1",
        customer_endpoint_dns_name="vpce-046cf43c79424d4c9-nmls2y9k.vpce-svc-0824460b72e1a420e.us-east-1.vpce.amazonaws.com")
    test_data_source = mongodbatlas.get_privatelink_endpoint_service_data_federation_online_archive_output(project_id=atlas_project.id,
        endpoint_id=test.endpoint_id)
    ```


    :param _builtins.str endpoint_id: Unique 22-character alphanumeric string that identifies the private endpoint. See [Atlas Data Lake supports Amazon Web Services private endpoints using the AWS PrivateLink feature](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation/operation/createDataFederationPrivateEndpoint:~:text=Atlas%20Data%20Lake%20supports%20Amazon%20Web%20Services%20private%20endpoints%20using%20the%20AWS%20PrivateLink%20feature).
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['endpointId'] = endpoint_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getPrivatelinkEndpointServiceDataFederationOnlineArchive:getPrivatelinkEndpointServiceDataFederationOnlineArchive', __args__, opts=opts, typ=GetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult).value

    return AwaitableGetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult(
        comment=pulumi.get(__ret__, 'comment'),
        customer_endpoint_dns_name=pulumi.get(__ret__, 'customer_endpoint_dns_name'),
        endpoint_id=pulumi.get(__ret__, 'endpoint_id'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        provider_name=pulumi.get(__ret__, 'provider_name'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'))
def get_privatelink_endpoint_service_data_federation_online_archive_output(endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                                           project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult]:
    """
    ## # Data Source: PrivatelinkEndpointServiceDataFederationOnlineArchive

    `PrivatelinkEndpointServiceDataFederationOnlineArchive` describes a Private Endpoint Service resource for Data Federation and Online Archive.

    > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    atlas_project = mongodbatlas.Project("atlas-project",
        org_id=atlas_org_id,
        name=atlas_project_name)
    test = mongodbatlas.PrivatelinkEndpointServiceDataFederationOnlineArchive("test",
        project_id=atlas_project.id,
        endpoint_id="vpce-046cf43c79424d4c9",
        provider_name="AWS",
        comment="Test",
        region="US_EAST_1",
        customer_endpoint_dns_name="vpce-046cf43c79424d4c9-nmls2y9k.vpce-svc-0824460b72e1a420e.us-east-1.vpce.amazonaws.com")
    test_data_source = mongodbatlas.get_privatelink_endpoint_service_data_federation_online_archive_output(project_id=atlas_project.id,
        endpoint_id=test.endpoint_id)
    ```


    :param _builtins.str endpoint_id: Unique 22-character alphanumeric string that identifies the private endpoint. See [Atlas Data Lake supports Amazon Web Services private endpoints using the AWS PrivateLink feature](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation/operation/createDataFederationPrivateEndpoint:~:text=Atlas%20Data%20Lake%20supports%20Amazon%20Web%20Services%20private%20endpoints%20using%20the%20AWS%20PrivateLink%20feature).
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['endpointId'] = endpoint_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getPrivatelinkEndpointServiceDataFederationOnlineArchive:getPrivatelinkEndpointServiceDataFederationOnlineArchive', __args__, opts=opts, typ=GetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult)
    return __ret__.apply(lambda __response__: GetPrivatelinkEndpointServiceDataFederationOnlineArchiveResult(
        comment=pulumi.get(__response__, 'comment'),
        customer_endpoint_dns_name=pulumi.get(__response__, 'customer_endpoint_dns_name'),
        endpoint_id=pulumi.get(__response__, 'endpoint_id'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        provider_name=pulumi.get(__response__, 'provider_name'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type')))
