# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStreamConnectionsResult',
    'AwaitableGetStreamConnectionsResult',
    'get_stream_connections',
    'get_stream_connections_output',
]

@pulumi.output_type
class GetStreamConnectionsResult:
    """
    A collection of values returned by getStreamConnections.
    """
    def __init__(__self__, id=None, instance_name=None, items_per_page=None, page_num=None, project_id=None, results=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if items_per_page and not isinstance(items_per_page, int):
            raise TypeError("Expected argument 'items_per_page' to be a int")
        pulumi.set(__self__, "items_per_page", items_per_page)
        if page_num and not isinstance(page_num, int):
            raise TypeError("Expected argument 'page_num' to be a int")
        pulumi.set(__self__, "page_num", page_num)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This parameter is deprecated.""")
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        Human-readable label that identifies the stream instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="itemsPerPage")
    def items_per_page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "items_per_page")

    @_builtins.property
    @pulumi.getter(name="pageNum")
    def page_num(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_num")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetStreamConnectionsResultResult']:
        """
        A list where each element contains a stream connection.
        """
        return pulumi.get(self, "results")

    @_builtins.property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> _builtins.int:
        """
        Count of the total number of items in the result set. The count might be greater than the number of objects in the results array if the entire result set is paginated.
        """
        return pulumi.get(self, "total_count")


class AwaitableGetStreamConnectionsResult(GetStreamConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamConnectionsResult(
            id=self.id,
            instance_name=self.instance_name,
            items_per_page=self.items_per_page,
            page_num=self.page_num,
            project_id=self.project_id,
            results=self.results,
            total_count=self.total_count)


def get_stream_connections(instance_name: Optional[_builtins.str] = None,
                           items_per_page: Optional[_builtins.int] = None,
                           page_num: Optional[_builtins.int] = None,
                           project_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamConnectionsResult:
    """
    ## # Data Source: get_stream_connections

    `get_stream_connections` describes all connections of a stream instance for the specified project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_stream_connections(project_id="<PROJECT_ID>",
        instance_name="<INSTANCE_NAME>")
    ```


    :param _builtins.str instance_name: Human-readable label that identifies the stream instance.
    :param _builtins.int items_per_page: Number of items that the response returns per page, up to a maximum of `500`. Defaults to `100`.
    :param _builtins.int page_num: Number of the page that displays the current set of the total objects that the response returns. Defaults to `1`.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['instanceName'] = instance_name
    __args__['itemsPerPage'] = items_per_page
    __args__['pageNum'] = page_num
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getStreamConnections:getStreamConnections', __args__, opts=opts, typ=GetStreamConnectionsResult).value

    return AwaitableGetStreamConnectionsResult(
        id=pulumi.get(__ret__, 'id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        items_per_page=pulumi.get(__ret__, 'items_per_page'),
        page_num=pulumi.get(__ret__, 'page_num'),
        project_id=pulumi.get(__ret__, 'project_id'),
        results=pulumi.get(__ret__, 'results'),
        total_count=pulumi.get(__ret__, 'total_count'))
def get_stream_connections_output(instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                                  items_per_page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                  page_num: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                  project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamConnectionsResult]:
    """
    ## # Data Source: get_stream_connections

    `get_stream_connections` describes all connections of a stream instance for the specified project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test = mongodbatlas.get_stream_connections(project_id="<PROJECT_ID>",
        instance_name="<INSTANCE_NAME>")
    ```


    :param _builtins.str instance_name: Human-readable label that identifies the stream instance.
    :param _builtins.int items_per_page: Number of items that the response returns per page, up to a maximum of `500`. Defaults to `100`.
    :param _builtins.int page_num: Number of the page that displays the current set of the total objects that the response returns. Defaults to `1`.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project.
    """
    __args__ = dict()
    __args__['instanceName'] = instance_name
    __args__['itemsPerPage'] = items_per_page
    __args__['pageNum'] = page_num
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getStreamConnections:getStreamConnections', __args__, opts=opts, typ=GetStreamConnectionsResult)
    return __ret__.apply(lambda __response__: GetStreamConnectionsResult(
        id=pulumi.get(__response__, 'id'),
        instance_name=pulumi.get(__response__, 'instance_name'),
        items_per_page=pulumi.get(__response__, 'items_per_page'),
        page_num=pulumi.get(__response__, 'page_num'),
        project_id=pulumi.get(__response__, 'project_id'),
        results=pulumi.get(__response__, 'results'),
        total_count=pulumi.get(__response__, 'total_count')))
