# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StreamPrivatelinkEndpointArgs', 'StreamPrivatelinkEndpoint']

@pulumi.input_type
class StreamPrivatelinkEndpointArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 provider_name: pulumi.Input[_builtins.str],
                 vendor: pulumi.Input[_builtins.str],
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StreamPrivatelinkEndpoint resource.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.<br>**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
        :param pulumi.Input[_builtins.str] provider_name: Provider where the endpoint is deployed. Valid values are AWS and AZURE.
        :param pulumi.Input[_builtins.str] vendor: Vendor that manages the endpoint. The following are the vendor values per provider:
               
               	* **AWS**: MSK, CONFLUENT, and S3
               
               	* **Azure**: EVENTHUB and CONFLUENT
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN). Required for AWS Provider and MSK vendor.
        :param pulumi.Input[_builtins.str] dns_domain: The domain hostname. Required for the following provider and vendor combinations:
               				
               	* AWS provider with CONFLUENT vendor.
               
               	* AZURE provider with EVENTHUB or CONFLUENT vendor.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_sub_domains: Sub-Domain name of Confluent cluster. These are typically your availability zones. Required for AWS Provider and CONFLUENT vendor. If your AWS CONFLUENT cluster doesn't use subdomains, you must set this to the empty array [].
        :param pulumi.Input[_builtins.str] region: The region of the Provider’s cluster. See [AZURE](https://www.mongodb.com/docs/atlas/reference/microsoft-azure/#stream-processing-instances) and [AWS](https://www.mongodb.com/docs/atlas/reference/amazon-aws/#stream-processing-instances) supported regions. When the vendor is `CONFLUENT`, this is the domain name of Confluent cluster. When the vendor is `MSK`, this is computed by the API from the provided `arn`.
        :param pulumi.Input[_builtins.str] service_endpoint_id: For AZURE EVENTHUB, this is the [namespace endpoint ID](https://learn.microsoft.com/en-us/rest/api/eventhub/namespaces/get). For AWS CONFLUENT cluster, this is the [VPC Endpoint service name](https://docs.confluent.io/cloud/current/networking/private-links/aws-privatelink.html).
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provider_name", provider_name)
        pulumi.set(__self__, "vendor", vendor)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if dns_sub_domains is not None:
            pulumi.set(__self__, "dns_sub_domains", dns_sub_domains)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_endpoint_id is not None:
            pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.<br>**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Input[_builtins.str]:
        """
        Provider where the endpoint is deployed. Valid values are AWS and AZURE.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_name", value)

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> pulumi.Input[_builtins.str]:
        """
        Vendor that manages the endpoint. The following are the vendor values per provider:

        	* **AWS**: MSK, CONFLUENT, and S3

        	* **Azure**: EVENTHUB and CONFLUENT
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vendor", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN). Required for AWS Provider and MSK vendor.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain hostname. Required for the following provider and vendor combinations:
        				
        	* AWS provider with CONFLUENT vendor.

        	* AZURE provider with EVENTHUB or CONFLUENT vendor.
        """
        return pulumi.get(self, "dns_domain")

    @dns_domain.setter
    def dns_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_domain", value)

    @_builtins.property
    @pulumi.getter(name="dnsSubDomains")
    def dns_sub_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Sub-Domain name of Confluent cluster. These are typically your availability zones. Required for AWS Provider and CONFLUENT vendor. If your AWS CONFLUENT cluster doesn't use subdomains, you must set this to the empty array [].
        """
        return pulumi.get(self, "dns_sub_domains")

    @dns_sub_domains.setter
    def dns_sub_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_sub_domains", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the Provider’s cluster. See [AZURE](https://www.mongodb.com/docs/atlas/reference/microsoft-azure/#stream-processing-instances) and [AWS](https://www.mongodb.com/docs/atlas/reference/amazon-aws/#stream-processing-instances) supported regions. When the vendor is `CONFLUENT`, this is the domain name of Confluent cluster. When the vendor is `MSK`, this is computed by the API from the provided `arn`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For AZURE EVENTHUB, this is the [namespace endpoint ID](https://learn.microsoft.com/en-us/rest/api/eventhub/namespaces/get). For AWS CONFLUENT cluster, this is the [VPC Endpoint service name](https://docs.confluent.io/cloud/current/networking/private-links/aws-privatelink.html).
        """
        return pulumi.get(self, "service_endpoint_id")

    @service_endpoint_id.setter
    def service_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint_id", value)


@pulumi.input_type
class _StreamPrivatelinkEndpointState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 error_message: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StreamPrivatelinkEndpoint resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN). Required for AWS Provider and MSK vendor.
        :param pulumi.Input[_builtins.str] dns_domain: The domain hostname. Required for the following provider and vendor combinations:
               				
               	* AWS provider with CONFLUENT vendor.
               
               	* AZURE provider with EVENTHUB or CONFLUENT vendor.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_sub_domains: Sub-Domain name of Confluent cluster. These are typically your availability zones. Required for AWS Provider and CONFLUENT vendor. If your AWS CONFLUENT cluster doesn't use subdomains, you must set this to the empty array [].
        :param pulumi.Input[_builtins.str] error_message: Error message if the connection is in a failed state.
        :param pulumi.Input[_builtins.str] interface_endpoint_id: Interface endpoint ID that is created from the specified service endpoint ID.
        :param pulumi.Input[_builtins.str] interface_endpoint_name: Name of interface endpoint that is created from the specified service endpoint ID.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.<br>**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
        :param pulumi.Input[_builtins.str] provider_account_id: Account ID from the cloud provider.
        :param pulumi.Input[_builtins.str] provider_name: Provider where the endpoint is deployed. Valid values are AWS and AZURE.
        :param pulumi.Input[_builtins.str] region: The region of the Provider’s cluster. See [AZURE](https://www.mongodb.com/docs/atlas/reference/microsoft-azure/#stream-processing-instances) and [AWS](https://www.mongodb.com/docs/atlas/reference/amazon-aws/#stream-processing-instances) supported regions. When the vendor is `CONFLUENT`, this is the domain name of Confluent cluster. When the vendor is `MSK`, this is computed by the API from the provided `arn`.
        :param pulumi.Input[_builtins.str] service_endpoint_id: For AZURE EVENTHUB, this is the [namespace endpoint ID](https://learn.microsoft.com/en-us/rest/api/eventhub/namespaces/get). For AWS CONFLUENT cluster, this is the [VPC Endpoint service name](https://docs.confluent.io/cloud/current/networking/private-links/aws-privatelink.html).
        :param pulumi.Input[_builtins.str] state: Status of the connection.
        :param pulumi.Input[_builtins.str] vendor: Vendor that manages the endpoint. The following are the vendor values per provider:
               
               	* **AWS**: MSK, CONFLUENT, and S3
               
               	* **Azure**: EVENTHUB and CONFLUENT
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if dns_domain is not None:
            pulumi.set(__self__, "dns_domain", dns_domain)
        if dns_sub_domains is not None:
            pulumi.set(__self__, "dns_sub_domains", dns_sub_domains)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if interface_endpoint_id is not None:
            pulumi.set(__self__, "interface_endpoint_id", interface_endpoint_id)
        if interface_endpoint_name is not None:
            pulumi.set(__self__, "interface_endpoint_name", interface_endpoint_name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if provider_account_id is not None:
            pulumi.set(__self__, "provider_account_id", provider_account_id)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_endpoint_id is not None:
            pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN). Required for AWS Provider and MSK vendor.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain hostname. Required for the following provider and vendor combinations:
        				
        	* AWS provider with CONFLUENT vendor.

        	* AZURE provider with EVENTHUB or CONFLUENT vendor.
        """
        return pulumi.get(self, "dns_domain")

    @dns_domain.setter
    def dns_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_domain", value)

    @_builtins.property
    @pulumi.getter(name="dnsSubDomains")
    def dns_sub_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Sub-Domain name of Confluent cluster. These are typically your availability zones. Required for AWS Provider and CONFLUENT vendor. If your AWS CONFLUENT cluster doesn't use subdomains, you must set this to the empty array [].
        """
        return pulumi.get(self, "dns_sub_domains")

    @dns_sub_domains.setter
    def dns_sub_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_sub_domains", value)

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error message if the connection is in a failed state.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_message", value)

    @_builtins.property
    @pulumi.getter(name="interfaceEndpointId")
    def interface_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface endpoint ID that is created from the specified service endpoint ID.
        """
        return pulumi.get(self, "interface_endpoint_id")

    @interface_endpoint_id.setter
    def interface_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="interfaceEndpointName")
    def interface_endpoint_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of interface endpoint that is created from the specified service endpoint ID.
        """
        return pulumi.get(self, "interface_endpoint_name")

    @interface_endpoint_name.setter
    def interface_endpoint_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_endpoint_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.<br>**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="providerAccountId")
    def provider_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID from the cloud provider.
        """
        return pulumi.get(self, "provider_account_id")

    @provider_account_id.setter
    def provider_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_account_id", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider where the endpoint is deployed. Valid values are AWS and AZURE.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the Provider’s cluster. See [AZURE](https://www.mongodb.com/docs/atlas/reference/microsoft-azure/#stream-processing-instances) and [AWS](https://www.mongodb.com/docs/atlas/reference/amazon-aws/#stream-processing-instances) supported regions. When the vendor is `CONFLUENT`, this is the domain name of Confluent cluster. When the vendor is `MSK`, this is computed by the API from the provided `arn`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For AZURE EVENTHUB, this is the [namespace endpoint ID](https://learn.microsoft.com/en-us/rest/api/eventhub/namespaces/get). For AWS CONFLUENT cluster, this is the [VPC Endpoint service name](https://docs.confluent.io/cloud/current/networking/private-links/aws-privatelink.html).
        """
        return pulumi.get(self, "service_endpoint_id")

    @service_endpoint_id.setter
    def service_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vendor that manages the endpoint. The following are the vendor values per provider:

        	* **AWS**: MSK, CONFLUENT, and S3

        	* **Azure**: EVENTHUB and CONFLUENT
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vendor", value)


@pulumi.type_token("mongodbatlas:index/streamPrivatelinkEndpoint:StreamPrivatelinkEndpoint")
class StreamPrivatelinkEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## # Resource: StreamPrivatelinkEndpoint

        `StreamPrivatelinkEndpoint` describes a Privatelink Endpoint for Streams.

        ## Example Usage

        ### S

        ### AWS S3 Privatelink
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_mongodbatlas as mongodbatlas

        # S3 bucket for stream data
        stream_bucket = aws.index.S3Bucket("stream_bucket",
            bucket=s3_bucket_name,
            force_destroy=True)
        stream_bucket_versioning = aws.index.S3BucketVersioning("stream_bucket_versioning",
            bucket=stream_bucket.id,
            versioning_configuration=[{
                status: Enabled,
            }])
        stream_bucket_encryption = aws.index.S3BucketServerSideEncryptionConfiguration("stream_bucket_encryption",
            bucket=stream_bucket.id,
            rule=[{
                applyServerSideEncryptionByDefault: [{
                    sseAlgorithm: AES256,
                }],
            }])
        # PrivateLink for S3
        this = mongodbatlas.StreamPrivatelinkEndpoint("this",
            project_id=project_id,
            provider_name="AWS",
            vendor="S3",
            region=region,
            service_endpoint_id=service_endpoint_id)
        pulumi.export("privatelinkEndpointId", this.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN). Required for AWS Provider and MSK vendor.
        :param pulumi.Input[_builtins.str] dns_domain: The domain hostname. Required for the following provider and vendor combinations:
               				
               	* AWS provider with CONFLUENT vendor.
               
               	* AZURE provider with EVENTHUB or CONFLUENT vendor.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_sub_domains: Sub-Domain name of Confluent cluster. These are typically your availability zones. Required for AWS Provider and CONFLUENT vendor. If your AWS CONFLUENT cluster doesn't use subdomains, you must set this to the empty array [].
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.<br>**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
        :param pulumi.Input[_builtins.str] provider_name: Provider where the endpoint is deployed. Valid values are AWS and AZURE.
        :param pulumi.Input[_builtins.str] region: The region of the Provider’s cluster. See [AZURE](https://www.mongodb.com/docs/atlas/reference/microsoft-azure/#stream-processing-instances) and [AWS](https://www.mongodb.com/docs/atlas/reference/amazon-aws/#stream-processing-instances) supported regions. When the vendor is `CONFLUENT`, this is the domain name of Confluent cluster. When the vendor is `MSK`, this is computed by the API from the provided `arn`.
        :param pulumi.Input[_builtins.str] service_endpoint_id: For AZURE EVENTHUB, this is the [namespace endpoint ID](https://learn.microsoft.com/en-us/rest/api/eventhub/namespaces/get). For AWS CONFLUENT cluster, this is the [VPC Endpoint service name](https://docs.confluent.io/cloud/current/networking/private-links/aws-privatelink.html).
        :param pulumi.Input[_builtins.str] vendor: Vendor that manages the endpoint. The following are the vendor values per provider:
               
               	* **AWS**: MSK, CONFLUENT, and S3
               
               	* **Azure**: EVENTHUB and CONFLUENT
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamPrivatelinkEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: StreamPrivatelinkEndpoint

        `StreamPrivatelinkEndpoint` describes a Privatelink Endpoint for Streams.

        ## Example Usage

        ### S

        ### AWS S3 Privatelink
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_mongodbatlas as mongodbatlas

        # S3 bucket for stream data
        stream_bucket = aws.index.S3Bucket("stream_bucket",
            bucket=s3_bucket_name,
            force_destroy=True)
        stream_bucket_versioning = aws.index.S3BucketVersioning("stream_bucket_versioning",
            bucket=stream_bucket.id,
            versioning_configuration=[{
                status: Enabled,
            }])
        stream_bucket_encryption = aws.index.S3BucketServerSideEncryptionConfiguration("stream_bucket_encryption",
            bucket=stream_bucket.id,
            rule=[{
                applyServerSideEncryptionByDefault: [{
                    sseAlgorithm: AES256,
                }],
            }])
        # PrivateLink for S3
        this = mongodbatlas.StreamPrivatelinkEndpoint("this",
            project_id=project_id,
            provider_name="AWS",
            vendor="S3",
            region=region,
            service_endpoint_id=service_endpoint_id)
        pulumi.export("privatelinkEndpointId", this.id)
        ```

        :param str resource_name: The name of the resource.
        :param StreamPrivatelinkEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamPrivatelinkEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vendor: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamPrivatelinkEndpointArgs.__new__(StreamPrivatelinkEndpointArgs)

            __props__.__dict__["arn"] = arn
            __props__.__dict__["dns_domain"] = dns_domain
            __props__.__dict__["dns_sub_domains"] = dns_sub_domains
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'provider_name'")
            __props__.__dict__["provider_name"] = provider_name
            __props__.__dict__["region"] = region
            __props__.__dict__["service_endpoint_id"] = service_endpoint_id
            if vendor is None and not opts.urn:
                raise TypeError("Missing required property 'vendor'")
            __props__.__dict__["vendor"] = vendor
            __props__.__dict__["error_message"] = None
            __props__.__dict__["interface_endpoint_id"] = None
            __props__.__dict__["interface_endpoint_name"] = None
            __props__.__dict__["provider_account_id"] = None
            __props__.__dict__["state"] = None
        super(StreamPrivatelinkEndpoint, __self__).__init__(
            'mongodbatlas:index/streamPrivatelinkEndpoint:StreamPrivatelinkEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            dns_domain: Optional[pulumi.Input[_builtins.str]] = None,
            dns_sub_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            error_message: Optional[pulumi.Input[_builtins.str]] = None,
            interface_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            interface_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            provider_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            provider_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            vendor: Optional[pulumi.Input[_builtins.str]] = None) -> 'StreamPrivatelinkEndpoint':
        """
        Get an existing StreamPrivatelinkEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN). Required for AWS Provider and MSK vendor.
        :param pulumi.Input[_builtins.str] dns_domain: The domain hostname. Required for the following provider and vendor combinations:
               				
               	* AWS provider with CONFLUENT vendor.
               
               	* AZURE provider with EVENTHUB or CONFLUENT vendor.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_sub_domains: Sub-Domain name of Confluent cluster. These are typically your availability zones. Required for AWS Provider and CONFLUENT vendor. If your AWS CONFLUENT cluster doesn't use subdomains, you must set this to the empty array [].
        :param pulumi.Input[_builtins.str] error_message: Error message if the connection is in a failed state.
        :param pulumi.Input[_builtins.str] interface_endpoint_id: Interface endpoint ID that is created from the specified service endpoint ID.
        :param pulumi.Input[_builtins.str] interface_endpoint_name: Name of interface endpoint that is created from the specified service endpoint ID.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.<br>**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
        :param pulumi.Input[_builtins.str] provider_account_id: Account ID from the cloud provider.
        :param pulumi.Input[_builtins.str] provider_name: Provider where the endpoint is deployed. Valid values are AWS and AZURE.
        :param pulumi.Input[_builtins.str] region: The region of the Provider’s cluster. See [AZURE](https://www.mongodb.com/docs/atlas/reference/microsoft-azure/#stream-processing-instances) and [AWS](https://www.mongodb.com/docs/atlas/reference/amazon-aws/#stream-processing-instances) supported regions. When the vendor is `CONFLUENT`, this is the domain name of Confluent cluster. When the vendor is `MSK`, this is computed by the API from the provided `arn`.
        :param pulumi.Input[_builtins.str] service_endpoint_id: For AZURE EVENTHUB, this is the [namespace endpoint ID](https://learn.microsoft.com/en-us/rest/api/eventhub/namespaces/get). For AWS CONFLUENT cluster, this is the [VPC Endpoint service name](https://docs.confluent.io/cloud/current/networking/private-links/aws-privatelink.html).
        :param pulumi.Input[_builtins.str] state: Status of the connection.
        :param pulumi.Input[_builtins.str] vendor: Vendor that manages the endpoint. The following are the vendor values per provider:
               
               	* **AWS**: MSK, CONFLUENT, and S3
               
               	* **Azure**: EVENTHUB and CONFLUENT
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamPrivatelinkEndpointState.__new__(_StreamPrivatelinkEndpointState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["dns_domain"] = dns_domain
        __props__.__dict__["dns_sub_domains"] = dns_sub_domains
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["interface_endpoint_id"] = interface_endpoint_id
        __props__.__dict__["interface_endpoint_name"] = interface_endpoint_name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["provider_account_id"] = provider_account_id
        __props__.__dict__["provider_name"] = provider_name
        __props__.__dict__["region"] = region
        __props__.__dict__["service_endpoint_id"] = service_endpoint_id
        __props__.__dict__["state"] = state
        __props__.__dict__["vendor"] = vendor
        return StreamPrivatelinkEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Amazon Resource Name (ARN). Required for AWS Provider and MSK vendor.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="dnsDomain")
    def dns_domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The domain hostname. Required for the following provider and vendor combinations:
        				
        	* AWS provider with CONFLUENT vendor.

        	* AZURE provider with EVENTHUB or CONFLUENT vendor.
        """
        return pulumi.get(self, "dns_domain")

    @_builtins.property
    @pulumi.getter(name="dnsSubDomains")
    def dns_sub_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Sub-Domain name of Confluent cluster. These are typically your availability zones. Required for AWS Provider and CONFLUENT vendor. If your AWS CONFLUENT cluster doesn't use subdomains, you must set this to the empty array [].
        """
        return pulumi.get(self, "dns_sub_domains")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[_builtins.str]:
        """
        Error message if the connection is in a failed state.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="interfaceEndpointId")
    def interface_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        Interface endpoint ID that is created from the specified service endpoint ID.
        """
        return pulumi.get(self, "interface_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="interfaceEndpointName")
    def interface_endpoint_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of interface endpoint that is created from the specified service endpoint ID.
        """
        return pulumi.get(self, "interface_endpoint_name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.<br>**NOTE**: Groups and projects are synonymous terms. Your group id is the same as your project id. For existing groups, your group or project id remains the same. The resource and corresponding endpoints use the term groups.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="providerAccountId")
    def provider_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account ID from the cloud provider.
        """
        return pulumi.get(self, "provider_account_id")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Output[_builtins.str]:
        """
        Provider where the endpoint is deployed. Valid values are AWS and AZURE.
        """
        return pulumi.get(self, "provider_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the Provider’s cluster. See [AZURE](https://www.mongodb.com/docs/atlas/reference/microsoft-azure/#stream-processing-instances) and [AWS](https://www.mongodb.com/docs/atlas/reference/amazon-aws/#stream-processing-instances) supported regions. When the vendor is `CONFLUENT`, this is the domain name of Confluent cluster. When the vendor is `MSK`, this is computed by the API from the provided `arn`.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        For AZURE EVENTHUB, this is the [namespace endpoint ID](https://learn.microsoft.com/en-us/rest/api/eventhub/namespaces/get). For AWS CONFLUENT cluster, this is the [VPC Endpoint service name](https://docs.confluent.io/cloud/current/networking/private-links/aws-privatelink.html).
        """
        return pulumi.get(self, "service_endpoint_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the connection.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def vendor(self) -> pulumi.Output[_builtins.str]:
        """
        Vendor that manages the endpoint. The following are the vendor values per provider:

        	* **AWS**: MSK, CONFLUENT, and S3

        	* **Azure**: EVENTHUB and CONFLUENT
        """
        return pulumi.get(self, "vendor")

