INPUT_VARIABLES = [
    "tanf_reported",
    "spm_unit_payroll_tax_reported",
    "veterans_benefits",
    "other_credits",
    "tax_exempt_ira_distributions",
    "ssi_reported",
    "tax_exempt_403b_distributions",
    "taxable_ira_distributions",
    "w2_wages_from_qualified_business",
    "roth_ira_contributions",
    "social_security_retirement",
    "domestic_production_ald",
    "social_security_disability",
    "health_savings_account_ald",
    "investment_income_elected_form_4952",
    "medical_out_of_pocket_expenses",
    "unemployment_compensation",
    "self_employment_income",
    "interest_deduction",
    "energy_efficient_home_improvement_credit",
    "spm_unit_net_income_reported",
    "roth_401k_contributions",
    "spm_unit_federal_tax_reported",
    "spm_unit_pre_subsidy_childcare_expenses",
    "taxable_pension_income",
    "keogh_distributions",
    "social_security_survivors",
    "amt_foreign_tax_credit",
    "cdcc_relevant_expenses",
    "social_security",
    "workers_compensation",
    "self_employed_health_insurance_ald",
    "state_and_local_sales_or_income_tax",
    "child_support_received",
    "child_support_expense",
    "tax_exempt_sep_distributions",
    "salt_refund_income",
    "spm_unit_total_income_reported",
    "alimony_income",
    "prior_year_minimum_tax_credit",
    "self_employed_pension_contributions",
    "taxable_unemployment_compensation",
    "employment_income_last_year",
    "taxable_sep_distributions",
    "spm_unit_capped_housing_subsidy_reported",
    "miscellaneous_income",
    "short_term_capital_gains",
    "qualified_dividend_income",
    "tax_exempt_private_pension_income",
    "rental_income",
    "student_loan_interest",
    "tax_exempt_interest_income",
    "general_business_credit",
    "early_withdrawal_penalty",
    "spm_unit_weight",
    "casualty_loss",
    "partnership_s_corp_income",
    "taxable_interest_income",
    "spm_unit_spm_threshold",
    "non_sch_d_capital_gains",
    "spm_unit_state_tax_reported",
    "spm_unit_capped_work_childcare_expenses",
    "farm_income",
    "taxable_403b_distributions",
    "qualified_tuition_expenses",
    "disability_benefits",
    "taxable_401k_distributions",
    "farm_rent_income",
    "unreported_payroll_tax",
    "traditional_ira_contributions",
    "tax_exempt_401k_distributions",
    "alimony_expense",
    "taxable_private_pension_income",
    "charitable_cash_donations",
    "spm_unit_broadband_subsidy_reported",
    "free_school_meals_reported",
    "non_qualified_dividend_income",
    "excess_withheld_payroll_tax",
    "health_insurance_premiums",
    "spm_unit_energy_subsidy_reported",
    "real_estate_taxes",
    "estate_income",
    "misc_deduction",
    "self_employed_pension_contribution_ald",
    "spm_unit_wic_reported",
    "unrecaptured_section_1250_gain",
    "snap_reported",
    "long_term_capital_gains_on_collectibles",
    "self_employment_income_last_year",
    "tax_exempt_pension_income",
    "employment_income",
    "foreign_tax_credit",
    "pre_tax_contributions",
    "social_security_dependents",
    "american_opportunity_credit",
    "charitable_non_cash_donations",
    "recapture_of_investment_credit",
    "savers_credit",
    "educator_expense",
    "long_term_capital_gains",
    "traditional_401k_contributions",
    "strike_benefits",
    "other_medical_expenses",
    "over_the_counter_health_expenses",
    "medicare_part_b_premiums",
    "health_insurance_premiums_without_medicare_part_b",
]


def add_default_uprating(system):
    for variable in system.variables.values():
        if (variable.name in INPUT_VARIABLES) and (variable.uprating is None):
            variable.uprating = (
                "calibration.gov.cbo.income_by_source.adjusted_gross_income"
            )
        system.variables[variable.name] = variable
