class LLMError(Exception):
    """Base class for all LLM-related errors."""

    pass


class LLMJSONParsingError(LLMError):
    """Exception raised for errors in the JSON parsing process."""

    def __init__(self, message="Error parsing JSON generated by LLM"):
        self.message = message
        super().__init__(self.message)


class LocalLLMError(LLMError):
    """Generic catch-all error for local LLM problems"""

    def __init__(self, message="Encountered an error while running local LLM"):
        self.message = message
        super().__init__(self.message)


class LocalLLMConnectionError(LLMError):
    """Error for when local LLM cannot be reached with provided IP/port"""

    def __init__(self, message="Could not connect to local LLM"):
        self.message = message
        super().__init__(self.message)
