# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRecommendationsResult',
    'AwaitableGetRecommendationsResult',
    'get_recommendations',
    'get_recommendations_output',
]

@pulumi.output_type
class GetRecommendationsResult:
    """
    A collection of values returned by getRecommendations.
    """
    def __init__(__self__, filter_by_categories=None, filter_by_resource_groups=None, id=None, recommendations=None):
        if filter_by_categories and not isinstance(filter_by_categories, list):
            raise TypeError("Expected argument 'filter_by_categories' to be a list")
        pulumi.set(__self__, "filter_by_categories", filter_by_categories)
        if filter_by_resource_groups and not isinstance(filter_by_resource_groups, list):
            raise TypeError("Expected argument 'filter_by_resource_groups' to be a list")
        pulumi.set(__self__, "filter_by_resource_groups", filter_by_resource_groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if recommendations and not isinstance(recommendations, list):
            raise TypeError("Expected argument 'recommendations' to be a list")
        pulumi.set(__self__, "recommendations", recommendations)

    @_builtins.property
    @pulumi.getter(name="filterByCategories")
    def filter_by_categories(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "filter_by_categories")

    @_builtins.property
    @pulumi.getter(name="filterByResourceGroups")
    def filter_by_resource_groups(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "filter_by_resource_groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def recommendations(self) -> Sequence['outputs.GetRecommendationsRecommendationResult']:
        """
        One or more `recommendations` blocks as defined below.
        """
        return pulumi.get(self, "recommendations")


class AwaitableGetRecommendationsResult(GetRecommendationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecommendationsResult(
            filter_by_categories=self.filter_by_categories,
            filter_by_resource_groups=self.filter_by_resource_groups,
            id=self.id,
            recommendations=self.recommendations)


def get_recommendations(filter_by_categories: Optional[Sequence[_builtins.str]] = None,
                        filter_by_resource_groups: Optional[Sequence[_builtins.str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecommendationsResult:
    """
    Use this data source to access information about an existing Advisor Recommendations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.advisor.get_recommendations(filter_by_categories=[
            "security",
            "cost",
        ],
        filter_by_resource_groups=["example-resgroups"])
    pulumi.export("recommendations", example.recommendations)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Advisor` - 2023-01-01


    :param Sequence[_builtins.str] filter_by_categories: Specifies a list of categories in which the Advisor Recommendations will be listed. Possible values are `HighAvailability`, `Security`, `Performance`, `Cost` and `OperationalExcellence`.
    :param Sequence[_builtins.str] filter_by_resource_groups: Specifies a list of resource groups about which the Advisor Recommendations will be listed.
    """
    __args__ = dict()
    __args__['filterByCategories'] = filter_by_categories
    __args__['filterByResourceGroups'] = filter_by_resource_groups
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:advisor/getRecommendations:getRecommendations', __args__, opts=opts, typ=GetRecommendationsResult).value

    return AwaitableGetRecommendationsResult(
        filter_by_categories=pulumi.get(__ret__, 'filter_by_categories'),
        filter_by_resource_groups=pulumi.get(__ret__, 'filter_by_resource_groups'),
        id=pulumi.get(__ret__, 'id'),
        recommendations=pulumi.get(__ret__, 'recommendations'))
def get_recommendations_output(filter_by_categories: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               filter_by_resource_groups: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRecommendationsResult]:
    """
    Use this data source to access information about an existing Advisor Recommendations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.advisor.get_recommendations(filter_by_categories=[
            "security",
            "cost",
        ],
        filter_by_resource_groups=["example-resgroups"])
    pulumi.export("recommendations", example.recommendations)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Advisor` - 2023-01-01


    :param Sequence[_builtins.str] filter_by_categories: Specifies a list of categories in which the Advisor Recommendations will be listed. Possible values are `HighAvailability`, `Security`, `Performance`, `Cost` and `OperationalExcellence`.
    :param Sequence[_builtins.str] filter_by_resource_groups: Specifies a list of resource groups about which the Advisor Recommendations will be listed.
    """
    __args__ = dict()
    __args__['filterByCategories'] = filter_by_categories
    __args__['filterByResourceGroups'] = filter_by_resource_groups
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:advisor/getRecommendations:getRecommendations', __args__, opts=opts, typ=GetRecommendationsResult)
    return __ret__.apply(lambda __response__: GetRecommendationsResult(
        filter_by_categories=pulumi.get(__response__, 'filter_by_categories'),
        filter_by_resource_groups=pulumi.get(__response__, 'filter_by_resource_groups'),
        id=pulumi.get(__response__, 'id'),
        recommendations=pulumi.get(__response__, 'recommendations')))
