# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApiResult',
    'AwaitableGetApiResult',
    'get_api',
    'get_api_output',
]

@pulumi.output_type
class GetApiResult:
    """
    A collection of values returned by getApi.
    """
    def __init__(__self__, api_management_name=None, description=None, display_name=None, id=None, is_current=None, is_online=None, name=None, path=None, protocols=None, resource_group_name=None, revision=None, service_url=None, soap_pass_through=None, subscription_key_parameter_names=None, subscription_required=None, version=None, version_set_id=None):
        if api_management_name and not isinstance(api_management_name, str):
            raise TypeError("Expected argument 'api_management_name' to be a str")
        pulumi.set(__self__, "api_management_name", api_management_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_current and not isinstance(is_current, bool):
            raise TypeError("Expected argument 'is_current' to be a bool")
        pulumi.set(__self__, "is_current", is_current)
        if is_online and not isinstance(is_online, bool):
            raise TypeError("Expected argument 'is_online' to be a bool")
        pulumi.set(__self__, "is_online", is_online)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if protocols and not isinstance(protocols, list):
            raise TypeError("Expected argument 'protocols' to be a list")
        pulumi.set(__self__, "protocols", protocols)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if revision and not isinstance(revision, str):
            raise TypeError("Expected argument 'revision' to be a str")
        pulumi.set(__self__, "revision", revision)
        if service_url and not isinstance(service_url, str):
            raise TypeError("Expected argument 'service_url' to be a str")
        pulumi.set(__self__, "service_url", service_url)
        if soap_pass_through and not isinstance(soap_pass_through, bool):
            raise TypeError("Expected argument 'soap_pass_through' to be a bool")
        pulumi.set(__self__, "soap_pass_through", soap_pass_through)
        if subscription_key_parameter_names and not isinstance(subscription_key_parameter_names, list):
            raise TypeError("Expected argument 'subscription_key_parameter_names' to be a list")
        pulumi.set(__self__, "subscription_key_parameter_names", subscription_key_parameter_names)
        if subscription_required and not isinstance(subscription_required, bool):
            raise TypeError("Expected argument 'subscription_required' to be a bool")
        pulumi.set(__self__, "subscription_required", subscription_required)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if version_set_id and not isinstance(version_set_id, str):
            raise TypeError("Expected argument 'version_set_id' to be a str")
        pulumi.set(__self__, "version_set_id", version_set_id)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> _builtins.str:
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the API Management API, which may include HTML formatting tags.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the API.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCurrent")
    def is_current(self) -> _builtins.bool:
        """
        Is this the current API Revision?
        """
        return pulumi.get(self, "is_current")

    @_builtins.property
    @pulumi.getter(name="isOnline")
    def is_online(self) -> _builtins.bool:
        """
        Is this API Revision online/accessible via the Gateway?
        """
        return pulumi.get(self, "is_online")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The Path for this API Management API.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Sequence[_builtins.str]:
        """
        A list of protocols the operations in this API can be invoked.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.str:
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> _builtins.str:
        """
        Absolute URL of the backend service implementing this API.
        """
        return pulumi.get(self, "service_url")

    @_builtins.property
    @pulumi.getter(name="soapPassThrough")
    def soap_pass_through(self) -> _builtins.bool:
        """
        Should this API expose a SOAP frontend, rather than a HTTP frontend?
        """
        return pulumi.get(self, "soap_pass_through")

    @_builtins.property
    @pulumi.getter(name="subscriptionKeyParameterNames")
    def subscription_key_parameter_names(self) -> Sequence['outputs.GetApiSubscriptionKeyParameterNameResult']:
        """
        A `subscription_key_parameter_names` block as documented below.
        """
        return pulumi.get(self, "subscription_key_parameter_names")

    @_builtins.property
    @pulumi.getter(name="subscriptionRequired")
    def subscription_required(self) -> _builtins.bool:
        """
        Should this API require a subscription key?
        """
        return pulumi.get(self, "subscription_required")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Version number of this API, if this API is versioned.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionSetId")
    def version_set_id(self) -> _builtins.str:
        """
        The ID of the Version Set which this API is associated with.
        """
        return pulumi.get(self, "version_set_id")


class AwaitableGetApiResult(GetApiResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiResult(
            api_management_name=self.api_management_name,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            is_current=self.is_current,
            is_online=self.is_online,
            name=self.name,
            path=self.path,
            protocols=self.protocols,
            resource_group_name=self.resource_group_name,
            revision=self.revision,
            service_url=self.service_url,
            soap_pass_through=self.soap_pass_through,
            subscription_key_parameter_names=self.subscription_key_parameter_names,
            subscription_required=self.subscription_required,
            version=self.version,
            version_set_id=self.version_set_id)


def get_api(api_management_name: Optional[_builtins.str] = None,
            name: Optional[_builtins.str] = None,
            resource_group_name: Optional[_builtins.str] = None,
            revision: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiResult:
    """
    Use this data source to access information about an existing API Management API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_api(name="search-api",
        api_management_name="search-api-management",
        resource_group_name="search-service",
        revision="2")
    pulumi.export("apiManagementApiId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2022-08-01


    :param _builtins.str api_management_name: The name of the API Management Service in which the API Management API exists.
    :param _builtins.str name: The name of the API Management API.
    :param _builtins.str resource_group_name: The Name of the Resource Group in which the API Management Service exists.
    :param _builtins.str revision: The Revision of the API Management API.
    """
    __args__ = dict()
    __args__['apiManagementName'] = api_management_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['revision'] = revision
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:apimanagement/getApi:getApi', __args__, opts=opts, typ=GetApiResult).value

    return AwaitableGetApiResult(
        api_management_name=pulumi.get(__ret__, 'api_management_name'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        is_current=pulumi.get(__ret__, 'is_current'),
        is_online=pulumi.get(__ret__, 'is_online'),
        name=pulumi.get(__ret__, 'name'),
        path=pulumi.get(__ret__, 'path'),
        protocols=pulumi.get(__ret__, 'protocols'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        revision=pulumi.get(__ret__, 'revision'),
        service_url=pulumi.get(__ret__, 'service_url'),
        soap_pass_through=pulumi.get(__ret__, 'soap_pass_through'),
        subscription_key_parameter_names=pulumi.get(__ret__, 'subscription_key_parameter_names'),
        subscription_required=pulumi.get(__ret__, 'subscription_required'),
        version=pulumi.get(__ret__, 'version'),
        version_set_id=pulumi.get(__ret__, 'version_set_id'))
def get_api_output(api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                   name: Optional[pulumi.Input[_builtins.str]] = None,
                   resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                   revision: Optional[pulumi.Input[_builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiResult]:
    """
    Use this data source to access information about an existing API Management API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_api(name="search-api",
        api_management_name="search-api-management",
        resource_group_name="search-service",
        revision="2")
    pulumi.export("apiManagementApiId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2022-08-01


    :param _builtins.str api_management_name: The name of the API Management Service in which the API Management API exists.
    :param _builtins.str name: The name of the API Management API.
    :param _builtins.str resource_group_name: The Name of the Resource Group in which the API Management Service exists.
    :param _builtins.str revision: The Revision of the API Management API.
    """
    __args__ = dict()
    __args__['apiManagementName'] = api_management_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['revision'] = revision
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:apimanagement/getApi:getApi', __args__, opts=opts, typ=GetApiResult)
    return __ret__.apply(lambda __response__: GetApiResult(
        api_management_name=pulumi.get(__response__, 'api_management_name'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        is_current=pulumi.get(__response__, 'is_current'),
        is_online=pulumi.get(__response__, 'is_online'),
        name=pulumi.get(__response__, 'name'),
        path=pulumi.get(__response__, 'path'),
        protocols=pulumi.get(__response__, 'protocols'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        revision=pulumi.get(__response__, 'revision'),
        service_url=pulumi.get(__response__, 'service_url'),
        soap_pass_through=pulumi.get(__response__, 'soap_pass_through'),
        subscription_key_parameter_names=pulumi.get(__response__, 'subscription_key_parameter_names'),
        subscription_required=pulumi.get(__response__, 'subscription_required'),
        version=pulumi.get(__response__, 'version'),
        version_set_id=pulumi.get(__response__, 'version_set_id')))
