# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, additional_locations=None, developer_portal_url=None, gateway_regional_url=None, gateway_url=None, hostname_configurations=None, id=None, identities=None, location=None, management_api_url=None, name=None, notification_sender_email=None, portal_url=None, private_ip_addresses=None, public_ip_address_id=None, public_ip_addresses=None, publisher_email=None, publisher_name=None, resource_group_name=None, scm_url=None, sku_name=None, tags=None, tenant_accesses=None):
        if additional_locations and not isinstance(additional_locations, list):
            raise TypeError("Expected argument 'additional_locations' to be a list")
        pulumi.set(__self__, "additional_locations", additional_locations)
        if developer_portal_url and not isinstance(developer_portal_url, str):
            raise TypeError("Expected argument 'developer_portal_url' to be a str")
        pulumi.set(__self__, "developer_portal_url", developer_portal_url)
        if gateway_regional_url and not isinstance(gateway_regional_url, str):
            raise TypeError("Expected argument 'gateway_regional_url' to be a str")
        pulumi.set(__self__, "gateway_regional_url", gateway_regional_url)
        if gateway_url and not isinstance(gateway_url, str):
            raise TypeError("Expected argument 'gateway_url' to be a str")
        pulumi.set(__self__, "gateway_url", gateway_url)
        if hostname_configurations and not isinstance(hostname_configurations, list):
            raise TypeError("Expected argument 'hostname_configurations' to be a list")
        pulumi.set(__self__, "hostname_configurations", hostname_configurations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if management_api_url and not isinstance(management_api_url, str):
            raise TypeError("Expected argument 'management_api_url' to be a str")
        pulumi.set(__self__, "management_api_url", management_api_url)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notification_sender_email and not isinstance(notification_sender_email, str):
            raise TypeError("Expected argument 'notification_sender_email' to be a str")
        pulumi.set(__self__, "notification_sender_email", notification_sender_email)
        if portal_url and not isinstance(portal_url, str):
            raise TypeError("Expected argument 'portal_url' to be a str")
        pulumi.set(__self__, "portal_url", portal_url)
        if private_ip_addresses and not isinstance(private_ip_addresses, list):
            raise TypeError("Expected argument 'private_ip_addresses' to be a list")
        pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if public_ip_address_id and not isinstance(public_ip_address_id, str):
            raise TypeError("Expected argument 'public_ip_address_id' to be a str")
        pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        if public_ip_addresses and not isinstance(public_ip_addresses, list):
            raise TypeError("Expected argument 'public_ip_addresses' to be a list")
        pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        if publisher_email and not isinstance(publisher_email, str):
            raise TypeError("Expected argument 'publisher_email' to be a str")
        pulumi.set(__self__, "publisher_email", publisher_email)
        if publisher_name and not isinstance(publisher_name, str):
            raise TypeError("Expected argument 'publisher_name' to be a str")
        pulumi.set(__self__, "publisher_name", publisher_name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scm_url and not isinstance(scm_url, str):
            raise TypeError("Expected argument 'scm_url' to be a str")
        pulumi.set(__self__, "scm_url", scm_url)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tenant_accesses and not isinstance(tenant_accesses, list):
            raise TypeError("Expected argument 'tenant_accesses' to be a list")
        pulumi.set(__self__, "tenant_accesses", tenant_accesses)

    @_builtins.property
    @pulumi.getter(name="additionalLocations")
    def additional_locations(self) -> Sequence['outputs.GetServiceAdditionalLocationResult']:
        """
        Zero or more `additional_location` blocks as defined below
        """
        return pulumi.get(self, "additional_locations")

    @_builtins.property
    @pulumi.getter(name="developerPortalUrl")
    def developer_portal_url(self) -> _builtins.str:
        """
        The URL for the Developer Portal associated with this API Management service.
        """
        return pulumi.get(self, "developer_portal_url")

    @_builtins.property
    @pulumi.getter(name="gatewayRegionalUrl")
    def gateway_regional_url(self) -> _builtins.str:
        """
        Gateway URL of the API Management service in the Region.
        """
        return pulumi.get(self, "gateway_regional_url")

    @_builtins.property
    @pulumi.getter(name="gatewayUrl")
    def gateway_url(self) -> _builtins.str:
        """
        The URL for the API Management Service's Gateway.
        """
        return pulumi.get(self, "gateway_url")

    @_builtins.property
    @pulumi.getter(name="hostnameConfigurations")
    def hostname_configurations(self) -> Sequence['outputs.GetServiceHostnameConfigurationResult']:
        """
        A `hostname_configuration` block as defined below.
        """
        return pulumi.get(self, "hostname_configurations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetServiceIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The location name of the additional region among Azure Data center regions.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managementApiUrl")
    def management_api_url(self) -> _builtins.str:
        """
        The URL for the Management API.
        """
        return pulumi.get(self, "management_api_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationSenderEmail")
    def notification_sender_email(self) -> _builtins.str:
        """
        The email address from which the notification will be sent.
        """
        return pulumi.get(self, "notification_sender_email")

    @_builtins.property
    @pulumi.getter(name="portalUrl")
    def portal_url(self) -> _builtins.str:
        """
        The URL of the Publisher Portal.
        """
        return pulumi.get(self, "portal_url")

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        Private IP addresses of the API Management service in the additional location, for instances using virtual network mode.
        """
        return pulumi.get(self, "private_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> _builtins.str:
        """
        ID of the standard SKU IPv4 Public IP. Available only for Premium SKU deployed in a virtual network.
        """
        return pulumi.get(self, "public_ip_address_id")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="publisherEmail")
    def publisher_email(self) -> _builtins.str:
        """
        The email of Publisher/Company of the API Management Service.
        """
        return pulumi.get(self, "publisher_email")

    @_builtins.property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> _builtins.str:
        """
        The name of the Publisher/Company of the API Management Service.
        """
        return pulumi.get(self, "publisher_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scmUrl")
    def scm_url(self) -> _builtins.str:
        """
        The SCM (Source Code Management) endpoint.
        """
        return pulumi.get(self, "scm_url")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> _builtins.str:
        """
        The SKU of the API Management Service consisting of the name and capacity, separated by an underscore.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantAccesses")
    def tenant_accesses(self) -> Sequence['outputs.GetServiceTenantAccessResult']:
        """
        A `tenant_access` block as defined below.
        """
        return pulumi.get(self, "tenant_accesses")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            additional_locations=self.additional_locations,
            developer_portal_url=self.developer_portal_url,
            gateway_regional_url=self.gateway_regional_url,
            gateway_url=self.gateway_url,
            hostname_configurations=self.hostname_configurations,
            id=self.id,
            identities=self.identities,
            location=self.location,
            management_api_url=self.management_api_url,
            name=self.name,
            notification_sender_email=self.notification_sender_email,
            portal_url=self.portal_url,
            private_ip_addresses=self.private_ip_addresses,
            public_ip_address_id=self.public_ip_address_id,
            public_ip_addresses=self.public_ip_addresses,
            publisher_email=self.publisher_email,
            publisher_name=self.publisher_name,
            resource_group_name=self.resource_group_name,
            scm_url=self.scm_url,
            sku_name=self.sku_name,
            tags=self.tags,
            tenant_accesses=self.tenant_accesses)


def get_service(name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                tags: Optional[Mapping[str, _builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Use this data source to access information about an existing API Management Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_service(name="search-api",
        resource_group_name="search-service")
    pulumi.export("apiManagementId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2024-05-01, 2022-08-01


    :param _builtins.str name: The name of the API Management service.
    :param _builtins.str resource_group_name: The Name of the Resource Group in which the API Management Service exists.
    :param Mapping[str, _builtins.str] tags: A mapping of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:apimanagement/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        additional_locations=pulumi.get(__ret__, 'additional_locations'),
        developer_portal_url=pulumi.get(__ret__, 'developer_portal_url'),
        gateway_regional_url=pulumi.get(__ret__, 'gateway_regional_url'),
        gateway_url=pulumi.get(__ret__, 'gateway_url'),
        hostname_configurations=pulumi.get(__ret__, 'hostname_configurations'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        management_api_url=pulumi.get(__ret__, 'management_api_url'),
        name=pulumi.get(__ret__, 'name'),
        notification_sender_email=pulumi.get(__ret__, 'notification_sender_email'),
        portal_url=pulumi.get(__ret__, 'portal_url'),
        private_ip_addresses=pulumi.get(__ret__, 'private_ip_addresses'),
        public_ip_address_id=pulumi.get(__ret__, 'public_ip_address_id'),
        public_ip_addresses=pulumi.get(__ret__, 'public_ip_addresses'),
        publisher_email=pulumi.get(__ret__, 'publisher_email'),
        publisher_name=pulumi.get(__ret__, 'publisher_name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        scm_url=pulumi.get(__ret__, 'scm_url'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        tags=pulumi.get(__ret__, 'tags'),
        tenant_accesses=pulumi.get(__ret__, 'tenant_accesses'))
def get_service_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Use this data source to access information about an existing API Management Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_service(name="search-api",
        resource_group_name="search-service")
    pulumi.export("apiManagementId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2024-05-01, 2022-08-01


    :param _builtins.str name: The name of the API Management service.
    :param _builtins.str resource_group_name: The Name of the Resource Group in which the API Management Service exists.
    :param Mapping[str, _builtins.str] tags: A mapping of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:apimanagement/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        additional_locations=pulumi.get(__response__, 'additional_locations'),
        developer_portal_url=pulumi.get(__response__, 'developer_portal_url'),
        gateway_regional_url=pulumi.get(__response__, 'gateway_regional_url'),
        gateway_url=pulumi.get(__response__, 'gateway_url'),
        hostname_configurations=pulumi.get(__response__, 'hostname_configurations'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        management_api_url=pulumi.get(__response__, 'management_api_url'),
        name=pulumi.get(__response__, 'name'),
        notification_sender_email=pulumi.get(__response__, 'notification_sender_email'),
        portal_url=pulumi.get(__response__, 'portal_url'),
        private_ip_addresses=pulumi.get(__response__, 'private_ip_addresses'),
        public_ip_address_id=pulumi.get(__response__, 'public_ip_address_id'),
        public_ip_addresses=pulumi.get(__response__, 'public_ip_addresses'),
        publisher_email=pulumi.get(__response__, 'publisher_email'),
        publisher_name=pulumi.get(__response__, 'publisher_name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        scm_url=pulumi.get(__response__, 'scm_url'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        tags=pulumi.get(__response__, 'tags'),
        tenant_accesses=pulumi.get(__response__, 'tenant_accesses')))
