# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, api_management_name=None, email=None, first_name=None, id=None, last_name=None, note=None, resource_group_name=None, state=None, user_id=None):
        if api_management_name and not isinstance(api_management_name, str):
            raise TypeError("Expected argument 'api_management_name' to be a str")
        pulumi.set(__self__, "api_management_name", api_management_name)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if note and not isinstance(note, str):
            raise TypeError("Expected argument 'note' to be a str")
        pulumi.set(__self__, "note", note)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> _builtins.str:
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The Email Address used for this User.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        """
        The First Name for the User.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        """
        The Last Name for the User.
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def note(self) -> _builtins.str:
        """
        Any notes about this User.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of this User, for example `active`, `blocked` or `pending`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        return pulumi.get(self, "user_id")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            api_management_name=self.api_management_name,
            email=self.email,
            first_name=self.first_name,
            id=self.id,
            last_name=self.last_name,
            note=self.note,
            resource_group_name=self.resource_group_name,
            state=self.state,
            user_id=self.user_id)


def get_user(api_management_name: Optional[_builtins.str] = None,
             resource_group_name: Optional[_builtins.str] = None,
             user_id: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Use this data source to access information about an existing API Management User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_user(user_id="my-user",
        api_management_name="example-apim",
        resource_group_name="search-service")
    pulumi.export("notes", example.notes)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2022-08-01


    :param _builtins.str api_management_name: The Name of the API Management Service in which this User exists.
    :param _builtins.str resource_group_name: The Name of the Resource Group in which the API Management Service exists.
    :param _builtins.str user_id: The Identifier for the User.
    """
    __args__ = dict()
    __args__['apiManagementName'] = api_management_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:apimanagement/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        api_management_name=pulumi.get(__ret__, 'api_management_name'),
        email=pulumi.get(__ret__, 'email'),
        first_name=pulumi.get(__ret__, 'first_name'),
        id=pulumi.get(__ret__, 'id'),
        last_name=pulumi.get(__ret__, 'last_name'),
        note=pulumi.get(__ret__, 'note'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        state=pulumi.get(__ret__, 'state'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_user_output(api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                    resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                    user_id: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    Use this data source to access information about an existing API Management User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_user(user_id="my-user",
        api_management_name="example-apim",
        resource_group_name="search-service")
    pulumi.export("notes", example.notes)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2022-08-01


    :param _builtins.str api_management_name: The Name of the API Management Service in which this User exists.
    :param _builtins.str resource_group_name: The Name of the Resource Group in which the API Management Service exists.
    :param _builtins.str user_id: The Identifier for the User.
    """
    __args__ = dict()
    __args__['apiManagementName'] = api_management_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:apimanagement/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        api_management_name=pulumi.get(__response__, 'api_management_name'),
        email=pulumi.get(__response__, 'email'),
        first_name=pulumi.get(__response__, 'first_name'),
        id=pulumi.get(__response__, 'id'),
        last_name=pulumi.get(__response__, 'last_name'),
        note=pulumi.get(__response__, 'note'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        state=pulumi.get(__response__, 'state'),
        user_id=pulumi.get(__response__, 'user_id')))
