# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IdentityProviderTwitterArgs', 'IdentityProviderTwitter']

@pulumi.input_type
class IdentityProviderTwitterArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[_builtins.str],
                 api_management_name: pulumi.Input[_builtins.str],
                 api_secret_key: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a IdentityProviderTwitter resource.
        :param pulumi.Input[_builtins.str] api_key: App Consumer API key for Twitter.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Twitter Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_secret_key: App Consumer API secret key for Twitter.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "api_secret_key", api_secret_key)
        pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[_builtins.str]:
        """
        App Consumer API key for Twitter.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the API Management Service where this Twitter Identity Provider should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="apiSecretKey")
    def api_secret_key(self) -> pulumi.Input[_builtins.str]:
        """
        App Consumer API secret key for Twitter.
        """
        return pulumi.get(self, "api_secret_key")

    @api_secret_key.setter
    def api_secret_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_secret_key", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.input_type
class _IdentityProviderTwitterState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 api_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IdentityProviderTwitter resources.
        :param pulumi.Input[_builtins.str] api_key: App Consumer API key for Twitter.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Twitter Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_secret_key: App Consumer API secret key for Twitter.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if api_secret_key is not None:
            pulumi.set(__self__, "api_secret_key", api_secret_key)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App Consumer API key for Twitter.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the API Management Service where this Twitter Identity Provider should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="apiSecretKey")
    def api_secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App Consumer API secret key for Twitter.
        """
        return pulumi.get(self, "api_secret_key")

    @api_secret_key.setter
    def api_secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_secret_key", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:apimanagement/identityProviderTwitter:IdentityProviderTwitter")
class IdentityProviderTwitter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 api_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Management Twitter Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@mycompany.io",
            sku_name="Developer_1")
        example_identity_provider_twitter = azure.apimanagement.IdentityProviderTwitter("example",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            api_key="00000000000000000000000000000000",
            api_secret_key="00000000000000000000000000000000")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2022-08-01

        ## Import

        API Management Twitter Identity Provider can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/identityProviderTwitter:IdentityProviderTwitter example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/identityProviders/twitter
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: App Consumer API key for Twitter.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Twitter Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_secret_key: App Consumer API secret key for Twitter.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityProviderTwitterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Management Twitter Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@mycompany.io",
            sku_name="Developer_1")
        example_identity_provider_twitter = azure.apimanagement.IdentityProviderTwitter("example",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            api_key="00000000000000000000000000000000",
            api_secret_key="00000000000000000000000000000000")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2022-08-01

        ## Import

        API Management Twitter Identity Provider can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/identityProviderTwitter:IdentityProviderTwitter example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/identityProviders/twitter
        ```

        :param str resource_name: The name of the resource.
        :param IdentityProviderTwitterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityProviderTwitterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 api_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityProviderTwitterArgs.__new__(IdentityProviderTwitterArgs)

            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            if api_secret_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_secret_key'")
            __props__.__dict__["api_secret_key"] = None if api_secret_key is None else pulumi.Output.secret(api_secret_key)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "apiSecretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IdentityProviderTwitter, __self__).__init__(
            'azure:apimanagement/identityProviderTwitter:IdentityProviderTwitter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
            api_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'IdentityProviderTwitter':
        """
        Get an existing IdentityProviderTwitter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: App Consumer API key for Twitter.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Twitter Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_secret_key: App Consumer API secret key for Twitter.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityProviderTwitterState.__new__(_IdentityProviderTwitterState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["api_secret_key"] = api_secret_key
        __props__.__dict__["resource_group_name"] = resource_group_name
        return IdentityProviderTwitter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[_builtins.str]:
        """
        App Consumer API key for Twitter.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the API Management Service where this Twitter Identity Provider should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter(name="apiSecretKey")
    def api_secret_key(self) -> pulumi.Output[_builtins.str]:
        """
        App Consumer API secret key for Twitter.
        """
        return pulumi.get(self, "api_secret_key")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

