# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceApiVersionSetArgs', 'WorkspaceApiVersionSet']

@pulumi.input_type
class WorkspaceApiVersionSetArgs:
    def __init__(__self__, *,
                 api_management_workspace_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 versioning_scheme: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_query_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceApiVersionSet resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the API Management Workspace API Version Set.
        :param pulumi.Input[_builtins.str] versioning_scheme: Specifies where in a request that the API Version should be read from. Possible values are `Header`, `Query` and `Segment`.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the API Management Workspace API Version Set.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace API Version Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] version_header_name: Specifies the name of the header to read from inbound requests to determine the API version.
        :param pulumi.Input[_builtins.str] version_query_name: Specifies the name of the query string parameter to read from inbound requests to determine the API version.
        """
        pulumi.set(__self__, "api_management_workspace_id", api_management_workspace_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "versioning_scheme", versioning_scheme)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version_header_name is not None:
            pulumi.set(__self__, "version_header_name", version_header_name)
        if version_query_name is not None:
            pulumi.set(__self__, "version_query_name", version_query_name)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @api_management_workspace_id.setter
    def api_management_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the display name of the API Management Workspace API Version Set.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="versioningScheme")
    def versioning_scheme(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies where in a request that the API Version should be read from. Possible values are `Header`, `Query` and `Segment`.
        """
        return pulumi.get(self, "versioning_scheme")

    @versioning_scheme.setter
    def versioning_scheme(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "versioning_scheme", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the API Management Workspace API Version Set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the API Management Workspace API Version Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="versionHeaderName")
    def version_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the header to read from inbound requests to determine the API version.
        """
        return pulumi.get(self, "version_header_name")

    @version_header_name.setter
    def version_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_header_name", value)

    @_builtins.property
    @pulumi.getter(name="versionQueryName")
    def version_query_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the query string parameter to read from inbound requests to determine the API version.
        """
        return pulumi.get(self, "version_query_name")

    @version_query_name.setter
    def version_query_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_query_name", value)


@pulumi.input_type
class _WorkspaceApiVersionSetState:
    def __init__(__self__, *,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 versioning_scheme: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceApiVersionSet resources.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the API Management Workspace API Version Set.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the API Management Workspace API Version Set.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace API Version Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] version_header_name: Specifies the name of the header to read from inbound requests to determine the API version.
        :param pulumi.Input[_builtins.str] version_query_name: Specifies the name of the query string parameter to read from inbound requests to determine the API version.
        :param pulumi.Input[_builtins.str] versioning_scheme: Specifies where in a request that the API Version should be read from. Possible values are `Header`, `Query` and `Segment`.
        """
        if api_management_workspace_id is not None:
            pulumi.set(__self__, "api_management_workspace_id", api_management_workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version_header_name is not None:
            pulumi.set(__self__, "version_header_name", version_header_name)
        if version_query_name is not None:
            pulumi.set(__self__, "version_query_name", version_query_name)
        if versioning_scheme is not None:
            pulumi.set(__self__, "versioning_scheme", versioning_scheme)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @api_management_workspace_id.setter
    def api_management_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the API Management Workspace API Version Set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the display name of the API Management Workspace API Version Set.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the API Management Workspace API Version Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="versionHeaderName")
    def version_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the header to read from inbound requests to determine the API version.
        """
        return pulumi.get(self, "version_header_name")

    @version_header_name.setter
    def version_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_header_name", value)

    @_builtins.property
    @pulumi.getter(name="versionQueryName")
    def version_query_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the query string parameter to read from inbound requests to determine the API version.
        """
        return pulumi.get(self, "version_query_name")

    @version_query_name.setter
    def version_query_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_query_name", value)

    @_builtins.property
    @pulumi.getter(name="versioningScheme")
    def versioning_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies where in a request that the API Version should be read from. Possible values are `Header`, `Query` and `Segment`.
        """
        return pulumi.get(self, "versioning_scheme")

    @versioning_scheme.setter
    def versioning_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "versioning_scheme", value)


@pulumi.type_token("azure:apimanagement/workspaceApiVersionSet:WorkspaceApiVersionSet")
class WorkspaceApiVersionSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 versioning_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Version Set within an API Management Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="Example Publisher",
            publisher_email="publisher@example.com",
            sku_name="Premium_1")
        example_workspace = azure.apimanagement.Workspace("example",
            name="example-workspace",
            api_management_id=example_service.id,
            display_name="Example Workspace",
            description="Example workspace for development")
        example_workspace_api_version_set = azure.apimanagement.WorkspaceApiVersionSet("example",
            name="example-version-set",
            api_management_workspace_id=example_workspace.id,
            display_name="Example API Version Set",
            versioning_scheme="Segment")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Workspace API Version Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/workspaceApiVersionSet:WorkspaceApiVersionSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/workspaces/workspace1/apiVersionSets/set1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the API Management Workspace API Version Set.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the API Management Workspace API Version Set.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace API Version Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] version_header_name: Specifies the name of the header to read from inbound requests to determine the API version.
        :param pulumi.Input[_builtins.str] version_query_name: Specifies the name of the query string parameter to read from inbound requests to determine the API version.
        :param pulumi.Input[_builtins.str] versioning_scheme: Specifies where in a request that the API Version should be read from. Possible values are `Header`, `Query` and `Segment`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceApiVersionSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Version Set within an API Management Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="Example Publisher",
            publisher_email="publisher@example.com",
            sku_name="Premium_1")
        example_workspace = azure.apimanagement.Workspace("example",
            name="example-workspace",
            api_management_id=example_service.id,
            display_name="Example Workspace",
            description="Example workspace for development")
        example_workspace_api_version_set = azure.apimanagement.WorkspaceApiVersionSet("example",
            name="example-version-set",
            api_management_workspace_id=example_workspace.id,
            display_name="Example API Version Set",
            versioning_scheme="Segment")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Workspace API Version Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/workspaceApiVersionSet:WorkspaceApiVersionSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/workspaces/workspace1/apiVersionSets/set1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceApiVersionSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceApiVersionSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_query_name: Optional[pulumi.Input[_builtins.str]] = None,
                 versioning_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceApiVersionSetArgs.__new__(WorkspaceApiVersionSetArgs)

            if api_management_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_workspace_id'")
            __props__.__dict__["api_management_workspace_id"] = api_management_workspace_id
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["name"] = name
            __props__.__dict__["version_header_name"] = version_header_name
            __props__.__dict__["version_query_name"] = version_query_name
            if versioning_scheme is None and not opts.urn:
                raise TypeError("Missing required property 'versioning_scheme'")
            __props__.__dict__["versioning_scheme"] = versioning_scheme
        super(WorkspaceApiVersionSet, __self__).__init__(
            'azure:apimanagement/workspaceApiVersionSet:WorkspaceApiVersionSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            version_header_name: Optional[pulumi.Input[_builtins.str]] = None,
            version_query_name: Optional[pulumi.Input[_builtins.str]] = None,
            versioning_scheme: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceApiVersionSet':
        """
        Get an existing WorkspaceApiVersionSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the API Management Workspace API Version Set.
        :param pulumi.Input[_builtins.str] display_name: Specifies the display name of the API Management Workspace API Version Set.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace API Version Set. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] version_header_name: Specifies the name of the header to read from inbound requests to determine the API version.
        :param pulumi.Input[_builtins.str] version_query_name: Specifies the name of the query string parameter to read from inbound requests to determine the API version.
        :param pulumi.Input[_builtins.str] versioning_scheme: Specifies where in a request that the API Version should be read from. Possible values are `Header`, `Query` and `Segment`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceApiVersionSetState.__new__(_WorkspaceApiVersionSetState)

        __props__.__dict__["api_management_workspace_id"] = api_management_workspace_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["version_header_name"] = version_header_name
        __props__.__dict__["version_query_name"] = version_query_name
        __props__.__dict__["versioning_scheme"] = versioning_scheme
        return WorkspaceApiVersionSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the API Management Workspace API Version Set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the display name of the API Management Workspace API Version Set.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the API Management Workspace API Version Set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="versionHeaderName")
    def version_header_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the header to read from inbound requests to determine the API version.
        """
        return pulumi.get(self, "version_header_name")

    @_builtins.property
    @pulumi.getter(name="versionQueryName")
    def version_query_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the query string parameter to read from inbound requests to determine the API version.
        """
        return pulumi.get(self, "version_query_name")

    @_builtins.property
    @pulumi.getter(name="versioningScheme")
    def versioning_scheme(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies where in a request that the API Version should be read from. Possible values are `Header`, `Query` and `Segment`.
        """
        return pulumi.get(self, "versioning_scheme")

