# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceCertificateArgs', 'WorkspaceCertificate']

@pulumi.input_type
class WorkspaceCertificateArgs:
    def __init__(__self__, *,
                 api_management_workspace_id: pulumi.Input[_builtins.str],
                 certificate_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceCertificate resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_data_base64: Specifies the base64-encoded string containing the certificate in PKCS#12 (.pfx) format.
               
               > **Note:** This is required when `password` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: Specifies the ID of the key vault secret.
               
               > **Note:** This is required when `user_assigned_identity_client_id` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] password: Specifies the password used to access the `certificate_data_base64`.
        :param pulumi.Input[_builtins.str] user_assigned_identity_client_id: Specifies the client ID of user-assigned identity to be used for accessing the `key_vault_secret_id`.
        """
        pulumi.set(__self__, "api_management_workspace_id", api_management_workspace_id)
        if certificate_data_base64 is not None:
            pulumi.set(__self__, "certificate_data_base64", certificate_data_base64)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_assigned_identity_client_id is not None:
            pulumi.set(__self__, "user_assigned_identity_client_id", user_assigned_identity_client_id)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @api_management_workspace_id.setter
    def api_management_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateDataBase64")
    def certificate_data_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the base64-encoded string containing the certificate in PKCS#12 (.pfx) format.

        > **Note:** This is required when `password` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        """
        return pulumi.get(self, "certificate_data_base64")

    @certificate_data_base64.setter
    def certificate_data_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_data_base64", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the key vault secret.

        > **Note:** This is required when `user_assigned_identity_client_id` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the API Management Workspace Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password used to access the `certificate_data_base64`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityClientId")
    def user_assigned_identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the client ID of user-assigned identity to be used for accessing the `key_vault_secret_id`.
        """
        return pulumi.get(self, "user_assigned_identity_client_id")

    @user_assigned_identity_client_id.setter
    def user_assigned_identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_assigned_identity_client_id", value)


@pulumi.input_type
class _WorkspaceCertificateState:
    def __init__(__self__, *,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 subject: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceCertificate resources.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_data_base64: Specifies the base64-encoded string containing the certificate in PKCS#12 (.pfx) format.
               
               > **Note:** This is required when `password` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        :param pulumi.Input[_builtins.str] expiration: The expiration date of the API Management Workspace Certificate.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: Specifies the ID of the key vault secret.
               
               > **Note:** This is required when `user_assigned_identity_client_id` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] password: Specifies the password used to access the `certificate_data_base64`.
        :param pulumi.Input[_builtins.str] subject: The subject name of the API Management Workspace Certificate.
        :param pulumi.Input[_builtins.str] thumbprint: The thumbprint of the API Management Workspace Certificate.
        :param pulumi.Input[_builtins.str] user_assigned_identity_client_id: Specifies the client ID of user-assigned identity to be used for accessing the `key_vault_secret_id`.
        """
        if api_management_workspace_id is not None:
            pulumi.set(__self__, "api_management_workspace_id", api_management_workspace_id)
        if certificate_data_base64 is not None:
            pulumi.set(__self__, "certificate_data_base64", certificate_data_base64)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if user_assigned_identity_client_id is not None:
            pulumi.set(__self__, "user_assigned_identity_client_id", user_assigned_identity_client_id)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @api_management_workspace_id.setter
    def api_management_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateDataBase64")
    def certificate_data_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the base64-encoded string containing the certificate in PKCS#12 (.pfx) format.

        > **Note:** This is required when `password` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        """
        return pulumi.get(self, "certificate_data_base64")

    @certificate_data_base64.setter
    def certificate_data_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_data_base64", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration date of the API Management Workspace Certificate.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the key vault secret.

        > **Note:** This is required when `user_assigned_identity_client_id` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @key_vault_secret_id.setter
    def key_vault_secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_secret_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the API Management Workspace Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password used to access the `certificate_data_base64`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subject name of the API Management Workspace Certificate.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject", value)

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The thumbprint of the API Management Workspace Certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thumbprint", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityClientId")
    def user_assigned_identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the client ID of user-assigned identity to be used for accessing the `key_vault_secret_id`.
        """
        return pulumi.get(self, "user_assigned_identity_client_id")

    @user_assigned_identity_client_id.setter
    def user_assigned_identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_assigned_identity_client_id", value)


@pulumi.type_token("azure:apimanagement/workspaceCertificate:WorkspaceCertificate")
class WorkspaceCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Certificate within an API Management Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@terraform.io",
            sku_name="Premium_1")
        example_workspace = azure.apimanagement.Workspace("example",
            name="example-workspace",
            api_management_id=example_service.id,
            display_name="Example Workspace")
        example_workspace_certificate = azure.apimanagement.WorkspaceCertificate("example",
            name="example-cert",
            api_management_workspace_id=example_workspace.id,
            certificate_data_base64=std.filebase64(input="example.pfx").result,
            password="terraform")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Workspace Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/workspaceCertificate:WorkspaceCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/workspaces/workspace1/certificates/certificate1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_data_base64: Specifies the base64-encoded string containing the certificate in PKCS#12 (.pfx) format.
               
               > **Note:** This is required when `password` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: Specifies the ID of the key vault secret.
               
               > **Note:** This is required when `user_assigned_identity_client_id` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] password: Specifies the password used to access the `certificate_data_base64`.
        :param pulumi.Input[_builtins.str] user_assigned_identity_client_id: Specifies the client ID of user-assigned identity to be used for accessing the `key_vault_secret_id`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Certificate within an API Management Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@terraform.io",
            sku_name="Premium_1")
        example_workspace = azure.apimanagement.Workspace("example",
            name="example-workspace",
            api_management_id=example_service.id,
            display_name="Example Workspace")
        example_workspace_certificate = azure.apimanagement.WorkspaceCertificate("example",
            name="example-cert",
            api_management_workspace_id=example_workspace.id,
            certificate_data_base64=std.filebase64(input="example.pfx").result,
            password="terraform")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Workspace Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/workspaceCertificate:WorkspaceCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/workspaces/workspace1/certificates/certificate1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceCertificateArgs.__new__(WorkspaceCertificateArgs)

            if api_management_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_workspace_id'")
            __props__.__dict__["api_management_workspace_id"] = api_management_workspace_id
            __props__.__dict__["certificate_data_base64"] = None if certificate_data_base64 is None else pulumi.Output.secret(certificate_data_base64)
            __props__.__dict__["key_vault_secret_id"] = key_vault_secret_id
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["user_assigned_identity_client_id"] = user_assigned_identity_client_id
            __props__.__dict__["expiration"] = None
            __props__.__dict__["subject"] = None
            __props__.__dict__["thumbprint"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["certificateDataBase64", "password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WorkspaceCertificate, __self__).__init__(
            'azure:apimanagement/workspaceCertificate:WorkspaceCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_data_base64: Optional[pulumi.Input[_builtins.str]] = None,
            expiration: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            subject: Optional[pulumi.Input[_builtins.str]] = None,
            thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
            user_assigned_identity_client_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceCertificate':
        """
        Get an existing WorkspaceCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_data_base64: Specifies the base64-encoded string containing the certificate in PKCS#12 (.pfx) format.
               
               > **Note:** This is required when `password` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        :param pulumi.Input[_builtins.str] expiration: The expiration date of the API Management Workspace Certificate.
        :param pulumi.Input[_builtins.str] key_vault_secret_id: Specifies the ID of the key vault secret.
               
               > **Note:** This is required when `user_assigned_identity_client_id` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] password: Specifies the password used to access the `certificate_data_base64`.
        :param pulumi.Input[_builtins.str] subject: The subject name of the API Management Workspace Certificate.
        :param pulumi.Input[_builtins.str] thumbprint: The thumbprint of the API Management Workspace Certificate.
        :param pulumi.Input[_builtins.str] user_assigned_identity_client_id: Specifies the client ID of user-assigned identity to be used for accessing the `key_vault_secret_id`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceCertificateState.__new__(_WorkspaceCertificateState)

        __props__.__dict__["api_management_workspace_id"] = api_management_workspace_id
        __props__.__dict__["certificate_data_base64"] = certificate_data_base64
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["key_vault_secret_id"] = key_vault_secret_id
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["subject"] = subject
        __props__.__dict__["thumbprint"] = thumbprint
        __props__.__dict__["user_assigned_identity_client_id"] = user_assigned_identity_client_id
        return WorkspaceCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @_builtins.property
    @pulumi.getter(name="certificateDataBase64")
    def certificate_data_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the base64-encoded string containing the certificate in PKCS#12 (.pfx) format.

        > **Note:** This is required when `password` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        """
        return pulumi.get(self, "certificate_data_base64")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[_builtins.str]:
        """
        The expiration date of the API Management Workspace Certificate.
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the key vault secret.

        > **Note:** This is required when `user_assigned_identity_client_id` is specified. Exactly one of `certificate_data_base64` or `key_vault_secret_id` must be specified.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the API Management Workspace Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the password used to access the `certificate_data_base64`.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> pulumi.Output[_builtins.str]:
        """
        The subject name of the API Management Workspace Certificate.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Output[_builtins.str]:
        """
        The thumbprint of the API Management Workspace Certificate.
        """
        return pulumi.get(self, "thumbprint")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityClientId")
    def user_assigned_identity_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the client ID of user-assigned identity to be used for accessing the `key_vault_secret_id`.
        """
        return pulumi.get(self, "user_assigned_identity_client_id")

