# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspacePolicyArgs', 'WorkspacePolicy']

@pulumi.input_type
class WorkspacePolicyArgs:
    def __init__(__self__, *,
                 api_management_workspace_id: pulumi.Input[_builtins.str],
                 xml_content: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_link: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspacePolicy resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] xml_content: Specifies the API Management Workspace Policy as an XML string.
        :param pulumi.Input[_builtins.str] xml_link: Specifies a publicly accessible URL to a policy XML document.
               
               > **Note:** Exactly one of `xml_content` or `xml_link` must be specified.
        """
        pulumi.set(__self__, "api_management_workspace_id", api_management_workspace_id)
        if xml_content is not None:
            pulumi.set(__self__, "xml_content", xml_content)
        if xml_link is not None:
            pulumi.set(__self__, "xml_link", xml_link)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @api_management_workspace_id.setter
    def api_management_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="xmlContent")
    def xml_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the API Management Workspace Policy as an XML string.
        """
        return pulumi.get(self, "xml_content")

    @xml_content.setter
    def xml_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xml_content", value)

    @_builtins.property
    @pulumi.getter(name="xmlLink")
    def xml_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a publicly accessible URL to a policy XML document.

        > **Note:** Exactly one of `xml_content` or `xml_link` must be specified.
        """
        return pulumi.get(self, "xml_link")

    @xml_link.setter
    def xml_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xml_link", value)


@pulumi.input_type
class _WorkspacePolicyState:
    def __init__(__self__, *,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_content: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_link: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspacePolicy resources.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] xml_content: Specifies the API Management Workspace Policy as an XML string.
        :param pulumi.Input[_builtins.str] xml_link: Specifies a publicly accessible URL to a policy XML document.
               
               > **Note:** Exactly one of `xml_content` or `xml_link` must be specified.
        """
        if api_management_workspace_id is not None:
            pulumi.set(__self__, "api_management_workspace_id", api_management_workspace_id)
        if xml_content is not None:
            pulumi.set(__self__, "xml_content", xml_content)
        if xml_link is not None:
            pulumi.set(__self__, "xml_link", xml_link)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @api_management_workspace_id.setter
    def api_management_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="xmlContent")
    def xml_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the API Management Workspace Policy as an XML string.
        """
        return pulumi.get(self, "xml_content")

    @xml_content.setter
    def xml_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xml_content", value)

    @_builtins.property
    @pulumi.getter(name="xmlLink")
    def xml_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a publicly accessible URL to a policy XML document.

        > **Note:** Exactly one of `xml_content` or `xml_link` must be specified.
        """
        return pulumi.get(self, "xml_link")

    @xml_link.setter
    def xml_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xml_link", value)


@pulumi.type_token("azure:apimanagement/workspacePolicy:WorkspacePolicy")
class WorkspacePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_content: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_link: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Management Workspace Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apimanagement",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Premium_1")
        example_workspace = azure.apimanagement.Workspace("example",
            name="example-workspace",
            api_management_id=example_service.id,
            display_name="my workspace")
        example_workspace_policy = azure.apimanagement.WorkspacePolicy("example",
            api_management_workspace_id=example_workspace.id,
            xml_content=\"\"\"<policies>
          <inbound>
            <find-and-replace from=\\"abc\\" to=\\"xyz\\" />
          </inbound>
        </policies>
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Workspace Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/workspacePolicy:WorkspacePolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] xml_content: Specifies the API Management Workspace Policy as an XML string.
        :param pulumi.Input[_builtins.str] xml_link: Specifies a publicly accessible URL to a policy XML document.
               
               > **Note:** Exactly one of `xml_content` or `xml_link` must be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspacePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Management Workspace Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apimanagement",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Premium_1")
        example_workspace = azure.apimanagement.Workspace("example",
            name="example-workspace",
            api_management_id=example_service.id,
            display_name="my workspace")
        example_workspace_policy = azure.apimanagement.WorkspacePolicy("example",
            api_management_workspace_id=example_workspace.id,
            xml_content=\"\"\"<policies>
          <inbound>
            <find-and-replace from=\\"abc\\" to=\\"xyz\\" />
          </inbound>
        </policies>
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Workspace Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/workspacePolicy:WorkspacePolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspacePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspacePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_content: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_link: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspacePolicyArgs.__new__(WorkspacePolicyArgs)

            if api_management_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_workspace_id'")
            __props__.__dict__["api_management_workspace_id"] = api_management_workspace_id
            __props__.__dict__["xml_content"] = xml_content
            __props__.__dict__["xml_link"] = xml_link
        super(WorkspacePolicy, __self__).__init__(
            'azure:apimanagement/workspacePolicy:WorkspacePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            xml_content: Optional[pulumi.Input[_builtins.str]] = None,
            xml_link: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspacePolicy':
        """
        Get an existing WorkspacePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] xml_content: Specifies the API Management Workspace Policy as an XML string.
        :param pulumi.Input[_builtins.str] xml_link: Specifies a publicly accessible URL to a policy XML document.
               
               > **Note:** Exactly one of `xml_content` or `xml_link` must be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspacePolicyState.__new__(_WorkspacePolicyState)

        __props__.__dict__["api_management_workspace_id"] = api_management_workspace_id
        __props__.__dict__["xml_content"] = xml_content
        __props__.__dict__["xml_link"] = xml_link
        return WorkspacePolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @_builtins.property
    @pulumi.getter(name="xmlContent")
    def xml_content(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the API Management Workspace Policy as an XML string.
        """
        return pulumi.get(self, "xml_content")

    @_builtins.property
    @pulumi.getter(name="xmlLink")
    def xml_link(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a publicly accessible URL to a policy XML document.

        > **Note:** Exactly one of `xml_content` or `xml_link` must be specified.
        """
        return pulumi.get(self, "xml_link")

