# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspacePolicyFragmentArgs', 'WorkspacePolicyFragment']

@pulumi.input_type
class WorkspacePolicyFragmentArgs:
    def __init__(__self__, *,
                 api_management_workspace_id: pulumi.Input[_builtins.str],
                 xml_content: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_format: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspacePolicyFragment resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] xml_content: Specifies the XML content of the API Management Workspace Policy Fragment.
        :param pulumi.Input[_builtins.str] description: Specifies the description for the API Management Workspace Policy Fragment.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace Policy Fragment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] xml_format: Specifies the XML format of the API Management Workspace Policy Fragment. Possible values are `xml` or `rawxml`. Defaults to `xml`.
        """
        pulumi.set(__self__, "api_management_workspace_id", api_management_workspace_id)
        pulumi.set(__self__, "xml_content", xml_content)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if xml_format is not None:
            pulumi.set(__self__, "xml_format", xml_format)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @api_management_workspace_id.setter
    def api_management_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="xmlContent")
    def xml_content(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the XML content of the API Management Workspace Policy Fragment.
        """
        return pulumi.get(self, "xml_content")

    @xml_content.setter
    def xml_content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "xml_content", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description for the API Management Workspace Policy Fragment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the API Management Workspace Policy Fragment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="xmlFormat")
    def xml_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the XML format of the API Management Workspace Policy Fragment. Possible values are `xml` or `rawxml`. Defaults to `xml`.
        """
        return pulumi.get(self, "xml_format")

    @xml_format.setter
    def xml_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xml_format", value)


@pulumi.input_type
class _WorkspacePolicyFragmentState:
    def __init__(__self__, *,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_content: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_format: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspacePolicyFragment resources.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies the description for the API Management Workspace Policy Fragment.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace Policy Fragment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] xml_content: Specifies the XML content of the API Management Workspace Policy Fragment.
        :param pulumi.Input[_builtins.str] xml_format: Specifies the XML format of the API Management Workspace Policy Fragment. Possible values are `xml` or `rawxml`. Defaults to `xml`.
        """
        if api_management_workspace_id is not None:
            pulumi.set(__self__, "api_management_workspace_id", api_management_workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if xml_content is not None:
            pulumi.set(__self__, "xml_content", xml_content)
        if xml_format is not None:
            pulumi.set(__self__, "xml_format", xml_format)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @api_management_workspace_id.setter
    def api_management_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description for the API Management Workspace Policy Fragment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the API Management Workspace Policy Fragment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="xmlContent")
    def xml_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the XML content of the API Management Workspace Policy Fragment.
        """
        return pulumi.get(self, "xml_content")

    @xml_content.setter
    def xml_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xml_content", value)

    @_builtins.property
    @pulumi.getter(name="xmlFormat")
    def xml_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the XML format of the API Management Workspace Policy Fragment. Possible values are `xml` or `rawxml`. Defaults to `xml`.
        """
        return pulumi.get(self, "xml_format")

    @xml_format.setter
    def xml_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xml_format", value)


@pulumi.type_token("azure:apimanagement/workspacePolicyFragment:WorkspacePolicyFragment")
class WorkspacePolicyFragment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_content: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_format: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Management Workspace Policy Fragment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Premium_1")
        example_workspace = azure.apimanagement.Workspace("example",
            name="example-workspace",
            api_management_id=example_service.id,
            display_name="Example Workspace",
            description="Example API Management Workspace")
        example_workspace_policy_fragment = azure.apimanagement.WorkspacePolicyFragment("example",
            name="example-policy-fragment",
            api_management_workspace_id=example_workspace.id,
            xml_format="xml",
            xml_content=std.file(input="policy-fragment-1.xml").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Workspace Policy Fragments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/workspacePolicyFragment:WorkspacePolicyFragment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/instance1/workspaces/workspace1/policyFragments/policyFragment1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies the description for the API Management Workspace Policy Fragment.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace Policy Fragment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] xml_content: Specifies the XML content of the API Management Workspace Policy Fragment.
        :param pulumi.Input[_builtins.str] xml_format: Specifies the XML format of the API Management Workspace Policy Fragment. Possible values are `xml` or `rawxml`. Defaults to `xml`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspacePolicyFragmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Management Workspace Policy Fragment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Premium_1")
        example_workspace = azure.apimanagement.Workspace("example",
            name="example-workspace",
            api_management_id=example_service.id,
            display_name="Example Workspace",
            description="Example API Management Workspace")
        example_workspace_policy_fragment = azure.apimanagement.WorkspacePolicyFragment("example",
            name="example-policy-fragment",
            api_management_workspace_id=example_workspace.id,
            xml_format="xml",
            xml_content=std.file(input="policy-fragment-1.xml").result)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Workspace Policy Fragments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/workspacePolicyFragment:WorkspacePolicyFragment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/instance1/workspaces/workspace1/policyFragments/policyFragment1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspacePolicyFragmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspacePolicyFragmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_content: Optional[pulumi.Input[_builtins.str]] = None,
                 xml_format: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspacePolicyFragmentArgs.__new__(WorkspacePolicyFragmentArgs)

            if api_management_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_workspace_id'")
            __props__.__dict__["api_management_workspace_id"] = api_management_workspace_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if xml_content is None and not opts.urn:
                raise TypeError("Missing required property 'xml_content'")
            __props__.__dict__["xml_content"] = xml_content
            __props__.__dict__["xml_format"] = xml_format
        super(WorkspacePolicyFragment, __self__).__init__(
            'azure:apimanagement/workspacePolicyFragment:WorkspacePolicyFragment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            xml_content: Optional[pulumi.Input[_builtins.str]] = None,
            xml_format: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspacePolicyFragment':
        """
        Get an existing WorkspacePolicyFragment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_workspace_id: Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies the description for the API Management Workspace Policy Fragment.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the API Management Workspace Policy Fragment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] xml_content: Specifies the XML content of the API Management Workspace Policy Fragment.
        :param pulumi.Input[_builtins.str] xml_format: Specifies the XML format of the API Management Workspace Policy Fragment. Possible values are `xml` or `rawxml`. Defaults to `xml`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspacePolicyFragmentState.__new__(_WorkspacePolicyFragmentState)

        __props__.__dict__["api_management_workspace_id"] = api_management_workspace_id
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["xml_content"] = xml_content
        __props__.__dict__["xml_format"] = xml_format
        return WorkspacePolicyFragment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementWorkspaceId")
    def api_management_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the API Management Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_workspace_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description for the API Management Workspace Policy Fragment.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the API Management Workspace Policy Fragment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="xmlContent")
    def xml_content(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the XML content of the API Management Workspace Policy Fragment.
        """
        return pulumi.get(self, "xml_content")

    @_builtins.property
    @pulumi.getter(name="xmlFormat")
    def xml_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the XML format of the API Management Workspace Policy Fragment. Possible values are `xml` or `rawxml`. Defaults to `xml`.
        """
        return pulumi.get(self, "xml_format")

