# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConfigurationKeyResult',
    'AwaitableGetConfigurationKeyResult',
    'get_configuration_key',
    'get_configuration_key_output',
]

@pulumi.output_type
class GetConfigurationKeyResult:
    """
    A collection of values returned by getConfigurationKey.
    """
    def __init__(__self__, configuration_store_id=None, content_type=None, etag=None, id=None, key=None, label=None, locked=None, tags=None, type=None, value=None, vault_key_reference=None):
        if configuration_store_id and not isinstance(configuration_store_id, str):
            raise TypeError("Expected argument 'configuration_store_id' to be a str")
        pulumi.set(__self__, "configuration_store_id", configuration_store_id)
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if locked and not isinstance(locked, bool):
            raise TypeError("Expected argument 'locked' to be a bool")
        pulumi.set(__self__, "locked", locked)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)
        if vault_key_reference and not isinstance(vault_key_reference, str):
            raise TypeError("Expected argument 'vault_key_reference' to be a str")
        pulumi.set(__self__, "vault_key_reference", vault_key_reference)

    @_builtins.property
    @pulumi.getter(name="configurationStoreId")
    def configuration_store_id(self) -> _builtins.str:
        return pulumi.get(self, "configuration_store_id")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        The content type of the App Configuration Key.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        The ETag of the key.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> _builtins.bool:
        """
        Is this App Configuration Key be Locked to prevent changes.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the App Configuration Key. It can either be `kv` (simple [key/value](https://docs.microsoft.com/azure/azure-app-configuration/concept-key-value)) or `vault` (where the value is a reference to a [Key Vault Secret](https://azure.microsoft.com/en-gb/services/key-vault/).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the App Configuration Key.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="vaultKeyReference")
    def vault_key_reference(self) -> _builtins.str:
        """
        The ID of the vault secret this App Configuration Key refers to, when `type` is `vault`.
        """
        return pulumi.get(self, "vault_key_reference")


class AwaitableGetConfigurationKeyResult(GetConfigurationKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationKeyResult(
            configuration_store_id=self.configuration_store_id,
            content_type=self.content_type,
            etag=self.etag,
            id=self.id,
            key=self.key,
            label=self.label,
            locked=self.locked,
            tags=self.tags,
            type=self.type,
            value=self.value,
            vault_key_reference=self.vault_key_reference)


def get_configuration_key(configuration_store_id: Optional[_builtins.str] = None,
                          key: Optional[_builtins.str] = None,
                          label: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationKeyResult:
    """
    Use this data source to access information about an existing Azure App Configuration Key.

    > **Note:** App Configuration Keys are provisioned using a Data Plane API which requires the role `App Configuration Data Owner` on either the App Configuration or a parent scope (such as the Resource Group/Subscription). [More information can be found in the Azure Documentation for App Configuration](https://docs.microsoft.com/azure/azure-app-configuration/concept-enable-rbac#azure-built-in-roles-for-azure-app-configuration).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test = azure.appconfiguration.get_configuration_key(configuration_store_id=appconf["id"],
        key="appConfKey1",
        label="somelabel")
    pulumi.export("value", test.value)
    ```


    :param _builtins.str configuration_store_id: Specifies the id of the App Configuration.
    :param _builtins.str key: The name of the App Configuration Key.
    :param _builtins.str label: The label of the App Configuration Key.
    """
    __args__ = dict()
    __args__['configurationStoreId'] = configuration_store_id
    __args__['key'] = key
    __args__['label'] = label
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:appconfiguration/getConfigurationKey:getConfigurationKey', __args__, opts=opts, typ=GetConfigurationKeyResult).value

    return AwaitableGetConfigurationKeyResult(
        configuration_store_id=pulumi.get(__ret__, 'configuration_store_id'),
        content_type=pulumi.get(__ret__, 'content_type'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        label=pulumi.get(__ret__, 'label'),
        locked=pulumi.get(__ret__, 'locked'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        value=pulumi.get(__ret__, 'value'),
        vault_key_reference=pulumi.get(__ret__, 'vault_key_reference'))
def get_configuration_key_output(configuration_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 key: Optional[pulumi.Input[_builtins.str]] = None,
                                 label: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigurationKeyResult]:
    """
    Use this data source to access information about an existing Azure App Configuration Key.

    > **Note:** App Configuration Keys are provisioned using a Data Plane API which requires the role `App Configuration Data Owner` on either the App Configuration or a parent scope (such as the Resource Group/Subscription). [More information can be found in the Azure Documentation for App Configuration](https://docs.microsoft.com/azure/azure-app-configuration/concept-enable-rbac#azure-built-in-roles-for-azure-app-configuration).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    test = azure.appconfiguration.get_configuration_key(configuration_store_id=appconf["id"],
        key="appConfKey1",
        label="somelabel")
    pulumi.export("value", test.value)
    ```


    :param _builtins.str configuration_store_id: Specifies the id of the App Configuration.
    :param _builtins.str key: The name of the App Configuration Key.
    :param _builtins.str label: The label of the App Configuration Key.
    """
    __args__ = dict()
    __args__['configurationStoreId'] = configuration_store_id
    __args__['key'] = key
    __args__['label'] = label
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:appconfiguration/getConfigurationKey:getConfigurationKey', __args__, opts=opts, typ=GetConfigurationKeyResult)
    return __ret__.apply(lambda __response__: GetConfigurationKeyResult(
        configuration_store_id=pulumi.get(__response__, 'configuration_store_id'),
        content_type=pulumi.get(__response__, 'content_type'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        label=pulumi.get(__response__, 'label'),
        locked=pulumi.get(__response__, 'locked'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        value=pulumi.get(__response__, 'value'),
        vault_key_reference=pulumi.get(__response__, 'vault_key_reference')))
