# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetInsightsResult',
    'AwaitableGetInsightsResult',
    'get_insights',
    'get_insights_output',
]

@pulumi.output_type
class GetInsightsResult:
    """
    A collection of values returned by getInsights.
    """
    def __init__(__self__, app_id=None, application_type=None, connection_string=None, id=None, instrumentation_key=None, location=None, name=None, resource_group_name=None, retention_in_days=None, tags=None, workspace_id=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if application_type and not isinstance(application_type, str):
            raise TypeError("Expected argument 'application_type' to be a str")
        pulumi.set(__self__, "application_type", application_type)
        if connection_string and not isinstance(connection_string, str):
            raise TypeError("Expected argument 'connection_string' to be a str")
        pulumi.set(__self__, "connection_string", connection_string)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instrumentation_key and not isinstance(instrumentation_key, str):
            raise TypeError("Expected argument 'instrumentation_key' to be a str")
        pulumi.set(__self__, "instrumentation_key", instrumentation_key)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_in_days and not isinstance(retention_in_days, int):
            raise TypeError("Expected argument 'retention_in_days' to be a int")
        pulumi.set(__self__, "retention_in_days", retention_in_days)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        """
        The App ID associated with this Application Insights component.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> _builtins.str:
        """
        The type of the component.
        """
        return pulumi.get(self, "application_type")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> _builtins.str:
        """
        The connection string of the Application Insights component. (Sensitive)
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instrumentationKey")
    def instrumentation_key(self) -> _builtins.str:
        """
        The instrumentation key of the Application Insights component.
        """
        return pulumi.get(self, "instrumentation_key")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure location where the component exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> _builtins.int:
        """
        The retention period in days.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags applied to the component.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        """
        The id of the associated Log Analytics workspace
        """
        return pulumi.get(self, "workspace_id")


class AwaitableGetInsightsResult(GetInsightsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInsightsResult(
            app_id=self.app_id,
            application_type=self.application_type,
            connection_string=self.connection_string,
            id=self.id,
            instrumentation_key=self.instrumentation_key,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            retention_in_days=self.retention_in_days,
            tags=self.tags,
            workspace_id=self.workspace_id)


def get_insights(name: Optional[_builtins.str] = None,
                 resource_group_name: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInsightsResult:
    """
    Use this data source to access information about an existing Application Insights component.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appinsights.get_insights(name="production",
        resource_group_name="networking")
    pulumi.export("applicationInsightsInstrumentationKey", example.instrumentation_key)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights` - 2020-02-02


    :param _builtins.str name: Specifies the name of the Application Insights component.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Application Insights component is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:appinsights/getInsights:getInsights', __args__, opts=opts, typ=GetInsightsResult).value

    return AwaitableGetInsightsResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        application_type=pulumi.get(__ret__, 'application_type'),
        connection_string=pulumi.get(__ret__, 'connection_string'),
        id=pulumi.get(__ret__, 'id'),
        instrumentation_key=pulumi.get(__ret__, 'instrumentation_key'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        retention_in_days=pulumi.get(__ret__, 'retention_in_days'),
        tags=pulumi.get(__ret__, 'tags'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_insights_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                        resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInsightsResult]:
    """
    Use this data source to access information about an existing Application Insights component.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appinsights.get_insights(name="production",
        resource_group_name="networking")
    pulumi.export("applicationInsightsInstrumentationKey", example.instrumentation_key)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Insights` - 2020-02-02


    :param _builtins.str name: Specifies the name of the Application Insights component.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Application Insights component is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:appinsights/getInsights:getInsights', __args__, opts=opts, typ=GetInsightsResult)
    return __ret__.apply(lambda __response__: GetInsightsResult(
        app_id=pulumi.get(__response__, 'app_id'),
        application_type=pulumi.get(__response__, 'application_type'),
        connection_string=pulumi.get(__response__, 'connection_string'),
        id=pulumi.get(__response__, 'id'),
        instrumentation_key=pulumi.get(__response__, 'instrumentation_key'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        retention_in_days=pulumi.get(__response__, 'retention_in_days'),
        tags=pulumi.get(__response__, 'tags'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
