# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StandardWebTestArgs', 'StandardWebTest']

@pulumi.input_type
class StandardWebTestArgs:
    def __init__(__self__, *,
                 application_insights_id: pulumi.Input[_builtins.str],
                 geo_locations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 request: pulumi.Input['StandardWebTestRequestArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 validation_rules: Optional[pulumi.Input['StandardWebTestValidationRulesArgs']] = None):
        """
        The set of arguments for constructing a StandardWebTest resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights instance on which the WebTest operates. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_locations: Specifies a list of where to physically run the tests from to give global coverage for accessibility of your application.
               
               > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        :param pulumi.Input['StandardWebTestRequestArgs'] request: A `request` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[_builtins.str] description: Purpose/user defined descriptive test for this WebTest.
        :param pulumi.Input[_builtins.bool] enabled: Should the WebTest be enabled?
        :param pulumi.Input[_builtins.int] frequency: Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created. It needs to correlate with location of the parent resource (azurerm_application_insights)
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Insights Standard WebTest. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[_builtins.bool] retry_enabled: Should the retry on WebTest failure be enabled?
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Application Insights Standard WebTest.
        :param pulumi.Input[_builtins.int] timeout: Seconds until this WebTest will timeout and fail. Default is `30`.
        :param pulumi.Input['StandardWebTestValidationRulesArgs'] validation_rules: A `validation_rules` block as defined below.
        """
        pulumi.set(__self__, "application_insights_id", application_insights_id)
        pulumi.set(__self__, "geo_locations", geo_locations)
        pulumi.set(__self__, "request", request)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retry_enabled is not None:
            pulumi.set(__self__, "retry_enabled", retry_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if validation_rules is not None:
            pulumi.set(__self__, "validation_rules", validation_rules)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Application Insights instance on which the WebTest operates. Changing this forces a new Application Insights Standard WebTest to be created.
        """
        return pulumi.get(self, "application_insights_id")

    @application_insights_id.setter
    def application_insights_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_insights_id", value)

    @_builtins.property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of where to physically run the tests from to give global coverage for accessibility of your application.

        > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        """
        return pulumi.get(self, "geo_locations")

    @geo_locations.setter
    def geo_locations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "geo_locations", value)

    @_builtins.property
    @pulumi.getter
    def request(self) -> pulumi.Input['StandardWebTestRequestArgs']:
        """
        A `request` block as defined below.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: pulumi.Input['StandardWebTestRequestArgs']):
        pulumi.set(self, "request", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Purpose/user defined descriptive test for this WebTest.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the WebTest be enabled?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created. It needs to correlate with location of the parent resource (azurerm_application_insights)
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Application Insights Standard WebTest. Changing this forces a new Application Insights Standard WebTest to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retryEnabled")
    def retry_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the retry on WebTest failure be enabled?
        """
        return pulumi.get(self, "retry_enabled")

    @retry_enabled.setter
    def retry_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retry_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Insights Standard WebTest.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="validationRules")
    def validation_rules(self) -> Optional[pulumi.Input['StandardWebTestValidationRulesArgs']]:
        """
        A `validation_rules` block as defined below.
        """
        return pulumi.get(self, "validation_rules")

    @validation_rules.setter
    def validation_rules(self, value: Optional[pulumi.Input['StandardWebTestValidationRulesArgs']]):
        pulumi.set(self, "validation_rules", value)


@pulumi.input_type
class _StandardWebTestState:
    def __init__(__self__, *,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request: Optional[pulumi.Input['StandardWebTestRequestArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 synthetic_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 validation_rules: Optional[pulumi.Input['StandardWebTestValidationRulesArgs']] = None):
        """
        Input properties used for looking up and filtering StandardWebTest resources.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights instance on which the WebTest operates. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[_builtins.str] description: Purpose/user defined descriptive test for this WebTest.
        :param pulumi.Input[_builtins.bool] enabled: Should the WebTest be enabled?
        :param pulumi.Input[_builtins.int] frequency: Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_locations: Specifies a list of where to physically run the tests from to give global coverage for accessibility of your application.
               
               > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created. It needs to correlate with location of the parent resource (azurerm_application_insights)
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Insights Standard WebTest. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input['StandardWebTestRequestArgs'] request: A `request` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[_builtins.bool] retry_enabled: Should the retry on WebTest failure be enabled?
        :param pulumi.Input[_builtins.str] synthetic_monitor_id: Unique ID of this WebTest. This is typically the same value as the Name field.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Application Insights Standard WebTest.
        :param pulumi.Input[_builtins.int] timeout: Seconds until this WebTest will timeout and fail. Default is `30`.
        :param pulumi.Input['StandardWebTestValidationRulesArgs'] validation_rules: A `validation_rules` block as defined below.
        """
        if application_insights_id is not None:
            pulumi.set(__self__, "application_insights_id", application_insights_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if geo_locations is not None:
            pulumi.set(__self__, "geo_locations", geo_locations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retry_enabled is not None:
            pulumi.set(__self__, "retry_enabled", retry_enabled)
        if synthetic_monitor_id is not None:
            pulumi.set(__self__, "synthetic_monitor_id", synthetic_monitor_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if validation_rules is not None:
            pulumi.set(__self__, "validation_rules", validation_rules)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Application Insights instance on which the WebTest operates. Changing this forces a new Application Insights Standard WebTest to be created.
        """
        return pulumi.get(self, "application_insights_id")

    @application_insights_id.setter
    def application_insights_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_insights_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Purpose/user defined descriptive test for this WebTest.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the WebTest be enabled?
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of where to physically run the tests from to give global coverage for accessibility of your application.

        > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        """
        return pulumi.get(self, "geo_locations")

    @geo_locations.setter
    def geo_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "geo_locations", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created. It needs to correlate with location of the parent resource (azurerm_application_insights)
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Application Insights Standard WebTest. Changing this forces a new Application Insights Standard WebTest to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['StandardWebTestRequestArgs']]:
        """
        A `request` block as defined below.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['StandardWebTestRequestArgs']]):
        pulumi.set(self, "request", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="retryEnabled")
    def retry_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the retry on WebTest failure be enabled?
        """
        return pulumi.get(self, "retry_enabled")

    @retry_enabled.setter
    def retry_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retry_enabled", value)

    @_builtins.property
    @pulumi.getter(name="syntheticMonitorId")
    def synthetic_monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique ID of this WebTest. This is typically the same value as the Name field.
        """
        return pulumi.get(self, "synthetic_monitor_id")

    @synthetic_monitor_id.setter
    def synthetic_monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synthetic_monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Application Insights Standard WebTest.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="validationRules")
    def validation_rules(self) -> Optional[pulumi.Input['StandardWebTestValidationRulesArgs']]:
        """
        A `validation_rules` block as defined below.
        """
        return pulumi.get(self, "validation_rules")

    @validation_rules.setter
    def validation_rules(self, value: Optional[pulumi.Input['StandardWebTestValidationRulesArgs']]):
        pulumi.set(self, "validation_rules", value)


@pulumi.type_token("azure:appinsights/standardWebTest:StandardWebTest")
class StandardWebTest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request: Optional[pulumi.Input[Union['StandardWebTestRequestArgs', 'StandardWebTestRequestArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 validation_rules: Optional[pulumi.Input[Union['StandardWebTestValidationRulesArgs', 'StandardWebTestValidationRulesArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Application Insights Standard WebTest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_standard_web_test = azure.appinsights.StandardWebTest("example",
            name="example-test",
            resource_group_name=example.name,
            location="West Europe",
            application_insights_id=example_insights.id,
            geo_locations=["example"],
            request={
                "url": "http://www.example.com",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2022-06-15

        ## Import

        Application Insights Standard WebTests can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/standardWebTest:StandardWebTest example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Insights/webTests/appinsightswebtest
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights instance on which the WebTest operates. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[_builtins.str] description: Purpose/user defined descriptive test for this WebTest.
        :param pulumi.Input[_builtins.bool] enabled: Should the WebTest be enabled?
        :param pulumi.Input[_builtins.int] frequency: Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_locations: Specifies a list of where to physically run the tests from to give global coverage for accessibility of your application.
               
               > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created. It needs to correlate with location of the parent resource (azurerm_application_insights)
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Insights Standard WebTest. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[Union['StandardWebTestRequestArgs', 'StandardWebTestRequestArgsDict']] request: A `request` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[_builtins.bool] retry_enabled: Should the retry on WebTest failure be enabled?
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Application Insights Standard WebTest.
        :param pulumi.Input[_builtins.int] timeout: Seconds until this WebTest will timeout and fail. Default is `30`.
        :param pulumi.Input[Union['StandardWebTestValidationRulesArgs', 'StandardWebTestValidationRulesArgsDict']] validation_rules: A `validation_rules` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StandardWebTestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Application Insights Standard WebTest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_standard_web_test = azure.appinsights.StandardWebTest("example",
            name="example-test",
            resource_group_name=example.name,
            location="West Europe",
            application_insights_id=example_insights.id,
            geo_locations=["example"],
            request={
                "url": "http://www.example.com",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2022-06-15

        ## Import

        Application Insights Standard WebTests can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/standardWebTest:StandardWebTest example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Insights/webTests/appinsightswebtest
        ```

        :param str resource_name: The name of the resource.
        :param StandardWebTestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StandardWebTestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 request: Optional[pulumi.Input[Union['StandardWebTestRequestArgs', 'StandardWebTestRequestArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 validation_rules: Optional[pulumi.Input[Union['StandardWebTestValidationRulesArgs', 'StandardWebTestValidationRulesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StandardWebTestArgs.__new__(StandardWebTestArgs)

            if application_insights_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_insights_id'")
            __props__.__dict__["application_insights_id"] = application_insights_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["frequency"] = frequency
            if geo_locations is None and not opts.urn:
                raise TypeError("Missing required property 'geo_locations'")
            __props__.__dict__["geo_locations"] = geo_locations
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if request is None and not opts.urn:
                raise TypeError("Missing required property 'request'")
            __props__.__dict__["request"] = request
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retry_enabled"] = retry_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["validation_rules"] = validation_rules
            __props__.__dict__["synthetic_monitor_id"] = None
        super(StandardWebTest, __self__).__init__(
            'azure:appinsights/standardWebTest:StandardWebTest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            frequency: Optional[pulumi.Input[_builtins.int]] = None,
            geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            request: Optional[pulumi.Input[Union['StandardWebTestRequestArgs', 'StandardWebTestRequestArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            synthetic_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            validation_rules: Optional[pulumi.Input[Union['StandardWebTestValidationRulesArgs', 'StandardWebTestValidationRulesArgsDict']]] = None) -> 'StandardWebTest':
        """
        Get an existing StandardWebTest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights instance on which the WebTest operates. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[_builtins.str] description: Purpose/user defined descriptive test for this WebTest.
        :param pulumi.Input[_builtins.bool] enabled: Should the WebTest be enabled?
        :param pulumi.Input[_builtins.int] frequency: Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_locations: Specifies a list of where to physically run the tests from to give global coverage for accessibility of your application.
               
               > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created. It needs to correlate with location of the parent resource (azurerm_application_insights)
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Insights Standard WebTest. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[Union['StandardWebTestRequestArgs', 'StandardWebTestRequestArgsDict']] request: A `request` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created.
        :param pulumi.Input[_builtins.bool] retry_enabled: Should the retry on WebTest failure be enabled?
        :param pulumi.Input[_builtins.str] synthetic_monitor_id: Unique ID of this WebTest. This is typically the same value as the Name field.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Application Insights Standard WebTest.
        :param pulumi.Input[_builtins.int] timeout: Seconds until this WebTest will timeout and fail. Default is `30`.
        :param pulumi.Input[Union['StandardWebTestValidationRulesArgs', 'StandardWebTestValidationRulesArgsDict']] validation_rules: A `validation_rules` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StandardWebTestState.__new__(_StandardWebTestState)

        __props__.__dict__["application_insights_id"] = application_insights_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["geo_locations"] = geo_locations
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["request"] = request
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retry_enabled"] = retry_enabled
        __props__.__dict__["synthetic_monitor_id"] = synthetic_monitor_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["validation_rules"] = validation_rules
        return StandardWebTest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Application Insights instance on which the WebTest operates. Changing this forces a new Application Insights Standard WebTest to be created.
        """
        return pulumi.get(self, "application_insights_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Purpose/user defined descriptive test for this WebTest.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the WebTest be enabled?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a list of where to physically run the tests from to give global coverage for accessibility of your application.

        > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        """
        return pulumi.get(self, "geo_locations")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created. It needs to correlate with location of the parent resource (azurerm_application_insights)
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Application Insights Standard WebTest. Changing this forces a new Application Insights Standard WebTest to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def request(self) -> pulumi.Output['outputs.StandardWebTestRequest']:
        """
        A `request` block as defined below.
        """
        return pulumi.get(self, "request")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Application Insights Standard WebTest should exist. Changing this forces a new Application Insights Standard WebTest to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="retryEnabled")
    def retry_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the retry on WebTest failure be enabled?
        """
        return pulumi.get(self, "retry_enabled")

    @_builtins.property
    @pulumi.getter(name="syntheticMonitorId")
    def synthetic_monitor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique ID of this WebTest. This is typically the same value as the Name field.
        """
        return pulumi.get(self, "synthetic_monitor_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Application Insights Standard WebTest.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="validationRules")
    def validation_rules(self) -> pulumi.Output[Optional['outputs.StandardWebTestValidationRules']]:
        """
        A `validation_rules` block as defined below.
        """
        return pulumi.get(self, "validation_rules")

