# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WebTestArgs', 'WebTest']

@pulumi.input_type
class WebTestArgs:
    def __init__(__self__, *,
                 application_insights_id: pulumi.Input[_builtins.str],
                 configuration: pulumi.Input[_builtins.str],
                 geo_locations: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 kind: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a WebTest resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights component on which the WebTest operates. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] configuration: An XML configuration specification for a WebTest ([see here for more information](https://docs.microsoft.com/rest/api/application-insights/webtests/createorupdate/)).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_locations: A list of where to physically run the tests from to give global coverage for accessibility of your application.
               
               > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        :param pulumi.Input[_builtins.str] kind: The kind of web test that this web test watches. Choices are `ping` and `multistep`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Application Insights WebTest. Changing this forces a new resource
        :param pulumi.Input[_builtins.str] description: Purpose/user defined descriptive test for this WebTest.
        :param pulumi.Input[_builtins.bool] enabled: Is the test actively being monitored.
        :param pulumi.Input[_builtins.int] frequency: Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. It needs to correlate with location of parent resource (azurerm_application_insights).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Application Insights WebTest. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] retry_enabled: Allow for retries should this WebTest fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] timeout: Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        pulumi.set(__self__, "application_insights_id", application_insights_id)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "geo_locations", geo_locations)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retry_enabled is not None:
            pulumi.set(__self__, "retry_enabled", retry_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Application Insights component on which the WebTest operates. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_insights_id")

    @application_insights_id.setter
    def application_insights_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_insights_id", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Input[_builtins.str]:
        """
        An XML configuration specification for a WebTest ([see here for more information](https://docs.microsoft.com/rest/api/application-insights/webtests/createorupdate/)).
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of where to physically run the tests from to give global coverage for accessibility of your application.

        > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        """
        return pulumi.get(self, "geo_locations")

    @geo_locations.setter
    def geo_locations(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "geo_locations", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Input[_builtins.str]:
        """
        The kind of web test that this web test watches. Choices are `ping` and `multistep`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Application Insights WebTest. Changing this forces a new resource
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Purpose/user defined descriptive test for this WebTest.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the test actively being monitored.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. It needs to correlate with location of parent resource (azurerm_application_insights).
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Application Insights WebTest. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retryEnabled")
    def retry_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow for retries should this WebTest fail.
        """
        return pulumi.get(self, "retry_enabled")

    @retry_enabled.setter
    def retry_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retry_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _WebTestState:
    def __init__(__self__, *,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 synthetic_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering WebTest resources.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights component on which the WebTest operates. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] configuration: An XML configuration specification for a WebTest ([see here for more information](https://docs.microsoft.com/rest/api/application-insights/webtests/createorupdate/)).
        :param pulumi.Input[_builtins.str] description: Purpose/user defined descriptive test for this WebTest.
        :param pulumi.Input[_builtins.bool] enabled: Is the test actively being monitored.
        :param pulumi.Input[_builtins.int] frequency: Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_locations: A list of where to physically run the tests from to give global coverage for accessibility of your application.
               
               > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        :param pulumi.Input[_builtins.str] kind: The kind of web test that this web test watches. Choices are `ping` and `multistep`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. It needs to correlate with location of parent resource (azurerm_application_insights).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Application Insights WebTest. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Application Insights WebTest. Changing this forces a new resource
        :param pulumi.Input[_builtins.bool] retry_enabled: Allow for retries should this WebTest fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] timeout: Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        if application_insights_id is not None:
            pulumi.set(__self__, "application_insights_id", application_insights_id)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if geo_locations is not None:
            pulumi.set(__self__, "geo_locations", geo_locations)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retry_enabled is not None:
            pulumi.set(__self__, "retry_enabled", retry_enabled)
        if synthetic_monitor_id is not None:
            pulumi.set(__self__, "synthetic_monitor_id", synthetic_monitor_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Application Insights component on which the WebTest operates. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_insights_id")

    @application_insights_id.setter
    def application_insights_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_insights_id", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An XML configuration specification for a WebTest ([see here for more information](https://docs.microsoft.com/rest/api/application-insights/webtests/createorupdate/)).
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Purpose/user defined descriptive test for this WebTest.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the test actively being monitored.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of where to physically run the tests from to give global coverage for accessibility of your application.

        > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        """
        return pulumi.get(self, "geo_locations")

    @geo_locations.setter
    def geo_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "geo_locations", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kind of web test that this web test watches. Choices are `ping` and `multistep`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. It needs to correlate with location of parent resource (azurerm_application_insights).
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Application Insights WebTest. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Application Insights WebTest. Changing this forces a new resource
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="retryEnabled")
    def retry_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow for retries should this WebTest fail.
        """
        return pulumi.get(self, "retry_enabled")

    @retry_enabled.setter
    def retry_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retry_enabled", value)

    @_builtins.property
    @pulumi.getter(name="syntheticMonitorId")
    def synthetic_monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "synthetic_monitor_id")

    @synthetic_monitor_id.setter
    def synthetic_monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synthetic_monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.type_token("azure:appinsights/webTest:WebTest")
class WebTest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tf-test",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="tf-test-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_web_test = azure.appinsights.WebTest("example",
            name="tf-test-appinsights-webtest",
            location=example_insights.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            kind="ping",
            frequency=300,
            timeout=60,
            enabled=True,
            geo_locations=[
                "us-tx-sn1-azr",
                "us-il-ch1-azr",
            ],
            configuration=\"\"\"<WebTest Name=\\"WebTest1\\" Id=\\"ABD48585-0831-40CB-9069-682EA6BB3583\\" Enabled=\\"True\\" CssProjectStructure=\\"\\" CssIteration=\\"\\" Timeout=\\"0\\" WorkItemIds=\\"\\" xmlns=\\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\\" Description=\\"\\" CredentialUserName=\\"\\" CredentialPassword=\\"\\" PreAuthenticate=\\"True\\" Proxy=\\"default\\" StopOnError=\\"False\\" RecordedResultFile=\\"\\" ResultsLocale=\\"\\">
          <Items>
            <Request Method=\\"GET\\" Guid=\\"a5f10126-e4cd-570d-961c-cea43999a200\\" Version=\\"1.1\\" Url=\\"http://microsoft.com\\" ThinkTime=\\"0\\" Timeout=\\"300\\" ParseDependentRequests=\\"True\\" FollowRedirects=\\"True\\" RecordResult=\\"True\\" Cache=\\"False\\" ResponseTimeGoal=\\"0\\" Encoding=\\"utf-8\\" ExpectedHttpStatusCode=\\"200\\" ExpectedResponseUrl=\\"\\" ReportingName=\\"\\" IgnoreHttpStatusCode=\\"False\\" />
          </Items>
        </WebTest>
        \"\"\")
        pulumi.export("webtestId", example_web_test.id)
        pulumi.export("webtestsSyntheticId", example_web_test.synthetic_monitor_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2022-06-15

        ## Import

        Application Insights Web Tests can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/webTest:WebTest my_test /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Insights/webTests/my_test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights component on which the WebTest operates. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] configuration: An XML configuration specification for a WebTest ([see here for more information](https://docs.microsoft.com/rest/api/application-insights/webtests/createorupdate/)).
        :param pulumi.Input[_builtins.str] description: Purpose/user defined descriptive test for this WebTest.
        :param pulumi.Input[_builtins.bool] enabled: Is the test actively being monitored.
        :param pulumi.Input[_builtins.int] frequency: Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_locations: A list of where to physically run the tests from to give global coverage for accessibility of your application.
               
               > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        :param pulumi.Input[_builtins.str] kind: The kind of web test that this web test watches. Choices are `ping` and `multistep`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. It needs to correlate with location of parent resource (azurerm_application_insights).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Application Insights WebTest. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Application Insights WebTest. Changing this forces a new resource
        :param pulumi.Input[_builtins.bool] retry_enabled: Allow for retries should this WebTest fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] timeout: Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebTestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tf-test",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="tf-test-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_web_test = azure.appinsights.WebTest("example",
            name="tf-test-appinsights-webtest",
            location=example_insights.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            kind="ping",
            frequency=300,
            timeout=60,
            enabled=True,
            geo_locations=[
                "us-tx-sn1-azr",
                "us-il-ch1-azr",
            ],
            configuration=\"\"\"<WebTest Name=\\"WebTest1\\" Id=\\"ABD48585-0831-40CB-9069-682EA6BB3583\\" Enabled=\\"True\\" CssProjectStructure=\\"\\" CssIteration=\\"\\" Timeout=\\"0\\" WorkItemIds=\\"\\" xmlns=\\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\\" Description=\\"\\" CredentialUserName=\\"\\" CredentialPassword=\\"\\" PreAuthenticate=\\"True\\" Proxy=\\"default\\" StopOnError=\\"False\\" RecordedResultFile=\\"\\" ResultsLocale=\\"\\">
          <Items>
            <Request Method=\\"GET\\" Guid=\\"a5f10126-e4cd-570d-961c-cea43999a200\\" Version=\\"1.1\\" Url=\\"http://microsoft.com\\" ThinkTime=\\"0\\" Timeout=\\"300\\" ParseDependentRequests=\\"True\\" FollowRedirects=\\"True\\" RecordResult=\\"True\\" Cache=\\"False\\" ResponseTimeGoal=\\"0\\" Encoding=\\"utf-8\\" ExpectedHttpStatusCode=\\"200\\" ExpectedResponseUrl=\\"\\" ReportingName=\\"\\" IgnoreHttpStatusCode=\\"False\\" />
          </Items>
        </WebTest>
        \"\"\")
        pulumi.export("webtestId", example_web_test.id)
        pulumi.export("webtestsSyntheticId", example_web_test.synthetic_monitor_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2022-06-15

        ## Import

        Application Insights Web Tests can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/webTest:WebTest my_test /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Insights/webTests/my_test
        ```

        :param str resource_name: The name of the resource.
        :param WebTestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebTestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.int]] = None,
                 geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebTestArgs.__new__(WebTestArgs)

            if application_insights_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_insights_id'")
            __props__.__dict__["application_insights_id"] = application_insights_id
            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["frequency"] = frequency
            if geo_locations is None and not opts.urn:
                raise TypeError("Missing required property 'geo_locations'")
            __props__.__dict__["geo_locations"] = geo_locations
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retry_enabled"] = retry_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["synthetic_monitor_id"] = None
        super(WebTest, __self__).__init__(
            'azure:appinsights/webTest:WebTest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            frequency: Optional[pulumi.Input[_builtins.int]] = None,
            geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            retry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            synthetic_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'WebTest':
        """
        Get an existing WebTest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights component on which the WebTest operates. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] configuration: An XML configuration specification for a WebTest ([see here for more information](https://docs.microsoft.com/rest/api/application-insights/webtests/createorupdate/)).
        :param pulumi.Input[_builtins.str] description: Purpose/user defined descriptive test for this WebTest.
        :param pulumi.Input[_builtins.bool] enabled: Is the test actively being monitored.
        :param pulumi.Input[_builtins.int] frequency: Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] geo_locations: A list of where to physically run the tests from to give global coverage for accessibility of your application.
               
               > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        :param pulumi.Input[_builtins.str] kind: The kind of web test that this web test watches. Choices are `ping` and `multistep`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. It needs to correlate with location of parent resource (azurerm_application_insights).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Application Insights WebTest. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Application Insights WebTest. Changing this forces a new resource
        :param pulumi.Input[_builtins.bool] retry_enabled: Allow for retries should this WebTest fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] timeout: Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebTestState.__new__(_WebTestState)

        __props__.__dict__["application_insights_id"] = application_insights_id
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["geo_locations"] = geo_locations
        __props__.__dict__["kind"] = kind
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retry_enabled"] = retry_enabled
        __props__.__dict__["synthetic_monitor_id"] = synthetic_monitor_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeout"] = timeout
        return WebTest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Application Insights component on which the WebTest operates. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_insights_id")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[_builtins.str]:
        """
        An XML configuration specification for a WebTest ([see here for more information](https://docs.microsoft.com/rest/api/application-insights/webtests/createorupdate/)).
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Purpose/user defined descriptive test for this WebTest.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the test actively being monitored.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Interval in seconds between test runs for this WebTest. Valid options are `300`, `600` and `900`. Defaults to `300`.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of where to physically run the tests from to give global coverage for accessibility of your application.

        > **Note:** [Valid options for geo locations are described here](https://docs.microsoft.com/azure/azure-monitor/app/monitor-web-app-availability#location-population-tags)
        """
        return pulumi.get(self, "geo_locations")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        The kind of web test that this web test watches. Choices are `ping` and `multistep`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created. It needs to correlate with location of parent resource (azurerm_application_insights).
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Application Insights WebTest. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Application Insights WebTest. Changing this forces a new resource
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="retryEnabled")
    def retry_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow for retries should this WebTest fail.
        """
        return pulumi.get(self, "retry_enabled")

    @_builtins.property
    @pulumi.getter(name="syntheticMonitorId")
    def synthetic_monitor_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "synthetic_monitor_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Seconds until this WebTest will timeout and fail. Default is `30`.
        """
        return pulumi.get(self, "timeout")

