# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudBuildPackBindingArgs', 'SpringCloudBuildPackBinding']

@pulumi.input_type
class SpringCloudBuildPackBindingArgs:
    def __init__(__self__, *,
                 spring_cloud_builder_id: pulumi.Input[_builtins.str],
                 binding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 launch: Optional[pulumi.Input['SpringCloudBuildPackBindingLaunchArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudBuildPackBinding resource.
        :param pulumi.Input[_builtins.str] spring_cloud_builder_id: The ID of the Spring Cloud Builder. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        :param pulumi.Input[_builtins.str] binding_type: Specifies the Build Pack Binding Type. Allowed values are `ApacheSkyWalking`, `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        :param pulumi.Input['SpringCloudBuildPackBindingLaunchArgs'] launch: A `launch` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Build Pack Binding. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        pulumi.set(__self__, "spring_cloud_builder_id", spring_cloud_builder_id)
        if binding_type is not None:
            pulumi.set(__self__, "binding_type", binding_type)
        if launch is not None:
            pulumi.set(__self__, "launch", launch)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="springCloudBuilderId")
    def spring_cloud_builder_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Spring Cloud Builder. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        return pulumi.get(self, "spring_cloud_builder_id")

    @spring_cloud_builder_id.setter
    def spring_cloud_builder_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spring_cloud_builder_id", value)

    @_builtins.property
    @pulumi.getter(name="bindingType")
    def binding_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Build Pack Binding Type. Allowed values are `ApacheSkyWalking`, `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        """
        return pulumi.get(self, "binding_type")

    @binding_type.setter
    def binding_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binding_type", value)

    @_builtins.property
    @pulumi.getter
    def launch(self) -> Optional[pulumi.Input['SpringCloudBuildPackBindingLaunchArgs']]:
        """
        A `launch` block as defined below.
        """
        return pulumi.get(self, "launch")

    @launch.setter
    def launch(self, value: Optional[pulumi.Input['SpringCloudBuildPackBindingLaunchArgs']]):
        pulumi.set(self, "launch", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Build Pack Binding. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpringCloudBuildPackBindingState:
    def __init__(__self__, *,
                 binding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 launch: Optional[pulumi.Input['SpringCloudBuildPackBindingLaunchArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_builder_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudBuildPackBinding resources.
        :param pulumi.Input[_builtins.str] binding_type: Specifies the Build Pack Binding Type. Allowed values are `ApacheSkyWalking`, `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        :param pulumi.Input['SpringCloudBuildPackBindingLaunchArgs'] launch: A `launch` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Build Pack Binding. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_builder_id: The ID of the Spring Cloud Builder. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        if binding_type is not None:
            pulumi.set(__self__, "binding_type", binding_type)
        if launch is not None:
            pulumi.set(__self__, "launch", launch)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spring_cloud_builder_id is not None:
            pulumi.set(__self__, "spring_cloud_builder_id", spring_cloud_builder_id)

    @_builtins.property
    @pulumi.getter(name="bindingType")
    def binding_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Build Pack Binding Type. Allowed values are `ApacheSkyWalking`, `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        """
        return pulumi.get(self, "binding_type")

    @binding_type.setter
    def binding_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "binding_type", value)

    @_builtins.property
    @pulumi.getter
    def launch(self) -> Optional[pulumi.Input['SpringCloudBuildPackBindingLaunchArgs']]:
        """
        A `launch` block as defined below.
        """
        return pulumi.get(self, "launch")

    @launch.setter
    def launch(self, value: Optional[pulumi.Input['SpringCloudBuildPackBindingLaunchArgs']]):
        pulumi.set(self, "launch", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Build Pack Binding. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="springCloudBuilderId")
    def spring_cloud_builder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Spring Cloud Builder. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        return pulumi.get(self, "spring_cloud_builder_id")

    @spring_cloud_builder_id.setter
    def spring_cloud_builder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spring_cloud_builder_id", value)


@pulumi.type_token("azure:appplatform/springCloudBuildPackBinding:SpringCloudBuildPackBinding")
class SpringCloudBuildPackBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 binding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 launch: Optional[pulumi.Input[Union['SpringCloudBuildPackBindingLaunchArgs', 'SpringCloudBuildPackBindingLaunchArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_builder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Spring Cloud Build Pack Binding.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudBuildPackBinding` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="E0")
        example_spring_cloud_builder = azure.appplatform.SpringCloudBuilder("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            build_pack_groups=[{
                "name": "mix",
                "build_pack_ids": ["tanzu-Build Packs/java-azure"],
            }],
            stack={
                "id": "io.Build Packs.stacks.bionic",
                "version": "base",
            })
        example_spring_cloud_build_pack_binding = azure.appplatform.SpringCloudBuildPackBinding("example",
            name="example",
            spring_cloud_builder_id=example_spring_cloud_builder.id,
            binding_type="ApplicationInsights",
            launch={
                "properties": {
                    "abc": "def",
                    "any-string": "any-string",
                    "sampling-rate": "12.0",
                },
                "secrets": {
                    "connection-string": "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX",
                },
            })
        ```

        ## Import

        Spring Cloud Build Pack Bindings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudBuildPackBinding:SpringCloudBuildPackBinding example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/buildServices/buildService1/builders/builder1/buildPackBindings/binding1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] binding_type: Specifies the Build Pack Binding Type. Allowed values are `ApacheSkyWalking`, `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        :param pulumi.Input[Union['SpringCloudBuildPackBindingLaunchArgs', 'SpringCloudBuildPackBindingLaunchArgsDict']] launch: A `launch` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Build Pack Binding. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_builder_id: The ID of the Spring Cloud Builder. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudBuildPackBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spring Cloud Build Pack Binding.

        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudBuildPackBinding` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="E0")
        example_spring_cloud_builder = azure.appplatform.SpringCloudBuilder("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            build_pack_groups=[{
                "name": "mix",
                "build_pack_ids": ["tanzu-Build Packs/java-azure"],
            }],
            stack={
                "id": "io.Build Packs.stacks.bionic",
                "version": "base",
            })
        example_spring_cloud_build_pack_binding = azure.appplatform.SpringCloudBuildPackBinding("example",
            name="example",
            spring_cloud_builder_id=example_spring_cloud_builder.id,
            binding_type="ApplicationInsights",
            launch={
                "properties": {
                    "abc": "def",
                    "any-string": "any-string",
                    "sampling-rate": "12.0",
                },
                "secrets": {
                    "connection-string": "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX",
                },
            })
        ```

        ## Import

        Spring Cloud Build Pack Bindings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudBuildPackBinding:SpringCloudBuildPackBinding example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/buildServices/buildService1/builders/builder1/buildPackBindings/binding1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudBuildPackBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudBuildPackBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 binding_type: Optional[pulumi.Input[_builtins.str]] = None,
                 launch: Optional[pulumi.Input[Union['SpringCloudBuildPackBindingLaunchArgs', 'SpringCloudBuildPackBindingLaunchArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_builder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudBuildPackBindingArgs.__new__(SpringCloudBuildPackBindingArgs)

            __props__.__dict__["binding_type"] = binding_type
            __props__.__dict__["launch"] = launch
            __props__.__dict__["name"] = name
            if spring_cloud_builder_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_builder_id'")
            __props__.__dict__["spring_cloud_builder_id"] = spring_cloud_builder_id
        super(SpringCloudBuildPackBinding, __self__).__init__(
            'azure:appplatform/springCloudBuildPackBinding:SpringCloudBuildPackBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            binding_type: Optional[pulumi.Input[_builtins.str]] = None,
            launch: Optional[pulumi.Input[Union['SpringCloudBuildPackBindingLaunchArgs', 'SpringCloudBuildPackBindingLaunchArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            spring_cloud_builder_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpringCloudBuildPackBinding':
        """
        Get an existing SpringCloudBuildPackBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] binding_type: Specifies the Build Pack Binding Type. Allowed values are `ApacheSkyWalking`, `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        :param pulumi.Input[Union['SpringCloudBuildPackBindingLaunchArgs', 'SpringCloudBuildPackBindingLaunchArgsDict']] launch: A `launch` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Build Pack Binding. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_builder_id: The ID of the Spring Cloud Builder. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudBuildPackBindingState.__new__(_SpringCloudBuildPackBindingState)

        __props__.__dict__["binding_type"] = binding_type
        __props__.__dict__["launch"] = launch
        __props__.__dict__["name"] = name
        __props__.__dict__["spring_cloud_builder_id"] = spring_cloud_builder_id
        return SpringCloudBuildPackBinding(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bindingType")
    def binding_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Build Pack Binding Type. Allowed values are `ApacheSkyWalking`, `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        """
        return pulumi.get(self, "binding_type")

    @_builtins.property
    @pulumi.getter
    def launch(self) -> pulumi.Output[Optional['outputs.SpringCloudBuildPackBindingLaunch']]:
        """
        A `launch` block as defined below.
        """
        return pulumi.get(self, "launch")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Spring Cloud Build Pack Binding. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="springCloudBuilderId")
    def spring_cloud_builder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Spring Cloud Builder. Changing this forces a new Spring Cloud Build Pack Binding to be created.
        """
        return pulumi.get(self, "spring_cloud_builder_id")

