# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudServiceArgs', 'SpringCloudService']

@pulumi.input_type
class SpringCloudServiceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 build_agent_pool_size: Optional[pulumi.Input[_builtins.str]] = None,
                 config_server_git_setting: Optional[pulumi.Input['SpringCloudServiceConfigServerGitSettingArgs']] = None,
                 container_registries: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceContainerRegistryArgs']]]] = None,
                 default_build_service: Optional[pulumi.Input['SpringCloudServiceDefaultBuildServiceArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_public_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 marketplace: Optional[pulumi.Input['SpringCloudServiceMarketplaceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['SpringCloudServiceNetworkArgs']] = None,
                 service_registry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trace: Optional[pulumi.Input['SpringCloudServiceTraceArgs']] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SpringCloudService resource.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies The name of the resource group in which to create the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] build_agent_pool_size: Specifies the size for this Spring Cloud Service's default build agent pool. Possible values are `S1`, `S2`, `S3`, `S4` and `S5`. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input['SpringCloudServiceConfigServerGitSettingArgs'] config_server_git_setting: A `config_server_git_setting` block as defined below. This field is applicable only for Spring Cloud Service with basic and standard tier.
        :param pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceContainerRegistryArgs']]] container_registries: One or more `container_registry` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input['SpringCloudServiceDefaultBuildServiceArgs'] default_build_service: A `default_build_service` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] log_stream_public_endpoint_enabled: Should the log stream in vnet injection instance could be accessed from Internet?
        :param pulumi.Input[_builtins.str] managed_environment_id: The resource Id of the Managed Environment that the Spring Apps instance builds on. Can only be specified when `sku_tier` is set to `StandardGen2`.
        :param pulumi.Input['SpringCloudServiceMarketplaceArgs'] marketplace: A `marketplace` block as defined below. Can only be specified when `sku` is set to `E0`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input['SpringCloudServiceNetworkArgs'] network: A `network` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] service_registry_enabled: Whether enable the default Service Registry. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Spring Cloud Service. Possible values are `B0`, `S0` and `E0`. Defaults to `S0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_tier: Specifies the SKU Tier for this Spring Cloud Service. Possible values are `Basic`, `Enterprise`, `Standard` and `StandardGen2`. The attribute is automatically computed from API response except when `managed_environment_id` is defined. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['SpringCloudServiceTraceArgs'] trace: A `trace` block as defined below.
        :param pulumi.Input[_builtins.bool] zone_redundant: Whether zone redundancy is enabled for this Spring Cloud Service. Defaults to `false`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if build_agent_pool_size is not None:
            pulumi.set(__self__, "build_agent_pool_size", build_agent_pool_size)
        if config_server_git_setting is not None:
            pulumi.set(__self__, "config_server_git_setting", config_server_git_setting)
        if container_registries is not None:
            pulumi.set(__self__, "container_registries", container_registries)
        if default_build_service is not None:
            pulumi.set(__self__, "default_build_service", default_build_service)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_stream_public_endpoint_enabled is not None:
            pulumi.set(__self__, "log_stream_public_endpoint_enabled", log_stream_public_endpoint_enabled)
        if managed_environment_id is not None:
            pulumi.set(__self__, "managed_environment_id", managed_environment_id)
        if marketplace is not None:
            pulumi.set(__self__, "marketplace", marketplace)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if service_registry_enabled is not None:
            pulumi.set(__self__, "service_registry_enabled", service_registry_enabled)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if sku_tier is not None:
            pulumi.set(__self__, "sku_tier", sku_tier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trace is not None:
            pulumi.set(__self__, "trace", trace)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies The name of the resource group in which to create the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="buildAgentPoolSize")
    def build_agent_pool_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the size for this Spring Cloud Service's default build agent pool. Possible values are `S1`, `S2`, `S3`, `S4` and `S5`. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "build_agent_pool_size")

    @build_agent_pool_size.setter
    def build_agent_pool_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_agent_pool_size", value)

    @_builtins.property
    @pulumi.getter(name="configServerGitSetting")
    def config_server_git_setting(self) -> Optional[pulumi.Input['SpringCloudServiceConfigServerGitSettingArgs']]:
        """
        A `config_server_git_setting` block as defined below. This field is applicable only for Spring Cloud Service with basic and standard tier.
        """
        return pulumi.get(self, "config_server_git_setting")

    @config_server_git_setting.setter
    def config_server_git_setting(self, value: Optional[pulumi.Input['SpringCloudServiceConfigServerGitSettingArgs']]):
        pulumi.set(self, "config_server_git_setting", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistries")
    def container_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceContainerRegistryArgs']]]]:
        """
        One or more `container_registry` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "container_registries")

    @container_registries.setter
    def container_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceContainerRegistryArgs']]]]):
        pulumi.set(self, "container_registries", value)

    @_builtins.property
    @pulumi.getter(name="defaultBuildService")
    def default_build_service(self) -> Optional[pulumi.Input['SpringCloudServiceDefaultBuildServiceArgs']]:
        """
        A `default_build_service` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "default_build_service")

    @default_build_service.setter
    def default_build_service(self, value: Optional[pulumi.Input['SpringCloudServiceDefaultBuildServiceArgs']]):
        pulumi.set(self, "default_build_service", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logStreamPublicEndpointEnabled")
    def log_stream_public_endpoint_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the log stream in vnet injection instance could be accessed from Internet?
        """
        return pulumi.get(self, "log_stream_public_endpoint_enabled")

    @log_stream_public_endpoint_enabled.setter
    def log_stream_public_endpoint_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_stream_public_endpoint_enabled", value)

    @_builtins.property
    @pulumi.getter(name="managedEnvironmentId")
    def managed_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource Id of the Managed Environment that the Spring Apps instance builds on. Can only be specified when `sku_tier` is set to `StandardGen2`.
        """
        return pulumi.get(self, "managed_environment_id")

    @managed_environment_id.setter
    def managed_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def marketplace(self) -> Optional[pulumi.Input['SpringCloudServiceMarketplaceArgs']]:
        """
        A `marketplace` block as defined below. Can only be specified when `sku` is set to `E0`.
        """
        return pulumi.get(self, "marketplace")

    @marketplace.setter
    def marketplace(self, value: Optional[pulumi.Input['SpringCloudServiceMarketplaceArgs']]):
        pulumi.set(self, "marketplace", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['SpringCloudServiceNetworkArgs']]:
        """
        A `network` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['SpringCloudServiceNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="serviceRegistryEnabled")
    def service_registry_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the default Service Registry. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "service_registry_enabled")

    @service_registry_enabled.setter
    def service_registry_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "service_registry_enabled", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU Name for this Spring Cloud Service. Possible values are `B0`, `S0` and `E0`. Defaults to `S0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU Tier for this Spring Cloud Service. Possible values are `Basic`, `Enterprise`, `Standard` and `StandardGen2`. The attribute is automatically computed from API response except when `managed_environment_id` is defined. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_tier")

    @sku_tier.setter
    def sku_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_tier", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def trace(self) -> Optional[pulumi.Input['SpringCloudServiceTraceArgs']]:
        """
        A `trace` block as defined below.
        """
        return pulumi.get(self, "trace")

    @trace.setter
    def trace(self, value: Optional[pulumi.Input['SpringCloudServiceTraceArgs']]):
        pulumi.set(self, "trace", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether zone redundancy is enabled for this Spring Cloud Service. Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.input_type
class _SpringCloudServiceState:
    def __init__(__self__, *,
                 build_agent_pool_size: Optional[pulumi.Input[_builtins.str]] = None,
                 config_server_git_setting: Optional[pulumi.Input['SpringCloudServiceConfigServerGitSettingArgs']] = None,
                 container_registries: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceContainerRegistryArgs']]]] = None,
                 default_build_service: Optional[pulumi.Input['SpringCloudServiceDefaultBuildServiceArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_public_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 marketplace: Optional[pulumi.Input['SpringCloudServiceMarketplaceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['SpringCloudServiceNetworkArgs']] = None,
                 outbound_public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 required_network_traffic_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceRequiredNetworkTrafficRuleArgs']]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_registry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trace: Optional[pulumi.Input['SpringCloudServiceTraceArgs']] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SpringCloudService resources.
        :param pulumi.Input[_builtins.str] build_agent_pool_size: Specifies the size for this Spring Cloud Service's default build agent pool. Possible values are `S1`, `S2`, `S3`, `S4` and `S5`. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input['SpringCloudServiceConfigServerGitSettingArgs'] config_server_git_setting: A `config_server_git_setting` block as defined below. This field is applicable only for Spring Cloud Service with basic and standard tier.
        :param pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceContainerRegistryArgs']]] container_registries: One or more `container_registry` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input['SpringCloudServiceDefaultBuildServiceArgs'] default_build_service: A `default_build_service` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] log_stream_public_endpoint_enabled: Should the log stream in vnet injection instance could be accessed from Internet?
        :param pulumi.Input[_builtins.str] managed_environment_id: The resource Id of the Managed Environment that the Spring Apps instance builds on. Can only be specified when `sku_tier` is set to `StandardGen2`.
        :param pulumi.Input['SpringCloudServiceMarketplaceArgs'] marketplace: A `marketplace` block as defined below. Can only be specified when `sku` is set to `E0`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input['SpringCloudServiceNetworkArgs'] network: A `network` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_public_ip_addresses: A list of the outbound Public IP Addresses used by this Spring Cloud Service.
        :param pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceRequiredNetworkTrafficRuleArgs']]] required_network_traffic_rules: A list of `required_network_traffic_rules` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies The name of the resource group in which to create the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] service_registry_enabled: Whether enable the default Service Registry. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[_builtins.str] service_registry_id: The ID of the Spring Cloud Service Registry.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Spring Cloud Service. Possible values are `B0`, `S0` and `E0`. Defaults to `S0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_tier: Specifies the SKU Tier for this Spring Cloud Service. Possible values are `Basic`, `Enterprise`, `Standard` and `StandardGen2`. The attribute is automatically computed from API response except when `managed_environment_id` is defined. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['SpringCloudServiceTraceArgs'] trace: A `trace` block as defined below.
        :param pulumi.Input[_builtins.bool] zone_redundant: Whether zone redundancy is enabled for this Spring Cloud Service. Defaults to `false`.
        """
        if build_agent_pool_size is not None:
            pulumi.set(__self__, "build_agent_pool_size", build_agent_pool_size)
        if config_server_git_setting is not None:
            pulumi.set(__self__, "config_server_git_setting", config_server_git_setting)
        if container_registries is not None:
            pulumi.set(__self__, "container_registries", container_registries)
        if default_build_service is not None:
            pulumi.set(__self__, "default_build_service", default_build_service)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_stream_public_endpoint_enabled is not None:
            pulumi.set(__self__, "log_stream_public_endpoint_enabled", log_stream_public_endpoint_enabled)
        if managed_environment_id is not None:
            pulumi.set(__self__, "managed_environment_id", managed_environment_id)
        if marketplace is not None:
            pulumi.set(__self__, "marketplace", marketplace)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if outbound_public_ip_addresses is not None:
            pulumi.set(__self__, "outbound_public_ip_addresses", outbound_public_ip_addresses)
        if required_network_traffic_rules is not None:
            pulumi.set(__self__, "required_network_traffic_rules", required_network_traffic_rules)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_registry_enabled is not None:
            pulumi.set(__self__, "service_registry_enabled", service_registry_enabled)
        if service_registry_id is not None:
            pulumi.set(__self__, "service_registry_id", service_registry_id)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if sku_tier is not None:
            pulumi.set(__self__, "sku_tier", sku_tier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trace is not None:
            pulumi.set(__self__, "trace", trace)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @_builtins.property
    @pulumi.getter(name="buildAgentPoolSize")
    def build_agent_pool_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the size for this Spring Cloud Service's default build agent pool. Possible values are `S1`, `S2`, `S3`, `S4` and `S5`. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "build_agent_pool_size")

    @build_agent_pool_size.setter
    def build_agent_pool_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_agent_pool_size", value)

    @_builtins.property
    @pulumi.getter(name="configServerGitSetting")
    def config_server_git_setting(self) -> Optional[pulumi.Input['SpringCloudServiceConfigServerGitSettingArgs']]:
        """
        A `config_server_git_setting` block as defined below. This field is applicable only for Spring Cloud Service with basic and standard tier.
        """
        return pulumi.get(self, "config_server_git_setting")

    @config_server_git_setting.setter
    def config_server_git_setting(self, value: Optional[pulumi.Input['SpringCloudServiceConfigServerGitSettingArgs']]):
        pulumi.set(self, "config_server_git_setting", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistries")
    def container_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceContainerRegistryArgs']]]]:
        """
        One or more `container_registry` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "container_registries")

    @container_registries.setter
    def container_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceContainerRegistryArgs']]]]):
        pulumi.set(self, "container_registries", value)

    @_builtins.property
    @pulumi.getter(name="defaultBuildService")
    def default_build_service(self) -> Optional[pulumi.Input['SpringCloudServiceDefaultBuildServiceArgs']]:
        """
        A `default_build_service` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "default_build_service")

    @default_build_service.setter
    def default_build_service(self, value: Optional[pulumi.Input['SpringCloudServiceDefaultBuildServiceArgs']]):
        pulumi.set(self, "default_build_service", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logStreamPublicEndpointEnabled")
    def log_stream_public_endpoint_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the log stream in vnet injection instance could be accessed from Internet?
        """
        return pulumi.get(self, "log_stream_public_endpoint_enabled")

    @log_stream_public_endpoint_enabled.setter
    def log_stream_public_endpoint_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_stream_public_endpoint_enabled", value)

    @_builtins.property
    @pulumi.getter(name="managedEnvironmentId")
    def managed_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource Id of the Managed Environment that the Spring Apps instance builds on. Can only be specified when `sku_tier` is set to `StandardGen2`.
        """
        return pulumi.get(self, "managed_environment_id")

    @managed_environment_id.setter
    def managed_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def marketplace(self) -> Optional[pulumi.Input['SpringCloudServiceMarketplaceArgs']]:
        """
        A `marketplace` block as defined below. Can only be specified when `sku` is set to `E0`.
        """
        return pulumi.get(self, "marketplace")

    @marketplace.setter
    def marketplace(self, value: Optional[pulumi.Input['SpringCloudServiceMarketplaceArgs']]):
        pulumi.set(self, "marketplace", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['SpringCloudServiceNetworkArgs']]:
        """
        A `network` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['SpringCloudServiceNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="outboundPublicIpAddresses")
    def outbound_public_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the outbound Public IP Addresses used by this Spring Cloud Service.
        """
        return pulumi.get(self, "outbound_public_ip_addresses")

    @outbound_public_ip_addresses.setter
    def outbound_public_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "outbound_public_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="requiredNetworkTrafficRules")
    def required_network_traffic_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceRequiredNetworkTrafficRuleArgs']]]]:
        """
        A list of `required_network_traffic_rules` blocks as defined below.
        """
        return pulumi.get(self, "required_network_traffic_rules")

    @required_network_traffic_rules.setter
    def required_network_traffic_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpringCloudServiceRequiredNetworkTrafficRuleArgs']]]]):
        pulumi.set(self, "required_network_traffic_rules", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies The name of the resource group in which to create the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceRegistryEnabled")
    def service_registry_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the default Service Registry. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "service_registry_enabled")

    @service_registry_enabled.setter
    def service_registry_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "service_registry_enabled", value)

    @_builtins.property
    @pulumi.getter(name="serviceRegistryId")
    def service_registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Spring Cloud Service Registry.
        """
        return pulumi.get(self, "service_registry_id")

    @service_registry_id.setter
    def service_registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_registry_id", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU Name for this Spring Cloud Service. Possible values are `B0`, `S0` and `E0`. Defaults to `S0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU Tier for this Spring Cloud Service. Possible values are `Basic`, `Enterprise`, `Standard` and `StandardGen2`. The attribute is automatically computed from API response except when `managed_environment_id` is defined. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_tier")

    @sku_tier.setter
    def sku_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_tier", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def trace(self) -> Optional[pulumi.Input['SpringCloudServiceTraceArgs']]:
        """
        A `trace` block as defined below.
        """
        return pulumi.get(self, "trace")

    @trace.setter
    def trace(self, value: Optional[pulumi.Input['SpringCloudServiceTraceArgs']]):
        pulumi.set(self, "trace", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether zone redundancy is enabled for this Spring Cloud Service. Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.type_token("azure:appplatform/springCloudService:SpringCloudService")
class SpringCloudService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_agent_pool_size: Optional[pulumi.Input[_builtins.str]] = None,
                 config_server_git_setting: Optional[pulumi.Input[Union['SpringCloudServiceConfigServerGitSettingArgs', 'SpringCloudServiceConfigServerGitSettingArgsDict']]] = None,
                 container_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudServiceContainerRegistryArgs', 'SpringCloudServiceContainerRegistryArgsDict']]]]] = None,
                 default_build_service: Optional[pulumi.Input[Union['SpringCloudServiceDefaultBuildServiceArgs', 'SpringCloudServiceDefaultBuildServiceArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_public_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 marketplace: Optional[pulumi.Input[Union['SpringCloudServiceMarketplaceArgs', 'SpringCloudServiceMarketplaceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['SpringCloudServiceNetworkArgs', 'SpringCloudServiceNetworkArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_registry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trace: Optional[pulumi.Input[Union['SpringCloudServiceTraceArgs', 'SpringCloudServiceTraceArgsDict']]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages an Azure Spring Cloud Service.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudService` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="tf-test-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="S0",
            config_server_git_setting={
                "uri": "https://github.com/Azure-Samples/piggymetrics",
                "label": "config",
                "search_paths": [
                    "dir1",
                    "dir2",
                ],
            },
            trace={
                "connection_string": example_insights.connection_string,
                "sample_rate": 10,
            },
            tags={
                "Env": "staging",
            })
        ```

        ## Import

        Spring Cloud services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudService:SpringCloudService example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AppPlatform/spring/spring1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] build_agent_pool_size: Specifies the size for this Spring Cloud Service's default build agent pool. Possible values are `S1`, `S2`, `S3`, `S4` and `S5`. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[Union['SpringCloudServiceConfigServerGitSettingArgs', 'SpringCloudServiceConfigServerGitSettingArgsDict']] config_server_git_setting: A `config_server_git_setting` block as defined below. This field is applicable only for Spring Cloud Service with basic and standard tier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudServiceContainerRegistryArgs', 'SpringCloudServiceContainerRegistryArgsDict']]]] container_registries: One or more `container_registry` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[Union['SpringCloudServiceDefaultBuildServiceArgs', 'SpringCloudServiceDefaultBuildServiceArgsDict']] default_build_service: A `default_build_service` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] log_stream_public_endpoint_enabled: Should the log stream in vnet injection instance could be accessed from Internet?
        :param pulumi.Input[_builtins.str] managed_environment_id: The resource Id of the Managed Environment that the Spring Apps instance builds on. Can only be specified when `sku_tier` is set to `StandardGen2`.
        :param pulumi.Input[Union['SpringCloudServiceMarketplaceArgs', 'SpringCloudServiceMarketplaceArgsDict']] marketplace: A `marketplace` block as defined below. Can only be specified when `sku` is set to `E0`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SpringCloudServiceNetworkArgs', 'SpringCloudServiceNetworkArgsDict']] network: A `network` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies The name of the resource group in which to create the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] service_registry_enabled: Whether enable the default Service Registry. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Spring Cloud Service. Possible values are `B0`, `S0` and `E0`. Defaults to `S0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_tier: Specifies the SKU Tier for this Spring Cloud Service. Possible values are `Basic`, `Enterprise`, `Standard` and `StandardGen2`. The attribute is automatically computed from API response except when `managed_environment_id` is defined. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['SpringCloudServiceTraceArgs', 'SpringCloudServiceTraceArgsDict']] trace: A `trace` block as defined below.
        :param pulumi.Input[_builtins.bool] zone_redundant: Whether zone redundancy is enabled for this Spring Cloud Service. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Spring Cloud Service.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudService` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="tf-test-appinsights",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="S0",
            config_server_git_setting={
                "uri": "https://github.com/Azure-Samples/piggymetrics",
                "label": "config",
                "search_paths": [
                    "dir1",
                    "dir2",
                ],
            },
            trace={
                "connection_string": example_insights.connection_string,
                "sample_rate": 10,
            },
            tags={
                "Env": "staging",
            })
        ```

        ## Import

        Spring Cloud services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudService:SpringCloudService example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AppPlatform/spring/spring1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_agent_pool_size: Optional[pulumi.Input[_builtins.str]] = None,
                 config_server_git_setting: Optional[pulumi.Input[Union['SpringCloudServiceConfigServerGitSettingArgs', 'SpringCloudServiceConfigServerGitSettingArgsDict']]] = None,
                 container_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudServiceContainerRegistryArgs', 'SpringCloudServiceContainerRegistryArgsDict']]]]] = None,
                 default_build_service: Optional[pulumi.Input[Union['SpringCloudServiceDefaultBuildServiceArgs', 'SpringCloudServiceDefaultBuildServiceArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_stream_public_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 managed_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 marketplace: Optional[pulumi.Input[Union['SpringCloudServiceMarketplaceArgs', 'SpringCloudServiceMarketplaceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['SpringCloudServiceNetworkArgs', 'SpringCloudServiceNetworkArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_registry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trace: Optional[pulumi.Input[Union['SpringCloudServiceTraceArgs', 'SpringCloudServiceTraceArgsDict']]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudServiceArgs.__new__(SpringCloudServiceArgs)

            __props__.__dict__["build_agent_pool_size"] = build_agent_pool_size
            __props__.__dict__["config_server_git_setting"] = config_server_git_setting
            __props__.__dict__["container_registries"] = container_registries
            __props__.__dict__["default_build_service"] = default_build_service
            __props__.__dict__["location"] = location
            __props__.__dict__["log_stream_public_endpoint_enabled"] = log_stream_public_endpoint_enabled
            __props__.__dict__["managed_environment_id"] = managed_environment_id
            __props__.__dict__["marketplace"] = marketplace
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["service_registry_enabled"] = service_registry_enabled
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["sku_tier"] = sku_tier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trace"] = trace
            __props__.__dict__["zone_redundant"] = zone_redundant
            __props__.__dict__["outbound_public_ip_addresses"] = None
            __props__.__dict__["required_network_traffic_rules"] = None
            __props__.__dict__["service_registry_id"] = None
        super(SpringCloudService, __self__).__init__(
            'azure:appplatform/springCloudService:SpringCloudService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            build_agent_pool_size: Optional[pulumi.Input[_builtins.str]] = None,
            config_server_git_setting: Optional[pulumi.Input[Union['SpringCloudServiceConfigServerGitSettingArgs', 'SpringCloudServiceConfigServerGitSettingArgsDict']]] = None,
            container_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudServiceContainerRegistryArgs', 'SpringCloudServiceContainerRegistryArgsDict']]]]] = None,
            default_build_service: Optional[pulumi.Input[Union['SpringCloudServiceDefaultBuildServiceArgs', 'SpringCloudServiceDefaultBuildServiceArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            log_stream_public_endpoint_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            managed_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            marketplace: Optional[pulumi.Input[Union['SpringCloudServiceMarketplaceArgs', 'SpringCloudServiceMarketplaceArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[Union['SpringCloudServiceNetworkArgs', 'SpringCloudServiceNetworkArgsDict']]] = None,
            outbound_public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            required_network_traffic_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudServiceRequiredNetworkTrafficRuleArgs', 'SpringCloudServiceRequiredNetworkTrafficRuleArgsDict']]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_registry_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            service_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_tier: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            trace: Optional[pulumi.Input[Union['SpringCloudServiceTraceArgs', 'SpringCloudServiceTraceArgsDict']]] = None,
            zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SpringCloudService':
        """
        Get an existing SpringCloudService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] build_agent_pool_size: Specifies the size for this Spring Cloud Service's default build agent pool. Possible values are `S1`, `S2`, `S3`, `S4` and `S5`. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[Union['SpringCloudServiceConfigServerGitSettingArgs', 'SpringCloudServiceConfigServerGitSettingArgsDict']] config_server_git_setting: A `config_server_git_setting` block as defined below. This field is applicable only for Spring Cloud Service with basic and standard tier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudServiceContainerRegistryArgs', 'SpringCloudServiceContainerRegistryArgsDict']]]] container_registries: One or more `container_registry` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[Union['SpringCloudServiceDefaultBuildServiceArgs', 'SpringCloudServiceDefaultBuildServiceArgsDict']] default_build_service: A `default_build_service` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] log_stream_public_endpoint_enabled: Should the log stream in vnet injection instance could be accessed from Internet?
        :param pulumi.Input[_builtins.str] managed_environment_id: The resource Id of the Managed Environment that the Spring Apps instance builds on. Can only be specified when `sku_tier` is set to `StandardGen2`.
        :param pulumi.Input[Union['SpringCloudServiceMarketplaceArgs', 'SpringCloudServiceMarketplaceArgsDict']] marketplace: A `marketplace` block as defined below. Can only be specified when `sku` is set to `E0`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SpringCloudServiceNetworkArgs', 'SpringCloudServiceNetworkArgsDict']] network: A `network` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_public_ip_addresses: A list of the outbound Public IP Addresses used by this Spring Cloud Service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SpringCloudServiceRequiredNetworkTrafficRuleArgs', 'SpringCloudServiceRequiredNetworkTrafficRuleArgsDict']]]] required_network_traffic_rules: A list of `required_network_traffic_rules` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies The name of the resource group in which to create the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] service_registry_enabled: Whether enable the default Service Registry. This field is applicable only for Spring Cloud Service with enterprise tier.
        :param pulumi.Input[_builtins.str] service_registry_id: The ID of the Spring Cloud Service Registry.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Spring Cloud Service. Possible values are `B0`, `S0` and `E0`. Defaults to `S0`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_tier: Specifies the SKU Tier for this Spring Cloud Service. Possible values are `Basic`, `Enterprise`, `Standard` and `StandardGen2`. The attribute is automatically computed from API response except when `managed_environment_id` is defined. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['SpringCloudServiceTraceArgs', 'SpringCloudServiceTraceArgsDict']] trace: A `trace` block as defined below.
        :param pulumi.Input[_builtins.bool] zone_redundant: Whether zone redundancy is enabled for this Spring Cloud Service. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudServiceState.__new__(_SpringCloudServiceState)

        __props__.__dict__["build_agent_pool_size"] = build_agent_pool_size
        __props__.__dict__["config_server_git_setting"] = config_server_git_setting
        __props__.__dict__["container_registries"] = container_registries
        __props__.__dict__["default_build_service"] = default_build_service
        __props__.__dict__["location"] = location
        __props__.__dict__["log_stream_public_endpoint_enabled"] = log_stream_public_endpoint_enabled
        __props__.__dict__["managed_environment_id"] = managed_environment_id
        __props__.__dict__["marketplace"] = marketplace
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["outbound_public_ip_addresses"] = outbound_public_ip_addresses
        __props__.__dict__["required_network_traffic_rules"] = required_network_traffic_rules
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["service_registry_enabled"] = service_registry_enabled
        __props__.__dict__["service_registry_id"] = service_registry_id
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["sku_tier"] = sku_tier
        __props__.__dict__["tags"] = tags
        __props__.__dict__["trace"] = trace
        __props__.__dict__["zone_redundant"] = zone_redundant
        return SpringCloudService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="buildAgentPoolSize")
    def build_agent_pool_size(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the size for this Spring Cloud Service's default build agent pool. Possible values are `S1`, `S2`, `S3`, `S4` and `S5`. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "build_agent_pool_size")

    @_builtins.property
    @pulumi.getter(name="configServerGitSetting")
    def config_server_git_setting(self) -> pulumi.Output[Optional['outputs.SpringCloudServiceConfigServerGitSetting']]:
        """
        A `config_server_git_setting` block as defined below. This field is applicable only for Spring Cloud Service with basic and standard tier.
        """
        return pulumi.get(self, "config_server_git_setting")

    @_builtins.property
    @pulumi.getter(name="containerRegistries")
    def container_registries(self) -> pulumi.Output[Optional[Sequence['outputs.SpringCloudServiceContainerRegistry']]]:
        """
        One or more `container_registry` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "container_registries")

    @_builtins.property
    @pulumi.getter(name="defaultBuildService")
    def default_build_service(self) -> pulumi.Output[Optional['outputs.SpringCloudServiceDefaultBuildService']]:
        """
        A `default_build_service` block as defined below. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "default_build_service")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logStreamPublicEndpointEnabled")
    def log_stream_public_endpoint_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the log stream in vnet injection instance could be accessed from Internet?
        """
        return pulumi.get(self, "log_stream_public_endpoint_enabled")

    @_builtins.property
    @pulumi.getter(name="managedEnvironmentId")
    def managed_environment_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource Id of the Managed Environment that the Spring Apps instance builds on. Can only be specified when `sku_tier` is set to `StandardGen2`.
        """
        return pulumi.get(self, "managed_environment_id")

    @_builtins.property
    @pulumi.getter
    def marketplace(self) -> pulumi.Output['outputs.SpringCloudServiceMarketplace']:
        """
        A `marketplace` block as defined below. Can only be specified when `sku` is set to `E0`.
        """
        return pulumi.get(self, "marketplace")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional['outputs.SpringCloudServiceNetwork']]:
        """
        A `network` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="outboundPublicIpAddresses")
    def outbound_public_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of the outbound Public IP Addresses used by this Spring Cloud Service.
        """
        return pulumi.get(self, "outbound_public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="requiredNetworkTrafficRules")
    def required_network_traffic_rules(self) -> pulumi.Output[Sequence['outputs.SpringCloudServiceRequiredNetworkTrafficRule']]:
        """
        A list of `required_network_traffic_rules` blocks as defined below.
        """
        return pulumi.get(self, "required_network_traffic_rules")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies The name of the resource group in which to create the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="serviceRegistryEnabled")
    def service_registry_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether enable the default Service Registry. This field is applicable only for Spring Cloud Service with enterprise tier.
        """
        return pulumi.get(self, "service_registry_enabled")

    @_builtins.property
    @pulumi.getter(name="serviceRegistryId")
    def service_registry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Spring Cloud Service Registry.
        """
        return pulumi.get(self, "service_registry_id")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the SKU Name for this Spring Cloud Service. Possible values are `B0`, `S0` and `E0`. Defaults to `S0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="skuTier")
    def sku_tier(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SKU Tier for this Spring Cloud Service. Possible values are `Basic`, `Enterprise`, `Standard` and `StandardGen2`. The attribute is automatically computed from API response except when `managed_environment_id` is defined. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_tier")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def trace(self) -> pulumi.Output[Optional['outputs.SpringCloudServiceTrace']]:
        """
        A `trace` block as defined below.
        """
        return pulumi.get(self, "trace")

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether zone redundancy is enabled for this Spring Cloud Service. Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundant")

