# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ActiveSlotArgs', 'ActiveSlot']

@pulumi.input_type
class ActiveSlotArgs:
    def __init__(__self__, *,
                 app_service_name: pulumi.Input[_builtins.str],
                 app_service_slot_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ActiveSlot resource.
        :param pulumi.Input[_builtins.str] app_service_name: The name of the App Service within which the Slot exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] app_service_slot_name: The name of the App Service Slot which should be promoted to the Production Slot within the App Service.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the App Service exists. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "app_service_name", app_service_name)
        pulumi.set(__self__, "app_service_slot_name", app_service_slot_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="appServiceName")
    def app_service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the App Service within which the Slot exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_service_name")

    @app_service_name.setter
    def app_service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_service_name", value)

    @_builtins.property
    @pulumi.getter(name="appServiceSlotName")
    def app_service_slot_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the App Service Slot which should be promoted to the Production Slot within the App Service.
        """
        return pulumi.get(self, "app_service_slot_name")

    @app_service_slot_name.setter
    def app_service_slot_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_service_slot_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the App Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.input_type
class _ActiveSlotState:
    def __init__(__self__, *,
                 app_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service_slot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ActiveSlot resources.
        :param pulumi.Input[_builtins.str] app_service_name: The name of the App Service within which the Slot exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] app_service_slot_name: The name of the App Service Slot which should be promoted to the Production Slot within the App Service.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the App Service exists. Changing this forces a new resource to be created.
        """
        if app_service_name is not None:
            pulumi.set(__self__, "app_service_name", app_service_name)
        if app_service_slot_name is not None:
            pulumi.set(__self__, "app_service_slot_name", app_service_slot_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="appServiceName")
    def app_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the App Service within which the Slot exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_service_name")

    @app_service_name.setter
    def app_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service_name", value)

    @_builtins.property
    @pulumi.getter(name="appServiceSlotName")
    def app_service_slot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the App Service Slot which should be promoted to the Production Slot within the App Service.
        """
        return pulumi.get(self, "app_service_slot_name")

    @app_service_slot_name.setter
    def app_service_slot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service_slot_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the App Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:appservice/activeSlot:ActiveSlot")
class ActiveSlot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service_slot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Promotes an App Service Slot to Production within an App Service.

        !> **NOTE:** This resource has been deprecated in version 5.0 of the provider and will be removed in version 6.0. Please use `appservice.WebAppActiveSlot` resource instead.

        > **Note:** When using Slots - the `app_settings`, `connection_string` and `site_config` blocks on the `appservice.AppService` resource will be overwritten when promoting a Slot using the `appservice.ActiveSlot` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        server = random.RandomId("server")
        example = azure.core.ResourceGroup("example")
        example_plan = azure.appservice.Plan("example")
        example_app_service = azure.appservice.AppService("example")
        example_slot = azure.appservice.Slot("example")
        example_active_slot = azure.appservice.ActiveSlot("example",
            resource_group_name=example.name,
            app_service_name=example_app_service.name,
            app_service_slot_name=example_slot.name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_name: The name of the App Service within which the Slot exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] app_service_slot_name: The name of the App Service Slot which should be promoted to the Production Slot within the App Service.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the App Service exists. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActiveSlotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Promotes an App Service Slot to Production within an App Service.

        !> **NOTE:** This resource has been deprecated in version 5.0 of the provider and will be removed in version 6.0. Please use `appservice.WebAppActiveSlot` resource instead.

        > **Note:** When using Slots - the `app_settings`, `connection_string` and `site_config` blocks on the `appservice.AppService` resource will be overwritten when promoting a Slot using the `appservice.ActiveSlot` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        server = random.RandomId("server")
        example = azure.core.ResourceGroup("example")
        example_plan = azure.appservice.Plan("example")
        example_app_service = azure.appservice.AppService("example")
        example_slot = azure.appservice.Slot("example")
        example_active_slot = azure.appservice.ActiveSlot("example",
            resource_group_name=example.name,
            app_service_name=example_app_service.name,
            app_service_slot_name=example_slot.name)
        ```

        :param str resource_name: The name of the resource.
        :param ActiveSlotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActiveSlotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service_slot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActiveSlotArgs.__new__(ActiveSlotArgs)

            if app_service_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_service_name'")
            __props__.__dict__["app_service_name"] = app_service_name
            if app_service_slot_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_service_slot_name'")
            __props__.__dict__["app_service_slot_name"] = app_service_slot_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(ActiveSlot, __self__).__init__(
            'azure:appservice/activeSlot:ActiveSlot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_service_slot_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ActiveSlot':
        """
        Get an existing ActiveSlot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_name: The name of the App Service within which the Slot exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] app_service_slot_name: The name of the App Service Slot which should be promoted to the Production Slot within the App Service.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the App Service exists. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActiveSlotState.__new__(_ActiveSlotState)

        __props__.__dict__["app_service_name"] = app_service_name
        __props__.__dict__["app_service_slot_name"] = app_service_slot_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return ActiveSlot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appServiceName")
    def app_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the App Service within which the Slot exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_service_name")

    @_builtins.property
    @pulumi.getter(name="appServiceSlotName")
    def app_service_slot_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the App Service Slot which should be promoted to the Production Slot within the App Service.
        """
        return pulumi.get(self, "app_service_slot_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the App Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

