# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppConnectionArgs', 'AppConnection']

@pulumi.input_type
class AppConnectionArgs:
    def __init__(__self__, *,
                 authentication: pulumi.Input['AppConnectionAuthenticationArgs'],
                 function_app_id: pulumi.Input[_builtins.str],
                 target_resource_id: pulumi.Input[_builtins.str],
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_store: Optional[pulumi.Input['AppConnectionSecretStoreArgs']] = None,
                 vnet_solution: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppConnection resource.
        :param pulumi.Input['AppConnectionAuthenticationArgs'] authentication: The authentication info. An `authentication` block as defined below.
               
               > **Note:** If a Managed Identity is used, this will need to be configured on the App Service.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of the data source function app. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        :param pulumi.Input[_builtins.str] name: The name of the service connection. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "function_app_id", function_app_id)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if client_type is not None:
            pulumi.set(__self__, "client_type", client_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_store is not None:
            pulumi.set(__self__, "secret_store", secret_store)
        if vnet_solution is not None:
            pulumi.set(__self__, "vnet_solution", vnet_solution)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Input['AppConnectionAuthenticationArgs']:
        """
        The authentication info. An `authentication` block as defined below.

        > **Note:** If a Managed Identity is used, this will need to be configured on the App Service.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input['AppConnectionAuthenticationArgs']):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the data source function app. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_app_id")

    @function_app_id.setter
    def function_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_app_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> Optional[pulumi.Input['AppConnectionSecretStoreArgs']]:
        return pulumi.get(self, "secret_store")

    @secret_store.setter
    def secret_store(self, value: Optional[pulumi.Input['AppConnectionSecretStoreArgs']]):
        pulumi.set(self, "secret_store", value)

    @_builtins.property
    @pulumi.getter(name="vnetSolution")
    def vnet_solution(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vnet_solution")

    @vnet_solution.setter
    def vnet_solution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnet_solution", value)


@pulumi.input_type
class _AppConnectionState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['AppConnectionAuthenticationArgs']] = None,
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_store: Optional[pulumi.Input['AppConnectionSecretStoreArgs']] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_solution: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppConnection resources.
        :param pulumi.Input['AppConnectionAuthenticationArgs'] authentication: The authentication info. An `authentication` block as defined below.
               
               > **Note:** If a Managed Identity is used, this will need to be configured on the App Service.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of the data source function app. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the service connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if client_type is not None:
            pulumi.set(__self__, "client_type", client_type)
        if function_app_id is not None:
            pulumi.set(__self__, "function_app_id", function_app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_store is not None:
            pulumi.set(__self__, "secret_store", secret_store)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if vnet_solution is not None:
            pulumi.set(__self__, "vnet_solution", vnet_solution)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['AppConnectionAuthenticationArgs']]:
        """
        The authentication info. An `authentication` block as defined below.

        > **Note:** If a Managed Identity is used, this will need to be configured on the App Service.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['AppConnectionAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_type", value)

    @_builtins.property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the data source function app. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_app_id")

    @function_app_id.setter
    def function_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_app_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> Optional[pulumi.Input['AppConnectionSecretStoreArgs']]:
        return pulumi.get(self, "secret_store")

    @secret_store.setter
    def secret_store(self, value: Optional[pulumi.Input['AppConnectionSecretStoreArgs']]):
        pulumi.set(self, "secret_store", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="vnetSolution")
    def vnet_solution(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vnet_solution")

    @vnet_solution.setter
    def vnet_solution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnet_solution", value)


@pulumi.type_token("azure:appservice/appConnection:AppConnection")
class AppConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['AppConnectionAuthenticationArgs', 'AppConnectionAuthenticationArgsDict']]] = None,
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_store: Optional[pulumi.Input[Union['AppConnectionSecretStoreArgs', 'AppConnectionSecretStoreArgsDict']]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_solution: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a service connector for function app.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cosmosdb.Account("example",
            name="example-cosmosdb-account",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "BoundedStaleness",
                "max_interval_in_seconds": 10,
                "max_staleness_prefix": 200,
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_sql_database = azure.cosmosdb.SqlDatabase("example",
            name="cosmos-sql-db",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name,
            throughput=400)
        example_sql_container = azure.cosmosdb.SqlContainer("example",
            name="example-container",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name,
            database_name=example_sql_database.name,
            partition_key_path="/definition")
        example_account2 = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            location=example.location,
            name="example-serviceplan",
            resource_group_name=example.name,
            sku_name="P1v2",
            os_type="Linux")
        test = azure.appservice.FunctionApp("test",
            name="example-function-app",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            app_service_plan_id=test_azurerm_app_service_plan["id"],
            storage_account_name=test_azurerm_storage_account["name"],
            storage_account_access_key=test_azurerm_storage_account["primaryAccessKey"])
        example_app_connection = azure.appservice.AppConnection("example",
            name="example-serviceconnector",
            function_app_id=example_azurerm_function_app["id"],
            target_resource_id=test_azurerm_cosmosdb_account["id"],
            authentication={
                "type": "systemAssignedIdentity",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceLinker` - 2024-04-01, 2022-05-01

        ## Import

        Service Connector for app service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/appConnection:AppConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Web/sites/webapp/providers/Microsoft.ServiceLinker/linkers/serviceconnector1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AppConnectionAuthenticationArgs', 'AppConnectionAuthenticationArgsDict']] authentication: The authentication info. An `authentication` block as defined below.
               
               > **Note:** If a Managed Identity is used, this will need to be configured on the App Service.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of the data source function app. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the service connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a service connector for function app.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cosmosdb.Account("example",
            name="example-cosmosdb-account",
            location=example.location,
            resource_group_name=example.name,
            offer_type="Standard",
            kind="GlobalDocumentDB",
            consistency_policy={
                "consistency_level": "BoundedStaleness",
                "max_interval_in_seconds": 10,
                "max_staleness_prefix": 200,
            },
            geo_locations=[{
                "location": example.location,
                "failover_priority": 0,
            }])
        example_sql_database = azure.cosmosdb.SqlDatabase("example",
            name="cosmos-sql-db",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name,
            throughput=400)
        example_sql_container = azure.cosmosdb.SqlContainer("example",
            name="example-container",
            resource_group_name=example_account.resource_group_name,
            account_name=example_account.name,
            database_name=example_sql_database.name,
            partition_key_path="/definition")
        example_account2 = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            location=example.location,
            name="example-serviceplan",
            resource_group_name=example.name,
            sku_name="P1v2",
            os_type="Linux")
        test = azure.appservice.FunctionApp("test",
            name="example-function-app",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            app_service_plan_id=test_azurerm_app_service_plan["id"],
            storage_account_name=test_azurerm_storage_account["name"],
            storage_account_access_key=test_azurerm_storage_account["primaryAccessKey"])
        example_app_connection = azure.appservice.AppConnection("example",
            name="example-serviceconnector",
            function_app_id=example_azurerm_function_app["id"],
            target_resource_id=test_azurerm_cosmosdb_account["id"],
            authentication={
                "type": "systemAssignedIdentity",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceLinker` - 2024-04-01, 2022-05-01

        ## Import

        Service Connector for app service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/appConnection:AppConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Web/sites/webapp/providers/Microsoft.ServiceLinker/linkers/serviceconnector1
        ```

        :param str resource_name: The name of the resource.
        :param AppConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['AppConnectionAuthenticationArgs', 'AppConnectionAuthenticationArgsDict']]] = None,
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_store: Optional[pulumi.Input[Union['AppConnectionSecretStoreArgs', 'AppConnectionSecretStoreArgsDict']]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_solution: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppConnectionArgs.__new__(AppConnectionArgs)

            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["client_type"] = client_type
            if function_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'function_app_id'")
            __props__.__dict__["function_app_id"] = function_app_id
            __props__.__dict__["name"] = name
            __props__.__dict__["secret_store"] = secret_store
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            __props__.__dict__["vnet_solution"] = vnet_solution
        super(AppConnection, __self__).__init__(
            'azure:appservice/appConnection:AppConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[Union['AppConnectionAuthenticationArgs', 'AppConnectionAuthenticationArgsDict']]] = None,
            client_type: Optional[pulumi.Input[_builtins.str]] = None,
            function_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_store: Optional[pulumi.Input[Union['AppConnectionSecretStoreArgs', 'AppConnectionSecretStoreArgsDict']]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            vnet_solution: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppConnection':
        """
        Get an existing AppConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AppConnectionAuthenticationArgs', 'AppConnectionAuthenticationArgsDict']] authentication: The authentication info. An `authentication` block as defined below.
               
               > **Note:** If a Managed Identity is used, this will need to be configured on the App Service.
        :param pulumi.Input[_builtins.str] function_app_id: The ID of the data source function app. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the service connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppConnectionState.__new__(_AppConnectionState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["client_type"] = client_type
        __props__.__dict__["function_app_id"] = function_app_id
        __props__.__dict__["name"] = name
        __props__.__dict__["secret_store"] = secret_store
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["vnet_solution"] = vnet_solution
        return AppConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.AppConnectionAuthentication']:
        """
        The authentication info. An `authentication` block as defined below.

        > **Note:** If a Managed Identity is used, this will need to be configured on the App Service.
        """
        return pulumi.get(self, "authentication")

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "client_type")

    @_builtins.property
    @pulumi.getter(name="functionAppId")
    def function_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the data source function app. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_app_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> pulumi.Output[Optional['outputs.AppConnectionSecretStore']]:
        return pulumi.get(self, "secret_store")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter(name="vnetSolution")
    def vnet_solution(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "vnet_solution")

