# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentV3Args', 'EnvironmentV3']

@pulumi.input_type
class EnvironmentV3Args:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 allow_new_private_endpoint_connections: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_settings: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentV3ClusterSettingArgs']]]] = None,
                 dedicated_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_debugging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a EnvironmentV3 resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the App Service Environment exists. Defaults to the Resource Group of the Subnet (specified by `subnet_id`). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet which the App Service Environment should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** a /24 or larger CIDR is required. Once associated with an ASE, this size cannot be changed.
               
               > **Note:** This Subnet requires a delegation to `Microsoft.Web/hostingEnvironments` as detailed in the example above.
        :param pulumi.Input[_builtins.bool] allow_new_private_endpoint_connections: Should new Private Endpoint Connections be allowed. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentV3ClusterSettingArgs']]] cluster_settings: Zero or more `cluster_setting` blocks as defined below.
        :param pulumi.Input[_builtins.int] dedicated_host_count: This ASEv3 should use dedicated Hosts. Possible values are `2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] internal_load_balancing_mode: Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment. Possible values are `None` (for an External VIP Type), and `"Web, Publishing"` (for an Internal VIP Type). Defaults to `None`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the App Service Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] remote_debugging_enabled: Whether to enable remote debug. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] zone_redundant: Set to `true` to deploy the ASEv3 with availability zones supported. Zonal ASEs can be deployed in some regions, you can refer to [Availability Zone support for App Service Environments](https://docs.microsoft.com/azure/app-service/environment/zone-redundancy). You can only set either `dedicated_host_count` or `zone_redundant` but not both. Changing this forces a new resource to be created.
               
               > **Note:** Setting this value will provision 2 Physical Hosts for your App Service Environment V3, this is done at additional cost, please be aware of the pricing commitment in the [General Availability Notes](https://techcommunity.microsoft.com/t5/apps-on-azure/announcing-app-service-environment-v3-ga/ba-p/2517990)
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if allow_new_private_endpoint_connections is not None:
            pulumi.set(__self__, "allow_new_private_endpoint_connections", allow_new_private_endpoint_connections)
        if cluster_settings is not None:
            pulumi.set(__self__, "cluster_settings", cluster_settings)
        if dedicated_host_count is not None:
            pulumi.set(__self__, "dedicated_host_count", dedicated_host_count)
        if internal_load_balancing_mode is not None:
            pulumi.set(__self__, "internal_load_balancing_mode", internal_load_balancing_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_debugging_enabled is not None:
            pulumi.set(__self__, "remote_debugging_enabled", remote_debugging_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the App Service Environment exists. Defaults to the Resource Group of the Subnet (specified by `subnet_id`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Subnet which the App Service Environment should be connected to. Changing this forces a new resource to be created.

        > **Note:** a /24 or larger CIDR is required. Once associated with an ASE, this size cannot be changed.

        > **Note:** This Subnet requires a delegation to `Microsoft.Web/hostingEnvironments` as detailed in the example above.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="allowNewPrivateEndpointConnections")
    def allow_new_private_endpoint_connections(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should new Private Endpoint Connections be allowed. Defaults to `true`.
        """
        return pulumi.get(self, "allow_new_private_endpoint_connections")

    @allow_new_private_endpoint_connections.setter
    def allow_new_private_endpoint_connections(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_new_private_endpoint_connections", value)

    @_builtins.property
    @pulumi.getter(name="clusterSettings")
    def cluster_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentV3ClusterSettingArgs']]]]:
        """
        Zero or more `cluster_setting` blocks as defined below.
        """
        return pulumi.get(self, "cluster_settings")

    @cluster_settings.setter
    def cluster_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentV3ClusterSettingArgs']]]]):
        pulumi.set(self, "cluster_settings", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostCount")
    def dedicated_host_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This ASEv3 should use dedicated Hosts. Possible values are `2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dedicated_host_count")

    @dedicated_host_count.setter
    def dedicated_host_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dedicated_host_count", value)

    @_builtins.property
    @pulumi.getter(name="internalLoadBalancingMode")
    def internal_load_balancing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment. Possible values are `None` (for an External VIP Type), and `"Web, Publishing"` (for an Internal VIP Type). Defaults to `None`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "internal_load_balancing_mode")

    @internal_load_balancing_mode.setter
    def internal_load_balancing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_load_balancing_mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the App Service Environment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="remoteDebuggingEnabled")
    def remote_debugging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable remote debug. Defaults to `false`.
        """
        return pulumi.get(self, "remote_debugging_enabled")

    @remote_debugging_enabled.setter
    def remote_debugging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remote_debugging_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to deploy the ASEv3 with availability zones supported. Zonal ASEs can be deployed in some regions, you can refer to [Availability Zone support for App Service Environments](https://docs.microsoft.com/azure/app-service/environment/zone-redundancy). You can only set either `dedicated_host_count` or `zone_redundant` but not both. Changing this forces a new resource to be created.

        > **Note:** Setting this value will provision 2 Physical Hosts for your App Service Environment V3, this is done at additional cost, please be aware of the pricing commitment in the [General Availability Notes](https://techcommunity.microsoft.com/t5/apps-on-azure/announcing-app-service-environment-v3-ga/ba-p/2517990)
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.input_type
class _EnvironmentV3State:
    def __init__(__self__, *,
                 allow_new_private_endpoint_connections: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_settings: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentV3ClusterSettingArgs']]]] = None,
                 dedicated_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 dns_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 external_inbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inbound_network_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentV3InboundNetworkDependencyArgs']]]] = None,
                 internal_inbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 internal_load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_ssl_address_count: Optional[pulumi.Input[_builtins.int]] = None,
                 linux_outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_debugging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 windows_outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering EnvironmentV3 resources.
        :param pulumi.Input[_builtins.bool] allow_new_private_endpoint_connections: Should new Private Endpoint Connections be allowed. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentV3ClusterSettingArgs']]] cluster_settings: Zero or more `cluster_setting` blocks as defined below.
        :param pulumi.Input[_builtins.int] dedicated_host_count: This ASEv3 should use dedicated Hosts. Possible values are `2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_suffix: the DNS suffix for this App Service Environment V3.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_inbound_ip_addresses: The external inbound IP addresses of the App Service Environment V3.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentV3InboundNetworkDependencyArgs']]] inbound_network_dependencies: An `inbound_network_dependencies` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] internal_inbound_ip_addresses: The internal inbound IP addresses of the App Service Environment V3.
        :param pulumi.Input[_builtins.str] internal_load_balancing_mode: Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment. Possible values are `None` (for an External VIP Type), and `"Web, Publishing"` (for an Internal VIP Type). Defaults to `None`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] ip_ssl_address_count: The number of IP SSL addresses reserved for the App Service Environment V3.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linux_outbound_ip_addresses: Outbound addresses of Linux based Apps in this App Service Environment V3
        :param pulumi.Input[_builtins.str] location: The location where the App Service Environment exists.
        :param pulumi.Input[_builtins.str] name: The name of the App Service Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] pricing_tier: Pricing tier for the front end instances.
        :param pulumi.Input[_builtins.bool] remote_debugging_enabled: Whether to enable remote debug. Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the App Service Environment exists. Defaults to the Resource Group of the Subnet (specified by `subnet_id`). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet which the App Service Environment should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** a /24 or larger CIDR is required. Once associated with an ASE, this size cannot be changed.
               
               > **Note:** This Subnet requires a delegation to `Microsoft.Web/hostingEnvironments` as detailed in the example above.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] windows_outbound_ip_addresses: Outbound addresses of Windows based Apps in this App Service Environment V3.
        :param pulumi.Input[_builtins.bool] zone_redundant: Set to `true` to deploy the ASEv3 with availability zones supported. Zonal ASEs can be deployed in some regions, you can refer to [Availability Zone support for App Service Environments](https://docs.microsoft.com/azure/app-service/environment/zone-redundancy). You can only set either `dedicated_host_count` or `zone_redundant` but not both. Changing this forces a new resource to be created.
               
               > **Note:** Setting this value will provision 2 Physical Hosts for your App Service Environment V3, this is done at additional cost, please be aware of the pricing commitment in the [General Availability Notes](https://techcommunity.microsoft.com/t5/apps-on-azure/announcing-app-service-environment-v3-ga/ba-p/2517990)
        """
        if allow_new_private_endpoint_connections is not None:
            pulumi.set(__self__, "allow_new_private_endpoint_connections", allow_new_private_endpoint_connections)
        if cluster_settings is not None:
            pulumi.set(__self__, "cluster_settings", cluster_settings)
        if dedicated_host_count is not None:
            pulumi.set(__self__, "dedicated_host_count", dedicated_host_count)
        if dns_suffix is not None:
            pulumi.set(__self__, "dns_suffix", dns_suffix)
        if external_inbound_ip_addresses is not None:
            pulumi.set(__self__, "external_inbound_ip_addresses", external_inbound_ip_addresses)
        if inbound_network_dependencies is not None:
            pulumi.set(__self__, "inbound_network_dependencies", inbound_network_dependencies)
        if internal_inbound_ip_addresses is not None:
            pulumi.set(__self__, "internal_inbound_ip_addresses", internal_inbound_ip_addresses)
        if internal_load_balancing_mode is not None:
            pulumi.set(__self__, "internal_load_balancing_mode", internal_load_balancing_mode)
        if ip_ssl_address_count is not None:
            pulumi.set(__self__, "ip_ssl_address_count", ip_ssl_address_count)
        if linux_outbound_ip_addresses is not None:
            pulumi.set(__self__, "linux_outbound_ip_addresses", linux_outbound_ip_addresses)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pricing_tier is not None:
            pulumi.set(__self__, "pricing_tier", pricing_tier)
        if remote_debugging_enabled is not None:
            pulumi.set(__self__, "remote_debugging_enabled", remote_debugging_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if windows_outbound_ip_addresses is not None:
            pulumi.set(__self__, "windows_outbound_ip_addresses", windows_outbound_ip_addresses)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @_builtins.property
    @pulumi.getter(name="allowNewPrivateEndpointConnections")
    def allow_new_private_endpoint_connections(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should new Private Endpoint Connections be allowed. Defaults to `true`.
        """
        return pulumi.get(self, "allow_new_private_endpoint_connections")

    @allow_new_private_endpoint_connections.setter
    def allow_new_private_endpoint_connections(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_new_private_endpoint_connections", value)

    @_builtins.property
    @pulumi.getter(name="clusterSettings")
    def cluster_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentV3ClusterSettingArgs']]]]:
        """
        Zero or more `cluster_setting` blocks as defined below.
        """
        return pulumi.get(self, "cluster_settings")

    @cluster_settings.setter
    def cluster_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentV3ClusterSettingArgs']]]]):
        pulumi.set(self, "cluster_settings", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostCount")
    def dedicated_host_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This ASEv3 should use dedicated Hosts. Possible values are `2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dedicated_host_count")

    @dedicated_host_count.setter
    def dedicated_host_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dedicated_host_count", value)

    @_builtins.property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the DNS suffix for this App Service Environment V3.
        """
        return pulumi.get(self, "dns_suffix")

    @dns_suffix.setter
    def dns_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_suffix", value)

    @_builtins.property
    @pulumi.getter(name="externalInboundIpAddresses")
    def external_inbound_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The external inbound IP addresses of the App Service Environment V3.
        """
        return pulumi.get(self, "external_inbound_ip_addresses")

    @external_inbound_ip_addresses.setter
    def external_inbound_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_inbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="inboundNetworkDependencies")
    def inbound_network_dependencies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentV3InboundNetworkDependencyArgs']]]]:
        """
        An `inbound_network_dependencies` block as defined below.
        """
        return pulumi.get(self, "inbound_network_dependencies")

    @inbound_network_dependencies.setter
    def inbound_network_dependencies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentV3InboundNetworkDependencyArgs']]]]):
        pulumi.set(self, "inbound_network_dependencies", value)

    @_builtins.property
    @pulumi.getter(name="internalInboundIpAddresses")
    def internal_inbound_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The internal inbound IP addresses of the App Service Environment V3.
        """
        return pulumi.get(self, "internal_inbound_ip_addresses")

    @internal_inbound_ip_addresses.setter
    def internal_inbound_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "internal_inbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="internalLoadBalancingMode")
    def internal_load_balancing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment. Possible values are `None` (for an External VIP Type), and `"Web, Publishing"` (for an Internal VIP Type). Defaults to `None`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "internal_load_balancing_mode")

    @internal_load_balancing_mode.setter
    def internal_load_balancing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_load_balancing_mode", value)

    @_builtins.property
    @pulumi.getter(name="ipSslAddressCount")
    def ip_ssl_address_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IP SSL addresses reserved for the App Service Environment V3.
        """
        return pulumi.get(self, "ip_ssl_address_count")

    @ip_ssl_address_count.setter
    def ip_ssl_address_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_ssl_address_count", value)

    @_builtins.property
    @pulumi.getter(name="linuxOutboundIpAddresses")
    def linux_outbound_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Outbound addresses of Linux based Apps in this App Service Environment V3
        """
        return pulumi.get(self, "linux_outbound_ip_addresses")

    @linux_outbound_ip_addresses.setter
    def linux_outbound_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "linux_outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the App Service Environment exists.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the App Service Environment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pricing tier for the front end instances.
        """
        return pulumi.get(self, "pricing_tier")

    @pricing_tier.setter
    def pricing_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_tier", value)

    @_builtins.property
    @pulumi.getter(name="remoteDebuggingEnabled")
    def remote_debugging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable remote debug. Defaults to `false`.
        """
        return pulumi.get(self, "remote_debugging_enabled")

    @remote_debugging_enabled.setter
    def remote_debugging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remote_debugging_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the App Service Environment exists. Defaults to the Resource Group of the Subnet (specified by `subnet_id`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet which the App Service Environment should be connected to. Changing this forces a new resource to be created.

        > **Note:** a /24 or larger CIDR is required. Once associated with an ASE, this size cannot be changed.

        > **Note:** This Subnet requires a delegation to `Microsoft.Web/hostingEnvironments` as detailed in the example above.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="windowsOutboundIpAddresses")
    def windows_outbound_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Outbound addresses of Windows based Apps in this App Service Environment V3.
        """
        return pulumi.get(self, "windows_outbound_ip_addresses")

    @windows_outbound_ip_addresses.setter
    def windows_outbound_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "windows_outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to deploy the ASEv3 with availability zones supported. Zonal ASEs can be deployed in some regions, you can refer to [Availability Zone support for App Service Environments](https://docs.microsoft.com/azure/app-service/environment/zone-redundancy). You can only set either `dedicated_host_count` or `zone_redundant` but not both. Changing this forces a new resource to be created.

        > **Note:** Setting this value will provision 2 Physical Hosts for your App Service Environment V3, this is done at additional cost, please be aware of the pricing commitment in the [General Availability Notes](https://techcommunity.microsoft.com/t5/apps-on-azure/announcing-app-service-environment-v3-ga/ba-p/2517990)
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.type_token("azure:appservice/environmentV3:EnvironmentV3")
class EnvironmentV3(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_new_private_endpoint_connections: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentV3ClusterSettingArgs', 'EnvironmentV3ClusterSettingArgsDict']]]]] = None,
                 dedicated_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_debugging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a 3rd Generation (v3) App Service Environment.

        ## Example Usage

        This example provisions an App Service Environment V3. Additional examples of how to use the `appservice.EnvironmentV3` resource can be found in the `./examples/app-service-environment-v3` directory within the GitHub Repository.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exampleRG1",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "Microsoft.Web.hostingEnvironments",
                "service_delegation": {
                    "name": "Microsoft.Web/hostingEnvironments",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/action"],
                },
            }])
        example_environment_v3 = azure.appservice.EnvironmentV3("example",
            name="example-asev3",
            resource_group_name=example.name,
            subnet_id=example_subnet.id,
            internal_load_balancing_mode="Web, Publishing",
            cluster_settings=[
                {
                    "name": "DisableTls1.0",
                    "value": "1",
                },
                {
                    "name": "InternalEncryption",
                    "value": "true",
                },
                {
                    "name": "FrontEndSSLCipherSuiteOrder",
                    "value": "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
                },
            ],
            tags={
                "env": "production",
                "terraformed": "true",
            })
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            sku_name="I1v2",
            app_service_environment_id=example_environment_v3.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        * `Microsoft.Web` - 2023-01-01

        ## Import

        A 3rd Generation (v3) App Service Environment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/environmentV3:EnvironmentV3 myAppServiceEnv /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Web/hostingEnvironments/myAppServiceEnv
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_new_private_endpoint_connections: Should new Private Endpoint Connections be allowed. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentV3ClusterSettingArgs', 'EnvironmentV3ClusterSettingArgsDict']]]] cluster_settings: Zero or more `cluster_setting` blocks as defined below.
        :param pulumi.Input[_builtins.int] dedicated_host_count: This ASEv3 should use dedicated Hosts. Possible values are `2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] internal_load_balancing_mode: Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment. Possible values are `None` (for an External VIP Type), and `"Web, Publishing"` (for an Internal VIP Type). Defaults to `None`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the App Service Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] remote_debugging_enabled: Whether to enable remote debug. Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the App Service Environment exists. Defaults to the Resource Group of the Subnet (specified by `subnet_id`). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet which the App Service Environment should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** a /24 or larger CIDR is required. Once associated with an ASE, this size cannot be changed.
               
               > **Note:** This Subnet requires a delegation to `Microsoft.Web/hostingEnvironments` as detailed in the example above.
        :param pulumi.Input[_builtins.bool] zone_redundant: Set to `true` to deploy the ASEv3 with availability zones supported. Zonal ASEs can be deployed in some regions, you can refer to [Availability Zone support for App Service Environments](https://docs.microsoft.com/azure/app-service/environment/zone-redundancy). You can only set either `dedicated_host_count` or `zone_redundant` but not both. Changing this forces a new resource to be created.
               
               > **Note:** Setting this value will provision 2 Physical Hosts for your App Service Environment V3, this is done at additional cost, please be aware of the pricing commitment in the [General Availability Notes](https://techcommunity.microsoft.com/t5/apps-on-azure/announcing-app-service-environment-v3-ga/ba-p/2517990)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentV3Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a 3rd Generation (v3) App Service Environment.

        ## Example Usage

        This example provisions an App Service Environment V3. Additional examples of how to use the `appservice.EnvironmentV3` resource can be found in the `./examples/app-service-environment-v3` directory within the GitHub Repository.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exampleRG1",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "Microsoft.Web.hostingEnvironments",
                "service_delegation": {
                    "name": "Microsoft.Web/hostingEnvironments",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/action"],
                },
            }])
        example_environment_v3 = azure.appservice.EnvironmentV3("example",
            name="example-asev3",
            resource_group_name=example.name,
            subnet_id=example_subnet.id,
            internal_load_balancing_mode="Web, Publishing",
            cluster_settings=[
                {
                    "name": "DisableTls1.0",
                    "value": "1",
                },
                {
                    "name": "InternalEncryption",
                    "value": "true",
                },
                {
                    "name": "FrontEndSSLCipherSuiteOrder",
                    "value": "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
                },
            ],
            tags={
                "env": "production",
                "terraformed": "true",
            })
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            sku_name="I1v2",
            app_service_environment_id=example_environment_v3.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2025-01-01

        * `Microsoft.Web` - 2023-01-01

        ## Import

        A 3rd Generation (v3) App Service Environment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/environmentV3:EnvironmentV3 myAppServiceEnv /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Web/hostingEnvironments/myAppServiceEnv
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentV3Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentV3Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_new_private_endpoint_connections: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentV3ClusterSettingArgs', 'EnvironmentV3ClusterSettingArgsDict']]]]] = None,
                 dedicated_host_count: Optional[pulumi.Input[_builtins.int]] = None,
                 internal_load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_debugging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentV3Args.__new__(EnvironmentV3Args)

            __props__.__dict__["allow_new_private_endpoint_connections"] = allow_new_private_endpoint_connections
            __props__.__dict__["cluster_settings"] = cluster_settings
            __props__.__dict__["dedicated_host_count"] = dedicated_host_count
            __props__.__dict__["internal_load_balancing_mode"] = internal_load_balancing_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["remote_debugging_enabled"] = remote_debugging_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone_redundant"] = zone_redundant
            __props__.__dict__["dns_suffix"] = None
            __props__.__dict__["external_inbound_ip_addresses"] = None
            __props__.__dict__["inbound_network_dependencies"] = None
            __props__.__dict__["internal_inbound_ip_addresses"] = None
            __props__.__dict__["ip_ssl_address_count"] = None
            __props__.__dict__["linux_outbound_ip_addresses"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["pricing_tier"] = None
            __props__.__dict__["windows_outbound_ip_addresses"] = None
        super(EnvironmentV3, __self__).__init__(
            'azure:appservice/environmentV3:EnvironmentV3',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_new_private_endpoint_connections: Optional[pulumi.Input[_builtins.bool]] = None,
            cluster_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentV3ClusterSettingArgs', 'EnvironmentV3ClusterSettingArgsDict']]]]] = None,
            dedicated_host_count: Optional[pulumi.Input[_builtins.int]] = None,
            dns_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            external_inbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            inbound_network_dependencies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentV3InboundNetworkDependencyArgs', 'EnvironmentV3InboundNetworkDependencyArgsDict']]]]] = None,
            internal_inbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            internal_load_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
            ip_ssl_address_count: Optional[pulumi.Input[_builtins.int]] = None,
            linux_outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_tier: Optional[pulumi.Input[_builtins.str]] = None,
            remote_debugging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            windows_outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone_redundant: Optional[pulumi.Input[_builtins.bool]] = None) -> 'EnvironmentV3':
        """
        Get an existing EnvironmentV3 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_new_private_endpoint_connections: Should new Private Endpoint Connections be allowed. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentV3ClusterSettingArgs', 'EnvironmentV3ClusterSettingArgsDict']]]] cluster_settings: Zero or more `cluster_setting` blocks as defined below.
        :param pulumi.Input[_builtins.int] dedicated_host_count: This ASEv3 should use dedicated Hosts. Possible values are `2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] dns_suffix: the DNS suffix for this App Service Environment V3.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_inbound_ip_addresses: The external inbound IP addresses of the App Service Environment V3.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentV3InboundNetworkDependencyArgs', 'EnvironmentV3InboundNetworkDependencyArgsDict']]]] inbound_network_dependencies: An `inbound_network_dependencies` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] internal_inbound_ip_addresses: The internal inbound IP addresses of the App Service Environment V3.
        :param pulumi.Input[_builtins.str] internal_load_balancing_mode: Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment. Possible values are `None` (for an External VIP Type), and `"Web, Publishing"` (for an Internal VIP Type). Defaults to `None`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] ip_ssl_address_count: The number of IP SSL addresses reserved for the App Service Environment V3.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] linux_outbound_ip_addresses: Outbound addresses of Linux based Apps in this App Service Environment V3
        :param pulumi.Input[_builtins.str] location: The location where the App Service Environment exists.
        :param pulumi.Input[_builtins.str] name: The name of the App Service Environment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] pricing_tier: Pricing tier for the front end instances.
        :param pulumi.Input[_builtins.bool] remote_debugging_enabled: Whether to enable remote debug. Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the App Service Environment exists. Defaults to the Resource Group of the Subnet (specified by `subnet_id`). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet which the App Service Environment should be connected to. Changing this forces a new resource to be created.
               
               > **Note:** a /24 or larger CIDR is required. Once associated with an ASE, this size cannot be changed.
               
               > **Note:** This Subnet requires a delegation to `Microsoft.Web/hostingEnvironments` as detailed in the example above.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] windows_outbound_ip_addresses: Outbound addresses of Windows based Apps in this App Service Environment V3.
        :param pulumi.Input[_builtins.bool] zone_redundant: Set to `true` to deploy the ASEv3 with availability zones supported. Zonal ASEs can be deployed in some regions, you can refer to [Availability Zone support for App Service Environments](https://docs.microsoft.com/azure/app-service/environment/zone-redundancy). You can only set either `dedicated_host_count` or `zone_redundant` but not both. Changing this forces a new resource to be created.
               
               > **Note:** Setting this value will provision 2 Physical Hosts for your App Service Environment V3, this is done at additional cost, please be aware of the pricing commitment in the [General Availability Notes](https://techcommunity.microsoft.com/t5/apps-on-azure/announcing-app-service-environment-v3-ga/ba-p/2517990)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentV3State.__new__(_EnvironmentV3State)

        __props__.__dict__["allow_new_private_endpoint_connections"] = allow_new_private_endpoint_connections
        __props__.__dict__["cluster_settings"] = cluster_settings
        __props__.__dict__["dedicated_host_count"] = dedicated_host_count
        __props__.__dict__["dns_suffix"] = dns_suffix
        __props__.__dict__["external_inbound_ip_addresses"] = external_inbound_ip_addresses
        __props__.__dict__["inbound_network_dependencies"] = inbound_network_dependencies
        __props__.__dict__["internal_inbound_ip_addresses"] = internal_inbound_ip_addresses
        __props__.__dict__["internal_load_balancing_mode"] = internal_load_balancing_mode
        __props__.__dict__["ip_ssl_address_count"] = ip_ssl_address_count
        __props__.__dict__["linux_outbound_ip_addresses"] = linux_outbound_ip_addresses
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["pricing_tier"] = pricing_tier
        __props__.__dict__["remote_debugging_enabled"] = remote_debugging_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["windows_outbound_ip_addresses"] = windows_outbound_ip_addresses
        __props__.__dict__["zone_redundant"] = zone_redundant
        return EnvironmentV3(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowNewPrivateEndpointConnections")
    def allow_new_private_endpoint_connections(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should new Private Endpoint Connections be allowed. Defaults to `true`.
        """
        return pulumi.get(self, "allow_new_private_endpoint_connections")

    @_builtins.property
    @pulumi.getter(name="clusterSettings")
    def cluster_settings(self) -> pulumi.Output[Sequence['outputs.EnvironmentV3ClusterSetting']]:
        """
        Zero or more `cluster_setting` blocks as defined below.
        """
        return pulumi.get(self, "cluster_settings")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostCount")
    def dedicated_host_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        This ASEv3 should use dedicated Hosts. Possible values are `2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dedicated_host_count")

    @_builtins.property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> pulumi.Output[_builtins.str]:
        """
        the DNS suffix for this App Service Environment V3.
        """
        return pulumi.get(self, "dns_suffix")

    @_builtins.property
    @pulumi.getter(name="externalInboundIpAddresses")
    def external_inbound_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The external inbound IP addresses of the App Service Environment V3.
        """
        return pulumi.get(self, "external_inbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="inboundNetworkDependencies")
    def inbound_network_dependencies(self) -> pulumi.Output[Sequence['outputs.EnvironmentV3InboundNetworkDependency']]:
        """
        An `inbound_network_dependencies` block as defined below.
        """
        return pulumi.get(self, "inbound_network_dependencies")

    @_builtins.property
    @pulumi.getter(name="internalInboundIpAddresses")
    def internal_inbound_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The internal inbound IP addresses of the App Service Environment V3.
        """
        return pulumi.get(self, "internal_inbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="internalLoadBalancingMode")
    def internal_load_balancing_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment. Possible values are `None` (for an External VIP Type), and `"Web, Publishing"` (for an Internal VIP Type). Defaults to `None`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "internal_load_balancing_mode")

    @_builtins.property
    @pulumi.getter(name="ipSslAddressCount")
    def ip_ssl_address_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of IP SSL addresses reserved for the App Service Environment V3.
        """
        return pulumi.get(self, "ip_ssl_address_count")

    @_builtins.property
    @pulumi.getter(name="linuxOutboundIpAddresses")
    def linux_outbound_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Outbound addresses of Linux based Apps in this App Service Environment V3
        """
        return pulumi.get(self, "linux_outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the App Service Environment exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the App Service Environment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pricingTier")
    def pricing_tier(self) -> pulumi.Output[_builtins.str]:
        """
        Pricing tier for the front end instances.
        """
        return pulumi.get(self, "pricing_tier")

    @_builtins.property
    @pulumi.getter(name="remoteDebuggingEnabled")
    def remote_debugging_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable remote debug. Defaults to `false`.
        """
        return pulumi.get(self, "remote_debugging_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the App Service Environment exists. Defaults to the Resource Group of the Subnet (specified by `subnet_id`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Subnet which the App Service Environment should be connected to. Changing this forces a new resource to be created.

        > **Note:** a /24 or larger CIDR is required. Once associated with an ASE, this size cannot be changed.

        > **Note:** This Subnet requires a delegation to `Microsoft.Web/hostingEnvironments` as detailed in the example above.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="windowsOutboundIpAddresses")
    def windows_outbound_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Outbound addresses of Windows based Apps in this App Service Environment V3.
        """
        return pulumi.get(self, "windows_outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to `true` to deploy the ASEv3 with availability zones supported. Zonal ASEs can be deployed in some regions, you can refer to [Availability Zone support for App Service Environments](https://docs.microsoft.com/azure/app-service/environment/zone-redundancy). You can only set either `dedicated_host_count` or `zone_redundant` but not both. Changing this forces a new resource to be created.

        > **Note:** Setting this value will provision 2 Physical Hosts for your App Service Environment V3, this is done at additional cost, please be aware of the pricing commitment in the [General Availability Notes](https://techcommunity.microsoft.com/t5/apps-on-azure/announcing-app-service-environment-v3-ga/ba-p/2517990)
        """
        return pulumi.get(self, "zone_redundant")

