# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, expiration_date=None, friendly_name=None, host_names=None, id=None, issue_date=None, issuer=None, location=None, name=None, resource_group_name=None, subject_name=None, tags=None, thumbprint=None):
        if expiration_date and not isinstance(expiration_date, str):
            raise TypeError("Expected argument 'expiration_date' to be a str")
        pulumi.set(__self__, "expiration_date", expiration_date)
        if friendly_name and not isinstance(friendly_name, str):
            raise TypeError("Expected argument 'friendly_name' to be a str")
        pulumi.set(__self__, "friendly_name", friendly_name)
        if host_names and not isinstance(host_names, list):
            raise TypeError("Expected argument 'host_names' to be a list")
        pulumi.set(__self__, "host_names", host_names)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issue_date and not isinstance(issue_date, str):
            raise TypeError("Expected argument 'issue_date' to be a str")
        pulumi.set(__self__, "issue_date", issue_date)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subject_name and not isinstance(subject_name, str):
            raise TypeError("Expected argument 'subject_name' to be a str")
        pulumi.set(__self__, "subject_name", subject_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if thumbprint and not isinstance(thumbprint, str):
            raise TypeError("Expected argument 'thumbprint' to be a str")
        pulumi.set(__self__, "thumbprint", thumbprint)

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> _builtins.str:
        """
        The expiration date for the certificate.
        """
        return pulumi.get(self, "expiration_date")

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> _builtins.str:
        """
        The friendly name of the certificate.
        """
        return pulumi.get(self, "friendly_name")

    @_builtins.property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> Sequence[_builtins.str]:
        """
        List of host names the certificate applies to.
        """
        return pulumi.get(self, "host_names")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="issueDate")
    def issue_date(self) -> _builtins.str:
        """
        The issue date for the certificate.
        """
        return pulumi.get(self, "issue_date")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        The name of the certificate issuer.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> _builtins.str:
        """
        The subject name of the certificate.
        """
        return pulumi.get(self, "subject_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> _builtins.str:
        """
        The thumbprint for the certificate.
        """
        return pulumi.get(self, "thumbprint")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            expiration_date=self.expiration_date,
            friendly_name=self.friendly_name,
            host_names=self.host_names,
            id=self.id,
            issue_date=self.issue_date,
            issuer=self.issuer,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            subject_name=self.subject_name,
            tags=self.tags,
            thumbprint=self.thumbprint)


def get_certificate(name: Optional[_builtins.str] = None,
                    resource_group_name: Optional[_builtins.str] = None,
                    tags: Optional[Mapping[str, _builtins.str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Use this data source to access information about an App Service Certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appservice.get_certificate(name="example-app-service-certificate",
        resource_group_name="example-rg")
    pulumi.export("appServiceCertificateId", example.id)
    ```


    :param _builtins.str name: Specifies the name of the certificate.
    :param _builtins.str resource_group_name: The name of the resource group in which to create the certificate.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:appservice/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        expiration_date=pulumi.get(__ret__, 'expiration_date'),
        friendly_name=pulumi.get(__ret__, 'friendly_name'),
        host_names=pulumi.get(__ret__, 'host_names'),
        id=pulumi.get(__ret__, 'id'),
        issue_date=pulumi.get(__ret__, 'issue_date'),
        issuer=pulumi.get(__ret__, 'issuer'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        subject_name=pulumi.get(__ret__, 'subject_name'),
        tags=pulumi.get(__ret__, 'tags'),
        thumbprint=pulumi.get(__ret__, 'thumbprint'))
def get_certificate_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                           tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Use this data source to access information about an App Service Certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appservice.get_certificate(name="example-app-service-certificate",
        resource_group_name="example-rg")
    pulumi.export("appServiceCertificateId", example.id)
    ```


    :param _builtins.str name: Specifies the name of the certificate.
    :param _builtins.str resource_group_name: The name of the resource group in which to create the certificate.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:appservice/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult)
    return __ret__.apply(lambda __response__: GetCertificateResult(
        expiration_date=pulumi.get(__response__, 'expiration_date'),
        friendly_name=pulumi.get(__response__, 'friendly_name'),
        host_names=pulumi.get(__response__, 'host_names'),
        id=pulumi.get(__response__, 'id'),
        issue_date=pulumi.get(__response__, 'issue_date'),
        issuer=pulumi.get(__response__, 'issuer'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        subject_name=pulumi.get(__response__, 'subject_name'),
        tags=pulumi.get(__response__, 'tags'),
        thumbprint=pulumi.get(__response__, 'thumbprint')))
