# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFunctionAppResult',
    'AwaitableGetFunctionAppResult',
    'get_function_app',
    'get_function_app_output',
]

@pulumi.output_type
class GetFunctionAppResult:
    """
    A collection of values returned by getFunctionApp.
    """
    def __init__(__self__, app_service_plan_id=None, app_settings=None, client_cert_mode=None, connection_strings=None, custom_domain_verification_id=None, default_hostname=None, enabled=None, id=None, identities=None, location=None, name=None, os_type=None, outbound_ip_addresses=None, possible_outbound_ip_addresses=None, resource_group_name=None, site_configs=None, site_credentials=None, source_controls=None, tags=None):
        if app_service_plan_id and not isinstance(app_service_plan_id, str):
            raise TypeError("Expected argument 'app_service_plan_id' to be a str")
        pulumi.set(__self__, "app_service_plan_id", app_service_plan_id)
        if app_settings and not isinstance(app_settings, dict):
            raise TypeError("Expected argument 'app_settings' to be a dict")
        pulumi.set(__self__, "app_settings", app_settings)
        if client_cert_mode and not isinstance(client_cert_mode, str):
            raise TypeError("Expected argument 'client_cert_mode' to be a str")
        pulumi.set(__self__, "client_cert_mode", client_cert_mode)
        if connection_strings and not isinstance(connection_strings, list):
            raise TypeError("Expected argument 'connection_strings' to be a list")
        pulumi.set(__self__, "connection_strings", connection_strings)
        if custom_domain_verification_id and not isinstance(custom_domain_verification_id, str):
            raise TypeError("Expected argument 'custom_domain_verification_id' to be a str")
        pulumi.set(__self__, "custom_domain_verification_id", custom_domain_verification_id)
        if default_hostname and not isinstance(default_hostname, str):
            raise TypeError("Expected argument 'default_hostname' to be a str")
        pulumi.set(__self__, "default_hostname", default_hostname)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_type and not isinstance(os_type, str):
            raise TypeError("Expected argument 'os_type' to be a str")
        pulumi.set(__self__, "os_type", os_type)
        if outbound_ip_addresses and not isinstance(outbound_ip_addresses, str):
            raise TypeError("Expected argument 'outbound_ip_addresses' to be a str")
        pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if possible_outbound_ip_addresses and not isinstance(possible_outbound_ip_addresses, str):
            raise TypeError("Expected argument 'possible_outbound_ip_addresses' to be a str")
        pulumi.set(__self__, "possible_outbound_ip_addresses", possible_outbound_ip_addresses)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if site_configs and not isinstance(site_configs, list):
            raise TypeError("Expected argument 'site_configs' to be a list")
        pulumi.set(__self__, "site_configs", site_configs)
        if site_credentials and not isinstance(site_credentials, list):
            raise TypeError("Expected argument 'site_credentials' to be a list")
        pulumi.set(__self__, "site_credentials", site_credentials)
        if source_controls and not isinstance(source_controls, list):
            raise TypeError("Expected argument 'source_controls' to be a list")
        pulumi.set(__self__, "source_controls", source_controls)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="appServicePlanId")
    def app_service_plan_id(self) -> _builtins.str:
        """
        The ID of the App Service Plan within which to create this Function App.
        """
        return pulumi.get(self, "app_service_plan_id")

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Mapping[str, _builtins.str]:
        """
        A key-value pair of App Settings.
        """
        return pulumi.get(self, "app_settings")

    @_builtins.property
    @pulumi.getter(name="clientCertMode")
    def client_cert_mode(self) -> _builtins.str:
        """
        The mode of the Function App's client certificates requirement for incoming requests.
        """
        return pulumi.get(self, "client_cert_mode")

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Sequence['outputs.GetFunctionAppConnectionStringResult']:
        """
        An `connection_string` block as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @_builtins.property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> _builtins.str:
        """
        An identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @_builtins.property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> _builtins.str:
        """
        The default hostname associated with the Function App.
        """
        return pulumi.get(self, "default_hostname")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Is the Function App enabled?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetFunctionAppIdentityResult']:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name for this IP Restriction.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        A string indicating the Operating System type for this function app.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> _builtins.str:
        """
        A comma separated list of outbound IP addresses.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> _builtins.str:
        """
        A comma separated list of outbound IP addresses, not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="siteConfigs")
    def site_configs(self) -> Sequence['outputs.GetFunctionAppSiteConfigResult']:
        return pulumi.get(self, "site_configs")

    @_builtins.property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> Sequence['outputs.GetFunctionAppSiteCredentialResult']:
        """
        A `site_credential` block as defined below, which contains the site-level credentials used to publish to this App Service.
        """
        return pulumi.get(self, "site_credentials")

    @_builtins.property
    @pulumi.getter(name="sourceControls")
    def source_controls(self) -> Sequence['outputs.GetFunctionAppSourceControlResult']:
        """
        A `source_control` block as defined below.
        """
        return pulumi.get(self, "source_controls")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetFunctionAppResult(GetFunctionAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionAppResult(
            app_service_plan_id=self.app_service_plan_id,
            app_settings=self.app_settings,
            client_cert_mode=self.client_cert_mode,
            connection_strings=self.connection_strings,
            custom_domain_verification_id=self.custom_domain_verification_id,
            default_hostname=self.default_hostname,
            enabled=self.enabled,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            os_type=self.os_type,
            outbound_ip_addresses=self.outbound_ip_addresses,
            possible_outbound_ip_addresses=self.possible_outbound_ip_addresses,
            resource_group_name=self.resource_group_name,
            site_configs=self.site_configs,
            site_credentials=self.site_credentials,
            source_controls=self.source_controls,
            tags=self.tags)


def get_function_app(name: Optional[_builtins.str] = None,
                     resource_group_name: Optional[_builtins.str] = None,
                     tags: Optional[Mapping[str, _builtins.str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionAppResult:
    """
    Use this data source to access information about a Function App.

    !> **Note:** The `appservice.FunctionApp` data source is deprecated in version 5.0 of the AzureRM provider and will be removed in version 6.0. Please use the `appservice.LinuxFunctionApp` and `appservice.WindowsFunctionApp` data sources instead.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appservice.get_function_app(name="test-azure-functions",
        resource_group_name=example_azurerm_resource_group["name"])
    ```


    :param _builtins.str name: The name of the Function App resource.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Function App exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:appservice/getFunctionApp:getFunctionApp', __args__, opts=opts, typ=GetFunctionAppResult).value

    return AwaitableGetFunctionAppResult(
        app_service_plan_id=pulumi.get(__ret__, 'app_service_plan_id'),
        app_settings=pulumi.get(__ret__, 'app_settings'),
        client_cert_mode=pulumi.get(__ret__, 'client_cert_mode'),
        connection_strings=pulumi.get(__ret__, 'connection_strings'),
        custom_domain_verification_id=pulumi.get(__ret__, 'custom_domain_verification_id'),
        default_hostname=pulumi.get(__ret__, 'default_hostname'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        os_type=pulumi.get(__ret__, 'os_type'),
        outbound_ip_addresses=pulumi.get(__ret__, 'outbound_ip_addresses'),
        possible_outbound_ip_addresses=pulumi.get(__ret__, 'possible_outbound_ip_addresses'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        site_configs=pulumi.get(__ret__, 'site_configs'),
        site_credentials=pulumi.get(__ret__, 'site_credentials'),
        source_controls=pulumi.get(__ret__, 'source_controls'),
        tags=pulumi.get(__ret__, 'tags'))
def get_function_app_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionAppResult]:
    """
    Use this data source to access information about a Function App.

    !> **Note:** The `appservice.FunctionApp` data source is deprecated in version 5.0 of the AzureRM provider and will be removed in version 6.0. Please use the `appservice.LinuxFunctionApp` and `appservice.WindowsFunctionApp` data sources instead.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appservice.get_function_app(name="test-azure-functions",
        resource_group_name=example_azurerm_resource_group["name"])
    ```


    :param _builtins.str name: The name of the Function App resource.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Function App exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:appservice/getFunctionApp:getFunctionApp', __args__, opts=opts, typ=GetFunctionAppResult)
    return __ret__.apply(lambda __response__: GetFunctionAppResult(
        app_service_plan_id=pulumi.get(__response__, 'app_service_plan_id'),
        app_settings=pulumi.get(__response__, 'app_settings'),
        client_cert_mode=pulumi.get(__response__, 'client_cert_mode'),
        connection_strings=pulumi.get(__response__, 'connection_strings'),
        custom_domain_verification_id=pulumi.get(__response__, 'custom_domain_verification_id'),
        default_hostname=pulumi.get(__response__, 'default_hostname'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        os_type=pulumi.get(__response__, 'os_type'),
        outbound_ip_addresses=pulumi.get(__response__, 'outbound_ip_addresses'),
        possible_outbound_ip_addresses=pulumi.get(__response__, 'possible_outbound_ip_addresses'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        site_configs=pulumi.get(__response__, 'site_configs'),
        site_credentials=pulumi.get(__response__, 'site_credentials'),
        source_controls=pulumi.get(__response__, 'source_controls'),
        tags=pulumi.get(__response__, 'tags')))
