# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VirtualNetworkSwiftConnectionArgs', 'VirtualNetworkSwiftConnection']

@pulumi.input_type
class VirtualNetworkSwiftConnectionArgs:
    def __init__(__self__, *,
                 app_service_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a VirtualNetworkSwiftConnection resource.
        :param pulumi.Input[_builtins.str] app_service_id: The ID of the App Service or Function App to associate to the VNet. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet the app service will be associated to (the subnet must have a `service_delegation` configured for `Microsoft.Web/serverFarms`).
        """
        pulumi.set(__self__, "app_service_id", app_service_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="appServiceId")
    def app_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the App Service or Function App to associate to the VNet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_service_id")

    @app_service_id.setter
    def app_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_service_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the subnet the app service will be associated to (the subnet must have a `service_delegation` configured for `Microsoft.Web/serverFarms`).
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _VirtualNetworkSwiftConnectionState:
    def __init__(__self__, *,
                 app_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualNetworkSwiftConnection resources.
        :param pulumi.Input[_builtins.str] app_service_id: The ID of the App Service or Function App to associate to the VNet. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet the app service will be associated to (the subnet must have a `service_delegation` configured for `Microsoft.Web/serverFarms`).
        """
        if app_service_id is not None:
            pulumi.set(__self__, "app_service_id", app_service_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="appServiceId")
    def app_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the App Service or Function App to associate to the VNet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_service_id")

    @app_service_id.setter
    def app_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the subnet the app service will be associated to (the subnet must have a `service_delegation` configured for `Microsoft.Web/serverFarms`).
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.type_token("azure:appservice/virtualNetworkSwiftConnection:VirtualNetworkSwiftConnection")
class VirtualNetworkSwiftConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an App Service Virtual Network Association for [Regional VNet Integration](https://docs.microsoft.com/azure/app-service/web-sites-integrate-with-vnet#regional-vnet-integration).

        This resource can be used for both App Services and Function Apps.

        > **Note:** The following resources support associating the vNet for Regional vNet Integration directly on the resource and via the `appservice.VirtualNetworkSwiftConnection` resource. You can't use both simultaneously.

        - appservice.LinuxFunctionApp
        - appservice.LinuxFunctionAppSlot
        - appservice.LinuxWebApp
        - appservice.LinuxWebAppSlot
        - logicapps.Standard
        - appservice.WindowsFunctionApp
        - appservice.WindowsFunctionAppSlot
        - appservice.WindowsWebApp
        - appservice.WindowsWebAppSlot

        This resource requires the `Microsoft.Network/virtualNetworks/subnets/write` permission scope on the subnet.

        The resource specific vNet integration requires the `Microsoft.Network/virtualNetworks/subnets/join/action` permission scope.

        There is a hard limit of [one VNet integration per App Service Plan](https://docs.microsoft.com/azure/app-service/web-sites-integrate-with-vnet#regional-vnet-integration).
        Multiple apps in the same App Service plan can use the same VNet.

        ## Example Usage

        ### With App Service)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-virtual-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "example-delegation",
                "service_delegation": {
                    "name": "Microsoft.Web/serverFarms",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/action"],
                },
            }])
        example_plan = azure.appservice.Plan("example",
            name="example-app-service-plan",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "tier": "Standard",
                "size": "S1",
            })
        example_app_service = azure.appservice.AppService("example",
            name="example-app-service",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id)
        example_virtual_network_swift_connection = azure.appservice.VirtualNetworkSwiftConnection("example",
            app_service_id=example_app_service.id,
            subnet_id=example_subnet.id)
        ```

        ### With Function App)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-virtual-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "example-delegation",
                "service_delegation": {
                    "name": "Microsoft.Web/serverFarms",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/action"],
                },
            }])
        example_plan = azure.appservice.Plan("example",
            name="example-app-service-plan",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "tier": "Standard",
                "size": "S1",
            })
        example_account = azure.storage.Account("example",
            name="functionsappexamplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_function_app = azure.appservice.FunctionApp("example",
            name="example-function-app",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key)
        example_virtual_network_swift_connection = azure.appservice.VirtualNetworkSwiftConnection("example",
            app_service_id=example_function_app.id,
            subnet_id=example_subnet.id)
        ```

        ## Import

        App Service Virtual Network Associations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/virtualNetworkSwiftConnection:VirtualNetworkSwiftConnection myassociation /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Web/sites/instance1/config/virtualNetwork
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_id: The ID of the App Service or Function App to associate to the VNet. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet the app service will be associated to (the subnet must have a `service_delegation` configured for `Microsoft.Web/serverFarms`).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualNetworkSwiftConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an App Service Virtual Network Association for [Regional VNet Integration](https://docs.microsoft.com/azure/app-service/web-sites-integrate-with-vnet#regional-vnet-integration).

        This resource can be used for both App Services and Function Apps.

        > **Note:** The following resources support associating the vNet for Regional vNet Integration directly on the resource and via the `appservice.VirtualNetworkSwiftConnection` resource. You can't use both simultaneously.

        - appservice.LinuxFunctionApp
        - appservice.LinuxFunctionAppSlot
        - appservice.LinuxWebApp
        - appservice.LinuxWebAppSlot
        - logicapps.Standard
        - appservice.WindowsFunctionApp
        - appservice.WindowsFunctionAppSlot
        - appservice.WindowsWebApp
        - appservice.WindowsWebAppSlot

        This resource requires the `Microsoft.Network/virtualNetworks/subnets/write` permission scope on the subnet.

        The resource specific vNet integration requires the `Microsoft.Network/virtualNetworks/subnets/join/action` permission scope.

        There is a hard limit of [one VNet integration per App Service Plan](https://docs.microsoft.com/azure/app-service/web-sites-integrate-with-vnet#regional-vnet-integration).
        Multiple apps in the same App Service plan can use the same VNet.

        ## Example Usage

        ### With App Service)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-virtual-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "example-delegation",
                "service_delegation": {
                    "name": "Microsoft.Web/serverFarms",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/action"],
                },
            }])
        example_plan = azure.appservice.Plan("example",
            name="example-app-service-plan",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "tier": "Standard",
                "size": "S1",
            })
        example_app_service = azure.appservice.AppService("example",
            name="example-app-service",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id)
        example_virtual_network_swift_connection = azure.appservice.VirtualNetworkSwiftConnection("example",
            app_service_id=example_app_service.id,
            subnet_id=example_subnet.id)
        ```

        ### With Function App)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-virtual-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "example-delegation",
                "service_delegation": {
                    "name": "Microsoft.Web/serverFarms",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/action"],
                },
            }])
        example_plan = azure.appservice.Plan("example",
            name="example-app-service-plan",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "tier": "Standard",
                "size": "S1",
            })
        example_account = azure.storage.Account("example",
            name="functionsappexamplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_function_app = azure.appservice.FunctionApp("example",
            name="example-function-app",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key)
        example_virtual_network_swift_connection = azure.appservice.VirtualNetworkSwiftConnection("example",
            app_service_id=example_function_app.id,
            subnet_id=example_subnet.id)
        ```

        ## Import

        App Service Virtual Network Associations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/virtualNetworkSwiftConnection:VirtualNetworkSwiftConnection myassociation /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Web/sites/instance1/config/virtualNetwork
        ```

        :param str resource_name: The name of the resource.
        :param VirtualNetworkSwiftConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualNetworkSwiftConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualNetworkSwiftConnectionArgs.__new__(VirtualNetworkSwiftConnectionArgs)

            if app_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_service_id'")
            __props__.__dict__["app_service_id"] = app_service_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
        super(VirtualNetworkSwiftConnection, __self__).__init__(
            'azure:appservice/virtualNetworkSwiftConnection:VirtualNetworkSwiftConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VirtualNetworkSwiftConnection':
        """
        Get an existing VirtualNetworkSwiftConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_id: The ID of the App Service or Function App to associate to the VNet. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet the app service will be associated to (the subnet must have a `service_delegation` configured for `Microsoft.Web/serverFarms`).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualNetworkSwiftConnectionState.__new__(_VirtualNetworkSwiftConnectionState)

        __props__.__dict__["app_service_id"] = app_service_id
        __props__.__dict__["subnet_id"] = subnet_id
        return VirtualNetworkSwiftConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appServiceId")
    def app_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the App Service or Function App to associate to the VNet. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "app_service_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the subnet the app service will be associated to (the subnet must have a `service_delegation` configured for `Microsoft.Web/serverFarms`).
        """
        return pulumi.get(self, "subnet_id")

