# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 agent_public_key_certificate: pulumi.Input[_builtins.str],
                 identity: pulumi.Input['ClusterIdentityArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] agent_public_key_certificate: Specifies the base64-encoded public certificate used by the agent to do the initial handshake to the backend services in Azure. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input['ClusterIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Arc Kubernetes Cluster. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Kubernetes Cluster.
        """
        pulumi.set(__self__, "agent_public_key_certificate", agent_public_key_certificate)
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="agentPublicKeyCertificate")
    def agent_public_key_certificate(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the base64-encoded public certificate used by the agent to do the initial handshake to the backend services in Azure. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "agent_public_key_certificate")

    @agent_public_key_certificate.setter
    def agent_public_key_certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_public_key_certificate", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['ClusterIdentityArgs']:
        """
        An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['ClusterIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Arc Kubernetes Cluster. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Arc Kubernetes Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 agent_public_key_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_version: Optional[pulumi.Input[_builtins.str]] = None,
                 distribution: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ClusterIdentityArgs']] = None,
                 infrastructure: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 offering: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 total_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 total_node_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] agent_public_key_certificate: Specifies the base64-encoded public certificate used by the agent to do the initial handshake to the backend services in Azure. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] agent_version: Version of the agent running on the cluster resource.
        :param pulumi.Input[_builtins.str] distribution: The distribution running on this Arc Kubernetes Cluster.
        :param pulumi.Input['ClusterIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] infrastructure: The infrastructure on which the Arc Kubernetes Cluster is running on.
        :param pulumi.Input[_builtins.str] kubernetes_version: The Kubernetes version of the cluster resource.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Arc Kubernetes Cluster. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] offering: The cluster offering.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Kubernetes Cluster.
        :param pulumi.Input[_builtins.int] total_core_count: Number of CPU cores present in the cluster resource.
        :param pulumi.Input[_builtins.int] total_node_count: Number of nodes present in the cluster resource.
        """
        if agent_public_key_certificate is not None:
            pulumi.set(__self__, "agent_public_key_certificate", agent_public_key_certificate)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if infrastructure is not None:
            pulumi.set(__self__, "infrastructure", infrastructure)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offering is not None:
            pulumi.set(__self__, "offering", offering)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if total_core_count is not None:
            pulumi.set(__self__, "total_core_count", total_core_count)
        if total_node_count is not None:
            pulumi.set(__self__, "total_node_count", total_node_count)

    @_builtins.property
    @pulumi.getter(name="agentPublicKeyCertificate")
    def agent_public_key_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the base64-encoded public certificate used by the agent to do the initial handshake to the backend services in Azure. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "agent_public_key_certificate")

    @agent_public_key_certificate.setter
    def agent_public_key_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_public_key_certificate", value)

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the agent running on the cluster resource.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_version", value)

    @_builtins.property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The distribution running on this Arc Kubernetes Cluster.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "distribution", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ClusterIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def infrastructure(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The infrastructure on which the Arc Kubernetes Cluster is running on.
        """
        return pulumi.get(self, "infrastructure")

    @infrastructure.setter
    def infrastructure(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infrastructure", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kubernetes version of the cluster resource.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_version", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Arc Kubernetes Cluster. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def offering(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster offering.
        """
        return pulumi.get(self, "offering")

    @offering.setter
    def offering(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offering", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Arc Kubernetes Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="totalCoreCount")
    def total_core_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of CPU cores present in the cluster resource.
        """
        return pulumi.get(self, "total_core_count")

    @total_core_count.setter
    def total_core_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_core_count", value)

    @_builtins.property
    @pulumi.getter(name="totalNodeCount")
    def total_node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes present in the cluster resource.
        """
        return pulumi.get(self, "total_node_count")

    @total_node_count.setter
    def total_node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_node_count", value)


@pulumi.type_token("azure:arckubernetes/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_public_key_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Arc Kubernetes Cluster.

        > **Note:** Installing and configuring the Azure Arc Agent on your Kubernetes Cluster to establish connectivity is outside the scope of this document. For more details refer to [Deploy agents to your cluster](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/conceptual-agent-overview#deploy-agents-to-your-cluster) and [Connect an existing Kubernetes Cluster](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/quickstart-connect-cluster?tabs=azure-cli#connect-an-existing-kubernetes-cluster). If you encounter issues connecting your Kubernetes Cluster to Azure Arc, we'd recommend opening a ticket with Microsoft Support.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.arckubernetes.Cluster("example",
            name="example-akcc",
            resource_group_name=example.name,
            location="West Europe",
            agent_public_key_certificate=std.filebase64(input="testdata/public.cer").result,
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "ENV": "Test",
            })
        ```

        > **Note:** An extensive example on connecting the `arckubernetes.Cluster` to an external kubernetes cluster can be found in the `./examples/arckubernetes` directory within the GitHub Repository.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kubernetes` - 2024-01-01

        ## Import

        Arc Kubernetes Cluster can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:arckubernetes/cluster:Cluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Kubernetes/connectedClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_public_key_certificate: Specifies the base64-encoded public certificate used by the agent to do the initial handshake to the backend services in Azure. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Arc Kubernetes Cluster. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Kubernetes Cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Arc Kubernetes Cluster.

        > **Note:** Installing and configuring the Azure Arc Agent on your Kubernetes Cluster to establish connectivity is outside the scope of this document. For more details refer to [Deploy agents to your cluster](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/conceptual-agent-overview#deploy-agents-to-your-cluster) and [Connect an existing Kubernetes Cluster](https://learn.microsoft.com/en-us/azure/azure-arc/kubernetes/quickstart-connect-cluster?tabs=azure-cli#connect-an-existing-kubernetes-cluster). If you encounter issues connecting your Kubernetes Cluster to Azure Arc, we'd recommend opening a ticket with Microsoft Support.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.arckubernetes.Cluster("example",
            name="example-akcc",
            resource_group_name=example.name,
            location="West Europe",
            agent_public_key_certificate=std.filebase64(input="testdata/public.cer").result,
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "ENV": "Test",
            })
        ```

        > **Note:** An extensive example on connecting the `arckubernetes.Cluster` to an external kubernetes cluster can be found in the `./examples/arckubernetes` directory within the GitHub Repository.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kubernetes` - 2024-01-01

        ## Import

        Arc Kubernetes Cluster can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:arckubernetes/cluster:Cluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Kubernetes/connectedClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_public_key_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if agent_public_key_certificate is None and not opts.urn:
                raise TypeError("Missing required property 'agent_public_key_certificate'")
            __props__.__dict__["agent_public_key_certificate"] = agent_public_key_certificate
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["agent_version"] = None
            __props__.__dict__["distribution"] = None
            __props__.__dict__["infrastructure"] = None
            __props__.__dict__["kubernetes_version"] = None
            __props__.__dict__["offering"] = None
            __props__.__dict__["total_core_count"] = None
            __props__.__dict__["total_node_count"] = None
        super(Cluster, __self__).__init__(
            'azure:arckubernetes/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_public_key_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            agent_version: Optional[pulumi.Input[_builtins.str]] = None,
            distribution: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']]] = None,
            infrastructure: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            offering: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            total_core_count: Optional[pulumi.Input[_builtins.int]] = None,
            total_node_count: Optional[pulumi.Input[_builtins.int]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_public_key_certificate: Specifies the base64-encoded public certificate used by the agent to do the initial handshake to the backend services in Azure. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] agent_version: Version of the agent running on the cluster resource.
        :param pulumi.Input[_builtins.str] distribution: The distribution running on this Arc Kubernetes Cluster.
        :param pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] infrastructure: The infrastructure on which the Arc Kubernetes Cluster is running on.
        :param pulumi.Input[_builtins.str] kubernetes_version: The Kubernetes version of the cluster resource.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Arc Kubernetes Cluster. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[_builtins.str] offering: The cluster offering.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Kubernetes Cluster.
        :param pulumi.Input[_builtins.int] total_core_count: Number of CPU cores present in the cluster resource.
        :param pulumi.Input[_builtins.int] total_node_count: Number of nodes present in the cluster resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["agent_public_key_certificate"] = agent_public_key_certificate
        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["distribution"] = distribution
        __props__.__dict__["identity"] = identity
        __props__.__dict__["infrastructure"] = infrastructure
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["offering"] = offering
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["total_core_count"] = total_core_count
        __props__.__dict__["total_node_count"] = total_node_count
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentPublicKeyCertificate")
    def agent_public_key_certificate(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the base64-encoded public certificate used by the agent to do the initial handshake to the backend services in Azure. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "agent_public_key_certificate")

    @_builtins.property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the agent running on the cluster resource.
        """
        return pulumi.get(self, "agent_version")

    @_builtins.property
    @pulumi.getter
    def distribution(self) -> pulumi.Output[_builtins.str]:
        """
        The distribution running on this Arc Kubernetes Cluster.
        """
        return pulumi.get(self, "distribution")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.ClusterIdentity']:
        """
        An `identity` block as defined below. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def infrastructure(self) -> pulumi.Output[_builtins.str]:
        """
        The infrastructure on which the Arc Kubernetes Cluster is running on.
        """
        return pulumi.get(self, "infrastructure")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[_builtins.str]:
        """
        The Kubernetes version of the cluster resource.
        """
        return pulumi.get(self, "kubernetes_version")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Arc Kubernetes Cluster. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def offering(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster offering.
        """
        return pulumi.get(self, "offering")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Arc Kubernetes Cluster should exist. Changing this forces a new Arc Kubernetes Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Arc Kubernetes Cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalCoreCount")
    def total_core_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of CPU cores present in the cluster resource.
        """
        return pulumi.get(self, "total_core_count")

    @_builtins.property
    @pulumi.getter(name="totalNodeCount")
    def total_node_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of nodes present in the cluster resource.
        """
        return pulumi.get(self, "total_node_count")

