# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterExtensionIdentity',
    'ClusterIdentity',
    'FluxConfigurationBlobStorage',
    'FluxConfigurationBlobStorageServicePrincipal',
    'FluxConfigurationBucket',
    'FluxConfigurationGitRepository',
    'FluxConfigurationKustomization',
    'ProvisionedClusterAzureActiveDirectory',
    'ProvisionedClusterIdentity',
]

@pulumi.output_type
class ClusterExtensionIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterExtensionIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterExtensionIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterExtensionIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity. The only possible value is `SystemAssigned`. Changing this forces a new resource to be created.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity. The only possible value is `SystemAssigned`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ClusterIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity assigned to this Arc Kubernetes Cluster. At this time the only possible value is `SystemAssigned`. Changing this forces a new resource to be created.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity assigned to this Arc Kubernetes Cluster. At this time the only possible value is `SystemAssigned`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class FluxConfigurationBlobStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerId":
            suggest = "container_id"
        elif key == "accountKey":
            suggest = "account_key"
        elif key == "localAuthReference":
            suggest = "local_auth_reference"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "servicePrincipal":
            suggest = "service_principal"
        elif key == "syncIntervalInSeconds":
            suggest = "sync_interval_in_seconds"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FluxConfigurationBlobStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FluxConfigurationBlobStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FluxConfigurationBlobStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_id: _builtins.str,
                 account_key: Optional[_builtins.str] = None,
                 local_auth_reference: Optional[_builtins.str] = None,
                 sas_token: Optional[_builtins.str] = None,
                 service_principal: Optional['outputs.FluxConfigurationBlobStorageServicePrincipal'] = None,
                 sync_interval_in_seconds: Optional[_builtins.int] = None,
                 timeout_in_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.str container_id: Specifies the Azure Blob container ID.
        :param _builtins.str account_key: Specifies the account key (shared key) to access the storage account.
        :param _builtins.str local_auth_reference: Specifies the name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        :param _builtins.str sas_token: Specifies the shared access token to access the storage container.
        :param 'FluxConfigurationBlobStorageServicePrincipalArgs' service_principal: A `service_principal` block as defined below.
        :param _builtins.int sync_interval_in_seconds: Specifies the interval at which to re-reconcile the cluster Azure Blob source with the remote.
        :param _builtins.int timeout_in_seconds: Specifies the maximum time to attempt to reconcile the cluster Azure Blob source with the remote.
        """
        pulumi.set(__self__, "container_id", container_id)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if local_auth_reference is not None:
            pulumi.set(__self__, "local_auth_reference", local_auth_reference)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if service_principal is not None:
            pulumi.set(__self__, "service_principal", service_principal)
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> _builtins.str:
        """
        Specifies the Azure Blob container ID.
        """
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[_builtins.str]:
        """
        Specifies the account key (shared key) to access the storage account.
        """
        return pulumi.get(self, "account_key")

    @_builtins.property
    @pulumi.getter(name="localAuthReference")
    def local_auth_reference(self) -> Optional[_builtins.str]:
        """
        Specifies the name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        """
        return pulumi.get(self, "local_auth_reference")

    @_builtins.property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[_builtins.str]:
        """
        Specifies the shared access token to access the storage container.
        """
        return pulumi.get(self, "sas_token")

    @_builtins.property
    @pulumi.getter(name="servicePrincipal")
    def service_principal(self) -> Optional['outputs.FluxConfigurationBlobStorageServicePrincipal']:
        """
        A `service_principal` block as defined below.
        """
        return pulumi.get(self, "service_principal")

    @_builtins.property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the interval at which to re-reconcile the cluster Azure Blob source with the remote.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum time to attempt to reconcile the cluster Azure Blob source with the remote.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class FluxConfigurationBlobStorageServicePrincipal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "clientCertificateBase64":
            suggest = "client_certificate_base64"
        elif key == "clientCertificatePassword":
            suggest = "client_certificate_password"
        elif key == "clientCertificateSendChain":
            suggest = "client_certificate_send_chain"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FluxConfigurationBlobStorageServicePrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FluxConfigurationBlobStorageServicePrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FluxConfigurationBlobStorageServicePrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 tenant_id: _builtins.str,
                 client_certificate_base64: Optional[_builtins.str] = None,
                 client_certificate_password: Optional[_builtins.str] = None,
                 client_certificate_send_chain: Optional[_builtins.bool] = None,
                 client_secret: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_id: Specifies the client ID for authenticating a Service Principal.
        :param _builtins.str tenant_id: Specifies the tenant ID for authenticating a Service Principal.
        :param _builtins.str client_certificate_base64: Base64-encoded certificate used to authenticate a Service Principal .
        :param _builtins.str client_certificate_password: Specifies the password for the certificate used to authenticate a Service Principal .
        :param _builtins.bool client_certificate_send_chain: Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the client certificate.
        :param _builtins.str client_secret: Specifies the client secret for authenticating a Service Principal.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if client_certificate_base64 is not None:
            pulumi.set(__self__, "client_certificate_base64", client_certificate_base64)
        if client_certificate_password is not None:
            pulumi.set(__self__, "client_certificate_password", client_certificate_password)
        if client_certificate_send_chain is not None:
            pulumi.set(__self__, "client_certificate_send_chain", client_certificate_send_chain)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        Specifies the client ID for authenticating a Service Principal.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        Specifies the tenant ID for authenticating a Service Principal.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="clientCertificateBase64")
    def client_certificate_base64(self) -> Optional[_builtins.str]:
        """
        Base64-encoded certificate used to authenticate a Service Principal .
        """
        return pulumi.get(self, "client_certificate_base64")

    @_builtins.property
    @pulumi.getter(name="clientCertificatePassword")
    def client_certificate_password(self) -> Optional[_builtins.str]:
        """
        Specifies the password for the certificate used to authenticate a Service Principal .
        """
        return pulumi.get(self, "client_certificate_password")

    @_builtins.property
    @pulumi.getter(name="clientCertificateSendChain")
    def client_certificate_send_chain(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the client certificate.
        """
        return pulumi.get(self, "client_certificate_send_chain")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[_builtins.str]:
        """
        Specifies the client secret for authenticating a Service Principal.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class FluxConfigurationBucket(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "accessKey":
            suggest = "access_key"
        elif key == "localAuthReference":
            suggest = "local_auth_reference"
        elif key == "secretKeyBase64":
            suggest = "secret_key_base64"
        elif key == "syncIntervalInSeconds":
            suggest = "sync_interval_in_seconds"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"
        elif key == "tlsEnabled":
            suggest = "tls_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FluxConfigurationBucket. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FluxConfigurationBucket.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FluxConfigurationBucket.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 url: _builtins.str,
                 access_key: Optional[_builtins.str] = None,
                 local_auth_reference: Optional[_builtins.str] = None,
                 secret_key_base64: Optional[_builtins.str] = None,
                 sync_interval_in_seconds: Optional[_builtins.int] = None,
                 timeout_in_seconds: Optional[_builtins.int] = None,
                 tls_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str bucket_name: Specifies the bucket name to sync from the url endpoint for the flux configuration.
        :param _builtins.str url: Specifies the URL to sync for the flux configuration S3 bucket. It must start with `http://` or `https://`.
        :param _builtins.str access_key: Specifies the plaintext access key used to securely access the S3 bucket.
        :param _builtins.str local_auth_reference: Specifies the name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        :param _builtins.str secret_key_base64: Specifies the Base64-encoded secret key used to authenticate with the bucket source.
        :param _builtins.int sync_interval_in_seconds: Specifies the interval at which to re-reconcile the cluster git repository source with the remote. Defaults to `600`.
        :param _builtins.int timeout_in_seconds: Specifies the maximum time to attempt to reconcile the cluster git repository source with the remote. Defaults to `600`.
        :param _builtins.bool tls_enabled: Specify whether to communicate with a bucket using TLS is enabled. Defaults to `true`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "url", url)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if local_auth_reference is not None:
            pulumi.set(__self__, "local_auth_reference", local_auth_reference)
        if secret_key_base64 is not None:
            pulumi.set(__self__, "secret_key_base64", secret_key_base64)
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Specifies the bucket name to sync from the url endpoint for the flux configuration.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Specifies the URL to sync for the flux configuration S3 bucket. It must start with `http://` or `https://`.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        """
        Specifies the plaintext access key used to securely access the S3 bucket.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="localAuthReference")
    def local_auth_reference(self) -> Optional[_builtins.str]:
        """
        Specifies the name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
        """
        return pulumi.get(self, "local_auth_reference")

    @_builtins.property
    @pulumi.getter(name="secretKeyBase64")
    def secret_key_base64(self) -> Optional[_builtins.str]:
        """
        Specifies the Base64-encoded secret key used to authenticate with the bucket source.
        """
        return pulumi.get(self, "secret_key_base64")

    @_builtins.property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the interval at which to re-reconcile the cluster git repository source with the remote. Defaults to `600`.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum time to attempt to reconcile the cluster git repository source with the remote. Defaults to `600`.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[_builtins.bool]:
        """
        Specify whether to communicate with a bucket using TLS is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "tls_enabled")


@pulumi.output_type
class FluxConfigurationGitRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceType":
            suggest = "reference_type"
        elif key == "referenceValue":
            suggest = "reference_value"
        elif key == "httpsCaCertBase64":
            suggest = "https_ca_cert_base64"
        elif key == "httpsKeyBase64":
            suggest = "https_key_base64"
        elif key == "httpsUser":
            suggest = "https_user"
        elif key == "localAuthReference":
            suggest = "local_auth_reference"
        elif key == "sshKnownHostsBase64":
            suggest = "ssh_known_hosts_base64"
        elif key == "sshPrivateKeyBase64":
            suggest = "ssh_private_key_base64"
        elif key == "syncIntervalInSeconds":
            suggest = "sync_interval_in_seconds"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FluxConfigurationGitRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FluxConfigurationGitRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FluxConfigurationGitRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_type: _builtins.str,
                 reference_value: _builtins.str,
                 url: _builtins.str,
                 https_ca_cert_base64: Optional[_builtins.str] = None,
                 https_key_base64: Optional[_builtins.str] = None,
                 https_user: Optional[_builtins.str] = None,
                 local_auth_reference: Optional[_builtins.str] = None,
                 ssh_known_hosts_base64: Optional[_builtins.str] = None,
                 ssh_private_key_base64: Optional[_builtins.str] = None,
                 sync_interval_in_seconds: Optional[_builtins.int] = None,
                 timeout_in_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.str reference_type: Specifies the source reference type for the GitRepository object. Possible values are `branch`, `commit`, `semver` and `tag`.
        :param _builtins.str reference_value: Specifies the source reference value for the GitRepository object.
        :param _builtins.str url: Specifies the URL to sync for the flux configuration git repository. It must start with `http://`, `https://`, `git@` or `ssh://`.
        :param _builtins.str https_ca_cert_base64: Specifies the Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS.
        :param _builtins.str https_key_base64: Specifies the Base64-encoded HTTPS personal access token or password that will be used to access the repository.
        :param _builtins.str https_user: Specifies the plaintext HTTPS username used to access private git repositories over HTTPS.
        :param _builtins.str local_auth_reference: Specifies the name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets. It must be between 1 and 63 characters. It can contain only lowercase letters, numbers, and hyphens (-). It must start and end with a lowercase letter or number.
        :param _builtins.str ssh_known_hosts_base64: Specifies the Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH.
        :param _builtins.str ssh_private_key_base64: Specifies the Base64-encoded SSH private key in PEM format.
        :param _builtins.int sync_interval_in_seconds: Specifies the interval at which to re-reconcile the cluster git repository source with the remote. Defaults to `600`.
        :param _builtins.int timeout_in_seconds: Specifies the maximum time to attempt to reconcile the cluster git repository source with the remote. Defaults to `600`.
        """
        pulumi.set(__self__, "reference_type", reference_type)
        pulumi.set(__self__, "reference_value", reference_value)
        pulumi.set(__self__, "url", url)
        if https_ca_cert_base64 is not None:
            pulumi.set(__self__, "https_ca_cert_base64", https_ca_cert_base64)
        if https_key_base64 is not None:
            pulumi.set(__self__, "https_key_base64", https_key_base64)
        if https_user is not None:
            pulumi.set(__self__, "https_user", https_user)
        if local_auth_reference is not None:
            pulumi.set(__self__, "local_auth_reference", local_auth_reference)
        if ssh_known_hosts_base64 is not None:
            pulumi.set(__self__, "ssh_known_hosts_base64", ssh_known_hosts_base64)
        if ssh_private_key_base64 is not None:
            pulumi.set(__self__, "ssh_private_key_base64", ssh_private_key_base64)
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @_builtins.property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> _builtins.str:
        """
        Specifies the source reference type for the GitRepository object. Possible values are `branch`, `commit`, `semver` and `tag`.
        """
        return pulumi.get(self, "reference_type")

    @_builtins.property
    @pulumi.getter(name="referenceValue")
    def reference_value(self) -> _builtins.str:
        """
        Specifies the source reference value for the GitRepository object.
        """
        return pulumi.get(self, "reference_value")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Specifies the URL to sync for the flux configuration git repository. It must start with `http://`, `https://`, `git@` or `ssh://`.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="httpsCaCertBase64")
    def https_ca_cert_base64(self) -> Optional[_builtins.str]:
        """
        Specifies the Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS.
        """
        return pulumi.get(self, "https_ca_cert_base64")

    @_builtins.property
    @pulumi.getter(name="httpsKeyBase64")
    def https_key_base64(self) -> Optional[_builtins.str]:
        """
        Specifies the Base64-encoded HTTPS personal access token or password that will be used to access the repository.
        """
        return pulumi.get(self, "https_key_base64")

    @_builtins.property
    @pulumi.getter(name="httpsUser")
    def https_user(self) -> Optional[_builtins.str]:
        """
        Specifies the plaintext HTTPS username used to access private git repositories over HTTPS.
        """
        return pulumi.get(self, "https_user")

    @_builtins.property
    @pulumi.getter(name="localAuthReference")
    def local_auth_reference(self) -> Optional[_builtins.str]:
        """
        Specifies the name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets. It must be between 1 and 63 characters. It can contain only lowercase letters, numbers, and hyphens (-). It must start and end with a lowercase letter or number.
        """
        return pulumi.get(self, "local_auth_reference")

    @_builtins.property
    @pulumi.getter(name="sshKnownHostsBase64")
    def ssh_known_hosts_base64(self) -> Optional[_builtins.str]:
        """
        Specifies the Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH.
        """
        return pulumi.get(self, "ssh_known_hosts_base64")

    @_builtins.property
    @pulumi.getter(name="sshPrivateKeyBase64")
    def ssh_private_key_base64(self) -> Optional[_builtins.str]:
        """
        Specifies the Base64-encoded SSH private key in PEM format.
        """
        return pulumi.get(self, "ssh_private_key_base64")

    @_builtins.property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the interval at which to re-reconcile the cluster git repository source with the remote. Defaults to `600`.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum time to attempt to reconcile the cluster git repository source with the remote. Defaults to `600`.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class FluxConfigurationKustomization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOns":
            suggest = "depends_ons"
        elif key == "garbageCollectionEnabled":
            suggest = "garbage_collection_enabled"
        elif key == "recreatingEnabled":
            suggest = "recreating_enabled"
        elif key == "retryIntervalInSeconds":
            suggest = "retry_interval_in_seconds"
        elif key == "syncIntervalInSeconds":
            suggest = "sync_interval_in_seconds"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FluxConfigurationKustomization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FluxConfigurationKustomization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FluxConfigurationKustomization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 depends_ons: Optional[Sequence[_builtins.str]] = None,
                 garbage_collection_enabled: Optional[_builtins.bool] = None,
                 path: Optional[_builtins.str] = None,
                 recreating_enabled: Optional[_builtins.bool] = None,
                 retry_interval_in_seconds: Optional[_builtins.int] = None,
                 sync_interval_in_seconds: Optional[_builtins.int] = None,
                 timeout_in_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: Specifies the name of the kustomization.
        :param Sequence[_builtins.str] depends_ons: Specifies other kustomizations that this kustomization depends on. This kustomization will not reconcile until all dependencies have completed their reconciliation.
        :param _builtins.bool garbage_collection_enabled: Whether garbage collections of Kubernetes objects created by this kustomization is enabled. Defaults to `false`.
        :param _builtins.str path: Specifies the path in the source reference to reconcile on the cluster.
        :param _builtins.bool recreating_enabled: Whether re-creating Kubernetes resources on the cluster is enabled when patching fails due to an immutable field change. Defaults to `false`.
        :param _builtins.int retry_interval_in_seconds: The interval at which to re-reconcile the kustomization on the cluster in the event of failure on reconciliation. Defaults to `600`.
        :param _builtins.int sync_interval_in_seconds: The interval at which to re-reconcile the kustomization on the cluster. Defaults to `600`.
        :param _builtins.int timeout_in_seconds: The maximum time to attempt to reconcile the kustomization on the cluster. Defaults to `600`.
        """
        pulumi.set(__self__, "name", name)
        if depends_ons is not None:
            pulumi.set(__self__, "depends_ons", depends_ons)
        if garbage_collection_enabled is not None:
            pulumi.set(__self__, "garbage_collection_enabled", garbage_collection_enabled)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if recreating_enabled is not None:
            pulumi.set(__self__, "recreating_enabled", recreating_enabled)
        if retry_interval_in_seconds is not None:
            pulumi.set(__self__, "retry_interval_in_seconds", retry_interval_in_seconds)
        if sync_interval_in_seconds is not None:
            pulumi.set(__self__, "sync_interval_in_seconds", sync_interval_in_seconds)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the kustomization.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies other kustomizations that this kustomization depends on. This kustomization will not reconcile until all dependencies have completed their reconciliation.
        """
        return pulumi.get(self, "depends_ons")

    @_builtins.property
    @pulumi.getter(name="garbageCollectionEnabled")
    def garbage_collection_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether garbage collections of Kubernetes objects created by this kustomization is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "garbage_collection_enabled")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Specifies the path in the source reference to reconcile on the cluster.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="recreatingEnabled")
    def recreating_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether re-creating Kubernetes resources on the cluster is enabled when patching fails due to an immutable field change. Defaults to `false`.
        """
        return pulumi.get(self, "recreating_enabled")

    @_builtins.property
    @pulumi.getter(name="retryIntervalInSeconds")
    def retry_interval_in_seconds(self) -> Optional[_builtins.int]:
        """
        The interval at which to re-reconcile the kustomization on the cluster in the event of failure on reconciliation. Defaults to `600`.
        """
        return pulumi.get(self, "retry_interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="syncIntervalInSeconds")
    def sync_interval_in_seconds(self) -> Optional[_builtins.int]:
        """
        The interval at which to re-reconcile the kustomization on the cluster. Defaults to `600`.
        """
        return pulumi.get(self, "sync_interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[_builtins.int]:
        """
        The maximum time to attempt to reconcile the kustomization on the cluster. Defaults to `600`.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class ProvisionedClusterAzureActiveDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminGroupObjectIds":
            suggest = "admin_group_object_ids"
        elif key == "azureRbacEnabled":
            suggest = "azure_rbac_enabled"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProvisionedClusterAzureActiveDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProvisionedClusterAzureActiveDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProvisionedClusterAzureActiveDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_group_object_ids: Optional[Sequence[_builtins.str]] = None,
                 azure_rbac_enabled: Optional[_builtins.bool] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] admin_group_object_ids: A list of IDs of Microsoft Entra ID Groups. All members of the specified Microsoft Entra ID Groups have the cluster administrator access to the Kubernetes cluster.
        :param _builtins.bool azure_rbac_enabled: Whether to enable Azure RBAC for Kubernetes authorization. Defaults to `false`.
        :param _builtins.str tenant_id: The Tenant ID to use for authentication. If not specified, the Tenant of the Arc Kubernetes Cluster will be used.
        """
        if admin_group_object_ids is not None:
            pulumi.set(__self__, "admin_group_object_ids", admin_group_object_ids)
        if azure_rbac_enabled is not None:
            pulumi.set(__self__, "azure_rbac_enabled", azure_rbac_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="adminGroupObjectIds")
    def admin_group_object_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IDs of Microsoft Entra ID Groups. All members of the specified Microsoft Entra ID Groups have the cluster administrator access to the Kubernetes cluster.
        """
        return pulumi.get(self, "admin_group_object_ids")

    @_builtins.property
    @pulumi.getter(name="azureRbacEnabled")
    def azure_rbac_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable Azure RBAC for Kubernetes authorization. Defaults to `false`.
        """
        return pulumi.get(self, "azure_rbac_enabled")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID to use for authentication. If not specified, the Tenant of the Arc Kubernetes Cluster will be used.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ProvisionedClusterIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProvisionedClusterIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProvisionedClusterIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProvisionedClusterIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of the Managed Identity. The only possible value is `SystemAssigned`. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Managed Identity. The only possible value is `SystemAssigned`. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


